import os
import sys
import argparse
from string import Template

def generate_project(args):
  '''Generates the project structure.'''
  projectName = args.projectName

  DIRS = {
    'docs': Template('$project_name/docs'),
    'src': Template('$project_name/$project_name'),
    'tests': Template('$project_name/tests')
  }

  FILES = {
    'docs': Template('$project_name/docs/.gitinclude'),
    'src': Template('$project_name/$project_name/.gitinclude'),
    'tests': Template('$project_name/tests/.gitinclude'),
    'gitignore': Template('$project_name/.gitignore'),
    'ci': Template('$project_name/.travis.yml'),
    'pypirc': Template('$project_name/.pypirc'),
    'license': Template('$project_name/LICENSE'),
    'manifeset': Template('$project_name/MANIFEST.in'),
    'readme': Template('$project_name/README.rst'),
    'setup': Template('$project_name/setup.py'),
    'contributing': Template('$project_name/CONTRIBUTING'),
    'changelog': Template('$project_name/CHANGELOG.rst'),
    'authors': Template('$project_name/AUTHORS'),
    'vagrantfile': Template('$project_name/Vagrantfile'),
    'requirements': Template('$project_name/requirements.txt'),
    'berksfile': Template('$project_name/Berksfile'),
    'coveragerc': Template('$project_name/.coveragerc')
  }

  for d in DIRS:
    if not getattr(args, d, False):
      directory = DIRS[d]
      os.makedirs(directory.substitute(project_name=projectName))

  for f in FILES:
    if not getattr(args, f, False):
      fle = FILES[f]
      open(fle.substitute(project_name=projectName), 'w')

def parse_cl_args(arg_vector):
  '''Parses the command line arguments'''
  parser = argparse.ArgumentParser(description='Generates project skeleton for open source python project.')
  parser.add_argument('projectName', metavar='projectName', help='the name of the project')

  parser.add_argument('--no_docs', dest='docs', help='don\'t generate a docs directory', required=False, action='store_true')
  parser.add_argument('--no_src', dest='src', help='don\'t generate a src directory', required=False, action='store_true')
  parser.add_argument('--no_tests', dest='tests', help='don\'t generate a tests directory', required=False, action='store_true')
  parser.add_argument('--no_gitignore', dest='gitignore', help='don\'t generate .gitignore', required=False, action='store_true')
  parser.add_argument('--no_ci', dest='ci', help='don\'t generate .travis.yml', required=False, action='store_true')
  parser.add_argument('--no_pypirc', dest='pypirc', help='don\'t generate .pypirc', required=False, action='store_true')
  parser.add_argument('--no_license', dest='license', help='don\'t generate LICENSE', required=False, action='store_true')
  parser.add_argument('--no_manifest', dest='manifest', help='don\'t generate MANIFEST.in', required=False, action='store_true')
  parser.add_argument('--no_readme', dest='readme', help='don\'t generate README.rst', required=False, action='store_true')
  parser.add_argument('--no_setup', dest='setup', help='don\'t generate setup.py', required=False, action='store_true')
  parser.add_argument('--no_contributing', dest='contributing', help='don\'t generate CONTRIBUTING', required=False, action='store_true')
  parser.add_argument('--no_changelog', dest='changelog', help='don\'t generate CHANGELOG.rst', required=False, action='store_true')
  parser.add_argument('--no_authors', dest='authors', help='don\'t generate AUTHORS', required=False, action='store_true')
  parser.add_argument('--no_vagrantfile', dest='vagrantfile', help='don\'t generate Vagrantfile', required=False, action='store_true')
  parser.add_argument('--no_requirements', dest='requirements', help='don\'t generate requirements.txt', required=False, action='store_true')
  parser.add_argument('--no_berksfile', dest='berksfile', help='don\'t generate Berksfile', required=False, action='store_true')
  parser.add_argument('--no_coveragerc', dest='coveragerc', help='don\'t generate .coveragerc', required=False, action='store_true')

  return parser.parse_args(arg_vector)

def run():
  '''Generates boilerplate for opensource project.'''

  args = parse_cl_args(sys.argv[1:])
  generate_project(args)

if __name__ == '__main__':
  run()