# -*- coding: utf-8 -*-

# PyParadox is a *nix launcher for Paradox games.
# Copyright (C) 2014  Ruben Bakker <rubykuby@gmail.com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import re


class Plugin(object):
    """Represents a single plugin (DLC/mod)."""

    def __init__(self, filename):
        self.filename = filename
        self.name = self.get_name()
        self.enabled = True

    def get_name(self):
        """Extract the name of the plugin from the file."""
        with open(self.filename) as plugin_file:
            plugin_contents = plugin_file.read()

        try:
            return re.search('^name[ \t]*=[ \t]*"(.*)"', plugin_contents,
                             re.MULTILINE).group(1)
        except AttributeError:
            # TODO: Log instance of plugin name not found. Find a way to present
            #       it to user.
            return self.filename
