# -*- coding: utf-8 -*-

# PyParadox is a *nix launcher for Paradox games.
# Copyright (C) 2014  Ruben Bakker <rubykuby@gmail.com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from pyparadox.exceptions import PySideImportError
try:
    from PySide import QtCore, QtGui
    from PySide.QtCore import Signal, Slot
except ImportError:
    raise PySideImportError


class PluginListModel(QtCore.QAbstractListModel):
    """Model that holds all plugins (DLCs/mods)."""

    def __init__(self, plugins, parent=None):
        super(PluginListModel, self).__init__()
        self.plugins = plugins

    def rowCount(self, parent):
        return len(self.plugins)

    def data(self, index, role):
        """Return values for the model."""
        if role == QtCore.Qt.DisplayRole:
            return self.plugins[index.row()].name

        if role == QtCore.Qt.CheckStateRole:
            item = self.plugins[index.row()]

            if item.enabled:
                return QtCore.Qt.Checked
            else:
                return QtCore.Qt.Unchecked

    def flags(self, index):
        """Overwrites default flags to allow checking of items."""
        return QtCore.Qt.ItemIsEnabled | QtCore.Qt.ItemIsUserCheckable

    def setData(self, index, value, role):
        """Setter method for the model. Allows switching of checkstate."""
        if role == QtCore.Qt.CheckStateRole:
            item = self.plugins[index.row()]
            item.enabled = not item.enabled
            return True
        return False
