# -*- coding: utf-8 -*-

# PyParadox is a *nix launcher for Paradox games.
# Copyright (C) 2014  Ruben Bakker <rubykuby@gmail.com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import os
import shutil
import pytest
from pyparadox.Config import Config

class TestConfig(object):

    def setup_class(self):
        self.config = Config("ck2", "PyParadox", "PyParadox",
                             "/tmp/testpyparadox/pyparadox.conf")

    def teardown_class(self):
        del self.config
        shutil.rmtree("/tmp/testpyparadox")

    def test_init(self):
        assert True

    def test_game_path(self):
        self.config.game_path = "/tmp"
        assert self.config.game_path == "/tmp"

    def test_mod_path(self):
        self.config.mod_path = "/tmp"
        assert self.config.mod_path == "/tmp"

    def test_binary(self):
        self.config.binary = "eu4"
        assert self.config.binary == "eu4"

    def test_excluded_dlcs_none(self):
        self.config.excluded_dlcs = []
        assert self.config.excluded_dlcs == []

    def test_excluded_dlcs_single(self):
        self.config.excluded_dlcs = ["dlc001.dlc"]
        assert self.config.excluded_dlcs == ["dlc001.dlc"]

    def test_excluded_dlcs_multiple(self):
        self.config.excluded_dlcs = ["dlc001.dlc","dlc002.dlc"]
        assert self.config.excluded_dlcs == ["dlc001.dlc","dlc002.dlc"]

    def test_mods_none(self):
        self.config.mods = []
        assert self.config.mods == []

    def test_mods_single(self):
        self.config.mods = ["better gender law mod.mod"]
        assert self.config.mods == ["better gender law mod.mod"]

    def test_mods_multiple(self):
        self.config.mods = ["better gender law mod.mod","foo.mod"]
        assert self.config.mods == ["better gender law mod.mod","foo.mod"]

class TestTwoConfigs(object):

    def teardown_method(self, method):
        shutil.rmtree("/tmp/testpyparadox")

    def test_two_configs_same_game(self):
        config_one = Config("ck2", "PyParadox", "PyParadox",
                            "/tmp/testpyparadox/pyparadox.conf")
        config_one.binary = "eu4"
        del config_one
        config_two = Config("ck2", "PyParadox", "PyParadox",
                            "/tmp/testpyparadox/pyparadox.conf")
        assert config_two.binary == "eu4"

    def test_two_configs_different_game(self):
        config_one = Config("ck2", "PyParadox", "PyParadox",
                            "/tmp/testpyparadox/pyparadox.conf")
        config_one.binary = "foo"
        del config_one
        config_two = Config("eu4", "PyParadox", "PyParadox",
                            "/tmp/testpyparadox/pyparadox.conf")
        assert config_two.binary != "foo"
