# -*- coding: utf-8 -*-

# PyParadox is a *nix launcher for Paradox games.
# Copyright (C) 2014  Ruben Bakker <rubykuby@gmail.com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import os
import pytest
from pyparadox.command import make_command


def test_make_command():
    game_path = os.path.join(os.path.expanduser("~"),
                             ".steam",
                             "steam",
                             "SteamApps",
                             "common",
                             "Crusader Kings II")
    binary = "ck2"
    excluded_dlcs = ["dlc001.dlc"]
    mods = ["better gender law mod.mod"]
    assert make_command(game_path, binary, excluded_dlcs, mods) == \
        [
            os.path.join(os.path.expanduser("~"),
                         ".steam",
                         "steam",
                         "SteamApps",
                         "common",
                         "Crusader Kings II",
                         "ck2"),
            "-skiplauncher",
            "-exclude_dlc={}".format(os.path.join("dlc", "dlc001.dlc")),
            "-mod={}".format(os.path.join("mod", "better gender law mod.mod"))
        ]

def test_make_command_no_plugins():
    game_path = os.path.join(os.path.expanduser("~"),
                             ".steam",
                             "steam",
                             "SteamApps",
                             "common",
                             "Crusader Kings II")
    binary = "ck2"
    excluded_dlcs = []
    mods = []
    assert make_command(game_path, binary, excluded_dlcs, mods) == \
        [
            os.path.join(os.path.expanduser("~"),
                         ".steam",
                         "steam",
                         "SteamApps",
                         "common",
                         "Crusader Kings II",
                         "ck2"),
            "-skiplauncher"
        ]
