#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# PyParadox is a *nix launcher for Paradox games.
# Copyright (C) 2014  Ruben Bakker <rubykuby@gmail.com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import sys
import pyparadox
from pyparadox.exceptions import PySideImportError
from pyparadox.gui.MainWindow import MainWindow
try:
    from PySide import QtCore, QtGui
    from PySide.QtCore import Signal, Slot
except ImportError:
    raise PySideImportError


def main(game):
    app = QtGui.QApplication(sys.argv)
    app.setApplicationVersion(pyparadox.__version__)
    app.setApplicationName(app.tr("PyParadox"))

    form = MainWindow(game)
    form.show()

    app.exec_()
