#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os
import sys

from setuptools import setup
from setuptools.command.test import test as TestCommand


class Tox(TestCommand):
    def finalize_options(self):
        TestCommand.finalize_options(self)
        self.test_args = []
        self.test_suite = True
    def run_tests(self):
        # Import here; not allowed in setup.py global scope.
        import tox
        errno = tox.cmdline(self.test_args)
        sys.exit(errno)

readme = open('README.rst').read()
history = open('HISTORY.rst').read().replace('.. :changelog:', '')

requirements = [
    'appdirs',
]

test_requirements = [
    'pytest',
    'tox',
]

setup(
    name='pyparadox',
    version='0.0.1',
    description='PyParadox is a *nix launcher for Paradox games',
    long_description=readme + '\n\n' + history,
    author='Ruben Bakker',
    author_email='rubykuby@gmail.com',
    url='https://github.com/Rubykuby/pyparadox',
    packages=[
        'pyparadox',
        'pyparadox.gui',
    ],
    #package_dir={'pyparadox':
                 #'pyparadox'},
    include_package_data=True,
    install_requires=requirements,
    dependency_links=[
        'https://download.qt-project.org/official_releases/pyside/'
    ],
    license="GPLv3+",
    zip_safe=False,
    keywords='pyparadox',
    classifiers=[
        'Development Status :: 2 - Pre-Alpha',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: GNU General Public License v3 or later (GPLv3+)',
        'Natural Language :: English',
        "Programming Language :: Python :: 2",
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.4',
    ],
    test_suite='tests',
    tests_require=test_requirements,
    cmdclass = {'test':Tox},
    scripts=[
        'pyparadox-eu4',
        'pyparadox-ck2',
    ]
)
