# -*- coding: utf-8 -*-

# PyParadox is a *nix launcher for Paradox games.
# Copyright (C) 2014  Ruben Bakker <rubykuby@gmail.com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import os
import pytest
from pyparadox.finder import find_dlcs, find_mods


def test_find_dlcs():
    dlc_dir = os.path.join(os.path.dirname(__file__), "dlc")
    dlcs = [dlc.name for dlc in find_dlcs(dlc_dir)]
    assert dlcs[0] == "Dynasty Coat of Arms Pack 1"

def test_find_mods():
    mod_dir = os.path.join(os.path.dirname(__file__), "mod")
    mods = [mod.name for mod in find_mods(mod_dir)]
    assert mods[0] == "Better gender law mod"
