# -*- coding: utf-8 -*-

# PyParadox is a *nix launcher for Paradox games.
# Copyright (C) 2014  Ruben Bakker <rubykuby@gmail.com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from abc import ABCMeta
import re
from .exceptions import NameNotFoundError


class Plugin(object):
    """Represents a single plugin (DLC/mod)."""

    __metaclass__ = ABCMeta

    def __init__(self, filename, name, enabled=True):
        self.filename = filename
        self.name = name
        self.enabled = enabled

    @staticmethod
    def get_plugin_name(fileobj):
        try:
            return re.search('^name[ \t]*=[ \t]*"(.*)"', fileobj.read(),
                             re.MULTILINE).group(1)
        except AttributeError:
            # TODO: Log instance of plugin name not found. Find a way to
            #       present it to user.
            raise NameNotFoundError()
