#!/usr/bin/env python
# -*- coding: utf-8 -*-

# PyParadox is a *nix launcher for Paradox games.
# Copyright (C) 2014  Ruben Bakker <rubykuby@gmail.com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import sys
from . import __version__
from .exceptions import PySideImportError
from .Config import Config
from .gui.MainWindow import MainWindow
try:
    from PySide import QtGui
except ImportError:
    raise PySideImportError


def pyparadox_eu4():
    main("eu4")


def pyparadox_ck2():
    main("ck2")


def main(game):
    app = QtGui.QApplication(sys.argv)
    app.setApplicationVersion(__version__)
    app.setApplicationName(app.tr("PyParadox"))
    app.setOrganizationName(app.tr("PyParadox"))
    app.process = None

    config = Config(game, app.applicationName(), app.organizationName())

    form = MainWindow(game, config)
    form.show()

    app.exec_()

    if app.process is not None:
        process = app.process
        app.exit()
        process.wait()
    sys.exit()
