#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os
import sys
try:
    from setuptools import setup
except ImportError:
    from distutils.core import setup


readme = open('README.rst').read()
history = open('HISTORY.rst').read().replace('.. :changelog:', '')

requirements = [
    'appdirs'
]

test_requirements = [
]

# Copied from (and hacked):
# https://github.com/pypa/virtualenv/blob/develop/setup.py#L42
def get_version(filename):
    import re

    here = os.path.dirname(__file__)
    with open(os.path.join(here, filename)) as f:
        version_file = f.read()
    version_match = re.search(r"^__version__ = ['\"]([^'\"]*)['\"]",
                              version_file, re.M)
    if version_match:
        return version_match.group(1)
    raise RuntimeError("Unable to find version string.")

setup(
    name='pyparadox',
    version=get_version(os.path.join("pyparadox", "__init__.py")),
    description='PyParadox is a *nix launcher for Paradox games.',
    long_description=readme + '\n\n' + history,
    author='Ruben Bakker',
    author_email='rubykuby@gmail.com',
    url='https://github.com/Rubykuby/pyparadox',
    packages=[
        'pyparadox',
        'pyparadox.gui'
    ],
    package_dir={'pyparadox': 'pyparadox'},
    entry_points={
        'gui_scripts': [
            'pyparadox-eu4 = pyparadox.main:pyparadox_eu4',
            'pyparadox-ck2 = pyparadox.main:pyparadox_ck2'
        ]
    },
    include_package_data=True,
    install_requires=requirements,
    dependency_links=[
        'https://download.qt-project.org/official_releases/pyside/'
    ],
    license="GPLv3+",
    zip_safe=False,
    keywords='pyparadox',
    classifiers=[
        'Development Status :: 2 - Pre-Alpha',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: GNU General Public License v3 or later (GPLv3+)',
        'Natural Language :: English',
        "Programming Language :: Python :: 2",
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.4',
    ],
    test_suite='tests',
    tests_require=test_requirements,
)
