# -*- coding: utf-8 -*-

# PyParadox is a *nix launcher for Paradox games.
# Copyright (C) 2014  Ruben Bakker <rubykuby@gmail.com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import unittest
try:
    from unittest import mock
except ImportError:
    import mock
from pyparadox.find import find_dlcs, find_mods


class TestFindDlcs(unittest.TestCase):

    @mock.patch("pyparadox.find.os.path.join", autospec=True)
    @mock.patch("pyparadox.find.glob.glob", autospec=True)
    def test_find_dlcs(self, mock_glob, mock_join):
        # Mock list of "found" files.
        mock_glob.return_value = ["dlc_file0.dlc", "dlc_file1.dlc"]

        for i, dlc in enumerate(find_dlcs("path")):
            self.assertEqual(dlc, mock_glob.return_value[i],
                             "File names are returned")

        # No files found.
        mock_glob.return_value = []

        self.assertFalse(find_dlcs("path"), "No files are found")


class TestFindMods(unittest.TestCase):

    @mock.patch("pyparadox.find.os.path.join", autospec=True)
    @mock.patch("pyparadox.find.glob.glob", autospec=True)
    def test_find_mods(self, mock_glob, mock_join):
        # Mock list of "found" files.
        mock_glob.return_value = ["mod_file0.mod", "mod_file1.mod"]

        for i, mod in enumerate(find_mods("path")):
            self.assertEqual(mod, mock_glob.return_value[i],
                             "File names are returned")

        # No files found.
        mock_glob.return_value = []

        self.assertFalse(find_mods("path"), "No files are found")
