# -*- coding: utf-8 -*-

# PyParadox is a *nix launcher for Paradox games.
# Copyright (C) 2014  Ruben Bakker <rubykuby@gmail.com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

"""All exceptions used in the PyParadox code base are defined here."""


class PyParadoxException(Exception):
    """Base exception class.  All PyParadox-specific exceptions should inherit
    from this class.
    """


class QtImportError(PyParadoxException):
    """Could not import PySide/PyQt4."""


class GameNotExistError(PyParadoxException):
    """String identifier for game is not valid."""


class NameNotFoundError(PyParadoxException):
    """Name not found in plugin file."""
