# -*- coding: utf-8 -*-

# PyParadox is a *nix launcher for Paradox games.
# Copyright (C) 2014  Ruben Bakker <rubykuby@gmail.com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import os
import glob


def find_dlcs(dlc_path):
    """Return a list of all ".dlc" files in ``dlc_path``.

    :param dlc_path: Absolute path of directory that needs to be searched.
    :type dlc_path: str.
    :returns: List of found DLCs.
    :rtype: list.
    """
    return glob.glob(os.path.join(dlc_path, "*.dlc"))


def find_mods(mod_path):
    """Return a list of all ".mod" files in ``mod_path``.

    :param mod_path: Absolute path of directory that needs to be searched.
    :type mod_path: str.
    :returns: List of found mods.
    :rtype: list.
    """
    return glob.glob(os.path.join(mod_path, "*.mod"))
