"""
Declares a @builtin decorator class for tagging php built-in functions, as well as implements and exports most if not all php built-in functions.
"""

import sys
import scope
from errors import ExecuteError

class builtin(object):
	"Class for tagging built in functions"
	def __init__(self, func):
		self.func = func
	def __call__(self, *args, **kw):
		self.func(*args, **kw)
	def __repr__(self):
		return "<php-builtin-function %r>"%self.func.__name__



@builtin
def isset(args, executer, local_dict):
	try:
		executer.SUPRESS_OUTPUT+=1
		for a in args:
			executer.get_val(a)
		executer.SUPRESS_OUTPUT-=1
		return True
	except:
		return False


def include_impl(args, executer, local_dict, require=False, once=False):
	# print "include impl : args:%r, executer:%r, local_dict:%r, require:%r, once:%r"%(args, executer, local_dict, require, once)
	lf_key='~!loaded_files'
	path = executer.get_val(args[0])
	if lf_key not in executer.globals:
		# print " --> Creating executer.globals[%r]"%lf_key
		executer.globals[lf_key] = {}
	
	if once and path in executer.globals[lf_key]:
		# print " -once-> file is already included"
		pass
	else:
		import os.path
		if os.path.exists(path):
			# print " --> including file %r"%path
			import compiler
			executer.globals[lf_key][path] = True
			file_data = None
			with file(path, 'r') as finp:
				file_data = finp.read()
			executer.visit(compiler.compile_php(file_data), local_dict)
		elif require:
			raise ExecuteError("required file %s not found!"%path)
	

@builtin
def require_once(args, executer, local_dict):
	include_impl(args, executer, local_dict, True, True)
@builtin
def require(args, executer, local_dict):
	include_impl(args, executer, local_dict, True, False)
@builtin
def include_once(args, executer, local_dict):
	include_impl(args, executer, local_dict, False, True)
@builtin
def include(args, executer, local_dict):
	include_impl(args, executer, local_dict, False, False)

def var_dump_impl(x, depth=0):
	import phparray
	dstr = "  "*depth
	t = type(x)
	if x is None:
		print "%sNULL"%dstr
	elif t in (int, long):
		print "%sint(%d)"%(dstr, x)
	elif t == str:
		print "%sstring(%d) %r"%(dstr, len(x), x)
	elif isinstance(x, phparray.PHPArray):
		print "%sarray(%d) {"%(dstr, len(x))
		for y in x:
			print "%s  [%r]=>"%(dstr, y)
			var_dump_impl(x[y], depth + 1)
		print "%s}"%dstr
		
		
@builtin
def var_dump(args, executer, local):
	args = [executer.get_val(a) for a in args]
	for arg in args:
		var_dump_impl(arg)

@builtin
def ini_set(args, executer, local):
	pass

@builtin
def error_reporting(args, executer, local):
	if len(args) > 0:
		executer.ERROR_REPORTING = executer.get_val(args[0])
	return executer.ERROR_REPORTING

PHP_CONSTANTS={
	# error reporting constants
	'E_ERROR'             : 0x0001,  # (integer) 	Fatal run-time errors. These indicate errors that can not be recovered from, such as a memory allocation problem. Execution of the script is halted. 	 
	'E_WARNING'           : 0x0002,  # (integer) 	Run-time warnings (non-fatal errors). Execution of the script is not halted. 	 
	'E_PARSE'             : 0x0004,  # (integer) 	Compile-time parse errors. Parse errors should only be generated by the parser. 	 
	'E_NOTICE'            : 0x0008,  # (integer) 	Run-time notices. Indicate that the script encountered something that could indicate an error, but could also happen in the normal course of running a script. 	 
	'E_CORE_ERROR'        : 0x0010,  # (integer) 	Fatal errors that occur during PHP's initial startup. This is like an E_ERROR, except it is generated by the core of PHP. 	 
	'E_CORE_WARNING'      : 0x0020,  # (integer) 	Warnings (non-fatal errors) that occur during PHP's initial startup. This is like an E_WARNING, except it is generated by the core of PHP. 	 
	'E_COMPILE_ERROR'     : 0x0040,  # (integer) 	Fatal compile-time errors. This is like an E_ERROR, except it is generated by the Zend Scripting Engine. 	 
	'E_COMPILE_WARNING'   : 0x0080,  # (integer) 	Compile-time warnings (non-fatal errors). This is like an E_WARNING, except it is generated by the Zend Scripting Engine. 	 
	'E_USER_ERROR'        : 0x0100,  # (integer) 	User-generated error message. This is like an E_ERROR, except it is generated in PHP code by using the PHP function trigger_error(). 	 
	'E_USER_WARNING'      : 0x0200,  # (integer) 	User-generated warning message. This is like an E_WARNING, except it is generated in PHP code by using the PHP function trigger_error(). 	 
	'E_USER_NOTICE'       : 0x0400,  # (integer) 	User-generated notice message. This is like an E_NOTICE, except it is generated in PHP code by using the PHP function trigger_error(). 	 
	'E_STRICT'            : 0x0800,  # (integer) 	Enable to have PHP suggest changes to your code which will ensure the best interoperability and forward compatibility of your code. 	Since PHP 5 but not included in E_ALL until PHP 5.4.0
	'E_RECOVERABLE_ERROR' : 0x1000,  # (integer) 	Catchable fatal error. It indicates that a probably dangerous error occurred, but did not leave the Engine in an unstable state. If the error is not caught by a user defined handle (see also set_error_handler()), the application aborts as it was an E_ERROR. 	Since PHP 5.2.0
	'E_DEPRECATED'        : 0x2000,  # (integer) 	Run-time notices. Enable this to receive warnings about code that will not work in future versions. 	Since PHP 5.3.0
	'E_USER_DEPRECATED'   : 0x4000,  # (integer) 	User-generated warning message. This is like an E_DEPRECATED, except it is generated in PHP code by using the PHP function trigger_error(). 	Since PHP 5.3.0
	'E_ALL'               : 0x7fff,  # (integer) 	All errors and warnings, as supported, except of level E_STRICT prior to PHP 5.4.0.
	'true'  : True,
	'false' : False,
	'null'  : None
}




builtins = scope.scope(
	dict((a, z) for a,z in ((x,getattr(y, x)) for x in dir() for y in [sys.modules[__name__]]) if isinstance(z, builtin)),
	PHP_CONSTANTS,
	name='phpbuiltins'
)
