#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals

"""
拼音库，抓取自汉典网(zdic.net)。包含下列范围的 Unicode 字符：

CJK基本:[4E00-9FFF]       CJK扩展A:[3400-4DBF]
CJK扩展B:[20000-2A6DF]    CJK扩展C:[2A700-2B73F]
CJK扩展D:[2B740-2B81D]    CJK兼容扩展:[2F800-2FA1F]
CJK部首扩展:[2E80-2EFF]    CJK笔画:[31C0-31EF]
CJK康熙部首:[2F00-2FDF]    CJK兼容:[F900-FAFF]

注释掉了没有拼音的字符。
"""

# Unicode 编码作为字典的 key
pinyin_dict = {
    # CJK 部首扩展:[2E80-2EFF]
    # 0x2E80: '',  # ⺀
    # 0x2E81: '',  # ⺁
    # 0x2E82: '',  # ⺂
    # 0x2E83: '',  # ⺃
    # 0x2E84: '',  # ⺄
    # 0x2E85: '',  # ⺅
    # 0x2E86: '',  # ⺆
    # 0x2E87: '',  # ⺇
    # 0x2E88: '',  # ⺈
    # 0x2E89: '',  # ⺉
    # 0x2E8A: '',  # ⺊
    # 0x2E8B: '',  # ⺋
    # 0x2E8C: '',  # ⺌
    # 0x2E8D: '',  # ⺍
    # 0x2E8E: '',  # ⺎
    # 0x2E8F: '',  # ⺏
    # 0x2E90: '',  # ⺐
    # 0x2E91: '',  # ⺑
    # 0x2E92: '',  # ⺒
    # 0x2E93: '',  # ⺓
    # 0x2E94: '',  # ⺔
    # 0x2E95: '',  # ⺕
    # 0x2E96: '',  # ⺖
    # 0x2E97: '',  # ⺗
    # 0x2E98: '',  # ⺘
    # 0x2E99: '',  # ⺙
    # 0x2E9A: '',  # ⺚
    # 0x2E9B: '',  # ⺛
    # 0x2E9C: '',  # ⺜
    # 0x2E9D: '',  # ⺝
    # 0x2E9E: '',  # ⺞
    # 0x2E9F: '',  # ⺟
    # 0x2EA0: '',  # ⺠
    # 0x2EA1: '',  # ⺡
    # 0x2EA2: '',  # ⺢
    # 0x2EA3: '',  # ⺣
    # 0x2EA4: '',  # ⺤
    # 0x2EA5: '',  # ⺥
    # 0x2EA6: '',  # ⺦
    # 0x2EA7: '',  # ⺧
    # 0x2EA8: '',  # ⺨
    # 0x2EA9: '',  # ⺩
    # 0x2EAA: '',  # ⺪
    # 0x2EAB: '',  # ⺫
    # 0x2EAC: '',  # ⺬
    # 0x2EAD: '',  # ⺭
    # 0x2EAE: '',  # ⺮
    # 0x2EAF: '',  # ⺯
    # 0x2EB0: '',  # ⺰
    # 0x2EB1: '',  # ⺱
    # 0x2EB2: '',  # ⺲
    # 0x2EB3: '',  # ⺳
    # 0x2EB4: '',  # ⺴
    # 0x2EB5: '',  # ⺵
    # 0x2EB6: '',  # ⺶
    # 0x2EB7: '',  # ⺷
    # 0x2EB8: '',  # ⺸
    # 0x2EB9: '',  # ⺹
    # 0x2EBA: '',  # ⺺
    # 0x2EBB: '',  # ⺻
    # 0x2EBC: '',  # ⺼
    # 0x2EBD: '',  # ⺽
    # 0x2EBE: '',  # ⺾
    # 0x2EBF: '',  # ⺿
    # 0x2EC0: '',  # ⻀
    # 0x2EC1: '',  # ⻁
    # 0x2EC2: '',  # ⻂
    # 0x2EC3: '',  # ⻃
    # 0x2EC4: '',  # ⻄
    # 0x2EC5: '',  # ⻅
    # 0x2EC6: '',  # ⻆
    # 0x2EC7: '',  # ⻇
    # 0x2EC8: '',  # ⻈
    # 0x2EC9: '',  # ⻉
    # 0x2ECA: '',  # ⻊
    # 0x2ECB: '',  # ⻋
    # 0x2ECC: '',  # ⻌
    # 0x2ECD: '',  # ⻍
    # 0x2ECE: '',  # ⻎
    # 0x2ECF: '',  # ⻏
    # 0x2ED0: '',  # ⻐
    # 0x2ED1: '',  # ⻑
    # 0x2ED2: '',  # ⻒
    # 0x2ED3: '',  # ⻓
    # 0x2ED4: '',  # ⻔
    # 0x2ED5: '',  # ⻕
    # 0x2ED6: '',  # ⻖
    # 0x2ED7: '',  # ⻗
    # 0x2ED8: '',  # ⻘
    # 0x2ED9: '',  # ⻙
    # 0x2EDA: '',  # ⻚
    # 0x2EDB: '',  # ⻛
    # 0x2EDC: '',  # ⻜
    # 0x2EDD: '',  # ⻝
    # 0x2EDE: '',  # ⻞
    # 0x2EDF: '',  # ⻟
    # 0x2EE0: '',  # ⻠
    # 0x2EE1: '',  # ⻡
    # 0x2EE2: '',  # ⻢
    # 0x2EE3: '',  # ⻣
    # 0x2EE4: '',  # ⻤
    # 0x2EE5: '',  # ⻥
    # 0x2EE6: '',  # ⻦
    # 0x2EE7: '',  # ⻧
    # 0x2EE8: '',  # ⻨
    # 0x2EE9: '',  # ⻩
    # 0x2EEA: '',  # ⻪
    # 0x2EEB: '',  # ⻫
    # 0x2EEC: '',  # ⻬
    # 0x2EED: '',  # ⻭
    # 0x2EEE: '',  # ⻮
    # 0x2EEF: '',  # ⻯
    # 0x2EF0: '',  # ⻰
    # 0x2EF1: '',  # ⻱
    # 0x2EF2: '',  # ⻲
    # 0x2EF3: '',  # ⻳
    # 0x2EF4: '',  #
    # 0x2EF5: '',  #
    # 0x2EF6: '',  #
    # 0x2EF7: '',  #
    # 0x2EF8: '',  #
    # 0x2EF9: '',  #
    # 0x2EFA: '',  #
    # 0x2EFB: '',  #
    # 0x2EFC: '',  #
    # 0x2EFD: '',  #
    # 0x2EFE: '',  #
    # 0x2EFF: '',  #

    # CJK 康熙部首:[2F00-2FDF]
    # 0x2F00: '',  # ⼀
    # 0x2F01: '',  # ⼁
    # 0x2F02: '',  # ⼂
    # 0x2F03: '',  # ⼃
    # 0x2F04: '',  # ⼄
    # 0x2F05: '',  # ⼅
    # 0x2F06: '',  # ⼆
    # 0x2F07: '',  # ⼇
    # 0x2F08: '',  # ⼈
    # 0x2F09: '',  # ⼉
    # 0x2F0A: '',  # ⼊
    # 0x2F0B: '',  # ⼋
    # 0x2F0C: '',  # ⼌
    # 0x2F0D: '',  # ⼍
    # 0x2F0E: '',  # ⼎
    # 0x2F0F: '',  # ⼏
    # 0x2F10: '',  # ⼐
    # 0x2F11: '',  # ⼑
    # 0x2F12: '',  # ⼒
    # 0x2F13: '',  # ⼓
    # 0x2F14: '',  # ⼔
    # 0x2F15: '',  # ⼕
    # 0x2F16: '',  # ⼖
    # 0x2F17: '',  # ⼗
    # 0x2F18: '',  # ⼘
    # 0x2F19: '',  # ⼙
    # 0x2F1A: '',  # ⼚
    # 0x2F1B: '',  # ⼛
    # 0x2F1C: '',  # ⼜
    # 0x2F1D: '',  # ⼝
    # 0x2F1E: '',  # ⼞
    # 0x2F1F: '',  # ⼟
    # 0x2F20: '',  # ⼠
    # 0x2F21: '',  # ⼡
    # 0x2F22: '',  # ⼢
    # 0x2F23: '',  # ⼣
    # 0x2F24: '',  # ⼤
    # 0x2F25: '',  # ⼥
    # 0x2F26: '',  # ⼦
    # 0x2F27: '',  # ⼧
    # 0x2F28: '',  # ⼨
    # 0x2F29: '',  # ⼩
    # 0x2F2A: '',  # ⼪
    # 0x2F2B: '',  # ⼫
    # 0x2F2C: '',  # ⼬
    # 0x2F2D: '',  # ⼭
    # 0x2F2E: '',  # ⼮
    # 0x2F2F: '',  # ⼯
    # 0x2F30: '',  # ⼰
    # 0x2F31: '',  # ⼱
    # 0x2F32: '',  # ⼲
    # 0x2F33: '',  # ⼳
    # 0x2F34: '',  # ⼴
    # 0x2F35: '',  # ⼵
    # 0x2F36: '',  # ⼶
    # 0x2F37: '',  # ⼷
    # 0x2F38: '',  # ⼸
    # 0x2F39: '',  # ⼹
    # 0x2F3A: '',  # ⼺
    # 0x2F3B: '',  # ⼻
    # 0x2F3C: '',  # ⼼
    # 0x2F3D: '',  # ⼽
    # 0x2F3E: '',  # ⼾
    # 0x2F3F: '',  # ⼿
    # 0x2F40: '',  # ⽀
    # 0x2F41: '',  # ⽁
    # 0x2F42: '',  # ⽂
    # 0x2F43: '',  # ⽃
    # 0x2F44: '',  # ⽄
    # 0x2F45: '',  # ⽅
    # 0x2F46: '',  # ⽆
    # 0x2F47: '',  # ⽇
    # 0x2F48: '',  # ⽈
    # 0x2F49: '',  # ⽉
    # 0x2F4A: '',  # ⽊
    # 0x2F4B: '',  # ⽋
    # 0x2F4C: '',  # ⽌
    # 0x2F4D: '',  # ⽍
    # 0x2F4E: '',  # ⽎
    # 0x2F4F: '',  # ⽏
    # 0x2F50: '',  # ⽐
    # 0x2F51: '',  # ⽑
    # 0x2F52: '',  # ⽒
    # 0x2F53: '',  # ⽓
    # 0x2F54: '',  # ⽔
    # 0x2F55: '',  # ⽕
    # 0x2F56: '',  # ⽖
    # 0x2F57: '',  # ⽗
    # 0x2F58: '',  # ⽘
    # 0x2F59: '',  # ⽙
    # 0x2F5A: '',  # ⽚
    # 0x2F5B: '',  # ⽛
    # 0x2F5C: '',  # ⽜
    # 0x2F5D: '',  # ⽝
    # 0x2F5E: '',  # ⽞
    # 0x2F5F: '',  # ⽟
    # 0x2F60: '',  # ⽠
    # 0x2F61: '',  # ⽡
    # 0x2F62: '',  # ⽢
    # 0x2F63: '',  # ⽣
    # 0x2F64: '',  # ⽤
    # 0x2F65: '',  # ⽥
    # 0x2F66: '',  # ⽦
    # 0x2F67: '',  # ⽧
    # 0x2F68: '',  # ⽨
    # 0x2F69: '',  # ⽩
    # 0x2F6A: '',  # ⽪
    # 0x2F6B: '',  # ⽫
    # 0x2F6C: '',  # ⽬
    # 0x2F6D: '',  # ⽭
    # 0x2F6E: '',  # ⽮
    # 0x2F6F: '',  # ⽯
    # 0x2F70: '',  # ⽰
    # 0x2F71: '',  # ⽱
    # 0x2F72: '',  # ⽲
    # 0x2F73: '',  # ⽳
    # 0x2F74: '',  # ⽴
    # 0x2F75: '',  # ⽵
    # 0x2F76: '',  # ⽶
    # 0x2F77: '',  # ⽷
    # 0x2F78: '',  # ⽸
    # 0x2F79: '',  # ⽹
    # 0x2F7A: '',  # ⽺
    # 0x2F7B: '',  # ⽻
    # 0x2F7C: '',  # ⽼
    # 0x2F7D: '',  # ⽽
    # 0x2F7E: '',  # ⽾
    # 0x2F7F: '',  # ⽿
    # 0x2F800: '',  # 丽
    # 0x2F810: '',  # 兤
    # 0x2F820: '',  # 刻
    # 0x2F830: '',  # 卽
    # 0x2F840: '',  # 咢
    # 0x2F850: '',  # 切
    # 0x2F860: '',  # 𡚨
    # 0x2F870: '',  # 寳
    # 0x2F880: '',  # 嵼
    # 0x2F890: '',  # 廾
    # 0x2F8A0: '',  # 悁
    # 0x2F8B0: '',  # 懲
    # 0x2F8C0: '',  # 揅
    # 0x2F8D0: '',  # 㬈
    # 0x2F8E0: '',  # 枅
    # 0x2F8F0: '',  # 𣢧
    # 0x2F900: '',  # 派
    # 0x2F910: '',  # 𣽞
    # 0x2F920: '',  # 爨
    # 0x2F930: '',  # 瑱
    # 0x2F940: '',  # 直
    # 0x2F950: '',  # 磌
    # 0x2F960: '',  # 䈂
    # 0x2F970: '',  # 繅
    # 0x2F980: '',  # 𣍟
    # 0x2F990: '',  # 芋
    # 0x2F9A0: '',  # 荓
    # 0x2F9B0: '',  # 𦾱
    # 0x2F9C0: '',  # 蟡
    # 0x2F9D0: '',  # 諭
    # 0x2F9E0: '',  # 𨗒
    # 0x2F9F0: '',  # 閷
    # 0x2FA00: '',  # 頩
    # 0x2FA10: '',  # 𪃎
    # 0x2FA2: '',  # ⾢
    # 0x2FA3: '',  # ⾣
    # 0x2FA4: '',  # ⾤
    # 0x2FA5: '',  # ⾥
    # 0x2FA6: '',  # ⾦
    # 0x2FA7: '',  # ⾧
    # 0x2FA8: '',  # ⾨
    # 0x2FA9: '',  # ⾩
    # 0x2FAA: '',  # ⾪
    # 0x2FAB: '',  # ⾫
    # 0x2FAC: '',  # ⾬
    # 0x2FAD: '',  # ⾭
    # 0x2FAE: '',  # ⾮
    # 0x2FAF: '',  # ⾯
    # 0x2FB0: '',  # ⾰
    # 0x2FB1: '',  # ⾱
    # 0x2FB2: '',  # ⾲
    # 0x2FB3: '',  # ⾳
    # 0x2FB4: '',  # ⾴
    # 0x2FB5: '',  # ⾵
    # 0x2FB6: '',  # ⾶
    # 0x2FB7: '',  # ⾷
    # 0x2FB8: '',  # ⾸
    # 0x2FB9: '',  # ⾹
    # 0x2FBA: '',  # ⾺
    # 0x2FBB: '',  # ⾻
    # 0x2FBC: '',  # ⾼
    # 0x2FBD: '',  # ⾽
    # 0x2FBE: '',  # ⾾
    # 0x2FBF: '',  # ⾿
    # 0x2FC0: '',  # ⿀
    # 0x2FC1: '',  # ⿁
    # 0x2FC2: '',  # ⿂
    # 0x2FC3: '',  # ⿃
    # 0x2FC4: '',  # ⿄
    # 0x2FC5: '',  # ⿅
    # 0x2FC6: '',  # ⿆
    # 0x2FC7: '',  # ⿇
    # 0x2FC8: '',  # ⿈
    # 0x2FC9: '',  # ⿉
    # 0x2FCA: '',  # ⿊
    # 0x2FCB: '',  # ⿋
    # 0x2FCC: '',  # ⿌
    # 0x2FCD: '',  # ⿍
    # 0x2FCE: '',  # ⿎
    # 0x2FCF: '',  # ⿏
    # 0x2FD0: '',  # ⿐
    # 0x2FD1: '',  # ⿑
    # 0x2FD2: '',  # ⿒
    # 0x2FD3: '',  # ⿓
    # 0x2FD4: '',  # ⿔
    # 0x2FD5: '',  # ⿕
    # 0x2FD6: '',  #
    # 0x2FD7: '',  #
    # 0x2FD8: '',  #
    # 0x2FD9: '',  #
    # 0x2FDA: '',  #
    # 0x2FDB: '',  #
    # 0x2FDC: '',  #
    # 0x2FDD: '',  #
    # 0x2FDE: '',  #
    # 0x2FDF: '',  #

    # CJK 笔画:[31C0-31EF]
    # 0x31C0: '',  # ㇀
    # 0x31C1: '',  # ㇁
    # 0x31C2: '',  # ㇂
    # 0x31C3: '',  # ㇃
    # 0x31C4: '',  # ㇄
    # 0x31C5: '',  # ㇅
    # 0x31C6: '',  # ㇆
    # 0x31C7: '',  # ㇇
    # 0x31C8: '',  # ㇈
    # 0x31C9: '',  # ㇉
    # 0x31CA: '',  # ㇊
    # 0x31CB: '',  # ㇋
    # 0x31CC: '',  # ㇌
    # 0x31CD: '',  # ㇍
    # 0x31CE: '',  # ㇎
    # 0x31CF: '',  # ㇏
    # 0x31D0: '',  # ㇐
    # 0x31D1: '',  # ㇑
    # 0x31D2: '',  # ㇒
    # 0x31D3: '',  # ㇓
    # 0x31D4: '',  # ㇔
    # 0x31D5: '',  # ㇕
    # 0x31D6: '',  # ㇖
    # 0x31D7: '',  # ㇗
    # 0x31D8: '',  # ㇘
    # 0x31D9: '',  # ㇙
    # 0x31DA: '',  # ㇚
    # 0x31DB: '',  # ㇛
    # 0x31DC: '',  # ㇜
    # 0x31DD: '',  # ㇝
    # 0x31DE: '',  # ㇞
    # 0x31DF: '',  # ㇟
    # 0x31E0: '',  # ㇠
    # 0x31E1: '',  # ㇡
    # 0x31E2: '',  # ㇢
    # 0x31E3: '',  # ㇣
    # 0x31E4: '',  #
    # 0x31E5: '',  #
    # 0x31E6: '',  #
    # 0x31E7: '',  #
    # 0x31E8: '',  #
    # 0x31E9: '',  #
    # 0x31EA: '',  #
    # 0x31EB: '',  #
    # 0x31EC: '',  #
    # 0x31ED: '',  #
    # 0x31EE: '',  #
    # 0x31EF: '',  #

    # CJK 扩展 A:[3400-4DBF]
    0x3400: 'qiū',  # 㐀
    0x3401: 'tiǎn,tiàn',  # 㐁
    0x3402: 'xǐ',  # 㐂
    # 0x3403: '',  # 㐃
    # 0x3404: '',  # 㐄
    0x3405: 'wǔ',  # 㐅
    0x3406: 'yǐn,yī',  # 㐆
    0x3407: 'jiǔ',  # 㐇
    0x3408: 'rù',  # 㐈
    0x3409: 'dīng',  # 㐉
    0x340A: 'shì',  # 㐊
    0x340B: 'tǔ',  # 㐋
    0x340C: 'sì,yí',  # 㐌
    0x340D: 'zhǎo',  # 㐍
    0x340E: 'wén',  # 㐎
    0x340F: 'wǔ',  # 㐏
    0x3410: 'nú',  # 㐐
    0x3411: 'dōng',  # 㐑
    0x3412: 'zhào',  # 㐒
    0x3413: 'kě',  # 㐓
    0x3414: 'xiǎng',  # 㐔
    # 0x3415: '',  # 㐕
    0x3416: 'yè',  # 㐖
    0x3417: 'lǎo',  # 㐗
    0x3418: 'mǐ',  # 㐘
    0x3419: 'dòu',  # 㐙
    0x341A: 'wú',  # 㐚
    0x341B: 'yòu ㄧ',  # 㐛
    0x341C: 'chóu',  # 㐜
    0x341D: 'jū',  # 㐝
    0x341E: 'qí',  # 㐞
    0x341F: 'fēi',  # 㐟
    # 0x3420: '',  # 㐠
    0x3421: 'nuò',  # 㐡
    0x3422: 'fú',  # 㐢
    0x3423: 'kù',  # 㐣
    0x3424: 'qiú',  # 㐤
    0x3425: 'chú',  # 㐥
    0x3426: 'jǔ',  # 㐦
    # 0x3427: '',  # 㐧
    0x3428: 'xù',  # 㐨
    0x3429: 'xíng',  # 㐩
    # 0x342A: '',  # 㐪
    0x342B: 'xiōng',  # 㐫
    0x342C: 'liú',  # 㐬
    0x342D: 'lǐn',  # 㐭
    # 0x342E: '',  # 㐮
    # 0x342F: '',  # 㐯
    0x3430: 'xìn',  # 㐰
    0x3431: 'zhěn',  # 㐱
    0x3432: 'dài,fú',  # 㐲
    0x3433: 'wù',  # 㐳
    # 0x3434: '',  # 㐴
    # 0x3435: '',  # 㐵
    # 0x3436: '',  # 㐶
    0x3437: 'mǎ,mà,mián',  # 㐷
    0x3438: 'qiàn',  # 㐸
    0x3439: 'yì',  # 㐹
    0x343A: 'zhòng,yín',  # 㐺
    0x343B: 'nèi',  # 㐻
    0x343C: 'chèng,zhěng',  # 㐼
    # 0x343D: '',  # 㐽
    0x343E: 'ruǎn,yuàn',  # 㐾
    # 0x343F: '',  # 㐿
    0x3440: 'tài',  # 㑀
    # 0x3441: '',  # 㑁
    0x3442: 'fǎng,páng',  # 㑂
    0x3443: 'ǎo',  # 㑃
    0x3444: 'wǔ',  # 㑄
    0x3445: 'zuò',  # 㑅
    # 0x3446: '',  # 㑆
    0x3447: 'zhòu',  # 㑇
    0x3448: 'dòng',  # 㑈
    0x3449: 'sù',  # 㑉
    0x344A: 'yì',  # 㑊
    0x344B: 'jiòng,kǒng,qióng',  # 㑋
    # 0x344C: '',  # 㑌
    0x344D: 'lěi,lèi',  # 㑍
    0x344E: 'nǎo',  # 㑎
    0x344F: 'zhù',  # 㑏
    # 0x3450: '',  # 㑐
    0x3451: 'lǎn,jì',  # 㑑
    # 0x3452: '',  # 㑒
    # 0x3453: '',  # 㑓
    0x3454: 'xǔ',  # 㑔
    # 0x3455: '',  # 㑕
    # 0x3456: '',  # 㑖
    0x3457: 'shēn',  # 㑗
    0x3458: 'jiè',  # 㑘
    0x3459: 'dié,yǒng',  # 㑙
    0x345A: 'nuó',  # 㑚
    0x345B: 'sù',  # 㑛
    0x345C: 'yì,chì',  # 㑜
    0x345D: 'lòng',  # 㑝
    0x345E: 'yìng',  # 㑞
    0x345F: 'běng,bó,pěng',  # 㑟
    # 0x3460: '',  # 㑠
    # 0x3461: '',  # 㑡
    # 0x3462: '',  # 㑢
    0x3463: 'lán',  # 㑣
    0x3464: 'miáo',  # 㑤
    0x3465: 'yì',  # 㑥
    0x3466: 'lì',  # 㑦
    0x3467: 'jì',  # 㑧
    0x3468: 'yǔ',  # 㑨
    0x3469: 'luó',  # 㑩
    0x346A: 'chái',  # 㑪
    # 0x346B: '',  # 㑫
    # 0x346C: '',  # 㑬
    # 0x346D: '',  # 㑭
    0x346E: 'hún,wén',  # 㑮
    0x346F: 'xǔ',  # 㑯
    0x3470: 'huì',  # 㑰
    0x3471: 'rǎo',  # 㑱
    # 0x3472: '',  # 㑲
    0x3473: 'zhòu',  # 㑳
    # 0x3474: '',  # 㑴
    0x3475: 'hàn,jí,jié,zhǎ,zí',  # 㑵
    0x3476: 'xì',  # 㑶
    0x3477: 'tài',  # 㑷
    0x3478: 'ǎi,yáo,yóu',  # 㑸
    0x3479: 'huì',  # 㑹
    0x347A: 'jùn',  # 㑺
    0x347B: 'mà',  # 㑻
    # 0x347C: '',  # 㑼
    0x347D: 'táng',  # 㑽
    0x347E: 'xiáo,yáo',  # 㑾
    0x347F: 'zhào',  # 㑿
    0x3480: 'zhǎ',  # 㒀
    0x3481: 'yǔ,yùn',  # 㒁
    0x3482: 'kù,zhuó',  # 㒂
    0x3483: 'èr',  # 㒃
    0x3484: 'nàng,nèn,rǎn',  # 㒄
    0x3485: 'qǐ',  # 㒅
    0x3486: 'chì,kè,xì,xiào,yàn',  # 㒆
    0x3487: 'mù,wǔ',  # 㒇
    0x3488: 'hàn',  # 㒈
    0x3489: 'tǎng',  # 㒉
    0x348A: 'sè',  # 㒊
    # 0x348B: '',  # 㒋
    0x348C: 'qióng',  # 㒌
    0x348D: 'léi,lěi',  # 㒍
    0x348E: 'sǎ,sà,tàn',  # 㒎
    # 0x348F: '',  # 㒏
    0x3490: 'xùn',  # 㒐
    0x3491: 'huì,kuǐ',  # 㒑
    0x3492: 'pú',  # 㒒
    0x3493: 'tà',  # 㒓
    0x3494: 'shǔ',  # 㒔
    # 0x3495: '',  # 㒕
    0x3496: 'ǒu',  # 㒖
    0x3497: 'tái',  # 㒗
    # 0x3498: '',  # 㒘
    0x3499: 'mián',  # 㒙
    0x349A: 'wěn',  # 㒚
    0x349B: 'diào',  # 㒛
    0x349C: 'yú,yǔ',  # 㒜
    0x349D: 'miè,wà',  # 㒝
    0x349E: 'jùn,kě',  # 㒞
    0x349F: 'niǎo',  # 㒟
    0x34A0: 'xiè',  # 㒠
    0x34A1: 'yóu',  # 㒡
    # 0x34A2: '',  # 㒢
    # 0x34A3: '',  # 㒣
    0x34A4: 'shè,chè',  # 㒤
    # 0x34A5: '',  # 㒥
    0x34A6: 'lěi',  # 㒦
    0x34A7: 'lì',  # 㒧
    # 0x34A8: '',  # 㒨
    0x34A9: 'luǒ',  # 㒩
    # 0x34AA: '',  # 㒪
    0x34AB: 'jì',  # 㒫
    # 0x34AC: '',  # 㒬
    # 0x34AD: '',  # 㒭
    # 0x34AE: '',  # 㒮
    # 0x34AF: '',  # 㒯
    0x34B0: 'quán',  # 㒰
    0x34B1: 'mèng',  # 㒱
    0x34B2: 'cái',  # 㒲
    0x34B3: 'liǎng',  # 㒳
    0x34B4: 'gǔ',  # 㒴
    0x34B5: 'mào',  # 㒵
    # 0x34B6: '',  # 㒶
    0x34B7: 'guǎ,xìng,xǔ',  # 㒷
    0x34B8: 'suì,xuán',  # 㒸
    0x34B9: 'diān',  # 㒹
    # 0x34BA: '',  # 㒺
    0x34BB: 'mào',  # 㒻
    0x34BC: 'mán',  # 㒼
    # 0x34BD: '',  # 㒽
    0x34BE: 'shì',  # 㒾
    0x34BF: 'lí',  # 㒿
    # 0x34C0: '',  # 㓀
    0x34C1: 'wǎng',  # 㓁
    0x34C2: 'kòu',  # 㓂
    0x34C3: 'chuí,dù,zhà',  # 㓃
    0x34C4: 'zhèn',  # 㓄
    # 0x34C5: '',  # 㓅
    # 0x34C6: '',  # 㓆
    # 0x34C7: '',  # 㓇
    0x34C8: 'bèi,bìng,fèi,yè',  # 㓈
    0x34C9: 'huàn,huó,huò',  # 㓉
    0x34CA: 'dòng',  # 㓊
    0x34CB: 'gòng',  # 㓋
    # 0x34CC: '',  # 㓌
    # 0x34CD: '',  # 㓍
    0x34CE: 'qīn,qǐn,qìn',  # 㓎
    0x34CF: 'jiǒng',  # 㓏
    0x34D0: 'lù',  # 㓐
    0x34D1: 'xìng',  # 㓑
    # 0x34D2: '',  # 㓒
    0x34D3: 'nán',  # 㓓
    0x34D4: 'xiè',  # 㓔
    # 0x34D5: '',  # 㓕
    0x34D6: 'bì,bié',  # 㓖
    0x34D7: 'jié,qǐ',  # 㓗
    0x34D8: 'sù',  # 㓘
    # 0x34D9: '',  # 㓙
    # 0x34DA: '',  # 㓚
    # 0x34DB: '',  # 㓛
    0x34DC: 'yòu',  # 㓜
    0x34DD: 'xíng',  # 㓝
    0x34DE: 'qì,qià,yáo',  # 㓞
    0x34DF: 'pí',  # 㓟
    0x34E0: 'diàn',  # 㓠
    0x34E1: 'fǔ,fǒu',  # 㓡
    0x34E2: 'luò',  # 㓢
    0x34E3: 'qià',  # 㓣
    0x34E4: 'jié,qià',  # 㓤
    # 0x34E5: '',  # 㓥
    0x34E6: 'bāi',  # 㓦
    0x34E7: 'yǎn',  # 㓧
    0x34E8: 'cí,cì',  # 㓨
    # 0x34E9: '',  # 㓩
    0x34EA: 'lǎng',  # 㓪
    # 0x34EB: '',  # 㓫
    # 0x34EC: '',  # 㓬
    0x34ED: 'hé',  # 㓭
    # 0x34EE: '',  # 㓮
    0x34EF: 'lí',  # 㓯
    0x34F0: 'huà',  # 㓰
    0x34F1: 'tóu',  # 㓱
    0x34F2: 'piàn',  # 㓲
    # 0x34F3: '',  # 㓳
    0x34F4: 'jùn,ruǎn',  # 㓴
    0x34F5: 'è',  # 㓵
    0x34F6: 'qiè',  # 㓶
    0x34F7: 'yì',  # 㓷
    0x34F8: 'jué,zhuó',  # 㓸
    0x34F9: 'ruì',  # 㓹
    0x34FA: 'jiàn',  # 㓺
    # 0x34FB: '',  # 㓻
    0x34FC: 'chì,chòng',  # 㓼
    0x34FD: 'chóng',  # 㓽
    0x34FE: 'chí',  # 㓾
    # 0x34FF: '',  # 㓿
    0x3500: 'lüè,qíng',  # 㔀
    # 0x3501: '',  # 㔁
    0x3502: 'lín',  # 㔂
    0x3503: 'jué,pì',  # 㔃
    0x3504: 'sù',  # 㔄
    0x3505: 'xiào',  # 㔅
    0x3506: 'zàn',  # 㔆
    0x3507: 'pō',  # 㔇
    # 0x3508: '',  # 㔈
    0x3509: 'zhú',  # 㔉
    0x350A: 'dǎn',  # 㔊
    0x350B: 'jiàn,lán,làn',  # 㔋
    0x350C: 'zhòu',  # 㔌
    0x350D: 'duǒ,zhá',  # 㔍
    0x350E: 'xiè,yì',  # 㔎
    0x350F: 'lì',  # 㔏
    # 0x3510: '',  # 㔐
    0x3511: 'chì,dào,qì,shuì',  # 㔑
    0x3512: 'xí',  # 㔒
    0x3513: 'jiǎn,xiàn',  # 㔓
    # 0x3514: '',  # 㔔
    0x3515: 'jí,yì',  # 㔕
    0x3516: 'jiā',  # 㔖
    0x3517: 'fèi',  # 㔗
    0x3518: 'chù',  # 㔘
    0x3519: 'bǎng,péng',  # 㔙
    0x351A: 'kǒu',  # 㔚
    0x351B: 'jié',  # 㔛
    0x351C: 'bá,bó',  # 㔜
    0x351D: 'liǎng',  # 㔝
    0x351E: 'kuài,kuàng,wàng',  # 㔞
    # 0x351F: '',  # 㔟
    0x3520: 'hé,jiá',  # 㔠
    # 0x3521: '',  # 㔡
    0x3522: 'jué',  # 㔢
    0x3523: 'léi,lèi',  # 㔣
    0x3524: 'shěn',  # 㔤
    0x3525: 'pí',  # 㔥
    0x3526: 'yǎng',  # 㔦
    0x3527: 'xuè',  # 㔧
    0x3528: 'bèi',  # 㔨
    0x3529: 'è',  # 㔩
    0x352A: 'lǔ',  # 㔪
    # 0x352B: '',  # 㔫
    # 0x352C: '',  # 㔬
    0x352D: 'chè,chí,yí',  # 㔭
    0x352E: 'nuó',  # 㔮
    0x352F: 'suǎn,xuán',  # 㔯
    0x3530: 'héng',  # 㔰
    0x3531: 'yǔ',  # 㔱
    # 0x3532: '',  # 㔲
    0x3533: 'guǐ,gùn,huán,jué',  # 㔳
    0x3534: 'yì',  # 㔴
    0x3535: 'xiàn,xuǎn',  # 㔵
    0x3536: 'gòng',  # 㔶
    0x3537: 'lòu',  # 㔷
    # 0x3538: '',  # 㔸
    0x3539: 'lè',  # 㔹
    0x353A: 'shì',  # 㔺
    0x353B: 'pī',  # 㔻
    0x353C: 'sǔn',  # 㔼
    0x353D: 'yào,yǒu',  # 㔽
    0x353E: 'jié',  # 㔾
    0x353F: 'zòu',  # 㔿
    # 0x3540: '',  # 㕀
    0x3541: 'què',  # 㕁
    0x3542: 'yín',  # 㕂
    # 0x3543: '',  # 㕃
    0x3544: 'zhì',  # 㕄
    0x3545: 'jiǎ',  # 㕅
    0x3546: 'hù',  # 㕆
    0x3547: 'lá,lā',  # 㕇
    0x3548: 'hòu,yǐ',  # 㕈
    0x3549: 'kè',  # 㕉
    0x354A: 'fū',  # 㕊
    0x354B: 'jìng,qín',  # 㕋
    0x354C: 'ài',  # 㕌
    # 0x354D: '',  # 㕍
    0x354E: 'è,kè,kǔn',  # 㕎
    0x354F: 'chú',  # 㕏
    0x3550: 'xiě',  # 㕐
    0x3551: 'chú',  # 㕑
    0x3552: 'wéi,wěi,wēi',  # 㕒
    # 0x3553: '',  # 㕓
    # 0x3554: '',  # 㕔
    0x3555: 'huàn',  # 㕕
    0x3556: 'sù',  # 㕖
    0x3557: 'yòu',  # 㕗
    0x3558: 'cān',  # 㕘
    0x3559: 'jùn,ruì',  # 㕙
    0x355A: 'zhǎo',  # 㕚
    0x355B: 'xù,yǒu,yòu',  # 㕛
    0x355C: 'shǐ',  # 㕜
    # 0x355D: '',  # 㕝
    0x355E: 'shuā',  # 㕞
    0x355F: 'kuì',  # 㕟
    0x3560: 'shuāng',  # 㕠
    0x3561: 'hé,hè,huò',  # 㕡
    0x3562: 'gài,hài,jù,lǔn,nǒu',  # 㕢
    0x3563: 'yǎn,yàn',  # 㕣
    0x3564: 'qiú',  # 㕤
    0x3565: 'yǐ',  # 㕥
    0x3566: 'huà',  # 㕦
    0x3567: 'xī',  # 㕧
    0x3568: 'fàn',  # 㕨
    0x3569: 'zhàng',  # 㕩
    0x356A: 'dǎn',  # 㕪
    0x356B: 'fǎng',  # 㕫
    0x356C: 'sòng',  # 㕬
    0x356D: 'ào,bì',  # 㕭
    0x356E: 'fǔ,tiào',  # 㕮
    0x356F: 'nè',  # 㕯
    0x3570: 'hè',  # 㕰
    0x3571: 'yóu',  # 㕱
    0x3572: 'huá,yíng',  # 㕲
    # 0x3573: '',  # 㕳
    0x3574: 'chén',  # 㕴
    0x3575: 'guó,hún,luǒ',  # 㕵
    0x3576: 'ň,ňg',  # 㕶
    0x3577: 'huà',  # 㕷
    0x3578: 'lì',  # 㕸
    0x3579: 'fá',  # 㕹
    0x357A: 'háo',  # 㕺
    0x357B: 'tòu',  # 㕻
    # 0x357C: '',  # 㕼
    0x357D: 'sì',  # 㕽
    0x357E: 'xiǎo',  # 㕾
    # 0x357F: '',  # 㕿
    0x3580: 'lè,luò',  # 㖀
    0x3581: 'lìn',  # 㖁
    0x3582: 'yì',  # 㖂
    0x3583: 'hǒu,hòu',  # 㖃
    # 0x3584: '',  # 㖄
    0x3585: 'xù',  # 㖅
    0x3586: 'qú,qǔ',  # 㖆
    0x3587: 'ér',  # 㖇
    # 0x3588: '',  # 㖈
    # 0x3589: '',  # 㖉
    # 0x358A: '',  # 㖊
    # 0x358B: '',  # 㖋
    # 0x358C: '',  # 㖌
    # 0x358D: '',  # 㖍
    # 0x358E: '',  # 㖎
    0x358F: 'nèi',  # 㖏
    0x3590: 'wěi',  # 㖐
    0x3591: 'xiè',  # 㖑
    0x3592: 'tí',  # 㖒
    0x3593: 'hóng',  # 㖓
    0x3594: 'tǔn',  # 㖔
    0x3595: 'bò,niè',  # 㖕
    0x3596: 'niè',  # 㖖
    0x3597: 'yín',  # 㖗
    # 0x3598: '',  # 㖘
    # 0x3599: '',  # 㖙
    # 0x359A: '',  # 㖚
    # 0x359B: '',  # 㖛
    0x359C: 'xiǎng',  # 㖜
    # 0x359D: '',  # 㖝
    0x359E: 'wāi',  # 㖞
    0x359F: 'shòu',  # 㖟
    0x35A0: 'bà,nuò',  # 㖠
    0x35A1: 'yè',  # 㖡
    0x35A2: 'jí,qí',  # 㖢
    0x35A3: 'tòu',  # 㖣
    0x35A4: 'hán',  # 㖤
    0x35A5: 'jiǒng',  # 㖥
    0x35A6: 'dǒng',  # 㖦
    0x35A7: 'wěn',  # 㖧
    0x35A8: 'lù',  # 㖨
    0x35A9: 'sǒu',  # 㖩
    0x35AA: 'guó',  # 㖪
    0x35AB: 'líng',  # 㖫
    # 0x35AC: '',  # 㖬
    0x35AD: 'tiǎn',  # 㖭
    0x35AE: 'lún',  # 㖮
    # 0x35AF: '',  # 㖯
    # 0x35B0: '',  # 㖰
    # 0x35B1: '',  # 㖱
    # 0x35B2: '',  # 㖲
    # 0x35B3: '',  # 㖳
    # 0x35B4: '',  # 㖴
    # 0x35B5: '',  # 㖵
    0x35B6: 'yè',  # 㖶
    0x35B7: 'shí,tí',  # 㖷
    0x35B8: 'xué',  # 㖸
    0x35B9: 'fèn',  # 㖹
    0x35BA: 'chǔn',  # 㖺
    0x35BB: 'róu',  # 㖻
    0x35BC: 'duǒ,lín,móu',  # 㖼
    0x35BD: 'zé,zéi',  # 㖽
    0x35BE: 'è',  # 㖾
    0x35BF: 'xié',  # 㖿
    # 0x35C0: '',  # 㗀
    0x35C1: 'è',  # 㗁
    0x35C2: 'shěng',  # 㗂
    0x35C3: 'wěn,yìn',  # 㗃
    0x35C4: 'mán,màn',  # 㗄
    0x35C5: 'hú',  # 㗅
    0x35C6: 'gé,kài',  # 㗆
    0x35C7: 'xiá,ya',  # 㗇
    0x35C8: 'màn',  # 㗈
    0x35C9: 'bì,è,lüè',  # 㗉
    0x35CA: 'jí,qì,bī,léi',  # 㗊
    0x35CB: 'hóu',  # 㗋
    0x35CC: 'zhì',  # 㗌
    # 0x35CD: '',  # 㗍
    # 0x35CE: '',  # 㗎
    # 0x35CF: '',  # 㗏
    # 0x35D0: '',  # 㗐
    0x35D1: 'bài',  # 㗑
    0x35D2: 'ài',  # 㗒
    # 0x35D3: '',  # 㗓
    # 0x35D4: '',  # 㗔
    0x35D5: 'gòu',  # 㗕
    0x35D6: 'dàn',  # 㗖
    0x35D7: 'bǎi',  # 㗗
    0x35D8: 'bó,fù',  # 㗘
    0x35D9: 'nà,chú,zhōu',  # 㗙
    0x35DA: 'lì',  # 㗚
    0x35DB: 'xiào',  # 㗛
    0x35DC: 'xiù',  # 㗜
    # 0x35DD: '',  # 㗝
    # 0x35DE: '',  # 㗞
    # 0x35DF: '',  # 㗟
    # 0x35E0: '',  # 㗠
    # 0x35E1: '',  # 㗡
    0x35E2: 'dòng,hóng',  # 㗢
    0x35E3: 'tì',  # 㗣
    0x35E4: 'cù',  # 㗤
    0x35E5: 'kuò',  # 㗥
    0x35E6: 'láo',  # 㗦
    0x35E7: 'zhì',  # 㗧
    0x35E8: 'ǎi',  # 㗨
    0x35E9: 'xī',  # 㗩
    # 0x35EA: '',  # 㗪
    0x35EB: 'qiè',  # 㗫
    0x35EC: 'zhā',  # 㗬
    # 0x35ED: '',  # 㗭
    # 0x35EE: '',  # 㗮
    # 0x35EF: '',  # 㗯
    0x35F0: 'chù,cóng',  # 㗰
    0x35F1: 'jí',  # 㗱
    0x35F2: 'huò,xì',  # 㗲
    0x35F3: 'tǎ',  # 㗳
    0x35F4: 'yán',  # 㗴
    0x35F5: 'xù',  # 㗵
    # 0x35F6: '',  # 㗶
    0x35F7: 'sǎi',  # 㗷
    # 0x35F8: '',  # 㗸
    # 0x35F9: '',  # 㗹
    # 0x35FA: '',  # 㗺
    0x35FB: 'guō',  # 㗻
    0x35FC: 'yè',  # 㗼
    0x35FD: 'xiǎng',  # 㗽
    0x35FE: 'xué',  # 㗾
    0x35FF: 'hé,xià,xiā',  # 㗿
    0x3600: 'zuò',  # 㘀
    0x3601: 'yì',  # 㘁
    0x3602: 'cí',  # 㘂
    0x3603: 'ruò',  # 㘃
    0x3604: 'lēng',  # 㘄
    0x3605: 'xián',  # 㘅
    0x3606: 'tái',  # 㘆
    0x3607: 'róng',  # 㘇
    0x3608: 'yī,yì',  # 㘈
    0x3609: 'zhì',  # 㘉
    0x360A: 'yì',  # 㘊
    0x360B: 'xián',  # 㘋
    0x360C: 'jù',  # 㘌
    0x360D: 'jí,qì',  # 㘍
    0x360E: 'hǎn,hàn',  # 㘎
    # 0x360F: '',  # 㘏
    0x3610: 'pào,pěng',  # 㘐
    0x3611: 'lì',  # 㘑
    # 0x3612: '',  # 㘒
    0x3613: 'lán',  # 㘓
    0x3614: 'cǎn,sǎi',  # 㘔
    0x3615: 'hǎn,lán',  # 㘕
    0x3616: 'yán',  # 㘖
    # 0x3617: '',  # 㘗
    # 0x3618: '',  # 㘘
    0x3619: 'yán,yǎn',  # 㘙
    0x361A: 'hǎn',  # 㘚
    # 0x361B: '',  # 㘛
    0x361C: 'chǐ,chóu,chù',  # 㘜
    0x361D: 'niǎn,niè,nà,lǎn',  # 㘝
    0x361E: 'huò',  # 㘞
    # 0x361F: '',  # 㘟
    0x3620: 'bì,mì',  # 㘠
    0x3621: 'xiá',  # 㘡
    0x3622: 'wěng',  # 㘢
    0x3623: 'xuán,yuán',  # 㘣
    # 0x3624: '',  # 㘤
    0x3625: 'yóu',  # 㘥
    0x3626: 'qín',  # 㘦
    0x3627: 'xù',  # 㘧
    0x3628: 'nèi',  # 㘨
    0x3629: 'bì',  # 㘩
    0x362A: 'hào',  # 㘪
    0x362B: 'jǐng',  # 㘫
    0x362C: 'ào',  # 㘬
    0x362D: 'ào',  # 㘭
    # 0x362E: '',  # 㘮
    # 0x362F: '',  # 㘯
    # 0x3630: '',  # 㘰
    # 0x3631: '',  # 㘱
    0x3632: 'jú',  # 㘲
    # 0x3633: '',  # 㘳
    0x3634: 'zuò',  # 㘴
    0x3635: 'bù',  # 㘵
    0x3636: 'jié',  # 㘶
    0x3637: 'ài',  # 㘷
    0x3638: 'zàng',  # 㘸
    0x3639: 'cí',  # 㘹
    0x363A: 'fá',  # 㘺
    # 0x363B: '',  # 㘻
    # 0x363C: '',  # 㘼
    # 0x363D: '',  # 㘽
    # 0x363E: '',  # 㘾
    0x363F: 'niè',  # 㘿
    0x3640: 'liù',  # 㙀
    0x3641: 'mǎng,méi,mèi,mù,nà',  # 㙁
    0x3642: 'duì',  # 㙂
    # 0x3643: '',  # 㙃
    0x3644: 'bì',  # 㙄
    0x3645: 'bǎo',  # 㙅
    # 0x3646: '',  # 㙆
    0x3647: 'chù',  # 㙇
    0x3648: 'hán,xià',  # 㙈
    0x3649: 'tiǎn',  # 㙉
    0x364A: 'cháng,zhàng',  # 㙊
    # 0x364B: '',  # 㙋
    # 0x364C: '',  # 㙌
    0x364D: 'duō',  # 㙍
    # 0x364E: '',  # 㙎
    0x364F: 'fù',  # 㙏
    0x3650: 'duǒ',  # 㙐
    0x3651: 'yǔ',  # 㙑
    0x3652: 'yě',  # 㙒
    0x3653: 'kuí',  # 㙓
    0x3654: 'hán',  # 㙔
    0x3655: 'kuài',  # 㙕
    # 0x3656: '',  # 㙖
    0x3657: 'kuài',  # 㙗
    # 0x3658: '',  # 㙘
    0x3659: 'lǒng',  # 㙙
    0x365A: 'xīng',  # 㙚
    0x365B: 'bǔ',  # 㙛
    0x365C: 'chí,tái',  # 㙜
    0x365D: 'xié',  # 㙝
    0x365E: 'niè',  # 㙞
    0x365F: 'lǎng',  # 㙟
    0x3660: 'yì,yī',  # 㙠
    # 0x3661: '',  # 㙡
    0x3662: 'mán,mén',  # 㙢
    0x3663: 'zhàng',  # 㙣
    0x3664: 'xià',  # 㙤
    0x3665: 'gǔn',  # 㙥
    0x3666: 'xié',  # 㙦
    # 0x3667: '',  # 㙧
    0x3668: 'jì,qí',  # 㙨
    0x3669: 'liáo',  # 㙩
    0x366A: 'yè,yì',  # 㙪
    0x366B: 'jí',  # 㙫
    0x366C: 'yín',  # 㙬
    # 0x366D: '',  # 㙭
    0x366E: 'dā,da',  # 㙮
    0x366F: 'yì',  # 㙯
    0x3670: 'xiè',  # 㙰
    0x3671: 'hào',  # 㙱
    0x3672: 'yǒng',  # 㙲
    0x3673: 'hǎn,hé,kǎn',  # 㙳
    0x3674: 'chàn,zhàn',  # 㙴
    0x3675: 'tái',  # 㙵
    0x3676: 'táng',  # 㙶
    0x3677: 'zhí',  # 㙷
    0x3678: 'bào,bó,pú',  # 㙸
    0x3679: 'méng',  # 㙹
    0x367A: 'guì,kuí',  # 㙺
    0x367B: 'chán,qiè,zàn',  # 㙻
    0x367C: 'lěi',  # 㙼
    # 0x367D: '',  # 㙽
    0x367E: 'xì,xué',  # 㙾
    # 0x367F: '',  # 㙿
    # 0x3680: '',  # 㚀
    0x3681: 'qiáo,qiào,qù',  # 㚁
    0x3682: 'ráng',  # 㚂
    0x3683: 'yún,yùn,yūn',  # 㚃
    # 0x3684: '',  # 㚄
    0x3685: 'lóng',  # 㚅
    0x3686: 'fù',  # 㚆
    0x3687: 'zōng',  # 㚇
    # 0x3688: '',  # 㚈
    0x3689: 'gǔ',  # 㚉
    0x368A: 'kāi',  # 㚊
    # 0x368B: '',  # 㚋
    0x368C: 'huà,huǒ',  # 㚌
    0x368D: 'guó,kuǐ,kuì',  # 㚍
    # 0x368E: '',  # 㚎
    0x368F: 'gǎo',  # 㚏
    0x3690: 'tào',  # 㚐
    # 0x3691: '',  # 㚑
    0x3692: 'shǎn',  # 㚒
    0x3693: 'lái,lǎi',  # 㚓
    0x3694: 'niè',  # 㚔
    0x3695: 'fú,bì',  # 㚕
    0x3696: 'gǎo',  # 㚖
    0x3697: 'qié,xié',  # 㚗
    0x3698: 'bàn',  # 㚘
    # 0x3699: '',  # 㚙
    # 0x369A: '',  # 㚚
    0x369B: 'xì',  # 㚛
    0x369C: 'xù,yù',  # 㚜
    0x369D: 'kuí',  # 㚝
    0x369E: 'měng,shěn,yìng,yùn',  # 㚞
    0x369F: 'chuò',  # 㚟
    # 0x36A0: '',  # 㚠
    0x36A1: 'jǐ',  # 㚡
    0x36A2: 'nú',  # 㚢
    0x36A3: 'jiāo,xiáo',  # 㚣
    0x36A4: 'yì',  # 㚤
    0x36A5: 'yú',  # 㚥
    0x36A6: 'yí',  # 㚦
    0x36A7: 'yǎn',  # 㚧
    # 0x36A8: '',  # 㚨
    0x36A9: 'rǎn',  # 㚩
    0x36AA: 'hào',  # 㚪
    0x36AB: 'shà,zhà',  # 㚫
    # 0x36AC: '',  # 㚬
    0x36AD: 'yóu',  # 㚭
    # 0x36AE: '',  # 㚮
    0x36AF: 'xín,xún',  # 㚯
    0x36B0: 'bǐ',  # 㚰
    # 0x36B1: '',  # 㚱
    0x36B2: 'diǎn,shàn,chān',  # 㚲
    # 0x36B3: '',  # 㚳
    0x36B4: 'bù',  # 㚴
    # 0x36B5: '',  # 㚵
    0x36B6: 'sì',  # 㚶
    0x36B7: 'ěr,nǎi',  # 㚷
    0x36B8: 'sī',  # 㚸
    0x36B9: 'mǎo',  # 㚹
    0x36BA: 'yùn',  # 㚺
    0x36BB: 'jī',  # 㚻
    # 0x36BC: '',  # 㚼
    0x36BD: 'qiǎo',  # 㚽
    # 0x36BE: '',  # 㚾
    0x36BF: 'páo',  # 㚿
    # 0x36C0: '',  # 㛀
    # 0x36C1: '',  # 㛁
    0x36C2: 'nuǒ',  # 㛂
    0x36C3: 'jié',  # 㛃
    0x36C4: 'yī',  # 㛄
    0x36C5: 'èr',  # 㛅
    0x36C6: 'duǒ,duò',  # 㛆
    # 0x36C7: '',  # 㛇
    # 0x36C8: '',  # 㛈
    # 0x36C9: '',  # 㛉
    0x36CA: 'duǒ',  # 㛊
    # 0x36CB: '',  # 㛋
    # 0x36CC: '',  # 㛌
    0x36CD: 'qiè',  # 㛍
    # 0x36CE: '',  # 㛎
    0x36CF: 'òu,qiú',  # 㛏
    0x36D0: 'sǎo',  # 㛐
    0x36D1: 'càn',  # 㛑
    0x36D2: 'dòu',  # 㛒
    # 0x36D3: '',  # 㛓
    0x36D4: 'péng',  # 㛔
    0x36D5: 'yì',  # 㛕
    0x36D6: 'suō',  # 㛖
    0x36D7: 'zuò,qiē',  # 㛗
    0x36D8: 'pò',  # 㛘
    0x36D9: 'qiè,qín,shěn,shèn',  # 㛙
    0x36DA: 'tǒng',  # 㛚
    0x36DB: 'xìn,zhèn',  # 㛛
    0x36DC: 'yóu',  # 㛜
    0x36DD: 'bèi,bèng',  # 㛝
    0x36DE: 'lòng',  # 㛞
    # 0x36DF: '',  # 㛟
    # 0x36E0: '',  # 㛠
    # 0x36E1: '',  # 㛡
    # 0x36E2: '',  # 㛢
    0x36E3: 'yún',  # 㛣
    # 0x36E4: '',  # 㛤
    0x36E5: 'tà',  # 㛥
    0x36E6: 'lǎn',  # 㛦
    0x36E7: 'mǎn',  # 㛧
    0x36E8: 'qiǎng',  # 㛨
    0x36E9: 'zhóu',  # 㛩
    0x36EA: 'yàn,yuán',  # 㛪
    # 0x36EB: '',  # 㛫
    0x36EC: 'lù',  # 㛬
    # 0x36ED: '',  # 㛭
    0x36EE: 'sǎo',  # 㛮
    0x36EF: 'miǎn',  # 㛯
    # 0x36F0: '',  # 㛰
    0x36F1: 'ruì,wěi',  # 㛱
    0x36F2: 'fà',  # 㛲
    0x36F3: 'chà,yì',  # 㛳
    0x36F4: 'nǎo',  # 㛴
    # 0x36F5: '',  # 㛵
    0x36F6: 'chóu,tán,tàn',  # 㛶
    # 0x36F7: '',  # 㛷
    0x36F8: 'shù',  # 㛸
    0x36F9: 'pián',  # 㛹
    # 0x36FA: '',  # 㛺
    0x36FB: 'kuǐ',  # 㛻
    0x36FC: 'shà,chā',  # 㛼
    # 0x36FD: '',  # 㛽
    0x36FE: 'xián',  # 㛾
    0x36FF: 'zhì',  # 㛿
    # 0x3700: '',  # 㜀
    # 0x3701: '',  # 㜁
    # 0x3702: '',  # 㜂
    0x3703: 'liàn,liáo,máng',  # 㜃
    0x3704: 'xún',  # 㜄
    0x3705: 'xù',  # 㜅
    0x3706: 'mì',  # 㜆
    0x3707: 'huì,yè',  # 㜇
    0x3708: 'mù',  # 㜈
    # 0x3709: '',  # 㜉
    0x370A: 'pàng,zhǎn',  # 㜊
    0x370B: 'yì',  # 㜋
    0x370C: 'gòu',  # 㜌
    0x370D: 'táng',  # 㜍
    0x370E: 'xī,xì',  # 㜎
    0x370F: 'yún',  # 㜏
    0x3710: 'shù',  # 㜐
    0x3711: 'fú,pó',  # 㜑
    0x3712: 'yì',  # 㜒
    0x3713: 'dá',  # 㜓
    # 0x3714: '',  # 㜔
    0x3715: 'lián',  # 㜕
    0x3716: 'cáo',  # 㜖
    0x3717: 'cǎn,chú,xuàn',  # 㜗
    0x3718: 'jù',  # 㜘
    0x3719: 'lù',  # 㜙
    0x371A: 'sù',  # 㜚
    0x371B: 'nèn,ruǎn',  # 㜛
    0x371C: 'ào',  # 㜜
    0x371D: 'ǎn,àn',  # 㜝
    0x371E: 'qiàn',  # 㜞
    # 0x371F: '',  # 㜟
    # 0x3720: '',  # 㜠
    # 0x3721: '',  # 㜡
    # 0x3722: '',  # 㜢
    0x3723: 'rán,niàn',  # 㜣
    0x3724: 'shěn,niǎn',  # 㜤
    0x3725: 'mái,mó',  # 㜥
    0x3726: 'hàn,niè,sì,xié,xín',  # 㜦
    0x3727: 'yuè',  # 㜧
    0x3728: 'ér,nái',  # 㜨
    0x3729: 'ào',  # 㜩
    0x372A: 'xiǎn',  # 㜪
    0x372B: 'mà,méi,měi',  # 㜫
    # 0x372C: '',  # 㜬
    0x372D: 'dāng',  # 㜭
    0x372E: 'làn',  # 㜮
    # 0x372F: '',  # 㜯
    0x3730: 'yuè',  # 㜰
    0x3731: 'dòng,zhì',  # 㜱
    0x3732: 'wěng,yíng',  # 㜲
    0x3733: 'huái',  # 㜳
    0x3734: 'mèng',  # 㜴
    0x3735: 'niǎo',  # 㜵
    0x3736: 'fàn',  # 㜶
    0x3737: 'mí,nǎi,xiǎn',  # 㜷
    0x3738: 'niè',  # 㜸
    0x3739: 'qú',  # 㜹
    0x373A: 'zàn',  # 㜺
    0x373B: 'liàn',  # 㜻
    0x373C: 'zhí,zhì',  # 㜼
    0x373D: 'zǐ',  # 㜽
    0x373E: 'hái',  # 㜾
    0x373F: 'xù',  # 㜿
    0x3740: 'hào',  # 㝀
    0x3741: 'xún',  # 㝁
    0x3742: 'zhì',  # 㝂
    0x3743: 'fàn,miǎn,wǎn',  # 㝃
    0x3744: 'chún,qì,rùn',  # 㝄
    0x3745: 'gòu',  # 㝅
    # 0x3746: '',  # 㝆
    0x3747: 'chún',  # 㝇
    0x3748: 'luán',  # 㝈
    0x3749: 'zhù',  # 㝉
    0x374A: 'shǒu',  # 㝊
    0x374B: 'liáo,liǎo,liú',  # 㝋
    0x374C: 'jié,jiù,zhòu',  # 㝌
    0x374D: 'xiě',  # 㝍
    0x374E: 'dìng',  # 㝎
    0x374F: 'jiè',  # 㝏
    0x3750: 'róng',  # 㝐
    0x3751: 'máng,páng',  # 㝑
    # 0x3752: '',  # 㝒
    0x3753: 'gé,kè',  # 㝓
    0x3754: 'yào',  # 㝔
    0x3755: 'níng',  # 㝕
    0x3756: 'yí,yín',  # 㝖
    0x3757: 'láng',  # 㝗
    0x3758: 'yóng',  # 㝘
    0x3759: 'yín',  # 㝙
    # 0x375A: '',  # 㝚
    0x375B: 'sù',  # 㝛
    # 0x375C: '',  # 㝜
    0x375D: 'lín',  # 㝝
    0x375E: 'yā',  # 㝞
    0x375F: 'máo,mào,kuān',  # 㝟
    0x3760: 'míng',  # 㝠
    0x3761: 'zuì',  # 㝡
    0x3762: 'yǔ',  # 㝢
    0x3763: 'yè,yì',  # 㝣
    0x3764: 'gòu',  # 㝤
    0x3765: 'mǐ',  # 㝥
    0x3766: 'jùn,yá',  # 㝦
    0x3767: 'wěn',  # 㝧
    # 0x3768: '',  # 㝨
    0x3769: 'kāng',  # 㝩
    0x376A: 'diàn,dǐng',  # 㝪
    0x376B: 'lóng',  # 㝫
    0x376C: 'hú',  # 㝬
    0x376D: 'xǐng',  # 㝭
    0x376E: 'cuì',  # 㝮
    0x376F: 'qiáo',  # 㝯
    0x3770: 'mián',  # 㝰
    0x3771: 'mèng',  # 㝱
    0x3772: 'qǐn',  # 㝲
    # 0x3773: '',  # 㝳
    0x3774: 'wán',  # 㝴
    0x3775: 'dé',  # 㝵
    0x3776: 'ài,dé',  # 㝶
    # 0x3777: '',  # 㝷
    0x3778: 'biàn',  # 㝸
    0x3779: 'nóu',  # 㝹
    0x377A: 'lián,lín',  # 㝺
    0x377B: 'jǐn',  # 㝻
    0x377C: 'yū',  # 㝼
    0x377D: 'chuí,shuǐ,zhuǐ',  # 㝽
    0x377E: 'zuǒ',  # 㝾
    0x377F: 'bó,bǒ,fù,qiàn',  # 㝿
    # 0x3780: '',  # 㞀
    0x3781: 'yào',  # 㞁
    0x3782: 'tuǐ',  # 㞂
    0x3783: 'jí',  # 㞃
    # 0x3784: '',  # 㞄
    0x3785: 'guǒ',  # 㞅
    0x3786: 'jǐ',  # 㞆
    0x3787: 'wěi',  # 㞇
    # 0x3788: '',  # 㞈
    # 0x3789: '',  # 㞉
    0x378A: 'xù',  # 㞊
    0x378B: 'niǎn',  # 㞋
    0x378C: 'yùn',  # 㞌
    # 0x378D: '',  # 㞍
    0x378E: 'bǎ,fú,pá',  # 㞎
    0x378F: 'zhé',  # 㞏
    0x3790: 'jū',  # 㞐
    0x3791: 'wěi',  # 㞑
    0x3792: 'xì,xiè',  # 㞒
    0x3793: 'qǐ,qì',  # 㞓
    0x3794: 'yí',  # 㞔
    0x3795: 'xiè',  # 㞕
    0x3796: 'cì',  # 㞖
    0x3797: 'qiú',  # 㞗
    0x3798: 'tún',  # 㞘
    0x3799: 'niào',  # 㞙
    0x379A: 'qì,zhǎ',  # 㞚
    0x379B: 'jǐ',  # 㞛
    # 0x379C: '',  # 㞜
    # 0x379D: '',  # 㞝
    0x379E: 'sóng',  # 㞞
    0x379F: 'diàn',  # 㞟
    0x37A0: 'láo,liáo',  # 㞠
    0x37A1: 'zhǎn',  # 㞡
    # 0x37A2: '',  # 㞢
    # 0x37A3: '',  # 㞣
    0x37A4: 'yín',  # 㞤
    0x37A5: 'cén',  # 㞥
    0x37A6: 'jǐ',  # 㞦
    0x37A7: 'huì',  # 㞧
    0x37A8: 'zǎi,zǐ',  # 㞨
    0x37A9: 'lán',  # 㞩
    0x37AA: 'náo',  # 㞪
    0x37AB: 'jù,zǒu',  # 㞫
    0x37AC: 'qìn',  # 㞬
    0x37AD: 'dài',  # 㞭
    # 0x37AE: '',  # 㞮
    0x37AF: 'jié',  # 㞯
    0x37B0: 'xǔ',  # 㞰
    # 0x37B1: '',  # 㞱
    0x37B2: 'yòng',  # 㞲
    0x37B3: 'dǒu',  # 㞳
    0x37B4: 'chí',  # 㞴
    # 0x37B5: '',  # 㞵
    0x37B6: 'mǐn',  # 㞶
    0x37B7: 'huáng',  # 㞷
    0x37B8: 'suì',  # 㞸
    0x37B9: 'kě',  # 㞹
    0x37BA: 'zú',  # 㞺
    0x37BB: 'hào',  # 㞻
    0x37BC: 'chéng,shèng,zhé',  # 㞼
    0x37BD: 'xuè',  # 㞽
    0x37BE: 'ní,yì',  # 㞾
    0x37BF: 'chì,qí',  # 㞿
    0x37C0: 'lián',  # 㟀
    0x37C1: 'àn',  # 㟁
    0x37C2: 'chǐ,mǔ',  # 㟂
    0x37C3: 'sī',  # 㟃
    0x37C4: 'xiáng',  # 㟄
    0x37C5: 'yáng',  # 㟅
    0x37C6: 'huá',  # 㟆
    0x37C7: 'cuó,cuǒ',  # 㟇
    0x37C8: 'qiú',  # 㟈
    0x37C9: 'láo',  # 㟉
    0x37CA: 'fú',  # 㟊
    0x37CB: 'duì',  # 㟋
    0x37CC: 'máng',  # 㟌
    0x37CD: 'láng',  # 㟍
    0x37CE: 'tuǒ',  # 㟎
    0x37CF: 'hán',  # 㟏
    0x37D0: 'mǎng',  # 㟐
    0x37D1: 'bó',  # 㟑
    # 0x37D2: '',  # 㟒
    0x37D3: 'qí',  # 㟓
    0x37D4: 'hán',  # 㟔
    # 0x37D5: '',  # 㟕
    0x37D6: 'lòng',  # 㟖
    # 0x37D7: '',  # 㟗
    0x37D8: 'tiáo',  # 㟘
    0x37D9: 'lǎo,zé,zhái',  # 㟙
    0x37DA: 'qí',  # 㟚
    0x37DB: 'zàn',  # 㟛
    0x37DC: 'mí',  # 㟜
    0x37DD: 'péi,pǒu',  # 㟝
    0x37DE: 'zhàn',  # 㟞
    0x37DF: 'xiàng',  # 㟟
    0x37E0: 'gǎng',  # 㟠
    # 0x37E1: '',  # 㟡
    0x37E2: 'qí',  # 㟢
    # 0x37E3: '',  # 㟣
    0x37E4: 'lù',  # 㟤
    # 0x37E5: '',  # 㟥
    0x37E6: 'yùn',  # 㟦
    0x37E7: 'è,niè,xùn',  # 㟧
    0x37E8: 'quán',  # 㟨
    0x37E9: 'mín,mǐn,wěn',  # 㟩
    0x37EA: 'wěi',  # 㟪
    0x37EB: 'quán',  # 㟫
    0x37EC: 'shǔ,sǒu',  # 㟬
    0x37ED: 'mín',  # 㟭
    0x37EE: 'tū',  # 㟮
    0x37EF: 'è',  # 㟯
    0x37F0: 'mǐng',  # 㟰
    0x37F1: 'yǎo',  # 㟱
    0x37F2: 'jué,yuán',  # 㟲
    0x37F3: 'lì',  # 㟳
    0x37F4: 'kuài,kuǐ,wěi',  # 㟴
    0x37F5: 'gǎng',  # 㟵
    0x37F6: 'yuán',  # 㟶
    0x37F7: 'da',  # 㟷
    # 0x37F8: '',  # 㟸
    0x37F9: 'láo',  # 㟹
    0x37FA: 'lóu',  # 㟺
    0x37FB: 'qiàn',  # 㟻
    0x37FC: 'áo',  # 㟼
    0x37FD: 'biǎo',  # 㟽
    # 0x37FE: '',  # 㟾
    0x37FF: 'máng,mǎng',  # 㟿
    0x3800: 'dǎo',  # 㠀
    # 0x3801: '',  # 㠁
    0x3802: 'áo',  # 㠂
    # 0x3803: '',  # 㠃
    0x3804: 'xí',  # 㠄
    0x3805: 'fú,fù',  # 㠅
    # 0x3806: '',  # 㠆
    0x3807: 'jiù',  # 㠇
    0x3808: 'rùn',  # 㠈
    0x3809: 'tóng',  # 㠉
    # 0x380A: '',  # 㠊
    0x380B: 'è',  # 㠋
    # 0x380C: '',  # 㠌
    0x380D: 'jí,jié,qì',  # 㠍
    0x380E: 'qì',  # 㠎
    0x380F: 'huá',  # 㠏
    0x3810: 'jiào',  # 㠐
    0x3811: 'zuì',  # 㠑
    0x3812: 'biǎo',  # 㠒
    0x3813: 'méng',  # 㠓
    0x3814: 'bài',  # 㠔
    0x3815: 'wěi',  # 㠕
    0x3816: 'jì,yǐ',  # 㠖
    0x3817: 'ào,wò',  # 㠗
    0x3818: 'yǔ',  # 㠘
    0x3819: 'háo',  # 㠙
    0x381A: 'duì,zhuó',  # 㠚
    0x381B: 'wò',  # 㠛
    0x381C: 'nì',  # 㠜
    0x381D: 'cuán',  # 㠝
    # 0x381E: '',  # 㠞
    0x381F: 'lí',  # 㠟
    0x3820: 'lú',  # 㠠
    0x3821: 'niǎo',  # 㠡
    0x3822: 'huái',  # 㠢
    0x3823: 'lài,lì',  # 㠣
    # 0x3824: '',  # 㠤
    0x3825: 'lǜ',  # 㠥
    # 0x3826: '',  # 㠦
    0x3827: 'mí,mǐ',  # 㠧
    0x3828: 'yù',  # 㠨
    # 0x3829: '',  # 㠩
    0x382A: 'jù',  # 㠪
    0x382B: 'gū',  # 㠫
    0x382C: 'gū',  # 㠬
    0x382D: 'zhǎn,zhàn',  # 㠭
    # 0x382E: '',  # 㠮
    0x382F: 'yǐ',  # 㠯
    # 0x3830: '',  # 㠰
    0x3831: 'jì,qǐ',  # 㠱
    0x3832: 'bǐ',  # 㠲
    # 0x3833: '',  # 㠳
    0x3834: 'rèn',  # 㠴
    0x3835: 'huāng',  # 㠵
    0x3836: 'fán',  # 㠶
    0x3837: 'gé',  # 㠷
    0x3838: 'kù',  # 㠸
    0x3839: 'jiè',  # 㠹
    0x383A: 'miáo',  # 㠺
    # 0x383B: '',  # 㠻
    # 0x383C: '',  # 㠼
    0x383D: 'tóng',  # 㠽
    # 0x383E: '',  # 㠾
    0x383F: 'cǐ',  # 㠿
    0x3840: 'bì',  # 㡀
    0x3841: 'kǎi,kuà',  # 㡁
    0x3842: 'lì',  # 㡂
    # 0x3843: '',  # 㡃
    0x3844: 'sǔn,xún',  # 㡄
    0x3845: 'nuǒ',  # 㡅
    0x3846: 'huāng',  # 㡆
    0x3847: 'jí,zhé',  # 㡇
    0x3848: 'mén,wèn',  # 㡈
    0x3849: 'xián,yán',  # 㡉
    0x384A: 'qià,qiǎn',  # 㡊
    0x384B: 'è,yé',  # 㡋
    0x384C: 'mào,mèi',  # 㡌
    # 0x384D: '',  # 㡍
    # 0x384E: '',  # 㡎
    0x384F: 'tóu,shū',  # 㡏
    # 0x3850: '',  # 㡐
    0x3851: 'qiǎo',  # 㡑
    0x3852: 'zhūn',  # 㡒
    # 0x3853: '',  # 㡓
    0x3854: 'wù,mù',  # 㡔
    # 0x3855: '',  # 㡕
    0x3856: 'chuáng',  # 㡖
    0x3857: 'tí',  # 㡗
    0x3858: 'lián',  # 㡘
    0x3859: 'bī,pí',  # 㡙
    # 0x385A: '',  # 㡚
    0x385B: 'máng',  # 㡛
    0x385C: 'xuě',  # 㡜
    0x385D: 'fèng,fú',  # 㡝
    0x385E: 'lěi,lóu',  # 㡞
    # 0x385F: '',  # 㡟
    0x3860: 'zhèng',  # 㡠
    0x3861: 'chú',  # 㡡
    0x3862: 'màn',  # 㡢
    0x3863: 'lóng',  # 㡣
    # 0x3864: '',  # 㡤
    0x3865: 'yǐn',  # 㡥
    # 0x3866: '',  # 㡦
    0x3867: 'zhèng',  # 㡧
    0x3868: 'qiān,jiān',  # 㡨
    0x3869: 'luán',  # 㡩
    0x386A: 'nié',  # 㡪
    0x386B: 'yì',  # 㡫
    # 0x386C: '',  # 㡬
    0x386D: 'jì',  # 㡭
    0x386E: 'jí',  # 㡮
    0x386F: 'zhái,dù',  # 㡯
    0x3870: 'yǔ',  # 㡰
    0x3871: 'jiǔ',  # 㡱
    0x3872: 'huán',  # 㡲
    0x3873: 'dǐ,zhé,zhǐ',  # 㡳
    # 0x3874: '',  # 㡴
    0x3875: 'líng',  # 㡵
    0x3876: 'zhǐ',  # 㡶
    0x3877: 'běn',  # 㡷
    0x3878: 'zhǎ,zhà',  # 㡸
    0x3879: 'cì,jū',  # 㡹
    0x387A: 'dàn',  # 㡺
    0x387B: 'liào',  # 㡻
    0x387C: 'yì',  # 㡼
    0x387D: 'zhào',  # 㡽
    0x387E: 'xiàn',  # 㡾
    0x387F: 'chì',  # 㡿
    0x3880: 'cì,zì',  # 㢀
    0x3881: 'chǐ',  # 㢁
    0x3882: 'yǎn',  # 㢂
    0x3883: 'láng',  # 㢃
    0x3884: 'dòu',  # 㢄
    0x3885: 'lòng',  # 㢅
    0x3886: 'chán',  # 㢆
    # 0x3887: '',  # 㢇
    0x3888: 'tuí',  # 㢈
    0x3889: 'chá',  # 㢉
    0x388A: 'ǎi',  # 㢊
    0x388B: 'chǐ',  # 㢋
    # 0x388C: '',  # 㢌
    0x388D: 'yíng,yǐng',  # 㢍
    0x388E: 'chà,zé,zhái,zhé',  # 㢎
    0x388F: 'tóu',  # 㢏
    # 0x3890: '',  # 㢐
    0x3891: 'tuí',  # 㢑
    0x3892: 'chá',  # 㢒
    0x3893: 'yǎo,zhàng',  # 㢓
    0x3894: 'zǒng',  # 㢔
    # 0x3895: '',  # 㢕
    # 0x3896: '',  # 㢖
    0x3897: 'qiào',  # 㢗
    0x3898: 'lián',  # 㢘
    0x3899: 'qín',  # 㢙
    0x389A: 'lǔ',  # 㢚
    0x389B: 'yàn',  # 㢛
    # 0x389C: '',  # 㢜
    # 0x389D: '',  # 㢝
    0x389E: 'yì',  # 㢞
    0x389F: 'chǎn,chān',  # 㢟
    0x38A0: 'jiǒng,jùn',  # 㢠
    0x38A1: 'jiǎng',  # 㢡
    # 0x38A2: '',  # 㢢
    0x38A3: 'jìng,qíng',  # 㢣
    # 0x38A4: '',  # 㢤
    0x38A5: 'dòng',  # 㢥
    0x38A6: 'gē',  # 㢦
    0x38A7: 'juàn',  # 㢧
    0x38A8: 'hàn',  # 㢨
    0x38A9: 'dì',  # 㢩
    # 0x38AA: '',  # 㢪
    # 0x38AB: '',  # 㢫
    0x38AC: 'hóng',  # 㢬
    # 0x38AD: '',  # 㢭
    0x38AE: 'chí',  # 㢮
    0x38AF: 'mín',  # 㢯
    0x38B0: 'bì,huán',  # 㢰
    # 0x38B1: '',  # 㢱
    0x38B2: 'xùn',  # 㢲
    0x38B3: 'lú',  # 㢳
    # 0x38B4: '',  # 㢴
    0x38B5: 'shè,xié',  # 㢵
    0x38B6: 'bì',  # 㢶
    # 0x38B7: '',  # 㢷
    0x38B8: 'bì',  # 㢸
    # 0x38B9: '',  # 㢹
    0x38BA: 'xián',  # 㢺
    0x38BB: 'wěi',  # 㢻
    0x38BC: 'biè',  # 㢼
    0x38BD: 'ěr',  # 㢽
    0x38BE: 'juàn',  # 㢾
    # 0x38BF: '',  # 㢿
    0x38C0: 'zhèn',  # 㣀
    0x38C1: 'bèi',  # 㣁
    0x38C2: 'yì',  # 㣂
    0x38C3: 'yǔ,yù',  # 㣃
    0x38C4: 'qú',  # 㣄
    0x38C5: 'zàn',  # 㣅
    0x38C6: 'mí,mí,pèi',  # 㣆
    0x38C7: 'nǐ,yì',  # 㣇
    0x38C8: 'sì',  # 㣈
    # 0x38C9: '',  # 㣉
    # 0x38CA: '',  # 㣊
    # 0x38CB: '',  # 㣋
    0x38CC: 'shàn',  # 㣌
    0x38CD: 'tái',  # 㣍
    0x38CE: 'mù',  # 㣎
    0x38CF: 'jìng',  # 㣏
    0x38D0: 'biàn',  # 㣐
    0x38D1: 'róng',  # 㣑
    0x38D2: 'cèng',  # 㣒
    0x38D3: 'càn',  # 㣓
    # 0x38D4: '',  # 㣔
    # 0x38D5: '',  # 㣕
    # 0x38D6: '',  # 㣖
    # 0x38D7: '',  # 㣗
    # 0x38D8: '',  # 㣘
    0x38D9: 'dí',  # 㣙
    0x38DA: 'tóng,tǒng',  # 㣚
    0x38DB: 'tà',  # 㣛
    0x38DC: 'xíng',  # 㣜
    0x38DD: 'sōng',  # 㣝
    0x38DE: 'duó,duò',  # 㣞
    0x38DF: 'xì',  # 㣟
    0x38E0: 'tóng',  # 㣠
    # 0x38E1: '',  # 㣡
    0x38E2: 'tí',  # 㣢
    0x38E3: 'shǎn,shàn',  # 㣣
    0x38E4: 'jiàn',  # 㣤
    0x38E5: 'zhì',  # 㣥
    # 0x38E6: '',  # 㣦
    0x38E7: 'yìn,yǒng',  # 㣧
    # 0x38E8: '',  # 㣨
    # 0x38E9: '',  # 㣩
    0x38EA: 'huǎn,kuò',  # 㣪
    0x38EB: 'zhǒng',  # 㣫
    0x38EC: 'qì',  # 㣬
    # 0x38ED: '',  # 㣭
    # 0x38EE: '',  # 㣮
    0x38EF: 'xiè',  # 㣯
    0x38F0: 'xiè',  # 㣰
    0x38F1: 'zé,zuò',  # 㣱
    0x38F2: 'wéi',  # 㣲
    # 0x38F3: '',  # 㣳
    # 0x38F4: '',  # 㣴
    0x38F5: 'tà',  # 㣵
    0x38F6: 'zhān',  # 㣶
    0x38F7: 'nìng',  # 㣷
    # 0x38F8: '',  # 㣸
    # 0x38F9: '',  # 㣹
    # 0x38FA: '',  # 㣺
    0x38FB: 'yì',  # 㣻
    0x38FC: 'rěn',  # 㣼
    0x38FD: 'shù',  # 㣽
    0x38FE: 'chà',  # 㣾
    0x38FF: 'zhuó',  # 㣿
    # 0x3900: '',  # 㤀
    0x3901: 'miǎn,tiǎn',  # 㤁
    0x3902: 'jí',  # 㤂
    0x3903: 'fáng',  # 㤃
    0x3904: 'pèi',  # 㤄
    0x3905: 'ài',  # 㤅
    0x3906: 'fàn',  # 㤆
    0x3907: 'ǎo,fó,wù',  # 㤇
    0x3908: 'qìn',  # 㤈
    0x3909: 'qiā,yá',  # 㤉
    0x390A: 'xiào,yáo',  # 㤊
    # 0x390B: '',  # 㤋
    # 0x390C: '',  # 㤌
    0x390D: 'qiǎo',  # 㤍
    # 0x390E: '',  # 㤎
    0x390F: 'tóng',  # 㤏
    # 0x3910: '',  # 㤐
    0x3911: 'yōu',  # 㤑
    # 0x3912: '',  # 㤒
    0x3913: 'bèn',  # 㤓
    0x3914: 'fú,fù',  # 㤔
    0x3915: 'chù',  # 㤕
    0x3916: 'zhù',  # 㤖
    # 0x3917: '',  # 㤗
    0x3918: 'chù,cù,zhòu',  # 㤘
    # 0x3919: '',  # 㤙
    0x391A: 'háng',  # 㤚
    0x391B: 'nín,rèn',  # 㤛
    0x391C: 'jué,yù',  # 㤜
    # 0x391D: '',  # 㤝
    0x391E: 'chà',  # 㤞
    0x391F: 'kǒng,tòu',  # 㤟
    0x3920: 'liè',  # 㤠
    0x3921: 'lì',  # 㤡
    0x3922: 'xù,yù',  # 㤢
    # 0x3923: '',  # 㤣
    0x3924: 'yú,yǔ',  # 㤤
    0x3925: 'hài',  # 㤥
    0x3926: 'lì',  # 㤦
    0x3927: 'hóu,hòu',  # 㤧
    0x3928: 'gǒng,qióng',  # 㤨
    0x3929: 'kè',  # 㤩
    0x392A: 'yuàn',  # 㤪
    0x392B: 'dé',  # 㤫
    0x392C: 'huì,kuì',  # 㤬
    # 0x392D: '',  # 㤭
    0x392E: 'kuáng,guàng',  # 㤮
    0x392F: 'jiǒng,jùn',  # 㤯
    0x3930: 'zǎn,zuò',  # 㤰
    0x3931: 'fù',  # 㤱
    0x3932: 'qiè,qù',  # 㤲
    0x3933: 'běi',  # 㤳
    0x3934: 'xí',  # 㤴
    0x3935: 'cí',  # 㤵
    0x3936: 'páng',  # 㤶
    # 0x3937: '',  # 㤷
    0x3938: 'xì',  # 㤸
    0x3939: 'qiú',  # 㤹
    0x393A: 'huǎng',  # 㤺
    0x393B: 'lǔn',  # 㤻
    # 0x393C: '',  # 㤼
    0x393D: 'chóu',  # 㤽
    0x393E: 'sàn',  # 㤾
    # 0x393F: '',  # 㤿
    0x3940: 'dé',  # 㥀
    0x3941: 'dé,zhí,zhòu',  # 㥁
    0x3942: 'tè',  # 㥂
    0x3943: 'mèn',  # 㥃
    0x3944: 'líng',  # 㥄
    0x3945: 'shòu',  # 㥅
    0x3946: 'diàn,tuì',  # 㥆
    0x3947: 'cán,càn',  # 㥇
    0x3948: 'dié',  # 㥈
    0x3949: 'chè,chì',  # 㥉
    0x394A: 'péng',  # 㥊
    0x394B: 'yī',  # 㥋
    0x394C: 'jú',  # 㥌
    0x394D: 'jì',  # 㥍
    0x394E: 'lái,lí',  # 㥎
    0x394F: 'tiǎn',  # 㥏
    0x3950: 'yuàn',  # 㥐
    # 0x3951: '',  # 㥑
    0x3952: 'cǎi',  # 㥒
    0x3953: 'qǐ',  # 㥓
    0x3954: 'yú,yù',  # 㥔
    0x3955: 'lián',  # 㥕
    # 0x3956: '',  # 㥖
    # 0x3957: '',  # 㥗
    # 0x3958: '',  # 㥘
    # 0x3959: '',  # 㥙
    0x395A: 'yú',  # 㥚
    0x395B: 'jí,kè,sù',  # 㥛
    0x395C: 'wèi',  # 㥜
    0x395D: 'mǐ,miǎn',  # 㥝
    0x395E: 'cuì,qiàn,suì',  # 㥞
    0x395F: 'xié',  # 㥟
    0x3960: 'xǔ',  # 㥠
    0x3961: 'xì',  # 㥡
    0x3962: 'qiú',  # 㥢
    0x3963: 'huì',  # 㥣
    # 0x3964: '',  # 㥤
    0x3965: 'yú',  # 㥥
    0x3966: 'qiè,xiá,xiǎn',  # 㥦
    0x3967: 'shùn',  # 㥧
    0x3968: 'chuí,shuì,wěi',  # 㥨
    0x3969: 'duǒ',  # 㥩
    0x396A: 'lóu',  # 㥪
    0x396B: 'dūn',  # 㥫
    0x396C: 'páng',  # 㥬
    0x396D: 'tài',  # 㥭
    0x396E: 'zhòu',  # 㥮
    0x396F: 'yǐn',  # 㥯
    # 0x3970: '',  # 㥰
    0x3971: 'fěi',  # 㥱
    0x3972: 'shèn,yín',  # 㥲
    0x3973: 'yuán',  # 㥳
    0x3974: 'yí,yǐ',  # 㥴
    0x3975: 'hùn',  # 㥵
    0x3976: 'sè',  # 㥶
    0x3977: 'yè,yì',  # 㥷
    0x3978: 'mǐn',  # 㥸
    0x3979: 'fěn',  # 㥹
    0x397A: 'hé,hè',  # 㥺
    # 0x397B: '',  # 㥻
    0x397C: 'yǐn',  # 㥼
    0x397D: 'cè,zé',  # 㥽
    0x397E: 'nì',  # 㥾
    0x397F: 'ào',  # 㥿
    0x3980: 'féng',  # 㦀
    0x3981: 'lián',  # 㦁
    0x3982: 'cháng,tàng',  # 㦂
    0x3983: 'chǎn',  # 㦃
    0x3984: 'má,mì',  # 㦄
    0x3985: 'diē,dì',  # 㦅
    # 0x3986: '',  # 㦆
    0x3987: 'lù',  # 㦇
    # 0x3988: '',  # 㦈
    0x3989: 'yì',  # 㦉
    0x398A: 'huá',  # 㦊
    # 0x398B: '',  # 㦋
    0x398C: 'tuì,xù,hū',  # 㦌
    0x398D: 'è',  # 㦍
    0x398E: 'huà',  # 㦎
    0x398F: 'sǔn,xuàn',  # 㦏
    0x3990: 'nì',  # 㦐
    0x3991: 'liǎn,xiàn',  # 㦑
    0x3992: 'lí',  # 㦒
    0x3993: 'xiàn',  # 㦓
    0x3994: 'yàn',  # 㦔
    0x3995: 'lóng',  # 㦕
    0x3996: 'mèn',  # 㦖
    0x3997: 'jiàn,jìn',  # 㦗
    # 0x3998: '',  # 㦘
    # 0x3999: '',  # 㦙
    0x399A: 'biǎn',  # 㦚
    0x399B: 'yú,yǔ',  # 㦛
    0x399C: 'huò,xuè',  # 㦜
    0x399D: 'miǎo',  # 㦝
    0x399E: 'chóu',  # 㦞
    0x399F: 'hài,mái',  # 㦟
    # 0x39A0: '',  # 㦠
    0x39A1: 'lè',  # 㦡
    0x39A2: 'jié,qì',  # 㦢
    0x39A3: 'wèi',  # 㦣
    0x39A4: 'yì',  # 㦤
    0x39A5: 'huán,xiǎn',  # 㦥
    0x39A6: 'hè',  # 㦦
    0x39A7: 'cǎn',  # 㦧
    0x39A8: 'lán,làn',  # 㦨
    0x39A9: 'yǐn',  # 㦩
    0x39AA: 'xiè',  # 㦪
    # 0x39AB: '',  # 㦫
    0x39AC: 'luǒ',  # 㦬
    0x39AD: 'líng',  # 㦭
    0x39AE: 'qián',  # 㦮
    0x39AF: 'huò',  # 㦯
    0x39B0: 'jiān',  # 㦰
    0x39B1: 'wǒ',  # 㦱
    0x39B2: 'zāi',  # 㦲
    # 0x39B3: '',  # 㦳
    0x39B4: 'gé,qià',  # 㦴
    # 0x39B5: '',  # 㦵
    0x39B6: 'dié',  # 㦶
    0x39B7: 'yǒng',  # 㦷
    0x39B8: 'jǐ',  # 㦸
    0x39B9: 'àng,yáng,yǐng',  # 㦹
    0x39BA: 'rǔ,rù',  # 㦺
    0x39BB: 'xí,zhé',  # 㦻
    0x39BC: 'shuàng',  # 㦼
    0x39BD: 'xù,yù',  # 㦽
    0x39BE: 'yí',  # 㦾
    0x39BF: 'hù',  # 㦿
    0x39C0: 'jí',  # 㧀
    0x39C1: 'qù',  # 㧁
    0x39C2: 'tián',  # 㧂
    # 0x39C3: '',  # 㧃
    0x39C4: 'qiǎn,qiú',  # 㧄
    0x39C5: 'mù,dāo',  # 㧅
    # 0x39C6: '',  # 㧆
    0x39C7: 'mǎo',  # 㧇
    0x39C8: 'yǐn,yìn',  # 㧈
    0x39C9: 'gài,kuì',  # 㧉
    0x39CA: 'bá,pō',  # 㧊
    0x39CB: 'xiǎn,xuǎn',  # 㧋
    0x39CC: 'mào',  # 㧌
    0x39CD: 'fǎng',  # 㧍
    0x39CE: 'yá,yà,qiā',  # 㧎
    0x39CF: 'gāng',  # 㧏
    0x39D0: 'sǒng',  # 㧐
    0x39D1: 'wéi,wěi',  # 㧑
    0x39D2: 'xué,yù,yuè',  # 㧒
    # 0x39D3: '',  # 㧓
    0x39D4: 'guài',  # 㧔
    0x39D5: 'jiù,liǔ,yú',  # 㧕
    0x39D6: 'è',  # 㧖
    0x39D7: 'zǐ,jǐ,zhǐ',  # 㧗
    0x39D8: 'cuì,nǎo,zì',  # 㧘
    0x39D9: 'bì',  # 㧙
    0x39DA: 'wǎ',  # 㧚
    # 0x39DB: '',  # 㧛
    0x39DC: 'liè',  # 㧜
    # 0x39DD: '',  # 㧝
    # 0x39DE: '',  # 㧞
    0x39DF: 'kuǎi',  # 㧟
    # 0x39E0: '',  # 㧠
    0x39E1: 'hài',  # 㧡
    0x39E2: 'yīn',  # 㧢
    0x39E3: 'zhù',  # 㧣
    0x39E4: 'chòng',  # 㧤
    0x39E5: 'xiǎn',  # 㧥
    0x39E6: 'xuàn',  # 㧦
    # 0x39E7: '',  # 㧧
    0x39E8: 'qiú',  # 㧨
    0x39E9: 'pèi',  # 㧩
    0x39EA: 'guǐ',  # 㧪
    0x39EB: 'ér',  # 㧫
    0x39EC: 'gǒng',  # 㧬
    0x39ED: 'qióng',  # 㧭
    # 0x39EE: '',  # 㧮
    0x39EF: 'lǎo',  # 㧯
    0x39F0: 'lì',  # 㧰
    0x39F1: 'chèn,ná,nì,nì,tiàn',  # 㧱
    0x39F2: 'sǎn',  # 㧲
    0x39F3: 'bǎi,bó,zhuò',  # 㧳
    0x39F4: 'wǒ',  # 㧴
    0x39F5: 'póu,pǒu',  # 㧵
    # 0x39F6: '',  # 㧶
    0x39F7: 'duò,tùn',  # 㧷
    # 0x39F8: '',  # 㧸
    0x39F9: 'tè',  # 㧹
    0x39FA: 'tà',  # 㧺
    0x39FB: 'zhǐ,zhuó,zú',  # 㧻
    0x39FC: 'biào',  # 㧼
    0x39FD: 'gù,hú',  # 㧽
    # 0x39FE: '',  # 㧾
    # 0x39FF: '',  # 㧿
    0x3A00: 'bǐng',  # 㨀
    0x3A01: 'zhí,zhì',  # 㨁
    0x3A02: 'dǒng',  # 㨂
    0x3A03: 'chéng,duǐ',  # 㨃
    0x3A04: 'zhào',  # 㨄
    0x3A05: 'nèi,ruì',  # 㨅
    0x3A06: 'lǐn',  # 㨆
    0x3A07: 'pó',  # 㨇
    0x3A08: 'jǐ',  # 㨈
    0x3A09: 'mǐn',  # 㨉
    0x3A0A: 'wěi',  # 㨊
    0x3A0B: 'chě,lè,zhèn',  # 㨋
    0x3A0C: 'gòu,rú,rǔ',  # 㨌
    # 0x3A0D: '',  # 㨍
    0x3A0E: 'rú,ruán',  # 㨎
    # 0x3A0F: '',  # 㨏
    0x3A10: 'bǔ,péi',  # 㨐
    # 0x3A11: '',  # 㨑
    0x3A12: 'kuí,wěi,xié',  # 㨒
    0x3A13: 'láo,liáo',  # 㨓
    0x3A14: 'hàn',  # 㨔
    0x3A15: 'yíng',  # 㨕
    0x3A16: 'zhì',  # 㨖
    0x3A17: 'jié',  # 㨗
    0x3A18: 'xǐng',  # 㨘
    0x3A19: 'xié',  # 㨙
    0x3A1A: 'xún',  # 㨚
    0x3A1B: 'shǎn',  # 㨛
    0x3A1C: 'qián',  # 㨜
    0x3A1D: 'xiè',  # 㨝
    0x3A1E: 'sù',  # 㨞
    0x3A1F: 'hái',  # 㨟
    0x3A20: 'mì',  # 㨠
    0x3A21: 'hún',  # 㨡
    # 0x3A22: '',  # 㨢
    # 0x3A23: '',  # 㨣
    0x3A24: 'huì,kuǎi,wài',  # 㨤
    0x3A25: 'nà',  # 㨥
    0x3A26: 'sǒng',  # 㨦
    0x3A27: 'bèn',  # 㨧
    0x3A28: 'liù',  # 㨨
    0x3A29: 'jié',  # 㨩
    0x3A2A: 'huàng',  # 㨪
    0x3A2B: 'lǎn',  # 㨫
    # 0x3A2C: '',  # 㨬
    0x3A2D: 'hù',  # 㨭
    0x3A2E: 'dōu',  # 㨮
    0x3A2F: 'huò,kuò',  # 㨯
    0x3A30: 'gé,gǔn,hùn,huò,jié',  # 㨰
    0x3A31: 'yáo',  # 㨱
    0x3A32: 'cè',  # 㨲
    0x3A33: 'guǐ',  # 㨳
    0x3A34: 'jiàn',  # 㨴
    0x3A35: 'jiǎn',  # 㨵
    0x3A36: 'chóu,dǎo,zhǒu,zhòu',  # 㨶
    0x3A37: 'jìn',  # 㨷
    0x3A38: 'mà',  # 㨸
    0x3A39: 'huì',  # 㨹
    0x3A3A: 'mén,mì,miǎn',  # 㨺
    0x3A3B: 'cán,shǎn,zàn',  # 㨻
    0x3A3C: 'lüè',  # 㨼
    0x3A3D: 'pǐ,pì,qiǎo',  # 㨽
    0x3A3E: 'yàng',  # 㨾
    0x3A3F: 'jù',  # 㨿
    0x3A40: 'jù',  # 㩀
    0x3A41: 'què',  # 㩁
    # 0x3A42: '',  # 㩂
    0x3A43: 'qiān',  # 㩃
    0x3A44: 'shāi',  # 㩄
    0x3A45: 'chōu',  # 㩅
    0x3A46: 'jiù',  # 㩆
    0x3A47: 'huà,huò',  # 㩇
    0x3A48: 'xiàn,yǔn',  # 㩈
    0x3A49: 'xié',  # 㩉
    # 0x3A4A: '',  # 㩊
    0x3A4B: 'sù,xiāo',  # 㩋
    0x3A4C: 'fèi',  # 㩌
    0x3A4D: 'cè',  # 㩍
    0x3A4E: 'yè',  # 㩎
    # 0x3A4F: '',  # 㩏
    0x3A50: 'dèn',  # 㩐
    # 0x3A51: '',  # 㩑
    0x3A52: 'qín',  # 㩒
    0x3A53: 'huǐ',  # 㩓
    0x3A54: 'tún',  # 㩔
    # 0x3A55: '',  # 㩕
    0x3A56: 'qiáng,tiáo',  # 㩖
    0x3A57: 'xí,xié',  # 㩗
    0x3A58: 'yǐ',  # 㩘
    # 0x3A59: '',  # 㩙
    0x3A5A: 'méng',  # 㩚
    0x3A5B: 'tuán',  # 㩛
    0x3A5C: 'lǎn',  # 㩜
    0x3A5D: 'háo',  # 㩝
    0x3A5E: 'cì',  # 㩞
    0x3A5F: 'zhài',  # 㩟
    0x3A60: 'piǎo',  # 㩠
    0x3A61: 'luǒ',  # 㩡
    0x3A62: 'mí,miè',  # 㩢
    # 0x3A63: '',  # 㩣
    # 0x3A64: '',  # 㩤
    # 0x3A65: '',  # 㩥
    0x3A66: 'xié',  # 㩦
    0x3A67: 'bó',  # 㩧
    0x3A68: 'huì',  # 㩨
    0x3A69: 'qǐ,qǐng',  # 㩩
    0x3A6A: 'xié,xìn,yé',  # 㩪
    # 0x3A6B: '',  # 㩫
    # 0x3A6C: '',  # 㩬
    0x3A6D: 'bó,jiǎo,xiào',  # 㩭
    0x3A6E: 'qián,xián',  # 㩮
    0x3A6F: 'bǎn,pán,pó',  # 㩯
    0x3A70: 'jiǎo,qiáo,xiǔ',  # 㩰
    0x3A71: 'jué',  # 㩱
    0x3A72: 'kǔn,quán',  # 㩲
    0x3A73: 'sǒng',  # 㩳
    0x3A74: 'jú',  # 㩴
    0x3A75: 'è',  # 㩵
    0x3A76: 'niè,nǐng',  # 㩶
    # 0x3A77: '',  # 㩷
    0x3A78: 'dié',  # 㩸
    0x3A79: 'dié,zhá',  # 㩹
    # 0x3A7A: '',  # 㩺
    0x3A7B: 'guǐ,qī',  # 㩻
    0x3A7C: 'zhī',  # 㩼
    0x3A7D: 'qí',  # 㩽
    0x3A7E: 'chuí',  # 㩾
    # 0x3A7F: '',  # 㩿
    0x3A80: 'yú',  # 㪀
    0x3A81: 'qín',  # 㪁
    # 0x3A82: '',  # 㪂
    0x3A83: 'hé',  # 㪃
    0x3A84: 'fú',  # 㪄
    # 0x3A85: '',  # 㪅
    0x3A86: 'dǐ',  # 㪆
    0x3A87: 'xiàn',  # 㪇
    0x3A88: 'guì',  # 㪈
    0x3A89: 'hé',  # 㪉
    0x3A8A: 'qún',  # 㪊
    0x3A8B: 'hàn',  # 㪋
    0x3A8C: 'tǒng,yú,yǔ',  # 㪌
    0x3A8D: 'bó',  # 㪍
    0x3A8E: 'shǎn',  # 㪎
    0x3A8F: 'bǐ',  # 㪏
    0x3A90: 'lù',  # 㪐
    0x3A91: 'yè',  # 㪑
    0x3A92: 'ní',  # 㪒
    0x3A93: 'chuái',  # 㪓
    0x3A94: 'sàn,tán',  # 㪔
    0x3A95: 'diào',  # 㪕
    0x3A96: 'lù',  # 㪖
    0x3A97: 'tǒu',  # 㪗
    0x3A98: 'liǎn',  # 㪘
    0x3A99: 'kě,kè,kuò',  # 㪙
    0x3A9A: 'sàn',  # 㪚
    0x3A9B: 'zhěn',  # 㪛
    0x3A9C: 'chuǎi',  # 㪜
    0x3A9D: 'liàn',  # 㪝
    0x3A9E: 'mào',  # 㪞
    # 0x3A9F: '',  # 㪟
    0x3AA0: 'qiàn',  # 㪠
    0x3AA1: 'kě',  # 㪡
    0x3AA2: 'shǎo',  # 㪢
    0x3AA3: 'qiào',  # 㪣
    0x3AA4: 'bì',  # 㪤
    0x3AA5: 'zhā',  # 㪥
    0x3AA6: 'yìn',  # 㪦
    # 0x3AA7: '',  # 㪧
    0x3AA8: 'shàn',  # 㪨
    0x3AA9: 'sù',  # 㪩
    0x3AAA: 'sà,xǐ',  # 㪪
    0x3AAB: 'ruì',  # 㪫
    0x3AAC: 'zhuó',  # 㪬
    0x3AAD: 'lú',  # 㪭
    0x3AAE: 'líng',  # 㪮
    0x3AAF: 'chá,jǔ,qú',  # 㪯
    # 0x3AB0: '',  # 㪰
    0x3AB1: 'huàn',  # 㪱
    # 0x3AB2: '',  # 㪲
    # 0x3AB3: '',  # 㪳
    0x3AB4: 'jiá',  # 㪴
    0x3AB5: 'bàn',  # 㪵
    0x3AB6: 'hú',  # 㪶
    0x3AB7: 'dǒu',  # 㪷
    # 0x3AB8: '',  # 㪸
    0x3AB9: 'lǒu',  # 㪹
    0x3ABA: 'jū',  # 㪺
    0x3ABB: 'juàn',  # 㪻
    0x3ABC: 'kě',  # 㪼
    0x3ABD: 'suǒ,suò',  # 㪽
    0x3ABE: 'gé,luò',  # 㪾
    0x3ABF: 'zhé,shé',  # 㪿
    0x3AC0: 'dǐng',  # 㫀
    0x3AC1: 'duàn',  # 㫁
    0x3AC2: 'zhù',  # 㫂
    0x3AC3: 'yǎn',  # 㫃
    0x3AC4: 'páng',  # 㫄
    0x3AC5: 'chá,qí,shí',  # 㫅
    # 0x3AC6: '',  # 㫆
    # 0x3AC7: '',  # 㫇
    # 0x3AC8: '',  # 㫈
    # 0x3AC9: '',  # 㫉
    0x3ACA: 'yǐ',  # 㫊
    # 0x3ACB: '',  # 㫋
    # 0x3ACC: '',  # 㫌
    0x3ACD: 'yóu',  # 㫍
    0x3ACE: 'gǔn,kuài',  # 㫎
    0x3ACF: 'yǎo',  # 㫏
    0x3AD0: 'yǎo',  # 㫐
    0x3AD1: 'shí,zhǐ',  # 㫑
    0x3AD2: 'gǒng',  # 㫒
    0x3AD3: 'qǐ,qì',  # 㫓
    0x3AD4: 'gèn',  # 㫔
    # 0x3AD5: '',  # 㫕
    0x3AD6: 'zhǐ',  # 㫖
    0x3AD7: 'hòu',  # 㫗
    0x3AD8: 'mì,miǎn',  # 㫘
    0x3AD9: 'fú',  # 㫙
    0x3ADA: 'hū',  # 㫚
    0x3ADB: 'guàng,kuáng,kuàng,mǔ',  # 㫛
    0x3ADC: 'dàn,tǎn',  # 㫜
    # 0x3ADD: '',  # 㫝
    # 0x3ADE: '',  # 㫞
    0x3ADF: 'yán',  # 㫟
    # 0x3AE0: '',  # 㫠
    # 0x3AE1: '',  # 㫡
    0x3AE2: 'qù',  # 㫢
    # 0x3AE3: '',  # 㫣
    0x3AE4: 'chǎng,zhào',  # 㫤
    0x3AE5: 'mǐng',  # 㫥
    # 0x3AE6: '',  # 㫦
    0x3AE7: 'bào',  # 㫧
    # 0x3AE8: '',  # 㫨
    # 0x3AE9: '',  # 㫩
    # 0x3AEA: '',  # 㫪
    0x3AEB: 'xiǎn',  # 㫫
    # 0x3AEC: '',  # 㫬
    0x3AED: 'shí',  # 㫭
    # 0x3AEE: '',  # 㫮
    0x3AEF: 'mào',  # 㫯
    0x3AF0: 'lǎng',  # 㫰
    0x3AF1: 'nǎn',  # 㫱
    0x3AF2: 'pèi',  # 㫲
    0x3AF3: 'chén',  # 㫳
    # 0x3AF4: '',  # 㫴
    # 0x3AF5: '',  # 㫵
    0x3AF6: 'cǒu,zhǒu',  # 㫶
    # 0x3AF7: '',  # 㫷
    0x3AF8: 'qiè',  # 㫸
    0x3AF9: 'dài,shù,yú',  # 㫹
    # 0x3AFA: '',  # 㫺
    0x3AFB: 'kùn',  # 㫻
    0x3AFC: 'dié,zhé,zhì',  # 㫼
    0x3AFD: 'lù',  # 㫽
    # 0x3AFE: '',  # 㫾
    # 0x3AFF: '',  # 㫿
    # 0x3B00: '',  # 㬀
    # 0x3B01: '',  # 㬁
    0x3B02: 'yú',  # 㬂
    0x3B03: 'tái',  # 㬃
    0x3B04: 'chàn',  # 㬄
    0x3B05: 'màn',  # 㬅
    0x3B06: 'mián,miàn,mǐn',  # 㬆
    0x3B07: 'huàn',  # 㬇
    # 0x3B08: '',  # 㬈
    0x3B09: 'nuǎn,ruò',  # 㬉
    0x3B0A: 'huǎn',  # 㬊
    0x3B0B: 'hóu',  # 㬋
    0x3B0C: 'jìng',  # 㬌
    0x3B0D: 'bó',  # 㬍
    0x3B0E: 'xiǎn',  # 㬎
    0x3B0F: 'lì',  # 㬏
    0x3B10: 'jǐn,jìn,xíng,yǐng',  # 㬐
    # 0x3B11: '',  # 㬑
    0x3B12: 'mǎng,mào',  # 㬒
    0x3B13: 'piào',  # 㬓
    0x3B14: 'háo',  # 㬔
    0x3B15: 'yáng',  # 㬕
    # 0x3B16: '',  # 㬖
    0x3B17: 'xiàn',  # 㬗
    0x3B18: 'sù',  # 㬘
    0x3B19: 'wěi',  # 㬙
    0x3B1A: 'chè',  # 㬚
    # 0x3B1B: '',  # 㬛
    0x3B1C: 'jìn',  # 㬜
    0x3B1D: 'céng',  # 㬝
    0x3B1E: 'hè',  # 㬞
    # 0x3B1F: '',  # 㬟
    0x3B20: 'shài',  # 㬠
    0x3B21: 'líng',  # 㬡
    # 0x3B22: '',  # 㬢
    0x3B23: 'duì',  # 㬣
    # 0x3B24: '',  # 㬤
    0x3B25: 'pù',  # 㬥
    0x3B26: 'yuè',  # 㬦
    0x3B27: 'bó',  # 㬧
    # 0x3B28: '',  # 㬨
    0x3B29: 'huì',  # 㬩
    0x3B2A: 'dié,zhì',  # 㬪
    0x3B2B: 'yàn',  # 㬫
    0x3B2C: 'jù',  # 㬬
    0x3B2D: 'jiào,shǎn,yǎo',  # 㬭
    0x3B2E: 'kuài,nàn',  # 㬮
    0x3B2F: 'liè',  # 㬯
    0x3B30: 'yú',  # 㬰
    0x3B31: 'tì',  # 㬱
    # 0x3B32: '',  # 㬲
    0x3B33: 'wǔ',  # 㬳
    0x3B34: 'hǒng',  # 㬴
    0x3B35: 'xiáo,jiāo',  # 㬵
    0x3B36: 'hào',  # 㬶
    # 0x3B37: '',  # 㬷
    # 0x3B38: '',  # 㬸
    # 0x3B39: '',  # 㬹
    # 0x3B3A: '',  # 㬺
    0x3B3B: 'huǎng',  # 㬻
    0x3B3C: 'fù',  # 㬼
    # 0x3B3D: '',  # 㬽
    # 0x3B3E: '',  # 㬾
    0x3B3F: 'dùn',  # 㬿
    # 0x3B40: '',  # 㭀
    0x3B41: 'réng',  # 㭁
    0x3B42: 'jiǎo',  # 㭂
    # 0x3B43: '',  # 㭃
    0x3B44: 'xìn',  # 㭄
    # 0x3B45: '',  # 㭅
    # 0x3B46: '',  # 㭆
    0x3B47: 'yuàn',  # 㭇
    0x3B48: 'jué,kuài',  # 㭈
    0x3B49: 'huá',  # 㭉
    # 0x3B4A: '',  # 㭊
    0x3B4B: 'bàng',  # 㭋
    0x3B4C: 'móu,yú',  # 㭌
    # 0x3B4D: '',  # 㭍
    0x3B4E: 'gāng',  # 㭎
    0x3B4F: 'wěi',  # 㭏
    # 0x3B50: '',  # 㭐
    0x3B51: 'mèi',  # 㭑
    0x3B52: 'sì',  # 㭒
    0x3B53: 'biàn',  # 㭓
    0x3B54: 'lú',  # 㭔
    0x3B55: 'qū',  # 㭕
    # 0x3B56: '',  # 㭖
    # 0x3B57: '',  # 㭗
    0x3B58: 'hé,gé',  # 㭘
    0x3B59: 'shé,zhé',  # 㭙
    # 0x3B5A: '',  # 㭚
    0x3B5B: 'pài',  # 㭛
    0x3B5C: 'róng',  # 㭜
    0x3B5D: 'qiú',  # 㭝
    0x3B5E: 'liè',  # 㭞
    0x3B5F: 'gǒng',  # 㭟
    0x3B60: 'xiǎn',  # 㭠
    0x3B61: 'xì,xìn',  # 㭡
    # 0x3B62: '',  # 㭢
    # 0x3B63: '',  # 㭣
    0x3B64: 'niǎo',  # 㭤
    # 0x3B65: '',  # 㭥
    # 0x3B66: '',  # 㭦
    # 0x3B67: '',  # 㭧
    0x3B68: 'yé',  # 㭨
    0x3B69: 'lèi,líng,liè',  # 㭩
    # 0x3B6A: '',  # 㭪
    0x3B6B: 'cuán,cuó,zhèn',  # 㭫
    0x3B6C: 'zhuó',  # 㭬
    0x3B6D: 'fèi',  # 㭭
    0x3B6E: 'zuò',  # 㭮
    0x3B6F: 'dié,nà,zhé',  # 㭯
    0x3B70: 'jì,jué,zuǐ',  # 㭰
    0x3B71: 'hé,xiá',  # 㭱
    0x3B72: 'jí',  # 㭲
    # 0x3B73: '',  # 㭳
    # 0x3B74: '',  # 㭴
    # 0x3B75: '',  # 㭵
    # 0x3B76: '',  # 㭶
    # 0x3B77: '',  # 㭷
    0x3B78: 'tú',  # 㭸
    0x3B79: 'xián',  # 㭹
    0x3B7A: 'yǎn',  # 㭺
    0x3B7B: 'táng',  # 㭻
    0x3B7C: 'tà',  # 㭼
    0x3B7D: 'dǐ',  # 㭽
    0x3B7E: 'jué,yuè',  # 㭾
    0x3B7F: 'áng',  # 㭿
    0x3B80: 'hán',  # 㮀
    0x3B81: 'yáo',  # 㮁
    0x3B82: 'jú',  # 㮂
    0x3B83: 'ruí',  # 㮃
    0x3B84: 'bǎng,bì,péng',  # 㮄
    # 0x3B85: '',  # 㮅
    0x3B86: 'niè',  # 㮆
    0x3B87: 'tiàn',  # 㮇
    0x3B88: 'nài',  # 㮈
    # 0x3B89: '',  # 㮉
    # 0x3B8A: '',  # 㮊
    0x3B8B: 'yǒu,yù',  # 㮋
    0x3B8C: 'mián,mǐn',  # 㮌
    # 0x3B8D: '',  # 㮍
    # 0x3B8E: '',  # 㮎
    0x3B8F: 'nài',  # 㮏
    0x3B90: 'xǐng,shěng',  # 㮐
    0x3B91: 'qì',  # 㮑
    # 0x3B92: '',  # 㮒
    0x3B93: 'gèn',  # 㮓
    0x3B94: 'tóng',  # 㮔
    0x3B95: 'ér,ruǎn',  # 㮕
    0x3B96: 'jiá,jiá',  # 㮖
    0x3B97: 'qín',  # 㮗
    0x3B98: 'mào',  # 㮘
    0x3B99: 'è',  # 㮙
    0x3B9A: 'lì',  # 㮚
    0x3B9B: 'chí',  # 㮛
    # 0x3B9C: '',  # 㮜
    0x3B9D: 'hé,luò',  # 㮝
    0x3B9E: 'jié,ní,yá',  # 㮞
    0x3B9F: 'jí,niǎn,pèng,ròu,kā',  # 㮟
    # 0x3BA0: '',  # 㮠
    0x3BA1: 'guàn',  # 㮡
    0x3BA2: 'hóu',  # 㮢
    0x3BA3: 'gài,zé',  # 㮣
    # 0x3BA4: '',  # 㮤
    0x3BA5: 'fèn',  # 㮥
    0x3BA6: 'sè,suǒ',  # 㮦
    # 0x3BA7: '',  # 㮧
    0x3BA8: 'jí,jì',  # 㮨
    0x3BA9: 'xī',  # 㮩
    0x3BAA: 'qióng',  # 㮪
    0x3BAB: 'hé',  # 㮫
    # 0x3BAC: '',  # 㮬
    0x3BAD: 'xián',  # 㮭
    0x3BAE: 'jié',  # 㮮
    0x3BAF: 'huá,hún,kuǎn',  # 㮯
    0x3BB0: 'bí,pí',  # 㮰
    # 0x3BB1: '',  # 㮱
    # 0x3BB2: '',  # 㮲
    0x3BB3: 'zhèn',  # 㮳
    # 0x3BB4: '',  # 㮴
    # 0x3BB5: '',  # 㮵
    0x3BB6: 'shì,shuò',  # 㮶
    # 0x3BB7: '',  # 㮷
    0x3BB8: 'sòng',  # 㮸
    0x3BB9: 'zhǐ',  # 㮹
    0x3BBA: 'běn',  # 㮺
    # 0x3BBB: '',  # 㮻
    # 0x3BBC: '',  # 㮼
    # 0x3BBD: '',  # 㮽
    0x3BBE: 'lǎng',  # 㮾
    0x3BBF: 'bì',  # 㮿
    0x3BC0: 'xiǎn,xuàn',  # 㯀
    0x3BC1: 'bàng',  # 㯁
    0x3BC2: 'dài',  # 㯂
    # 0x3BC3: '',  # 㯃
    # 0x3BC4: '',  # 㯄
    0x3BC5: 'pí',  # 㯅
    0x3BC6: 'chǎn',  # 㯆
    0x3BC7: 'bì',  # 㯇
    0x3BC8: 'sù',  # 㯈
    0x3BC9: 'huò,chū',  # 㯉
    0x3BCA: 'hén',  # 㯊
    0x3BCB: 'yǐng',  # 㯋
    0x3BCC: 'chuán',  # 㯌
    0x3BCD: 'jiǎng',  # 㯍
    0x3BCE: 'nèn',  # 㯎
    0x3BCF: 'gǔ',  # 㯏
    0x3BD0: 'fǎng,tuǒ',  # 㯐
    # 0x3BD1: '',  # 㯑
    # 0x3BD2: '',  # 㯒
    0x3BD3: 'tà',  # 㯓
    0x3BD4: 'cuì',  # 㯔
    0x3BD5: 'xī',  # 㯕
    0x3BD6: 'dé',  # 㯖
    0x3BD7: 'rǎn,shùn,xián,xiàn',  # 㯗
    0x3BD8: 'kuǎn',  # 㯘
    0x3BD9: 'chè',  # 㯙
    0x3BDA: 'dá',  # 㯚
    0x3BDB: 'hú,huò',  # 㯛
    0x3BDC: 'cuì',  # 㯜
    0x3BDD: 'lù',  # 㯝
    0x3BDE: 'juàn,yuè',  # 㯞
    0x3BDF: 'lù',  # 㯟
    0x3BE0: 'qiàn,xiàn,xún',  # 㯠
    0x3BE1: 'pào',  # 㯡
    0x3BE2: 'zhèn',  # 㯢
    # 0x3BE3: '',  # 㯣
    0x3BE4: 'lì',  # 㯤
    0x3BE5: 'cáo,zāo',  # 㯥
    0x3BE6: 'qí',  # 㯦
    # 0x3BE7: '',  # 㯧
    # 0x3BE8: '',  # 㯨
    0x3BE9: 'tì',  # 㯩
    0x3BEA: 'líng',  # 㯪
    0x3BEB: 'qú',  # 㯫
    0x3BEC: 'liǎn',  # 㯬
    0x3BED: 'lǔ',  # 㯭
    0x3BEE: 'shǔ',  # 㯮
    0x3BEF: 'gòng',  # 㯯
    0x3BF0: 'zhé,zhí',  # 㯰
    0x3BF1: 'biǎo,piáo,pāo',  # 㯱
    0x3BF2: 'jìn',  # 㯲
    0x3BF3: 'qíng',  # 㯳
    # 0x3BF4: '',  # 㯴
    # 0x3BF5: '',  # 㯵
    0x3BF6: 'zōng',  # 㯶
    0x3BF7: 'pú',  # 㯷
    0x3BF8: 'jǐn',  # 㯸
    0x3BF9: 'biǎo',  # 㯹
    0x3BFA: 'jiàn',  # 㯺
    0x3BFB: 'gǔn,hùn',  # 㯻
    # 0x3BFC: '',  # 㯼
    # 0x3BFD: '',  # 㯽
    # 0x3BFE: '',  # 㯾
    0x3BFF: 'liè',  # 㯿
    0x3C00: 'lí',  # 㰀
    0x3C01: 'luǒ',  # 㰁
    0x3C02: 'shěn,sǔn',  # 㰂
    0x3C03: 'mián',  # 㰃
    0x3C04: 'jiàn',  # 㰄
    0x3C05: 'dí',  # 㰅
    0x3C06: 'bèi',  # 㰆
    # 0x3C07: '',  # 㰇
    0x3C08: 'liǎn',  # 㰈
    # 0x3C09: '',  # 㰉
    0x3C0A: 'xún',  # 㰊
    0x3C0B: 'pín',  # 㰋
    0x3C0C: 'què',  # 㰌
    0x3C0D: 'lóng',  # 㰍
    0x3C0E: 'zuì',  # 㰎
    # 0x3C0F: '',  # 㰏
    0x3C10: 'jué,kuí,lěi,tuǐ,tuǒ',  # 㰐
    # 0x3C11: '',  # 㰑
    0x3C12: 'shé,xué',  # 㰒
    # 0x3C13: '',  # 㰓
    0x3C14: 'xiè',  # 㰔
    # 0x3C15: '',  # 㰕
    0x3C16: 'lǎn',  # 㰖
    0x3C17: 'cù',  # 㰗
    0x3C18: 'yí',  # 㰘
    0x3C19: 'nuó',  # 㰙
    0x3C1A: 'lí',  # 㰚
    0x3C1B: 'yuè',  # 㰛
    # 0x3C1C: '',  # 㰜
    0x3C1D: 'yǐ',  # 㰝
    # 0x3C1E: '',  # 㰞
    0x3C1F: 'jì,qì',  # 㰟
    0x3C20: 'kàng',  # 㰠
    0x3C21: 'xiè',  # 㰡
    # 0x3C22: '',  # 㰢
    0x3C23: 'zì',  # 㰣
    0x3C24: 'hē,qiè',  # 㰤
    0x3C25: 'huì',  # 㰥
    0x3C26: 'qù',  # 㰦
    # 0x3C27: '',  # 㰧
    # 0x3C28: '',  # 㰨
    # 0x3C29: '',  # 㰩
    0x3C2A: 'wá',  # 㰪
    # 0x3C2B: '',  # 㰫
    0x3C2C: 'xún',  # 㰬
    # 0x3C2D: '',  # 㰭
    0x3C2E: 'shèn',  # 㰮
    0x3C2F: 'tòu,tǒu,hòu',  # 㰯
    0x3C30: 'qiè',  # 㰰
    0x3C31: 'shà',  # 㰱
    0x3C32: 'xù,yù',  # 㰲
    0x3C33: 'yà',  # 㰳
    0x3C34: 'pó,pǒu',  # 㰴
    0x3C35: 'zú',  # 㰵
    0x3C36: 'yǒu',  # 㰶
    0x3C37: 'zì',  # 㰷
    0x3C38: 'liǎn,liàn,luǎn',  # 㰸
    0x3C39: 'jìn',  # 㰹
    0x3C3A: 'xiá,xià',  # 㰺
    0x3C3B: 'yǐ',  # 㰻
    0x3C3C: 'qiè',  # 㰼
    0x3C3D: 'mǐ,yàn',  # 㰽
    0x3C3E: 'jiào',  # 㰾
    # 0x3C3F: '',  # 㰿
    0x3C40: 'chǐ,chuài',  # 㱀
    0x3C41: 'shì',  # 㱁
    0x3C42: 'kāng',  # 㱂
    0x3C43: 'yǐn',  # 㱃
    0x3C44: 'mò',  # 㱄
    0x3C45: 'yì',  # 㱅
    # 0x3C46: '',  # 㱆
    0x3C47: 'sè,xì',  # 㱇
    0x3C48: 'jìn',  # 㱈
    0x3C49: 'yè',  # 㱉
    # 0x3C4A: '',  # 㱊
    0x3C4B: 'què',  # 㱋
    0x3C4C: 'chè,yǎn,yé',  # 㱌
    0x3C4D: 'luán',  # 㱍
    # 0x3C4E: '',  # 㱎
    0x3C4F: 'zhèng',  # 㱏
    # 0x3C50: '',  # 㱐
    # 0x3C51: '',  # 㱑
    # 0x3C52: '',  # 㱒
    # 0x3C53: '',  # 㱓
    0x3C54: 'xiē,suò',  # 㱔
    # 0x3C55: '',  # 㱕
    0x3C56: 'cuì',  # 㱖
    # 0x3C57: '',  # 㱗
    0x3C58: 'àn,yǎn',  # 㱘
    0x3C59: 'xiǔ',  # 㱙
    0x3C5A: 'cán,hài,shàn',  # 㱚
    0x3C5B: 'chuǎn',  # 㱛
    0x3C5C: 'zhá',  # 㱜
    # 0x3C5D: '',  # 㱝
    0x3C5E: 'jí',  # 㱞
    0x3C5F: 'bó,pí,pǐ',  # 㱟
    0x3C60: 'kū',  # 㱠
    # 0x3C61: '',  # 㱡
    0x3C62: 'láng',  # 㱢
    0x3C63: 'tuǐ',  # 㱣
    # 0x3C64: '',  # 㱤
    0x3C65: 'líng',  # 㱥
    0x3C66: 'è,guì,jǐ,qī',  # 㱦
    0x3C67: 'wò',  # 㱧
    0x3C68: 'liàn',  # 㱨
    0x3C69: 'dú',  # 㱩
    0x3C6A: 'mèn,hūn',  # 㱪
    0x3C6B: 'làn',  # 㱫
    0x3C6C: 'wěi',  # 㱬
    0x3C6D: 'duàn',  # 㱭
    0x3C6E: 'kuài,kuì',  # 㱮
    0x3C6F: 'ái',  # 㱯
    0x3C70: 'zǎi',  # 㱰
    0x3C71: 'huì,wù,xì',  # 㱱
    0x3C72: 'yì',  # 㱲
    0x3C73: 'mò',  # 㱳
    0x3C74: 'zì',  # 㱴
    0x3C75: 'bèn,fèn',  # 㱵
    0x3C76: 'bèng,jiào,péng,qiǎo,rù',  # 㱶
    # 0x3C77: '',  # 㱷
    0x3C78: 'bì,bié',  # 㱸
    0x3C79: 'lì,suàn,xiàn',  # 㱹
    0x3C7A: 'lú',  # 㱺
    0x3C7B: 'luǒ,luò',  # 㱻
    # 0x3C7C: '',  # 㱼
    0x3C7D: 'dàn,qín,zhěn',  # 㱽
    0x3C7E: 'gāi,kāi',  # 㱾
    0x3C7F: 'què',  # 㱿
    0x3C80: 'chén',  # 㲀
    # 0x3C81: '',  # 㲁
    0x3C82: 'chéng',  # 㲂
    0x3C83: 'jiù',  # 㲃
    0x3C84: 'kòu,kū',  # 㲄
    0x3C85: 'jì',  # 㲅
    0x3C86: 'líng',  # 㲆
    # 0x3C87: '',  # 㲇
    0x3C88: 'sháo',  # 㲈
    0x3C89: 'què',  # 㲉
    0x3C8A: 'ruì',  # 㲊
    0x3C8B: 'chuò,zhuó,zú',  # 㲋
    0x3C8C: 'nèng',  # 㲌
    # 0x3C8D: '',  # 㲍
    0x3C8E: 'lóu',  # 㲎
    0x3C8F: 'bǎo,piǎo,pín,pìng',  # 㲏
    # 0x3C90: '',  # 㲐
    # 0x3C91: '',  # 㲑
    0x3C92: 'bào',  # 㲒
    0x3C93: 'róng',  # 㲓
    # 0x3C94: '',  # 㲔
    0x3C95: 'lèi',  # 㲕
    # 0x3C96: '',  # 㲖
    # 0x3C97: '',  # 㲗
    0x3C98: 'qú',  # 㲘
    # 0x3C99: '',  # 㲙
    0x3C9A: 'shā',  # 㲚
    0x3C9B: 'zhǐ',  # 㲛
    0x3C9C: 'tán,tǎn',  # 㲜
    0x3C9D: 'rǒng',  # 㲝
    0x3C9E: 'zú',  # 㲞
    0x3C9F: 'yǐng',  # 㲟
    0x3CA0: 'máo',  # 㲠
    0x3CA1: 'nài,nì',  # 㲡
    0x3CA2: 'biàn,bié',  # 㲢
    # 0x3CA3: '',  # 㲣
    # 0x3CA4: '',  # 㲤
    0x3CA5: 'táng',  # 㲥
    0x3CA6: 'hàn,hě',  # 㲦
    0x3CA7: 'zào',  # 㲧
    0x3CA8: 'róng',  # 㲨
    # 0x3CA9: '',  # 㲩
    0x3CAA: 'dēng',  # 㲪
    0x3CAB: 'pú',  # 㲫
    # 0x3CAC: '',  # 㲬
    0x3CAD: 'tǎn',  # 㲭
    # 0x3CAE: '',  # 㲮
    0x3CAF: 'rán',  # 㲯
    0x3CB0: 'níng',  # 㲰
    0x3CB1: 'liè',  # 㲱
    0x3CB2: 'dié,yì',  # 㲲
    0x3CB3: 'dié',  # 㲳
    0x3CB4: 'zhòng,zhòu',  # 㲴
    # 0x3CB5: '',  # 㲵
    0x3CB6: 'lǜ',  # 㲶
    0x3CB7: 'dàn',  # 㲷
    # 0x3CB8: '',  # 㲸
    0x3CB9: 'guǐ,qiú',  # 㲹
    0x3CBA: 'jí,kè,léi',  # 㲺
    0x3CBB: 'nì',  # 㲻
    0x3CBC: 'yì',  # 㲼
    0x3CBD: 'niàn,rěn,xiàn',  # 㲽
    0x3CBE: 'yǔ,yù',  # 㲾
    0x3CBF: 'wǎng',  # 㲿
    0x3CC0: 'guò,kǎi,xì',  # 㳀
    0x3CC1: 'zè',  # 㳁
    0x3CC2: 'yán',  # 㳂
    0x3CC3: 'cuì',  # 㳃
    0x3CC4: 'xián',  # 㳄
    0x3CC5: 'jiǎo,liú',  # 㳅
    0x3CC6: 'shǔ,tǒu',  # 㳆
    0x3CC7: 'fù',  # 㳇
    0x3CC8: 'pèi',  # 㳈
    # 0x3CC9: '',  # 㳉
    # 0x3CCA: '',  # 㳊
    # 0x3CCB: '',  # 㳋
    # 0x3CCC: '',  # 㳌
    0x3CCD: 'bù',  # 㳍
    0x3CCE: 'biàn,fàn',  # 㳎
    0x3CCF: 'chǐ,shì',  # 㳏
    0x3CD0: 'sà,zhá,zhǎ',  # 㳐
    0x3CD1: 'yì',  # 㳑
    0x3CD2: 'fǎ',  # 㳒
    # 0x3CD3: '',  # 㳓
    0x3CD4: 'duì',  # 㳔
    0x3CD5: 'lán',  # 㳕
    # 0x3CD6: '',  # 㳖
    0x3CD7: 'chài',  # 㳗
    0x3CD8: 'chōng',  # 㳘
    0x3CD9: 'xuàn',  # 㳙
    0x3CDA: 'yù',  # 㳚
    0x3CDB: 'yú',  # 㳛
    # 0x3CDC: '',  # 㳜
    # 0x3CDD: '',  # 㳝
    # 0x3CDE: '',  # 㳞
    # 0x3CDF: '',  # 㳟
    0x3CE0: 'tà',  # 㳠
    # 0x3CE1: '',  # 㳡
    # 0x3CE2: '',  # 㳢
    # 0x3CE3: '',  # 㳣
    # 0x3CE4: '',  # 㳤
    0x3CE5: 'jù,lòng',  # 㳥
    0x3CE6: 'xiè',  # 㳦
    0x3CE7: 'xí',  # 㳧
    0x3CE8: 'jiǎn,zá,zǎn',  # 㳨
    # 0x3CE9: '',  # 㳩
    0x3CEA: 'pàn,pì',  # 㳪
    0x3CEB: 'tà',  # 㳫
    0x3CEC: 'xuán',  # 㳬
    0x3CED: 'xián',  # 㳭
    0x3CEE: 'niào',  # 㳮
    # 0x3CEF: '',  # 㳯
    # 0x3CF0: '',  # 㳰
    # 0x3CF1: '',  # 㳱
    # 0x3CF2: '',  # 㳲
    # 0x3CF3: '',  # 㳳
    0x3CF4: 'mì',  # 㳴
    0x3CF5: 'jì',  # 㳵
    0x3CF6: 'gòu,nǒu',  # 㳶
    0x3CF7: 'wěn,hū',  # 㳷
    # 0x3CF8: '',  # 㳸
    0x3CF9: 'wǎng',  # 㳹
    0x3CFA: 'yóu',  # 㳺
    0x3CFB: 'zé',  # 㳻
    0x3CFC: 'bì',  # 㳼
    0x3CFD: 'mǐ',  # 㳽
    # 0x3CFE: '',  # 㳾
    0x3CFF: 'xiè',  # 㳿
    0x3D00: 'fàn',  # 㴀
    0x3D01: 'yì',  # 㴁
    # 0x3D02: '',  # 㴂
    0x3D03: 'lèi,lì',  # 㴃
    0x3D04: 'yíng',  # 㴄
    # 0x3D05: '',  # 㴅
    0x3D06: 'jìn,xìng',  # 㴆
    0x3D07: 'shè',  # 㴇
    0x3D08: 'yìn',  # 㴈
    0x3D09: 'jǐ',  # 㴉
    # 0x3D0A: '',  # 㴊
    0x3D0B: 'sù',  # 㴋
    # 0x3D0C: '',  # 㴌
    # 0x3D0D: '',  # 㴍
    # 0x3D0E: '',  # 㴎
    0x3D0F: 'wǎng',  # 㴏
    0x3D10: 'miàn',  # 㴐
    0x3D11: 'sù',  # 㴑
    0x3D12: 'yì',  # 㴒
    0x3D13: 'zǎi',  # 㴓
    0x3D14: 'sè,yì',  # 㴔
    0x3D15: 'jí',  # 㴕
    0x3D16: 'luò',  # 㴖
    # 0x3D17: '',  # 㴗
    0x3D18: 'mào',  # 㴘
    0x3D19: 'zhá',  # 㴙
    0x3D1A: 'suì',  # 㴚
    0x3D1B: 'zhì',  # 㴛
    0x3D1C: 'biàn',  # 㴜
    0x3D1D: 'lí',  # 㴝
    0x3D1E: 'tāo',  # 㴞
    # 0x3D1F: '',  # 㴟
    # 0x3D20: '',  # 㴠
    # 0x3D21: '',  # 㴡
    # 0x3D22: '',  # 㴢
    # 0x3D23: '',  # 㴣
    # 0x3D24: '',  # 㴤
    0x3D25: 'qiào',  # 㴥
    0x3D26: 'guàn',  # 㴦
    # 0x3D27: '',  # 㴧
    0x3D28: 'zhèn',  # 㴨
    0x3D29: 'yōng',  # 㴩
    0x3D2A: 'niè',  # 㴪
    0x3D2B: 'jùn',  # 㴫
    0x3D2C: 'xiè',  # 㴬
    0x3D2D: 'yǎo',  # 㴭
    0x3D2E: 'xiè',  # 㴮
    # 0x3D2F: '',  # 㴯
    0x3D30: 'néng',  # 㴰
    # 0x3D31: '',  # 㴱
    0x3D32: 'sī',  # 㴲
    0x3D33: 'lǒng',  # 㴳
    0x3D34: 'chén',  # 㴴
    0x3D35: 'mì',  # 㴵
    0x3D36: 'què',  # 㴶
    0x3D37: 'dān',  # 㴷
    0x3D38: 'nà,shǎn,yè',  # 㴸
    # 0x3D39: '',  # 㴹
    # 0x3D3A: '',  # 㴺
    # 0x3D3B: '',  # 㴻
    0x3D3C: 'sù',  # 㴼
    0x3D3D: 'xiè,yìn',  # 㴽
    0x3D3E: 'bó',  # 㴾
    0x3D3F: 'dǐng',  # 㴿
    0x3D40: 'cuàn,zú',  # 㵀
    # 0x3D41: '',  # 㵁
    0x3D42: 'chuǎng,shù',  # 㵂
    0x3D43: 'shé',  # 㵃
    0x3D44: 'hàn,qià,yù',  # 㵄
    0x3D45: 'dàn,tàn',  # 㵅
    0x3D46: 'hào',  # 㵆
    # 0x3D47: '',  # 㵇
    # 0x3D48: '',  # 㵈
    # 0x3D49: '',  # 㵉
    0x3D4A: 'shěn,zhé',  # 㵊
    0x3D4B: 'mì',  # 㵋
    0x3D4C: 'chàn,qióng,xún',  # 㵌
    0x3D4D: 'mèn',  # 㵍
    0x3D4E: 'hǎn,jiàn,kǎn',  # 㵎
    0x3D4F: 'cuǐ',  # 㵏
    0x3D50: 'jué',  # 㵐
    0x3D51: 'hè',  # 㵑
    0x3D52: 'fèi',  # 㵒
    0x3D53: 'shí',  # 㵓
    0x3D54: 'chě,chè',  # 㵔
    0x3D55: 'shèn',  # 㵕
    # 0x3D56: '',  # 㵖
    0x3D57: 'fù,pán,píng',  # 㵗
    0x3D58: 'màn',  # 㵘
    # 0x3D59: '',  # 㵙
    # 0x3D5A: '',  # 㵚
    # 0x3D5B: '',  # 㵛
    # 0x3D5C: '',  # 㵜
    0x3D5D: 'yì',  # 㵝
    0x3D5E: 'chóu',  # 㵞
    # 0x3D5F: '',  # 㵟
    # 0x3D60: '',  # 㵠
    0x3D61: 'báo',  # 㵡
    0x3D62: 'léi,lěi',  # 㵢
    0x3D63: 'kě,luǒ',  # 㵣
    0x3D64: 'diàn,shà,xiá',  # 㵤
    0x3D65: 'bì,mì',  # 㵥
    0x3D66: 'suí',  # 㵦
    0x3D67: 'gé',  # 㵧
    0x3D68: 'bì,pì',  # 㵨
    0x3D69: 'yì',  # 㵩
    0x3D6A: 'xián',  # 㵪
    0x3D6B: 'nǐ,yì',  # 㵫
    0x3D6C: 'yíng',  # 㵬
    0x3D6D: 'zhǔ',  # 㵭
    0x3D6E: 'chún,wěn',  # 㵮
    0x3D6F: 'féng',  # 㵯
    0x3D70: 'xù',  # 㵰
    0x3D71: 'piǎo',  # 㵱
    0x3D72: 'wǔ',  # 㵲
    0x3D73: 'liáo,liú',  # 㵳
    0x3D74: 'cáng',  # 㵴
    0x3D75: 'zòu',  # 㵵
    # 0x3D76: '',  # 㵶
    0x3D77: 'biàn',  # 㵷
    0x3D78: 'yào,yuè',  # 㵸
    0x3D79: 'huán',  # 㵹
    0x3D7A: 'pái,pài',  # 㵺
    0x3D7B: 'sòu',  # 㵻
    0x3D7C: 'xiè',  # 㵼
    0x3D7D: 'duì,lěi',  # 㵽
    0x3D7E: 'jìng,qìng',  # 㵾
    0x3D7F: 'xí',  # 㵿
    # 0x3D80: '',  # 㶀
    0x3D81: 'guó',  # 㶁
    # 0x3D82: '',  # 㶂
    # 0x3D83: '',  # 㶃
    0x3D84: 'yán',  # 㶄
    0x3D85: 'xué',  # 㶅
    0x3D86: 'chú,zhū',  # 㶆
    0x3D87: 'héng',  # 㶇
    0x3D88: 'yíng,yìng',  # 㶈
    # 0x3D89: '',  # 㶉
    # 0x3D8A: '',  # 㶊
    # 0x3D8B: '',  # 㶋
    0x3D8C: 'lián',  # 㶌
    0x3D8D: 'xiǎn',  # 㶍
    0x3D8E: 'huán',  # 㶎
    # 0x3D8F: '',  # 㶏
    # 0x3D90: '',  # 㶐
    0x3D91: 'liàn',  # 㶑
    0x3D92: 'shǎn,shěn,tàn',  # 㶒
    0x3D93: 'cáng',  # 㶓
    0x3D94: 'bèi',  # 㶔
    0x3D95: 'jiǎn',  # 㶕
    0x3D96: 'shù',  # 㶖
    0x3D97: 'fàn',  # 㶗
    0x3D98: 'diàn',  # 㶘
    # 0x3D99: '',  # 㶙
    0x3D9A: 'bà',  # 㶚
    0x3D9B: 'yú',  # 㶛
    # 0x3D9C: '',  # 㶜
    # 0x3D9D: '',  # 㶝
    0x3D9E: 'nǎng',  # 㶞
    0x3D9F: 'lěi',  # 㶟
    0x3DA0: 'yì',  # 㶠
    0x3DA1: 'dài,huǒ,zuó',  # 㶡
    # 0x3DA2: '',  # 㶢
    0x3DA3: 'chán',  # 㶣
    0x3DA4: 'chǎo',  # 㶤
    # 0x3DA5: '',  # 㶥
    0x3DA6: 'jìn',  # 㶦
    0x3DA7: 'nèn',  # 㶧
    # 0x3DA8: '',  # 㶨
    # 0x3DA9: '',  # 㶩
    # 0x3DAA: '',  # 㶪
    0x3DAB: 'liǎo,liào',  # 㶫
    0x3DAC: 'méi,mò',  # 㶬
    0x3DAD: 'jiù,yǒu',  # 㶭
    # 0x3DAE: '',  # 㶮
    0x3DAF: 'liù',  # 㶯
    0x3DB0: 'hán',  # 㶰
    # 0x3DB1: '',  # 㶱
    0x3DB2: 'yòng',  # 㶲
    0x3DB3: 'jìn',  # 㶳
    0x3DB4: 'chǐ,shǐ',  # 㶴
    0x3DB5: 'rèn',  # 㶵
    0x3DB6: 'nóng',  # 㶶
    # 0x3DB7: '',  # 㶷
    # 0x3DB8: '',  # 㶸
    0x3DB9: 'hòng',  # 㶹
    0x3DBA: 'tiàn',  # 㶺
    # 0x3DBB: '',  # 㶻
    # 0x3DBC: '',  # 㶼
    # 0x3DBD: '',  # 㶽
    # 0x3DBE: '',  # 㶾
    0x3DBF: 'bó',  # 㶿
    0x3DC0: 'qióng',  # 㷀
    # 0x3DC1: '',  # 㷁
    0x3DC2: 'shù',  # 㷂
    0x3DC3: 'cuǐ',  # 㷃
    0x3DC4: 'huì',  # 㷄
    0x3DC5: 'chǎo,miǎo',  # 㷅
    0x3DC6: 'dòu,fù',  # 㷆
    0x3DC7: 'guài,kuí',  # 㷇
    0x3DC8: 'è',  # 㷈
    0x3DC9: 'wèi,yù,yùn',  # 㷉
    0x3DCA: 'fén',  # 㷊
    0x3DCB: 'tán,tǎn',  # 㷋
    # 0x3DCC: '',  # 㷌
    0x3DCD: 'lún',  # 㷍
    0x3DCE: 'hè,hóng,xié',  # 㷎
    0x3DCF: 'yǒng',  # 㷏
    0x3DD0: 'huǐ',  # 㷐
    # 0x3DD1: '',  # 㷑
    0x3DD2: 'yú',  # 㷒
    0x3DD3: 'zǒng',  # 㷓
    0x3DD4: 'yàn',  # 㷔
    0x3DD5: 'qiú',  # 㷕
    0x3DD6: 'zhào',  # 㷖
    0x3DD7: 'jiǒng',  # 㷗
    0x3DD8: 'tái',  # 㷘
    # 0x3DD9: '',  # 㷙
    # 0x3DDA: '',  # 㷚
    # 0x3DDB: '',  # 㷛
    # 0x3DDC: '',  # 㷜
    # 0x3DDD: '',  # 㷝
    # 0x3DDE: '',  # 㷞
    0x3DDF: 'tuì',  # 㷟
    0x3DE0: 'lín',  # 㷠
    0x3DE1: 'jiǒng',  # 㷡
    0x3DE2: 'zhǎ',  # 㷢
    # 0x3DE3: '',  # 㷣
    0x3DE4: 'hè,hù,xuè',  # 㷤
    # 0x3DE5: '',  # 㷥
    0x3DE6: 'xù',  # 㷦
    # 0x3DE7: '',  # 㷧
    # 0x3DE8: '',  # 㷨
    0x3DE9: 'xī',  # 㷩
    0x3DEA: 'cuì,zuǎn',  # 㷪
    0x3DEB: 'qǐng',  # 㷫
    0x3DEC: 'mò',  # 㷬
    0x3DED: 'fēng',  # 㷭
    0x3DEE: 'zāo',  # 㷮
    0x3DEF: 'bèng',  # 㷯
    0x3DF0: 'lí',  # 㷰
    # 0x3DF1: '',  # 㷱
    # 0x3DF2: '',  # 㷲
    0x3DF3: 'yàn',  # 㷳
    0x3DF4: 'gé,lì',  # 㷴
    0x3DF5: 'mò',  # 㷵
    0x3DF6: 'bèi,bì',  # 㷶
    0x3DF7: 'juǎn',  # 㷷
    0x3DF8: 'dié,yè',  # 㷸
    0x3DF9: 'shào',  # 㷹
    # 0x3DFA: '',  # 㷺
    0x3DFB: 'wú',  # 㷻
    0x3DFC: 'yàn',  # 㷼
    # 0x3DFD: '',  # 㷽
    0x3DFE: 'jué',  # 㷾
    # 0x3DFF: '',  # 㷿
    0x3E00: 'tái',  # 㸀
    0x3E01: 'hǎn,hàn',  # 㸁
    # 0x3E02: '',  # 㸂
    0x3E03: 'diǎn',  # 㸃
    0x3E04: 'jì,jié',  # 㸄
    0x3E05: 'jié',  # 㸅
    0x3E06: 'kào',  # 㸆
    # 0x3E07: '',  # 㸇
    # 0x3E08: '',  # 㸈
    0x3E09: 'xiè',  # 㸉
    0x3E0A: 'là,lài,liè',  # 㸊
    0x3E0B: 'fán',  # 㸋
    0x3E0C: 'huò',  # 㸌
    0x3E0D: 'xì',  # 㸍
    0x3E0E: 'niè',  # 㸎
    0x3E0F: 'mí',  # 㸏
    0x3E10: 'rán',  # 㸐
    0x3E11: 'cuàn',  # 㸑
    0x3E12: 'yín',  # 㸒
    0x3E13: 'mì',  # 㸓
    0x3E14: 'kàn',  # 㸔
    0x3E15: 'jué',  # 㸕
    # 0x3E16: '',  # 㸖
    0x3E17: 'tóng',  # 㸗
    0x3E18: 'wàn',  # 㸘
    # 0x3E19: '',  # 㸙
    0x3E1A: 'lǐ',  # 㸚
    0x3E1B: 'sháo,shuò',  # 㸛
    0x3E1C: 'kòng',  # 㸜
    0x3E1D: 'kǎn',  # 㸝
    0x3E1E: 'bǎn',  # 㸞
    # 0x3E1F: '',  # 㸟
    0x3E20: 'tiǎo',  # 㸠
    # 0x3E21: '',  # 㸡
    0x3E22: 'bèi',  # 㸢
    0x3E23: 'yè,yì',  # 㸣
    0x3E24: 'piàn',  # 㸤
    0x3E25: 'chán',  # 㸥
    0x3E26: 'hù',  # 㸦
    0x3E27: 'kèn,yín',  # 㸧
    # 0x3E28: '',  # 㸨
    0x3E29: 'àn',  # 㸩
    0x3E2A: 'chún',  # 㸪
    0x3E2B: 'qián',  # 㸫
    0x3E2C: 'bèi,fèi,pèi',  # 㸬
    # 0x3E2D: '',  # 㸭
    0x3E2E: 'fén',  # 㸮
    # 0x3E2F: '',  # 㸯
    0x3E30: 'tuó',  # 㸰
    0x3E31: 'tuó',  # 㸱
    0x3E32: 'zuó,zuò',  # 㸲
    0x3E33: 'líng',  # 㸳
    # 0x3E34: '',  # 㸴
    0x3E35: 'guǐ,wěi',  # 㸵
    # 0x3E36: '',  # 㸶
    0x3E37: 'shì',  # 㸷
    0x3E38: 'hǒu,ǒu,kǒu',  # 㸸
    0x3E39: 'liè',  # 㸹
    0x3E3A: 'shā',  # 㸺
    0x3E3B: 'sì',  # 㸻
    # 0x3E3C: '',  # 㸼
    0x3E3D: 'bèi',  # 㸽
    0x3E3E: 'rèn',  # 㸾
    0x3E3F: 'dú',  # 㸿
    0x3E40: 'bó',  # 㹀
    0x3E41: 'liáng',  # 㹁
    0x3E42: 'cì,qiǎn',  # 㹂
    0x3E43: 'bì,fèi',  # 㹃
    0x3E44: 'jì,qì',  # 㹄
    0x3E45: 'zǒng',  # 㹅
    # 0x3E46: '',  # 㹆
    0x3E47: 'hé',  # 㹇
    0x3E48: 'lí,máo',  # 㹈
    0x3E49: 'yuán',  # 㹉
    0x3E4A: 'yuè',  # 㹊
    # 0x3E4B: '',  # 㹋
    0x3E4C: 'chǎn,shèng',  # 㹌
    0x3E4D: 'dí,dú',  # 㹍
    0x3E4E: 'léi',  # 㹎
    0x3E4F: 'jǐn',  # 㹏
    0x3E50: 'chóng,zhòu',  # 㹐
    0x3E51: 'sì,yí',  # 㹑
    0x3E52: 'pǔ',  # 㹒
    0x3E53: 'yì',  # 㹓
    0x3E54: 'jiāng',  # 㹔
    # 0x3E55: '',  # 㹕
    0x3E56: 'huàn',  # 㹖
    0x3E57: 'táo,tāo',  # 㹗
    0x3E58: 'rú,rù,ruí',  # 㹘
    0x3E59: 'wěng',  # 㹙
    0x3E5A: 'wěng',  # 㹚
    0x3E5B: 'ráo,rǎo',  # 㹛
    0x3E5C: 'yín',  # 㹜
    0x3E5D: 'shì',  # 㹝
    0x3E5E: 'yín,yǐn',  # 㹞
    0x3E5F: 'jué',  # 㹟
    0x3E60: 'tún',  # 㹠
    0x3E61: 'xuán,xuàn',  # 㹡
    # 0x3E62: '',  # 㹢
    0x3E63: 'zhōng',  # 㹣
    0x3E64: 'qiè,què',  # 㹤
    0x3E65: 'zhù',  # 㹥
    # 0x3E66: '',  # 㹦
    # 0x3E67: '',  # 㹧
    0x3E68: 'yòu',  # 㹨
    # 0x3E69: '',  # 㹩
    # 0x3E6A: '',  # 㹪
    0x3E6B: 'xì,yí',  # 㹫
    0x3E6C: 'shǐ',  # 㹬
    0x3E6D: 'yì',  # 㹭
    0x3E6E: 'mò',  # 㹮
    # 0x3E6F: '',  # 㹯
    # 0x3E70: '',  # 㹰
    0x3E71: 'hú,què,rǎn',  # 㹱
    0x3E72: 'xiào',  # 㹲
    0x3E73: 'wú',  # 㹳
    # 0x3E74: '',  # 㹴
    0x3E75: 'jìng',  # 㹵
    0x3E76: 'tíng',  # 㹶
    0x3E77: 'shǐ,xìn',  # 㹷
    0x3E78: 'ní',  # 㹸
    # 0x3E79: '',  # 㹹
    0x3E7A: 'tà',  # 㹺
    # 0x3E7B: '',  # 㹻
    0x3E7C: 'chǔ,jú,yù',  # 㹼
    0x3E7D: 'chǎn,shàn',  # 㹽
    0x3E7E: 'piǎo',  # 㹾
    0x3E7F: 'diǎo,zhào,zhuó',  # 㹿
    0x3E80: 'náo',  # 㺀
    0x3E81: 'nǎo',  # 㺁
    0x3E82: 'gǎn,jiàn,yán',  # 㺂
    0x3E83: 'gǒu',  # 㺃
    0x3E84: 'yǔ',  # 㺄
    0x3E85: 'hóu',  # 㺅
    # 0x3E86: '',  # 㺆
    0x3E87: 'sī',  # 㺇
    0x3E88: 'chī',  # 㺈
    0x3E89: 'hù',  # 㺉
    0x3E8A: 'yàng',  # 㺊
    # 0x3E8B: '',  # 㺋
    0x3E8C: 'xiàn',  # 㺌
    # 0x3E8D: '',  # 㺍
    0x3E8E: 'róng',  # 㺎
    0x3E8F: 'lóu',  # 㺏
    0x3E90: 'zhǎo',  # 㺐
    0x3E91: 'cán,shǎn',  # 㺑
    0x3E92: 'liào,yáo,xiāo',  # 㺒
    0x3E93: 'piào',  # 㺓
    0x3E94: 'hài,wèi',  # 㺔
    0x3E95: 'fán',  # 㺕
    0x3E96: 'hǎn',  # 㺖
    0x3E97: 'dàn,yán',  # 㺗
    0x3E98: 'zhàn',  # 㺘
    # 0x3E99: '',  # 㺙
    0x3E9A: 'tǎ',  # 㺚
    0x3E9B: 'zhù',  # 㺛
    0x3E9C: 'nóng',  # 㺜
    0x3E9D: 'jiàn',  # 㺝
    0x3E9E: 'yú',  # 㺞
    0x3E9F: 'zhuó',  # 㺟
    0x3EA0: 'yòu,yù',  # 㺠
    0x3EA1: 'lì',  # 㺡
    # 0x3EA2: '',  # 㺢
    0x3EA3: 'xī',  # 㺣
    # 0x3EA4: '',  # 㺤
    0x3EA5: 'chán,tán',  # 㺥
    0x3EA6: 'lián',  # 㺦
    # 0x3EA7: '',  # 㺧
    0x3EA8: 'sī',  # 㺨
    0x3EA9: 'jiù,sè',  # 㺩
    0x3EAA: 'pú',  # 㺪
    0x3EAB: 'qiú',  # 㺫
    0x3EAC: 'gǒng',  # 㺬
    0x3EAD: 'zǐ',  # 㺭
    0x3EAE: 'yú',  # 㺮
    # 0x3EAF: '',  # 㺯
    # 0x3EB0: '',  # 㺰
    0x3EB1: 'réng',  # 㺱
    0x3EB2: 'niǔ',  # 㺲
    0x3EB3: 'méi',  # 㺳
    # 0x3EB4: '',  # 㺴
    0x3EB5: 'jiú',  # 㺵
    # 0x3EB6: '',  # 㺶
    0x3EB7: 'xù',  # 㺷
    0x3EB8: 'píng',  # 㺸
    0x3EB9: 'biàn',  # 㺹
    0x3EBA: 'mào',  # 㺺
    # 0x3EBB: '',  # 㺻
    # 0x3EBC: '',  # 㺼
    # 0x3EBD: '',  # 㺽
    # 0x3EBE: '',  # 㺾
    0x3EBF: 'yí',  # 㺿
    0x3EC0: 'yóu,yú',  # 㻀
    # 0x3EC1: '',  # 㻁
    0x3EC2: 'píng',  # 㻂
    0x3EC3: 'qū',  # 㻃
    0x3EC4: 'bǎo',  # 㻄
    0x3EC5: 'huì,kuài',  # 㻅
    # 0x3EC6: '',  # 㻆
    # 0x3EC7: '',  # 㻇
    # 0x3EC8: '',  # 㻈
    0x3EC9: 'bù',  # 㻉
    0x3ECA: 'máng,mén,mèng',  # 㻊
    0x3ECB: 'là,lèi',  # 㻋
    0x3ECC: 'tú',  # 㻌
    0x3ECD: 'wú',  # 㻍
    0x3ECE: 'lì,sè',  # 㻎
    0x3ECF: 'líng,lǐng',  # 㻏
    # 0x3ED0: '',  # 㻐
    0x3ED1: 'jì',  # 㻑
    0x3ED2: 'jùn',  # 㻒
    # 0x3ED3: '',  # 㻓
    0x3ED4: 'duǒ,ruì',  # 㻔
    0x3ED5: 'jué',  # 㻕
    0x3ED6: 'dài',  # 㻖
    0x3ED7: 'bèi',  # 㻗
    # 0x3ED8: '',  # 㻘
    # 0x3ED9: '',  # 㻙
    # 0x3EDA: '',  # 㻚
    # 0x3EDB: '',  # 㻛
    # 0x3EDC: '',  # 㻜
    0x3EDD: 'là',  # 㻝
    0x3EDE: 'biàn,fèn,pìn',  # 㻞
    0x3EDF: 'suí',  # 㻟
    0x3EE0: 'tú',  # 㻠
    0x3EE1: 'dié,jué',  # 㻡
    # 0x3EE2: '',  # 㻢
    # 0x3EE3: '',  # 㻣
    # 0x3EE4: '',  # 㻤
    # 0x3EE5: '',  # 㻥
    # 0x3EE6: '',  # 㻦
    0x3EE7: 'duò,hé',  # 㻧
    # 0x3EE8: '',  # 㻨
    # 0x3EE9: '',  # 㻩
    0x3EEA: 'suì',  # 㻪
    0x3EEB: 'bì',  # 㻫
    0x3EEC: 'tú',  # 㻬
    0x3EED: 'sè,zé',  # 㻭
    0x3EEE: 'càn',  # 㻮
    0x3EEF: 'tú',  # 㻯
    0x3EF0: 'miǎn,rè,wèi,yù',  # 㻰
    # 0x3EF1: '',  # 㻱
    # 0x3EF2: '',  # 㻲
    # 0x3EF3: '',  # 㻳
    # 0x3EF4: '',  # 㻴
    0x3EF5: 'zhàn',  # 㻵
    0x3EF6: 'bǐ,bì',  # 㻶
    0x3EF7: 'jí',  # 㻷
    0x3EF8: 'cén,jìn,xín,zēn',  # 㻸
    # 0x3EF9: '',  # 㻹
    0x3EFA: 'lì,liè',  # 㻺
    # 0x3EFB: '',  # 㻻
    # 0x3EFC: '',  # 㻼
    0x3EFD: 'suì',  # 㻽
    # 0x3EFE: '',  # 㻾
    0x3EFF: 'shǔ',  # 㻿
    # 0x3F00: '',  # 㼀
    # 0x3F01: '',  # 㼁
    0x3F02: 'é,wèn,yuǎn',  # 㼂
    # 0x3F03: '',  # 㼃
    # 0x3F04: '',  # 㼄
    # 0x3F05: '',  # 㼅
    0x3F06: 'yíng',  # 㼆
    0x3F07: 'qióng',  # 㼇
    0x3F08: 'luó',  # 㼈
    0x3F09: 'yìn,zhèn',  # 㼉
    0x3F0A: 'tún',  # 㼊
    0x3F0B: 'gǔ,jiǔ,móu,rǔ',  # 㼋
    0x3F0C: 'yǔ',  # 㼌
    0x3F0D: 'lěi',  # 㼍
    0x3F0E: 'bèi,bó,kě',  # 㼎
    0x3F0F: 'něi',  # 㼏
    0x3F10: 'pián',  # 㼐
    0x3F11: 'liàn,luán',  # 㼑
    0x3F12: 'qiǔ,tǎng',  # 㼒
    0x3F13: 'lián,liǎn',  # 㼓
    # 0x3F14: '',  # 㼔
    # 0x3F15: '',  # 㼕
    0x3F16: 'lì',  # 㼖
    0x3F17: 'dǐng,tíng',  # 㼗
    0x3F18: 'wǎ',  # 㼘
    0x3F19: 'zhòu',  # 㼙
    # 0x3F1A: '',  # 㼚
    0x3F1B: 'xíng',  # 㼛
    0x3F1C: 'àng,póu',  # 㼜
    0x3F1D: 'fàn,wǎn',  # 㼝
    0x3F1E: 'pèng',  # 㼞
    0x3F1F: 'bái',  # 㼟
    0x3F20: 'tuó',  # 㼠
    # 0x3F21: '',  # 㼡
    0x3F22: 'ě,yí',  # 㼢
    0x3F23: 'bǎi,bó',  # 㼣
    0x3F24: 'qì,qiè,yà',  # 㼤
    0x3F25: 'chú,kǎo,tǒu',  # 㼥
    0x3F26: 'gǒng',  # 㼦
    0x3F27: 'tóng',  # 㼧
    0x3F28: 'hán',  # 㼨
    0x3F29: 'chéng',  # 㼩
    0x3F2A: 'jiá',  # 㼪
    0x3F2B: 'huàn',  # 㼫
    0x3F2C: 'xìng',  # 㼬
    0x3F2D: 'diàn,niǎo',  # 㼭
    0x3F2E: 'chāi,qì',  # 㼮
    0x3F2F: 'dòng',  # 㼯
    0x3F30: 'é,pí',  # 㼰
    0x3F31: 'ruǎn',  # 㼱
    0x3F32: 'liè',  # 㼲
    0x3F33: 'shěng',  # 㼳
    0x3F34: 'ǒu',  # 㼴
    0x3F35: 'dì',  # 㼵
    0x3F36: 'yú',  # 㼶
    0x3F37: 'chuán',  # 㼷
    0x3F38: 'róng',  # 㼸
    # 0x3F39: '',  # 㼹
    0x3F3A: 'táng',  # 㼺
    0x3F3B: 'cóng',  # 㼻
    0x3F3C: 'piáo',  # 㼼
    0x3F3D: 'shuǎng,chuǎng',  # 㼽
    0x3F3E: 'lù',  # 㼾
    0x3F3F: 'tóng',  # 㼿
    0x3F40: 'zhèng',  # 㽀
    0x3F41: 'lì',  # 㽁
    0x3F42: 'sà',  # 㽂
    # 0x3F43: '',  # 㽃
    # 0x3F44: '',  # 㽄
    # 0x3F45: '',  # 㽅
    # 0x3F46: '',  # 㽆
    0x3F47: 'guài,hú,huí,méng,sè',  # 㽇
    0x3F48: 'yì',  # 㽈
    0x3F49: 'hǎn,jiàn,xiàn',  # 㽉
    0x3F4A: 'xiè',  # 㽊
    0x3F4B: 'luó,luò',  # 㽋
    0x3F4C: 'liù',  # 㽌
    # 0x3F4D: '',  # 㽍
    0x3F4E: 'dǎn,tán',  # 㽎
    0x3F4F: 'gàn',  # 㽏
    # 0x3F50: '',  # 㽐
    0x3F51: 'tán',  # 㽑
    # 0x3F52: '',  # 㽒
    # 0x3F53: '',  # 㽓
    # 0x3F54: '',  # 㽔
    0x3F55: 'yóu',  # 㽕
    0x3F56: 'nán',  # 㽖
    # 0x3F57: '',  # 㽗
    0x3F58: 'gǎng',  # 㽘
    0x3F59: 'jùn',  # 㽙
    0x3F5A: 'chì',  # 㽚
    0x3F5B: 'gōu,qú',  # 㽛
    0x3F5C: 'wǎn',  # 㽜
    0x3F5D: 'lì',  # 㽝
    0x3F5E: 'liú',  # 㽞
    0x3F5F: 'liè',  # 㽟
    0x3F60: 'xiá',  # 㽠
    0x3F61: 'bēi',  # 㽡
    0x3F62: 'ǎn,yè',  # 㽢
    0x3F63: 'yù',  # 㽣
    0x3F64: 'jú',  # 㽤
    0x3F65: 'róu',  # 㽥
    0x3F66: 'xún',  # 㽦
    # 0x3F67: '',  # 㽧
    0x3F68: 'cuó',  # 㽨
    0x3F69: 'càn,cào',  # 㽩
    0x3F6A: 'zěng,zhǎ',  # 㽪
    0x3F6B: 'yǒng',  # 㽫
    0x3F6C: 'fù',  # 㽬
    0x3F6D: 'ruǎn',  # 㽭
    # 0x3F6E: '',  # 㽮
    0x3F6F: 'xí',  # 㽯
    0x3F70: 'shù',  # 㽰
    0x3F71: 'jiǎo,jiū,niú',  # 㽱
    0x3F72: 'jiǎo',  # 㽲
    0x3F73: 'hàn,xiè,xǔ,yú',  # 㽳
    0x3F74: 'zhàng',  # 㽴
    # 0x3F75: '',  # 㽵
    # 0x3F76: '',  # 㽶
    0x3F77: 'shuì',  # 㽷
    0x3F78: 'chén',  # 㽸
    0x3F79: 'fàn,wǎn',  # 㽹
    0x3F7A: 'jí',  # 㽺
    # 0x3F7B: '',  # 㽻
    # 0x3F7C: '',  # 㽼
    0x3F7D: 'gù',  # 㽽
    0x3F7E: 'wù',  # 㽾
    # 0x3F7F: '',  # 㽿
    0x3F80: 'qiè',  # 㾀
    0x3F81: 'shù',  # 㾁
    # 0x3F82: '',  # 㾂
    0x3F83: 'tuó',  # 㾃
    0x3F84: 'dú',  # 㾄
    0x3F85: 'zǐ',  # 㾅
    0x3F86: 'rán,shǎn',  # 㾆
    0x3F87: 'mù',  # 㾇
    0x3F88: 'fù',  # 㾈
    0x3F89: 'líng',  # 㾉
    0x3F8A: 'jí',  # 㾊
    0x3F8B: 'xiù',  # 㾋
    0x3F8C: 'xuǎn',  # 㾌
    0x3F8D: 'nái',  # 㾍
    # 0x3F8E: '',  # 㾎
    0x3F8F: 'jiè',  # 㾏
    0x3F90: 'lì',  # 㾐
    0x3F91: 'dá',  # 㾑
    0x3F92: 'jì,rú,rù',  # 㾒
    0x3F93: 'yùn',  # 㾓
    # 0x3F94: '',  # 㾔
    0x3F95: 'shěn',  # 㾕
    0x3F96: 'lǐ,luó',  # 㾖
    0x3F97: 'lǎng,liàng',  # 㾗
    0x3F98: 'gěng',  # 㾘
    0x3F99: 'yǐn',  # 㾙
    # 0x3F9A: '',  # 㾚
    0x3F9B: 'qǐn',  # 㾛
    0x3F9C: 'qiè',  # 㾜
    0x3F9D: 'chè',  # 㾝
    0x3F9E: 'yǒu',  # 㾞
    0x3F9F: 'bù',  # 㾟
    0x3FA0: 'huáng,kuáng,kuì',  # 㾠
    0x3FA1: 'què',  # 㾡
    0x3FA2: 'lài',  # 㾢
    # 0x3FA3: '',  # 㾣
    # 0x3FA4: '',  # 㾤
    0x3FA5: 'xù',  # 㾥
    0x3FA6: 'bàng,pèi,pén',  # 㾦
    0x3FA7: 'kè',  # 㾧
    0x3FA8: 'qǐ,yǐ',  # 㾨
    # 0x3FA9: '',  # 㾩
    0x3FAA: 'shěng',  # 㾪
    0x3FAB: 'piān',  # 㾫
    # 0x3FAC: '',  # 㾬
    0x3FAD: 'zhòu',  # 㾭
    0x3FAE: 'huáng',  # 㾮
    0x3FAF: 'tuí,wěi',  # 㾯
    0x3FB0: 'hú',  # 㾰
    0x3FB1: 'bèi,fàn,fèi,fú',  # 㾱
    # 0x3FB2: '',  # 㾲
    # 0x3FB3: '',  # 㾳
    # 0x3FB4: '',  # 㾴
    0x3FB5: 'jì',  # 㾵
    0x3FB6: 'gǔ',  # 㾶
    # 0x3FB7: '',  # 㾷
    0x3FB8: 'gǎo',  # 㾸
    0x3FB9: 'chái',  # 㾹
    0x3FBA: 'mà,mò',  # 㾺
    0x3FBB: 'zhù',  # 㾻
    0x3FBC: 'tuǐ',  # 㾼
    0x3FBD: 'tuí,zhuì',  # 㾽
    0x3FBE: 'lián',  # 㾾
    0x3FBF: 'láng,lǎng',  # 㾿
    # 0x3FC0: '',  # 㿀
    # 0x3FC1: '',  # 㿁
    # 0x3FC2: '',  # 㿂
    0x3FC3: 'dài,zhì',  # 㿃
    0x3FC4: 'ài',  # 㿄
    0x3FC5: 'xiǎn,xuǎn',  # 㿅
    # 0x3FC6: '',  # 㿆
    0x3FC7: 'xí,xì',  # 㿇
    # 0x3FC8: '',  # 㿈
    0x3FC9: 'tuí',  # 㿉
    0x3FCA: 'cǎn',  # 㿊
    0x3FCB: 'sào',  # 㿋
    # 0x3FCC: '',  # 㿌
    0x3FCD: 'jiè',  # 㿍
    0x3FCE: 'fèn',  # 㿎
    0x3FCF: 'qún',  # 㿏
    # 0x3FD0: '',  # 㿐
    0x3FD1: 'yào',  # 㿑
    0x3FD2: 'dǎo',  # 㿒
    0x3FD3: 'jiá',  # 㿓
    0x3FD4: 'lěi',  # 㿔
    0x3FD5: 'yán',  # 㿕
    0x3FD6: 'lú',  # 㿖
    0x3FD7: 'tuí',  # 㿗
    0x3FD8: 'yíng',  # 㿘
    0x3FD9: 'pì',  # 㿙
    0x3FDA: 'luò',  # 㿚
    0x3FDB: 'lí,lì',  # 㿛
    0x3FDC: 'biě',  # 㿜
    # 0x3FDD: '',  # 㿝
    0x3FDE: 'mào',  # 㿞
    0x3FDF: 'bái,jiǎo',  # 㿟
    0x3FE0: 'huàng',  # 㿠
    # 0x3FE1: '',  # 㿡
    0x3FE2: 'yào,zhuì',  # 㿢
    0x3FE3: 'hé,xiá',  # 㿣
    0x3FE4: 'chǔn',  # 㿤
    0x3FE5: 'hú,hé',  # 㿥
    0x3FE6: 'nìng',  # 㿦
    0x3FE7: 'chóu',  # 㿧
    0x3FE8: 'lì',  # 㿨
    0x3FE9: 'tǎng',  # 㿩
    0x3FEA: 'huán',  # 㿪
    0x3FEB: 'bì',  # 㿫
    # 0x3FEC: '',  # 㿬
    0x3FED: 'chè',  # 㿭
    0x3FEE: 'yàng',  # 㿮
    0x3FEF: 'dá',  # 㿯
    0x3FF0: 'áo',  # 㿰
    0x3FF1: 'xué',  # 㿱
    # 0x3FF2: '',  # 㿲
    # 0x3FF3: '',  # 㿳
    # 0x3FF4: '',  # 㿴
    0x3FF5: 'rǎn',  # 㿵
    # 0x3FF6: '',  # 㿶
    0x3FF7: 'cuó,cāo',  # 㿷
    0x3FF8: 'wǎn,mán',  # 㿸
    0x3FF9: 'tà',  # 㿹
    0x3FFA: 'báo',  # 㿺
    # 0x3FFB: '',  # 㿻
    0x3FFC: 'yán',  # 㿼
    # 0x3FFD: '',  # 㿽
    0x3FFE: 'zhù',  # 㿾
    0x3FFF: 'yǎ',  # 㿿
    0x4000: 'fán',  # 䀀
    0x4001: 'yòu',  # 䀁
    # 0x4002: '',  # 䀂
    0x4003: 'tuí',  # 䀃
    0x4004: 'méng',  # 䀄
    0x4005: 'shè,zhé',  # 䀅
    0x4006: 'jìn',  # 䀆
    0x4007: 'gǔ,què',  # 䀇
    0x4008: 'qì',  # 䀈
    0x4009: 'qiáo,shà',  # 䀉
    0x400A: 'jiǎo',  # 䀊
    0x400B: 'yán',  # 䀋
    # 0x400C: '',  # 䀌
    0x400D: 'kàn',  # 䀍
    0x400E: 'miǎn',  # 䀎
    0x400F: 'xiàn,xuàn',  # 䀏
    0x4010: 'sǎn',  # 䀐
    0x4011: 'nà,nì,wò',  # 䀑
    # 0x4012: '',  # 䀒
    0x4013: 'huàn',  # 䀓
    0x4014: 'niú,rèn',  # 䀔
    0x4015: 'chèng,zhèn',  # 䀕
    # 0x4016: '',  # 䀖
    0x4017: 'jué',  # 䀗
    0x4018: 'xí,xié',  # 䀘
    0x4019: 'qì',  # 䀙
    0x401A: 'áng',  # 䀚
    0x401B: 'mèi,wù',  # 䀛
    0x401C: 'gǔ,mèi,xué',  # 䀜
    # 0x401D: '',  # 䀝
    # 0x401E: '',  # 䀞
    0x401F: 'fán,fèi,fèn',  # 䀟
    0x4020: 'qú,jù',  # 䀠
    0x4021: 'chàn,tàn',  # 䀡
    0x4022: 'shùn',  # 䀢
    0x4023: 'bì,mà',  # 䀣
    0x4024: 'mào',  # 䀤
    0x4025: 'shuò',  # 䀥
    0x4026: 'gǔ',  # 䀦
    0x4027: 'hǒng',  # 䀧
    0x4028: 'huàn',  # 䀨
    0x4029: 'luò',  # 䀩
    0x402A: 'háng',  # 䀪
    0x402B: 'jiá',  # 䀫
    0x402C: 'quán',  # 䀬
    0x402D: 'gāi',  # 䀭
    0x402E: 'máng',  # 䀮
    0x402F: 'bǔ',  # 䀯
    0x4030: 'gǔ,yíng',  # 䀰
    # 0x4031: '',  # 䀱
    0x4032: 'mù',  # 䀲
    0x4033: 'ài,là,lài',  # 䀳
    0x4034: 'yǐng',  # 䀴
    0x4035: 'shùn',  # 䀵
    0x4036: 'lǎng,liàng',  # 䀶
    0x4037: 'jié',  # 䀷
    0x4038: 'dì,zhì',  # 䀸
    0x4039: 'jiá,shè,jié',  # 䀹
    0x403A: 'chōu',  # 䀺
    0x403B: 'pìn',  # 䀻
    0x403C: 'rèn,zhěn',  # 䀼
    0x403D: 'yán',  # 䀽
    0x403E: 'dǔ',  # 䀾
    0x403F: 'dì',  # 䀿
    # 0x4040: '',  # 䁀
    0x4041: 'lǎng,liàng',  # 䁁
    0x4042: 'xiàn',  # 䁂
    # 0x4043: '',  # 䁃
    0x4044: 'xìng',  # 䁄
    0x4045: 'bèi,bì,měng,mèng',  # 䁅
    0x4046: 'ǎn,yì',  # 䁆
    0x4047: 'mì',  # 䁇
    0x4048: 'qì',  # 䁈
    0x4049: 'qì',  # 䁉
    0x404A: 'wò',  # 䁊
    0x404B: 'shé',  # 䁋
    0x404C: 'yù',  # 䁌
    0x404D: 'jià,kè,qià',  # 䁍
    0x404E: 'chéng',  # 䁎
    0x404F: 'yǎo',  # 䁏
    0x4050: 'yìng',  # 䁐
    0x4051: 'yáng',  # 䁑
    0x4052: 'jí',  # 䁒
    0x4053: 'jiè,zǒng',  # 䁓
    0x4054: 'hàn,huǎn,xuān',  # 䁔
    0x4055: 'mín',  # 䁕
    0x4056: 'lōu',  # 䁖
    0x4057: 'kǎi',  # 䁗
    0x4058: 'yǎo',  # 䁘
    0x4059: 'yǎn,yàn',  # 䁙
    0x405A: 'sǔn',  # 䁚
    0x405B: 'guǐ,guì,kuì',  # 䁛
    0x405C: 'huǎng,huàng',  # 䁜
    0x405D: 'yíng',  # 䁝
    0x405E: 'shěng',  # 䁞
    0x405F: 'chá,duó',  # 䁟
    0x4060: 'lián',  # 䁠
    # 0x4061: '',  # 䁡
    0x4062: 'xuán',  # 䁢
    0x4063: 'chuán',  # 䁣
    0x4064: 'chè,chèng',  # 䁤
    0x4065: 'nì',  # 䁥
    0x4066: 'qù',  # 䁦
    0x4067: 'miáo',  # 䁧
    0x4068: 'huò',  # 䁨
    0x4069: 'yú',  # 䁩
    0x406A: 'nǎn,zhǎn',  # 䁪
    0x406B: 'hú',  # 䁫
    0x406C: 'céng',  # 䁬
    # 0x406D: '',  # 䁭
    0x406E: 'qián',  # 䁮
    0x406F: 'shè,xié',  # 䁯
    0x4070: 'jiǎng',  # 䁰
    0x4071: 'ào',  # 䁱
    0x4072: 'mái',  # 䁲
    0x4073: 'mǎng',  # 䁳
    0x4074: 'zhǎn',  # 䁴
    0x4075: 'biǎn',  # 䁵
    0x4076: 'jiǎo',  # 䁶
    0x4077: 'jué,wò',  # 䁷
    0x4078: 'nóng',  # 䁸
    0x4079: 'bì',  # 䁹
    0x407A: 'shì',  # 䁺
    0x407B: 'lì,shuò',  # 䁻
    0x407C: 'mò,mù',  # 䁼
    0x407D: 'liè',  # 䁽
    0x407E: 'miè',  # 䁾
    0x407F: 'mò',  # 䁿
    # 0x4080: '',  # 䂀
    0x4081: 'chán',  # 䂁
    0x4082: 'qú',  # 䂂
    0x4083: 'jiào,jié',  # 䂃
    0x4084: 'huò,kuàng',  # 䂄
    # 0x4085: '',  # 䂅
    0x4086: 'xù',  # 䂆
    0x4087: 'náng,niǔ,nǒng,páng',  # 䂇
    0x4088: 'tóng',  # 䂈
    0x4089: 'hóu',  # 䂉
    0x408A: 'yù',  # 䂊
    # 0x408B: '',  # 䂋
    # 0x408C: '',  # 䂌
    0x408D: 'bó',  # 䂍
    0x408E: 'zuǎn',  # 䂎
    # 0x408F: '',  # 䂏
    0x4090: 'chuò',  # 䂐
    # 0x4091: '',  # 䂑
    0x4092: 'jié,qià,yà',  # 䂒
    # 0x4093: '',  # 䂓
    0x4094: 'xìng',  # 䂔
    0x4095: 'huì',  # 䂕
    0x4096: 'shí,sì',  # 䂖
    # 0x4097: '',  # 䂗
    # 0x4098: '',  # 䂘
    # 0x4099: '',  # 䂙
    0x409A: 'yáo,yóu',  # 䂚
    0x409B: 'yú',  # 䂛
    0x409C: 'bàng,péi',  # 䂜
    0x409D: 'jié,zé,zhé',  # 䂝
    0x409E: 'zhè',  # 䂞
    # 0x409F: '',  # 䂟
    0x40A0: 'shé,shǐ',  # 䂠
    0x40A1: 'dǐ,zhǐ',  # 䂡
    0x40A2: 'dǒng',  # 䂢
    0x40A3: 'cí',  # 䂣
    0x40A4: 'fù,hái',  # 䂤
    0x40A5: 'mín',  # 䂥
    0x40A6: 'zhěn',  # 䂦
    0x40A7: 'zhěn',  # 䂧
    # 0x40A8: '',  # 䂨
    0x40A9: 'yàn',  # 䂩
    0x40AA: 'diào,tiǎo',  # 䂪
    0x40AB: 'hóng',  # 䂫
    0x40AC: 'gǒng',  # 䂬
    0x40AD: 'qiāo',  # 䂭
    # 0x40AE: '',  # 䂮
    0x40AF: 'guài,guàn',  # 䂯
    0x40B0: 'là',  # 䂰
    0x40B1: 'cuì,ruì',  # 䂱
    0x40B2: 'fǎ',  # 䂲
    0x40B3: 'cuǒ',  # 䂳
    0x40B4: 'yán',  # 䂴
    # 0x40B5: '',  # 䂵
    0x40B6: 'jié',  # 䂶
    # 0x40B7: '',  # 䂷
    0x40B8: 'guó,xù',  # 䂸
    0x40B9: 'suǒ',  # 䂹
    0x40BA: 'wǎn,wǒ',  # 䂺
    0x40BB: 'zhèng',  # 䂻
    0x40BC: 'niè',  # 䂼
    0x40BD: 'diào,yì',  # 䂽
    0x40BE: 'lǎi',  # 䂾
    0x40BF: 'tà,tiè',  # 䂿
    0x40C0: 'cuì,xùn',  # 䃀
    0x40C1: 'yā',  # 䃁
    0x40C2: 'gǔn,gùn',  # 䃂
    # 0x40C3: '',  # 䃃
    # 0x40C4: '',  # 䃄
    # 0x40C5: '',  # 䃅
    # 0x40C6: '',  # 䃆
    0x40C7: 'mián',  # 䃇
    0x40C8: 'jiē',  # 䃈
    0x40C9: 'mín',  # 䃉
    0x40CA: 'jǔ',  # 䃊
    0x40CB: 'yú',  # 䃋
    # 0x40CC: '',  # 䃌
    0x40CD: 'zhào,zhuì',  # 䃍
    0x40CE: 'zhǎ',  # 䃎
    # 0x40CF: '',  # 䃏
    # 0x40D0: '',  # 䃐
    0x40D1: 'pán',  # 䃑
    0x40D2: 'hé',  # 䃒
    0x40D3: 'gòu',  # 䃓
    0x40D4: 'hóng',  # 䃔
    0x40D5: 'láo,luò',  # 䃕
    0x40D6: 'wù',  # 䃖
    0x40D7: 'chuò',  # 䃗
    # 0x40D8: '',  # 䃘
    0x40D9: 'lù',  # 䃙
    0x40DA: 'cù',  # 䃚
    0x40DB: 'lián,qiàn',  # 䃛
    # 0x40DC: '',  # 䃜
    0x40DD: 'qiào',  # 䃝
    0x40DE: 'shú,yì',  # 䃞
    # 0x40DF: '',  # 䃟
    # 0x40E0: '',  # 䃠
    0x40E1: 'cén',  # 䃡
    # 0x40E2: '',  # 䃢
    0x40E3: 'huǐ',  # 䃣
    0x40E4: 'sù',  # 䃤
    0x40E5: 'chuáng',  # 䃥
    # 0x40E6: '',  # 䃦
    0x40E7: 'lóng',  # 䃧
    # 0x40E8: '',  # 䃨
    0x40E9: 'náo',  # 䃩
    0x40EA: 'tán',  # 䃪
    0x40EB: 'dǎn',  # 䃫
    0x40EC: 'wěi',  # 䃬
    0x40ED: 'gǎn',  # 䃭
    0x40EE: 'dá',  # 䃮
    0x40EF: 'lì',  # 䃯
    # 0x40F0: '',  # 䃰
    0x40F1: 'xiàn',  # 䃱
    0x40F2: 'pán,pàn',  # 䃲
    0x40F3: 'là',  # 䃳
    # 0x40F4: '',  # 䃴
    0x40F5: 'niǎo',  # 䃵
    0x40F6: 'huái',  # 䃶
    0x40F7: 'yíng',  # 䃷
    0x40F8: 'xiàn',  # 䃸
    0x40F9: 'làn,lǎng',  # 䃹
    0x40FA: 'mó,mò',  # 䃺
    0x40FB: 'bà,pái',  # 䃻
    # 0x40FC: '',  # 䃼
    0x40FD: 'fú,guǐ,sì',  # 䃽
    0x40FE: 'bǐ',  # 䃾
    # 0x40FF: '',  # 䃿
    0x4100: 'huò',  # 䄀
    0x4101: 'yì',  # 䄁
    0x4102: 'liù',  # 䄂
    # 0x4103: '',  # 䄃
    # 0x4104: '',  # 䄄
    0x4105: 'juàn',  # 䄅
    0x4106: 'huó,kuò',  # 䄆
    0x4107: 'chéng',  # 䄇
    0x4108: 'dòu',  # 䄈
    0x4109: 'é',  # 䄉
    # 0x410A: '',  # 䄊
    0x410B: 'yǎn',  # 䄋
    0x410C: 'zhuì',  # 䄌
    0x410D: 'dù,duó,zhà',  # 䄍
    0x410E: 'qǐ',  # 䄎
    0x410F: 'yú,yāo',  # 䄏
    0x4110: 'quàn',  # 䄐
    0x4111: 'huó,kuò',  # 䄑
    0x4112: 'niè,rěn',  # 䄒
    0x4113: 'héng,huáng',  # 䄓
    0x4114: 'jǔ',  # 䄔
    0x4115: 'shè,shèn,tiǎn',  # 䄕
    # 0x4116: '',  # 䄖
    # 0x4117: '',  # 䄗
    0x4118: 'péng',  # 䄘
    0x4119: 'míng',  # 䄙
    0x411A: 'cáo',  # 䄚
    0x411B: 'lóu',  # 䄛
    0x411C: 'lí,chī ',  # 䄜
    0x411D: 'chǔn',  # 䄝
    # 0x411E: '',  # 䄞
    0x411F: 'cuì',  # 䄟
    0x4120: 'shàn',  # 䄠
    # 0x4121: '',  # 䄡
    0x4122: 'qí',  # 䄢
    # 0x4123: '',  # 䄣
    0x4124: 'lài,lán',  # 䄤
    0x4125: 'líng',  # 䄥
    0x4126: 'liǎo',  # 䄦
    0x4127: 'réng,rǒng',  # 䄧
    0x4128: 'yú,yǔ',  # 䄨
    0x4129: 'náo,yì',  # 䄩
    0x412A: 'chuò,diǎo',  # 䄪
    0x412B: 'qǐ',  # 䄫
    0x412C: 'yí',  # 䄬
    0x412D: 'nián',  # 䄭
    # 0x412E: '',  # 䄮
    0x412F: 'jiǎn,xiàn',  # 䄯
    0x4130: 'yá,zhá',  # 䄰
    # 0x4131: '',  # 䄱
    0x4132: 'chuí',  # 䄲
    # 0x4133: '',  # 䄳
    # 0x4134: '',  # 䄴
    # 0x4135: '',  # 䄵
    0x4136: 'bì',  # 䄶
    0x4137: 'dàn,diǎo,shí',  # 䄷
    0x4138: 'pò',  # 䄸
    0x4139: 'nián,tiǎn',  # 䄹
    0x413A: 'zhì',  # 䄺
    0x413B: 'cháo,táo,zhào',  # 䄻
    0x413C: 'tiǎn',  # 䄼
    0x413D: 'tiǎn',  # 䄽
    0x413E: 'ròu',  # 䄾
    0x413F: 'yì',  # 䄿
    0x4140: 'liè',  # 䅀
    0x4141: 'àn',  # 䅁
    0x4142: 'hé',  # 䅂
    0x4143: 'qióng',  # 䅃
    0x4144: 'lì',  # 䅄
    # 0x4145: '',  # 䅅
    0x4146: 'zì',  # 䅆
    0x4147: 'sù',  # 䅇
    0x4148: 'yuàn',  # 䅈
    0x4149: 'yà',  # 䅉
    0x414A: 'dù',  # 䅊
    0x414B: 'wǎn',  # 䅋
    0x414C: 'juān',  # 䅌
    0x414D: 'dòng,tǐng',  # 䅍
    0x414E: 'yǒu',  # 䅎
    0x414F: 'huì,wèi',  # 䅏
    0x4150: 'jiǎn,qián',  # 䅐
    0x4151: 'ruí,suí',  # 䅑
    0x4152: 'máng',  # 䅒
    0x4153: 'jǔ,qù',  # 䅓
    # 0x4154: '',  # 䅔
    # 0x4155: '',  # 䅕
    0x4156: 'ǎn',  # 䅖
    0x4157: 'suì',  # 䅗
    0x4158: 'lái',  # 䅘
    0x4159: 'hùn',  # 䅙
    0x415A: 'qiǎng,quǎn,zé',  # 䅚
    # 0x415B: '',  # 䅛
    0x415C: 'duò',  # 䅜
    # 0x415D: '',  # 䅝
    0x415E: 'nà,nài,nè',  # 䅞
    0x415F: 'cǎn',  # 䅟
    0x4160: 'tí',  # 䅠
    0x4161: 'xǔ',  # 䅡
    0x4162: 'jiù',  # 䅢
    0x4163: 'huáng',  # 䅣
    0x4164: 'qì',  # 䅤
    0x4165: 'jié',  # 䅥
    0x4166: 'máo',  # 䅦
    0x4167: 'yàn',  # 䅧
    # 0x4168: '',  # 䅨
    0x4169: 'zhǐ',  # 䅩
    0x416A: 'tuí',  # 䅪
    # 0x416B: '',  # 䅫
    0x416C: 'ài,yǎn,yè',  # 䅬
    0x416D: 'páng',  # 䅭
    0x416E: 'càng',  # 䅮
    0x416F: 'táng',  # 䅯
    0x4170: 'ěn',  # 䅰
    0x4171: 'hùn',  # 䅱
    0x4172: 'qí',  # 䅲
    0x4173: 'chú',  # 䅳
    0x4174: 'suǒ',  # 䅴
    0x4175: 'zhuó',  # 䅵
    0x4176: 'nòu,wǔ',  # 䅶
    0x4177: 'tú',  # 䅷
    0x4178: 'zú',  # 䅸
    0x4179: 'lóu,lǒu',  # 䅹
    0x417A: 'miǎo',  # 䅺
    0x417B: 'lí',  # 䅻
    0x417C: 'mán',  # 䅼
    0x417D: 'gǔ',  # 䅽
    0x417E: 'cén,qián,qín',  # 䅾
    0x417F: 'huá',  # 䅿
    0x4180: 'měi',  # 䆀
    # 0x4181: '',  # 䆁
    0x4182: 'lián,qiàn',  # 䆂
    0x4183: 'dǎo,dào',  # 䆃
    0x4184: 'shàn',  # 䆄
    0x4185: 'cí,jǐ,zī',  # 䆅
    # 0x4186: '',  # 䆆
    # 0x4187: '',  # 䆇
    0x4188: 'zhì',  # 䆈
    0x4189: 'bà',  # 䆉
    0x418A: 'cuì',  # 䆊
    # 0x418B: '',  # 䆋
    # 0x418C: '',  # 䆌
    0x418D: 'lóng',  # 䆍
    # 0x418E: '',  # 䆎
    0x418F: 'fèi',  # 䆏
    0x4190: 'guó',  # 䆐
    0x4191: 'chéng',  # 䆑
    0x4192: 'jiù',  # 䆒
    0x4193: 'è,ruǎn',  # 䆓
    # 0x4194: '',  # 䆔
    0x4195: 'jué,yuè',  # 䆕
    0x4196: 'hóng',  # 䆖
    0x4197: 'jiào',  # 䆗
    0x4198: 'cuán,yā',  # 䆘
    0x4199: 'yáo',  # 䆙
    0x419A: 'tóng',  # 䆚
    0x419B: 'chá,zhà,zhé',  # 䆛
    0x419C: 'yòu',  # 䆜
    0x419D: 'shù',  # 䆝
    0x419E: 'yǎo',  # 䆞
    0x419F: 'gé',  # 䆟
    0x41A0: 'huàn',  # 䆠
    0x41A1: 'láng,làng',  # 䆡
    0x41A2: 'jué,yuè',  # 䆢
    0x41A3: 'chén',  # 䆣
    # 0x41A4: '',  # 䆤
    # 0x41A5: '',  # 䆥
    0x41A6: 'shèn',  # 䆦
    # 0x41A7: '',  # 䆧
    0x41A8: 'míng',  # 䆨
    0x41A9: 'míng',  # 䆩
    # 0x41AA: '',  # 䆪
    # 0x41AB: '',  # 䆫
    0x41AC: 'yǔn',  # 䆬
    # 0x41AD: '',  # 䆭
    0x41AE: 'jìn',  # 䆮
    0x41AF: 'chuò,zhuó',  # 䆯
    # 0x41B0: '',  # 䆰
    0x41B1: 'tǎn',  # 䆱
    # 0x41B2: '',  # 䆲
    0x41B3: 'qióng,suì',  # 䆳
    # 0x41B4: '',  # 䆴
    0x41B5: 'chéng',  # 䆵
    # 0x41B6: '',  # 䆶
    0x41B7: 'yù,xuè',  # 䆷
    0x41B8: 'chéng',  # 䆸
    0x41B9: 'tǒng',  # 䆹
    # 0x41BA: '',  # 䆺
    0x41BB: 'qiào',  # 䆻
    # 0x41BC: '',  # 䆼
    0x41BD: 'jù,qú,qún',  # 䆽
    0x41BE: 'lán',  # 䆾
    0x41BF: 'yì',  # 䆿
    0x41C0: 'róng,rǒng',  # 䇀
    0x41C1: 'sī',  # 䇁
    0x41C2: 'qiān',  # 䇂
    0x41C3: 'sì,xiào',  # 䇃
    # 0x41C4: '',  # 䇄
    0x41C5: 'fá',  # 䇅
    # 0x41C6: '',  # 䇆
    0x41C7: 'méng',  # 䇇
    0x41C8: 'guì,huà',  # 䇈
    # 0x41C9: '',  # 䇉
    # 0x41CA: '',  # 䇊
    0x41CB: 'hài,rǎn,xiè',  # 䇋
    0x41CC: 'qiào',  # 䇌
    0x41CD: 'chuò',  # 䇍
    0x41CE: 'què',  # 䇎
    0x41CF: 'duì',  # 䇏
    0x41D0: 'lì',  # 䇐
    0x41D1: 'bà',  # 䇑
    0x41D2: 'jiè,qín,xiàn',  # 䇒
    # 0x41D3: '',  # 䇓
    0x41D4: 'luò,nuò',  # 䇔
    # 0x41D5: '',  # 䇕
    0x41D6: 'yǔn',  # 䇖
    # 0x41D7: '',  # 䇗
    0x41D8: 'hù',  # 䇘
    0x41D9: 'yǐn',  # 䇙
    # 0x41DA: '',  # 䇚
    0x41DB: 'zhǐ',  # 䇛
    0x41DC: 'liǎn',  # 䇜
    # 0x41DD: '',  # 䇝
    0x41DE: 'gǎn',  # 䇞
    0x41DF: 'jiàn',  # 䇟
    0x41E0: 'zhòu,zhù',  # 䇠
    0x41E1: 'zhù',  # 䇡
    0x41E2: 'kǔ',  # 䇢
    0x41E3: 'nà,nèi,yǐ',  # 䇣
    0x41E4: 'duì,ruì,sù',  # 䇤
    0x41E5: 'zé,zuó',  # 䇥
    0x41E6: 'yǎng',  # 䇦
    0x41E7: 'zhù',  # 䇧
    0x41E8: 'gòng,xiáng',  # 䇨
    0x41E9: 'yì',  # 䇩
    0x41EA: 'chī',  # 䇪
    0x41EB: 'jī',  # 䇫
    0x41EC: 'chuǎng,zhū',  # 䇬
    0x41ED: 'lǎo',  # 䇭
    0x41EE: 'rèn',  # 䇮
    0x41EF: 'róng',  # 䇯
    # 0x41F0: '',  # 䇰
    0x41F1: 'nà',  # 䇱
    0x41F2: 'cè,jiā',  # 䇲
    # 0x41F3: '',  # 䇳
    # 0x41F4: '',  # 䇴
    0x41F5: 'yí',  # 䇵
    0x41F6: 'jué',  # 䇶
    0x41F7: 'bǐ,bié',  # 䇷
    0x41F8: 'chéng,shèng,zèng',  # 䇸
    0x41F9: 'jùn',  # 䇹
    0x41FA: 'chóu,dòu',  # 䇺
    0x41FB: 'huì,kuì,wěi',  # 䇻
    0x41FC: 'chì,yì',  # 䇼
    0x41FD: 'zhì',  # 䇽
    0x41FE: 'yán',  # 䇾
    # 0x41FF: '',  # 䇿
    # 0x4200: '',  # 䈀
    0x4201: 'lún,luò',  # 䈁
    0x4202: 'bìng,píng',  # 䈂
    0x4203: 'zhǎo',  # 䈃
    0x4204: 'hán',  # 䈄
    0x4205: 'yù',  # 䈅
    0x4206: 'dài',  # 䈆
    0x4207: 'zhào',  # 䈇
    0x4208: 'féi',  # 䈈
    0x4209: 'shà',  # 䈉
    0x420A: 'líng',  # 䈊
    0x420B: 'tà',  # 䈋
    # 0x420C: '',  # 䈌
    0x420D: 'máng',  # 䈍
    0x420E: 'yè',  # 䈎
    0x420F: 'báo',  # 䈏
    0x4210: 'kuì',  # 䈐
    0x4211: 'guǎ,jué',  # 䈑
    0x4212: 'nǎn',  # 䈒
    0x4213: 'gé',  # 䈓
    # 0x4214: '',  # 䈔
    0x4215: 'chí,shi,tí,shí',  # 䈕
    # 0x4216: '',  # 䈖
    0x4217: 'suǒ',  # 䈗
    0x4218: 'cí',  # 䈘
    0x4219: 'zhòu',  # 䈙
    0x421A: 'tái',  # 䈚
    0x421B: 'kuài',  # 䈛
    0x421C: 'qìn',  # 䈜
    # 0x421D: '',  # 䈝
    0x421E: 'dǔ',  # 䈞
    0x421F: 'cè',  # 䈟
    0x4220: 'huǎn',  # 䈠
    # 0x4221: '',  # 䈡
    0x4222: 'sǎi',  # 䈢
    0x4223: 'zhèng',  # 䈣
    0x4224: 'qián',  # 䈤
    # 0x4225: '',  # 䈥
    # 0x4226: '',  # 䈦
    0x4227: 'wěi',  # 䈧
    # 0x4228: '',  # 䈨
    # 0x4229: '',  # 䈩
    0x422A: 'xì',  # 䈪
    0x422B: 'nà',  # 䈫
    0x422C: 'pú',  # 䈬
    0x422D: 'huái',  # 䈭
    0x422E: 'jǔ,jù,wǎn',  # 䈮
    # 0x422F: '',  # 䈯
    0x4230: 'shāo',  # 䈰
    # 0x4231: '',  # 䈱
    0x4232: 'pán',  # 䈲
    0x4233: 'tà',  # 䈳
    0x4234: 'qiàn,zhǎn',  # 䈴
    0x4235: 'wēng',  # 䈵
    0x4236: 'róng',  # 䈶
    0x4237: 'luò',  # 䈷
    0x4238: 'hú',  # 䈸
    0x4239: 'sǒu',  # 䈹
    # 0x423A: '',  # 䈺
    0x423B: 'pú',  # 䈻
    0x423C: 'miè,mì',  # 䈼
    # 0x423D: '',  # 䈽
    0x423E: 'shāo,shuò',  # 䈾
    0x423F: 'mài,mì',  # 䈿
    0x4240: 'shù',  # 䉀
    0x4241: 'líng',  # 䉁
    0x4242: 'lěi',  # 䉂
    0x4243: 'jiǎng',  # 䉃
    0x4244: 'léng',  # 䉄
    0x4245: 'zhì',  # 䉅
    0x4246: 'diǎo',  # 䉆
    # 0x4247: '',  # 䉇
    0x4248: 'sǎn',  # 䉈
    0x4249: 'hú',  # 䉉
    0x424A: 'fàn,fáng',  # 䉊
    0x424B: 'mèi',  # 䉋
    0x424C: 'suì',  # 䉌
    0x424D: 'jiǎn',  # 䉍
    0x424E: 'táng',  # 䉎
    0x424F: 'xiè',  # 䉏
    # 0x4250: '',  # 䉐
    0x4251: 'mó,wú',  # 䉑
    0x4252: 'fán',  # 䉒
    0x4253: 'léi,luò',  # 䉓
    # 0x4254: '',  # 䉔
    0x4255: 'céng',  # 䉕
    0x4256: 'líng',  # 䉖
    # 0x4257: '',  # 䉗
    0x4258: 'cóng',  # 䉘
    0x4259: 'yún',  # 䉙
    0x425A: 'méng',  # 䉚
    0x425B: 'yù',  # 䉛
    0x425C: 'zhì',  # 䉜
    0x425D: 'qǐ',  # 䉝
    0x425E: 'dǎn',  # 䉞
    0x425F: 'huò',  # 䉟
    0x4260: 'wéi',  # 䉠
    0x4261: 'tán',  # 䉡
    0x4262: 'sè',  # 䉢
    0x4263: 'xiè',  # 䉣
    0x4264: 'sǒu',  # 䉤
    0x4265: 'sǒng',  # 䉥
    # 0x4266: '',  # 䉦
    0x4267: 'liú,liǔ',  # 䉧
    0x4268: 'yì',  # 䉨
    # 0x4269: '',  # 䉩
    0x426A: 'lèi',  # 䉪
    0x426B: 'lí',  # 䉫
    0x426C: 'fèi',  # 䉬
    0x426D: 'liè',  # 䉭
    0x426E: 'lìn',  # 䉮
    0x426F: 'xiàn',  # 䉯
    0x4270: 'yáo',  # 䉰
    # 0x4271: '',  # 䉱
    0x4272: 'biè,mí',  # 䉲
    0x4273: 'xiǎn',  # 䉳
    0x4274: 'ráng,rǎng',  # 䉴
    0x4275: 'zhuàn',  # 䉵
    # 0x4276: '',  # 䉶
    0x4277: 'dàn,jìn,yán',  # 䉷
    0x4278: 'biàn',  # 䉸
    0x4279: 'líng,liǔ',  # 䉹
    0x427A: 'hóng',  # 䉺
    0x427B: 'qí',  # 䉻
    0x427C: 'liào',  # 䉼
    0x427D: 'bǎn',  # 䉽
    0x427E: 'mì,bì',  # 䉾
    0x427F: 'hú,luò',  # 䉿
    0x4280: 'hú',  # 䊀
    # 0x4281: '',  # 䊁
    0x4282: 'cè,sè',  # 䊂
    0x4283: 'pèi',  # 䊃
    0x4284: 'qióng',  # 䊄
    0x4285: 'míng',  # 䊅
    0x4286: 'jiù,qiǔ',  # 䊆
    0x4287: 'bù',  # 䊇
    0x4288: 'méi',  # 䊈
    0x4289: 'sǎn',  # 䊉
    0x428A: 'mèi',  # 䊊
    # 0x428B: '',  # 䊋
    # 0x428C: '',  # 䊌
    0x428D: 'lí',  # 䊍
    0x428E: 'quǎn',  # 䊎
    # 0x428F: '',  # 䊏
    0x4290: 'èn,huá,huàn,hún',  # 䊐
    0x4291: 'xiǎng',  # 䊑
    # 0x4292: '',  # 䊒
    0x4293: 'shì',  # 䊓
    # 0x4294: '',  # 䊔
    # 0x4295: '',  # 䊕
    0x4296: 'lǎn,nǎn',  # 䊖
    0x4297: 'huáng,huǎng',  # 䊗
    0x4298: 'jiù',  # 䊘
    0x4299: 'yán',  # 䊙
    0x429A: 'duī',  # 䊚
    0x429B: 'sǎ',  # 䊛
    0x429C: 'tuán',  # 䊜
    0x429D: 'xiè',  # 䊝
    0x429E: 'zhé',  # 䊞
    0x429F: 'mén',  # 䊟
    0x42A0: 'xì',  # 䊠
    0x42A1: 'mán',  # 䊡
    # 0x42A2: '',  # 䊢
    0x42A3: 'huáng',  # 䊣
    0x42A4: 'tán',  # 䊤
    0x42A5: 'xiào',  # 䊥
    0x42A6: 'yá,yè',  # 䊦
    0x42A7: 'bì',  # 䊧
    0x42A8: 'luó',  # 䊨
    0x42A9: 'fán,fàn',  # 䊩
    0x42AA: 'lì',  # 䊪
    0x42AB: 'cuǐ,mí',  # 䊫
    0x42AC: 'chà',  # 䊬
    0x42AD: 'chóu,dào',  # 䊭
    0x42AE: 'dí,zhé,zhè',  # 䊮
    0x42AF: 'kuàng',  # 䊯
    0x42B0: 'chǔ',  # 䊰
    # 0x42B1: '',  # 䊱
    0x42B2: 'chǎn',  # 䊲
    0x42B3: 'mí',  # 䊳
    0x42B4: 'qiàn',  # 䊴
    0x42B5: 'qiú',  # 䊵
    0x42B6: 'zhèn',  # 䊶
    # 0x42B7: '',  # 䊷
    # 0x42B8: '',  # 䊸
    # 0x42B9: '',  # 䊹
    0x42BA: 'gǔ,hù',  # 䊺
    0x42BB: 'yǎn',  # 䊻
    0x42BC: 'chǐ',  # 䊼
    0x42BD: 'guài',  # 䊽
    0x42BE: 'mù',  # 䊾
    0x42BF: 'bó,kù',  # 䊿
    0x42C0: 'kuà,huà',  # 䋀
    0x42C1: 'gěng',  # 䋁
    0x42C2: 'yáo',  # 䋂
    0x42C3: 'mào',  # 䋃
    0x42C4: 'wǎng',  # 䋄
    # 0x42C5: '',  # 䋅
    # 0x42C6: '',  # 䋆
    # 0x42C7: '',  # 䋇
    0x42C8: 'rú',  # 䋈
    0x42C9: 'jué,kě,xué',  # 䋉
    0x42CA: 'zhēng',  # 䋊
    0x42CB: 'mín',  # 䋋
    0x42CC: 'jiǎng',  # 䋌
    # 0x42CD: '',  # 䋍
    0x42CE: 'zhàn',  # 䋎
    0x42CF: 'zuò',  # 䋏
    0x42D0: 'yuè',  # 䋐
    0x42D1: 'bǐng',  # 䋑
    # 0x42D2: '',  # 䋒
    0x42D3: 'zhòu',  # 䋓
    0x42D4: 'bì',  # 䋔
    0x42D5: 'rèn',  # 䋕
    0x42D6: 'yù',  # 䋖
    # 0x42D7: '',  # 䋗
    0x42D8: 'chuò,zhuì',  # 䋘
    0x42D9: 'ěr',  # 䋙
    0x42DA: 'yì',  # 䋚
    0x42DB: 'mí,mǐ',  # 䋛
    0x42DC: 'qìng',  # 䋜
    # 0x42DD: '',  # 䋝
    0x42DE: 'wǎng',  # 䋞
    0x42DF: 'jì',  # 䋟
    0x42E0: 'bǔ',  # 䋠
    # 0x42E1: '',  # 䋡
    0x42E2: 'biè,biē',  # 䋢
    0x42E3: 'fán,pán',  # 䋣
    0x42E4: 'yào,yuè',  # 䋤
    0x42E5: 'lí',  # 䋥
    0x42E6: 'fán',  # 䋦
    0x42E7: 'qú',  # 䋧
    0x42E8: 'fǔ',  # 䋨
    0x42E9: 'ér',  # 䋩
    # 0x42EA: '',  # 䋪
    0x42EB: 'zhēng',  # 䋫
    # 0x42EC: '',  # 䋬
    0x42ED: 'huò,yù',  # 䋭
    0x42EE: 'jìn,qián',  # 䋮
    0x42EF: 'qǐ,qìng',  # 䋯
    0x42F0: 'jú',  # 䋰
    0x42F1: 'lái',  # 䋱
    0x42F2: 'chě,shéng,xǐng,zhè',  # 䋲
    0x42F3: 'bèi,mì',  # 䋳
    0x42F4: 'niù,rǒng,róu,rǔ',  # 䋴
    0x42F5: 'yì',  # 䋵
    0x42F6: 'xù',  # 䋶
    0x42F7: 'liú,móu',  # 䋷
    0x42F8: 'xún',  # 䋸
    0x42F9: 'fú,fù',  # 䋹
    # 0x42FA: '',  # 䋺
    0x42FB: 'nín',  # 䋻
    0x42FC: 'tǐng,yíng,tīng',  # 䋼
    0x42FD: 'běng,pěng',  # 䋽
    0x42FE: 'zhǎ',  # 䋾
    # 0x42FF: '',  # 䋿
    # 0x4300: '',  # 䌀
    # 0x4301: '',  # 䌁
    0x4302: 'òu',  # 䌂
    0x4303: 'shuò',  # 䌃
    0x4304: 'gěng',  # 䌄
    0x4305: 'táng',  # 䌅
    0x4306: 'guì',  # 䌆
    0x4307: 'suǒ',  # 䌇
    0x4308: 'tà',  # 䌈
    # 0x4309: '',  # 䌉
    0x430A: 'yáo,yóu',  # 䌊
    # 0x430B: '',  # 䌋
    0x430C: 'qì,qiè,qǔ',  # 䌌
    0x430D: 'hàn,jǐn',  # 䌍
    # 0x430E: '',  # 䌎
    0x430F: 'mì,miàn',  # 䌏
    0x4310: 'mì',  # 䌐
    # 0x4311: '',  # 䌑
    0x4312: 'lù',  # 䌒
    0x4313: 'fán',  # 䌓
    0x4314: 'òu',  # 䌔
    0x4315: 'mí,mó',  # 䌕
    0x4316: 'jié',  # 䌖
    0x4317: 'fǔ',  # 䌗
    0x4318: 'mí',  # 䌘
    0x4319: 'huǎng',  # 䌙
    0x431A: 'sù',  # 䌚
    0x431B: 'yáo',  # 䌛
    0x431C: 'niè',  # 䌜
    0x431D: 'jìn',  # 䌝
    0x431E: 'liǎn',  # 䌞
    0x431F: 'bì',  # 䌟
    0x4320: 'qìng,yǎn,yìn',  # 䌠
    0x4321: 'tǐ',  # 䌡
    0x4322: 'líng',  # 䌢
    0x4323: 'zuǎn',  # 䌣
    0x4324: 'zhǐ',  # 䌤
    0x4325: 'yǐn',  # 䌥
    0x4326: 'dǎo',  # 䌦
    0x4327: 'chóu',  # 䌧
    0x4328: 'cài',  # 䌨
    0x4329: 'mì,miè',  # 䌩
    0x432A: 'yán',  # 䌪
    0x432B: 'lǎn',  # 䌫
    0x432C: 'chóng',  # 䌬
    # 0x432D: '',  # 䌭
    # 0x432E: '',  # 䌮
    0x432F: 'guàn,quán',  # 䌯
    0x4330: 'shè',  # 䌰
    0x4331: 'luò',  # 䌱
    # 0x4332: '',  # 䌲
    0x4333: 'shī',  # 䌳
    0x4334: 'luò',  # 䌴
    0x4335: 'zhú,zhǔ',  # 䌵
    # 0x4336: '',  # 䌶
    0x4337: 'chōu,chóu',  # 䌷
    0x4338: 'juàn',  # 䌸
    0x4339: 'jiǒng',  # 䌹
    0x433A: 'ěr',  # 䌺
    0x433B: 'yì',  # 䌻
    0x433C: 'ruì',  # 䌼
    0x433D: 'cǎi',  # 䌽
    0x433E: 'rén',  # 䌾
    0x433F: 'fú',  # 䌿
    0x4340: 'lán',  # 䍀
    0x4341: 'suì',  # 䍁
    0x4342: 'yú',  # 䍂
    0x4343: 'yáo,yóu',  # 䍃
    0x4344: 'diǎn',  # 䍄
    0x4345: 'líng',  # 䍅
    0x4346: 'zhù',  # 䍆
    0x4347: 'tà',  # 䍇
    0x4348: 'píng',  # 䍈
    0x4349: 'qián,zhǎi',  # 䍉
    0x434A: 'jué',  # 䍊
    0x434B: 'chuí',  # 䍋
    0x434C: 'bù,fú',  # 䍌
    0x434D: 'gǔ,gù,guàng,kòu',  # 䍍
    0x434E: 'cùn',  # 䍎
    # 0x434F: '',  # 䍏
    0x4350: 'hǎn,hàn',  # 䍐
    0x4351: 'hǎn',  # 䍑
    0x4352: 'mǒu',  # 䍒
    0x4353: 'hù,yá',  # 䍓
    0x4354: 'hóng',  # 䍔
    0x4355: 'dǐ',  # 䍕
    0x4356: 'fú,fù,hài,xiè',  # 䍖
    0x4357: 'xuàn',  # 䍗
    0x4358: 'mí',  # 䍘
    0x4359: 'méi',  # 䍙
    0x435A: 'làng',  # 䍚
    0x435B: 'gù',  # 䍛
    0x435C: 'zhào',  # 䍜
    0x435D: 'tà,zǎn',  # 䍝
    0x435E: 'yù',  # 䍞
    0x435F: 'zòng',  # 䍟
    0x4360: 'lí',  # 䍠
    0x4361: 'liào,lù',  # 䍡
    0x4362: 'wú,wǔ',  # 䍢
    0x4363: 'léi',  # 䍣
    0x4364: 'jǐ',  # 䍤
    0x4365: 'lèi,lì',  # 䍥
    0x4366: 'lí',  # 䍦
    # 0x4367: '',  # 䍧
    0x4368: 'bó,fèi',  # 䍨
    0x4369: 'ǎng,yǎng',  # 䍩
    0x436A: 'kuì,wà',  # 䍪
    0x436B: 'tuó',  # 䍫
    # 0x436C: '',  # 䍬
    # 0x436D: '',  # 䍭
    0x436E: 'zhào',  # 䍮
    0x436F: 'guǐ,jì',  # 䍯
    # 0x4370: '',  # 䍰
    0x4371: 'xú',  # 䍱
    0x4372: 'nái,ní,nì',  # 䍲
    0x4373: 'chuò,jué,què',  # 䍳
    0x4374: 'duò,ruí,wěi,wèi',  # 䍴
    # 0x4375: '',  # 䍵
    0x4376: 'dòng',  # 䍶
    0x4377: 'guì,huì,wěi',  # 䍷
    0x4378: 'bó',  # 䍸
    # 0x4379: '',  # 䍹
    0x437A: 'huán',  # 䍺
    0x437B: 'xuǎn',  # 䍻
    0x437C: 'cán',  # 䍼
    0x437D: 'lì',  # 䍽
    0x437E: 'tuí,yǎn',  # 䍾
    0x437F: 'huáng',  # 䍿
    0x4380: 'xuè,yuè',  # 䎀
    0x4381: 'hú',  # 䎁
    0x4382: 'bǎo',  # 䎂
    0x4383: 'rǎn',  # 䎃
    0x4384: 'tiáo',  # 䎄
    0x4385: 'fù,luò,pò',  # 䎅
    0x4386: 'liào',  # 䎆
    # 0x4387: '',  # 䎇
    0x4388: 'yì',  # 䎈
    0x4389: 'shù,yù',  # 䎉
    0x438A: 'pò',  # 䎊
    0x438B: 'hè,kào',  # 䎋
    0x438C: 'cù',  # 䎌
    # 0x438D: '',  # 䎍
    0x438E: 'nà',  # 䎎
    0x438F: 'àn,hán',  # 䎏
    0x4390: 'chǎo',  # 䎐
    0x4391: 'lù',  # 䎑
    0x4392: 'zhǎn',  # 䎒
    0x4393: 'tà',  # 䎓
    # 0x4394: '',  # 䎔
    # 0x4395: '',  # 䎕
    # 0x4396: '',  # 䎖
    0x4397: 'qiáo',  # 䎗
    0x4398: 'sù',  # 䎘
    # 0x4399: '',  # 䎙
    0x439A: 'guàn,huì',  # 䎚
    # 0x439B: '',  # 䎛
    # 0x439C: '',  # 䎜
    0x439D: 'chú,zhù',  # 䎝
    # 0x439E: '',  # 䎞
    0x439F: 'ér,nuò',  # 䎟
    0x43A0: 'ér,nuó',  # 䎠
    0x43A1: 'nuǎn,ruǎn',  # 䎡
    0x43A2: 'qǐ',  # 䎢
    0x43A3: 'sì,xìn',  # 䎣
    0x43A4: 'chú,jú',  # 䎤
    # 0x43A5: '',  # 䎥
    0x43A6: 'yǎn',  # 䎦
    0x43A7: 'bàng,póu',  # 䎧
    0x43A8: 'àn,yè',  # 䎨
    # 0x43A9: '',  # 䎩
    0x43AA: 'nè',  # 䎪
    0x43AB: 'chuàng,zǒng',  # 䎫
    0x43AC: 'bēi,bà',  # 䎬
    0x43AD: 'cāo',  # 䎭
    0x43AE: 'tì',  # 䎮
    0x43AF: 'hàn',  # 䎯
    0x43B0: 'zuó',  # 䎰
    0x43B1: 'bēi,bà',  # 䎱
    0x43B2: 'zhé',  # 䎲
    0x43B3: 'wà,yuè',  # 䎳
    0x43B4: 'shèng',  # 䎴
    0x43B5: 'bì',  # 䎵
    0x43B6: 'èr',  # 䎶
    0x43B7: 'zhù',  # 䎷
    0x43B8: 'wù',  # 䎸
    0x43B9: 'wén',  # 䎹
    0x43BA: 'zhǐ,zhì',  # 䎺
    0x43BB: 'zhǒu',  # 䎻
    0x43BC: 'lù',  # 䎼
    0x43BD: 'wén,wèn',  # 䎽
    0x43BE: 'gǔn',  # 䎾
    0x43BF: 'qiú,xiòng',  # 䎿
    0x43C0: 'là',  # 䏀
    0x43C1: 'zǎi',  # 䏁
    0x43C2: 'sǒu',  # 䏂
    0x43C3: 'mián',  # 䏃
    0x43C4: 'zhì',  # 䏄
    0x43C5: 'qì',  # 䏅
    0x43C6: 'cáo',  # 䏆
    0x43C7: 'piào',  # 䏇
    0x43C8: 'lián',  # 䏈
    # 0x43C9: '',  # 䏉
    0x43CA: 'lóng',  # 䏊
    0x43CB: 'sù',  # 䏋
    0x43CC: 'qì,yì',  # 䏌
    0x43CD: 'yuàn',  # 䏍
    0x43CE: 'féng,hàn',  # 䏎
    # 0x43CF: '',  # 䏏
    0x43D0: 'jué,zhuò',  # 䏐
    0x43D1: 'dì,zhì',  # 䏑
    0x43D2: 'piàn',  # 䏒
    0x43D3: 'guǎn',  # 䏓
    0x43D4: 'niǔ',  # 䏔
    0x43D5: 'rěn,rùn',  # 䏕
    0x43D6: 'zhèn',  # 䏖
    0x43D7: 'gài,kuì',  # 䏗
    0x43D8: 'pǐ,pì',  # 䏘
    0x43D9: 'tǎn',  # 䏙
    0x43DA: 'chǎo,miǎo',  # 䏚
    0x43DB: 'chǔn',  # 䏛
    # 0x43DC: '',  # 䏜
    0x43DD: 'chún,zhuǎn',  # 䏝
    0x43DE: 'mò',  # 䏞
    0x43DF: 'biè,bié',  # 䏟
    0x43E0: 'qì',  # 䏠
    0x43E1: 'shì',  # 䏡
    0x43E2: 'bǐ',  # 䏢
    0x43E3: 'jué,qù,qū',  # 䏣
    0x43E4: 'sì',  # 䏤
    # 0x43E5: '',  # 䏥
    0x43E6: 'huá,tián,wǎn',  # 䏦
    0x43E7: 'ná',  # 䏧
    0x43E8: 'huǐ',  # 䏨
    # 0x43E9: '',  # 䏩
    0x43EA: 'èr',  # 䏪
    # 0x43EB: '',  # 䏫
    0x43EC: 'móu',  # 䏬
    # 0x43ED: '',  # 䏭
    0x43EE: 'xí,xié',  # 䏮
    0x43EF: 'zhì',  # 䏯
    0x43F0: 'rěn,chǔn',  # 䏰
    0x43F1: 'jú',  # 䏱
    0x43F2: 'dié',  # 䏲
    0x43F3: 'zhè',  # 䏳
    0x43F4: 'shào,shè',  # 䏴
    0x43F5: 'měng',  # 䏵
    0x43F6: 'bì',  # 䏶
    0x43F7: 'hàn',  # 䏷
    0x43F8: 'yú',  # 䏸
    0x43F9: 'xiàn',  # 䏹
    # 0x43FA: '',  # 䏺
    0x43FB: 'néng',  # 䏻
    0x43FC: 'cán',  # 䏼
    0x43FD: 'bù',  # 䏽
    # 0x43FE: '',  # 䏾
    0x43FF: 'qǐ',  # 䏿
    0x4400: 'jì',  # 䐀
    0x4401: 'niǎo,zhuó',  # 䐁
    0x4402: 'lù',  # 䐂
    0x4403: 'jiǒng',  # 䐃
    0x4404: 'hàn,liǎn,xiàn',  # 䐄
    0x4405: 'yí',  # 䐅
    0x4406: 'cǎi,cài',  # 䐆
    0x4407: 'chún',  # 䐇
    0x4408: 'zhí',  # 䐈
    0x4409: 'zì',  # 䐉
    0x440A: 'dá,hún,hùn',  # 䐊
    # 0x440B: '',  # 䐋
    0x440C: 'tiǎn,zhòu',  # 䐌
    0x440D: 'zhòu',  # 䐍
    # 0x440E: '',  # 䐎
    0x440F: 'chǔn',  # 䐏
    # 0x4410: '',  # 䐐
    0x4411: 'zhé',  # 䐑
    # 0x4412: '',  # 䐒
    0x4413: 'róu,rù',  # 䐓
    0x4414: 'bìn',  # 䐔
    0x4415: 'jí',  # 䐕
    0x4416: 'yí',  # 䐖
    0x4417: 'dǔ',  # 䐗
    0x4418: 'jué',  # 䐘
    0x4419: 'gé,yì',  # 䐙
    0x441A: 'jí,jì',  # 䐚
    0x441B: 'dā',  # 䐛
    0x441C: 'chēn',  # 䐜
    0x441D: 'suǒ,suò',  # 䐝
    0x441E: 'ruò',  # 䐞
    0x441F: 'xiàng',  # 䐟
    0x4420: 'huǎng',  # 䐠
    0x4421: 'qí',  # 䐡
    0x4422: 'zhù',  # 䐢
    0x4423: 'cuò,sǔn',  # 䐣
    0x4424: 'chí,cuó,qì,zhàn',  # 䐤
    0x4425: 'wěng',  # 䐥
    # 0x4426: '',  # 䐦
    0x4427: 'kào',  # 䐧
    0x4428: 'gǔ',  # 䐨
    0x4429: 'kǎi',  # 䐩
    0x442A: 'fàn,juǎn',  # 䐪
    # 0x442B: '',  # 䐫
    0x442C: 'cáo',  # 䐬
    0x442D: 'zhì',  # 䐭
    0x442E: 'chǎn',  # 䐮
    0x442F: 'léi',  # 䐯
    # 0x4430: '',  # 䐰
    # 0x4431: '',  # 䐱
    0x4432: 'zhé',  # 䐲
    0x4433: 'yú',  # 䐳
    0x4434: 'guì',  # 䐴
    0x4435: 'huáng',  # 䐵
    0x4436: 'jǐn',  # 䐶
    # 0x4437: '',  # 䐷
    0x4438: 'guó,huò',  # 䐸
    0x4439: 'sào,sōu',  # 䐹
    0x443A: 'tàn',  # 䐺
    # 0x443B: '',  # 䐻
    0x443C: 'xì',  # 䐼
    0x443D: 'mán',  # 䐽
    0x443E: 'duó',  # 䐾
    0x443F: 'áo,ǎo',  # 䐿
    0x4440: 'pì',  # 䑀
    0x4441: 'wù',  # 䑁
    0x4442: 'ǎi,xì',  # 䑂
    0x4443: 'méng',  # 䑃
    0x4444: 'pì,yì',  # 䑄
    0x4445: 'méng',  # 䑅
    0x4446: 'yǎng',  # 䑆
    0x4447: 'zhì',  # 䑇
    0x4448: 'bó',  # 䑈
    0x4449: 'yíng',  # 䑉
    0x444A: 'wéi,wèi',  # 䑊
    0x444B: 'náo,rǎng',  # 䑋
    0x444C: 'lán',  # 䑌
    0x444D: 'yàn,yǐng',  # 䑍
    0x444E: 'chǎn',  # 䑎
    0x444F: 'quán',  # 䑏
    0x4450: 'zhěn',  # 䑐
    0x4451: 'pú',  # 䑑
    # 0x4452: '',  # 䑒
    0x4453: 'tái,tǎi',  # 䑓
    0x4454: 'fèi',  # 䑔
    0x4455: 'shǔ',  # 䑕
    # 0x4456: '',  # 䑖
    0x4457: 'dàng',  # 䑗
    0x4458: 'chá,cuó',  # 䑘
    0x4459: 'rán',  # 䑙
    0x445A: 'tián',  # 䑚
    0x445B: 'chǐ,shì,yì',  # 䑛
    0x445C: 'tà',  # 䑜
    0x445D: 'jiǎ',  # 䑝
    0x445E: 'shùn',  # 䑞
    0x445F: 'huáng',  # 䑟
    0x4460: 'liǎo',  # 䑠
    0x4461: 'chā',  # 䑡
    # 0x4462: '',  # 䑢
    0x4463: 'chēn',  # 䑣
    0x4464: 'jìn,jìng',  # 䑤
    0x4465: 'è,sà',  # 䑥
    0x4466: 'gōu',  # 䑦
    0x4467: 'fú',  # 䑧
    0x4468: 'duò',  # 䑨
    # 0x4469: '',  # 䑩
    0x446A: 'è',  # 䑪
    # 0x446B: '',  # 䑫
    0x446C: 'yào',  # 䑬
    0x446D: 'dì,zhì',  # 䑭
    # 0x446E: '',  # 䑮
    0x446F: 'dì',  # 䑯
    0x4470: 'bù',  # 䑰
    0x4471: 'mán,wǎn',  # 䑱
    0x4472: 'chè,zhái,zhào',  # 䑲
    0x4473: 'lún',  # 䑳
    0x4474: 'qí',  # 䑴
    0x4475: 'mù',  # 䑵
    0x4476: 'cán,qiàn',  # 䑶
    # 0x4477: '',  # 䑷
    # 0x4478: '',  # 䑸
    # 0x4479: '',  # 䑹
    # 0x447A: '',  # 䑺
    0x447B: 'yóu',  # 䑻
    # 0x447C: '',  # 䑼
    0x447D: 'dá,tà',  # 䑽
    # 0x447E: '',  # 䑾
    0x447F: 'sù',  # 䑿
    0x4480: 'fú',  # 䒀
    0x4481: 'jì,xí,xiào,yà',  # 䒁
    0x4482: 'jiǎng,xiǎng',  # 䒂
    0x4483: 'zào',  # 䒃
    0x4484: 'bó,fù',  # 䒄
    0x4485: 'téng',  # 䒅
    0x4486: 'chè',  # 䒆
    0x4487: 'fù',  # 䒇
    0x4488: 'bǔ,fèi',  # 䒈
    0x4489: 'wǔ',  # 䒉
    # 0x448A: '',  # 䒊
    0x448B: 'yǎng',  # 䒋
    0x448C: 'mìng',  # 䒌
    0x448D: 'pǎng',  # 䒍
    0x448E: 'mǎng',  # 䒎
    # 0x448F: '',  # 䒏
    0x4490: 'méng',  # 䒐
    0x4491: 'cǎo',  # 䒑
    0x4492: 'tiáo,yǎo,yóu',  # 䒒
    0x4493: 'kǎi',  # 䒓
    0x4494: 'bài',  # 䒔
    0x4495: 'xiǎo',  # 䒕
    0x4496: 'xìn',  # 䒖
    0x4497: 'qì',  # 䒗
    # 0x4498: '',  # 䒘
    # 0x4499: '',  # 䒙
    0x449A: 'shǎo',  # 䒚
    0x449B: 'héng,huàn',  # 䒛
    0x449C: 'niú',  # 䒜
    0x449D: 'xiáo',  # 䒝
    0x449E: 'chén',  # 䒞
    # 0x449F: '',  # 䒟
    0x44A0: 'fēng,xiá',  # 䒠
    0x44A1: 'yǐn',  # 䒡
    0x44A2: 'áng,yìng',  # 䒢
    0x44A3: 'rǎn',  # 䒣
    0x44A4: 'rì',  # 䒤
    0x44A5: 'fà,liǔ,mán',  # 䒥
    0x44A6: 'fàn',  # 䒦
    0x44A7: 'qù',  # 䒧
    0x44A8: 'shǐ',  # 䒨
    0x44A9: 'hé,xiá',  # 䒩
    0x44AA: 'biàn',  # 䒪
    0x44AB: 'dài',  # 䒫
    0x44AC: 'mò',  # 䒬
    0x44AD: 'děng',  # 䒭
    # 0x44AE: '',  # 䒮
    # 0x44AF: '',  # 䒯
    # 0x44B0: '',  # 䒰
    # 0x44B1: '',  # 䒱
    0x44B2: 'chà',  # 䒲
    0x44B3: 'duǒ',  # 䒳
    0x44B4: 'yǒu',  # 䒴
    0x44B5: 'hào',  # 䒵
    # 0x44B6: '',  # 䒶
    0x44B7: 'guā',  # 䒷
    0x44B8: 'xián,xuè,yuè',  # 䒸
    0x44B9: 'lèi',  # 䒹
    0x44BA: 'jǐn',  # 䒺
    0x44BB: 'qǐ',  # 䒻
    0x44BC: 'qū',  # 䒼
    0x44BD: 'méi,wǎng',  # 䒽
    # 0x44BE: '',  # 䒾
    0x44BF: 'liáo',  # 䒿
    # 0x44C0: '',  # 䓀
    # 0x44C1: '',  # 䓁
    0x44C2: 'yán',  # 䓂
    0x44C3: 'yì',  # 䓃
    0x44C4: 'yín',  # 䓄
    0x44C5: 'qí',  # 䓅
    0x44C6: 'zhé',  # 䓆
    0x44C7: 'xì',  # 䓇
    0x44C8: 'yì',  # 䓈
    0x44C9: 'yé',  # 䓉
    0x44CA: 'è,wú,yú',  # 䓊
    # 0x44CB: '',  # 䓋
    0x44CC: 'zhì',  # 䓌
    0x44CD: 'hǎn',  # 䓍
    0x44CE: 'chuò',  # 䓎
    # 0x44CF: '',  # 䓏
    0x44D0: 'chún',  # 䓐
    0x44D1: 'bǐng,píng',  # 䓑
    0x44D2: 'kuǎi',  # 䓒
    0x44D3: 'chóu',  # 䓓
    # 0x44D4: '',  # 䓔
    0x44D5: 'tuǒ,wěi',  # 䓕
    0x44D6: 'qióng',  # 䓖
    # 0x44D7: '',  # 䓗
    0x44D8: 'jiù',  # 䓘
    # 0x44D9: '',  # 䓙
    0x44DA: 'cú',  # 䓚
    0x44DB: 'fǔ,gǔ,qū',  # 䓛
    0x44DC: 'zhī',  # 䓜
    0x44DD: 'méng,mèng',  # 䓝
    0x44DE: 'lì',  # 䓞
    0x44DF: 'liè',  # 䓟
    0x44E0: 'tà',  # 䓠
    0x44E1: 'zhī',  # 䓡
    0x44E2: 'gù',  # 䓢
    0x44E3: 'liǎng',  # 䓣
    # 0x44E4: '',  # 䓤
    0x44E5: 'là',  # 䓥
    0x44E6: 'diǎn',  # 䓦
    0x44E7: 'cì,jí',  # 䓧
    # 0x44E8: '',  # 䓨
    # 0x44E9: '',  # 䓩
    # 0x44EA: '',  # 䓪
    0x44EB: 'jì,qí',  # 䓫
    # 0x44EC: '',  # 䓬
    0x44ED: 'chà',  # 䓭
    0x44EE: 'mào',  # 䓮
    0x44EF: 'dú',  # 䓯
    # 0x44F0: '',  # 䓰
    0x44F1: 'chái,zhài',  # 䓱
    0x44F2: 'ruì,sà',  # 䓲
    0x44F3: 'hěn',  # 䓳
    0x44F4: 'ruán,ruǎn',  # 䓴
    # 0x44F5: '',  # 䓵
    0x44F6: 'lài',  # 䓶
    0x44F7: 'xìng',  # 䓷
    # 0x44F8: '',  # 䓸
    0x44F9: 'yì',  # 䓹
    0x44FA: 'měi,wèi',  # 䓺
    # 0x44FB: '',  # 䓻
    0x44FC: 'hè,máng',  # 䓼
    0x44FD: 'jì',  # 䓽
    0x44FE: 'suō',  # 䓾
    0x44FF: 'hǎn,hàn',  # 䓿
    # 0x4500: '',  # 䔀
    0x4501: 'lì',  # 䔁
    0x4502: 'zǐ',  # 䔂
    0x4503: 'zǔ',  # 䔃
    0x4504: 'yáo',  # 䔄
    # 0x4505: '',  # 䔅
    0x4506: 'lí',  # 䔆
    0x4507: 'qǐ,yǐ',  # 䔇
    0x4508: 'gǎn,gòng,nǒu',  # 䔈
    0x4509: 'lì',  # 䔉
    # 0x450A: '',  # 䔊
    # 0x450B: '',  # 䔋
    0x450C: 'gāo',  # 䔌
    # 0x450D: '',  # 䔍
    0x450E: 'sù',  # 䔎
    0x450F: 'chòu',  # 䔏
    # 0x4510: '',  # 䔐
    0x4511: 'xié,yé',  # 䔑
    0x4512: 'bèi',  # 䔒
    0x4513: 'xǔ',  # 䔓
    0x4514: 'jìng,qiǎn,qiú,yǐng',  # 䔔
    0x4515: 'pú',  # 䔕
    0x4516: 'líng',  # 䔖
    0x4517: 'xiáng',  # 䔗
    0x4518: 'zuò',  # 䔘
    0x4519: 'diào',  # 䔙
    0x451A: 'chún',  # 䔚
    0x451B: 'qǐng',  # 䔛
    0x451C: 'nán',  # 䔜
    # 0x451D: '',  # 䔝
    # 0x451E: '',  # 䔞
    0x451F: 'chí,chǐ,yí',  # 䔟
    0x4520: 'shǎo',  # 䔠
    0x4521: 'yú',  # 䔡
    0x4522: 'huá,huà',  # 䔢
    0x4523: 'lí',  # 䔣
    0x4524: 'pā',  # 䔤
    # 0x4525: '',  # 䔥
    # 0x4526: '',  # 䔦
    0x4527: 'lí,lì',  # 䔧
    # 0x4528: '',  # 䔨
    # 0x4529: '',  # 䔩
    0x452A: 'duì,shuǎng',  # 䔪
    0x452B: 'shū',  # 䔫
    0x452C: 'yì',  # 䔬
    0x452D: 'nìng,zhǒu',  # 䔭
    0x452E: 'sī',  # 䔮
    0x452F: 'hú,huà,kù',  # 䔯
    0x4530: 'fú,fù',  # 䔰
    # 0x4531: '',  # 䔱
    0x4532: 'chéng,zhuó',  # 䔲
    0x4533: 'nǎn,rán',  # 䔳
    0x4534: 'cè,cuì',  # 䔴
    # 0x4535: '',  # 䔵
    0x4536: 'tí',  # 䔶
    0x4537: 'qín',  # 䔷
    0x4538: 'biǎo',  # 䔸
    0x4539: 'suì',  # 䔹
    0x453A: 'wéi',  # 䔺
    # 0x453B: '',  # 䔻
    0x453C: 'sè',  # 䔼
    0x453D: 'ài',  # 䔽
    0x453E: 'è,qì,zè',  # 䔾
    0x453F: 'jiè,zǔn',  # 䔿
    0x4540: 'kuǎn',  # 䕀
    0x4541: 'fěi',  # 䕁
    # 0x4542: '',  # 䕂
    0x4543: 'yìn',  # 䕃
    # 0x4544: '',  # 䕄
    0x4545: 'sǎo',  # 䕅
    0x4546: 'dòu',  # 䕆
    0x4547: 'huì',  # 䕇
    0x4548: 'xiè',  # 䕈
    0x4549: 'zé',  # 䕉
    0x454A: 'tán',  # 䕊
    0x454B: 'chǎng,táng',  # 䕋
    0x454C: 'zhì',  # 䕌
    0x454D: 'yì',  # 䕍
    0x454E: 'fú',  # 䕎
    0x454F: 'é',  # 䕏
    # 0x4550: '',  # 䕐
    0x4551: 'jùn',  # 䕑
    # 0x4552: '',  # 䕒
    0x4553: 'chá,chuì',  # 䕓
    0x4554: 'xián',  # 䕔
    0x4555: 'màn',  # 䕕
    # 0x4556: '',  # 䕖
    0x4557: 'bì,pèi',  # 䕗
    0x4558: 'líng',  # 䕘
    0x4559: 'jié',  # 䕙
    0x455A: 'kuì',  # 䕚
    0x455B: 'jiá',  # 䕛
    # 0x455C: '',  # 䕜
    # 0x455D: '',  # 䕝
    0x455E: 'làng,liáo',  # 䕞
    # 0x455F: '',  # 䕟
    0x4560: 'fèi',  # 䕠
    0x4561: 'lǘ',  # 䕡
    0x4562: 'zhǎ',  # 䕢
    0x4563: 'hé,kě,shé',  # 䕣
    0x4564: 'qí,jī',  # 䕤
    0x4565: 'nǐ,yí',  # 䕥
    0x4566: 'yíng',  # 䕦
    0x4567: 'xiào',  # 䕧
    0x4568: 'téng',  # 䕨
    0x4569: 'lǎo',  # 䕩
    0x456A: 'zé',  # 䕪
    0x456B: 'kuí',  # 䕫
    0x456C: 'jiāng',  # 䕬
    0x456D: 'qián',  # 䕭
    0x456E: 'jú',  # 䕮
    0x456F: 'piáo',  # 䕯
    0x4570: 'bàn,fán,fàn',  # 䕰
    0x4571: 'dǒu,dòu,tóu',  # 䕱
    0x4572: 'lǐn',  # 䕲
    0x4573: 'mí',  # 䕳
    0x4574: 'zhuó',  # 䕴
    0x4575: 'xié,xiè',  # 䕵
    0x4576: 'hù',  # 䕶
    0x4577: 'mí',  # 䕷
    # 0x4578: '',  # 䕸
    0x4579: 'zá',  # 䕹
    0x457A: 'cóng',  # 䕺
    0x457B: 'gé,lì,lí',  # 䕻
    0x457C: 'nán,nàn,rán',  # 䕼
    0x457D: 'zhú',  # 䕽
    0x457E: 'yán,yín',  # 䕾
    0x457F: 'hàn',  # 䕿
    # 0x4580: '',  # 䖀
    0x4581: 'yì',  # 䖁
    0x4582: 'luán',  # 䖂
    0x4583: 'yuè',  # 䖃
    0x4584: 'rán',  # 䖄
    0x4585: 'líng',  # 䖅
    0x4586: 'niàng',  # 䖆
    0x4587: 'yù',  # 䖇
    0x4588: 'nüè',  # 䖈
    # 0x4589: '',  # 䖉
    0x458A: 'yí,yì',  # 䖊
    0x458B: 'nüè',  # 䖋
    0x458C: 'qín,yá,yì',  # 䖌
    0x458D: 'qián',  # 䖍
    0x458E: 'xiá',  # 䖎
    0x458F: 'chǔ',  # 䖏
    0x4590: 'jìn,yín',  # 䖐
    0x4591: 'mì',  # 䖑
    0x4592: 'xī',  # 䖒
    0x4593: 'nà',  # 䖓
    0x4594: 'hàn,kǎn',  # 䖔
    0x4595: 'zǔ',  # 䖕
    0x4596: 'xiá',  # 䖖
    0x4597: 'yán,yàn',  # 䖗
    0x4598: 'tú',  # 䖘
    # 0x4599: '',  # 䖙
    # 0x459A: '',  # 䖚
    0x459B: 'suǒ',  # 䖛
    0x459C: 'yín,yìn',  # 䖜
    0x459D: 'chóng',  # 䖝
    0x459E: 'zhǒu',  # 䖞
    0x459F: 'mǎng,méng',  # 䖟
    0x45A0: 'yuán',  # 䖠
    # 0x45A1: '',  # 䖡
    0x45A2: 'miáo',  # 䖢
    0x45A3: 'zǎo',  # 䖣
    0x45A4: 'wǎn,yuán',  # 䖤
    0x45A5: 'máo',  # 䖥
    0x45A6: 'qū,zhuō',  # 䖦
    0x45A7: 'nà',  # 䖧
    0x45A8: 'shí',  # 䖨
    0x45A9: 'bì,pì',  # 䖩
    0x45AA: 'cí',  # 䖪
    0x45AB: 'bàng',  # 䖫
    0x45AC: 'jiǎ',  # 䖬
    0x45AD: 'juàn',  # 䖭
    0x45AE: 'xiǎng',  # 䖮
    0x45AF: 'kuí,wā',  # 䖯
    0x45B0: 'pài',  # 䖰
    # 0x45B1: '',  # 䖱
    0x45B2: 'xún',  # 䖲
    0x45B3: 'zhà',  # 䖳
    0x45B4: 'yáo',  # 䖴
    0x45B5: 'kūn',  # 䖵
    # 0x45B6: '',  # 䖶
    # 0x45B7: '',  # 䖷
    0x45B8: 'é',  # 䖸
    0x45B9: 'yáng',  # 䖹
    0x45BA: 'tiáo,zhào',  # 䖺
    0x45BB: 'yóu',  # 䖻
    0x45BC: 'jué,xuè',  # 䖼
    0x45BD: 'lí',  # 䖽
    # 0x45BE: '',  # 䖾
    0x45BF: 'lí',  # 䖿
    # 0x45C0: '',  # 䗀
    0x45C1: 'jì,qī',  # 䗁
    0x45C2: 'hǔ',  # 䗂
    0x45C3: 'zhàn',  # 䗃
    0x45C4: 'fǔ,pì',  # 䗄
    0x45C5: 'cháng',  # 䗅
    0x45C6: 'guǎn,wěi',  # 䗆
    0x45C7: 'jú,qú',  # 䗇
    0x45C8: 'méng',  # 䗈
    # 0x45C9: '',  # 䗉
    0x45CA: 'chéng,tàn',  # 䗊
    0x45CB: 'móu',  # 䗋
    # 0x45CC: '',  # 䗌
    0x45CD: 'lǐ',  # 䗍
    # 0x45CE: '',  # 䗎
    # 0x45CF: '',  # 䗏
    0x45D0: 'shī',  # 䗐
    0x45D1: 'yì',  # 䗑
    0x45D2: 'bìng',  # 䗒
    # 0x45D3: '',  # 䗓
    0x45D4: 'hóu',  # 䗔
    0x45D5: 'wǎn',  # 䗕
    0x45D6: 'dì',  # 䗖
    # 0x45D7: '',  # 䗗
    0x45D8: 'gé,kè',  # 䗘
    0x45D9: 'hán',  # 䗙
    0x45DA: 'bó',  # 䗚
    # 0x45DB: '',  # 䗛
    0x45DC: 'liú',  # 䗜
    0x45DD: 'cán',  # 䗝
    0x45DE: 'cán,chěn,shǎn,yǐn,zàn,zhàn',  # 䗞
    0x45DF: 'yì',  # 䗟
    0x45E0: 'xuán',  # 䗠
    0x45E1: 'yán',  # 䗡
    0x45E2: 'zǎo',  # 䗢
    0x45E3: 'gǎo,hàn',  # 䗣
    0x45E4: 'yóng',  # 䗤
    0x45E5: 'zōng',  # 䗥
    # 0x45E6: '',  # 䗦
    # 0x45E7: '',  # 䗧
    0x45E8: 'yú',  # 䗨
    # 0x45E9: '',  # 䗩
    0x45EA: 'zhè',  # 䗪
    0x45EB: 'má',  # 䗫
    # 0x45EC: '',  # 䗬
    # 0x45ED: '',  # 䗭
    0x45EE: 'shuǎng',  # 䗮
    0x45EF: 'jìn',  # 䗯
    0x45F0: 'guàn',  # 䗰
    0x45F1: 'pú',  # 䗱
    0x45F2: 'lìn',  # 䗲
    # 0x45F3: '',  # 䗳
    0x45F4: 'tíng',  # 䗴
    # 0x45F5: '',  # 䗵
    0x45F6: 'là,lì',  # 䗶
    0x45F7: 'yì',  # 䗷
    # 0x45F8: '',  # 䗸
    0x45F9: 'cì',  # 䗹
    0x45FA: 'yǎn',  # 䗺
    0x45FB: 'jié',  # 䗻
    # 0x45FC: '',  # 䗼
    0x45FD: 'wèi',  # 䗽
    0x45FE: 'xiǎn',  # 䗾
    0x45FF: 'níng',  # 䗿
    0x4600: 'fù',  # 䘀
    0x4601: 'gé,jié,kě',  # 䘁
    # 0x4602: '',  # 䘂
    0x4603: 'mò',  # 䘃
    0x4604: 'fù,zhù',  # 䘄
    0x4605: 'nái,nài,něng',  # 䘅
    0x4606: 'xiǎn',  # 䘆
    0x4607: 'wén,wèn',  # 䘇
    0x4608: 'lì',  # 䘈
    0x4609: 'cán',  # 䘉
    0x460A: 'miè',  # 䘊
    # 0x460B: '',  # 䘋
    0x460C: 'nì',  # 䘌
    0x460D: 'chài',  # 䘍
    # 0x460E: '',  # 䘎
    0x460F: 'xù',  # 䘏
    # 0x4610: '',  # 䘐
    0x4611: 'mài,mò',  # 䘑
    0x4612: 'zuī',  # 䘒
    0x4613: 'kàn,kào',  # 䘓
    0x4614: 'kā',  # 䘔
    0x4615: 'háng',  # 䘕
    # 0x4616: '',  # 䘖
    # 0x4617: '',  # 䘗
    0x4618: 'yù',  # 䘘
    0x4619: 'wèi',  # 䘙
    0x461A: 'zú',  # 䘚
    # 0x461B: '',  # 䘛
    # 0x461C: '',  # 䘜
    0x461D: 'yì',  # 䘝
    # 0x461E: '',  # 䘞
    0x461F: 'diāo',  # 䘟
    0x4620: 'fú,pò',  # 䘠
    0x4621: 'bǐ',  # 䘡
    0x4622: 'zhǔ',  # 䘢
    0x4623: 'zǐ',  # 䘣
    0x4624: 'shù',  # 䘤
    0x4625: 'xiá,jiá',  # 䘥
    0x4626: 'ní,nǐ',  # 䘦
    # 0x4627: '',  # 䘧
    0x4628: 'jiǎo',  # 䘨
    0x4629: 'xuàn,xún',  # 䘩
    # 0x462A: '',  # 䘪
    0x462B: 'nòu,rú',  # 䘫
    0x462C: 'róng',  # 䘬
    0x462D: 'dié,zhì',  # 䘭
    0x462E: 'sà,sàng,xì',  # 䘮
    0x462F: 'shāo',  # 䘯
    0x4630: 'shān',  # 䘰
    0x4631: 'yù',  # 䘱
    # 0x4632: '',  # 䘲
    0x4633: 'jīn',  # 䘳
    # 0x4634: '',  # 䘴
    0x4635: 'lù',  # 䘵
    0x4636: 'hàn,yǎn',  # 䘶
    # 0x4637: '',  # 䘷
    0x4638: 'yì',  # 䘸
    0x4639: 'zuì',  # 䘹
    0x463A: 'zhàn',  # 䘺
    0x463B: 'sù,yù',  # 䘻
    0x463C: 'wǎn',  # 䘼
    0x463D: 'ní,nǐ,nì',  # 䘽
    0x463E: 'guǎn',  # 䘾
    0x463F: 'jué',  # 䘿
    0x4640: 'běng',  # 䙀
    0x4641: 'cán',  # 䙁
    # 0x4642: '',  # 䙂
    0x4643: 'duò,kuò,pán,ruán',  # 䙃
    0x4644: 'qì,zhǎ',  # 䙄
    0x4645: 'yào',  # 䙅
    0x4646: 'guì,kuì',  # 䙆
    0x4647: 'nuǎn,ruán',  # 䙇
    0x4648: 'hóu',  # 䙈
    0x4649: 'xún,zǎn',  # 䙉
    0x464A: 'xiè',  # 䙊
    # 0x464B: '',  # 䙋
    0x464C: 'huì,kuì',  # 䙌
    # 0x464D: '',  # 䙍
    0x464E: 'xié',  # 䙎
    0x464F: 'bó',  # 䙏
    0x4650: 'kè',  # 䙐
    # 0x4651: '',  # 䙑
    0x4652: 'xù',  # 䙒
    0x4653: 'bǎi',  # 䙓
    0x4654: 'yǔ',  # 䙔
    0x4655: 'chù,zǒng',  # 䙕
    # 0x4656: '',  # 䙖
    0x4657: 'tì',  # 䙗
    0x4658: 'chǔ,zú',  # 䙘
    0x4659: 'chí',  # 䙙
    0x465A: 'niǎo',  # 䙚
    0x465B: 'guàn,gǔn',  # 䙛
    0x465C: 'féng',  # 䙜
    0x465D: 'xiè,dié',  # 䙝
    # 0x465E: '',  # 䙞
    0x465F: 'duò,wéi',  # 䙟
    0x4660: 'jué,wò',  # 䙠
    0x4661: 'huì,kuì',  # 䙡
    0x4662: 'zèng',  # 䙢
    0x4663: 'sà',  # 䙣
    0x4664: 'duǒ,duò',  # 䙤
    0x4665: 'líng',  # 䙥
    0x4666: 'méng',  # 䙦
    # 0x4667: '',  # 䙧
    0x4668: 'guǒ,luǒ',  # 䙨
    0x4669: 'méng',  # 䙩
    0x466A: 'lóng,màng,pàn',  # 䙪
    # 0x466B: '',  # 䙫
    0x466C: 'yìng',  # 䙬
    # 0x466D: '',  # 䙭
    0x466E: 'guàn',  # 䙮
    0x466F: 'cù,zhuó',  # 䙯
    0x4670: 'lí',  # 䙰
    0x4671: 'dú,shǔ',  # 䙱
    # 0x4672: '',  # 䙲
    0x4673: 'è',  # 䙳
    # 0x4674: '',  # 䙴
    0x4675: 'xī',  # 䙵
    # 0x4676: '',  # 䙶
    0x4677: 'dé,zhé',  # 䙷
    0x4678: 'dé,de',  # 䙸
    0x4679: 'jiǎng,nǎo,xiàn,xiǎng',  # 䙹
    0x467A: 'lián,liǎn,qiǎn',  # 䙺
    # 0x467B: '',  # 䙻
    0x467C: 'shào',  # 䙼
    0x467D: 'xì,xié',  # 䙽
    0x467E: 'shī',  # 䙾
    0x467F: 'wèi',  # 䙿
    # 0x4680: '',  # 䚀
    # 0x4681: '',  # 䚁
    0x4682: 'hè,xì',  # 䚂
    0x4683: 'yóu',  # 䚃
    0x4684: 'lù',  # 䚄
    0x4685: 'lái,lài',  # 䚅
    0x4686: 'ǒu,yǎo,yǐng',  # 䚆
    0x4687: 'shěng,zhì',  # 䚇
    0x4688: 'juàn,wù,zhuàn',  # 䚈
    0x4689: 'qì,xì',  # 䚉
    # 0x468A: '',  # 䚊
    0x468B: 'yùn',  # 䚋
    # 0x468C: '',  # 䚌
    0x468D: 'qì',  # 䚍
    0x468E: 'chuāng',  # 䚎
    0x468F: 'lèng,lì,lìn',  # 䚏
    0x4690: 'jí',  # 䚐
    0x4691: 'mái',  # 䚑
    0x4692: 'chuáng,zhuàng',  # 䚒
    0x4693: 'niǎn,shěn',  # 䚓
    0x4694: 'bìn',  # 䚔
    0x4695: 'lì,luán',  # 䚕
    0x4696: 'líng',  # 䚖
    0x4697: 'gāng',  # 䚗
    0x4698: 'chén,chéng',  # 䚘
    0x4699: 'xuān',  # 䚙
    0x469A: 'xiǎn',  # 䚚
    0x469B: 'hú',  # 䚛
    # 0x469C: '',  # 䚜
    0x469D: 'zú',  # 䚝
    0x469E: 'dǎi',  # 䚞
    0x469F: 'dǎi',  # 䚟
    0x46A0: 'hùn',  # 䚠
    0x46A1: 'sāi',  # 䚡
    0x46A2: 'chè',  # 䚢
    0x46A3: 'tí,tì',  # 䚣
    # 0x46A4: '',  # 䚤
    0x46A5: 'nuò',  # 䚥
    0x46A6: 'zhì',  # 䚦
    0x46A7: 'liú',  # 䚧
    0x46A8: 'fèi',  # 䚨
    0x46A9: 'jiǎo,jiào',  # 䚩
    # 0x46AA: '',  # 䚪
    0x46AB: 'áo,xí',  # 䚫
    0x46AC: 'lín',  # 䚬
    0x46AD: 'xuān',  # 䚭
    0x46AE: 'réng',  # 䚮
    0x46AF: 'tǎo,zhèn',  # 䚯
    0x46B0: 'pǐ',  # 䚰
    0x46B1: 'xìn',  # 䚱
    0x46B2: 'shàn',  # 䚲
    0x46B3: 'xiè,zhì',  # 䚳
    0x46B4: 'wà',  # 䚴
    0x46B5: 'tǒu',  # 䚵
    # 0x46B6: '',  # 䚶
    0x46B7: 'xì,yǐ,yì',  # 䚷
    0x46B8: 'xiè',  # 䚸
    0x46B9: 'pǐ',  # 䚹
    0x46BA: 'yáo',  # 䚺
    0x46BB: 'yáo',  # 䚻
    # 0x46BC: '',  # 䚼
    0x46BD: 'hào',  # 䚽
    0x46BE: 'nín,rén',  # 䚾
    0x46BF: 'yìn',  # 䚿
    0x46C0: 'fǎn',  # 䛀
    0x46C1: 'nán',  # 䛁
    0x46C2: 'chí,chǐ',  # 䛂
    0x46C3: 'wàng',  # 䛃
    0x46C4: 'yuǎn',  # 䛄
    0x46C5: 'xiá',  # 䛅
    0x46C6: 'zhòu',  # 䛆
    0x46C7: 'yuǎn',  # 䛇
    0x46C8: 'shì',  # 䛈
    0x46C9: 'mì,miàn',  # 䛉
    # 0x46CA: '',  # 䛊
    0x46CB: 'gé,jì',  # 䛋
    0x46CC: 'páo,táo',  # 䛌
    0x46CD: 'fèi',  # 䛍
    0x46CE: 'hù,xuè,yù',  # 䛎
    0x46CF: 'ní',  # 䛏
    0x46D0: 'cí',  # 䛐
    0x46D1: 'mì',  # 䛑
    0x46D2: 'biàn',  # 䛒
    # 0x46D3: '',  # 䛓
    0x46D4: 'ná',  # 䛔
    0x46D5: 'yù',  # 䛕
    0x46D6: 'è,yì',  # 䛖
    0x46D7: 'zhǐ',  # 䛗
    0x46D8: 'nín,rén',  # 䛘
    0x46D9: 'xù',  # 䛙
    # 0x46DA: '',  # 䛚
    0x46DB: 'huì,qì',  # 䛛
    0x46DC: 'xùn',  # 䛜
    0x46DD: 'náo',  # 䛝
    0x46DE: 'hǎn,hàn',  # 䛞
    0x46DF: 'jiá',  # 䛟
    0x46E0: 'dòu,xiáng',  # 䛠
    0x46E1: 'huà',  # 䛡
    # 0x46E2: '',  # 䛢
    # 0x46E3: '',  # 䛣
    0x46E4: 'cù',  # 䛤
    0x46E5: 'xì',  # 䛥
    0x46E6: 'sòng',  # 䛦
    0x46E7: 'mí',  # 䛧
    0x46E8: 'xìn',  # 䛨
    0x46E9: 'wù',  # 䛩
    0x46EA: 'qióng,wěi',  # 䛪
    0x46EB: 'zhèng',  # 䛫
    0x46EC: 'táo',  # 䛬
    0x46ED: 'xìng',  # 䛭
    0x46EE: 'jiù',  # 䛮
    0x46EF: 'jù',  # 䛯
    0x46F0: 'hún,hùn',  # 䛰
    0x46F1: 'tí',  # 䛱
    0x46F2: 'mán,màn',  # 䛲
    0x46F3: 'jiǎn,yàn',  # 䛳
    0x46F4: 'qǐ',  # 䛴
    0x46F5: 'shòu',  # 䛵
    0x46F6: 'lěi',  # 䛶
    0x46F7: 'wǎn',  # 䛷
    0x46F8: 'chè,shǎn',  # 䛸
    0x46F9: 'càn',  # 䛹
    0x46FA: 'jiè',  # 䛺
    0x46FB: 'yòu',  # 䛻
    0x46FC: 'huǐ',  # 䛼
    0x46FD: 'zhǎ',  # 䛽
    0x46FE: 'sù',  # 䛾
    0x46FF: 'gé',  # 䛿
    0x4700: 'nǎo',  # 䜀
    0x4701: 'xì',  # 䜁
    # 0x4702: '',  # 䜂
    # 0x4703: '',  # 䜃
    0x4704: 'chí',  # 䜄
    0x4705: 'wéi',  # 䜅
    0x4706: 'mò,nèi,shé,suì,zhé',  # 䜆
    0x4707: 'gǔn,gùn',  # 䜇
    0x4708: 'jiǎo',  # 䜈
    # 0x4709: '',  # 䜉
    0x470A: 'zāo,zào',  # 䜊
    0x470B: 'huì',  # 䜋
    0x470C: 'luán',  # 䜌
    0x470D: 'liáo',  # 䜍
    0x470E: 'láo,lào',  # 䜎
    # 0x470F: '',  # 䜏
    0x4710: 'huī',  # 䜐
    0x4711: 'qià,wù',  # 䜑
    0x4712: 'ào',  # 䜒
    0x4713: 'niè,shè',  # 䜓
    0x4714: 'suí',  # 䜔
    0x4715: 'mài',  # 䜕
    0x4716: 'tàn',  # 䜖
    0x4717: 'xìn',  # 䜗
    0x4718: 'jǐng',  # 䜘
    0x4719: 'án',  # 䜙
    0x471A: 'tà',  # 䜚
    0x471B: 'chán,chàn',  # 䜛
    0x471C: 'wèi',  # 䜜
    0x471D: 'tuǎn',  # 䜝
    0x471E: 'jì',  # 䜞
    0x471F: 'chén,chèn',  # 䜟
    0x4720: 'chè,zhì',  # 䜠
    0x4721: 'xù,xuè,yù',  # 䜡
    0x4722: 'xiǎn',  # 䜢
    0x4723: 'xī,xīn,yín',  # 䜣
    # 0x4724: '',  # 䜤
    # 0x4725: '',  # 䜥
    # 0x4726: '',  # 䜦
    0x4727: 'nǎo',  # 䜧
    # 0x4728: '',  # 䜨
    0x4729: 'yàn',  # 䜩
    0x472A: 'qiú',  # 䜪
    0x472B: 'hóng',  # 䜫
    0x472C: 'sǒng,xiù',  # 䜬
    0x472D: 'jùn',  # 䜭
    0x472E: 'liáo',  # 䜮
    0x472F: 'jú',  # 䜯
    0x4730: 'hāo',  # 䜰
    0x4731: 'mǎn',  # 䜱
    0x4732: 'liè',  # 䜲
    # 0x4733: '',  # 䜳
    0x4734: 'chù,shì',  # 䜴
    0x4735: 'chǐ,shì',  # 䜵
    0x4736: 'xiáng',  # 䜶
    # 0x4737: '',  # 䜷
    0x4738: 'měi',  # 䜸
    0x4739: 'shù',  # 䜹
    0x473A: 'cè',  # 䜺
    0x473B: 'chǐ,shì',  # 䜻
    0x473C: 'gú',  # 䜼
    0x473D: 'yú',  # 䜽
    # 0x473E: '',  # 䜾
    0x473F: 'shù',  # 䜿
    0x4740: 'liáo,liú',  # 䝀
    0x4741: 'láo',  # 䝁
    0x4742: 'shù',  # 䝂
    0x4743: 'zhé',  # 䝃
    # 0x4744: '',  # 䝄
    # 0x4745: '',  # 䝅
    # 0x4746: '',  # 䝆
    # 0x4747: '',  # 䝇
    0x4748: 'è',  # 䝈
    # 0x4749: '',  # 䝉
    0x474A: 'shà',  # 䝊
    0x474B: 'zòng',  # 䝋
    0x474C: 'jué,jùn',  # 䝌
    0x474D: 'jùn',  # 䝍
    # 0x474E: '',  # 䝎
    0x474F: 'lóu,lǒu',  # 䝏
    0x4750: 'wéi',  # 䝐
    # 0x4751: '',  # 䝑
    0x4752: 'zhù',  # 䝒
    0x4753: 'là,liè',  # 䝓
    # 0x4754: '',  # 䝔
    0x4755: 'zhé',  # 䝕
    0x4756: 'zhǎo',  # 䝖
    # 0x4757: '',  # 䝗
    0x4758: 'yì',  # 䝘
    # 0x4759: '',  # 䝙
    0x475A: 'ní',  # 䝚
    # 0x475B: '',  # 䝛
    # 0x475C: '',  # 䝜
    0x475D: 'yǐ',  # 䝝
    0x475E: 'hào',  # 䝞
    0x475F: 'yà,yè',  # 䝟
    0x4760: 'huán,yuán',  # 䝠
    0x4761: 'màn',  # 䝡
    0x4762: 'màn,méng',  # 䝢
    0x4763: 'qú',  # 䝣
    0x4764: 'lǎo,liáo',  # 䝤
    0x4765: 'háo',  # 䝥
    # 0x4766: '',  # 䝦
    0x4767: 'mén,mín',  # 䝧
    0x4768: 'xián',  # 䝨
    0x4769: 'zhèn',  # 䝩
    0x476A: 'shú,shǔ',  # 䝪
    0x476B: 'zuó',  # 䝫
    0x476C: 'zhù',  # 䝬
    0x476D: 'gòu',  # 䝭
    0x476E: 'xuàn',  # 䝮
    0x476F: 'yì',  # 䝯
    0x4770: 'tí,zhì',  # 䝰
    # 0x4771: '',  # 䝱
    0x4772: 'jìn',  # 䝲
    0x4773: 'cán',  # 䝳
    # 0x4774: '',  # 䝴
    0x4775: 'bù',  # 䝵
    0x4776: 'liáng',  # 䝶
    0x4777: 'zhì',  # 䝷
    0x4778: 'jì',  # 䝸
    0x4779: 'wǎn,yuàn',  # 䝹
    0x477A: 'guàn',  # 䝺
    # 0x477B: '',  # 䝻
    0x477C: 'qíng',  # 䝼
    0x477D: 'ài',  # 䝽
    0x477E: 'fù',  # 䝾
    0x477F: 'guì',  # 䝿
    0x4780: 'gòu,hòu,mǐn',  # 䞀
    0x4781: 'xiàn,yàn,yǎng,yàng',  # 䞁
    0x4782: 'ruǎn',  # 䞂
    0x4783: 'zhì',  # 䞃
    0x4784: 'biào',  # 䞄
    0x4785: 'yí',  # 䞅
    0x4786: 'suǒ',  # 䞆
    0x4787: 'dié,zhì',  # 䞇
    0x4788: 'guǐ,guì',  # 䞈
    0x4789: 'shèng',  # 䞉
    0x478A: 'xùn',  # 䞊
    0x478B: 'chèn',  # 䞋
    0x478C: 'shé',  # 䞌
    0x478D: 'qíng',  # 䞍
    # 0x478E: '',  # 䞎
    # 0x478F: '',  # 䞏
    0x4790: 'chǔn,shǔn',  # 䞐
    0x4791: 'hóng',  # 䞑
    0x4792: 'dòng',  # 䞒
    0x4793: 'chēng',  # 䞓
    0x4794: 'wěi',  # 䞔
    0x4795: 'dié,nǎ,niè,rú,xiè,yú',  # 䞕
    0x4796: 'shǔ',  # 䞖
    0x4797: 'cāi',  # 䞗
    0x4798: 'jí',  # 䞘
    0x4799: 'zá',  # 䞙
    0x479A: 'qí',  # 䞚
    # 0x479B: '',  # 䞛
    0x479C: 'fù',  # 䞜
    0x479D: 'ǎo,yù',  # 䞝
    0x479E: 'fú',  # 䞞
    0x479F: 'pò',  # 䞟
    # 0x47A0: '',  # 䞠
    0x47A1: 'tǎn',  # 䞡
    0x47A2: 'zhà,zuó',  # 䞢
    0x47A3: 'chě,chè,qiè',  # 䞣
    0x47A4: 'qú',  # 䞤
    0x47A5: 'yòu',  # 䞥
    0x47A6: 'hé,jié',  # 䞦
    0x47A7: 'hòu',  # 䞧
    0x47A8: 'guǐ,kuǐ',  # 䞨
    0x47A9: 'è,ruí',  # 䞩
    0x47AA: 'jiàng',  # 䞪
    0x47AB: 'yǔn',  # 䞫
    0x47AC: 'tòu',  # 䞬
    0x47AD: 'qiǔ,qūn',  # 䞭
    # 0x47AE: '',  # 䞮
    0x47AF: 'fù',  # 䞯
    0x47B0: 'zuó',  # 䞰
    0x47B1: 'hú',  # 䞱
    # 0x47B2: '',  # 䞲
    0x47B3: 'bó,fèi',  # 䞳
    # 0x47B4: '',  # 䞴
    0x47B5: 'juě',  # 䞵
    0x47B6: 'dì,tì',  # 䞶
    0x47B7: 'jué',  # 䞷
    0x47B8: 'fù',  # 䞸
    0x47B9: 'huáng',  # 䞹
    # 0x47BA: '',  # 䞺
    0x47BB: 'yǒng',  # 䞻
    0x47BC: 'chuǐ,cuàn,jiàn,mèi',  # 䞼
    0x47BD: 'suǒ',  # 䞽
    0x47BE: 'chí',  # 䞾
    0x47BF: 'qiān',  # 䞿
    # 0x47C0: '',  # 䟀
    # 0x47C1: '',  # 䟁
    0x47C2: 'mán',  # 䟂
    0x47C3: 'cà,zàn',  # 䟃
    0x47C4: 'qì,zuó',  # 䟄
    0x47C5: 'jiàn,zàn',  # 䟅
    0x47C6: 'bì,bó',  # 䟆
    0x47C7: 'jī',  # 䟇
    0x47C8: 'zhí',  # 䟈
    0x47C9: 'zhú',  # 䟉
    0x47CA: 'qú',  # 䟊
    0x47CB: 'zhǎn,zhàn',  # 䟋
    0x47CC: 'jí,jié',  # 䟌
    0x47CD: 'dián',  # 䟍
    # 0x47CE: '',  # 䟎
    0x47CF: 'lì',  # 䟏
    0x47D0: 'lì',  # 䟐
    0x47D1: 'lǎ,yuè',  # 䟑
    0x47D2: 'quán',  # 䟒
    # 0x47D3: '',  # 䟓
    0x47D4: 'fù',  # 䟔
    0x47D5: 'chà',  # 䟕
    0x47D6: 'tàng',  # 䟖
    0x47D7: 'shì',  # 䟗
    0x47D8: 'hàng',  # 䟘
    0x47D9: 'qiè',  # 䟙
    0x47DA: 'qí',  # 䟚
    0x47DB: 'bó',  # 䟛
    0x47DC: 'nà',  # 䟜
    0x47DD: 'tòu',  # 䟝
    0x47DE: 'chú',  # 䟞
    0x47DF: 'cù',  # 䟟
    0x47E0: 'yuè',  # 䟠
    0x47E1: 'dì',  # 䟡
    0x47E2: 'chén,jiàn,niǎn',  # 䟢
    0x47E3: 'chù',  # 䟣
    0x47E4: 'bì',  # 䟤
    0x47E5: 'máng,méng',  # 䟥
    0x47E6: 'bá,bó,yuán',  # 䟦
    0x47E7: 'tián',  # 䟧
    0x47E8: 'mín',  # 䟨
    0x47E9: 'liě',  # 䟩
    0x47EA: 'fěng',  # 䟪
    # 0x47EB: '',  # 䟫
    0x47EC: 'qiù',  # 䟬
    0x47ED: 'tiáo',  # 䟭
    0x47EE: 'fú',  # 䟮
    0x47EF: 'kuò',  # 䟯
    0x47F0: 'jiǎn',  # 䟰
    # 0x47F1: '',  # 䟱
    0x47F2: 'còng',  # 䟲
    # 0x47F3: '',  # 䟳
    0x47F4: 'zhèn',  # 䟴
    0x47F5: 'qiú',  # 䟵
    0x47F6: 'cuò,zuò',  # 䟶
    0x47F7: 'chì,qì',  # 䟷
    0x47F8: 'kuí',  # 䟸
    0x47F9: 'liè,lìn',  # 䟹
    0x47FA: 'bǎng,bèi,pèi',  # 䟺
    0x47FB: 'dù',  # 䟻
    0x47FC: 'wǔ',  # 䟼
    0x47FD: 'shū',  # 䟽
    0x47FE: 'juě,zhuó',  # 䟾
    0x47FF: 'lù',  # 䟿
    0x4800: 'chǎng',  # 䠀
    # 0x4801: '',  # 䠁
    0x4802: 'chú,chǔ',  # 䠂
    0x4803: 'liǎng',  # 䠃
    0x4804: 'tiǎn',  # 䠄
    0x4805: 'kǔn,tà',  # 䠅
    0x4806: 'cháng',  # 䠆
    0x4807: 'jué',  # 䠇
    0x4808: 'tú',  # 䠈
    0x4809: 'huà,huàn,huǐ',  # 䠉
    0x480A: 'fèi',  # 䠊
    0x480B: 'bǐ,bì,mà',  # 䠋
    # 0x480C: '',  # 䠌
    0x480D: 'qiá,xiā',  # 䠍
    0x480E: 'wò',  # 䠎
    0x480F: 'jì',  # 䠏
    0x4810: 'qù',  # 䠐
    0x4811: 'kuǐ',  # 䠑
    0x4812: 'hú',  # 䠒
    0x4813: 'cù,jiù,qù',  # 䠓
    0x4814: 'suì',  # 䠔
    # 0x4815: '',  # 䠕
    # 0x4816: '',  # 䠖
    0x4817: 'qiù',  # 䠗
    0x4818: 'pì',  # 䠘
    0x4819: 'bèi,páng,páo',  # 䠙
    0x481A: 'wà',  # 䠚
    0x481B: 'jiǎo,xiào,yáo',  # 䠛
    0x481C: 'róng',  # 䠜
    # 0x481D: '',  # 䠝
    0x481E: 'cù,qí',  # 䠞
    0x481F: 'dié,shè',  # 䠟
    0x4820: 'chì',  # 䠠
    0x4821: 'cuó',  # 䠡
    0x4822: 'mèng',  # 䠢
    0x4823: 'xuǎn,xuàn',  # 䠣
    0x4824: 'duǒ,duò',  # 䠤
    0x4825: 'bié',  # 䠥
    0x4826: 'zhè,zhì',  # 䠦
    0x4827: 'chú',  # 䠧
    0x4828: 'chàn,mà',  # 䠨
    0x4829: 'guì',  # 䠩
    0x482A: 'duàn',  # 䠪
    0x482B: 'zòu',  # 䠫
    0x482C: 'dèng',  # 䠬
    0x482D: 'lái,lài',  # 䠭
    0x482E: 'téng',  # 䠮
    0x482F: 'yuè',  # 䠯
    0x4830: 'quán',  # 䠰
    0x4831: 'shǔ,zhú',  # 䠱
    0x4832: 'líng',  # 䠲
    # 0x4833: '',  # 䠳
    0x4834: 'qǐn,yǐn,zhěn',  # 䠴
    0x4835: 'fù',  # 䠵
    0x4836: 'shè',  # 䠶
    0x4837: 'tiǎo',  # 䠷
    # 0x4838: '',  # 䠸
    0x4839: 'hái',  # 䠹
    # 0x483A: '',  # 䠺
    0x483B: 'qióng',  # 䠻
    0x483C: 'diào,shù,xuè,zhú',  # 䠼
    0x483D: 'hái',  # 䠽
    0x483E: 'shǎn,shàn',  # 䠾
    0x483F: 'wài',  # 䠿
    0x4840: 'zhǎn',  # 䡀
    0x4841: 'lǒng',  # 䡁
    0x4842: 'jiù',  # 䡂
    0x4843: 'lì',  # 䡃
    # 0x4844: '',  # 䡄
    0x4845: 'mǐn,xiǎn,xún,zhèn,zuǎn,chūn',  # 䡅
    0x4846: 'róng,rǒng',  # 䡆
    0x4847: 'yuè',  # 䡇
    0x4848: 'jué',  # 䡈
    0x4849: 'kǎng',  # 䡉
    0x484A: 'fán,fǎn,pèi',  # 䡊
    0x484B: 'qí',  # 䡋
    0x484C: 'hóng',  # 䡌
    0x484D: 'fú,fǔ',  # 䡍
    0x484E: 'lú',  # 䡎
    0x484F: 'hóng',  # 䡏
    0x4850: 'tuó',  # 䡐
    0x4851: 'mín',  # 䡑
    0x4852: 'tián',  # 䡒
    0x4853: 'juàn',  # 䡓
    0x4854: 'qǐ',  # 䡔
    0x4855: 'zhěng',  # 䡕
    0x4856: 'jìng',  # 䡖
    0x4857: 'gǒng',  # 䡗
    0x4858: 'tián',  # 䡘
    0x4859: 'láng',  # 䡙
    0x485A: 'mào',  # 䡚
    0x485B: 'yìn',  # 䡛
    0x485C: 'lù',  # 䡜
    0x485D: 'yǔn,yuān',  # 䡝
    0x485E: 'jú',  # 䡞
    0x485F: 'pì',  # 䡟
    # 0x4860: '',  # 䡠
    0x4861: 'xié',  # 䡡
    0x4862: 'biàn',  # 䡢
    0x4863: 'hún',  # 䡣
    # 0x4864: '',  # 䡤
    0x4865: 'róng',  # 䡥
    0x4866: 'sǎng',  # 䡦
    0x4867: 'wǔ',  # 䡧
    0x4868: 'chà,chái,yín',  # 䡨
    0x4869: 'gǔ,hòu,tǒu,zhěn,kēng',  # 䡩
    0x486A: 'chán,shàn',  # 䡪
    0x486B: 'péng',  # 䡫
    0x486C: 'màn',  # 䡬
    # 0x486D: '',  # 䡭
    # 0x486E: '',  # 䡮
    0x486F: 'shuàng,zǒng',  # 䡯
    0x4870: 'kěng,kēng',  # 䡰
    0x4871: 'zhuǎn',  # 䡱
    0x4872: 'chán',  # 䡲
    # 0x4873: '',  # 䡳
    0x4874: 'chuáng,chōng',  # 䡴
    0x4875: 'suì',  # 䡵
    0x4876: 'bèi,pì',  # 䡶
    0x4877: 'kài',  # 䡷
    # 0x4878: '',  # 䡸
    0x4879: 'zhì',  # 䡹
    0x487A: 'wèi',  # 䡺
    0x487B: 'mín',  # 䡻
    0x487C: 'líng',  # 䡼
    # 0x487D: '',  # 䡽
    0x487E: 'nèi,niè',  # 䡾
    0x487F: 'líng',  # 䡿
    0x4880: 'qì',  # 䢀
    0x4881: 'yuè',  # 䢁
    # 0x4882: '',  # 䢂
    0x4883: 'yì',  # 䢃
    0x4884: 'xǐ,xǐ',  # 䢄
    0x4885: 'chén',  # 䢅
    # 0x4886: '',  # 䢆
    0x4887: 'rǒng,rǒu',  # 䢇
    0x4888: 'chén,qín',  # 䢈
    0x4889: 'nóng',  # 䢉
    0x488A: 'yóu',  # 䢊
    0x488B: 'jì',  # 䢋
    0x488C: 'bó',  # 䢌
    0x488D: 'fǎng,fèn',  # 䢍
    # 0x488E: '',  # 䢎
    # 0x488F: '',  # 䢏
    0x4890: 'cú',  # 䢐
    0x4891: 'dǐ',  # 䢑
    0x4892: 'jiāo',  # 䢒
    0x4893: 'yú',  # 䢓
    0x4894: 'gé,hé,jiá',  # 䢔
    0x4895: 'xù',  # 䢕
    0x4896: 'yù',  # 䢖
    0x4897: 'hé,qǔ',  # 䢗
    # 0x4898: '',  # 䢘
    0x4899: 'bài',  # 䢙
    0x489A: 'gòng,háng',  # 䢚
    0x489B: 'jiǒng',  # 䢛
    # 0x489C: '',  # 䢜
    0x489D: 'yà',  # 䢝
    0x489E: 'nù,shù',  # 䢞
    0x489F: 'yóu',  # 䢟
    0x48A0: 'sòng',  # 䢠
    0x48A1: 'xiè',  # 䢡
    0x48A2: 'càng',  # 䢢
    0x48A3: 'yáo',  # 䢣
    0x48A4: 'shù',  # 䢤
    0x48A5: 'yán,yàn',  # 䢥
    0x48A6: 'shuài',  # 䢦
    0x48A7: 'liào,lǐn,què',  # 䢧
    # 0x48A8: '',  # 䢨
    0x48A9: 'yù',  # 䢩
    0x48AA: 'bó,cuì,jiǎo,nǔ,qián',  # 䢪
    0x48AB: 'suí',  # 䢫
    # 0x48AC: '',  # 䢬
    0x48AD: 'yàn',  # 䢭
    0x48AE: 'lèi',  # 䢮
    0x48AF: 'lín',  # 䢯
    0x48B0: 'tái,tì',  # 䢰
    0x48B1: 'dú,zhà',  # 䢱
    0x48B2: 'yuè',  # 䢲
    0x48B3: 'jǐ,jì',  # 䢳
    # 0x48B4: '',  # 䢴
    0x48B5: 'yún',  # 䢵
    # 0x48B6: '',  # 䢶
    # 0x48B7: '',  # 䢷
    0x48B8: 'jū',  # 䢸
    0x48B9: 'jǔ',  # 䢹
    0x48BA: 'chū',  # 䢺
    0x48BB: 'chén,jìn,tán',  # 䢻
    0x48BC: 'gōng',  # 䢼
    0x48BD: 'xiàng',  # 䢽
    0x48BE: 'xiǎn',  # 䢾
    # 0x48BF: '',  # 䢿
    0x48C0: 'guǐ,wéi',  # 䣀
    0x48C1: 'yǔ',  # 䣁
    0x48C2: 'lěi,lèi',  # 䣂
    # 0x48C3: '',  # 䣃
    0x48C4: 'tú',  # 䣄
    0x48C5: 'chén',  # 䣅
    0x48C6: 'xíng',  # 䣆
    0x48C7: 'qiú',  # 䣇
    0x48C8: 'hàng,liáo,xiàng',  # 䣈
    # 0x48C9: '',  # 䣉
    0x48CA: 'dǎng',  # 䣊
    0x48CB: 'cǎi',  # 䣋
    0x48CC: 'dǐ',  # 䣌
    0x48CD: 'yǎn',  # 䣍
    # 0x48CE: '',  # 䣎
    # 0x48CF: '',  # 䣏
    # 0x48D0: '',  # 䣐
    0x48D1: 'chán',  # 䣑
    # 0x48D2: '',  # 䣒
    0x48D3: 'lí',  # 䣓
    0x48D4: 'suǒ,suò',  # 䣔
    0x48D5: 'mǎ,mà',  # 䣕
    0x48D6: 'mǎ',  # 䣖
    # 0x48D7: '',  # 䣗
    0x48D8: 'táng',  # 䣘
    0x48D9: 'péi',  # 䣙
    0x48DA: 'lóu,lú',  # 䣚
    0x48DB: 'qī',  # 䣛
    0x48DC: 'cuó',  # 䣜
    0x48DD: 'tú',  # 䣝
    0x48DE: 'è',  # 䣞
    0x48DF: 'cán',  # 䣟
    0x48E0: 'jié,tì',  # 䣠
    0x48E1: 'tí,yí',  # 䣡
    0x48E2: 'jí',  # 䣢
    0x48E3: 'dǎng,dào',  # 䣣
    0x48E4: 'jiào,jué',  # 䣤
    0x48E5: 'bǐ,mì',  # 䣥
    0x48E6: 'lèi',  # 䣦
    0x48E7: 'yì',  # 䣧
    0x48E8: 'chún',  # 䣨
    0x48E9: 'chún',  # 䣩
    0x48EA: 'pò',  # 䣪
    0x48EB: 'lí',  # 䣫
    0x48EC: 'zǎi',  # 䣬
    0x48ED: 'tài',  # 䣭
    0x48EE: 'pò',  # 䣮
    0x48EF: 'tiǎn',  # 䣯
    0x48F0: 'jù,yuàn',  # 䣰
    0x48F1: 'xù,yì',  # 䣱
    0x48F2: 'fàn',  # 䣲
    # 0x48F3: '',  # 䣳
    0x48F4: 'xù',  # 䣴
    0x48F5: 'èr',  # 䣵
    0x48F6: 'huó,tián',  # 䣶
    # 0x48F7: '',  # 䣷
    0x48F8: 'rǎn',  # 䣸
    0x48F9: 'fá',  # 䣹
    0x48FA: 'juān',  # 䣺
    # 0x48FB: '',  # 䣻
    0x48FC: 'liáng',  # 䣼
    0x48FD: 'tǐ',  # 䣽
    0x48FE: 'mì',  # 䣾
    # 0x48FF: '',  # 䣿
    # 0x4900: '',  # 䤀
    0x4901: 'cén,chè,shè,yín',  # 䤁
    0x4902: 'méi',  # 䤂
    0x4903: 'yìn',  # 䤃
    0x4904: 'miǎn,zhuàn',  # 䤄
    0x4905: 'tú',  # 䤅
    0x4906: 'kuí',  # 䤆
    # 0x4907: '',  # 䤇
    # 0x4908: '',  # 䤈
    0x4909: 'mì,míng,mò,rú',  # 䤉
    0x490A: 'róng',  # 䤊
    0x490B: 'guó,yù',  # 䤋
    # 0x490C: '',  # 䤌
    0x490D: 'mí',  # 䤍
    0x490E: 'jú',  # 䤎
    0x490F: 'pǐ',  # 䤏
    0x4910: 'jǐn',  # 䤐
    0x4911: 'wàng',  # 䤑
    0x4912: 'jǐ,jì',  # 䤒
    0x4913: 'méng',  # 䤓
    0x4914: 'jiàn,niú,xiàng',  # 䤔
    0x4915: 'xuè',  # 䤕
    0x4916: 'bào',  # 䤖
    0x4917: 'gǎn',  # 䤗
    0x4918: 'chǎn,qiǎn',  # 䤘
    0x4919: 'lì',  # 䤙
    0x491A: 'lǐ,lüè',  # 䤚
    0x491B: 'qiú',  # 䤛
    0x491C: 'dùn',  # 䤜
    0x491D: 'yìng',  # 䤝
    0x491E: 'yǔn',  # 䤞
    0x491F: 'chén',  # 䤟
    0x4920: 'jī,zhǐ',  # 䤠
    0x4921: 'rǎn',  # 䤡
    # 0x4922: '',  # 䤢
    # 0x4923: '',  # 䤣
    # 0x4924: '',  # 䤤
    0x4925: 'guǐ',  # 䤥
    0x4926: 'yuè',  # 䤦
    0x4927: 'huì',  # 䤧
    0x4928: 'pì',  # 䤨
    0x4929: 'chá',  # 䤩
    0x492A: 'duǒ',  # 䤪
    0x492B: 'chán',  # 䤫
    # 0x492C: '',  # 䤬
    0x492D: 'kuàn,shì,suì,yí',  # 䤭
    0x492E: 'shè',  # 䤮
    0x492F: 'xíng',  # 䤯
    0x4930: 'wěng,yíng',  # 䤰
    0x4931: 'shì',  # 䤱
    0x4932: 'chì',  # 䤲
    0x4933: 'yè',  # 䤳
    0x4934: 'hán',  # 䤴
    0x4935: 'fèi',  # 䤵
    0x4936: 'yè',  # 䤶
    0x4937: 'yán,yǎn',  # 䤷
    0x4938: 'zuàn',  # 䤸
    # 0x4939: '',  # 䤹
    0x493A: 'yǐn',  # 䤺
    0x493B: 'duò',  # 䤻
    0x493C: 'xiàn',  # 䤼
    # 0x493D: '',  # 䤽
    # 0x493E: '',  # 䤾
    0x493F: 'qiè',  # 䤿
    0x4940: 'chǎn',  # 䥀
    0x4941: 'hán',  # 䥁
    0x4942: 'mèng',  # 䥂
    0x4943: 'yuè',  # 䥃
    0x4944: 'cù,zǎn,zàn',  # 䥄
    0x4945: 'qiàn,qín',  # 䥅
    0x4946: 'jǐn,qín,ròu,wèi',  # 䥆
    0x4947: 'shàn',  # 䥇
    0x4948: 'mǔ',  # 䥈
    # 0x4949: '',  # 䥉
    # 0x494A: '',  # 䥊
    # 0x494B: '',  # 䥋
    0x494C: 'zhèng',  # 䥌
    0x494D: 'zhì',  # 䥍
    0x494E: 'chún',  # 䥎
    0x494F: 'yǔ',  # 䥏
    0x4950: 'móu',  # 䥐
    0x4951: 'wàn',  # 䥑
    0x4952: 'jiàng',  # 䥒
    # 0x4953: '',  # 䥓
    0x4954: 'sù',  # 䥔
    0x4955: 'piě',  # 䥕
    0x4956: 'tián',  # 䥖
    0x4957: 'kuǎn',  # 䥗
    0x4958: 'cù,cuò',  # 䥘
    0x4959: 'suì',  # 䥙
    # 0x495A: '',  # 䥚
    0x495B: 'jié',  # 䥛
    0x495C: 'jiàn',  # 䥜
    0x495D: 'áo,āo',  # 䥝
    0x495E: 'jiǎo',  # 䥞
    0x495F: 'yè',  # 䥟
    # 0x4960: '',  # 䥠
    0x4961: 'yè',  # 䥡
    0x4962: 'lóng',  # 䥢
    0x4963: 'záo',  # 䥣
    0x4964: 'báo,fú',  # 䥤
    0x4965: 'lián',  # 䥥
    # 0x4966: '',  # 䥦
    0x4967: 'huán,xuán',  # 䥧
    # 0x4968: '',  # 䥨
    0x4969: 'wéi',  # 䥩
    0x496A: 'xiǎn',  # 䥪
    0x496B: 'tiě',  # 䥫
    0x496C: 'bó',  # 䥬
    0x496D: 'zhèng',  # 䥭
    0x496E: 'zhú',  # 䥮
    0x496F: 'bà,bài,bēi',  # 䥯
    0x4970: 'mèng',  # 䥰
    0x4971: 'xiě',  # 䥱
    # 0x4972: '',  # 䥲
    # 0x4973: '',  # 䥳
    0x4974: 'juān',  # 䥴
    0x4975: 'xiǎo',  # 䥵
    0x4976: 'lì',  # 䥶
    0x4977: 'zhá',  # 䥷
    0x4978: 'mí',  # 䥸
    # 0x4979: '',  # 䥹
    0x497A: 'yé',  # 䥺
    # 0x497B: '',  # 䥻
    # 0x497C: '',  # 䥼
    # 0x497D: '',  # 䥽
    0x497E: 'xiě',  # 䥾
    # 0x497F: '',  # 䥿
    # 0x4980: '',  # 䦀
    # 0x4981: '',  # 䦁
    0x4982: 'shàn',  # 䦂
    # 0x4983: '',  # 䦃
    # 0x4984: '',  # 䦄
    0x4985: 'shàn,zhǎn',  # 䦅
    0x4986: 'jué',  # 䦆
    0x4987: 'jì',  # 䦇
    0x4988: 'fǎng,hǎn,jí,mǒu,zá,zuǒ',  # 䦈
    # 0x4989: '',  # 䦉
    0x498A: 'niǎo',  # 䦊
    0x498B: 'áo',  # 䦋
    0x498C: 'chù,pò,ruì',  # 䦌
    0x498D: 'wù',  # 䦍
    0x498E: 'guǎn',  # 䦎
    0x498F: 'xiè',  # 䦏
    0x4990: 'tǐng',  # 䦐
    0x4991: 'xiè',  # 䦑
    0x4992: 'dàng',  # 䦒
    # 0x4993: '',  # 䦓
    0x4994: 'tǎn',  # 䦔
    # 0x4995: '',  # 䦕
    0x4996: 'xiá,xié',  # 䦖
    0x4997: 'xù',  # 䦗
    0x4998: 'bì,xiǎn,xiàn',  # 䦘
    0x4999: 'sì',  # 䦙
    0x499A: 'huò,kuǎ,kuà',  # 䦚
    0x499B: 'zhèng,zhì',  # 䦛
    0x499C: 'wú,wù',  # 䦜
    # 0x499D: '',  # 䦝
    0x499E: 'rùn',  # 䦞
    0x499F: 'chuài',  # 䦟
    0x49A0: 'shǐ',  # 䦠
    0x49A1: 'huán',  # 䦡
    0x49A2: 'kuò',  # 䦢
    0x49A3: 'fù',  # 䦣
    0x49A4: 'chuài,wěn',  # 䦤
    0x49A5: 'xián',  # 䦥
    0x49A6: 'qín',  # 䦦
    0x49A7: 'qié,xì,yǎn',  # 䦧
    0x49A8: 'lán',  # 䦨
    0x49A9: 'wén',  # 䦩
    0x49AA: 'yà',  # 䦪
    # 0x49AB: '',  # 䦫
    0x49AC: 'què',  # 䦬
    # 0x49AD: '',  # 䦭
    0x49AE: 'chǔn',  # 䦮
    0x49AF: 'zhì',  # 䦯
    # 0x49B0: '',  # 䦰
    0x49B1: 'kuǐ,wěi',  # 䦱
    0x49B2: 'qiàn,yán',  # 䦲
    0x49B3: 'hàng,xiàng',  # 䦳
    0x49B4: 'yì',  # 䦴
    0x49B5: 'nǐ',  # 䦵
    0x49B6: 'zhèng',  # 䦶
    0x49B7: 'chuài,wěn',  # 䦷
    # 0x49B8: '',  # 䦸
    0x49B9: 'shí',  # 䦹
    0x49BA: 'dīng',  # 䦺
    0x49BB: 'cì,zǐ',  # 䦻
    0x49BC: 'jué',  # 䦼
    0x49BD: 'xù',  # 䦽
    0x49BE: 'yǔn',  # 䦾
    # 0x49BF: '',  # 䦿
    # 0x49C0: '',  # 䧀
    0x49C1: 'chù,xǔ',  # 䧁
    0x49C2: 'dào,tiǎo,zhào',  # 䧂
    0x49C3: 'diàn,tián',  # 䧃
    0x49C4: 'gè',  # 䧄
    0x49C5: 'tì,yà,yí',  # 䧅
    0x49C6: 'hóng,kǒu,qióng',  # 䧆
    0x49C7: 'nǐ,yǐ,yī',  # 䧇
    # 0x49C8: '',  # 䧈
    0x49C9: 'lǐ',  # 䧉
    0x49CA: 'kū',  # 䧊
    0x49CB: 'xiǎn',  # 䧋
    # 0x49CC: '',  # 䧌
    0x49CD: 'xì',  # 䧍
    0x49CE: 'xuàn',  # 䧎
    # 0x49CF: '',  # 䧏
    # 0x49D0: '',  # 䧐
    # 0x49D1: '',  # 䧑
    0x49D2: 'lái,lǎn',  # 䧒
    # 0x49D3: '',  # 䧓
    0x49D4: 'mù,niàn',  # 䧔
    0x49D5: 'chéng,yù',  # 䧕
    0x49D6: 'jiàn',  # 䧖
    0x49D7: 'bì',  # 䧗
    0x49D8: 'qí,zhuàn',  # 䧘
    0x49D9: 'líng',  # 䧙
    0x49DA: 'hào',  # 䧚
    0x49DB: 'bàng',  # 䧛
    0x49DC: 'táng',  # 䧜
    0x49DD: 'chī,zhì',  # 䧝
    0x49DE: 'fù,mà',  # 䧞
    0x49DF: 'xiàn,xuàn',  # 䧟
    0x49E0: 'shuàn',  # 䧠
    # 0x49E1: '',  # 䧡
    0x49E2: 'qū',  # 䧢
    # 0x49E3: '',  # 䧣
    0x49E4: 'pú',  # 䧤
    0x49E5: 'huì',  # 䧥
    0x49E6: 'wéi,huī',  # 䧦
    0x49E7: 'yǐ',  # 䧧
    0x49E8: 'yè',  # 䧨
    # 0x49E9: '',  # 䧩
    0x49EA: 'chè,zhé',  # 䧪
    0x49EB: 'háo',  # 䧫
    # 0x49EC: '',  # 䧬
    # 0x49ED: '',  # 䧭
    0x49EE: 'xiǎn,xiàn',  # 䧮
    0x49EF: 'chán,zhàn',  # 䧯
    0x49F0: 'hùn',  # 䧰
    # 0x49F1: '',  # 䧱
    0x49F2: 'hàn',  # 䧲
    0x49F3: 'cí,cǐ',  # 䧳
    0x49F4: 'zhī',  # 䧴
    0x49F5: 'qí,shěn,zhèn',  # 䧵
    0x49F6: 'kuí',  # 䧶
    0x49F7: 'róu',  # 䧷
    # 0x49F8: '',  # 䧸
    # 0x49F9: '',  # 䧹
    0x49FA: 'xióng',  # 䧺
    # 0x49FB: '',  # 䧻
    0x49FC: 'hú',  # 䧼
    0x49FD: 'cuǐ',  # 䧽
    # 0x49FE: '',  # 䧾
    0x49FF: 'què',  # 䧿
    0x4A00: 'dí,dì',  # 䨀
    0x4A01: 'chè,wù,yù',  # 䨁
    # 0x4A02: '',  # 䨂
    # 0x4A03: '',  # 䨃
    0x4A04: 'yàn,ān',  # 䨄
    0x4A05: 'liáo',  # 䨅
    0x4A06: 'bí,bì,xù',  # 䨆
    # 0x4A07: '',  # 䨇
    # 0x4A08: '',  # 䨈
    # 0x4A09: '',  # 䨉
    0x4A0A: 'yuān',  # 䨊
    # 0x4A0B: '',  # 䨋
    0x4A0C: 'báo,bó',  # 䨌
    0x4A0D: 'yǐng',  # 䨍
    0x4A0E: 'hóng',  # 䨎
    0x4A0F: 'cí',  # 䨏
    0x4A10: 'qià,xiá',  # 䨐
    0x4A11: 'tí',  # 䨑
    0x4A12: 'yù',  # 䨒
    0x4A13: 'léi,lèi',  # 䨓
    0x4A14: 'báo',  # 䨔
    # 0x4A15: '',  # 䨕
    0x4A16: 'jì',  # 䨖
    0x4A17: 'fú',  # 䨗
    0x4A18: 'xiàn',  # 䨘
    0x4A19: 'cén,yà,yín',  # 䨙
    # 0x4A1A: '',  # 䨚
    0x4A1B: 'sè',  # 䨛
    # 0x4A1C: '',  # 䨜
    # 0x4A1D: '',  # 䨝
    0x4A1E: 'yǔ,yù',  # 䨞
    # 0x4A1F: '',  # 䨟
    0x4A20: 'ǎi',  # 䨠
    0x4A21: 'hán',  # 䨡
    0x4A22: 'dàn,dí,gào,tán',  # 䨢
    0x4A23: 'gé,gèng',  # 䨣
    0x4A24: 'dí',  # 䨤
    0x4A25: 'hù,huò',  # 䨥
    0x4A26: 'páng',  # 䨦
    # 0x4A27: '',  # 䨧
    # 0x4A28: '',  # 䨨
    0x4A29: 'líng',  # 䨩
    0x4A2A: 'mái',  # 䨪
    0x4A2B: 'mài,màn',  # 䨫
    0x4A2C: 'lián',  # 䨬
    # 0x4A2D: '',  # 䨭
    0x4A2E: 'xuě',  # 䨮
    0x4A2F: 'zhèn',  # 䨯
    0x4A30: 'pò',  # 䨰
    0x4A31: 'fù',  # 䨱
    0x4A32: 'nóu',  # 䨲
    0x4A33: 'xì',  # 䨳
    0x4A34: 'duì,wèng',  # 䨴
    0x4A35: 'dàn',  # 䨵
    0x4A36: 'yǔn',  # 䨶
    0x4A37: 'xiàn',  # 䨷
    0x4A38: 'yǐn',  # 䨸
    # 0x4A39: '',  # 䨹
    0x4A3A: 'duì',  # 䨺
    0x4A3B: 'bèng',  # 䨻
    0x4A3C: 'hù',  # 䨼
    0x4A3D: 'fěi',  # 䨽
    0x4A3E: 'fěi',  # 䨾
    0x4A3F: 'qián,zá',  # 䨿
    0x4A40: 'bèi',  # 䩀
    0x4A41: 'fēi',  # 䩁
    # 0x4A42: '',  # 䩂
    0x4A43: 'shì',  # 䩃
    0x4A44: 'tiǎn',  # 䩄
    0x4A45: 'zhǎn',  # 䩅
    0x4A46: 'jiǎn,zhǎn',  # 䩆
    # 0x4A47: '',  # 䩇
    0x4A48: 'huì,wèi,xuě',  # 䩈
    0x4A49: 'fǔ',  # 䩉
    0x4A4A: 'wǎn,wò',  # 䩊
    0x4A4B: 'mǒ',  # 䩋
    0x4A4C: 'qiáo,jiāo',  # 䩌
    0x4A4D: 'liǎo',  # 䩍
    # 0x4A4E: '',  # 䩎
    0x4A4F: 'miè',  # 䩏
    0x4A50: 'gé,jí',  # 䩐
    0x4A51: 'hóng',  # 䩑
    0x4A52: 'yú',  # 䩒
    0x4A53: 'qí',  # 䩓
    0x4A54: 'duò',  # 䩔
    0x4A55: 'áng',  # 䩕
    # 0x4A56: '',  # 䩖
    0x4A57: 'bà',  # 䩗
    0x4A58: 'dì',  # 䩘
    0x4A59: 'xuàn',  # 䩙
    0x4A5A: 'dì,diàn',  # 䩚
    0x4A5B: 'bì',  # 䩛
    0x4A5C: 'zhòu',  # 䩜
    0x4A5D: 'páo',  # 䩝
    0x4A5E: 'nián,tiǎn,tié,wěi',  # 䩞
    0x4A5F: 'yí,tì',  # 䩟
    # 0x4A60: '',  # 䩠
    0x4A61: 'jiá',  # 䩡
    0x4A62: 'dá,zhì',  # 䩢
    0x4A63: 'duǒ,tú,tuì',  # 䩣
    0x4A64: 'xì,xié',  # 䩤
    0x4A65: 'dàn',  # 䩥
    0x4A66: 'tiáo,zuò',  # 䩦
    0x4A67: 'xiè',  # 䩧
    0x4A68: 'chàng',  # 䩨
    0x4A69: 'yuǎn',  # 䩩
    0x4A6A: 'guǎn',  # 䩪
    0x4A6B: 'liǎng',  # 䩫
    0x4A6C: 'běng,fěng',  # 䩬
    # 0x4A6D: '',  # 䩭
    0x4A6E: 'lù',  # 䩮
    0x4A6F: 'jí',  # 䩯
    0x4A70: 'xuàn',  # 䩰
    0x4A71: 'shù',  # 䩱
    # 0x4A72: '',  # 䩲
    0x4A73: 'shǔ,sù',  # 䩳
    0x4A74: 'hú',  # 䩴
    0x4A75: 'yùn',  # 䩵
    0x4A76: 'chǎn,chěng',  # 䩶
    # 0x4A77: '',  # 䩷
    0x4A78: 'róng,rǒng',  # 䩸
    0x4A79: 'é',  # 䩹
    # 0x4A7A: '',  # 䩺
    0x4A7B: 'bà',  # 䩻
    0x4A7C: 'féng',  # 䩼
    # 0x4A7D: '',  # 䩽
    0x4A7E: 'zhè',  # 䩾
    0x4A7F: 'fén',  # 䩿
    0x4A80: 'guǎn,ruǎn',  # 䪀
    0x4A81: 'bǔ',  # 䪁
    0x4A82: 'gé',  # 䪂
    # 0x4A83: '',  # 䪃
    0x4A84: 'huáng',  # 䪄
    0x4A85: 'dú',  # 䪅
    0x4A86: 'tǐ',  # 䪆
    0x4A87: 'bó',  # 䪇
    0x4A88: 'qiǎn,qiàn',  # 䪈
    0x4A89: 'là,liè',  # 䪉
    0x4A8A: 'lóng',  # 䪊
    0x4A8B: 'wèi',  # 䪋
    0x4A8C: 'zhàn',  # 䪌
    0x4A8D: 'lán,làn',  # 䪍
    0x4A8E: 'suī',  # 䪎
    0x4A8F: 'nà,dā',  # 䪏
    0x4A90: 'bì,pì',  # 䪐
    0x4A91: 'tuó',  # 䪑
    0x4A92: 'jiào,zhì,zhù',  # 䪒
    # 0x4A93: '',  # 䪓
    0x4A94: 'bǔ',  # 䪔
    0x4A95: 'jú',  # 䪕
    0x4A96: 'pò',  # 䪖
    0x4A97: 'xiá',  # 䪗
    0x4A98: 'wěi',  # 䪘
    0x4A99: 'fú,pò',  # 䪙
    0x4A9A: 'hè,tà',  # 䪚
    0x4A9B: 'fán',  # 䪛
    0x4A9C: 'chàn',  # 䪜
    0x4A9D: 'hù',  # 䪝
    0x4A9E: 'zá',  # 䪞
    # 0x4A9F: '',  # 䪟
    # 0x4AA0: '',  # 䪠
    # 0x4AA1: '',  # 䪡
    0x4AA2: 'jī',  # 䪢
    # 0x4AA3: '',  # 䪣
    0x4AA4: 'fán',  # 䪤
    0x4AA5: 'xiè',  # 䪥
    0x4AA6: 'hóng',  # 䪦
    0x4AA7: 'chí',  # 䪧
    0x4AA8: 'báo,qú',  # 䪨
    0x4AA9: 'yín',  # 䪩
    # 0x4AAA: '',  # 䪪
    # 0x4AAB: '',  # 䪫
    0x4AAC: 'bó,pú',  # 䪬
    0x4AAD: 'ruǎn',  # 䪭
    0x4AAE: 'chǒu',  # 䪮
    0x4AAF: 'yíng',  # 䪯
    # 0x4AB0: '',  # 䪰
    0x4AB1: 'gǎi',  # 䪱
    # 0x4AB2: '',  # 䪲
    0x4AB3: 'yǔn',  # 䪳
    0x4AB4: 'zhěn',  # 䪴
    0x4AB5: 'yǎ',  # 䪵
    # 0x4AB6: '',  # 䪶
    0x4AB7: 'hòu',  # 䪷
    0x4AB8: 'mín',  # 䪸
    0x4AB9: 'péi',  # 䪹
    0x4ABA: 'gé',  # 䪺
    0x4ABB: 'biàn',  # 䪻
    0x4ABC: 'zhuō',  # 䪼
    0x4ABD: 'hào',  # 䪽
    0x4ABE: 'mí,zhěn',  # 䪾
    0x4ABF: 'shěng,xìn',  # 䪿
    0x4AC0: 'gěn',  # 䫀
    0x4AC1: 'bì',  # 䫁
    0x4AC2: 'duǒ',  # 䫂
    0x4AC3: 'chún',  # 䫃
    0x4AC4: 'chuà',  # 䫄
    0x4AC5: 'sàn',  # 䫅
    0x4AC6: 'chéng,zhèng',  # 䫆
    0x4AC7: 'rán',  # 䫇
    0x4AC8: 'zèn,cén',  # 䫈
    0x4AC9: 'mào',  # 䫉
    0x4ACA: 'bó,péi',  # 䫊
    0x4ACB: 'tuí',  # 䫋
    0x4ACC: 'pǐ',  # 䫌
    0x4ACD: 'fǔ',  # 䫍
    # 0x4ACE: '',  # 䫎
    0x4ACF: 'qī',  # 䫏
    0x4AD0: 'lín',  # 䫐
    # 0x4AD1: '',  # 䫑
    0x4AD2: 'mén',  # 䫒
    0x4AD3: 'wú',  # 䫓
    0x4AD4: 'qì,qiè,xì',  # 䫔
    0x4AD5: 'zhì',  # 䫕
    0x4AD6: 'chěn,huǐ,nòu,shèn,tíng,yà,zhù',  # 䫖
    0x4AD7: 'xiá,xià',  # 䫗
    0x4AD8: 'hé',  # 䫘
    0x4AD9: 'sǎng',  # 䫙
    # 0x4ADA: '',  # 䫚
    0x4ADB: 'hóu',  # 䫛
    # 0x4ADC: '',  # 䫜
    0x4ADD: 'fǔ,fù',  # 䫝
    0x4ADE: 'ráo,qiāo',  # 䫞
    0x4ADF: 'hùn',  # 䫟
    0x4AE0: 'péi,pī',  # 䫠
    0x4AE1: 'qiàn,yán',  # 䫡
    # 0x4AE2: '',  # 䫢
    0x4AE3: 'xí',  # 䫣
    0x4AE4: 'míng',  # 䫤
    0x4AE5: 'kuǐ,wěi',  # 䫥
    0x4AE6: 'gé,kài',  # 䫦
    # 0x4AE7: '',  # 䫧
    0x4AE8: 'ào',  # 䫨
    0x4AE9: 'sǎn',  # 䫩
    0x4AEA: 'shuǎng',  # 䫪
    0x4AEB: 'lóu,lòu',  # 䫫
    0x4AEC: 'zhěn',  # 䫬
    0x4AED: 'huì',  # 䫭
    0x4AEE: 'cán,cǎn,tì',  # 䫮
    # 0x4AEF: '',  # 䫯
    0x4AF0: 'lìn,lǐn',  # 䫰
    0x4AF1: 'ná,rú',  # 䫱
    0x4AF2: 'hàn,kǎn',  # 䫲
    0x4AF3: 'dú',  # 䫳
    0x4AF4: 'jìn',  # 䫴
    0x4AF5: 'mián',  # 䫵
    0x4AF6: 'fán',  # 䫶
    0x4AF7: 'è',  # 䫷
    0x4AF8: 'náo',  # 䫸
    0x4AF9: 'hóng',  # 䫹
    0x4AFA: 'hóng,hòu',  # 䫺
    0x4AFB: 'xué,yù',  # 䫻
    0x4AFC: 'xuè',  # 䫼
    # 0x4AFD: '',  # 䫽
    0x4AFE: 'bī,bì',  # 䫾
    # 0x4AFF: '',  # 䫿
    0x4B00: 'yǒu',  # 䬀
    0x4B01: 'yí',  # 䬁
    0x4B02: 'xuè,yuè',  # 䬂
    0x4B03: 'sà',  # 䬃
    0x4B04: 'yù',  # 䬄
    0x4B05: 'lì,liè,xié',  # 䬅
    0x4B06: 'lì',  # 䬆
    0x4B07: 'yuàn',  # 䬇
    0x4B08: 'duì',  # 䬈
    0x4B09: 'hào',  # 䬉
    0x4B0A: 'qiè,shà',  # 䬊
    0x4B0B: 'léng',  # 䬋
    # 0x4B0C: '',  # 䬌
    0x4B0D: 'hū',  # 䬍
    0x4B0E: 'guó',  # 䬎
    0x4B0F: 'bù,fǒu',  # 䬏
    0x4B10: 'wěi',  # 䬐
    0x4B11: 'wèi',  # 䬑
    0x4B12: 'sōu',  # 䬒
    0x4B13: 'àn,ǎng',  # 䬓
    0x4B14: 'xù,yú',  # 䬔
    0x4B15: 'shǎng',  # 䬕
    0x4B16: 'héng',  # 䬖
    0x4B17: 'yáng',  # 䬗
    # 0x4B18: '',  # 䬘
    0x4B19: 'yáo',  # 䬙
    # 0x4B1A: '',  # 䬚
    0x4B1B: 'bì,yù',  # 䬛
    0x4B1C: 'chī',  # 䬜
    0x4B1D: 'héng,hòng',  # 䬝
    0x4B1E: 'táo',  # 䬞
    0x4B1F: 'liú',  # 䬟
    # 0x4B20: '',  # 䬠
    0x4B21: 'zhù',  # 䬡
    0x4B22: 'tāo',  # 䬢
    0x4B23: 'qì',  # 䬣
    0x4B24: 'cháo,zàn,zuò',  # 䬤
    0x4B25: 'yì',  # 䬥
    0x4B26: 'dòu',  # 䬦
    0x4B27: 'yuán',  # 䬧
    0x4B28: 'cù,jiù,zú',  # 䬨
    # 0x4B29: '',  # 䬩
    0x4B2A: 'bó,fù',  # 䬪
    0x4B2B: 'cǎn,tí',  # 䬫
    0x4B2C: 'yǎng',  # 䬬
    # 0x4B2D: '',  # 䬭
    0x4B2E: 'yí',  # 䬮
    0x4B2F: 'nián',  # 䬯
    0x4B30: 'shào',  # 䬰
    0x4B31: 'bèn',  # 䬱
    # 0x4B32: '',  # 䬲
    0x4B33: 'bǎn',  # 䬳
    0x4B34: 'mò',  # 䬴
    0x4B35: 'ài',  # 䬵
    0x4B36: 'èn',  # 䬶
    0x4B37: 'shě',  # 䬷
    # 0x4B38: '',  # 䬸
    0x4B39: 'zhì',  # 䬹
    0x4B3A: 'yàng',  # 䬺
    0x4B3B: 'jiàn,kǎn',  # 䬻
    0x4B3C: 'yuàn',  # 䬼
    0x4B3D: 'duì,shuì',  # 䬽
    0x4B3E: 'tí',  # 䬾
    0x4B3F: 'wěi,wèi',  # 䬿
    0x4B40: 'xùn',  # 䭀
    0x4B41: 'zhì',  # 䭁
    0x4B42: 'yì',  # 䭂
    0x4B43: 'rěn',  # 䭃
    0x4B44: 'shì',  # 䭄
    0x4B45: 'hú',  # 䭅
    0x4B46: 'nè',  # 䭆
    0x4B47: 'yì',  # 䭇
    0x4B48: 'jiàn',  # 䭈
    0x4B49: 'suǐ',  # 䭉
    0x4B4A: 'yǐng',  # 䭊
    0x4B4B: 'bǎo',  # 䭋
    0x4B4C: 'hú',  # 䭌
    0x4B4D: 'hú',  # 䭍
    0x4B4E: 'xié,yè',  # 䭎
    # 0x4B4F: '',  # 䭏
    0x4B50: 'yàng',  # 䭐
    0x4B51: 'lián,qiàn,xiàn',  # 䭑
    # 0x4B52: '',  # 䭒
    0x4B53: 'èn,wèn',  # 䭓
    # 0x4B54: '',  # 䭔
    0x4B55: 'jiàn,zǎn',  # 䭕
    0x4B56: 'zhù',  # 䭖
    0x4B57: 'yǐng',  # 䭗
    0x4B58: 'yàn,yǐng',  # 䭘
    0x4B59: 'jǐn',  # 䭙
    0x4B5A: 'chuáng,nè',  # 䭚
    0x4B5B: 'dàn',  # 䭛
    # 0x4B5C: '',  # 䭜
    0x4B5D: 'kuài',  # 䭝
    0x4B5E: 'yì',  # 䭞
    0x4B5F: 'yè',  # 䭟
    0x4B60: 'jiǎn,qiàn',  # 䭠
    0x4B61: 'èn,wèn',  # 䭡
    0x4B62: 'níng',  # 䭢
    0x4B63: 'cí',  # 䭣
    0x4B64: 'qiǎn',  # 䭤
    0x4B65: 'xuè,yàng,yào,zhòu',  # 䭥
    0x4B66: 'bó',  # 䭦
    0x4B67: 'mǐ',  # 䭧
    0x4B68: 'shuì',  # 䭨
    0x4B69: 'mì,mó',  # 䭩
    0x4B6A: 'liáng',  # 䭪
    0x4B6B: 'qǐ',  # 䭫
    0x4B6C: 'qǐ',  # 䭬
    0x4B6D: 'shǒu,shú,shù,tù',  # 䭭
    0x4B6E: 'bì,fú',  # 䭮
    0x4B6F: 'bó',  # 䭯
    0x4B70: 'běng,bèng',  # 䭰
    0x4B71: 'bié',  # 䭱
    0x4B72: 'nǐ,yǐ',  # 䭲
    0x4B73: 'wèi',  # 䭳
    0x4B74: 'huán,yuàn',  # 䭴
    0x4B75: 'fán',  # 䭵
    0x4B76: 'qí',  # 䭶
    0x4B77: 'liú,máo',  # 䭷
    0x4B78: 'fù',  # 䭸
    0x4B79: 'áng,àng',  # 䭹
    0x4B7A: 'áng',  # 䭺
    # 0x4B7B: '',  # 䭻
    0x4B7C: 'qí',  # 䭼
    0x4B7D: 'qún',  # 䭽
    0x4B7E: 'tuó',  # 䭾
    0x4B7F: 'yì',  # 䭿
    0x4B80: 'bó',  # 䮀
    0x4B81: 'pián',  # 䮁
    0x4B82: 'bó',  # 䮂
    # 0x4B83: '',  # 䮃
    0x4B84: 'xuán',  # 䮄
    # 0x4B85: '',  # 䮅
    # 0x4B86: '',  # 䮆
    0x4B87: 'yù',  # 䮇
    0x4B88: 'chí',  # 䮈
    0x4B89: 'lú',  # 䮉
    0x4B8A: 'yí',  # 䮊
    0x4B8B: 'lì,liè',  # 䮋
    # 0x4B8C: '',  # 䮌
    0x4B8D: 'niǎo,xìng',  # 䮍
    0x4B8E: 'xì',  # 䮎
    0x4B8F: 'wú',  # 䮏
    # 0x4B90: '',  # 䮐
    0x4B91: 'lèi',  # 䮑
    # 0x4B92: '',  # 䮒
    0x4B93: 'zhào',  # 䮓
    0x4B94: 'zuǐ,zuī',  # 䮔
    0x4B95: 'chuò',  # 䮕
    # 0x4B96: '',  # 䮖
    0x4B97: 'àn,niù,yàn',  # 䮗
    0x4B98: 'ér,ní,pài,pó',  # 䮘
    0x4B99: 'yù',  # 䮙
    0x4B9A: 'lèng',  # 䮚
    0x4B9B: 'fù',  # 䮛
    0x4B9C: 'shà,zhá',  # 䮜
    0x4B9D: 'huán,huǎn,hún',  # 䮝
    0x4B9E: 'chù,chǔn',  # 䮞
    0x4B9F: 'sǒu',  # 䮟
    # 0x4BA0: '',  # 䮠
    0x4BA1: 'bì',  # 䮡
    0x4BA2: 'dié',  # 䮢
    # 0x4BA3: '',  # 䮣
    0x4BA4: 'dí,hè,hé',  # 䮤
    0x4BA5: 'lì',  # 䮥
    # 0x4BA6: '',  # 䮦
    0x4BA7: 'hán,hàn',  # 䮧
    0x4BA8: 'zǎi',  # 䮨
    0x4BA9: 'gú,gǔ',  # 䮩
    0x4BAA: 'chéng',  # 䮪
    0x4BAB: 'lóu',  # 䮫
    0x4BAC: 'mò',  # 䮬
    0x4BAD: 'mì',  # 䮭
    0x4BAE: 'mài',  # 䮮
    0x4BAF: 'ào',  # 䮯
    0x4BB0: 'zhé',  # 䮰
    0x4BB1: 'zhú',  # 䮱
    0x4BB2: 'huáng',  # 䮲
    0x4BB3: 'fán',  # 䮳
    0x4BB4: 'dèng',  # 䮴
    0x4BB5: 'tóng,yǒng',  # 䮵
    # 0x4BB6: '',  # 䮶
    0x4BB7: 'dú',  # 䮷
    0x4BB8: 'hú,mú,wò',  # 䮸
    0x4BB9: 'wèi',  # 䮹
    0x4BBA: 'jì',  # 䮺
    0x4BBB: 'chì,dǎo,dào,děi',  # 䮻
    0x4BBC: 'lín',  # 䮼
    # 0x4BBD: '',  # 䮽
    0x4BBE: 'páng',  # 䮾
    0x4BBF: 'jiǎn',  # 䮿
    0x4BC0: 'niè',  # 䯀
    0x4BC1: 'luó',  # 䯁
    0x4BC2: 'jí,shēn',  # 䯂
    # 0x4BC3: '',  # 䯃
    # 0x4BC4: '',  # 䯄
    0x4BC5: 'niè',  # 䯅
    0x4BC6: 'yì',  # 䯆
    # 0x4BC7: '',  # 䯇
    0x4BC8: 'wán',  # 䯈
    0x4BC9: 'yà,wā',  # 䯉
    0x4BCA: 'qià',  # 䯊
    0x4BCB: 'bó',  # 䯋
    0x4BCC: 'kāo',  # 䯌
    0x4BCD: 'líng',  # 䯍
    0x4BCE: 'gàn',  # 䯎
    0x4BCF: 'huó,guā',  # 䯏
    0x4BD0: 'hái',  # 䯐
    # 0x4BD1: '',  # 䯑
    0x4BD2: 'héng',  # 䯒
    0x4BD3: 'kuí',  # 䯓
    0x4BD4: 'cén,zé',  # 䯔
    # 0x4BD5: '',  # 䯕
    0x4BD6: 'láng',  # 䯖
    0x4BD7: 'bì',  # 䯗
    0x4BD8: 'huàn',  # 䯘
    0x4BD9: 'pò',  # 䯙
    0x4BDA: 'ǒu,yǎo',  # 䯚
    0x4BDB: 'jiǎn,wàn',  # 䯛
    0x4BDC: 'tì',  # 䯜
    0x4BDD: 'suǐ',  # 䯝
    0x4BDE: 'kuā',  # 䯞
    0x4BDF: 'duì,xiá',  # 䯟
    0x4BE0: 'ǎo,ào',  # 䯠
    0x4BE1: 'jiǎn,jiàn,qiàn',  # 䯡
    0x4BE2: 'mó,mǒ',  # 䯢
    0x4BE3: 'guì,kuì',  # 䯣
    0x4BE4: 'kuài',  # 䯤
    0x4BE5: 'àn,qì',  # 䯥
    0x4BE6: 'mà',  # 䯦
    0x4BE7: 'qǐng',  # 䯧
    0x4BE8: 'fén,hè',  # 䯨
    # 0x4BE9: '',  # 䯩
    0x4BEA: 'kǎo',  # 䯪
    0x4BEB: 'hào,shà',  # 䯫
    0x4BEC: 'duǒ',  # 䯬
    # 0x4BED: '',  # 䯭
    0x4BEE: 'nái',  # 䯮
    # 0x4BEF: '',  # 䯯
    0x4BF0: 'jiè',  # 䯰
    0x4BF1: 'fù,pēi,pī',  # 䯱
    0x4BF2: 'pá',  # 䯲
    # 0x4BF3: '',  # 䯳
    0x4BF4: 'cháng',  # 䯴
    0x4BF5: 'niè',  # 䯵
    0x4BF6: 'mán',  # 䯶
    # 0x4BF7: '',  # 䯷
    0x4BF8: 'cì',  # 䯸
    # 0x4BF9: '',  # 䯹
    0x4BFA: 'kuò',  # 䯺
    # 0x4BFB: '',  # 䯻
    0x4BFC: 'dí',  # 䯼
    0x4BFD: 'fǔ,póu',  # 䯽
    0x4BFE: 'tiáo',  # 䯾
    0x4BFF: 'zú,zuó',  # 䯿
    0x4C00: 'wǒ',  # 䰀
    0x4C01: 'fèi',  # 䰁
    0x4C02: 'cài',  # 䰂
    0x4C03: 'péng',  # 䰃
    0x4C04: 'shì',  # 䰄
    # 0x4C05: '',  # 䰅
    0x4C06: 'róu',  # 䰆
    0x4C07: 'qí',  # 䰇
    0x4C08: 'chǎ,cuó,cuǒ',  # 䰈
    0x4C09: 'pán,pàn',  # 䰉
    0x4C0A: 'bó',  # 䰊
    0x4C0B: 'mán',  # 䰋
    0x4C0C: 'zǒng',  # 䰌
    0x4C0D: 'cì,qī,xiū',  # 䰍
    0x4C0E: 'guì,huǐ,kuì',  # 䰎
    0x4C0F: 'jì',  # 䰏
    0x4C10: 'lán',  # 䰐
    # 0x4C11: '',  # 䰑
    0x4C12: 'méng',  # 䰒
    0x4C13: 'mián',  # 䰓
    0x4C14: 'pán',  # 䰔
    0x4C15: 'lú',  # 䰕
    0x4C16: 'cuán',  # 䰖
    0x4C17: 'jiū',  # 䰗
    0x4C18: 'liú',  # 䰘
    0x4C19: 'yǐ',  # 䰙
    0x4C1A: 'wén',  # 䰚
    0x4C1B: 'lì',  # 䰛
    0x4C1C: 'lì',  # 䰜
    0x4C1D: 'zèng',  # 䰝
    0x4C1E: 'zhǔ',  # 䰞
    0x4C1F: 'hún',  # 䰟
    0x4C20: 'shén,shēn',  # 䰠
    0x4C21: 'chì',  # 䰡
    0x4C22: 'xìng',  # 䰢
    0x4C23: 'wǎng',  # 䰣
    # 0x4C24: '',  # 䰤
    0x4C25: 'huò,jì,shè,yù',  # 䰥
    0x4C26: 'pǐ,pì',  # 䰦
    0x4C27: 'hū',  # 䰧
    0x4C28: 'mèi',  # 䰨
    0x4C29: 'chě,chǐ',  # 䰩
    0x4C2A: 'mèi',  # 䰪
    0x4C2B: 'cháo',  # 䰫
    0x4C2C: 'jú',  # 䰬
    0x4C2D: 'nòu,rú',  # 䰭
    # 0x4C2E: '',  # 䰮
    0x4C2F: 'nǐ,rán,yì',  # 䰯
    0x4C30: 'rú',  # 䰰
    0x4C31: 'líng',  # 䰱
    0x4C32: 'yà',  # 䰲
    # 0x4C33: '',  # 䰳
    0x4C34: 'qì,zhì',  # 䰴
    # 0x4C35: '',  # 䰵
    # 0x4C36: '',  # 䰶
    0x4C37: 'bàng,bó',  # 䰷
    # 0x4C38: '',  # 䰸
    0x4C39: 'zé',  # 䰹
    0x4C3A: 'jiè',  # 䰺
    0x4C3B: 'yú',  # 䰻
    0x4C3C: 'xín,qín',  # 䰼
    0x4C3D: 'bèi',  # 䰽
    0x4C3E: 'bā',  # 䰾
    0x4C3F: 'tuó',  # 䰿
    # 0x4C40: '',  # 䱀
    0x4C41: 'qiáo',  # 䱁
    0x4C42: 'yǒu',  # 䱂
    0x4C43: 'dǐ,zhì',  # 䱃
    0x4C44: 'jiè',  # 䱄
    0x4C45: 'mò',  # 䱅
    0x4C46: 'shéng',  # 䱆
    0x4C47: 'shàn,táo',  # 䱇
    0x4C48: 'qí,yì',  # 䱈
    0x4C49: 'shàn',  # 䱉
    0x4C4A: 'mǐ',  # 䱊
    0x4C4B: 'dǎn,gǒng',  # 䱋
    0x4C4C: 'yí',  # 䱌
    0x4C4D: 'gèng',  # 䱍
    0x4C4E: 'gèng',  # 䱎
    0x4C4F: 'tǒu',  # 䱏
    # 0x4C50: '',  # 䱐
    0x4C51: 'xué',  # 䱑
    0x4C52: 'yì',  # 䱒
    0x4C53: 'tíng',  # 䱓
    0x4C54: 'tiáo',  # 䱔
    0x4C55: 'móu',  # 䱕
    0x4C56: 'liú,liǔ',  # 䱖
    # 0x4C57: '',  # 䱗
    0x4C58: 'lí',  # 䱘
    # 0x4C59: '',  # 䱙
    0x4C5A: 'lù',  # 䱚
    0x4C5B: 'huò',  # 䱛
    0x4C5C: 'cuò,què',  # 䱜
    0x4C5D: 'bà,pái',  # 䱝
    0x4C5E: 'liú,nài,wěi',  # 䱞
    0x4C5F: 'jù',  # 䱟
    0x4C60: 'zhàn',  # 䱠
    0x4C61: 'jú',  # 䱡
    # 0x4C62: '',  # 䱢
    0x4C63: 'zú',  # 䱣
    0x4C64: 'xiàn',  # 䱤
    0x4C65: 'zhì,jì',  # 䱥
    # 0x4C66: '',  # 䱦
    # 0x4C67: '',  # 䱧
    0x4C68: 'zhì',  # 䱨
    # 0x4C69: '',  # 䱩
    # 0x4C6A: '',  # 䱪
    0x4C6B: 'là',  # 䱫
    0x4C6C: 'xū',  # 䱬
    0x4C6D: 'gèng',  # 䱭
    0x4C6E: 'é',  # 䱮
    0x4C6F: 'mú',  # 䱯
    0x4C70: 'zhòng',  # 䱰
    0x4C71: 'dì,tí',  # 䱱
    0x4C72: 'yán',  # 䱲
    # 0x4C73: '',  # 䱳
    0x4C74: 'gèng',  # 䱴
    0x4C75: 'wēng',  # 䱵
    0x4C76: 'láng',  # 䱶
    0x4C77: 'yú',  # 䱷
    0x4C78: 'qiū,sōu',  # 䱸
    0x4C79: 'nà,zhǎ',  # 䱹
    0x4C7A: 'hái',  # 䱺
    0x4C7B: 'huá',  # 䱻
    0x4C7C: 'zhǎn',  # 䱼
    # 0x4C7D: '',  # 䱽
    0x4C7E: 'lóu,yú',  # 䱾
    0x4C7F: 'chàn',  # 䱿
    0x4C80: 'dié,suì,zhì,zòu',  # 䲀
    0x4C81: 'wèi',  # 䲁
    0x4C82: 'xuán',  # 䲂
    0x4C83: 'zǎo',  # 䲃
    0x4C84: 'mín,mǐn',  # 䲄
    0x4C85: 'guī',  # 䲅
    # 0x4C86: '',  # 䲆
    # 0x4C87: '',  # 䲇
    # 0x4C88: '',  # 䲈
    # 0x4C89: '',  # 䲉
    0x4C8A: 'tuǒ,duò',  # 䲊
    0x4C8B: 'cén',  # 䲋
    0x4C8C: 'kuǎn',  # 䲌
    0x4C8D: 'téng',  # 䲍
    0x4C8E: 'něi',  # 䲎
    0x4C8F: 'láo',  # 䲏
    0x4C90: 'lǔ',  # 䲐
    0x4C91: 'yí',  # 䲑
    0x4C92: 'xiè',  # 䲒
    0x4C93: 'yǎn',  # 䲓
    0x4C94: 'qíng,qìng,jīng',  # 䲔
    0x4C95: 'pǔ,pù',  # 䲕
    0x4C96: 'chóu',  # 䲖
    0x4C97: 'xián',  # 䲗
    0x4C98: 'guǎn,kàng,wéi',  # 䲘
    0x4C99: 'jié',  # 䲙
    0x4C9A: 'lài,làn',  # 䲚
    0x4C9B: 'méng',  # 䲛
    0x4C9C: 'yè',  # 䲜
    # 0x4C9D: '',  # 䲝
    0x4C9E: 'lì,luǒ',  # 䲞
    0x4C9F: 'yìn',  # 䲟
    # 0x4CA0: '',  # 䲠
    0x4CA1: 'qiū',  # 䲡
    0x4CA2: 'téng',  # 䲢
    0x4CA3: 'yú',  # 䲣
    # 0x4CA4: '',  # 䲤
    # 0x4CA5: '',  # 䲥
    0x4CA6: 'chá,dài,dì,tuǒ',  # 䲦
    0x4CA7: 'dù,shuì',  # 䲧
    0x4CA8: 'hóng',  # 䲨
    0x4CA9: 'shī',  # 䲩
    0x4CAA: 'xì',  # 䲪
    # 0x4CAB: '',  # 䲫
    0x4CAC: 'qí',  # 䲬
    # 0x4CAD: '',  # 䲭
    0x4CAE: 'yuán',  # 䲮
    0x4CAF: 'jí',  # 䲯
    0x4CB0: 'yùn',  # 䲰
    0x4CB1: 'fǎng',  # 䲱
    # 0x4CB2: '',  # 䲲
    0x4CB3: 'háng',  # 䲳
    0x4CB4: 'zhèn',  # 䲴
    0x4CB5: 'hù,què',  # 䲵
    # 0x4CB6: '',  # 䲶
    # 0x4CB7: '',  # 䲷
    0x4CB8: 'jiè',  # 䲸
    0x4CB9: 'péi',  # 䲹
    0x4CBA: 'gàn',  # 䲺
    0x4CBB: 'xuán,yuán',  # 䲻
    # 0x4CBC: '',  # 䲼
    0x4CBD: 'dǎo,shí',  # 䲽
    0x4CBE: 'qiǎo',  # 䲾
    0x4CBF: 'cí',  # 䲿
    0x4CC0: 'dié',  # 䳀
    0x4CC1: 'bá,bǐn,bó,yuán',  # 䳁
    0x4CC2: 'tiáo',  # 䳂
    0x4CC3: 'wǎn',  # 䳃
    0x4CC4: 'cí',  # 䳄
    0x4CC5: 'zhǐ',  # 䳅
    0x4CC6: 'bái',  # 䳆
    0x4CC7: 'wǔ',  # 䳇
    0x4CC8: 'bǎo',  # 䳈
    0x4CC9: 'dōng,dàn',  # 䳉
    0x4CCA: 'bá',  # 䳊
    0x4CCB: 'tóng,zhòng',  # 䳋
    # 0x4CCC: '',  # 䳌
    # 0x4CCD: '',  # 䳍
    0x4CCE: 'jiù',  # 䳎
    0x4CCF: 'guì',  # 䳏
    0x4CD0: 'cì',  # 䳐
    0x4CD1: 'yǒu,yù',  # 䳑
    0x4CD2: 'yuán',  # 䳒
    0x4CD3: 'lǎo',  # 䳓
    0x4CD4: 'jiù,jú',  # 䳔
    0x4CD5: 'fóu',  # 䳕
    0x4CD6: 'nèi,yè',  # 䳖
    0x4CD7: 'é',  # 䳗
    0x4CD8: 'é',  # 䳘
    0x4CD9: 'xǐng',  # 䳙
    0x4CDA: 'hé,kǎn',  # 䳚
    0x4CDB: 'yàn',  # 䳛
    0x4CDC: 'tú',  # 䳜
    0x4CDD: 'bù,diào,fǔ,pǒu',  # 䳝
    0x4CDE: 'běng',  # 䳞
    0x4CDF: 'kòu,míng,mǒ',  # 䳟
    0x4CE0: 'chuí,ruì,zhù',  # 䳠
    # 0x4CE1: '',  # 䳡
    0x4CE2: 'qí',  # 䳢
    0x4CE3: 'yuán',  # 䳣
    # 0x4CE4: '',  # 䳤
    # 0x4CE5: '',  # 䳥
    # 0x4CE6: '',  # 䳦
    0x4CE7: 'hóu',  # 䳧
    0x4CE8: 'huáng',  # 䳨
    # 0x4CE9: '',  # 䳩
    0x4CEA: 'juàn,tuán',  # 䳪
    0x4CEB: 'kuí',  # 䳫
    0x4CEC: 'è,yǎo,yì',  # 䳬
    0x4CED: 'jí',  # 䳭
    0x4CEE: 'mò',  # 䳮
    0x4CEF: 'chóng,chǒng',  # 䳯
    0x4CF0: 'bǎo',  # 䳰
    0x4CF1: 'wù',  # 䳱
    0x4CF2: 'zhèn',  # 䳲
    0x4CF3: 'xù',  # 䳳
    0x4CF4: 'dá,tà',  # 䳴
    0x4CF5: 'chì',  # 䳵
    # 0x4CF6: '',  # 䳶
    0x4CF7: 'cóng',  # 䳷
    0x4CF8: 'má,mái',  # 䳸
    0x4CF9: 'kòu',  # 䳹
    0x4CFA: 'yàn',  # 䳺
    0x4CFB: 'cán,chán,dié,zhàn',  # 䳻
    0x4CFC: 'ōu',  # 䳼
    0x4CFD: 'hè',  # 䳽
    # 0x4CFE: '',  # 䳾
    0x4CFF: 'lán,rán',  # 䳿
    0x4D00: 'tóng',  # 䴀
    0x4D01: 'yù',  # 䴁
    0x4D02: 'hàng,xiàng',  # 䴂
    0x4D03: 'náo',  # 䴃
    0x4D04: 'lì,shùn',  # 䴄
    0x4D05: 'fén',  # 䴅
    0x4D06: 'pú',  # 䴆
    0x4D07: 'líng',  # 䴇
    0x4D08: 'ǎo',  # 䴈
    0x4D09: 'xuán',  # 䴉
    0x4D0A: 'yí',  # 䴊
    0x4D0B: 'xuán',  # 䴋
    0x4D0C: 'méng',  # 䴌
    # 0x4D0D: '',  # 䴍
    0x4D0E: 'lěi',  # 䴎
    0x4D0F: 'yàn',  # 䴏
    0x4D10: 'bǎo',  # 䴐
    0x4D11: 'dié',  # 䴑
    0x4D12: 'líng',  # 䴒
    0x4D13: 'shī',  # 䴓
    0x4D14: 'jiāo',  # 䴔
    0x4D15: 'liè',  # 䴕
    0x4D16: 'jīng',  # 䴖
    0x4D17: 'jú',  # 䴗
    0x4D18: 'tī',  # 䴘
    0x4D19: 'pì',  # 䴙
    0x4D1A: 'gǎng',  # 䴚
    0x4D1B: 'jiǎo,tú,xì,xiào,yín',  # 䴛
    0x4D1C: 'huái',  # 䴜
    0x4D1D: 'bù,chuài',  # 䴝
    0x4D1E: 'dí',  # 䴞
    0x4D1F: 'huán,huàn',  # 䴟
    0x4D20: 'yǎo',  # 䴠
    0x4D21: 'lì',  # 䴡
    0x4D22: 'mí',  # 䴢
    # 0x4D23: '',  # 䴣
    # 0x4D24: '',  # 䴤
    0x4D25: 'jiā',  # 䴥
    0x4D26: 'rén,yín',  # 䴦
    # 0x4D27: '',  # 䴧
    # 0x4D28: '',  # 䴨
    0x4D29: 'piáo',  # 䴩
    0x4D2A: 'lù',  # 䴪
    0x4D2B: 'líng',  # 䴫
    0x4D2C: 'yì',  # 䴬
    0x4D2D: 'cái',  # 䴭
    0x4D2E: 'shàn',  # 䴮
    # 0x4D2F: '',  # 䴯
    0x4D30: 'shú',  # 䴰
    0x4D31: 'tuō',  # 䴱
    0x4D32: 'mò',  # 䴲
    0x4D33: 'hè,huá',  # 䴳
    0x4D34: 'tiè,nián',  # 䴴
    0x4D35: 'bǐng,zhuó',  # 䴵
    0x4D36: 'péng',  # 䴶
    0x4D37: 'hún',  # 䴷
    # 0x4D38: '',  # 䴸
    0x4D39: 'guǒ',  # 䴹
    0x4D3A: 'bù,cǎi,chàn',  # 䴺
    0x4D3B: 'lí',  # 䴻
    0x4D3C: 'chǎn,chàn',  # 䴼
    0x4D3D: 'bài,pí',  # 䴽
    0x4D3E: 'cuó,cuò,yè,zhěn,zǐ',  # 䴾
    0x4D3F: 'méng',  # 䴿
    0x4D40: 'suǒ',  # 䵀
    0x4D41: 'qiàng',  # 䵁
    0x4D42: 'zhí',  # 䵂
    0x4D43: 'kuàng',  # 䵃
    0x4D44: 'bí,bó,fèng,pěng',  # 䵄
    0x4D45: 'áo',  # 䵅
    0x4D46: 'méng',  # 䵆
    0x4D47: 'xiàn',  # 䵇
    0x4D48: 'kù',  # 䵈
    0x4D49: 'tóu',  # 䵉
    # 0x4D4A: '',  # 䵊
    0x4D4B: 'wěi',  # 䵋
    0x4D4C: 'xiān',  # 䵌
    # 0x4D4D: '',  # 䵍
    0x4D4E: 'tuān',  # 䵎
    0x4D4F: 'lǎo',  # 䵏
    0x4D50: 'chǎn,chàn',  # 䵐
    0x4D51: 'nì',  # 䵑
    0x4D52: 'nì',  # 䵒
    0x4D53: 'lí',  # 䵓
    0x4D54: 'dǒng',  # 䵔
    0x4D55: 'jù',  # 䵕
    0x4D56: 'jiàn,qiàn,xiàn',  # 䵖
    0x4D57: 'fú,bó',  # 䵗
    0x4D58: 'shà,shài',  # 䵘
    0x4D59: 'zhǎ',  # 䵙
    0x4D5A: 'tǎo',  # 䵚
    0x4D5B: 'jiàn,xiàn',  # 䵛
    0x4D5C: 'nǒng',  # 䵜
    0x4D5D: 'yà,yì',  # 䵝
    0x4D5E: 'jìng,qíng',  # 䵞
    0x4D5F: 'gǎn',  # 䵟
    0x4D60: 'dí',  # 䵠
    0x4D61: 'jiǎn',  # 䵡
    0x4D62: 'mèi,wèi',  # 䵢
    0x4D63: 'dá,zhǎn',  # 䵣
    0x4D64: 'jiǎn',  # 䵤
    0x4D65: 'shè,wán,yìng,yù',  # 䵥
    0x4D66: 'xiè',  # 䵦
    0x4D67: 'zài',  # 䵧
    0x4D68: 'máng',  # 䵨
    0x4D69: 'lí',  # 䵩
    0x4D6A: 'gùn',  # 䵪
    0x4D6B: 'yù',  # 䵫
    0x4D6C: 'tà',  # 䵬
    0x4D6D: 'zhè',  # 䵭
    0x4D6E: 'yàng',  # 䵮
    0x4D6F: 'tuǎn',  # 䵯
    # 0x4D70: '',  # 䵰
    0x4D71: 'hè,xì',  # 䵱
    0x4D72: 'diào',  # 䵲
    0x4D73: 'wèi',  # 䵳
    0x4D74: 'yùn,zèng',  # 䵴
    0x4D75: 'zhá,zhuó,chuā',  # 䵵
    0x4D76: 'qú',  # 䵶
    0x4D77: 'wā',  # 䵷
    # 0x4D78: '',  # 䵸
    0x4D79: 'zhī',  # 䵹
    0x4D7A: 'tǐng',  # 䵺
    0x4D7B: 'gǔ,hú,huì',  # 䵻
    # 0x4D7C: '',  # 䵼
    0x4D7D: 'cà',  # 䵽
    0x4D7E: 'fú',  # 䵾
    0x4D7F: 'tiè',  # 䵿
    0x4D80: 'tà',  # 䶀
    0x4D81: 'tà',  # 䶁
    0x4D82: 'zhuó',  # 䶂
    0x4D83: 'hán',  # 䶃
    0x4D84: 'píng',  # 䶄
    0x4D85: 'hé',  # 䶅
    # 0x4D86: '',  # 䶆
    0x4D87: 'zhòu',  # 䶇
    0x4D88: 'bó',  # 䶈
    0x4D89: 'liú',  # 䶉
    # 0x4D8A: '',  # 䶊
    # 0x4D8B: '',  # 䶋
    0x4D8C: 'pào',  # 䶌
    0x4D8D: 'dì,tì',  # 䶍
    0x4D8E: 'shà',  # 䶎
    0x4D8F: 'tǐ,tì',  # 䶏
    0x4D90: 'wài,huì',  # 䶐
    0x4D91: 'tì',  # 䶑
    0x4D92: 'qí',  # 䶒
    0x4D93: 'jì,qì',  # 䶓
    0x4D94: 'chí,mín',  # 䶔
    0x4D95: 'pá',  # 䶕
    0x4D96: 'jìn,qín',  # 䶖
    0x4D97: 'qiā,qiǎ,kè',  # 䶗
    0x4D98: 'lì',  # 䶘
    0x4D99: 'jù',  # 䶙
    0x4D9A: 'qǔ',  # 䶚
    0x4D9B: 'là,liè',  # 䶛
    0x4D9C: 'gù',  # 䶜
    0x4D9D: 'qià,xiá',  # 䶝
    0x4D9E: 'qí',  # 䶞
    0x4D9F: 'xiàn',  # 䶟
    0x4DA0: 'jiǎn,xián',  # 䶠
    0x4DA1: 'shí,zé,zhì',  # 䶡
    0x4DA2: 'xián,jiān',  # 䶢
    0x4DA3: 'ái',  # 䶣
    0x4DA4: 'huá',  # 䶤
    0x4DA5: 'jǔ,zhā',  # 䶥
    0x4DA6: 'zé',  # 䶦
    0x4DA7: 'yǎo',  # 䶧
    # 0x4DA8: '',  # 䶨
    0x4DA9: 'jì',  # 䶩
    0x4DAA: 'chá',  # 䶪
    0x4DAB: 'kǎn,yán,yàn',  # 䶫
    0x4DAC: 'jiān',  # 䶬
    # 0x4DAD: '',  # 䶭
    0x4DAE: 'yǎn',  # 䶮
    # 0x4DAF: '',  # 䶯
    # 0x4DB0: '',  # 䶰
    0x4DB1: 'tóng',  # 䶱
    0x4DB2: 'nán,nàn,rán',  # 䶲
    0x4DB3: 'yuè',  # 䶳
    0x4DB4: 'chuī',  # 䶴
    0x4DB5: 'chí,shǐ',  # 䶵
    # 0x4DB6: '',  #
    # 0x4DB7: '',  #
    # 0x4DB8: '',  #
    # 0x4DB9: '',  #
    # 0x4DBA: '',  #
    # 0x4DBB: '',  #
    # 0x4DBC: '',  #
    # 0x4DBD: '',  #
    # 0x4DBE: '',  #
    # 0x4DBF: '',  #

    # CJK 基本:[4E00-9FFF]
    0x4E00: 'yī',  # 一
    0x4E01: 'dīng,zhēng',  # 丁
    0x4E02: 'kǎo,qiǎo,yú',  # 丂
    0x4E03: 'qī',  # 七
    0x4E04: 'shàng',  # 丄
    0x4E05: 'xià',  # 丅
    0x4E06: 'hǎn',  # 丆
    0x4E07: 'wàn,mò',  # 万
    0x4E08: 'zhàng',  # 丈
    0x4E09: 'sān',  # 三
    0x4E0A: 'shàng,shǎng',  # 上
    0x4E0B: 'xià',  # 下
    0x4E0C: 'qí,jī',  # 丌
    0x4E0D: 'bù,fǒu',  # 不
    0x4E0E: 'yǔ,yù,yú',  # 与
    0x4E0F: 'miǎn',  # 丏
    0x4E10: 'gài',  # 丐
    0x4E11: 'chǒu',  # 丑
    0x4E12: 'chǒu',  # 丒
    0x4E13: 'zhuān',  # 专
    0x4E14: 'qiě,jū',  # 且
    0x4E15: 'pī',  # 丕
    0x4E16: 'shì',  # 世
    0x4E17: 'shì',  # 丗
    0x4E18: 'qiū',  # 丘
    0x4E19: 'bǐng',  # 丙
    0x4E1A: 'yè',  # 业
    0x4E1B: 'cóng',  # 丛
    0x4E1C: 'dōng',  # 东
    0x4E1D: 'sī',  # 丝
    0x4E1E: 'chéng',  # 丞
    0x4E1F: 'diū',  # 丟
    0x4E20: 'qiū',  # 丠
    0x4E21: 'liǎng',  # 両
    0x4E22: 'diū',  # 丢
    0x4E23: 'yǒu',  # 丣
    0x4E24: 'liǎng',  # 两
    0x4E25: 'yán',  # 严
    0x4E26: 'bìng',  # 並
    0x4E27: 'sāng,sàng',  # 丧
    0x4E28: 'gǔn',  # 丨
    0x4E29: 'jiū',  # 丩
    0x4E2A: 'gè,gě',  # 个
    0x4E2B: 'yā',  # 丫
    0x4E2C: 'pán',  # 丬
    0x4E2D: 'zhōng,zhòng',  # 中
    0x4E2E: 'jǐ',  # 丮
    0x4E2F: 'jiè',  # 丯
    0x4E30: 'fēng',  # 丰
    0x4E31: 'guàn,kuàng',  # 丱
    0x4E32: 'chuàn',  # 串
    0x4E33: 'chǎn',  # 丳
    0x4E34: 'lín',  # 临
    0x4E35: 'zhuó',  # 丵
    0x4E36: 'zhǔ',  # 丶
    0x4E37: 'bā',  # 丷
    0x4E38: 'wán',  # 丸
    0x4E39: 'dān',  # 丹
    0x4E3A: 'wéi,wèi',  # 为
    0x4E3B: 'zhǔ',  # 主
    0x4E3C: 'jǐng',  # 丼
    0x4E3D: 'lì,lí',  # 丽
    0x4E3E: 'jǔ',  # 举
    0x4E3F: 'piě',  # 丿
    0x4E40: 'fú',  # 乀
    0x4E41: 'yí,jí',  # 乁
    0x4E42: 'yì',  # 乂
    0x4E43: 'nǎi',  # 乃
    0x4E44: 'wǔ',  # 乄
    0x4E45: 'jiǔ',  # 久
    0x4E46: 'jiǔ',  # 乆
    0x4E47: 'tuō,zhé',  # 乇
    0x4E48: 'mó,ma,me,yāo',  # 么
    0x4E49: 'yì',  # 义
    0x4E4A: 'yī',  # 乊
    0x4E4B: 'zhī',  # 之
    0x4E4C: 'wū',  # 乌
    0x4E4D: 'zhà',  # 乍
    0x4E4E: 'hū',  # 乎
    0x4E4F: 'fá',  # 乏
    0x4E50: 'lè,yuè,yào,lào',  # 乐
    0x4E51: 'yín',  # 乑
    0x4E52: 'pīng',  # 乒
    0x4E53: 'pāng',  # 乓
    0x4E54: 'qiáo',  # 乔
    0x4E55: 'hǔ',  # 乕
    0x4E56: 'guāi',  # 乖
    0x4E57: 'chéng,shèng',  # 乗
    0x4E58: 'chéng,shèng',  # 乘
    0x4E59: 'yǐ',  # 乙
    0x4E5A: 'háo,yǐ',  # 乚
    0x4E5B: 'yǐ',  # 乛
    0x4E5C: 'miē,niè',  # 乜
    0x4E5D: 'jiǔ',  # 九
    0x4E5E: 'qǐ',  # 乞
    0x4E5F: 'yě',  # 也
    0x4E60: 'xí',  # 习
    0x4E61: 'xiāng',  # 乡
    0x4E62: 'gài',  # 乢
    0x4E63: 'jiǔ',  # 乣
    0x4E64: 'xià',  # 乤
    0x4E65: 'hol',  # 乥
    0x4E66: 'shū',  # 书
    0x4E67: 'dǒu',  # 乧
    0x4E68: 'shǐ',  # 乨
    0x4E69: 'jī',  # 乩
    0x4E6A: 'náng',  # 乪
    0x4E6B: 'jiā',  # 乫
    0x4E6C: 'jù',  # 乬
    0x4E6D: 'shí',  # 乭
    0x4E6E: 'mǎo',  # 乮
    0x4E6F: 'hū',  # 乯
    0x4E70: 'mǎi',  # 买
    0x4E71: 'luàn',  # 乱
    0x4E72: 'cal',  # 乲
    0x4E73: 'rǔ',  # 乳
    0x4E74: 'xué',  # 乴
    0x4E75: 'yǎn',  # 乵
    0x4E76: 'fǔ',  # 乶
    0x4E77: 'shā',  # 乷
    0x4E78: 'nǎ',  # 乸
    0x4E79: 'qián',  # 乹
    0x4E7A: 'suǒ',  # 乺
    0x4E7B: 'yú',  # 乻
    0x4E7C: 'zhù',  # 乼
    0x4E7D: 'zhě',  # 乽
    0x4E7E: 'qián,gān',  # 乾
    0x4E7F: 'zhì,luàn',  # 乿
    0x4E80: 'guī',  # 亀
    0x4E81: 'qián',  # 亁
    0x4E82: 'luàn',  # 亂
    0x4E83: 'lǐn,lìn',  # 亃
    0x4E84: 'yì',  # 亄
    0x4E85: 'jué',  # 亅
    0x4E86: 'liǎo,le',  # 了
    0x4E87: 'gè,mā',  # 亇
    0x4E88: 'yú,yǔ',  # 予
    0x4E89: 'zhēng',  # 争
    0x4E8A: 'shì',  # 亊
    0x4E8B: 'shì',  # 事
    0x4E8C: 'èr',  # 二
    0x4E8D: 'chù',  # 亍
    0x4E8E: 'yú',  # 于
    0x4E8F: 'kuī',  # 亏
    0x4E90: 'yú',  # 亐
    0x4E91: 'yún',  # 云
    0x4E92: 'hù',  # 互
    0x4E93: 'qí',  # 亓
    0x4E94: 'wǔ',  # 五
    0x4E95: 'jǐng',  # 井
    0x4E96: 'sì',  # 亖
    0x4E97: 'suì',  # 亗
    0x4E98: 'gèn',  # 亘
    0x4E99: 'gèn',  # 亙
    0x4E9A: 'yà',  # 亚
    0x4E9B: 'xiē,suò',  # 些
    0x4E9C: 'yà',  # 亜
    0x4E9D: 'qí,zhāi',  # 亝
    0x4E9E: 'yā,yà',  # 亞
    0x4E9F: 'jí,qì',  # 亟
    0x4EA0: 'tóu',  # 亠
    0x4EA1: 'wáng,wú',  # 亡
    0x4EA2: 'kàng',  # 亢
    0x4EA3: 'dà',  # 亣
    0x4EA4: 'jiāo',  # 交
    0x4EA5: 'hài',  # 亥
    0x4EA6: 'yì',  # 亦
    0x4EA7: 'chǎn',  # 产
    0x4EA8: 'hēng,pēng',  # 亨
    0x4EA9: 'mǔ',  # 亩
    0x4EAA: 'ye',  # 亪
    0x4EAB: 'xiǎng',  # 享
    0x4EAC: 'jīng',  # 京
    0x4EAD: 'tíng',  # 亭
    0x4EAE: 'liàng',  # 亮
    0x4EAF: 'xiǎng',  # 亯
    0x4EB0: 'jīng',  # 亰
    0x4EB1: 'yè',  # 亱
    0x4EB2: 'qīn,qìng',  # 亲
    0x4EB3: 'bó',  # 亳
    0x4EB4: 'yòu',  # 亴
    0x4EB5: 'xiè',  # 亵
    0x4EB6: 'dǎn,dàn',  # 亶
    0x4EB7: 'lián',  # 亷
    0x4EB8: 'duǒ',  # 亸
    0x4EB9: 'wěi,mén',  # 亹
    0x4EBA: 'rén',  # 人
    0x4EBB: 'rén',  # 亻
    0x4EBC: 'jí',  # 亼
    0x4EBD: 'jí',  # 亽
    0x4EBE: 'wáng',  # 亾
    0x4EBF: 'yì',  # 亿
    0x4EC0: 'shí,shén',  # 什
    0x4EC1: 'rén',  # 仁
    0x4EC2: 'lè',  # 仂
    0x4EC3: 'dīng',  # 仃
    0x4EC4: 'zè',  # 仄
    0x4EC5: 'jǐn,jìn',  # 仅
    0x4EC6: 'pū,pú',  # 仆
    0x4EC7: 'chóu,qiú',  # 仇
    0x4EC8: 'bā',  # 仈
    0x4EC9: 'zhǎng',  # 仉
    0x4ECA: 'jīn',  # 今
    0x4ECB: 'jiè',  # 介
    0x4ECC: 'bīng',  # 仌
    0x4ECD: 'réng',  # 仍
    0x4ECE: 'cóng,zòng',  # 从
    0x4ECF: 'fó',  # 仏
    0x4ED0: 'jīn,sǎn',  # 仐
    0x4ED1: 'lún',  # 仑
    0x4ED2: 'bīng,eo',  # 仒
    0x4ED3: 'cāng',  # 仓
    0x4ED4: 'zī,zǐ,zǎi',  # 仔
    0x4ED5: 'shì',  # 仕
    0x4ED6: 'tā',  # 他
    0x4ED7: 'zhàng',  # 仗
    0x4ED8: 'fù',  # 付
    0x4ED9: 'xiān',  # 仙
    0x4EDA: 'xiān',  # 仚
    0x4EDB: 'tuō,chà,duó',  # 仛
    0x4EDC: 'hóng',  # 仜
    0x4EDD: 'tóng',  # 仝
    0x4EDE: 'rèn',  # 仞
    0x4EDF: 'qiān',  # 仟
    0x4EE0: 'gǎn,hàn',  # 仠
    0x4EE1: 'yì,gē',  # 仡
    0x4EE2: 'bó',  # 仢
    0x4EE3: 'dài',  # 代
    0x4EE4: 'líng,lǐng,lìng',  # 令
    0x4EE5: 'yǐ',  # 以
    0x4EE6: 'chào',  # 仦
    0x4EE7: 'cháng,zhǎng',  # 仧
    0x4EE8: 'sā',  # 仨
    0x4EE9: 'cháng',  # 仩
    0x4EEA: 'yí',  # 仪
    0x4EEB: 'mù',  # 仫
    0x4EEC: 'mén',  # 们
    0x4EED: 'rèn',  # 仭
    0x4EEE: 'fǎn',  # 仮
    0x4EEF: 'chào,miǎo',  # 仯
    0x4EF0: 'yǎng,áng',  # 仰
    0x4EF1: 'qián',  # 仱
    0x4EF2: 'zhòng',  # 仲
    0x4EF3: 'pǐ,pí',  # 仳
    0x4EF4: 'wò',  # 仴
    0x4EF5: 'wǔ',  # 仵
    0x4EF6: 'jiàn',  # 件
    0x4EF7: 'jià,jiè,jie',  # 价
    0x4EF8: 'yǎo,fó',  # 仸
    0x4EF9: 'fēng',  # 仹
    0x4EFA: 'cāng',  # 仺
    0x4EFB: 'rèn,rén',  # 任
    0x4EFC: 'wáng',  # 仼
    0x4EFD: 'fèn,bīn',  # 份
    0x4EFE: 'dī',  # 仾
    0x4EFF: 'fǎng',  # 仿
    0x4F00: 'zhōng',  # 伀
    0x4F01: 'qǐ',  # 企
    0x4F02: 'pèi',  # 伂
    0x4F03: 'yú',  # 伃
    0x4F04: 'diào',  # 伄
    0x4F05: 'dùn',  # 伅
    0x4F06: 'wěn',  # 伆
    0x4F07: 'yì',  # 伇
    0x4F08: 'xǐn',  # 伈
    0x4F09: 'kàng',  # 伉
    0x4F0A: 'yī',  # 伊
    0x4F0B: 'jí',  # 伋
    0x4F0C: 'ài',  # 伌
    0x4F0D: 'wǔ',  # 伍
    0x4F0E: 'jì,qí',  # 伎
    0x4F0F: 'fú',  # 伏
    0x4F10: 'fá',  # 伐
    0x4F11: 'xiū,xǔ',  # 休
    0x4F12: 'jìn,yín',  # 伒
    0x4F13: 'pī',  # 伓
    0x4F14: 'dǎn',  # 伔
    0x4F15: 'fū',  # 伕
    0x4F16: 'tǎng',  # 伖
    0x4F17: 'zhòng',  # 众
    0x4F18: 'yōu',  # 优
    0x4F19: 'huǒ',  # 伙
    0x4F1A: 'huì,kuài',  # 会
    0x4F1B: 'yǔ',  # 伛
    0x4F1C: 'cuì',  # 伜
    0x4F1D: 'yún',  # 伝
    0x4F1E: 'sǎn',  # 伞
    0x4F1F: 'wěi',  # 伟
    0x4F20: 'chuán,zhuàn',  # 传
    0x4F21: 'chē,jū',  # 伡
    0x4F22: 'yá',  # 伢
    0x4F23: 'qiàn',  # 伣
    0x4F24: 'shāng',  # 伤
    0x4F25: 'chāng',  # 伥
    0x4F26: 'lún',  # 伦
    0x4F27: 'cāng,chen',  # 伧
    0x4F28: 'xùn',  # 伨
    0x4F29: 'xìn',  # 伩
    0x4F2A: 'wěi',  # 伪
    0x4F2B: 'zhù',  # 伫
    0x4F2C: 'chǐ',  # 伬
    0x4F2D: 'xián,xuán',  # 伭
    0x4F2E: 'nú,nǔ',  # 伮
    0x4F2F: 'bó,bǎi,bà',  # 伯
    0x4F30: 'gū,gù',  # 估
    0x4F31: 'nǐ',  # 伱
    0x4F32: 'nǐ,nì',  # 伲
    0x4F33: 'xiè',  # 伳
    0x4F34: 'bàn',  # 伴
    0x4F35: 'xù',  # 伵
    0x4F36: 'líng',  # 伶
    0x4F37: 'zhòu',  # 伷
    0x4F38: 'shēn',  # 伸
    0x4F39: 'qū',  # 伹
    0x4F3A: 'sì,cì',  # 伺
    0x4F3B: 'bēng',  # 伻
    0x4F3C: 'sì,shì',  # 似
    0x4F3D: 'qié,jiā,gā',  # 伽
    0x4F3E: 'pī',  # 伾
    0x4F3F: 'yì',  # 伿
    0x4F40: 'sì',  # 佀
    0x4F41: 'yǐ,chì',  # 佁
    0x4F42: 'zhēng',  # 佂
    0x4F43: 'diàn,tián',  # 佃
    0x4F44: 'hān,gàn',  # 佄
    0x4F45: 'mài',  # 佅
    0x4F46: 'dàn',  # 但
    0x4F47: 'zhù',  # 佇
    0x4F48: 'bù',  # 佈
    0x4F49: 'qū',  # 佉
    0x4F4A: 'bǐ',  # 佊
    0x4F4B: 'zhāo,shào',  # 佋
    0x4F4C: 'cǐ',  # 佌
    0x4F4D: 'wèi',  # 位
    0x4F4E: 'dī',  # 低
    0x4F4F: 'zhù',  # 住
    0x4F50: 'zuǒ',  # 佐
    0x4F51: 'yòu',  # 佑
    0x4F52: 'yǎng',  # 佒
    0x4F53: 'tǐ,tī',  # 体
    0x4F54: 'zhàn,diān',  # 佔
    0x4F55: 'hé,hē,hè',  # 何
    0x4F56: 'bì',  # 佖
    0x4F57: 'tuó',  # 佗
    0x4F58: 'shé',  # 佘
    0x4F59: 'yú',  # 余
    0x4F5A: 'yì,dié',  # 佚
    0x4F5B: 'fó,fú,bì,bó',  # 佛
    0x4F5C: 'zuò',  # 作
    0x4F5D: 'gōu,kòu',  # 佝
    0x4F5E: 'nìng',  # 佞
    0x4F5F: 'tóng',  # 佟
    0x4F60: 'nǐ',  # 你
    0x4F61: 'xiān',  # 佡
    0x4F62: 'qú',  # 佢
    0x4F63: 'yōng,yòng',  # 佣
    0x4F64: 'wǎ',  # 佤
    0x4F65: 'qiān',  # 佥
    0x4F66: 'yòu',  # 佦
    0x4F67: 'kǎ',  # 佧
    0x4F68: 'bāo',  # 佨
    0x4F69: 'pèi',  # 佩
    0x4F6A: 'huí,huái',  # 佪
    0x4F6B: 'gé',  # 佫
    0x4F6C: 'lǎo',  # 佬
    0x4F6D: 'xiáng',  # 佭
    0x4F6E: 'gé',  # 佮
    0x4F6F: 'yáng',  # 佯
    0x4F70: 'bǎi',  # 佰
    0x4F71: 'fǎ',  # 佱
    0x4F72: 'mǐng',  # 佲
    0x4F73: 'jiā',  # 佳
    0x4F74: 'èr,nài',  # 佴
    0x4F75: 'bìng',  # 併
    0x4F76: 'jí',  # 佶
    0x4F77: 'hěn',  # 佷
    0x4F78: 'huó',  # 佸
    0x4F79: 'guǐ',  # 佹
    0x4F7A: 'quán',  # 佺
    0x4F7B: 'tiāo',  # 佻
    0x4F7C: 'jiǎo',  # 佼
    0x4F7D: 'cì',  # 佽
    0x4F7E: 'yì',  # 佾
    0x4F7F: 'shǐ',  # 使
    0x4F80: 'xíng',  # 侀
    0x4F81: 'shēn',  # 侁
    0x4F82: 'tuō',  # 侂
    0x4F83: 'kǎn',  # 侃
    0x4F84: 'zhí',  # 侄
    0x4F85: 'gāi',  # 侅
    0x4F86: 'lái',  # 來
    0x4F87: 'yí',  # 侇
    0x4F88: 'chǐ',  # 侈
    0x4F89: 'kuǎ',  # 侉
    0x4F8A: 'gōng',  # 侊
    0x4F8B: 'lì',  # 例
    0x4F8C: 'yīn',  # 侌
    0x4F8D: 'shì',  # 侍
    0x4F8E: 'mǐ',  # 侎
    0x4F8F: 'zhū',  # 侏
    0x4F90: 'xù',  # 侐
    0x4F91: 'yòu',  # 侑
    0x4F92: 'ān',  # 侒
    0x4F93: 'lù',  # 侓
    0x4F94: 'móu',  # 侔
    0x4F95: 'ér',  # 侕
    0x4F96: 'lún',  # 侖
    0x4F97: 'dòng,tóng,tǒng',  # 侗
    0x4F98: 'chà',  # 侘
    0x4F99: 'chì',  # 侙
    0x4F9A: 'xùn',  # 侚
    0x4F9B: 'gōng,gòng',  # 供
    0x4F9C: 'zhōu',  # 侜
    0x4F9D: 'yī',  # 依
    0x4F9E: 'rú',  # 侞
    0x4F9F: 'cún,jiàn',  # 侟
    0x4FA0: 'xiá',  # 侠
    0x4FA1: 'sì',  # 価
    0x4FA2: 'dài',  # 侢
    0x4FA3: 'lǚ',  # 侣
    0x4FA4: 'ta',  # 侤
    0x4FA5: 'jiǎo,yáo',  # 侥
    0x4FA6: 'zhēn',  # 侦
    0x4FA7: 'cè,zè,zhāi',  # 侧
    0x4FA8: 'qiáo',  # 侨
    0x4FA9: 'kuài',  # 侩
    0x4FAA: 'chái',  # 侪
    0x4FAB: 'nìng',  # 侫
    0x4FAC: 'nóng',  # 侬
    0x4FAD: 'jǐn',  # 侭
    0x4FAE: 'wǔ',  # 侮
    0x4FAF: 'hóu,hòu',  # 侯
    0x4FB0: 'jiǒng',  # 侰
    0x4FB1: 'chěng,tǐng',  # 侱
    0x4FB2: 'zhèn,zhēn',  # 侲
    0x4FB3: 'zuò',  # 侳
    0x4FB4: 'hào',  # 侴
    0x4FB5: 'qīn',  # 侵
    0x4FB6: 'lǚ',  # 侶
    0x4FB7: 'jú',  # 侷
    0x4FB8: 'shù,dōu',  # 侸
    0x4FB9: 'tǐng',  # 侹
    0x4FBA: 'shèn',  # 侺
    0x4FBB: 'tuó,tuì',  # 侻
    0x4FBC: 'bó',  # 侼
    0x4FBD: 'nán',  # 侽
    0x4FBE: 'xiāo',  # 侾
    0x4FBF: 'biàn,pián',  # 便
    0x4FC0: 'tuǐ',  # 俀
    0x4FC1: 'yǔ',  # 俁
    0x4FC2: 'xì',  # 係
    0x4FC3: 'cù',  # 促
    0x4FC4: 'é',  # 俄
    0x4FC5: 'qiú',  # 俅
    0x4FC6: 'xú',  # 俆
    0x4FC7: 'guàng',  # 俇
    0x4FC8: 'kù',  # 俈
    0x4FC9: 'wù',  # 俉
    0x4FCA: 'jùn',  # 俊
    0x4FCB: 'yì',  # 俋
    0x4FCC: 'fǔ',  # 俌
    0x4FCD: 'liáng',  # 俍
    0x4FCE: 'zǔ',  # 俎
    0x4FCF: 'qiào,xiào',  # 俏
    0x4FD0: 'lì',  # 俐
    0x4FD1: 'yǒng',  # 俑
    0x4FD2: 'hùn',  # 俒
    0x4FD3: 'jìng',  # 俓
    0x4FD4: 'qiàn',  # 俔
    0x4FD5: 'sàn',  # 俕
    0x4FD6: 'pěi',  # 俖
    0x4FD7: 'sú',  # 俗
    0x4FD8: 'fú',  # 俘
    0x4FD9: 'xī',  # 俙
    0x4FDA: 'lǐ',  # 俚
    0x4FDB: 'fǔ',  # 俛
    0x4FDC: 'pīng',  # 俜
    0x4FDD: 'bǎo',  # 保
    0x4FDE: 'yú,yù,shù',  # 俞
    0x4FDF: 'sì,qí',  # 俟
    0x4FE0: 'xiá',  # 俠
    0x4FE1: 'xìn,shēn',  # 信
    0x4FE2: 'xiū',  # 俢
    0x4FE3: 'yǔ',  # 俣
    0x4FE4: 'dì',  # 俤
    0x4FE5: 'chē,jū',  # 俥
    0x4FE6: 'chóu',  # 俦
    0x4FE7: 'zhì',  # 俧
    0x4FE8: 'yǎn',  # 俨
    0x4FE9: 'liǎng,liǎ',  # 俩
    0x4FEA: 'lì',  # 俪
    0x4FEB: 'lái',  # 俫
    0x4FEC: 'sī',  # 俬
    0x4FED: 'jiǎn',  # 俭
    0x4FEE: 'xiū',  # 修
    0x4FEF: 'fǔ',  # 俯
    0x4FF0: 'huò',  # 俰
    0x4FF1: 'jù',  # 俱
    0x4FF2: 'xiào',  # 俲
    0x4FF3: 'pái',  # 俳
    0x4FF4: 'jiàn',  # 俴
    0x4FF5: 'biào',  # 俵
    0x4FF6: 'chù,tì',  # 俶
    0x4FF7: 'fèi',  # 俷
    0x4FF8: 'fèng',  # 俸
    0x4FF9: 'yà',  # 俹
    0x4FFA: 'ǎn',  # 俺
    0x4FFB: 'bèi',  # 俻
    0x4FFC: 'yù',  # 俼
    0x4FFD: 'xīn',  # 俽
    0x4FFE: 'bǐ',  # 俾
    0x4FFF: 'hǔ,chí',  # 俿
    0x5000: 'chāng',  # 倀
    0x5001: 'zhī',  # 倁
    0x5002: 'bìng',  # 倂
    0x5003: 'jiù',  # 倃
    0x5004: 'yáo',  # 倄
    0x5005: 'cuì,zú',  # 倅
    0x5006: 'liǎng,liǎ',  # 倆
    0x5007: 'wǎn',  # 倇
    0x5008: 'lái',  # 倈
    0x5009: 'cāng',  # 倉
    0x500A: 'zǒng',  # 倊
    0x500B: 'gè,gě',  # 個
    0x500C: 'guān',  # 倌
    0x500D: 'bèi',  # 倍
    0x500E: 'tiǎn',  # 倎
    0x500F: 'shū',  # 倏
    0x5010: 'shū',  # 倐
    0x5011: 'mén',  # 們
    0x5012: 'dǎo,dào',  # 倒
    0x5013: 'tán,tàn',  # 倓
    0x5014: 'jué,juè',  # 倔
    0x5015: 'chuí',  # 倕
    0x5016: 'xìng',  # 倖
    0x5017: 'péng',  # 倗
    0x5018: 'tǎng,cháng',  # 倘
    0x5019: 'hòu',  # 候
    0x501A: 'yǐ',  # 倚
    0x501B: 'qī',  # 倛
    0x501C: 'tì',  # 倜
    0x501D: 'gàn',  # 倝
    0x501E: 'liàng,jìng',  # 倞
    0x501F: 'jiè',  # 借
    0x5020: 'suī',  # 倠
    0x5021: 'chàng,chāng',  # 倡
    0x5022: 'jié',  # 倢
    0x5023: 'fǎng',  # 倣
    0x5024: 'zhí',  # 値
    0x5025: 'kōng,kǒng',  # 倥
    0x5026: 'juàn',  # 倦
    0x5027: 'zōng',  # 倧
    0x5028: 'jù',  # 倨
    0x5029: 'qiàn',  # 倩
    0x502A: 'ní',  # 倪
    0x502B: 'lún',  # 倫
    0x502C: 'zhuō',  # 倬
    0x502D: 'wō,wēi',  # 倭
    0x502E: 'luǒ',  # 倮
    0x502F: 'sōng',  # 倯
    0x5030: 'lèng',  # 倰
    0x5031: 'hùn',  # 倱
    0x5032: 'dōng',  # 倲
    0x5033: 'zì',  # 倳
    0x5034: 'bèn',  # 倴
    0x5035: 'wǔ',  # 倵
    0x5036: 'jù',  # 倶
    0x5037: 'nǎi',  # 倷
    0x5038: 'cǎi',  # 倸
    0x5039: 'jiǎn',  # 倹
    0x503A: 'zhài',  # 债
    0x503B: 'yē',  # 倻
    0x503C: 'zhí',  # 值
    0x503D: 'shà',  # 倽
    0x503E: 'qīng',  # 倾
    0x503F: 'nìng',  # 倿
    0x5040: 'yīng',  # 偀
    0x5041: 'chēng,chèn',  # 偁
    0x5042: 'qián',  # 偂
    0x5043: 'yǎn',  # 偃
    0x5044: 'ruǎn',  # 偄
    0x5045: 'zhòng,tóng',  # 偅
    0x5046: 'chǔn',  # 偆
    0x5047: 'jiǎ,jià',  # 假
    0x5048: 'jì,jié',  # 偈
    0x5049: 'wěi',  # 偉
    0x504A: 'yǔ',  # 偊
    0x504B: 'bǐng,bìng',  # 偋
    0x504C: 'ruò',  # 偌
    0x504D: 'tí',  # 偍
    0x504E: 'wēi',  # 偎
    0x504F: 'piān',  # 偏
    0x5050: 'yàn',  # 偐
    0x5051: 'fēng',  # 偑
    0x5052: 'tǎng,dàng',  # 偒
    0x5053: 'wò',  # 偓
    0x5054: 'è',  # 偔
    0x5055: 'xié',  # 偕
    0x5056: 'chě',  # 偖
    0x5057: 'shěng',  # 偗
    0x5058: 'kǎn',  # 偘
    0x5059: 'dì',  # 偙
    0x505A: 'zuò',  # 做
    0x505B: 'chā',  # 偛
    0x505C: 'tíng',  # 停
    0x505D: 'bèi',  # 偝
    0x505E: 'xiè',  # 偞
    0x505F: 'huáng',  # 偟
    0x5060: 'yǎo',  # 偠
    0x5061: 'zhàn',  # 偡
    0x5062: 'chǒu,qiào',  # 偢
    0x5063: 'ān',  # 偣
    0x5064: 'yóu',  # 偤
    0x5065: 'jiàn',  # 健
    0x5066: 'xū',  # 偦
    0x5067: 'zhā',  # 偧
    0x5068: 'cī',  # 偨
    0x5069: 'fù',  # 偩
    0x506A: 'bī',  # 偪
    0x506B: 'zhì',  # 偫
    0x506C: 'zǒng',  # 偬
    0x506D: 'miǎn',  # 偭
    0x506E: 'jí',  # 偮
    0x506F: 'yǐ',  # 偯
    0x5070: 'xiè',  # 偰
    0x5071: 'xún',  # 偱
    0x5072: 'cāi,sī',  # 偲
    0x5073: 'duān',  # 偳
    0x5074: 'cè,zè,zhāi',  # 側
    0x5075: 'zhēn',  # 偵
    0x5076: 'ǒu',  # 偶
    0x5077: 'tōu',  # 偷
    0x5078: 'tōu',  # 偸
    0x5079: 'bèi',  # 偹
    0x507A: 'zán,zá,zǎ',  # 偺
    0x507B: 'lǚ,lóu',  # 偻
    0x507C: 'jié',  # 偼
    0x507D: 'wěi',  # 偽
    0x507E: 'fèn',  # 偾
    0x507F: 'cháng',  # 偿
    0x5080: 'kuǐ,guī',  # 傀
    0x5081: 'sǒu',  # 傁
    0x5082: 'zhì,sī',  # 傂
    0x5083: 'sù',  # 傃
    0x5084: 'xiā',  # 傄
    0x5085: 'fù',  # 傅
    0x5086: 'yuàn,yuán',  # 傆
    0x5087: 'rǒng',  # 傇
    0x5088: 'lì',  # 傈
    0x5089: 'nù',  # 傉
    0x508A: 'yùn',  # 傊
    0x508B: 'jiǎng,gòu',  # 傋
    0x508C: 'mà',  # 傌
    0x508D: 'bàng',  # 傍
    0x508E: 'diān',  # 傎
    0x508F: 'táng',  # 傏
    0x5090: 'hào',  # 傐
    0x5091: 'jié',  # 傑
    0x5092: 'xī,xì',  # 傒
    0x5093: 'shān',  # 傓
    0x5094: 'qiàn,jiān',  # 傔
    0x5095: 'què,jué',  # 傕
    0x5096: 'cāng,chen',  # 傖
    0x5097: 'chù',  # 傗
    0x5098: 'sǎn',  # 傘
    0x5099: 'bèi',  # 備
    0x509A: 'xiào',  # 傚
    0x509B: 'róng',  # 傛
    0x509C: 'yáo',  # 傜
    0x509D: 'tà,tàn',  # 傝
    0x509E: 'suō',  # 傞
    0x509F: 'yǎng',  # 傟
    0x50A0: 'fá',  # 傠
    0x50A1: 'bìng',  # 傡
    0x50A2: 'jiā',  # 傢
    0x50A3: 'dǎi',  # 傣
    0x50A4: 'zài',  # 傤
    0x50A5: 'tǎng',  # 傥
    0x50A6: 'gǔ',  # 傦
    0x50A7: 'bīn',  # 傧
    0x50A8: 'chǔ',  # 储
    0x50A9: 'nuó',  # 傩
    0x50AA: 'cān,càn',  # 傪
    0x50AB: 'lěi',  # 傫
    0x50AC: 'cuī',  # 催
    0x50AD: 'yōng',  # 傭
    0x50AE: 'zāo,cáo',  # 傮
    0x50AF: 'zǒng',  # 傯
    0x50B0: 'péng',  # 傰
    0x50B1: 'sǒng',  # 傱
    0x50B2: 'ào',  # 傲
    0x50B3: 'chuán,zhuàn',  # 傳
    0x50B4: 'yǔ',  # 傴
    0x50B5: 'zhài',  # 債
    0x50B6: 'qī,còu',  # 傶
    0x50B7: 'shāng',  # 傷
    0x50B8: 'chuǎng',  # 傸
    0x50B9: 'jìng',  # 傹
    0x50BA: 'chì',  # 傺
    0x50BB: 'shǎ',  # 傻
    0x50BC: 'hàn',  # 傼
    0x50BD: 'zhāng',  # 傽
    0x50BE: 'qīng',  # 傾
    0x50BF: 'yān,yàn',  # 傿
    0x50C0: 'dì',  # 僀
    0x50C1: 'xiè',  # 僁
    0x50C2: 'lǚ,lóu',  # 僂
    0x50C3: 'bèi',  # 僃
    0x50C4: 'piào,biāo',  # 僄
    0x50C5: 'jǐn,jìn',  # 僅
    0x50C6: 'liàn',  # 僆
    0x50C7: 'lù',  # 僇
    0x50C8: 'màn',  # 僈
    0x50C9: 'qiān',  # 僉
    0x50CA: 'xiān',  # 僊
    0x50CB: 'tǎn,tàn',  # 僋
    0x50CC: 'yíng',  # 僌
    0x50CD: 'dòng',  # 働
    0x50CE: 'zhuàn',  # 僎
    0x50CF: 'xiàng',  # 像
    0x50D0: 'shàn',  # 僐
    0x50D1: 'qiáo',  # 僑
    0x50D2: 'jiǒng',  # 僒
    0x50D3: 'tuǐ,tuí',  # 僓
    0x50D4: 'zǔn',  # 僔
    0x50D5: 'pú',  # 僕
    0x50D6: 'xī',  # 僖
    0x50D7: 'láo',  # 僗
    0x50D8: 'chǎng',  # 僘
    0x50D9: 'guāng',  # 僙
    0x50DA: 'liáo',  # 僚
    0x50DB: 'qī',  # 僛
    0x50DC: 'chēng,dēng',  # 僜
    0x50DD: 'zhàn,zhuàn,chán',  # 僝
    0x50DE: 'wěi',  # 僞
    0x50DF: 'jī',  # 僟
    0x50E0: 'bō',  # 僠
    0x50E1: 'huì',  # 僡
    0x50E2: 'chuǎn',  # 僢
    0x50E3: 'tiě,jiàn',  # 僣
    0x50E4: 'dàn',  # 僤
    0x50E5: 'jiǎo,yáo',  # 僥
    0x50E6: 'jiù',  # 僦
    0x50E7: 'sēng',  # 僧
    0x50E8: 'fèn',  # 僨
    0x50E9: 'xiàn',  # 僩
    0x50EA: 'yù,jú',  # 僪
    0x50EB: 'è,wù,wū',  # 僫
    0x50EC: 'jiāo',  # 僬
    0x50ED: 'jiàn',  # 僭
    0x50EE: 'tóng,zhuàng',  # 僮
    0x50EF: 'lǐn',  # 僯
    0x50F0: 'bó',  # 僰
    0x50F1: 'gù',  # 僱
    0x50F2: 'xiān',  # 僲
    0x50F3: 'sù',  # 僳
    0x50F4: 'xiàn',  # 僴
    0x50F5: 'jiāng',  # 僵
    0x50F6: 'mǐn',  # 僶
    0x50F7: 'yè',  # 僷
    0x50F8: 'jìn',  # 僸
    0x50F9: 'jià,jie',  # 價
    0x50FA: 'qiào',  # 僺
    0x50FB: 'pì',  # 僻
    0x50FC: 'fēng',  # 僼
    0x50FD: 'zhòu',  # 僽
    0x50FE: 'ài',  # 僾
    0x50FF: 'sài',  # 僿
    0x5100: 'yí',  # 儀
    0x5101: 'jùn',  # 儁
    0x5102: 'nóng',  # 儂
    0x5103: 'chán,tǎn,shàn',  # 儃
    0x5104: 'yì',  # 億
    0x5105: 'dāng,dàng',  # 儅
    0x5106: 'jǐng',  # 儆
    0x5107: 'xuān',  # 儇
    0x5108: 'kuài',  # 儈
    0x5109: 'jiǎn',  # 儉
    0x510A: 'chù',  # 儊
    0x510B: 'dān,dàn',  # 儋
    0x510C: 'jiǎo',  # 儌
    0x510D: 'shǎ',  # 儍
    0x510E: 'zài',  # 儎
    0x510F: 'càn',  # 儏
    0x5110: 'bīn,bìn',  # 儐
    0x5111: 'án,àn',  # 儑
    0x5112: 'rú',  # 儒
    0x5113: 'tái',  # 儓
    0x5114: 'chóu',  # 儔
    0x5115: 'chái',  # 儕
    0x5116: 'lán',  # 儖
    0x5117: 'nǐ,yì',  # 儗
    0x5118: 'jǐn',  # 儘
    0x5119: 'qiàn',  # 儙
    0x511A: 'méng',  # 儚
    0x511B: 'wǔ',  # 儛
    0x511C: 'níng',  # 儜
    0x511D: 'qióng',  # 儝
    0x511E: 'nǐ',  # 儞
    0x511F: 'cháng',  # 償
    0x5120: 'liè',  # 儠
    0x5121: 'lěi',  # 儡
    0x5122: 'lǚ',  # 儢
    0x5123: 'kuǎng',  # 儣
    0x5124: 'bào',  # 儤
    0x5125: 'yù',  # 儥
    0x5126: 'biāo',  # 儦
    0x5127: 'zǎn',  # 儧
    0x5128: 'zhì',  # 儨
    0x5129: 'sì',  # 儩
    0x512A: 'yōu',  # 優
    0x512B: 'háo',  # 儫
    0x512C: 'qìng',  # 儬
    0x512D: 'chèn',  # 儭
    0x512E: 'lì',  # 儮
    0x512F: 'téng',  # 儯
    0x5130: 'wěi',  # 儰
    0x5131: 'lǒng,lóng,lòng',  # 儱
    0x5132: 'chǔ',  # 儲
    0x5133: 'chán,chàn',  # 儳
    0x5134: 'ráng,xiāng',  # 儴
    0x5135: 'shū',  # 儵
    0x5136: 'huì,xié',  # 儶
    0x5137: 'lì',  # 儷
    0x5138: 'luó',  # 儸
    0x5139: 'zǎn',  # 儹
    0x513A: 'nuó',  # 儺
    0x513B: 'tǎng',  # 儻
    0x513C: 'yǎn',  # 儼
    0x513D: 'léi',  # 儽
    0x513E: 'nàng,nāng',  # 儾
    0x513F: 'ér',  # 儿
    0x5140: 'wù',  # 兀
    0x5141: 'yǔn',  # 允
    0x5142: 'zān',  # 兂
    0x5143: 'yuán',  # 元
    0x5144: 'xiōng',  # 兄
    0x5145: 'chōng',  # 充
    0x5146: 'zhào',  # 兆
    0x5147: 'xiōng',  # 兇
    0x5148: 'xiān',  # 先
    0x5149: 'guāng',  # 光
    0x514A: 'duì,ruì,yuè',  # 兊
    0x514B: 'kè',  # 克
    0x514C: 'duì,ruì,yuè',  # 兌
    0x514D: 'miǎn',  # 免
    0x514E: 'tù',  # 兎
    0x514F: 'cháng,zhǎng',  # 兏
    0x5150: 'ér',  # 児
    0x5151: 'duì,ruì,yuè',  # 兑
    0x5152: 'ér',  # 兒
    0x5153: 'qīn',  # 兓
    0x5154: 'tù',  # 兔
    0x5155: 'sì',  # 兕
    0x5156: 'yǎn',  # 兖
    0x5157: 'yǎn',  # 兗
    0x5158: 'shǐ',  # 兘
    0x5159: 'shíkě',  # 兙
    0x515A: 'dǎng',  # 党
    0x515B: 'qiānkè',  # 兛
    0x515C: 'dōu',  # 兜
    0x515D: 'gōngfēn',  # 兝
    0x515E: 'háokè',  # 兞
    0x515F: 'shēn',  # 兟
    0x5160: 'dōu',  # 兠
    0x5161: 'bǎikè',  # 兡
    0x5162: 'jīng',  # 兢
    0x5163: 'gōnglǐ',  # 兣
    0x5164: 'huǎng',  # 兤
    0x5165: 'rù',  # 入
    0x5166: 'wáng',  # 兦
    0x5167: 'nèi',  # 內
    0x5168: 'quán',  # 全
    0x5169: 'liǎng',  # 兩
    0x516A: 'yú,shù',  # 兪
    0x516B: 'bā',  # 八
    0x516C: 'gōng',  # 公
    0x516D: 'liù,lù',  # 六
    0x516E: 'xī',  # 兮
    0x516F: 'han',  # 兯
    0x5170: 'lán',  # 兰
    0x5171: 'gòng,gōng',  # 共
    0x5172: 'tiān',  # 兲
    0x5173: 'guān',  # 关
    0x5174: 'xīng,xìng',  # 兴
    0x5175: 'bīng',  # 兵
    0x5176: 'qí,jī',  # 其
    0x5177: 'jù',  # 具
    0x5178: 'diǎn',  # 典
    0x5179: 'zī,cí',  # 兹
    0x517A: 'būn',  # 兺
    0x517B: 'yǎng',  # 养
    0x517C: 'jiān',  # 兼
    0x517D: 'shòu',  # 兽
    0x517E: 'jì',  # 兾
    0x517F: 'yì',  # 兿
    0x5180: 'jì',  # 冀
    0x5181: 'chǎn',  # 冁
    0x5182: 'jiōng',  # 冂
    0x5183: 'mào',  # 冃
    0x5184: 'rǎn',  # 冄
    0x5185: 'nèi,nà',  # 内
    0x5186: 'yuán',  # 円
    0x5187: 'mǎo',  # 冇
    0x5188: 'gāng',  # 冈
    0x5189: 'rǎn',  # 冉
    0x518A: 'cè',  # 冊
    0x518B: 'jiōng',  # 冋
    0x518C: 'cè',  # 册
    0x518D: 'zài',  # 再
    0x518E: 'guǎ',  # 冎
    0x518F: 'jiǒng',  # 冏
    0x5190: 'mào',  # 冐
    0x5191: 'zhòu',  # 冑
    0x5192: 'mào,mò',  # 冒
    0x5193: 'gòu',  # 冓
    0x5194: 'xú',  # 冔
    0x5195: 'miǎn',  # 冕
    0x5196: 'mì',  # 冖
    0x5197: 'rǒng',  # 冗
    0x5198: 'yín,yóu',  # 冘
    0x5199: 'xiě',  # 写
    0x519A: 'kǎn',  # 冚
    0x519B: 'jūn',  # 军
    0x519C: 'nóng',  # 农
    0x519D: 'yí',  # 冝
    0x519E: 'mí',  # 冞
    0x519F: 'shì',  # 冟
    0x51A0: 'guān,guàn',  # 冠
    0x51A1: 'měng',  # 冡
    0x51A2: 'zhǒng',  # 冢
    0x51A3: 'zuì',  # 冣
    0x51A4: 'yuān',  # 冤
    0x51A5: 'míng',  # 冥
    0x51A6: 'kòu',  # 冦
    0x51A7: 'lín',  # 冧
    0x51A8: 'fù',  # 冨
    0x51A9: 'xiě',  # 冩
    0x51AA: 'mì',  # 冪
    0x51AB: 'bīng',  # 冫
    0x51AC: 'dōng',  # 冬
    0x51AD: 'tài',  # 冭
    0x51AE: 'gāng',  # 冮
    0x51AF: 'féng,píng',  # 冯
    0x51B0: 'bīng',  # 冰
    0x51B1: 'hù',  # 冱
    0x51B2: 'chōng,chòng',  # 冲
    0x51B3: 'jué',  # 决
    0x51B4: 'yà',  # 冴
    0x51B5: 'kuàng',  # 况
    0x51B6: 'yě',  # 冶
    0x51B7: 'lěng',  # 冷
    0x51B8: 'pàn',  # 冸
    0x51B9: 'fā',  # 冹
    0x51BA: 'mǐn',  # 冺
    0x51BB: 'dòng',  # 冻
    0x51BC: 'xiǎn',  # 冼
    0x51BD: 'liè',  # 冽
    0x51BE: 'qià',  # 冾
    0x51BF: 'jiān',  # 冿
    0x51C0: 'jìng,chēng',  # 净
    0x51C1: 'sōu',  # 凁
    0x51C2: 'měi',  # 凂
    0x51C3: 'tú',  # 凃
    0x51C4: 'qī',  # 凄
    0x51C5: 'gù',  # 凅
    0x51C6: 'zhǔn',  # 准
    0x51C7: 'sōng',  # 凇
    0x51C8: 'jìng,chēng',  # 凈
    0x51C9: 'liáng,liàng',  # 凉
    0x51CA: 'qìng',  # 凊
    0x51CB: 'diāo',  # 凋
    0x51CC: 'líng',  # 凌
    0x51CD: 'dòng',  # 凍
    0x51CE: 'gàn',  # 凎
    0x51CF: 'jiǎn',  # 减
    0x51D0: 'yīn',  # 凐
    0x51D1: 'còu',  # 凑
    0x51D2: 'ái',  # 凒
    0x51D3: 'lì',  # 凓
    0x51D4: 'cāng',  # 凔
    0x51D5: 'mǐng',  # 凕
    0x51D6: 'zhǔn',  # 凖
    0x51D7: 'cuī',  # 凗
    0x51D8: 'sī',  # 凘
    0x51D9: 'duó',  # 凙
    0x51DA: 'jìn',  # 凚
    0x51DB: 'lǐn',  # 凛
    0x51DC: 'lǐn',  # 凜
    0x51DD: 'níng',  # 凝
    0x51DE: 'xī',  # 凞
    0x51DF: 'dú',  # 凟
    0x51E0: 'jī,jǐ',  # 几
    0x51E1: 'fán',  # 凡
    0x51E2: 'fán',  # 凢
    0x51E3: 'fán',  # 凣
    0x51E4: 'fèng',  # 凤
    0x51E5: 'jū',  # 凥
    0x51E6: 'chù,chǔ',  # 処
    0x51E7: 'zhēng',  # 凧
    0x51E8: 'fēng',  # 凨
    0x51E9: 'mù',  # 凩
    0x51EA: 'zhǐ',  # 凪
    0x51EB: 'fú',  # 凫
    0x51EC: 'fēng',  # 凬
    0x51ED: 'píng',  # 凭
    0x51EE: 'fēng',  # 凮
    0x51EF: 'kǎi',  # 凯
    0x51F0: 'huáng',  # 凰
    0x51F1: 'kǎi',  # 凱
    0x51F2: 'gān',  # 凲
    0x51F3: 'dèng',  # 凳
    0x51F4: 'píng',  # 凴
    0x51F5: 'kǎn,qiǎn',  # 凵
    0x51F6: 'xiōng',  # 凶
    0x51F7: 'kuài',  # 凷
    0x51F8: 'tū',  # 凸
    0x51F9: 'āo,wā',  # 凹
    0x51FA: 'chū',  # 出
    0x51FB: 'jī',  # 击
    0x51FC: 'dàng',  # 凼
    0x51FD: 'hán',  # 函
    0x51FE: 'hán',  # 凾
    0x51FF: 'záo',  # 凿
    0x5200: 'dāo',  # 刀
    0x5201: 'diāo',  # 刁
    0x5202: 'dāo',  # 刂
    0x5203: 'rèn',  # 刃
    0x5204: 'rèn',  # 刄
    0x5205: 'chuāng',  # 刅
    0x5206: 'fēn,fèn',  # 分
    0x5207: 'qiē,qiè',  # 切
    0x5208: 'yì',  # 刈
    0x5209: 'jī',  # 刉
    0x520A: 'kān',  # 刊
    0x520B: 'qiàn',  # 刋
    0x520C: 'cǔn',  # 刌
    0x520D: 'chú',  # 刍
    0x520E: 'wěn',  # 刎
    0x520F: 'jī',  # 刏
    0x5210: 'dǎn',  # 刐
    0x5211: 'xíng',  # 刑
    0x5212: 'huá,huà',  # 划
    0x5213: 'wán',  # 刓
    0x5214: 'jué',  # 刔
    0x5215: 'lí',  # 刕
    0x5216: 'yuè',  # 刖
    0x5217: 'liè',  # 列
    0x5218: 'liú',  # 刘
    0x5219: 'zé',  # 则
    0x521A: 'gāng',  # 刚
    0x521B: 'chuàng,chuāng',  # 创
    0x521C: 'fú',  # 刜
    0x521D: 'chū',  # 初
    0x521E: 'qù',  # 刞
    0x521F: 'diāo',  # 刟
    0x5220: 'shān',  # 删
    0x5221: 'mǐn',  # 刡
    0x5222: 'líng',  # 刢
    0x5223: 'zhōng',  # 刣
    0x5224: 'pàn',  # 判
    0x5225: 'bié,biè',  # 別
    0x5226: 'jié',  # 刦
    0x5227: 'jié',  # 刧
    0x5228: 'páo,bào',  # 刨
    0x5229: 'lì',  # 利
    0x522A: 'shān',  # 刪
    0x522B: 'bié,biè',  # 别
    0x522C: 'chǎn,chàn',  # 刬
    0x522D: 'jǐng',  # 刭
    0x522E: 'guā',  # 刮
    0x522F: 'gēng',  # 刯
    0x5230: 'dào',  # 到
    0x5231: 'chuàng',  # 刱
    0x5232: 'kuī',  # 刲
    0x5233: 'kū',  # 刳
    0x5234: 'duò',  # 刴
    0x5235: 'èr',  # 刵
    0x5236: 'zhì',  # 制
    0x5237: 'shuā,shuà',  # 刷
    0x5238: 'quàn,xuàn',  # 券
    0x5239: 'chà,shā',  # 刹
    0x523A: 'cì,cī',  # 刺
    0x523B: 'kè',  # 刻
    0x523C: 'jié',  # 刼
    0x523D: 'guì',  # 刽
    0x523E: 'cì',  # 刾
    0x523F: 'guì',  # 刿
    0x5240: 'kǎi',  # 剀
    0x5241: 'duò',  # 剁
    0x5242: 'jì',  # 剂
    0x5243: 'tì',  # 剃
    0x5244: 'jǐng',  # 剄
    0x5245: 'lóu',  # 剅
    0x5246: 'luǒ',  # 剆
    0x5247: 'zé',  # 則
    0x5248: 'yuān',  # 剈
    0x5249: 'cuò',  # 剉
    0x524A: 'xiāo,xuē',  # 削
    0x524B: 'kēi,kè',  # 剋
    0x524C: 'là,lá',  # 剌
    0x524D: 'qián',  # 前
    0x524E: 'chà,shā',  # 剎
    0x524F: 'chuàng',  # 剏
    0x5250: 'guǎ',  # 剐
    0x5251: 'jiàn',  # 剑
    0x5252: 'cuò',  # 剒
    0x5253: 'lí',  # 剓
    0x5254: 'tī',  # 剔
    0x5255: 'fèi',  # 剕
    0x5256: 'pōu',  # 剖
    0x5257: 'chǎn,chàn',  # 剗
    0x5258: 'qí',  # 剘
    0x5259: 'chuàng',  # 剙
    0x525A: 'zì',  # 剚
    0x525B: 'gāng',  # 剛
    0x525C: 'wān',  # 剜
    0x525D: 'bāo,bō',  # 剝
    0x525E: 'jī',  # 剞
    0x525F: 'duō',  # 剟
    0x5260: 'qíng',  # 剠
    0x5261: 'yǎn,shàn',  # 剡
    0x5262: 'dū,zhuó',  # 剢
    0x5263: 'jiàn',  # 剣
    0x5264: 'jì',  # 剤
    0x5265: 'bāo,bō',  # 剥
    0x5266: 'yān',  # 剦
    0x5267: 'jù',  # 剧
    0x5268: 'huò',  # 剨
    0x5269: 'shèng',  # 剩
    0x526A: 'jiǎn',  # 剪
    0x526B: 'duó',  # 剫
    0x526C: 'zhì,duān',  # 剬
    0x526D: 'wū',  # 剭
    0x526E: 'guǎ',  # 剮
    0x526F: 'fù,pì',  # 副
    0x5270: 'shèng',  # 剰
    0x5271: 'jiàn',  # 剱
    0x5272: 'gē',  # 割
    0x5273: 'dá,zhá',  # 剳
    0x5274: 'kǎi',  # 剴
    0x5275: 'chuàng,chuāng',  # 創
    0x5276: 'chuán',  # 剶
    0x5277: 'chǎn',  # 剷
    0x5278: 'tuán,zhuān',  # 剸
    0x5279: 'lù,jiū',  # 剹
    0x527A: 'lí',  # 剺
    0x527B: 'pēng',  # 剻
    0x527C: 'shān',  # 剼
    0x527D: 'piāo',  # 剽
    0x527E: 'kōu',  # 剾
    0x527F: 'jiǎo,chāo',  # 剿
    0x5280: 'guā',  # 劀
    0x5281: 'qiāo',  # 劁
    0x5282: 'jué',  # 劂
    0x5283: 'huá,huà',  # 劃
    0x5284: 'zhā,zhá',  # 劄
    0x5285: 'zhuó',  # 劅
    0x5286: 'lián',  # 劆
    0x5287: 'jù',  # 劇
    0x5288: 'pī,pǐ',  # 劈
    0x5289: 'liú',  # 劉
    0x528A: 'guì',  # 劊
    0x528B: 'jiǎo,chāo',  # 劋
    0x528C: 'guì',  # 劌
    0x528D: 'jiàn',  # 劍
    0x528E: 'jiàn',  # 劎
    0x528F: 'tāng',  # 劏
    0x5290: 'huō',  # 劐
    0x5291: 'jì',  # 劑
    0x5292: 'jiàn',  # 劒
    0x5293: 'yì',  # 劓
    0x5294: 'jiàn',  # 劔
    0x5295: 'zhì',  # 劕
    0x5296: 'chán',  # 劖
    0x5297: 'zuān',  # 劗
    0x5298: 'mó',  # 劘
    0x5299: 'lí',  # 劙
    0x529A: 'zhú',  # 劚
    0x529B: 'lì',  # 力
    0x529C: 'yà',  # 劜
    0x529D: 'quàn',  # 劝
    0x529E: 'bàn',  # 办
    0x529F: 'gōng',  # 功
    0x52A0: 'jiā',  # 加
    0x52A1: 'wù',  # 务
    0x52A2: 'mài',  # 劢
    0x52A3: 'liè',  # 劣
    0x52A4: 'jìn,jìng',  # 劤
    0x52A5: 'kēng',  # 劥
    0x52A6: 'xié,liè',  # 劦
    0x52A7: 'zhǐ',  # 劧
    0x52A8: 'dòng',  # 动
    0x52A9: 'zhù,chú',  # 助
    0x52AA: 'nǔ',  # 努
    0x52AB: 'jié',  # 劫
    0x52AC: 'qú',  # 劬
    0x52AD: 'shào',  # 劭
    0x52AE: 'yì',  # 劮
    0x52AF: 'zhǔ',  # 劯
    0x52B0: 'miǎo',  # 劰
    0x52B1: 'lì',  # 励
    0x52B2: 'jìn,jìng',  # 劲
    0x52B3: 'láo',  # 劳
    0x52B4: 'láo',  # 労
    0x52B5: 'juàn',  # 劵
    0x52B6: 'kǒu',  # 劶
    0x52B7: 'yáng',  # 劷
    0x52B8: 'wā',  # 劸
    0x52B9: 'xiào',  # 効
    0x52BA: 'móu',  # 劺
    0x52BB: 'kuāng',  # 劻
    0x52BC: 'jié',  # 劼
    0x52BD: 'liè',  # 劽
    0x52BE: 'hé',  # 劾
    0x52BF: 'shì',  # 势
    0x52C0: 'kè',  # 勀
    0x52C1: 'jìn,jìng',  # 勁
    0x52C2: 'gào',  # 勂
    0x52C3: 'bó,bèi',  # 勃
    0x52C4: 'mǐn',  # 勄
    0x52C5: 'chì',  # 勅
    0x52C6: 'láng',  # 勆
    0x52C7: 'yǒng',  # 勇
    0x52C8: 'yǒng',  # 勈
    0x52C9: 'miǎn',  # 勉
    0x52CA: 'kè',  # 勊
    0x52CB: 'xūn',  # 勋
    0x52CC: 'juàn,juān',  # 勌
    0x52CD: 'qíng',  # 勍
    0x52CE: 'lù',  # 勎
    0x52CF: 'bù',  # 勏
    0x52D0: 'měng',  # 勐
    0x52D1: 'chì',  # 勑
    0x52D2: 'lè,lēi',  # 勒
    0x52D3: 'kài',  # 勓
    0x52D4: 'miǎn',  # 勔
    0x52D5: 'dòng',  # 動
    0x52D6: 'xù',  # 勖
    0x52D7: 'xù',  # 勗
    0x52D8: 'kān',  # 勘
    0x52D9: 'wù',  # 務
    0x52DA: 'yì',  # 勚
    0x52DB: 'xūn',  # 勛
    0x52DC: 'wěng,yǎng',  # 勜
    0x52DD: 'shèng',  # 勝
    0x52DE: 'láo',  # 勞
    0x52DF: 'mù',  # 募
    0x52E0: 'lù',  # 勠
    0x52E1: 'piāo',  # 勡
    0x52E2: 'shì',  # 勢
    0x52E3: 'jì',  # 勣
    0x52E4: 'qín',  # 勤
    0x52E5: 'jiàng',  # 勥
    0x52E6: 'jiǎo,chāo',  # 勦
    0x52E7: 'quàn',  # 勧
    0x52E8: 'xiàng',  # 勨
    0x52E9: 'yì',  # 勩
    0x52EA: 'qiāo',  # 勪
    0x52EB: 'fān',  # 勫
    0x52EC: 'juān',  # 勬
    0x52ED: 'tóng,dòng',  # 勭
    0x52EE: 'jù',  # 勮
    0x52EF: 'dān',  # 勯
    0x52F0: 'xié',  # 勰
    0x52F1: 'mài',  # 勱
    0x52F2: 'xūn',  # 勲
    0x52F3: 'xūn',  # 勳
    0x52F4: 'lǜ',  # 勴
    0x52F5: 'lì',  # 勵
    0x52F6: 'chè',  # 勶
    0x52F7: 'ráng,xiāng',  # 勷
    0x52F8: 'quàn',  # 勸
    0x52F9: 'bāo',  # 勹
    0x52FA: 'sháo',  # 勺
    0x52FB: 'yún',  # 勻
    0x52FC: 'jiū',  # 勼
    0x52FD: 'bào',  # 勽
    0x52FE: 'gōu,gòu',  # 勾
    0x52FF: 'wù',  # 勿
    0x5300: 'yún',  # 匀
    0x5301: 'mangmi',  # 匁
    0x5302: 'xiōng',  # 匂
    0x5303: 'gài',  # 匃
    0x5304: 'gài',  # 匄
    0x5305: 'bāo',  # 包
    0x5306: 'cōng',  # 匆
    0x5307: 'yì',  # 匇
    0x5308: 'xiōng',  # 匈
    0x5309: 'pēng',  # 匉
    0x530A: 'jū',  # 匊
    0x530B: 'táo,yáo',  # 匋
    0x530C: 'gé',  # 匌
    0x530D: 'pú',  # 匍
    0x530E: 'è',  # 匎
    0x530F: 'páo',  # 匏
    0x5310: 'fú',  # 匐
    0x5311: 'gōng',  # 匑
    0x5312: 'dá',  # 匒
    0x5313: 'jiù',  # 匓
    0x5314: 'gōng',  # 匔
    0x5315: 'bǐ',  # 匕
    0x5316: 'huà,huā',  # 化
    0x5317: 'běi,bèi',  # 北
    0x5318: 'nǎo',  # 匘
    0x5319: 'chí,shi',  # 匙
    0x531A: 'fāng',  # 匚
    0x531B: 'jiù',  # 匛
    0x531C: 'yí',  # 匜
    0x531D: 'zā',  # 匝
    0x531E: 'jiàng',  # 匞
    0x531F: 'kàng',  # 匟
    0x5320: 'jiàng',  # 匠
    0x5321: 'kuāng',  # 匡
    0x5322: 'hū',  # 匢
    0x5323: 'xiá',  # 匣
    0x5324: 'qū',  # 匤
    0x5325: 'fán',  # 匥
    0x5326: 'guǐ',  # 匦
    0x5327: 'qiè',  # 匧
    0x5328: 'zāng,cáng',  # 匨
    0x5329: 'kuāng',  # 匩
    0x532A: 'fěi',  # 匪
    0x532B: 'hū',  # 匫
    0x532C: 'yǔ',  # 匬
    0x532D: 'guǐ',  # 匭
    0x532E: 'kuì,guì',  # 匮
    0x532F: 'huì',  # 匯
    0x5330: 'dān',  # 匰
    0x5331: 'kuì,guì',  # 匱
    0x5332: 'lián',  # 匲
    0x5333: 'lián',  # 匳
    0x5334: 'suǎn',  # 匴
    0x5335: 'dú',  # 匵
    0x5336: 'jiù',  # 匶
    0x5337: 'jué',  # 匷
    0x5338: 'xì',  # 匸
    0x5339: 'pǐ',  # 匹
    0x533A: 'qū,ōu',  # 区
    0x533B: 'yī',  # 医
    0x533C: 'kē,qià',  # 匼
    0x533D: 'yǎn,yàn',  # 匽
    0x533E: 'biǎn',  # 匾
    0x533F: 'nì',  # 匿
    0x5340: 'qū,ōu',  # 區
    0x5341: 'shí',  # 十
    0x5342: 'xùn',  # 卂
    0x5343: 'qiān',  # 千
    0x5344: 'niàn',  # 卄
    0x5345: 'sà',  # 卅
    0x5346: 'zú',  # 卆
    0x5347: 'shēng',  # 升
    0x5348: 'wǔ',  # 午
    0x5349: 'huì',  # 卉
    0x534A: 'bàn',  # 半
    0x534B: 'shì',  # 卋
    0x534C: 'xì',  # 卌
    0x534D: 'wàn',  # 卍
    0x534E: 'huá,huà,huā',  # 华
    0x534F: 'xié',  # 协
    0x5350: 'wàn',  # 卐
    0x5351: 'bēi',  # 卑
    0x5352: 'zú,cù',  # 卒
    0x5353: 'zhuó',  # 卓
    0x5354: 'xié',  # 協
    0x5355: 'dān,shàn,chán',  # 单
    0x5356: 'mài',  # 卖
    0x5357: 'nán,nā',  # 南
    0x5358: 'dān',  # 単
    0x5359: 'jí',  # 卙
    0x535A: 'bó',  # 博
    0x535B: 'shuài,lǜ',  # 卛
    0x535C: 'bǔ,bo',  # 卜
    0x535D: 'guàn,kuàng',  # 卝
    0x535E: 'biàn',  # 卞
    0x535F: 'bǔ',  # 卟
    0x5360: 'zhān,zhàn',  # 占
    0x5361: 'qiǎ,kǎ',  # 卡
    0x5362: 'lú',  # 卢
    0x5363: 'yǒu',  # 卣
    0x5364: 'lǔ',  # 卤
    0x5365: 'xī',  # 卥
    0x5366: 'guà',  # 卦
    0x5367: 'wò',  # 卧
    0x5368: 'xiè',  # 卨
    0x5369: 'jié',  # 卩
    0x536A: 'jié',  # 卪
    0x536B: 'wèi',  # 卫
    0x536C: 'yǎng,áng',  # 卬
    0x536D: 'qióng',  # 卭
    0x536E: 'zhī',  # 卮
    0x536F: 'mǎo',  # 卯
    0x5370: 'yìn',  # 印
    0x5371: 'wēi',  # 危
    0x5372: 'shào',  # 卲
    0x5373: 'jí',  # 即
    0x5374: 'què',  # 却
    0x5375: 'luǎn',  # 卵
    0x5376: 'chǐ',  # 卶
    0x5377: 'juàn,juǎn',  # 卷
    0x5378: 'xiè',  # 卸
    0x5379: 'xù',  # 卹
    0x537A: 'jǐn',  # 卺
    0x537B: 'què',  # 卻
    0x537C: 'wù',  # 卼
    0x537D: 'jí',  # 卽
    0x537E: 'è',  # 卾
    0x537F: 'qīng',  # 卿
    0x5380: 'xī',  # 厀
    0x5381: 'sān',  # 厁
    0x5382: 'chǎng,ān,hàn',  # 厂
    0x5383: 'wēi,yán',  # 厃
    0x5384: 'è',  # 厄
    0x5385: 'tīng',  # 厅
    0x5386: 'lì',  # 历
    0x5387: 'zhé,zhái',  # 厇
    0x5388: 'hàn,àn',  # 厈
    0x5389: 'lì',  # 厉
    0x538A: 'yǎ',  # 厊
    0x538B: 'yā,yà',  # 压
    0x538C: 'yàn',  # 厌
    0x538D: 'shè',  # 厍
    0x538E: 'dǐ',  # 厎
    0x538F: 'zhǎ,zhǎi',  # 厏
    0x5390: 'páng',  # 厐
    0x5391: 'yá',  # 厑
    0x5392: 'qiè',  # 厒
    0x5393: 'yá',  # 厓
    0x5394: 'zhì,shī',  # 厔
    0x5395: 'cè',  # 厕
    0x5396: 'máng',  # 厖
    0x5397: 'tí',  # 厗
    0x5398: 'lí',  # 厘
    0x5399: 'shè',  # 厙
    0x539A: 'hòu',  # 厚
    0x539B: 'tīng',  # 厛
    0x539C: 'zuī',  # 厜
    0x539D: 'cuò',  # 厝
    0x539E: 'fèi',  # 厞
    0x539F: 'yuán',  # 原
    0x53A0: 'cè',  # 厠
    0x53A1: 'yuán',  # 厡
    0x53A2: 'xiāng',  # 厢
    0x53A3: 'yǎn',  # 厣
    0x53A4: 'lì',  # 厤
    0x53A5: 'jué',  # 厥
    0x53A6: 'shà,xià',  # 厦
    0x53A7: 'diān',  # 厧
    0x53A8: 'chú',  # 厨
    0x53A9: 'jiù',  # 厩
    0x53AA: 'jǐn',  # 厪
    0x53AB: 'áo',  # 厫
    0x53AC: 'guǐ',  # 厬
    0x53AD: 'yàn',  # 厭
    0x53AE: 'sī',  # 厮
    0x53AF: 'lì',  # 厯
    0x53B0: 'chǎng',  # 厰
    0x53B1: 'qiān,lán',  # 厱
    0x53B2: 'lì',  # 厲
    0x53B3: 'yán',  # 厳
    0x53B4: 'yǎn',  # 厴
    0x53B5: 'yuán',  # 厵
    0x53B6: 'sī,mǒu',  # 厶
    0x53B7: 'gōng,hóng',  # 厷
    0x53B8: 'lín,miǎo',  # 厸
    0x53B9: 'róu,qiú',  # 厹
    0x53BA: 'qù',  # 厺
    0x53BB: 'qù',  # 去
    0x53BC: 'keum',  # 厼
    0x53BD: 'lěi',  # 厽
    0x53BE: 'dū',  # 厾
    0x53BF: 'xiàn,xuán',  # 县
    0x53C0: 'zhuān',  # 叀
    0x53C1: 'sān',  # 叁
    0x53C2: 'cān,shēn,cēn,sān',  # 参
    0x53C3: 'cān,shēn,cēn,sān',  # 參
    0x53C4: 'cān,shēn,cēn,sān',  # 叄
    0x53C5: 'cān,shēn,cēn,sān',  # 叅
    0x53C6: 'ài',  # 叆
    0x53C7: 'dài',  # 叇
    0x53C8: 'yòu',  # 又
    0x53C9: 'chā,chá,chǎ',  # 叉
    0x53CA: 'jí',  # 及
    0x53CB: 'yǒu',  # 友
    0x53CC: 'shuāng',  # 双
    0x53CD: 'fǎn',  # 反
    0x53CE: 'shōu',  # 収
    0x53CF: 'guái',  # 叏
    0x53D0: 'bá',  # 叐
    0x53D1: 'fā,fà',  # 发
    0x53D2: 'ruò',  # 叒
    0x53D3: 'lì',  # 叓
    0x53D4: 'shū',  # 叔
    0x53D5: 'zhuó,yǐ,lì,jué',  # 叕
    0x53D6: 'qǔ',  # 取
    0x53D7: 'shòu',  # 受
    0x53D8: 'biàn',  # 变
    0x53D9: 'xù',  # 叙
    0x53DA: 'jiǎ',  # 叚
    0x53DB: 'pàn',  # 叛
    0x53DC: 'sǒu',  # 叜
    0x53DD: 'jí',  # 叝
    0x53DE: 'wèi,yù',  # 叞
    0x53DF: 'sǒu',  # 叟
    0x53E0: 'dié',  # 叠
    0x53E1: 'ruì',  # 叡
    0x53E2: 'cóng',  # 叢
    0x53E3: 'kǒu',  # 口
    0x53E4: 'gǔ',  # 古
    0x53E5: 'jù,gōu',  # 句
    0x53E6: 'lìng',  # 另
    0x53E7: 'guǎ',  # 叧
    0x53E8: 'tāo,dāo',  # 叨
    0x53E9: 'kòu',  # 叩
    0x53EA: 'zhī,zhǐ',  # 只
    0x53EB: 'jiào',  # 叫
    0x53EC: 'zhào,shào',  # 召
    0x53ED: 'bā',  # 叭
    0x53EE: 'dīng',  # 叮
    0x53EF: 'kě,kè',  # 可
    0x53F0: 'tái,tāi',  # 台
    0x53F1: 'chì',  # 叱
    0x53F2: 'shǐ',  # 史
    0x53F3: 'yòu',  # 右
    0x53F4: 'qiú',  # 叴
    0x53F5: 'pǒ',  # 叵
    0x53F6: 'yè,xié',  # 叶
    0x53F7: 'hào,háo',  # 号
    0x53F8: 'sī',  # 司
    0x53F9: 'tàn',  # 叹
    0x53FA: 'chǐ',  # 叺
    0x53FB: 'lè',  # 叻
    0x53FC: 'diāo',  # 叼
    0x53FD: 'jī',  # 叽
    0x53FE: 'dug',  # 叾
    0x53FF: 'hōng,hóng',  # 叿
    0x5400: 'miē',  # 吀
    0x5401: 'xū,yù',  # 吁
    0x5402: 'máng',  # 吂
    0x5403: 'chī',  # 吃
    0x5404: 'gè,gě',  # 各
    0x5405: 'xuān,sòng',  # 吅
    0x5406: 'yāo',  # 吆
    0x5407: 'zǐ',  # 吇
    0x5408: 'hé,gě',  # 合
    0x5409: 'jí',  # 吉
    0x540A: 'diào',  # 吊
    0x540B: 'dòu,cùn',  # 吋
    0x540C: 'tóng,tòng',  # 同
    0x540D: 'míng',  # 名
    0x540E: 'hòu',  # 后
    0x540F: 'lì',  # 吏
    0x5410: 'tǔ,tù',  # 吐
    0x5411: 'xiàng',  # 向
    0x5412: 'zhà,zhā',  # 吒
    0x5413: 'xià,hè',  # 吓
    0x5414: 'yē',  # 吔
    0x5415: 'lǚ',  # 吕
    0x5416: 'yā,ā',  # 吖
    0x5417: 'má,mǎ,ma',  # 吗
    0x5418: 'ǒu',  # 吘
    0x5419: 'huō',  # 吙
    0x541A: 'yī',  # 吚
    0x541B: 'jūn',  # 君
    0x541C: 'chǒu',  # 吜
    0x541D: 'lìn',  # 吝
    0x541E: 'tūn',  # 吞
    0x541F: 'yín',  # 吟
    0x5420: 'fèi',  # 吠
    0x5421: 'pǐ,bǐ',  # 吡
    0x5422: 'qìn',  # 吢
    0x5423: 'qìn',  # 吣
    0x5424: 'jiè,gè',  # 吤
    0x5425: 'bù',  # 吥
    0x5426: 'fǒu,pǐ',  # 否
    0x5427: 'bā,ba',  # 吧
    0x5428: 'dūn',  # 吨
    0x5429: 'fēn',  # 吩
    0x542A: 'é,huā',  # 吪
    0x542B: 'hán',  # 含
    0x542C: 'tīng',  # 听
    0x542D: 'háng,kēng',  # 吭
    0x542E: 'shǔn',  # 吮
    0x542F: 'qǐ',  # 启
    0x5430: 'hóng',  # 吰
    0x5431: 'zhī,zī',  # 吱
    0x5432: 'yǐn,shěn',  # 吲
    0x5433: 'wú',  # 吳
    0x5434: 'wú',  # 吴
    0x5435: 'chǎo,chāo',  # 吵
    0x5436: 'nà,nè',  # 吶
    0x5437: 'xuè,chuò,jué',  # 吷
    0x5438: 'xī',  # 吸
    0x5439: 'chuī',  # 吹
    0x543A: 'dōu,rú',  # 吺
    0x543B: 'wěn',  # 吻
    0x543C: 'hǒu',  # 吼
    0x543D: 'hǒu,hōng,ōu',  # 吽
    0x543E: 'wú,yù',  # 吾
    0x543F: 'gào',  # 吿
    0x5440: 'yā,ya',  # 呀
    0x5441: 'jùn',  # 呁
    0x5442: 'lǚ',  # 呂
    0x5443: 'è',  # 呃
    0x5444: 'gé',  # 呄
    0x5445: 'wěn',  # 呅
    0x5446: 'dāi',  # 呆
    0x5447: 'qǐ',  # 呇
    0x5448: 'chéng',  # 呈
    0x5449: 'wú',  # 呉
    0x544A: 'gào',  # 告
    0x544B: 'fū',  # 呋
    0x544C: 'jiào',  # 呌
    0x544D: 'hōng',  # 呍
    0x544E: 'chǐ',  # 呎
    0x544F: 'shēng',  # 呏
    0x5450: 'nà,nè',  # 呐
    0x5451: 'tūn,tiān',  # 呑
    0x5452: 'fǔ,ḿ',  # 呒
    0x5453: 'yì',  # 呓
    0x5454: 'dāi',  # 呔
    0x5455: 'ǒu,ōu,òu',  # 呕
    0x5456: 'lì',  # 呖
    0x5457: 'bei,bài',  # 呗
    0x5458: 'yuán,yún,yùn',  # 员
    0x5459: 'wāi,hé,wǒ,wā,guǎ,guō',  # 呙
    0x545A: 'huá,qì',  # 呚
    0x545B: 'qiāng,qiàng',  # 呛
    0x545C: 'wū',  # 呜
    0x545D: 'è',  # 呝
    0x545E: 'shī',  # 呞
    0x545F: 'juǎn',  # 呟
    0x5460: 'pěn',  # 呠
    0x5461: 'wěn,mǐn',  # 呡
    0x5462: 'ní,ne',  # 呢
    0x5463: 'ḿ,m̀,móu',  # 呣
    0x5464: 'líng',  # 呤
    0x5465: 'rán',  # 呥
    0x5466: 'yōu',  # 呦
    0x5467: 'dǐ',  # 呧
    0x5468: 'zhōu',  # 周
    0x5469: 'shì',  # 呩
    0x546A: 'zhòu',  # 呪
    0x546B: 'tiè,chè',  # 呫
    0x546C: 'xì',  # 呬
    0x546D: 'yì',  # 呭
    0x546E: 'qì,zhī',  # 呮
    0x546F: 'píng',  # 呯
    0x5470: 'zǐ,cī',  # 呰
    0x5471: 'guā,gū,guǎ',  # 呱
    0x5472: 'zī,cī',  # 呲
    0x5473: 'wèi',  # 味
    0x5474: 'xǔ,hǒu,gòu',  # 呴
    0x5475: 'hē,a,kē',  # 呵
    0x5476: 'náo',  # 呶
    0x5477: 'xiā',  # 呷
    0x5478: 'pēi',  # 呸
    0x5479: 'yì',  # 呹
    0x547A: 'xiāo,háo',  # 呺
    0x547B: 'shēn',  # 呻
    0x547C: 'hū',  # 呼
    0x547D: 'mìng',  # 命
    0x547E: 'dá,dàn',  # 呾
    0x547F: 'qū',  # 呿
    0x5480: 'jǔ,zuǐ',  # 咀
    0x5481: 'xián,gān',  # 咁
    0x5482: 'zā',  # 咂
    0x5483: 'tuō',  # 咃
    0x5484: 'duō',  # 咄
    0x5485: 'pǒu',  # 咅
    0x5486: 'páo',  # 咆
    0x5487: 'bì',  # 咇
    0x5488: 'fú',  # 咈
    0x5489: 'yǎng',  # 咉
    0x548A: 'hé,hè',  # 咊
    0x548B: 'zǎ,zé,zhā',  # 咋
    0x548C: 'hé,hè,huó,huò,hú',  # 和
    0x548D: 'hāi',  # 咍
    0x548E: 'jiù',  # 咎
    0x548F: 'yǒng',  # 咏
    0x5490: 'fù',  # 咐
    0x5491: 'dā',  # 咑
    0x5492: 'zhòu',  # 咒
    0x5493: 'wǎ',  # 咓
    0x5494: 'kǎ',  # 咔
    0x5495: 'gū',  # 咕
    0x5496: 'kā,gā',  # 咖
    0x5497: 'zuo',  # 咗
    0x5498: 'bù',  # 咘
    0x5499: 'lóng',  # 咙
    0x549A: 'dōng',  # 咚
    0x549B: 'níng',  # 咛
    0x549C: 'tuō',  # 咜
    0x549D: 'sī',  # 咝
    0x549E: 'xiàn,xián',  # 咞
    0x549F: 'huò',  # 咟
    0x54A0: 'qì',  # 咠
    0x54A1: 'èr',  # 咡
    0x54A2: 'è',  # 咢
    0x54A3: 'guāng',  # 咣
    0x54A4: 'zhà',  # 咤
    0x54A5: 'dié,xī',  # 咥
    0x54A6: 'yí',  # 咦
    0x54A7: 'liě,liē,lié,lie',  # 咧
    0x54A8: 'zī',  # 咨
    0x54A9: 'miē',  # 咩
    0x54AA: 'mī',  # 咪
    0x54AB: 'zhǐ',  # 咫
    0x54AC: 'yǎo',  # 咬
    0x54AD: 'jī,xī,qià',  # 咭
    0x54AE: 'zhòu',  # 咮
    0x54AF: 'kǎ,luò,lo,gē',  # 咯
    0x54B0: 'shù,xún',  # 咰
    0x54B1: 'zán,zá,zǎ',  # 咱
    0x54B2: 'xiào',  # 咲
    0x54B3: 'ké,hāi',  # 咳
    0x54B4: 'huī',  # 咴
    0x54B5: 'kuā',  # 咵
    0x54B6: 'huài,shì',  # 咶
    0x54B7: 'táo',  # 咷
    0x54B8: 'xián',  # 咸
    0x54B9: 'è,àn',  # 咹
    0x54BA: 'xuǎn,xuān',  # 咺
    0x54BB: 'xiū',  # 咻
    0x54BC: 'wāi,hé,wǒ,wā,guǎ,guō',  # 咼
    0x54BD: 'yān,yàn,yè',  # 咽
    0x54BE: 'lǎo',  # 咾
    0x54BF: 'yī',  # 咿
    0x54C0: 'āi',  # 哀
    0x54C1: 'pǐn',  # 品
    0x54C2: 'shěn',  # 哂
    0x54C3: 'tóng',  # 哃
    0x54C4: 'hōng,hǒng,hòng',  # 哄
    0x54C5: 'xiōng',  # 哅
    0x54C6: 'duō',  # 哆
    0x54C7: 'wā,wa',  # 哇
    0x54C8: 'hā,hǎ,hà',  # 哈
    0x54C9: 'zāi',  # 哉
    0x54CA: 'yòu',  # 哊
    0x54CB: 'diè,dì',  # 哋
    0x54CC: 'pài',  # 哌
    0x54CD: 'xiǎng',  # 响
    0x54CE: 'āi',  # 哎
    0x54CF: 'gén,hěn',  # 哏
    0x54D0: 'kuāng',  # 哐
    0x54D1: 'yǎ,yā',  # 哑
    0x54D2: 'dā',  # 哒
    0x54D3: 'xiāo',  # 哓
    0x54D4: 'bì',  # 哔
    0x54D5: 'yuě,huì',  # 哕
    0x54D6: 'nián',  # 哖
    0x54D7: 'huá,huā',  # 哗
    0x54D8: 'xíng',  # 哘
    0x54D9: 'kuài',  # 哙
    0x54DA: 'duǒ',  # 哚
    0x54DB: 'ppun',  # 哛
    0x54DC: 'jì,jiē,zhāi',  # 哜
    0x54DD: 'nóng',  # 哝
    0x54DE: 'mōu',  # 哞
    0x54DF: 'yō,yo',  # 哟
    0x54E0: 'hào',  # 哠
    0x54E1: 'yuán,yún,yùn',  # 員
    0x54E2: 'lòng',  # 哢
    0x54E3: 'pǒu',  # 哣
    0x54E4: 'máng',  # 哤
    0x54E5: 'gē',  # 哥
    0x54E6: 'ó,ò,é',  # 哦
    0x54E7: 'chī',  # 哧
    0x54E8: 'shào',  # 哨
    0x54E9: 'li,lǐ,lī',  # 哩
    0x54EA: 'nǎ,něi,na,né',  # 哪
    0x54EB: 'zú',  # 哫
    0x54EC: 'hè',  # 哬
    0x54ED: 'kū',  # 哭
    0x54EE: 'xiào',  # 哮
    0x54EF: 'xiàn',  # 哯
    0x54F0: 'láo',  # 哰
    0x54F1: 'pò,bā,bō',  # 哱
    0x54F2: 'zhé',  # 哲
    0x54F3: 'zhā',  # 哳
    0x54F4: 'liàng,láng',  # 哴
    0x54F5: 'bā',  # 哵
    0x54F6: 'miē',  # 哶
    0x54F7: 'liè,lǜ',  # 哷
    0x54F8: 'suī',  # 哸
    0x54F9: 'fú',  # 哹
    0x54FA: 'bǔ',  # 哺
    0x54FB: 'hān',  # 哻
    0x54FC: 'hēng,hng',  # 哼
    0x54FD: 'gěng',  # 哽
    0x54FE: 'chuò,yuè',  # 哾
    0x54FF: 'gě,jiā',  # 哿
    0x5500: 'yòu',  # 唀
    0x5501: 'yàn',  # 唁
    0x5502: 'gū',  # 唂
    0x5503: 'gū',  # 唃
    0x5504: 'bei,bài',  # 唄
    0x5505: 'hán,hàn',  # 唅
    0x5506: 'suō',  # 唆
    0x5507: 'chún',  # 唇
    0x5508: 'yì',  # 唈
    0x5509: 'āi,ài',  # 唉
    0x550A: 'jiá,qiǎn',  # 唊
    0x550B: 'tǔ,tù',  # 唋
    0x550C: 'dàn,xián,yán',  # 唌
    0x550D: 'wǎn',  # 唍
    0x550E: 'lì',  # 唎
    0x550F: 'xī',  # 唏
    0x5510: 'táng',  # 唐
    0x5511: 'zuò',  # 唑
    0x5512: 'qiú',  # 唒
    0x5513: 'chē',  # 唓
    0x5514: 'wù,wú,ńg,ń',  # 唔
    0x5515: 'zào',  # 唕
    0x5516: 'yǎ',  # 唖
    0x5517: 'dōu',  # 唗
    0x5518: 'qǐ',  # 唘
    0x5519: 'dí',  # 唙
    0x551A: 'qìn',  # 唚
    0x551B: 'mài',  # 唛
    0x551C: 'mas',  # 唜
    0x551D: 'gòng,hǒng,gǒng',  # 唝
    0x551E: 'dóu',  # 唞
    0x551F: 'keos',  # 唟
    0x5520: 'lào,láo',  # 唠
    0x5521: 'liǎng',  # 唡
    0x5522: 'suǒ',  # 唢
    0x5523: 'zào',  # 唣
    0x5524: 'huàn',  # 唤
    0x5525: 'léng',  # 唥
    0x5526: 'shā',  # 唦
    0x5527: 'jī',  # 唧
    0x5528: 'zǔ',  # 唨
    0x5529: 'wō,wěi',  # 唩
    0x552A: 'fěng',  # 唪
    0x552B: 'jìn,yín',  # 唫
    0x552C: 'hǔ,xià',  # 唬
    0x552D: 'qì',  # 唭
    0x552E: 'shòu',  # 售
    0x552F: 'wéi',  # 唯
    0x5530: 'shuā',  # 唰
    0x5531: 'chàng',  # 唱
    0x5532: 'ér,wā',  # 唲
    0x5533: 'lì',  # 唳
    0x5534: 'qiàng',  # 唴
    0x5535: 'ǎn',  # 唵
    0x5536: 'jiè,zé,jí',  # 唶
    0x5537: 'yō',  # 唷
    0x5538: 'niàn',  # 唸
    0x5539: 'yū',  # 唹
    0x553A: 'tiǎn',  # 唺
    0x553B: 'lài',  # 唻
    0x553C: 'shà',  # 唼
    0x553D: 'xī',  # 唽
    0x553E: 'tuò',  # 唾
    0x553F: 'hū',  # 唿
    0x5540: 'ái',  # 啀
    0x5541: 'zhōu,zhāo,tiào',  # 啁
    0x5542: 'gòu',  # 啂
    0x5543: 'kěn',  # 啃
    0x5544: 'zhuó',  # 啄
    0x5545: 'zhuó,zhào',  # 啅
    0x5546: 'shāng',  # 商
    0x5547: 'dí',  # 啇
    0x5548: 'hèng',  # 啈
    0x5549: 'lán,lín',  # 啉
    0x554A: 'ā,á,ǎ,à,a',  # 啊
    0x554B: 'cǎi',  # 啋
    0x554C: 'qiāng',  # 啌
    0x554D: 'zhūn,tūn,xiāng,duǐ',  # 啍
    0x554E: 'wǔ',  # 啎
    0x554F: 'wèn',  # 問
    0x5550: 'cuì,qi',  # 啐
    0x5551: 'shà,jié,dié,tì',  # 啑
    0x5552: 'gǔ',  # 啒
    0x5553: 'qǐ',  # 啓
    0x5554: 'qǐ',  # 啔
    0x5555: 'táo',  # 啕
    0x5556: 'dàn',  # 啖
    0x5557: 'dàn',  # 啗
    0x5558: 'yuē,wā',  # 啘
    0x5559: 'zǐ,cǐ',  # 啙
    0x555A: 'bǐ,tú',  # 啚
    0x555B: 'cuì',  # 啛
    0x555C: 'chuò,chuài',  # 啜
    0x555D: 'hé',  # 啝
    0x555E: 'yǎ,yā',  # 啞
    0x555F: 'qǐ',  # 啟
    0x5560: 'zhé',  # 啠
    0x5561: 'fēi',  # 啡
    0x5562: 'liǎng',  # 啢
    0x5563: 'xián',  # 啣
    0x5564: 'pí',  # 啤
    0x5565: 'shá',  # 啥
    0x5566: 'lā,la',  # 啦
    0x5567: 'zé',  # 啧
    0x5568: 'qíng,yīng',  # 啨
    0x5569: 'guà',  # 啩
    0x556A: 'pā',  # 啪
    0x556B: 'zhě,shì',  # 啫
    0x556C: 'sè',  # 啬
    0x556D: 'zhuàn',  # 啭
    0x556E: 'niè',  # 啮
    0x556F: 'guō',  # 啯
    0x5570: 'luō,luó,luo',  # 啰
    0x5571: 'yán',  # 啱
    0x5572: 'dī',  # 啲
    0x5573: 'quán',  # 啳
    0x5574: 'tān,chǎn,tuō',  # 啴
    0x5575: 'bo',  # 啵
    0x5576: 'dìng',  # 啶
    0x5577: 'lāng',  # 啷
    0x5578: 'xiào',  # 啸
    0x5579: 'jú',  # 啹
    0x557A: 'táng',  # 啺
    0x557B: 'chì',  # 啻
    0x557C: 'tí',  # 啼
    0x557D: 'ān,án',  # 啽
    0x557E: 'jiū',  # 啾
    0x557F: 'dàn',  # 啿
    0x5580: 'kā',  # 喀
    0x5581: 'yóng',  # 喁
    0x5582: 'wèi',  # 喂
    0x5583: 'nán',  # 喃
    0x5584: 'shàn',  # 善
    0x5585: 'yù',  # 喅
    0x5586: 'zhé',  # 喆
    0x5587: 'lǎ',  # 喇
    0x5588: 'jiē',  # 喈
    0x5589: 'hóu',  # 喉
    0x558A: 'hǎn',  # 喊
    0x558B: 'dié,zhá',  # 喋
    0x558C: 'zhōu',  # 喌
    0x558D: 'chái',  # 喍
    0x558E: 'wāi',  # 喎
    0x558F: 'nuò,rě',  # 喏
    0x5590: 'huò,guó,xù',  # 喐
    0x5591: 'yīn',  # 喑
    0x5592: 'zán,zá,zǎ',  # 喒
    0x5593: 'yāo',  # 喓
    0x5594: 'ō,wō',  # 喔
    0x5595: 'miǎn',  # 喕
    0x5596: 'hú',  # 喖
    0x5597: 'yǔn',  # 喗
    0x5598: 'chuǎn',  # 喘
    0x5599: 'huì',  # 喙
    0x559A: 'huàn',  # 喚
    0x559B: 'huàn,yuán,xuǎn,hé',  # 喛
    0x559C: 'xǐ',  # 喜
    0x559D: 'hē,hè,yè',  # 喝
    0x559E: 'jī',  # 喞
    0x559F: 'kuì',  # 喟
    0x55A0: 'zhǒng,chuáng',  # 喠
    0x55A1: 'wéi,wèi',  # 喡
    0x55A2: 'shà',  # 喢
    0x55A3: 'xǔ',  # 喣
    0x55A4: 'huáng',  # 喤
    0x55A5: 'duó,zhà',  # 喥
    0x55A6: 'yán',  # 喦
    0x55A7: 'xuān',  # 喧
    0x55A8: 'liàng',  # 喨
    0x55A9: 'yù',  # 喩
    0x55AA: 'sāng,sàng',  # 喪
    0x55AB: 'chī',  # 喫
    0x55AC: 'qiáo,jiāo',  # 喬
    0x55AD: 'yàn',  # 喭
    0x55AE: 'dān,shàn,chán',  # 單
    0x55AF: 'pèn,bēn',  # 喯
    0x55B0: 'cān,sūn,qī',  # 喰
    0x55B1: 'lí',  # 喱
    0x55B2: 'yō,yo',  # 喲
    0x55B3: 'zhā,chā',  # 喳
    0x55B4: 'wēi',  # 喴
    0x55B5: 'miāo',  # 喵
    0x55B6: 'yíng',  # 営
    0x55B7: 'pēn,pèn',  # 喷
    0x55B8: 'phos',  # 喸
    0x55B9: 'kuí',  # 喹
    0x55BA: 'xí',  # 喺
    0x55BB: 'yù',  # 喻
    0x55BC: 'jiē',  # 喼
    0x55BD: 'lóu,lou',  # 喽
    0x55BE: 'kù',  # 喾
    0x55BF: 'zào,qiāo',  # 喿
    0x55C0: 'hù',  # 嗀
    0x55C1: 'tí',  # 嗁
    0x55C2: 'yáo',  # 嗂
    0x55C3: 'hè,xiāo,xiào,hù',  # 嗃
    0x55C4: 'shà,á',  # 嗄
    0x55C5: 'xiù',  # 嗅
    0x55C6: 'qiāng,qiàng',  # 嗆
    0x55C7: 'sè',  # 嗇
    0x55C8: 'yōng',  # 嗈
    0x55C9: 'sù',  # 嗉
    0x55CA: 'gòng,hǒng,gǒng',  # 嗊
    0x55CB: 'xié',  # 嗋
    0x55CC: 'yì,ài',  # 嗌
    0x55CD: 'suō',  # 嗍
    0x55CE: 'má,mǎ,ma',  # 嗎
    0x55CF: 'chā',  # 嗏
    0x55D0: 'hài',  # 嗐
    0x55D1: 'kē,kè',  # 嗑
    0x55D2: 'tà,dā',  # 嗒
    0x55D3: 'sǎng',  # 嗓
    0x55D4: 'chēn',  # 嗔
    0x55D5: 'rù',  # 嗕
    0x55D6: 'sōu',  # 嗖
    0x55D7: 'wā,gǔ',  # 嗗
    0x55D8: 'jī',  # 嗘
    0x55D9: 'bēng,pǎng',  # 嗙
    0x55DA: 'wū',  # 嗚
    0x55DB: 'xián,qiàn,qiè',  # 嗛
    0x55DC: 'shì',  # 嗜
    0x55DD: 'gé',  # 嗝
    0x55DE: 'zī',  # 嗞
    0x55DF: 'jiē',  # 嗟
    0x55E0: 'lào',  # 嗠
    0x55E1: 'wēng',  # 嗡
    0x55E2: 'wà',  # 嗢
    0x55E3: 'sì',  # 嗣
    0x55E4: 'chī',  # 嗤
    0x55E5: 'háo',  # 嗥
    0x55E6: 'suō',  # 嗦
    0x55E7: 'jiālún',  # 嗧
    0x55E8: 'hāi,hēi',  # 嗨
    0x55E9: 'suǒ',  # 嗩
    0x55EA: 'qín',  # 嗪
    0x55EB: 'niè',  # 嗫
    0x55EC: 'hē',  # 嗬
    0x55ED: 'zi',  # 嗭
    0x55EE: 'sǎi',  # 嗮
    0x55EF: 'ǹg,ńg,ňg,ǹ,ń,ň',  # 嗯
    0x55F0: 'gě',  # 嗰
    0x55F1: 'ná',  # 嗱
    0x55F2: 'diǎ',  # 嗲
    0x55F3: 'ǎi,ài,āi',  # 嗳
    0x55F4: 'qiāng',  # 嗴
    0x55F5: 'tōng',  # 嗵
    0x55F6: 'bì',  # 嗶
    0x55F7: 'áo',  # 嗷
    0x55F8: 'áo',  # 嗸
    0x55F9: 'lián',  # 嗹
    0x55FA: 'zuī,suī',  # 嗺
    0x55FB: 'zhē,zhè,zhù,zhe',  # 嗻
    0x55FC: 'mò',  # 嗼
    0x55FD: 'sòu',  # 嗽
    0x55FE: 'sǒu',  # 嗾
    0x55FF: 'tǎn',  # 嗿
    0x5600: 'dí',  # 嘀
    0x5601: 'qī',  # 嘁
    0x5602: 'jiào',  # 嘂
    0x5603: 'chōng',  # 嘃
    0x5604: 'jiào,dǎo',  # 嘄
    0x5605: 'kǎi,gě',  # 嘅
    0x5606: 'tàn',  # 嘆
    0x5607: 'shān,càn',  # 嘇
    0x5608: 'cáo',  # 嘈
    0x5609: 'jiā',  # 嘉
    0x560A: 'ái',  # 嘊
    0x560B: 'xiào',  # 嘋
    0x560C: 'piāo',  # 嘌
    0x560D: 'lóu,lou',  # 嘍
    0x560E: 'gā,gá,gǎ',  # 嘎
    0x560F: 'gǔ',  # 嘏
    0x5610: 'xiāo,jiāo',  # 嘐
    0x5611: 'hū',  # 嘑
    0x5612: 'huì',  # 嘒
    0x5613: 'guō',  # 嘓
    0x5614: 'ǒu,ōu,òu',  # 嘔
    0x5615: 'xiān',  # 嘕
    0x5616: 'zé',  # 嘖
    0x5617: 'cháng',  # 嘗
    0x5618: 'xū,shī',  # 嘘
    0x5619: 'pó',  # 嘙
    0x561A: 'dē,dēi',  # 嘚
    0x561B: 'má,ma',  # 嘛
    0x561C: 'mà',  # 嘜
    0x561D: 'hú',  # 嘝
    0x561E: 'lei,lē',  # 嘞
    0x561F: 'dū',  # 嘟
    0x5620: 'gā,gá,gǎ',  # 嘠
    0x5621: 'tāng',  # 嘡
    0x5622: 'yě',  # 嘢
    0x5623: 'bēng',  # 嘣
    0x5624: 'yīng',  # 嘤
    0x5625: 'sāi',  # 嘥
    0x5626: 'jiào',  # 嘦
    0x5627: 'mì',  # 嘧
    0x5628: 'xiào',  # 嘨
    0x5629: 'huá,huā',  # 嘩
    0x562A: 'mǎi',  # 嘪
    0x562B: 'rán',  # 嘫
    0x562C: 'zuō',  # 嘬
    0x562D: 'pēng',  # 嘭
    0x562E: 'lào,láo',  # 嘮
    0x562F: 'xiào',  # 嘯
    0x5630: 'jī',  # 嘰
    0x5631: 'zhǔ',  # 嘱
    0x5632: 'cháo,zhāo',  # 嘲
    0x5633: 'kuì',  # 嘳
    0x5634: 'zuǐ',  # 嘴
    0x5635: 'xiāo',  # 嘵
    0x5636: 'sī',  # 嘶
    0x5637: 'háo',  # 嘷
    0x5638: 'fǔ,ḿ',  # 嘸
    0x5639: 'liáo',  # 嘹
    0x563A: 'qiáo,qiào',  # 嘺
    0x563B: 'xī',  # 嘻
    0x563C: 'chù,xù,shòu',  # 嘼
    0x563D: 'tān,chǎn',  # 嘽
    0x563E: 'dàn,tán',  # 嘾
    0x563F: 'hēi,mò',  # 嘿
    0x5640: 'xùn',  # 噀
    0x5641: 'ě',  # 噁
    0x5642: 'zūn',  # 噂
    0x5643: 'fān,bo',  # 噃
    0x5644: 'chī',  # 噄
    0x5645: 'huī',  # 噅
    0x5646: 'zǎn',  # 噆
    0x5647: 'chuáng',  # 噇
    0x5648: 'cù,zā,hé',  # 噈
    0x5649: 'dàn',  # 噉
    0x564A: 'jué',  # 噊
    0x564B: 'tūn,kuò',  # 噋
    0x564C: 'cēng',  # 噌
    0x564D: 'jiào',  # 噍
    0x564E: 'yē',  # 噎
    0x564F: 'xī',  # 噏
    0x5650: 'qì',  # 噐
    0x5651: 'háo',  # 噑
    0x5652: 'lián',  # 噒
    0x5653: 'xū,shī',  # 噓
    0x5654: 'dēng',  # 噔
    0x5655: 'huī',  # 噕
    0x5656: 'yín',  # 噖
    0x5657: 'pū',  # 噗
    0x5658: 'juē',  # 噘
    0x5659: 'qín',  # 噙
    0x565A: 'xún',  # 噚
    0x565B: 'niè',  # 噛
    0x565C: 'lū',  # 噜
    0x565D: 'sī',  # 噝
    0x565E: 'yǎn',  # 噞
    0x565F: 'yīng',  # 噟
    0x5660: 'dā',  # 噠
    0x5661: 'zhān',  # 噡
    0x5662: 'ō',  # 噢
    0x5663: 'zhòu,zhuó',  # 噣
    0x5664: 'jìn',  # 噤
    0x5665: 'nóng',  # 噥
    0x5666: 'yuě,huì',  # 噦
    0x5667: 'xiè',  # 噧
    0x5668: 'qì',  # 器
    0x5669: 'è',  # 噩
    0x566A: 'zào',  # 噪
    0x566B: 'yī',  # 噫
    0x566C: 'shì',  # 噬
    0x566D: 'jiào,qiào,chī',  # 噭
    0x566E: 'yuàn',  # 噮
    0x566F: 'ǎi,ài,āi',  # 噯
    0x5670: 'yōng,yǒng',  # 噰
    0x5671: 'jué,xué',  # 噱
    0x5672: 'kuài',  # 噲
    0x5673: 'yǔ',  # 噳
    0x5674: 'pēn,pèn',  # 噴
    0x5675: 'dào',  # 噵
    0x5676: 'gá',  # 噶
    0x5677: 'xīn,hěn,hèn',  # 噷
    0x5678: 'dūn',  # 噸
    0x5679: 'dāng',  # 噹
    0x567A: 'xīn',  # 噺
    0x567B: 'sāi',  # 噻
    0x567C: 'pī',  # 噼
    0x567D: 'pǐ',  # 噽
    0x567E: 'yīn',  # 噾
    0x567F: 'zuǐ',  # 噿
    0x5680: 'níng',  # 嚀
    0x5681: 'dí',  # 嚁
    0x5682: 'làn',  # 嚂
    0x5683: 'tà',  # 嚃
    0x5684: 'huò,ǒ',  # 嚄
    0x5685: 'rú',  # 嚅
    0x5686: 'hāo',  # 嚆
    0x5687: 'hè,xià',  # 嚇
    0x5688: 'yàn',  # 嚈
    0x5689: 'duō',  # 嚉
    0x568A: 'xiù,pì',  # 嚊
    0x568B: 'zhōu,chóu',  # 嚋
    0x568C: 'jì,jiē,zhāi',  # 嚌
    0x568D: 'jìn',  # 嚍
    0x568E: 'háo',  # 嚎
    0x568F: 'tì',  # 嚏
    0x5690: 'cháng',  # 嚐
    0x5691: 'xūn',  # 嚑
    0x5692: 'mē',  # 嚒
    0x5693: 'cā,chā',  # 嚓
    0x5694: 'tì',  # 嚔
    0x5695: 'lū',  # 嚕
    0x5696: 'huì',  # 嚖
    0x5697: 'bó,pào,bào',  # 嚗
    0x5698: 'yōu',  # 嚘
    0x5699: 'niè',  # 嚙
    0x569A: 'yín',  # 嚚
    0x569B: 'hù',  # 嚛
    0x569C: 'mèi,me,mò',  # 嚜
    0x569D: 'hōng',  # 嚝
    0x569E: 'zhé',  # 嚞
    0x569F: 'lí',  # 嚟
    0x56A0: 'liú',  # 嚠
    0x56A1: 'xié,hái',  # 嚡
    0x56A2: 'náng',  # 嚢
    0x56A3: 'xiāo',  # 嚣
    0x56A4: 'mō',  # 嚤
    0x56A5: 'yàn',  # 嚥
    0x56A6: 'lì',  # 嚦
    0x56A7: 'lú',  # 嚧
    0x56A8: 'lóng',  # 嚨
    0x56A9: 'pó',  # 嚩
    0x56AA: 'dàn',  # 嚪
    0x56AB: 'chèn',  # 嚫
    0x56AC: 'pín',  # 嚬
    0x56AD: 'pǐ',  # 嚭
    0x56AE: 'xiàng',  # 嚮
    0x56AF: 'huò',  # 嚯
    0x56B0: 'mè',  # 嚰
    0x56B1: 'xī',  # 嚱
    0x56B2: 'duǒ',  # 嚲
    0x56B3: 'kù',  # 嚳
    0x56B4: 'yán',  # 嚴
    0x56B5: 'chán',  # 嚵
    0x56B6: 'yīng',  # 嚶
    0x56B7: 'rǎng,rāng',  # 嚷
    0x56B8: 'diǎn,dím',  # 嚸
    0x56B9: 'lá',  # 嚹
    0x56BA: 'tà',  # 嚺
    0x56BB: 'xiāo',  # 嚻
    0x56BC: 'jiáo,jué,jiào',  # 嚼
    0x56BD: 'chuò',  # 嚽
    0x56BE: 'huàn,huān',  # 嚾
    0x56BF: 'huò',  # 嚿
    0x56C0: 'zhuàn',  # 囀
    0x56C1: 'niè',  # 囁
    0x56C2: 'xiāo',  # 囂
    0x56C3: 'zá,cà',  # 囃
    0x56C4: 'lí',  # 囄
    0x56C5: 'chǎn',  # 囅
    0x56C6: 'chài',  # 囆
    0x56C7: 'lì',  # 囇
    0x56C8: 'yì',  # 囈
    0x56C9: 'luō,luó,luo',  # 囉
    0x56CA: 'náng,nāng',  # 囊
    0x56CB: 'zá,zàn,cān',  # 囋
    0x56CC: 'sū',  # 囌
    0x56CD: 'xǐ',  # 囍
    0x56CE: 'zèng',  # 囎
    0x56CF: 'jiān',  # 囏
    0x56D0: 'yàn,zá,niè',  # 囐
    0x56D1: 'zhǔ',  # 囑
    0x56D2: 'lán',  # 囒
    0x56D3: 'niè',  # 囓
    0x56D4: 'nāng',  # 囔
    0x56D5: 'ramo',  # 囕
    0x56D6: 'luó,luō,luo',  # 囖
    0x56D7: 'wéi,guó',  # 囗
    0x56D8: 'huí',  # 囘
    0x56D9: 'yīn',  # 囙
    0x56DA: 'qiú',  # 囚
    0x56DB: 'sì',  # 四
    0x56DC: 'nín',  # 囜
    0x56DD: 'jiǎn,nān',  # 囝
    0x56DE: 'huí',  # 回
    0x56DF: 'xìn',  # 囟
    0x56E0: 'yīn',  # 因
    0x56E1: 'nān',  # 囡
    0x56E2: 'tuán',  # 团
    0x56E3: 'tuán',  # 団
    0x56E4: 'dùn,tún',  # 囤
    0x56E5: 'kàng',  # 囥
    0x56E6: 'yuān',  # 囦
    0x56E7: 'jiǒng',  # 囧
    0x56E8: 'piān',  # 囨
    0x56E9: 'yún',  # 囩
    0x56EA: 'cōng',  # 囪
    0x56EB: 'hú',  # 囫
    0x56EC: 'huí',  # 囬
    0x56ED: 'yuán',  # 园
    0x56EE: 'é',  # 囮
    0x56EF: 'guó',  # 囯
    0x56F0: 'kùn',  # 困
    0x56F1: 'cōng',  # 囱
    0x56F2: 'wéi,tōng',  # 囲
    0x56F3: 'tú',  # 図
    0x56F4: 'wéi',  # 围
    0x56F5: 'lún',  # 囵
    0x56F6: 'guó',  # 囶
    0x56F7: 'qūn',  # 囷
    0x56F8: 'rì',  # 囸
    0x56F9: 'líng',  # 囹
    0x56FA: 'gù',  # 固
    0x56FB: 'guó',  # 囻
    0x56FC: 'tāi',  # 囼
    0x56FD: 'guó',  # 国
    0x56FE: 'tú',  # 图
    0x56FF: 'yòu',  # 囿
    0x5700: 'guó',  # 圀
    0x5701: 'yín',  # 圁
    0x5702: 'hùn',  # 圂
    0x5703: 'pǔ',  # 圃
    0x5704: 'yǔ',  # 圄
    0x5705: 'hán',  # 圅
    0x5706: 'yuán',  # 圆
    0x5707: 'lún',  # 圇
    0x5708: 'quān,juàn,juān',  # 圈
    0x5709: 'yǔ',  # 圉
    0x570A: 'qīng',  # 圊
    0x570B: 'guó',  # 國
    0x570C: 'chuán,chuí',  # 圌
    0x570D: 'wéi',  # 圍
    0x570E: 'yuán',  # 圎
    0x570F: 'quān,juàn,juān',  # 圏
    0x5710: 'kū',  # 圐
    0x5711: 'pǔ',  # 圑
    0x5712: 'yuán',  # 園
    0x5713: 'yuán',  # 圓
    0x5714: 'yà',  # 圔
    0x5715: 'tuān',  # 圕
    0x5716: 'tú',  # 圖
    0x5717: 'tú',  # 圗
    0x5718: 'tuán',  # 團
    0x5719: 'lüè',  # 圙
    0x571A: 'huì',  # 圚
    0x571B: 'yì',  # 圛
    0x571C: 'huán,yuán',  # 圜
    0x571D: 'luán',  # 圝
    0x571E: 'luán',  # 圞
    0x571F: 'tǔ',  # 土
    0x5720: 'yà',  # 圠
    0x5721: 'tǔ',  # 圡
    0x5722: 'tǐng',  # 圢
    0x5723: 'shèng',  # 圣
    0x5724: 'pú',  # 圤
    0x5725: 'lù',  # 圥
    0x5726: 'kuài',  # 圦
    0x5727: 'yā',  # 圧
    0x5728: 'zài',  # 在
    0x5729: 'wéi,xū',  # 圩
    0x572A: 'gē',  # 圪
    0x572B: 'yù,zhūn',  # 圫
    0x572C: 'wū',  # 圬
    0x572D: 'guī',  # 圭
    0x572E: 'pǐ',  # 圮
    0x572F: 'yí',  # 圯
    0x5730: 'dì,de',  # 地
    0x5731: 'qiān,sú',  # 圱
    0x5732: 'qiān',  # 圲
    0x5733: 'zhèn',  # 圳
    0x5734: 'zhuó',  # 圴
    0x5735: 'dàng',  # 圵
    0x5736: 'qià',  # 圶
    0x5737: 'xià',  # 圷
    0x5738: 'shān',  # 圸
    0x5739: 'kuàng',  # 圹
    0x573A: 'cháng,chǎng',  # 场
    0x573B: 'qí,yín',  # 圻
    0x573C: 'niè',  # 圼
    0x573D: 'mò',  # 圽
    0x573E: 'jī',  # 圾
    0x573F: 'jiá',  # 圿
    0x5740: 'zhǐ',  # 址
    0x5741: 'zhǐ,zhì',  # 坁
    0x5742: 'bǎn',  # 坂
    0x5743: 'xūn',  # 坃
    0x5744: 'yì',  # 坄
    0x5745: 'qǐn',  # 坅
    0x5746: 'méi,fén',  # 坆
    0x5747: 'jūn',  # 均
    0x5748: 'rǒng,kēng',  # 坈
    0x5749: 'tún,dùn',  # 坉
    0x574A: 'fāng,fáng',  # 坊
    0x574B: 'bèn,fèn',  # 坋
    0x574C: 'bèn',  # 坌
    0x574D: 'tān',  # 坍
    0x574E: 'kǎn',  # 坎
    0x574F: 'huài',  # 坏
    0x5750: 'zuò',  # 坐
    0x5751: 'kēng',  # 坑
    0x5752: 'bì',  # 坒
    0x5753: 'jǐng',  # 坓
    0x5754: 'dì,làn',  # 坔
    0x5755: 'jīng',  # 坕
    0x5756: 'jì',  # 坖
    0x5757: 'kuài',  # 块
    0x5758: 'dǐ',  # 坘
    0x5759: 'jīng',  # 坙
    0x575A: 'jiān',  # 坚
    0x575B: 'tán',  # 坛
    0x575C: 'lì',  # 坜
    0x575D: 'bà',  # 坝
    0x575E: 'wù',  # 坞
    0x575F: 'fén',  # 坟
    0x5760: 'zhuì',  # 坠
    0x5761: 'pō',  # 坡
    0x5762: 'pǎn,bàn',  # 坢
    0x5763: 'táng',  # 坣
    0x5764: 'kūn',  # 坤
    0x5765: 'qū',  # 坥
    0x5766: 'tǎn',  # 坦
    0x5767: 'zhǐ',  # 坧
    0x5768: 'tuó',  # 坨
    0x5769: 'gān',  # 坩
    0x576A: 'píng',  # 坪
    0x576B: 'diàn',  # 坫
    0x576C: 'guà',  # 坬
    0x576D: 'ní',  # 坭
    0x576E: 'tái',  # 坮
    0x576F: 'pī',  # 坯
    0x5770: 'jiōng',  # 坰
    0x5771: 'yǎng',  # 坱
    0x5772: 'fó',  # 坲
    0x5773: 'ào',  # 坳
    0x5774: 'lù',  # 坴
    0x5775: 'qiū',  # 坵
    0x5776: 'mù,mǔ',  # 坶
    0x5777: 'kē,kě',  # 坷
    0x5778: 'gòu',  # 坸
    0x5779: 'xuè',  # 坹
    0x577A: 'fá',  # 坺
    0x577B: 'dǐ,chí',  # 坻
    0x577C: 'chè',  # 坼
    0x577D: 'líng',  # 坽
    0x577E: 'zhù',  # 坾
    0x577F: 'fù',  # 坿
    0x5780: 'hū',  # 垀
    0x5781: 'zhì',  # 垁
    0x5782: 'chuí',  # 垂
    0x5783: 'lā',  # 垃
    0x5784: 'lǒng',  # 垄
    0x5785: 'lǒng',  # 垅
    0x5786: 'lú',  # 垆
    0x5787: 'ào',  # 垇
    0x5788: 'dài',  # 垈
    0x5789: 'páo',  # 垉
    0x578A: 'mín',  # 垊
    0x578B: 'xíng',  # 型
    0x578C: 'dòng,tóng',  # 垌
    0x578D: 'jì',  # 垍
    0x578E: 'hè',  # 垎
    0x578F: 'lǜ',  # 垏
    0x5790: 'cí',  # 垐
    0x5791: 'chǐ',  # 垑
    0x5792: 'lěi',  # 垒
    0x5793: 'gāi',  # 垓
    0x5794: 'yīn',  # 垔
    0x5795: 'hòu',  # 垕
    0x5796: 'duī',  # 垖
    0x5797: 'zhào',  # 垗
    0x5798: 'fú',  # 垘
    0x5799: 'guāng',  # 垙
    0x579A: 'yáo',  # 垚
    0x579B: 'duǒ,duò',  # 垛
    0x579C: 'duǒ,duò',  # 垜
    0x579D: 'guǐ',  # 垝
    0x579E: 'chá',  # 垞
    0x579F: 'yáng',  # 垟
    0x57A0: 'yín',  # 垠
    0x57A1: 'fá',  # 垡
    0x57A2: 'gòu',  # 垢
    0x57A3: 'yuán',  # 垣
    0x57A4: 'dié',  # 垤
    0x57A5: 'xié',  # 垥
    0x57A6: 'kěn',  # 垦
    0x57A7: 'shǎng',  # 垧
    0x57A8: 'shǒu',  # 垨
    0x57A9: 'è',  # 垩
    0x57AA: 'bìng',  # 垪
    0x57AB: 'diàn',  # 垫
    0x57AC: 'hóng',  # 垬
    0x57AD: 'yā',  # 垭
    0x57AE: 'kuǎ',  # 垮
    0x57AF: 'dá',  # 垯
    0x57B0: 'kǎ',  # 垰
    0x57B1: 'dàng',  # 垱
    0x57B2: 'kǎi',  # 垲
    0x57B3: 'háng',  # 垳
    0x57B4: 'nǎo',  # 垴
    0x57B5: 'ǎn',  # 垵
    0x57B6: 'xīng',  # 垶
    0x57B7: 'xiàn',  # 垷
    0x57B8: 'yuàn,huán',  # 垸
    0x57B9: 'bāng',  # 垹
    0x57BA: 'póu,fú',  # 垺
    0x57BB: 'bà',  # 垻
    0x57BC: 'yì',  # 垼
    0x57BD: 'yìn',  # 垽
    0x57BE: 'hàn',  # 垾
    0x57BF: 'xù',  # 垿
    0x57C0: 'chuí',  # 埀
    0x57C1: 'cén',  # 埁
    0x57C2: 'gěng',  # 埂
    0x57C3: 'āi',  # 埃
    0x57C4: 'běng,fēng',  # 埄
    0x57C5: 'dì,fáng',  # 埅
    0x57C6: 'què,jué',  # 埆
    0x57C7: 'yǒng',  # 埇
    0x57C8: 'jùn',  # 埈
    0x57C9: 'xiá,jiā',  # 埉
    0x57CA: 'dì',  # 埊
    0x57CB: 'mái,mán',  # 埋
    0x57CC: 'làng',  # 埌
    0x57CD: 'juǎn',  # 埍
    0x57CE: 'chéng',  # 城
    0x57CF: 'yán,shān',  # 埏
    0x57D0: 'qín,jīn',  # 埐
    0x57D1: 'zhé',  # 埑
    0x57D2: 'liè',  # 埒
    0x57D3: 'liè',  # 埓
    0x57D4: 'pǔ,bù',  # 埔
    0x57D5: 'chéng',  # 埕
    0x57D6: 'huā',  # 埖
    0x57D7: 'bù',  # 埗
    0x57D8: 'shí',  # 埘
    0x57D9: 'xūn',  # 埙
    0x57DA: 'guō',  # 埚
    0x57DB: 'jiōng',  # 埛
    0x57DC: 'yě',  # 埜
    0x57DD: 'niàn',  # 埝
    0x57DE: 'dī',  # 埞
    0x57DF: 'yù',  # 域
    0x57E0: 'bù',  # 埠
    0x57E1: 'yà',  # 埡
    0x57E2: 'quán',  # 埢
    0x57E3: 'suì,sù',  # 埣
    0x57E4: 'pí,pì',  # 埤
    0x57E5: 'qīng,zhēng',  # 埥
    0x57E6: 'wǎn,wān',  # 埦
    0x57E7: 'jù',  # 埧
    0x57E8: 'lǔn',  # 埨
    0x57E9: 'zhēng,chéng',  # 埩
    0x57EA: 'kōng',  # 埪
    0x57EB: 'chǒng,shǎng',  # 埫
    0x57EC: 'dōng',  # 埬
    0x57ED: 'dài',  # 埭
    0x57EE: 'tán,tàn',  # 埮
    0x57EF: 'ǎn',  # 埯
    0x57F0: 'cǎi,cài',  # 埰
    0x57F1: 'chù,tòu',  # 埱
    0x57F2: 'běng',  # 埲
    0x57F3: 'xiàn,kǎn',  # 埳
    0x57F4: 'zhí',  # 埴
    0x57F5: 'duǒ',  # 埵
    0x57F6: 'yì,shì',  # 埶
    0x57F7: 'zhí',  # 執
    0x57F8: 'yì',  # 埸
    0x57F9: 'péi',  # 培
    0x57FA: 'jī',  # 基
    0x57FB: 'zhǔn',  # 埻
    0x57FC: 'qí',  # 埼
    0x57FD: 'sào,sǎo',  # 埽
    0x57FE: 'jù',  # 埾
    0x57FF: 'ní',  # 埿
    0x5800: 'kū',  # 堀
    0x5801: 'kè',  # 堁
    0x5802: 'táng',  # 堂
    0x5803: 'kūn',  # 堃
    0x5804: 'nì',  # 堄
    0x5805: 'jiān',  # 堅
    0x5806: 'duī',  # 堆
    0x5807: 'jīn',  # 堇
    0x5808: 'gāng',  # 堈
    0x5809: 'yù',  # 堉
    0x580A: 'è',  # 堊
    0x580B: 'péng,bèng',  # 堋
    0x580C: 'gù',  # 堌
    0x580D: 'tù',  # 堍
    0x580E: 'lèng',  # 堎
    0x580F: 'fāng',  # 堏
    0x5810: 'yá',  # 堐
    0x5811: 'qiàn',  # 堑
    0x5812: 'kūn',  # 堒
    0x5813: 'àn',  # 堓
    0x5814: 'shēn',  # 堔
    0x5815: 'duò,huī',  # 堕
    0x5816: 'nǎo',  # 堖
    0x5817: 'tū',  # 堗
    0x5818: 'chéng',  # 堘
    0x5819: 'yīn',  # 堙
    0x581A: 'huán',  # 堚
    0x581B: 'bì',  # 堛
    0x581C: 'liàn',  # 堜
    0x581D: 'guō',  # 堝
    0x581E: 'dié',  # 堞
    0x581F: 'zhuàn',  # 堟
    0x5820: 'hòu',  # 堠
    0x5821: 'bǎo,bǔ,pù',  # 堡
    0x5822: 'bǎo',  # 堢
    0x5823: 'yú',  # 堣
    0x5824: 'dī',  # 堤
    0x5825: 'máo,móu,wǔ',  # 堥
    0x5826: 'jiē',  # 堦
    0x5827: 'ruán',  # 堧
    0x5828: 'è,ài,yè',  # 堨
    0x5829: 'gèng',  # 堩
    0x582A: 'kān',  # 堪
    0x582B: 'zōng',  # 堫
    0x582C: 'yú',  # 堬
    0x582D: 'huáng',  # 堭
    0x582E: 'è',  # 堮
    0x582F: 'yáo',  # 堯
    0x5830: 'yàn',  # 堰
    0x5831: 'bào',  # 報
    0x5832: 'jí',  # 堲
    0x5833: 'méi',  # 堳
    0x5834: 'cháng,chǎng',  # 場
    0x5835: 'dǔ',  # 堵
    0x5836: 'tuó',  # 堶
    0x5837: 'yìn',  # 堷
    0x5838: 'féng',  # 堸
    0x5839: 'zhòng',  # 堹
    0x583A: 'jiè',  # 堺
    0x583B: 'jīn',  # 堻
    0x583C: 'fēng',  # 堼
    0x583D: 'gāng',  # 堽
    0x583E: 'chuǎn',  # 堾
    0x583F: 'jiǎn',  # 堿
    0x5840: 'píng',  # 塀
    0x5841: 'lěi',  # 塁
    0x5842: 'jiǎng',  # 塂
    0x5843: 'huāng',  # 塃
    0x5844: 'léng',  # 塄
    0x5845: 'duàn',  # 塅
    0x5846: 'wān',  # 塆
    0x5847: 'xuān',  # 塇
    0x5848: 'jì',  # 塈
    0x5849: 'jí',  # 塉
    0x584A: 'kuài',  # 塊
    0x584B: 'yíng',  # 塋
    0x584C: 'tā',  # 塌
    0x584D: 'chéng',  # 塍
    0x584E: 'yǒng',  # 塎
    0x584F: 'kǎi',  # 塏
    0x5850: 'sù',  # 塐
    0x5851: 'sù',  # 塑
    0x5852: 'shí',  # 塒
    0x5853: 'mì',  # 塓
    0x5854: 'tǎ',  # 塔
    0x5855: 'wěng',  # 塕
    0x5856: 'chéng',  # 塖
    0x5857: 'tú',  # 塗
    0x5858: 'táng',  # 塘
    0x5859: 'què',  # 塙
    0x585A: 'zhǒng',  # 塚
    0x585B: 'lì',  # 塛
    0x585C: 'péng',  # 塜
    0x585D: 'bàng',  # 塝
    0x585E: 'sāi,sài,sè',  # 塞
    0x585F: 'zàng',  # 塟
    0x5860: 'duī',  # 塠
    0x5861: 'tián',  # 塡
    0x5862: 'wù',  # 塢
    0x5863: 'zhèng',  # 塣
    0x5864: 'xūn',  # 塤
    0x5865: 'gé',  # 塥
    0x5866: 'zhèn',  # 塦
    0x5867: 'ài',  # 塧
    0x5868: 'gōng',  # 塨
    0x5869: 'yán',  # 塩
    0x586A: 'xiàn',  # 塪
    0x586B: 'tián,zhèn',  # 填
    0x586C: 'yuán',  # 塬
    0x586D: 'wēn',  # 塭
    0x586E: 'xiè',  # 塮
    0x586F: 'liù',  # 塯
    0x5870: 'hǎi',  # 塰
    0x5871: 'lǎng',  # 塱
    0x5872: 'cháng,chǎng',  # 塲
    0x5873: 'péng',  # 塳
    0x5874: 'bèng',  # 塴
    0x5875: 'chén',  # 塵
    0x5876: 'lù',  # 塶
    0x5877: 'lǔ',  # 塷
    0x5878: 'ōu,qiū',  # 塸
    0x5879: 'qiàn',  # 塹
    0x587A: 'méi',  # 塺
    0x587B: 'mò',  # 塻
    0x587C: 'zhuān,tuán',  # 塼
    0x587D: 'shuǎng',  # 塽
    0x587E: 'shú',  # 塾
    0x587F: 'lǒu',  # 塿
    0x5880: 'chí',  # 墀
    0x5881: 'màn',  # 墁
    0x5882: 'biāo',  # 墂
    0x5883: 'jìng',  # 境
    0x5884: 'qī',  # 墄
    0x5885: 'shù',  # 墅
    0x5886: 'zhì,dì',  # 墆
    0x5887: 'zhàng',  # 墇
    0x5888: 'kàn',  # 墈
    0x5889: 'yōng',  # 墉
    0x588A: 'diàn',  # 墊
    0x588B: 'chěn',  # 墋
    0x588C: 'zhǐ,zhuó',  # 墌
    0x588D: 'xì',  # 墍
    0x588E: 'guō',  # 墎
    0x588F: 'qiǎng',  # 墏
    0x5890: 'jìn',  # 墐
    0x5891: 'dì',  # 墑
    0x5892: 'shāng',  # 墒
    0x5893: 'mù',  # 墓
    0x5894: 'cuī',  # 墔
    0x5895: 'yàn',  # 墕
    0x5896: 'tǎ',  # 墖
    0x5897: 'zēng',  # 増
    0x5898: 'qián',  # 墘
    0x5899: 'qiáng',  # 墙
    0x589A: 'liáng',  # 墚
    0x589B: 'wèi',  # 墛
    0x589C: 'zhuì',  # 墜
    0x589D: 'qiāo',  # 墝
    0x589E: 'zēng',  # 增
    0x589F: 'xū',  # 墟
    0x58A0: 'shàn',  # 墠
    0x58A1: 'shàn',  # 墡
    0x58A2: 'fá',  # 墢
    0x58A3: 'pú',  # 墣
    0x58A4: 'kuài,tuí',  # 墤
    0x58A5: 'tuǎn,dǒng',  # 墥
    0x58A6: 'fán',  # 墦
    0x58A7: 'qiáo,què',  # 墧
    0x58A8: 'mò',  # 墨
    0x58A9: 'dūn',  # 墩
    0x58AA: 'dūn',  # 墪
    0x58AB: 'zūn,dūn',  # 墫
    0x58AC: 'dì',  # 墬
    0x58AD: 'shèng',  # 墭
    0x58AE: 'duò,huī',  # 墮
    0x58AF: 'duò',  # 墯
    0x58B0: 'tán',  # 墰
    0x58B1: 'dèng',  # 墱
    0x58B2: 'wú',  # 墲
    0x58B3: 'fén',  # 墳
    0x58B4: 'huáng',  # 墴
    0x58B5: 'tán',  # 墵
    0x58B6: 'dā',  # 墶
    0x58B7: 'yè',  # 墷
    0x58B8: 'zhù',  # 墸
    0x58B9: 'jiàn',  # 墹
    0x58BA: 'ào',  # 墺
    0x58BB: 'qiáng',  # 墻
    0x58BC: 'jī',  # 墼
    0x58BD: 'qiāo,áo',  # 墽
    0x58BE: 'kěn',  # 墾
    0x58BF: 'yì,tú',  # 墿
    0x58C0: 'pí',  # 壀
    0x58C1: 'bì',  # 壁
    0x58C2: 'diàn',  # 壂
    0x58C3: 'jiāng',  # 壃
    0x58C4: 'yě',  # 壄
    0x58C5: 'yōng',  # 壅
    0x58C6: 'xué,bó,jué',  # 壆
    0x58C7: 'tán',  # 壇
    0x58C8: 'lǎn',  # 壈
    0x58C9: 'jù',  # 壉
    0x58CA: 'huài',  # 壊
    0x58CB: 'dàng',  # 壋
    0x58CC: 'rǎng',  # 壌
    0x58CD: 'qiàn',  # 壍
    0x58CE: 'xūn',  # 壎
    0x58CF: 'xiàn,làn',  # 壏
    0x58D0: 'xǐ',  # 壐
    0x58D1: 'hè',  # 壑
    0x58D2: 'ài',  # 壒
    0x58D3: 'yā,yà',  # 壓
    0x58D4: 'dǎo',  # 壔
    0x58D5: 'háo',  # 壕
    0x58D6: 'ruán',  # 壖
    0x58D7: 'jìn',  # 壗
    0x58D8: 'lěi',  # 壘
    0x58D9: 'kuàng',  # 壙
    0x58DA: 'lú',  # 壚
    0x58DB: 'yán',  # 壛
    0x58DC: 'tán',  # 壜
    0x58DD: 'wéi',  # 壝
    0x58DE: 'huài',  # 壞
    0x58DF: 'lǒng',  # 壟
    0x58E0: 'lǒng',  # 壠
    0x58E1: 'ruǐ',  # 壡
    0x58E2: 'lì',  # 壢
    0x58E3: 'lín',  # 壣
    0x58E4: 'rǎng',  # 壤
    0x58E5: 'chán',  # 壥
    0x58E6: 'xūn',  # 壦
    0x58E7: 'yán',  # 壧
    0x58E8: 'lěi',  # 壨
    0x58E9: 'bà',  # 壩
    0x58EA: 'wān',  # 壪
    0x58EB: 'shì',  # 士
    0x58EC: 'rén',  # 壬
    0x58ED: 'san',  # 壭
    0x58EE: 'zhuàng',  # 壮
    0x58EF: 'zhuàng',  # 壯
    0x58F0: 'shēng',  # 声
    0x58F1: 'yī',  # 壱
    0x58F2: 'mài',  # 売
    0x58F3: 'ké,qiào',  # 壳
    0x58F4: 'zhù',  # 壴
    0x58F5: 'zhuàng',  # 壵
    0x58F6: 'hú',  # 壶
    0x58F7: 'hú',  # 壷
    0x58F8: 'kǔn',  # 壸
    0x58F9: 'yī',  # 壹
    0x58FA: 'hú',  # 壺
    0x58FB: 'xù',  # 壻
    0x58FC: 'kǔn',  # 壼
    0x58FD: 'shòu',  # 壽
    0x58FE: 'mǎng',  # 壾
    0x58FF: 'cún',  # 壿
    0x5900: 'shòu',  # 夀
    0x5901: 'yī',  # 夁
    0x5902: 'zhǐ,zhōng',  # 夂
    0x5903: 'gǔ,yíng',  # 夃
    0x5904: 'chǔ,chù',  # 处
    0x5905: 'jiàng,xiáng',  # 夅
    0x5906: 'féng,fēng,páng',  # 夆
    0x5907: 'bèi',  # 备
    0x5908: 'zhāi',  # 夈
    0x5909: 'biàn',  # 変
    0x590A: 'suī',  # 夊
    0x590B: 'qūn',  # 夋
    0x590C: 'líng',  # 夌
    0x590D: 'fù',  # 复
    0x590E: 'cuò',  # 夎
    0x590F: 'xià',  # 夏
    0x5910: 'xiòng,xuàn',  # 夐
    0x5911: 'xiè',  # 夑
    0x5912: 'náo',  # 夒
    0x5913: 'xià',  # 夓
    0x5914: 'kuí',  # 夔
    0x5915: 'xī',  # 夕
    0x5916: 'wài',  # 外
    0x5917: 'yuàn,wǎn,wān,yuān',  # 夗
    0x5918: 'mǎo,wǎn',  # 夘
    0x5919: 'sù',  # 夙
    0x591A: 'duō',  # 多
    0x591B: 'duō',  # 夛
    0x591C: 'yè',  # 夜
    0x591D: 'qíng',  # 夝
    0x591E: 'oes',  # 夞
    0x591F: 'gòu',  # 够
    0x5920: 'gòu',  # 夠
    0x5921: 'qì',  # 夡
    0x5922: 'mèng',  # 夢
    0x5923: 'mèng',  # 夣
    0x5924: 'yín',  # 夤
    0x5925: 'huǒ',  # 夥
    0x5926: 'chěn',  # 夦
    0x5927: 'dà,dài,tài',  # 大
    0x5928: 'cè',  # 夨
    0x5929: 'tiān',  # 天
    0x592A: 'tài',  # 太
    0x592B: 'fū,fú',  # 夫
    0x592C: 'guài',  # 夬
    0x592D: 'yāo',  # 夭
    0x592E: 'yāng',  # 央
    0x592F: 'hāng,bèn',  # 夯
    0x5930: 'gǎo',  # 夰
    0x5931: 'shī',  # 失
    0x5932: 'tāo,běn',  # 夲
    0x5933: 'tài',  # 夳
    0x5934: 'tóu,tou',  # 头
    0x5935: 'yǎn,tāo',  # 夵
    0x5936: 'bǐ',  # 夶
    0x5937: 'yí',  # 夷
    0x5938: 'kuā,kuà',  # 夸
    0x5939: 'jiā,jiá,gā',  # 夹
    0x593A: 'duó',  # 夺
    0x593B: 'huà',  # 夻
    0x593C: 'kuǎng',  # 夼
    0x593D: 'yǔn',  # 夽
    0x593E: 'jiā,jiá,gā',  # 夾
    0x593F: 'bā',  # 夿
    0x5940: 'ēn',  # 奀
    0x5941: 'lián',  # 奁
    0x5942: 'huàn',  # 奂
    0x5943: 'dī,tì',  # 奃
    0x5944: 'yǎn,yān',  # 奄
    0x5945: 'pào',  # 奅
    0x5946: 'juàn',  # 奆
    0x5947: 'qí,jī',  # 奇
    0x5948: 'nài',  # 奈
    0x5949: 'fèng',  # 奉
    0x594A: 'xié',  # 奊
    0x594B: 'fèn',  # 奋
    0x594C: 'diǎn',  # 奌
    0x594D: 'quān,juàn',  # 奍
    0x594E: 'kuí',  # 奎
    0x594F: 'zòu',  # 奏
    0x5950: 'huàn',  # 奐
    0x5951: 'qì,qiè,xiè',  # 契
    0x5952: 'kāi',  # 奒
    0x5953: 'shē,chǐ,zhà',  # 奓
    0x5954: 'bēn,bèn',  # 奔
    0x5955: 'yì',  # 奕
    0x5956: 'jiǎng',  # 奖
    0x5957: 'tào',  # 套
    0x5958: 'zàng,zhuǎng',  # 奘
    0x5959: 'běn',  # 奙
    0x595A: 'xī',  # 奚
    0x595B: 'huǎng',  # 奛
    0x595C: 'fěi',  # 奜
    0x595D: 'diāo',  # 奝
    0x595E: 'xùn,zhuì',  # 奞
    0x595F: 'bēng',  # 奟
    0x5960: 'diàn',  # 奠
    0x5961: 'ào',  # 奡
    0x5962: 'shē',  # 奢
    0x5963: 'wěng',  # 奣
    0x5964: 'pò,hǎ,tǎi',  # 奤
    0x5965: 'ào,yù',  # 奥
    0x5966: 'wù',  # 奦
    0x5967: 'ào,yù',  # 奧
    0x5968: 'jiǎng',  # 奨
    0x5969: 'lián',  # 奩
    0x596A: 'duó',  # 奪
    0x596B: 'yūn',  # 奫
    0x596C: 'jiǎng',  # 奬
    0x596D: 'shì',  # 奭
    0x596E: 'fèn',  # 奮
    0x596F: 'huò',  # 奯
    0x5970: 'bì',  # 奰
    0x5971: 'luán',  # 奱
    0x5972: 'duǒ,chě',  # 奲
    0x5973: 'nǚ,rǔ',  # 女
    0x5974: 'nú',  # 奴
    0x5975: 'dǐng,dīng,tiǎn',  # 奵
    0x5976: 'nǎi',  # 奶
    0x5977: 'qiān',  # 奷
    0x5978: 'jiān',  # 奸
    0x5979: 'tā,jiě',  # 她
    0x597A: 'jiǔ',  # 奺
    0x597B: 'nuán',  # 奻
    0x597C: 'chà',  # 奼
    0x597D: 'hǎo,hào',  # 好
    0x597E: 'xiān',  # 奾
    0x597F: 'fàn',  # 奿
    0x5980: 'jǐ',  # 妀
    0x5981: 'shuò',  # 妁
    0x5982: 'rú',  # 如
    0x5983: 'fēi,pèi',  # 妃
    0x5984: 'wàng',  # 妄
    0x5985: 'hóng',  # 妅
    0x5986: 'zhuāng',  # 妆
    0x5987: 'fù',  # 妇
    0x5988: 'mā',  # 妈
    0x5989: 'dān',  # 妉
    0x598A: 'rèn',  # 妊
    0x598B: 'fū,yōu',  # 妋
    0x598C: 'jìng',  # 妌
    0x598D: 'yán',  # 妍
    0x598E: 'hài,jiè',  # 妎
    0x598F: 'wèn',  # 妏
    0x5990: 'zhōng',  # 妐
    0x5991: 'pā',  # 妑
    0x5992: 'dù',  # 妒
    0x5993: 'jì',  # 妓
    0x5994: 'kēng,háng',  # 妔
    0x5995: 'zhòng',  # 妕
    0x5996: 'yāo',  # 妖
    0x5997: 'jìn',  # 妗
    0x5998: 'yún',  # 妘
    0x5999: 'miào',  # 妙
    0x599A: 'fǒu,pēi,pī',  # 妚
    0x599B: 'chī',  # 妛
    0x599C: 'yuè,jué',  # 妜
    0x599D: 'zhuāng',  # 妝
    0x599E: 'niū',  # 妞
    0x599F: 'yàn',  # 妟
    0x59A0: 'nà,nàn',  # 妠
    0x59A1: 'xīn',  # 妡
    0x59A2: 'fén',  # 妢
    0x59A3: 'bǐ',  # 妣
    0x59A4: 'yú',  # 妤
    0x59A5: 'tuǒ',  # 妥
    0x59A6: 'fēng',  # 妦
    0x59A7: 'wàn,yuán',  # 妧
    0x59A8: 'fáng',  # 妨
    0x59A9: 'wǔ',  # 妩
    0x59AA: 'yù',  # 妪
    0x59AB: 'guī',  # 妫
    0x59AC: 'dù',  # 妬
    0x59AD: 'bá',  # 妭
    0x59AE: 'nī',  # 妮
    0x59AF: 'zhóu',  # 妯
    0x59B0: 'zhuó',  # 妰
    0x59B1: 'zhāo',  # 妱
    0x59B2: 'dá',  # 妲
    0x59B3: 'nǐ,nǎi',  # 妳
    0x59B4: 'yuàn',  # 妴
    0x59B5: 'tǒu',  # 妵
    0x59B6: 'xián,xuán,xù',  # 妶
    0x59B7: 'zhí,yì',  # 妷
    0x59B8: 'ē',  # 妸
    0x59B9: 'mèi',  # 妹
    0x59BA: 'mò',  # 妺
    0x59BB: 'qī,qì',  # 妻
    0x59BC: 'bì',  # 妼
    0x59BD: 'shēn',  # 妽
    0x59BE: 'qiè',  # 妾
    0x59BF: 'ē',  # 妿
    0x59C0: 'hé',  # 姀
    0x59C1: 'xǔ,xū',  # 姁
    0x59C2: 'fá',  # 姂
    0x59C3: 'zhēng',  # 姃
    0x59C4: 'mín',  # 姄
    0x59C5: 'bàn',  # 姅
    0x59C6: 'mǔ',  # 姆
    0x59C7: 'fū,fú',  # 姇
    0x59C8: 'líng',  # 姈
    0x59C9: 'zǐ',  # 姉
    0x59CA: 'zǐ',  # 姊
    0x59CB: 'shǐ',  # 始
    0x59CC: 'rǎn',  # 姌
    0x59CD: 'shān,shàn',  # 姍
    0x59CE: 'yāng',  # 姎
    0x59CF: 'mán',  # 姏
    0x59D0: 'jiě',  # 姐
    0x59D1: 'gū',  # 姑
    0x59D2: 'sì',  # 姒
    0x59D3: 'xìng',  # 姓
    0x59D4: 'wěi,wēi',  # 委
    0x59D5: 'zī',  # 姕
    0x59D6: 'jù',  # 姖
    0x59D7: 'shān,shàn',  # 姗
    0x59D8: 'pīn',  # 姘
    0x59D9: 'rèn',  # 姙
    0x59DA: 'yáo',  # 姚
    0x59DB: 'dòng',  # 姛
    0x59DC: 'jiāng',  # 姜
    0x59DD: 'shū',  # 姝
    0x59DE: 'jí',  # 姞
    0x59DF: 'gāi',  # 姟
    0x59E0: 'xiàng',  # 姠
    0x59E1: 'huá,huó',  # 姡
    0x59E2: 'juān',  # 姢
    0x59E3: 'jiāo,xiáo',  # 姣
    0x59E4: 'gòu,dù',  # 姤
    0x59E5: 'mǔ,lǎo',  # 姥
    0x59E6: 'jiān',  # 姦
    0x59E7: 'jiān',  # 姧
    0x59E8: 'yí',  # 姨
    0x59E9: 'nián,niàn',  # 姩
    0x59EA: 'zhí',  # 姪
    0x59EB: 'zhěn',  # 姫
    0x59EC: 'jī',  # 姬
    0x59ED: 'xiàn',  # 姭
    0x59EE: 'héng',  # 姮
    0x59EF: 'guāng',  # 姯
    0x59F0: 'jūn,xún',  # 姰
    0x59F1: 'kuā,hù',  # 姱
    0x59F2: 'yàn',  # 姲
    0x59F3: 'mǐng',  # 姳
    0x59F4: 'liè',  # 姴
    0x59F5: 'pèi',  # 姵
    0x59F6: 'è,yà',  # 姶
    0x59F7: 'yòu',  # 姷
    0x59F8: 'yán',  # 姸
    0x59F9: 'chà',  # 姹
    0x59FA: 'shēn,xiān',  # 姺
    0x59FB: 'yīn',  # 姻
    0x59FC: 'shí',  # 姼
    0x59FD: 'guǐ',  # 姽
    0x59FE: 'quán',  # 姾
    0x59FF: 'zī',  # 姿
    0x5A00: 'sōng',  # 娀
    0x5A01: 'wēi',  # 威
    0x5A02: 'hóng',  # 娂
    0x5A03: 'wá',  # 娃
    0x5A04: 'lóu',  # 娄
    0x5A05: 'yà',  # 娅
    0x5A06: 'ráo,rǎo',  # 娆
    0x5A07: 'jiāo',  # 娇
    0x5A08: 'luán',  # 娈
    0x5A09: 'pīng',  # 娉
    0x5A0A: 'xiàn',  # 娊
    0x5A0B: 'shào,shāo',  # 娋
    0x5A0C: 'lǐ',  # 娌
    0x5A0D: 'chéng,shèng',  # 娍
    0x5A0E: 'xiē',  # 娎
    0x5A0F: 'máng',  # 娏
    0x5A10: 'fū',  # 娐
    0x5A11: 'suō',  # 娑
    0x5A12: 'wǔ,mǔ',  # 娒
    0x5A13: 'wěi',  # 娓
    0x5A14: 'kè',  # 娔
    0x5A15: 'chuò,lài',  # 娕
    0x5A16: 'chuò',  # 娖
    0x5A17: 'tǐng',  # 娗
    0x5A18: 'niáng',  # 娘
    0x5A19: 'xíng',  # 娙
    0x5A1A: 'nán',  # 娚
    0x5A1B: 'yú',  # 娛
    0x5A1C: 'nà,nuó',  # 娜
    0x5A1D: 'pōu,bǐ',  # 娝
    0x5A1E: 'něi,suī',  # 娞
    0x5A1F: 'juān',  # 娟
    0x5A20: 'shēn',  # 娠
    0x5A21: 'zhì',  # 娡
    0x5A22: 'hán',  # 娢
    0x5A23: 'dì',  # 娣
    0x5A24: 'zhuāng',  # 娤
    0x5A25: 'é',  # 娥
    0x5A26: 'pín',  # 娦
    0x5A27: 'tuì',  # 娧
    0x5A28: 'mǎn',  # 娨
    0x5A29: 'miǎn',  # 娩
    0x5A2A: 'wú,wù,yú',  # 娪
    0x5A2B: 'yán',  # 娫
    0x5A2C: 'wǔ',  # 娬
    0x5A2D: 'xī,āi',  # 娭
    0x5A2E: 'yán',  # 娮
    0x5A2F: 'yú',  # 娯
    0x5A30: 'sì',  # 娰
    0x5A31: 'yú',  # 娱
    0x5A32: 'wā',  # 娲
    0x5A33: 'lì',  # 娳
    0x5A34: 'xián',  # 娴
    0x5A35: 'jū',  # 娵
    0x5A36: 'qǔ',  # 娶
    0x5A37: 'zhuì,shuì',  # 娷
    0x5A38: 'qī',  # 娸
    0x5A39: 'xián',  # 娹
    0x5A3A: 'zhuó',  # 娺
    0x5A3B: 'dōng,dòng',  # 娻
    0x5A3C: 'chāng',  # 娼
    0x5A3D: 'lù',  # 娽
    0x5A3E: 'ǎi,ái,è',  # 娾
    0x5A3F: 'ē,ě',  # 娿
    0x5A40: 'ē',  # 婀
    0x5A41: 'lóu',  # 婁
    0x5A42: 'mián',  # 婂
    0x5A43: 'cóng',  # 婃
    0x5A44: 'pǒu,péi,bù',  # 婄
    0x5A45: 'jú',  # 婅
    0x5A46: 'pó',  # 婆
    0x5A47: 'cǎi',  # 婇
    0x5A48: 'líng',  # 婈
    0x5A49: 'wǎn',  # 婉
    0x5A4A: 'biǎo',  # 婊
    0x5A4B: 'xiāo',  # 婋
    0x5A4C: 'shū',  # 婌
    0x5A4D: 'qǐ',  # 婍
    0x5A4E: 'huī',  # 婎
    0x5A4F: 'fù,fàn',  # 婏
    0x5A50: 'wǒ',  # 婐
    0x5A51: 'wǒ',  # 婑
    0x5A52: 'tán',  # 婒
    0x5A53: 'fēi',  # 婓
    0x5A54: 'fēi',  # 婔
    0x5A55: 'jié',  # 婕
    0x5A56: 'tiān',  # 婖
    0x5A57: 'ní,nǐ',  # 婗
    0x5A58: 'quán,juàn',  # 婘
    0x5A59: 'jìng',  # 婙
    0x5A5A: 'hūn',  # 婚
    0x5A5B: 'jīng',  # 婛
    0x5A5C: 'qiān,jǐn',  # 婜
    0x5A5D: 'diàn',  # 婝
    0x5A5E: 'xìng',  # 婞
    0x5A5F: 'hù',  # 婟
    0x5A60: 'wān,wà',  # 婠
    0x5A61: 'lái,lài',  # 婡
    0x5A62: 'bì',  # 婢
    0x5A63: 'yīn',  # 婣
    0x5A64: 'zhōu,chōu',  # 婤
    0x5A65: 'chuò,nào',  # 婥
    0x5A66: 'fù',  # 婦
    0x5A67: 'jìng',  # 婧
    0x5A68: 'lún',  # 婨
    0x5A69: 'nüè',  # 婩
    0x5A6A: 'lán',  # 婪
    0x5A6B: 'hùn,kūn',  # 婫
    0x5A6C: 'yín',  # 婬
    0x5A6D: 'yà',  # 婭
    0x5A6E: 'jū',  # 婮
    0x5A6F: 'lì',  # 婯
    0x5A70: 'diǎn',  # 婰
    0x5A71: 'xián',  # 婱
    0x5A72: 'huā',  # 婲
    0x5A73: 'huà',  # 婳
    0x5A74: 'yīng',  # 婴
    0x5A75: 'chán',  # 婵
    0x5A76: 'shěn',  # 婶
    0x5A77: 'tíng',  # 婷
    0x5A78: 'dàng,yáng',  # 婸
    0x5A79: 'yǎo',  # 婹
    0x5A7A: 'wù',  # 婺
    0x5A7B: 'nàn',  # 婻
    0x5A7C: 'ruò,chuò',  # 婼
    0x5A7D: 'jiǎ',  # 婽
    0x5A7E: 'tōu,yú',  # 婾
    0x5A7F: 'xù',  # 婿
    0x5A80: 'yù,yú',  # 媀
    0x5A81: 'wéi,wěi',  # 媁
    0x5A82: 'dì,tí',  # 媂
    0x5A83: 'róu',  # 媃
    0x5A84: 'měi',  # 媄
    0x5A85: 'dān',  # 媅
    0x5A86: 'ruǎn,nèn',  # 媆
    0x5A87: 'qīn',  # 媇
    0x5A88: 'huī',  # 媈
    0x5A89: 'wò',  # 媉
    0x5A8A: 'qián',  # 媊
    0x5A8B: 'chūn',  # 媋
    0x5A8C: 'miáo',  # 媌
    0x5A8D: 'fù',  # 媍
    0x5A8E: 'jiě',  # 媎
    0x5A8F: 'duān',  # 媏
    0x5A90: 'yí,pèi',  # 媐
    0x5A91: 'zhòng',  # 媑
    0x5A92: 'méi',  # 媒
    0x5A93: 'huáng',  # 媓
    0x5A94: 'mián,miǎn',  # 媔
    0x5A95: 'ān',  # 媕
    0x5A96: 'yīng',  # 媖
    0x5A97: 'xuān',  # 媗
    0x5A98: 'jiē',  # 媘
    0x5A99: 'wēi',  # 媙
    0x5A9A: 'mèi',  # 媚
    0x5A9B: 'yuàn,yuán',  # 媛
    0x5A9C: 'zhēng',  # 媜
    0x5A9D: 'qiū',  # 媝
    0x5A9E: 'tí',  # 媞
    0x5A9F: 'xiè',  # 媟
    0x5AA0: 'tuó,duò',  # 媠
    0x5AA1: 'liàn',  # 媡
    0x5AA2: 'mào',  # 媢
    0x5AA3: 'rǎn',  # 媣
    0x5AA4: 'sī',  # 媤
    0x5AA5: 'piān',  # 媥
    0x5AA6: 'wèi',  # 媦
    0x5AA7: 'wā',  # 媧
    0x5AA8: 'cù',  # 媨
    0x5AA9: 'hú',  # 媩
    0x5AAA: 'ǎo',  # 媪
    0x5AAB: 'jié',  # 媫
    0x5AAC: 'bǎo',  # 媬
    0x5AAD: 'xū',  # 媭
    0x5AAE: 'tōu,yú',  # 媮
    0x5AAF: 'guī',  # 媯
    0x5AB0: 'chú,zòu',  # 媰
    0x5AB1: 'yáo',  # 媱
    0x5AB2: 'pì',  # 媲
    0x5AB3: 'xí',  # 媳
    0x5AB4: 'yuán',  # 媴
    0x5AB5: 'yìng',  # 媵
    0x5AB6: 'róng',  # 媶
    0x5AB7: 'rù',  # 媷
    0x5AB8: 'chī',  # 媸
    0x5AB9: 'liú',  # 媹
    0x5ABA: 'měi',  # 媺
    0x5ABB: 'pán',  # 媻
    0x5ABC: 'ǎo',  # 媼
    0x5ABD: 'mā',  # 媽
    0x5ABE: 'gòu',  # 媾
    0x5ABF: 'kuì',  # 媿
    0x5AC0: 'qín,shēn',  # 嫀
    0x5AC1: 'jià',  # 嫁
    0x5AC2: 'sǎo',  # 嫂
    0x5AC3: 'zhēn,zhěn',  # 嫃
    0x5AC4: 'yuán',  # 嫄
    0x5AC5: 'jiē,suǒ',  # 嫅
    0x5AC6: 'róng',  # 嫆
    0x5AC7: 'míng,mǐng',  # 嫇
    0x5AC8: 'yīng',  # 嫈
    0x5AC9: 'jí',  # 嫉
    0x5ACA: 'sù',  # 嫊
    0x5ACB: 'niǎo',  # 嫋
    0x5ACC: 'xián',  # 嫌
    0x5ACD: 'tāo',  # 嫍
    0x5ACE: 'páng',  # 嫎
    0x5ACF: 'láng',  # 嫏
    0x5AD0: 'nǎo',  # 嫐
    0x5AD1: 'biáo',  # 嫑
    0x5AD2: 'ài',  # 嫒
    0x5AD3: 'pì',  # 嫓
    0x5AD4: 'pín',  # 嫔
    0x5AD5: 'yì',  # 嫕
    0x5AD6: 'piáo,piāo',  # 嫖
    0x5AD7: 'yù',  # 嫗
    0x5AD8: 'léi',  # 嫘
    0x5AD9: 'xuán',  # 嫙
    0x5ADA: 'màn',  # 嫚
    0x5ADB: 'yī',  # 嫛
    0x5ADC: 'zhāng',  # 嫜
    0x5ADD: 'kāng',  # 嫝
    0x5ADE: 'yōng',  # 嫞
    0x5ADF: 'nì',  # 嫟
    0x5AE0: 'lí',  # 嫠
    0x5AE1: 'dí',  # 嫡
    0x5AE2: 'guī',  # 嫢
    0x5AE3: 'yān',  # 嫣
    0x5AE4: 'jǐn,jìn',  # 嫤
    0x5AE5: 'zhuān',  # 嫥
    0x5AE6: 'cháng',  # 嫦
    0x5AE7: 'zé',  # 嫧
    0x5AE8: 'hān,nǎn',  # 嫨
    0x5AE9: 'nèn',  # 嫩
    0x5AEA: 'lào',  # 嫪
    0x5AEB: 'mó',  # 嫫
    0x5AEC: 'zhē',  # 嫬
    0x5AED: 'hù',  # 嫭
    0x5AEE: 'hù',  # 嫮
    0x5AEF: 'ào',  # 嫯
    0x5AF0: 'nèn',  # 嫰
    0x5AF1: 'qiáng',  # 嫱
    0x5AF2: 'mā,má',  # 嫲
    0x5AF3: 'piè',  # 嫳
    0x5AF4: 'gū',  # 嫴
    0x5AF5: 'wǔ',  # 嫵
    0x5AF6: 'qiáo',  # 嫶
    0x5AF7: 'tuǒ',  # 嫷
    0x5AF8: 'zhǎn',  # 嫸
    0x5AF9: 'miáo',  # 嫹
    0x5AFA: 'xián',  # 嫺
    0x5AFB: 'xián',  # 嫻
    0x5AFC: 'mò',  # 嫼
    0x5AFD: 'liáo',  # 嫽
    0x5AFE: 'lián',  # 嫾
    0x5AFF: 'huà',  # 嫿
    0x5B00: 'guī',  # 嬀
    0x5B01: 'dēng',  # 嬁
    0x5B02: 'zhí',  # 嬂
    0x5B03: 'xū',  # 嬃
    0x5B04: 'yī',  # 嬄
    0x5B05: 'huà',  # 嬅
    0x5B06: 'xī',  # 嬆
    0x5B07: 'kuì',  # 嬇
    0x5B08: 'ráo,rǎo',  # 嬈
    0x5B09: 'xī',  # 嬉
    0x5B0A: 'yàn',  # 嬊
    0x5B0B: 'chán',  # 嬋
    0x5B0C: 'jiāo',  # 嬌
    0x5B0D: 'měi',  # 嬍
    0x5B0E: 'fàn',  # 嬎
    0x5B0F: 'fān',  # 嬏
    0x5B10: 'xiān,yǎn,jìn',  # 嬐
    0x5B11: 'yì',  # 嬑
    0x5B12: 'huì',  # 嬒
    0x5B13: 'jiào',  # 嬓
    0x5B14: 'fù',  # 嬔
    0x5B15: 'shì',  # 嬕
    0x5B16: 'bì',  # 嬖
    0x5B17: 'shàn',  # 嬗
    0x5B18: 'suì',  # 嬘
    0x5B19: 'qiáng',  # 嬙
    0x5B1A: 'liǎn',  # 嬚
    0x5B1B: 'huán,xuān,qióng',  # 嬛
    0x5B1C: 'xīn',  # 嬜
    0x5B1D: 'niǎo',  # 嬝
    0x5B1E: 'dǒng',  # 嬞
    0x5B1F: 'yǐ',  # 嬟
    0x5B20: 'cān',  # 嬠
    0x5B21: 'ài',  # 嬡
    0x5B22: 'niáng',  # 嬢
    0x5B23: 'níng',  # 嬣
    0x5B24: 'mó',  # 嬤
    0x5B25: 'tiǎo',  # 嬥
    0x5B26: 'chóu',  # 嬦
    0x5B27: 'jìn',  # 嬧
    0x5B28: 'cí',  # 嬨
    0x5B29: 'yú',  # 嬩
    0x5B2A: 'pín',  # 嬪
    0x5B2B: 'róng',  # 嬫
    0x5B2C: 'rú',  # 嬬
    0x5B2D: 'nǎi',  # 嬭
    0x5B2E: 'yān,yàn',  # 嬮
    0x5B2F: 'tái',  # 嬯
    0x5B30: 'yīng',  # 嬰
    0x5B31: 'qiàn',  # 嬱
    0x5B32: 'niǎo',  # 嬲
    0x5B33: 'yuè',  # 嬳
    0x5B34: 'yíng',  # 嬴
    0x5B35: 'mián',  # 嬵
    0x5B36: 'bí',  # 嬶
    0x5B37: 'mó',  # 嬷
    0x5B38: 'shěn',  # 嬸
    0x5B39: 'xìng',  # 嬹
    0x5B3A: 'nì',  # 嬺
    0x5B3B: 'dú',  # 嬻
    0x5B3C: 'liǔ',  # 嬼
    0x5B3D: 'yuān',  # 嬽
    0x5B3E: 'lǎn',  # 嬾
    0x5B3F: 'yàn',  # 嬿
    0x5B40: 'shuāng',  # 孀
    0x5B41: 'líng',  # 孁
    0x5B42: 'jiǎo',  # 孂
    0x5B43: 'niáng',  # 孃
    0x5B44: 'lǎn',  # 孄
    0x5B45: 'xiān,qiān',  # 孅
    0x5B46: 'yīng',  # 孆
    0x5B47: 'shuāng',  # 孇
    0x5B48: 'xié,huī',  # 孈
    0x5B49: 'huān,quán',  # 孉
    0x5B4A: 'mǐ',  # 孊
    0x5B4B: 'lí,lì',  # 孋
    0x5B4C: 'luán',  # 孌
    0x5B4D: 'yǎn',  # 孍
    0x5B4E: 'zhú,chuò',  # 孎
    0x5B4F: 'lǎn',  # 孏
    0x5B50: 'zǐ',  # 子
    0x5B51: 'jié',  # 孑
    0x5B52: 'jué',  # 孒
    0x5B53: 'jué',  # 孓
    0x5B54: 'kǒng',  # 孔
    0x5B55: 'yùn',  # 孕
    0x5B56: 'zī,mā',  # 孖
    0x5B57: 'zì',  # 字
    0x5B58: 'cún',  # 存
    0x5B59: 'sūn,xùn',  # 孙
    0x5B5A: 'fú',  # 孚
    0x5B5B: 'bèi',  # 孛
    0x5B5C: 'zī',  # 孜
    0x5B5D: 'xiào',  # 孝
    0x5B5E: 'xìn',  # 孞
    0x5B5F: 'mèng',  # 孟
    0x5B60: 'sì',  # 孠
    0x5B61: 'tāi',  # 孡
    0x5B62: 'bāo',  # 孢
    0x5B63: 'jì',  # 季
    0x5B64: 'gū',  # 孤
    0x5B65: 'nú',  # 孥
    0x5B66: 'xué',  # 学
    0x5B67: 'yòu,niū',  # 孧
    0x5B68: 'zhuǎn',  # 孨
    0x5B69: 'hái',  # 孩
    0x5B6A: 'luán',  # 孪
    0x5B6B: 'sūn,xùn',  # 孫
    0x5B6C: 'nāo',  # 孬
    0x5B6D: 'miē',  # 孭
    0x5B6E: 'cóng',  # 孮
    0x5B6F: 'qiān',  # 孯
    0x5B70: 'shú',  # 孰
    0x5B71: 'chán,càn',  # 孱
    0x5B72: 'yā',  # 孲
    0x5B73: 'zī',  # 孳
    0x5B74: 'nǐ',  # 孴
    0x5B75: 'fū',  # 孵
    0x5B76: 'zī',  # 孶
    0x5B77: 'lí',  # 孷
    0x5B78: 'xué',  # 學
    0x5B79: 'bò',  # 孹
    0x5B7A: 'rú',  # 孺
    0x5B7B: 'nái',  # 孻
    0x5B7C: 'niè',  # 孼
    0x5B7D: 'niè',  # 孽
    0x5B7E: 'yīng',  # 孾
    0x5B7F: 'luán',  # 孿
    0x5B80: 'mián',  # 宀
    0x5B81: 'níng,nìng,zhù',  # 宁
    0x5B82: 'rǒng',  # 宂
    0x5B83: 'tā',  # 它
    0x5B84: 'guǐ',  # 宄
    0x5B85: 'zhái',  # 宅
    0x5B86: 'qióng',  # 宆
    0x5B87: 'yǔ',  # 宇
    0x5B88: 'shǒu',  # 守
    0x5B89: 'ān',  # 安
    0x5B8A: 'tū,jiā',  # 宊
    0x5B8B: 'sòng',  # 宋
    0x5B8C: 'wán',  # 完
    0x5B8D: 'ròu',  # 宍
    0x5B8E: 'yǎo',  # 宎
    0x5B8F: 'hóng',  # 宏
    0x5B90: 'yí',  # 宐
    0x5B91: 'jǐng',  # 宑
    0x5B92: 'zhūn',  # 宒
    0x5B93: 'mì,fú',  # 宓
    0x5B94: 'zhǔ',  # 宔
    0x5B95: 'dàng',  # 宕
    0x5B96: 'hóng',  # 宖
    0x5B97: 'zōng',  # 宗
    0x5B98: 'guān',  # 官
    0x5B99: 'zhòu',  # 宙
    0x5B9A: 'dìng',  # 定
    0x5B9B: 'wǎn,yuān',  # 宛
    0x5B9C: 'yí',  # 宜
    0x5B9D: 'bǎo',  # 宝
    0x5B9E: 'shí',  # 实
    0x5B9F: 'shí',  # 実
    0x5BA0: 'chǒng',  # 宠
    0x5BA1: 'shěn',  # 审
    0x5BA2: 'kè',  # 客
    0x5BA3: 'xuān',  # 宣
    0x5BA4: 'shì',  # 室
    0x5BA5: 'yòu',  # 宥
    0x5BA6: 'huàn',  # 宦
    0x5BA7: 'yí',  # 宧
    0x5BA8: 'tiǎo',  # 宨
    0x5BA9: 'shǐ',  # 宩
    0x5BAA: 'xiàn',  # 宪
    0x5BAB: 'gōng',  # 宫
    0x5BAC: 'chéng',  # 宬
    0x5BAD: 'qún',  # 宭
    0x5BAE: 'gōng',  # 宮
    0x5BAF: 'xiāo',  # 宯
    0x5BB0: 'zǎi',  # 宰
    0x5BB1: 'zhà',  # 宱
    0x5BB2: 'bǎo,shí',  # 宲
    0x5BB3: 'hài',  # 害
    0x5BB4: 'yàn',  # 宴
    0x5BB5: 'xiāo',  # 宵
    0x5BB6: 'jiā,jia,jie',  # 家
    0x5BB7: 'shěn',  # 宷
    0x5BB8: 'chén',  # 宸
    0x5BB9: 'róng',  # 容
    0x5BBA: 'huāng,huǎng',  # 宺
    0x5BBB: 'mì',  # 宻
    0x5BBC: 'kòu',  # 宼
    0x5BBD: 'kuān',  # 宽
    0x5BBE: 'bīn',  # 宾
    0x5BBF: 'sù,xiǔ,xiù',  # 宿
    0x5BC0: 'cǎi,cài',  # 寀
    0x5BC1: 'zǎn',  # 寁
    0x5BC2: 'jì',  # 寂
    0x5BC3: 'yuān',  # 寃
    0x5BC4: 'jì',  # 寄
    0x5BC5: 'yín',  # 寅
    0x5BC6: 'mì',  # 密
    0x5BC7: 'kòu',  # 寇
    0x5BC8: 'qīng',  # 寈
    0x5BC9: 'hè',  # 寉
    0x5BCA: 'zhēn',  # 寊
    0x5BCB: 'jiàn',  # 寋
    0x5BCC: 'fù',  # 富
    0x5BCD: 'níng,nìng',  # 寍
    0x5BCE: 'bǐng,bìng',  # 寎
    0x5BCF: 'huán',  # 寏
    0x5BD0: 'mèi',  # 寐
    0x5BD1: 'qǐn',  # 寑
    0x5BD2: 'hán',  # 寒
    0x5BD3: 'yù',  # 寓
    0x5BD4: 'shí',  # 寔
    0x5BD5: 'níng,nìng',  # 寕
    0x5BD6: 'jìn,qǐn',  # 寖
    0x5BD7: 'níng,nìng',  # 寗
    0x5BD8: 'zhì',  # 寘
    0x5BD9: 'yǔ',  # 寙
    0x5BDA: 'bǎo',  # 寚
    0x5BDB: 'kuān',  # 寛
    0x5BDC: 'níng,nìng',  # 寜
    0x5BDD: 'qǐn',  # 寝
    0x5BDE: 'mò',  # 寞
    0x5BDF: 'chá',  # 察
    0x5BE0: 'jù,lóu',  # 寠
    0x5BE1: 'guǎ',  # 寡
    0x5BE2: 'qǐn',  # 寢
    0x5BE3: 'hū',  # 寣
    0x5BE4: 'wù',  # 寤
    0x5BE5: 'liáo',  # 寥
    0x5BE6: 'shí',  # 實
    0x5BE7: 'níng,nìng',  # 寧
    0x5BE8: 'zhài',  # 寨
    0x5BE9: 'shěn',  # 審
    0x5BEA: 'wěi',  # 寪
    0x5BEB: 'xiě,xiè',  # 寫
    0x5BEC: 'kuān',  # 寬
    0x5BED: 'huì',  # 寭
    0x5BEE: 'liáo',  # 寮
    0x5BEF: 'jùn',  # 寯
    0x5BF0: 'huán',  # 寰
    0x5BF1: 'yì',  # 寱
    0x5BF2: 'yí',  # 寲
    0x5BF3: 'bǎo',  # 寳
    0x5BF4: 'qīn,qìn',  # 寴
    0x5BF5: 'chǒng',  # 寵
    0x5BF6: 'bǎo',  # 寶
    0x5BF7: 'fēng',  # 寷
    0x5BF8: 'cùn',  # 寸
    0x5BF9: 'duì',  # 对
    0x5BFA: 'sì',  # 寺
    0x5BFB: 'xún',  # 寻
    0x5BFC: 'dǎo',  # 导
    0x5BFD: 'lüè,luó',  # 寽
    0x5BFE: 'duì',  # 対
    0x5BFF: 'shòu',  # 寿
    0x5C00: 'pǒ',  # 尀
    0x5C01: 'fēng',  # 封
    0x5C02: 'zhuān',  # 専
    0x5C03: 'fū',  # 尃
    0x5C04: 'shè,yè,yì',  # 射
    0x5C05: 'kēi,kè',  # 尅
    0x5C06: 'jiāng,jiàng',  # 将
    0x5C07: 'jiāng,jiàng',  # 將
    0x5C08: 'zhuān',  # 專
    0x5C09: 'wèi,yù',  # 尉
    0x5C0A: 'zūn',  # 尊
    0x5C0B: 'xún',  # 尋
    0x5C0C: 'shù,zhù',  # 尌
    0x5C0D: 'duì',  # 對
    0x5C0E: 'dǎo',  # 導
    0x5C0F: 'xiǎo',  # 小
    0x5C10: 'jié,jí',  # 尐
    0x5C11: 'shǎo,shào',  # 少
    0x5C12: 'ěr',  # 尒
    0x5C13: 'ěr',  # 尓
    0x5C14: 'ěr',  # 尔
    0x5C15: 'gǎ',  # 尕
    0x5C16: 'jiān',  # 尖
    0x5C17: 'shú',  # 尗
    0x5C18: 'chén',  # 尘
    0x5C19: 'shàng',  # 尙
    0x5C1A: 'shàng',  # 尚
    0x5C1B: 'mó',  # 尛
    0x5C1C: 'gá',  # 尜
    0x5C1D: 'cháng',  # 尝
    0x5C1E: 'liáo',  # 尞
    0x5C1F: 'xiǎn',  # 尟
    0x5C20: 'xiǎn',  # 尠
    0x5C21: 'hùn',  # 尡
    0x5C22: 'yóu',  # 尢
    0x5C23: 'wāng',  # 尣
    0x5C24: 'yóu',  # 尤
    0x5C25: 'liào',  # 尥
    0x5C26: 'liào',  # 尦
    0x5C27: 'yáo',  # 尧
    0x5C28: 'lóng,máng,méng,páng',  # 尨
    0x5C29: 'wāng',  # 尩
    0x5C2A: 'wāng',  # 尪
    0x5C2B: 'wāng',  # 尫
    0x5C2C: 'gà',  # 尬
    0x5C2D: 'yáo',  # 尭
    0x5C2E: 'duò',  # 尮
    0x5C2F: 'kuì,kuǐ',  # 尯
    0x5C30: 'zhǒng',  # 尰
    0x5C31: 'jiù',  # 就
    0x5C32: 'gān',  # 尲
    0x5C33: 'gǔ',  # 尳
    0x5C34: 'gān',  # 尴
    0x5C35: 'tuí',  # 尵
    0x5C36: 'gān',  # 尶
    0x5C37: 'gān',  # 尷
    0x5C38: 'shī',  # 尸
    0x5C39: 'yǐn',  # 尹
    0x5C3A: 'chǐ,chě',  # 尺
    0x5C3B: 'kāo',  # 尻
    0x5C3C: 'ní',  # 尼
    0x5C3D: 'jìn,jǐn',  # 尽
    0x5C3E: 'wěi,yǐ',  # 尾
    0x5C3F: 'niào,suī',  # 尿
    0x5C40: 'jú',  # 局
    0x5C41: 'pì',  # 屁
    0x5C42: 'céng',  # 层
    0x5C43: 'xì',  # 屃
    0x5C44: 'bī',  # 屄
    0x5C45: 'jū',  # 居
    0x5C46: 'jiè',  # 屆
    0x5C47: 'tián',  # 屇
    0x5C48: 'qū',  # 屈
    0x5C49: 'tì',  # 屉
    0x5C4A: 'jiè',  # 届
    0x5C4B: 'wū',  # 屋
    0x5C4C: 'diǎo',  # 屌
    0x5C4D: 'shī',  # 屍
    0x5C4E: 'shǐ',  # 屎
    0x5C4F: 'píng,bǐng',  # 屏
    0x5C50: 'jī',  # 屐
    0x5C51: 'xiè',  # 屑
    0x5C52: 'zhěn',  # 屒
    0x5C53: 'xì',  # 屓
    0x5C54: 'ní',  # 屔
    0x5C55: 'zhǎn',  # 展
    0x5C56: 'xī',  # 屖
    0x5C57: 'wěi',  # 屗
    0x5C58: 'mǎn',  # 屘
    0x5C59: 'ē',  # 屙
    0x5C5A: 'lòu',  # 屚
    0x5C5B: 'pǐng,bǐng',  # 屛
    0x5C5C: 'tì',  # 屜
    0x5C5D: 'fèi',  # 屝
    0x5C5E: 'shǔ,zhǔ',  # 属
    0x5C5F: 'xiè,tì',  # 屟
    0x5C60: 'tú',  # 屠
    0x5C61: 'lǚ',  # 屡
    0x5C62: 'lǚ',  # 屢
    0x5C63: 'xǐ',  # 屣
    0x5C64: 'céng',  # 層
    0x5C65: 'lǚ',  # 履
    0x5C66: 'jù',  # 屦
    0x5C67: 'xiè',  # 屧
    0x5C68: 'jù',  # 屨
    0x5C69: 'juē',  # 屩
    0x5C6A: 'liáo',  # 屪
    0x5C6B: 'juē',  # 屫
    0x5C6C: 'shǔ,zhǔ',  # 屬
    0x5C6D: 'xì',  # 屭
    0x5C6E: 'chè,cǎo',  # 屮
    0x5C6F: 'tún,zhūn',  # 屯
    0x5C70: 'nì,jǐ',  # 屰
    0x5C71: 'shān',  # 山
    0x5C72: 'wā',  # 屲
    0x5C73: 'xiān',  # 屳
    0x5C74: 'lì',  # 屴
    0x5C75: 'àn',  # 屵
    0x5C76: 'huì',  # 屶
    0x5C77: 'huì',  # 屷
    0x5C78: 'hóng,lóng',  # 屸
    0x5C79: 'yì',  # 屹
    0x5C7A: 'qǐ',  # 屺
    0x5C7B: 'rèn',  # 屻
    0x5C7C: 'wù',  # 屼
    0x5C7D: 'hàn,àn',  # 屽
    0x5C7E: 'shēn',  # 屾
    0x5C7F: 'yǔ',  # 屿
    0x5C80: 'chū',  # 岀
    0x5C81: 'suì',  # 岁
    0x5C82: 'qǐ,kǎi',  # 岂
    0x5C83: 'rèn',  # 岃
    0x5C84: 'yuè',  # 岄
    0x5C85: 'bǎn',  # 岅
    0x5C86: 'yǎo',  # 岆
    0x5C87: 'áng',  # 岇
    0x5C88: 'yá',  # 岈
    0x5C89: 'wù',  # 岉
    0x5C8A: 'jié',  # 岊
    0x5C8B: 'è',  # 岋
    0x5C8C: 'jí',  # 岌
    0x5C8D: 'qiān',  # 岍
    0x5C8E: 'fén',  # 岎
    0x5C8F: 'wán',  # 岏
    0x5C90: 'qí',  # 岐
    0x5C91: 'cén',  # 岑
    0x5C92: 'qián',  # 岒
    0x5C93: 'qí',  # 岓
    0x5C94: 'chà',  # 岔
    0x5C95: 'jiè',  # 岕
    0x5C96: 'qū',  # 岖
    0x5C97: 'gǎng',  # 岗
    0x5C98: 'xiàn',  # 岘
    0x5C99: 'ào',  # 岙
    0x5C9A: 'lán',  # 岚
    0x5C9B: 'dǎo',  # 岛
    0x5C9C: 'bā',  # 岜
    0x5C9D: 'zuò',  # 岝
    0x5C9E: 'zuò',  # 岞
    0x5C9F: 'yǎng',  # 岟
    0x5CA0: 'jù',  # 岠
    0x5CA1: 'gāng',  # 岡
    0x5CA2: 'kě',  # 岢
    0x5CA3: 'gǒu',  # 岣
    0x5CA4: 'xuè',  # 岤
    0x5CA5: 'pō',  # 岥
    0x5CA6: 'lì',  # 岦
    0x5CA7: 'tiáo',  # 岧
    0x5CA8: 'jū,jǔ',  # 岨
    0x5CA9: 'yán',  # 岩
    0x5CAA: 'fú',  # 岪
    0x5CAB: 'xiù',  # 岫
    0x5CAC: 'jiǎ',  # 岬
    0x5CAD: 'lǐng,líng',  # 岭
    0x5CAE: 'tuó',  # 岮
    0x5CAF: 'pī',  # 岯
    0x5CB0: 'ào',  # 岰
    0x5CB1: 'dài',  # 岱
    0x5CB2: 'kuàng',  # 岲
    0x5CB3: 'yuè',  # 岳
    0x5CB4: 'qū',  # 岴
    0x5CB5: 'hù',  # 岵
    0x5CB6: 'pò',  # 岶
    0x5CB7: 'mín',  # 岷
    0x5CB8: 'àn',  # 岸
    0x5CB9: 'tiáo',  # 岹
    0x5CBA: 'lǐng,líng',  # 岺
    0x5CBB: 'dī',  # 岻
    0x5CBC: 'píng',  # 岼
    0x5CBD: 'dōng',  # 岽
    0x5CBE: 'zhān',  # 岾
    0x5CBF: 'kuī',  # 岿
    0x5CC0: 'xiù',  # 峀
    0x5CC1: 'mǎo',  # 峁
    0x5CC2: 'tóng',  # 峂
    0x5CC3: 'xué',  # 峃
    0x5CC4: 'yì',  # 峄
    0x5CC5: 'biàn',  # 峅
    0x5CC6: 'hé',  # 峆
    0x5CC7: 'kè,bā',  # 峇
    0x5CC8: 'luò',  # 峈
    0x5CC9: 'é',  # 峉
    0x5CCA: 'fù,niè',  # 峊
    0x5CCB: 'xún',  # 峋
    0x5CCC: 'dié',  # 峌
    0x5CCD: 'lù',  # 峍
    0x5CCE: 'ěn',  # 峎
    0x5CCF: 'ér',  # 峏
    0x5CD0: 'gāi',  # 峐
    0x5CD1: 'quán',  # 峑
    0x5CD2: 'tóng,dòng',  # 峒
    0x5CD3: 'yí',  # 峓
    0x5CD4: 'mǔ',  # 峔
    0x5CD5: 'shí',  # 峕
    0x5CD6: 'ān',  # 峖
    0x5CD7: 'wéi',  # 峗
    0x5CD8: 'huán',  # 峘
    0x5CD9: 'zhì,shì',  # 峙
    0x5CDA: 'mì',  # 峚
    0x5CDB: 'lǐ',  # 峛
    0x5CDC: 'fǎ',  # 峜
    0x5CDD: 'tóng',  # 峝
    0x5CDE: 'wéi',  # 峞
    0x5CDF: 'yòu',  # 峟
    0x5CE0: 'qiǎ',  # 峠
    0x5CE1: 'xiá',  # 峡
    0x5CE2: 'lǐ',  # 峢
    0x5CE3: 'yáo',  # 峣
    0x5CE4: 'jiào,qiáo',  # 峤
    0x5CE5: 'zhēng',  # 峥
    0x5CE6: 'luán',  # 峦
    0x5CE7: 'jiāo',  # 峧
    0x5CE8: 'é',  # 峨
    0x5CE9: 'é',  # 峩
    0x5CEA: 'yù',  # 峪
    0x5CEB: 'xié,yé',  # 峫
    0x5CEC: 'bū',  # 峬
    0x5CED: 'qiào',  # 峭
    0x5CEE: 'qún',  # 峮
    0x5CEF: 'fēng',  # 峯
    0x5CF0: 'fēng',  # 峰
    0x5CF1: 'náo',  # 峱
    0x5CF2: 'lǐ',  # 峲
    0x5CF3: 'yōu',  # 峳
    0x5CF4: 'xiàn',  # 峴
    0x5CF5: 'róng',  # 峵
    0x5CF6: 'dǎo',  # 島
    0x5CF7: 'shēn',  # 峷
    0x5CF8: 'chéng',  # 峸
    0x5CF9: 'tú',  # 峹
    0x5CFA: 'gěng',  # 峺
    0x5CFB: 'jùn',  # 峻
    0x5CFC: 'gào',  # 峼
    0x5CFD: 'xiá',  # 峽
    0x5CFE: 'yín',  # 峾
    0x5CFF: 'wú',  # 峿
    0x5D00: 'lǎng',  # 崀
    0x5D01: 'kàn',  # 崁
    0x5D02: 'láo',  # 崂
    0x5D03: 'lái',  # 崃
    0x5D04: 'xiǎn',  # 崄
    0x5D05: 'què',  # 崅
    0x5D06: 'kōng',  # 崆
    0x5D07: 'chóng',  # 崇
    0x5D08: 'chóng',  # 崈
    0x5D09: 'tà',  # 崉
    0x5D0A: 'lín',  # 崊
    0x5D0B: 'huà',  # 崋
    0x5D0C: 'jū',  # 崌
    0x5D0D: 'lái',  # 崍
    0x5D0E: 'qí',  # 崎
    0x5D0F: 'mín',  # 崏
    0x5D10: 'kūn',  # 崐
    0x5D11: 'kūn',  # 崑
    0x5D12: 'zú,cuì',  # 崒
    0x5D13: 'gù',  # 崓
    0x5D14: 'cuī',  # 崔
    0x5D15: 'yá',  # 崕
    0x5D16: 'yá',  # 崖
    0x5D17: 'gǎng,gāng',  # 崗
    0x5D18: 'lún',  # 崘
    0x5D19: 'lún',  # 崙
    0x5D1A: 'líng,léng',  # 崚
    0x5D1B: 'jué',  # 崛
    0x5D1C: 'duǒ',  # 崜
    0x5D1D: 'zhēng',  # 崝
    0x5D1E: 'guō',  # 崞
    0x5D1F: 'yín',  # 崟
    0x5D20: 'dōng,dòng',  # 崠
    0x5D21: 'hán',  # 崡
    0x5D22: 'zhēng',  # 崢
    0x5D23: 'wěi',  # 崣
    0x5D24: 'xiáo',  # 崤
    0x5D25: 'pí,bǐ',  # 崥
    0x5D26: 'yān',  # 崦
    0x5D27: 'sōng',  # 崧
    0x5D28: 'jié',  # 崨
    0x5D29: 'bēng',  # 崩
    0x5D2A: 'zú',  # 崪
    0x5D2B: 'jué',  # 崫
    0x5D2C: 'dōng',  # 崬
    0x5D2D: 'zhǎn,chán',  # 崭
    0x5D2E: 'gù',  # 崮
    0x5D2F: 'yín',  # 崯
    0x5D30: 'zī',  # 崰
    0x5D31: 'zè',  # 崱
    0x5D32: 'huáng',  # 崲
    0x5D33: 'yú',  # 崳
    0x5D34: 'wǎi,wēi',  # 崴
    0x5D35: 'yáng,dàng',  # 崵
    0x5D36: 'fēng',  # 崶
    0x5D37: 'qiú',  # 崷
    0x5D38: 'yáng',  # 崸
    0x5D39: 'tí',  # 崹
    0x5D3A: 'yǐ',  # 崺
    0x5D3B: 'zhì,shì',  # 崻
    0x5D3C: 'shì,dié',  # 崼
    0x5D3D: 'zǎi',  # 崽
    0x5D3E: 'yǎo',  # 崾
    0x5D3F: 'è',  # 崿
    0x5D40: 'zhù',  # 嵀
    0x5D41: 'kān,zhàn',  # 嵁
    0x5D42: 'lǜ',  # 嵂
    0x5D43: 'yǎn',  # 嵃
    0x5D44: 'měi',  # 嵄
    0x5D45: 'hán',  # 嵅
    0x5D46: 'jī',  # 嵆
    0x5D47: 'jī',  # 嵇
    0x5D48: 'huàn',  # 嵈
    0x5D49: 'tíng',  # 嵉
    0x5D4A: 'shèng',  # 嵊
    0x5D4B: 'méi',  # 嵋
    0x5D4C: 'qiàn,kàn',  # 嵌
    0x5D4D: 'wù,máo',  # 嵍
    0x5D4E: 'yú',  # 嵎
    0x5D4F: 'zōng',  # 嵏
    0x5D50: 'lán',  # 嵐
    0x5D51: 'kě,jié',  # 嵑
    0x5D52: 'yán',  # 嵒
    0x5D53: 'yán',  # 嵓
    0x5D54: 'wēi,wěi',  # 嵔
    0x5D55: 'zōng',  # 嵕
    0x5D56: 'chá',  # 嵖
    0x5D57: 'suì',  # 嵗
    0x5D58: 'róng',  # 嵘
    0x5D59: 'kē',  # 嵙
    0x5D5A: 'qīn',  # 嵚
    0x5D5B: 'yú',  # 嵛
    0x5D5C: 'qí',  # 嵜
    0x5D5D: 'lǒu',  # 嵝
    0x5D5E: 'tú',  # 嵞
    0x5D5F: 'cuī',  # 嵟
    0x5D60: 'xī',  # 嵠
    0x5D61: 'wěng',  # 嵡
    0x5D62: 'cāng',  # 嵢
    0x5D63: 'dàng,táng',  # 嵣
    0x5D64: 'róng,yíng',  # 嵤
    0x5D65: 'jié',  # 嵥
    0x5D66: 'kǎi,ái',  # 嵦
    0x5D67: 'liú',  # 嵧
    0x5D68: 'wù',  # 嵨
    0x5D69: 'sōng',  # 嵩
    0x5D6A: 'kāo,qiāo',  # 嵪
    0x5D6B: 'zī',  # 嵫
    0x5D6C: 'wéi',  # 嵬
    0x5D6D: 'bēng',  # 嵭
    0x5D6E: 'diān',  # 嵮
    0x5D6F: 'cuó',  # 嵯
    0x5D70: 'qīn,qiǎn',  # 嵰
    0x5D71: 'yǒng',  # 嵱
    0x5D72: 'niè',  # 嵲
    0x5D73: 'cuó',  # 嵳
    0x5D74: 'jǐ',  # 嵴
    0x5D75: 'shí',  # 嵵
    0x5D76: 'ruò',  # 嵶
    0x5D77: 'sǒng',  # 嵷
    0x5D78: 'zǒng',  # 嵸
    0x5D79: 'jiàng',  # 嵹
    0x5D7A: 'liáo',  # 嵺
    0x5D7B: 'kāng',  # 嵻
    0x5D7C: 'chǎn',  # 嵼
    0x5D7D: 'dié,dì',  # 嵽
    0x5D7E: 'cēn',  # 嵾
    0x5D7F: 'dǐng',  # 嵿
    0x5D80: 'tū',  # 嶀
    0x5D81: 'lǒu',  # 嶁
    0x5D82: 'zhàng',  # 嶂
    0x5D83: 'zhǎn,chán',  # 嶃
    0x5D84: 'zhǎn,chán',  # 嶄
    0x5D85: 'áo,ào',  # 嶅
    0x5D86: 'cáo',  # 嶆
    0x5D87: 'qū',  # 嶇
    0x5D88: 'qiāng',  # 嶈
    0x5D89: 'wěi',  # 嶉
    0x5D8A: 'zuǐ',  # 嶊
    0x5D8B: 'dǎo',  # 嶋
    0x5D8C: 'dǎo',  # 嶌
    0x5D8D: 'xí',  # 嶍
    0x5D8E: 'yù',  # 嶎
    0x5D8F: 'pǐ,pèi',  # 嶏
    0x5D90: 'lóng',  # 嶐
    0x5D91: 'xiàng',  # 嶑
    0x5D92: 'céng',  # 嶒
    0x5D93: 'bō',  # 嶓
    0x5D94: 'qīn',  # 嶔
    0x5D95: 'jiāo',  # 嶕
    0x5D96: 'yān',  # 嶖
    0x5D97: 'láo',  # 嶗
    0x5D98: 'zhàn',  # 嶘
    0x5D99: 'lín',  # 嶙
    0x5D9A: 'liáo',  # 嶚
    0x5D9B: 'liáo',  # 嶛
    0x5D9C: 'qín',  # 嶜
    0x5D9D: 'dèng',  # 嶝
    0x5D9E: 'tuò',  # 嶞
    0x5D9F: 'zūn',  # 嶟
    0x5DA0: 'jiào,qiáo',  # 嶠
    0x5DA1: 'jué,guì',  # 嶡
    0x5DA2: 'yáo',  # 嶢
    0x5DA3: 'jiāo',  # 嶣
    0x5DA4: 'yáo',  # 嶤
    0x5DA5: 'jué',  # 嶥
    0x5DA6: 'zhān,shàn',  # 嶦
    0x5DA7: 'yì',  # 嶧
    0x5DA8: 'xué',  # 嶨
    0x5DA9: 'náo',  # 嶩
    0x5DAA: 'yè',  # 嶪
    0x5DAB: 'yè',  # 嶫
    0x5DAC: 'yí',  # 嶬
    0x5DAD: 'niè',  # 嶭
    0x5DAE: 'xiǎn',  # 嶮
    0x5DAF: 'jí',  # 嶯
    0x5DB0: 'xiè,jiè',  # 嶰
    0x5DB1: 'kě,jié',  # 嶱
    0x5DB2: 'guī,xī,juàn',  # 嶲
    0x5DB3: 'dì',  # 嶳
    0x5DB4: 'ào',  # 嶴
    0x5DB5: 'zuì',  # 嶵
    0x5DB6: 'wēi',  # 嶶
    0x5DB7: 'yí',  # 嶷
    0x5DB8: 'róng',  # 嶸
    0x5DB9: 'dǎo',  # 嶹
    0x5DBA: 'lǐng',  # 嶺
    0x5DBB: 'jié',  # 嶻
    0x5DBC: 'yǔ',  # 嶼
    0x5DBD: 'yuè',  # 嶽
    0x5DBE: 'yǐn',  # 嶾
    0x5DBF: 'rū',  # 嶿
    0x5DC0: 'jié',  # 巀
    0x5DC1: 'lì,liè',  # 巁
    0x5DC2: 'guī,xī,juàn',  # 巂
    0x5DC3: 'lóng',  # 巃
    0x5DC4: 'lóng',  # 巄
    0x5DC5: 'diān',  # 巅
    0x5DC6: 'yíng,hōng',  # 巆
    0x5DC7: 'xī',  # 巇
    0x5DC8: 'jú',  # 巈
    0x5DC9: 'chán',  # 巉
    0x5DCA: 'yǐng',  # 巊
    0x5DCB: 'kuī',  # 巋
    0x5DCC: 'yán',  # 巌
    0x5DCD: 'wēi',  # 巍
    0x5DCE: 'náo',  # 巎
    0x5DCF: 'quán',  # 巏
    0x5DD0: 'chǎo',  # 巐
    0x5DD1: 'cuán',  # 巑
    0x5DD2: 'luán',  # 巒
    0x5DD3: 'diān',  # 巓
    0x5DD4: 'diān',  # 巔
    0x5DD5: 'niè',  # 巕
    0x5DD6: 'yán',  # 巖
    0x5DD7: 'yán',  # 巗
    0x5DD8: 'yǎn',  # 巘
    0x5DD9: 'kuí',  # 巙
    0x5DDA: 'yǎn',  # 巚
    0x5DDB: 'chuān',  # 巛
    0x5DDC: 'kuài',  # 巜
    0x5DDD: 'chuān',  # 川
    0x5DDE: 'zhōu',  # 州
    0x5DDF: 'huāng',  # 巟
    0x5DE0: 'jīng,xíng',  # 巠
    0x5DE1: 'xún',  # 巡
    0x5DE2: 'cháo',  # 巢
    0x5DE3: 'cháo',  # 巣
    0x5DE4: 'liè',  # 巤
    0x5DE5: 'gōng',  # 工
    0x5DE6: 'zuǒ',  # 左
    0x5DE7: 'qiǎo',  # 巧
    0x5DE8: 'jù',  # 巨
    0x5DE9: 'gǒng',  # 巩
    0x5DEA: 'jù',  # 巪
    0x5DEB: 'wū',  # 巫
    0x5DEC: 'gū',  # 巬
    0x5DED: 'gū',  # 巭
    0x5DEE: 'chà,chā,chāi,cī',  # 差
    0x5DEF: 'qiú',  # 巯
    0x5DF0: 'qiú',  # 巰
    0x5DF1: 'jǐ',  # 己
    0x5DF2: 'yǐ',  # 已
    0x5DF3: 'sì',  # 巳
    0x5DF4: 'bā',  # 巴
    0x5DF5: 'zhī',  # 巵
    0x5DF6: 'zhāo',  # 巶
    0x5DF7: 'xiàng,hàng',  # 巷
    0x5DF8: 'yí',  # 巸
    0x5DF9: 'jǐn',  # 巹
    0x5DFA: 'xùn',  # 巺
    0x5DFB: 'juàn,juǎn',  # 巻
    0x5DFC: 'phas',  # 巼
    0x5DFD: 'xùn',  # 巽
    0x5DFE: 'jīn',  # 巾
    0x5DFF: 'fú',  # 巿
    0x5E00: 'zā',  # 帀
    0x5E01: 'bì',  # 币
    0x5E02: 'shì',  # 市
    0x5E03: 'bù',  # 布
    0x5E04: 'dīng',  # 帄
    0x5E05: 'shuài',  # 帅
    0x5E06: 'fān',  # 帆
    0x5E07: 'niè',  # 帇
    0x5E08: 'shī',  # 师
    0x5E09: 'fēn',  # 帉
    0x5E0A: 'pà',  # 帊
    0x5E0B: 'zhǐ',  # 帋
    0x5E0C: 'xī',  # 希
    0x5E0D: 'hù',  # 帍
    0x5E0E: 'dàn',  # 帎
    0x5E0F: 'wéi',  # 帏
    0x5E10: 'zhàng',  # 帐
    0x5E11: 'tǎng,nú',  # 帑
    0x5E12: 'dài',  # 帒
    0x5E13: 'mò,wà',  # 帓
    0x5E14: 'pèi',  # 帔
    0x5E15: 'pà',  # 帕
    0x5E16: 'tiè,tiě,tiē',  # 帖
    0x5E17: 'fú',  # 帗
    0x5E18: 'lián',  # 帘
    0x5E19: 'zhì',  # 帙
    0x5E1A: 'zhǒu',  # 帚
    0x5E1B: 'bó',  # 帛
    0x5E1C: 'zhì',  # 帜
    0x5E1D: 'dì',  # 帝
    0x5E1E: 'mò',  # 帞
    0x5E1F: 'yì',  # 帟
    0x5E20: 'yì',  # 帠
    0x5E21: 'píng',  # 帡
    0x5E22: 'qià',  # 帢
    0x5E23: 'juàn,juǎn',  # 帣
    0x5E24: 'rú',  # 帤
    0x5E25: 'shuài',  # 帥
    0x5E26: 'dài',  # 带
    0x5E27: 'zhēn',  # 帧
    0x5E28: 'shuì',  # 帨
    0x5E29: 'qiāo',  # 帩
    0x5E2A: 'zhēn',  # 帪
    0x5E2B: 'shī',  # 師
    0x5E2C: 'qún',  # 帬
    0x5E2D: 'xí',  # 席
    0x5E2E: 'bāng',  # 帮
    0x5E2F: 'dài',  # 帯
    0x5E30: 'guī',  # 帰
    0x5E31: 'chóu,dào',  # 帱
    0x5E32: 'píng',  # 帲
    0x5E33: 'zhàng',  # 帳
    0x5E34: 'jiǎn,jiān,sàn',  # 帴
    0x5E35: 'wān',  # 帵
    0x5E36: 'dài',  # 帶
    0x5E37: 'wéi',  # 帷
    0x5E38: 'cháng',  # 常
    0x5E39: 'shà,qiè',  # 帹
    0x5E3A: 'qí,jì',  # 帺
    0x5E3B: 'zé',  # 帻
    0x5E3C: 'guó',  # 帼
    0x5E3D: 'mào',  # 帽
    0x5E3E: 'zhǔ',  # 帾
    0x5E3F: 'hóu',  # 帿
    0x5E40: 'zhēn',  # 幀
    0x5E41: 'zhèng',  # 幁
    0x5E42: 'mì',  # 幂
    0x5E43: 'wéi',  # 幃
    0x5E44: 'wò',  # 幄
    0x5E45: 'fú',  # 幅
    0x5E46: 'yì',  # 幆
    0x5E47: 'bāng',  # 幇
    0x5E48: 'píng',  # 幈
    0x5E49: 'dié',  # 幉
    0x5E4A: 'gōng',  # 幊
    0x5E4B: 'pán',  # 幋
    0x5E4C: 'huǎng',  # 幌
    0x5E4D: 'tāo',  # 幍
    0x5E4E: 'mì',  # 幎
    0x5E4F: 'jià',  # 幏
    0x5E50: 'téng',  # 幐
    0x5E51: 'huī',  # 幑
    0x5E52: 'zhōng',  # 幒
    0x5E53: 'shān,qiāo,shēn',  # 幓
    0x5E54: 'màn',  # 幔
    0x5E55: 'mù',  # 幕
    0x5E56: 'biāo',  # 幖
    0x5E57: 'guó',  # 幗
    0x5E58: 'zé',  # 幘
    0x5E59: 'mù',  # 幙
    0x5E5A: 'bāng',  # 幚
    0x5E5B: 'zhàng',  # 幛
    0x5E5C: 'jǐng',  # 幜
    0x5E5D: 'chǎn,chàn',  # 幝
    0x5E5E: 'fú',  # 幞
    0x5E5F: 'zhì',  # 幟
    0x5E60: 'hū',  # 幠
    0x5E61: 'fān',  # 幡
    0x5E62: 'chuáng,zhuàng',  # 幢
    0x5E63: 'bì',  # 幣
    0x5E64: 'bì',  # 幤
    0x5E65: 'zhǎng',  # 幥
    0x5E66: 'mì',  # 幦
    0x5E67: 'qiāo',  # 幧
    0x5E68: 'chān,chàn',  # 幨
    0x5E69: 'fén',  # 幩
    0x5E6A: 'méng',  # 幪
    0x5E6B: 'bāng',  # 幫
    0x5E6C: 'chóu,dào',  # 幬
    0x5E6D: 'miè',  # 幭
    0x5E6E: 'chú',  # 幮
    0x5E6F: 'jié',  # 幯
    0x5E70: 'xiǎn',  # 幰
    0x5E71: 'lán',  # 幱
    0x5E72: 'gān,gàn',  # 干
    0x5E73: 'píng',  # 平
    0x5E74: 'nián',  # 年
    0x5E75: 'jiān',  # 幵
    0x5E76: 'bìng,bīng',  # 并
    0x5E77: 'bìng,bīng',  # 幷
    0x5E78: 'xìng',  # 幸
    0x5E79: 'gàn',  # 幹
    0x5E7A: 'yāo',  # 幺
    0x5E7B: 'huàn',  # 幻
    0x5E7C: 'yòu',  # 幼
    0x5E7D: 'yōu',  # 幽
    0x5E7E: 'jī,jǐ',  # 幾
    0x5E7F: 'guǎng,ān',  # 广
    0x5E80: 'pǐ',  # 庀
    0x5E81: 'tīng',  # 庁
    0x5E82: 'zè',  # 庂
    0x5E83: 'guǎng',  # 広
    0x5E84: 'zhuāng',  # 庄
    0x5E85: 'mó,mā,me',  # 庅
    0x5E86: 'qìng',  # 庆
    0x5E87: 'bì',  # 庇
    0x5E88: 'qín',  # 庈
    0x5E89: 'dùn,tún',  # 庉
    0x5E8A: 'chuáng',  # 床
    0x5E8B: 'guǐ',  # 庋
    0x5E8C: 'yǎ',  # 庌
    0x5E8D: 'bài,tīng',  # 庍
    0x5E8E: 'jiè',  # 庎
    0x5E8F: 'xù',  # 序
    0x5E90: 'lú',  # 庐
    0x5E91: 'wǔ',  # 庑
    0x5E92: 'zhuāng',  # 庒
    0x5E93: 'kù',  # 库
    0x5E94: 'yīng,yìng',  # 应
    0x5E95: 'dǐ,de',  # 底
    0x5E96: 'páo',  # 庖
    0x5E97: 'diàn',  # 店
    0x5E98: 'yā',  # 庘
    0x5E99: 'miào',  # 庙
    0x5E9A: 'gēng',  # 庚
    0x5E9B: 'cì',  # 庛
    0x5E9C: 'fǔ',  # 府
    0x5E9D: 'tóng',  # 庝
    0x5E9E: 'páng',  # 庞
    0x5E9F: 'fèi',  # 废
    0x5EA0: 'xiáng',  # 庠
    0x5EA1: 'yǐ',  # 庡
    0x5EA2: 'zhì',  # 庢
    0x5EA3: 'tiāo',  # 庣
    0x5EA4: 'zhì',  # 庤
    0x5EA5: 'xiū',  # 庥
    0x5EA6: 'dù,duó',  # 度
    0x5EA7: 'zuò',  # 座
    0x5EA8: 'xiāo',  # 庨
    0x5EA9: 'tú',  # 庩
    0x5EAA: 'guǐ',  # 庪
    0x5EAB: 'kù',  # 庫
    0x5EAC: 'máng,méng,páng',  # 庬
    0x5EAD: 'tíng',  # 庭
    0x5EAE: 'yóu',  # 庮
    0x5EAF: 'bū',  # 庯
    0x5EB0: 'bìng,píng',  # 庰
    0x5EB1: 'chěng',  # 庱
    0x5EB2: 'lái',  # 庲
    0x5EB3: 'bēi',  # 庳
    0x5EB4: 'jī,cuò',  # 庴
    0x5EB5: 'ān',  # 庵
    0x5EB6: 'shù',  # 庶
    0x5EB7: 'kāng',  # 康
    0x5EB8: 'yōng',  # 庸
    0x5EB9: 'tuǒ',  # 庹
    0x5EBA: 'sōng',  # 庺
    0x5EBB: 'shù',  # 庻
    0x5EBC: 'qǐng',  # 庼
    0x5EBD: 'yù',  # 庽
    0x5EBE: 'yǔ',  # 庾
    0x5EBF: 'miào',  # 庿
    0x5EC0: 'sōu',  # 廀
    0x5EC1: 'cè',  # 廁
    0x5EC2: 'xiāng',  # 廂
    0x5EC3: 'fèi',  # 廃
    0x5EC4: 'jiù',  # 廄
    0x5EC5: 'è',  # 廅
    0x5EC6: 'guī,wěi,huì',  # 廆
    0x5EC7: 'liù',  # 廇
    0x5EC8: 'shà,xià',  # 廈
    0x5EC9: 'lián',  # 廉
    0x5ECA: 'láng',  # 廊
    0x5ECB: 'sōu',  # 廋
    0x5ECC: 'zhì',  # 廌
    0x5ECD: 'bù',  # 廍
    0x5ECE: 'qǐng',  # 廎
    0x5ECF: 'jiù',  # 廏
    0x5ED0: 'jiù',  # 廐
    0x5ED1: 'jǐn,qín',  # 廑
    0x5ED2: 'áo',  # 廒
    0x5ED3: 'kuò',  # 廓
    0x5ED4: 'lóu',  # 廔
    0x5ED5: 'yìn',  # 廕
    0x5ED6: 'liào',  # 廖
    0x5ED7: 'dài',  # 廗
    0x5ED8: 'lù',  # 廘
    0x5ED9: 'yì',  # 廙
    0x5EDA: 'chú',  # 廚
    0x5EDB: 'chán',  # 廛
    0x5EDC: 'tú',  # 廜
    0x5EDD: 'sī',  # 廝
    0x5EDE: 'xīn',  # 廞
    0x5EDF: 'miào',  # 廟
    0x5EE0: 'chǎng',  # 廠
    0x5EE1: 'wǔ',  # 廡
    0x5EE2: 'fèi',  # 廢
    0x5EE3: 'guǎng',  # 廣
    0x5EE4: 'kù',  # 廤
    0x5EE5: 'kuài',  # 廥
    0x5EE6: 'bì',  # 廦
    0x5EE7: 'qiáng,sè',  # 廧
    0x5EE8: 'xiè',  # 廨
    0x5EE9: 'lǐn',  # 廩
    0x5EEA: 'lǐn',  # 廪
    0x5EEB: 'liáo',  # 廫
    0x5EEC: 'lú',  # 廬
    0x5EED: 'jì',  # 廭
    0x5EEE: 'yǐng',  # 廮
    0x5EEF: 'xiān',  # 廯
    0x5EF0: 'tīng',  # 廰
    0x5EF1: 'yōng',  # 廱
    0x5EF2: 'lí',  # 廲
    0x5EF3: 'tīng',  # 廳
    0x5EF4: 'yǐn,yìn',  # 廴
    0x5EF5: 'xún',  # 廵
    0x5EF6: 'yán',  # 延
    0x5EF7: 'tíng',  # 廷
    0x5EF8: 'dí',  # 廸
    0x5EF9: 'pò,pǎi',  # 廹
    0x5EFA: 'jiàn',  # 建
    0x5EFB: 'huí',  # 廻
    0x5EFC: 'nǎi',  # 廼
    0x5EFD: 'huí',  # 廽
    0x5EFE: 'gǒng',  # 廾
    0x5EFF: 'niàn',  # 廿
    0x5F00: 'kāi',  # 开
    0x5F01: 'biàn',  # 弁
    0x5F02: 'yì',  # 异
    0x5F03: 'qì',  # 弃
    0x5F04: 'nòng,lòng',  # 弄
    0x5F05: 'fèn',  # 弅
    0x5F06: 'jǔ',  # 弆
    0x5F07: 'yǎn',  # 弇
    0x5F08: 'yì',  # 弈
    0x5F09: 'zàng',  # 弉
    0x5F0A: 'bì',  # 弊
    0x5F0B: 'yì',  # 弋
    0x5F0C: 'yī',  # 弌
    0x5F0D: 'èr',  # 弍
    0x5F0E: 'sān',  # 弎
    0x5F0F: 'shì',  # 式
    0x5F10: 'èr',  # 弐
    0x5F11: 'shì',  # 弑
    0x5F12: 'shì',  # 弒
    0x5F13: 'gōng',  # 弓
    0x5F14: 'diào',  # 弔
    0x5F15: 'yǐn',  # 引
    0x5F16: 'hù',  # 弖
    0x5F17: 'fú',  # 弗
    0x5F18: 'hóng',  # 弘
    0x5F19: 'wū',  # 弙
    0x5F1A: 'tuí',  # 弚
    0x5F1B: 'chí',  # 弛
    0x5F1C: 'jiàng',  # 弜
    0x5F1D: 'bà',  # 弝
    0x5F1E: 'shěn',  # 弞
    0x5F1F: 'dì,tì,tuí',  # 弟
    0x5F20: 'zhāng',  # 张
    0x5F21: 'jué,zhāng',  # 弡
    0x5F22: 'tāo',  # 弢
    0x5F23: 'fǔ',  # 弣
    0x5F24: 'dǐ',  # 弤
    0x5F25: 'mí,mǐ',  # 弥
    0x5F26: 'xián',  # 弦
    0x5F27: 'hú',  # 弧
    0x5F28: 'chāo',  # 弨
    0x5F29: 'nǔ',  # 弩
    0x5F2A: 'jìng',  # 弪
    0x5F2B: 'zhěn',  # 弫
    0x5F2C: 'yi',  # 弬
    0x5F2D: 'mǐ',  # 弭
    0x5F2E: 'juàn,quān',  # 弮
    0x5F2F: 'wān',  # 弯
    0x5F30: 'shāo',  # 弰
    0x5F31: 'ruò',  # 弱
    0x5F32: 'xuān,yuān',  # 弲
    0x5F33: 'jìng',  # 弳
    0x5F34: 'diāo',  # 弴
    0x5F35: 'zhāng',  # 張
    0x5F36: 'jiàng',  # 弶
    0x5F37: 'qiáng,qiǎng,jiàng',  # 強
    0x5F38: 'péng',  # 弸
    0x5F39: 'dàn,tán',  # 弹
    0x5F3A: 'qiáng,qiǎng,jiàng',  # 强
    0x5F3B: 'bì',  # 弻
    0x5F3C: 'bì',  # 弼
    0x5F3D: 'shè',  # 弽
    0x5F3E: 'dàn,tán',  # 弾
    0x5F3F: 'jiǎn',  # 弿
    0x5F40: 'gòu',  # 彀
    0x5F41: 'gē',  # 彁
    0x5F42: 'fā',  # 彂
    0x5F43: 'bì',  # 彃
    0x5F44: 'kōu',  # 彄
    0x5F45: 'jiǎn',  # 彅
    0x5F46: 'biè',  # 彆
    0x5F47: 'xiāo',  # 彇
    0x5F48: 'dàn,tán',  # 彈
    0x5F49: 'guō',  # 彉
    0x5F4A: 'qiáng,qiǎng,jiàng',  # 彊
    0x5F4B: 'hóng',  # 彋
    0x5F4C: 'mí,mǐ',  # 彌
    0x5F4D: 'guō',  # 彍
    0x5F4E: 'wān',  # 彎
    0x5F4F: 'jué',  # 彏
    0x5F50: 'jì,xuě',  # 彐
    0x5F51: 'jì',  # 彑
    0x5F52: 'guī',  # 归
    0x5F53: 'dāng,dàng',  # 当
    0x5F54: 'lù',  # 彔
    0x5F55: 'lù',  # 录
    0x5F56: 'tuàn',  # 彖
    0x5F57: 'huì',  # 彗
    0x5F58: 'zhì',  # 彘
    0x5F59: 'huì',  # 彙
    0x5F5A: 'huì',  # 彚
    0x5F5B: 'yí',  # 彛
    0x5F5C: 'yí',  # 彜
    0x5F5D: 'yí',  # 彝
    0x5F5E: 'yí',  # 彞
    0x5F5F: 'huò',  # 彟
    0x5F60: 'huò',  # 彠
    0x5F61: 'shān,xiǎn',  # 彡
    0x5F62: 'xíng',  # 形
    0x5F63: 'wén',  # 彣
    0x5F64: 'tóng',  # 彤
    0x5F65: 'yàn',  # 彥
    0x5F66: 'yàn',  # 彦
    0x5F67: 'yù',  # 彧
    0x5F68: 'chī',  # 彨
    0x5F69: 'cǎi',  # 彩
    0x5F6A: 'biāo',  # 彪
    0x5F6B: 'diāo',  # 彫
    0x5F6C: 'bīn',  # 彬
    0x5F6D: 'péng,bāng',  # 彭
    0x5F6E: 'yǒng',  # 彮
    0x5F6F: 'piāo,piào',  # 彯
    0x5F70: 'zhāng',  # 彰
    0x5F71: 'yǐng',  # 影
    0x5F72: 'chī',  # 彲
    0x5F73: 'chì',  # 彳
    0x5F74: 'zhuó,bó',  # 彴
    0x5F75: 'tuǒ,yí',  # 彵
    0x5F76: 'jí',  # 彶
    0x5F77: 'páng,fǎng',  # 彷
    0x5F78: 'zhōng',  # 彸
    0x5F79: 'yì',  # 役
    0x5F7A: 'wǎng',  # 彺
    0x5F7B: 'chè',  # 彻
    0x5F7C: 'bǐ',  # 彼
    0x5F7D: 'dī',  # 彽
    0x5F7E: 'líng',  # 彾
    0x5F7F: 'fù',  # 彿
    0x5F80: 'wǎng',  # 往
    0x5F81: 'zhēng',  # 征
    0x5F82: 'cú',  # 徂
    0x5F83: 'wǎng',  # 徃
    0x5F84: 'jìng',  # 径
    0x5F85: 'dài,dāi',  # 待
    0x5F86: 'xī',  # 徆
    0x5F87: 'xùn',  # 徇
    0x5F88: 'hěn',  # 很
    0x5F89: 'yáng',  # 徉
    0x5F8A: 'huái',  # 徊
    0x5F8B: 'lǜ',  # 律
    0x5F8C: 'hòu',  # 後
    0x5F8D: 'wàng,jiā,wā',  # 徍
    0x5F8E: 'chěng,zhèng',  # 徎
    0x5F8F: 'zhì',  # 徏
    0x5F90: 'xú',  # 徐
    0x5F91: 'jìng',  # 徑
    0x5F92: 'tú',  # 徒
    0x5F93: 'cóng',  # 従
    0x5F94: 'cóng',  # 徔
    0x5F95: 'lài,lái',  # 徕
    0x5F96: 'cóng',  # 徖
    0x5F97: 'dé,děi,de',  # 得
    0x5F98: 'pái',  # 徘
    0x5F99: 'xǐ',  # 徙
    0x5F9A: 'dōng',  # 徚
    0x5F9B: 'jì',  # 徛
    0x5F9C: 'cháng',  # 徜
    0x5F9D: 'zhì',  # 徝
    0x5F9E: 'cóng,zòng',  # 從
    0x5F9F: 'zhōu',  # 徟
    0x5FA0: 'lái,lài',  # 徠
    0x5FA1: 'yù',  # 御
    0x5FA2: 'xiè',  # 徢
    0x5FA3: 'jiè',  # 徣
    0x5FA4: 'jiàn',  # 徤
    0x5FA5: 'shì,tǐ',  # 徥
    0x5FA6: 'jiǎ,xiá',  # 徦
    0x5FA7: 'biàn',  # 徧
    0x5FA8: 'huáng',  # 徨
    0x5FA9: 'fù',  # 復
    0x5FAA: 'xún',  # 循
    0x5FAB: 'wěi',  # 徫
    0x5FAC: 'páng',  # 徬
    0x5FAD: 'yáo',  # 徭
    0x5FAE: 'wēi',  # 微
    0x5FAF: 'xī',  # 徯
    0x5FB0: 'zhēng',  # 徰
    0x5FB1: 'piào',  # 徱
    0x5FB2: 'tí,chí',  # 徲
    0x5FB3: 'dé',  # 徳
    0x5FB4: 'zhǐ,zhēng',  # 徴
    0x5FB5: 'zhǐ,zhēng',  # 徵
    0x5FB6: 'bié',  # 徶
    0x5FB7: 'dé',  # 德
    0x5FB8: 'zhǒng,chōng',  # 徸
    0x5FB9: 'chè',  # 徹
    0x5FBA: 'jiǎo,yáo',  # 徺
    0x5FBB: 'huì',  # 徻
    0x5FBC: 'jiǎo,jiào',  # 徼
    0x5FBD: 'huī',  # 徽
    0x5FBE: 'méi',  # 徾
    0x5FBF: 'lòng,lǒng',  # 徿
    0x5FC0: 'xiāng',  # 忀
    0x5FC1: 'bào',  # 忁
    0x5FC2: 'qú,jù',  # 忂
    0x5FC3: 'xīn',  # 心
    0x5FC4: 'xīn',  # 忄
    0x5FC5: 'bì',  # 必
    0x5FC6: 'yì',  # 忆
    0x5FC7: 'lè',  # 忇
    0x5FC8: 'rén',  # 忈
    0x5FC9: 'dāo',  # 忉
    0x5FCA: 'dìng,tìng',  # 忊
    0x5FCB: 'gǎi',  # 忋
    0x5FCC: 'jì',  # 忌
    0x5FCD: 'rěn',  # 忍
    0x5FCE: 'rén',  # 忎
    0x5FCF: 'chàn',  # 忏
    0x5FD0: 'tǎn',  # 忐
    0x5FD1: 'tè',  # 忑
    0x5FD2: 'tè,tuī',  # 忒
    0x5FD3: 'gān,hàn',  # 忓
    0x5FD4: 'yì,qì',  # 忔
    0x5FD5: 'shì,tài',  # 忕
    0x5FD6: 'cǔn',  # 忖
    0x5FD7: 'zhì',  # 志
    0x5FD8: 'wàng',  # 忘
    0x5FD9: 'máng',  # 忙
    0x5FDA: 'xī,liě',  # 忚
    0x5FDB: 'fān',  # 忛
    0x5FDC: 'yīng,yìng',  # 応
    0x5FDD: 'tiǎn',  # 忝
    0x5FDE: 'mǐn,wěn,mín',  # 忞
    0x5FDF: 'mǐn,wěn,mín',  # 忟
    0x5FE0: 'zhōng',  # 忠
    0x5FE1: 'chōng',  # 忡
    0x5FE2: 'wù',  # 忢
    0x5FE3: 'jí',  # 忣
    0x5FE4: 'wǔ',  # 忤
    0x5FE5: 'xì',  # 忥
    0x5FE6: 'jiá',  # 忦
    0x5FE7: 'yōu',  # 忧
    0x5FE8: 'wán',  # 忨
    0x5FE9: 'cōng',  # 忩
    0x5FEA: 'sōng,zhōng',  # 忪
    0x5FEB: 'kuài',  # 快
    0x5FEC: 'yù,shū',  # 忬
    0x5FED: 'biàn',  # 忭
    0x5FEE: 'zhì',  # 忮
    0x5FEF: 'qí,shì',  # 忯
    0x5FF0: 'cuì',  # 忰
    0x5FF1: 'chén',  # 忱
    0x5FF2: 'tài',  # 忲
    0x5FF3: 'tún,zhūn,dùn',  # 忳
    0x5FF4: 'qián,qín',  # 忴
    0x5FF5: 'niàn',  # 念
    0x5FF6: 'hún',  # 忶
    0x5FF7: 'xiōng',  # 忷
    0x5FF8: 'niǔ',  # 忸
    0x5FF9: 'kuáng,wǎng',  # 忹
    0x5FFA: 'xiān',  # 忺
    0x5FFB: 'xīn',  # 忻
    0x5FFC: 'kāng,hàng',  # 忼
    0x5FFD: 'hū',  # 忽
    0x5FFE: 'kài,xì',  # 忾
    0x5FFF: 'fèn',  # 忿
    0x6000: 'huái',  # 怀
    0x6001: 'tài',  # 态
    0x6002: 'sǒng',  # 怂
    0x6003: 'wǔ',  # 怃
    0x6004: 'òu',  # 怄
    0x6005: 'chàng',  # 怅
    0x6006: 'chuàng',  # 怆
    0x6007: 'jù',  # 怇
    0x6008: 'yì',  # 怈
    0x6009: 'bǎo,bào',  # 怉
    0x600A: 'chāo',  # 怊
    0x600B: 'mín,mén',  # 怋
    0x600C: 'pēi',  # 怌
    0x600D: 'zuò,zhà',  # 怍
    0x600E: 'zěn',  # 怎
    0x600F: 'yàng',  # 怏
    0x6010: 'kòu,jù',  # 怐
    0x6011: 'bàn',  # 怑
    0x6012: 'nù',  # 怒
    0x6013: 'náo,niú',  # 怓
    0x6014: 'zhēng',  # 怔
    0x6015: 'pà',  # 怕
    0x6016: 'bù',  # 怖
    0x6017: 'tiē,zhān',  # 怗
    0x6018: 'hù,gù',  # 怘
    0x6019: 'hù',  # 怙
    0x601A: 'cū,jù,zū',  # 怚
    0x601B: 'dá',  # 怛
    0x601C: 'lián',  # 怜
    0x601D: 'sī,sāi',  # 思
    0x601E: 'yóu,chóu',  # 怞
    0x601F: 'dì',  # 怟
    0x6020: 'dài',  # 怠
    0x6021: 'yí',  # 怡
    0x6022: 'tū,dié',  # 怢
    0x6023: 'yóu',  # 怣
    0x6024: 'fū',  # 怤
    0x6025: 'jí',  # 急
    0x6026: 'pēng',  # 怦
    0x6027: 'xìng',  # 性
    0x6028: 'yuàn',  # 怨
    0x6029: 'ní',  # 怩
    0x602A: 'guài',  # 怪
    0x602B: 'fú',  # 怫
    0x602C: 'xì',  # 怬
    0x602D: 'bì',  # 怭
    0x602E: 'yōu,yào',  # 怮
    0x602F: 'qiè',  # 怯
    0x6030: 'xuàn',  # 怰
    0x6031: 'cōng',  # 怱
    0x6032: 'bǐng',  # 怲
    0x6033: 'huǎng',  # 怳
    0x6034: 'xù,xuè',  # 怴
    0x6035: 'chù',  # 怵
    0x6036: 'bì,pī',  # 怶
    0x6037: 'shù',  # 怷
    0x6038: 'xī,shù',  # 怸
    0x6039: 'tān',  # 怹
    0x603A: 'yǒng',  # 怺
    0x603B: 'zǒng',  # 总
    0x603C: 'duì',  # 怼
    0x603D: 'mì',  # 怽
    0x603E: 'gi',  # 怾
    0x603F: 'yì',  # 怿
    0x6040: 'shì',  # 恀
    0x6041: 'nèn,nín',  # 恁
    0x6042: 'xún',  # 恂
    0x6043: 'shì',  # 恃
    0x6044: 'xì',  # 恄
    0x6045: 'lǎo',  # 恅
    0x6046: 'héng',  # 恆
    0x6047: 'kuāng',  # 恇
    0x6048: 'móu',  # 恈
    0x6049: 'zhǐ',  # 恉
    0x604A: 'xié',  # 恊
    0x604B: 'liàn',  # 恋
    0x604C: 'tiāo,yáo',  # 恌
    0x604D: 'huǎng',  # 恍
    0x604E: 'dié',  # 恎
    0x604F: 'hào',  # 恏
    0x6050: 'kǒng',  # 恐
    0x6051: 'guǐ',  # 恑
    0x6052: 'héng',  # 恒
    0x6053: 'xī,qī,xù',  # 恓
    0x6054: 'xiào,jiǎo',  # 恔
    0x6055: 'shù',  # 恕
    0x6056: 'sī',  # 恖
    0x6057: 'hū,kuā',  # 恗
    0x6058: 'qiū',  # 恘
    0x6059: 'yàng',  # 恙
    0x605A: 'huì',  # 恚
    0x605B: 'huí',  # 恛
    0x605C: 'chì',  # 恜
    0x605D: 'jiá',  # 恝
    0x605E: 'yí',  # 恞
    0x605F: 'xiōng',  # 恟
    0x6060: 'guài',  # 恠
    0x6061: 'lìn',  # 恡
    0x6062: 'huī',  # 恢
    0x6063: 'zì',  # 恣
    0x6064: 'xù',  # 恤
    0x6065: 'chǐ',  # 恥
    0x6066: 'shàng',  # 恦
    0x6067: 'nǜ',  # 恧
    0x6068: 'hèn',  # 恨
    0x6069: 'ēn',  # 恩
    0x606A: 'kè',  # 恪
    0x606B: 'dòng',  # 恫
    0x606C: 'tián',  # 恬
    0x606D: 'gōng',  # 恭
    0x606E: 'quán,zhuān',  # 恮
    0x606F: 'xī',  # 息
    0x6070: 'qià',  # 恰
    0x6071: 'yuè',  # 恱
    0x6072: 'pēng',  # 恲
    0x6073: 'kěn',  # 恳
    0x6074: 'dé',  # 恴
    0x6075: 'huì',  # 恵
    0x6076: 'è,wù,ě,wū',  # 恶
    0x6077: 'qiū',  # 恷
    0x6078: 'tòng',  # 恸
    0x6079: 'yān',  # 恹
    0x607A: 'kǎi',  # 恺
    0x607B: 'cè',  # 恻
    0x607C: 'nǎo',  # 恼
    0x607D: 'yùn',  # 恽
    0x607E: 'máng',  # 恾
    0x607F: 'yǒng',  # 恿
    0x6080: 'yǒng',  # 悀
    0x6081: 'yuān,juàn',  # 悁
    0x6082: 'pī,pǐ',  # 悂
    0x6083: 'kǔn',  # 悃
    0x6084: 'qiǎo,qiāo',  # 悄
    0x6085: 'yuè',  # 悅
    0x6086: 'yù,shū',  # 悆
    0x6087: 'tú',  # 悇
    0x6088: 'jiè,kè',  # 悈
    0x6089: 'xī',  # 悉
    0x608A: 'zhé',  # 悊
    0x608B: 'lìn',  # 悋
    0x608C: 'tì',  # 悌
    0x608D: 'hàn',  # 悍
    0x608E: 'hào,jiào',  # 悎
    0x608F: 'qiè',  # 悏
    0x6090: 'tì',  # 悐
    0x6091: 'bù',  # 悑
    0x6092: 'yì',  # 悒
    0x6093: 'qiàn',  # 悓
    0x6094: 'huǐ',  # 悔
    0x6095: 'xī',  # 悕
    0x6096: 'bèi',  # 悖
    0x6097: 'mán,mèn',  # 悗
    0x6098: 'yī,yì',  # 悘
    0x6099: 'hēng,hèng',  # 悙
    0x609A: 'sǒng',  # 悚
    0x609B: 'quān',  # 悛
    0x609C: 'chěng',  # 悜
    0x609D: 'kuī,lǐ',  # 悝
    0x609E: 'wù',  # 悞
    0x609F: 'wù',  # 悟
    0x60A0: 'yōu',  # 悠
    0x60A1: 'lí',  # 悡
    0x60A2: 'liàng',  # 悢
    0x60A3: 'huàn',  # 患
    0x60A4: 'cōng',  # 悤
    0x60A5: 'yì,niàn',  # 悥
    0x60A6: 'yuè',  # 悦
    0x60A7: 'lì',  # 悧
    0x60A8: 'nín',  # 您
    0x60A9: 'nǎo',  # 悩
    0x60AA: 'è',  # 悪
    0x60AB: 'què',  # 悫
    0x60AC: 'xuán',  # 悬
    0x60AD: 'qiān',  # 悭
    0x60AE: 'wù',  # 悮
    0x60AF: 'mǐn',  # 悯
    0x60B0: 'cóng',  # 悰
    0x60B1: 'fěi',  # 悱
    0x60B2: 'bēi',  # 悲
    0x60B3: 'dé',  # 悳
    0x60B4: 'cuì',  # 悴
    0x60B5: 'chàng',  # 悵
    0x60B6: 'mèn,mēn',  # 悶
    0x60B7: 'lì',  # 悷
    0x60B8: 'jì',  # 悸
    0x60B9: 'guàn',  # 悹
    0x60BA: 'guàn',  # 悺
    0x60BB: 'xìng',  # 悻
    0x60BC: 'dào',  # 悼
    0x60BD: 'qī',  # 悽
    0x60BE: 'kōng,kǒng',  # 悾
    0x60BF: 'tiǎn',  # 悿
    0x60C0: 'lǔn,lùn',  # 惀
    0x60C1: 'xī',  # 惁
    0x60C2: 'kǎn',  # 惂
    0x60C3: 'gǔn',  # 惃
    0x60C4: 'nì',  # 惄
    0x60C5: 'qíng',  # 情
    0x60C6: 'chóu',  # 惆
    0x60C7: 'dūn',  # 惇
    0x60C8: 'guǒ',  # 惈
    0x60C9: 'zhān',  # 惉
    0x60CA: 'jīng',  # 惊
    0x60CB: 'wǎn',  # 惋
    0x60CC: 'yuān,wǎn',  # 惌
    0x60CD: 'jīn',  # 惍
    0x60CE: 'jì',  # 惎
    0x60CF: 'lán,lín',  # 惏
    0x60D0: 'yù,xù',  # 惐
    0x60D1: 'huò',  # 惑
    0x60D2: 'hé,hè',  # 惒
    0x60D3: 'juàn,quán',  # 惓
    0x60D4: 'tán,dàn',  # 惔
    0x60D5: 'tì',  # 惕
    0x60D6: 'tì',  # 惖
    0x60D7: 'niàn',  # 惗
    0x60D8: 'wǎng',  # 惘
    0x60D9: 'chuò,chuì',  # 惙
    0x60DA: 'hū',  # 惚
    0x60DB: 'hūn,mèn',  # 惛
    0x60DC: 'xī',  # 惜
    0x60DD: 'chǎng',  # 惝
    0x60DE: 'xīn',  # 惞
    0x60DF: 'wéi',  # 惟
    0x60E0: 'huì',  # 惠
    0x60E1: 'è,wù,ě,wū',  # 惡
    0x60E2: 'suǒ,ruǐ',  # 惢
    0x60E3: 'zǒng',  # 惣
    0x60E4: 'jiān',  # 惤
    0x60E5: 'yǒng',  # 惥
    0x60E6: 'diàn',  # 惦
    0x60E7: 'jù',  # 惧
    0x60E8: 'cǎn',  # 惨
    0x60E9: 'chéng',  # 惩
    0x60EA: 'dé',  # 惪
    0x60EB: 'bèi',  # 惫
    0x60EC: 'qiè',  # 惬
    0x60ED: 'cán',  # 惭
    0x60EE: 'dàn,dá',  # 惮
    0x60EF: 'guàn',  # 惯
    0x60F0: 'duò',  # 惰
    0x60F1: 'nǎo',  # 惱
    0x60F2: 'yùn',  # 惲
    0x60F3: 'xiǎng',  # 想
    0x60F4: 'zhuì',  # 惴
    0x60F5: 'dié',  # 惵
    0x60F6: 'huáng',  # 惶
    0x60F7: 'chǔn',  # 惷
    0x60F8: 'qióng',  # 惸
    0x60F9: 'rě',  # 惹
    0x60FA: 'xīng',  # 惺
    0x60FB: 'cè',  # 惻
    0x60FC: 'biǎn',  # 惼
    0x60FD: 'mǐn',  # 惽
    0x60FE: 'zōng',  # 惾
    0x60FF: 'tí,shì',  # 惿
    0x6100: 'qiǎo',  # 愀
    0x6101: 'chóu',  # 愁
    0x6102: 'bèi',  # 愂
    0x6103: 'xuān',  # 愃
    0x6104: 'wēi',  # 愄
    0x6105: 'gé',  # 愅
    0x6106: 'qiān',  # 愆
    0x6107: 'wěi',  # 愇
    0x6108: 'yù',  # 愈
    0x6109: 'yú,tōu',  # 愉
    0x610A: 'bì',  # 愊
    0x610B: 'xuān',  # 愋
    0x610C: 'huàn',  # 愌
    0x610D: 'mǐn',  # 愍
    0x610E: 'bì',  # 愎
    0x610F: 'yì',  # 意
    0x6110: 'miǎn',  # 愐
    0x6111: 'yǒng',  # 愑
    0x6112: 'qì,kài',  # 愒
    0x6113: 'dàng,shāng,táng,yáng',  # 愓
    0x6114: 'yīn',  # 愔
    0x6115: 'è',  # 愕
    0x6116: 'chén,xìn,dān',  # 愖
    0x6117: 'mào',  # 愗
    0x6118: 'kè,qià',  # 愘
    0x6119: 'kè',  # 愙
    0x611A: 'yú',  # 愚
    0x611B: 'ài',  # 愛
    0x611C: 'qiè',  # 愜
    0x611D: 'yǎn',  # 愝
    0x611E: 'nuò',  # 愞
    0x611F: 'gǎn',  # 感
    0x6120: 'yùn',  # 愠
    0x6121: 'còng,sōng',  # 愡
    0x6122: 'sāi,sī,sǐ',  # 愢
    0x6123: 'lèng',  # 愣
    0x6124: 'fèn',  # 愤
    0x6125: 'yīng',  # 愥
    0x6126: 'kuì',  # 愦
    0x6127: 'kuì',  # 愧
    0x6128: 'què',  # 愨
    0x6129: 'gōng,gòng,hǒng',  # 愩
    0x612A: 'yún',  # 愪
    0x612B: 'sù',  # 愫
    0x612C: 'sù,shuò',  # 愬
    0x612D: 'qí',  # 愭
    0x612E: 'yáo,yào',  # 愮
    0x612F: 'sǒng',  # 愯
    0x6130: 'huàng',  # 愰
    0x6131: 'jí',  # 愱
    0x6132: 'gǔ',  # 愲
    0x6133: 'jù',  # 愳
    0x6134: 'chuàng',  # 愴
    0x6135: 'nì',  # 愵
    0x6136: 'xié',  # 愶
    0x6137: 'kǎi',  # 愷
    0x6138: 'zhěng',  # 愸
    0x6139: 'yǒng',  # 愹
    0x613A: 'cǎo',  # 愺
    0x613B: 'xùn',  # 愻
    0x613C: 'shèn',  # 愼
    0x613D: 'bó',  # 愽
    0x613E: 'kài,xì',  # 愾
    0x613F: 'yuàn',  # 愿
    0x6140: 'xì,xié',  # 慀
    0x6141: 'hùn',  # 慁
    0x6142: 'yǒng',  # 慂
    0x6143: 'yǎng',  # 慃
    0x6144: 'lì',  # 慄
    0x6145: 'cǎo,sāo',  # 慅
    0x6146: 'tāo',  # 慆
    0x6147: 'yīn',  # 慇
    0x6148: 'cí',  # 慈
    0x6149: 'xù,chù',  # 慉
    0x614A: 'qiàn,qiè',  # 慊
    0x614B: 'tài',  # 態
    0x614C: 'huāng',  # 慌
    0x614D: 'yùn',  # 慍
    0x614E: 'shèn',  # 慎
    0x614F: 'mǐng',  # 慏
    0x6150: 'gōng,gòng,hǒng',  # 慐
    0x6151: 'shè',  # 慑
    0x6152: 'cáo,cóng',  # 慒
    0x6153: 'piāo',  # 慓
    0x6154: 'mù',  # 慔
    0x6155: 'mù',  # 慕
    0x6156: 'guó',  # 慖
    0x6157: 'chì',  # 慗
    0x6158: 'cǎn',  # 慘
    0x6159: 'cán',  # 慙
    0x615A: 'cán',  # 慚
    0x615B: 'cuī',  # 慛
    0x615C: 'mín',  # 慜
    0x615D: 'tè',  # 慝
    0x615E: 'zhāng',  # 慞
    0x615F: 'tòng',  # 慟
    0x6160: 'ào,áo',  # 慠
    0x6161: 'shuǎng',  # 慡
    0x6162: 'màn',  # 慢
    0x6163: 'guàn',  # 慣
    0x6164: 'què',  # 慤
    0x6165: 'zào',  # 慥
    0x6166: 'jiù',  # 慦
    0x6167: 'huì',  # 慧
    0x6168: 'kǎi',  # 慨
    0x6169: 'lián,liǎn',  # 慩
    0x616A: 'òu',  # 慪
    0x616B: 'sǒng',  # 慫
    0x616C: 'qín,jìn,jǐn',  # 慬
    0x616D: 'yìn',  # 慭
    0x616E: 'lǜ',  # 慮
    0x616F: 'shāng',  # 慯
    0x6170: 'wèi',  # 慰
    0x6171: 'tuán',  # 慱
    0x6172: 'mán',  # 慲
    0x6173: 'qiān',  # 慳
    0x6174: 'shè',  # 慴
    0x6175: 'yōng',  # 慵
    0x6176: 'qìng',  # 慶
    0x6177: 'kāng',  # 慷
    0x6178: 'dì,chì',  # 慸
    0x6179: 'zhí,zhé',  # 慹
    0x617A: 'lóu,lǚ',  # 慺
    0x617B: 'juàn',  # 慻
    0x617C: 'qī',  # 慼
    0x617D: 'qī',  # 慽
    0x617E: 'yù',  # 慾
    0x617F: 'píng',  # 慿
    0x6180: 'liáo',  # 憀
    0x6181: 'còng',  # 憁
    0x6182: 'yōu',  # 憂
    0x6183: 'chōng',  # 憃
    0x6184: 'zhī,zhì',  # 憄
    0x6185: 'tòng',  # 憅
    0x6186: 'chēng',  # 憆
    0x6187: 'qì',  # 憇
    0x6188: 'qū',  # 憈
    0x6189: 'péng',  # 憉
    0x618A: 'bèi',  # 憊
    0x618B: 'biē',  # 憋
    0x618C: 'qióng',  # 憌
    0x618D: 'jiāo',  # 憍
    0x618E: 'zēng',  # 憎
    0x618F: 'chì',  # 憏
    0x6190: 'lián',  # 憐
    0x6191: 'píng',  # 憑
    0x6192: 'kuì',  # 憒
    0x6193: 'huì',  # 憓
    0x6194: 'qiáo',  # 憔
    0x6195: 'chéng,dèng,zhèng',  # 憕
    0x6196: 'yìn',  # 憖
    0x6197: 'yìn',  # 憗
    0x6198: 'xǐ,xī',  # 憘
    0x6199: 'xǐ',  # 憙
    0x619A: 'dàn,dá',  # 憚
    0x619B: 'tán',  # 憛
    0x619C: 'duò',  # 憜
    0x619D: 'duì',  # 憝
    0x619E: 'duì,dùn,tūn',  # 憞
    0x619F: 'sù',  # 憟
    0x61A0: 'jué',  # 憠
    0x61A1: 'cè',  # 憡
    0x61A2: 'xiāo,jiāo',  # 憢
    0x61A3: 'fān',  # 憣
    0x61A4: 'fèn',  # 憤
    0x61A5: 'láo',  # 憥
    0x61A6: 'lào,láo',  # 憦
    0x61A7: 'chōng',  # 憧
    0x61A8: 'hān',  # 憨
    0x61A9: 'qì',  # 憩
    0x61AA: 'xián,xiàn',  # 憪
    0x61AB: 'mǐn',  # 憫
    0x61AC: 'jǐng',  # 憬
    0x61AD: 'liǎo,liáo',  # 憭
    0x61AE: 'wǔ',  # 憮
    0x61AF: 'cǎn',  # 憯
    0x61B0: 'jué',  # 憰
    0x61B1: 'cù',  # 憱
    0x61B2: 'xiàn',  # 憲
    0x61B3: 'tǎn',  # 憳
    0x61B4: 'shéng',  # 憴
    0x61B5: 'pī',  # 憵
    0x61B6: 'yì',  # 憶
    0x61B7: 'chù',  # 憷
    0x61B8: 'xiān',  # 憸
    0x61B9: 'náo,nǎo,náng',  # 憹
    0x61BA: 'dàn',  # 憺
    0x61BB: 'tǎn',  # 憻
    0x61BC: 'jǐng,jìng',  # 憼
    0x61BD: 'sōng',  # 憽
    0x61BE: 'hàn',  # 憾
    0x61BF: 'jiǎo,jǐ',  # 憿
    0x61C0: 'wèi',  # 懀
    0x61C1: 'xuān,huān',  # 懁
    0x61C2: 'dǒng',  # 懂
    0x61C3: 'qín',  # 懃
    0x61C4: 'qín',  # 懄
    0x61C5: 'jù',  # 懅
    0x61C6: 'cǎo,sāo,sào',  # 懆
    0x61C7: 'kěn',  # 懇
    0x61C8: 'xiè',  # 懈
    0x61C9: 'yīng,yìng',  # 應
    0x61CA: 'ào',  # 懊
    0x61CB: 'mào',  # 懋
    0x61CC: 'yì',  # 懌
    0x61CD: 'lǐn',  # 懍
    0x61CE: 'sè',  # 懎
    0x61CF: 'jùn',  # 懏
    0x61D0: 'huái',  # 懐
    0x61D1: 'mèn',  # 懑
    0x61D2: 'lǎn',  # 懒
    0x61D3: 'ài',  # 懓
    0x61D4: 'lǐn',  # 懔
    0x61D5: 'yān',  # 懕
    0x61D6: 'guō',  # 懖
    0x61D7: 'xià',  # 懗
    0x61D8: 'chì',  # 懘
    0x61D9: 'yǔ,yú',  # 懙
    0x61DA: 'yìn',  # 懚
    0x61DB: 'dāi',  # 懛
    0x61DC: 'mèng,méng,měng',  # 懜
    0x61DD: 'ài,yì,nǐ',  # 懝
    0x61DE: 'méng,měng',  # 懞
    0x61DF: 'duì',  # 懟
    0x61E0: 'qí,jī,jì',  # 懠
    0x61E1: 'mǒ',  # 懡
    0x61E2: 'lán,xiàn',  # 懢
    0x61E3: 'mèn',  # 懣
    0x61E4: 'chóu',  # 懤
    0x61E5: 'zhì',  # 懥
    0x61E6: 'nuò',  # 懦
    0x61E7: 'nuò',  # 懧
    0x61E8: 'yān',  # 懨
    0x61E9: 'yǎng',  # 懩
    0x61EA: 'bó',  # 懪
    0x61EB: 'zhì',  # 懫
    0x61EC: 'kuàng',  # 懬
    0x61ED: 'kuǎng',  # 懭
    0x61EE: 'yōu,yǒu',  # 懮
    0x61EF: 'fū',  # 懯
    0x61F0: 'liú,liǔ',  # 懰
    0x61F1: 'miè',  # 懱
    0x61F2: 'chéng',  # 懲
    0x61F3: 'huì',  # 懳
    0x61F4: 'chàn',  # 懴
    0x61F5: 'měng',  # 懵
    0x61F6: 'lǎn',  # 懶
    0x61F7: 'huái',  # 懷
    0x61F8: 'xuán',  # 懸
    0x61F9: 'ràng',  # 懹
    0x61FA: 'chàn',  # 懺
    0x61FB: 'jì',  # 懻
    0x61FC: 'jù',  # 懼
    0x61FD: 'huān',  # 懽
    0x61FE: 'shè',  # 懾
    0x61FF: 'yì',  # 懿
    0x6200: 'liàn',  # 戀
    0x6201: 'nǎn',  # 戁
    0x6202: 'mí,mó',  # 戂
    0x6203: 'tǎng',  # 戃
    0x6204: 'jué',  # 戄
    0x6205: 'gàng,zhuàng',  # 戅
    0x6206: 'gàng,zhuàng',  # 戆
    0x6207: 'gàng,zhuàng',  # 戇
    0x6208: 'gē',  # 戈
    0x6209: 'yuè',  # 戉
    0x620A: 'wù',  # 戊
    0x620B: 'jiān',  # 戋
    0x620C: 'xū',  # 戌
    0x620D: 'shù',  # 戍
    0x620E: 'róng',  # 戎
    0x620F: 'xì,hū',  # 戏
    0x6210: 'chéng',  # 成
    0x6211: 'wǒ',  # 我
    0x6212: 'jiè',  # 戒
    0x6213: 'gē',  # 戓
    0x6214: 'jiān',  # 戔
    0x6215: 'qiāng',  # 戕
    0x6216: 'huò',  # 或
    0x6217: 'qiāng,qiàng',  # 戗
    0x6218: 'zhàn',  # 战
    0x6219: 'dòng',  # 戙
    0x621A: 'qī',  # 戚
    0x621B: 'jiá',  # 戛
    0x621C: 'dié',  # 戜
    0x621D: 'zéi',  # 戝
    0x621E: 'jiá',  # 戞
    0x621F: 'jǐ',  # 戟
    0x6220: 'zhí',  # 戠
    0x6221: 'kān',  # 戡
    0x6222: 'jí',  # 戢
    0x6223: 'kuí',  # 戣
    0x6224: 'gài',  # 戤
    0x6225: 'děng',  # 戥
    0x6226: 'zhàn',  # 戦
    0x6227: 'qiāng,qiàng',  # 戧
    0x6228: 'gē',  # 戨
    0x6229: 'jiǎn',  # 戩
    0x622A: 'jié',  # 截
    0x622B: 'yù',  # 戫
    0x622C: 'jiǎn',  # 戬
    0x622D: 'yǎn',  # 戭
    0x622E: 'lù',  # 戮
    0x622F: 'xì,hū',  # 戯
    0x6230: 'zhàn',  # 戰
    0x6231: 'xì,hū',  # 戱
    0x6232: 'xì,hū',  # 戲
    0x6233: 'chuō',  # 戳
    0x6234: 'dài',  # 戴
    0x6235: 'qú',  # 戵
    0x6236: 'hù',  # 戶
    0x6237: 'hù',  # 户
    0x6238: 'hù',  # 戸
    0x6239: 'è',  # 戹
    0x623A: 'shì',  # 戺
    0x623B: 'tì',  # 戻
    0x623C: 'mǎo',  # 戼
    0x623D: 'hù',  # 戽
    0x623E: 'lì',  # 戾
    0x623F: 'fáng',  # 房
    0x6240: 'suǒ',  # 所
    0x6241: 'biǎn,piān',  # 扁
    0x6242: 'diàn',  # 扂
    0x6243: 'jiōng',  # 扃
    0x6244: 'shǎng,jiōng',  # 扄
    0x6245: 'yí',  # 扅
    0x6246: 'yǐ',  # 扆
    0x6247: 'shàn,shān',  # 扇
    0x6248: 'hù',  # 扈
    0x6249: 'fēi',  # 扉
    0x624A: 'yǎn',  # 扊
    0x624B: 'shǒu',  # 手
    0x624C: 'shǒu',  # 扌
    0x624D: 'cái',  # 才
    0x624E: 'zā,zhā,zhá',  # 扎
    0x624F: 'qiú',  # 扏
    0x6250: 'lè,lì,cái',  # 扐
    0x6251: 'pū',  # 扑
    0x6252: 'bā,pá',  # 扒
    0x6253: 'dǎ,dá',  # 打
    0x6254: 'rēng',  # 扔
    0x6255: 'fǎn,fú',  # 払
    0x6256: 'rù',  # 扖
    0x6257: 'zài',  # 扗
    0x6258: 'tuō',  # 托
    0x6259: 'zhàng',  # 扙
    0x625A: 'diǎo,dí,yuē,lì',  # 扚
    0x625B: 'káng,gāng',  # 扛
    0x625C: 'yū,wū',  # 扜
    0x625D: 'yū,wū,kū',  # 扝
    0x625E: 'hàn',  # 扞
    0x625F: 'shēn',  # 扟
    0x6260: 'chā',  # 扠
    0x6261: 'tuō,chǐ,yǐ',  # 扡
    0x6262: 'gǔ,xì,gē,jié',  # 扢
    0x6263: 'kòu',  # 扣
    0x6264: 'wù',  # 扤
    0x6265: 'dèn',  # 扥
    0x6266: 'qiān',  # 扦
    0x6267: 'zhí',  # 执
    0x6268: 'rèn',  # 扨
    0x6269: 'kuò',  # 扩
    0x626A: 'mén',  # 扪
    0x626B: 'sǎo,sào',  # 扫
    0x626C: 'yáng',  # 扬
    0x626D: 'niǔ',  # 扭
    0x626E: 'bàn',  # 扮
    0x626F: 'chě',  # 扯
    0x6270: 'rǎo',  # 扰
    0x6271: 'xī,chā,qì',  # 扱
    0x6272: 'qián,qín',  # 扲
    0x6273: 'bān',  # 扳
    0x6274: 'jiá',  # 扴
    0x6275: 'yú',  # 扵
    0x6276: 'fú',  # 扶
    0x6277: 'bā,ào',  # 扷
    0x6278: 'xī,zhé',  # 扸
    0x6279: 'pī',  # 批
    0x627A: 'zhǐ',  # 扺
    0x627B: 'zhì,sǔn,kǎn',  # 扻
    0x627C: 'è',  # 扼
    0x627D: 'dèn',  # 扽
    0x627E: 'zhǎo',  # 找
    0x627F: 'chéng',  # 承
    0x6280: 'jì',  # 技
    0x6281: 'yǎn',  # 抁
    0x6282: 'kuáng,wǎng,zài',  # 抂
    0x6283: 'biàn',  # 抃
    0x6284: 'chāo',  # 抄
    0x6285: 'jū',  # 抅
    0x6286: 'wěn',  # 抆
    0x6287: 'hú,gǔ',  # 抇
    0x6288: 'yuè',  # 抈
    0x6289: 'jué',  # 抉
    0x628A: 'bǎ,bà',  # 把
    0x628B: 'qìn',  # 抋
    0x628C: 'dǎn,shěn',  # 抌
    0x628D: 'zhěng',  # 抍
    0x628E: 'yǔn',  # 抎
    0x628F: 'wán',  # 抏
    0x6290: 'nè,nì,ruì,nà',  # 抐
    0x6291: 'yì',  # 抑
    0x6292: 'shū',  # 抒
    0x6293: 'zhuā',  # 抓
    0x6294: 'póu',  # 抔
    0x6295: 'tóu',  # 投
    0x6296: 'dǒu',  # 抖
    0x6297: 'kàng',  # 抗
    0x6298: 'zhē,zhé,shé',  # 折
    0x6299: 'póu,pōu,fū',  # 抙
    0x629A: 'fǔ',  # 抚
    0x629B: 'pāo',  # 抛
    0x629C: 'bá',  # 抜
    0x629D: 'ǎo,ào,niù',  # 抝
    0x629E: 'zé',  # 択
    0x629F: 'tuán',  # 抟
    0x62A0: 'kōu',  # 抠
    0x62A1: 'lūn,lún',  # 抡
    0x62A2: 'qiāng,qiǎng,chēng',  # 抢
    0x62A3: 'yún',  # 抣
    0x62A4: 'hù',  # 护
    0x62A5: 'bào',  # 报
    0x62A6: 'bǐng',  # 抦
    0x62A7: 'zhǐ,zhǎi',  # 抧
    0x62A8: 'pēng',  # 抨
    0x62A9: 'nán',  # 抩
    0x62AA: 'bù,pū',  # 抪
    0x62AB: 'pī',  # 披
    0x62AC: 'tái',  # 抬
    0x62AD: 'yǎo,tāo',  # 抭
    0x62AE: 'zhěn',  # 抮
    0x62AF: 'zhā',  # 抯
    0x62B0: 'yāng',  # 抰
    0x62B1: 'bào',  # 抱
    0x62B2: 'hē,hè,qiā',  # 抲
    0x62B3: 'nǐ,ní',  # 抳
    0x62B4: 'yè',  # 抴
    0x62B5: 'dǐ',  # 抵
    0x62B6: 'chì',  # 抶
    0x62B7: 'pī,pēi',  # 抷
    0x62B8: 'jiā',  # 抸
    0x62B9: 'mǒ,mò,mā',  # 抹
    0x62BA: 'mèi',  # 抺
    0x62BB: 'chēn',  # 抻
    0x62BC: 'yā',  # 押
    0x62BD: 'chōu',  # 抽
    0x62BE: 'qū',  # 抾
    0x62BF: 'mǐn',  # 抿
    0x62C0: 'zhù',  # 拀
    0x62C1: 'jiā,yá',  # 拁
    0x62C2: 'fú,bì',  # 拂
    0x62C3: 'zhǎ',  # 拃
    0x62C4: 'zhǔ',  # 拄
    0x62C5: 'dān,dàn,dǎn',  # 担
    0x62C6: 'chāi,cā',  # 拆
    0x62C7: 'mǔ',  # 拇
    0x62C8: 'niān',  # 拈
    0x62C9: 'lā,lá',  # 拉
    0x62CA: 'fǔ',  # 拊
    0x62CB: 'pāo',  # 拋
    0x62CC: 'bàn,pàn',  # 拌
    0x62CD: 'pāi',  # 拍
    0x62CE: 'līn',  # 拎
    0x62CF: 'ná',  # 拏
    0x62D0: 'guǎi',  # 拐
    0x62D1: 'qián',  # 拑
    0x62D2: 'jù',  # 拒
    0x62D3: 'tuò,tà,zhí',  # 拓
    0x62D4: 'bá',  # 拔
    0x62D5: 'tuō',  # 拕
    0x62D6: 'tuō',  # 拖
    0x62D7: 'ǎo,ào,niù',  # 拗
    0x62D8: 'jū,gōu',  # 拘
    0x62D9: 'zhuō',  # 拙
    0x62DA: 'pàn,pīn,fān',  # 拚
    0x62DB: 'zhāo',  # 招
    0x62DC: 'bài',  # 拜
    0x62DD: 'bài',  # 拝
    0x62DE: 'dǐ',  # 拞
    0x62DF: 'nǐ',  # 拟
    0x62E0: 'jù',  # 拠
    0x62E1: 'kuò',  # 拡
    0x62E2: 'lǒng',  # 拢
    0x62E3: 'jiǎn',  # 拣
    0x62E4: 'qiǎ',  # 拤
    0x62E5: 'yōng',  # 拥
    0x62E6: 'lán',  # 拦
    0x62E7: 'níng,nǐng,nìng',  # 拧
    0x62E8: 'bō',  # 拨
    0x62E9: 'zé,zhái',  # 择
    0x62EA: 'qiān',  # 拪
    0x62EB: 'hén',  # 拫
    0x62EC: 'kuò,guā',  # 括
    0x62ED: 'shì',  # 拭
    0x62EE: 'jié,jiá',  # 拮
    0x62EF: 'zhěng',  # 拯
    0x62F0: 'nǐn',  # 拰
    0x62F1: 'gǒng',  # 拱
    0x62F2: 'gǒng',  # 拲
    0x62F3: 'quán',  # 拳
    0x62F4: 'shuān',  # 拴
    0x62F5: 'cún,zùn',  # 拵
    0x62F6: 'zā,zǎn',  # 拶
    0x62F7: 'kǎo',  # 拷
    0x62F8: 'yí,chǐ,hài',  # 拸
    0x62F9: 'xié',  # 拹
    0x62FA: 'cè,sè,chuò',  # 拺
    0x62FB: 'huī',  # 拻
    0x62FC: 'pīn',  # 拼
    0x62FD: 'zhuài,zhuāi,yè',  # 拽
    0x62FE: 'shí,shè',  # 拾
    0x62FF: 'ná',  # 拿
    0x6300: 'bāi',  # 挀
    0x6301: 'chí',  # 持
    0x6302: 'guà',  # 挂
    0x6303: 'zhì',  # 挃
    0x6304: 'kuò,guāng',  # 挄
    0x6305: 'duò',  # 挅
    0x6306: 'duǒ,duò',  # 挆
    0x6307: 'zhǐ',  # 指
    0x6308: 'qiè',  # 挈
    0x6309: 'àn',  # 按
    0x630A: 'nòng',  # 挊
    0x630B: 'zhèn',  # 挋
    0x630C: 'gé',  # 挌
    0x630D: 'jiào',  # 挍
    0x630E: 'kuà,kū',  # 挎
    0x630F: 'dòng',  # 挏
    0x6310: 'rú,ná',  # 挐
    0x6311: 'tiāo,tiǎo',  # 挑
    0x6312: 'liè',  # 挒
    0x6313: 'zhā',  # 挓
    0x6314: 'lǚ',  # 挔
    0x6315: 'dié,shè',  # 挕
    0x6316: 'wā',  # 挖
    0x6317: 'jué',  # 挗
    0x6318: 'liě',  # 挘
    0x6319: 'jǔ',  # 挙
    0x631A: 'zhì',  # 挚
    0x631B: 'luán',  # 挛
    0x631C: 'yà,yǎ',  # 挜
    0x631D: 'zhuā,wō',  # 挝
    0x631E: 'tà',  # 挞
    0x631F: 'xié,jiā',  # 挟
    0x6320: 'náo',  # 挠
    0x6321: 'dǎng,dàng',  # 挡
    0x6322: 'jiǎo',  # 挢
    0x6323: 'zhèng,zhēng',  # 挣
    0x6324: 'jǐ',  # 挤
    0x6325: 'huī',  # 挥
    0x6326: 'xián',  # 挦
    0x6327: 'yǔ',  # 挧
    0x6328: 'āi,ái',  # 挨
    0x6329: 'tuō,shuì',  # 挩
    0x632A: 'nuó',  # 挪
    0x632B: 'cuò',  # 挫
    0x632C: 'bó',  # 挬
    0x632D: 'gěng',  # 挭
    0x632E: 'tǐ,tì',  # 挮
    0x632F: 'zhèn',  # 振
    0x6330: 'chéng',  # 挰
    0x6331: 'suō,shā',  # 挱
    0x6332: 'suō,shā',  # 挲
    0x6333: 'kēng,qiān',  # 挳
    0x6334: 'měi',  # 挴
    0x6335: 'nòng',  # 挵
    0x6336: 'jú',  # 挶
    0x6337: 'bàng,péng',  # 挷
    0x6338: 'jiǎn',  # 挸
    0x6339: 'yì',  # 挹
    0x633A: 'tǐng',  # 挺
    0x633B: 'shān',  # 挻
    0x633C: 'ruó',  # 挼
    0x633D: 'wǎn',  # 挽
    0x633E: 'xié,jiā',  # 挾
    0x633F: 'chā',  # 挿
    0x6340: 'péng',  # 捀
    0x6341: 'jiǎo,kù',  # 捁
    0x6342: 'wǔ',  # 捂
    0x6343: 'jùn',  # 捃
    0x6344: 'jiù',  # 捄
    0x6345: 'tǒng',  # 捅
    0x6346: 'kǔn',  # 捆
    0x6347: 'huò,chì',  # 捇
    0x6348: 'tú,shū,chá',  # 捈
    0x6349: 'zhuō',  # 捉
    0x634A: 'póu,pōu,fū',  # 捊
    0x634B: 'luō,lǚ',  # 捋
    0x634C: 'bā',  # 捌
    0x634D: 'hàn',  # 捍
    0x634E: 'shāo,shào',  # 捎
    0x634F: 'niē',  # 捏
    0x6350: 'juān',  # 捐
    0x6351: 'zè',  # 捑
    0x6352: 'shù,sǒng,sōu',  # 捒
    0x6353: 'yé,yú',  # 捓
    0x6354: 'jué,zhuó',  # 捔
    0x6355: 'bǔ',  # 捕
    0x6356: 'wán',  # 捖
    0x6357: 'bù,pú,zhì',  # 捗
    0x6358: 'zùn',  # 捘
    0x6359: 'yè',  # 捙
    0x635A: 'zhāi',  # 捚
    0x635B: 'lǚ',  # 捛
    0x635C: 'sōu',  # 捜
    0x635D: 'tuō,shuì',  # 捝
    0x635E: 'lāo',  # 捞
    0x635F: 'sǔn',  # 损
    0x6360: 'bāng',  # 捠
    0x6361: 'jiǎn',  # 捡
    0x6362: 'huàn',  # 换
    0x6363: 'dǎo',  # 捣
    0x6364: 'wěi',  # 捤
    0x6365: 'wàn,wǎn,wān,yù',  # 捥
    0x6366: 'qín',  # 捦
    0x6367: 'pěng',  # 捧
    0x6368: 'shě',  # 捨
    0x6369: 'liè',  # 捩
    0x636A: 'mín',  # 捪
    0x636B: 'mén',  # 捫
    0x636C: 'fǔ,fù,bǔ',  # 捬
    0x636D: 'bǎi',  # 捭
    0x636E: 'jù,jū',  # 据
    0x636F: 'dáo',  # 捯
    0x6370: 'wǒ,luò,luǒ',  # 捰
    0x6371: 'ái',  # 捱
    0x6372: 'juǎn,quán',  # 捲
    0x6373: 'yuè',  # 捳
    0x6374: 'zǒng',  # 捴
    0x6375: 'chēn',  # 捵
    0x6376: 'chuí',  # 捶
    0x6377: 'jié',  # 捷
    0x6378: 'tū',  # 捸
    0x6379: 'bèn',  # 捹
    0x637A: 'nà',  # 捺
    0x637B: 'niǎn,niē',  # 捻
    0x637C: 'ruó,wěi,ré',  # 捼
    0x637D: 'zuó',  # 捽
    0x637E: 'wò,xiá',  # 捾
    0x637F: 'qī',  # 捿
    0x6380: 'xiān',  # 掀
    0x6381: 'chéng',  # 掁
    0x6382: 'diān',  # 掂
    0x6383: 'sǎo,sào',  # 掃
    0x6384: 'lūn,lún',  # 掄
    0x6385: 'qìng,qiàn',  # 掅
    0x6386: 'gāng',  # 掆
    0x6387: 'duō',  # 掇
    0x6388: 'shòu',  # 授
    0x6389: 'diào',  # 掉
    0x638A: 'pǒu,póu',  # 掊
    0x638B: 'dǐ',  # 掋
    0x638C: 'zhǎng',  # 掌
    0x638D: 'hùn',  # 掍
    0x638E: 'jǐ',  # 掎
    0x638F: 'tāo',  # 掏
    0x6390: 'qiā',  # 掐
    0x6391: 'qí',  # 掑
    0x6392: 'pái,pǎi',  # 排
    0x6393: 'shū',  # 掓
    0x6394: 'qiān,wàn',  # 掔
    0x6395: 'líng',  # 掕
    0x6396: 'yè,yē',  # 掖
    0x6397: 'yà,yǎ',  # 掗
    0x6398: 'jué',  # 掘
    0x6399: 'zhēng,zhèng',  # 掙
    0x639A: 'liǎng',  # 掚
    0x639B: 'guà',  # 掛
    0x639C: 'nǐ,niè,yì',  # 掜
    0x639D: 'huò,xù',  # 掝
    0x639E: 'shàn,yàn,yǎn',  # 掞
    0x639F: 'zhěng,dìng',  # 掟
    0x63A0: 'lüè',  # 掠
    0x63A1: 'cǎi',  # 採
    0x63A2: 'tàn',  # 探
    0x63A3: 'chè',  # 掣
    0x63A4: 'bīng',  # 掤
    0x63A5: 'jiē',  # 接
    0x63A6: 'tì',  # 掦
    0x63A7: 'kòng',  # 控
    0x63A8: 'tuī',  # 推
    0x63A9: 'yǎn',  # 掩
    0x63AA: 'cuò',  # 措
    0x63AB: 'zōu,zhōu,chōu',  # 掫
    0x63AC: 'jū',  # 掬
    0x63AD: 'tiàn',  # 掭
    0x63AE: 'qián',  # 掮
    0x63AF: 'kèn',  # 掯
    0x63B0: 'bāi',  # 掰
    0x63B1: 'pá',  # 掱
    0x63B2: 'jiē',  # 掲
    0x63B3: 'lǔ',  # 掳
    0x63B4: 'guó',  # 掴
    0x63B5: 'mìng',  # 掵
    0x63B6: 'jié',  # 掶
    0x63B7: 'zhì',  # 掷
    0x63B8: 'dǎn,shàn',  # 掸
    0x63B9: 'mēng',  # 掹
    0x63BA: 'chān,xiān,càn,shǎn',  # 掺
    0x63BB: 'sāo',  # 掻
    0x63BC: 'guàn',  # 掼
    0x63BD: 'pèng',  # 掽
    0x63BE: 'yuàn',  # 掾
    0x63BF: 'nuò',  # 掿
    0x63C0: 'jiǎn',  # 揀
    0x63C1: 'zhēng,kēng',  # 揁
    0x63C2: 'jiū,yóu',  # 揂
    0x63C3: 'jiǎn,jiān',  # 揃
    0x63C4: 'yú',  # 揄
    0x63C5: 'yán',  # 揅
    0x63C6: 'kuí',  # 揆
    0x63C7: 'nǎn',  # 揇
    0x63C8: 'hōng',  # 揈
    0x63C9: 'róu',  # 揉
    0x63CA: 'pì,chè',  # 揊
    0x63CB: 'wēi',  # 揋
    0x63CC: 'sāi',  # 揌
    0x63CD: 'zòu',  # 揍
    0x63CE: 'xuān',  # 揎
    0x63CF: 'miáo',  # 描
    0x63D0: 'tí,dī,dǐ',  # 提
    0x63D1: 'niē',  # 揑
    0x63D2: 'chā',  # 插
    0x63D3: 'shì',  # 揓
    0x63D4: 'zǒng,sōng',  # 揔
    0x63D5: 'zhèn,zhēn',  # 揕
    0x63D6: 'yī',  # 揖
    0x63D7: 'xún',  # 揗
    0x63D8: 'huáng,yóng',  # 揘
    0x63D9: 'biǎn',  # 揙
    0x63DA: 'yáng',  # 揚
    0x63DB: 'huàn',  # 換
    0x63DC: 'yǎn',  # 揜
    0x63DD: 'zǎn,zuàn',  # 揝
    0x63DE: 'ǎn',  # 揞
    0x63DF: 'xū,jū',  # 揟
    0x63E0: 'yà',  # 揠
    0x63E1: 'wò',  # 握
    0x63E2: 'ké,qiā',  # 揢
    0x63E3: 'chuǎi,chuài,chuāi,tuán,zhuī',  # 揣
    0x63E4: 'jí',  # 揤
    0x63E5: 'tì,dì',  # 揥
    0x63E6: 'là,lá',  # 揦
    0x63E7: 'là',  # 揧
    0x63E8: 'chéng',  # 揨
    0x63E9: 'kāi',  # 揩
    0x63EA: 'jiū',  # 揪
    0x63EB: 'jiū',  # 揫
    0x63EC: 'tú',  # 揬
    0x63ED: 'jiē,qì',  # 揭
    0x63EE: 'huī',  # 揮
    0x63EF: 'gèn',  # 揯
    0x63F0: 'chòng,dǒng',  # 揰
    0x63F1: 'xiāo',  # 揱
    0x63F2: 'shé,dié,yè',  # 揲
    0x63F3: 'xiē',  # 揳
    0x63F4: 'yuán',  # 援
    0x63F5: 'qián,jiàn,jiǎn',  # 揵
    0x63F6: 'yé',  # 揶
    0x63F7: 'chā',  # 揷
    0x63F8: 'zhā',  # 揸
    0x63F9: 'bēi',  # 揹
    0x63FA: 'yáo',  # 揺
    0x63FB: 'wēi',  # 揻
    0x63FC: 'bèng',  # 揼
    0x63FD: 'lǎn',  # 揽
    0x63FE: 'wèn',  # 揾
    0x63FF: 'qìn',  # 揿
    0x6400: 'chān',  # 搀
    0x6401: 'gē,gé',  # 搁
    0x6402: 'lǒu,lōu',  # 搂
    0x6403: 'zǒng',  # 搃
    0x6404: 'gèn',  # 搄
    0x6405: 'jiǎo',  # 搅
    0x6406: 'gòu',  # 搆
    0x6407: 'qìn',  # 搇
    0x6408: 'róng',  # 搈
    0x6409: 'què',  # 搉
    0x640A: 'chōu,zǒu',  # 搊
    0x640B: 'chuāi',  # 搋
    0x640C: 'zhǎn',  # 搌
    0x640D: 'sǔn',  # 損
    0x640E: 'sūn',  # 搎
    0x640F: 'bó',  # 搏
    0x6410: 'chù',  # 搐
    0x6411: 'róng,náng,nǎng',  # 搑
    0x6412: 'bàng,péng',  # 搒
    0x6413: 'cuō',  # 搓
    0x6414: 'sāo',  # 搔
    0x6415: 'kē,è',  # 搕
    0x6416: 'yáo',  # 搖
    0x6417: 'dǎo',  # 搗
    0x6418: 'zhī',  # 搘
    0x6419: 'nù,nuò,nòu',  # 搙
    0x641A: 'lā,xié,xiàn',  # 搚
    0x641B: 'jiān',  # 搛
    0x641C: 'sōu',  # 搜
    0x641D: 'qiǔ',  # 搝
    0x641E: 'gǎo',  # 搞
    0x641F: 'xiǎn,xiān',  # 搟
    0x6420: 'shuò',  # 搠
    0x6421: 'sǎng',  # 搡
    0x6422: 'jìn',  # 搢
    0x6423: 'miè',  # 搣
    0x6424: 'è',  # 搤
    0x6425: 'chuí',  # 搥
    0x6426: 'nuò',  # 搦
    0x6427: 'shān',  # 搧
    0x6428: 'tà',  # 搨
    0x6429: 'jié,zhé',  # 搩
    0x642A: 'táng',  # 搪
    0x642B: 'pán,bān,pó',  # 搫
    0x642C: 'bān',  # 搬
    0x642D: 'dā',  # 搭
    0x642E: 'lì',  # 搮
    0x642F: 'tāo',  # 搯
    0x6430: 'hú',  # 搰
    0x6431: 'zhì,nái',  # 搱
    0x6432: 'wā,wǎ,wà',  # 搲
    0x6433: 'huá',  # 搳
    0x6434: 'qiān',  # 搴
    0x6435: 'wèn',  # 搵
    0x6436: 'qiāng,qiǎng,chēng',  # 搶
    0x6437: 'tián,shēn',  # 搷
    0x6438: 'zhēn',  # 搸
    0x6439: 'è',  # 搹
    0x643A: 'xié',  # 携
    0x643B: 'ná,nuò',  # 搻
    0x643C: 'quán',  # 搼
    0x643D: 'chá',  # 搽
    0x643E: 'zhà',  # 搾
    0x643F: 'gé',  # 搿
    0x6440: 'wǔ',  # 摀
    0x6441: 'èn',  # 摁
    0x6442: 'shè',  # 摂
    0x6443: 'gāng',  # 摃
    0x6444: 'shè,niè',  # 摄
    0x6445: 'shū',  # 摅
    0x6446: 'bǎi',  # 摆
    0x6447: 'yáo',  # 摇
    0x6448: 'bìn',  # 摈
    0x6449: 'sōu',  # 摉
    0x644A: 'tān',  # 摊
    0x644B: 'sà,shā,shǎi',  # 摋
    0x644C: 'chǎn,sùn',  # 摌
    0x644D: 'suō',  # 摍
    0x644E: 'jiū,liú,liáo,jiǎo,náo',  # 摎
    0x644F: 'chōng',  # 摏
    0x6450: 'chuāng',  # 摐
    0x6451: 'guó',  # 摑
    0x6452: 'bìng',  # 摒
    0x6453: 'féng,pěng',  # 摓
    0x6454: 'shuāi',  # 摔
    0x6455: 'dì,tú,zhí',  # 摕
    0x6456: 'qì,jì,chá',  # 摖
    0x6457: 'sōu,sǒng',  # 摗
    0x6458: 'zhāi',  # 摘
    0x6459: 'liǎn,liàn',  # 摙
    0x645A: 'chēng',  # 摚
    0x645B: 'chī',  # 摛
    0x645C: 'guàn',  # 摜
    0x645D: 'lù',  # 摝
    0x645E: 'luò',  # 摞
    0x645F: 'lǒu,lōu',  # 摟
    0x6460: 'zǒng',  # 摠
    0x6461: 'gài,xì',  # 摡
    0x6462: 'hù,chū',  # 摢
    0x6463: 'zhā',  # 摣
    0x6464: 'qiāng',  # 摤
    0x6465: 'tàng',  # 摥
    0x6466: 'huà',  # 摦
    0x6467: 'cuī',  # 摧
    0x6468: 'zhì,nái',  # 摨
    0x6469: 'mó,mā',  # 摩
    0x646A: 'jiāng,qiàng',  # 摪
    0x646B: 'guī',  # 摫
    0x646C: 'yǐng',  # 摬
    0x646D: 'zhí',  # 摭
    0x646E: 'áo,qiáo',  # 摮
    0x646F: 'zhì',  # 摯
    0x6470: 'niè,chè',  # 摰
    0x6471: 'mán,màn',  # 摱
    0x6472: 'chàn,cán',  # 摲
    0x6473: 'kōu',  # 摳
    0x6474: 'chū',  # 摴
    0x6475: 'sè,mí,sù',  # 摵
    0x6476: 'tuán',  # 摶
    0x6477: 'jiǎo,chāo',  # 摷
    0x6478: 'mō',  # 摸
    0x6479: 'mó',  # 摹
    0x647A: 'zhé',  # 摺
    0x647B: 'chān,xiān,càn,shǎn',  # 摻
    0x647C: 'kēng,qiān',  # 摼
    0x647D: 'biào,biāo',  # 摽
    0x647E: 'jiàng',  # 摾
    0x647F: 'yáo',  # 摿
    0x6480: 'gòu',  # 撀
    0x6481: 'qiān',  # 撁
    0x6482: 'liào',  # 撂
    0x6483: 'jī',  # 撃
    0x6484: 'yīng',  # 撄
    0x6485: 'juē,jué',  # 撅
    0x6486: 'piē',  # 撆
    0x6487: 'piē,piě',  # 撇
    0x6488: 'lāo',  # 撈
    0x6489: 'dūn',  # 撉
    0x648A: 'xiàn',  # 撊
    0x648B: 'ruán',  # 撋
    0x648C: 'guì',  # 撌
    0x648D: 'zǎn,zān,zēn,qián',  # 撍
    0x648E: 'yī',  # 撎
    0x648F: 'xián',  # 撏
    0x6490: 'chēng',  # 撐
    0x6491: 'chēng',  # 撑
    0x6492: 'sā,sǎ',  # 撒
    0x6493: 'náo',  # 撓
    0x6494: 'hòng',  # 撔
    0x6495: 'sī',  # 撕
    0x6496: 'hàn',  # 撖
    0x6497: 'héng,guàng',  # 撗
    0x6498: 'dā',  # 撘
    0x6499: 'zǔn',  # 撙
    0x649A: 'niǎn',  # 撚
    0x649B: 'lǐn',  # 撛
    0x649C: 'zhěng,chéng',  # 撜
    0x649D: 'huī,wéi',  # 撝
    0x649E: 'zhuàng',  # 撞
    0x649F: 'jiǎo',  # 撟
    0x64A0: 'jǐ',  # 撠
    0x64A1: 'cāo',  # 撡
    0x64A2: 'dǎn',  # 撢
    0x64A3: 'dǎn,shàn',  # 撣
    0x64A4: 'chè',  # 撤
    0x64A5: 'bō',  # 撥
    0x64A6: 'chě',  # 撦
    0x64A7: 'juē',  # 撧
    0x64A8: 'xiāo,sōu',  # 撨
    0x64A9: 'liāo,liáo',  # 撩
    0x64AA: 'bèn',  # 撪
    0x64AB: 'fǔ',  # 撫
    0x64AC: 'qiào',  # 撬
    0x64AD: 'bō',  # 播
    0x64AE: 'cuō,zuǒ',  # 撮
    0x64AF: 'zhuó',  # 撯
    0x64B0: 'zhuàn',  # 撰
    0x64B1: 'wěi,tuǒ',  # 撱
    0x64B2: 'pū',  # 撲
    0x64B3: 'qìn',  # 撳
    0x64B4: 'dūn',  # 撴
    0x64B5: 'niǎn',  # 撵
    0x64B6: 'huá',  # 撶
    0x64B7: 'xié',  # 撷
    0x64B8: 'lū',  # 撸
    0x64B9: 'jiǎo',  # 撹
    0x64BA: 'cuān',  # 撺
    0x64BB: 'tà',  # 撻
    0x64BC: 'hàn',  # 撼
    0x64BD: 'qiào,yāo,jī',  # 撽
    0x64BE: 'zhuā,wō',  # 撾
    0x64BF: 'jiǎn',  # 撿
    0x64C0: 'gǎn',  # 擀
    0x64C1: 'yōng',  # 擁
    0x64C2: 'léi,lèi',  # 擂
    0x64C3: 'nǎng',  # 擃
    0x64C4: 'lǔ',  # 擄
    0x64C5: 'shàn',  # 擅
    0x64C6: 'zhuó',  # 擆
    0x64C7: 'zé,zhái',  # 擇
    0x64C8: 'pǔ',  # 擈
    0x64C9: 'chuò',  # 擉
    0x64CA: 'jī',  # 擊
    0x64CB: 'dǎng,dàng',  # 擋
    0x64CC: 'sè',  # 擌
    0x64CD: 'cāo',  # 操
    0x64CE: 'qíng',  # 擎
    0x64CF: 'qíng,jǐng',  # 擏
    0x64D0: 'huàn',  # 擐
    0x64D1: 'jiē',  # 擑
    0x64D2: 'qín',  # 擒
    0x64D3: 'kuǎi',  # 擓
    0x64D4: 'dān,dàn',  # 擔
    0x64D5: 'xié',  # 擕
    0x64D6: 'qiā,jiā,yè',  # 擖
    0x64D7: 'pǐ,bò',  # 擗
    0x64D8: 'bò,bāi',  # 擘
    0x64D9: 'ào',  # 擙
    0x64DA: 'jù,jū',  # 據
    0x64DB: 'yè',  # 擛
    0x64DC: 'è',  # 擜
    0x64DD: 'mēng',  # 擝
    0x64DE: 'sòu,sǒu',  # 擞
    0x64DF: 'mí',  # 擟
    0x64E0: 'jǐ',  # 擠
    0x64E1: 'tái',  # 擡
    0x64E2: 'zhuó',  # 擢
    0x64E3: 'dǎo',  # 擣
    0x64E4: 'xǐng',  # 擤
    0x64E5: 'lǎn',  # 擥
    0x64E6: 'cā',  # 擦
    0x64E7: 'jǔ',  # 擧
    0x64E8: 'yē',  # 擨
    0x64E9: 'rǔ',  # 擩
    0x64EA: 'yè',  # 擪
    0x64EB: 'yè',  # 擫
    0x64EC: 'nǐ',  # 擬
    0x64ED: 'huò',  # 擭
    0x64EE: 'jié',  # 擮
    0x64EF: 'bìn',  # 擯
    0x64F0: 'níng,nǐng,nìng',  # 擰
    0x64F1: 'gē,gé',  # 擱
    0x64F2: 'zhì',  # 擲
    0x64F3: 'zhì,jié',  # 擳
    0x64F4: 'kuò',  # 擴
    0x64F5: 'mó',  # 擵
    0x64F6: 'jiàn',  # 擶
    0x64F7: 'xié',  # 擷
    0x64F8: 'liè,là',  # 擸
    0x64F9: 'tān',  # 擹
    0x64FA: 'bǎi',  # 擺
    0x64FB: 'sòu,sǒu',  # 擻
    0x64FC: 'lū',  # 擼
    0x64FD: 'lì,luò,yuè',  # 擽
    0x64FE: 'rǎo',  # 擾
    0x64FF: 'tī,zhì,zhāi',  # 擿
    0x6500: 'pān',  # 攀
    0x6501: 'yǎng',  # 攁
    0x6502: 'léi,lèi',  # 攂
    0x6503: 'cā,sǎ',  # 攃
    0x6504: 'shū',  # 攄
    0x6505: 'zǎn',  # 攅
    0x6506: 'niǎn',  # 攆
    0x6507: 'xiǎn',  # 攇
    0x6508: 'jùn,pèi',  # 攈
    0x6509: 'huō',  # 攉
    0x650A: 'lì,luò',  # 攊
    0x650B: 'là,lài',  # 攋
    0x650C: 'huàn',  # 攌
    0x650D: 'yíng',  # 攍
    0x650E: 'lú,luó',  # 攎
    0x650F: 'lǒng',  # 攏
    0x6510: 'qiān',  # 攐
    0x6511: 'qiān',  # 攑
    0x6512: 'zǎn,cuán',  # 攒
    0x6513: 'qiān',  # 攓
    0x6514: 'lán',  # 攔
    0x6515: 'xiān,jiān',  # 攕
    0x6516: 'yīng',  # 攖
    0x6517: 'méi',  # 攗
    0x6518: 'rǎng',  # 攘
    0x6519: 'chān',  # 攙
    0x651A: 'wěng',  # 攚
    0x651B: 'cuān',  # 攛
    0x651C: 'xié',  # 攜
    0x651D: 'shè,niè',  # 攝
    0x651E: 'luó',  # 攞
    0x651F: 'jùn',  # 攟
    0x6520: 'mí,mǐ,mó',  # 攠
    0x6521: 'chī',  # 攡
    0x6522: 'zǎn,cuán',  # 攢
    0x6523: 'luán',  # 攣
    0x6524: 'tān',  # 攤
    0x6525: 'zuàn',  # 攥
    0x6526: 'lì,shài',  # 攦
    0x6527: 'diān',  # 攧
    0x6528: 'wā',  # 攨
    0x6529: 'dǎng',  # 攩
    0x652A: 'jiǎo',  # 攪
    0x652B: 'jué',  # 攫
    0x652C: 'lǎn',  # 攬
    0x652D: 'lì,luǒ',  # 攭
    0x652E: 'nǎng',  # 攮
    0x652F: 'zhī',  # 支
    0x6530: 'guì',  # 攰
    0x6531: 'guǐ,guì',  # 攱
    0x6532: 'qī,yǐ,jī',  # 攲
    0x6533: 'xún',  # 攳
    0x6534: 'pū',  # 攴
    0x6535: 'pū',  # 攵
    0x6536: 'shōu',  # 收
    0x6537: 'kǎo',  # 攷
    0x6538: 'yōu',  # 攸
    0x6539: 'gǎi',  # 改
    0x653A: 'yǐ',  # 攺
    0x653B: 'gōng',  # 攻
    0x653C: 'gān,hàn',  # 攼
    0x653D: 'bān',  # 攽
    0x653E: 'fàng',  # 放
    0x653F: 'zhèng',  # 政
    0x6540: 'pò',  # 敀
    0x6541: 'diān',  # 敁
    0x6542: 'kòu',  # 敂
    0x6543: 'mǐn',  # 敃
    0x6544: 'wù,móu',  # 敄
    0x6545: 'gù',  # 故
    0x6546: 'hé',  # 敆
    0x6547: 'cè',  # 敇
    0x6548: 'xiào',  # 效
    0x6549: 'mǐ',  # 敉
    0x654A: 'chù,shōu',  # 敊
    0x654B: 'gé,guó,è',  # 敋
    0x654C: 'dí',  # 敌
    0x654D: 'xù',  # 敍
    0x654E: 'jiào,jiāo',  # 敎
    0x654F: 'mǐn',  # 敏
    0x6550: 'chén',  # 敐
    0x6551: 'jiù',  # 救
    0x6552: 'shēn',  # 敒
    0x6553: 'duó,duì',  # 敓
    0x6554: 'yǔ',  # 敔
    0x6555: 'chì',  # 敕
    0x6556: 'áo',  # 敖
    0x6557: 'bài',  # 敗
    0x6558: 'xù',  # 敘
    0x6559: 'jiào,jiāo',  # 教
    0x655A: 'duó,duì',  # 敚
    0x655B: 'liǎn',  # 敛
    0x655C: 'niè',  # 敜
    0x655D: 'bì',  # 敝
    0x655E: 'chǎng',  # 敞
    0x655F: 'diǎn',  # 敟
    0x6560: 'duō,què',  # 敠
    0x6561: 'yì',  # 敡
    0x6562: 'gǎn',  # 敢
    0x6563: 'sàn,sǎn',  # 散
    0x6564: 'kě',  # 敤
    0x6565: 'yàn',  # 敥
    0x6566: 'dūn,duì',  # 敦
    0x6567: 'qī,yǐ,jī',  # 敧
    0x6568: 'tǒu',  # 敨
    0x6569: 'xiào,xué',  # 敩
    0x656A: 'duō,què',  # 敪
    0x656B: 'jiǎo',  # 敫
    0x656C: 'jìng',  # 敬
    0x656D: 'yáng',  # 敭
    0x656E: 'xiá',  # 敮
    0x656F: 'mǐn',  # 敯
    0x6570: 'shù,shǔ,shuò',  # 数
    0x6571: 'ái,zhú',  # 敱
    0x6572: 'qiāo',  # 敲
    0x6573: 'ái',  # 敳
    0x6574: 'zhěng',  # 整
    0x6575: 'dí',  # 敵
    0x6576: 'chén',  # 敶
    0x6577: 'fū',  # 敷
    0x6578: 'shù,shǔ,shuò',  # 數
    0x6579: 'liáo',  # 敹
    0x657A: 'qū',  # 敺
    0x657B: 'xiòng,xuàn',  # 敻
    0x657C: 'yǐ',  # 敼
    0x657D: 'jiǎo',  # 敽
    0x657E: 'shàn',  # 敾
    0x657F: 'jiǎo',  # 敿
    0x6580: 'zhuó,zhú',  # 斀
    0x6581: 'yì,dù',  # 斁
    0x6582: 'liǎn',  # 斂
    0x6583: 'bì',  # 斃
    0x6584: 'lí,tái',  # 斄
    0x6585: 'xiào',  # 斅
    0x6586: 'xiào',  # 斆
    0x6587: 'wén',  # 文
    0x6588: 'xué',  # 斈
    0x6589: 'qí',  # 斉
    0x658A: 'qí',  # 斊
    0x658B: 'zhāi',  # 斋
    0x658C: 'bīn',  # 斌
    0x658D: 'jué,jiào',  # 斍
    0x658E: 'zhāi',  # 斎
    0x658F: 'láng',  # 斏
    0x6590: 'fěi,fēi',  # 斐
    0x6591: 'bān',  # 斑
    0x6592: 'bān',  # 斒
    0x6593: 'lán',  # 斓
    0x6594: 'yǔ,zhōng',  # 斔
    0x6595: 'lán',  # 斕
    0x6596: 'wěi,mén',  # 斖
    0x6597: 'dǒu,dòu',  # 斗
    0x6598: 'shēng',  # 斘
    0x6599: 'liào',  # 料
    0x659A: 'jiǎ',  # 斚
    0x659B: 'hú',  # 斛
    0x659C: 'xié',  # 斜
    0x659D: 'jiǎ',  # 斝
    0x659E: 'yǔ',  # 斞
    0x659F: 'zhēn',  # 斟
    0x65A0: 'jiào',  # 斠
    0x65A1: 'wò,guǎn',  # 斡
    0x65A2: 'tǒu,tiǎo',  # 斢
    0x65A3: 'dòu',  # 斣
    0x65A4: 'jīn',  # 斤
    0x65A5: 'chì',  # 斥
    0x65A6: 'yín,zhì',  # 斦
    0x65A7: 'fǔ',  # 斧
    0x65A8: 'qiāng',  # 斨
    0x65A9: 'zhǎn',  # 斩
    0x65AA: 'qú',  # 斪
    0x65AB: 'zhuó',  # 斫
    0x65AC: 'zhǎn',  # 斬
    0x65AD: 'duàn',  # 断
    0x65AE: 'zhuó',  # 斮
    0x65AF: 'sī',  # 斯
    0x65B0: 'xīn',  # 新
    0x65B1: 'zhuó',  # 斱
    0x65B2: 'zhuó',  # 斲
    0x65B3: 'qín',  # 斳
    0x65B4: 'lín',  # 斴
    0x65B5: 'zhuó',  # 斵
    0x65B6: 'chù',  # 斶
    0x65B7: 'duàn',  # 斷
    0x65B8: 'zhú',  # 斸
    0x65B9: 'fāng',  # 方
    0x65BA: 'chǎn,jiè',  # 斺
    0x65BB: 'háng',  # 斻
    0x65BC: 'yú,wū',  # 於
    0x65BD: 'shī',  # 施
    0x65BE: 'pèi',  # 斾
    0x65BF: 'liú,yóu',  # 斿
    0x65C0: 'mèi',  # 旀
    0x65C1: 'páng,bàng',  # 旁
    0x65C2: 'qí',  # 旂
    0x65C3: 'zhān',  # 旃
    0x65C4: 'máo,mào',  # 旄
    0x65C5: 'lǚ',  # 旅
    0x65C6: 'pèi',  # 旆
    0x65C7: 'pī,bì',  # 旇
    0x65C8: 'liú',  # 旈
    0x65C9: 'fū',  # 旉
    0x65CA: 'fǎng',  # 旊
    0x65CB: 'xuán,xuàn',  # 旋
    0x65CC: 'jīng',  # 旌
    0x65CD: 'jīng',  # 旍
    0x65CE: 'nǐ',  # 旎
    0x65CF: 'zú',  # 族
    0x65D0: 'zhào',  # 旐
    0x65D1: 'yǐ',  # 旑
    0x65D2: 'liú',  # 旒
    0x65D3: 'shāo',  # 旓
    0x65D4: 'jiàn',  # 旔
    0x65D5: 'eos',  # 旕
    0x65D6: 'yǐ',  # 旖
    0x65D7: 'qí',  # 旗
    0x65D8: 'zhì',  # 旘
    0x65D9: 'fān',  # 旙
    0x65DA: 'piāo',  # 旚
    0x65DB: 'fān',  # 旛
    0x65DC: 'zhān',  # 旜
    0x65DD: 'kuài',  # 旝
    0x65DE: 'suì',  # 旞
    0x65DF: 'yú',  # 旟
    0x65E0: 'wú',  # 无
    0x65E1: 'jì',  # 旡
    0x65E2: 'jì',  # 既
    0x65E3: 'jì',  # 旣
    0x65E4: 'huò',  # 旤
    0x65E5: 'rì',  # 日
    0x65E6: 'dàn',  # 旦
    0x65E7: 'jiù',  # 旧
    0x65E8: 'zhǐ',  # 旨
    0x65E9: 'zǎo',  # 早
    0x65EA: 'xié',  # 旪
    0x65EB: 'tiāo',  # 旫
    0x65EC: 'xún',  # 旬
    0x65ED: 'xù',  # 旭
    0x65EE: 'gā',  # 旮
    0x65EF: 'lá',  # 旯
    0x65F0: 'gàn,hàn',  # 旰
    0x65F1: 'hàn',  # 旱
    0x65F2: 'tái,yīng',  # 旲
    0x65F3: 'dì,dí,de',  # 旳
    0x65F4: 'xù,xū',  # 旴
    0x65F5: 'chǎn',  # 旵
    0x65F6: 'shí',  # 时
    0x65F7: 'kuàng',  # 旷
    0x65F8: 'yáng',  # 旸
    0x65F9: 'shí',  # 旹
    0x65FA: 'wàng',  # 旺
    0x65FB: 'mín',  # 旻
    0x65FC: 'mín',  # 旼
    0x65FD: 'tūn,zhùn',  # 旽
    0x65FE: 'chūn',  # 旾
    0x65FF: 'wù,wǔ',  # 旿
    0x6600: 'yún',  # 昀
    0x6601: 'bèi',  # 昁
    0x6602: 'áng',  # 昂
    0x6603: 'zè',  # 昃
    0x6604: 'bǎn',  # 昄
    0x6605: 'jié',  # 昅
    0x6606: 'kūn',  # 昆
    0x6607: 'shēng',  # 昇
    0x6608: 'hù',  # 昈
    0x6609: 'fǎng',  # 昉
    0x660A: 'hào',  # 昊
    0x660B: 'guì',  # 昋
    0x660C: 'chāng',  # 昌
    0x660D: 'xuān',  # 昍
    0x660E: 'míng',  # 明
    0x660F: 'hūn',  # 昏
    0x6610: 'fēn',  # 昐
    0x6611: 'qǐn',  # 昑
    0x6612: 'hū',  # 昒
    0x6613: 'yì',  # 易
    0x6614: 'xī',  # 昔
    0x6615: 'xīn',  # 昕
    0x6616: 'yán',  # 昖
    0x6617: 'zè',  # 昗
    0x6618: 'fǎng',  # 昘
    0x6619: 'tán',  # 昙
    0x661A: 'shèn',  # 昚
    0x661B: 'jù',  # 昛
    0x661C: 'yáng',  # 昜
    0x661D: 'zǎn',  # 昝
    0x661E: 'bǐng',  # 昞
    0x661F: 'xīng',  # 星
    0x6620: 'yìng',  # 映
    0x6621: 'xuàn',  # 昡
    0x6622: 'pò',  # 昢
    0x6623: 'zhěn',  # 昣
    0x6624: 'líng',  # 昤
    0x6625: 'chūn',  # 春
    0x6626: 'hào',  # 昦
    0x6627: 'mèi',  # 昧
    0x6628: 'zuó',  # 昨
    0x6629: 'mò',  # 昩
    0x662A: 'biàn',  # 昪
    0x662B: 'xù',  # 昫
    0x662C: 'hūn',  # 昬
    0x662D: 'zhāo',  # 昭
    0x662E: 'zòng',  # 昮
    0x662F: 'shì',  # 是
    0x6630: 'shì',  # 昰
    0x6631: 'yù',  # 昱
    0x6632: 'fèi',  # 昲
    0x6633: 'dié,yì',  # 昳
    0x6634: 'mǎo',  # 昴
    0x6635: 'nì',  # 昵
    0x6636: 'chǎng',  # 昶
    0x6637: 'wēn',  # 昷
    0x6638: 'dōng',  # 昸
    0x6639: 'ǎi',  # 昹
    0x663A: 'bǐng',  # 昺
    0x663B: 'áng',  # 昻
    0x663C: 'zhòu',  # 昼
    0x663D: 'lóng',  # 昽
    0x663E: 'xiǎn',  # 显
    0x663F: 'kuàng',  # 昿
    0x6640: 'tiǎo',  # 晀
    0x6641: 'cháo',  # 晁
    0x6642: 'shí',  # 時
    0x6643: 'huǎng,huàng',  # 晃
    0x6644: 'huǎng',  # 晄
    0x6645: 'xuān',  # 晅
    0x6646: 'kuí',  # 晆
    0x6647: 'xù,kuā',  # 晇
    0x6648: 'jiǎo',  # 晈
    0x6649: 'jìn',  # 晉
    0x664A: 'zhì',  # 晊
    0x664B: 'jìn',  # 晋
    0x664C: 'shǎng',  # 晌
    0x664D: 'tóng',  # 晍
    0x664E: 'hǒng',  # 晎
    0x664F: 'yàn',  # 晏
    0x6650: 'gāi',  # 晐
    0x6651: 'xiǎng',  # 晑
    0x6652: 'shài',  # 晒
    0x6653: 'xiǎo',  # 晓
    0x6654: 'yè',  # 晔
    0x6655: 'yùn,yūn',  # 晕
    0x6656: 'huī',  # 晖
    0x6657: 'hán',  # 晗
    0x6658: 'hàn',  # 晘
    0x6659: 'jùn',  # 晙
    0x665A: 'wǎn',  # 晚
    0x665B: 'xiàn',  # 晛
    0x665C: 'kūn',  # 晜
    0x665D: 'zhòu',  # 晝
    0x665E: 'xī',  # 晞
    0x665F: 'shèng,chéng',  # 晟
    0x6660: 'shèng',  # 晠
    0x6661: 'bū',  # 晡
    0x6662: 'zhé',  # 晢
    0x6663: 'zhé',  # 晣
    0x6664: 'wù',  # 晤
    0x6665: 'wǎn',  # 晥
    0x6666: 'huì',  # 晦
    0x6667: 'hào',  # 晧
    0x6668: 'chén',  # 晨
    0x6669: 'wǎn',  # 晩
    0x666A: 'tiǎn',  # 晪
    0x666B: 'zhuó',  # 晫
    0x666C: 'zuì',  # 晬
    0x666D: 'zhǒu',  # 晭
    0x666E: 'pǔ',  # 普
    0x666F: 'jǐng,yǐng',  # 景
    0x6670: 'xī',  # 晰
    0x6671: 'shǎn',  # 晱
    0x6672: 'nǐ',  # 晲
    0x6673: 'xī',  # 晳
    0x6674: 'qíng',  # 晴
    0x6675: 'qǐ,dù',  # 晵
    0x6676: 'jīng',  # 晶
    0x6677: 'guǐ',  # 晷
    0x6678: 'zhěng',  # 晸
    0x6679: 'yì',  # 晹
    0x667A: 'zhì',  # 智
    0x667B: 'àn,ǎn,yǎn',  # 晻
    0x667C: 'wǎn',  # 晼
    0x667D: 'lín',  # 晽
    0x667E: 'liàng',  # 晾
    0x667F: 'chēng',  # 晿
    0x6680: 'wǎng,wàng',  # 暀
    0x6681: 'xiǎo',  # 暁
    0x6682: 'zàn',  # 暂
    0x6683: 'fēi',  # 暃
    0x6684: 'xuān',  # 暄
    0x6685: 'xuǎn',  # 暅
    0x6686: 'yí',  # 暆
    0x6687: 'xiá',  # 暇
    0x6688: 'yùn,yūn',  # 暈
    0x6689: 'huī',  # 暉
    0x668A: 'xǔ',  # 暊
    0x668B: 'mǐn,mín',  # 暋
    0x668C: 'kuí',  # 暌
    0x668D: 'yē',  # 暍
    0x668E: 'yìng',  # 暎
    0x668F: 'shǔ,dǔ',  # 暏
    0x6690: 'wěi',  # 暐
    0x6691: 'shǔ',  # 暑
    0x6692: 'qíng',  # 暒
    0x6693: 'mào',  # 暓
    0x6694: 'nán',  # 暔
    0x6695: 'jiǎn,lán',  # 暕
    0x6696: 'nuǎn',  # 暖
    0x6697: 'àn',  # 暗
    0x6698: 'yáng',  # 暘
    0x6699: 'chūn',  # 暙
    0x669A: 'yáo',  # 暚
    0x669B: 'suǒ',  # 暛
    0x669C: 'pǔ',  # 暜
    0x669D: 'míng',  # 暝
    0x669E: 'jiǎo',  # 暞
    0x669F: 'kǎi',  # 暟
    0x66A0: 'hào',  # 暠
    0x66A1: 'wěng',  # 暡
    0x66A2: 'chàng',  # 暢
    0x66A3: 'qì',  # 暣
    0x66A4: 'hào',  # 暤
    0x66A5: 'yàn',  # 暥
    0x66A6: 'lì',  # 暦
    0x66A7: 'ài',  # 暧
    0x66A8: 'jì',  # 暨
    0x66A9: 'jì',  # 暩
    0x66AA: 'mèn',  # 暪
    0x66AB: 'zàn',  # 暫
    0x66AC: 'xiè',  # 暬
    0x66AD: 'hào',  # 暭
    0x66AE: 'mù',  # 暮
    0x66AF: 'mù',  # 暯
    0x66B0: 'cōng',  # 暰
    0x66B1: 'nì',  # 暱
    0x66B2: 'zhāng',  # 暲
    0x66B3: 'huì',  # 暳
    0x66B4: 'bào,pù',  # 暴
    0x66B5: 'hàn',  # 暵
    0x66B6: 'xuán',  # 暶
    0x66B7: 'chuán',  # 暷
    0x66B8: 'liáo',  # 暸
    0x66B9: 'xiān',  # 暹
    0x66BA: 'tǎn',  # 暺
    0x66BB: 'jǐng',  # 暻
    0x66BC: 'piē',  # 暼
    0x66BD: 'lín',  # 暽
    0x66BE: 'tūn',  # 暾
    0x66BF: 'xī,xǐ',  # 暿
    0x66C0: 'yì',  # 曀
    0x66C1: 'jì',  # 曁
    0x66C2: 'huàng',  # 曂
    0x66C3: 'dài',  # 曃
    0x66C4: 'yè',  # 曄
    0x66C5: 'yè',  # 曅
    0x66C6: 'lì',  # 曆
    0x66C7: 'tán',  # 曇
    0x66C8: 'tóng',  # 曈
    0x66C9: 'xiǎo',  # 曉
    0x66CA: 'fèi',  # 曊
    0x66CB: 'shěn',  # 曋
    0x66CC: 'zhào',  # 曌
    0x66CD: 'hào',  # 曍
    0x66CE: 'yì',  # 曎
    0x66CF: 'xiàng',  # 曏
    0x66D0: 'xīng',  # 曐
    0x66D1: 'shēn',  # 曑
    0x66D2: 'jiǎo',  # 曒
    0x66D3: 'bào',  # 曓
    0x66D4: 'jìng',  # 曔
    0x66D5: 'yàn',  # 曕
    0x66D6: 'ài',  # 曖
    0x66D7: 'yè',  # 曗
    0x66D8: 'rú',  # 曘
    0x66D9: 'shǔ',  # 曙
    0x66DA: 'méng',  # 曚
    0x66DB: 'xūn',  # 曛
    0x66DC: 'yào',  # 曜
    0x66DD: 'pù,bào',  # 曝
    0x66DE: 'lì',  # 曞
    0x66DF: 'chén',  # 曟
    0x66E0: 'kuàng',  # 曠
    0x66E1: 'dié',  # 曡
    0x66E2: 'liǎo',  # 曢
    0x66E3: 'yàn',  # 曣
    0x66E4: 'huò',  # 曤
    0x66E5: 'lú',  # 曥
    0x66E6: 'xī',  # 曦
    0x66E7: 'róng',  # 曧
    0x66E8: 'lóng',  # 曨
    0x66E9: 'nǎng',  # 曩
    0x66EA: 'luǒ',  # 曪
    0x66EB: 'luán',  # 曫
    0x66EC: 'shài',  # 曬
    0x66ED: 'tǎng',  # 曭
    0x66EE: 'yǎn',  # 曮
    0x66EF: 'zhú',  # 曯
    0x66F0: 'yuē',  # 曰
    0x66F1: 'yuē',  # 曱
    0x66F2: 'qū,qǔ',  # 曲
    0x66F3: 'yè',  # 曳
    0x66F4: 'gēng,gèng',  # 更
    0x66F5: 'yè',  # 曵
    0x66F6: 'hū,hù',  # 曶
    0x66F7: 'hé',  # 曷
    0x66F8: 'shū',  # 書
    0x66F9: 'cáo',  # 曹
    0x66FA: 'cáo',  # 曺
    0x66FB: 'shēng',  # 曻
    0x66FC: 'màn',  # 曼
    0x66FD: 'zēng,céng',  # 曽
    0x66FE: 'zēng,céng',  # 曾
    0x66FF: 'tì',  # 替
    0x6700: 'zuì',  # 最
    0x6701: 'cǎn,qián,jiàn',  # 朁
    0x6702: 'xù',  # 朂
    0x6703: 'huì,kuài',  # 會
    0x6704: 'yǐn',  # 朄
    0x6705: 'qiè,hé',  # 朅
    0x6706: 'fēn',  # 朆
    0x6707: 'bì,pí',  # 朇
    0x6708: 'yuè',  # 月
    0x6709: 'yǒu,yòu',  # 有
    0x670A: 'ruǎn',  # 朊
    0x670B: 'péng',  # 朋
    0x670C: 'fén,bān',  # 朌
    0x670D: 'fú,fù',  # 服
    0x670E: 'líng',  # 朎
    0x670F: 'fěi,kū',  # 朏
    0x6710: 'qú,xù,chǔn',  # 朐
    0x6711: 'tì',  # 朑
    0x6712: 'nǜ,gǎ',  # 朒
    0x6713: 'tiǎo',  # 朓
    0x6714: 'shuò',  # 朔
    0x6715: 'zhèn',  # 朕
    0x6716: 'lǎng',  # 朖
    0x6717: 'lǎng',  # 朗
    0x6718: 'juān,zuī',  # 朘
    0x6719: 'míng',  # 朙
    0x671A: 'huāng,máng,wáng',  # 朚
    0x671B: 'wàng',  # 望
    0x671C: 'tūn',  # 朜
    0x671D: 'zhāo,cháo',  # 朝
    0x671E: 'jī',  # 朞
    0x671F: 'qī,jī',  # 期
    0x6720: 'yīng',  # 朠
    0x6721: 'zōng',  # 朡
    0x6722: 'wàng',  # 朢
    0x6723: 'tóng,chuáng',  # 朣
    0x6724: 'lǎng',  # 朤
    0x6725: 'láo',  # 朥
    0x6726: 'méng',  # 朦
    0x6727: 'lóng',  # 朧
    0x6728: 'mù',  # 木
    0x6729: 'tin',  # 朩
    0x672A: 'wèi',  # 未
    0x672B: 'mò',  # 末
    0x672C: 'běn',  # 本
    0x672D: 'zhá',  # 札
    0x672E: 'shù,shú,zhú',  # 朮
    0x672F: 'shù,shú,zhú',  # 术
    0x6730: 'teul',  # 朰
    0x6731: 'zhū,shú',  # 朱
    0x6732: 'rén',  # 朲
    0x6733: 'bā',  # 朳
    0x6734: 'pǔ,pò,pō,piáo',  # 朴
    0x6735: 'duǒ',  # 朵
    0x6736: 'duǒ',  # 朶
    0x6737: 'dāo,tiáo,mù',  # 朷
    0x6738: 'lì',  # 朸
    0x6739: 'qiú,guǐ',  # 朹
    0x673A: 'jī',  # 机
    0x673B: 'jiū',  # 朻
    0x673C: 'bǐ',  # 朼
    0x673D: 'xiǔ',  # 朽
    0x673E: 'chéng,chēng',  # 朾
    0x673F: 'cì',  # 朿
    0x6740: 'shā',  # 杀
    0x6741: 'rù',  # 杁
    0x6742: 'zá',  # 杂
    0x6743: 'quán',  # 权
    0x6744: 'qiān',  # 杄
    0x6745: 'yú,wū',  # 杅
    0x6746: 'gān,gǎn',  # 杆
    0x6747: 'wū',  # 杇
    0x6748: 'chā,chà',  # 杈
    0x6749: 'shān,shā',  # 杉
    0x674A: 'xún',  # 杊
    0x674B: 'fán',  # 杋
    0x674C: 'wù',  # 杌
    0x674D: 'zǐ',  # 杍
    0x674E: 'lǐ',  # 李
    0x674F: 'xìng',  # 杏
    0x6750: 'cái',  # 材
    0x6751: 'cūn',  # 村
    0x6752: 'rèn,ér',  # 杒
    0x6753: 'sháo,biāo',  # 杓
    0x6754: 'tuō,zhé',  # 杔
    0x6755: 'dì,duò',  # 杕
    0x6756: 'zhàng',  # 杖
    0x6757: 'máng',  # 杗
    0x6758: 'chì',  # 杘
    0x6759: 'yì',  # 杙
    0x675A: 'gū,gài',  # 杚
    0x675B: 'gōng',  # 杛
    0x675C: 'dù',  # 杜
    0x675D: 'yí,lì,lí,duò,tuò',  # 杝
    0x675E: 'qǐ',  # 杞
    0x675F: 'shù',  # 束
    0x6760: 'gàng,gāng',  # 杠
    0x6761: 'tiáo,tiāo',  # 条
    0x6762: 'jié',  # 杢
    0x6763: 'mián',  # 杣
    0x6764: 'wàn',  # 杤
    0x6765: 'lái',  # 来
    0x6766: 'jiǔ',  # 杦
    0x6767: 'máng',  # 杧
    0x6768: 'yáng',  # 杨
    0x6769: 'mà,mǎ',  # 杩
    0x676A: 'miǎo',  # 杪
    0x676B: 'sì,zhǐ,xǐ',  # 杫
    0x676C: 'yuán,wán',  # 杬
    0x676D: 'háng',  # 杭
    0x676E: 'fèi,bèi',  # 杮
    0x676F: 'bēi',  # 杯
    0x6770: 'jié',  # 杰
    0x6771: 'dōng',  # 東
    0x6772: 'gǎo',  # 杲
    0x6773: 'yǎo',  # 杳
    0x6774: 'xiān',  # 杴
    0x6775: 'chǔ',  # 杵
    0x6776: 'chūn',  # 杶
    0x6777: 'pá',  # 杷
    0x6778: 'shū,duì',  # 杸
    0x6779: 'huà',  # 杹
    0x677A: 'xīn',  # 杺
    0x677B: 'niǔ,chǒu',  # 杻
    0x677C: 'zhù',  # 杼
    0x677D: 'chǒu',  # 杽
    0x677E: 'sōng',  # 松
    0x677F: 'bǎn',  # 板
    0x6780: 'sōng',  # 枀
    0x6781: 'jí',  # 极
    0x6782: 'wò,yuè',  # 枂
    0x6783: 'jìn',  # 枃
    0x6784: 'gòu',  # 构
    0x6785: 'jī',  # 枅
    0x6786: 'máo',  # 枆
    0x6787: 'pí',  # 枇
    0x6788: 'pī,mì',  # 枈
    0x6789: 'wǎng',  # 枉
    0x678A: 'àng',  # 枊
    0x678B: 'fāng,bìng',  # 枋
    0x678C: 'fén',  # 枌
    0x678D: 'yì',  # 枍
    0x678E: 'fú,fū',  # 枎
    0x678F: 'nán',  # 枏
    0x6790: 'xī',  # 析
    0x6791: 'hù,dǐ',  # 枑
    0x6792: 'yā',  # 枒
    0x6793: 'dōu',  # 枓
    0x6794: 'xín',  # 枔
    0x6795: 'zhěn',  # 枕
    0x6796: 'yǎo,yāo',  # 枖
    0x6797: 'lín',  # 林
    0x6798: 'ruì',  # 枘
    0x6799: 'ě,è',  # 枙
    0x679A: 'méi',  # 枚
    0x679B: 'zhào',  # 枛
    0x679C: 'guǒ',  # 果
    0x679D: 'zhī,qí',  # 枝
    0x679E: 'cōng,zōng',  # 枞
    0x679F: 'yùn',  # 枟
    0x67A0: 'huà',  # 枠
    0x67A1: 'shēng',  # 枡
    0x67A2: 'shū',  # 枢
    0x67A3: 'zǎo',  # 枣
    0x67A4: 'dì,duò',  # 枤
    0x67A5: 'lì',  # 枥
    0x67A6: 'lú',  # 枦
    0x67A7: 'jiǎn',  # 枧
    0x67A8: 'chéng',  # 枨
    0x67A9: 'sōng',  # 枩
    0x67AA: 'qiāng',  # 枪
    0x67AB: 'fēng',  # 枫
    0x67AC: 'zhān',  # 枬
    0x67AD: 'xiāo',  # 枭
    0x67AE: 'xiān,zhēn',  # 枮
    0x67AF: 'kū',  # 枯
    0x67B0: 'píng',  # 枰
    0x67B1: 'sì,tái',  # 枱
    0x67B2: 'xǐ',  # 枲
    0x67B3: 'zhǐ',  # 枳
    0x67B4: 'guǎi',  # 枴
    0x67B5: 'xiāo',  # 枵
    0x67B6: 'jià',  # 架
    0x67B7: 'jiā',  # 枷
    0x67B8: 'jǔ,gǒu',  # 枸
    0x67B9: 'bāo,fú',  # 枹
    0x67BA: 'mò',  # 枺
    0x67BB: 'yì,xiè',  # 枻
    0x67BC: 'yè',  # 枼
    0x67BD: 'yè',  # 枽
    0x67BE: 'shì',  # 枾
    0x67BF: 'niè',  # 枿
    0x67C0: 'bǐ',  # 柀
    0x67C1: 'tuó,duò',  # 柁
    0x67C2: 'yí,duò,lí',  # 柂
    0x67C3: 'líng',  # 柃
    0x67C4: 'bǐng',  # 柄
    0x67C5: 'nǐ,chì',  # 柅
    0x67C6: 'lā',  # 柆
    0x67C7: 'hé',  # 柇
    0x67C8: 'pán,bàn',  # 柈
    0x67C9: 'fán',  # 柉
    0x67CA: 'zhōng',  # 柊
    0x67CB: 'dài',  # 柋
    0x67CC: 'cí',  # 柌
    0x67CD: 'yǎng,yàng,yāng,yīng',  # 柍
    0x67CE: 'fū,fǔ,fù',  # 柎
    0x67CF: 'bǎi,bó,bò',  # 柏
    0x67D0: 'mǒu',  # 某
    0x67D1: 'gān',  # 柑
    0x67D2: 'qī',  # 柒
    0x67D3: 'rǎn',  # 染
    0x67D4: 'róu',  # 柔
    0x67D5: 'mào',  # 柕
    0x67D6: 'sháo,shào',  # 柖
    0x67D7: 'sōng',  # 柗
    0x67D8: 'zhè',  # 柘
    0x67D9: 'xiá',  # 柙
    0x67DA: 'yòu,yóu',  # 柚
    0x67DB: 'shēn',  # 柛
    0x67DC: 'guì,jǔ',  # 柜
    0x67DD: 'tuò',  # 柝
    0x67DE: 'zuò,zhà',  # 柞
    0x67DF: 'nán',  # 柟
    0x67E0: 'níng',  # 柠
    0x67E1: 'yǒng',  # 柡
    0x67E2: 'dǐ,chí',  # 柢
    0x67E3: 'zhì,dié',  # 柣
    0x67E4: 'zhā,zǔ,zū',  # 柤
    0x67E5: 'chá,zhā',  # 查
    0x67E6: 'dàn',  # 柦
    0x67E7: 'gū',  # 柧
    0x67E8: 'bù,pū',  # 柨
    0x67E9: 'jiù',  # 柩
    0x67EA: 'āo,ào',  # 柪
    0x67EB: 'fú',  # 柫
    0x67EC: 'jiǎn',  # 柬
    0x67ED: 'bā,fú,pèi,bó,biē',  # 柭
    0x67EE: 'duò,zuó,wù',  # 柮
    0x67EF: 'kē',  # 柯
    0x67F0: 'nài',  # 柰
    0x67F1: 'zhù',  # 柱
    0x67F2: 'bì,bié',  # 柲
    0x67F3: 'liǔ',  # 柳
    0x67F4: 'chái',  # 柴
    0x67F5: 'shān',  # 柵
    0x67F6: 'sì',  # 柶
    0x67F7: 'zhù',  # 柷
    0x67F8: 'bēi,pēi',  # 柸
    0x67F9: 'shì,fèi',  # 柹
    0x67FA: 'guǎi',  # 柺
    0x67FB: 'chá,zhā',  # 査
    0x67FC: 'yǎo',  # 柼
    0x67FD: 'chēng',  # 柽
    0x67FE: 'jiù',  # 柾
    0x67FF: 'shì',  # 柿
    0x6800: 'zhī',  # 栀
    0x6801: 'liǔ',  # 栁
    0x6802: 'méi',  # 栂
    0x6803: 'lì',  # 栃
    0x6804: 'róng',  # 栄
    0x6805: 'zhà,shān,shi,cè',  # 栅
    0x6806: 'zǎo',  # 栆
    0x6807: 'biāo',  # 标
    0x6808: 'zhàn',  # 栈
    0x6809: 'zhì',  # 栉
    0x680A: 'lóng',  # 栊
    0x680B: 'dòng',  # 栋
    0x680C: 'lú',  # 栌
    0x680D: 'saeng',  # 栍
    0x680E: 'lì,yuè',  # 栎
    0x680F: 'lán',  # 栏
    0x6810: 'yǒng',  # 栐
    0x6811: 'shù',  # 树
    0x6812: 'xún',  # 栒
    0x6813: 'shuān',  # 栓
    0x6814: 'qì,qiè',  # 栔
    0x6815: 'chén',  # 栕
    0x6816: 'qī,xī',  # 栖
    0x6817: 'lì',  # 栗
    0x6818: 'yí',  # 栘
    0x6819: 'xiáng',  # 栙
    0x681A: 'zhèn',  # 栚
    0x681B: 'lì',  # 栛
    0x681C: 'sè',  # 栜
    0x681D: 'guā,tiǎn',  # 栝
    0x681E: 'kān',  # 栞
    0x681F: 'bēn,bīng',  # 栟
    0x6820: 'rěn',  # 栠
    0x6821: 'xiào,jiào',  # 校
    0x6822: 'bǎi',  # 栢
    0x6823: 'rěn',  # 栣
    0x6824: 'bìng',  # 栤
    0x6825: 'zī',  # 栥
    0x6826: 'chóu',  # 栦
    0x6827: 'yì,xiè',  # 栧
    0x6828: 'cì',  # 栨
    0x6829: 'xǔ',  # 栩
    0x682A: 'zhū',  # 株
    0x682B: 'jiàn,zùn',  # 栫
    0x682C: 'zuì',  # 栬
    0x682D: 'ér',  # 栭
    0x682E: 'ěr',  # 栮
    0x682F: 'yǒu,yù',  # 栯
    0x6830: 'fá',  # 栰
    0x6831: 'gǒng',  # 栱
    0x6832: 'kǎo',  # 栲
    0x6833: 'lǎo',  # 栳
    0x6834: 'zhān',  # 栴
    0x6835: 'liè',  # 栵
    0x6836: 'yīn',  # 栶
    0x6837: 'yàng',  # 样
    0x6838: 'hé,hú',  # 核
    0x6839: 'gēn',  # 根
    0x683A: 'zhī,yì',  # 栺
    0x683B: 'shì',  # 栻
    0x683C: 'gé',  # 格
    0x683D: 'zāi',  # 栽
    0x683E: 'luán',  # 栾
    0x683F: 'fú',  # 栿
    0x6840: 'jié',  # 桀
    0x6841: 'héng,háng',  # 桁
    0x6842: 'guì',  # 桂
    0x6843: 'táo',  # 桃
    0x6844: 'guāng,guàng',  # 桄
    0x6845: 'wéi',  # 桅
    0x6846: 'kuàng',  # 框
    0x6847: 'rú',  # 桇
    0x6848: 'àn',  # 案
    0x6849: 'ān',  # 桉
    0x684A: 'juàn',  # 桊
    0x684B: 'yí,tí',  # 桋
    0x684C: 'zhuō',  # 桌
    0x684D: 'kū',  # 桍
    0x684E: 'zhì',  # 桎
    0x684F: 'qióng',  # 桏
    0x6850: 'tóng',  # 桐
    0x6851: 'sāng',  # 桑
    0x6852: 'sāng',  # 桒
    0x6853: 'huán',  # 桓
    0x6854: 'jié,jú',  # 桔
    0x6855: 'jiù',  # 桕
    0x6856: 'xuè',  # 桖
    0x6857: 'duò',  # 桗
    0x6858: 'chuí',  # 桘
    0x6859: 'yú,móu',  # 桙
    0x685A: 'zā,zǎn',  # 桚
    0x685B: 'kasei',  # 桛
    0x685C: 'yīng',  # 桜
    0x685D: 'jié',  # 桝
    0x685E: 'liǔ',  # 桞
    0x685F: 'zhàn',  # 桟
    0x6860: 'yā',  # 桠
    0x6861: 'ráo,náo',  # 桡
    0x6862: 'zhēn',  # 桢
    0x6863: 'dàng',  # 档
    0x6864: 'qī',  # 桤
    0x6865: 'qiáo',  # 桥
    0x6866: 'huà',  # 桦
    0x6867: 'guì,huì',  # 桧
    0x6868: 'jiǎng',  # 桨
    0x6869: 'zhuāng',  # 桩
    0x686A: 'xún',  # 桪
    0x686B: 'suō',  # 桫
    0x686C: 'shā',  # 桬
    0x686D: 'chén,zhèn',  # 桭
    0x686E: 'bēi',  # 桮
    0x686F: 'tīng,yíng',  # 桯
    0x6870: 'guā',  # 桰
    0x6871: 'jìng',  # 桱
    0x6872: 'bó',  # 桲
    0x6873: 'bèn,fàn',  # 桳
    0x6874: 'fú',  # 桴
    0x6875: 'ruí',  # 桵
    0x6876: 'tǒng',  # 桶
    0x6877: 'jué',  # 桷
    0x6878: 'xī',  # 桸
    0x6879: 'láng',  # 桹
    0x687A: 'liǔ',  # 桺
    0x687B: 'fēng,fèng',  # 桻
    0x687C: 'qī',  # 桼
    0x687D: 'wěn',  # 桽
    0x687E: 'jūn',  # 桾
    0x687F: 'gǎn',  # 桿
    0x6880: 'sù,yìn',  # 梀
    0x6881: 'liáng',  # 梁
    0x6882: 'qiú',  # 梂
    0x6883: 'tǐng,tìng',  # 梃
    0x6884: 'yǒu',  # 梄
    0x6885: 'méi',  # 梅
    0x6886: 'bāng',  # 梆
    0x6887: 'lòng',  # 梇
    0x6888: 'pēng',  # 梈
    0x6889: 'zhuāng',  # 梉
    0x688A: 'dì',  # 梊
    0x688B: 'xuān,juān,xié',  # 梋
    0x688C: 'tú,chá',  # 梌
    0x688D: 'zào',  # 梍
    0x688E: 'āo,yòu',  # 梎
    0x688F: 'gù',  # 梏
    0x6890: 'bì',  # 梐
    0x6891: 'dí',  # 梑
    0x6892: 'hán',  # 梒
    0x6893: 'zǐ',  # 梓
    0x6894: 'zhī',  # 梔
    0x6895: 'rèn,ér',  # 梕
    0x6896: 'bèi',  # 梖
    0x6897: 'gěng',  # 梗
    0x6898: 'jiǎn',  # 梘
    0x6899: 'huàn',  # 梙
    0x689A: 'wǎn',  # 梚
    0x689B: 'nuó',  # 梛
    0x689C: 'jiā',  # 梜
    0x689D: 'tiáo,tiāo',  # 條
    0x689E: 'jì',  # 梞
    0x689F: 'xiāo',  # 梟
    0x68A0: 'lǚ',  # 梠
    0x68A1: 'kuǎn',  # 梡
    0x68A2: 'shāo,sào',  # 梢
    0x68A3: 'chén',  # 梣
    0x68A4: 'fēn',  # 梤
    0x68A5: 'sōng',  # 梥
    0x68A6: 'mèng',  # 梦
    0x68A7: 'wú',  # 梧
    0x68A8: 'lí',  # 梨
    0x68A9: 'sì,qǐ',  # 梩
    0x68AA: 'dòu',  # 梪
    0x68AB: 'qǐn',  # 梫
    0x68AC: 'yǐng',  # 梬
    0x68AD: 'suō',  # 梭
    0x68AE: 'jū',  # 梮
    0x68AF: 'tī',  # 梯
    0x68B0: 'xiè',  # 械
    0x68B1: 'kǔn',  # 梱
    0x68B2: 'zhuō',  # 梲
    0x68B3: 'shū',  # 梳
    0x68B4: 'chān,yán',  # 梴
    0x68B5: 'fàn',  # 梵
    0x68B6: 'wěi',  # 梶
    0x68B7: 'jìng',  # 梷
    0x68B8: 'lí',  # 梸
    0x68B9: 'bīn,bīng',  # 梹
    0x68BA: 'xià',  # 梺
    0x68BB: 'fó',  # 梻
    0x68BC: 'chóu,táo,dào',  # 梼
    0x68BD: 'zhì',  # 梽
    0x68BE: 'lái',  # 梾
    0x68BF: 'lián,liǎn',  # 梿
    0x68C0: 'jiǎn',  # 检
    0x68C1: 'zhuō',  # 棁
    0x68C2: 'líng',  # 棂
    0x68C3: 'lí',  # 棃
    0x68C4: 'qì',  # 棄
    0x68C5: 'bǐng',  # 棅
    0x68C6: 'lún',  # 棆
    0x68C7: 'cōng,sōng',  # 棇
    0x68C8: 'qiàn',  # 棈
    0x68C9: 'mián',  # 棉
    0x68CA: 'qí',  # 棊
    0x68CB: 'qí',  # 棋
    0x68CC: 'cǎi',  # 棌
    0x68CD: 'gùn,hùn',  # 棍
    0x68CE: 'chán',  # 棎
    0x68CF: 'dé,zhé',  # 棏
    0x68D0: 'fěi',  # 棐
    0x68D1: 'pái,bèi,pèi',  # 棑
    0x68D2: 'bàng',  # 棒
    0x68D3: 'bàng,pǒu,bèi,bēi',  # 棓
    0x68D4: 'hūn',  # 棔
    0x68D5: 'zōng',  # 棕
    0x68D6: 'chéng',  # 棖
    0x68D7: 'zǎo',  # 棗
    0x68D8: 'jí',  # 棘
    0x68D9: 'lì,liè',  # 棙
    0x68DA: 'péng',  # 棚
    0x68DB: 'yù',  # 棛
    0x68DC: 'yù',  # 棜
    0x68DD: 'gù',  # 棝
    0x68DE: 'jùn',  # 棞
    0x68DF: 'dòng',  # 棟
    0x68E0: 'táng',  # 棠
    0x68E1: 'gāng',  # 棡
    0x68E2: 'wǎng',  # 棢
    0x68E3: 'dì,dài,tì',  # 棣
    0x68E4: 'què',  # 棤
    0x68E5: 'fán',  # 棥
    0x68E6: 'chēng',  # 棦
    0x68E7: 'zhàn',  # 棧
    0x68E8: 'qǐ',  # 棨
    0x68E9: 'yuān',  # 棩
    0x68EA: 'yǎn,yàn',  # 棪
    0x68EB: 'yù',  # 棫
    0x68EC: 'quān,juàn',  # 棬
    0x68ED: 'yì',  # 棭
    0x68EE: 'sēn',  # 森
    0x68EF: 'rěn,shěn',  # 棯
    0x68F0: 'chuí',  # 棰
    0x68F1: 'léng,lēng,líng',  # 棱
    0x68F2: 'qī',  # 棲
    0x68F3: 'zhuō',  # 棳
    0x68F4: 'fú,sù',  # 棴
    0x68F5: 'kē',  # 棵
    0x68F6: 'lái',  # 棶
    0x68F7: 'zōu,sǒu',  # 棷
    0x68F8: 'zōu',  # 棸
    0x68F9: 'zhào,zhuō',  # 棹
    0x68FA: 'guān',  # 棺
    0x68FB: 'fēn',  # 棻
    0x68FC: 'fén',  # 棼
    0x68FD: 'chēn,shēn',  # 棽
    0x68FE: 'qíng',  # 棾
    0x68FF: 'ní,nǐ',  # 棿
    0x6900: 'wǎn',  # 椀
    0x6901: 'guǒ',  # 椁
    0x6902: 'lù',  # 椂
    0x6903: 'háo',  # 椃
    0x6904: 'jiē,qiè',  # 椄
    0x6905: 'yǐ,yī',  # 椅
    0x6906: 'chóu,zhòu,diāo',  # 椆
    0x6907: 'jǔ',  # 椇
    0x6908: 'jú',  # 椈
    0x6909: 'chéng,shèng',  # 椉
    0x690A: 'zú,cuì',  # 椊
    0x690B: 'liáng',  # 椋
    0x690C: 'qiāng,kōng',  # 椌
    0x690D: 'zhí',  # 植
    0x690E: 'zhuī,chuí',  # 椎
    0x690F: 'yā',  # 椏
    0x6910: 'jū',  # 椐
    0x6911: 'bēi',  # 椑
    0x6912: 'jiāo',  # 椒
    0x6913: 'zhuó',  # 椓
    0x6914: 'zī',  # 椔
    0x6915: 'bīn',  # 椕
    0x6916: 'péng',  # 椖
    0x6917: 'dìng',  # 椗
    0x6918: 'chǔ',  # 椘
    0x6919: 'chāng',  # 椙
    0x691A: 'mēn',  # 椚
    0x691B: 'huā',  # 椛
    0x691C: 'jiǎn',  # 検
    0x691D: 'guī',  # 椝
    0x691E: 'xì',  # 椞
    0x691F: 'dú',  # 椟
    0x6920: 'qiàn',  # 椠
    0x6921: 'dào',  # 椡
    0x6922: 'guì',  # 椢
    0x6923: 'diǎn',  # 椣
    0x6924: 'luó',  # 椤
    0x6925: 'zhī',  # 椥
    0x6926: 'quān,juàn,quán',  # 椦
    0x6927: 'myeong',  # 椧
    0x6928: 'fǔ',  # 椨
    0x6929: 'gēng',  # 椩
    0x692A: 'pèng',  # 椪
    0x692B: 'shàn',  # 椫
    0x692C: 'yí',  # 椬
    0x692D: 'tuǒ',  # 椭
    0x692E: 'sēn',  # 椮
    0x692F: 'duǒ,chuán',  # 椯
    0x6930: 'yē',  # 椰
    0x6931: 'fù',  # 椱
    0x6932: 'wěi,huī',  # 椲
    0x6933: 'wēi',  # 椳
    0x6934: 'duàn',  # 椴
    0x6935: 'jiǎ,jiā',  # 椵
    0x6936: 'zōng',  # 椶
    0x6937: 'jiān,hán',  # 椷
    0x6938: 'yí',  # 椸
    0x6939: 'zhēn,shèn',  # 椹
    0x693A: 'xí',  # 椺
    0x693B: 'yàn,yà',  # 椻
    0x693C: 'yǎn',  # 椼
    0x693D: 'chuán',  # 椽
    0x693E: 'jiān',  # 椾
    0x693F: 'chūn',  # 椿
    0x6940: 'yǔ',  # 楀
    0x6941: 'hé',  # 楁
    0x6942: 'zhā,chá',  # 楂
    0x6943: 'wò',  # 楃
    0x6944: 'piān',  # 楄
    0x6945: 'bī',  # 楅
    0x6946: 'yāo',  # 楆
    0x6947: 'guō,kuǎ',  # 楇
    0x6948: 'xū',  # 楈
    0x6949: 'ruò',  # 楉
    0x694A: 'yáng',  # 楊
    0x694B: 'là',  # 楋
    0x694C: 'yán',  # 楌
    0x694D: 'běn',  # 楍
    0x694E: 'huī',  # 楎
    0x694F: 'kuí',  # 楏
    0x6950: 'jiè',  # 楐
    0x6951: 'kuí',  # 楑
    0x6952: 'sī',  # 楒
    0x6953: 'fēng',  # 楓
    0x6954: 'xiē',  # 楔
    0x6955: 'tuǒ',  # 楕
    0x6956: 'jí,zhì',  # 楖
    0x6957: 'jiàn',  # 楗
    0x6958: 'mù',  # 楘
    0x6959: 'máo',  # 楙
    0x695A: 'chǔ',  # 楚
    0x695B: 'kǔ,hù',  # 楛
    0x695C: 'hú',  # 楜
    0x695D: 'liàn',  # 楝
    0x695E: 'léng',  # 楞
    0x695F: 'tíng',  # 楟
    0x6960: 'nán',  # 楠
    0x6961: 'yú',  # 楡
    0x6962: 'yóu,yǒu',  # 楢
    0x6963: 'méi',  # 楣
    0x6964: 'sǒng,cōng',  # 楤
    0x6965: 'xuàn,yuán',  # 楥
    0x6966: 'xuàn',  # 楦
    0x6967: 'yǎng,yàng,yīng',  # 楧
    0x6968: 'zhēn',  # 楨
    0x6969: 'pián',  # 楩
    0x696A: 'dié,yè',  # 楪
    0x696B: 'jí',  # 楫
    0x696C: 'jiē',  # 楬
    0x696D: 'yè',  # 業
    0x696E: 'chǔ',  # 楮
    0x696F: 'shǔn,dùn',  # 楯
    0x6970: 'yú',  # 楰
    0x6971: 'còu,zòu',  # 楱
    0x6972: 'wēi',  # 楲
    0x6973: 'méi',  # 楳
    0x6974: 'dì,dǐ,shì',  # 楴
    0x6975: 'jí',  # 極
    0x6976: 'jié',  # 楶
    0x6977: 'kǎi,jiē',  # 楷
    0x6978: 'qiū',  # 楸
    0x6979: 'yíng',  # 楹
    0x697A: 'róu,ròu',  # 楺
    0x697B: 'huáng',  # 楻
    0x697C: 'lóu',  # 楼
    0x697D: 'lè,yuè',  # 楽
    0x697E: 'quán',  # 楾
    0x697F: 'xiāng',  # 楿
    0x6980: 'pǐn',  # 榀
    0x6981: 'shǐ',  # 榁
    0x6982: 'gài',  # 概
    0x6983: 'tán',  # 榃
    0x6984: 'lǎn',  # 榄
    0x6985: 'wēn,yùn',  # 榅
    0x6986: 'yú',  # 榆
    0x6987: 'chèn',  # 榇
    0x6988: 'lǘ',  # 榈
    0x6989: 'jǔ',  # 榉
    0x698A: 'shén',  # 榊
    0x698B: 'chū',  # 榋
    0x698C: 'bī,pi',  # 榌
    0x698D: 'xiè',  # 榍
    0x698E: 'jiǎ',  # 榎
    0x698F: 'yì',  # 榏
    0x6990: 'zhǎn,niǎn,zhèn',  # 榐
    0x6991: 'fú,fù,bó',  # 榑
    0x6992: 'nuò',  # 榒
    0x6993: 'mì',  # 榓
    0x6994: 'láng',  # 榔
    0x6995: 'róng',  # 榕
    0x6996: 'gǔ',  # 榖
    0x6997: 'jiàn,jìn',  # 榗
    0x6998: 'jǔ',  # 榘
    0x6999: 'tā',  # 榙
    0x699A: 'yǎo',  # 榚
    0x699B: 'zhēn',  # 榛
    0x699C: 'bǎng,bàng',  # 榜
    0x699D: 'shā,xiè',  # 榝
    0x699E: 'yuán',  # 榞
    0x699F: 'zǐ',  # 榟
    0x69A0: 'míng',  # 榠
    0x69A1: 'sù',  # 榡
    0x69A2: 'jià',  # 榢
    0x69A3: 'yáo',  # 榣
    0x69A4: 'jié',  # 榤
    0x69A5: 'huàng',  # 榥
    0x69A6: 'gàn',  # 榦
    0x69A7: 'fěi',  # 榧
    0x69A8: 'zhà',  # 榨
    0x69A9: 'qián',  # 榩
    0x69AA: 'mà,mā',  # 榪
    0x69AB: 'sǔn',  # 榫
    0x69AC: 'yuán',  # 榬
    0x69AD: 'xiè',  # 榭
    0x69AE: 'róng',  # 榮
    0x69AF: 'shí',  # 榯
    0x69B0: 'zhī',  # 榰
    0x69B1: 'cuī',  # 榱
    0x69B2: 'wēn',  # 榲
    0x69B3: 'tíng',  # 榳
    0x69B4: 'liú',  # 榴
    0x69B5: 'róng',  # 榵
    0x69B6: 'táng',  # 榶
    0x69B7: 'què',  # 榷
    0x69B8: 'zhāi',  # 榸
    0x69B9: 'sì',  # 榹
    0x69BA: 'shèng',  # 榺
    0x69BB: 'tà',  # 榻
    0x69BC: 'kē',  # 榼
    0x69BD: 'xī',  # 榽
    0x69BE: 'gù',  # 榾
    0x69BF: 'qī',  # 榿
    0x69C0: 'gǎo',  # 槀
    0x69C1: 'gǎo',  # 槁
    0x69C2: 'sūn',  # 槂
    0x69C3: 'pán',  # 槃
    0x69C4: 'tāo',  # 槄
    0x69C5: 'gé',  # 槅
    0x69C6: 'chūn',  # 槆
    0x69C7: 'diān',  # 槇
    0x69C8: 'nòu',  # 槈
    0x69C9: 'jí',  # 槉
    0x69CA: 'shuò',  # 槊
    0x69CB: 'gòu',  # 構
    0x69CC: 'chuí',  # 槌
    0x69CD: 'qiāng',  # 槍
    0x69CE: 'chá',  # 槎
    0x69CF: 'qiǎn,lián,xiàn',  # 槏
    0x69D0: 'huái',  # 槐
    0x69D1: 'méi',  # 槑
    0x69D2: 'xù',  # 槒
    0x69D3: 'gàng',  # 槓
    0x69D4: 'gāo',  # 槔
    0x69D5: 'zhuō',  # 槕
    0x69D6: 'tuó',  # 槖
    0x69D7: 'qiáo',  # 槗
    0x69D8: 'yàng',  # 様
    0x69D9: 'diān,zhěn,zhēn',  # 槙
    0x69DA: 'jiǎ',  # 槚
    0x69DB: 'jiàn,kǎn',  # 槛
    0x69DC: 'zuì',  # 槜
    0x69DD: 'dǎo',  # 槝
    0x69DE: 'lóng',  # 槞
    0x69DF: 'bīn,bīng',  # 槟
    0x69E0: 'zhū',  # 槠
    0x69E1: 'sāng',  # 槡
    0x69E2: 'xí,dié',  # 槢
    0x69E3: 'jī,guī',  # 槣
    0x69E4: 'lián,liǎn',  # 槤
    0x69E5: 'huì',  # 槥
    0x69E6: 'róng,yōng',  # 槦
    0x69E7: 'qiàn',  # 槧
    0x69E8: 'guǒ',  # 槨
    0x69E9: 'gài',  # 槩
    0x69EA: 'gài',  # 槪
    0x69EB: 'tuán,shuàn,quán',  # 槫
    0x69EC: 'huà',  # 槬
    0x69ED: 'qì,sè',  # 槭
    0x69EE: 'sēn',  # 槮
    0x69EF: 'cuī,zhǐ',  # 槯
    0x69F0: 'pèng',  # 槰
    0x69F1: 'yǒu,chǎo',  # 槱
    0x69F2: 'hú',  # 槲
    0x69F3: 'jiǎng',  # 槳
    0x69F4: 'hù',  # 槴
    0x69F5: 'huàn',  # 槵
    0x69F6: 'guì',  # 槶
    0x69F7: 'niè',  # 槷
    0x69F8: 'yì',  # 槸
    0x69F9: 'gāo',  # 槹
    0x69FA: 'kāng',  # 槺
    0x69FB: 'guī',  # 槻
    0x69FC: 'guī',  # 槼
    0x69FD: 'cáo',  # 槽
    0x69FE: 'màn,wàn',  # 槾
    0x69FF: 'jǐn',  # 槿
    0x6A00: 'dī',  # 樀
    0x6A01: 'zhuāng',  # 樁
    0x6A02: 'lè,yuè,yào,lào',  # 樂
    0x6A03: 'láng',  # 樃
    0x6A04: 'chén',  # 樄
    0x6A05: 'cōng,zōng',  # 樅
    0x6A06: 'lí,chī',  # 樆
    0x6A07: 'xiū',  # 樇
    0x6A08: 'qíng',  # 樈
    0x6A09: 'shǎng',  # 樉
    0x6A0A: 'fán',  # 樊
    0x6A0B: 'tōng',  # 樋
    0x6A0C: 'guàn',  # 樌
    0x6A0D: 'zé',  # 樍
    0x6A0E: 'sù',  # 樎
    0x6A0F: 'léi,lěi',  # 樏
    0x6A10: 'lǔ',  # 樐
    0x6A11: 'liáng',  # 樑
    0x6A12: 'mì',  # 樒
    0x6A13: 'lóu',  # 樓
    0x6A14: 'cháo,jiǎo,chāo',  # 樔
    0x6A15: 'sù',  # 樕
    0x6A16: 'kē',  # 樖
    0x6A17: 'chū',  # 樗
    0x6A18: 'táng',  # 樘
    0x6A19: 'biāo',  # 標
    0x6A1A: 'lù',  # 樚
    0x6A1B: 'jiū,liáo',  # 樛
    0x6A1C: 'zhè',  # 樜
    0x6A1D: 'zhā',  # 樝
    0x6A1E: 'shū',  # 樞
    0x6A1F: 'zhāng',  # 樟
    0x6A20: 'mán',  # 樠
    0x6A21: 'mó,mú',  # 模
    0x6A22: 'niǎo,mù',  # 樢
    0x6A23: 'yàng',  # 樣
    0x6A24: 'tiáo',  # 樤
    0x6A25: 'péng',  # 樥
    0x6A26: 'zhù',  # 樦
    0x6A27: 'shā,xiè',  # 樧
    0x6A28: 'xī',  # 樨
    0x6A29: 'quán',  # 権
    0x6A2A: 'héng,hèng',  # 横
    0x6A2B: 'jiān',  # 樫
    0x6A2C: 'cōng',  # 樬
    0x6A2D: 'jī',  # 樭
    0x6A2E: 'yān',  # 樮
    0x6A2F: 'qiáng',  # 樯
    0x6A30: 'xuě',  # 樰
    0x6A31: 'yīng',  # 樱
    0x6A32: 'èr',  # 樲
    0x6A33: 'xún',  # 樳
    0x6A34: 'zhí',  # 樴
    0x6A35: 'qiáo',  # 樵
    0x6A36: 'zuī',  # 樶
    0x6A37: 'cóng',  # 樷
    0x6A38: 'pǔ',  # 樸
    0x6A39: 'shù',  # 樹
    0x6A3A: 'huà',  # 樺
    0x6A3B: 'guì',  # 樻
    0x6A3C: 'zhēn',  # 樼
    0x6A3D: 'zūn',  # 樽
    0x6A3E: 'yuè',  # 樾
    0x6A3F: 'shàn',  # 樿
    0x6A40: 'xī',  # 橀
    0x6A41: 'chūn',  # 橁
    0x6A42: 'diàn',  # 橂
    0x6A43: 'fá,fèi',  # 橃
    0x6A44: 'gǎn',  # 橄
    0x6A45: 'mó',  # 橅
    0x6A46: 'wú',  # 橆
    0x6A47: 'qiāo',  # 橇
    0x6A48: 'ráo,náo',  # 橈
    0x6A49: 'lìn',  # 橉
    0x6A4A: 'liú',  # 橊
    0x6A4B: 'qiáo',  # 橋
    0x6A4C: 'xiàn',  # 橌
    0x6A4D: 'rùn',  # 橍
    0x6A4E: 'fǎn',  # 橎
    0x6A4F: 'zhǎn,jiǎn',  # 橏
    0x6A50: 'tuó',  # 橐
    0x6A51: 'liáo',  # 橑
    0x6A52: 'yún',  # 橒
    0x6A53: 'shùn',  # 橓
    0x6A54: 'tuí,dūn',  # 橔
    0x6A55: 'chēng',  # 橕
    0x6A56: 'táng,chēng',  # 橖
    0x6A57: 'méng',  # 橗
    0x6A58: 'jú',  # 橘
    0x6A59: 'chéng',  # 橙
    0x6A5A: 'sù,qiū',  # 橚
    0x6A5B: 'jué',  # 橛
    0x6A5C: 'jué',  # 橜
    0x6A5D: 'tán,diàn',  # 橝
    0x6A5E: 'huì',  # 橞
    0x6A5F: 'jī',  # 機
    0x6A60: 'nuó',  # 橠
    0x6A61: 'xiàng',  # 橡
    0x6A62: 'tuǒ',  # 橢
    0x6A63: 'níng',  # 橣
    0x6A64: 'ruǐ',  # 橤
    0x6A65: 'zhū',  # 橥
    0x6A66: 'tóng,chuáng',  # 橦
    0x6A67: 'zēng,céng',  # 橧
    0x6A68: 'fén,fèn,fèi',  # 橨
    0x6A69: 'qióng',  # 橩
    0x6A6A: 'rǎn,yān',  # 橪
    0x6A6B: 'héng,hèng',  # 橫
    0x6A6C: 'qián',  # 橬
    0x6A6D: 'gū',  # 橭
    0x6A6E: 'liǔ',  # 橮
    0x6A6F: 'lào',  # 橯
    0x6A70: 'gāo',  # 橰
    0x6A71: 'chú',  # 橱
    0x6A72: 'xǐ',  # 橲
    0x6A73: 'shèng',  # 橳
    0x6A74: 'zǐ',  # 橴
    0x6A75: 'zān',  # 橵
    0x6A76: 'jǐ',  # 橶
    0x6A77: 'dōu',  # 橷
    0x6A78: 'jīng',  # 橸
    0x6A79: 'lǔ',  # 橹
    0x6A7A: 'xiàn',  # 橺
    0x6A7B: 'cū,chu',  # 橻
    0x6A7C: 'yuán',  # 橼
    0x6A7D: 'tà',  # 橽
    0x6A7E: 'shū,qiāo',  # 橾
    0x6A7F: 'jiāng',  # 橿
    0x6A80: 'tán',  # 檀
    0x6A81: 'lǐn',  # 檁
    0x6A82: 'nóng',  # 檂
    0x6A83: 'yǐn',  # 檃
    0x6A84: 'xí',  # 檄
    0x6A85: 'huì',  # 檅
    0x6A86: 'shān',  # 檆
    0x6A87: 'zuì',  # 檇
    0x6A88: 'xuán',  # 檈
    0x6A89: 'chēng',  # 檉
    0x6A8A: 'gàn',  # 檊
    0x6A8B: 'jū',  # 檋
    0x6A8C: 'zuì',  # 檌
    0x6A8D: 'yì',  # 檍
    0x6A8E: 'qín',  # 檎
    0x6A8F: 'pǔ',  # 檏
    0x6A90: 'yán',  # 檐
    0x6A91: 'léi',  # 檑
    0x6A92: 'fēng',  # 檒
    0x6A93: 'huǐ',  # 檓
    0x6A94: 'dàng',  # 檔
    0x6A95: 'jì',  # 檕
    0x6A96: 'suì',  # 檖
    0x6A97: 'bò',  # 檗
    0x6A98: 'píng,bò',  # 檘
    0x6A99: 'chéng',  # 檙
    0x6A9A: 'chǔ',  # 檚
    0x6A9B: 'zhuā',  # 檛
    0x6A9C: 'guì,huì',  # 檜
    0x6A9D: 'jí',  # 檝
    0x6A9E: 'jiě',  # 檞
    0x6A9F: 'jiǎ',  # 檟
    0x6AA0: 'qíng',  # 檠
    0x6AA1: 'zhái,shì,tú',  # 檡
    0x6AA2: 'jiǎn',  # 檢
    0x6AA3: 'qiáng',  # 檣
    0x6AA4: 'dào',  # 檤
    0x6AA5: 'yǐ',  # 檥
    0x6AA6: 'biāo,biǎo',  # 檦
    0x6AA7: 'sōng',  # 檧
    0x6AA8: 'shē',  # 檨
    0x6AA9: 'lǐn',  # 檩
    0x6AAA: 'lì',  # 檪
    0x6AAB: 'chá',  # 檫
    0x6AAC: 'méng',  # 檬
    0x6AAD: 'yín',  # 檭
    0x6AAE: 'chóu,táo,dǎo',  # 檮
    0x6AAF: 'tái',  # 檯
    0x6AB0: 'mián',  # 檰
    0x6AB1: 'qí',  # 檱
    0x6AB2: 'tuán',  # 檲
    0x6AB3: 'bīn,bīng',  # 檳
    0x6AB4: 'huò',  # 檴
    0x6AB5: 'jì',  # 檵
    0x6AB6: 'qiān,lián',  # 檶
    0x6AB7: 'nǐ,mí',  # 檷
    0x6AB8: 'níng',  # 檸
    0x6AB9: 'yī',  # 檹
    0x6ABA: 'gǎo',  # 檺
    0x6ABB: 'jiàn,kǎn',  # 檻
    0x6ABC: 'yǐn',  # 檼
    0x6ABD: 'nòu,ruǎn,rú',  # 檽
    0x6ABE: 'qǐng',  # 檾
    0x6ABF: 'yǎn',  # 檿
    0x6AC0: 'qí',  # 櫀
    0x6AC1: 'mì',  # 櫁
    0x6AC2: 'zhào',  # 櫂
    0x6AC3: 'guì',  # 櫃
    0x6AC4: 'chūn',  # 櫄
    0x6AC5: 'jī,jì',  # 櫅
    0x6AC6: 'kuí',  # 櫆
    0x6AC7: 'pó',  # 櫇
    0x6AC8: 'dèng',  # 櫈
    0x6AC9: 'chú',  # 櫉
    0x6ACA: 'gé',  # 櫊
    0x6ACB: 'mián',  # 櫋
    0x6ACC: 'yōu',  # 櫌
    0x6ACD: 'zhì',  # 櫍
    0x6ACE: 'huǎng,guǒ,gǔ',  # 櫎
    0x6ACF: 'qiān',  # 櫏
    0x6AD0: 'lěi',  # 櫐
    0x6AD1: 'léi,lěi',  # 櫑
    0x6AD2: 'sà',  # 櫒
    0x6AD3: 'lǔ',  # 櫓
    0x6AD4: 'lì',  # 櫔
    0x6AD5: 'cuán',  # 櫕
    0x6AD6: 'lǜ,chū',  # 櫖
    0x6AD7: 'miè,mèi',  # 櫗
    0x6AD8: 'huì',  # 櫘
    0x6AD9: 'ōu',  # 櫙
    0x6ADA: 'lǘ',  # 櫚
    0x6ADB: 'zhì',  # 櫛
    0x6ADC: 'gāo',  # 櫜
    0x6ADD: 'dú',  # 櫝
    0x6ADE: 'yuán',  # 櫞
    0x6ADF: 'lì,yuè',  # 櫟
    0x6AE0: 'fèi',  # 櫠
    0x6AE1: 'zhuó,zhù',  # 櫡
    0x6AE2: 'sǒu',  # 櫢
    0x6AE3: 'lián,liǎn',  # 櫣
    0x6AE4: 'jiàng',  # 櫤
    0x6AE5: 'chú',  # 櫥
    0x6AE6: 'qìng',  # 櫦
    0x6AE7: 'zhū',  # 櫧
    0x6AE8: 'lú',  # 櫨
    0x6AE9: 'yán',  # 櫩
    0x6AEA: 'lì',  # 櫪
    0x6AEB: 'zhū',  # 櫫
    0x6AEC: 'chèn',  # 櫬
    0x6AED: 'jué,jì',  # 櫭
    0x6AEE: 'è',  # 櫮
    0x6AEF: 'sū',  # 櫯
    0x6AF0: 'huái,guī',  # 櫰
    0x6AF1: 'niè',  # 櫱
    0x6AF2: 'yù',  # 櫲
    0x6AF3: 'lóng',  # 櫳
    0x6AF4: 'là,lài',  # 櫴
    0x6AF5: 'qiáo',  # 櫵
    0x6AF6: 'xiǎn',  # 櫶
    0x6AF7: 'guī',  # 櫷
    0x6AF8: 'jǔ',  # 櫸
    0x6AF9: 'xiāo',  # 櫹
    0x6AFA: 'líng',  # 櫺
    0x6AFB: 'yīng',  # 櫻
    0x6AFC: 'jiān',  # 櫼
    0x6AFD: 'yǐn',  # 櫽
    0x6AFE: 'yòu,yóu',  # 櫾
    0x6AFF: 'yíng',  # 櫿
    0x6B00: 'xiāng',  # 欀
    0x6B01: 'nóng',  # 欁
    0x6B02: 'bó',  # 欂
    0x6B03: 'chán,zhàn',  # 欃
    0x6B04: 'lán',  # 欄
    0x6B05: 'jǔ',  # 欅
    0x6B06: 'shuāng',  # 欆
    0x6B07: 'shè',  # 欇
    0x6B08: 'wéi,zuì',  # 欈
    0x6B09: 'cóng',  # 欉
    0x6B0A: 'quán',  # 權
    0x6B0B: 'qú',  # 欋
    0x6B0C: 'cáng',  # 欌
    0x6B0D: 'jiù',  # 欍
    0x6B0E: 'yù',  # 欎
    0x6B0F: 'luó',  # 欏
    0x6B10: 'lì',  # 欐
    0x6B11: 'cuán',  # 欑
    0x6B12: 'luán',  # 欒
    0x6B13: 'dǎng',  # 欓
    0x6B14: 'qú',  # 欔
    0x6B15: 'yán',  # 欕
    0x6B16: 'lǎn',  # 欖
    0x6B17: 'lán',  # 欗
    0x6B18: 'zhú',  # 欘
    0x6B19: 'léi',  # 欙
    0x6B1A: 'lǐ',  # 欚
    0x6B1B: 'bà',  # 欛
    0x6B1C: 'náng',  # 欜
    0x6B1D: 'yù',  # 欝
    0x6B1E: 'líng',  # 欞
    0x6B1F: 'guàn',  # 欟
    0x6B20: 'qiàn',  # 欠
    0x6B21: 'cì',  # 次
    0x6B22: 'huān',  # 欢
    0x6B23: 'xīn',  # 欣
    0x6B24: 'yú',  # 欤
    0x6B25: 'yù,yì',  # 欥
    0x6B26: 'qiān,xiān',  # 欦
    0x6B27: 'ōu',  # 欧
    0x6B28: 'xū',  # 欨
    0x6B29: 'chāo',  # 欩
    0x6B2A: 'chù,qù,xì',  # 欪
    0x6B2B: 'qì',  # 欫
    0x6B2C: 'kài,ài',  # 欬
    0x6B2D: 'yì,yīn',  # 欭
    0x6B2E: 'jué',  # 欮
    0x6B2F: 'xì,kài',  # 欯
    0x6B30: 'xù',  # 欰
    0x6B31: 'hē',  # 欱
    0x6B32: 'yù',  # 欲
    0x6B33: 'kuài',  # 欳
    0x6B34: 'láng',  # 欴
    0x6B35: 'kuǎn',  # 欵
    0x6B36: 'shuò,sòu',  # 欶
    0x6B37: 'xī',  # 欷
    0x6B38: 'èi,èi,ěi,èi,ǎi',  # 欸
    0x6B39: 'qī',  # 欹
    0x6B3A: 'qī',  # 欺
    0x6B3B: 'xū,chuā',  # 欻
    0x6B3C: 'chǐ,chuài',  # 欼
    0x6B3D: 'qīn',  # 欽
    0x6B3E: 'kuǎn',  # 款
    0x6B3F: 'kǎn,qiàn',  # 欿
    0x6B40: 'kuǎn',  # 歀
    0x6B41: 'kǎn,kè',  # 歁
    0x6B42: 'chuǎn,chuán',  # 歂
    0x6B43: 'shà',  # 歃
    0x6B44: 'guā',  # 歄
    0x6B45: 'yān,yīn',  # 歅
    0x6B46: 'xīn',  # 歆
    0x6B47: 'xiē',  # 歇
    0x6B48: 'yú',  # 歈
    0x6B49: 'qiàn',  # 歉
    0x6B4A: 'xiāo',  # 歊
    0x6B4B: 'yē',  # 歋
    0x6B4C: 'gē',  # 歌
    0x6B4D: 'wū',  # 歍
    0x6B4E: 'tàn',  # 歎
    0x6B4F: 'jìn,qūn',  # 歏
    0x6B50: 'ōu',  # 歐
    0x6B51: 'hū',  # 歑
    0x6B52: 'tì',  # 歒
    0x6B53: 'huān',  # 歓
    0x6B54: 'xū',  # 歔
    0x6B55: 'pēn',  # 歕
    0x6B56: 'xǐ',  # 歖
    0x6B57: 'xiào',  # 歗
    0x6B58: 'xū',  # 歘
    0x6B59: 'xī,shè',  # 歙
    0x6B5A: 'shàn',  # 歚
    0x6B5B: 'liǎn,hān',  # 歛
    0x6B5C: 'chù',  # 歜
    0x6B5D: 'yì',  # 歝
    0x6B5E: 'è',  # 歞
    0x6B5F: 'yú',  # 歟
    0x6B60: 'chuò',  # 歠
    0x6B61: 'huān',  # 歡
    0x6B62: 'zhǐ',  # 止
    0x6B63: 'zhèng,zhēng',  # 正
    0x6B64: 'cǐ',  # 此
    0x6B65: 'bù',  # 步
    0x6B66: 'wǔ',  # 武
    0x6B67: 'qí',  # 歧
    0x6B68: 'bù',  # 歨
    0x6B69: 'bù',  # 歩
    0x6B6A: 'wāi',  # 歪
    0x6B6B: 'jù',  # 歫
    0x6B6C: 'qián',  # 歬
    0x6B6D: 'zhì,chí',  # 歭
    0x6B6E: 'sè',  # 歮
    0x6B6F: 'chǐ',  # 歯
    0x6B70: 'sè,shà',  # 歰
    0x6B71: 'zhǒng',  # 歱
    0x6B72: 'suì',  # 歲
    0x6B73: 'suì',  # 歳
    0x6B74: 'lì',  # 歴
    0x6B75: 'zé',  # 歵
    0x6B76: 'yú',  # 歶
    0x6B77: 'lì',  # 歷
    0x6B78: 'guī',  # 歸
    0x6B79: 'dǎi',  # 歹
    0x6B7A: 'è',  # 歺
    0x6B7B: 'sǐ',  # 死
    0x6B7C: 'jiān',  # 歼
    0x6B7D: 'zhé',  # 歽
    0x6B7E: 'mò,wěn',  # 歾
    0x6B7F: 'mò',  # 歿
    0x6B80: 'yāo',  # 殀
    0x6B81: 'mò',  # 殁
    0x6B82: 'cú',  # 殂
    0x6B83: 'yāng',  # 殃
    0x6B84: 'tiǎn',  # 殄
    0x6B85: 'shēng',  # 殅
    0x6B86: 'dài',  # 殆
    0x6B87: 'shāng',  # 殇
    0x6B88: 'xù',  # 殈
    0x6B89: 'xùn',  # 殉
    0x6B8A: 'shū',  # 殊
    0x6B8B: 'cán',  # 残
    0x6B8C: 'jǐng',  # 殌
    0x6B8D: 'piǎo',  # 殍
    0x6B8E: 'qià',  # 殎
    0x6B8F: 'qiú',  # 殏
    0x6B90: 'sù',  # 殐
    0x6B91: 'qíng,jìng',  # 殑
    0x6B92: 'yǔn',  # 殒
    0x6B93: 'liàn',  # 殓
    0x6B94: 'yì',  # 殔
    0x6B95: 'fǒu,bó',  # 殕
    0x6B96: 'zhí,shi',  # 殖
    0x6B97: 'yè,yān,yàn',  # 殗
    0x6B98: 'cán',  # 殘
    0x6B99: 'hūn,mèi',  # 殙
    0x6B9A: 'dān',  # 殚
    0x6B9B: 'jí',  # 殛
    0x6B9C: 'dié',  # 殜
    0x6B9D: 'zhēn',  # 殝
    0x6B9E: 'yǔn',  # 殞
    0x6B9F: 'wēn',  # 殟
    0x6BA0: 'chòu',  # 殠
    0x6BA1: 'bìn',  # 殡
    0x6BA2: 'tì',  # 殢
    0x6BA3: 'jìn',  # 殣
    0x6BA4: 'shāng',  # 殤
    0x6BA5: 'yín',  # 殥
    0x6BA6: 'chī',  # 殦
    0x6BA7: 'jiù',  # 殧
    0x6BA8: 'kuì,huì',  # 殨
    0x6BA9: 'cuàn',  # 殩
    0x6BAA: 'yì',  # 殪
    0x6BAB: 'dān',  # 殫
    0x6BAC: 'dù',  # 殬
    0x6BAD: 'jiāng',  # 殭
    0x6BAE: 'liàn',  # 殮
    0x6BAF: 'bìn',  # 殯
    0x6BB0: 'dú',  # 殰
    0x6BB1: 'jiān',  # 殱
    0x6BB2: 'jiān',  # 殲
    0x6BB3: 'shū',  # 殳
    0x6BB4: 'ōu',  # 殴
    0x6BB5: 'duàn',  # 段
    0x6BB6: 'zhù',  # 殶
    0x6BB7: 'yīn,yān,yǐn',  # 殷
    0x6BB8: 'qìng,kēng,shēng',  # 殸
    0x6BB9: 'yì',  # 殹
    0x6BBA: 'shā',  # 殺
    0x6BBB: 'ké,qiào',  # 殻
    0x6BBC: 'ké,qiào',  # 殼
    0x6BBD: 'xiáo,yáo,xiào',  # 殽
    0x6BBE: 'xùn',  # 殾
    0x6BBF: 'diàn',  # 殿
    0x6BC0: 'huǐ',  # 毀
    0x6BC1: 'huǐ',  # 毁
    0x6BC2: 'gǔ',  # 毂
    0x6BC3: 'qiāo',  # 毃
    0x6BC4: 'jī',  # 毄
    0x6BC5: 'yì',  # 毅
    0x6BC6: 'ōu',  # 毆
    0x6BC7: 'huǐ',  # 毇
    0x6BC8: 'duàn',  # 毈
    0x6BC9: 'yī',  # 毉
    0x6BCA: 'xiāo',  # 毊
    0x6BCB: 'wú',  # 毋
    0x6BCC: 'guàn,wān',  # 毌
    0x6BCD: 'mǔ',  # 母
    0x6BCE: 'měi',  # 毎
    0x6BCF: 'měi',  # 每
    0x6BD0: 'ǎi',  # 毐
    0x6BD1: 'jiě',  # 毑
    0x6BD2: 'dú,dài',  # 毒
    0x6BD3: 'yù',  # 毓
    0x6BD4: 'bǐ',  # 比
    0x6BD5: 'bì',  # 毕
    0x6BD6: 'bì',  # 毖
    0x6BD7: 'pí',  # 毗
    0x6BD8: 'pí',  # 毘
    0x6BD9: 'bì',  # 毙
    0x6BDA: 'chán',  # 毚
    0x6BDB: 'máo',  # 毛
    0x6BDC: 'háo',  # 毜
    0x6BDD: 'cǎi',  # 毝
    0x6BDE: 'bǐ',  # 毞
    0x6BDF: 'liě',  # 毟
    0x6BE0: 'jiā',  # 毠
    0x6BE1: 'zhān',  # 毡
    0x6BE2: 'sāi',  # 毢
    0x6BE3: 'mù',  # 毣
    0x6BE4: 'tuò',  # 毤
    0x6BE5: 'xún,xùn',  # 毥
    0x6BE6: 'ěr',  # 毦
    0x6BE7: 'róng',  # 毧
    0x6BE8: 'xiǎn',  # 毨
    0x6BE9: 'jū',  # 毩
    0x6BEA: 'mú',  # 毪
    0x6BEB: 'háo',  # 毫
    0x6BEC: 'qiú',  # 毬
    0x6BED: 'dòu,nuò',  # 毭
    0x6BEE: 'shā',  # 毮
    0x6BEF: 'tǎn',  # 毯
    0x6BF0: 'péi',  # 毰
    0x6BF1: 'jū',  # 毱
    0x6BF2: 'duō',  # 毲
    0x6BF3: 'cuì',  # 毳
    0x6BF4: 'bī',  # 毴
    0x6BF5: 'sān',  # 毵
    0x6BF6: 'sān',  # 毶
    0x6BF7: 'mào',  # 毷
    0x6BF8: 'sāi,suī',  # 毸
    0x6BF9: 'shū',  # 毹
    0x6BFA: 'shū',  # 毺
    0x6BFB: 'tuò',  # 毻
    0x6BFC: 'hé',  # 毼
    0x6BFD: 'jiàn',  # 毽
    0x6BFE: 'tà',  # 毾
    0x6BFF: 'sān',  # 毿
    0x6C00: 'lǘ',  # 氀
    0x6C01: 'mú',  # 氁
    0x6C02: 'máo',  # 氂
    0x6C03: 'tóng',  # 氃
    0x6C04: 'rǒng',  # 氄
    0x6C05: 'chǎng',  # 氅
    0x6C06: 'pǔ',  # 氆
    0x6C07: 'lǔ',  # 氇
    0x6C08: 'zhān',  # 氈
    0x6C09: 'sào',  # 氉
    0x6C0A: 'zhān',  # 氊
    0x6C0B: 'méng',  # 氋
    0x6C0C: 'lǔ',  # 氌
    0x6C0D: 'qú',  # 氍
    0x6C0E: 'dié',  # 氎
    0x6C0F: 'shì,zhī',  # 氏
    0x6C10: 'dī,dǐ',  # 氐
    0x6C11: 'mín',  # 民
    0x6C12: 'jué',  # 氒
    0x6C13: 'méng,máng',  # 氓
    0x6C14: 'qì',  # 气
    0x6C15: 'piē',  # 氕
    0x6C16: 'nǎi',  # 氖
    0x6C17: 'qì',  # 気
    0x6C18: 'dāo',  # 氘
    0x6C19: 'xiān',  # 氙
    0x6C1A: 'chuān',  # 氚
    0x6C1B: 'fēn',  # 氛
    0x6C1C: 'yáng,rì',  # 氜
    0x6C1D: 'nèi',  # 氝
    0x6C1E: 'nèi',  # 氞
    0x6C1F: 'fú',  # 氟
    0x6C20: 'shēn',  # 氠
    0x6C21: 'dōng',  # 氡
    0x6C22: 'qīng',  # 氢
    0x6C23: 'qì',  # 氣
    0x6C24: 'yīn',  # 氤
    0x6C25: 'xī',  # 氥
    0x6C26: 'hài',  # 氦
    0x6C27: 'yǎng',  # 氧
    0x6C28: 'ān',  # 氨
    0x6C29: 'yà',  # 氩
    0x6C2A: 'kè',  # 氪
    0x6C2B: 'qīng',  # 氫
    0x6C2C: 'yà',  # 氬
    0x6C2D: 'dōng',  # 氭
    0x6C2E: 'dàn',  # 氮
    0x6C2F: 'lǜ',  # 氯
    0x6C30: 'qíng',  # 氰
    0x6C31: 'yǎng',  # 氱
    0x6C32: 'yūn',  # 氲
    0x6C33: 'yūn',  # 氳
    0x6C34: 'shuǐ',  # 水
    0x6C35: 'shuǐ',  # 氵
    0x6C36: 'zhěng,chéng,zhèng',  # 氶
    0x6C37: 'bīng',  # 氷
    0x6C38: 'yǒng',  # 永
    0x6C39: 'dàng',  # 氹
    0x6C3A: 'shuǐ',  # 氺
    0x6C3B: 'lè',  # 氻
    0x6C3C: 'nì',  # 氼
    0x6C3D: 'tǔn',  # 氽
    0x6C3E: 'fàn',  # 氾
    0x6C3F: 'guǐ,jiǔ',  # 氿
    0x6C40: 'tīng',  # 汀
    0x6C41: 'zhī',  # 汁
    0x6C42: 'qiú',  # 求
    0x6C43: 'bīn,pà,pā',  # 汃
    0x6C44: 'zè',  # 汄
    0x6C45: 'miǎn',  # 汅
    0x6C46: 'cuān',  # 汆
    0x6C47: 'huì',  # 汇
    0x6C48: 'diāo',  # 汈
    0x6C49: 'hàn',  # 汉
    0x6C4A: 'chà',  # 汊
    0x6C4B: 'zhuó,què',  # 汋
    0x6C4C: 'chuàn',  # 汌
    0x6C4D: 'wán',  # 汍
    0x6C4E: 'fàn',  # 汎
    0x6C4F: 'tài,dà',  # 汏
    0x6C50: 'xī',  # 汐
    0x6C51: 'tuō',  # 汑
    0x6C52: 'máng',  # 汒
    0x6C53: 'qiú',  # 汓
    0x6C54: 'qì',  # 汔
    0x6C55: 'shàn',  # 汕
    0x6C56: 'pìn',  # 汖
    0x6C57: 'hàn,hán',  # 汗
    0x6C58: 'qiān',  # 汘
    0x6C59: 'wū',  # 汙
    0x6C5A: 'wū',  # 汚
    0x6C5B: 'xùn',  # 汛
    0x6C5C: 'sì',  # 汜
    0x6C5D: 'rǔ',  # 汝
    0x6C5E: 'gǒng',  # 汞
    0x6C5F: 'jiāng',  # 江
    0x6C60: 'chí',  # 池
    0x6C61: 'wū',  # 污
    0x6C62: 'tu',  # 汢
    0x6C63: 'jiǔ',  # 汣
    0x6C64: 'tāng,shāng',  # 汤
    0x6C65: 'zhī,jì',  # 汥
    0x6C66: 'zhǐ',  # 汦
    0x6C67: 'qiān',  # 汧
    0x6C68: 'mì',  # 汨
    0x6C69: 'gǔ,yù',  # 汩
    0x6C6A: 'wāng',  # 汪
    0x6C6B: 'jǐng',  # 汫
    0x6C6C: 'jǐng',  # 汬
    0x6C6D: 'ruì',  # 汭
    0x6C6E: 'jūn',  # 汮
    0x6C6F: 'hóng',  # 汯
    0x6C70: 'tài',  # 汰
    0x6C71: 'tài',  # 汱
    0x6C72: 'jí',  # 汲
    0x6C73: 'biàn',  # 汳
    0x6C74: 'biàn',  # 汴
    0x6C75: 'gàn,hán,cén',  # 汵
    0x6C76: 'wèn,mén',  # 汶
    0x6C77: 'zhōng',  # 汷
    0x6C78: 'fāng,pāng',  # 汸
    0x6C79: 'xiōng',  # 汹
    0x6C7A: 'jué',  # 決
    0x6C7B: 'hǔ,huǎng',  # 汻
    0x6C7C: 'niú,yóu',  # 汼
    0x6C7D: 'qì',  # 汽
    0x6C7E: 'fén',  # 汾
    0x6C7F: 'xù',  # 汿
    0x6C80: 'xù',  # 沀
    0x6C81: 'qìn',  # 沁
    0x6C82: 'yí',  # 沂
    0x6C83: 'wò',  # 沃
    0x6C84: 'yún',  # 沄
    0x6C85: 'yuán',  # 沅
    0x6C86: 'hàng',  # 沆
    0x6C87: 'yǎn',  # 沇
    0x6C88: 'shěn,chén',  # 沈
    0x6C89: 'chén',  # 沉
    0x6C8A: 'dàn',  # 沊
    0x6C8B: 'yóu',  # 沋
    0x6C8C: 'dùn',  # 沌
    0x6C8D: 'hù',  # 沍
    0x6C8E: 'huò',  # 沎
    0x6C8F: 'qī',  # 沏
    0x6C90: 'mù',  # 沐
    0x6C91: 'nǜ,niǔ',  # 沑
    0x6C92: 'méi,mò',  # 沒
    0x6C93: 'tà,dá',  # 沓
    0x6C94: 'miǎn',  # 沔
    0x6C95: 'mì,wù',  # 沕
    0x6C96: 'chōng',  # 沖
    0x6C97: 'hóng,pāng',  # 沗
    0x6C98: 'bǐ',  # 沘
    0x6C99: 'shā,shà',  # 沙
    0x6C9A: 'zhǐ',  # 沚
    0x6C9B: 'pèi',  # 沛
    0x6C9C: 'pàn',  # 沜
    0x6C9D: 'zhuǐ,zǐ',  # 沝
    0x6C9E: 'zā',  # 沞
    0x6C9F: 'gōu',  # 沟
    0x6CA0: 'pài',  # 沠
    0x6CA1: 'méi,mò',  # 没
    0x6CA2: 'zé',  # 沢
    0x6CA3: 'fēng',  # 沣
    0x6CA4: 'òu,ōu',  # 沤
    0x6CA5: 'lì',  # 沥
    0x6CA6: 'lún',  # 沦
    0x6CA7: 'cāng',  # 沧
    0x6CA8: 'fēng',  # 沨
    0x6CA9: 'wéi',  # 沩
    0x6CAA: 'hù',  # 沪
    0x6CAB: 'mò',  # 沫
    0x6CAC: 'mèi',  # 沬
    0x6CAD: 'shù',  # 沭
    0x6CAE: 'jǔ,jù',  # 沮
    0x6CAF: 'zá',  # 沯
    0x6CB0: 'tuō,duó',  # 沰
    0x6CB1: 'tuó',  # 沱
    0x6CB2: 'tuó,duò',  # 沲
    0x6CB3: 'hé',  # 河
    0x6CB4: 'lì',  # 沴
    0x6CB5: 'mǐ,lì',  # 沵
    0x6CB6: 'yí,chí',  # 沶
    0x6CB7: 'fā',  # 沷
    0x6CB8: 'fèi',  # 沸
    0x6CB9: 'yóu',  # 油
    0x6CBA: 'tián',  # 沺
    0x6CBB: 'zhì',  # 治
    0x6CBC: 'zhǎo',  # 沼
    0x6CBD: 'gū',  # 沽
    0x6CBE: 'zhān',  # 沾
    0x6CBF: 'yán',  # 沿
    0x6CC0: 'sī',  # 泀
    0x6CC1: 'kuàng',  # 況
    0x6CC2: 'jiǒng',  # 泂
    0x6CC3: 'jū',  # 泃
    0x6CC4: 'xiè,yì',  # 泄
    0x6CC5: 'qiú',  # 泅
    0x6CC6: 'yì,dié',  # 泆
    0x6CC7: 'jiā',  # 泇
    0x6CC8: 'zhōng',  # 泈
    0x6CC9: 'quán',  # 泉
    0x6CCA: 'bó,pō',  # 泊
    0x6CCB: 'huì',  # 泋
    0x6CCC: 'mì,bì',  # 泌
    0x6CCD: 'bēn,bèn',  # 泍
    0x6CCE: 'zé',  # 泎
    0x6CCF: 'chù,shè',  # 泏
    0x6CD0: 'lè',  # 泐
    0x6CD1: 'yōu,yòu,āo',  # 泑
    0x6CD2: 'gū',  # 泒
    0x6CD3: 'hóng',  # 泓
    0x6CD4: 'gān',  # 泔
    0x6CD5: 'fǎ',  # 法
    0x6CD6: 'mǎo',  # 泖
    0x6CD7: 'sì',  # 泗
    0x6CD8: 'hū',  # 泘
    0x6CD9: 'pēng,píng',  # 泙
    0x6CDA: 'cǐ',  # 泚
    0x6CDB: 'fàn',  # 泛
    0x6CDC: 'zhī',  # 泜
    0x6CDD: 'sù',  # 泝
    0x6CDE: 'nìng',  # 泞
    0x6CDF: 'chēng',  # 泟
    0x6CE0: 'líng',  # 泠
    0x6CE1: 'pào,pāo',  # 泡
    0x6CE2: 'bō',  # 波
    0x6CE3: 'qì',  # 泣
    0x6CE4: 'sì',  # 泤
    0x6CE5: 'ní,nì',  # 泥
    0x6CE6: 'jú',  # 泦
    0x6CE7: 'yuè,sà',  # 泧
    0x6CE8: 'zhù',  # 注
    0x6CE9: 'shēng',  # 泩
    0x6CEA: 'lèi',  # 泪
    0x6CEB: 'xuàn',  # 泫
    0x6CEC: 'jué,xuè',  # 泬
    0x6CED: 'fú',  # 泭
    0x6CEE: 'pàn',  # 泮
    0x6CEF: 'mǐn',  # 泯
    0x6CF0: 'tài',  # 泰
    0x6CF1: 'yāng',  # 泱
    0x6CF2: 'jǐ',  # 泲
    0x6CF3: 'yǒng',  # 泳
    0x6CF4: 'guàn',  # 泴
    0x6CF5: 'bèng',  # 泵
    0x6CF6: 'xué',  # 泶
    0x6CF7: 'lóng,shuāng',  # 泷
    0x6CF8: 'lú',  # 泸
    0x6CF9: 'dàn',  # 泹
    0x6CFA: 'luò,pō',  # 泺
    0x6CFB: 'xiè',  # 泻
    0x6CFC: 'pō',  # 泼
    0x6CFD: 'zé,shì',  # 泽
    0x6CFE: 'jīng',  # 泾
    0x6CFF: 'yín',  # 泿
    0x6D00: 'pán',  # 洀
    0x6D01: 'jié',  # 洁
    0x6D02: 'yè',  # 洂
    0x6D03: 'huī',  # 洃
    0x6D04: 'huí',  # 洄
    0x6D05: 'zài',  # 洅
    0x6D06: 'chéng',  # 洆
    0x6D07: 'yīn',  # 洇
    0x6D08: 'wéi',  # 洈
    0x6D09: 'hòu',  # 洉
    0x6D0A: 'jiàn',  # 洊
    0x6D0B: 'yáng',  # 洋
    0x6D0C: 'liè',  # 洌
    0x6D0D: 'sì',  # 洍
    0x6D0E: 'jì',  # 洎
    0x6D0F: 'ér',  # 洏
    0x6D10: 'xíng',  # 洐
    0x6D11: 'fú,fù',  # 洑
    0x6D12: 'sǎ,xǐ',  # 洒
    0x6D13: 'sè,qì,zì',  # 洓
    0x6D14: 'zhǐ',  # 洔
    0x6D15: 'yìn',  # 洕
    0x6D16: 'wú',  # 洖
    0x6D17: 'xǐ,xiǎn',  # 洗
    0x6D18: 'kǎo,kào',  # 洘
    0x6D19: 'zhū',  # 洙
    0x6D1A: 'jiàng',  # 洚
    0x6D1B: 'luò',  # 洛
    0x6D1C: 'luò',  # 洜
    0x6D1D: 'àn,yàn,è',  # 洝
    0x6D1E: 'dòng',  # 洞
    0x6D1F: 'yí',  # 洟
    0x6D20: 'sì',  # 洠
    0x6D21: 'lěi,lèi',  # 洡
    0x6D22: 'yī',  # 洢
    0x6D23: 'mǐ',  # 洣
    0x6D24: 'quán',  # 洤
    0x6D25: 'jīn',  # 津
    0x6D26: 'pò',  # 洦
    0x6D27: 'wěi',  # 洧
    0x6D28: 'xiáo',  # 洨
    0x6D29: 'xiè',  # 洩
    0x6D2A: 'hóng',  # 洪
    0x6D2B: 'xù',  # 洫
    0x6D2C: 'sù,shuò',  # 洬
    0x6D2D: 'kuāng',  # 洭
    0x6D2E: 'táo',  # 洮
    0x6D2F: 'qiè,jié',  # 洯
    0x6D30: 'jù',  # 洰
    0x6D31: 'ěr',  # 洱
    0x6D32: 'zhōu',  # 洲
    0x6D33: 'rù',  # 洳
    0x6D34: 'píng',  # 洴
    0x6D35: 'xún',  # 洵
    0x6D36: 'xiōng',  # 洶
    0x6D37: 'zhì',  # 洷
    0x6D38: 'guāng',  # 洸
    0x6D39: 'huán',  # 洹
    0x6D3A: 'míng',  # 洺
    0x6D3B: 'huó',  # 活
    0x6D3C: 'wā',  # 洼
    0x6D3D: 'qià',  # 洽
    0x6D3E: 'pài',  # 派
    0x6D3F: 'wū',  # 洿
    0x6D40: 'qū',  # 浀
    0x6D41: 'liú',  # 流
    0x6D42: 'yì',  # 浂
    0x6D43: 'jiā',  # 浃
    0x6D44: 'jìng',  # 浄
    0x6D45: 'qiǎn,jiān',  # 浅
    0x6D46: 'jiāng,jiàng',  # 浆
    0x6D47: 'jiāo',  # 浇
    0x6D48: 'zhēn',  # 浈
    0x6D49: 'shī',  # 浉
    0x6D4A: 'zhuó',  # 浊
    0x6D4B: 'cè',  # 测
    0x6D4C: 'fá',  # 浌
    0x6D4D: 'kuài,huì',  # 浍
    0x6D4E: 'jì,jǐ',  # 济
    0x6D4F: 'liú',  # 浏
    0x6D50: 'chǎn',  # 浐
    0x6D51: 'hún',  # 浑
    0x6D52: 'hǔ,xǔ',  # 浒
    0x6D53: 'nóng',  # 浓
    0x6D54: 'xún',  # 浔
    0x6D55: 'jìn',  # 浕
    0x6D56: 'liè',  # 浖
    0x6D57: 'qiú',  # 浗
    0x6D58: 'wěi',  # 浘
    0x6D59: 'zhè',  # 浙
    0x6D5A: 'jùn,xùn',  # 浚
    0x6D5B: 'hán',  # 浛
    0x6D5C: 'bāng',  # 浜
    0x6D5D: 'máng',  # 浝
    0x6D5E: 'zhuó',  # 浞
    0x6D5F: 'yōu,dí',  # 浟
    0x6D60: 'xī',  # 浠
    0x6D61: 'bó',  # 浡
    0x6D62: 'dòu',  # 浢
    0x6D63: 'huàn',  # 浣
    0x6D64: 'hóng',  # 浤
    0x6D65: 'yì',  # 浥
    0x6D66: 'pǔ',  # 浦
    0x6D67: 'yǐng,chéng,yíng',  # 浧
    0x6D68: 'lǎn',  # 浨
    0x6D69: 'hào',  # 浩
    0x6D6A: 'làng',  # 浪
    0x6D6B: 'hǎn',  # 浫
    0x6D6C: 'lǐ',  # 浬
    0x6D6D: 'gēng',  # 浭
    0x6D6E: 'fú',  # 浮
    0x6D6F: 'wú',  # 浯
    0x6D70: 'lì',  # 浰
    0x6D71: 'chún',  # 浱
    0x6D72: 'féng,hóng',  # 浲
    0x6D73: 'yì',  # 浳
    0x6D74: 'yù',  # 浴
    0x6D75: 'tóng',  # 浵
    0x6D76: 'láo',  # 浶
    0x6D77: 'hǎi',  # 海
    0x6D78: 'jìn',  # 浸
    0x6D79: 'jiā',  # 浹
    0x6D7A: 'chōng',  # 浺
    0x6D7B: 'jiǒng,jiōng',  # 浻
    0x6D7C: 'měi',  # 浼
    0x6D7D: 'suī,něi',  # 浽
    0x6D7E: 'chēng',  # 浾
    0x6D7F: 'pèi',  # 浿
    0x6D80: 'xiàn',  # 涀
    0x6D81: 'shèn',  # 涁
    0x6D82: 'tú',  # 涂
    0x6D83: 'kùn',  # 涃
    0x6D84: 'pīng',  # 涄
    0x6D85: 'niè',  # 涅
    0x6D86: 'hàn',  # 涆
    0x6D87: 'jīng',  # 涇
    0x6D88: 'xiāo',  # 消
    0x6D89: 'shè',  # 涉
    0x6D8A: 'niǎn',  # 涊
    0x6D8B: 'tū',  # 涋
    0x6D8C: 'yǒng,chōng',  # 涌
    0x6D8D: 'xiào',  # 涍
    0x6D8E: 'xián',  # 涎
    0x6D8F: 'tǐng',  # 涏
    0x6D90: 'é',  # 涐
    0x6D91: 'sù',  # 涑
    0x6D92: 'tūn,yūn',  # 涒
    0x6D93: 'juān',  # 涓
    0x6D94: 'cén',  # 涔
    0x6D95: 'tì',  # 涕
    0x6D96: 'lì',  # 涖
    0x6D97: 'shuì',  # 涗
    0x6D98: 'sì',  # 涘
    0x6D99: 'lèi',  # 涙
    0x6D9A: 'shuì',  # 涚
    0x6D9B: 'tāo',  # 涛
    0x6D9C: 'dú',  # 涜
    0x6D9D: 'lào',  # 涝
    0x6D9E: 'lái',  # 涞
    0x6D9F: 'lián',  # 涟
    0x6DA0: 'wéi',  # 涠
    0x6DA1: 'wō,guō',  # 涡
    0x6DA2: 'yún',  # 涢
    0x6DA3: 'huàn',  # 涣
    0x6DA4: 'dí',  # 涤
    0x6DA5: 'hēng',  # 涥
    0x6DA6: 'rùn',  # 润
    0x6DA7: 'jiàn',  # 涧
    0x6DA8: 'zhǎng,zhàng',  # 涨
    0x6DA9: 'sè',  # 涩
    0x6DAA: 'fú',  # 涪
    0x6DAB: 'guān',  # 涫
    0x6DAC: 'xìng',  # 涬
    0x6DAD: 'shòu,tāo',  # 涭
    0x6DAE: 'shuàn',  # 涮
    0x6DAF: 'yá',  # 涯
    0x6DB0: 'chuò',  # 涰
    0x6DB1: 'zhàng',  # 涱
    0x6DB2: 'yè',  # 液
    0x6DB3: 'kōng,náng',  # 涳
    0x6DB4: 'wǎn,wò,yuān',  # 涴
    0x6DB5: 'hán',  # 涵
    0x6DB6: 'tuō,tuò',  # 涶
    0x6DB7: 'dōng',  # 涷
    0x6DB8: 'hé',  # 涸
    0x6DB9: 'wō',  # 涹
    0x6DBA: 'jū',  # 涺
    0x6DBB: 'shè',  # 涻
    0x6DBC: 'liáng,liàng',  # 涼
    0x6DBD: 'hūn',  # 涽
    0x6DBE: 'tà',  # 涾
    0x6DBF: 'zhuō',  # 涿
    0x6DC0: 'diàn',  # 淀
    0x6DC1: 'qiè,jí',  # 淁
    0x6DC2: 'dé',  # 淂
    0x6DC3: 'juàn',  # 淃
    0x6DC4: 'zī',  # 淄
    0x6DC5: 'xī',  # 淅
    0x6DC6: 'xiáo',  # 淆
    0x6DC7: 'qí',  # 淇
    0x6DC8: 'gǔ',  # 淈
    0x6DC9: 'guǒ,guàn',  # 淉
    0x6DCA: 'yān',  # 淊
    0x6DCB: 'lín,lìn',  # 淋
    0x6DCC: 'tǎng,chǎng',  # 淌
    0x6DCD: 'zhōu',  # 淍
    0x6DCE: 'pěng',  # 淎
    0x6DCF: 'hào',  # 淏
    0x6DD0: 'chāng',  # 淐
    0x6DD1: 'shū',  # 淑
    0x6DD2: 'qī',  # 淒
    0x6DD3: 'fāng',  # 淓
    0x6DD4: 'zhí',  # 淔
    0x6DD5: 'lù',  # 淕
    0x6DD6: 'nào,chuò,zhuō',  # 淖
    0x6DD7: 'jú',  # 淗
    0x6DD8: 'táo',  # 淘
    0x6DD9: 'cóng',  # 淙
    0x6DDA: 'lèi',  # 淚
    0x6DDB: 'zhè',  # 淛
    0x6DDC: 'píng,péng',  # 淜
    0x6DDD: 'féi',  # 淝
    0x6DDE: 'sōng',  # 淞
    0x6DDF: 'tiǎn',  # 淟
    0x6DE0: 'pì,pèi',  # 淠
    0x6DE1: 'dàn',  # 淡
    0x6DE2: 'yù,xù',  # 淢
    0x6DE3: 'ní',  # 淣
    0x6DE4: 'yū',  # 淤
    0x6DE5: 'lù',  # 淥
    0x6DE6: 'gàn',  # 淦
    0x6DE7: 'mì',  # 淧
    0x6DE8: 'jìng,chēng',  # 淨
    0x6DE9: 'líng',  # 淩
    0x6DEA: 'lún',  # 淪
    0x6DEB: 'yín',  # 淫
    0x6DEC: 'cuì',  # 淬
    0x6DED: 'qú',  # 淭
    0x6DEE: 'huái',  # 淮
    0x6DEF: 'yù',  # 淯
    0x6DF0: 'niǎn,shěn',  # 淰
    0x6DF1: 'shēn',  # 深
    0x6DF2: 'biāo,hǔ',  # 淲
    0x6DF3: 'chún,zhūn',  # 淳
    0x6DF4: 'hū',  # 淴
    0x6DF5: 'yuān',  # 淵
    0x6DF6: 'lái',  # 淶
    0x6DF7: 'hùn,hún',  # 混
    0x6DF8: 'qīng',  # 淸
    0x6DF9: 'yān',  # 淹
    0x6DFA: 'qiǎn',  # 淺
    0x6DFB: 'tiān',  # 添
    0x6DFC: 'miǎo',  # 淼
    0x6DFD: 'zhǐ',  # 淽
    0x6DFE: 'yǐn',  # 淾
    0x6DFF: 'bó',  # 淿
    0x6E00: 'bèn',  # 渀
    0x6E01: 'yuān',  # 渁
    0x6E02: 'wèn,mín',  # 渂
    0x6E03: 'ruò,rè,luò',  # 渃
    0x6E04: 'fēi',  # 渄
    0x6E05: 'qīng',  # 清
    0x6E06: 'yuān',  # 渆
    0x6E07: 'kě',  # 渇
    0x6E08: 'jì,jǐ',  # 済
    0x6E09: 'shè',  # 渉
    0x6E0A: 'yuān',  # 渊
    0x6E0B: 'sè',  # 渋
    0x6E0C: 'lù',  # 渌
    0x6E0D: 'zì',  # 渍
    0x6E0E: 'dú,dòu',  # 渎
    0x6E0F: 'yī',  # 渏
    0x6E10: 'jiàn,jiān',  # 渐
    0x6E11: 'miǎn,shéng',  # 渑
    0x6E12: 'pài',  # 渒
    0x6E13: 'xī',  # 渓
    0x6E14: 'yú',  # 渔
    0x6E15: 'yuān',  # 渕
    0x6E16: 'shěn',  # 渖
    0x6E17: 'shèn',  # 渗
    0x6E18: 'róu',  # 渘
    0x6E19: 'huàn',  # 渙
    0x6E1A: 'zhǔ',  # 渚
    0x6E1B: 'jiǎn',  # 減
    0x6E1C: 'nuǎn,nuán',  # 渜
    0x6E1D: 'yú',  # 渝
    0x6E1E: 'qiú,wù',  # 渞
    0x6E1F: 'tíng,tīng',  # 渟
    0x6E20: 'qú,jù',  # 渠
    0x6E21: 'dù',  # 渡
    0x6E22: 'fēng',  # 渢
    0x6E23: 'zhā',  # 渣
    0x6E24: 'bó',  # 渤
    0x6E25: 'wò',  # 渥
    0x6E26: 'wō,guō',  # 渦
    0x6E27: 'tí,dī,dì',  # 渧
    0x6E28: 'wěi',  # 渨
    0x6E29: 'wēn',  # 温
    0x6E2A: 'rú',  # 渪
    0x6E2B: 'xiè',  # 渫
    0x6E2C: 'cè',  # 測
    0x6E2D: 'wèi',  # 渭
    0x6E2E: 'hé',  # 渮
    0x6E2F: 'gǎng,jiǎng',  # 港
    0x6E30: 'yān,yǎn',  # 渰
    0x6E31: 'hóng',  # 渱
    0x6E32: 'xuàn',  # 渲
    0x6E33: 'mǐ',  # 渳
    0x6E34: 'kě',  # 渴
    0x6E35: 'máo',  # 渵
    0x6E36: 'yīng',  # 渶
    0x6E37: 'yǎn',  # 渷
    0x6E38: 'yóu',  # 游
    0x6E39: 'hōng,qìng',  # 渹
    0x6E3A: 'miǎo',  # 渺
    0x6E3B: 'shěng',  # 渻
    0x6E3C: 'měi',  # 渼
    0x6E3D: 'zāi',  # 渽
    0x6E3E: 'hún',  # 渾
    0x6E3F: 'nài',  # 渿
    0x6E40: 'guǐ',  # 湀
    0x6E41: 'chì',  # 湁
    0x6E42: 'è',  # 湂
    0x6E43: 'pài',  # 湃
    0x6E44: 'méi',  # 湄
    0x6E45: 'liàn',  # 湅
    0x6E46: 'qì',  # 湆
    0x6E47: 'qì',  # 湇
    0x6E48: 'méi',  # 湈
    0x6E49: 'tián',  # 湉
    0x6E4A: 'còu',  # 湊
    0x6E4B: 'wéi',  # 湋
    0x6E4C: 'cān',  # 湌
    0x6E4D: 'tuān',  # 湍
    0x6E4E: 'miǎn',  # 湎
    0x6E4F: 'huì,mǐn,xū',  # 湏
    0x6E50: 'pò',  # 湐
    0x6E51: 'xǔ,xū',  # 湑
    0x6E52: 'jí',  # 湒
    0x6E53: 'pén',  # 湓
    0x6E54: 'jiān',  # 湔
    0x6E55: 'jiǎn',  # 湕
    0x6E56: 'hú',  # 湖
    0x6E57: 'fèng',  # 湗
    0x6E58: 'xiāng',  # 湘
    0x6E59: 'yì',  # 湙
    0x6E5A: 'yìn',  # 湚
    0x6E5B: 'zhàn',  # 湛
    0x6E5C: 'shí',  # 湜
    0x6E5D: 'jiē',  # 湝
    0x6E5E: 'zhēn',  # 湞
    0x6E5F: 'huáng',  # 湟
    0x6E60: 'tàn',  # 湠
    0x6E61: 'yú',  # 湡
    0x6E62: 'bì',  # 湢
    0x6E63: 'mǐn,hūn',  # 湣
    0x6E64: 'shī',  # 湤
    0x6E65: 'tū',  # 湥
    0x6E66: 'shēng',  # 湦
    0x6E67: 'yǒng',  # 湧
    0x6E68: 'jú',  # 湨
    0x6E69: 'dòng',  # 湩
    0x6E6A: 'tuàn,nuǎn',  # 湪
    0x6E6B: 'qiū,jiǎo',  # 湫
    0x6E6C: 'qiū,jiǎo',  # 湬
    0x6E6D: 'qiú',  # 湭
    0x6E6E: 'yān,yīn',  # 湮
    0x6E6F: 'tāng,shāng',  # 湯
    0x6E70: 'lóng',  # 湰
    0x6E71: 'huò',  # 湱
    0x6E72: 'yuán',  # 湲
    0x6E73: 'nǎn',  # 湳
    0x6E74: 'bàn,pán',  # 湴
    0x6E75: 'yǒu',  # 湵
    0x6E76: 'quán',  # 湶
    0x6E77: 'zhuāng,hún',  # 湷
    0x6E78: 'liàng',  # 湸
    0x6E79: 'chán',  # 湹
    0x6E7A: 'xián',  # 湺
    0x6E7B: 'chún',  # 湻
    0x6E7C: 'niè',  # 湼
    0x6E7D: 'zī',  # 湽
    0x6E7E: 'wān',  # 湾
    0x6E7F: 'shī',  # 湿
    0x6E80: 'mǎn',  # 満
    0x6E81: 'yíng',  # 溁
    0x6E82: 'là',  # 溂
    0x6E83: 'kuì,huì',  # 溃
    0x6E84: 'féng,hóng',  # 溄
    0x6E85: 'jiàn,jiān',  # 溅
    0x6E86: 'xù',  # 溆
    0x6E87: 'lóu',  # 溇
    0x6E88: 'wéi',  # 溈
    0x6E89: 'gài',  # 溉
    0x6E8A: 'bō',  # 溊
    0x6E8B: 'yíng',  # 溋
    0x6E8C: 'pō',  # 溌
    0x6E8D: 'jìn',  # 溍
    0x6E8E: 'yàn,guì',  # 溎
    0x6E8F: 'táng',  # 溏
    0x6E90: 'yuán',  # 源
    0x6E91: 'suǒ',  # 溑
    0x6E92: 'yuán',  # 溒
    0x6E93: 'lián,liǎn,nián,xián,xiàn',  # 溓
    0x6E94: 'yǎo',  # 溔
    0x6E95: 'méng',  # 溕
    0x6E96: 'zhǔn',  # 準
    0x6E97: 'chéng',  # 溗
    0x6E98: 'kè',  # 溘
    0x6E99: 'tài',  # 溙
    0x6E9A: 'dá,tǎ',  # 溚
    0x6E9B: 'wā',  # 溛
    0x6E9C: 'liū,liù',  # 溜
    0x6E9D: 'gōu',  # 溝
    0x6E9E: 'sāo',  # 溞
    0x6E9F: 'míng',  # 溟
    0x6EA0: 'zhà',  # 溠
    0x6EA1: 'shí',  # 溡
    0x6EA2: 'yì',  # 溢
    0x6EA3: 'lùn',  # 溣
    0x6EA4: 'mǎ',  # 溤
    0x6EA5: 'pǔ',  # 溥
    0x6EA6: 'wēi',  # 溦
    0x6EA7: 'lì',  # 溧
    0x6EA8: 'zāi',  # 溨
    0x6EA9: 'wù',  # 溩
    0x6EAA: 'xī',  # 溪
    0x6EAB: 'wēn',  # 溫
    0x6EAC: 'qiāng',  # 溬
    0x6EAD: 'zé',  # 溭
    0x6EAE: 'shī',  # 溮
    0x6EAF: 'sù',  # 溯
    0x6EB0: 'ái',  # 溰
    0x6EB1: 'zhēn,qín',  # 溱
    0x6EB2: 'sōu',  # 溲
    0x6EB3: 'yún',  # 溳
    0x6EB4: 'xiù',  # 溴
    0x6EB5: 'yīn',  # 溵
    0x6EB6: 'róng',  # 溶
    0x6EB7: 'hùn',  # 溷
    0x6EB8: 'sù',  # 溸
    0x6EB9: 'suò',  # 溹
    0x6EBA: 'nì,niào',  # 溺
    0x6EBB: 'tā',  # 溻
    0x6EBC: 'shī',  # 溼
    0x6EBD: 'rù',  # 溽
    0x6EBE: 'āi',  # 溾
    0x6EBF: 'pàn',  # 溿
    0x6EC0: 'chù,xù',  # 滀
    0x6EC1: 'chú',  # 滁
    0x6EC2: 'pāng',  # 滂
    0x6EC3: 'wěng,wēng',  # 滃
    0x6EC4: 'cāng',  # 滄
    0x6EC5: 'miè',  # 滅
    0x6EC6: 'gé',  # 滆
    0x6EC7: 'diān',  # 滇
    0x6EC8: 'hào,xuè',  # 滈
    0x6EC9: 'huàng',  # 滉
    0x6ECA: 'qì,xì,xiē',  # 滊
    0x6ECB: 'zī',  # 滋
    0x6ECC: 'dí',  # 滌
    0x6ECD: 'zhì',  # 滍
    0x6ECE: 'xíng,yíng',  # 滎
    0x6ECF: 'fǔ',  # 滏
    0x6ED0: 'jié',  # 滐
    0x6ED1: 'huá',  # 滑
    0x6ED2: 'gē',  # 滒
    0x6ED3: 'zǐ',  # 滓
    0x6ED4: 'tāo',  # 滔
    0x6ED5: 'téng',  # 滕
    0x6ED6: 'suī',  # 滖
    0x6ED7: 'bì',  # 滗
    0x6ED8: 'jiào',  # 滘
    0x6ED9: 'huì',  # 滙
    0x6EDA: 'gǔn',  # 滚
    0x6EDB: 'yín',  # 滛
    0x6EDC: 'zé,hào',  # 滜
    0x6EDD: 'lóng',  # 滝
    0x6EDE: 'zhì',  # 滞
    0x6EDF: 'yàn',  # 滟
    0x6EE0: 'shè',  # 滠
    0x6EE1: 'mǎn',  # 满
    0x6EE2: 'yíng',  # 滢
    0x6EE3: 'chún',  # 滣
    0x6EE4: 'lǜ',  # 滤
    0x6EE5: 'làn',  # 滥
    0x6EE6: 'luán',  # 滦
    0x6EE7: 'yáo',  # 滧
    0x6EE8: 'bīn',  # 滨
    0x6EE9: 'tān',  # 滩
    0x6EEA: 'yù',  # 滪
    0x6EEB: 'xiǔ',  # 滫
    0x6EEC: 'hù',  # 滬
    0x6EED: 'bì',  # 滭
    0x6EEE: 'biāo',  # 滮
    0x6EEF: 'zhì',  # 滯
    0x6EF0: 'jiàng',  # 滰
    0x6EF1: 'kòu',  # 滱
    0x6EF2: 'shèn',  # 滲
    0x6EF3: 'shāng',  # 滳
    0x6EF4: 'dī',  # 滴
    0x6EF5: 'mì',  # 滵
    0x6EF6: 'áo',  # 滶
    0x6EF7: 'lǔ',  # 滷
    0x6EF8: 'hǔ,xǔ',  # 滸
    0x6EF9: 'hū',  # 滹
    0x6EFA: 'yōu',  # 滺
    0x6EFB: 'chǎn',  # 滻
    0x6EFC: 'fàn',  # 滼
    0x6EFD: 'yōng',  # 滽
    0x6EFE: 'gǔn',  # 滾
    0x6EFF: 'mǎn',  # 滿
    0x6F00: 'qǐng',  # 漀
    0x6F01: 'yú',  # 漁
    0x6F02: 'piāo,piǎo,piào',  # 漂
    0x6F03: 'jì',  # 漃
    0x6F04: 'yá',  # 漄
    0x6F05: 'cháo',  # 漅
    0x6F06: 'qī',  # 漆
    0x6F07: 'xǐ',  # 漇
    0x6F08: 'jì',  # 漈
    0x6F09: 'lù',  # 漉
    0x6F0A: 'lóu',  # 漊
    0x6F0B: 'lóng',  # 漋
    0x6F0C: 'jǐn',  # 漌
    0x6F0D: 'guó',  # 漍
    0x6F0E: 'cóng,sǒng',  # 漎
    0x6F0F: 'lòu',  # 漏
    0x6F10: 'zhí',  # 漐
    0x6F11: 'gài',  # 漑
    0x6F12: 'qiáng',  # 漒
    0x6F13: 'lí',  # 漓
    0x6F14: 'yǎn',  # 演
    0x6F15: 'cáo',  # 漕
    0x6F16: 'jiào',  # 漖
    0x6F17: 'cōng',  # 漗
    0x6F18: 'chún',  # 漘
    0x6F19: 'tuán,zhuān',  # 漙
    0x6F1A: 'òu,ōu',  # 漚
    0x6F1B: 'téng',  # 漛
    0x6F1C: 'yě',  # 漜
    0x6F1D: 'xí',  # 漝
    0x6F1E: 'mì',  # 漞
    0x6F1F: 'táng',  # 漟
    0x6F20: 'mò',  # 漠
    0x6F21: 'shāng',  # 漡
    0x6F22: 'hàn',  # 漢
    0x6F23: 'lián',  # 漣
    0x6F24: 'lǎn',  # 漤
    0x6F25: 'wā',  # 漥
    0x6F26: 'chí',  # 漦
    0x6F27: 'gān',  # 漧
    0x6F28: 'féng,péng',  # 漨
    0x6F29: 'xuán',  # 漩
    0x6F2A: 'yī',  # 漪
    0x6F2B: 'màn',  # 漫
    0x6F2C: 'zì',  # 漬
    0x6F2D: 'mǎng',  # 漭
    0x6F2E: 'kāng',  # 漮
    0x6F2F: 'luò,tà',  # 漯
    0x6F30: 'bēn,pēng',  # 漰
    0x6F31: 'shù',  # 漱
    0x6F32: 'zhǎng,zhàng',  # 漲
    0x6F33: 'zhāng',  # 漳
    0x6F34: 'chóng,zhuàng',  # 漴
    0x6F35: 'xù',  # 漵
    0x6F36: 'huàn',  # 漶
    0x6F37: 'huǒ,huò,kuò',  # 漷
    0x6F38: 'jiàn,jiān',  # 漸
    0x6F39: 'yān',  # 漹
    0x6F3A: 'shuǎng',  # 漺
    0x6F3B: 'liáo,liú',  # 漻
    0x6F3C: 'cuǐ,cuī',  # 漼
    0x6F3D: 'tí',  # 漽
    0x6F3E: 'yàng',  # 漾
    0x6F3F: 'jiāng,jiàng',  # 漿
    0x6F40: 'cóng,zǒng',  # 潀
    0x6F41: 'yǐng',  # 潁
    0x6F42: 'hóng',  # 潂
    0x6F43: 'xiǔ',  # 潃
    0x6F44: 'shù',  # 潄
    0x6F45: 'guàn',  # 潅
    0x6F46: 'yíng',  # 潆
    0x6F47: 'xiāo',  # 潇
    0x6F48: 'cóng,zōng',  # 潈
    0x6F49: 'kūn',  # 潉
    0x6F4A: 'xù',  # 潊
    0x6F4B: 'liàn',  # 潋
    0x6F4C: 'zhì',  # 潌
    0x6F4D: 'wéi',  # 潍
    0x6F4E: 'pì,piē',  # 潎
    0x6F4F: 'yù',  # 潏
    0x6F50: 'jiào,qiáo',  # 潐
    0x6F51: 'pō',  # 潑
    0x6F52: 'dàng,xiàng',  # 潒
    0x6F53: 'huì',  # 潓
    0x6F54: 'jié',  # 潔
    0x6F55: 'wǔ',  # 潕
    0x6F56: 'pá',  # 潖
    0x6F57: 'jí',  # 潗
    0x6F58: 'pān',  # 潘
    0x6F59: 'wéi',  # 潙
    0x6F5A: 'sù',  # 潚
    0x6F5B: 'qián',  # 潛
    0x6F5C: 'qián',  # 潜
    0x6F5D: 'xī,yà',  # 潝
    0x6F5E: 'lù',  # 潞
    0x6F5F: 'xì',  # 潟
    0x6F60: 'xùn',  # 潠
    0x6F61: 'dùn',  # 潡
    0x6F62: 'huáng,guāng',  # 潢
    0x6F63: 'mǐn',  # 潣
    0x6F64: 'rùn',  # 潤
    0x6F65: 'sù',  # 潥
    0x6F66: 'lǎo,lào,liáo',  # 潦
    0x6F67: 'zhēn',  # 潧
    0x6F68: 'cōng,zòng',  # 潨
    0x6F69: 'yì',  # 潩
    0x6F6A: 'zhí,zhì',  # 潪
    0x6F6B: 'wān',  # 潫
    0x6F6C: 'tān,shàn',  # 潬
    0x6F6D: 'tán',  # 潭
    0x6F6E: 'cháo',  # 潮
    0x6F6F: 'xún',  # 潯
    0x6F70: 'kuì,huì',  # 潰
    0x6F71: 'yē',  # 潱
    0x6F72: 'shào',  # 潲
    0x6F73: 'tú,zhā',  # 潳
    0x6F74: 'zhū',  # 潴
    0x6F75: 'sàn,sǎ',  # 潵
    0x6F76: 'hēi',  # 潶
    0x6F77: 'bì',  # 潷
    0x6F78: 'shān',  # 潸
    0x6F79: 'chán',  # 潹
    0x6F7A: 'chán',  # 潺
    0x6F7B: 'shǔ',  # 潻
    0x6F7C: 'tóng',  # 潼
    0x6F7D: 'pū',  # 潽
    0x6F7E: 'lín',  # 潾
    0x6F7F: 'wéi',  # 潿
    0x6F80: 'sè',  # 澀
    0x6F81: 'sè',  # 澁
    0x6F82: 'chéng',  # 澂
    0x6F83: 'jiǒng',  # 澃
    0x6F84: 'chéng,dèng',  # 澄
    0x6F85: 'huà',  # 澅
    0x6F86: 'jiāo',  # 澆
    0x6F87: 'lào',  # 澇
    0x6F88: 'chè',  # 澈
    0x6F89: 'gǎn',  # 澉
    0x6F8A: 'cūn,cún',  # 澊
    0x6F8B: 'jǐng',  # 澋
    0x6F8C: 'sī',  # 澌
    0x6F8D: 'shù,zhù',  # 澍
    0x6F8E: 'péng',  # 澎
    0x6F8F: 'hán',  # 澏
    0x6F90: 'yún',  # 澐
    0x6F91: 'liū,liù',  # 澑
    0x6F92: 'hòng,gǒng',  # 澒
    0x6F93: 'fú',  # 澓
    0x6F94: 'hào',  # 澔
    0x6F95: 'hé',  # 澕
    0x6F96: 'xián',  # 澖
    0x6F97: 'jiàn',  # 澗
    0x6F98: 'shān',  # 澘
    0x6F99: 'xì',  # 澙
    0x6F9A: 'ào,yù',  # 澚
    0x6F9B: 'lǔ',  # 澛
    0x6F9C: 'lán',  # 澜
    0x6F9D: 'nìng',  # 澝
    0x6F9E: 'yú',  # 澞
    0x6F9F: 'lǐn',  # 澟
    0x6FA0: 'miǎn,shéng',  # 澠
    0x6FA1: 'zǎo',  # 澡
    0x6FA2: 'dāng',  # 澢
    0x6FA3: 'huàn',  # 澣
    0x6FA4: 'zé,shì',  # 澤
    0x6FA5: 'xiè',  # 澥
    0x6FA6: 'yù',  # 澦
    0x6FA7: 'lǐ',  # 澧
    0x6FA8: 'shì',  # 澨
    0x6FA9: 'xué',  # 澩
    0x6FAA: 'líng',  # 澪
    0x6FAB: 'wàn,màn',  # 澫
    0x6FAC: 'zī',  # 澬
    0x6FAD: 'yōng,yǒng',  # 澭
    0x6FAE: 'kuài,huì',  # 澮
    0x6FAF: 'càn',  # 澯
    0x6FB0: 'liàn',  # 澰
    0x6FB1: 'diàn',  # 澱
    0x6FB2: 'yè',  # 澲
    0x6FB3: 'ào',  # 澳
    0x6FB4: 'huán',  # 澴
    0x6FB5: 'zhēn',  # 澵
    0x6FB6: 'chán',  # 澶
    0x6FB7: 'màn',  # 澷
    0x6FB8: 'gǎn',  # 澸
    0x6FB9: 'dàn,tán',  # 澹
    0x6FBA: 'yì',  # 澺
    0x6FBB: 'suì',  # 澻
    0x6FBC: 'pì',  # 澼
    0x6FBD: 'jù',  # 澽
    0x6FBE: 'tà',  # 澾
    0x6FBF: 'qín',  # 澿
    0x6FC0: 'jī',  # 激
    0x6FC1: 'zhuó',  # 濁
    0x6FC2: 'lián',  # 濂
    0x6FC3: 'nóng',  # 濃
    0x6FC4: 'guō,wō',  # 濄
    0x6FC5: 'jìn',  # 濅
    0x6FC6: 'fén,pēn',  # 濆
    0x6FC7: 'sè',  # 濇
    0x6FC8: 'jí,shà',  # 濈
    0x6FC9: 'suī',  # 濉
    0x6FCA: 'huì,huò',  # 濊
    0x6FCB: 'chǔ',  # 濋
    0x6FCC: 'tà',  # 濌
    0x6FCD: 'sōng',  # 濍
    0x6FCE: 'dǐng,tìng',  # 濎
    0x6FCF: 'sè',  # 濏
    0x6FD0: 'zhǔ',  # 濐
    0x6FD1: 'lài',  # 濑
    0x6FD2: 'bīn',  # 濒
    0x6FD3: 'lián',  # 濓
    0x6FD4: 'mǐ,nǐ',  # 濔
    0x6FD5: 'shī',  # 濕
    0x6FD6: 'shù',  # 濖
    0x6FD7: 'mì',  # 濗
    0x6FD8: 'nìng',  # 濘
    0x6FD9: 'yíng',  # 濙
    0x6FDA: 'yíng',  # 濚
    0x6FDB: 'méng',  # 濛
    0x6FDC: 'jìn',  # 濜
    0x6FDD: 'qí',  # 濝
    0x6FDE: 'bì,pì',  # 濞
    0x6FDF: 'jì,jǐ',  # 濟
    0x6FE0: 'háo',  # 濠
    0x6FE1: 'rú',  # 濡
    0x6FE2: 'cuì,zuǐ',  # 濢
    0x6FE3: 'wò',  # 濣
    0x6FE4: 'tāo',  # 濤
    0x6FE5: 'yǐn',  # 濥
    0x6FE6: 'yīn',  # 濦
    0x6FE7: 'duì',  # 濧
    0x6FE8: 'cí',  # 濨
    0x6FE9: 'huò,hù',  # 濩
    0x6FEA: 'qìng',  # 濪
    0x6FEB: 'làn',  # 濫
    0x6FEC: 'jùn,xùn',  # 濬
    0x6FED: 'ǎi,kài,kè',  # 濭
    0x6FEE: 'pú',  # 濮
    0x6FEF: 'zhuó,zhào',  # 濯
    0x6FF0: 'wéi',  # 濰
    0x6FF1: 'bīn',  # 濱
    0x6FF2: 'gǔ',  # 濲
    0x6FF3: 'qián',  # 濳
    0x6FF4: 'yíng',  # 濴
    0x6FF5: 'bīn',  # 濵
    0x6FF6: 'kuò',  # 濶
    0x6FF7: 'fèi',  # 濷
    0x6FF8: 'cāng',  # 濸
    0x6FF9: 'mè',  # 濹
    0x6FFA: 'jiàn,jiān',  # 濺
    0x6FFB: 'wěi,duì',  # 濻
    0x6FFC: 'luò,pō',  # 濼
    0x6FFD: 'zàn,cuán',  # 濽
    0x6FFE: 'lǜ',  # 濾
    0x6FFF: 'lì',  # 濿
    0x7000: 'yōu',  # 瀀
    0x7001: 'yǎng,yàng',  # 瀁
    0x7002: 'lǔ',  # 瀂
    0x7003: 'sì',  # 瀃
    0x7004: 'zhì',  # 瀄
    0x7005: 'yíng',  # 瀅
    0x7006: 'dú,dòu',  # 瀆
    0x7007: 'wǎng,wāng',  # 瀇
    0x7008: 'huī',  # 瀈
    0x7009: 'xiè',  # 瀉
    0x700A: 'pán',  # 瀊
    0x700B: 'shěn',  # 瀋
    0x700C: 'biāo',  # 瀌
    0x700D: 'chán',  # 瀍
    0x700E: 'miè,mò',  # 瀎
    0x700F: 'liú',  # 瀏
    0x7010: 'jiān',  # 瀐
    0x7011: 'pù,bào',  # 瀑
    0x7012: 'sè',  # 瀒
    0x7013: 'chéng,dèng',  # 瀓
    0x7014: 'gǔ',  # 瀔
    0x7015: 'bīn',  # 瀕
    0x7016: 'huò',  # 瀖
    0x7017: 'xiàn',  # 瀗
    0x7018: 'lú',  # 瀘
    0x7019: 'qìn',  # 瀙
    0x701A: 'hàn',  # 瀚
    0x701B: 'yíng',  # 瀛
    0x701C: 'róng',  # 瀜
    0x701D: 'lì',  # 瀝
    0x701E: 'jìng',  # 瀞
    0x701F: 'xiāo',  # 瀟
    0x7020: 'yíng',  # 瀠
    0x7021: 'suǐ',  # 瀡
    0x7022: 'wěi,duì',  # 瀢
    0x7023: 'xiè',  # 瀣
    0x7024: 'huái,wāi',  # 瀤
    0x7025: 'xuè',  # 瀥
    0x7026: 'zhū',  # 瀦
    0x7027: 'lóng,shuāng',  # 瀧
    0x7028: 'lài',  # 瀨
    0x7029: 'duì',  # 瀩
    0x702A: 'fàn',  # 瀪
    0x702B: 'hú',  # 瀫
    0x702C: 'lài',  # 瀬
    0x702D: 'shū',  # 瀭
    0x702E: 'lián',  # 瀮
    0x702F: 'yíng',  # 瀯
    0x7030: 'mí',  # 瀰
    0x7031: 'jì',  # 瀱
    0x7032: 'liàn',  # 瀲
    0x7033: 'jiàn,zùn',  # 瀳
    0x7034: 'yīng,yǐng,yìng',  # 瀴
    0x7035: 'fèn',  # 瀵
    0x7036: 'lín',  # 瀶
    0x7037: 'yì',  # 瀷
    0x7038: 'jiān',  # 瀸
    0x7039: 'yuè',  # 瀹
    0x703A: 'chán',  # 瀺
    0x703B: 'dài',  # 瀻
    0x703C: 'ráng,nǎng',  # 瀼
    0x703D: 'jiǎn',  # 瀽
    0x703E: 'lán',  # 瀾
    0x703F: 'fán',  # 瀿
    0x7040: 'shuàng',  # 灀
    0x7041: 'yuān',  # 灁
    0x7042: 'zhuó,jiào,zé',  # 灂
    0x7043: 'fēng',  # 灃
    0x7044: 'shè',  # 灄
    0x7045: 'lěi',  # 灅
    0x7046: 'lán',  # 灆
    0x7047: 'cóng',  # 灇
    0x7048: 'qú',  # 灈
    0x7049: 'yōng',  # 灉
    0x704A: 'qián',  # 灊
    0x704B: 'fǎ',  # 灋
    0x704C: 'guàn',  # 灌
    0x704D: 'jué',  # 灍
    0x704E: 'yàn',  # 灎
    0x704F: 'hào',  # 灏
    0x7050: 'yíng',  # 灐
    0x7051: 'sǎ',  # 灑
    0x7052: 'zàn,cuán',  # 灒
    0x7053: 'luán,luàn',  # 灓
    0x7054: 'yàn',  # 灔
    0x7055: 'lí',  # 灕
    0x7056: 'mǐ',  # 灖
    0x7057: 'shàn',  # 灗
    0x7058: 'tān',  # 灘
    0x7059: 'dǎng,tǎng',  # 灙
    0x705A: 'jiǎo',  # 灚
    0x705B: 'chǎn',  # 灛
    0x705C: 'yíng',  # 灜
    0x705D: 'hào',  # 灝
    0x705E: 'bà',  # 灞
    0x705F: 'zhú',  # 灟
    0x7060: 'lǎn',  # 灠
    0x7061: 'lán',  # 灡
    0x7062: 'nǎng',  # 灢
    0x7063: 'wān',  # 灣
    0x7064: 'luán',  # 灤
    0x7065: 'xún,quán,quàn',  # 灥
    0x7066: 'xiǎn',  # 灦
    0x7067: 'yàn',  # 灧
    0x7068: 'gàn',  # 灨
    0x7069: 'yàn',  # 灩
    0x706A: 'yù',  # 灪
    0x706B: 'huǒ',  # 火
    0x706C: 'huǒ,biāo',  # 灬
    0x706D: 'miè',  # 灭
    0x706E: 'guāng',  # 灮
    0x706F: 'dēng',  # 灯
    0x7070: 'huī',  # 灰
    0x7071: 'xiāo',  # 灱
    0x7072: 'xiāo',  # 灲
    0x7073: 'huī',  # 灳
    0x7074: 'hōng',  # 灴
    0x7075: 'líng',  # 灵
    0x7076: 'zào',  # 灶
    0x7077: 'zhuàn',  # 灷
    0x7078: 'jiǔ',  # 灸
    0x7079: 'zhà,yù',  # 灹
    0x707A: 'xiè',  # 灺
    0x707B: 'chì',  # 灻
    0x707C: 'zhuó',  # 灼
    0x707D: 'zāi',  # 災
    0x707E: 'zāi',  # 灾
    0x707F: 'càn',  # 灿
    0x7080: 'yáng',  # 炀
    0x7081: 'qì',  # 炁
    0x7082: 'zhōng',  # 炂
    0x7083: 'fén,bèn',  # 炃
    0x7084: 'niǔ',  # 炄
    0x7085: 'jiǒng,guì',  # 炅
    0x7086: 'wén',  # 炆
    0x7087: 'pū',  # 炇
    0x7088: 'yì',  # 炈
    0x7089: 'lú',  # 炉
    0x708A: 'chuī',  # 炊
    0x708B: 'pī',  # 炋
    0x708C: 'kài',  # 炌
    0x708D: 'pàn',  # 炍
    0x708E: 'yán',  # 炎
    0x708F: 'yán',  # 炏
    0x7090: 'pàng,fēng',  # 炐
    0x7091: 'mù',  # 炑
    0x7092: 'chǎo',  # 炒
    0x7093: 'liào',  # 炓
    0x7094: 'quē',  # 炔
    0x7095: 'kàng',  # 炕
    0x7096: 'dùn',  # 炖
    0x7097: 'guāng',  # 炗
    0x7098: 'xìn',  # 炘
    0x7099: 'zhì',  # 炙
    0x709A: 'guāng',  # 炚
    0x709B: 'guāng',  # 炛
    0x709C: 'wěi',  # 炜
    0x709D: 'qiàng',  # 炝
    0x709E: 'biān',  # 炞
    0x709F: 'dá',  # 炟
    0x70A0: 'xiá',  # 炠
    0x70A1: 'zhēng',  # 炡
    0x70A2: 'zhú',  # 炢
    0x70A3: 'kě',  # 炣
    0x70A4: 'zhào,zhāo',  # 炤
    0x70A5: 'fú',  # 炥
    0x70A6: 'bá',  # 炦
    0x70A7: 'xiè',  # 炧
    0x70A8: 'xiè',  # 炨
    0x70A9: 'lìng',  # 炩
    0x70AA: 'zhuō,chù',  # 炪
    0x70AB: 'xuàn',  # 炫
    0x70AC: 'jù',  # 炬
    0x70AD: 'tàn',  # 炭
    0x70AE: 'páo,bāo,pào',  # 炮
    0x70AF: 'jiǒng',  # 炯
    0x70B0: 'páo,fǒu',  # 炰
    0x70B1: 'tái',  # 炱
    0x70B2: 'tái',  # 炲
    0x70B3: 'bǐng',  # 炳
    0x70B4: 'yǎng',  # 炴
    0x70B5: 'tōng',  # 炵
    0x70B6: 'shǎn,qián,shān',  # 炶
    0x70B7: 'zhù',  # 炷
    0x70B8: 'zhà,zhá',  # 炸
    0x70B9: 'diǎn',  # 点
    0x70BA: 'wéi,wèi',  # 為
    0x70BB: 'shí',  # 炻
    0x70BC: 'liàn',  # 炼
    0x70BD: 'chì',  # 炽
    0x70BE: 'huǎng',  # 炾
    0x70BF: 'zhōu',  # 炿
    0x70C0: 'hū',  # 烀
    0x70C1: 'shuò',  # 烁
    0x70C2: 'làn',  # 烂
    0x70C3: 'tīng',  # 烃
    0x70C4: 'jiǎo,yào',  # 烄
    0x70C5: 'xù',  # 烅
    0x70C6: 'héng',  # 烆
    0x70C7: 'quǎn',  # 烇
    0x70C8: 'liè',  # 烈
    0x70C9: 'huàn',  # 烉
    0x70CA: 'yáng,yàng',  # 烊
    0x70CB: 'xiāo',  # 烋
    0x70CC: 'xiū',  # 烌
    0x70CD: 'xiǎn',  # 烍
    0x70CE: 'yín',  # 烎
    0x70CF: 'wū',  # 烏
    0x70D0: 'zhōu',  # 烐
    0x70D1: 'yáo',  # 烑
    0x70D2: 'shì',  # 烒
    0x70D3: 'wēi',  # 烓
    0x70D4: 'tóng,dòng',  # 烔
    0x70D5: 'miè',  # 烕
    0x70D6: 'zāi',  # 烖
    0x70D7: 'kài',  # 烗
    0x70D8: 'hōng',  # 烘
    0x70D9: 'lào,luò',  # 烙
    0x70DA: 'xiá',  # 烚
    0x70DB: 'zhú',  # 烛
    0x70DC: 'xuǎn',  # 烜
    0x70DD: 'zhēng',  # 烝
    0x70DE: 'pò',  # 烞
    0x70DF: 'yān',  # 烟
    0x70E0: 'huí,huǐ',  # 烠
    0x70E1: 'guāng',  # 烡
    0x70E2: 'chè',  # 烢
    0x70E3: 'huī',  # 烣
    0x70E4: 'kǎo',  # 烤
    0x70E5: 'jù',  # 烥
    0x70E6: 'fán',  # 烦
    0x70E7: 'shāo',  # 烧
    0x70E8: 'yè',  # 烨
    0x70E9: 'huì',  # 烩
    # 0x70EA: '',  # 烪
    0x70EB: 'tàng',  # 烫
    0x70EC: 'jìn',  # 烬
    0x70ED: 'rè',  # 热
    0x70EE: 'liè',  # 烮
    0x70EF: 'xī',  # 烯
    0x70F0: 'fú,páo',  # 烰
    0x70F1: 'jiǒng',  # 烱
    0x70F2: 'xiè,chè',  # 烲
    0x70F3: 'pǔ',  # 烳
    0x70F4: 'tīng',  # 烴
    0x70F5: 'zhuó',  # 烵
    0x70F6: 'tǐng',  # 烶
    0x70F7: 'wán',  # 烷
    0x70F8: 'hǎi',  # 烸
    0x70F9: 'pēng',  # 烹
    0x70FA: 'lǎng',  # 烺
    0x70FB: 'yàn',  # 烻
    0x70FC: 'xù',  # 烼
    0x70FD: 'fēng',  # 烽
    0x70FE: 'chì',  # 烾
    0x70FF: 'róng',  # 烿
    0x7100: 'hú',  # 焀
    0x7101: 'xī',  # 焁
    0x7102: 'shū',  # 焂
    0x7103: 'hè',  # 焃
    0x7104: 'xūn,hūn',  # 焄
    0x7105: 'kù',  # 焅
    0x7106: 'juān,yè',  # 焆
    0x7107: 'xiāo',  # 焇
    0x7108: 'xī',  # 焈
    0x7109: 'yān',  # 焉
    0x710A: 'hàn',  # 焊
    0x710B: 'zhuàng',  # 焋
    0x710C: 'qū,jùn',  # 焌
    0x710D: 'dì',  # 焍
    0x710E: 'xiè,chè',  # 焎
    0x710F: 'jí,qì',  # 焏
    0x7110: 'wù',  # 焐
    0x7111: 'yān',  # 焑
    0x7112: 'lǚ',  # 焒
    0x7113: 'hán',  # 焓
    0x7114: 'yàn',  # 焔
    0x7115: 'huàn',  # 焕
    0x7116: 'mèn',  # 焖
    0x7117: 'jú',  # 焗
    0x7118: 'dào',  # 焘
    0x7119: 'bèi',  # 焙
    0x711A: 'fén',  # 焚
    0x711B: 'lìn',  # 焛
    0x711C: 'kūn',  # 焜
    0x711D: 'hùn',  # 焝
    0x711E: 'tūn',  # 焞
    0x711F: 'xī',  # 焟
    0x7120: 'cuì',  # 焠
    0x7121: 'wú',  # 無
    0x7122: 'hōng',  # 焢
    0x7123: 'chǎo,jù',  # 焣
    0x7124: 'fǔ',  # 焤
    0x7125: 'wò,ài',  # 焥
    0x7126: 'jiāo',  # 焦
    0x7127: 'zǒng,cōng',  # 焧
    0x7128: 'fèng',  # 焨
    0x7129: 'píng',  # 焩
    0x712A: 'qióng',  # 焪
    0x712B: 'ruò',  # 焫
    0x712C: 'xī,yì',  # 焬
    0x712D: 'qióng',  # 焭
    0x712E: 'xìn',  # 焮
    0x712F: 'zhuō,chāo',  # 焯
    0x7130: 'yàn',  # 焰
    0x7131: 'yàn',  # 焱
    0x7132: 'yì',  # 焲
    0x7133: 'jué',  # 焳
    0x7134: 'yù',  # 焴
    0x7135: 'gàng',  # 焵
    0x7136: 'rán',  # 然
    0x7137: 'pí',  # 焷
    0x7138: 'xiǒng,yīng',  # 焸
    0x7139: 'gàng',  # 焹
    0x713A: 'shēng',  # 焺
    0x713B: 'chàng',  # 焻
    0x713C: 'shāo',  # 焼
    0x713D: 'xiǒng,yīng',  # 焽
    0x713E: 'niǎn',  # 焾
    0x713F: 'gēng',  # 焿
    0x7140: 'qū',  # 煀
    0x7141: 'chén',  # 煁
    0x7142: 'hè',  # 煂
    0x7143: 'kuǐ',  # 煃
    0x7144: 'zhǒng',  # 煄
    0x7145: 'duàn',  # 煅
    0x7146: 'xiā',  # 煆
    0x7147: 'huī,yùn,xūn',  # 煇
    0x7148: 'fèng',  # 煈
    0x7149: 'liàn',  # 煉
    0x714A: 'xuān',  # 煊
    0x714B: 'xīng',  # 煋
    0x714C: 'huáng',  # 煌
    0x714D: 'jiǎo,qiāo',  # 煍
    0x714E: 'jiān',  # 煎
    0x714F: 'bì',  # 煏
    0x7150: 'yīng',  # 煐
    0x7151: 'zhǔ',  # 煑
    0x7152: 'wěi',  # 煒
    0x7153: 'tuān',  # 煓
    0x7154: 'shǎn,qián,shān',  # 煔
    0x7155: 'xī,yí',  # 煕
    0x7156: 'nuǎn',  # 煖
    0x7157: 'nuǎn',  # 煗
    0x7158: 'chán',  # 煘
    0x7159: 'yān',  # 煙
    0x715A: 'jiǒng',  # 煚
    0x715B: 'jiǒng',  # 煛
    0x715C: 'yù',  # 煜
    0x715D: 'mèi',  # 煝
    0x715E: 'shā,shà',  # 煞
    0x715F: 'wèi',  # 煟
    0x7160: 'yè,zhá',  # 煠
    0x7161: 'jìn',  # 煡
    0x7162: 'qióng',  # 煢
    0x7163: 'róu',  # 煣
    0x7164: 'méi',  # 煤
    0x7165: 'huàn',  # 煥
    0x7166: 'xù',  # 煦
    0x7167: 'zhào',  # 照
    0x7168: 'wēi',  # 煨
    0x7169: 'fán',  # 煩
    0x716A: 'qiú',  # 煪
    0x716B: 'suì',  # 煫
    0x716C: 'yáng,yàng',  # 煬
    0x716D: 'liè',  # 煭
    0x716E: 'zhǔ',  # 煮
    0x716F: 'jiē',  # 煯
    0x7170: 'zào',  # 煰
    0x7171: 'guā',  # 煱
    0x7172: 'bāo',  # 煲
    0x7173: 'hú',  # 煳
    0x7174: 'yūn,yǔn',  # 煴
    0x7175: 'nǎn',  # 煵
    0x7176: 'shì',  # 煶
    0x7177: 'huǒ',  # 煷
    0x7178: 'biān',  # 煸
    0x7179: 'gòu',  # 煹
    0x717A: 'tuì',  # 煺
    0x717B: 'táng',  # 煻
    0x717C: 'chǎo',  # 煼
    0x717D: 'shān',  # 煽
    0x717E: 'ēn,yūn',  # 煾
    0x717F: 'bó',  # 煿
    0x7180: 'huǎng',  # 熀
    0x7181: 'xié',  # 熁
    0x7182: 'xì',  # 熂
    0x7183: 'wù',  # 熃
    0x7184: 'xī',  # 熄
    0x7185: 'yūn,yǔn',  # 熅
    0x7186: 'hé',  # 熆
    0x7187: 'hè,xiāo',  # 熇
    0x7188: 'xī',  # 熈
    0x7189: 'yún',  # 熉
    0x718A: 'xióng',  # 熊
    0x718B: 'xióng',  # 熋
    0x718C: 'shǎn',  # 熌
    0x718D: 'qióng',  # 熍
    0x718E: 'yào',  # 熎
    0x718F: 'xūn,xùn',  # 熏
    0x7190: 'mì',  # 熐
    0x7191: 'lián',  # 熑
    0x7192: 'yíng',  # 熒
    0x7193: 'wǔ',  # 熓
    0x7194: 'róng',  # 熔
    0x7195: 'gòng',  # 熕
    0x7196: 'yàn',  # 熖
    0x7197: 'qiàng',  # 熗
    0x7198: 'liū',  # 熘
    0x7199: 'xī',  # 熙
    0x719A: 'bì',  # 熚
    0x719B: 'biāo',  # 熛
    0x719C: 'cōng,zǒng',  # 熜
    0x719D: 'lù,āo',  # 熝
    0x719E: 'jiān',  # 熞
    0x719F: 'shú',  # 熟
    0x71A0: 'yì',  # 熠
    0x71A1: 'lóu',  # 熡
    0x71A2: 'péng,fēng',  # 熢
    0x71A3: 'suī,cuǐ',  # 熣
    0x71A4: 'yì',  # 熤
    0x71A5: 'tēng',  # 熥
    0x71A6: 'jué',  # 熦
    0x71A7: 'zōng',  # 熧
    0x71A8: 'yùn,yù',  # 熨
    0x71A9: 'hù',  # 熩
    0x71AA: 'yí',  # 熪
    0x71AB: 'zhì',  # 熫
    0x71AC: 'āo,áo',  # 熬
    0x71AD: 'wèi',  # 熭
    0x71AE: 'liǔ',  # 熮
    0x71AF: 'hàn,rǎn',  # 熯
    0x71B0: 'ōu,ǒu',  # 熰
    0x71B1: 'rè',  # 熱
    0x71B2: 'jiǒng',  # 熲
    0x71B3: 'màn',  # 熳
    0x71B4: 'kūn',  # 熴
    0x71B5: 'shāng',  # 熵
    0x71B6: 'cuàn',  # 熶
    0x71B7: 'zèng',  # 熷
    0x71B8: 'jiān',  # 熸
    0x71B9: 'xī',  # 熹
    0x71BA: 'xī',  # 熺
    0x71BB: 'xī',  # 熻
    0x71BC: 'yì',  # 熼
    0x71BD: 'xiào',  # 熽
    0x71BE: 'chì',  # 熾
    0x71BF: 'huáng,huǎng',  # 熿
    0x71C0: 'chǎn,dǎn,chàn',  # 燀
    0x71C1: 'yè',  # 燁
    0x71C2: 'tán',  # 燂
    0x71C3: 'rán',  # 燃
    0x71C4: 'yàn',  # 燄
    0x71C5: 'xún',  # 燅
    0x71C6: 'qiāo',  # 燆
    0x71C7: 'jùn',  # 燇
    0x71C8: 'dēng',  # 燈
    0x71C9: 'dùn',  # 燉
    0x71CA: 'shēn',  # 燊
    0x71CB: 'jiāo,qiáo,jué,zhuó',  # 燋
    0x71CC: 'fén',  # 燌
    0x71CD: 'sī',  # 燍
    0x71CE: 'liáo,liǎo',  # 燎
    0x71CF: 'yù',  # 燏
    0x71D0: 'lín',  # 燐
    0x71D1: 'tóng,dòng',  # 燑
    0x71D2: 'shāo',  # 燒
    0x71D3: 'fén',  # 燓
    0x71D4: 'fán',  # 燔
    0x71D5: 'yàn,yān',  # 燕
    0x71D6: 'xún',  # 燖
    0x71D7: 'làn',  # 燗
    0x71D8: 'měi',  # 燘
    0x71D9: 'tàng',  # 燙
    0x71DA: 'yì',  # 燚
    0x71DB: 'jiǒng',  # 燛
    0x71DC: 'mèn',  # 燜
    0x71DD: 'zhǔ',  # 燝
    0x71DE: 'jiǎo',  # 燞
    0x71DF: 'yíng',  # 營
    0x71E0: 'yù',  # 燠
    0x71E1: 'yì',  # 燡
    0x71E2: 'xué',  # 燢
    0x71E3: 'lán',  # 燣
    0x71E4: 'tài,liè',  # 燤
    0x71E5: 'zào',  # 燥
    0x71E6: 'càn',  # 燦
    0x71E7: 'suì',  # 燧
    0x71E8: 'xī',  # 燨
    0x71E9: 'què',  # 燩
    0x71EA: 'zǒng',  # 燪
    0x71EB: 'lián',  # 燫
    0x71EC: 'huǐ',  # 燬
    0x71ED: 'zhú',  # 燭
    0x71EE: 'xiè',  # 燮
    0x71EF: 'líng',  # 燯
    0x71F0: 'wēi',  # 燰
    0x71F1: 'yì',  # 燱
    0x71F2: 'xié',  # 燲
    0x71F3: 'zhào',  # 燳
    0x71F4: 'huì',  # 燴
    0x71F5: 'dá',  # 燵
    0x71F6: 'nóng',  # 燶
    0x71F7: 'lán',  # 燷
    0x71F8: 'xū',  # 燸
    0x71F9: 'xiǎn',  # 燹
    0x71FA: 'hè',  # 燺
    0x71FB: 'xūn',  # 燻
    0x71FC: 'jìn',  # 燼
    0x71FD: 'chóu',  # 燽
    0x71FE: 'dào',  # 燾
    0x71FF: 'yào',  # 燿
    0x7200: 'hè',  # 爀
    0x7201: 'làn',  # 爁
    0x7202: 'biāo',  # 爂
    0x7203: 'róng,yíng',  # 爃
    0x7204: 'lì,liè',  # 爄
    0x7205: 'mò',  # 爅
    0x7206: 'bào',  # 爆
    0x7207: 'ruò',  # 爇
    0x7208: 'lǜ',  # 爈
    0x7209: 'là,liè',  # 爉
    0x720A: 'āo',  # 爊
    0x720B: 'xūn,xùn',  # 爋
    0x720C: 'kuàng,huǎng',  # 爌
    0x720D: 'shuò',  # 爍
    0x720E: 'liáo,liǎo',  # 爎
    0x720F: 'lì',  # 爏
    0x7210: 'lú',  # 爐
    0x7211: 'jué',  # 爑
    0x7212: 'liáo,liǎo',  # 爒
    0x7213: 'yàn,xún',  # 爓
    0x7214: 'xī',  # 爔
    0x7215: 'xiè',  # 爕
    0x7216: 'lóng',  # 爖
    0x7217: 'yè',  # 爗
    0x7218: 'cān',  # 爘
    0x7219: 'rǎng',  # 爙
    0x721A: 'yuè',  # 爚
    0x721B: 'làn',  # 爛
    0x721C: 'cóng',  # 爜
    0x721D: 'jué',  # 爝
    0x721E: 'chóng',  # 爞
    0x721F: 'guàn',  # 爟
    0x7220: 'qú',  # 爠
    0x7221: 'chè',  # 爡
    0x7222: 'mí',  # 爢
    0x7223: 'tǎng',  # 爣
    0x7224: 'làn',  # 爤
    0x7225: 'zhú',  # 爥
    0x7226: 'lǎn,làn',  # 爦
    0x7227: 'líng',  # 爧
    0x7228: 'cuàn',  # 爨
    0x7229: 'yù',  # 爩
    0x722A: 'zhǎo,zhuǎ',  # 爪
    0x722B: 'zhǎo,zhuǎ',  # 爫
    0x722C: 'pá',  # 爬
    0x722D: 'zhēng',  # 爭
    0x722E: 'páo',  # 爮
    0x722F: 'chēng,chèn',  # 爯
    0x7230: 'yuán',  # 爰
    0x7231: 'ài',  # 爱
    0x7232: 'wéi,wèi',  # 爲
    0x7233: 'han',  # 爳
    0x7234: 'jué',  # 爴
    0x7235: 'jué',  # 爵
    0x7236: 'fù,fǔ',  # 父
    0x7237: 'yé',  # 爷
    0x7238: 'bà',  # 爸
    0x7239: 'diē',  # 爹
    0x723A: 'yé',  # 爺
    0x723B: 'yáo',  # 爻
    0x723C: 'zǔ',  # 爼
    0x723D: 'shuǎng',  # 爽
    0x723E: 'ěr',  # 爾
    0x723F: 'pán',  # 爿
    0x7240: 'chuáng',  # 牀
    0x7241: 'kē',  # 牁
    0x7242: 'zāng',  # 牂
    0x7243: 'dié',  # 牃
    0x7244: 'qiāng',  # 牄
    0x7245: 'yōng',  # 牅
    0x7246: 'qiáng',  # 牆
    0x7247: 'piàn,piān',  # 片
    0x7248: 'bǎn',  # 版
    0x7249: 'pàn',  # 牉
    0x724A: 'cháo',  # 牊
    0x724B: 'jiān',  # 牋
    0x724C: 'pái',  # 牌
    0x724D: 'dú',  # 牍
    0x724E: 'chuāng',  # 牎
    0x724F: 'yú',  # 牏
    0x7250: 'zhá',  # 牐
    0x7251: 'biān,miàn',  # 牑
    0x7252: 'dié',  # 牒
    0x7253: 'bǎng',  # 牓
    0x7254: 'bó',  # 牔
    0x7255: 'chuāng',  # 牕
    0x7256: 'yǒu',  # 牖
    0x7257: 'yǒu,yōng',  # 牗
    0x7258: 'dú',  # 牘
    0x7259: 'yá',  # 牙
    0x725A: 'chēng,chèng',  # 牚
    0x725B: 'niú',  # 牛
    0x725C: 'niú',  # 牜
    0x725D: 'pìn',  # 牝
    0x725E: 'jiū,lè',  # 牞
    0x725F: 'móu,mù',  # 牟
    0x7260: 'tā',  # 牠
    0x7261: 'mǔ',  # 牡
    0x7262: 'láo',  # 牢
    0x7263: 'rèn',  # 牣
    0x7264: 'māng',  # 牤
    0x7265: 'fāng',  # 牥
    0x7266: 'máo',  # 牦
    0x7267: 'mù',  # 牧
    0x7268: 'gāng',  # 牨
    0x7269: 'wù',  # 物
    0x726A: 'yàn',  # 牪
    0x726B: 'gē,qiú',  # 牫
    0x726C: 'bèi',  # 牬
    0x726D: 'sì',  # 牭
    0x726E: 'jiàn',  # 牮
    0x726F: 'gǔ',  # 牯
    0x7270: 'yòu,chōu',  # 牰
    0x7271: 'kē',  # 牱
    0x7272: 'shēng',  # 牲
    0x7273: 'mǔ',  # 牳
    0x7274: 'dǐ',  # 牴
    0x7275: 'qiān',  # 牵
    0x7276: 'quàn',  # 牶
    0x7277: 'quán',  # 牷
    0x7278: 'zì',  # 牸
    0x7279: 'tè',  # 特
    0x727A: 'xī',  # 牺
    0x727B: 'máng',  # 牻
    0x727C: 'kēng',  # 牼
    0x727D: 'qiān',  # 牽
    0x727E: 'wǔ',  # 牾
    0x727F: 'gù',  # 牿
    0x7280: 'xī',  # 犀
    0x7281: 'lí',  # 犁
    0x7282: 'lí',  # 犂
    0x7283: 'pǒu',  # 犃
    0x7284: 'jī',  # 犄
    0x7285: 'gāng',  # 犅
    0x7286: 'zhí,tè',  # 犆
    0x7287: 'bēn',  # 犇
    0x7288: 'quán',  # 犈
    0x7289: 'chún',  # 犉
    0x728A: 'dú',  # 犊
    0x728B: 'jù',  # 犋
    0x728C: 'jiā',  # 犌
    0x728D: 'jiān,qián',  # 犍
    0x728E: 'fēng',  # 犎
    0x728F: 'piān',  # 犏
    0x7290: 'kē',  # 犐
    0x7291: 'jú',  # 犑
    0x7292: 'kào',  # 犒
    0x7293: 'chú',  # 犓
    0x7294: 'xì',  # 犔
    0x7295: 'bèi',  # 犕
    0x7296: 'luò',  # 犖
    0x7297: 'jiè',  # 犗
    0x7298: 'má',  # 犘
    0x7299: 'sān',  # 犙
    0x729A: 'wèi',  # 犚
    0x729B: 'máo,lí',  # 犛
    0x729C: 'dūn',  # 犜
    0x729D: 'tóng',  # 犝
    0x729E: 'qiáo',  # 犞
    0x729F: 'jiàng',  # 犟
    0x72A0: 'xī',  # 犠
    0x72A1: 'lì',  # 犡
    0x72A2: 'dú',  # 犢
    0x72A3: 'liè',  # 犣
    0x72A4: 'pái',  # 犤
    0x72A5: 'piāo',  # 犥
    0x72A6: 'bào',  # 犦
    0x72A7: 'xī',  # 犧
    0x72A8: 'chōu',  # 犨
    0x72A9: 'wéi',  # 犩
    0x72AA: 'kuí',  # 犪
    0x72AB: 'chōu',  # 犫
    0x72AC: 'quǎn',  # 犬
    0x72AD: 'quǎn',  # 犭
    0x72AE: 'quǎn,bá',  # 犮
    0x72AF: 'fàn',  # 犯
    0x72B0: 'qiú',  # 犰
    0x72B1: 'jǐ',  # 犱
    0x72B2: 'chái',  # 犲
    0x72B3: 'zhuó,bào',  # 犳
    0x72B4: 'hān,àn',  # 犴
    0x72B5: 'gē',  # 犵
    0x72B6: 'zhuàng',  # 状
    0x72B7: 'guǎng',  # 犷
    0x72B8: 'mǎ',  # 犸
    0x72B9: 'yóu',  # 犹
    0x72BA: 'kàng,gǎng',  # 犺
    0x72BB: 'pèi,fèi',  # 犻
    0x72BC: 'hǒu',  # 犼
    0x72BD: 'yà',  # 犽
    0x72BE: 'yín',  # 犾
    0x72BF: 'huān,fān',  # 犿
    0x72C0: 'zhuàng',  # 狀
    0x72C1: 'yǔn',  # 狁
    0x72C2: 'kuáng',  # 狂
    0x72C3: 'niǔ',  # 狃
    0x72C4: 'dí',  # 狄
    0x72C5: 'kuáng',  # 狅
    0x72C6: 'zhòng',  # 狆
    0x72C7: 'mù',  # 狇
    0x72C8: 'bèi',  # 狈
    0x72C9: 'pī',  # 狉
    0x72CA: 'jú',  # 狊
    0x72CB: 'yí,quán,chí',  # 狋
    0x72CC: 'shēng,xīng',  # 狌
    0x72CD: 'páo',  # 狍
    0x72CE: 'xiá',  # 狎
    0x72CF: 'tuó,yí',  # 狏
    0x72D0: 'hú',  # 狐
    0x72D1: 'líng',  # 狑
    0x72D2: 'fèi',  # 狒
    0x72D3: 'pī',  # 狓
    0x72D4: 'nǐ',  # 狔
    0x72D5: 'yǎo',  # 狕
    0x72D6: 'yòu',  # 狖
    0x72D7: 'gǒu',  # 狗
    0x72D8: 'xuè',  # 狘
    0x72D9: 'jū',  # 狙
    0x72DA: 'dàn',  # 狚
    0x72DB: 'bó',  # 狛
    0x72DC: 'kǔ',  # 狜
    0x72DD: 'xiǎn',  # 狝
    0x72DE: 'níng',  # 狞
    0x72DF: 'huán,huān',  # 狟
    0x72E0: 'hěn',  # 狠
    0x72E1: 'jiǎo',  # 狡
    0x72E2: 'hé,mò',  # 狢
    0x72E3: 'zhào',  # 狣
    0x72E4: 'jié',  # 狤
    0x72E5: 'xùn',  # 狥
    0x72E6: 'shān',  # 狦
    0x72E7: 'tà,shì',  # 狧
    0x72E8: 'róng',  # 狨
    0x72E9: 'shòu',  # 狩
    0x72EA: 'tóng,dòng',  # 狪
    0x72EB: 'lǎo',  # 狫
    0x72EC: 'dú',  # 独
    0x72ED: 'xiá',  # 狭
    0x72EE: 'shī',  # 狮
    0x72EF: 'kuài',  # 狯
    0x72F0: 'zhēng',  # 狰
    0x72F1: 'yù',  # 狱
    0x72F2: 'sūn',  # 狲
    0x72F3: 'yú',  # 狳
    0x72F4: 'bì',  # 狴
    0x72F5: 'máng,dòu',  # 狵
    0x72F6: 'xī,shǐ',  # 狶
    0x72F7: 'juàn',  # 狷
    0x72F8: 'lí',  # 狸
    0x72F9: 'xiá',  # 狹
    0x72FA: 'yín',  # 狺
    0x72FB: 'suān',  # 狻
    0x72FC: 'láng',  # 狼
    0x72FD: 'bèi',  # 狽
    0x72FE: 'zhì',  # 狾
    0x72FF: 'yán',  # 狿
    0x7300: 'shā',  # 猀
    0x7301: 'lì',  # 猁
    0x7302: 'hàn',  # 猂
    0x7303: 'xiǎn',  # 猃
    0x7304: 'jīng',  # 猄
    0x7305: 'pái',  # 猅
    0x7306: 'fēi',  # 猆
    0x7307: 'xiāo',  # 猇
    0x7308: 'bài,pí',  # 猈
    0x7309: 'qí',  # 猉
    0x730A: 'ní',  # 猊
    0x730B: 'biāo',  # 猋
    0x730C: 'yìn',  # 猌
    0x730D: 'lái',  # 猍
    0x730E: 'liè',  # 猎
    0x730F: 'jiān,yàn',  # 猏
    0x7310: 'qiāng',  # 猐
    0x7311: 'kūn',  # 猑
    0x7312: 'yàn',  # 猒
    0x7313: 'guō',  # 猓
    0x7314: 'zòng',  # 猔
    0x7315: 'mí',  # 猕
    0x7316: 'chāng',  # 猖
    0x7317: 'yī,yǐ',  # 猗
    0x7318: 'zhì',  # 猘
    0x7319: 'zhēng',  # 猙
    0x731A: 'yá,wèi',  # 猚
    0x731B: 'měng',  # 猛
    0x731C: 'cāi',  # 猜
    0x731D: 'cù',  # 猝
    0x731E: 'shē',  # 猞
    0x731F: 'liè',  # 猟
    0x7320: 'ceon',  # 猠
    0x7321: 'luó',  # 猡
    0x7322: 'hú',  # 猢
    0x7323: 'zōng',  # 猣
    0x7324: 'guì',  # 猤
    0x7325: 'wěi',  # 猥
    0x7326: 'fēng',  # 猦
    0x7327: 'wō',  # 猧
    0x7328: 'yuán',  # 猨
    0x7329: 'xīng',  # 猩
    0x732A: 'zhū',  # 猪
    0x732B: 'māo,máo',  # 猫
    0x732C: 'wèi',  # 猬
    0x732D: 'chuàn,chuān',  # 猭
    0x732E: 'xiàn',  # 献
    0x732F: 'tuān,tuàn',  # 猯
    0x7330: 'yà,jiá,qiè',  # 猰
    0x7331: 'náo',  # 猱
    0x7332: 'xiē,hè,gé,hài',  # 猲
    0x7333: 'jiā',  # 猳
    0x7334: 'hóu',  # 猴
    0x7335: 'biān,piàn',  # 猵
    0x7336: 'yóu',  # 猶
    0x7337: 'yóu',  # 猷
    0x7338: 'méi',  # 猸
    0x7339: 'chá',  # 猹
    0x733A: 'yáo',  # 猺
    0x733B: 'sūn',  # 猻
    0x733C: 'bó,pò',  # 猼
    0x733D: 'míng',  # 猽
    0x733E: 'huá',  # 猾
    0x733F: 'yuán',  # 猿
    0x7340: 'sōu',  # 獀
    0x7341: 'mǎ',  # 獁
    0x7342: 'huán',  # 獂
    0x7343: 'dāi',  # 獃
    0x7344: 'yù',  # 獄
    0x7345: 'shī',  # 獅
    0x7346: 'háo',  # 獆
    0x7347: 'qiāng',  # 獇
    0x7348: 'yì',  # 獈
    0x7349: 'zhēn',  # 獉
    0x734A: 'cāng',  # 獊
    0x734B: 'háo,gāo',  # 獋
    0x734C: 'màn',  # 獌
    0x734D: 'jìng',  # 獍
    0x734E: 'jiǎng',  # 獎
    0x734F: 'mò',  # 獏
    0x7350: 'zhāng',  # 獐
    0x7351: 'chán',  # 獑
    0x7352: 'áo',  # 獒
    0x7353: 'áo',  # 獓
    0x7354: 'háo',  # 獔
    0x7355: 'suǒ',  # 獕
    0x7356: 'fén,fèn',  # 獖
    0x7357: 'jué',  # 獗
    0x7358: 'bì',  # 獘
    0x7359: 'bì',  # 獙
    0x735A: 'huáng',  # 獚
    0x735B: 'pú',  # 獛
    0x735C: 'lín,lìn',  # 獜
    0x735D: 'xù',  # 獝
    0x735E: 'tóng',  # 獞
    0x735F: 'yào,xiāo',  # 獟
    0x7360: 'liáo',  # 獠
    0x7361: 'shuò,xī',  # 獡
    0x7362: 'xiāo',  # 獢
    0x7363: 'shòu',  # 獣
    0x7364: 'dūn',  # 獤
    0x7365: 'jiào',  # 獥
    0x7366: 'gé,liè,xiē',  # 獦
    0x7367: 'juàn',  # 獧
    0x7368: 'dú',  # 獨
    0x7369: 'huì',  # 獩
    0x736A: 'kuài',  # 獪
    0x736B: 'xiǎn',  # 獫
    0x736C: 'xiè',  # 獬
    0x736D: 'tǎ',  # 獭
    0x736E: 'xiǎn',  # 獮
    0x736F: 'xūn',  # 獯
    0x7370: 'níng',  # 獰
    0x7371: 'biān,piàn',  # 獱
    0x7372: 'huò',  # 獲
    0x7373: 'nòu,rú',  # 獳
    0x7374: 'méng',  # 獴
    0x7375: 'liè',  # 獵
    0x7376: 'náo,nǎo,yōu',  # 獶
    0x7377: 'guǎng',  # 獷
    0x7378: 'shòu',  # 獸
    0x7379: 'lú',  # 獹
    0x737A: 'tǎ',  # 獺
    0x737B: 'xiàn',  # 獻
    0x737C: 'mí',  # 獼
    0x737D: 'ráng',  # 獽
    0x737E: 'huān',  # 獾
    0x737F: 'náo,yōu',  # 獿
    0x7380: 'luó',  # 玀
    0x7381: 'xiǎn',  # 玁
    0x7382: 'qí',  # 玂
    0x7383: 'jué',  # 玃
    0x7384: 'xuán',  # 玄
    0x7385: 'miào',  # 玅
    0x7386: 'zī',  # 玆
    0x7387: 'shuài,lǜ',  # 率
    0x7388: 'lú',  # 玈
    0x7389: 'yù',  # 玉
    0x738A: 'sù',  # 玊
    0x738B: 'wáng,wàng',  # 王
    0x738C: 'qiú',  # 玌
    0x738D: 'gǎ',  # 玍
    0x738E: 'dīng',  # 玎
    0x738F: 'lè',  # 玏
    0x7390: 'bā',  # 玐
    0x7391: 'jī',  # 玑
    0x7392: 'hóng',  # 玒
    0x7393: 'dì',  # 玓
    0x7394: 'chuàn',  # 玔
    0x7395: 'gān',  # 玕
    0x7396: 'jiǔ',  # 玖
    0x7397: 'yú',  # 玗
    0x7398: 'qǐ',  # 玘
    0x7399: 'yú',  # 玙
    0x739A: 'chàng,yáng',  # 玚
    0x739B: 'mǎ',  # 玛
    0x739C: 'hóng',  # 玜
    0x739D: 'wǔ',  # 玝
    0x739E: 'fū',  # 玞
    0x739F: 'mín,wén',  # 玟
    0x73A0: 'jiè',  # 玠
    0x73A1: 'yà',  # 玡
    0x73A2: 'bīn,fēn',  # 玢
    0x73A3: 'biàn',  # 玣
    0x73A4: 'bàng',  # 玤
    0x73A5: 'yuè',  # 玥
    0x73A6: 'jué',  # 玦
    0x73A7: 'mén,yǔn',  # 玧
    0x73A8: 'jué',  # 玨
    0x73A9: 'wán',  # 玩
    0x73AA: 'jiān,qián',  # 玪
    0x73AB: 'méi',  # 玫
    0x73AC: 'dǎn',  # 玬
    0x73AD: 'pín',  # 玭
    0x73AE: 'wěi',  # 玮
    0x73AF: 'huán',  # 环
    0x73B0: 'xiàn',  # 现
    0x73B1: 'qiāng,cāng',  # 玱
    0x73B2: 'líng',  # 玲
    0x73B3: 'dài',  # 玳
    0x73B4: 'yì',  # 玴
    0x73B5: 'án,gān',  # 玵
    0x73B6: 'píng',  # 玶
    0x73B7: 'diàn',  # 玷
    0x73B8: 'fú',  # 玸
    0x73B9: 'xuán,xián',  # 玹
    0x73BA: 'xǐ',  # 玺
    0x73BB: 'bō',  # 玻
    0x73BC: 'cī,cǐ',  # 玼
    0x73BD: 'gǒu',  # 玽
    0x73BE: 'jiǎ',  # 玾
    0x73BF: 'sháo',  # 玿
    0x73C0: 'pò',  # 珀
    0x73C1: 'cí',  # 珁
    0x73C2: 'kē',  # 珂
    0x73C3: 'rǎn',  # 珃
    0x73C4: 'shēng',  # 珄
    0x73C5: 'shēn',  # 珅
    0x73C6: 'yí,tāi',  # 珆
    0x73C7: 'zǔ,jù',  # 珇
    0x73C8: 'jiā',  # 珈
    0x73C9: 'mín',  # 珉
    0x73CA: 'shān',  # 珊
    0x73CB: 'liǔ',  # 珋
    0x73CC: 'bì',  # 珌
    0x73CD: 'zhēn',  # 珍
    0x73CE: 'zhēn',  # 珎
    0x73CF: 'jué',  # 珏
    0x73D0: 'fà',  # 珐
    0x73D1: 'lóng',  # 珑
    0x73D2: 'jīn',  # 珒
    0x73D3: 'jiào',  # 珓
    0x73D4: 'jiàn',  # 珔
    0x73D5: 'lì',  # 珕
    0x73D6: 'guāng',  # 珖
    0x73D7: 'xiān',  # 珗
    0x73D8: 'zhōu',  # 珘
    0x73D9: 'gǒng',  # 珙
    0x73DA: 'yān',  # 珚
    0x73DB: 'xiù',  # 珛
    0x73DC: 'yáng',  # 珜
    0x73DD: 'xǔ',  # 珝
    0x73DE: 'luò',  # 珞
    0x73DF: 'sù',  # 珟
    0x73E0: 'zhū',  # 珠
    0x73E1: 'qín',  # 珡
    0x73E2: 'yín,kèn',  # 珢
    0x73E3: 'xún',  # 珣
    0x73E4: 'bǎo',  # 珤
    0x73E5: 'ěr',  # 珥
    0x73E6: 'xiàng',  # 珦
    0x73E7: 'yáo',  # 珧
    0x73E8: 'xiá',  # 珨
    0x73E9: 'héng',  # 珩
    0x73EA: 'guī',  # 珪
    0x73EB: 'chōng',  # 珫
    0x73EC: 'xù',  # 珬
    0x73ED: 'bān',  # 班
    0x73EE: 'pèi',  # 珮
    0x73EF: 'lǎo',  # 珯
    0x73F0: 'dāng',  # 珰
    0x73F1: 'yīng',  # 珱
    0x73F2: 'hún,huī',  # 珲
    0x73F3: 'wén',  # 珳
    0x73F4: 'é',  # 珴
    0x73F5: 'chéng',  # 珵
    0x73F6: 'dì,tí',  # 珶
    0x73F7: 'wǔ',  # 珷
    0x73F8: 'wú',  # 珸
    0x73F9: 'chéng',  # 珹
    0x73FA: 'jùn',  # 珺
    0x73FB: 'méi',  # 珻
    0x73FC: 'bèi',  # 珼
    0x73FD: 'tǐng',  # 珽
    0x73FE: 'xiàn',  # 現
    0x73FF: 'chù',  # 珿
    0x7400: 'hán',  # 琀
    0x7401: 'xuán,qióng',  # 琁
    0x7402: 'yán',  # 琂
    0x7403: 'qiú',  # 球
    0x7404: 'xuàn',  # 琄
    0x7405: 'láng',  # 琅
    0x7406: 'lǐ',  # 理
    0x7407: 'xiù',  # 琇
    0x7408: 'fú,fū',  # 琈
    0x7409: 'liú',  # 琉
    0x740A: 'yá',  # 琊
    0x740B: 'xī',  # 琋
    0x740C: 'líng',  # 琌
    0x740D: 'lí',  # 琍
    0x740E: 'jīn',  # 琎
    0x740F: 'liǎn',  # 琏
    0x7410: 'suǒ',  # 琐
    0x7411: 'suǒ',  # 琑
    0x7412: 'fēng',  # 琒
    0x7413: 'wán',  # 琓
    0x7414: 'diàn',  # 琔
    0x7415: 'pín,bǐng',  # 琕
    0x7416: 'zhǎn',  # 琖
    0x7417: 'cuì,sè',  # 琗
    0x7418: 'mín',  # 琘
    0x7419: 'yù',  # 琙
    0x741A: 'jū',  # 琚
    0x741B: 'chēn',  # 琛
    0x741C: 'lái',  # 琜
    0x741D: 'mín',  # 琝
    0x741E: 'shèng',  # 琞
    0x741F: 'wéi,yù',  # 琟
    0x7420: 'tiǎn,tiàn',  # 琠
    0x7421: 'shū',  # 琡
    0x7422: 'zhuó,zuó',  # 琢
    0x7423: 'běng,pěi',  # 琣
    0x7424: 'chēng',  # 琤
    0x7425: 'hǔ',  # 琥
    0x7426: 'qí',  # 琦
    0x7427: 'è',  # 琧
    0x7428: 'kūn',  # 琨
    0x7429: 'chāng',  # 琩
    0x742A: 'qí',  # 琪
    0x742B: 'běng',  # 琫
    0x742C: 'wǎn',  # 琬
    0x742D: 'lù',  # 琭
    0x742E: 'cóng',  # 琮
    0x742F: 'guǎn',  # 琯
    0x7430: 'yǎn',  # 琰
    0x7431: 'diāo',  # 琱
    0x7432: 'bèi',  # 琲
    0x7433: 'lín',  # 琳
    0x7434: 'qín',  # 琴
    0x7435: 'pí',  # 琵
    0x7436: 'pá',  # 琶
    0x7437: 'què',  # 琷
    0x7438: 'zhuó',  # 琸
    0x7439: 'qín',  # 琹
    0x743A: 'fà',  # 琺
    0x743B: 'jīn',  # 琻
    0x743C: 'qióng',  # 琼
    0x743D: 'dǔ',  # 琽
    0x743E: 'jiè',  # 琾
    0x743F: 'hún,huī',  # 琿
    0x7440: 'yǔ',  # 瑀
    0x7441: 'mào',  # 瑁
    0x7442: 'méi',  # 瑂
    0x7443: 'chūn',  # 瑃
    0x7444: 'xuān',  # 瑄
    0x7445: 'tí',  # 瑅
    0x7446: 'xīng',  # 瑆
    0x7447: 'dài',  # 瑇
    0x7448: 'róu',  # 瑈
    0x7449: 'mín',  # 瑉
    0x744A: 'jiān',  # 瑊
    0x744B: 'wěi',  # 瑋
    0x744C: 'ruǎn',  # 瑌
    0x744D: 'huàn',  # 瑍
    0x744E: 'xié,jiē',  # 瑎
    0x744F: 'chuān',  # 瑏
    0x7450: 'jiǎn',  # 瑐
    0x7451: 'zhuàn',  # 瑑
    0x7452: 'chàng,yáng',  # 瑒
    0x7453: 'liàn',  # 瑓
    0x7454: 'quán',  # 瑔
    0x7455: 'xiá',  # 瑕
    0x7456: 'duàn',  # 瑖
    0x7457: 'yuàn',  # 瑗
    0x7458: 'yé',  # 瑘
    0x7459: 'nǎo',  # 瑙
    0x745A: 'hú',  # 瑚
    0x745B: 'yīng',  # 瑛
    0x745C: 'yú',  # 瑜
    0x745D: 'huáng',  # 瑝
    0x745E: 'ruì',  # 瑞
    0x745F: 'sè',  # 瑟
    0x7460: 'liú',  # 瑠
    0x7461: 'shī',  # 瑡
    0x7462: 'róng',  # 瑢
    0x7463: 'suǒ',  # 瑣
    0x7464: 'yáo',  # 瑤
    0x7465: 'wēn',  # 瑥
    0x7466: 'wǔ',  # 瑦
    0x7467: 'zhēn',  # 瑧
    0x7468: 'jìn',  # 瑨
    0x7469: 'yíng',  # 瑩
    0x746A: 'mǎ',  # 瑪
    0x746B: 'tāo',  # 瑫
    0x746C: 'liú',  # 瑬
    0x746D: 'táng',  # 瑭
    0x746E: 'lì',  # 瑮
    0x746F: 'láng',  # 瑯
    0x7470: 'guī',  # 瑰
    0x7471: 'tiàn,tián,zhèn',  # 瑱
    0x7472: 'qiāng,cāng',  # 瑲
    0x7473: 'cuō',  # 瑳
    0x7474: 'jué',  # 瑴
    0x7475: 'zhǎo',  # 瑵
    0x7476: 'yáo',  # 瑶
    0x7477: 'ài',  # 瑷
    0x7478: 'bīn,pián',  # 瑸
    0x7479: 'tú,shū',  # 瑹
    0x747A: 'cháng',  # 瑺
    0x747B: 'kūn',  # 瑻
    0x747C: 'zhuān',  # 瑼
    0x747D: 'cōng',  # 瑽
    0x747E: 'jǐn',  # 瑾
    0x747F: 'yī',  # 瑿
    0x7480: 'cuǐ',  # 璀
    0x7481: 'cōng',  # 璁
    0x7482: 'qí',  # 璂
    0x7483: 'lí',  # 璃
    0x7484: 'jǐng',  # 璄
    0x7485: 'zǎo,suǒ',  # 璅
    0x7486: 'qiú',  # 璆
    0x7487: 'xuán',  # 璇
    0x7488: 'áo',  # 璈
    0x7489: 'liǎn',  # 璉
    0x748A: 'mén',  # 璊
    0x748B: 'zhāng',  # 璋
    0x748C: 'yín',  # 璌
    0x748D: 'yè',  # 璍
    0x748E: 'yīng',  # 璎
    0x748F: 'zhì',  # 璏
    0x7490: 'lù',  # 璐
    0x7491: 'wú',  # 璑
    0x7492: 'dēng',  # 璒
    0x7493: 'xiù',  # 璓
    0x7494: 'zēng',  # 璔
    0x7495: 'xún',  # 璕
    0x7496: 'qú',  # 璖
    0x7497: 'dàng',  # 璗
    0x7498: 'lín',  # 璘
    0x7499: 'liáo',  # 璙
    0x749A: 'qióng,jué',  # 璚
    0x749B: 'sù',  # 璛
    0x749C: 'huáng',  # 璜
    0x749D: 'guī',  # 璝
    0x749E: 'pú',  # 璞
    0x749F: 'jǐng',  # 璟
    0x74A0: 'fán',  # 璠
    0x74A1: 'jīn',  # 璡
    0x74A2: 'liú',  # 璢
    0x74A3: 'jī',  # 璣
    0x74A4: 'huì',  # 璤
    0x74A5: 'jǐng',  # 璥
    0x74A6: 'ài',  # 璦
    0x74A7: 'bì',  # 璧
    0x74A8: 'càn',  # 璨
    0x74A9: 'qú',  # 璩
    0x74AA: 'zǎo',  # 璪
    0x74AB: 'dāng',  # 璫
    0x74AC: 'jiǎo',  # 璬
    0x74AD: 'guǎn',  # 璭
    0x74AE: 'tǎn',  # 璮
    0x74AF: 'huì,kuài',  # 璯
    0x74B0: 'huán',  # 環
    0x74B1: 'sè',  # 璱
    0x74B2: 'suì',  # 璲
    0x74B3: 'tián',  # 璳
    0x74B4: 'chǔ',  # 璴
    0x74B5: 'yú',  # 璵
    0x74B6: 'jìn',  # 璶
    0x74B7: 'lú,fū',  # 璷
    0x74B8: 'bīn,pián',  # 璸
    0x74B9: 'shú',  # 璹
    0x74BA: 'wèn',  # 璺
    0x74BB: 'zuǐ',  # 璻
    0x74BC: 'lán',  # 璼
    0x74BD: 'xǐ',  # 璽
    0x74BE: 'jì,zī',  # 璾
    0x74BF: 'xuán',  # 璿
    0x74C0: 'ruǎn',  # 瓀
    0x74C1: 'wò',  # 瓁
    0x74C2: 'gài',  # 瓂
    0x74C3: 'léi',  # 瓃
    0x74C4: 'dú',  # 瓄
    0x74C5: 'lì',  # 瓅
    0x74C6: 'zhì',  # 瓆
    0x74C7: 'róu',  # 瓇
    0x74C8: 'lí',  # 瓈
    0x74C9: 'zàn',  # 瓉
    0x74CA: 'qióng',  # 瓊
    0x74CB: 'tì',  # 瓋
    0x74CC: 'guī',  # 瓌
    0x74CD: 'suí',  # 瓍
    0x74CE: 'là',  # 瓎
    0x74CF: 'lóng',  # 瓏
    0x74D0: 'lú',  # 瓐
    0x74D1: 'lì',  # 瓑
    0x74D2: 'zàn',  # 瓒
    0x74D3: 'làn',  # 瓓
    0x74D4: 'yīng',  # 瓔
    0x74D5: 'mí,xǐ',  # 瓕
    0x74D6: 'xiāng',  # 瓖
    0x74D7: 'qióng,wěi,wèi',  # 瓗
    0x74D8: 'guàn',  # 瓘
    0x74D9: 'dào',  # 瓙
    0x74DA: 'zàn',  # 瓚
    0x74DB: 'huán,yè,yà',  # 瓛
    0x74DC: 'guā',  # 瓜
    0x74DD: 'bó',  # 瓝
    0x74DE: 'dié',  # 瓞
    0x74DF: 'bó,páo',  # 瓟
    0x74E0: 'hù',  # 瓠
    0x74E1: 'zhí,hú',  # 瓡
    0x74E2: 'piáo',  # 瓢
    0x74E3: 'bàn',  # 瓣
    0x74E4: 'ráng',  # 瓤
    0x74E5: 'lì',  # 瓥
    0x74E6: 'wǎ,wà',  # 瓦
    0x74E7: 'shíwǎ',  # 瓧
    0x74E8: 'xiáng,hóng',  # 瓨
    0x74E9: 'qiānwǎ',  # 瓩
    0x74EA: 'bǎn',  # 瓪
    0x74EB: 'pén',  # 瓫
    0x74EC: 'fǎng',  # 瓬
    0x74ED: 'dǎn',  # 瓭
    0x74EE: 'wèng',  # 瓮
    0x74EF: 'ōu',  # 瓯
    0x74F0: 'fēnwǎ',  # 瓰
    0x74F1: 'máowǎ',  # 瓱
    0x74F2: 'túnwǎ',  # 瓲
    0x74F3: 'hú',  # 瓳
    0x74F4: 'líng',  # 瓴
    0x74F5: 'yí',  # 瓵
    0x74F6: 'píng',  # 瓶
    0x74F7: 'cí',  # 瓷
    0x74F8: 'bǎi,wǎ',  # 瓸
    0x74F9: 'juàn,juān',  # 瓹
    0x74FA: 'cháng',  # 瓺
    0x74FB: 'chī',  # 瓻
    0x74FC: 'lǐwǎ',  # 瓼
    0x74FD: 'dàng',  # 瓽
    0x74FE: 'wā',  # 瓾
    0x74FF: 'bù',  # 瓿
    0x7500: 'zhuì',  # 甀
    0x7501: 'píng',  # 甁
    0x7502: 'biān',  # 甂
    0x7503: 'zhòu',  # 甃
    0x7504: 'zhēn',  # 甄
    0x7505: 'líwǎ',  # 甅
    0x7506: 'cí',  # 甆
    0x7507: 'yīng',  # 甇
    0x7508: 'qì',  # 甈
    0x7509: 'xián',  # 甉
    0x750A: 'lǒu',  # 甊
    0x750B: 'dì',  # 甋
    0x750C: 'ōu',  # 甌
    0x750D: 'méng',  # 甍
    0x750E: 'zhuān',  # 甎
    0x750F: 'bèng',  # 甏
    0x7510: 'lìn',  # 甐
    0x7511: 'zèng',  # 甑
    0x7512: 'wǔ',  # 甒
    0x7513: 'pì',  # 甓
    0x7514: 'dān',  # 甔
    0x7515: 'wèng',  # 甕
    0x7516: 'yīng',  # 甖
    0x7517: 'yǎn',  # 甗
    0x7518: 'gān',  # 甘
    0x7519: 'dài',  # 甙
    0x751A: 'shèn,shén',  # 甚
    0x751B: 'tián',  # 甛
    0x751C: 'tián',  # 甜
    0x751D: 'hán',  # 甝
    0x751E: 'cháng',  # 甞
    0x751F: 'shēng',  # 生
    0x7520: 'qíng',  # 甠
    0x7521: 'shēn',  # 甡
    0x7522: 'chǎn',  # 產
    0x7523: 'chǎn',  # 産
    0x7524: 'ruí',  # 甤
    0x7525: 'shēng',  # 甥
    0x7526: 'sū',  # 甦
    0x7527: 'shēn',  # 甧
    0x7528: 'yòng',  # 用
    0x7529: 'shuǎi',  # 甩
    0x752A: 'lù',  # 甪
    0x752B: 'fǔ',  # 甫
    0x752C: 'yǒng',  # 甬
    0x752D: 'béng',  # 甭
    0x752E: 'béng',  # 甮
    0x752F: 'níng,nìng',  # 甯
    0x7530: 'tián',  # 田
    0x7531: 'yóu',  # 由
    0x7532: 'jiǎ',  # 甲
    0x7533: 'shēn',  # 申
    0x7534: 'yóu,zhá',  # 甴
    0x7535: 'diàn',  # 电
    0x7536: 'fú',  # 甶
    0x7537: 'nán',  # 男
    0x7538: 'diàn,tián,shèng',  # 甸
    0x7539: 'pīng',  # 甹
    0x753A: 'tǐng,dīng',  # 町
    0x753B: 'huà',  # 画
    0x753C: 'tǐng,dīng',  # 甼
    0x753D: 'zhèn',  # 甽
    0x753E: 'zāi,zī',  # 甾
    0x753F: 'méng',  # 甿
    0x7540: 'bì',  # 畀
    0x7541: 'bì,qí',  # 畁
    0x7542: 'mǔ',  # 畂
    0x7543: 'xún',  # 畃
    0x7544: 'liú',  # 畄
    0x7545: 'chàng',  # 畅
    0x7546: 'mǔ',  # 畆
    0x7547: 'yún',  # 畇
    0x7548: 'fàn',  # 畈
    0x7549: 'fú',  # 畉
    0x754A: 'gēng',  # 畊
    0x754B: 'tián',  # 畋
    0x754C: 'jiè',  # 界
    0x754D: 'jiè',  # 畍
    0x754E: 'quǎn',  # 畎
    0x754F: 'wèi',  # 畏
    0x7550: 'fú,bì',  # 畐
    0x7551: 'tián',  # 畑
    0x7552: 'mǔ',  # 畒
    0x7553: 'duō',  # 畓
    0x7554: 'pàn',  # 畔
    0x7555: 'jiāng',  # 畕
    0x7556: 'wā',  # 畖
    0x7557: 'dá,fú',  # 畗
    0x7558: 'nán',  # 畘
    0x7559: 'liú',  # 留
    0x755A: 'běn',  # 畚
    0x755B: 'zhěn',  # 畛
    0x755C: 'xù,chù',  # 畜
    0x755D: 'mǔ',  # 畝
    0x755E: 'mǔ',  # 畞
    0x755F: 'cè,jì',  # 畟
    0x7560: 'zāi,zī',  # 畠
    0x7561: 'gāi',  # 畡
    0x7562: 'bì',  # 畢
    0x7563: 'dá',  # 畣
    0x7564: 'zhì,chóu,shì',  # 畤
    0x7565: 'lüè',  # 略
    0x7566: 'qí',  # 畦
    0x7567: 'lüè',  # 畧
    0x7568: 'fān,pān',  # 畨
    0x7569: 'yī',  # 畩
    0x756A: 'fān,pān',  # 番
    0x756B: 'huà',  # 畫
    0x756C: 'shē,yú',  # 畬
    0x756D: 'shē',  # 畭
    0x756E: 'mǔ',  # 畮
    0x756F: 'jùn',  # 畯
    0x7570: 'yì',  # 異
    0x7571: 'liú',  # 畱
    0x7572: 'shē',  # 畲
    0x7573: 'dié',  # 畳
    0x7574: 'chóu',  # 畴
    0x7575: 'huà',  # 畵
    0x7576: 'dāng,dàng,dǎng',  # 當
    0x7577: 'zhuì',  # 畷
    0x7578: 'jī',  # 畸
    0x7579: 'wǎn',  # 畹
    0x757A: 'jiāng,jiàng',  # 畺
    0x757B: 'chéng',  # 畻
    0x757C: 'chàng',  # 畼
    0x757D: 'tuǎn',  # 畽
    0x757E: 'léi',  # 畾
    0x757F: 'jī',  # 畿
    0x7580: 'chā',  # 疀
    0x7581: 'liú',  # 疁
    0x7582: 'dié',  # 疂
    0x7583: 'tuǎn',  # 疃
    0x7584: 'lín,lìn',  # 疄
    0x7585: 'jiāng',  # 疅
    0x7586: 'jiāng,qiáng',  # 疆
    0x7587: 'chóu',  # 疇
    0x7588: 'pì',  # 疈
    0x7589: 'dié',  # 疉
    0x758A: 'dié',  # 疊
    0x758B: 'pǐ,yǎ,shū',  # 疋
    0x758C: 'jié,qiè',  # 疌
    0x758D: 'dàn',  # 疍
    0x758E: 'shū',  # 疎
    0x758F: 'shū',  # 疏
    0x7590: 'zhì,dì',  # 疐
    0x7591: 'yí,nǐ',  # 疑
    0x7592: 'nè',  # 疒
    0x7593: 'nǎi',  # 疓
    0x7594: 'dīng',  # 疔
    0x7595: 'bǐ',  # 疕
    0x7596: 'jiē',  # 疖
    0x7597: 'liáo',  # 疗
    0x7598: 'gāng',  # 疘
    0x7599: 'gē,yì',  # 疙
    0x759A: 'jiù',  # 疚
    0x759B: 'zhǒu',  # 疛
    0x759C: 'xià',  # 疜
    0x759D: 'shàn',  # 疝
    0x759E: 'xū',  # 疞
    0x759F: 'nüè,yào',  # 疟
    0x75A0: 'lì,lài',  # 疠
    0x75A1: 'yáng',  # 疡
    0x75A2: 'chèn',  # 疢
    0x75A3: 'yóu',  # 疣
    0x75A4: 'bā',  # 疤
    0x75A5: 'jiè',  # 疥
    0x75A6: 'jué,xuè',  # 疦
    0x75A7: 'qí',  # 疧
    0x75A8: 'yǎ,xiā',  # 疨
    0x75A9: 'cuì',  # 疩
    0x75AA: 'bì',  # 疪
    0x75AB: 'yì',  # 疫
    0x75AC: 'lì',  # 疬
    0x75AD: 'zòng',  # 疭
    0x75AE: 'chuāng',  # 疮
    0x75AF: 'fēng',  # 疯
    0x75B0: 'zhù',  # 疰
    0x75B1: 'pào',  # 疱
    0x75B2: 'pí',  # 疲
    0x75B3: 'gān',  # 疳
    0x75B4: 'kē',  # 疴
    0x75B5: 'cī',  # 疵
    0x75B6: 'xuē',  # 疶
    0x75B7: 'zhī',  # 疷
    0x75B8: 'dǎn',  # 疸
    0x75B9: 'zhěn',  # 疹
    0x75BA: 'fá,biǎn',  # 疺
    0x75BB: 'zhǐ',  # 疻
    0x75BC: 'téng',  # 疼
    0x75BD: 'jū',  # 疽
    0x75BE: 'jí',  # 疾
    0x75BF: 'fèi,féi',  # 疿
    0x75C0: 'gōu',  # 痀
    0x75C1: 'shān,diàn',  # 痁
    0x75C2: 'jiā',  # 痂
    0x75C3: 'xuán',  # 痃
    0x75C4: 'zhà',  # 痄
    0x75C5: 'bìng',  # 病
    0x75C6: 'niè',  # 痆
    0x75C7: 'zhèng,zhēng',  # 症
    0x75C8: 'yōng',  # 痈
    0x75C9: 'jìng',  # 痉
    0x75CA: 'quán',  # 痊
    0x75CB: 'téng,chóng',  # 痋
    0x75CC: 'tōng,tóng',  # 痌
    0x75CD: 'yí',  # 痍
    0x75CE: 'jiē',  # 痎
    0x75CF: 'wěi,yòu,yù',  # 痏
    0x75D0: 'huí',  # 痐
    0x75D1: 'tān,shǐ',  # 痑
    0x75D2: 'yǎng',  # 痒
    0x75D3: 'zhì',  # 痓
    0x75D4: 'zhì',  # 痔
    0x75D5: 'hén',  # 痕
    0x75D6: 'yǎ',  # 痖
    0x75D7: 'mèi',  # 痗
    0x75D8: 'dòu',  # 痘
    0x75D9: 'jìng',  # 痙
    0x75DA: 'xiāo',  # 痚
    0x75DB: 'tòng',  # 痛
    0x75DC: 'tū',  # 痜
    0x75DD: 'máng',  # 痝
    0x75DE: 'pǐ',  # 痞
    0x75DF: 'xiāo',  # 痟
    0x75E0: 'suān',  # 痠
    0x75E1: 'pū,pù',  # 痡
    0x75E2: 'lì',  # 痢
    0x75E3: 'zhì',  # 痣
    0x75E4: 'cuó',  # 痤
    0x75E5: 'duó',  # 痥
    0x75E6: 'wù',  # 痦
    0x75E7: 'shā',  # 痧
    0x75E8: 'láo',  # 痨
    0x75E9: 'shòu',  # 痩
    0x75EA: 'huàn',  # 痪
    0x75EB: 'xián',  # 痫
    0x75EC: 'yì',  # 痬
    0x75ED: 'bēng,péng',  # 痭
    0x75EE: 'zhàng',  # 痮
    0x75EF: 'guǎn',  # 痯
    0x75F0: 'tán',  # 痰
    0x75F1: 'fèi,féi',  # 痱
    0x75F2: 'má',  # 痲
    0x75F3: 'má,lìn',  # 痳
    0x75F4: 'chī',  # 痴
    0x75F5: 'jì',  # 痵
    0x75F6: 'tiǎn,diàn',  # 痶
    0x75F7: 'ān,yè,è',  # 痷
    0x75F8: 'chì',  # 痸
    0x75F9: 'bì',  # 痹
    0x75FA: 'bì',  # 痺
    0x75FB: 'mín',  # 痻
    0x75FC: 'gù',  # 痼
    0x75FD: 'duī',  # 痽
    0x75FE: 'kē,ē',  # 痾
    0x75FF: 'wěi',  # 痿
    0x7600: 'yū',  # 瘀
    0x7601: 'cuì',  # 瘁
    0x7602: 'yǎ',  # 瘂
    0x7603: 'zhú',  # 瘃
    0x7604: 'cù',  # 瘄
    0x7605: 'dàn,dān',  # 瘅
    0x7606: 'shèn',  # 瘆
    0x7607: 'zhǒng',  # 瘇
    0x7608: 'zhì,chì',  # 瘈
    0x7609: 'yù',  # 瘉
    0x760A: 'hóu',  # 瘊
    0x760B: 'fēng',  # 瘋
    0x760C: 'là',  # 瘌
    0x760D: 'yáng',  # 瘍
    0x760E: 'chén',  # 瘎
    0x760F: 'tú',  # 瘏
    0x7610: 'yǔ',  # 瘐
    0x7611: 'guō',  # 瘑
    0x7612: 'wén',  # 瘒
    0x7613: 'huàn',  # 瘓
    0x7614: 'kù',  # 瘔
    0x7615: 'jiǎ,xiá,xiā',  # 瘕
    0x7616: 'yīn',  # 瘖
    0x7617: 'yì',  # 瘗
    0x7618: 'lòu',  # 瘘
    0x7619: 'sào',  # 瘙
    0x761A: 'jué',  # 瘚
    0x761B: 'chì',  # 瘛
    0x761C: 'xī',  # 瘜
    0x761D: 'guān',  # 瘝
    0x761E: 'yì',  # 瘞
    0x761F: 'wēn',  # 瘟
    0x7620: 'jí',  # 瘠
    0x7621: 'chuāng',  # 瘡
    0x7622: 'bān',  # 瘢
    0x7623: 'huì,lěi',  # 瘣
    0x7624: 'liú',  # 瘤
    0x7625: 'chài,cuó',  # 瘥
    0x7626: 'shòu',  # 瘦
    0x7627: 'nüè,yào',  # 瘧
    0x7628: 'diān,chēn',  # 瘨
    0x7629: 'dá,da',  # 瘩
    0x762A: 'biē,biě',  # 瘪
    0x762B: 'tān',  # 瘫
    0x762C: 'zhàng',  # 瘬
    0x762D: 'biāo',  # 瘭
    0x762E: 'shèn',  # 瘮
    0x762F: 'cù',  # 瘯
    0x7630: 'luǒ',  # 瘰
    0x7631: 'yì',  # 瘱
    0x7632: 'zòng',  # 瘲
    0x7633: 'chōu',  # 瘳
    0x7634: 'zhàng',  # 瘴
    0x7635: 'zhài',  # 瘵
    0x7636: 'sòu',  # 瘶
    0x7637: 'sè',  # 瘷
    0x7638: 'qué',  # 瘸
    0x7639: 'diào',  # 瘹
    0x763A: 'lòu',  # 瘺
    0x763B: 'lòu',  # 瘻
    0x763C: 'mò',  # 瘼
    0x763D: 'qín',  # 瘽
    0x763E: 'yǐn',  # 瘾
    0x763F: 'yǐng',  # 瘿
    0x7640: 'huáng',  # 癀
    0x7641: 'fú',  # 癁
    0x7642: 'liáo',  # 療
    0x7643: 'lóng',  # 癃
    0x7644: 'qiáo,jiào',  # 癄
    0x7645: 'liú',  # 癅
    0x7646: 'láo',  # 癆
    0x7647: 'xián',  # 癇
    0x7648: 'fèi',  # 癈
    0x7649: 'dàn,dān',  # 癉
    0x764A: 'yìn',  # 癊
    0x764B: 'hè',  # 癋
    0x764C: 'ái',  # 癌
    0x764D: 'bān',  # 癍
    0x764E: 'xián',  # 癎
    0x764F: 'guān',  # 癏
    0x7650: 'guì,wēi',  # 癐
    0x7651: 'nòng,nóng',  # 癑
    0x7652: 'yù',  # 癒
    0x7653: 'wēi',  # 癓
    0x7654: 'yì',  # 癔
    0x7655: 'yōng',  # 癕
    0x7656: 'pǐ',  # 癖
    0x7657: 'lěi',  # 癗
    0x7658: 'lì,lài',  # 癘
    0x7659: 'shǔ',  # 癙
    0x765A: 'dàn',  # 癚
    0x765B: 'lǐn',  # 癛
    0x765C: 'diàn',  # 癜
    0x765D: 'lǐn',  # 癝
    0x765E: 'lài',  # 癞
    0x765F: 'biē,biě',  # 癟
    0x7660: 'jì',  # 癠
    0x7661: 'chī',  # 癡
    0x7662: 'yǎng',  # 癢
    0x7663: 'xuǎn',  # 癣
    0x7664: 'jiē',  # 癤
    0x7665: 'zhēng',  # 癥
    0x7666: 'mèng',  # 癦
    0x7667: 'lì',  # 癧
    0x7668: 'huò',  # 癨
    0x7669: 'lài',  # 癩
    0x766A: 'jī',  # 癪
    0x766B: 'diān',  # 癫
    0x766C: 'xuǎn',  # 癬
    0x766D: 'yǐng',  # 癭
    0x766E: 'yǐn',  # 癮
    0x766F: 'qú',  # 癯
    0x7670: 'yōng',  # 癰
    0x7671: 'tān',  # 癱
    0x7672: 'diān',  # 癲
    0x7673: 'luǒ',  # 癳
    0x7674: 'luán',  # 癴
    0x7675: 'luán',  # 癵
    0x7676: 'bō',  # 癶
    0x7677: 'bō,bǒ',  # 癷
    0x7678: 'guǐ',  # 癸
    0x7679: 'bá',  # 癹
    0x767A: 'fā',  # 発
    0x767B: 'dēng',  # 登
    0x767C: 'fā',  # 發
    0x767D: 'bái',  # 白
    0x767E: 'bǎi',  # 百
    0x767F: 'qié',  # 癿
    0x7680: 'jí,bī',  # 皀
    0x7681: 'zào',  # 皁
    0x7682: 'zào',  # 皂
    0x7683: 'mào',  # 皃
    0x7684: 'dí,dì,de',  # 的
    0x7685: 'pā,bà',  # 皅
    0x7686: 'jiē',  # 皆
    0x7687: 'huáng',  # 皇
    0x7688: 'guī',  # 皈
    0x7689: 'cǐ',  # 皉
    0x768A: 'líng',  # 皊
    0x768B: 'gāo,háo',  # 皋
    0x768C: 'mò',  # 皌
    0x768D: 'jí',  # 皍
    0x768E: 'jiǎo',  # 皎
    0x768F: 'pěng',  # 皏
    0x7690: 'gāo,yáo',  # 皐
    0x7691: 'ái',  # 皑
    0x7692: 'é',  # 皒
    0x7693: 'hào',  # 皓
    0x7694: 'hàn',  # 皔
    0x7695: 'bì',  # 皕
    0x7696: 'wǎn',  # 皖
    0x7697: 'chóu',  # 皗
    0x7698: 'qiàn',  # 皘
    0x7699: 'xī',  # 皙
    0x769A: 'ái',  # 皚
    0x769B: 'xiǎo',  # 皛
    0x769C: 'hào',  # 皜
    0x769D: 'huàng',  # 皝
    0x769E: 'hào',  # 皞
    0x769F: 'zé',  # 皟
    0x76A0: 'cuǐ',  # 皠
    0x76A1: 'hào',  # 皡
    0x76A2: 'xiǎo',  # 皢
    0x76A3: 'yè',  # 皣
    0x76A4: 'pó',  # 皤
    0x76A5: 'hào',  # 皥
    0x76A6: 'jiǎo',  # 皦
    0x76A7: 'ài',  # 皧
    0x76A8: 'xīng',  # 皨
    0x76A9: 'huàng',  # 皩
    0x76AA: 'lì,luò,bō',  # 皪
    0x76AB: 'piǎo',  # 皫
    0x76AC: 'hé',  # 皬
    0x76AD: 'jiào',  # 皭
    0x76AE: 'pí',  # 皮
    0x76AF: 'gǎn',  # 皯
    0x76B0: 'pào',  # 皰
    0x76B1: 'zhòu',  # 皱
    0x76B2: 'jūn',  # 皲
    0x76B3: 'qiú',  # 皳
    0x76B4: 'cūn',  # 皴
    0x76B5: 'què',  # 皵
    0x76B6: 'zhā',  # 皶
    0x76B7: 'gǔ',  # 皷
    0x76B8: 'jūn',  # 皸
    0x76B9: 'jūn',  # 皹
    0x76BA: 'zhòu',  # 皺
    0x76BB: 'zhā,cǔ',  # 皻
    0x76BC: 'gǔ',  # 皼
    0x76BD: 'zhāo,zhǎn,dǎn',  # 皽
    0x76BE: 'dú',  # 皾
    0x76BF: 'mǐn',  # 皿
    0x76C0: 'qǐ',  # 盀
    0x76C1: 'yíng',  # 盁
    0x76C2: 'yú',  # 盂
    0x76C3: 'bēi',  # 盃
    0x76C4: 'diào',  # 盄
    0x76C5: 'zhōng',  # 盅
    0x76C6: 'pén',  # 盆
    0x76C7: 'hé',  # 盇
    0x76C8: 'yíng',  # 盈
    0x76C9: 'hé',  # 盉
    0x76CA: 'yì',  # 益
    0x76CB: 'bō',  # 盋
    0x76CC: 'wǎn',  # 盌
    0x76CD: 'hé',  # 盍
    0x76CE: 'àng',  # 盎
    0x76CF: 'zhǎn',  # 盏
    0x76D0: 'yán',  # 盐
    0x76D1: 'jiān,jiàn',  # 监
    0x76D2: 'hé',  # 盒
    0x76D3: 'yū',  # 盓
    0x76D4: 'kuī',  # 盔
    0x76D5: 'fàn',  # 盕
    0x76D6: 'gài,gě,hé',  # 盖
    0x76D7: 'dào',  # 盗
    0x76D8: 'pán',  # 盘
    0x76D9: 'fǔ',  # 盙
    0x76DA: 'qiú',  # 盚
    0x76DB: 'shèng,chéng',  # 盛
    0x76DC: 'dào',  # 盜
    0x76DD: 'lù',  # 盝
    0x76DE: 'zhǎn',  # 盞
    0x76DF: 'méng',  # 盟
    0x76E0: 'lí',  # 盠
    0x76E1: 'jìn',  # 盡
    0x76E2: 'xù',  # 盢
    0x76E3: 'jiān,jiàn',  # 監
    0x76E4: 'pán',  # 盤
    0x76E5: 'guàn',  # 盥
    0x76E6: 'ān',  # 盦
    0x76E7: 'lú',  # 盧
    0x76E8: 'xǔ',  # 盨
    0x76E9: 'zhōu,chóu',  # 盩
    0x76EA: 'dàng',  # 盪
    0x76EB: 'ān',  # 盫
    0x76EC: 'gǔ',  # 盬
    0x76ED: 'lì',  # 盭
    0x76EE: 'mù',  # 目
    0x76EF: 'dīng',  # 盯
    0x76F0: 'gàn',  # 盰
    0x76F1: 'xū',  # 盱
    0x76F2: 'máng',  # 盲
    0x76F3: 'máng,wàng',  # 盳
    0x76F4: 'zhí',  # 直
    0x76F5: 'qì',  # 盵
    0x76F6: 'yuǎn',  # 盶
    0x76F7: 'xián,tián',  # 盷
    0x76F8: 'xiāng,xiàng',  # 相
    0x76F9: 'dǔn',  # 盹
    0x76FA: 'xīn',  # 盺
    0x76FB: 'xì,pǎn',  # 盻
    0x76FC: 'pàn',  # 盼
    0x76FD: 'fēng',  # 盽
    0x76FE: 'dùn',  # 盾
    0x76FF: 'mín',  # 盿
    0x7700: 'míng',  # 眀
    0x7701: 'shěng,xǐng',  # 省
    0x7702: 'shì',  # 眂
    0x7703: 'yún,hùn',  # 眃
    0x7704: 'miǎn',  # 眄
    0x7705: 'pān',  # 眅
    0x7706: 'fǎng',  # 眆
    0x7707: 'miǎo',  # 眇
    0x7708: 'dān',  # 眈
    0x7709: 'méi',  # 眉
    0x770A: 'mào',  # 眊
    0x770B: 'kàn,kān',  # 看
    0x770C: 'xiàn',  # 県
    0x770D: 'kōu',  # 眍
    0x770E: 'shì',  # 眎
    0x770F: 'yāng,yǎng,yìng',  # 眏
    0x7710: 'zhēng',  # 眐
    0x7711: 'yǎo,āo,ǎo',  # 眑
    0x7712: 'shēn',  # 眒
    0x7713: 'huò',  # 眓
    0x7714: 'dà',  # 眔
    0x7715: 'zhěn',  # 眕
    0x7716: 'kuàng',  # 眖
    0x7717: 'jū,xū,kōu',  # 眗
    0x7718: 'shèn',  # 眘
    0x7719: 'yí,chì',  # 眙
    0x771A: 'shěng',  # 眚
    0x771B: 'mèi',  # 眛
    0x771C: 'mò,miè',  # 眜
    0x771D: 'zhù',  # 眝
    0x771E: 'zhēn',  # 眞
    0x771F: 'zhēn',  # 真
    0x7720: 'mián',  # 眠
    0x7721: 'shì',  # 眡
    0x7722: 'yuān',  # 眢
    0x7723: 'dié,tì',  # 眣
    0x7724: 'nì',  # 眤
    0x7725: 'zì',  # 眥
    0x7726: 'zì',  # 眦
    0x7727: 'chǎo',  # 眧
    0x7728: 'zhǎ',  # 眨
    0x7729: 'xuàn',  # 眩
    0x772A: 'bǐng,fǎng',  # 眪
    0x772B: 'pàng,pán',  # 眫
    0x772C: 'lóng',  # 眬
    0x772D: 'guì,suī',  # 眭
    0x772E: 'tóng',  # 眮
    0x772F: 'mī,mí',  # 眯
    0x7730: 'dié,zhì',  # 眰
    0x7731: 'dì',  # 眱
    0x7732: 'nè',  # 眲
    0x7733: 'míng',  # 眳
    0x7734: 'xuàn,shùn,xún',  # 眴
    0x7735: 'chī',  # 眵
    0x7736: 'kuàng',  # 眶
    0x7737: 'juàn',  # 眷
    0x7738: 'móu',  # 眸
    0x7739: 'zhèn',  # 眹
    0x773A: 'tiào',  # 眺
    0x773B: 'yáng',  # 眻
    0x773C: 'yǎn',  # 眼
    0x773D: 'mò',  # 眽
    0x773E: 'zhòng',  # 眾
    0x773F: 'mò',  # 眿
    0x7740: 'zhuó,zháo,zhāo,zhe',  # 着
    0x7741: 'zhēng',  # 睁
    0x7742: 'méi',  # 睂
    0x7743: 'suō',  # 睃
    0x7744: 'qiáo,shào,xiāo',  # 睄
    0x7745: 'hàn',  # 睅
    0x7746: 'huǎn',  # 睆
    0x7747: 'dì',  # 睇
    0x7748: 'chěng',  # 睈
    0x7749: 'cuó,zhuài',  # 睉
    0x774A: 'juàn',  # 睊
    0x774B: 'é',  # 睋
    0x774C: 'miǎn',  # 睌
    0x774D: 'xiàn',  # 睍
    0x774E: 'xī',  # 睎
    0x774F: 'kùn',  # 睏
    0x7750: 'lài',  # 睐
    0x7751: 'jiǎn',  # 睑
    0x7752: 'shǎn',  # 睒
    0x7753: 'tiǎn',  # 睓
    0x7754: 'gùn',  # 睔
    0x7755: 'wān',  # 睕
    0x7756: 'lèng',  # 睖
    0x7757: 'shì',  # 睗
    0x7758: 'qióng',  # 睘
    0x7759: 'lì',  # 睙
    0x775A: 'yá',  # 睚
    0x775B: 'jīng',  # 睛
    0x775C: 'zhēng',  # 睜
    0x775D: 'lí',  # 睝
    0x775E: 'lài',  # 睞
    0x775F: 'suì,zuì',  # 睟
    0x7760: 'juàn',  # 睠
    0x7761: 'shuì',  # 睡
    0x7762: 'huī,suī',  # 睢
    0x7763: 'dū',  # 督
    0x7764: 'bì',  # 睤
    0x7765: 'bì,pì',  # 睥
    0x7766: 'mù',  # 睦
    0x7767: 'hūn',  # 睧
    0x7768: 'nì',  # 睨
    0x7769: 'lù',  # 睩
    0x776A: 'yì,zé,gāo',  # 睪
    0x776B: 'jié',  # 睫
    0x776C: 'cǎi',  # 睬
    0x776D: 'zhǒu',  # 睭
    0x776E: 'yú',  # 睮
    0x776F: 'hūn',  # 睯
    0x7770: 'mà',  # 睰
    0x7771: 'xià',  # 睱
    0x7772: 'xǐng,xìng',  # 睲
    0x7773: 'huī',  # 睳
    0x7774: 'hùn',  # 睴
    0x7775: 'zāi',  # 睵
    0x7776: 'chǔn',  # 睶
    0x7777: 'jiān',  # 睷
    0x7778: 'mèi',  # 睸
    0x7779: 'dǔ',  # 睹
    0x777A: 'hóu',  # 睺
    0x777B: 'xuān',  # 睻
    0x777C: 'tí',  # 睼
    0x777D: 'kuí',  # 睽
    0x777E: 'gāo',  # 睾
    0x777F: 'ruì',  # 睿
    0x7780: 'mào',  # 瞀
    0x7781: 'xù',  # 瞁
    0x7782: 'fá',  # 瞂
    0x7783: 'wò',  # 瞃
    0x7784: 'miáo',  # 瞄
    0x7785: 'chǒu',  # 瞅
    0x7786: 'guì,wèi,kuì',  # 瞆
    0x7787: 'mī,mí',  # 瞇
    0x7788: 'wěng',  # 瞈
    0x7789: 'kòu,jì',  # 瞉
    0x778A: 'dàng',  # 瞊
    0x778B: 'chēn',  # 瞋
    0x778C: 'kē',  # 瞌
    0x778D: 'sǒu',  # 瞍
    0x778E: 'xiā',  # 瞎
    0x778F: 'qióng,huán',  # 瞏
    0x7790: 'mò',  # 瞐
    0x7791: 'míng',  # 瞑
    0x7792: 'mán,mén',  # 瞒
    0x7793: 'fèn',  # 瞓
    0x7794: 'zé',  # 瞔
    0x7795: 'zhàng',  # 瞕
    0x7796: 'yì',  # 瞖
    0x7797: 'diāo,dōu',  # 瞗
    0x7798: 'kōu',  # 瞘
    0x7799: 'mò',  # 瞙
    0x779A: 'shùn',  # 瞚
    0x779B: 'cōng',  # 瞛
    0x779C: 'lóu,lǘ,lou',  # 瞜
    0x779D: 'chī',  # 瞝
    0x779E: 'mán,mén',  # 瞞
    0x779F: 'piǎo',  # 瞟
    0x77A0: 'chēng',  # 瞠
    0x77A1: 'guī',  # 瞡
    0x77A2: 'méng,měng',  # 瞢
    0x77A3: 'wàn',  # 瞣
    0x77A4: 'rún,shùn',  # 瞤
    0x77A5: 'piē',  # 瞥
    0x77A6: 'xī',  # 瞦
    0x77A7: 'qiáo',  # 瞧
    0x77A8: 'pú',  # 瞨
    0x77A9: 'zhǔ',  # 瞩
    0x77AA: 'dèng',  # 瞪
    0x77AB: 'shěn',  # 瞫
    0x77AC: 'shùn',  # 瞬
    0x77AD: 'liǎo,liào',  # 瞭
    0x77AE: 'chè',  # 瞮
    0x77AF: 'xián,jiàn',  # 瞯
    0x77B0: 'kàn',  # 瞰
    0x77B1: 'yè',  # 瞱
    0x77B2: 'xuè',  # 瞲
    0x77B3: 'tóng',  # 瞳
    0x77B4: 'wǔ,mí',  # 瞴
    0x77B5: 'lín',  # 瞵
    0x77B6: 'guì,kuì',  # 瞶
    0x77B7: 'jiàn',  # 瞷
    0x77B8: 'yè',  # 瞸
    0x77B9: 'ài',  # 瞹
    0x77BA: 'huì',  # 瞺
    0x77BB: 'zhān',  # 瞻
    0x77BC: 'jiǎn',  # 瞼
    0x77BD: 'gǔ',  # 瞽
    0x77BE: 'zhào',  # 瞾
    0x77BF: 'qú,jù',  # 瞿
    0x77C0: 'wéi',  # 矀
    0x77C1: 'chǒu',  # 矁
    0x77C2: 'sào',  # 矂
    0x77C3: 'nǐng,chēng',  # 矃
    0x77C4: 'xūn',  # 矄
    0x77C5: 'yào',  # 矅
    0x77C6: 'huò,yuè',  # 矆
    0x77C7: 'mēng',  # 矇
    0x77C8: 'mián',  # 矈
    0x77C9: 'pín',  # 矉
    0x77CA: 'mián',  # 矊
    0x77CB: 'lěi',  # 矋
    0x77CC: 'kuàng,guō',  # 矌
    0x77CD: 'jué',  # 矍
    0x77CE: 'xuān',  # 矎
    0x77CF: 'mián',  # 矏
    0x77D0: 'huò',  # 矐
    0x77D1: 'lú',  # 矑
    0x77D2: 'méng,měng',  # 矒
    0x77D3: 'lóng',  # 矓
    0x77D4: 'guàn,quán',  # 矔
    0x77D5: 'mǎn,mán',  # 矕
    0x77D6: 'xǐ',  # 矖
    0x77D7: 'chù',  # 矗
    0x77D8: 'tǎng',  # 矘
    0x77D9: 'kàn',  # 矙
    0x77DA: 'zhǔ',  # 矚
    0x77DB: 'máo',  # 矛
    0x77DC: 'jīn,qín,guān',  # 矜
    0x77DD: 'jīn,qín,guān',  # 矝
    0x77DE: 'yù,xù,jué',  # 矞
    0x77DF: 'shuò',  # 矟
    0x77E0: 'zé',  # 矠
    0x77E1: 'jué',  # 矡
    0x77E2: 'shǐ',  # 矢
    0x77E3: 'yǐ',  # 矣
    0x77E4: 'shěn',  # 矤
    0x77E5: 'zhī,zhì',  # 知
    0x77E6: 'hóu,hòu',  # 矦
    0x77E7: 'shěn',  # 矧
    0x77E8: 'yǐng',  # 矨
    0x77E9: 'jǔ',  # 矩
    0x77EA: 'zhōu',  # 矪
    0x77EB: 'jiǎo,jiáo',  # 矫
    0x77EC: 'cuó',  # 矬
    0x77ED: 'duǎn',  # 短
    0x77EE: 'ǎi',  # 矮
    0x77EF: 'jiǎo,jiáo',  # 矯
    0x77F0: 'zēng',  # 矰
    0x77F1: 'yuē',  # 矱
    0x77F2: 'bà',  # 矲
    0x77F3: 'shí,dàn',  # 石
    0x77F4: 'dìng',  # 矴
    0x77F5: 'qì',  # 矵
    0x77F6: 'jī',  # 矶
    0x77F7: 'zǐ',  # 矷
    0x77F8: 'gān',  # 矸
    0x77F9: 'wù',  # 矹
    0x77FA: 'zhé',  # 矺
    0x77FB: 'kū',  # 矻
    0x77FC: 'gāng,qiāng,kòng',  # 矼
    0x77FD: 'xī',  # 矽
    0x77FE: 'fán',  # 矾
    0x77FF: 'kuàng',  # 矿
    0x7800: 'dàng',  # 砀
    0x7801: 'mǎ',  # 码
    0x7802: 'shā',  # 砂
    0x7803: 'dān',  # 砃
    0x7804: 'jué',  # 砄
    0x7805: 'lì',  # 砅
    0x7806: 'fū',  # 砆
    0x7807: 'mín',  # 砇
    0x7808: 'è',  # 砈
    0x7809: 'xū,huā',  # 砉
    0x780A: 'kāng',  # 砊
    0x780B: 'zhǐ',  # 砋
    0x780C: 'qì,qiè',  # 砌
    0x780D: 'kǎn',  # 砍
    0x780E: 'jiè',  # 砎
    0x780F: 'pīn,bīn,fēn',  # 砏
    0x7810: 'è',  # 砐
    0x7811: 'yà',  # 砑
    0x7812: 'pī',  # 砒
    0x7813: 'zhé',  # 砓
    0x7814: 'yán,yàn',  # 研
    0x7815: 'suì',  # 砕
    0x7816: 'zhuān',  # 砖
    0x7817: 'chē',  # 砗
    0x7818: 'dùn',  # 砘
    0x7819: 'wǎ',  # 砙
    0x781A: 'yàn',  # 砚
    0x781B: 'jīn',  # 砛
    0x781C: 'fēng',  # 砜
    0x781D: 'fǎ',  # 砝
    0x781E: 'mò',  # 砞
    0x781F: 'zhǎ',  # 砟
    0x7820: 'jū',  # 砠
    0x7821: 'yù',  # 砡
    0x7822: 'kē,luǒ',  # 砢
    0x7823: 'tuó',  # 砣
    0x7824: 'tuó',  # 砤
    0x7825: 'dǐ',  # 砥
    0x7826: 'zhài',  # 砦
    0x7827: 'zhēn',  # 砧
    0x7828: 'ě',  # 砨
    0x7829: 'fú,fèi',  # 砩
    0x782A: 'mǔ',  # 砪
    0x782B: 'zhù,zhǔ',  # 砫
    0x782C: 'lì,lā,lá',  # 砬
    0x782D: 'biān',  # 砭
    0x782E: 'nǔ',  # 砮
    0x782F: 'pīng',  # 砯
    0x7830: 'pēng',  # 砰
    0x7831: 'líng',  # 砱
    0x7832: 'pào',  # 砲
    0x7833: 'lè',  # 砳
    0x7834: 'pò',  # 破
    0x7835: 'bō',  # 砵
    0x7836: 'pò',  # 砶
    0x7837: 'shēn',  # 砷
    0x7838: 'zá',  # 砸
    0x7839: 'ài',  # 砹
    0x783A: 'lì',  # 砺
    0x783B: 'lóng',  # 砻
    0x783C: 'tóng',  # 砼
    0x783D: 'yòng',  # 砽
    0x783E: 'lì',  # 砾
    0x783F: 'kuàng',  # 砿
    0x7840: 'chǔ',  # 础
    0x7841: 'kēng',  # 硁
    0x7842: 'quán',  # 硂
    0x7843: 'zhū',  # 硃
    0x7844: 'kuāng,guāng',  # 硄
    0x7845: 'guī',  # 硅
    0x7846: 'è',  # 硆
    0x7847: 'náo',  # 硇
    0x7848: 'qià',  # 硈
    0x7849: 'lù',  # 硉
    0x784A: 'wěi,guì',  # 硊
    0x784B: 'ài',  # 硋
    0x784C: 'luò,gè',  # 硌
    0x784D: 'kèn,xiàn,gǔn,yǐn',  # 硍
    0x784E: 'xíng',  # 硎
    0x784F: 'yán,yàn',  # 硏
    0x7850: 'dòng',  # 硐
    0x7851: 'pēng,píng',  # 硑
    0x7852: 'xī',  # 硒
    0x7853: 'lǎo',  # 硓
    0x7854: 'hóng',  # 硔
    0x7855: 'shuò,shí',  # 硕
    0x7856: 'xiá',  # 硖
    0x7857: 'qiāo',  # 硗
    0x7858: 'qíng',  # 硘
    0x7859: 'wéi,wèi',  # 硙
    0x785A: 'qiáo',  # 硚
    0x785B: 'ceok',  # 硛
    0x785C: 'kēng',  # 硜
    0x785D: 'xiāo',  # 硝
    0x785E: 'què,kè,kù',  # 硞
    0x785F: 'chàn',  # 硟
    0x7860: 'láng',  # 硠
    0x7861: 'hōng',  # 硡
    0x7862: 'yù',  # 硢
    0x7863: 'xiāo',  # 硣
    0x7864: 'xiá',  # 硤
    0x7865: 'mǎng,bàng',  # 硥
    0x7866: 'luò,lòng',  # 硦
    0x7867: 'yǒng,tóng',  # 硧
    0x7868: 'chē',  # 硨
    0x7869: 'chè',  # 硩
    0x786A: 'wò',  # 硪
    0x786B: 'liú',  # 硫
    0x786C: 'yìng',  # 硬
    0x786D: 'máng',  # 硭
    0x786E: 'què',  # 确
    0x786F: 'yàn',  # 硯
    0x7870: 'shā',  # 硰
    0x7871: 'kǔn',  # 硱
    0x7872: 'yù',  # 硲
    0x7873: 'ceok',  # 硳
    0x7874: 'huā',  # 硴
    0x7875: 'lǔ',  # 硵
    0x7876: 'chěn',  # 硶
    0x7877: 'jiǎn',  # 硷
    0x7878: 'nüè',  # 硸
    0x7879: 'sōng',  # 硹
    0x787A: 'zhuó',  # 硺
    0x787B: 'kēng,kěng',  # 硻
    0x787C: 'péng',  # 硼
    0x787D: 'yān,yǎn',  # 硽
    0x787E: 'zhuì,chuí,duǒ',  # 硾
    0x787F: 'kōng',  # 硿
    0x7880: 'chēng',  # 碀
    0x7881: 'qí',  # 碁
    0x7882: 'zòng,cóng',  # 碂
    0x7883: 'qìng',  # 碃
    0x7884: 'lín',  # 碄
    0x7885: 'jūn',  # 碅
    0x7886: 'bō',  # 碆
    0x7887: 'dìng',  # 碇
    0x7888: 'mín',  # 碈
    0x7889: 'diāo',  # 碉
    0x788A: 'jiān,zhàn',  # 碊
    0x788B: 'hè',  # 碋
    0x788C: 'lù,liù',  # 碌
    0x788D: 'ài',  # 碍
    0x788E: 'suì',  # 碎
    0x788F: 'què,xī',  # 碏
    0x7890: 'léng',  # 碐
    0x7891: 'bēi',  # 碑
    0x7892: 'yín',  # 碒
    0x7893: 'duì',  # 碓
    0x7894: 'wǔ',  # 碔
    0x7895: 'qí',  # 碕
    0x7896: 'lún,lǔn,lùn',  # 碖
    0x7897: 'wǎn',  # 碗
    0x7898: 'diǎn',  # 碘
    0x7899: 'náo,gāng',  # 碙
    0x789A: 'bèi',  # 碚
    0x789B: 'qì',  # 碛
    0x789C: 'chěn',  # 碜
    0x789D: 'ruǎn',  # 碝
    0x789E: 'yán',  # 碞
    0x789F: 'dié',  # 碟
    0x78A0: 'dìng',  # 碠
    0x78A1: 'zhóu',  # 碡
    0x78A2: 'tuó',  # 碢
    0x78A3: 'jié,yà',  # 碣
    0x78A4: 'yīng',  # 碤
    0x78A5: 'biǎn',  # 碥
    0x78A6: 'kè',  # 碦
    0x78A7: 'bì',  # 碧
    0x78A8: 'wěi,wèi',  # 碨
    0x78A9: 'shuò,shí',  # 碩
    0x78AA: 'zhēn',  # 碪
    0x78AB: 'duàn',  # 碫
    0x78AC: 'xiá',  # 碬
    0x78AD: 'dàng',  # 碭
    0x78AE: 'tí,dī',  # 碮
    0x78AF: 'nǎo',  # 碯
    0x78B0: 'pèng',  # 碰
    0x78B1: 'jiǎn',  # 碱
    0x78B2: 'dì',  # 碲
    0x78B3: 'tàn',  # 碳
    0x78B4: 'chá,chā',  # 碴
    0x78B5: 'tián',  # 碵
    0x78B6: 'qì',  # 碶
    0x78B7: 'dùn',  # 碷
    0x78B8: 'fēng',  # 碸
    0x78B9: 'xuàn',  # 碹
    0x78BA: 'què',  # 確
    0x78BB: 'què,qiāo',  # 碻
    0x78BC: 'mǎ',  # 碼
    0x78BD: 'gōng',  # 碽
    0x78BE: 'niǎn',  # 碾
    0x78BF: 'sù,xiè',  # 碿
    0x78C0: 'é',  # 磀
    0x78C1: 'cí',  # 磁
    0x78C2: 'liú,liù',  # 磂
    0x78C3: 'sī,tí',  # 磃
    0x78C4: 'táng',  # 磄
    0x78C5: 'bàng,páng',  # 磅
    0x78C6: 'huá,kě,gū',  # 磆
    0x78C7: 'pī',  # 磇
    0x78C8: 'kuǐ,wěi',  # 磈
    0x78C9: 'sǎng',  # 磉
    0x78CA: 'lěi',  # 磊
    0x78CB: 'cuō',  # 磋
    0x78CC: 'tián',  # 磌
    0x78CD: 'xiá,qià,yà',  # 磍
    0x78CE: 'xī',  # 磎
    0x78CF: 'lián,qiān',  # 磏
    0x78D0: 'pán',  # 磐
    0x78D1: 'ái,wèi',  # 磑
    0x78D2: 'yǔn',  # 磒
    0x78D3: 'duī',  # 磓
    0x78D4: 'zhé',  # 磔
    0x78D5: 'kē',  # 磕
    0x78D6: 'lá,lā',  # 磖
    0x78D7: 'zhuān',  # 磗
    0x78D8: 'yáo',  # 磘
    0x78D9: 'gǔn',  # 磙
    0x78DA: 'zhuān',  # 磚
    0x78DB: 'chán',  # 磛
    0x78DC: 'qì',  # 磜
    0x78DD: 'áo,qiāo',  # 磝
    0x78DE: 'pēng,pèng',  # 磞
    0x78DF: 'liù',  # 磟
    0x78E0: 'lǔ',  # 磠
    0x78E1: 'kàn',  # 磡
    0x78E2: 'chuǎng',  # 磢
    0x78E3: 'chěn',  # 磣
    0x78E4: 'yīn,yǐn',  # 磤
    0x78E5: 'lěi,léi',  # 磥
    0x78E6: 'biāo',  # 磦
    0x78E7: 'qì',  # 磧
    0x78E8: 'mó,mò',  # 磨
    0x78E9: 'qì,zhú',  # 磩
    0x78EA: 'cuī',  # 磪
    0x78EB: 'zōng',  # 磫
    0x78EC: 'qìng',  # 磬
    0x78ED: 'chuò',  # 磭
    0x78EE: 'lún',  # 磮
    0x78EF: 'jī',  # 磯
    0x78F0: 'shàn',  # 磰
    0x78F1: 'láo,luò',  # 磱
    0x78F2: 'qú',  # 磲
    0x78F3: 'zēng',  # 磳
    0x78F4: 'dèng',  # 磴
    0x78F5: 'jiàn',  # 磵
    0x78F6: 'xì',  # 磶
    0x78F7: 'lín',  # 磷
    0x78F8: 'dìng',  # 磸
    0x78F9: 'diàn',  # 磹
    0x78FA: 'huáng',  # 磺
    0x78FB: 'pán,bō',  # 磻
    0x78FC: 'jí,shé',  # 磼
    0x78FD: 'qiāo',  # 磽
    0x78FE: 'dī',  # 磾
    0x78FF: 'lì',  # 磿
    0x7900: 'jiàn',  # 礀
    0x7901: 'jiāo',  # 礁
    0x7902: 'xī',  # 礂
    0x7903: 'zhǎng',  # 礃
    0x7904: 'qiáo',  # 礄
    0x7905: 'dūn',  # 礅
    0x7906: 'jiǎn',  # 礆
    0x7907: 'yù',  # 礇
    0x7908: 'zhuì',  # 礈
    0x7909: 'hé,qiāo,qiào',  # 礉
    0x790A: 'kè,huò',  # 礊
    0x790B: 'zé',  # 礋
    0x790C: 'léi,lěi',  # 礌
    0x790D: 'jié',  # 礍
    0x790E: 'chǔ',  # 礎
    0x790F: 'yè',  # 礏
    0x7910: 'què,hú',  # 礐
    0x7911: 'dàng',  # 礑
    0x7912: 'yǐ',  # 礒
    0x7913: 'jiāng',  # 礓
    0x7914: 'pī',  # 礔
    0x7915: 'pī',  # 礕
    0x7916: 'yù',  # 礖
    0x7917: 'pīn',  # 礗
    0x7918: 'è,qì',  # 礘
    0x7919: 'ài',  # 礙
    0x791A: 'kē',  # 礚
    0x791B: 'jiān',  # 礛
    0x791C: 'yù',  # 礜
    0x791D: 'ruǎn',  # 礝
    0x791E: 'méng',  # 礞
    0x791F: 'pào',  # 礟
    0x7920: 'cí',  # 礠
    0x7921: 'bō',  # 礡
    0x7922: 'yǎng',  # 礢
    0x7923: 'miè',  # 礣
    0x7924: 'cǎ',  # 礤
    0x7925: 'xián,xín',  # 礥
    0x7926: 'kuàng',  # 礦
    0x7927: 'léi,lěi,lèi',  # 礧
    0x7928: 'lěi',  # 礨
    0x7929: 'zhì',  # 礩
    0x792A: 'lì',  # 礪
    0x792B: 'lì',  # 礫
    0x792C: 'fán',  # 礬
    0x792D: 'què',  # 礭
    0x792E: 'pào',  # 礮
    0x792F: 'yīng',  # 礯
    0x7930: 'lì',  # 礰
    0x7931: 'lóng',  # 礱
    0x7932: 'lóng',  # 礲
    0x7933: 'mò',  # 礳
    0x7934: 'bó',  # 礴
    0x7935: 'shuāng',  # 礵
    0x7936: 'guàn',  # 礶
    0x7937: 'jiān',  # 礷
    0x7938: 'cǎ',  # 礸
    0x7939: 'yán,yǎn',  # 礹
    0x793A: 'shì',  # 示
    0x793B: 'shì',  # 礻
    0x793C: 'lǐ',  # 礼
    0x793D: 'réng',  # 礽
    0x793E: 'shè',  # 社
    0x793F: 'yuè',  # 礿
    0x7940: 'sì',  # 祀
    0x7941: 'qí',  # 祁
    0x7942: 'tā',  # 祂
    0x7943: 'mà',  # 祃
    0x7944: 'xiè',  # 祄
    0x7945: 'yāo',  # 祅
    0x7946: 'xiān',  # 祆
    0x7947: 'zhǐ,qí',  # 祇
    0x7948: 'qí',  # 祈
    0x7949: 'zhǐ',  # 祉
    0x794A: 'bēng,fāng',  # 祊
    0x794B: 'duì',  # 祋
    0x794C: 'zhòng',  # 祌
    0x794D: 'rèn',  # 祍
    0x794E: 'yī',  # 祎
    0x794F: 'shí',  # 祏
    0x7950: 'yòu',  # 祐
    0x7951: 'zhì',  # 祑
    0x7952: 'tiáo',  # 祒
    0x7953: 'fú',  # 祓
    0x7954: 'fù',  # 祔
    0x7955: 'mì,bì',  # 祕
    0x7956: 'zǔ',  # 祖
    0x7957: 'zhī',  # 祗
    0x7958: 'suàn',  # 祘
    0x7959: 'mèi',  # 祙
    0x795A: 'zuò',  # 祚
    0x795B: 'qū',  # 祛
    0x795C: 'hù',  # 祜
    0x795D: 'zhù',  # 祝
    0x795E: 'shén',  # 神
    0x795F: 'suì',  # 祟
    0x7960: 'cí',  # 祠
    0x7961: 'chái',  # 祡
    0x7962: 'mí',  # 祢
    0x7963: 'lǚ',  # 祣
    0x7964: 'yǔ',  # 祤
    0x7965: 'xiáng',  # 祥
    0x7966: 'wú',  # 祦
    0x7967: 'tiāo',  # 祧
    0x7968: 'piào,piāo',  # 票
    0x7969: 'zhù',  # 祩
    0x796A: 'guǐ',  # 祪
    0x796B: 'xiá',  # 祫
    0x796C: 'zhī',  # 祬
    0x796D: 'jì,zhài',  # 祭
    0x796E: 'gào',  # 祮
    0x796F: 'zhēn',  # 祯
    0x7970: 'gào',  # 祰
    0x7971: 'shuì,lèi',  # 祱
    0x7972: 'jìn',  # 祲
    0x7973: 'shèn',  # 祳
    0x7974: 'gāi',  # 祴
    0x7975: 'kǔn',  # 祵
    0x7976: 'dì',  # 祶
    0x7977: 'dǎo',  # 祷
    0x7978: 'huò',  # 祸
    0x7979: 'táo',  # 祹
    0x797A: 'qí',  # 祺
    0x797B: 'gù',  # 祻
    0x797C: 'guàn',  # 祼
    0x797D: 'zuì',  # 祽
    0x797E: 'líng',  # 祾
    0x797F: 'lù',  # 祿
    0x7980: 'bǐng',  # 禀
    0x7981: 'jīn,jìn',  # 禁
    0x7982: 'dǎo',  # 禂
    0x7983: 'zhí',  # 禃
    0x7984: 'lù',  # 禄
    0x7985: 'chán,shàn',  # 禅
    0x7986: 'bì,pí',  # 禆
    0x7987: 'chǔ',  # 禇
    0x7988: 'huī',  # 禈
    0x7989: 'yǒu',  # 禉
    0x798A: 'xì',  # 禊
    0x798B: 'yīn',  # 禋
    0x798C: 'zī',  # 禌
    0x798D: 'huò',  # 禍
    0x798E: 'zhēn',  # 禎
    0x798F: 'fú',  # 福
    0x7990: 'yuàn',  # 禐
    0x7991: 'xú',  # 禑
    0x7992: 'xiǎn',  # 禒
    0x7993: 'shāng,yáng',  # 禓
    0x7994: 'tí,zhǐ',  # 禔
    0x7995: 'yī',  # 禕
    0x7996: 'méi',  # 禖
    0x7997: 'sī',  # 禗
    0x7998: 'dì',  # 禘
    0x7999: 'bèi',  # 禙
    0x799A: 'zhuó',  # 禚
    0x799B: 'zhēn',  # 禛
    0x799C: 'yíng',  # 禜
    0x799D: 'jì',  # 禝
    0x799E: 'gào',  # 禞
    0x799F: 'táng',  # 禟
    0x79A0: 'sī',  # 禠
    0x79A1: 'mà',  # 禡
    0x79A2: 'tà',  # 禢
    0x79A3: 'fù',  # 禣
    0x79A4: 'xuān',  # 禤
    0x79A5: 'qí',  # 禥
    0x79A6: 'yù',  # 禦
    0x79A7: 'xǐ',  # 禧
    0x79A8: 'jī,jì',  # 禨
    0x79A9: 'sì',  # 禩
    0x79AA: 'shàn,chán',  # 禪
    0x79AB: 'dàn',  # 禫
    0x79AC: 'guì',  # 禬
    0x79AD: 'suì',  # 禭
    0x79AE: 'lǐ',  # 禮
    0x79AF: 'nóng',  # 禯
    0x79B0: 'mí',  # 禰
    0x79B1: 'dǎo',  # 禱
    0x79B2: 'lì',  # 禲
    0x79B3: 'ráng',  # 禳
    0x79B4: 'yuè',  # 禴
    0x79B5: 'tí',  # 禵
    0x79B6: 'zàn',  # 禶
    0x79B7: 'lèi',  # 禷
    0x79B8: 'róu',  # 禸
    0x79B9: 'yǔ',  # 禹
    0x79BA: 'yú,yù,ǒu',  # 禺
    0x79BB: 'lí',  # 离
    0x79BC: 'xiè',  # 禼
    0x79BD: 'qín',  # 禽
    0x79BE: 'hé',  # 禾
    0x79BF: 'tū',  # 禿
    0x79C0: 'xiù',  # 秀
    0x79C1: 'sī',  # 私
    0x79C2: 'rén',  # 秂
    0x79C3: 'tū',  # 秃
    0x79C4: 'zǐ,zì',  # 秄
    0x79C5: 'chá,ná',  # 秅
    0x79C6: 'gǎn',  # 秆
    0x79C7: 'yì,zhí',  # 秇
    0x79C8: 'xiān',  # 秈
    0x79C9: 'bǐng',  # 秉
    0x79CA: 'nián',  # 秊
    0x79CB: 'qiū',  # 秋
    0x79CC: 'qiū',  # 秌
    0x79CD: 'zhǒng,zhòng,chóng',  # 种
    0x79CE: 'fèn',  # 秎
    0x79CF: 'hào,mào',  # 秏
    0x79D0: 'yún',  # 秐
    0x79D1: 'kē',  # 科
    0x79D2: 'miǎo',  # 秒
    0x79D3: 'zhī',  # 秓
    0x79D4: 'jīng',  # 秔
    0x79D5: 'bǐ',  # 秕
    0x79D6: 'zhǐ',  # 秖
    0x79D7: 'yù',  # 秗
    0x79D8: 'mì,bì',  # 秘
    0x79D9: 'kù,kū',  # 秙
    0x79DA: 'bàn',  # 秚
    0x79DB: 'pī',  # 秛
    0x79DC: 'ní,nì',  # 秜
    0x79DD: 'lì',  # 秝
    0x79DE: 'yóu',  # 秞
    0x79DF: 'zū',  # 租
    0x79E0: 'pī',  # 秠
    0x79E1: 'bó',  # 秡
    0x79E2: 'líng',  # 秢
    0x79E3: 'mò',  # 秣
    0x79E4: 'chèng',  # 秤
    0x79E5: 'nián',  # 秥
    0x79E6: 'qín',  # 秦
    0x79E7: 'yāng',  # 秧
    0x79E8: 'zuó',  # 秨
    0x79E9: 'zhì',  # 秩
    0x79EA: 'dī',  # 秪
    0x79EB: 'shú',  # 秫
    0x79EC: 'jù',  # 秬
    0x79ED: 'zǐ',  # 秭
    0x79EE: 'huó,kuò',  # 秮
    0x79EF: 'jī',  # 积
    0x79F0: 'chēng,chèn,chèng',  # 称
    0x79F1: 'tóng',  # 秱
    0x79F2: 'shì,zhì',  # 秲
    0x79F3: 'huó,kuò',  # 秳
    0x79F4: 'huō',  # 秴
    0x79F5: 'yīn',  # 秵
    0x79F6: 'zī',  # 秶
    0x79F7: 'zhì',  # 秷
    0x79F8: 'jiē',  # 秸
    0x79F9: 'rěn',  # 秹
    0x79FA: 'dù',  # 秺
    0x79FB: 'yí',  # 移
    0x79FC: 'zhū',  # 秼
    0x79FD: 'huì',  # 秽
    0x79FE: 'nóng',  # 秾
    0x79FF: 'fù,pū',  # 秿
    0x7A00: 'xī',  # 稀
    0x7A01: 'gǎo',  # 稁
    0x7A02: 'láng',  # 稂
    0x7A03: 'fū',  # 稃
    0x7A04: 'xùn,zè',  # 稄
    0x7A05: 'shuì',  # 稅
    0x7A06: 'lǚ',  # 稆
    0x7A07: 'kǔn',  # 稇
    0x7A08: 'gǎn',  # 稈
    0x7A09: 'jīng',  # 稉
    0x7A0A: 'tí',  # 稊
    0x7A0B: 'chéng',  # 程
    0x7A0C: 'tú,shǔ',  # 稌
    0x7A0D: 'shāo,shào',  # 稍
    0x7A0E: 'shuì',  # 税
    0x7A0F: 'yà',  # 稏
    0x7A10: 'lǔn',  # 稐
    0x7A11: 'lù',  # 稑
    0x7A12: 'gū',  # 稒
    0x7A13: 'zuó',  # 稓
    0x7A14: 'rěn',  # 稔
    0x7A15: 'zhùn,zhǔn',  # 稕
    0x7A16: 'bàng',  # 稖
    0x7A17: 'bài',  # 稗
    0x7A18: 'jī,qí',  # 稘
    0x7A19: 'zhī',  # 稙
    0x7A1A: 'zhì',  # 稚
    0x7A1B: 'kǔn',  # 稛
    0x7A1C: 'léng,lēng,líng',  # 稜
    0x7A1D: 'péng',  # 稝
    0x7A1E: 'kē',  # 稞
    0x7A1F: 'bǐng',  # 稟
    0x7A20: 'chóu',  # 稠
    0x7A21: 'zuì,zú,sū',  # 稡
    0x7A22: 'yù',  # 稢
    0x7A23: 'sū',  # 稣
    0x7A24: 'lüè',  # 稤
    0x7A25: 'xiāng',  # 稥
    0x7A26: 'yī',  # 稦
    0x7A27: 'xì,qiè',  # 稧
    0x7A28: 'biǎn',  # 稨
    0x7A29: 'jì',  # 稩
    0x7A2A: 'fú',  # 稪
    0x7A2B: 'pì,bì',  # 稫
    0x7A2C: 'nuò',  # 稬
    0x7A2D: 'jiē',  # 稭
    0x7A2E: 'zhǒng,zhòng',  # 種
    0x7A2F: 'zōng,zǒng',  # 稯
    0x7A30: 'xǔ,xū',  # 稰
    0x7A31: 'chēng,chèn,chèng',  # 稱
    0x7A32: 'dào',  # 稲
    0x7A33: 'wěn',  # 稳
    0x7A34: 'xián,jiān,liàn',  # 稴
    0x7A35: 'zī,jiū',  # 稵
    0x7A36: 'yù',  # 稶
    0x7A37: 'jì',  # 稷
    0x7A38: 'xù',  # 稸
    0x7A39: 'zhěn',  # 稹
    0x7A3A: 'zhì',  # 稺
    0x7A3B: 'dào',  # 稻
    0x7A3C: 'jià',  # 稼
    0x7A3D: 'jī,qǐ',  # 稽
    0x7A3E: 'gǎo',  # 稾
    0x7A3F: 'gǎo',  # 稿
    0x7A40: 'gǔ',  # 穀
    0x7A41: 'róng',  # 穁
    0x7A42: 'suì',  # 穂
    0x7A43: 'ròng',  # 穃
    0x7A44: 'jì',  # 穄
    0x7A45: 'kāng',  # 穅
    0x7A46: 'mù',  # 穆
    0x7A47: 'cǎn,shān,cēn',  # 穇
    0x7A48: 'mén,méi',  # 穈
    0x7A49: 'zhì',  # 穉
    0x7A4A: 'jì',  # 穊
    0x7A4B: 'lù',  # 穋
    0x7A4C: 'sū',  # 穌
    0x7A4D: 'jī',  # 積
    0x7A4E: 'yǐng',  # 穎
    0x7A4F: 'wěn',  # 穏
    0x7A50: 'qiū',  # 穐
    0x7A51: 'sè',  # 穑
    0x7A52: 'kweok',  # 穒
    0x7A53: 'yì',  # 穓
    0x7A54: 'huáng',  # 穔
    0x7A55: 'qiè',  # 穕
    0x7A56: 'jǐ,jì',  # 穖
    0x7A57: 'suì',  # 穗
    0x7A58: 'xiāo,rào',  # 穘
    0x7A59: 'pú',  # 穙
    0x7A5A: 'jiāo',  # 穚
    0x7A5B: 'zhuō,bó',  # 穛
    0x7A5C: 'tóng,zhǒng',  # 穜
    0x7A5D: 'zuō',  # 穝
    0x7A5E: 'lǔ',  # 穞
    0x7A5F: 'suì',  # 穟
    0x7A60: 'nóng',  # 穠
    0x7A61: 'sè',  # 穡
    0x7A62: 'huì',  # 穢
    0x7A63: 'ráng',  # 穣
    0x7A64: 'nuò',  # 穤
    0x7A65: 'yǔ',  # 穥
    0x7A66: 'pīn',  # 穦
    0x7A67: 'jì',  # 穧
    0x7A68: 'tuí',  # 穨
    0x7A69: 'wěn',  # 穩
    0x7A6A: 'chēng,chèn,chèng',  # 穪
    0x7A6B: 'huò',  # 穫
    0x7A6C: 'kuàng',  # 穬
    0x7A6D: 'lǚ',  # 穭
    0x7A6E: 'biāo,pāo',  # 穮
    0x7A6F: 'sè',  # 穯
    0x7A70: 'ráng',  # 穰
    0x7A71: 'zhuō,jué',  # 穱
    0x7A72: 'lí',  # 穲
    0x7A73: 'cuán,zàn',  # 穳
    0x7A74: 'xué',  # 穴
    0x7A75: 'wā',  # 穵
    0x7A76: 'jiū',  # 究
    0x7A77: 'qióng',  # 穷
    0x7A78: 'xī',  # 穸
    0x7A79: 'qióng',  # 穹
    0x7A7A: 'kōng,kòng,kǒng',  # 空
    0x7A7B: 'yū,yǔ',  # 穻
    0x7A7C: 'shēn',  # 穼
    0x7A7D: 'jǐng',  # 穽
    0x7A7E: 'yào',  # 穾
    0x7A7F: 'chuān',  # 穿
    0x7A80: 'zhūn',  # 窀
    0x7A81: 'tū',  # 突
    0x7A82: 'láo',  # 窂
    0x7A83: 'qiè',  # 窃
    0x7A84: 'zhǎi',  # 窄
    0x7A85: 'yǎo',  # 窅
    0x7A86: 'biǎn',  # 窆
    0x7A87: 'báo',  # 窇
    0x7A88: 'yǎo',  # 窈
    0x7A89: 'bìng',  # 窉
    0x7A8A: 'wā',  # 窊
    0x7A8B: 'zhú,kū',  # 窋
    0x7A8C: 'jiào,liáo,liù',  # 窌
    0x7A8D: 'qiào',  # 窍
    0x7A8E: 'diào',  # 窎
    0x7A8F: 'wū',  # 窏
    0x7A90: 'wā,guī',  # 窐
    0x7A91: 'yáo',  # 窑
    0x7A92: 'zhì',  # 窒
    0x7A93: 'chuāng',  # 窓
    0x7A94: 'yào',  # 窔
    0x7A95: 'tiǎo,yáo',  # 窕
    0x7A96: 'jiào',  # 窖
    0x7A97: 'chuāng',  # 窗
    0x7A98: 'jiǒng',  # 窘
    0x7A99: 'xiāo',  # 窙
    0x7A9A: 'chéng',  # 窚
    0x7A9B: 'kòu',  # 窛
    0x7A9C: 'cuàn',  # 窜
    0x7A9D: 'wō',  # 窝
    0x7A9E: 'dàn',  # 窞
    0x7A9F: 'kū',  # 窟
    0x7AA0: 'kē',  # 窠
    0x7AA1: 'zhuó',  # 窡
    0x7AA2: 'huò',  # 窢
    0x7AA3: 'sū',  # 窣
    0x7AA4: 'guān',  # 窤
    0x7AA5: 'kuī',  # 窥
    0x7AA6: 'dòu',  # 窦
    0x7AA7: 'zhuō',  # 窧
    0x7AA8: 'yìn,xūn',  # 窨
    0x7AA9: 'wō',  # 窩
    0x7AAA: 'wā',  # 窪
    0x7AAB: 'yà,yē',  # 窫
    0x7AAC: 'yú',  # 窬
    0x7AAD: 'jù',  # 窭
    0x7AAE: 'qióng',  # 窮
    0x7AAF: 'yáo',  # 窯
    0x7AB0: 'yáo',  # 窰
    0x7AB1: 'tiǎo',  # 窱
    0x7AB2: 'cháo',  # 窲
    0x7AB3: 'yǔ',  # 窳
    0x7AB4: 'tián,diān,yǎn',  # 窴
    0x7AB5: 'diào',  # 窵
    0x7AB6: 'jù',  # 窶
    0x7AB7: 'liào',  # 窷
    0x7AB8: 'xī',  # 窸
    0x7AB9: 'wù',  # 窹
    0x7ABA: 'kuī',  # 窺
    0x7ABB: 'chuāng',  # 窻
    0x7ABC: 'chāo,kē',  # 窼
    0x7ABD: 'kuǎn,cuàn',  # 窽
    0x7ABE: 'kuǎn,cuàn',  # 窾
    0x7ABF: 'lóng',  # 窿
    0x7AC0: 'chēng,chèng',  # 竀
    0x7AC1: 'cuì',  # 竁
    0x7AC2: 'liáo',  # 竂
    0x7AC3: 'zào',  # 竃
    0x7AC4: 'cuàn',  # 竄
    0x7AC5: 'qiào',  # 竅
    0x7AC6: 'qióng',  # 竆
    0x7AC7: 'dòu',  # 竇
    0x7AC8: 'zào',  # 竈
    0x7AC9: 'lǒng',  # 竉
    0x7ACA: 'qiè',  # 竊
    0x7ACB: 'lì',  # 立
    0x7ACC: 'chù',  # 竌
    0x7ACD: 'shí',  # 竍
    0x7ACE: 'fù',  # 竎
    0x7ACF: 'qiān',  # 竏
    0x7AD0: 'chù,qì',  # 竐
    0x7AD1: 'hóng',  # 竑
    0x7AD2: 'qí',  # 竒
    0x7AD3: 'háo',  # 竓
    0x7AD4: 'shēng',  # 竔
    0x7AD5: 'fēn',  # 竕
    0x7AD6: 'shù',  # 竖
    0x7AD7: 'miào',  # 竗
    0x7AD8: 'qǔ,kǒu',  # 竘
    0x7AD9: 'zhàn',  # 站
    0x7ADA: 'zhù',  # 竚
    0x7ADB: 'líng',  # 竛
    0x7ADC: 'lóng',  # 竜
    0x7ADD: 'bìng',  # 竝
    0x7ADE: 'jìng',  # 竞
    0x7ADF: 'jìng',  # 竟
    0x7AE0: 'zhāng',  # 章
    0x7AE1: 'bǎi',  # 竡
    0x7AE2: 'sì',  # 竢
    0x7AE3: 'jùn',  # 竣
    0x7AE4: 'hóng',  # 竤
    0x7AE5: 'tóng',  # 童
    0x7AE6: 'sǒng',  # 竦
    0x7AE7: 'jìng,zhěn',  # 竧
    0x7AE8: 'diào',  # 竨
    0x7AE9: 'yì',  # 竩
    0x7AEA: 'shù',  # 竪
    0x7AEB: 'jìng',  # 竫
    0x7AEC: 'qǔ',  # 竬
    0x7AED: 'jié',  # 竭
    0x7AEE: 'píng',  # 竮
    0x7AEF: 'duān',  # 端
    0x7AF0: 'lí',  # 竰
    0x7AF1: 'zhuǎn',  # 竱
    0x7AF2: 'céng,zēng',  # 竲
    0x7AF3: 'dēng',  # 竳
    0x7AF4: 'cūn',  # 竴
    0x7AF5: 'wāi',  # 竵
    0x7AF6: 'jìng',  # 競
    0x7AF7: 'kǎn,kàn',  # 竷
    0x7AF8: 'jìng',  # 竸
    0x7AF9: 'zhú',  # 竹
    0x7AFA: 'zhú,dǔ',  # 竺
    0x7AFB: 'lè,jīn',  # 竻
    0x7AFC: 'péng',  # 竼
    0x7AFD: 'yú',  # 竽
    0x7AFE: 'chí',  # 竾
    0x7AFF: 'gān',  # 竿
    0x7B00: 'máng',  # 笀
    0x7B01: 'zhú',  # 笁
    0x7B02: 'wán',  # 笂
    0x7B03: 'dǔ',  # 笃
    0x7B04: 'jī',  # 笄
    0x7B05: 'jiǎo,jiào',  # 笅
    0x7B06: 'bā',  # 笆
    0x7B07: 'suàn',  # 笇
    0x7B08: 'jí',  # 笈
    0x7B09: 'qǐn',  # 笉
    0x7B0A: 'zhào',  # 笊
    0x7B0B: 'sǔn',  # 笋
    0x7B0C: 'yá',  # 笌
    0x7B0D: 'zhuì,ruì',  # 笍
    0x7B0E: 'yuán',  # 笎
    0x7B0F: 'hù',  # 笏
    0x7B10: 'háng,hàng',  # 笐
    0x7B11: 'xiào',  # 笑
    0x7B12: 'cén,jìn,hán',  # 笒
    0x7B13: 'pí,bì',  # 笓
    0x7B14: 'bǐ',  # 笔
    0x7B15: 'jiǎn',  # 笕
    0x7B16: 'yǐ',  # 笖
    0x7B17: 'dōng',  # 笗
    0x7B18: 'shān',  # 笘
    0x7B19: 'shēng',  # 笙
    0x7B1A: 'dā,xiá,nà',  # 笚
    0x7B1B: 'dí',  # 笛
    0x7B1C: 'zhú',  # 笜
    0x7B1D: 'nà',  # 笝
    0x7B1E: 'chī',  # 笞
    0x7B1F: 'gū',  # 笟
    0x7B20: 'lì',  # 笠
    0x7B21: 'qiè',  # 笡
    0x7B22: 'mǐn',  # 笢
    0x7B23: 'bāo',  # 笣
    0x7B24: 'tiáo',  # 笤
    0x7B25: 'sì',  # 笥
    0x7B26: 'fú',  # 符
    0x7B27: 'cè',  # 笧
    0x7B28: 'bèn',  # 笨
    0x7B29: 'fá',  # 笩
    0x7B2A: 'dá',  # 笪
    0x7B2B: 'zǐ',  # 笫
    0x7B2C: 'dì',  # 第
    0x7B2D: 'líng',  # 笭
    0x7B2E: 'zuó,zé',  # 笮
    0x7B2F: 'nú',  # 笯
    0x7B30: 'fú,fèi',  # 笰
    0x7B31: 'gǒu',  # 笱
    0x7B32: 'fán',  # 笲
    0x7B33: 'jiā',  # 笳
    0x7B34: 'gě',  # 笴
    0x7B35: 'fàn',  # 笵
    0x7B36: 'shǐ',  # 笶
    0x7B37: 'mǎo',  # 笷
    0x7B38: 'pǒ',  # 笸
    0x7B39: 'tì',  # 笹
    0x7B3A: 'jiān',  # 笺
    0x7B3B: 'qióng',  # 笻
    0x7B3C: 'lóng,lǒng',  # 笼
    0x7B3D: 'mǐn',  # 笽
    0x7B3E: 'biān',  # 笾
    0x7B3F: 'luò',  # 笿
    0x7B40: 'guì',  # 筀
    0x7B41: 'qū',  # 筁
    0x7B42: 'chí',  # 筂
    0x7B43: 'yīn',  # 筃
    0x7B44: 'yào',  # 筄
    0x7B45: 'xiǎn',  # 筅
    0x7B46: 'bǐ',  # 筆
    0x7B47: 'qióng',  # 筇
    0x7B48: 'kuò',  # 筈
    0x7B49: 'děng',  # 等
    0x7B4A: 'jiǎo,jiào',  # 筊
    0x7B4B: 'jīn',  # 筋
    0x7B4C: 'quán',  # 筌
    0x7B4D: 'sǔn',  # 筍
    0x7B4E: 'rú',  # 筎
    0x7B4F: 'fá',  # 筏
    0x7B50: 'kuāng',  # 筐
    0x7B51: 'zhù,zhú',  # 筑
    0x7B52: 'tǒng',  # 筒
    0x7B53: 'jī',  # 筓
    0x7B54: 'dá,dā',  # 答
    0x7B55: 'háng',  # 筕
    0x7B56: 'cè',  # 策
    0x7B57: 'zhòng',  # 筗
    0x7B58: 'kòu',  # 筘
    0x7B59: 'lái',  # 筙
    0x7B5A: 'bì',  # 筚
    0x7B5B: 'shāi',  # 筛
    0x7B5C: 'dāng',  # 筜
    0x7B5D: 'zhēng',  # 筝
    0x7B5E: 'cè',  # 筞
    0x7B5F: 'fū',  # 筟
    0x7B60: 'yún,jūn',  # 筠
    0x7B61: 'tú',  # 筡
    0x7B62: 'pá',  # 筢
    0x7B63: 'lí',  # 筣
    0x7B64: 'láng,làng',  # 筤
    0x7B65: 'jǔ',  # 筥
    0x7B66: 'guǎn',  # 筦
    0x7B67: 'jiǎn',  # 筧
    0x7B68: 'hán',  # 筨
    0x7B69: 'tǒng',  # 筩
    0x7B6A: 'xiá',  # 筪
    0x7B6B: 'zhì,zhǐ',  # 筫
    0x7B6C: 'chéng',  # 筬
    0x7B6D: 'suàn',  # 筭
    0x7B6E: 'shì',  # 筮
    0x7B6F: 'zhù',  # 筯
    0x7B70: 'zuó',  # 筰
    0x7B71: 'xiǎo',  # 筱
    0x7B72: 'shāo',  # 筲
    0x7B73: 'tíng',  # 筳
    0x7B74: 'cè',  # 筴
    0x7B75: 'yán',  # 筵
    0x7B76: 'gào',  # 筶
    0x7B77: 'kuài',  # 筷
    0x7B78: 'gān',  # 筸
    0x7B79: 'chóu',  # 筹
    0x7B7A: 'kuāng',  # 筺
    0x7B7B: 'gàng',  # 筻
    0x7B7C: 'yún',  # 筼
    0x7B7D: 'o',  # 筽
    0x7B7E: 'qiān',  # 签
    0x7B7F: 'xiǎo',  # 筿
    0x7B80: 'jiǎn',  # 简
    0x7B81: 'póu,bù,fú,pú',  # 箁
    0x7B82: 'lái',  # 箂
    0x7B83: 'zōu',  # 箃
    0x7B84: 'pái,bēi',  # 箄
    0x7B85: 'bì',  # 箅
    0x7B86: 'bì',  # 箆
    0x7B87: 'gè',  # 箇
    0x7B88: 'tái,chí',  # 箈
    0x7B89: 'guǎi,dài',  # 箉
    0x7B8A: 'yū',  # 箊
    0x7B8B: 'jiān',  # 箋
    0x7B8C: 'zhào,dào',  # 箌
    0x7B8D: 'gū',  # 箍
    0x7B8E: 'chí',  # 箎
    0x7B8F: 'zhēng',  # 箏
    0x7B90: 'qìng,jīng',  # 箐
    0x7B91: 'shà',  # 箑
    0x7B92: 'zhǒu',  # 箒
    0x7B93: 'lù',  # 箓
    0x7B94: 'bó',  # 箔
    0x7B95: 'jī',  # 箕
    0x7B96: 'lín,lǐn',  # 箖
    0x7B97: 'suàn',  # 算
    0x7B98: 'jùn,qūn',  # 箘
    0x7B99: 'fú',  # 箙
    0x7B9A: 'zhá',  # 箚
    0x7B9B: 'gū',  # 箛
    0x7B9C: 'kōng',  # 箜
    0x7B9D: 'qián',  # 箝
    0x7B9E: 'quān',  # 箞
    0x7B9F: 'jùn',  # 箟
    0x7BA0: 'chuí',  # 箠
    0x7BA1: 'guǎn',  # 管
    0x7BA2: 'wǎn,yuān',  # 箢
    0x7BA3: 'cè',  # 箣
    0x7BA4: 'zú',  # 箤
    0x7BA5: 'pǒ',  # 箥
    0x7BA6: 'zé',  # 箦
    0x7BA7: 'qiè',  # 箧
    0x7BA8: 'tuò',  # 箨
    0x7BA9: 'luó',  # 箩
    0x7BAA: 'dān',  # 箪
    0x7BAB: 'xiāo',  # 箫
    0x7BAC: 'ruò',  # 箬
    0x7BAD: 'jiàn',  # 箭
    0x7BAE: 'xuān',  # 箮
    0x7BAF: 'biān',  # 箯
    0x7BB0: 'sǔn',  # 箰
    0x7BB1: 'xiāng',  # 箱
    0x7BB2: 'xiǎn',  # 箲
    0x7BB3: 'píng',  # 箳
    0x7BB4: 'zhēn',  # 箴
    0x7BB5: 'xīng',  # 箵
    0x7BB6: 'hú',  # 箶
    0x7BB7: 'shī,yí',  # 箷
    0x7BB8: 'zhù',  # 箸
    0x7BB9: 'yuē,yào,chuò',  # 箹
    0x7BBA: 'chūn',  # 箺
    0x7BBB: 'lǜ',  # 箻
    0x7BBC: 'wū',  # 箼
    0x7BBD: 'dǒng',  # 箽
    0x7BBE: 'shuò,xiāo,qiào',  # 箾
    0x7BBF: 'jí',  # 箿
    0x7BC0: 'jié',  # 節
    0x7BC1: 'huáng',  # 篁
    0x7BC2: 'xīng',  # 篂
    0x7BC3: 'mèi',  # 篃
    0x7BC4: 'fàn',  # 範
    0x7BC5: 'chuán',  # 篅
    0x7BC6: 'zhuàn',  # 篆
    0x7BC7: 'piān',  # 篇
    0x7BC8: 'fēng',  # 篈
    0x7BC9: 'zhù,zhú',  # 築
    0x7BCA: 'hóng',  # 篊
    0x7BCB: 'qiè',  # 篋
    0x7BCC: 'hóu',  # 篌
    0x7BCD: 'qiū',  # 篍
    0x7BCE: 'miǎo',  # 篎
    0x7BCF: 'qiàn',  # 篏
    0x7BD0: 'gū',  # 篐
    0x7BD1: 'kuì',  # 篑
    0x7BD2: 'yì',  # 篒
    0x7BD3: 'lǒu',  # 篓
    0x7BD4: 'yún',  # 篔
    0x7BD5: 'hé',  # 篕
    0x7BD6: 'táng',  # 篖
    0x7BD7: 'yuè',  # 篗
    0x7BD8: 'chōu',  # 篘
    0x7BD9: 'gāo',  # 篙
    0x7BDA: 'fěi',  # 篚
    0x7BDB: 'ruò',  # 篛
    0x7BDC: 'zhēng',  # 篜
    0x7BDD: 'gōu',  # 篝
    0x7BDE: 'niè',  # 篞
    0x7BDF: 'qiàn',  # 篟
    0x7BE0: 'xiǎo',  # 篠
    0x7BE1: 'cuàn',  # 篡
    0x7BE2: 'gōng,gǎn,lǒng',  # 篢
    0x7BE3: 'péng,páng',  # 篣
    0x7BE4: 'dǔ',  # 篤
    0x7BE5: 'lì',  # 篥
    0x7BE6: 'bì',  # 篦
    0x7BE7: 'zhuó,huò',  # 篧
    0x7BE8: 'chú',  # 篨
    0x7BE9: 'shāi',  # 篩
    0x7BEA: 'chí',  # 篪
    0x7BEB: 'zhù',  # 篫
    0x7BEC: 'qiāng,cāng',  # 篬
    0x7BED: 'lóng,lǒng',  # 篭
    0x7BEE: 'lán',  # 篮
    0x7BEF: 'jiǎn,jiān',  # 篯
    0x7BF0: 'bù',  # 篰
    0x7BF1: 'lí',  # 篱
    0x7BF2: 'huì',  # 篲
    0x7BF3: 'bì',  # 篳
    0x7BF4: 'zhú,dí',  # 篴
    0x7BF5: 'cōng',  # 篵
    0x7BF6: 'yān',  # 篶
    0x7BF7: 'péng',  # 篷
    0x7BF8: 'cēn,zān,cǎn',  # 篸
    0x7BF9: 'zhuàn,zuàn,suǎn',  # 篹
    0x7BFA: 'pí',  # 篺
    0x7BFB: 'piǎo,biāo',  # 篻
    0x7BFC: 'dōu',  # 篼
    0x7BFD: 'yù',  # 篽
    0x7BFE: 'miè',  # 篾
    0x7BFF: 'tuán,zhuān',  # 篿
    0x7C00: 'zé',  # 簀
    0x7C01: 'shāi',  # 簁
    0x7C02: 'guó,guì',  # 簂
    0x7C03: 'yí',  # 簃
    0x7C04: 'hù',  # 簄
    0x7C05: 'chǎn',  # 簅
    0x7C06: 'kòu',  # 簆
    0x7C07: 'cù',  # 簇
    0x7C08: 'píng',  # 簈
    0x7C09: 'zào',  # 簉
    0x7C0A: 'jī',  # 簊
    0x7C0B: 'guǐ',  # 簋
    0x7C0C: 'sù',  # 簌
    0x7C0D: 'lǒu',  # 簍
    0x7C0E: 'cè,jí',  # 簎
    0x7C0F: 'lù',  # 簏
    0x7C10: 'niǎn',  # 簐
    0x7C11: 'suō',  # 簑
    0x7C12: 'cuàn',  # 簒
    0x7C13: 'diāo',  # 簓
    0x7C14: 'suō',  # 簔
    0x7C15: 'lè',  # 簕
    0x7C16: 'duàn',  # 簖
    0x7C17: 'zhù',  # 簗
    0x7C18: 'xiāo',  # 簘
    0x7C19: 'bó',  # 簙
    0x7C1A: 'mì,miè',  # 簚
    0x7C1B: 'shāi',  # 簛
    0x7C1C: 'dàng',  # 簜
    0x7C1D: 'liáo',  # 簝
    0x7C1E: 'dān',  # 簞
    0x7C1F: 'diàn',  # 簟
    0x7C20: 'fǔ',  # 簠
    0x7C21: 'jiǎn',  # 簡
    0x7C22: 'mǐn',  # 簢
    0x7C23: 'kuì',  # 簣
    0x7C24: 'dài',  # 簤
    0x7C25: 'jiāo',  # 簥
    0x7C26: 'dēng',  # 簦
    0x7C27: 'huáng',  # 簧
    0x7C28: 'sǔn,zhuàn',  # 簨
    0x7C29: 'láo',  # 簩
    0x7C2A: 'zān',  # 簪
    0x7C2B: 'xiāo',  # 簫
    0x7C2C: 'lù',  # 簬
    0x7C2D: 'shì',  # 簭
    0x7C2E: 'zān',  # 簮
    0x7C2F: 'qí',  # 簯
    0x7C30: 'pái',  # 簰
    0x7C31: 'qí',  # 簱
    0x7C32: 'pái',  # 簲
    0x7C33: 'gǎn,gàn',  # 簳
    0x7C34: 'jù',  # 簴
    0x7C35: 'lù',  # 簵
    0x7C36: 'lù',  # 簶
    0x7C37: 'yán',  # 簷
    0x7C38: 'bò,bǒ',  # 簸
    0x7C39: 'dāng',  # 簹
    0x7C3A: 'sài',  # 簺
    0x7C3B: 'zhuā',  # 簻
    0x7C3C: 'gōu',  # 簼
    0x7C3D: 'qiān',  # 簽
    0x7C3E: 'lián',  # 簾
    0x7C3F: 'bù,bó',  # 簿
    0x7C40: 'zhòu',  # 籀
    0x7C41: 'lài',  # 籁
    0x7C42: 'shi',  # 籂
    0x7C43: 'lán',  # 籃
    0x7C44: 'kuì',  # 籄
    0x7C45: 'yú',  # 籅
    0x7C46: 'yuè',  # 籆
    0x7C47: 'háo',  # 籇
    0x7C48: 'zhēn,jiān',  # 籈
    0x7C49: 'tái',  # 籉
    0x7C4A: 'tì',  # 籊
    0x7C4B: 'niè',  # 籋
    0x7C4C: 'chóu',  # 籌
    0x7C4D: 'jí',  # 籍
    0x7C4E: 'yí',  # 籎
    0x7C4F: 'qí',  # 籏
    0x7C50: 'téng',  # 籐
    0x7C51: 'zhuàn',  # 籑
    0x7C52: 'zhòu',  # 籒
    0x7C53: 'fān,pān,biān',  # 籓
    0x7C54: 'sǒu,shǔ',  # 籔
    0x7C55: 'zhòu',  # 籕
    0x7C56: 'qiān',  # 籖
    0x7C57: 'zhuó',  # 籗
    0x7C58: 'téng',  # 籘
    0x7C59: 'lù',  # 籙
    0x7C5A: 'lú',  # 籚
    0x7C5B: 'jiǎn,jiān',  # 籛
    0x7C5C: 'tuò',  # 籜
    0x7C5D: 'yíng',  # 籝
    0x7C5E: 'yù',  # 籞
    0x7C5F: 'lài',  # 籟
    0x7C60: 'lóng,lǒng',  # 籠
    0x7C61: 'qiè',  # 籡
    0x7C62: 'lián',  # 籢
    0x7C63: 'lán',  # 籣
    0x7C64: 'qiān',  # 籤
    0x7C65: 'yuè',  # 籥
    0x7C66: 'zhōng',  # 籦
    0x7C67: 'qú',  # 籧
    0x7C68: 'lián',  # 籨
    0x7C69: 'biān',  # 籩
    0x7C6A: 'duàn',  # 籪
    0x7C6B: 'zuǎn',  # 籫
    0x7C6C: 'lí',  # 籬
    0x7C6D: 'shāi',  # 籭
    0x7C6E: 'luó',  # 籮
    0x7C6F: 'yíng',  # 籯
    0x7C70: 'yuè',  # 籰
    0x7C71: 'zhuó',  # 籱
    0x7C72: 'yù',  # 籲
    0x7C73: 'mǐ',  # 米
    0x7C74: 'dí',  # 籴
    0x7C75: 'fán',  # 籵
    0x7C76: 'shēn',  # 籶
    0x7C77: 'zhé',  # 籷
    0x7C78: 'shēn',  # 籸
    0x7C79: 'nǚ',  # 籹
    0x7C7A: 'hé',  # 籺
    0x7C7B: 'lèi',  # 类
    0x7C7C: 'xiān',  # 籼
    0x7C7D: 'zǐ',  # 籽
    0x7C7E: 'ní',  # 籾
    0x7C7F: 'cùn',  # 籿
    0x7C80: 'zhàng',  # 粀
    0x7C81: 'qiān',  # 粁
    0x7C82: 'zhāi',  # 粂
    0x7C83: 'bǐ',  # 粃
    0x7C84: 'bǎn',  # 粄
    0x7C85: 'wù',  # 粅
    0x7C86: 'shā,chǎo',  # 粆
    0x7C87: 'kāng,jīng',  # 粇
    0x7C88: 'róu',  # 粈
    0x7C89: 'fěn',  # 粉
    0x7C8A: 'bì',  # 粊
    0x7C8B: 'cuì',  # 粋
    0x7C8C: 'yǐn',  # 粌
    0x7C8D: 'zhé',  # 粍
    0x7C8E: 'mǐ',  # 粎
    0x7C8F: 'tà',  # 粏
    0x7C90: 'hù',  # 粐
    0x7C91: 'bā',  # 粑
    0x7C92: 'lì',  # 粒
    0x7C93: 'gān',  # 粓
    0x7C94: 'jù',  # 粔
    0x7C95: 'pò',  # 粕
    0x7C96: 'yù',  # 粖
    0x7C97: 'cū',  # 粗
    0x7C98: 'nián,zhān',  # 粘
    0x7C99: 'zhòu',  # 粙
    0x7C9A: 'chī',  # 粚
    0x7C9B: 'sù',  # 粛
    0x7C9C: 'tiào',  # 粜
    0x7C9D: 'lì',  # 粝
    0x7C9E: 'xī',  # 粞
    0x7C9F: 'sù',  # 粟
    0x7CA0: 'hóng',  # 粠
    0x7CA1: 'tóng',  # 粡
    0x7CA2: 'zī,cí',  # 粢
    0x7CA3: 'cè,sè',  # 粣
    0x7CA4: 'yuè',  # 粤
    0x7CA5: 'zhōu,yù',  # 粥
    0x7CA6: 'lín',  # 粦
    0x7CA7: 'zhuāng',  # 粧
    0x7CA8: 'bǎi',  # 粨
    0x7CA9: 'lāo',  # 粩
    0x7CAA: 'fèn',  # 粪
    0x7CAB: 'ér',  # 粫
    0x7CAC: 'qū',  # 粬
    0x7CAD: 'hé',  # 粭
    0x7CAE: 'liáng',  # 粮
    0x7CAF: 'xiàn',  # 粯
    0x7CB0: 'fū,fú',  # 粰
    0x7CB1: 'liáng',  # 粱
    0x7CB2: 'càn',  # 粲
    0x7CB3: 'jīng',  # 粳
    0x7CB4: 'lǐ',  # 粴
    0x7CB5: 'yuè',  # 粵
    0x7CB6: 'lù',  # 粶
    0x7CB7: 'jú',  # 粷
    0x7CB8: 'qí',  # 粸
    0x7CB9: 'cuì',  # 粹
    0x7CBA: 'bài',  # 粺
    0x7CBB: 'zhāng',  # 粻
    0x7CBC: 'lín',  # 粼
    0x7CBD: 'zòng',  # 粽
    0x7CBE: 'jīng',  # 精
    0x7CBF: 'guǒ',  # 粿
    0x7CC0: 'huā',  # 糀
    0x7CC1: 'sǎn,shēn',  # 糁
    0x7CC2: 'shēn',  # 糂
    0x7CC3: 'táng',  # 糃
    0x7CC4: 'biān,biǎn',  # 糄
    0x7CC5: 'róu',  # 糅
    0x7CC6: 'miàn',  # 糆
    0x7CC7: 'hóu',  # 糇
    0x7CC8: 'xǔ',  # 糈
    0x7CC9: 'zòng',  # 糉
    0x7CCA: 'hū,hú,hù',  # 糊
    0x7CCB: 'jiàn',  # 糋
    0x7CCC: 'zān',  # 糌
    0x7CCD: 'cí',  # 糍
    0x7CCE: 'lí',  # 糎
    0x7CCF: 'xiè',  # 糏
    0x7CD0: 'fū',  # 糐
    0x7CD1: 'nuò',  # 糑
    0x7CD2: 'bèi',  # 糒
    0x7CD3: 'gǔ,gòu',  # 糓
    0x7CD4: 'xiǔ',  # 糔
    0x7CD5: 'gāo',  # 糕
    0x7CD6: 'táng',  # 糖
    0x7CD7: 'qiǔ',  # 糗
    0x7CD8: 'jiā',  # 糘
    0x7CD9: 'cāo',  # 糙
    0x7CDA: 'zhuāng',  # 糚
    0x7CDB: 'táng',  # 糛
    0x7CDC: 'mí,méi',  # 糜
    0x7CDD: 'sǎn,shēn',  # 糝
    0x7CDE: 'fèn',  # 糞
    0x7CDF: 'zāo',  # 糟
    0x7CE0: 'kāng',  # 糠
    0x7CE1: 'jiàng',  # 糡
    0x7CE2: 'mó',  # 糢
    0x7CE3: 'sǎn,shēn',  # 糣
    0x7CE4: 'sǎn',  # 糤
    0x7CE5: 'nuò',  # 糥
    0x7CE6: 'xī',  # 糦
    0x7CE7: 'liáng',  # 糧
    0x7CE8: 'jiàng',  # 糨
    0x7CE9: 'kuài',  # 糩
    0x7CEA: 'bó',  # 糪
    0x7CEB: 'huán',  # 糫
    0x7CEC: 'shǔ',  # 糬
    0x7CED: 'zòng',  # 糭
    0x7CEE: 'xiàn',  # 糮
    0x7CEF: 'nuò',  # 糯
    0x7CF0: 'tuán',  # 糰
    0x7CF1: 'niè',  # 糱
    0x7CF2: 'lì',  # 糲
    0x7CF3: 'zuò',  # 糳
    0x7CF4: 'dí',  # 糴
    0x7CF5: 'niè',  # 糵
    0x7CF6: 'tiào',  # 糶
    0x7CF7: 'làn',  # 糷
    0x7CF8: 'mì,sī',  # 糸
    0x7CF9: 'sī',  # 糹
    0x7CFA: 'jiū,jiǔ',  # 糺
    0x7CFB: 'xì,jì',  # 系
    0x7CFC: 'gōng',  # 糼
    0x7CFD: 'zhēng,zhěng',  # 糽
    0x7CFE: 'jiū',  # 糾
    0x7CFF: 'gōng',  # 糿
    0x7D00: 'jì',  # 紀
    0x7D01: 'chà,chǎ',  # 紁
    0x7D02: 'zhòu',  # 紂
    0x7D03: 'xún',  # 紃
    0x7D04: 'yuē,yāo',  # 約
    0x7D05: 'hóng,gōng',  # 紅
    0x7D06: 'yū',  # 紆
    0x7D07: 'hé,gē',  # 紇
    0x7D08: 'wán',  # 紈
    0x7D09: 'rèn',  # 紉
    0x7D0A: 'wěn',  # 紊
    0x7D0B: 'wén,wèn',  # 紋
    0x7D0C: 'qiú',  # 紌
    0x7D0D: 'nà',  # 納
    0x7D0E: 'zī',  # 紎
    0x7D0F: 'tǒu',  # 紏
    0x7D10: 'niǔ',  # 紐
    0x7D11: 'fóu',  # 紑
    0x7D12: 'jì,jié,jiè',  # 紒
    0x7D13: 'shū',  # 紓
    0x7D14: 'chún',  # 純
    0x7D15: 'pī,pí,bǐ',  # 紕
    0x7D16: 'zhèn',  # 紖
    0x7D17: 'shā',  # 紗
    0x7D18: 'hóng',  # 紘
    0x7D19: 'zhǐ',  # 紙
    0x7D1A: 'jí',  # 級
    0x7D1B: 'fēn',  # 紛
    0x7D1C: 'yún',  # 紜
    0x7D1D: 'rèn',  # 紝
    0x7D1E: 'dǎn',  # 紞
    0x7D1F: 'jīn,jìn',  # 紟
    0x7D20: 'sù',  # 素
    0x7D21: 'fǎng',  # 紡
    0x7D22: 'suǒ',  # 索
    0x7D23: 'cuì',  # 紣
    0x7D24: 'jiǔ',  # 紤
    0x7D25: 'zhā,zā',  # 紥
    0x7D26: 'hā',  # 紦
    0x7D27: 'jǐn',  # 紧
    0x7D28: 'fū,fù',  # 紨
    0x7D29: 'zhì',  # 紩
    0x7D2A: 'qī',  # 紪
    0x7D2B: 'zǐ',  # 紫
    0x7D2C: 'chōu,chóu',  # 紬
    0x7D2D: 'hóng',  # 紭
    0x7D2E: 'zhā,zā',  # 紮
    0x7D2F: 'léi,lěi,lèi',  # 累
    0x7D30: 'xì',  # 細
    0x7D31: 'fú',  # 紱
    0x7D32: 'xiè',  # 紲
    0x7D33: 'shēn',  # 紳
    0x7D34: 'bō,bì',  # 紴
    0x7D35: 'zhù',  # 紵
    0x7D36: 'qū,qǔ',  # 紶
    0x7D37: 'líng',  # 紷
    0x7D38: 'zhù',  # 紸
    0x7D39: 'shào',  # 紹
    0x7D3A: 'gàn',  # 紺
    0x7D3B: 'yǎng',  # 紻
    0x7D3C: 'fú',  # 紼
    0x7D3D: 'tuó',  # 紽
    0x7D3E: 'zhěn,tiǎn',  # 紾
    0x7D3F: 'dài',  # 紿
    0x7D40: 'chù',  # 絀
    0x7D41: 'shī',  # 絁
    0x7D42: 'zhōng',  # 終
    0x7D43: 'xián',  # 絃
    0x7D44: 'zǔ',  # 組
    0x7D45: 'jiōng,jiǒng',  # 絅
    0x7D46: 'bàn',  # 絆
    0x7D47: 'qú',  # 絇
    0x7D48: 'mò',  # 絈
    0x7D49: 'shù',  # 絉
    0x7D4A: 'zuì',  # 絊
    0x7D4B: 'kuàng',  # 絋
    0x7D4C: 'jīng',  # 経
    0x7D4D: 'rèn',  # 絍
    0x7D4E: 'háng',  # 絎
    0x7D4F: 'xiè',  # 絏
    0x7D50: 'jié,jiē',  # 結
    0x7D51: 'zhū',  # 絑
    0x7D52: 'chóu',  # 絒
    0x7D53: 'guà,kuā',  # 絓
    0x7D54: 'bǎi,mò',  # 絔
    0x7D55: 'jué',  # 絕
    0x7D56: 'kuàng',  # 絖
    0x7D57: 'hú',  # 絗
    0x7D58: 'cì',  # 絘
    0x7D59: 'huán,gēng',  # 絙
    0x7D5A: 'gēng',  # 絚
    0x7D5B: 'tāo',  # 絛
    0x7D5C: 'xié,jié',  # 絜
    0x7D5D: 'kù',  # 絝
    0x7D5E: 'jiǎo',  # 絞
    0x7D5F: 'quán,shuān',  # 絟
    0x7D60: 'gǎi,ǎi',  # 絠
    0x7D61: 'luò,lào',  # 絡
    0x7D62: 'xuàn',  # 絢
    0x7D63: 'bēng,bīng,pēng',  # 絣
    0x7D64: 'xiàn',  # 絤
    0x7D65: 'fú',  # 絥
    0x7D66: 'gěi,jǐ',  # 給
    0x7D67: 'tōng,tóng,dòng',  # 絧
    0x7D68: 'róng',  # 絨
    0x7D69: 'tiào,diào,dào',  # 絩
    0x7D6A: 'yīn',  # 絪
    0x7D6B: 'lěi,lèi,léi',  # 絫
    0x7D6C: 'xiè',  # 絬
    0x7D6D: 'juàn',  # 絭
    0x7D6E: 'xù',  # 絮
    0x7D6F: 'gāi,hài',  # 絯
    0x7D70: 'dié',  # 絰
    0x7D71: 'tǒng',  # 統
    0x7D72: 'sī',  # 絲
    0x7D73: 'jiàng',  # 絳
    0x7D74: 'xiáng',  # 絴
    0x7D75: 'huì',  # 絵
    0x7D76: 'jué',  # 絶
    0x7D77: 'zhí',  # 絷
    0x7D78: 'jiǎn',  # 絸
    0x7D79: 'juàn',  # 絹
    0x7D7A: 'chī,zhǐ',  # 絺
    0x7D7B: 'miǎn,wèn,mán,wàn',  # 絻
    0x7D7C: 'zhèn',  # 絼
    0x7D7D: 'lǚ',  # 絽
    0x7D7E: 'chéng',  # 絾
    0x7D7F: 'qiú',  # 絿
    0x7D80: 'shū',  # 綀
    0x7D81: 'bǎng',  # 綁
    0x7D82: 'tǒng',  # 綂
    0x7D83: 'xiāo',  # 綃
    0x7D84: 'huán,huàn,wàn',  # 綄
    0x7D85: 'qīn,xiān',  # 綅
    0x7D86: 'gěng',  # 綆
    0x7D87: 'xū',  # 綇
    0x7D88: 'tí,tì',  # 綈
    0x7D89: 'xiù',  # 綉
    0x7D8A: 'xié',  # 綊
    0x7D8B: 'hóng',  # 綋
    0x7D8C: 'xì',  # 綌
    0x7D8D: 'fú',  # 綍
    0x7D8E: 'tīng',  # 綎
    0x7D8F: 'suí',  # 綏
    0x7D90: 'duì',  # 綐
    0x7D91: 'kǔn',  # 綑
    0x7D92: 'fū',  # 綒
    0x7D93: 'jīng',  # 經
    0x7D94: 'hù',  # 綔
    0x7D95: 'zhī',  # 綕
    0x7D96: 'yán,xiàn',  # 綖
    0x7D97: 'jiǒng',  # 綗
    0x7D98: 'féng',  # 綘
    0x7D99: 'jì',  # 継
    0x7D9A: 'xù',  # 続
    0x7D9B: 'rěn',  # 綛
    0x7D9C: 'zōng,zèng',  # 綜
    0x7D9D: 'lín,chēn',  # 綝
    0x7D9E: 'duǒ',  # 綞
    0x7D9F: 'lì,liè',  # 綟
    0x7DA0: 'lǜ',  # 綠
    0x7DA1: 'jīng',  # 綡
    0x7DA2: 'chóu',  # 綢
    0x7DA3: 'quǎn',  # 綣
    0x7DA4: 'shào',  # 綤
    0x7DA5: 'qí',  # 綥
    0x7DA6: 'qí',  # 綦
    0x7DA7: 'zhǔn,zhùn',  # 綧
    0x7DA8: 'jī,qí',  # 綨
    0x7DA9: 'wǎn',  # 綩
    0x7DAA: 'qiàn,qīng,zhēng',  # 綪
    0x7DAB: 'xiàn',  # 綫
    0x7DAC: 'shòu',  # 綬
    0x7DAD: 'wéi',  # 維
    0x7DAE: 'qìng,qǐ',  # 綮
    0x7DAF: 'táo',  # 綯
    0x7DB0: 'wǎn',  # 綰
    0x7DB1: 'gāng',  # 綱
    0x7DB2: 'wǎng',  # 網
    0x7DB3: 'bēng,běng,bèng',  # 綳
    0x7DB4: 'zhuì',  # 綴
    0x7DB5: 'cǎi',  # 綵
    0x7DB6: 'guǒ',  # 綶
    0x7DB7: 'cuì',  # 綷
    0x7DB8: 'lún,guān',  # 綸
    0x7DB9: 'liǔ',  # 綹
    0x7DBA: 'qǐ',  # 綺
    0x7DBB: 'zhàn',  # 綻
    0x7DBC: 'bì',  # 綼
    0x7DBD: 'chuò,chāo',  # 綽
    0x7DBE: 'líng',  # 綾
    0x7DBF: 'mián',  # 綿
    0x7DC0: 'qī',  # 緀
    0x7DC1: 'jī',  # 緁
    0x7DC2: 'tián,tǎn,chān',  # 緂
    0x7DC3: 'zōng',  # 緃
    0x7DC4: 'gǔn',  # 緄
    0x7DC5: 'zōu',  # 緅
    0x7DC6: 'xī',  # 緆
    0x7DC7: 'zī',  # 緇
    0x7DC8: 'xìng',  # 緈
    0x7DC9: 'liǎng',  # 緉
    0x7DCA: 'jǐn',  # 緊
    0x7DCB: 'fēi',  # 緋
    0x7DCC: 'ruí',  # 緌
    0x7DCD: 'mín',  # 緍
    0x7DCE: 'yù',  # 緎
    0x7DCF: 'zǒng',  # 総
    0x7DD0: 'fán',  # 緐
    0x7DD1: 'lǜ,lù',  # 緑
    0x7DD2: 'xù',  # 緒
    0x7DD3: 'yīng',  # 緓
    0x7DD4: 'shàng',  # 緔
    0x7DD5: 'zī',  # 緕
    0x7DD6: 'xù',  # 緖
    0x7DD7: 'xiāng',  # 緗
    0x7DD8: 'jiān',  # 緘
    0x7DD9: 'kè',  # 緙
    0x7DDA: 'xiàn',  # 線
    0x7DDB: 'ruǎn,ruàn',  # 緛
    0x7DDC: 'mián',  # 緜
    0x7DDD: 'jī,qī',  # 緝
    0x7DDE: 'duàn',  # 緞
    0x7DDF: 'chóng,zhòng',  # 緟
    0x7DE0: 'dì',  # 締
    0x7DE1: 'mín',  # 緡
    0x7DE2: 'miáo,máo',  # 緢
    0x7DE3: 'yuán',  # 緣
    0x7DE4: 'xiè,yè',  # 緤
    0x7DE5: 'bǎo',  # 緥
    0x7DE6: 'sī',  # 緦
    0x7DE7: 'qiū',  # 緧
    0x7DE8: 'biān',  # 編
    0x7DE9: 'huǎn',  # 緩
    0x7DEA: 'gēng,gèng',  # 緪
    0x7DEB: 'zǒng',  # 緫
    0x7DEC: 'miǎn',  # 緬
    0x7DED: 'wèi',  # 緭
    0x7DEE: 'fù',  # 緮
    0x7DEF: 'wěi',  # 緯
    0x7DF0: 'tōu,xū,shū',  # 緰
    0x7DF1: 'gōu',  # 緱
    0x7DF2: 'miǎo',  # 緲
    0x7DF3: 'xié',  # 緳
    0x7DF4: 'liàn',  # 練
    0x7DF5: 'zōng,zòng',  # 緵
    0x7DF6: 'biàn,pián',  # 緶
    0x7DF7: 'gǔn,yùn',  # 緷
    0x7DF8: 'yīn',  # 緸
    0x7DF9: 'tí',  # 緹
    0x7DFA: 'guā,wō',  # 緺
    0x7DFB: 'zhì',  # 緻
    0x7DFC: 'yùn,yūn,wēn',  # 緼
    0x7DFD: 'chēng',  # 緽
    0x7DFE: 'chán',  # 緾
    0x7DFF: 'dài',  # 緿
    0x7E00: 'xié',  # 縀
    0x7E01: 'yuán',  # 縁
    0x7E02: 'zǒng',  # 縂
    0x7E03: 'xū',  # 縃
    0x7E04: 'shéng',  # 縄
    0x7E05: 'wēi',  # 縅
    0x7E06: 'gēng,gèng',  # 縆
    0x7E07: 'seon',  # 縇
    0x7E08: 'yíng',  # 縈
    0x7E09: 'jìn',  # 縉
    0x7E0A: 'yì',  # 縊
    0x7E0B: 'zhuì',  # 縋
    0x7E0C: 'nì',  # 縌
    0x7E0D: 'bāng,bàng',  # 縍
    0x7E0E: 'gǔ,hú',  # 縎
    0x7E0F: 'pán',  # 縏
    0x7E10: 'zhòu',  # 縐
    0x7E11: 'jiān',  # 縑
    0x7E12: 'cī,cuò,suǒ',  # 縒
    0x7E13: 'quán',  # 縓
    0x7E14: 'shuǎng',  # 縔
    0x7E15: 'yùn,yūn,wēn',  # 縕
    0x7E16: 'xiá',  # 縖
    0x7E17: 'cuī,suī,shuāi',  # 縗
    0x7E18: 'xì',  # 縘
    0x7E19: 'róng,rǒng,ròng',  # 縙
    0x7E1A: 'tāo',  # 縚
    0x7E1B: 'fù',  # 縛
    0x7E1C: 'yún',  # 縜
    0x7E1D: 'zhěn',  # 縝
    0x7E1E: 'gǎo',  # 縞
    0x7E1F: 'rù',  # 縟
    0x7E20: 'hú',  # 縠
    0x7E21: 'zài,zēng',  # 縡
    0x7E22: 'téng',  # 縢
    0x7E23: 'xiàn,xuán',  # 縣
    0x7E24: 'sù',  # 縤
    0x7E25: 'zhěn',  # 縥
    0x7E26: 'zòng',  # 縦
    0x7E27: 'tāo',  # 縧
    0x7E28: 'huǎng',  # 縨
    0x7E29: 'cài',  # 縩
    0x7E2A: 'bì',  # 縪
    0x7E2B: 'féng,fèng',  # 縫
    0x7E2C: 'cù',  # 縬
    0x7E2D: 'lí',  # 縭
    0x7E2E: 'suō,sù',  # 縮
    0x7E2F: 'yǎn,yǐn',  # 縯
    0x7E30: 'xǐ',  # 縰
    0x7E31: 'zòng,zǒng',  # 縱
    0x7E32: 'léi',  # 縲
    0x7E33: 'zhuàn,juàn',  # 縳
    0x7E34: 'qiàn',  # 縴
    0x7E35: 'màn',  # 縵
    0x7E36: 'zhí',  # 縶
    0x7E37: 'lǚ',  # 縷
    0x7E38: 'mù,mò',  # 縸
    0x7E39: 'piǎo,piāo',  # 縹
    0x7E3A: 'lián',  # 縺
    0x7E3B: 'mí',  # 縻
    0x7E3C: 'xuàn',  # 縼
    0x7E3D: 'zǒng',  # 總
    0x7E3E: 'jì',  # 績
    0x7E3F: 'shān',  # 縿
    0x7E40: 'suì',  # 繀
    0x7E41: 'fán,pó',  # 繁
    0x7E42: 'lǜ',  # 繂
    0x7E43: 'bēng,běng,bèng',  # 繃
    0x7E44: 'yī',  # 繄
    0x7E45: 'sāo',  # 繅
    0x7E46: 'móu,miù,miào,mù,liǎo',  # 繆
    0x7E47: 'yáo,yóu,zhòu',  # 繇
    0x7E48: 'qiǎng',  # 繈
    0x7E49: 'shéng',  # 繉
    0x7E4A: 'xiān',  # 繊
    0x7E4B: 'jì',  # 繋
    0x7E4C: 'zōng,zòng',  # 繌
    0x7E4D: 'xiù',  # 繍
    0x7E4E: 'rán',  # 繎
    0x7E4F: 'xuàn',  # 繏
    0x7E50: 'suì',  # 繐
    0x7E51: 'qiāo',  # 繑
    0x7E52: 'zēng,zèng',  # 繒
    0x7E53: 'zuǒ',  # 繓
    0x7E54: 'zhī,zhì',  # 織
    0x7E55: 'shàn',  # 繕
    0x7E56: 'sǎn',  # 繖
    0x7E57: 'lín',  # 繗
    0x7E58: 'jú,jué',  # 繘
    0x7E59: 'fān',  # 繙
    0x7E5A: 'liáo',  # 繚
    0x7E5B: 'chuō,chuò',  # 繛
    0x7E5C: 'zūn,zǔn',  # 繜
    0x7E5D: 'jiàn',  # 繝
    0x7E5E: 'rào',  # 繞
    0x7E5F: 'chǎn,chán',  # 繟
    0x7E60: 'ruǐ',  # 繠
    0x7E61: 'xiù',  # 繡
    0x7E62: 'huì,huí',  # 繢
    0x7E63: 'huà',  # 繣
    0x7E64: 'zuǎn',  # 繤
    0x7E65: 'xī',  # 繥
    0x7E66: 'qiǎng',  # 繦
    0x7E67: 'wén',  # 繧
    0x7E68: 'da',  # 繨
    0x7E69: 'shéng',  # 繩
    0x7E6A: 'huì',  # 繪
    0x7E6B: 'xì,jì',  # 繫
    0x7E6C: 'sè',  # 繬
    0x7E6D: 'jiǎn',  # 繭
    0x7E6E: 'jiāng',  # 繮
    0x7E6F: 'huán',  # 繯
    0x7E70: 'qiāo,sāo',  # 繰
    0x7E71: 'cōng',  # 繱
    0x7E72: 'xiè',  # 繲
    0x7E73: 'jiǎo,zhuó',  # 繳
    0x7E74: 'bì',  # 繴
    0x7E75: 'dàn,tán,chán',  # 繵
    0x7E76: 'yì',  # 繶
    0x7E77: 'nǒng',  # 繷
    0x7E78: 'suì',  # 繸
    0x7E79: 'yì',  # 繹
    0x7E7A: 'shā',  # 繺
    0x7E7B: 'rú',  # 繻
    0x7E7C: 'jì',  # 繼
    0x7E7D: 'bīn',  # 繽
    0x7E7E: 'qiǎn',  # 繾
    0x7E7F: 'lán',  # 繿
    0x7E80: 'pú,fú',  # 纀
    0x7E81: 'xūn',  # 纁
    0x7E82: 'zuǎn',  # 纂
    0x7E83: 'zī',  # 纃
    0x7E84: 'péng',  # 纄
    0x7E85: 'yào,lì',  # 纅
    0x7E86: 'mò',  # 纆
    0x7E87: 'lèi',  # 纇
    0x7E88: 'xiè',  # 纈
    0x7E89: 'zuǎn',  # 纉
    0x7E8A: 'kuàng',  # 纊
    0x7E8B: 'yōu',  # 纋
    0x7E8C: 'xù',  # 續
    0x7E8D: 'léi',  # 纍
    0x7E8E: 'xiān',  # 纎
    0x7E8F: 'chán',  # 纏
    0x7E90: 'jiǎo',  # 纐
    0x7E91: 'lú',  # 纑
    0x7E92: 'chán',  # 纒
    0x7E93: 'yīng',  # 纓
    0x7E94: 'cái',  # 纔
    0x7E95: 'xiāng,rǎng',  # 纕
    0x7E96: 'xiān',  # 纖
    0x7E97: 'zuī',  # 纗
    0x7E98: 'zuǎn',  # 纘
    0x7E99: 'luò',  # 纙
    0x7E9A: 'lí,xǐ,lǐ,sǎ',  # 纚
    0x7E9B: 'dào',  # 纛
    0x7E9C: 'lǎn',  # 纜
    0x7E9D: 'léi',  # 纝
    0x7E9E: 'liàn',  # 纞
    0x7E9F: 'sī',  # 纟
    0x7EA0: 'jiū',  # 纠
    0x7EA1: 'yū',  # 纡
    0x7EA2: 'hóng,gōng',  # 红
    0x7EA3: 'zhòu',  # 纣
    0x7EA4: 'xiān,qiàn',  # 纤
    0x7EA5: 'hé,gē',  # 纥
    0x7EA6: 'yuē,yāo',  # 约
    0x7EA7: 'jí',  # 级
    0x7EA8: 'wán',  # 纨
    0x7EA9: 'kuàng',  # 纩
    0x7EAA: 'jì,jǐ',  # 纪
    0x7EAB: 'rèn',  # 纫
    0x7EAC: 'wěi',  # 纬
    0x7EAD: 'yún',  # 纭
    0x7EAE: 'hóng',  # 纮
    0x7EAF: 'chún',  # 纯
    0x7EB0: 'pī,pí,bǐ',  # 纰
    0x7EB1: 'shā',  # 纱
    0x7EB2: 'gāng',  # 纲
    0x7EB3: 'nà',  # 纳
    0x7EB4: 'rèn',  # 纴
    0x7EB5: 'zòng,zǒng',  # 纵
    0x7EB6: 'lún,guān',  # 纶
    0x7EB7: 'fēn',  # 纷
    0x7EB8: 'zhǐ',  # 纸
    0x7EB9: 'wén,wèn',  # 纹
    0x7EBA: 'fǎng',  # 纺
    0x7EBB: 'zhù',  # 纻
    0x7EBC: 'zhèn',  # 纼
    0x7EBD: 'niǔ',  # 纽
    0x7EBE: 'shū',  # 纾
    0x7EBF: 'xiàn',  # 线
    0x7EC0: 'gàn',  # 绀
    0x7EC1: 'xiè',  # 绁
    0x7EC2: 'fú',  # 绂
    0x7EC3: 'liàn',  # 练
    0x7EC4: 'zǔ',  # 组
    0x7EC5: 'shēn',  # 绅
    0x7EC6: 'xì',  # 细
    0x7EC7: 'zhī,zhì',  # 织
    0x7EC8: 'zhōng',  # 终
    0x7EC9: 'zhòu',  # 绉
    0x7ECA: 'bàn',  # 绊
    0x7ECB: 'fú',  # 绋
    0x7ECC: 'chù',  # 绌
    0x7ECD: 'shào',  # 绍
    0x7ECE: 'yì',  # 绎
    0x7ECF: 'jīng',  # 经
    0x7ED0: 'dài',  # 绐
    0x7ED1: 'bǎng',  # 绑
    0x7ED2: 'róng',  # 绒
    0x7ED3: 'jié,jiē',  # 结
    0x7ED4: 'kù',  # 绔
    0x7ED5: 'rào',  # 绕
    0x7ED6: 'dié',  # 绖
    0x7ED7: 'háng',  # 绗
    0x7ED8: 'huì',  # 绘
    0x7ED9: 'gěi,jǐ',  # 给
    0x7EDA: 'xuàn',  # 绚
    0x7EDB: 'jiàng',  # 绛
    0x7EDC: 'luò,lào',  # 络
    0x7EDD: 'jué',  # 绝
    0x7EDE: 'jiǎo',  # 绞
    0x7EDF: 'tǒng',  # 统
    0x7EE0: 'gěng',  # 绠
    0x7EE1: 'xiāo',  # 绡
    0x7EE2: 'juàn',  # 绢
    0x7EE3: 'xiù',  # 绣
    0x7EE4: 'xì',  # 绤
    0x7EE5: 'suí',  # 绥
    0x7EE6: 'tāo',  # 绦
    0x7EE7: 'jì',  # 继
    0x7EE8: 'tí,tì',  # 绨
    0x7EE9: 'jì',  # 绩
    0x7EEA: 'xù',  # 绪
    0x7EEB: 'líng',  # 绫
    0x7EEC: 'yīng',  # 绬
    0x7EED: 'xù',  # 续
    0x7EEE: 'qǐ',  # 绮
    0x7EEF: 'fēi',  # 绯
    0x7EF0: 'chuò,chāo',  # 绰
    0x7EF1: 'shàng',  # 绱
    0x7EF2: 'gǔn',  # 绲
    0x7EF3: 'shéng',  # 绳
    0x7EF4: 'wéi',  # 维
    0x7EF5: 'mián',  # 绵
    0x7EF6: 'shòu',  # 绶
    0x7EF7: 'bēng,běng,bèng',  # 绷
    0x7EF8: 'chóu',  # 绸
    0x7EF9: 'táo',  # 绹
    0x7EFA: 'liǔ',  # 绺
    0x7EFB: 'quǎn',  # 绻
    0x7EFC: 'zōng,zèng',  # 综
    0x7EFD: 'zhàn',  # 绽
    0x7EFE: 'wǎn',  # 绾
    0x7EFF: 'lǜ,lù',  # 绿
    0x7F00: 'zhuì',  # 缀
    0x7F01: 'zī',  # 缁
    0x7F02: 'kè',  # 缂
    0x7F03: 'xiāng',  # 缃
    0x7F04: 'jiān',  # 缄
    0x7F05: 'miǎn',  # 缅
    0x7F06: 'lǎn',  # 缆
    0x7F07: 'tí',  # 缇
    0x7F08: 'miǎo',  # 缈
    0x7F09: 'jī,qī',  # 缉
    0x7F0A: 'yùn,yūn,wēn',  # 缊
    0x7F0B: 'huì,huí',  # 缋
    0x7F0C: 'sī',  # 缌
    0x7F0D: 'duǒ',  # 缍
    0x7F0E: 'duàn',  # 缎
    0x7F0F: 'biàn,pián',  # 缏
    0x7F10: 'xiàn',  # 缐
    0x7F11: 'gōu',  # 缑
    0x7F12: 'zhuì',  # 缒
    0x7F13: 'huǎn',  # 缓
    0x7F14: 'dì',  # 缔
    0x7F15: 'lǚ',  # 缕
    0x7F16: 'biān',  # 编
    0x7F17: 'mín',  # 缗
    0x7F18: 'yuán',  # 缘
    0x7F19: 'jìn',  # 缙
    0x7F1A: 'fù',  # 缚
    0x7F1B: 'rù',  # 缛
    0x7F1C: 'zhěn',  # 缜
    0x7F1D: 'féng,fèng',  # 缝
    0x7F1E: 'cuī,suī,shuāi',  # 缞
    0x7F1F: 'gǎo',  # 缟
    0x7F20: 'chán',  # 缠
    0x7F21: 'lí',  # 缡
    0x7F22: 'yì',  # 缢
    0x7F23: 'jiān',  # 缣
    0x7F24: 'bīn',  # 缤
    0x7F25: 'piǎo,piāo',  # 缥
    0x7F26: 'màn',  # 缦
    0x7F27: 'léi',  # 缧
    0x7F28: 'yīng',  # 缨
    0x7F29: 'suō,sù',  # 缩
    0x7F2A: 'móu,miù,miào,mù,liǎo',  # 缪
    0x7F2B: 'sāo',  # 缫
    0x7F2C: 'xié',  # 缬
    0x7F2D: 'liáo',  # 缭
    0x7F2E: 'shàn',  # 缮
    0x7F2F: 'zēng,zèng',  # 缯
    0x7F30: 'jiāng',  # 缰
    0x7F31: 'qiǎn',  # 缱
    0x7F32: 'qiāo,sāo',  # 缲
    0x7F33: 'huán',  # 缳
    0x7F34: 'jiǎo,zhuó',  # 缴
    0x7F35: 'zuǎn',  # 缵
    0x7F36: 'fǒu',  # 缶
    0x7F37: 'xiè',  # 缷
    0x7F38: 'gāng',  # 缸
    0x7F39: 'fǒu',  # 缹
    0x7F3A: 'quē',  # 缺
    0x7F3B: 'fǒu',  # 缻
    0x7F3C: 'quē',  # 缼
    0x7F3D: 'bō',  # 缽
    0x7F3E: 'píng',  # 缾
    0x7F3F: 'xiàng',  # 缿
    0x7F40: 'zhào',  # 罀
    0x7F41: 'gāng',  # 罁
    0x7F42: 'yīng',  # 罂
    0x7F43: 'yīng',  # 罃
    0x7F44: 'qìng',  # 罄
    0x7F45: 'xià',  # 罅
    0x7F46: 'guàn',  # 罆
    0x7F47: 'zūn',  # 罇
    0x7F48: 'tán',  # 罈
    0x7F49: 'chēng',  # 罉
    0x7F4A: 'qì',  # 罊
    0x7F4B: 'wèng',  # 罋
    0x7F4C: 'yīng',  # 罌
    0x7F4D: 'léi',  # 罍
    0x7F4E: 'tán',  # 罎
    0x7F4F: 'lú',  # 罏
    0x7F50: 'guàn',  # 罐
    0x7F51: 'wǎng',  # 网
    0x7F52: 'wǎng',  # 罒
    0x7F53: 'wǎng',  # 罓
    0x7F54: 'wǎng',  # 罔
    0x7F55: 'hǎn',  # 罕
    0x7F56: 'wǎng,ra',  # 罖
    0x7F57: 'luó',  # 罗
    0x7F58: 'fú',  # 罘
    0x7F59: 'shēn',  # 罙
    0x7F5A: 'fá',  # 罚
    0x7F5B: 'gū',  # 罛
    0x7F5C: 'zhǔ',  # 罜
    0x7F5D: 'jū',  # 罝
    0x7F5E: 'máo',  # 罞
    0x7F5F: 'gǔ',  # 罟
    0x7F60: 'mín',  # 罠
    0x7F61: 'gāng',  # 罡
    0x7F62: 'bà,ba,pí',  # 罢
    0x7F63: 'guà',  # 罣
    0x7F64: 'tí',  # 罤
    0x7F65: 'juàn',  # 罥
    0x7F66: 'fú',  # 罦
    0x7F67: 'shēn',  # 罧
    0x7F68: 'yǎn',  # 罨
    0x7F69: 'zhào',  # 罩
    0x7F6A: 'zuì',  # 罪
    0x7F6B: 'guǎi,guà',  # 罫
    0x7F6C: 'zhuó',  # 罬
    0x7F6D: 'yù',  # 罭
    0x7F6E: 'zhì',  # 置
    0x7F6F: 'ǎn',  # 罯
    0x7F70: 'fá',  # 罰
    0x7F71: 'lǎn',  # 罱
    0x7F72: 'shǔ',  # 署
    0x7F73: 'sī',  # 罳
    0x7F74: 'pí',  # 罴
    0x7F75: 'mà',  # 罵
    0x7F76: 'liǔ',  # 罶
    0x7F77: 'bà,ba,pí',  # 罷
    0x7F78: 'fá',  # 罸
    0x7F79: 'lí',  # 罹
    0x7F7A: 'cháo',  # 罺
    0x7F7B: 'wèi',  # 罻
    0x7F7C: 'bì',  # 罼
    0x7F7D: 'jì',  # 罽
    0x7F7E: 'zēng',  # 罾
    0x7F7F: 'chōng',  # 罿
    0x7F80: 'liǔ',  # 羀
    0x7F81: 'jī',  # 羁
    0x7F82: 'juàn',  # 羂
    0x7F83: 'mì',  # 羃
    0x7F84: 'zhào',  # 羄
    0x7F85: 'luó',  # 羅
    0x7F86: 'pí',  # 羆
    0x7F87: 'jī',  # 羇
    0x7F88: 'jī',  # 羈
    0x7F89: 'luán',  # 羉
    0x7F8A: 'yáng,xiáng',  # 羊
    0x7F8B: 'mǐ',  # 羋
    0x7F8C: 'qiāng',  # 羌
    0x7F8D: 'dá',  # 羍
    0x7F8E: 'měi',  # 美
    0x7F8F: 'yáng,xiáng',  # 羏
    0x7F90: 'líng',  # 羐
    0x7F91: 'yǒu',  # 羑
    0x7F92: 'fén',  # 羒
    0x7F93: 'bā',  # 羓
    0x7F94: 'gāo',  # 羔
    0x7F95: 'yàng',  # 羕
    0x7F96: 'gǔ',  # 羖
    0x7F97: 'qiāng',  # 羗
    0x7F98: 'zāng',  # 羘
    0x7F99: 'měi,gāo',  # 羙
    0x7F9A: 'líng',  # 羚
    0x7F9B: 'yì,xī',  # 羛
    0x7F9C: 'zhù',  # 羜
    0x7F9D: 'dī',  # 羝
    0x7F9E: 'xiū',  # 羞
    0x7F9F: 'qiǎng',  # 羟
    0x7FA0: 'yí',  # 羠
    0x7FA1: 'xiàn',  # 羡
    0x7FA2: 'róng',  # 羢
    0x7FA3: 'qún',  # 羣
    0x7FA4: 'qún',  # 群
    0x7FA5: 'qiǎng',  # 羥
    0x7FA6: 'huán',  # 羦
    0x7FA7: 'suō',  # 羧
    0x7FA8: 'xiàn',  # 羨
    0x7FA9: 'yì',  # 義
    0x7FAA: 'yōu',  # 羪
    0x7FAB: 'qiāng,kòng',  # 羫
    0x7FAC: 'qián,xián,yán',  # 羬
    0x7FAD: 'yú',  # 羭
    0x7FAE: 'gēng',  # 羮
    0x7FAF: 'jié',  # 羯
    0x7FB0: 'tāng',  # 羰
    0x7FB1: 'yuán',  # 羱
    0x7FB2: 'xī',  # 羲
    0x7FB3: 'fán',  # 羳
    0x7FB4: 'shān',  # 羴
    0x7FB5: 'fén',  # 羵
    0x7FB6: 'shān',  # 羶
    0x7FB7: 'liǎn',  # 羷
    0x7FB8: 'léi',  # 羸
    0x7FB9: 'gēng',  # 羹
    0x7FBA: 'nóu',  # 羺
    0x7FBB: 'qiàng',  # 羻
    0x7FBC: 'chàn',  # 羼
    0x7FBD: 'yǔ',  # 羽
    0x7FBE: 'hóng,gòng',  # 羾
    0x7FBF: 'yì',  # 羿
    0x7FC0: 'chōng',  # 翀
    0x7FC1: 'wēng',  # 翁
    0x7FC2: 'fēn',  # 翂
    0x7FC3: 'hóng',  # 翃
    0x7FC4: 'chì',  # 翄
    0x7FC5: 'chì',  # 翅
    0x7FC6: 'cuì',  # 翆
    0x7FC7: 'fú',  # 翇
    0x7FC8: 'xiá',  # 翈
    0x7FC9: 'běn',  # 翉
    0x7FCA: 'yì',  # 翊
    0x7FCB: 'là',  # 翋
    0x7FCC: 'yì',  # 翌
    0x7FCD: 'pī,bì,pō',  # 翍
    0x7FCE: 'líng',  # 翎
    0x7FCF: 'liù',  # 翏
    0x7FD0: 'zhì',  # 翐
    0x7FD1: 'qú,yù',  # 翑
    0x7FD2: 'xí',  # 習
    0x7FD3: 'xié',  # 翓
    0x7FD4: 'xiáng',  # 翔
    0x7FD5: 'xī',  # 翕
    0x7FD6: 'xī',  # 翖
    0x7FD7: 'ké',  # 翗
    0x7FD8: 'qiáo,qiào',  # 翘
    0x7FD9: 'huì',  # 翙
    0x7FDA: 'huī',  # 翚
    0x7FDB: 'xiāo',  # 翛
    0x7FDC: 'shà',  # 翜
    0x7FDD: 'hóng',  # 翝
    0x7FDE: 'jiāng',  # 翞
    0x7FDF: 'dí,zhái',  # 翟
    0x7FE0: 'cuì',  # 翠
    0x7FE1: 'fěi',  # 翡
    0x7FE2: 'dào,zhōu',  # 翢
    0x7FE3: 'shà',  # 翣
    0x7FE4: 'chì',  # 翤
    0x7FE5: 'zhù',  # 翥
    0x7FE6: 'jiǎn',  # 翦
    0x7FE7: 'xuān',  # 翧
    0x7FE8: 'chì',  # 翨
    0x7FE9: 'piān',  # 翩
    0x7FEA: 'zōng',  # 翪
    0x7FEB: 'wán',  # 翫
    0x7FEC: 'huī',  # 翬
    0x7FED: 'hóu',  # 翭
    0x7FEE: 'hé',  # 翮
    0x7FEF: 'hè',  # 翯
    0x7FF0: 'hàn',  # 翰
    0x7FF1: 'áo',  # 翱
    0x7FF2: 'piāo',  # 翲
    0x7FF3: 'yì',  # 翳
    0x7FF4: 'lián',  # 翴
    0x7FF5: 'hóu,qú',  # 翵
    0x7FF6: 'áo',  # 翶
    0x7FF7: 'lín',  # 翷
    0x7FF8: 'pěn',  # 翸
    0x7FF9: 'qiáo,qiào',  # 翹
    0x7FFA: 'áo',  # 翺
    0x7FFB: 'fān',  # 翻
    0x7FFC: 'yì',  # 翼
    0x7FFD: 'huì',  # 翽
    0x7FFE: 'xuān',  # 翾
    0x7FFF: 'dào',  # 翿
    0x8000: 'yào',  # 耀
    0x8001: 'lǎo',  # 老
    0x8002: 'lǎo',  # 耂
    0x8003: 'kǎo',  # 考
    0x8004: 'mào',  # 耄
    0x8005: 'zhě',  # 者
    0x8006: 'qí,shì',  # 耆
    0x8007: 'gǒu',  # 耇
    0x8008: 'gǒu',  # 耈
    0x8009: 'gǒu',  # 耉
    0x800A: 'dié',  # 耊
    0x800B: 'dié',  # 耋
    0x800C: 'ér',  # 而
    0x800D: 'shuǎ',  # 耍
    0x800E: 'ruǎn,nuò',  # 耎
    0x800F: 'ér,nài',  # 耏
    0x8010: 'nài',  # 耐
    0x8011: 'duān,zhuān',  # 耑
    0x8012: 'lěi',  # 耒
    0x8013: 'tīng',  # 耓
    0x8014: 'zǐ',  # 耔
    0x8015: 'gēng',  # 耕
    0x8016: 'chào',  # 耖
    0x8017: 'hào',  # 耗
    0x8018: 'yún',  # 耘
    0x8019: 'bà,pá',  # 耙
    0x801A: 'pī',  # 耚
    0x801B: 'sì,chí',  # 耛
    0x801C: 'sì',  # 耜
    0x801D: 'qù,chú',  # 耝
    0x801E: 'jiā',  # 耞
    0x801F: 'jù',  # 耟
    0x8020: 'huō',  # 耠
    0x8021: 'chú',  # 耡
    0x8022: 'lào',  # 耢
    0x8023: 'lún,lǔn',  # 耣
    0x8024: 'jí,jiè',  # 耤
    0x8025: 'tǎng',  # 耥
    0x8026: 'ǒu',  # 耦
    0x8027: 'lóu',  # 耧
    0x8028: 'nòu',  # 耨
    0x8029: 'jiǎng',  # 耩
    0x802A: 'pǎng',  # 耪
    0x802B: 'zhá,zé',  # 耫
    0x802C: 'lóu',  # 耬
    0x802D: 'jī',  # 耭
    0x802E: 'lào',  # 耮
    0x802F: 'huò',  # 耯
    0x8030: 'yōu',  # 耰
    0x8031: 'mò',  # 耱
    0x8032: 'huái',  # 耲
    0x8033: 'ěr',  # 耳
    0x8034: 'yì',  # 耴
    0x8035: 'dīng',  # 耵
    0x8036: 'yé,yē',  # 耶
    0x8037: 'dā',  # 耷
    0x8038: 'sǒng',  # 耸
    0x8039: 'qín',  # 耹
    0x803A: 'yún,yíng',  # 耺
    0x803B: 'chǐ',  # 耻
    0x803C: 'dān',  # 耼
    0x803D: 'dān',  # 耽
    0x803E: 'hóng',  # 耾
    0x803F: 'gěng',  # 耿
    0x8040: 'zhí',  # 聀
    0x8041: 'pàn',  # 聁
    0x8042: 'niè',  # 聂
    0x8043: 'dān',  # 聃
    0x8044: 'zhěn',  # 聄
    0x8045: 'chè',  # 聅
    0x8046: 'líng',  # 聆
    0x8047: 'zhēng',  # 聇
    0x8048: 'yǒu',  # 聈
    0x8049: 'wà,tuǐ,zhuó',  # 聉
    0x804A: 'liáo',  # 聊
    0x804B: 'lóng',  # 聋
    0x804C: 'zhí',  # 职
    0x804D: 'níng',  # 聍
    0x804E: 'tiāo',  # 聎
    0x804F: 'ér,nǜ',  # 聏
    0x8050: 'yà',  # 聐
    0x8051: 'tiē,zhé',  # 聑
    0x8052: 'guō',  # 聒
    0x8053: 'xù',  # 聓
    0x8054: 'lián',  # 联
    0x8055: 'hào',  # 聕
    0x8056: 'shèng',  # 聖
    0x8057: 'liè',  # 聗
    0x8058: 'pìn',  # 聘
    0x8059: 'jīng',  # 聙
    0x805A: 'jù',  # 聚
    0x805B: 'bǐ',  # 聛
    0x805C: 'dǐ,zhì',  # 聜
    0x805D: 'guó',  # 聝
    0x805E: 'wén',  # 聞
    0x805F: 'xù',  # 聟
    0x8060: 'pīng',  # 聠
    0x8061: 'cōng',  # 聡
    0x8062: 'dìng',  # 聢
    0x8063: 'ní',  # 聣
    0x8064: 'tíng',  # 聤
    0x8065: 'jǔ',  # 聥
    0x8066: 'cōng',  # 聦
    0x8067: 'kuī',  # 聧
    0x8068: 'lián',  # 聨
    0x8069: 'kuì',  # 聩
    0x806A: 'cōng',  # 聪
    0x806B: 'lián',  # 聫
    0x806C: 'wēng',  # 聬
    0x806D: 'kuì',  # 聭
    0x806E: 'lián',  # 聮
    0x806F: 'lián',  # 聯
    0x8070: 'cōng',  # 聰
    0x8071: 'áo',  # 聱
    0x8072: 'shēng',  # 聲
    0x8073: 'sǒng',  # 聳
    0x8074: 'tīng',  # 聴
    0x8075: 'kuì',  # 聵
    0x8076: 'niè',  # 聶
    0x8077: 'zhí',  # 職
    0x8078: 'dān',  # 聸
    0x8079: 'níng',  # 聹
    0x807A: 'qié',  # 聺
    0x807B: 'nǐ,jiàn',  # 聻
    0x807C: 'tīng',  # 聼
    0x807D: 'tīng',  # 聽
    0x807E: 'lóng',  # 聾
    0x807F: 'yù',  # 聿
    0x8080: 'yù',  # 肀
    0x8081: 'zhào',  # 肁
    0x8082: 'sì',  # 肂
    0x8083: 'sù',  # 肃
    0x8084: 'yì',  # 肄
    0x8085: 'sù',  # 肅
    0x8086: 'sì',  # 肆
    0x8087: 'zhào',  # 肇
    0x8088: 'zhào',  # 肈
    0x8089: 'ròu',  # 肉
    0x808A: 'yì',  # 肊
    0x808B: 'lèi,lē',  # 肋
    0x808C: 'jī',  # 肌
    0x808D: 'qiú',  # 肍
    0x808E: 'kěn',  # 肎
    0x808F: 'cào',  # 肏
    0x8090: 'gē',  # 肐
    0x8091: 'bó,dí',  # 肑
    0x8092: 'huàn',  # 肒
    0x8093: 'huāng',  # 肓
    0x8094: 'chǐ',  # 肔
    0x8095: 'rèn',  # 肕
    0x8096: 'xiāo,xiào',  # 肖
    0x8097: 'rǔ',  # 肗
    0x8098: 'zhǒu',  # 肘
    0x8099: 'yuān',  # 肙
    0x809A: 'dù,dǔ',  # 肚
    0x809B: 'gāng',  # 肛
    0x809C: 'róng,chēn',  # 肜
    0x809D: 'gān',  # 肝
    0x809E: 'chāi',  # 肞
    0x809F: 'wò',  # 肟
    0x80A0: 'cháng',  # 肠
    0x80A1: 'gǔ',  # 股
    0x80A2: 'zhī',  # 肢
    0x80A3: 'qín,hán,hàn',  # 肣
    0x80A4: 'fū',  # 肤
    0x80A5: 'féi',  # 肥
    0x80A6: 'bān',  # 肦
    0x80A7: 'pēi',  # 肧
    0x80A8: 'pàng,pán,pàn',  # 肨
    0x80A9: 'jiān',  # 肩
    0x80AA: 'fáng',  # 肪
    0x80AB: 'zhūn,chún',  # 肫
    0x80AC: 'yóu',  # 肬
    0x80AD: 'nà',  # 肭
    0x80AE: 'āng',  # 肮
    0x80AF: 'kěn',  # 肯
    0x80B0: 'rán',  # 肰
    0x80B1: 'gōng',  # 肱
    0x80B2: 'yù',  # 育
    0x80B3: 'wěn',  # 肳
    0x80B4: 'yáo',  # 肴
    0x80B5: 'qí',  # 肵
    0x80B6: 'pí,bǐ,bì',  # 肶
    0x80B7: 'qiǎn',  # 肷
    0x80B8: 'xī',  # 肸
    0x80B9: 'xī',  # 肹
    0x80BA: 'fèi',  # 肺
    0x80BB: 'kěn',  # 肻
    0x80BC: 'jǐng',  # 肼
    0x80BD: 'tài',  # 肽
    0x80BE: 'shèn',  # 肾
    0x80BF: 'zhǒng',  # 肿
    0x80C0: 'zhàng',  # 胀
    0x80C1: 'xié',  # 胁
    0x80C2: 'shèn',  # 胂
    0x80C3: 'wèi',  # 胃
    0x80C4: 'zhòu',  # 胄
    0x80C5: 'dié',  # 胅
    0x80C6: 'dǎn',  # 胆
    0x80C7: 'fèi,bì',  # 胇
    0x80C8: 'bá',  # 胈
    0x80C9: 'bó',  # 胉
    0x80CA: 'qú',  # 胊
    0x80CB: 'tián',  # 胋
    0x80CC: 'bèi,bēi',  # 背
    0x80CD: 'guā',  # 胍
    0x80CE: 'tāi',  # 胎
    0x80CF: 'zǐ,fèi',  # 胏
    0x80D0: 'fěi,kū',  # 胐
    0x80D1: 'zhī',  # 胑
    0x80D2: 'nì',  # 胒
    0x80D3: 'píng,pēng',  # 胓
    0x80D4: 'zì',  # 胔
    0x80D5: 'fū,fú,zhǒu',  # 胕
    0x80D6: 'pàng,pán,pàn',  # 胖
    0x80D7: 'zhēn',  # 胗
    0x80D8: 'xián',  # 胘
    0x80D9: 'zuò',  # 胙
    0x80DA: 'pēi',  # 胚
    0x80DB: 'jiǎ',  # 胛
    0x80DC: 'shèng',  # 胜
    0x80DD: 'zhī',  # 胝
    0x80DE: 'bāo',  # 胞
    0x80DF: 'mǔ',  # 胟
    0x80E0: 'qū',  # 胠
    0x80E1: 'hú',  # 胡
    0x80E2: 'qià',  # 胢
    0x80E3: 'chǐ',  # 胣
    0x80E4: 'yìn',  # 胤
    0x80E5: 'xū',  # 胥
    0x80E6: 'yāng',  # 胦
    0x80E7: 'lóng',  # 胧
    0x80E8: 'dòng',  # 胨
    0x80E9: 'kǎ',  # 胩
    0x80EA: 'lú',  # 胪
    0x80EB: 'jìng',  # 胫
    0x80EC: 'nǔ',  # 胬
    0x80ED: 'yān',  # 胭
    0x80EE: 'pāng',  # 胮
    0x80EF: 'kuà',  # 胯
    0x80F0: 'yí',  # 胰
    0x80F1: 'guāng',  # 胱
    0x80F2: 'hǎi',  # 胲
    0x80F3: 'gē,gé',  # 胳
    0x80F4: 'dòng',  # 胴
    0x80F5: 'chī',  # 胵
    0x80F6: 'jiāo',  # 胶
    0x80F7: 'xiōng',  # 胷
    0x80F8: 'xiōng',  # 胸
    0x80F9: 'ér',  # 胹
    0x80FA: 'àn',  # 胺
    0x80FB: 'héng',  # 胻
    0x80FC: 'pián',  # 胼
    0x80FD: 'néng,nài',  # 能
    0x80FE: 'zì',  # 胾
    0x80FF: 'guī,kuì',  # 胿
    0x8100: 'zhēng',  # 脀
    0x8101: 'tiǎo',  # 脁
    0x8102: 'zhī',  # 脂
    0x8103: 'cuì',  # 脃
    0x8104: 'méi',  # 脄
    0x8105: 'xié',  # 脅
    0x8106: 'cuì',  # 脆
    0x8107: 'xié',  # 脇
    0x8108: 'mài',  # 脈
    0x8109: 'mài,mò',  # 脉
    0x810A: 'jǐ',  # 脊
    0x810B: 'xié',  # 脋
    0x810C: 'nín',  # 脌
    0x810D: 'kuài',  # 脍
    0x810E: 'sà',  # 脎
    0x810F: 'zàng',  # 脏
    0x8110: 'qí',  # 脐
    0x8111: 'nǎo',  # 脑
    0x8112: 'mǐ',  # 脒
    0x8113: 'nóng',  # 脓
    0x8114: 'luán',  # 脔
    0x8115: 'wàn',  # 脕
    0x8116: 'bó',  # 脖
    0x8117: 'wěn',  # 脗
    0x8118: 'wǎn',  # 脘
    0x8119: 'xiū',  # 脙
    0x811A: 'jiǎo',  # 脚
    0x811B: 'jìng',  # 脛
    0x811C: 'róu',  # 脜
    0x811D: 'hēng',  # 脝
    0x811E: 'cuǒ',  # 脞
    0x811F: 'liè',  # 脟
    0x8120: 'shān',  # 脠
    0x8121: 'tǐng',  # 脡
    0x8122: 'méi',  # 脢
    0x8123: 'chún',  # 脣
    0x8124: 'shèn',  # 脤
    0x8125: 'jiá',  # 脥
    0x8126: 'tè',  # 脦
    0x8127: 'juān',  # 脧
    0x8128: 'cù',  # 脨
    0x8129: 'xiū',  # 脩
    0x812A: 'xìn',  # 脪
    0x812B: 'tuō',  # 脫
    0x812C: 'pāo',  # 脬
    0x812D: 'chéng',  # 脭
    0x812E: 'něi',  # 脮
    0x812F: 'fǔ',  # 脯
    0x8130: 'dòu',  # 脰
    0x8131: 'tuō',  # 脱
    0x8132: 'niào',  # 脲
    0x8133: 'nǎo',  # 脳
    0x8134: 'pǐ',  # 脴
    0x8135: 'gǔ',  # 脵
    0x8136: 'luó',  # 脶
    0x8137: 'lì',  # 脷
    0x8138: 'liǎn',  # 脸
    0x8139: 'zhàng',  # 脹
    0x813A: 'cuī',  # 脺
    0x813B: 'jiē',  # 脻
    0x813C: 'liǎng',  # 脼
    0x813D: 'shuí',  # 脽
    0x813E: 'pí',  # 脾
    0x813F: 'biāo',  # 脿
    0x8140: 'lún',  # 腀
    0x8141: 'pián',  # 腁
    0x8142: 'guò',  # 腂
    0x8143: 'juàn',  # 腃
    0x8144: 'chuí',  # 腄
    0x8145: 'dàn',  # 腅
    0x8146: 'tiǎn',  # 腆
    0x8147: 'něi',  # 腇
    0x8148: 'jīng',  # 腈
    0x8149: 'nái',  # 腉
    0x814A: 'là,xī',  # 腊
    0x814B: 'yè',  # 腋
    0x814C: 'ā,yān',  # 腌
    0x814D: 'rèn',  # 腍
    0x814E: 'shèn',  # 腎
    0x814F: 'zhuì',  # 腏
    0x8150: 'fǔ',  # 腐
    0x8151: 'fǔ',  # 腑
    0x8152: 'jū',  # 腒
    0x8153: 'féi',  # 腓
    0x8154: 'qiāng',  # 腔
    0x8155: 'wàn',  # 腕
    0x8156: 'dòng',  # 腖
    0x8157: 'pí',  # 腗
    0x8158: 'guó',  # 腘
    0x8159: 'zōng',  # 腙
    0x815A: 'dìng',  # 腚
    0x815B: 'wò',  # 腛
    0x815C: 'méi',  # 腜
    0x815D: 'ruǎn',  # 腝
    0x815E: 'zhuàn',  # 腞
    0x815F: 'chì',  # 腟
    0x8160: 'còu',  # 腠
    0x8161: 'luó',  # 腡
    0x8162: 'ǒu',  # 腢
    0x8163: 'dì',  # 腣
    0x8164: 'ān',  # 腤
    0x8165: 'xīng',  # 腥
    0x8166: 'nǎo',  # 腦
    0x8167: 'shù',  # 腧
    0x8168: 'shuàn',  # 腨
    0x8169: 'nǎn',  # 腩
    0x816A: 'yùn',  # 腪
    0x816B: 'zhǒng',  # 腫
    0x816C: 'róu',  # 腬
    0x816D: 'è',  # 腭
    0x816E: 'sāi',  # 腮
    0x816F: 'tú',  # 腯
    0x8170: 'yāo',  # 腰
    0x8171: 'jiàn',  # 腱
    0x8172: 'wěi',  # 腲
    0x8173: 'jiǎo',  # 腳
    0x8174: 'yú',  # 腴
    0x8175: 'jiā',  # 腵
    0x8176: 'duàn',  # 腶
    0x8177: 'bì',  # 腷
    0x8178: 'cháng',  # 腸
    0x8179: 'fù',  # 腹
    0x817A: 'xiàn',  # 腺
    0x817B: 'nì',  # 腻
    0x817C: 'miǎn',  # 腼
    0x817D: 'wà',  # 腽
    0x817E: 'téng',  # 腾
    0x817F: 'tuǐ',  # 腿
    0x8180: 'bǎng,páng',  # 膀
    0x8181: 'qiǎn',  # 膁
    0x8182: 'lǚ',  # 膂
    0x8183: 'wà',  # 膃
    0x8184: 'shòu',  # 膄
    0x8185: 'táng',  # 膅
    0x8186: 'sù',  # 膆
    0x8187: 'zhuì',  # 膇
    0x8188: 'gé',  # 膈
    0x8189: 'yì',  # 膉
    0x818A: 'bó',  # 膊
    0x818B: 'liáo',  # 膋
    0x818C: 'jí',  # 膌
    0x818D: 'pí',  # 膍
    0x818E: 'xié',  # 膎
    0x818F: 'gāo,gào',  # 膏
    0x8190: 'lǚ',  # 膐
    0x8191: 'bìn',  # 膑
    0x8192: 'ōu',  # 膒
    0x8193: 'cháng',  # 膓
    0x8194: 'lù,biāo',  # 膔
    0x8195: 'guó',  # 膕
    0x8196: 'pāng',  # 膖
    0x8197: 'chuái',  # 膗
    0x8198: 'biāo',  # 膘
    0x8199: 'jiǎng',  # 膙
    0x819A: 'fū',  # 膚
    0x819B: 'táng',  # 膛
    0x819C: 'mó',  # 膜
    0x819D: 'xī',  # 膝
    0x819E: 'zhuān,chuán,chún,zhuǎn',  # 膞
    0x819F: 'lǜ',  # 膟
    0x81A0: 'jiāo',  # 膠
    0x81A1: 'yìng',  # 膡
    0x81A2: 'lǘ',  # 膢
    0x81A3: 'zhì',  # 膣
    0x81A4: 'xuě',  # 膤
    0x81A5: 'cūn',  # 膥
    0x81A6: 'lìn',  # 膦
    0x81A7: 'tóng',  # 膧
    0x81A8: 'péng',  # 膨
    0x81A9: 'nì',  # 膩
    0x81AA: 'chuài',  # 膪
    0x81AB: 'liáo',  # 膫
    0x81AC: 'cuì',  # 膬
    0x81AD: 'kuì',  # 膭
    0x81AE: 'xiāo',  # 膮
    0x81AF: 'tēng',  # 膯
    0x81B0: 'fán,pán',  # 膰
    0x81B1: 'zhí',  # 膱
    0x81B2: 'jiāo',  # 膲
    0x81B3: 'shàn',  # 膳
    0x81B4: 'hū,wǔ',  # 膴
    0x81B5: 'cuì',  # 膵
    0x81B6: 'rùn',  # 膶
    0x81B7: 'xiāng',  # 膷
    0x81B8: 'suǐ',  # 膸
    0x81B9: 'fèn',  # 膹
    0x81BA: 'yīng',  # 膺
    0x81BB: 'shān,dàn',  # 膻
    0x81BC: 'zhuā',  # 膼
    0x81BD: 'dǎn',  # 膽
    0x81BE: 'kuài',  # 膾
    0x81BF: 'nóng',  # 膿
    0x81C0: 'tún',  # 臀
    0x81C1: 'lián',  # 臁
    0x81C2: 'bì,bei',  # 臂
    0x81C3: 'yōng',  # 臃
    0x81C4: 'jué',  # 臄
    0x81C5: 'chù',  # 臅
    0x81C6: 'yì',  # 臆
    0x81C7: 'juǎn',  # 臇
    0x81C8: 'là,gé',  # 臈
    0x81C9: 'liǎn',  # 臉
    0x81CA: 'sāo,sào',  # 臊
    0x81CB: 'tún',  # 臋
    0x81CC: 'gǔ',  # 臌
    0x81CD: 'qí',  # 臍
    0x81CE: 'cuì',  # 臎
    0x81CF: 'bìn',  # 臏
    0x81D0: 'xūn',  # 臐
    0x81D1: 'nào',  # 臑
    0x81D2: 'wò,yuè',  # 臒
    0x81D3: 'zàng',  # 臓
    0x81D4: 'xiàn',  # 臔
    0x81D5: 'biāo',  # 臕
    0x81D6: 'xìng',  # 臖
    0x81D7: 'kuān',  # 臗
    0x81D8: 'là',  # 臘
    0x81D9: 'yān',  # 臙
    0x81DA: 'lú',  # 臚
    0x81DB: 'huò',  # 臛
    0x81DC: 'zā',  # 臜
    0x81DD: 'luǒ',  # 臝
    0x81DE: 'qú',  # 臞
    0x81DF: 'zàng',  # 臟
    0x81E0: 'luán',  # 臠
    0x81E1: 'ní,luán',  # 臡
    0x81E2: 'zā',  # 臢
    0x81E3: 'chén',  # 臣
    0x81E4: 'qiān,xián',  # 臤
    0x81E5: 'wò',  # 臥
    0x81E6: 'guàng,jiǒng',  # 臦
    0x81E7: 'zāng,zàng,cáng',  # 臧
    0x81E8: 'lín',  # 臨
    0x81E9: 'guǎng,jiǒng',  # 臩
    0x81EA: 'zì',  # 自
    0x81EB: 'jiǎo',  # 臫
    0x81EC: 'niè',  # 臬
    0x81ED: 'chòu,xiù',  # 臭
    0x81EE: 'jì',  # 臮
    0x81EF: 'gāo',  # 臯
    0x81F0: 'chòu',  # 臰
    0x81F1: 'mián,biān',  # 臱
    0x81F2: 'niè',  # 臲
    0x81F3: 'zhì',  # 至
    0x81F4: 'zhì',  # 致
    0x81F5: 'gé',  # 臵
    0x81F6: 'jiàn',  # 臶
    0x81F7: 'dié,zhí',  # 臷
    0x81F8: 'zhī,jìn',  # 臸
    0x81F9: 'xiū',  # 臹
    0x81FA: 'tái',  # 臺
    0x81FB: 'zhēn',  # 臻
    0x81FC: 'jiù',  # 臼
    0x81FD: 'xiàn',  # 臽
    0x81FE: 'yú',  # 臾
    0x81FF: 'chā',  # 臿
    0x8200: 'yǎo',  # 舀
    0x8201: 'yú',  # 舁
    0x8202: 'chōng',  # 舂
    0x8203: 'xì',  # 舃
    0x8204: 'xì',  # 舄
    0x8205: 'jiù',  # 舅
    0x8206: 'yú',  # 舆
    0x8207: 'yǔ',  # 與
    0x8208: 'xīng',  # 興
    0x8209: 'jǔ',  # 舉
    0x820A: 'jiù',  # 舊
    0x820B: 'xìn',  # 舋
    0x820C: 'shé',  # 舌
    0x820D: 'shě,shè',  # 舍
    0x820E: 'shè',  # 舎
    0x820F: 'jiǔ',  # 舏
    0x8210: 'shì',  # 舐
    0x8211: 'tān',  # 舑
    0x8212: 'shū',  # 舒
    0x8213: 'shì',  # 舓
    0x8214: 'tiǎn',  # 舔
    0x8215: 'tàn',  # 舕
    0x8216: 'pù',  # 舖
    0x8217: 'pù',  # 舗
    0x8218: 'guǎn',  # 舘
    0x8219: 'huà',  # 舙
    0x821A: 'tiàn',  # 舚
    0x821B: 'chuǎn',  # 舛
    0x821C: 'shùn',  # 舜
    0x821D: 'xiá',  # 舝
    0x821E: 'wǔ',  # 舞
    0x821F: 'zhōu',  # 舟
    0x8220: 'dāo',  # 舠
    0x8221: 'chuán',  # 舡
    0x8222: 'shān',  # 舢
    0x8223: 'yǐ',  # 舣
    0x8224: 'fán',  # 舤
    0x8225: 'pā',  # 舥
    0x8226: 'tài',  # 舦
    0x8227: 'fán',  # 舧
    0x8228: 'bǎn',  # 舨
    0x8229: 'chuán',  # 舩
    0x822A: 'háng',  # 航
    0x822B: 'fǎng',  # 舫
    0x822C: 'bān',  # 般
    0x822D: 'bǐ',  # 舭
    0x822E: 'lú',  # 舮
    0x822F: 'zhōng',  # 舯
    0x8230: 'jiàn',  # 舰
    0x8231: 'cāng',  # 舱
    0x8232: 'líng',  # 舲
    0x8233: 'zhú',  # 舳
    0x8234: 'zé',  # 舴
    0x8235: 'duò',  # 舵
    0x8236: 'bó',  # 舶
    0x8237: 'xián',  # 舷
    0x8238: 'gě',  # 舸
    0x8239: 'chuán',  # 船
    0x823A: 'xiá',  # 舺
    0x823B: 'lú',  # 舻
    0x823C: 'qióng',  # 舼
    0x823D: 'páng',  # 舽
    0x823E: 'xī',  # 舾
    0x823F: 'kuā',  # 舿
    0x8240: 'fú',  # 艀
    0x8241: 'zào',  # 艁
    0x8242: 'féng',  # 艂
    0x8243: 'lí',  # 艃
    0x8244: 'shāo',  # 艄
    0x8245: 'yú',  # 艅
    0x8246: 'láng',  # 艆
    0x8247: 'tǐng',  # 艇
    0x8248: 'yù',  # 艈
    0x8249: 'wěi',  # 艉
    0x824A: 'bó',  # 艊
    0x824B: 'měng',  # 艋
    0x824C: 'niàn',  # 艌
    0x824D: 'jū',  # 艍
    0x824E: 'huáng',  # 艎
    0x824F: 'shǒu',  # 艏
    0x8250: 'kè',  # 艐
    0x8251: 'biàn',  # 艑
    0x8252: 'mù',  # 艒
    0x8253: 'dié',  # 艓
    0x8254: 'dào',  # 艔
    0x8255: 'bàng',  # 艕
    0x8256: 'chā',  # 艖
    0x8257: 'yì',  # 艗
    0x8258: 'sōu',  # 艘
    0x8259: 'cāng',  # 艙
    0x825A: 'cáo',  # 艚
    0x825B: 'lóu',  # 艛
    0x825C: 'dài',  # 艜
    0x825D: 'xuě',  # 艝
    0x825E: 'yào',  # 艞
    0x825F: 'chōng',  # 艟
    0x8260: 'dēng',  # 艠
    0x8261: 'dāng',  # 艡
    0x8262: 'qiáng',  # 艢
    0x8263: 'lǔ',  # 艣
    0x8264: 'yǐ',  # 艤
    0x8265: 'jí',  # 艥
    0x8266: 'jiàn',  # 艦
    0x8267: 'huò',  # 艧
    0x8268: 'méng',  # 艨
    0x8269: 'qí',  # 艩
    0x826A: 'lǔ',  # 艪
    0x826B: 'lú',  # 艫
    0x826C: 'chán',  # 艬
    0x826D: 'shuāng',  # 艭
    0x826E: 'gèn',  # 艮
    0x826F: 'liáng',  # 良
    0x8270: 'jiān',  # 艰
    0x8271: 'jiān',  # 艱
    0x8272: 'sè',  # 色
    0x8273: 'yàn',  # 艳
    0x8274: 'fú',  # 艴
    0x8275: 'pīng',  # 艵
    0x8276: 'yàn',  # 艶
    0x8277: 'yàn',  # 艷
    0x8278: 'cǎo',  # 艸
    0x8279: 'ǎo',  # 艹
    0x827A: 'yì',  # 艺
    0x827B: 'lè',  # 艻
    0x827C: 'dǐng',  # 艼
    0x827D: 'jiāo,qiú',  # 艽
    0x827E: 'ài,yì',  # 艾
    0x827F: 'nǎi',  # 艿
    0x8280: 'tiáo',  # 芀
    0x8281: 'qiú',  # 芁
    0x8282: 'jié,jiē',  # 节
    0x8283: 'péng',  # 芃
    0x8284: 'wán',  # 芄
    0x8285: 'yì',  # 芅
    0x8286: 'chāi,chā',  # 芆
    0x8287: 'mián',  # 芇
    0x8288: 'mǐ',  # 芈
    0x8289: 'gǎn',  # 芉
    0x828A: 'qiān',  # 芊
    0x828B: 'yù',  # 芋
    0x828C: 'yù',  # 芌
    0x828D: 'sháo',  # 芍
    0x828E: 'xiōng',  # 芎
    0x828F: 'dù',  # 芏
    0x8290: 'hù,xià',  # 芐
    0x8291: 'qǐ',  # 芑
    0x8292: 'máng',  # 芒
    0x8293: 'zì,zǐ',  # 芓
    0x8294: 'huì,hū',  # 芔
    0x8295: 'suī',  # 芕
    0x8296: 'zhì',  # 芖
    0x8297: 'xiāng',  # 芗
    0x8298: 'bì,pí',  # 芘
    0x8299: 'fú',  # 芙
    0x829A: 'tún,chūn',  # 芚
    0x829B: 'wěi',  # 芛
    0x829C: 'wú',  # 芜
    0x829D: 'zhī',  # 芝
    0x829E: 'qì',  # 芞
    0x829F: 'shān',  # 芟
    0x82A0: 'wén',  # 芠
    0x82A1: 'qiàn',  # 芡
    0x82A2: 'rén',  # 芢
    0x82A3: 'fú',  # 芣
    0x82A4: 'kōu',  # 芤
    0x82A5: 'jiè,gài',  # 芥
    0x82A6: 'lú',  # 芦
    0x82A7: 'xù,zhù',  # 芧
    0x82A8: 'jī',  # 芨
    0x82A9: 'qín',  # 芩
    0x82AA: 'qí',  # 芪
    0x82AB: 'yuán,yán',  # 芫
    0x82AC: 'fēn',  # 芬
    0x82AD: 'bā',  # 芭
    0x82AE: 'ruì',  # 芮
    0x82AF: 'xīn,xìn',  # 芯
    0x82B0: 'jì',  # 芰
    0x82B1: 'huā',  # 花
    0x82B2: 'lún,huā',  # 芲
    0x82B3: 'fāng',  # 芳
    0x82B4: 'wù,hū',  # 芴
    0x82B5: 'jué',  # 芵
    0x82B6: 'gōu,gǒu',  # 芶
    0x82B7: 'zhǐ',  # 芷
    0x82B8: 'yún',  # 芸
    0x82B9: 'qín',  # 芹
    0x82BA: 'ǎo',  # 芺
    0x82BB: 'chú',  # 芻
    0x82BC: 'máo,mào',  # 芼
    0x82BD: 'yá',  # 芽
    0x82BE: 'fèi,fú',  # 芾
    0x82BF: 'réng',  # 芿
    0x82C0: 'háng',  # 苀
    0x82C1: 'cōng',  # 苁
    0x82C2: 'chán,yín',  # 苂
    0x82C3: 'yǒu',  # 苃
    0x82C4: 'biàn',  # 苄
    0x82C5: 'yì',  # 苅
    0x82C6: 'qiē',  # 苆
    0x82C7: 'wěi',  # 苇
    0x82C8: 'lì',  # 苈
    0x82C9: 'pǐ',  # 苉
    0x82CA: 'è',  # 苊
    0x82CB: 'xiàn',  # 苋
    0x82CC: 'cháng',  # 苌
    0x82CD: 'cāng',  # 苍
    0x82CE: 'zhù',  # 苎
    0x82CF: 'sū,sù',  # 苏
    0x82D0: 'dì,tí',  # 苐
    0x82D1: 'yuàn',  # 苑
    0x82D2: 'rǎn',  # 苒
    0x82D3: 'líng',  # 苓
    0x82D4: 'tái,tāi',  # 苔
    0x82D5: 'tiáo,sháo',  # 苕
    0x82D6: 'dí',  # 苖
    0x82D7: 'miáo',  # 苗
    0x82D8: 'qǐng',  # 苘
    0x82D9: 'lì,jī',  # 苙
    0x82DA: 'yòng',  # 苚
    0x82DB: 'kē,hē',  # 苛
    0x82DC: 'mù',  # 苜
    0x82DD: 'bèi',  # 苝
    0x82DE: 'bāo',  # 苞
    0x82DF: 'gǒu',  # 苟
    0x82E0: 'mín',  # 苠
    0x82E1: 'yǐ',  # 苡
    0x82E2: 'yǐ',  # 苢
    0x82E3: 'jù,qǔ',  # 苣
    0x82E4: 'piě',  # 苤
    0x82E5: 'ruò,rě',  # 若
    0x82E6: 'kǔ',  # 苦
    0x82E7: 'zhù,níng',  # 苧
    0x82E8: 'nǐ',  # 苨
    0x82E9: 'pā,bó',  # 苩
    0x82EA: 'bǐng',  # 苪
    0x82EB: 'shān,shàn',  # 苫
    0x82EC: 'xiú',  # 苬
    0x82ED: 'yǎo',  # 苭
    0x82EE: 'xiān',  # 苮
    0x82EF: 'běn',  # 苯
    0x82F0: 'hóng',  # 苰
    0x82F1: 'yīng',  # 英
    0x82F2: 'zuó,zhǎ',  # 苲
    0x82F3: 'dōng',  # 苳
    0x82F4: 'jū,chá',  # 苴
    0x82F5: 'dié',  # 苵
    0x82F6: 'nié',  # 苶
    0x82F7: 'gān',  # 苷
    0x82F8: 'hū',  # 苸
    0x82F9: 'píng,pēng',  # 苹
    0x82FA: 'méi',  # 苺
    0x82FB: 'fú',  # 苻
    0x82FC: 'shēng,ruí',  # 苼
    0x82FD: 'gū',  # 苽
    0x82FE: 'bì',  # 苾
    0x82FF: 'wèi',  # 苿
    0x8300: 'fú',  # 茀
    0x8301: 'zhuó',  # 茁
    0x8302: 'mào',  # 茂
    0x8303: 'fàn',  # 范
    0x8304: 'qié',  # 茄
    0x8305: 'máo',  # 茅
    0x8306: 'máo',  # 茆
    0x8307: 'bá',  # 茇
    0x8308: 'zǐ',  # 茈
    0x8309: 'mò',  # 茉
    0x830A: 'zī',  # 茊
    0x830B: 'zhǐ',  # 茋
    0x830C: 'chí',  # 茌
    0x830D: 'jì',  # 茍
    0x830E: 'jīng',  # 茎
    0x830F: 'lóng',  # 茏
    0x8310: 'cōng',  # 茐
    0x8311: 'niǎo',  # 茑
    0x8312: 'yuán',  # 茒
    0x8313: 'xué',  # 茓
    0x8314: 'yíng',  # 茔
    0x8315: 'qióng',  # 茕
    0x8316: 'gè',  # 茖
    0x8317: 'míng',  # 茗
    0x8318: 'lì',  # 茘
    0x8319: 'róng',  # 茙
    0x831A: 'yìn',  # 茚
    0x831B: 'gèn',  # 茛
    0x831C: 'qiàn',  # 茜
    0x831D: 'chǎi',  # 茝
    0x831E: 'chén',  # 茞
    0x831F: 'yù',  # 茟
    0x8320: 'hāo',  # 茠
    0x8321: 'zì',  # 茡
    0x8322: 'liè',  # 茢
    0x8323: 'wú',  # 茣
    0x8324: 'jì',  # 茤
    0x8325: 'guī',  # 茥
    0x8326: 'cì',  # 茦
    0x8327: 'jiǎn',  # 茧
    0x8328: 'cí',  # 茨
    0x8329: 'hòu',  # 茩
    0x832A: 'guāng',  # 茪
    0x832B: 'máng',  # 茫
    0x832C: 'chá',  # 茬
    0x832D: 'jiāo',  # 茭
    0x832E: 'jiāo',  # 茮
    0x832F: 'fú',  # 茯
    0x8330: 'yú',  # 茰
    0x8331: 'zhū',  # 茱
    0x8332: 'zī',  # 茲
    0x8333: 'jiāng',  # 茳
    0x8334: 'huí',  # 茴
    0x8335: 'yīn',  # 茵
    0x8336: 'chá',  # 茶
    0x8337: 'fá',  # 茷
    0x8338: 'róng',  # 茸
    0x8339: 'rú',  # 茹
    0x833A: 'chōng',  # 茺
    0x833B: 'mǎng',  # 茻
    0x833C: 'tóng',  # 茼
    0x833D: 'zhòng',  # 茽
    0x833E: 'qiān',  # 茾
    0x833F: 'zhú',  # 茿
    0x8340: 'xún',  # 荀
    0x8341: 'huán',  # 荁
    0x8342: 'fū',  # 荂
    0x8343: 'quán',  # 荃
    0x8344: 'gāi',  # 荄
    0x8345: 'dá',  # 荅
    0x8346: 'jīng',  # 荆
    0x8347: 'xìng',  # 荇
    0x8348: 'chuǎn',  # 荈
    0x8349: 'cǎo',  # 草
    0x834A: 'jīng',  # 荊
    0x834B: 'ér',  # 荋
    0x834C: 'àn',  # 荌
    0x834D: 'qiáo',  # 荍
    0x834E: 'chí',  # 荎
    0x834F: 'rěn',  # 荏
    0x8350: 'jiàn',  # 荐
    0x8351: 'yí,tí',  # 荑
    0x8352: 'huāng',  # 荒
    0x8353: 'píng',  # 荓
    0x8354: 'lì',  # 荔
    0x8355: 'jīn',  # 荕
    0x8356: 'lǎo',  # 荖
    0x8357: 'shù',  # 荗
    0x8358: 'zhuāng',  # 荘
    0x8359: 'dá',  # 荙
    0x835A: 'jiá',  # 荚
    0x835B: 'ráo',  # 荛
    0x835C: 'bì',  # 荜
    0x835D: 'cè',  # 荝
    0x835E: 'qiáo',  # 荞
    0x835F: 'huì',  # 荟
    0x8360: 'jì,qí',  # 荠
    0x8361: 'dàng',  # 荡
    0x8362: 'zì',  # 荢
    0x8363: 'róng',  # 荣
    0x8364: 'hūn',  # 荤
    0x8365: 'xíng,yīng',  # 荥
    0x8366: 'luò',  # 荦
    0x8367: 'yíng',  # 荧
    0x8368: 'qián,xún',  # 荨
    0x8369: 'jìn',  # 荩
    0x836A: 'sūn',  # 荪
    0x836B: 'yīn,yìn',  # 荫
    0x836C: 'mǎi',  # 荬
    0x836D: 'hóng',  # 荭
    0x836E: 'zhòu',  # 荮
    0x836F: 'yào',  # 药
    0x8370: 'dù',  # 荰
    0x8371: 'wěi',  # 荱
    0x8372: 'lí',  # 荲
    0x8373: 'dòu',  # 荳
    0x8374: 'fū',  # 荴
    0x8375: 'rěn',  # 荵
    0x8376: 'yín',  # 荶
    0x8377: 'hé',  # 荷
    0x8378: 'bí',  # 荸
    0x8379: 'bù',  # 荹
    0x837A: 'yǔn',  # 荺
    0x837B: 'dí',  # 荻
    0x837C: 'tú',  # 荼
    0x837D: 'suī',  # 荽
    0x837E: 'suī',  # 荾
    0x837F: 'chéng',  # 荿
    0x8380: 'chén',  # 莀
    0x8381: 'wú',  # 莁
    0x8382: 'bié',  # 莂
    0x8383: 'xī',  # 莃
    0x8384: 'gěng',  # 莄
    0x8385: 'lì',  # 莅
    0x8386: 'pú',  # 莆
    0x8387: 'zhù',  # 莇
    0x8388: 'mò',  # 莈
    0x8389: 'lì',  # 莉
    0x838A: 'zhuāng',  # 莊
    0x838B: 'zuó',  # 莋
    0x838C: 'tuō',  # 莌
    0x838D: 'qiú',  # 莍
    0x838E: 'suō,shā',  # 莎
    0x838F: 'suō',  # 莏
    0x8390: 'chén',  # 莐
    0x8391: 'péng,fēng',  # 莑
    0x8392: 'jǔ',  # 莒
    0x8393: 'méi',  # 莓
    0x8394: 'méng',  # 莔
    0x8395: 'xìng',  # 莕
    0x8396: 'jìng',  # 莖
    0x8397: 'chē',  # 莗
    0x8398: 'shēn,xīn',  # 莘
    0x8399: 'jūn',  # 莙
    0x839A: 'yán',  # 莚
    0x839B: 'tíng',  # 莛
    0x839C: 'yóu',  # 莜
    0x839D: 'cuò',  # 莝
    0x839E: 'guān,guǎn,wǎn',  # 莞
    0x839F: 'hàn',  # 莟
    0x83A0: 'yǒu',  # 莠
    0x83A1: 'cuò',  # 莡
    0x83A2: 'jiá',  # 莢
    0x83A3: 'wáng',  # 莣
    0x83A4: 'sù,yóu',  # 莤
    0x83A5: 'niǔ',  # 莥
    0x83A6: 'shāo,xiāo',  # 莦
    0x83A7: 'xiàn',  # 莧
    0x83A8: 'làng,liáng',  # 莨
    0x83A9: 'fú,piǎo',  # 莩
    0x83AA: 'é',  # 莪
    0x83AB: 'mò,mù',  # 莫
    0x83AC: 'wèn,wǎn,miǎn',  # 莬
    0x83AD: 'jié',  # 莭
    0x83AE: 'nán',  # 莮
    0x83AF: 'mù',  # 莯
    0x83B0: 'kǎn',  # 莰
    0x83B1: 'lái',  # 莱
    0x83B2: 'lián',  # 莲
    0x83B3: 'shì,shí',  # 莳
    0x83B4: 'wō',  # 莴
    0x83B5: 'tù,tú',  # 莵
    0x83B6: 'xiān,liǎn',  # 莶
    0x83B7: 'huò',  # 获
    0x83B8: 'yóu',  # 莸
    0x83B9: 'yíng',  # 莹
    0x83BA: 'yīng',  # 莺
    0x83BB: 'neus',  # 莻
    0x83BC: 'chún',  # 莼
    0x83BD: 'mǎng',  # 莽
    0x83BE: 'mǎng',  # 莾
    0x83BF: 'cì',  # 莿
    0x83C0: 'wǎn,yùn',  # 菀
    0x83C1: 'jīng',  # 菁
    0x83C2: 'dì',  # 菂
    0x83C3: 'qú',  # 菃
    0x83C4: 'dōng',  # 菄
    0x83C5: 'jiān',  # 菅
    0x83C6: 'zōu,chù',  # 菆
    0x83C7: 'gū',  # 菇
    0x83C8: 'lā',  # 菈
    0x83C9: 'lù',  # 菉
    0x83CA: 'jú',  # 菊
    0x83CB: 'wèi',  # 菋
    0x83CC: 'jūn,jùn',  # 菌
    0x83CD: 'niè,rěn',  # 菍
    0x83CE: 'kūn',  # 菎
    0x83CF: 'hé',  # 菏
    0x83D0: 'pú',  # 菐
    0x83D1: 'zī,zì,zāi',  # 菑
    0x83D2: 'gǎo',  # 菒
    0x83D3: 'guǒ',  # 菓
    0x83D4: 'fú',  # 菔
    0x83D5: 'lún',  # 菕
    0x83D6: 'chāng',  # 菖
    0x83D7: 'chóu',  # 菗
    0x83D8: 'sōng',  # 菘
    0x83D9: 'chuí',  # 菙
    0x83DA: 'zhàn',  # 菚
    0x83DB: 'mén',  # 菛
    0x83DC: 'cài',  # 菜
    0x83DD: 'bá',  # 菝
    0x83DE: 'lí',  # 菞
    0x83DF: 'tù,tú',  # 菟
    0x83E0: 'bō',  # 菠
    0x83E1: 'hàn',  # 菡
    0x83E2: 'bào',  # 菢
    0x83E3: 'qìn',  # 菣
    0x83E4: 'juǎn',  # 菤
    0x83E5: 'xī',  # 菥
    0x83E6: 'qín',  # 菦
    0x83E7: 'dǐ',  # 菧
    0x83E8: 'jiē,shà',  # 菨
    0x83E9: 'pú',  # 菩
    0x83EA: 'dàng',  # 菪
    0x83EB: 'jǐn',  # 菫
    0x83EC: 'qiáo,zhǎo',  # 菬
    0x83ED: 'tái,zhī,chí',  # 菭
    0x83EE: 'gēng',  # 菮
    0x83EF: 'huá,huà,huā',  # 華
    0x83F0: 'gū',  # 菰
    0x83F1: 'líng',  # 菱
    0x83F2: 'fēi,fěi',  # 菲
    0x83F3: 'qín,qīn,jīn',  # 菳
    0x83F4: 'ān',  # 菴
    0x83F5: 'wǎng',  # 菵
    0x83F6: 'běng',  # 菶
    0x83F7: 'zhǒu',  # 菷
    0x83F8: 'yān',  # 菸
    0x83F9: 'zū',  # 菹
    0x83FA: 'jiān',  # 菺
    0x83FB: 'lǐn,má',  # 菻
    0x83FC: 'tǎn',  # 菼
    0x83FD: 'shū',  # 菽
    0x83FE: 'tián,tiàn',  # 菾
    0x83FF: 'dào',  # 菿
    0x8400: 'hǔ',  # 萀
    0x8401: 'qí',  # 萁
    0x8402: 'hé',  # 萂
    0x8403: 'cuì',  # 萃
    0x8404: 'táo',  # 萄
    0x8405: 'chūn',  # 萅
    0x8406: 'bì',  # 萆
    0x8407: 'cháng',  # 萇
    0x8408: 'huán',  # 萈
    0x8409: 'fèi',  # 萉
    0x840A: 'lái',  # 萊
    0x840B: 'qī',  # 萋
    0x840C: 'méng',  # 萌
    0x840D: 'píng',  # 萍
    0x840E: 'wěi',  # 萎
    0x840F: 'dàn',  # 萏
    0x8410: 'shà',  # 萐
    0x8411: 'huán',  # 萑
    0x8412: 'yǎn',  # 萒
    0x8413: 'yí',  # 萓
    0x8414: 'tiáo',  # 萔
    0x8415: 'qí',  # 萕
    0x8416: 'wǎn',  # 萖
    0x8417: 'cè',  # 萗
    0x8418: 'nài',  # 萘
    0x8419: 'zhěn',  # 萙
    0x841A: 'tuò',  # 萚
    0x841B: 'jiū',  # 萛
    0x841C: 'tiē',  # 萜
    0x841D: 'luó',  # 萝
    0x841E: 'bì',  # 萞
    0x841F: 'yì',  # 萟
    0x8420: 'pān',  # 萠
    0x8421: 'bó',  # 萡
    0x8422: 'pāo',  # 萢
    0x8423: 'dìng',  # 萣
    0x8424: 'yíng',  # 萤
    0x8425: 'yíng',  # 营
    0x8426: 'yíng',  # 萦
    0x8427: 'xiāo',  # 萧
    0x8428: 'sà',  # 萨
    0x8429: 'qiū',  # 萩
    0x842A: 'kē',  # 萪
    0x842B: 'xiāng',  # 萫
    0x842C: 'wàn',  # 萬
    0x842D: 'yǔ',  # 萭
    0x842E: 'yú',  # 萮
    0x842F: 'fù',  # 萯
    0x8430: 'liàn',  # 萰
    0x8431: 'xuān',  # 萱
    0x8432: 'xuān',  # 萲
    0x8433: 'nǎn',  # 萳
    0x8434: 'cè',  # 萴
    0x8435: 'wō',  # 萵
    0x8436: 'chǔn',  # 萶
    0x8437: 'shāo',  # 萷
    0x8438: 'yú',  # 萸
    0x8439: 'biān',  # 萹
    0x843A: 'mào',  # 萺
    0x843B: 'ān',  # 萻
    0x843C: 'è',  # 萼
    0x843D: 'là,luò,lào',  # 落
    0x843E: 'yíng',  # 萾
    0x843F: 'kuò',  # 萿
    0x8440: 'kuò',  # 葀
    0x8441: 'jiāng',  # 葁
    0x8442: 'miǎn',  # 葂
    0x8443: 'zuò',  # 葃
    0x8444: 'zuò',  # 葄
    0x8445: 'zū',  # 葅
    0x8446: 'bǎo',  # 葆
    0x8447: 'róu',  # 葇
    0x8448: 'xǐ',  # 葈
    0x8449: 'yè',  # 葉
    0x844A: 'ān',  # 葊
    0x844B: 'qú',  # 葋
    0x844C: 'jiān',  # 葌
    0x844D: 'fú',  # 葍
    0x844E: 'lǜ',  # 葎
    0x844F: 'jīng',  # 葏
    0x8450: 'pén',  # 葐
    0x8451: 'fēng',  # 葑
    0x8452: 'hóng',  # 葒
    0x8453: 'hóng',  # 葓
    0x8454: 'hóu',  # 葔
    0x8455: 'xìng',  # 葕
    0x8456: 'tū',  # 葖
    0x8457: 'zhù,zhuó,zhe',  # 著
    0x8458: 'zī',  # 葘
    0x8459: 'xiāng',  # 葙
    0x845A: 'shèn',  # 葚
    0x845B: 'gé,gě',  # 葛
    0x845C: 'qiā',  # 葜
    0x845D: 'qíng',  # 葝
    0x845E: 'mǐ',  # 葞
    0x845F: 'huáng',  # 葟
    0x8460: 'shēn',  # 葠
    0x8461: 'pú',  # 葡
    0x8462: 'gài',  # 葢
    0x8463: 'dǒng',  # 董
    0x8464: 'zhòu',  # 葤
    0x8465: 'qián',  # 葥
    0x8466: 'wěi',  # 葦
    0x8467: 'bó',  # 葧
    0x8468: 'wēi',  # 葨
    0x8469: 'pā',  # 葩
    0x846A: 'jì',  # 葪
    0x846B: 'hú',  # 葫
    0x846C: 'zàng',  # 葬
    0x846D: 'jiā',  # 葭
    0x846E: 'duàn',  # 葮
    0x846F: 'yào',  # 葯
    0x8470: 'jùn',  # 葰
    0x8471: 'cōng',  # 葱
    0x8472: 'quán',  # 葲
    0x8473: 'wēi',  # 葳
    0x8474: 'zhēn',  # 葴
    0x8475: 'kuí',  # 葵
    0x8476: 'tíng',  # 葶
    0x8477: 'hūn',  # 葷
    0x8478: 'xǐ',  # 葸
    0x8479: 'shī',  # 葹
    0x847A: 'qì',  # 葺
    0x847B: 'lán',  # 葻
    0x847C: 'zōng',  # 葼
    0x847D: 'yāo',  # 葽
    0x847E: 'yuān',  # 葾
    0x847F: 'méi',  # 葿
    0x8480: 'yūn',  # 蒀
    0x8481: 'shù',  # 蒁
    0x8482: 'dì',  # 蒂
    0x8483: 'zhuàn',  # 蒃
    0x8484: 'guān',  # 蒄
    0x8485: 'rǎn',  # 蒅
    0x8486: 'xuē',  # 蒆
    0x8487: 'chǎn',  # 蒇
    0x8488: 'kǎi',  # 蒈
    0x8489: 'kuì,kuài',  # 蒉
    0x848A: 'huā',  # 蒊
    0x848B: 'jiǎng',  # 蒋
    0x848C: 'lóu',  # 蒌
    0x848D: 'wěi',  # 蒍
    0x848E: 'pài',  # 蒎
    0x848F: 'yòng',  # 蒏
    0x8490: 'sōu',  # 蒐
    0x8491: 'yīn',  # 蒑
    0x8492: 'shī',  # 蒒
    0x8493: 'chún',  # 蒓
    0x8494: 'shì,shí',  # 蒔
    0x8495: 'yūn',  # 蒕
    0x8496: 'zhēn',  # 蒖
    0x8497: 'làng',  # 蒗
    0x8498: 'rú,ná',  # 蒘
    0x8499: 'mēng,méng,měng',  # 蒙
    0x849A: 'lì',  # 蒚
    0x849B: 'quē',  # 蒛
    0x849C: 'suàn',  # 蒜
    0x849D: 'yuán,huán',  # 蒝
    0x849E: 'lì',  # 蒞
    0x849F: 'jǔ',  # 蒟
    0x84A0: 'xī',  # 蒠
    0x84A1: 'bàng',  # 蒡
    0x84A2: 'chú',  # 蒢
    0x84A3: 'xú,shú',  # 蒣
    0x84A4: 'tú',  # 蒤
    0x84A5: 'liú',  # 蒥
    0x84A6: 'huò',  # 蒦
    0x84A7: 'diǎn',  # 蒧
    0x84A8: 'qiàn',  # 蒨
    0x84A9: 'zū,jù',  # 蒩
    0x84AA: 'pò',  # 蒪
    0x84AB: 'cuó',  # 蒫
    0x84AC: 'yuān',  # 蒬
    0x84AD: 'chú',  # 蒭
    0x84AE: 'yù',  # 蒮
    0x84AF: 'kuǎi',  # 蒯
    0x84B0: 'pán',  # 蒰
    0x84B1: 'pú',  # 蒱
    0x84B2: 'pú',  # 蒲
    0x84B3: 'nà',  # 蒳
    0x84B4: 'shuò',  # 蒴
    0x84B5: 'xí,xì',  # 蒵
    0x84B6: 'fén',  # 蒶
    0x84B7: 'yún',  # 蒷
    0x84B8: 'zhēng',  # 蒸
    0x84B9: 'jiān',  # 蒹
    0x84BA: 'jí',  # 蒺
    0x84BB: 'ruò',  # 蒻
    0x84BC: 'cāng',  # 蒼
    0x84BD: 'ēn',  # 蒽
    0x84BE: 'mí',  # 蒾
    0x84BF: 'hāo',  # 蒿
    0x84C0: 'sūn',  # 蓀
    0x84C1: 'zhēn',  # 蓁
    0x84C2: 'míng',  # 蓂
    0x84C3: 'sōu,sǒu',  # 蓃
    0x84C4: 'xù',  # 蓄
    0x84C5: 'liú',  # 蓅
    0x84C6: 'xí',  # 蓆
    0x84C7: 'gū',  # 蓇
    0x84C8: 'láng',  # 蓈
    0x84C9: 'róng',  # 蓉
    0x84CA: 'wěng',  # 蓊
    0x84CB: 'gài,gě,hé',  # 蓋
    0x84CC: 'cuò',  # 蓌
    0x84CD: 'shī',  # 蓍
    0x84CE: 'táng',  # 蓎
    0x84CF: 'luǒ',  # 蓏
    0x84D0: 'rù',  # 蓐
    0x84D1: 'suō',  # 蓑
    0x84D2: 'xuān',  # 蓒
    0x84D3: 'bèi',  # 蓓
    0x84D4: 'yǎo,zhuó',  # 蓔
    0x84D5: 'guì',  # 蓕
    0x84D6: 'bì',  # 蓖
    0x84D7: 'zǒng',  # 蓗
    0x84D8: 'gǔn',  # 蓘
    0x84D9: 'zuò',  # 蓙
    0x84DA: 'tiáo',  # 蓚
    0x84DB: 'cè',  # 蓛
    0x84DC: 'pèi',  # 蓜
    0x84DD: 'lán',  # 蓝
    0x84DE: 'dàn',  # 蓞
    0x84DF: 'jì',  # 蓟
    0x84E0: 'lí',  # 蓠
    0x84E1: 'shēn',  # 蓡
    0x84E2: 'lǎng',  # 蓢
    0x84E3: 'yù',  # 蓣
    0x84E4: 'líng',  # 蓤
    0x84E5: 'yíng',  # 蓥
    0x84E6: 'mò',  # 蓦
    0x84E7: 'diào,tiáo,dí',  # 蓧
    0x84E8: 'tiáo',  # 蓨
    0x84E9: 'mǎo',  # 蓩
    0x84EA: 'tōng',  # 蓪
    0x84EB: 'zhú',  # 蓫
    0x84EC: 'péng',  # 蓬
    0x84ED: 'ān',  # 蓭
    0x84EE: 'lián',  # 蓮
    0x84EF: 'cōng',  # 蓯
    0x84F0: 'xǐ',  # 蓰
    0x84F1: 'píng',  # 蓱
    0x84F2: 'qiū,xū,fū',  # 蓲
    0x84F3: 'jǐn',  # 蓳
    0x84F4: 'chún',  # 蓴
    0x84F5: 'jié',  # 蓵
    0x84F6: 'wéi',  # 蓶
    0x84F7: 'tuī',  # 蓷
    0x84F8: 'cáo',  # 蓸
    0x84F9: 'yù',  # 蓹
    0x84FA: 'yì',  # 蓺
    0x84FB: 'zí,jú',  # 蓻
    0x84FC: 'liǎo,lù',  # 蓼
    0x84FD: 'bì',  # 蓽
    0x84FE: 'lǔ',  # 蓾
    0x84FF: 'xù',  # 蓿
    0x8500: 'bù',  # 蔀
    0x8501: 'zhāng',  # 蔁
    0x8502: 'léi',  # 蔂
    0x8503: 'qiáng',  # 蔃
    0x8504: 'màn',  # 蔄
    0x8505: 'yán',  # 蔅
    0x8506: 'líng',  # 蔆
    0x8507: 'jì',  # 蔇
    0x8508: 'biāo',  # 蔈
    0x8509: 'gǔn',  # 蔉
    0x850A: 'hàn',  # 蔊
    0x850B: 'dí',  # 蔋
    0x850C: 'sù',  # 蔌
    0x850D: 'lù',  # 蔍
    0x850E: 'shè',  # 蔎
    0x850F: 'shāng',  # 蔏
    0x8510: 'dí',  # 蔐
    0x8511: 'miè',  # 蔑
    0x8512: 'hūn',  # 蔒
    0x8513: 'màn,wàn',  # 蔓
    0x8514: 'bo',  # 蔔
    0x8515: 'dì',  # 蔕
    0x8516: 'cuó',  # 蔖
    0x8517: 'zhè',  # 蔗
    0x8518: 'shēn',  # 蔘
    0x8519: 'xuàn',  # 蔙
    0x851A: 'wèi',  # 蔚
    0x851B: 'hú',  # 蔛
    0x851C: 'áo',  # 蔜
    0x851D: 'mǐ',  # 蔝
    0x851E: 'lóu',  # 蔞
    0x851F: 'cù',  # 蔟
    0x8520: 'zhōng',  # 蔠
    0x8521: 'cài',  # 蔡
    0x8522: 'pó',  # 蔢
    0x8523: 'jiǎng',  # 蔣
    0x8524: 'mì',  # 蔤
    0x8525: 'cōng',  # 蔥
    0x8526: 'niǎo',  # 蔦
    0x8527: 'huì',  # 蔧
    0x8528: 'juàn',  # 蔨
    0x8529: 'yín',  # 蔩
    0x852A: 'jiān',  # 蔪
    0x852B: 'niān',  # 蔫
    0x852C: 'shū',  # 蔬
    0x852D: 'yīn',  # 蔭
    0x852E: 'guó',  # 蔮
    0x852F: 'chén',  # 蔯
    0x8530: 'hù',  # 蔰
    0x8531: 'shā',  # 蔱
    0x8532: 'kòu',  # 蔲
    0x8533: 'qiàn',  # 蔳
    0x8534: 'má',  # 蔴
    0x8535: 'zàng',  # 蔵
    0x8536: 'zé',  # 蔶
    0x8537: 'qiáng',  # 蔷
    0x8538: 'dōu',  # 蔸
    0x8539: 'liǎn',  # 蔹
    0x853A: 'lìn',  # 蔺
    0x853B: 'kòu',  # 蔻
    0x853C: 'ǎi',  # 蔼
    0x853D: 'bì',  # 蔽
    0x853E: 'lí',  # 蔾
    0x853F: 'wěi',  # 蔿
    0x8540: 'jí',  # 蕀
    0x8541: 'qián,xún',  # 蕁
    0x8542: 'shèng',  # 蕂
    0x8543: 'fán',  # 蕃
    0x8544: 'méng',  # 蕄
    0x8545: 'ǒu',  # 蕅
    0x8546: 'chǎn',  # 蕆
    0x8547: 'diǎn',  # 蕇
    0x8548: 'xùn',  # 蕈
    0x8549: 'jiāo',  # 蕉
    0x854A: 'ruǐ',  # 蕊
    0x854B: 'ruǐ',  # 蕋
    0x854C: 'lěi',  # 蕌
    0x854D: 'yú',  # 蕍
    0x854E: 'qiáo',  # 蕎
    0x854F: 'zhū',  # 蕏
    0x8550: 'huá',  # 蕐
    0x8551: 'jiān',  # 蕑
    0x8552: 'mǎi',  # 蕒
    0x8553: 'yún',  # 蕓
    0x8554: 'bāo',  # 蕔
    0x8555: 'yóu',  # 蕕
    0x8556: 'qú',  # 蕖
    0x8557: 'lù',  # 蕗
    0x8558: 'ráo',  # 蕘
    0x8559: 'huì',  # 蕙
    0x855A: 'è',  # 蕚
    0x855B: 'tí',  # 蕛
    0x855C: 'fěi',  # 蕜
    0x855D: 'jué',  # 蕝
    0x855E: 'zuì',  # 蕞
    0x855F: 'fà',  # 蕟
    0x8560: 'rú',  # 蕠
    0x8561: 'fén',  # 蕡
    0x8562: 'kuì',  # 蕢
    0x8563: 'shùn',  # 蕣
    0x8564: 'ruí',  # 蕤
    0x8565: 'yǎ',  # 蕥
    0x8566: 'xū',  # 蕦
    0x8567: 'fù',  # 蕧
    0x8568: 'jué',  # 蕨
    0x8569: 'dàng',  # 蕩
    0x856A: 'wú',  # 蕪
    0x856B: 'dǒng',  # 蕫
    0x856C: 'sī',  # 蕬
    0x856D: 'xiāo',  # 蕭
    0x856E: 'xì',  # 蕮
    0x856F: 'sà',  # 蕯
    0x8570: 'yùn',  # 蕰
    0x8571: 'shāo',  # 蕱
    0x8572: 'qí',  # 蕲
    0x8573: 'jiān',  # 蕳
    0x8574: 'yùn',  # 蕴
    0x8575: 'sūn',  # 蕵
    0x8576: 'líng',  # 蕶
    0x8577: 'yù',  # 蕷
    0x8578: 'xiá',  # 蕸
    0x8579: 'wèng',  # 蕹
    0x857A: 'jí',  # 蕺
    0x857B: 'hòng',  # 蕻
    0x857C: 'sì',  # 蕼
    0x857D: 'nóng',  # 蕽
    0x857E: 'lěi',  # 蕾
    0x857F: 'xuān',  # 蕿
    0x8580: 'yùn',  # 薀
    0x8581: 'yù',  # 薁
    0x8582: 'xí,xiào',  # 薂
    0x8583: 'hào',  # 薃
    0x8584: 'báo,bó,bò',  # 薄
    0x8585: 'hāo',  # 薅
    0x8586: 'ài',  # 薆
    0x8587: 'wēi',  # 薇
    0x8588: 'huì',  # 薈
    0x8589: 'huì',  # 薉
    0x858A: 'jì',  # 薊
    0x858B: 'cí,zī',  # 薋
    0x858C: 'xiāng',  # 薌
    0x858D: 'wàn,luàn',  # 薍
    0x858E: 'miè',  # 薎
    0x858F: 'yì',  # 薏
    0x8590: 'léng',  # 薐
    0x8591: 'jiāng',  # 薑
    0x8592: 'càn',  # 薒
    0x8593: 'shēn',  # 薓
    0x8594: 'qiáng,sè',  # 薔
    0x8595: 'lián',  # 薕
    0x8596: 'kē',  # 薖
    0x8597: 'yuán',  # 薗
    0x8598: 'dá',  # 薘
    0x8599: 'tì',  # 薙
    0x859A: 'tāng',  # 薚
    0x859B: 'xuē',  # 薛
    0x859C: 'bì',  # 薜
    0x859D: 'zhān',  # 薝
    0x859E: 'sūn',  # 薞
    0x859F: 'xiān,liǎn',  # 薟
    0x85A0: 'fán',  # 薠
    0x85A1: 'dǐng',  # 薡
    0x85A2: 'xiè',  # 薢
    0x85A3: 'gǔ',  # 薣
    0x85A4: 'xiè',  # 薤
    0x85A5: 'shǔ',  # 薥
    0x85A6: 'jiàn',  # 薦
    0x85A7: 'hāo,kǎo',  # 薧
    0x85A8: 'hōng',  # 薨
    0x85A9: 'sà',  # 薩
    0x85AA: 'xīn',  # 薪
    0x85AB: 'xūn',  # 薫
    0x85AC: 'yào',  # 薬
    0x85AD: 'bài',  # 薭
    0x85AE: 'sǒu',  # 薮
    0x85AF: 'shǔ',  # 薯
    0x85B0: 'xūn',  # 薰
    0x85B1: 'duì',  # 薱
    0x85B2: 'pín',  # 薲
    0x85B3: 'yuǎn,wěi',  # 薳
    0x85B4: 'níng',  # 薴
    0x85B5: 'chóu,zhòu',  # 薵
    0x85B6: 'mái,wō',  # 薶
    0x85B7: 'rú',  # 薷
    0x85B8: 'piáo',  # 薸
    0x85B9: 'tái',  # 薹
    0x85BA: 'jì,qí',  # 薺
    0x85BB: 'zǎo',  # 薻
    0x85BC: 'chén',  # 薼
    0x85BD: 'zhēn',  # 薽
    0x85BE: 'ěr',  # 薾
    0x85BF: 'nǐ',  # 薿
    0x85C0: 'yíng',  # 藀
    0x85C1: 'gǎo',  # 藁
    0x85C2: 'cóng',  # 藂
    0x85C3: 'xiāo,hào',  # 藃
    0x85C4: 'qí',  # 藄
    0x85C5: 'fá',  # 藅
    0x85C6: 'jiǎn',  # 藆
    0x85C7: 'xù,yù,xū',  # 藇
    0x85C8: 'kuí',  # 藈
    0x85C9: 'jiè,jí',  # 藉
    0x85CA: 'biǎn',  # 藊
    0x85CB: 'diào,zhuó',  # 藋
    0x85CC: 'mí',  # 藌
    0x85CD: 'lán',  # 藍
    0x85CE: 'jìn',  # 藎
    0x85CF: 'cáng,zàng',  # 藏
    0x85D0: 'miǎo',  # 藐
    0x85D1: 'qióng',  # 藑
    0x85D2: 'qì',  # 藒
    0x85D3: 'xiǎn',  # 藓
    0x85D4: 'liáo',  # 藔
    0x85D5: 'ǒu',  # 藕
    0x85D6: 'xián',  # 藖
    0x85D7: 'sù',  # 藗
    0x85D8: 'lǘ',  # 藘
    0x85D9: 'yì',  # 藙
    0x85DA: 'xù',  # 藚
    0x85DB: 'xiě',  # 藛
    0x85DC: 'lí',  # 藜
    0x85DD: 'yì',  # 藝
    0x85DE: 'lǎ',  # 藞
    0x85DF: 'lěi',  # 藟
    0x85E0: 'jiào',  # 藠
    0x85E1: 'dí',  # 藡
    0x85E2: 'zhǐ',  # 藢
    0x85E3: 'bēi',  # 藣
    0x85E4: 'téng',  # 藤
    0x85E5: 'yào',  # 藥
    0x85E6: 'mò',  # 藦
    0x85E7: 'huàn',  # 藧
    0x85E8: 'biāo,pāo',  # 藨
    0x85E9: 'fān',  # 藩
    0x85EA: 'sǒu',  # 藪
    0x85EB: 'tán',  # 藫
    0x85EC: 'tuī',  # 藬
    0x85ED: 'qióng',  # 藭
    0x85EE: 'qiáo',  # 藮
    0x85EF: 'wèi',  # 藯
    0x85F0: 'liú,liǔ',  # 藰
    0x85F1: 'huì,huí',  # 藱
    0x85F2: 'ōu',  # 藲
    0x85F3: 'gǎo',  # 藳
    0x85F4: 'yùn',  # 藴
    0x85F5: 'bǎo',  # 藵
    0x85F6: 'lì',  # 藶
    0x85F7: 'shǔ',  # 藷
    0x85F8: 'zhū,chú',  # 藸
    0x85F9: 'ǎi',  # 藹
    0x85FA: 'lìn',  # 藺
    0x85FB: 'zǎo',  # 藻
    0x85FC: 'xuān',  # 藼
    0x85FD: 'qìn',  # 藽
    0x85FE: 'lài',  # 藾
    0x85FF: 'huò',  # 藿
    0x8600: 'tuò',  # 蘀
    0x8601: 'wù',  # 蘁
    0x8602: 'ruǐ',  # 蘂
    0x8603: 'ruǐ',  # 蘃
    0x8604: 'qí',  # 蘄
    0x8605: 'héng',  # 蘅
    0x8606: 'lú',  # 蘆
    0x8607: 'sū',  # 蘇
    0x8608: 'tuí',  # 蘈
    0x8609: 'máng',  # 蘉
    0x860A: 'yùn',  # 蘊
    0x860B: 'pín,píng',  # 蘋
    0x860C: 'yù',  # 蘌
    0x860D: 'xūn',  # 蘍
    0x860E: 'jì',  # 蘎
    0x860F: 'jiōng',  # 蘏
    0x8610: 'xuān',  # 蘐
    0x8611: 'mó',  # 蘑
    0x8612: 'qiū',  # 蘒
    0x8613: 'sū',  # 蘓
    0x8614: 'jiōng',  # 蘔
    0x8615: 'péng',  # 蘕
    0x8616: 'niè',  # 蘖
    0x8617: 'bò',  # 蘗
    0x8618: 'ráng',  # 蘘
    0x8619: 'yì',  # 蘙
    0x861A: 'xiǎn',  # 蘚
    0x861B: 'yú',  # 蘛
    0x861C: 'jú',  # 蘜
    0x861D: 'liǎn',  # 蘝
    0x861E: 'liǎn',  # 蘞
    0x861F: 'yǐn',  # 蘟
    0x8620: 'qiáng',  # 蘠
    0x8621: 'yīng',  # 蘡
    0x8622: 'lóng',  # 蘢
    0x8623: 'tǒu',  # 蘣
    0x8624: 'huā',  # 蘤
    0x8625: 'yuè',  # 蘥
    0x8626: 'lìng',  # 蘦
    0x8627: 'qú',  # 蘧
    0x8628: 'yáo',  # 蘨
    0x8629: 'fán',  # 蘩
    0x862A: 'mí',  # 蘪
    0x862B: 'lán',  # 蘫
    0x862C: 'guī',  # 蘬
    0x862D: 'lán',  # 蘭
    0x862E: 'jì',  # 蘮
    0x862F: 'dàng',  # 蘯
    0x8630: 'màn',  # 蘰
    0x8631: 'lèi',  # 蘱
    0x8632: 'léi',  # 蘲
    0x8633: 'huī',  # 蘳
    0x8634: 'fēng',  # 蘴
    0x8635: 'zhī',  # 蘵
    0x8636: 'wèi',  # 蘶
    0x8637: 'kuí',  # 蘷
    0x8638: 'zhàn',  # 蘸
    0x8639: 'huái',  # 蘹
    0x863A: 'lí',  # 蘺
    0x863B: 'jì',  # 蘻
    0x863C: 'mí',  # 蘼
    0x863D: 'lěi',  # 蘽
    0x863E: 'huài',  # 蘾
    0x863F: 'luó',  # 蘿
    0x8640: 'jī',  # 虀
    0x8641: 'kuí',  # 虁
    0x8642: 'lù',  # 虂
    0x8643: 'jiān',  # 虃
    0x8644: 'sal',  # 虄
    0x8645: 'téng',  # 虅
    0x8646: 'léi',  # 虆
    0x8647: 'quǎn',  # 虇
    0x8648: 'xiāo',  # 虈
    0x8649: 'yì',  # 虉
    0x864A: 'luán',  # 虊
    0x864B: 'mén',  # 虋
    0x864C: 'biē',  # 虌
    0x864D: 'hū',  # 虍
    0x864E: 'hǔ',  # 虎
    0x864F: 'lǔ',  # 虏
    0x8650: 'nüè',  # 虐
    0x8651: 'lǜ',  # 虑
    0x8652: 'sī',  # 虒
    0x8653: 'xiāo',  # 虓
    0x8654: 'qián',  # 虔
    0x8655: 'chǔ',  # 處
    0x8656: 'hū',  # 虖
    0x8657: 'xū',  # 虗
    0x8658: 'cuó',  # 虘
    0x8659: 'fú',  # 虙
    0x865A: 'xū',  # 虚
    0x865B: 'xū',  # 虛
    0x865C: 'lǔ',  # 虜
    0x865D: 'hǔ',  # 虝
    0x865E: 'yú',  # 虞
    0x865F: 'hào,háo',  # 號
    0x8660: 'jiāo',  # 虠
    0x8661: 'jù',  # 虡
    0x8662: 'guó',  # 虢
    0x8663: 'bào',  # 虣
    0x8664: 'yán',  # 虤
    0x8665: 'zhàn',  # 虥
    0x8666: 'zhàn',  # 虦
    0x8667: 'kuī',  # 虧
    0x8668: 'bīn',  # 虨
    0x8669: 'xì',  # 虩
    0x866A: 'shù',  # 虪
    0x866B: 'chóng',  # 虫
    0x866C: 'qiú',  # 虬
    0x866D: 'diāo',  # 虭
    0x866E: 'jǐ',  # 虮
    0x866F: 'qiú',  # 虯
    0x8670: 'dīng',  # 虰
    0x8671: 'shī',  # 虱
    0x8672: 'xiā',  # 虲
    0x8673: 'jué',  # 虳
    0x8674: 'zhé',  # 虴
    0x8675: 'shé',  # 虵
    0x8676: 'yú',  # 虶
    0x8677: 'hán',  # 虷
    0x8678: 'zǐ',  # 虸
    0x8679: 'hóng',  # 虹
    0x867A: 'huǐ,huī',  # 虺
    0x867B: 'méng',  # 虻
    0x867C: 'gè',  # 虼
    0x867D: 'suī',  # 虽
    0x867E: 'xiā,hā',  # 虾
    0x867F: 'chài',  # 虿
    0x8680: 'shí',  # 蚀
    0x8681: 'yǐ',  # 蚁
    0x8682: 'mǎ,mā,mà',  # 蚂
    0x8683: 'xiǎng',  # 蚃
    0x8684: 'fāng,bàng',  # 蚄
    0x8685: 'è',  # 蚅
    0x8686: 'bā',  # 蚆
    0x8687: 'chǐ',  # 蚇
    0x8688: 'qiān',  # 蚈
    0x8689: 'wén',  # 蚉
    0x868A: 'wén',  # 蚊
    0x868B: 'ruì',  # 蚋
    0x868C: 'bàng,bèng',  # 蚌
    0x868D: 'pí',  # 蚍
    0x868E: 'yuè',  # 蚎
    0x868F: 'yuè',  # 蚏
    0x8690: 'jūn',  # 蚐
    0x8691: 'qí',  # 蚑
    0x8692: 'tóng',  # 蚒
    0x8693: 'yǐn',  # 蚓
    0x8694: 'qí,zhǐ',  # 蚔
    0x8695: 'cán',  # 蚕
    0x8696: 'yuán,wán',  # 蚖
    0x8697: 'jué,quē',  # 蚗
    0x8698: 'huí',  # 蚘
    0x8699: 'qín,qián',  # 蚙
    0x869A: 'qí',  # 蚚
    0x869B: 'zhòng',  # 蚛
    0x869C: 'yá',  # 蚜
    0x869D: 'háo',  # 蚝
    0x869E: 'mù',  # 蚞
    0x869F: 'wáng',  # 蚟
    0x86A0: 'fén',  # 蚠
    0x86A1: 'fén',  # 蚡
    0x86A2: 'háng',  # 蚢
    0x86A3: 'gōng,zhōng',  # 蚣
    0x86A4: 'zǎo',  # 蚤
    0x86A5: 'fù,fǔ',  # 蚥
    0x86A6: 'rán',  # 蚦
    0x86A7: 'jiè',  # 蚧
    0x86A8: 'fú',  # 蚨
    0x86A9: 'chī',  # 蚩
    0x86AA: 'dǒu',  # 蚪
    0x86AB: 'bào',  # 蚫
    0x86AC: 'xiǎn',  # 蚬
    0x86AD: 'ní',  # 蚭
    0x86AE: 'dài,dé',  # 蚮
    0x86AF: 'qiū',  # 蚯
    0x86B0: 'yóu',  # 蚰
    0x86B1: 'zhà',  # 蚱
    0x86B2: 'píng',  # 蚲
    0x86B3: 'chí',  # 蚳
    0x86B4: 'yòu',  # 蚴
    0x86B5: 'kē',  # 蚵
    0x86B6: 'hān',  # 蚶
    0x86B7: 'jù',  # 蚷
    0x86B8: 'lì',  # 蚸
    0x86B9: 'fù',  # 蚹
    0x86BA: 'rán',  # 蚺
    0x86BB: 'zhá',  # 蚻
    0x86BC: 'gǒu,qú,xù',  # 蚼
    0x86BD: 'pí',  # 蚽
    0x86BE: 'pí,bǒ',  # 蚾
    0x86BF: 'xián',  # 蚿
    0x86C0: 'zhù',  # 蛀
    0x86C1: 'diāo',  # 蛁
    0x86C2: 'bié',  # 蛂
    0x86C3: 'bīng',  # 蛃
    0x86C4: 'gū',  # 蛄
    0x86C5: 'zhān',  # 蛅
    0x86C6: 'qū',  # 蛆
    0x86C7: 'shé,yí',  # 蛇
    0x86C8: 'tiě',  # 蛈
    0x86C9: 'líng',  # 蛉
    0x86CA: 'gǔ',  # 蛊
    0x86CB: 'dàn',  # 蛋
    0x86CC: 'tún',  # 蛌
    0x86CD: 'yíng',  # 蛍
    0x86CE: 'lì',  # 蛎
    0x86CF: 'chēng',  # 蛏
    0x86D0: 'qū',  # 蛐
    0x86D1: 'móu',  # 蛑
    0x86D2: 'gé,luò',  # 蛒
    0x86D3: 'cì',  # 蛓
    0x86D4: 'huí',  # 蛔
    0x86D5: 'huí',  # 蛕
    0x86D6: 'máng,bàng',  # 蛖
    0x86D7: 'fù',  # 蛗
    0x86D8: 'yáng',  # 蛘
    0x86D9: 'wā',  # 蛙
    0x86DA: 'liè',  # 蛚
    0x86DB: 'zhū',  # 蛛
    0x86DC: 'yī',  # 蛜
    0x86DD: 'xián',  # 蛝
    0x86DE: 'kuò',  # 蛞
    0x86DF: 'jiāo',  # 蛟
    0x86E0: 'lì',  # 蛠
    0x86E1: 'yì,xǔ',  # 蛡
    0x86E2: 'píng',  # 蛢
    0x86E3: 'jié',  # 蛣
    0x86E4: 'gé,há',  # 蛤
    0x86E5: 'shé',  # 蛥
    0x86E6: 'yí',  # 蛦
    0x86E7: 'wǎng',  # 蛧
    0x86E8: 'mò',  # 蛨
    0x86E9: 'qióng',  # 蛩
    0x86EA: 'qiè,ní',  # 蛪
    0x86EB: 'guǐ',  # 蛫
    0x86EC: 'qióng',  # 蛬
    0x86ED: 'zhì',  # 蛭
    0x86EE: 'mán',  # 蛮
    0x86EF: 'lǎo',  # 蛯
    0x86F0: 'zhé',  # 蛰
    0x86F1: 'jiá',  # 蛱
    0x86F2: 'náo',  # 蛲
    0x86F3: 'sī',  # 蛳
    0x86F4: 'qí',  # 蛴
    0x86F5: 'xíng',  # 蛵
    0x86F6: 'jiè',  # 蛶
    0x86F7: 'qiú',  # 蛷
    0x86F8: 'xiāo',  # 蛸
    0x86F9: 'yǒng',  # 蛹
    0x86FA: 'jiá',  # 蛺
    0x86FB: 'tuì',  # 蛻
    0x86FC: 'chē',  # 蛼
    0x86FD: 'bèi',  # 蛽
    0x86FE: 'é,yǐ',  # 蛾
    0x86FF: 'hàn',  # 蛿
    0x8700: 'shǔ',  # 蜀
    0x8701: 'xuán',  # 蜁
    0x8702: 'fēng',  # 蜂
    0x8703: 'shèn',  # 蜃
    0x8704: 'shèn',  # 蜄
    0x8705: 'fǔ',  # 蜅
    0x8706: 'xiǎn',  # 蜆
    0x8707: 'zhé',  # 蜇
    0x8708: 'wú',  # 蜈
    0x8709: 'fú',  # 蜉
    0x870A: 'lì',  # 蜊
    0x870B: 'láng',  # 蜋
    0x870C: 'bì',  # 蜌
    0x870D: 'chú',  # 蜍
    0x870E: 'yuān',  # 蜎
    0x870F: 'yǒu',  # 蜏
    0x8710: 'jié',  # 蜐
    0x8711: 'dàn',  # 蜑
    0x8712: 'yán',  # 蜒
    0x8713: 'tíng',  # 蜓
    0x8714: 'diàn',  # 蜔
    0x8715: 'tuì',  # 蜕
    0x8716: 'huí',  # 蜖
    0x8717: 'wō',  # 蜗
    0x8718: 'zhī',  # 蜘
    0x8719: 'zhōng',  # 蜙
    0x871A: 'fēi',  # 蜚
    0x871B: 'jū',  # 蜛
    0x871C: 'mì',  # 蜜
    0x871D: 'qí',  # 蜝
    0x871E: 'qí',  # 蜞
    0x871F: 'yù',  # 蜟
    0x8720: 'jùn',  # 蜠
    0x8721: 'là',  # 蜡
    0x8722: 'měng',  # 蜢
    0x8723: 'qiāng',  # 蜣
    0x8724: 'sī',  # 蜤
    0x8725: 'xī',  # 蜥
    0x8726: 'lún',  # 蜦
    0x8727: 'lì',  # 蜧
    0x8728: 'dié',  # 蜨
    0x8729: 'tiáo',  # 蜩
    0x872A: 'táo',  # 蜪
    0x872B: 'kūn',  # 蜫
    0x872C: 'hán',  # 蜬
    0x872D: 'hàn',  # 蜭
    0x872E: 'yù',  # 蜮
    0x872F: 'bàng',  # 蜯
    0x8730: 'féi',  # 蜰
    0x8731: 'pí',  # 蜱
    0x8732: 'wēi',  # 蜲
    0x8733: 'dūn',  # 蜳
    0x8734: 'yì',  # 蜴
    0x8735: 'yuān',  # 蜵
    0x8736: 'suò',  # 蜶
    0x8737: 'quán',  # 蜷
    0x8738: 'qiǎn',  # 蜸
    0x8739: 'ruì',  # 蜹
    0x873A: 'ní',  # 蜺
    0x873B: 'qīng',  # 蜻
    0x873C: 'wèi',  # 蜼
    0x873D: 'liǎng',  # 蜽
    0x873E: 'guǒ',  # 蜾
    0x873F: 'wān',  # 蜿
    0x8740: 'dōng',  # 蝀
    0x8741: 'è',  # 蝁
    0x8742: 'bǎn',  # 蝂
    0x8743: 'dì',  # 蝃
    0x8744: 'wǎng',  # 蝄
    0x8745: 'cán',  # 蝅
    0x8746: 'yǎng',  # 蝆
    0x8747: 'yíng',  # 蝇
    0x8748: 'guō',  # 蝈
    0x8749: 'chán',  # 蝉
    0x874A: 'dìng',  # 蝊
    0x874B: 'là',  # 蝋
    0x874C: 'kē',  # 蝌
    0x874D: 'jí',  # 蝍
    0x874E: 'xiē',  # 蝎
    0x874F: 'tíng',  # 蝏
    0x8750: 'mào',  # 蝐
    0x8751: 'xū',  # 蝑
    0x8752: 'mián',  # 蝒
    0x8753: 'yú',  # 蝓
    0x8754: 'jiē',  # 蝔
    0x8755: 'shí',  # 蝕
    0x8756: 'xuān',  # 蝖
    0x8757: 'huáng',  # 蝗
    0x8758: 'yǎn',  # 蝘
    0x8759: 'biān',  # 蝙
    0x875A: 'róu',  # 蝚
    0x875B: 'wēi',  # 蝛
    0x875C: 'fù',  # 蝜
    0x875D: 'yuán',  # 蝝
    0x875E: 'mèi',  # 蝞
    0x875F: 'wèi',  # 蝟
    0x8760: 'fú',  # 蝠
    0x8761: 'rú',  # 蝡
    0x8762: 'xié',  # 蝢
    0x8763: 'yóu',  # 蝣
    0x8764: 'qiú',  # 蝤
    0x8765: 'máo',  # 蝥
    0x8766: 'xiā,hā',  # 蝦
    0x8767: 'yīng',  # 蝧
    0x8768: 'shī',  # 蝨
    0x8769: 'chóng',  # 蝩
    0x876A: 'tāng',  # 蝪
    0x876B: 'zhū',  # 蝫
    0x876C: 'zōng',  # 蝬
    0x876D: 'dì',  # 蝭
    0x876E: 'fù',  # 蝮
    0x876F: 'yuán',  # 蝯
    0x8770: 'kuí',  # 蝰
    0x8771: 'méng',  # 蝱
    0x8772: 'là',  # 蝲
    0x8773: 'dài',  # 蝳
    0x8774: 'hú',  # 蝴
    0x8775: 'qiū',  # 蝵
    0x8776: 'dié',  # 蝶
    0x8777: 'lì',  # 蝷
    0x8778: 'wō',  # 蝸
    0x8779: 'yūn',  # 蝹
    0x877A: 'qǔ',  # 蝺
    0x877B: 'nǎn',  # 蝻
    0x877C: 'lóu',  # 蝼
    0x877D: 'chūn',  # 蝽
    0x877E: 'róng',  # 蝾
    0x877F: 'yíng',  # 蝿
    0x8780: 'jiāng',  # 螀
    0x8781: 'tuì',  # 螁
    0x8782: 'láng',  # 螂
    0x8783: 'páng',  # 螃
    0x8784: 'sī',  # 螄
    0x8785: 'xī',  # 螅
    0x8786: 'cì',  # 螆
    0x8787: 'xī,qī',  # 螇
    0x8788: 'yuán',  # 螈
    0x8789: 'wēng',  # 螉
    0x878A: 'lián',  # 螊
    0x878B: 'sōu',  # 螋
    0x878C: 'bān',  # 螌
    0x878D: 'róng',  # 融
    0x878E: 'róng',  # 螎
    0x878F: 'jí',  # 螏
    0x8790: 'wū',  # 螐
    0x8791: 'xiù',  # 螑
    0x8792: 'hàn',  # 螒
    0x8793: 'qín',  # 螓
    0x8794: 'yí',  # 螔
    0x8795: 'bī,pí',  # 螕
    0x8796: 'huá',  # 螖
    0x8797: 'táng',  # 螗
    0x8798: 'yǐ',  # 螘
    0x8799: 'dù',  # 螙
    0x879A: 'nài,něng',  # 螚
    0x879B: 'hé,xiá',  # 螛
    0x879C: 'hú',  # 螜
    0x879D: 'guì,huǐ',  # 螝
    0x879E: 'mǎ,mā,mà',  # 螞
    0x879F: 'míng',  # 螟
    0x87A0: 'yì',  # 螠
    0x87A1: 'wén',  # 螡
    0x87A2: 'yíng',  # 螢
    0x87A3: 'téng',  # 螣
    0x87A4: 'zhōng',  # 螤
    0x87A5: 'cāng',  # 螥
    0x87A6: 'sāo',  # 螦
    0x87A7: 'qí',  # 螧
    0x87A8: 'mǎn',  # 螨
    0x87A9: 'dāo',  # 螩
    0x87AA: 'shāng',  # 螪
    0x87AB: 'shì,zhē',  # 螫
    0x87AC: 'cáo',  # 螬
    0x87AD: 'chī',  # 螭
    0x87AE: 'dì',  # 螮
    0x87AF: 'áo',  # 螯
    0x87B0: 'lù',  # 螰
    0x87B1: 'wèi',  # 螱
    0x87B2: 'dié,zhì',  # 螲
    0x87B3: 'táng',  # 螳
    0x87B4: 'chén',  # 螴
    0x87B5: 'piāo',  # 螵
    0x87B6: 'qú,jù',  # 螶
    0x87B7: 'pí',  # 螷
    0x87B8: 'yú',  # 螸
    0x87B9: 'chán,jiàn',  # 螹
    0x87BA: 'luó',  # 螺
    0x87BB: 'lóu',  # 螻
    0x87BC: 'qǐn',  # 螼
    0x87BD: 'zhōng',  # 螽
    0x87BE: 'yǐn',  # 螾
    0x87BF: 'jiāng',  # 螿
    0x87C0: 'shuài',  # 蟀
    0x87C1: 'wén',  # 蟁
    0x87C2: 'xiāo',  # 蟂
    0x87C3: 'wàn',  # 蟃
    0x87C4: 'zhé',  # 蟄
    0x87C5: 'zhè',  # 蟅
    0x87C6: 'má,mò',  # 蟆
    0x87C7: 'má',  # 蟇
    0x87C8: 'guō',  # 蟈
    0x87C9: 'liú',  # 蟉
    0x87CA: 'máo',  # 蟊
    0x87CB: 'xī',  # 蟋
    0x87CC: 'cōng',  # 蟌
    0x87CD: 'lí',  # 蟍
    0x87CE: 'mǎn',  # 蟎
    0x87CF: 'xiāo',  # 蟏
    0x87D0: 'chán',  # 蟐
    0x87D1: 'zhāng',  # 蟑
    0x87D2: 'mǎng,měng',  # 蟒
    0x87D3: 'xiàng',  # 蟓
    0x87D4: 'mò',  # 蟔
    0x87D5: 'zuī',  # 蟕
    0x87D6: 'sī',  # 蟖
    0x87D7: 'qiū',  # 蟗
    0x87D8: 'tè',  # 蟘
    0x87D9: 'zhí',  # 蟙
    0x87DA: 'péng',  # 蟚
    0x87DB: 'péng',  # 蟛
    0x87DC: 'jiǎo',  # 蟜
    0x87DD: 'qú',  # 蟝
    0x87DE: 'biē,bié',  # 蟞
    0x87DF: 'liáo',  # 蟟
    0x87E0: 'pán',  # 蟠
    0x87E1: 'guǐ',  # 蟡
    0x87E2: 'xǐ',  # 蟢
    0x87E3: 'jǐ',  # 蟣
    0x87E4: 'zhuān',  # 蟤
    0x87E5: 'huáng',  # 蟥
    0x87E6: 'fèi,bēn',  # 蟦
    0x87E7: 'láo,liáo',  # 蟧
    0x87E8: 'jué',  # 蟨
    0x87E9: 'jué',  # 蟩
    0x87EA: 'huì',  # 蟪
    0x87EB: 'yín,xún',  # 蟫
    0x87EC: 'chán',  # 蟬
    0x87ED: 'jiāo',  # 蟭
    0x87EE: 'shàn',  # 蟮
    0x87EF: 'náo',  # 蟯
    0x87F0: 'xiāo',  # 蟰
    0x87F1: 'wú',  # 蟱
    0x87F2: 'chóng',  # 蟲
    0x87F3: 'xún',  # 蟳
    0x87F4: 'sī',  # 蟴
    0x87F5: 'chú',  # 蟵
    0x87F6: 'chēng',  # 蟶
    0x87F7: 'dāng',  # 蟷
    0x87F8: 'lí',  # 蟸
    0x87F9: 'xiè',  # 蟹
    0x87FA: 'shàn',  # 蟺
    0x87FB: 'yǐ',  # 蟻
    0x87FC: 'jǐng',  # 蟼
    0x87FD: 'dá',  # 蟽
    0x87FE: 'chán',  # 蟾
    0x87FF: 'qì',  # 蟿
    0x8800: 'cī',  # 蠀
    0x8801: 'xiǎng',  # 蠁
    0x8802: 'shè',  # 蠂
    0x8803: 'luǒ',  # 蠃
    0x8804: 'qín',  # 蠄
    0x8805: 'yíng',  # 蠅
    0x8806: 'chài',  # 蠆
    0x8807: 'lì',  # 蠇
    0x8808: 'zéi',  # 蠈
    0x8809: 'xuān',  # 蠉
    0x880A: 'lián',  # 蠊
    0x880B: 'zhú',  # 蠋
    0x880C: 'zé',  # 蠌
    0x880D: 'xiē',  # 蠍
    0x880E: 'mǎng',  # 蠎
    0x880F: 'xiè',  # 蠏
    0x8810: 'qí',  # 蠐
    0x8811: 'róng',  # 蠑
    0x8812: 'jiǎn',  # 蠒
    0x8813: 'měng',  # 蠓
    0x8814: 'háo',  # 蠔
    0x8815: 'rú',  # 蠕
    0x8816: 'huò',  # 蠖
    0x8817: 'zhuó',  # 蠗
    0x8818: 'jié',  # 蠘
    0x8819: 'pín',  # 蠙
    0x881A: 'hē',  # 蠚
    0x881B: 'miè',  # 蠛
    0x881C: 'fán',  # 蠜
    0x881D: 'lěi',  # 蠝
    0x881E: 'jié',  # 蠞
    0x881F: 'là',  # 蠟
    0x8820: 'mǐn',  # 蠠
    0x8821: 'lǐ',  # 蠡
    0x8822: 'chǔn',  # 蠢
    0x8823: 'lì',  # 蠣
    0x8824: 'qiū',  # 蠤
    0x8825: 'niè',  # 蠥
    0x8826: 'lú',  # 蠦
    0x8827: 'dù',  # 蠧
    0x8828: 'xiāo',  # 蠨
    0x8829: 'zhū',  # 蠩
    0x882A: 'lóng',  # 蠪
    0x882B: 'lí',  # 蠫
    0x882C: 'lóng',  # 蠬
    0x882D: 'fēng',  # 蠭
    0x882E: 'yē',  # 蠮
    0x882F: 'pí',  # 蠯
    0x8830: 'náng',  # 蠰
    0x8831: 'gǔ',  # 蠱
    0x8832: 'juān',  # 蠲
    0x8833: 'yīng',  # 蠳
    0x8834: 'shǔ',  # 蠴
    0x8835: 'xī',  # 蠵
    0x8836: 'cán',  # 蠶
    0x8837: 'qú',  # 蠷
    0x8838: 'quán',  # 蠸
    0x8839: 'dù',  # 蠹
    0x883A: 'cán',  # 蠺
    0x883B: 'mán',  # 蠻
    0x883C: 'qú',  # 蠼
    0x883D: 'jié',  # 蠽
    0x883E: 'zhú',  # 蠾
    0x883F: 'zhuó',  # 蠿
    0x8840: 'xiě,xuè',  # 血
    0x8841: 'huāng',  # 衁
    0x8842: 'nǜ',  # 衂
    0x8843: 'pēi',  # 衃
    0x8844: 'nǜ',  # 衄
    0x8845: 'xìn',  # 衅
    0x8846: 'zhòng',  # 衆
    0x8847: 'mài',  # 衇
    0x8848: 'ěr',  # 衈
    0x8849: 'kè',  # 衉
    0x884A: 'miè',  # 衊
    0x884B: 'xì',  # 衋
    0x884C: 'háng,xíng',  # 行
    0x884D: 'yǎn',  # 衍
    0x884E: 'kàn',  # 衎
    0x884F: 'yuàn',  # 衏
    0x8850: 'qú',  # 衐
    0x8851: 'líng',  # 衑
    0x8852: 'xuàn',  # 衒
    0x8853: 'shù',  # 術
    0x8854: 'xián',  # 衔
    0x8855: 'tòng',  # 衕
    0x8856: 'xiàng',  # 衖
    0x8857: 'jiē',  # 街
    0x8858: 'xián',  # 衘
    0x8859: 'yá',  # 衙
    0x885A: 'hú',  # 衚
    0x885B: 'wèi',  # 衛
    0x885C: 'dào',  # 衜
    0x885D: 'chōng',  # 衝
    0x885E: 'wèi',  # 衞
    0x885F: 'dào',  # 衟
    0x8860: 'zhūn',  # 衠
    0x8861: 'héng',  # 衡
    0x8862: 'qú',  # 衢
    0x8863: 'yī',  # 衣
    0x8864: 'yī',  # 衤
    0x8865: 'bǔ',  # 补
    0x8866: 'gǎn',  # 衦
    0x8867: 'yú',  # 衧
    0x8868: 'biǎo',  # 表
    0x8869: 'chà',  # 衩
    0x886A: 'yì',  # 衪
    0x886B: 'shān',  # 衫
    0x886C: 'chèn',  # 衬
    0x886D: 'fū',  # 衭
    0x886E: 'gǔn',  # 衮
    0x886F: 'fēn',  # 衯
    0x8870: 'shuāi,cuī',  # 衰
    0x8871: 'jié',  # 衱
    0x8872: 'nà',  # 衲
    0x8873: 'zhōng',  # 衳
    0x8874: 'dǎn',  # 衴
    0x8875: 'rì',  # 衵
    0x8876: 'zhòng',  # 衶
    0x8877: 'zhōng',  # 衷
    0x8878: 'jiè',  # 衸
    0x8879: 'zhǐ',  # 衹
    0x887A: 'xié',  # 衺
    0x887B: 'rán',  # 衻
    0x887C: 'zhī',  # 衼
    0x887D: 'rèn',  # 衽
    0x887E: 'qīn',  # 衾
    0x887F: 'jīn',  # 衿
    0x8880: 'jūn',  # 袀
    0x8881: 'yuán',  # 袁
    0x8882: 'mèi',  # 袂
    0x8883: 'chài',  # 袃
    0x8884: 'ǎo',  # 袄
    0x8885: 'niǎo',  # 袅
    0x8886: 'huī',  # 袆
    0x8887: 'rán',  # 袇
    0x8888: 'jiā',  # 袈
    0x8889: 'tuó,tuō',  # 袉
    0x888A: 'lǐng,líng',  # 袊
    0x888B: 'dài',  # 袋
    0x888C: 'bào,páo,pào',  # 袌
    0x888D: 'páo',  # 袍
    0x888E: 'yào',  # 袎
    0x888F: 'zuò',  # 袏
    0x8890: 'bì',  # 袐
    0x8891: 'shào',  # 袑
    0x8892: 'tǎn',  # 袒
    0x8893: 'jù,jiē',  # 袓
    0x8894: 'hè,kè',  # 袔
    0x8895: 'xué',  # 袕
    0x8896: 'xiù',  # 袖
    0x8897: 'zhěn',  # 袗
    0x8898: 'yí,yì',  # 袘
    0x8899: 'pà',  # 袙
    0x889A: 'fú',  # 袚
    0x889B: 'dī',  # 袛
    0x889C: 'wà',  # 袜
    0x889D: 'fù',  # 袝
    0x889E: 'gǔn',  # 袞
    0x889F: 'zhì',  # 袟
    0x88A0: 'zhì',  # 袠
    0x88A1: 'rán',  # 袡
    0x88A2: 'pàn',  # 袢
    0x88A3: 'yì',  # 袣
    0x88A4: 'mào',  # 袤
    0x88A5: 'tuō',  # 袥
    0x88A6: 'nà,jué',  # 袦
    0x88A7: 'gōu',  # 袧
    0x88A8: 'xuàn',  # 袨
    0x88A9: 'zhé',  # 袩
    0x88AA: 'qū',  # 袪
    0x88AB: 'bèi,pī',  # 被
    0x88AC: 'yù',  # 袬
    0x88AD: 'xí',  # 袭
    0x88AE: 'mí',  # 袮
    0x88AF: 'bó',  # 袯
    0x88B0: 'bō',  # 袰
    0x88B1: 'fú',  # 袱
    0x88B2: 'chǐ,nuǒ',  # 袲
    0x88B3: 'chǐ,qǐ,duǒ,nuǒ',  # 袳
    0x88B4: 'kù',  # 袴
    0x88B5: 'rèn',  # 袵
    0x88B6: 'péng',  # 袶
    0x88B7: 'jiá,jié,qiā',  # 袷
    0x88B8: 'jiàn,zùn',  # 袸
    0x88B9: 'bó,mò',  # 袹
    0x88BA: 'jié',  # 袺
    0x88BB: 'ér',  # 袻
    0x88BC: 'gē',  # 袼
    0x88BD: 'rú',  # 袽
    0x88BE: 'zhū',  # 袾
    0x88BF: 'guī,guà',  # 袿
    0x88C0: 'yīn',  # 裀
    0x88C1: 'cái',  # 裁
    0x88C2: 'liè,liě',  # 裂
    0x88C3: 'kǎ',  # 裃
    0x88C4: 'háng',  # 裄
    0x88C5: 'zhuāng',  # 装
    0x88C6: 'dāng',  # 裆
    0x88C7: 'xū',  # 裇
    0x88C8: 'kūn',  # 裈
    0x88C9: 'kèn',  # 裉
    0x88CA: 'niǎo',  # 裊
    0x88CB: 'shù',  # 裋
    0x88CC: 'jiá',  # 裌
    0x88CD: 'kǔn',  # 裍
    0x88CE: 'chéng,chěng',  # 裎
    0x88CF: 'lǐ',  # 裏
    0x88D0: 'juān',  # 裐
    0x88D1: 'shēn',  # 裑
    0x88D2: 'póu',  # 裒
    0x88D3: 'gé,jiē',  # 裓
    0x88D4: 'yì',  # 裔
    0x88D5: 'yù',  # 裕
    0x88D6: 'zhěn',  # 裖
    0x88D7: 'liú',  # 裗
    0x88D8: 'qiú',  # 裘
    0x88D9: 'qún',  # 裙
    0x88DA: 'jì',  # 裚
    0x88DB: 'yì',  # 裛
    0x88DC: 'bǔ',  # 補
    0x88DD: 'zhuāng',  # 裝
    0x88DE: 'shuì',  # 裞
    0x88DF: 'shā',  # 裟
    0x88E0: 'qún',  # 裠
    0x88E1: 'lǐ',  # 裡
    0x88E2: 'lián',  # 裢
    0x88E3: 'liǎn',  # 裣
    0x88E4: 'kù',  # 裤
    0x88E5: 'jiǎn',  # 裥
    0x88E6: 'bāo',  # 裦
    0x88E7: 'chān',  # 裧
    0x88E8: 'bì,pí',  # 裨
    0x88E9: 'kūn',  # 裩
    0x88EA: 'táo',  # 裪
    0x88EB: 'yuàn',  # 裫
    0x88EC: 'líng',  # 裬
    0x88ED: 'chǐ',  # 裭
    0x88EE: 'chāng',  # 裮
    0x88EF: 'chóu,dāo',  # 裯
    0x88F0: 'duō',  # 裰
    0x88F1: 'biǎo',  # 裱
    0x88F2: 'liǎng',  # 裲
    0x88F3: 'cháng,shang',  # 裳
    0x88F4: 'péi',  # 裴
    0x88F5: 'péi',  # 裵
    0x88F6: 'fēi',  # 裶
    0x88F7: 'yuān,gǔn',  # 裷
    0x88F8: 'luǒ',  # 裸
    0x88F9: 'guǒ',  # 裹
    0x88FA: 'yǎn,ān',  # 裺
    0x88FB: 'dú',  # 裻
    0x88FC: 'xī,tì',  # 裼
    0x88FD: 'zhì',  # 製
    0x88FE: 'jū',  # 裾
    0x88FF: 'yǐ',  # 裿
    0x8900: 'qí',  # 褀
    0x8901: 'guǒ',  # 褁
    0x8902: 'guà',  # 褂
    0x8903: 'kèn',  # 褃
    0x8904: 'qī',  # 褄
    0x8905: 'tì',  # 褅
    0x8906: 'tí',  # 褆
    0x8907: 'fù',  # 複
    0x8908: 'chóng',  # 褈
    0x8909: 'xiè',  # 褉
    0x890A: 'biǎn',  # 褊
    0x890B: 'dié',  # 褋
    0x890C: 'kūn',  # 褌
    0x890D: 'duān',  # 褍
    0x890E: 'xiù',  # 褎
    0x890F: 'xiù',  # 褏
    0x8910: 'hè',  # 褐
    0x8911: 'yuàn',  # 褑
    0x8912: 'bāo',  # 褒
    0x8913: 'bǎo',  # 褓
    0x8914: 'fù,fú',  # 褔
    0x8915: 'yú',  # 褕
    0x8916: 'tuàn',  # 褖
    0x8917: 'yǎn',  # 褗
    0x8918: 'huī',  # 褘
    0x8919: 'bèi',  # 褙
    0x891A: 'zhǔ,chǔ',  # 褚
    0x891B: 'lǚ',  # 褛
    0x891C: 'páo',  # 褜
    0x891D: 'dān',  # 褝
    0x891E: 'yùn',  # 褞
    0x891F: 'tā',  # 褟
    0x8920: 'gōu',  # 褠
    0x8921: 'dā',  # 褡
    0x8922: 'huái',  # 褢
    0x8923: 'róng',  # 褣
    0x8924: 'yuán',  # 褤
    0x8925: 'rù',  # 褥
    0x8926: 'nài',  # 褦
    0x8927: 'jiǒng',  # 褧
    0x8928: 'suǒ',  # 褨
    0x8929: 'bān',  # 褩
    0x892A: 'tuì,tùn',  # 褪
    0x892B: 'chǐ',  # 褫
    0x892C: 'sǎng',  # 褬
    0x892D: 'niǎo',  # 褭
    0x892E: 'yīng',  # 褮
    0x892F: 'jiè',  # 褯
    0x8930: 'qiān',  # 褰
    0x8931: 'huái',  # 褱
    0x8932: 'kù',  # 褲
    0x8933: 'lián',  # 褳
    0x8934: 'lán',  # 褴
    0x8935: 'lí',  # 褵
    0x8936: 'zhě',  # 褶
    0x8937: 'shī',  # 褷
    0x8938: 'lǚ',  # 褸
    0x8939: 'yì',  # 褹
    0x893A: 'diē',  # 褺
    0x893B: 'xiè',  # 褻
    0x893C: 'xiān',  # 褼
    0x893D: 'wèi',  # 褽
    0x893E: 'biǎo',  # 褾
    0x893F: 'cáo',  # 褿
    0x8940: 'jì',  # 襀
    0x8941: 'qiǎng',  # 襁
    0x8942: 'sēn',  # 襂
    0x8943: 'bāo',  # 襃
    0x8944: 'xiāng',  # 襄
    0x8945: 'bì',  # 襅
    0x8946: 'fú',  # 襆
    0x8947: 'jiǎn',  # 襇
    0x8948: 'zhuàn',  # 襈
    0x8949: 'jiǎn',  # 襉
    0x894A: 'cuì',  # 襊
    0x894B: 'jí',  # 襋
    0x894C: 'dān',  # 襌
    0x894D: 'zá',  # 襍
    0x894E: 'fán',  # 襎
    0x894F: 'bó',  # 襏
    0x8950: 'xiàng',  # 襐
    0x8951: 'xín',  # 襑
    0x8952: 'bié',  # 襒
    0x8953: 'ráo',  # 襓
    0x8954: 'mǎn',  # 襔
    0x8955: 'lán',  # 襕
    0x8956: 'ǎo',  # 襖
    0x8957: 'zé',  # 襗
    0x8958: 'guì',  # 襘
    0x8959: 'cào',  # 襙
    0x895A: 'suì',  # 襚
    0x895B: 'nóng',  # 襛
    0x895C: 'chān',  # 襜
    0x895D: 'liǎn',  # 襝
    0x895E: 'bì',  # 襞
    0x895F: 'jīn',  # 襟
    0x8960: 'dāng',  # 襠
    0x8961: 'shǔ',  # 襡
    0x8962: 'tǎn',  # 襢
    0x8963: 'bì',  # 襣
    0x8964: 'lán',  # 襤
    0x8965: 'fú',  # 襥
    0x8966: 'rú',  # 襦
    0x8967: 'zhǐ',  # 襧
    0x8968: 'tae',  # 襨
    0x8969: 'shǔ',  # 襩
    0x896A: 'wà',  # 襪
    0x896B: 'shì',  # 襫
    0x896C: 'bǎi',  # 襬
    0x896D: 'xié',  # 襭
    0x896E: 'bó',  # 襮
    0x896F: 'chèn',  # 襯
    0x8970: 'lǎi',  # 襰
    0x8971: 'lóng',  # 襱
    0x8972: 'xí',  # 襲
    0x8973: 'xiān',  # 襳
    0x8974: 'lán',  # 襴
    0x8975: 'zhě',  # 襵
    0x8976: 'dài',  # 襶
    0x8977: 'jǔ',  # 襷
    0x8978: 'zàn',  # 襸
    0x8979: 'shī',  # 襹
    0x897A: 'jiǎn',  # 襺
    0x897B: 'pàn',  # 襻
    0x897C: 'yì',  # 襼
    0x897D: 'lán',  # 襽
    0x897E: 'yà',  # 襾
    0x897F: 'xī',  # 西
    0x8980: 'yà',  # 覀
    0x8981: 'yào,yāo',  # 要
    0x8982: 'fěng',  # 覂
    0x8983: 'tán,qín',  # 覃
    0x8984: 'fù',  # 覄
    0x8985: 'fiào',  # 覅
    0x8986: 'fù',  # 覆
    0x8987: 'bà',  # 覇
    0x8988: 'hé',  # 覈
    0x8989: 'jī',  # 覉
    0x898A: 'jī',  # 覊
    0x898B: 'jiàn,xiàn',  # 見
    0x898C: 'guān,guàn',  # 覌
    0x898D: 'biàn',  # 覍
    0x898E: 'yàn',  # 覎
    0x898F: 'guī',  # 規
    0x8990: 'jué,jiào',  # 覐
    0x8991: 'piǎn',  # 覑
    0x8992: 'mào',  # 覒
    0x8993: 'mì',  # 覓
    0x8994: 'mì',  # 覔
    0x8995: 'piē,miè',  # 覕
    0x8996: 'shì',  # 視
    0x8997: 'sì',  # 覗
    0x8998: 'chān',  # 覘
    0x8999: 'zhěn',  # 覙
    0x899A: 'jué,jiào',  # 覚
    0x899B: 'mì',  # 覛
    0x899C: 'tiào',  # 覜
    0x899D: 'lián',  # 覝
    0x899E: 'yào',  # 覞
    0x899F: 'zhì',  # 覟
    0x89A0: 'jūn',  # 覠
    0x89A1: 'xī',  # 覡
    0x89A2: 'shǎn',  # 覢
    0x89A3: 'wēi',  # 覣
    0x89A4: 'xì',  # 覤
    0x89A5: 'tiǎn',  # 覥
    0x89A6: 'yú',  # 覦
    0x89A7: 'lǎn',  # 覧
    0x89A8: 'è',  # 覨
    0x89A9: 'dǔ',  # 覩
    0x89AA: 'qīn,qìng',  # 親
    0x89AB: 'pǎng',  # 覫
    0x89AC: 'jì',  # 覬
    0x89AD: 'míng',  # 覭
    0x89AE: 'yíng,yǐng',  # 覮
    0x89AF: 'gòu',  # 覯
    0x89B0: 'qū,qù',  # 覰
    0x89B1: 'zhàn,zhān',  # 覱
    0x89B2: 'jìn',  # 覲
    0x89B3: 'guān,guàn',  # 観
    0x89B4: 'dèng',  # 覴
    0x89B5: 'jiàn,biǎn',  # 覵
    0x89B6: 'luó,luǎn',  # 覶
    0x89B7: 'qù,qū',  # 覷
    0x89B8: 'jiàn',  # 覸
    0x89B9: 'wéi',  # 覹
    0x89BA: 'jué,jiào',  # 覺
    0x89BB: 'qù,qū',  # 覻
    0x89BC: 'luó',  # 覼
    0x89BD: 'lǎn',  # 覽
    0x89BE: 'shěn',  # 覾
    0x89BF: 'dí',  # 覿
    0x89C0: 'guān,guàn',  # 觀
    0x89C1: 'jiàn,xiàn',  # 见
    0x89C2: 'guān,guàn',  # 观
    0x89C3: 'yàn',  # 觃
    0x89C4: 'guī',  # 规
    0x89C5: 'mì',  # 觅
    0x89C6: 'shì',  # 视
    0x89C7: 'chān',  # 觇
    0x89C8: 'lǎn',  # 览
    0x89C9: 'jué,jiào',  # 觉
    0x89CA: 'jì',  # 觊
    0x89CB: 'xí',  # 觋
    0x89CC: 'dí',  # 觌
    0x89CD: 'tiǎn',  # 觍
    0x89CE: 'yú',  # 觎
    0x89CF: 'gòu',  # 觏
    0x89D0: 'jìn',  # 觐
    0x89D1: 'qù,qū',  # 觑
    0x89D2: 'jiǎo,jué',  # 角
    0x89D3: 'qiú',  # 觓
    0x89D4: 'jīn',  # 觔
    0x89D5: 'cū',  # 觕
    0x89D6: 'jué',  # 觖
    0x89D7: 'zhì',  # 觗
    0x89D8: 'chào',  # 觘
    0x89D9: 'jí',  # 觙
    0x89DA: 'gū',  # 觚
    0x89DB: 'dàn',  # 觛
    0x89DC: 'zī,zuǐ',  # 觜
    0x89DD: 'dǐ',  # 觝
    0x89DE: 'shāng',  # 觞
    0x89DF: 'huà,xiè',  # 觟
    0x89E0: 'quán',  # 觠
    0x89E1: 'gé',  # 觡
    0x89E2: 'shì',  # 觢
    0x89E3: 'jiě,jiè,xiè',  # 解
    0x89E4: 'guǐ',  # 觤
    0x89E5: 'gōng',  # 觥
    0x89E6: 'chù',  # 触
    0x89E7: 'jiě,jiè,xiè',  # 觧
    0x89E8: 'hùn',  # 觨
    0x89E9: 'qiú',  # 觩
    0x89EA: 'xīng',  # 觪
    0x89EB: 'sù',  # 觫
    0x89EC: 'ní',  # 觬
    0x89ED: 'jī,qí',  # 觭
    0x89EE: 'jué',  # 觮
    0x89EF: 'zhì',  # 觯
    0x89F0: 'zhā',  # 觰
    0x89F1: 'bì',  # 觱
    0x89F2: 'xīng',  # 觲
    0x89F3: 'hú',  # 觳
    0x89F4: 'shāng',  # 觴
    0x89F5: 'gōng',  # 觵
    0x89F6: 'zhì',  # 觶
    0x89F7: 'xué,hù',  # 觷
    0x89F8: 'chù',  # 觸
    0x89F9: 'xī',  # 觹
    0x89FA: 'yí',  # 觺
    0x89FB: 'lì,lù',  # 觻
    0x89FC: 'jué',  # 觼
    0x89FD: 'xī',  # 觽
    0x89FE: 'yàn',  # 觾
    0x89FF: 'xī',  # 觿
    0x8A00: 'yán',  # 言
    0x8A01: 'yán',  # 訁
    0x8A02: 'dìng',  # 訂
    0x8A03: 'fù',  # 訃
    0x8A04: 'qiú',  # 訄
    0x8A05: 'qiú',  # 訅
    0x8A06: 'jiào',  # 訆
    0x8A07: 'hōng',  # 訇
    0x8A08: 'jì',  # 計
    0x8A09: 'fàn',  # 訉
    0x8A0A: 'xùn',  # 訊
    0x8A0B: 'diào',  # 訋
    0x8A0C: 'hòng',  # 訌
    0x8A0D: 'chài',  # 訍
    0x8A0E: 'tǎo',  # 討
    0x8A0F: 'xū',  # 訏
    0x8A10: 'jié',  # 訐
    0x8A11: 'dàn',  # 訑
    0x8A12: 'rèn',  # 訒
    0x8A13: 'xùn',  # 訓
    0x8A14: 'yín',  # 訔
    0x8A15: 'shàn',  # 訕
    0x8A16: 'qì',  # 訖
    0x8A17: 'tuō',  # 託
    0x8A18: 'jì',  # 記
    0x8A19: 'xùn',  # 訙
    0x8A1A: 'yín',  # 訚
    0x8A1B: 'é',  # 訛
    0x8A1C: 'fēn',  # 訜
    0x8A1D: 'yà',  # 訝
    0x8A1E: 'yāo',  # 訞
    0x8A1F: 'sòng',  # 訟
    0x8A20: 'shěn',  # 訠
    0x8A21: 'yín',  # 訡
    0x8A22: 'xīn',  # 訢
    0x8A23: 'jué',  # 訣
    0x8A24: 'xiáo',  # 訤
    0x8A25: 'nè',  # 訥
    0x8A26: 'chén',  # 訦
    0x8A27: 'yóu',  # 訧
    0x8A28: 'zhǐ',  # 訨
    0x8A29: 'xiōng',  # 訩
    0x8A2A: 'fǎng',  # 訪
    0x8A2B: 'xìn',  # 訫
    0x8A2C: 'chāo',  # 訬
    0x8A2D: 'shè',  # 設
    0x8A2E: 'yán',  # 訮
    0x8A2F: 'sǎ',  # 訯
    0x8A30: 'zhùn',  # 訰
    0x8A31: 'xū',  # 許
    0x8A32: 'yì',  # 訲
    0x8A33: 'yì',  # 訳
    0x8A34: 'sù',  # 訴
    0x8A35: 'chī',  # 訵
    0x8A36: 'hē',  # 訶
    0x8A37: 'shēn',  # 訷
    0x8A38: 'hé',  # 訸
    0x8A39: 'xù',  # 訹
    0x8A3A: 'zhěn',  # 診
    0x8A3B: 'zhù',  # 註
    0x8A3C: 'zhèng',  # 証
    0x8A3D: 'gòu',  # 訽
    0x8A3E: 'zī',  # 訾
    0x8A3F: 'zǐ',  # 訿
    0x8A40: 'zhān',  # 詀
    0x8A41: 'gǔ',  # 詁
    0x8A42: 'fù',  # 詂
    0x8A43: 'jiǎn',  # 詃
    0x8A44: 'dié',  # 詄
    0x8A45: 'líng',  # 詅
    0x8A46: 'dǐ',  # 詆
    0x8A47: 'yàng',  # 詇
    0x8A48: 'lì',  # 詈
    0x8A49: 'náo',  # 詉
    0x8A4A: 'pàn',  # 詊
    0x8A4B: 'zhòu',  # 詋
    0x8A4C: 'gàn',  # 詌
    0x8A4D: 'yì',  # 詍
    0x8A4E: 'jù',  # 詎
    0x8A4F: 'yào',  # 詏
    0x8A50: 'zhà',  # 詐
    0x8A51: 'tuó',  # 詑
    0x8A52: 'yí,dài',  # 詒
    0x8A53: 'qǔ',  # 詓
    0x8A54: 'zhào',  # 詔
    0x8A55: 'píng',  # 評
    0x8A56: 'bì',  # 詖
    0x8A57: 'xiòng',  # 詗
    0x8A58: 'qū',  # 詘
    0x8A59: 'bá',  # 詙
    0x8A5A: 'dá',  # 詚
    0x8A5B: 'zǔ',  # 詛
    0x8A5C: 'tāo',  # 詜
    0x8A5D: 'zhǔ',  # 詝
    0x8A5E: 'cí',  # 詞
    0x8A5F: 'zhé',  # 詟
    0x8A60: 'yǒng',  # 詠
    0x8A61: 'xǔ',  # 詡
    0x8A62: 'xún',  # 詢
    0x8A63: 'yì',  # 詣
    0x8A64: 'huǎng',  # 詤
    0x8A65: 'hé',  # 詥
    0x8A66: 'shì',  # 試
    0x8A67: 'chá',  # 詧
    0x8A68: 'xiào',  # 詨
    0x8A69: 'shī',  # 詩
    0x8A6A: 'hěn',  # 詪
    0x8A6B: 'chà',  # 詫
    0x8A6C: 'gòu',  # 詬
    0x8A6D: 'guǐ',  # 詭
    0x8A6E: 'quán',  # 詮
    0x8A6F: 'huì',  # 詯
    0x8A70: 'jié',  # 詰
    0x8A71: 'huà',  # 話
    0x8A72: 'gāi',  # 該
    0x8A73: 'xiáng',  # 詳
    0x8A74: 'wēi',  # 詴
    0x8A75: 'shēn',  # 詵
    0x8A76: 'chóu',  # 詶
    0x8A77: 'tóng',  # 詷
    0x8A78: 'mí',  # 詸
    0x8A79: 'zhān',  # 詹
    0x8A7A: 'míng',  # 詺
    0x8A7B: 'luò',  # 詻
    0x8A7C: 'huī',  # 詼
    0x8A7D: 'yán',  # 詽
    0x8A7E: 'xiōng',  # 詾
    0x8A7F: 'guà',  # 詿
    0x8A80: 'èr',  # 誀
    0x8A81: 'bìng',  # 誁
    0x8A82: 'tiǎo,diào',  # 誂
    0x8A83: 'yí,chǐ,chì',  # 誃
    0x8A84: 'lěi',  # 誄
    0x8A85: 'zhū',  # 誅
    0x8A86: 'kuāng',  # 誆
    0x8A87: 'kuā,kuà',  # 誇
    0x8A88: 'wū',  # 誈
    0x8A89: 'yù',  # 誉
    0x8A8A: 'téng',  # 誊
    0x8A8B: 'jì',  # 誋
    0x8A8C: 'zhì',  # 誌
    0x8A8D: 'rèn',  # 認
    0x8A8E: 'cù',  # 誎
    0x8A8F: 'lǎng,làng',  # 誏
    0x8A90: 'é',  # 誐
    0x8A91: 'kuáng',  # 誑
    0x8A92: 'ēi,éi,ěi,èi,xī',  # 誒
    0x8A93: 'shì',  # 誓
    0x8A94: 'tǐng',  # 誔
    0x8A95: 'dàn',  # 誕
    0x8A96: 'bèi,bó',  # 誖
    0x8A97: 'chán',  # 誗
    0x8A98: 'yòu',  # 誘
    0x8A99: 'kēng',  # 誙
    0x8A9A: 'qiào',  # 誚
    0x8A9B: 'qīn',  # 誛
    0x8A9C: 'shuà',  # 誜
    0x8A9D: 'ān',  # 誝
    0x8A9E: 'yǔ,yù',  # 語
    0x8A9F: 'xiào',  # 誟
    0x8AA0: 'chéng',  # 誠
    0x8AA1: 'jiè',  # 誡
    0x8AA2: 'xiàn',  # 誢
    0x8AA3: 'wū',  # 誣
    0x8AA4: 'wù',  # 誤
    0x8AA5: 'gào',  # 誥
    0x8AA6: 'sòng',  # 誦
    0x8AA7: 'bū',  # 誧
    0x8AA8: 'huì',  # 誨
    0x8AA9: 'jìng',  # 誩
    0x8AAA: 'shuō,shuì,yuè',  # 說
    0x8AAB: 'zhèn',  # 誫
    0x8AAC: 'shuō,shuì,yuè',  # 説
    0x8AAD: 'dú',  # 読
    0x8AAE: 'huā',  # 誮
    0x8AAF: 'chàng',  # 誯
    0x8AB0: 'shuí,shéi',  # 誰
    0x8AB1: 'jié',  # 誱
    0x8AB2: 'kè',  # 課
    0x8AB3: 'qū,juè',  # 誳
    0x8AB4: 'cóng',  # 誴
    0x8AB5: 'xiáo',  # 誵
    0x8AB6: 'suì',  # 誶
    0x8AB7: 'wǎng',  # 誷
    0x8AB8: 'xián',  # 誸
    0x8AB9: 'fěi',  # 誹
    0x8ABA: 'chī,lài',  # 誺
    0x8ABB: 'tà',  # 誻
    0x8ABC: 'yì',  # 誼
    0x8ABD: 'nì,ná',  # 誽
    0x8ABE: 'yín',  # 誾
    0x8ABF: 'diào,tiáo',  # 調
    0x8AC0: 'pǐ,bēi',  # 諀
    0x8AC1: 'zhuó',  # 諁
    0x8AC2: 'chǎn',  # 諂
    0x8AC3: 'chēn',  # 諃
    0x8AC4: 'zhūn',  # 諄
    0x8AC5: 'jì,jī',  # 諅
    0x8AC6: 'qī',  # 諆
    0x8AC7: 'tán',  # 談
    0x8AC8: 'zhuì',  # 諈
    0x8AC9: 'wěi',  # 諉
    0x8ACA: 'jū',  # 諊
    0x8ACB: 'qǐng',  # 請
    0x8ACC: 'dǒng',  # 諌
    0x8ACD: 'zhèng',  # 諍
    0x8ACE: 'zé,zuò,zhǎ,cuò',  # 諎
    0x8ACF: 'zōu',  # 諏
    0x8AD0: 'qiān',  # 諐
    0x8AD1: 'zhuó',  # 諑
    0x8AD2: 'liàng',  # 諒
    0x8AD3: 'jiàn',  # 諓
    0x8AD4: 'chù,jí',  # 諔
    0x8AD5: 'xià,háo',  # 諕
    0x8AD6: 'lùn,lún',  # 論
    0x8AD7: 'shěn',  # 諗
    0x8AD8: 'biǎo',  # 諘
    0x8AD9: 'huà',  # 諙
    0x8ADA: 'biàn',  # 諚
    0x8ADB: 'yú',  # 諛
    0x8ADC: 'dié',  # 諜
    0x8ADD: 'xū',  # 諝
    0x8ADE: 'piǎn',  # 諞
    0x8ADF: 'shì,dì',  # 諟
    0x8AE0: 'xuān',  # 諠
    0x8AE1: 'shì',  # 諡
    0x8AE2: 'hùn',  # 諢
    0x8AE3: 'huà,guā',  # 諣
    0x8AE4: 'è',  # 諤
    0x8AE5: 'zhòng',  # 諥
    0x8AE6: 'dì',  # 諦
    0x8AE7: 'xié',  # 諧
    0x8AE8: 'fú',  # 諨
    0x8AE9: 'pǔ',  # 諩
    0x8AEA: 'tíng',  # 諪
    0x8AEB: 'jiàn',  # 諫
    0x8AEC: 'qǐ',  # 諬
    0x8AED: 'yù',  # 諭
    0x8AEE: 'zī',  # 諮
    0x8AEF: 'zhuān',  # 諯
    0x8AF0: 'xǐ,shāi,āi',  # 諰
    0x8AF1: 'huì',  # 諱
    0x8AF2: 'yīn',  # 諲
    0x8AF3: 'ān',  # 諳
    0x8AF4: 'xián',  # 諴
    0x8AF5: 'nán,nàn',  # 諵
    0x8AF6: 'chén',  # 諶
    0x8AF7: 'fěng',  # 諷
    0x8AF8: 'zhū',  # 諸
    0x8AF9: 'yáng',  # 諹
    0x8AFA: 'yàn',  # 諺
    0x8AFB: 'huáng',  # 諻
    0x8AFC: 'xuān',  # 諼
    0x8AFD: 'gé',  # 諽
    0x8AFE: 'nuò',  # 諾
    0x8AFF: 'xǔ',  # 諿
    0x8B00: 'móu',  # 謀
    0x8B01: 'yè',  # 謁
    0x8B02: 'wèi',  # 謂
    0x8B03: 'xīng',  # 謃
    0x8B04: 'téng',  # 謄
    0x8B05: 'zhōu',  # 謅
    0x8B06: 'shàn',  # 謆
    0x8B07: 'jiǎn',  # 謇
    0x8B08: 'bó',  # 謈
    0x8B09: 'kuì',  # 謉
    0x8B0A: 'huǎng',  # 謊
    0x8B0B: 'huò',  # 謋
    0x8B0C: 'gē',  # 謌
    0x8B0D: 'yíng',  # 謍
    0x8B0E: 'mí',  # 謎
    0x8B0F: 'xiǎo',  # 謏
    0x8B10: 'mì',  # 謐
    0x8B11: 'xǐ',  # 謑
    0x8B12: 'qiāng',  # 謒
    0x8B13: 'chēn',  # 謓
    0x8B14: 'xuè',  # 謔
    0x8B15: 'tí',  # 謕
    0x8B16: 'sù',  # 謖
    0x8B17: 'bàng',  # 謗
    0x8B18: 'chí',  # 謘
    0x8B19: 'qiān',  # 謙
    0x8B1A: 'shì',  # 謚
    0x8B1B: 'jiǎng',  # 講
    0x8B1C: 'yuán',  # 謜
    0x8B1D: 'xiè',  # 謝
    0x8B1E: 'hè',  # 謞
    0x8B1F: 'tāo',  # 謟
    0x8B20: 'yáo',  # 謠
    0x8B21: 'yáo',  # 謡
    0x8B22: 'lū',  # 謢
    0x8B23: 'yú',  # 謣
    0x8B24: 'biāo',  # 謤
    0x8B25: 'còng',  # 謥
    0x8B26: 'qǐng',  # 謦
    0x8B27: 'lí',  # 謧
    0x8B28: 'mó',  # 謨
    0x8B29: 'mó',  # 謩
    0x8B2A: 'shāng',  # 謪
    0x8B2B: 'zhé',  # 謫
    0x8B2C: 'miù',  # 謬
    0x8B2D: 'jiǎn',  # 謭
    0x8B2E: 'zé',  # 謮
    0x8B2F: 'jiē',  # 謯
    0x8B30: 'lián',  # 謰
    0x8B31: 'lóu',  # 謱
    0x8B32: 'càn',  # 謲
    0x8B33: 'ōu',  # 謳
    0x8B34: 'gùn',  # 謴
    0x8B35: 'xí',  # 謵
    0x8B36: 'zhuó',  # 謶
    0x8B37: 'áo',  # 謷
    0x8B38: 'áo',  # 謸
    0x8B39: 'jǐn',  # 謹
    0x8B3A: 'zhé',  # 謺
    0x8B3B: 'yí',  # 謻
    0x8B3C: 'hū',  # 謼
    0x8B3D: 'jiàng',  # 謽
    0x8B3E: 'mán',  # 謾
    0x8B3F: 'cháo',  # 謿
    0x8B40: 'hàn',  # 譀
    0x8B41: 'huá',  # 譁
    0x8B42: 'chǎn',  # 譂
    0x8B43: 'xū',  # 譃
    0x8B44: 'zēng',  # 譄
    0x8B45: 'sè',  # 譅
    0x8B46: 'xī',  # 譆
    0x8B47: 'zhā',  # 譇
    0x8B48: 'duì',  # 譈
    0x8B49: 'zhèng',  # 證
    0x8B4A: 'náo',  # 譊
    0x8B4B: 'lán',  # 譋
    0x8B4C: 'é',  # 譌
    0x8B4D: 'yīng',  # 譍
    0x8B4E: 'jué',  # 譎
    0x8B4F: 'jī',  # 譏
    0x8B50: 'zǔn',  # 譐
    0x8B51: 'jiǎo',  # 譑
    0x8B52: 'bò',  # 譒
    0x8B53: 'huì',  # 譓
    0x8B54: 'zhuàn',  # 譔
    0x8B55: 'wú',  # 譕
    0x8B56: 'zèn',  # 譖
    0x8B57: 'zhá',  # 譗
    0x8B58: 'shí',  # 識
    0x8B59: 'qiáo',  # 譙
    0x8B5A: 'tán',  # 譚
    0x8B5B: 'jiàn',  # 譛
    0x8B5C: 'pǔ',  # 譜
    0x8B5D: 'shéng',  # 譝
    0x8B5E: 'xuān',  # 譞
    0x8B5F: 'zào',  # 譟
    0x8B60: 'tán',  # 譠
    0x8B61: 'dǎng',  # 譡
    0x8B62: 'suì',  # 譢
    0x8B63: 'xiǎn',  # 譣
    0x8B64: 'jī',  # 譤
    0x8B65: 'jiào',  # 譥
    0x8B66: 'jǐng',  # 警
    0x8B67: 'zhàn',  # 譧
    0x8B68: 'nóng',  # 譨
    0x8B69: 'yī',  # 譩
    0x8B6A: 'ǎi',  # 譪
    0x8B6B: 'zhān',  # 譫
    0x8B6C: 'pì',  # 譬
    0x8B6D: 'huǐ',  # 譭
    0x8B6E: 'huà',  # 譮
    0x8B6F: 'yì',  # 譯
    0x8B70: 'yì',  # 議
    0x8B71: 'shàn',  # 譱
    0x8B72: 'ràng',  # 譲
    0x8B73: 'ròu',  # 譳
    0x8B74: 'qiǎn',  # 譴
    0x8B75: 'duì',  # 譵
    0x8B76: 'tà',  # 譶
    0x8B77: 'hù',  # 護
    0x8B78: 'zhōu',  # 譸
    0x8B79: 'háo',  # 譹
    0x8B7A: 'ài',  # 譺
    0x8B7B: 'yīng',  # 譻
    0x8B7C: 'jiān',  # 譼
    0x8B7D: 'yù',  # 譽
    0x8B7E: 'jiǎn',  # 譾
    0x8B7F: 'huì',  # 譿
    0x8B80: 'dú',  # 讀
    0x8B81: 'zhé',  # 讁
    0x8B82: 'juàn,xuān',  # 讂
    0x8B83: 'zàn',  # 讃
    0x8B84: 'lěi',  # 讄
    0x8B85: 'shěn',  # 讅
    0x8B86: 'wèi',  # 讆
    0x8B87: 'chǎn',  # 讇
    0x8B88: 'lì',  # 讈
    0x8B89: 'yí,tuī',  # 讉
    0x8B8A: 'biàn',  # 變
    0x8B8B: 'zhé',  # 讋
    0x8B8C: 'yàn',  # 讌
    0x8B8D: 'è',  # 讍
    0x8B8E: 'chóu',  # 讎
    0x8B8F: 'wèi',  # 讏
    0x8B90: 'chóu',  # 讐
    0x8B91: 'yào',  # 讑
    0x8B92: 'chán',  # 讒
    0x8B93: 'ràng',  # 讓
    0x8B94: 'yǐn',  # 讔
    0x8B95: 'lán',  # 讕
    0x8B96: 'chèn',  # 讖
    0x8B97: 'xié',  # 讗
    0x8B98: 'niè',  # 讘
    0x8B99: 'huān',  # 讙
    0x8B9A: 'zàn',  # 讚
    0x8B9B: 'yì',  # 讛
    0x8B9C: 'dǎng',  # 讜
    0x8B9D: 'zhán',  # 讝
    0x8B9E: 'yàn',  # 讞
    0x8B9F: 'dú',  # 讟
    0x8BA0: 'yán',  # 讠
    0x8BA1: 'jì',  # 计
    0x8BA2: 'dìng',  # 订
    0x8BA3: 'fù',  # 讣
    0x8BA4: 'rèn',  # 认
    0x8BA5: 'jī',  # 讥
    0x8BA6: 'jié',  # 讦
    0x8BA7: 'hòng',  # 讧
    0x8BA8: 'tǎo',  # 讨
    0x8BA9: 'ràng',  # 让
    0x8BAA: 'shàn',  # 讪
    0x8BAB: 'qì',  # 讫
    0x8BAC: 'tuō',  # 讬
    0x8BAD: 'xùn',  # 训
    0x8BAE: 'yì',  # 议
    0x8BAF: 'xùn',  # 讯
    0x8BB0: 'jì',  # 记
    0x8BB1: 'rèn',  # 讱
    0x8BB2: 'jiǎng',  # 讲
    0x8BB3: 'huì',  # 讳
    0x8BB4: 'ōu',  # 讴
    0x8BB5: 'jù',  # 讵
    0x8BB6: 'yà',  # 讶
    0x8BB7: 'nè',  # 讷
    0x8BB8: 'xǔ,hǔ',  # 许
    0x8BB9: 'é',  # 讹
    0x8BBA: 'lùn,lún',  # 论
    0x8BBB: 'xiōng',  # 讻
    0x8BBC: 'sòng',  # 讼
    0x8BBD: 'fěng',  # 讽
    0x8BBE: 'shè',  # 设
    0x8BBF: 'fǎng',  # 访
    0x8BC0: 'jué',  # 诀
    0x8BC1: 'zhèng',  # 证
    0x8BC2: 'gǔ',  # 诂
    0x8BC3: 'hē',  # 诃
    0x8BC4: 'píng',  # 评
    0x8BC5: 'zǔ',  # 诅
    0x8BC6: 'shí,zhì',  # 识
    0x8BC7: 'xiòng',  # 诇
    0x8BC8: 'zhà',  # 诈
    0x8BC9: 'sù',  # 诉
    0x8BCA: 'zhěn',  # 诊
    0x8BCB: 'dǐ',  # 诋
    0x8BCC: 'zhōu',  # 诌
    0x8BCD: 'cí',  # 词
    0x8BCE: 'qū',  # 诎
    0x8BCF: 'zhào',  # 诏
    0x8BD0: 'bì',  # 诐
    0x8BD1: 'yì',  # 译
    0x8BD2: 'yí,dài',  # 诒
    0x8BD3: 'kuāng',  # 诓
    0x8BD4: 'lěi',  # 诔
    0x8BD5: 'shì',  # 试
    0x8BD6: 'guà',  # 诖
    0x8BD7: 'shī',  # 诗
    0x8BD8: 'jié,jí',  # 诘
    0x8BD9: 'huī',  # 诙
    0x8BDA: 'chéng',  # 诚
    0x8BDB: 'zhū',  # 诛
    0x8BDC: 'shēn',  # 诜
    0x8BDD: 'huà',  # 话
    0x8BDE: 'dàn',  # 诞
    0x8BDF: 'gòu',  # 诟
    0x8BE0: 'quán',  # 诠
    0x8BE1: 'guǐ',  # 诡
    0x8BE2: 'xún',  # 询
    0x8BE3: 'yì',  # 诣
    0x8BE4: 'zhèng',  # 诤
    0x8BE5: 'gāi',  # 该
    0x8BE6: 'xiáng,yáng',  # 详
    0x8BE7: 'chà',  # 诧
    0x8BE8: 'hùn',  # 诨
    0x8BE9: 'xǔ',  # 诩
    0x8BEA: 'zhōu,chóu',  # 诪
    0x8BEB: 'jiè',  # 诫
    0x8BEC: 'wū',  # 诬
    0x8BED: 'yǔ,yù',  # 语
    0x8BEE: 'qiào',  # 诮
    0x8BEF: 'wù',  # 误
    0x8BF0: 'gào',  # 诰
    0x8BF1: 'yòu',  # 诱
    0x8BF2: 'huì',  # 诲
    0x8BF3: 'kuáng',  # 诳
    0x8BF4: 'shuō,shuì,yuè',  # 说
    0x8BF5: 'sòng',  # 诵
    0x8BF6: 'ēi,éi,ěi,èi,xī',  # 诶
    0x8BF7: 'qǐng',  # 请
    0x8BF8: 'zhū',  # 诸
    0x8BF9: 'zōu',  # 诹
    0x8BFA: 'nuò',  # 诺
    0x8BFB: 'dú,dòu',  # 读
    0x8BFC: 'zhuó',  # 诼
    0x8BFD: 'fěi',  # 诽
    0x8BFE: 'kè',  # 课
    0x8BFF: 'wěi',  # 诿
    0x8C00: 'yú',  # 谀
    0x8C01: 'shuí',  # 谁
    0x8C02: 'shěn',  # 谂
    0x8C03: 'tiáo,diào,zhōu',  # 调
    0x8C04: 'chǎn',  # 谄
    0x8C05: 'liàng',  # 谅
    0x8C06: 'zhūn',  # 谆
    0x8C07: 'suì',  # 谇
    0x8C08: 'tán',  # 谈
    0x8C09: 'shěn',  # 谉
    0x8C0A: 'yì',  # 谊
    0x8C0B: 'móu',  # 谋
    0x8C0C: 'chén,shèn',  # 谌
    0x8C0D: 'dié',  # 谍
    0x8C0E: 'huǎng',  # 谎
    0x8C0F: 'jiàn',  # 谏
    0x8C10: 'xié',  # 谐
    0x8C11: 'xuè',  # 谑
    0x8C12: 'yè',  # 谒
    0x8C13: 'wèi',  # 谓
    0x8C14: 'è',  # 谔
    0x8C15: 'yù',  # 谕
    0x8C16: 'xuān',  # 谖
    0x8C17: 'chán',  # 谗
    0x8C18: 'zī',  # 谘
    0x8C19: 'ān',  # 谙
    0x8C1A: 'yàn',  # 谚
    0x8C1B: 'dì',  # 谛
    0x8C1C: 'mí',  # 谜
    0x8C1D: 'piǎn',  # 谝
    0x8C1E: 'xū',  # 谞
    0x8C1F: 'mó',  # 谟
    0x8C20: 'dǎng',  # 谠
    0x8C21: 'sù',  # 谡
    0x8C22: 'xiè',  # 谢
    0x8C23: 'yáo',  # 谣
    0x8C24: 'bàng',  # 谤
    0x8C25: 'shì',  # 谥
    0x8C26: 'qiān',  # 谦
    0x8C27: 'mì',  # 谧
    0x8C28: 'jǐn',  # 谨
    0x8C29: 'mán',  # 谩
    0x8C2A: 'zhé',  # 谪
    0x8C2B: 'jiǎn',  # 谫
    0x8C2C: 'miù',  # 谬
    0x8C2D: 'tán',  # 谭
    0x8C2E: 'zèn',  # 谮
    0x8C2F: 'qiáo',  # 谯
    0x8C30: 'lán',  # 谰
    0x8C31: 'pǔ',  # 谱
    0x8C32: 'jué',  # 谲
    0x8C33: 'yàn',  # 谳
    0x8C34: 'qiǎn',  # 谴
    0x8C35: 'zhān',  # 谵
    0x8C36: 'chèn',  # 谶
    0x8C37: 'gǔ',  # 谷
    0x8C38: 'qiān',  # 谸
    0x8C39: 'hóng',  # 谹
    0x8C3A: 'xiā',  # 谺
    0x8C3B: 'jí',  # 谻
    0x8C3C: 'hóng',  # 谼
    0x8C3D: 'hān',  # 谽
    0x8C3E: 'hōng',  # 谾
    0x8C3F: 'xī',  # 谿
    0x8C40: 'xī',  # 豀
    0x8C41: 'huō,huò,huá',  # 豁
    0x8C42: 'liáo',  # 豂
    0x8C43: 'hǎn',  # 豃
    0x8C44: 'dú',  # 豄
    0x8C45: 'lóng',  # 豅
    0x8C46: 'dòu',  # 豆
    0x8C47: 'jiāng',  # 豇
    0x8C48: 'qǐ,kǎi',  # 豈
    0x8C49: 'chǐ',  # 豉
    0x8C4A: 'lǐ',  # 豊
    0x8C4B: 'dēng',  # 豋
    0x8C4C: 'wān',  # 豌
    0x8C4D: 'bī',  # 豍
    0x8C4E: 'shù',  # 豎
    0x8C4F: 'xiàn',  # 豏
    0x8C50: 'fēng',  # 豐
    0x8C51: 'zhì',  # 豑
    0x8C52: 'zhì',  # 豒
    0x8C53: 'yàn',  # 豓
    0x8C54: 'yàn',  # 豔
    0x8C55: 'shǐ',  # 豕
    0x8C56: 'chù',  # 豖
    0x8C57: 'huī',  # 豗
    0x8C58: 'tún',  # 豘
    0x8C59: 'yì',  # 豙
    0x8C5A: 'tún',  # 豚
    0x8C5B: 'yì',  # 豛
    0x8C5C: 'jiān',  # 豜
    0x8C5D: 'bā',  # 豝
    0x8C5E: 'hòu',  # 豞
    0x8C5F: 'è',  # 豟
    0x8C60: 'chú',  # 豠
    0x8C61: 'xiàng',  # 象
    0x8C62: 'huàn',  # 豢
    0x8C63: 'jiān,yàn',  # 豣
    0x8C64: 'kěn',  # 豤
    0x8C65: 'gāi',  # 豥
    0x8C66: 'jù',  # 豦
    0x8C67: 'fú',  # 豧
    0x8C68: 'xī',  # 豨
    0x8C69: 'bīn',  # 豩
    0x8C6A: 'háo',  # 豪
    0x8C6B: 'yù',  # 豫
    0x8C6C: 'zhū',  # 豬
    0x8C6D: 'jiā',  # 豭
    0x8C6E: 'fén',  # 豮
    0x8C6F: 'xī',  # 豯
    0x8C70: 'hù',  # 豰
    0x8C71: 'wēn',  # 豱
    0x8C72: 'huán',  # 豲
    0x8C73: 'bīn',  # 豳
    0x8C74: 'dí',  # 豴
    0x8C75: 'zōng',  # 豵
    0x8C76: 'fén',  # 豶
    0x8C77: 'yì',  # 豷
    0x8C78: 'zhì',  # 豸
    0x8C79: 'bào',  # 豹
    0x8C7A: 'chái',  # 豺
    0x8C7B: 'àn',  # 豻
    0x8C7C: 'pí',  # 豼
    0x8C7D: 'nà',  # 豽
    0x8C7E: 'pī',  # 豾
    0x8C7F: 'gǒu',  # 豿
    0x8C80: 'nà',  # 貀
    0x8C81: 'yòu',  # 貁
    0x8C82: 'diāo',  # 貂
    0x8C83: 'mò',  # 貃
    0x8C84: 'sì',  # 貄
    0x8C85: 'xiū',  # 貅
    0x8C86: 'huán,huān',  # 貆
    0x8C87: 'kěn,kūn',  # 貇
    0x8C88: 'hé,mò',  # 貈
    0x8C89: 'hé,háo,mò',  # 貉
    0x8C8A: 'mò',  # 貊
    0x8C8B: 'àn',  # 貋
    0x8C8C: 'mào',  # 貌
    0x8C8D: 'lí',  # 貍
    0x8C8E: 'ní',  # 貎
    0x8C8F: 'bǐ',  # 貏
    0x8C90: 'yǔ',  # 貐
    0x8C91: 'jiā',  # 貑
    0x8C92: 'tuān,tuàn',  # 貒
    0x8C93: 'māo,máo',  # 貓
    0x8C94: 'pí',  # 貔
    0x8C95: 'xī',  # 貕
    0x8C96: 'yì',  # 貖
    0x8C97: 'jù,lóu',  # 貗
    0x8C98: 'mò',  # 貘
    0x8C99: 'chū',  # 貙
    0x8C9A: 'tán',  # 貚
    0x8C9B: 'huān',  # 貛
    0x8C9C: 'jué',  # 貜
    0x8C9D: 'bèi',  # 貝
    0x8C9E: 'zhēn',  # 貞
    0x8C9F: 'yuán,yún,yùn',  # 貟
    0x8CA0: 'fù',  # 負
    0x8CA1: 'cái',  # 財
    0x8CA2: 'gòng',  # 貢
    0x8CA3: 'dài',  # 貣
    0x8CA4: 'yì,yí',  # 貤
    0x8CA5: 'háng',  # 貥
    0x8CA6: 'wán',  # 貦
    0x8CA7: 'pín',  # 貧
    0x8CA8: 'huò',  # 貨
    0x8CA9: 'fàn',  # 販
    0x8CAA: 'tān',  # 貪
    0x8CAB: 'guàn',  # 貫
    0x8CAC: 'zé,zhài',  # 責
    0x8CAD: 'zhì',  # 貭
    0x8CAE: 'èr',  # 貮
    0x8CAF: 'zhù',  # 貯
    0x8CB0: 'shì',  # 貰
    0x8CB1: 'bì',  # 貱
    0x8CB2: 'zī',  # 貲
    0x8CB3: 'èr',  # 貳
    0x8CB4: 'guì',  # 貴
    0x8CB5: 'piǎn',  # 貵
    0x8CB6: 'biǎn',  # 貶
    0x8CB7: 'mǎi',  # 買
    0x8CB8: 'dài',  # 貸
    0x8CB9: 'shèng',  # 貹
    0x8CBA: 'kuàng',  # 貺
    0x8CBB: 'fèi',  # 費
    0x8CBC: 'tiē',  # 貼
    0x8CBD: 'yí',  # 貽
    0x8CBE: 'chí',  # 貾
    0x8CBF: 'mào',  # 貿
    0x8CC0: 'hè',  # 賀
    0x8CC1: 'bì,bēn',  # 賁
    0x8CC2: 'lù',  # 賂
    0x8CC3: 'lìn',  # 賃
    0x8CC4: 'huì',  # 賄
    0x8CC5: 'gāi',  # 賅
    0x8CC6: 'pián',  # 賆
    0x8CC7: 'zī',  # 資
    0x8CC8: 'jiǎ,gǔ,jià',  # 賈
    0x8CC9: 'xù',  # 賉
    0x8CCA: 'zéi',  # 賊
    0x8CCB: 'jiǎo',  # 賋
    0x8CCC: 'gāi',  # 賌
    0x8CCD: 'zāng',  # 賍
    0x8CCE: 'jiàn',  # 賎
    0x8CCF: 'yīng',  # 賏
    0x8CD0: 'jùn',  # 賐
    0x8CD1: 'zhèn',  # 賑
    0x8CD2: 'shē',  # 賒
    0x8CD3: 'bīn',  # 賓
    0x8CD4: 'bīn',  # 賔
    0x8CD5: 'qiú',  # 賕
    0x8CD6: 'shē',  # 賖
    0x8CD7: 'chuàn',  # 賗
    0x8CD8: 'zāng',  # 賘
    0x8CD9: 'zhōu',  # 賙
    0x8CDA: 'lài',  # 賚
    0x8CDB: 'zàn',  # 賛
    0x8CDC: 'cì',  # 賜
    0x8CDD: 'chēn',  # 賝
    0x8CDE: 'shǎng',  # 賞
    0x8CDF: 'tiǎn',  # 賟
    0x8CE0: 'péi',  # 賠
    0x8CE1: 'gēng',  # 賡
    0x8CE2: 'xián',  # 賢
    0x8CE3: 'mài',  # 賣
    0x8CE4: 'jiàn',  # 賤
    0x8CE5: 'suì',  # 賥
    0x8CE6: 'fù',  # 賦
    0x8CE7: 'dǎn',  # 賧
    0x8CE8: 'cóng',  # 賨
    0x8CE9: 'cóng',  # 賩
    0x8CEA: 'zhì',  # 質
    0x8CEB: 'jī',  # 賫
    0x8CEC: 'zhàng',  # 賬
    0x8CED: 'dǔ',  # 賭
    0x8CEE: 'jìn',  # 賮
    0x8CEF: 'xiōng,mín',  # 賯
    0x8CF0: 'chǔn',  # 賰
    0x8CF1: 'yǔn',  # 賱
    0x8CF2: 'bǎo',  # 賲
    0x8CF3: 'zāi',  # 賳
    0x8CF4: 'lài',  # 賴
    0x8CF5: 'fèng',  # 賵
    0x8CF6: 'càng',  # 賶
    0x8CF7: 'jī',  # 賷
    0x8CF8: 'shèng',  # 賸
    0x8CF9: 'ài',  # 賹
    0x8CFA: 'zhuàn,zuàn',  # 賺
    0x8CFB: 'fù',  # 賻
    0x8CFC: 'gòu',  # 購
    0x8CFD: 'sài',  # 賽
    0x8CFE: 'zé',  # 賾
    0x8CFF: 'liáo',  # 賿
    0x8D00: 'yì',  # 贀
    0x8D01: 'bài',  # 贁
    0x8D02: 'chěn',  # 贂
    0x8D03: 'wàn,zhuàn',  # 贃
    0x8D04: 'zhì',  # 贄
    0x8D05: 'zhuì',  # 贅
    0x8D06: 'biāo',  # 贆
    0x8D07: 'yūn',  # 贇
    0x8D08: 'zèng',  # 贈
    0x8D09: 'dàn',  # 贉
    0x8D0A: 'zàn',  # 贊
    0x8D0B: 'yàn',  # 贋
    0x8D0C: 'pú',  # 贌
    0x8D0D: 'shàn',  # 贍
    0x8D0E: 'wàn',  # 贎
    0x8D0F: 'yíng',  # 贏
    0x8D10: 'jìn',  # 贐
    0x8D11: 'gàn',  # 贑
    0x8D12: 'xián',  # 贒
    0x8D13: 'zāng',  # 贓
    0x8D14: 'bì',  # 贔
    0x8D15: 'dú',  # 贕
    0x8D16: 'shú',  # 贖
    0x8D17: 'yàn',  # 贗
    0x8D18: 'shǎng',  # 贘
    0x8D19: 'xuàn',  # 贙
    0x8D1A: 'lòng',  # 贚
    0x8D1B: 'gàn',  # 贛
    0x8D1C: 'zāng',  # 贜
    0x8D1D: 'bèi',  # 贝
    0x8D1E: 'zhēn',  # 贞
    0x8D1F: 'fù',  # 负
    0x8D20: 'yuán,yùn',  # 贠
    0x8D21: 'gòng',  # 贡
    0x8D22: 'cái',  # 财
    0x8D23: 'zé,zhài',  # 责
    0x8D24: 'xián',  # 贤
    0x8D25: 'bài',  # 败
    0x8D26: 'zhàng',  # 账
    0x8D27: 'huò',  # 货
    0x8D28: 'zhì',  # 质
    0x8D29: 'fàn',  # 贩
    0x8D2A: 'tān',  # 贪
    0x8D2B: 'pín',  # 贫
    0x8D2C: 'biǎn',  # 贬
    0x8D2D: 'gòu',  # 购
    0x8D2E: 'zhù',  # 贮
    0x8D2F: 'guàn',  # 贯
    0x8D30: 'èr',  # 贰
    0x8D31: 'jiàn',  # 贱
    0x8D32: 'bì,bēn',  # 贲
    0x8D33: 'shì',  # 贳
    0x8D34: 'tiē',  # 贴
    0x8D35: 'guì',  # 贵
    0x8D36: 'kuàng',  # 贶
    0x8D37: 'dài',  # 贷
    0x8D38: 'mào',  # 贸
    0x8D39: 'fèi',  # 费
    0x8D3A: 'hè',  # 贺
    0x8D3B: 'yí',  # 贻
    0x8D3C: 'zéi',  # 贼
    0x8D3D: 'zhì',  # 贽
    0x8D3E: 'gǔ,jiǎ',  # 贾
    0x8D3F: 'huì',  # 贿
    0x8D40: 'zī',  # 赀
    0x8D41: 'lìn',  # 赁
    0x8D42: 'lù',  # 赂
    0x8D43: 'zāng',  # 赃
    0x8D44: 'zī',  # 资
    0x8D45: 'gāi',  # 赅
    0x8D46: 'jìn',  # 赆
    0x8D47: 'qiú',  # 赇
    0x8D48: 'zhèn',  # 赈
    0x8D49: 'lài',  # 赉
    0x8D4A: 'shē',  # 赊
    0x8D4B: 'fù',  # 赋
    0x8D4C: 'dǔ',  # 赌
    0x8D4D: 'jī',  # 赍
    0x8D4E: 'shú',  # 赎
    0x8D4F: 'shǎng',  # 赏
    0x8D50: 'cì',  # 赐
    0x8D51: 'bì',  # 赑
    0x8D52: 'zhōu',  # 赒
    0x8D53: 'gēng',  # 赓
    0x8D54: 'péi',  # 赔
    0x8D55: 'dǎn',  # 赕
    0x8D56: 'lài',  # 赖
    0x8D57: 'fèng',  # 赗
    0x8D58: 'zhuì',  # 赘
    0x8D59: 'fù',  # 赙
    0x8D5A: 'zhuàn',  # 赚
    0x8D5B: 'sài',  # 赛
    0x8D5C: 'zé',  # 赜
    0x8D5D: 'yàn',  # 赝
    0x8D5E: 'zàn',  # 赞
    0x8D5F: 'yūn',  # 赟
    0x8D60: 'zèng',  # 赠
    0x8D61: 'shàn',  # 赡
    0x8D62: 'yíng',  # 赢
    0x8D63: 'gàn',  # 赣
    0x8D64: 'chì',  # 赤
    0x8D65: 'xī',  # 赥
    0x8D66: 'shè',  # 赦
    0x8D67: 'nǎn',  # 赧
    0x8D68: 'tóng',  # 赨
    0x8D69: 'xì',  # 赩
    0x8D6A: 'chēng',  # 赪
    0x8D6B: 'hè',  # 赫
    0x8D6C: 'chēng',  # 赬
    0x8D6D: 'zhě',  # 赭
    0x8D6E: 'xiá',  # 赮
    0x8D6F: 'táng',  # 赯
    0x8D70: 'zǒu',  # 走
    0x8D71: 'zǒu',  # 赱
    0x8D72: 'lì',  # 赲
    0x8D73: 'jiū',  # 赳
    0x8D74: 'fù',  # 赴
    0x8D75: 'zhào',  # 赵
    0x8D76: 'gǎn',  # 赶
    0x8D77: 'qǐ',  # 起
    0x8D78: 'shàn',  # 赸
    0x8D79: 'qióng',  # 赹
    0x8D7A: 'yǐn',  # 赺
    0x8D7B: 'xiǎn',  # 赻
    0x8D7C: 'zī',  # 赼
    0x8D7D: 'jué',  # 赽
    0x8D7E: 'qǐn',  # 赾
    0x8D7F: 'chí',  # 赿
    0x8D80: 'cī',  # 趀
    0x8D81: 'chèn',  # 趁
    0x8D82: 'chèn',  # 趂
    0x8D83: 'dié,tú',  # 趃
    0x8D84: 'qiè,jū',  # 趄
    0x8D85: 'chāo',  # 超
    0x8D86: 'dī',  # 趆
    0x8D87: 'xì',  # 趇
    0x8D88: 'zhān',  # 趈
    0x8D89: 'jué',  # 趉
    0x8D8A: 'yuè',  # 越
    0x8D8B: 'qū,cù',  # 趋
    0x8D8C: 'jí,jié',  # 趌
    0x8D8D: 'qū',  # 趍
    0x8D8E: 'chú',  # 趎
    0x8D8F: 'guā,huó',  # 趏
    0x8D90: 'xuè',  # 趐
    0x8D91: 'zī',  # 趑
    0x8D92: 'tiào',  # 趒
    0x8D93: 'duǒ',  # 趓
    0x8D94: 'liè',  # 趔
    0x8D95: 'gǎn',  # 趕
    0x8D96: 'suō',  # 趖
    0x8D97: 'cù',  # 趗
    0x8D98: 'xí',  # 趘
    0x8D99: 'zhào',  # 趙
    0x8D9A: 'sù',  # 趚
    0x8D9B: 'yǐn',  # 趛
    0x8D9C: 'jú',  # 趜
    0x8D9D: 'jiàn',  # 趝
    0x8D9E: 'què,qì,jí',  # 趞
    0x8D9F: 'tàng,tāng',  # 趟
    0x8DA0: 'chuō,zhuó',  # 趠
    0x8DA1: 'cuǐ',  # 趡
    0x8DA2: 'lù',  # 趢
    0x8DA3: 'qù,cù',  # 趣
    0x8DA4: 'dàng',  # 趤
    0x8DA5: 'qiū',  # 趥
    0x8DA6: 'zī',  # 趦
    0x8DA7: 'tí',  # 趧
    0x8DA8: 'qū,cù',  # 趨
    0x8DA9: 'chì',  # 趩
    0x8DAA: 'huáng',  # 趪
    0x8DAB: 'qiáo',  # 趫
    0x8DAC: 'qiāo',  # 趬
    0x8DAD: 'jiào',  # 趭
    0x8DAE: 'zào',  # 趮
    0x8DAF: 'tì,yuè',  # 趯
    0x8DB0: 'ěr',  # 趰
    0x8DB1: 'zǎn',  # 趱
    0x8DB2: 'zǎn',  # 趲
    0x8DB3: 'zú',  # 足
    0x8DB4: 'pā',  # 趴
    0x8DB5: 'bào,bō',  # 趵
    0x8DB6: 'kuà,wù',  # 趶
    0x8DB7: 'kē',  # 趷
    0x8DB8: 'dǔn',  # 趸
    0x8DB9: 'jué,guì',  # 趹
    0x8DBA: 'fū',  # 趺
    0x8DBB: 'chěn',  # 趻
    0x8DBC: 'jiǎn',  # 趼
    0x8DBD: 'fāng,fàng,páng',  # 趽
    0x8DBE: 'zhǐ',  # 趾
    0x8DBF: 'tā',  # 趿
    0x8DC0: 'yuè',  # 跀
    0x8DC1: 'bà,páo',  # 跁
    0x8DC2: 'qí,qǐ',  # 跂
    0x8DC3: 'yuè',  # 跃
    0x8DC4: 'qiāng,qiàng',  # 跄
    0x8DC5: 'tuò',  # 跅
    0x8DC6: 'tái',  # 跆
    0x8DC7: 'yì',  # 跇
    0x8DC8: 'jiàn,chén',  # 跈
    0x8DC9: 'líng',  # 跉
    0x8DCA: 'mèi',  # 跊
    0x8DCB: 'bá',  # 跋
    0x8DCC: 'diē',  # 跌
    0x8DCD: 'kū',  # 跍
    0x8DCE: 'tuó',  # 跎
    0x8DCF: 'jiā',  # 跏
    0x8DD0: 'cī,cǐ',  # 跐
    0x8DD1: 'pǎo,páo',  # 跑
    0x8DD2: 'qiǎ',  # 跒
    0x8DD3: 'zhù',  # 跓
    0x8DD4: 'jū',  # 跔
    0x8DD5: 'diǎn,tiē,dié',  # 跕
    0x8DD6: 'zhí',  # 跖
    0x8DD7: 'fū',  # 跗
    0x8DD8: 'pán,bàn',  # 跘
    0x8DD9: 'jū,jù,qiè',  # 跙
    0x8DDA: 'shān',  # 跚
    0x8DDB: 'bǒ',  # 跛
    0x8DDC: 'ní',  # 跜
    0x8DDD: 'jù',  # 距
    0x8DDE: 'lì,luò',  # 跞
    0x8DDF: 'gēn',  # 跟
    0x8DE0: 'yí',  # 跠
    0x8DE1: 'jì',  # 跡
    0x8DE2: 'dài,duò,duō,chí',  # 跢
    0x8DE3: 'xiǎn',  # 跣
    0x8DE4: 'jiāo',  # 跤
    0x8DE5: 'duò',  # 跥
    0x8DE6: 'zhū',  # 跦
    0x8DE7: 'quán',  # 跧
    0x8DE8: 'kuà',  # 跨
    0x8DE9: 'zhuǎi',  # 跩
    0x8DEA: 'guì',  # 跪
    0x8DEB: 'qióng',  # 跫
    0x8DEC: 'kuǐ',  # 跬
    0x8DED: 'xiáng',  # 跭
    0x8DEE: 'dié',  # 跮
    0x8DEF: 'lù',  # 路
    0x8DF0: 'pián,bèng',  # 跰
    0x8DF1: 'zhì',  # 跱
    0x8DF2: 'jié',  # 跲
    0x8DF3: 'tiào,táo',  # 跳
    0x8DF4: 'cǎi',  # 跴
    0x8DF5: 'jiàn',  # 践
    0x8DF6: 'dá',  # 跶
    0x8DF7: 'qiāo',  # 跷
    0x8DF8: 'bì',  # 跸
    0x8DF9: 'xiān',  # 跹
    0x8DFA: 'duò',  # 跺
    0x8DFB: 'jī',  # 跻
    0x8DFC: 'jú',  # 跼
    0x8DFD: 'jì',  # 跽
    0x8DFE: 'shū,chōu',  # 跾
    0x8DFF: 'tú',  # 跿
    0x8E00: 'chuò',  # 踀
    0x8E01: 'jìng',  # 踁
    0x8E02: 'niè',  # 踂
    0x8E03: 'xiāo',  # 踃
    0x8E04: 'bù',  # 踄
    0x8E05: 'xué',  # 踅
    0x8E06: 'cūn',  # 踆
    0x8E07: 'mǔ',  # 踇
    0x8E08: 'shū',  # 踈
    0x8E09: 'liáng,liàng',  # 踉
    0x8E0A: 'yǒng',  # 踊
    0x8E0B: 'jiǎo',  # 踋
    0x8E0C: 'chóu',  # 踌
    0x8E0D: 'qiāo',  # 踍
    0x8E0E: 'móu',  # 踎
    0x8E0F: 'tà',  # 踏
    0x8E10: 'jiàn',  # 踐
    0x8E11: 'jī',  # 踑
    0x8E12: 'wō',  # 踒
    0x8E13: 'wěi',  # 踓
    0x8E14: 'chuō',  # 踔
    0x8E15: 'jié',  # 踕
    0x8E16: 'jí',  # 踖
    0x8E17: 'niè',  # 踗
    0x8E18: 'jū',  # 踘
    0x8E19: 'niè',  # 踙
    0x8E1A: 'lún',  # 踚
    0x8E1B: 'lù',  # 踛
    0x8E1C: 'lèng',  # 踜
    0x8E1D: 'huái',  # 踝
    0x8E1E: 'jù',  # 踞
    0x8E1F: 'chí',  # 踟
    0x8E20: 'wǎn',  # 踠
    0x8E21: 'quán',  # 踡
    0x8E22: 'tī',  # 踢
    0x8E23: 'bó',  # 踣
    0x8E24: 'zú',  # 踤
    0x8E25: 'qiè',  # 踥
    0x8E26: 'qī',  # 踦
    0x8E27: 'cù',  # 踧
    0x8E28: 'zōng',  # 踨
    0x8E29: 'cǎi',  # 踩
    0x8E2A: 'zōng',  # 踪
    0x8E2B: 'pèng',  # 踫
    0x8E2C: 'zhì',  # 踬
    0x8E2D: 'zhēng',  # 踭
    0x8E2E: 'diǎn',  # 踮
    0x8E2F: 'zhí',  # 踯
    0x8E30: 'yú',  # 踰
    0x8E31: 'duó',  # 踱
    0x8E32: 'dùn',  # 踲
    0x8E33: 'chuǎn',  # 踳
    0x8E34: 'yǒng',  # 踴
    0x8E35: 'zhǒng',  # 踵
    0x8E36: 'dì',  # 踶
    0x8E37: 'zhě',  # 踷
    0x8E38: 'chěn',  # 踸
    0x8E39: 'chuài',  # 踹
    0x8E3A: 'jiàn',  # 踺
    0x8E3B: 'guā',  # 踻
    0x8E3C: 'táng',  # 踼
    0x8E3D: 'jǔ',  # 踽
    0x8E3E: 'fú',  # 踾
    0x8E3F: 'cù',  # 踿
    0x8E40: 'dié',  # 蹀
    0x8E41: 'pián',  # 蹁
    0x8E42: 'róu',  # 蹂
    0x8E43: 'nuò',  # 蹃
    0x8E44: 'tí',  # 蹄
    0x8E45: 'chǎ',  # 蹅
    0x8E46: 'tuǐ',  # 蹆
    0x8E47: 'jiǎn',  # 蹇
    0x8E48: 'dǎo',  # 蹈
    0x8E49: 'cuō',  # 蹉
    0x8E4A: 'qī,xī',  # 蹊
    0x8E4B: 'tà',  # 蹋
    0x8E4C: 'qiāng',  # 蹌
    0x8E4D: 'niǎn',  # 蹍
    0x8E4E: 'diān',  # 蹎
    0x8E4F: 'tí',  # 蹏
    0x8E50: 'jí',  # 蹐
    0x8E51: 'niè',  # 蹑
    0x8E52: 'pán',  # 蹒
    0x8E53: 'liū',  # 蹓
    0x8E54: 'zàn',  # 蹔
    0x8E55: 'bì',  # 蹕
    0x8E56: 'chōng',  # 蹖
    0x8E57: 'lù',  # 蹗
    0x8E58: 'liáo',  # 蹘
    0x8E59: 'cù',  # 蹙
    0x8E5A: 'tāng',  # 蹚
    0x8E5B: 'dài',  # 蹛
    0x8E5C: 'sù',  # 蹜
    0x8E5D: 'xǐ',  # 蹝
    0x8E5E: 'kuǐ',  # 蹞
    0x8E5F: 'jì',  # 蹟
    0x8E60: 'zhí',  # 蹠
    0x8E61: 'qiāng',  # 蹡
    0x8E62: 'dí',  # 蹢
    0x8E63: 'pán',  # 蹣
    0x8E64: 'zōng',  # 蹤
    0x8E65: 'lián',  # 蹥
    0x8E66: 'bèng',  # 蹦
    0x8E67: 'zāo',  # 蹧
    0x8E68: 'niǎn',  # 蹨
    0x8E69: 'bié',  # 蹩
    0x8E6A: 'tuí',  # 蹪
    0x8E6B: 'jú',  # 蹫
    0x8E6C: 'dēng',  # 蹬
    0x8E6D: 'cèng',  # 蹭
    0x8E6E: 'xiān',  # 蹮
    0x8E6F: 'fán',  # 蹯
    0x8E70: 'chú',  # 蹰
    0x8E71: 'zhōng',  # 蹱
    0x8E72: 'dūn',  # 蹲
    0x8E73: 'bō',  # 蹳
    0x8E74: 'cù',  # 蹴
    0x8E75: 'cù',  # 蹵
    0x8E76: 'jué,juě',  # 蹶
    0x8E77: 'jué',  # 蹷
    0x8E78: 'lìn',  # 蹸
    0x8E79: 'tà',  # 蹹
    0x8E7A: 'qiāo',  # 蹺
    0x8E7B: 'qiāo',  # 蹻
    0x8E7C: 'pǔ',  # 蹼
    0x8E7D: 'liāo',  # 蹽
    0x8E7E: 'dūn',  # 蹾
    0x8E7F: 'cuān',  # 蹿
    0x8E80: 'guàn',  # 躀
    0x8E81: 'zào',  # 躁
    0x8E82: 'tà',  # 躂
    0x8E83: 'bì',  # 躃
    0x8E84: 'bì',  # 躄
    0x8E85: 'zhú',  # 躅
    0x8E86: 'jù',  # 躆
    0x8E87: 'chú',  # 躇
    0x8E88: 'qiào',  # 躈
    0x8E89: 'dǔn',  # 躉
    0x8E8A: 'chóu',  # 躊
    0x8E8B: 'jī',  # 躋
    0x8E8C: 'wǔ',  # 躌
    0x8E8D: 'yuè',  # 躍
    0x8E8E: 'niǎn',  # 躎
    0x8E8F: 'lìn',  # 躏
    0x8E90: 'liè',  # 躐
    0x8E91: 'zhí',  # 躑
    0x8E92: 'lì,luò',  # 躒
    0x8E93: 'zhì',  # 躓
    0x8E94: 'chán',  # 躔
    0x8E95: 'chú',  # 躕
    0x8E96: 'duàn',  # 躖
    0x8E97: 'wèi',  # 躗
    0x8E98: 'lóng,lǒng',  # 躘
    0x8E99: 'lìn',  # 躙
    0x8E9A: 'xiān',  # 躚
    0x8E9B: 'wèi',  # 躛
    0x8E9C: 'zuān',  # 躜
    0x8E9D: 'lán',  # 躝
    0x8E9E: 'xiè',  # 躞
    0x8E9F: 'ráng',  # 躟
    0x8EA0: 'sǎ,xiè',  # 躠
    0x8EA1: 'niè',  # 躡
    0x8EA2: 'tà',  # 躢
    0x8EA3: 'qú',  # 躣
    0x8EA4: 'jí',  # 躤
    0x8EA5: 'cuān',  # 躥
    0x8EA6: 'zuān',  # 躦
    0x8EA7: 'xǐ',  # 躧
    0x8EA8: 'kuí',  # 躨
    0x8EA9: 'jué',  # 躩
    0x8EAA: 'lìn',  # 躪
    0x8EAB: 'shēn',  # 身
    0x8EAC: 'gōng',  # 躬
    0x8EAD: 'dān',  # 躭
    0x8EAE: 'fēn',  # 躮
    0x8EAF: 'qū',  # 躯
    0x8EB0: 'tǐ',  # 躰
    0x8EB1: 'duǒ',  # 躱
    0x8EB2: 'duǒ',  # 躲
    0x8EB3: 'gōng',  # 躳
    0x8EB4: 'láng',  # 躴
    0x8EB5: 'rěn',  # 躵
    0x8EB6: 'luǒ',  # 躶
    0x8EB7: 'ǎi',  # 躷
    0x8EB8: 'jī',  # 躸
    0x8EB9: 'jū',  # 躹
    0x8EBA: 'tǎng',  # 躺
    0x8EBB: 'kōng',  # 躻
    0x8EBC: 'lào',  # 躼
    0x8EBD: 'yǎn',  # 躽
    0x8EBE: 'měi',  # 躾
    0x8EBF: 'kāng',  # 躿
    0x8EC0: 'qū',  # 軀
    0x8EC1: 'lóu',  # 軁
    0x8EC2: 'lào',  # 軂
    0x8EC3: 'duǒ',  # 軃
    0x8EC4: 'zhí',  # 軄
    0x8EC5: 'yàn',  # 軅
    0x8EC6: 'tǐ',  # 軆
    0x8EC7: 'dào',  # 軇
    0x8EC8: 'yīng',  # 軈
    0x8EC9: 'yù',  # 軉
    0x8ECA: 'chē,jū',  # 車
    0x8ECB: 'yà,zhá,gá',  # 軋
    0x8ECC: 'guǐ',  # 軌
    0x8ECD: 'jūn',  # 軍
    0x8ECE: 'wèi',  # 軎
    0x8ECF: 'yuè',  # 軏
    0x8ED0: 'xìn,xiàn',  # 軐
    0x8ED1: 'dài',  # 軑
    0x8ED2: 'xuān',  # 軒
    0x8ED3: 'fàn,guǐ',  # 軓
    0x8ED4: 'rèn',  # 軔
    0x8ED5: 'shān',  # 軕
    0x8ED6: 'kuáng',  # 軖
    0x8ED7: 'shū',  # 軗
    0x8ED8: 'tún',  # 軘
    0x8ED9: 'chén',  # 軙
    0x8EDA: 'dài',  # 軚
    0x8EDB: 'è',  # 軛
    0x8EDC: 'nà',  # 軜
    0x8EDD: 'qí',  # 軝
    0x8EDE: 'máo',  # 軞
    0x8EDF: 'ruǎn',  # 軟
    0x8EE0: 'kuáng',  # 軠
    0x8EE1: 'qián',  # 軡
    0x8EE2: 'zhuàn,zhuǎn',  # 転
    0x8EE3: 'hōng',  # 軣
    0x8EE4: 'hū',  # 軤
    0x8EE5: 'qú',  # 軥
    0x8EE6: 'kuàng',  # 軦
    0x8EE7: 'dǐ',  # 軧
    0x8EE8: 'líng',  # 軨
    0x8EE9: 'dài',  # 軩
    0x8EEA: 'āo,ào',  # 軪
    0x8EEB: 'zhěn',  # 軫
    0x8EEC: 'fàn',  # 軬
    0x8EED: 'kuāng',  # 軭
    0x8EEE: 'yǎng',  # 軮
    0x8EEF: 'pēng',  # 軯
    0x8EF0: 'bèi',  # 軰
    0x8EF1: 'gū',  # 軱
    0x8EF2: 'gū',  # 軲
    0x8EF3: 'páo',  # 軳
    0x8EF4: 'zhù',  # 軴
    0x8EF5: 'rǒng',  # 軵
    0x8EF6: 'è',  # 軶
    0x8EF7: 'bá',  # 軷
    0x8EF8: 'zhóu,zhòu',  # 軸
    0x8EF9: 'zhǐ',  # 軹
    0x8EFA: 'yáo',  # 軺
    0x8EFB: 'kē,kě',  # 軻
    0x8EFC: 'yì,dié',  # 軼
    0x8EFD: 'qīng',  # 軽
    0x8EFE: 'shì',  # 軾
    0x8EFF: 'píng',  # 軿
    0x8F00: 'ér',  # 輀
    0x8F01: 'gǒng',  # 輁
    0x8F02: 'jú',  # 輂
    0x8F03: 'jiào',  # 較
    0x8F04: 'guāng',  # 輄
    0x8F05: 'lù',  # 輅
    0x8F06: 'kǎi',  # 輆
    0x8F07: 'quán',  # 輇
    0x8F08: 'zhōu',  # 輈
    0x8F09: 'zài',  # 載
    0x8F0A: 'zhì',  # 輊
    0x8F0B: 'shē',  # 輋
    0x8F0C: 'liàng',  # 輌
    0x8F0D: 'yù',  # 輍
    0x8F0E: 'shāo',  # 輎
    0x8F0F: 'yóu',  # 輏
    0x8F10: 'wàn',  # 輐
    0x8F11: 'yǐn',  # 輑
    0x8F12: 'zhé',  # 輒
    0x8F13: 'wǎn',  # 輓
    0x8F14: 'fǔ',  # 輔
    0x8F15: 'qīng',  # 輕
    0x8F16: 'zhōu',  # 輖
    0x8F17: 'ní',  # 輗
    0x8F18: 'líng',  # 輘
    0x8F19: 'zhé',  # 輙
    0x8F1A: 'hàn',  # 輚
    0x8F1B: 'liàng',  # 輛
    0x8F1C: 'zī',  # 輜
    0x8F1D: 'huī',  # 輝
    0x8F1E: 'wǎng',  # 輞
    0x8F1F: 'chuò',  # 輟
    0x8F20: 'guǒ',  # 輠
    0x8F21: 'kǎn',  # 輡
    0x8F22: 'yǐ',  # 輢
    0x8F23: 'péng',  # 輣
    0x8F24: 'qiàn',  # 輤
    0x8F25: 'gǔn',  # 輥
    0x8F26: 'niǎn',  # 輦
    0x8F27: 'píng',  # 輧
    0x8F28: 'guǎn',  # 輨
    0x8F29: 'bèi',  # 輩
    0x8F2A: 'lún',  # 輪
    0x8F2B: 'pái',  # 輫
    0x8F2C: 'liáng',  # 輬
    0x8F2D: 'ruǎn',  # 輭
    0x8F2E: 'róu',  # 輮
    0x8F2F: 'jí',  # 輯
    0x8F30: 'yáng',  # 輰
    0x8F31: 'xián',  # 輱
    0x8F32: 'chuán',  # 輲
    0x8F33: 'còu',  # 輳
    0x8F34: 'chūn',  # 輴
    0x8F35: 'gé',  # 輵
    0x8F36: 'yóu',  # 輶
    0x8F37: 'hōng',  # 輷
    0x8F38: 'shū',  # 輸
    0x8F39: 'fù',  # 輹
    0x8F3A: 'zī',  # 輺
    0x8F3B: 'fú',  # 輻
    0x8F3C: 'wēn',  # 輼
    0x8F3D: 'fàn',  # 輽
    0x8F3E: 'zhǎn',  # 輾
    0x8F3F: 'yú',  # 輿
    0x8F40: 'wēn',  # 轀
    0x8F41: 'tāo',  # 轁
    0x8F42: 'gǔ',  # 轂
    0x8F43: 'zhēn',  # 轃
    0x8F44: 'xiá',  # 轄
    0x8F45: 'yuán',  # 轅
    0x8F46: 'lù',  # 轆
    0x8F47: 'jiāo',  # 轇
    0x8F48: 'cháo',  # 轈
    0x8F49: 'zhuǎn',  # 轉
    0x8F4A: 'wèi',  # 轊
    0x8F4B: 'hūn',  # 轋
    0x8F4C: 'xuě',  # 轌
    0x8F4D: 'zhé',  # 轍
    0x8F4E: 'jiào',  # 轎
    0x8F4F: 'zhàn',  # 轏
    0x8F50: 'bú',  # 轐
    0x8F51: 'lǎo',  # 轑
    0x8F52: 'fén',  # 轒
    0x8F53: 'fān',  # 轓
    0x8F54: 'lín',  # 轔
    0x8F55: 'gé',  # 轕
    0x8F56: 'sè',  # 轖
    0x8F57: 'kǎn',  # 轗
    0x8F58: 'huàn',  # 轘
    0x8F59: 'yǐ',  # 轙
    0x8F5A: 'jí',  # 轚
    0x8F5B: 'duì',  # 轛
    0x8F5C: 'ér',  # 轜
    0x8F5D: 'yú',  # 轝
    0x8F5E: 'jiàn',  # 轞
    0x8F5F: 'hōng',  # 轟
    0x8F60: 'léi',  # 轠
    0x8F61: 'pèi',  # 轡
    0x8F62: 'lì',  # 轢
    0x8F63: 'lì',  # 轣
    0x8F64: 'lú',  # 轤
    0x8F65: 'lìn',  # 轥
    0x8F66: 'chē,jū',  # 车
    0x8F67: 'yà',  # 轧
    0x8F68: 'guǐ',  # 轨
    0x8F69: 'xuān',  # 轩
    0x8F6A: 'dài',  # 轪
    0x8F6B: 'rèn',  # 轫
    0x8F6C: 'zhuǎn,zhuàn,zhuǎi',  # 转
    0x8F6D: 'è',  # 轭
    0x8F6E: 'lún',  # 轮
    0x8F6F: 'ruǎn',  # 软
    0x8F70: 'hōng',  # 轰
    0x8F71: 'gū',  # 轱
    0x8F72: 'kē',  # 轲
    0x8F73: 'lú',  # 轳
    0x8F74: 'zhóu,zhòu',  # 轴
    0x8F75: 'zhǐ',  # 轵
    0x8F76: 'yì',  # 轶
    0x8F77: 'hū',  # 轷
    0x8F78: 'zhěn',  # 轸
    0x8F79: 'lì',  # 轹
    0x8F7A: 'yáo',  # 轺
    0x8F7B: 'qīng',  # 轻
    0x8F7C: 'shì',  # 轼
    0x8F7D: 'zǎi,zài',  # 载
    0x8F7E: 'zhì',  # 轾
    0x8F7F: 'jiào',  # 轿
    0x8F80: 'zhōu',  # 辀
    0x8F81: 'quán',  # 辁
    0x8F82: 'lù',  # 辂
    0x8F83: 'jiào',  # 较
    0x8F84: 'zhé',  # 辄
    0x8F85: 'fǔ',  # 辅
    0x8F86: 'liàng',  # 辆
    0x8F87: 'niǎn',  # 辇
    0x8F88: 'bèi',  # 辈
    0x8F89: 'huī',  # 辉
    0x8F8A: 'gǔn',  # 辊
    0x8F8B: 'wǎng',  # 辋
    0x8F8C: 'liáng',  # 辌
    0x8F8D: 'chuò',  # 辍
    0x8F8E: 'zī',  # 辎
    0x8F8F: 'còu',  # 辏
    0x8F90: 'fú',  # 辐
    0x8F91: 'jí',  # 辑
    0x8F92: 'wēn',  # 辒
    0x8F93: 'shū',  # 输
    0x8F94: 'pèi',  # 辔
    0x8F95: 'yuán',  # 辕
    0x8F96: 'xiá',  # 辖
    0x8F97: 'zhǎn,niǎn',  # 辗
    0x8F98: 'lù',  # 辘
    0x8F99: 'zhé',  # 辙
    0x8F9A: 'lín',  # 辚
    0x8F9B: 'xīn',  # 辛
    0x8F9C: 'gū',  # 辜
    0x8F9D: 'cí',  # 辝
    0x8F9E: 'cí',  # 辞
    0x8F9F: 'bì,pì',  # 辟
    0x8FA0: 'zuì',  # 辠
    0x8FA1: 'biàn',  # 辡
    0x8FA2: 'là',  # 辢
    0x8FA3: 'là',  # 辣
    0x8FA4: 'cí',  # 辤
    0x8FA5: 'xuē',  # 辥
    0x8FA6: 'bàn',  # 辦
    0x8FA7: 'biàn',  # 辧
    0x8FA8: 'biàn',  # 辨
    0x8FA9: 'biàn',  # 辩
    0x8FAA: 'xuē',  # 辪
    0x8FAB: 'biàn',  # 辫
    0x8FAC: 'bān',  # 辬
    0x8FAD: 'cí',  # 辭
    0x8FAE: 'biàn',  # 辮
    0x8FAF: 'biàn',  # 辯
    0x8FB0: 'chén',  # 辰
    0x8FB1: 'rǔ',  # 辱
    0x8FB2: 'nóng',  # 農
    0x8FB3: 'nóng',  # 辳
    0x8FB4: 'zhěn',  # 辴
    0x8FB5: 'chuò',  # 辵
    0x8FB6: 'chuò',  # 辶
    0x8FB7: 'yī',  # 辷
    0x8FB8: 'réng',  # 辸
    0x8FB9: 'biān',  # 边
    0x8FBA: 'dào,biān',  # 辺
    0x8FBB: 'shi',  # 辻
    0x8FBC: 'yū',  # 込
    0x8FBD: 'liáo',  # 辽
    0x8FBE: 'dá',  # 达
    0x8FBF: 'chān',  # 辿
    0x8FC0: 'gān',  # 迀
    0x8FC1: 'qiān',  # 迁
    0x8FC2: 'yū',  # 迂
    0x8FC3: 'yū',  # 迃
    0x8FC4: 'qì',  # 迄
    0x8FC5: 'xùn',  # 迅
    0x8FC6: 'yǐ,yí',  # 迆
    0x8FC7: 'guò,guo,guō',  # 过
    0x8FC8: 'mài',  # 迈
    0x8FC9: 'qī',  # 迉
    0x8FCA: 'zā',  # 迊
    0x8FCB: 'wàng,kuāng',  # 迋
    0x8FCC: 'tù',  # 迌
    0x8FCD: 'zhūn',  # 迍
    0x8FCE: 'yíng',  # 迎
    0x8FCF: 'dá',  # 迏
    0x8FD0: 'yùn',  # 运
    0x8FD1: 'jìn',  # 近
    0x8FD2: 'háng',  # 迒
    0x8FD3: 'yà',  # 迓
    0x8FD4: 'fǎn',  # 返
    0x8FD5: 'wǔ',  # 迕
    0x8FD6: 'dá',  # 迖
    0x8FD7: 'é',  # 迗
    0x8FD8: 'huán,hái',  # 还
    0x8FD9: 'zhè,zhèi',  # 这
    0x8FDA: 'dá',  # 迚
    0x8FDB: 'jìn',  # 进
    0x8FDC: 'yuǎn,yuàn',  # 远
    0x8FDD: 'wéi',  # 违
    0x8FDE: 'lián',  # 连
    0x8FDF: 'chí',  # 迟
    0x8FE0: 'chè',  # 迠
    0x8FE1: 'chí',  # 迡
    0x8FE2: 'tiáo',  # 迢
    0x8FE3: 'zhì,lì',  # 迣
    0x8FE4: 'yǐ,yí',  # 迤
    0x8FE5: 'jiǒng',  # 迥
    0x8FE6: 'jiā',  # 迦
    0x8FE7: 'chén',  # 迧
    0x8FE8: 'dài',  # 迨
    0x8FE9: 'ěr',  # 迩
    0x8FEA: 'dí',  # 迪
    0x8FEB: 'pò,pǎi',  # 迫
    0x8FEC: 'zhù,wǎng',  # 迬
    0x8FED: 'dié',  # 迭
    0x8FEE: 'zé',  # 迮
    0x8FEF: 'táo',  # 迯
    0x8FF0: 'shù',  # 述
    0x8FF1: 'yǐ,yí',  # 迱
    0x8FF2: 'keop',  # 迲
    0x8FF3: 'jìng',  # 迳
    0x8FF4: 'huí',  # 迴
    0x8FF5: 'dòng',  # 迵
    0x8FF6: 'yòu',  # 迶
    0x8FF7: 'mí',  # 迷
    0x8FF8: 'bèng',  # 迸
    0x8FF9: 'jì',  # 迹
    0x8FFA: 'nǎi',  # 迺
    0x8FFB: 'yí',  # 迻
    0x8FFC: 'jié',  # 迼
    0x8FFD: 'zhuī,duī',  # 追
    0x8FFE: 'liè',  # 迾
    0x8FFF: 'xùn',  # 迿
    0x9000: 'tuì',  # 退
    0x9001: 'sòng',  # 送
    0x9002: 'shì',  # 适
    0x9003: 'táo',  # 逃
    0x9004: 'páng',  # 逄
    0x9005: 'hòu',  # 逅
    0x9006: 'nì',  # 逆
    0x9007: 'dùn',  # 逇
    0x9008: 'jiǒng',  # 逈
    0x9009: 'xuǎn',  # 选
    0x900A: 'xùn',  # 逊
    0x900B: 'bū',  # 逋
    0x900C: 'yōu',  # 逌
    0x900D: 'xiāo',  # 逍
    0x900E: 'qiú',  # 逎
    0x900F: 'tòu',  # 透
    0x9010: 'zhú',  # 逐
    0x9011: 'qiú',  # 逑
    0x9012: 'dì',  # 递
    0x9013: 'dì',  # 逓
    0x9014: 'tú',  # 途
    0x9015: 'jìng',  # 逕
    0x9016: 'tì',  # 逖
    0x9017: 'dòu',  # 逗
    0x9018: 'yǐ',  # 逘
    0x9019: 'zhè',  # 這
    0x901A: 'tōng',  # 通
    0x901B: 'guàng',  # 逛
    0x901C: 'wǔ',  # 逜
    0x901D: 'shì',  # 逝
    0x901E: 'chěng',  # 逞
    0x901F: 'sù',  # 速
    0x9020: 'zào',  # 造
    0x9021: 'qūn',  # 逡
    0x9022: 'féng',  # 逢
    0x9023: 'lián',  # 連
    0x9024: 'suò',  # 逤
    0x9025: 'huí',  # 逥
    0x9026: 'lǐ',  # 逦
    0x9027: 'gǔ',  # 逧
    0x9028: 'lái',  # 逨
    0x9029: 'bèn',  # 逩
    0x902A: 'cuò',  # 逪
    0x902B: 'zhú',  # 逫
    0x902C: 'bèng',  # 逬
    0x902D: 'huàn',  # 逭
    0x902E: 'dài',  # 逮
    0x902F: 'lù',  # 逯
    0x9030: 'yóu',  # 逰
    0x9031: 'zhōu',  # 週
    0x9032: 'jìn',  # 進
    0x9033: 'yù',  # 逳
    0x9034: 'chuō',  # 逴
    0x9035: 'kuí',  # 逵
    0x9036: 'wēi',  # 逶
    0x9037: 'tì',  # 逷
    0x9038: 'yì',  # 逸
    0x9039: 'dá',  # 逹
    0x903A: 'yuǎn',  # 逺
    0x903B: 'luó',  # 逻
    0x903C: 'bī',  # 逼
    0x903D: 'nuò',  # 逽
    0x903E: 'yú',  # 逾
    0x903F: 'dàng',  # 逿
    0x9040: 'suí',  # 遀
    0x9041: 'dùn',  # 遁
    0x9042: 'suì',  # 遂
    0x9043: 'yǎn',  # 遃
    0x9044: 'chuán',  # 遄
    0x9045: 'chí',  # 遅
    0x9046: 'dì,tí',  # 遆
    0x9047: 'yù',  # 遇
    0x9048: 'shí',  # 遈
    0x9049: 'zhēn',  # 遉
    0x904A: 'yóu',  # 遊
    0x904B: 'yùn',  # 運
    0x904C: 'è',  # 遌
    0x904D: 'biàn',  # 遍
    0x904E: 'guò',  # 過
    0x904F: 'è',  # 遏
    0x9050: 'xiá',  # 遐
    0x9051: 'huáng',  # 遑
    0x9052: 'qiú',  # 遒
    0x9053: 'dào',  # 道
    0x9054: 'dá',  # 達
    0x9055: 'wéi',  # 違
    0x9056: 'nán',  # 遖
    0x9057: 'yí',  # 遗
    0x9058: 'gòu',  # 遘
    0x9059: 'yáo',  # 遙
    0x905A: 'chòu',  # 遚
    0x905B: 'liù',  # 遛
    0x905C: 'xùn',  # 遜
    0x905D: 'tà',  # 遝
    0x905E: 'dì',  # 遞
    0x905F: 'chí',  # 遟
    0x9060: 'yuǎn',  # 遠
    0x9061: 'sù',  # 遡
    0x9062: 'tà',  # 遢
    0x9063: 'qiǎn',  # 遣
    0x9064: 'mǎ',  # 遤
    0x9065: 'yáo',  # 遥
    0x9066: 'guàn',  # 遦
    0x9067: 'zhāng',  # 遧
    0x9068: 'áo',  # 遨
    0x9069: 'shì',  # 適
    0x906A: 'cà',  # 遪
    0x906B: 'chì',  # 遫
    0x906C: 'sù',  # 遬
    0x906D: 'zāo',  # 遭
    0x906E: 'zhē',  # 遮
    0x906F: 'dùn',  # 遯
    0x9070: 'dì',  # 遰
    0x9071: 'lóu',  # 遱
    0x9072: 'chí',  # 遲
    0x9073: 'cuō',  # 遳
    0x9074: 'lín',  # 遴
    0x9075: 'zūn',  # 遵
    0x9076: 'rào',  # 遶
    0x9077: 'qiān',  # 遷
    0x9078: 'xuǎn',  # 選
    0x9079: 'yù',  # 遹
    0x907A: 'yí',  # 遺
    0x907B: 'è',  # 遻
    0x907C: 'liáo',  # 遼
    0x907D: 'jù',  # 遽
    0x907E: 'shì',  # 遾
    0x907F: 'bì',  # 避
    0x9080: 'yāo',  # 邀
    0x9081: 'mài',  # 邁
    0x9082: 'xiè',  # 邂
    0x9083: 'suì',  # 邃
    0x9084: 'huán,hái',  # 還
    0x9085: 'zhān',  # 邅
    0x9086: 'téng',  # 邆
    0x9087: 'ěr',  # 邇
    0x9088: 'miǎo',  # 邈
    0x9089: 'biān',  # 邉
    0x908A: 'biān',  # 邊
    0x908B: 'lā',  # 邋
    0x908C: 'lí,chí',  # 邌
    0x908D: 'yuán',  # 邍
    0x908E: 'yáo',  # 邎
    0x908F: 'luó',  # 邏
    0x9090: 'lǐ',  # 邐
    0x9091: 'yì',  # 邑
    0x9092: 'tíng',  # 邒
    0x9093: 'dèng',  # 邓
    0x9094: 'qǐ',  # 邔
    0x9095: 'yōng',  # 邕
    0x9096: 'shān',  # 邖
    0x9097: 'hán',  # 邗
    0x9098: 'yú',  # 邘
    0x9099: 'máng',  # 邙
    0x909A: 'rú',  # 邚
    0x909B: 'qióng',  # 邛
    0x909C: 'xī',  # 邜
    0x909D: 'kuàng',  # 邝
    0x909E: 'fū',  # 邞
    0x909F: 'kàng,háng',  # 邟
    0x90A0: 'bīn',  # 邠
    0x90A1: 'fāng',  # 邡
    0x90A2: 'xíng',  # 邢
    0x90A3: 'nà,nǎ,nèi,nā',  # 那
    0x90A4: 'xīn',  # 邤
    0x90A5: 'shěn',  # 邥
    0x90A6: 'bāng',  # 邦
    0x90A7: 'yuán',  # 邧
    0x90A8: 'cūn',  # 邨
    0x90A9: 'huǒ',  # 邩
    0x90AA: 'xié,yá,yé,yú,xú',  # 邪
    0x90AB: 'bāng',  # 邫
    0x90AC: 'wū',  # 邬
    0x90AD: 'jù',  # 邭
    0x90AE: 'yóu',  # 邮
    0x90AF: 'hán',  # 邯
    0x90B0: 'tái',  # 邰
    0x90B1: 'qiū',  # 邱
    0x90B2: 'bì',  # 邲
    0x90B3: 'pī',  # 邳
    0x90B4: 'bǐng',  # 邴
    0x90B5: 'shào',  # 邵
    0x90B6: 'bèi',  # 邶
    0x90B7: 'wǎ',  # 邷
    0x90B8: 'dǐ',  # 邸
    0x90B9: 'zōu',  # 邹
    0x90BA: 'yè',  # 邺
    0x90BB: 'lín',  # 邻
    0x90BC: 'kuāng',  # 邼
    0x90BD: 'guī',  # 邽
    0x90BE: 'zhū',  # 邾
    0x90BF: 'shī',  # 邿
    0x90C0: 'kū',  # 郀
    0x90C1: 'yù',  # 郁
    0x90C2: 'gāi,hái',  # 郂
    0x90C3: 'hé',  # 郃
    0x90C4: 'qiè,xì',  # 郄
    0x90C5: 'zhì',  # 郅
    0x90C6: 'jí',  # 郆
    0x90C7: 'xún,huán',  # 郇
    0x90C8: 'hòu',  # 郈
    0x90C9: 'xíng',  # 郉
    0x90CA: 'jiāo',  # 郊
    0x90CB: 'xí',  # 郋
    0x90CC: 'guī',  # 郌
    0x90CD: 'nà',  # 郍
    0x90CE: 'láng,làng',  # 郎
    0x90CF: 'jiá',  # 郏
    0x90D0: 'kuài',  # 郐
    0x90D1: 'zhèng',  # 郑
    0x90D2: 'láng',  # 郒
    0x90D3: 'yùn',  # 郓
    0x90D4: 'yán',  # 郔
    0x90D5: 'chéng',  # 郕
    0x90D6: 'dòu',  # 郖
    0x90D7: 'xī',  # 郗
    0x90D8: 'lǚ',  # 郘
    0x90D9: 'fǔ',  # 郙
    0x90DA: 'wú',  # 郚
    0x90DB: 'fú',  # 郛
    0x90DC: 'gào',  # 郜
    0x90DD: 'hǎo',  # 郝
    0x90DE: 'láng',  # 郞
    0x90DF: 'jiá',  # 郟
    0x90E0: 'gěng',  # 郠
    0x90E1: 'jùn',  # 郡
    0x90E2: 'yǐng',  # 郢
    0x90E3: 'bó',  # 郣
    0x90E4: 'xì',  # 郤
    0x90E5: 'bèi',  # 郥
    0x90E6: 'lì,zhí',  # 郦
    0x90E7: 'yún',  # 郧
    0x90E8: 'bù',  # 部
    0x90E9: 'xiáo,ǎo',  # 郩
    0x90EA: 'qī',  # 郪
    0x90EB: 'pí',  # 郫
    0x90EC: 'qīng',  # 郬
    0x90ED: 'guō',  # 郭
    0x90EE: 'zhōu',  # 郮
    0x90EF: 'tán',  # 郯
    0x90F0: 'zōu',  # 郰
    0x90F1: 'píng',  # 郱
    0x90F2: 'lái',  # 郲
    0x90F3: 'ní',  # 郳
    0x90F4: 'chēn',  # 郴
    0x90F5: 'yóu',  # 郵
    0x90F6: 'bù',  # 郶
    0x90F7: 'xiāng',  # 郷
    0x90F8: 'dān',  # 郸
    0x90F9: 'jú',  # 郹
    0x90FA: 'yōng',  # 郺
    0x90FB: 'qiāo',  # 郻
    0x90FC: 'yī',  # 郼
    0x90FD: 'dū,dōu',  # 都
    0x90FE: 'yǎn',  # 郾
    0x90FF: 'méi',  # 郿
    0x9100: 'ruò',  # 鄀
    0x9101: 'bèi',  # 鄁
    0x9102: 'è',  # 鄂
    0x9103: 'shū',  # 鄃
    0x9104: 'juàn',  # 鄄
    0x9105: 'yǔ',  # 鄅
    0x9106: 'yùn',  # 鄆
    0x9107: 'hóu',  # 鄇
    0x9108: 'kuí',  # 鄈
    0x9109: 'xiāng',  # 鄉
    0x910A: 'xiāng',  # 鄊
    0x910B: 'sōu',  # 鄋
    0x910C: 'táng',  # 鄌
    0x910D: 'míng',  # 鄍
    0x910E: 'xī',  # 鄎
    0x910F: 'rǔ',  # 鄏
    0x9110: 'chù',  # 鄐
    0x9111: 'zī',  # 鄑
    0x9112: 'zōu',  # 鄒
    0x9113: 'yì',  # 鄓
    0x9114: 'wū',  # 鄔
    0x9115: 'xiāng',  # 鄕
    0x9116: 'yún',  # 鄖
    0x9117: 'hào',  # 鄗
    0x9118: 'yōng',  # 鄘
    0x9119: 'bǐ',  # 鄙
    0x911A: 'mào',  # 鄚
    0x911B: 'cháo',  # 鄛
    0x911C: 'fū',  # 鄜
    0x911D: 'liǎo',  # 鄝
    0x911E: 'yín',  # 鄞
    0x911F: 'zhuān',  # 鄟
    0x9120: 'hù',  # 鄠
    0x9121: 'qiāo',  # 鄡
    0x9122: 'yān',  # 鄢
    0x9123: 'zhāng',  # 鄣
    0x9124: 'màn',  # 鄤
    0x9125: 'qiāo',  # 鄥
    0x9126: 'xǔ',  # 鄦
    0x9127: 'dèng',  # 鄧
    0x9128: 'bì',  # 鄨
    0x9129: 'xún',  # 鄩
    0x912A: 'bì',  # 鄪
    0x912B: 'zēng',  # 鄫
    0x912C: 'wéi',  # 鄬
    0x912D: 'zhèng',  # 鄭
    0x912E: 'mào',  # 鄮
    0x912F: 'shàn',  # 鄯
    0x9130: 'lín',  # 鄰
    0x9131: 'pó',  # 鄱
    0x9132: 'dān',  # 鄲
    0x9133: 'méng',  # 鄳
    0x9134: 'yè',  # 鄴
    0x9135: 'cào',  # 鄵
    0x9136: 'kuài',  # 鄶
    0x9137: 'fēng',  # 鄷
    0x9138: 'méng',  # 鄸
    0x9139: 'zōu',  # 鄹
    0x913A: 'kuàng',  # 鄺
    0x913B: 'liǎn',  # 鄻
    0x913C: 'zàn',  # 鄼
    0x913D: 'chán',  # 鄽
    0x913E: 'yōu',  # 鄾
    0x913F: 'qí',  # 鄿
    0x9140: 'yàn',  # 酀
    0x9141: 'chán',  # 酁
    0x9142: 'cuó,zàn',  # 酂
    0x9143: 'líng',  # 酃
    0x9144: 'huān',  # 酄
    0x9145: 'xī',  # 酅
    0x9146: 'fēng',  # 酆
    0x9147: 'cuó,zàn',  # 酇
    0x9148: 'lì',  # 酈
    0x9149: 'yǒu',  # 酉
    0x914A: 'dīng,dǐng',  # 酊
    0x914B: 'qiú',  # 酋
    0x914C: 'zhuó',  # 酌
    0x914D: 'pèi',  # 配
    0x914E: 'zhòu',  # 酎
    0x914F: 'yǐ',  # 酏
    0x9150: 'gān',  # 酐
    0x9151: 'yú',  # 酑
    0x9152: 'jiǔ',  # 酒
    0x9153: 'yǎn',  # 酓
    0x9154: 'zuì',  # 酔
    0x9155: 'máo',  # 酕
    0x9156: 'dān',  # 酖
    0x9157: 'xù',  # 酗
    0x9158: 'dòu',  # 酘
    0x9159: 'zhēn',  # 酙
    0x915A: 'fēn',  # 酚
    0x915B: 'yuán',  # 酛
    0x915C: 'fū',  # 酜
    0x915D: 'yùn',  # 酝
    0x915E: 'tài',  # 酞
    0x915F: 'tiān',  # 酟
    0x9160: 'qiǎ',  # 酠
    0x9161: 'tuó',  # 酡
    0x9162: 'zuò',  # 酢
    0x9163: 'hān',  # 酣
    0x9164: 'gū',  # 酤
    0x9165: 'sū',  # 酥
    0x9166: 'pō',  # 酦
    0x9167: 'chóu',  # 酧
    0x9168: 'zài',  # 酨
    0x9169: 'mǐng',  # 酩
    0x916A: 'lào',  # 酪
    0x916B: 'chuò',  # 酫
    0x916C: 'chóu',  # 酬
    0x916D: 'yòu',  # 酭
    0x916E: 'tóng',  # 酮
    0x916F: 'zhǐ',  # 酯
    0x9170: 'xiān',  # 酰
    0x9171: 'jiàng',  # 酱
    0x9172: 'chéng',  # 酲
    0x9173: 'yìn',  # 酳
    0x9174: 'tú',  # 酴
    0x9175: 'jiào',  # 酵
    0x9176: 'méi',  # 酶
    0x9177: 'kù',  # 酷
    0x9178: 'suān',  # 酸
    0x9179: 'lèi',  # 酹
    0x917A: 'pú',  # 酺
    0x917B: 'zuì',  # 酻
    0x917C: 'hǎi',  # 酼
    0x917D: 'yàn',  # 酽
    0x917E: 'shī',  # 酾
    0x917F: 'niàng',  # 酿
    0x9180: 'wéi',  # 醀
    0x9181: 'lù',  # 醁
    0x9182: 'lǎn',  # 醂
    0x9183: 'yān',  # 醃
    0x9184: 'táo',  # 醄
    0x9185: 'pēi',  # 醅
    0x9186: 'zhǎn',  # 醆
    0x9187: 'chún',  # 醇
    0x9188: 'tán,dàn',  # 醈
    0x9189: 'zuì',  # 醉
    0x918A: 'zhuì',  # 醊
    0x918B: 'cù',  # 醋
    0x918C: 'kūn',  # 醌
    0x918D: 'tí,tǐ',  # 醍
    0x918E: 'xián',  # 醎
    0x918F: 'dū',  # 醏
    0x9190: 'hú',  # 醐
    0x9191: 'xǔ',  # 醑
    0x9192: 'xǐng',  # 醒
    0x9193: 'tǎn',  # 醓
    0x9194: 'qiú,chōu',  # 醔
    0x9195: 'chún',  # 醕
    0x9196: 'yùn',  # 醖
    0x9197: 'pō,fā',  # 醗
    0x9198: 'kē',  # 醘
    0x9199: 'sōu',  # 醙
    0x919A: 'mí',  # 醚
    0x919B: 'quán',  # 醛
    0x919C: 'chǒu',  # 醜
    0x919D: 'cuō',  # 醝
    0x919E: 'yùn',  # 醞
    0x919F: 'yòng',  # 醟
    0x91A0: 'àng',  # 醠
    0x91A1: 'zhà',  # 醡
    0x91A2: 'hǎi',  # 醢
    0x91A3: 'táng',  # 醣
    0x91A4: 'jiàng',  # 醤
    0x91A5: 'piǎo',  # 醥
    0x91A6: 'chǎn,chěn',  # 醦
    0x91A7: 'yù',  # 醧
    0x91A8: 'lí',  # 醨
    0x91A9: 'zāo',  # 醩
    0x91AA: 'láo',  # 醪
    0x91AB: 'yī',  # 醫
    0x91AC: 'jiàng',  # 醬
    0x91AD: 'bú',  # 醭
    0x91AE: 'jiào',  # 醮
    0x91AF: 'xī',  # 醯
    0x91B0: 'tán',  # 醰
    0x91B1: 'pō,fā',  # 醱
    0x91B2: 'nóng',  # 醲
    0x91B3: 'yì,shì',  # 醳
    0x91B4: 'lǐ',  # 醴
    0x91B5: 'jù',  # 醵
    0x91B6: 'yàn,liǎn,xiān',  # 醶
    0x91B7: 'yì',  # 醷
    0x91B8: 'niàng',  # 醸
    0x91B9: 'rú',  # 醹
    0x91BA: 'xūn',  # 醺
    0x91BB: 'chóu',  # 醻
    0x91BC: 'yàn',  # 醼
    0x91BD: 'líng',  # 醽
    0x91BE: 'mí',  # 醾
    0x91BF: 'mí',  # 醿
    0x91C0: 'niàng,niáng',  # 釀
    0x91C1: 'xìn',  # 釁
    0x91C2: 'jiào',  # 釂
    0x91C3: 'shī',  # 釃
    0x91C4: 'mí',  # 釄
    0x91C5: 'yàn',  # 釅
    0x91C6: 'biàn',  # 釆
    0x91C7: 'cǎi,cài',  # 采
    0x91C8: 'shì',  # 釈
    0x91C9: 'yòu',  # 釉
    0x91CA: 'shì',  # 释
    0x91CB: 'shì',  # 釋
    0x91CC: 'lǐ',  # 里
    0x91CD: 'zhòng,chóng',  # 重
    0x91CE: 'yě',  # 野
    0x91CF: 'liáng,liàng',  # 量
    0x91D0: 'lí,xǐ,xī',  # 釐
    0x91D1: 'jīn',  # 金
    0x91D2: 'jīn',  # 釒
    0x91D3: 'gá',  # 釓
    0x91D4: 'yǐ',  # 釔
    0x91D5: 'liǎo,liào',  # 釕
    0x91D6: 'dāo',  # 釖
    0x91D7: 'zhāo',  # 釗
    0x91D8: 'dīng,dìng',  # 釘
    0x91D9: 'pō',  # 釙
    0x91DA: 'qiú',  # 釚
    0x91DB: 'hé',  # 釛
    0x91DC: 'fǔ',  # 釜
    0x91DD: 'zhēn',  # 針
    0x91DE: 'zhí',  # 釞
    0x91DF: 'bā',  # 釟
    0x91E0: 'luàn',  # 釠
    0x91E1: 'fǔ',  # 釡
    0x91E2: 'nǎi',  # 釢
    0x91E3: 'diào',  # 釣
    0x91E4: 'shān,shàn',  # 釤
    0x91E5: 'qiǎo,jiǎo',  # 釥
    0x91E6: 'kòu',  # 釦
    0x91E7: 'chuàn',  # 釧
    0x91E8: 'zǐ',  # 釨
    0x91E9: 'fán',  # 釩
    0x91EA: 'huá,yú',  # 釪
    0x91EB: 'huá,wū',  # 釫
    0x91EC: 'hàn',  # 釬
    0x91ED: 'gāng',  # 釭
    0x91EE: 'qí',  # 釮
    0x91EF: 'máng',  # 釯
    0x91F0: 'rì,rèn,jiàn',  # 釰
    0x91F1: 'dì,dài',  # 釱
    0x91F2: 'sì',  # 釲
    0x91F3: 'xì',  # 釳
    0x91F4: 'yì',  # 釴
    0x91F5: 'chāi',  # 釵
    0x91F6: 'shī,yí',  # 釶
    0x91F7: 'tǔ',  # 釷
    0x91F8: 'xī',  # 釸
    0x91F9: 'nǚ',  # 釹
    0x91FA: 'qiān',  # 釺
    0x91FB: 'qiú',  # 釻
    0x91FC: 'rì,rèn,jiàn',  # 釼
    0x91FD: 'pī,zhāo',  # 釽
    0x91FE: 'yé,yá',  # 釾
    0x91FF: 'jīn',  # 釿
    0x9200: 'bǎ',  # 鈀
    0x9201: 'fāng',  # 鈁
    0x9202: 'chén',  # 鈂
    0x9203: 'xíng',  # 鈃
    0x9204: 'dǒu',  # 鈄
    0x9205: 'yuè',  # 鈅
    0x9206: 'qiān',  # 鈆
    0x9207: 'fū',  # 鈇
    0x9208: 'bù',  # 鈈
    0x9209: 'nà',  # 鈉
    0x920A: 'xīn',  # 鈊
    0x920B: 'é',  # 鈋
    0x920C: 'jué',  # 鈌
    0x920D: 'dùn',  # 鈍
    0x920E: 'gōu',  # 鈎
    0x920F: 'yǐn',  # 鈏
    0x9210: 'qián',  # 鈐
    0x9211: 'bǎn',  # 鈑
    0x9212: 'sà',  # 鈒
    0x9213: 'rèn',  # 鈓
    0x9214: 'chāo',  # 鈔
    0x9215: 'niǔ',  # 鈕
    0x9216: 'fēn',  # 鈖
    0x9217: 'yǔn',  # 鈗
    0x9218: 'yǐ',  # 鈘
    0x9219: 'qín',  # 鈙
    0x921A: 'pī',  # 鈚
    0x921B: 'guō',  # 鈛
    0x921C: 'hóng',  # 鈜
    0x921D: 'yín',  # 鈝
    0x921E: 'jūn',  # 鈞
    0x921F: 'diào',  # 鈟
    0x9220: 'yì',  # 鈠
    0x9221: 'zhōng',  # 鈡
    0x9222: 'xǐ',  # 鈢
    0x9223: 'gài',  # 鈣
    0x9224: 'rì',  # 鈤
    0x9225: 'huǒ',  # 鈥
    0x9226: 'tài',  # 鈦
    0x9227: 'kàng',  # 鈧
    0x9228: 'yuán',  # 鈨
    0x9229: 'lú',  # 鈩
    0x922A: 'è',  # 鈪
    0x922B: 'qín',  # 鈫
    0x922C: 'duó',  # 鈬
    0x922D: 'zī',  # 鈭
    0x922E: 'ní',  # 鈮
    0x922F: 'tú',  # 鈯
    0x9230: 'shì',  # 鈰
    0x9231: 'mín',  # 鈱
    0x9232: 'gū',  # 鈲
    0x9233: 'kē',  # 鈳
    0x9234: 'líng',  # 鈴
    0x9235: 'bǐng',  # 鈵
    0x9236: 'sì',  # 鈶
    0x9237: 'gǔ',  # 鈷
    0x9238: 'bó',  # 鈸
    0x9239: 'pí',  # 鈹
    0x923A: 'yù',  # 鈺
    0x923B: 'sì',  # 鈻
    0x923C: 'zuó',  # 鈼
    0x923D: 'bū',  # 鈽
    0x923E: 'yóu',  # 鈾
    0x923F: 'diàn',  # 鈿
    0x9240: 'jiǎ',  # 鉀
    0x9241: 'zhēn',  # 鉁
    0x9242: 'shǐ',  # 鉂
    0x9243: 'shì',  # 鉃
    0x9244: 'tiě',  # 鉄
    0x9245: 'jù',  # 鉅
    0x9246: 'zuān',  # 鉆
    0x9247: 'shī',  # 鉇
    0x9248: 'tā,tuó',  # 鉈
    0x9249: 'xuàn',  # 鉉
    0x924A: 'zhāo',  # 鉊
    0x924B: 'bào,páo',  # 鉋
    0x924C: 'hé',  # 鉌
    0x924D: 'bì',  # 鉍
    0x924E: 'shēng',  # 鉎
    0x924F: 'chú',  # 鉏
    0x9250: 'shí',  # 鉐
    0x9251: 'bó',  # 鉑
    0x9252: 'zhù',  # 鉒
    0x9253: 'chì',  # 鉓
    0x9254: 'zā',  # 鉔
    0x9255: 'pǒ',  # 鉕
    0x9256: 'tóng',  # 鉖
    0x9257: 'qián',  # 鉗
    0x9258: 'fú',  # 鉘
    0x9259: 'zhǎi',  # 鉙
    0x925A: 'mǎo',  # 鉚
    0x925B: 'qiān',  # 鉛
    0x925C: 'fú',  # 鉜
    0x925D: 'lì',  # 鉝
    0x925E: 'yuè',  # 鉞
    0x925F: 'pī',  # 鉟
    0x9260: 'yāng',  # 鉠
    0x9261: 'bàn',  # 鉡
    0x9262: 'bō',  # 鉢
    0x9263: 'jié',  # 鉣
    0x9264: 'gōu',  # 鉤
    0x9265: 'shù',  # 鉥
    0x9266: 'zhēng',  # 鉦
    0x9267: 'mǔ',  # 鉧
    0x9268: 'xǐ',  # 鉨
    0x9269: 'xǐ',  # 鉩
    0x926A: 'dì',  # 鉪
    0x926B: 'jiā',  # 鉫
    0x926C: 'mù',  # 鉬
    0x926D: 'tǎn',  # 鉭
    0x926E: 'shén',  # 鉮
    0x926F: 'yǐ',  # 鉯
    0x9270: 'sī',  # 鉰
    0x9271: 'kuàng',  # 鉱
    0x9272: 'kǎ',  # 鉲
    0x9273: 'běi',  # 鉳
    0x9274: 'jiàn',  # 鉴
    0x9275: 'tóng',  # 鉵
    0x9276: 'xíng',  # 鉶
    0x9277: 'hóng',  # 鉷
    0x9278: 'jiǎo',  # 鉸
    0x9279: 'chǐ',  # 鉹
    0x927A: 'ěr',  # 鉺
    0x927B: 'gè',  # 鉻
    0x927C: 'bǐng,píng',  # 鉼
    0x927D: 'shì',  # 鉽
    0x927E: 'máo',  # 鉾
    0x927F: 'hā,kē',  # 鉿
    0x9280: 'yín',  # 銀
    0x9281: 'jūn',  # 銁
    0x9282: 'zhōu',  # 銂
    0x9283: 'chòng',  # 銃
    0x9284: 'xiǎng,jiōng',  # 銄
    0x9285: 'tóng',  # 銅
    0x9286: 'mò',  # 銆
    0x9287: 'lèi',  # 銇
    0x9288: 'jī',  # 銈
    0x9289: 'yù,sì',  # 銉
    0x928A: 'xù,huì',  # 銊
    0x928B: 'rén,rěn',  # 銋
    0x928C: 'zùn',  # 銌
    0x928D: 'zhì',  # 銍
    0x928E: 'qióng',  # 銎
    0x928F: 'shàn,shuò',  # 銏
    0x9290: 'chì,lì',  # 銐
    0x9291: 'xiǎn,xǐ',  # 銑
    0x9292: 'xíng',  # 銒
    0x9293: 'quán',  # 銓
    0x9294: 'pī',  # 銔
    0x9295: 'tiě',  # 銕
    0x9296: 'zhū',  # 銖
    0x9297: 'hóu,xiàng',  # 銗
    0x9298: 'míng',  # 銘
    0x9299: 'kuǎ',  # 銙
    0x929A: 'diào,tiáo,yáo',  # 銚
    0x929B: 'xiān,kuò,tiǎn,guā',  # 銛
    0x929C: 'xián',  # 銜
    0x929D: 'xiū',  # 銝
    0x929E: 'jūn',  # 銞
    0x929F: 'chā',  # 銟
    0x92A0: 'lǎo',  # 銠
    0x92A1: 'jí',  # 銡
    0x92A2: 'pǐ',  # 銢
    0x92A3: 'rú',  # 銣
    0x92A4: 'mǐ',  # 銤
    0x92A5: 'yī',  # 銥
    0x92A6: 'yīn',  # 銦
    0x92A7: 'guāng',  # 銧
    0x92A8: 'ǎn',  # 銨
    0x92A9: 'diū',  # 銩
    0x92AA: 'yǒu',  # 銪
    0x92AB: 'sè',  # 銫
    0x92AC: 'kào',  # 銬
    0x92AD: 'qián',  # 銭
    0x92AE: 'luán',  # 銮
    0x92AF: 'sī',  # 銯
    0x92B0: 'āi',  # 銰
    0x92B1: 'diào',  # 銱
    0x92B2: 'hàn',  # 銲
    0x92B3: 'ruì',  # 銳
    0x92B4: 'shì,zhì',  # 銴
    0x92B5: 'kēng',  # 銵
    0x92B6: 'qiú',  # 銶
    0x92B7: 'xiāo',  # 銷
    0x92B8: 'zhé,niè',  # 銸
    0x92B9: 'xiù',  # 銹
    0x92BA: 'zàng',  # 銺
    0x92BB: 'tī',  # 銻
    0x92BC: 'cuò',  # 銼
    0x92BD: 'xiān,kuò,tiǎn,guā',  # 銽
    0x92BE: 'hòng,gǒng',  # 銾
    0x92BF: 'zhōng,yōng',  # 銿
    0x92C0: 'tōu,tù,dòu',  # 鋀
    0x92C1: 'lǚ',  # 鋁
    0x92C2: 'méi,méng',  # 鋂
    0x92C3: 'láng',  # 鋃
    0x92C4: 'wàn,jiǎn',  # 鋄
    0x92C5: 'xīn',  # 鋅
    0x92C6: 'yún',  # 鋆
    0x92C7: 'bèi',  # 鋇
    0x92C8: 'wù',  # 鋈
    0x92C9: 'sù',  # 鋉
    0x92CA: 'yù',  # 鋊
    0x92CB: 'chán',  # 鋋
    0x92CC: 'tǐng,dìng',  # 鋌
    0x92CD: 'bó',  # 鋍
    0x92CE: 'hàn',  # 鋎
    0x92CF: 'jiá',  # 鋏
    0x92D0: 'hóng',  # 鋐
    0x92D1: 'juān,jiān,cuān',  # 鋑
    0x92D2: 'fēng',  # 鋒
    0x92D3: 'chān',  # 鋓
    0x92D4: 'wǎn',  # 鋔
    0x92D5: 'zhì',  # 鋕
    0x92D6: 'sī,tuó',  # 鋖
    0x92D7: 'xuān,juān,juàn',  # 鋗
    0x92D8: 'huá,wú,wū',  # 鋘
    0x92D9: 'wú',  # 鋙
    0x92DA: 'tiáo',  # 鋚
    0x92DB: 'kuàng',  # 鋛
    0x92DC: 'zhuó,chuò',  # 鋜
    0x92DD: 'lüè',  # 鋝
    0x92DE: 'xíng,xìng,jīng',  # 鋞
    0x92DF: 'qǐn',  # 鋟
    0x92E0: 'shèn',  # 鋠
    0x92E1: 'hán',  # 鋡
    0x92E2: 'lüè',  # 鋢
    0x92E3: 'yé',  # 鋣
    0x92E4: 'chú',  # 鋤
    0x92E5: 'zèng',  # 鋥
    0x92E6: 'jū,jú',  # 鋦
    0x92E7: 'xiàn',  # 鋧
    0x92E8: 'é',  # 鋨
    0x92E9: 'máng',  # 鋩
    0x92EA: 'pū,pù',  # 鋪
    0x92EB: 'lí',  # 鋫
    0x92EC: 'pàn',  # 鋬
    0x92ED: 'ruì',  # 鋭
    0x92EE: 'chéng',  # 鋮
    0x92EF: 'gào',  # 鋯
    0x92F0: 'lǐ',  # 鋰
    0x92F1: 'tè',  # 鋱
    0x92F2: 'bīng',  # 鋲
    0x92F3: 'zhù',  # 鋳
    0x92F4: 'zhèn',  # 鋴
    0x92F5: 'tū',  # 鋵
    0x92F6: 'liǔ',  # 鋶
    0x92F7: 'zuì,niè',  # 鋷
    0x92F8: 'jù,jū',  # 鋸
    0x92F9: 'chǎng',  # 鋹
    0x92FA: 'yuǎn,yuān,wǎn,wān',  # 鋺
    0x92FB: 'jiān,jiàn',  # 鋻
    0x92FC: 'gāng,gàng',  # 鋼
    0x92FD: 'diào',  # 鋽
    0x92FE: 'táo',  # 鋾
    0x92FF: 'shǎng',  # 鋿
    0x9300: 'lún',  # 錀
    0x9301: 'kè',  # 錁
    0x9302: 'líng',  # 錂
    0x9303: 'pī',  # 錃
    0x9304: 'lù',  # 錄
    0x9305: 'lí',  # 錅
    0x9306: 'qīng',  # 錆
    0x9307: 'péi',  # 錇
    0x9308: 'juǎn',  # 錈
    0x9309: 'mín',  # 錉
    0x930A: 'zuì',  # 錊
    0x930B: 'péng',  # 錋
    0x930C: 'àn',  # 錌
    0x930D: 'pī',  # 錍
    0x930E: 'xiàn',  # 錎
    0x930F: 'yā',  # 錏
    0x9310: 'zhuī',  # 錐
    0x9311: 'lèi',  # 錑
    0x9312: 'ā',  # 錒
    0x9313: 'kōng',  # 錓
    0x9314: 'tà',  # 錔
    0x9315: 'kūn',  # 錕
    0x9316: 'dú',  # 錖
    0x9317: 'nèi',  # 錗
    0x9318: 'chuí',  # 錘
    0x9319: 'zī',  # 錙
    0x931A: 'zhēng',  # 錚
    0x931B: 'bēn',  # 錛
    0x931C: 'niè',  # 錜
    0x931D: 'cóng',  # 錝
    0x931E: 'chún',  # 錞
    0x931F: 'tán',  # 錟
    0x9320: 'dìng',  # 錠
    0x9321: 'qí',  # 錡
    0x9322: 'qián',  # 錢
    0x9323: 'zhuì',  # 錣
    0x9324: 'jī',  # 錤
    0x9325: 'yù',  # 錥
    0x9326: 'jǐn',  # 錦
    0x9327: 'guǎn',  # 錧
    0x9328: 'máo',  # 錨
    0x9329: 'chāng',  # 錩
    0x932A: 'tiǎn',  # 錪
    0x932B: 'xī',  # 錫
    0x932C: 'liàn',  # 錬
    0x932D: 'diāo',  # 錭
    0x932E: 'gù',  # 錮
    0x932F: 'cuò',  # 錯
    0x9330: 'shù',  # 錰
    0x9331: 'zhēn',  # 錱
    0x9332: 'lù',  # 録
    0x9333: 'měng',  # 錳
    0x9334: 'lù',  # 錴
    0x9335: 'huā',  # 錵
    0x9336: 'biǎo',  # 錶
    0x9337: 'gá',  # 錷
    0x9338: 'lái',  # 錸
    0x9339: 'kěn',  # 錹
    0x933A: 'fāng',  # 錺
    0x933B: 'bū',  # 錻
    0x933C: 'nài',  # 錼
    0x933D: 'wàn',  # 錽
    0x933E: 'zàn',  # 錾
    0x933F: 'hǔ',  # 錿
    0x9340: 'dé',  # 鍀
    0x9341: 'xiān',  # 鍁
    0x9342: 'piān',  # 鍂
    0x9343: 'huò',  # 鍃
    0x9344: 'liàng',  # 鍄
    0x9345: 'fǎ',  # 鍅
    0x9346: 'mén',  # 鍆
    0x9347: 'kǎi',  # 鍇
    0x9348: 'yāng',  # 鍈
    0x9349: 'chí',  # 鍉
    0x934A: 'liàn',  # 鍊
    0x934B: 'guō',  # 鍋
    0x934C: 'xiǎn',  # 鍌
    0x934D: 'dù',  # 鍍
    0x934E: 'tú',  # 鍎
    0x934F: 'wéi',  # 鍏
    0x9350: 'zōng',  # 鍐
    0x9351: 'fù',  # 鍑
    0x9352: 'róu',  # 鍒
    0x9353: 'jí',  # 鍓
    0x9354: 'è',  # 鍔
    0x9355: 'jūn',  # 鍕
    0x9356: 'chěn',  # 鍖
    0x9357: 'tí',  # 鍗
    0x9358: 'zhá',  # 鍘
    0x9359: 'hù',  # 鍙
    0x935A: 'yáng',  # 鍚
    0x935B: 'duàn',  # 鍛
    0x935C: 'xiá',  # 鍜
    0x935D: 'yú',  # 鍝
    0x935E: 'kēng',  # 鍞
    0x935F: 'shēng',  # 鍟
    0x9360: 'huáng',  # 鍠
    0x9361: 'wěi',  # 鍡
    0x9362: 'fù',  # 鍢
    0x9363: 'zhāo',  # 鍣
    0x9364: 'chā',  # 鍤
    0x9365: 'qiè',  # 鍥
    0x9366: 'shī',  # 鍦
    0x9367: 'hōng',  # 鍧
    0x9368: 'kuí',  # 鍨
    0x9369: 'nuò',  # 鍩
    0x936A: 'móu',  # 鍪
    0x936B: 'qiāo',  # 鍫
    0x936C: 'qiāo',  # 鍬
    0x936D: 'hóu',  # 鍭
    0x936E: 'tōu',  # 鍮
    0x936F: 'cōng',  # 鍯
    0x9370: 'huán',  # 鍰
    0x9371: 'yè',  # 鍱
    0x9372: 'mín',  # 鍲
    0x9373: 'jiàn',  # 鍳
    0x9374: 'duān',  # 鍴
    0x9375: 'jiàn',  # 鍵
    0x9376: 'sī',  # 鍶
    0x9377: 'kuí',  # 鍷
    0x9378: 'hú',  # 鍸
    0x9379: 'xuān',  # 鍹
    0x937A: 'zhě',  # 鍺
    0x937B: 'jié',  # 鍻
    0x937C: 'zhēn',  # 鍼
    0x937D: 'biān',  # 鍽
    0x937E: 'zhōng',  # 鍾
    0x937F: 'zī',  # 鍿
    0x9380: 'xiū',  # 鎀
    0x9381: 'yé',  # 鎁
    0x9382: 'měi',  # 鎂
    0x9383: 'pài',  # 鎃
    0x9384: 'āi',  # 鎄
    0x9385: 'jiè',  # 鎅
    0x9386: 'qián',  # 鎆
    0x9387: 'méi',  # 鎇
    0x9388: 'cuō,chā',  # 鎈
    0x9389: 'dā,tà',  # 鎉
    0x938A: 'bàng',  # 鎊
    0x938B: 'xiá',  # 鎋
    0x938C: 'lián',  # 鎌
    0x938D: 'suǒ,sè',  # 鎍
    0x938E: 'kài',  # 鎎
    0x938F: 'liú',  # 鎏
    0x9390: 'yáo,zú',  # 鎐
    0x9391: 'yè,tà,gé',  # 鎑
    0x9392: 'nòu',  # 鎒
    0x9393: 'wēng',  # 鎓
    0x9394: 'róng',  # 鎔
    0x9395: 'táng',  # 鎕
    0x9396: 'suǒ',  # 鎖
    0x9397: 'qiāng,chēng',  # 鎗
    0x9398: 'gé,lì',  # 鎘
    0x9399: 'shuò',  # 鎙
    0x939A: 'chuí',  # 鎚
    0x939B: 'bó',  # 鎛
    0x939C: 'pán',  # 鎜
    0x939D: 'dā',  # 鎝
    0x939E: 'bī,bì,pī',  # 鎞
    0x939F: 'sǎng',  # 鎟
    0x93A0: 'gāng',  # 鎠
    0x93A1: 'zī',  # 鎡
    0x93A2: 'wū',  # 鎢
    0x93A3: 'yíng',  # 鎣
    0x93A4: 'huàng',  # 鎤
    0x93A5: 'tiáo',  # 鎥
    0x93A6: 'liú,liù',  # 鎦
    0x93A7: 'kǎi',  # 鎧
    0x93A8: 'sǔn',  # 鎨
    0x93A9: 'shā',  # 鎩
    0x93AA: 'sōu',  # 鎪
    0x93AB: 'wàn,jiǎn',  # 鎫
    0x93AC: 'gǎo,hào',  # 鎬
    0x93AD: 'zhèn',  # 鎭
    0x93AE: 'zhèn',  # 鎮
    0x93AF: 'láng',  # 鎯
    0x93B0: 'yì',  # 鎰
    0x93B1: 'yuán',  # 鎱
    0x93B2: 'tǎng',  # 鎲
    0x93B3: 'niè',  # 鎳
    0x93B4: 'xí',  # 鎴
    0x93B5: 'jiā',  # 鎵
    0x93B6: 'gē',  # 鎶
    0x93B7: 'mǎ',  # 鎷
    0x93B8: 'juān',  # 鎸
    0x93B9: 'sòng',  # 鎹
    0x93BA: 'zǔ',  # 鎺
    0x93BB: 'suǒ',  # 鎻
    0x93BC: 'xià',  # 鎼
    0x93BD: 'fēng',  # 鎽
    0x93BE: 'wēn',  # 鎾
    0x93BF: 'ná',  # 鎿
    0x93C0: 'lǔ',  # 鏀
    0x93C1: 'suǒ',  # 鏁
    0x93C2: 'ōu',  # 鏂
    0x93C3: 'zú,chuò',  # 鏃
    0x93C4: 'tuán',  # 鏄
    0x93C5: 'xiū,xiù',  # 鏅
    0x93C6: 'guàn',  # 鏆
    0x93C7: 'xuàn',  # 鏇
    0x93C8: 'liàn',  # 鏈
    0x93C9: 'shòu,sōu',  # 鏉
    0x93CA: 'ào',  # 鏊
    0x93CB: 'mǎn',  # 鏋
    0x93CC: 'mò',  # 鏌
    0x93CD: 'luó',  # 鏍
    0x93CE: 'bì',  # 鏎
    0x93CF: 'wèi',  # 鏏
    0x93D0: 'liú',  # 鏐
    0x93D1: 'dí,dī',  # 鏑
    0x93D2: 'sǎn,qiāo,càn',  # 鏒
    0x93D3: 'cōng',  # 鏓
    0x93D4: 'yí',  # 鏔
    0x93D5: 'lù,áo',  # 鏕
    0x93D6: 'áo',  # 鏖
    0x93D7: 'kēng',  # 鏗
    0x93D8: 'qiāng',  # 鏘
    0x93D9: 'cuī',  # 鏙
    0x93DA: 'qī',  # 鏚
    0x93DB: 'shǎng',  # 鏛
    0x93DC: 'tāng,táng',  # 鏜
    0x93DD: 'màn',  # 鏝
    0x93DE: 'yōng',  # 鏞
    0x93DF: 'chǎn',  # 鏟
    0x93E0: 'fēng',  # 鏠
    0x93E1: 'jìng',  # 鏡
    0x93E2: 'biāo',  # 鏢
    0x93E3: 'shù',  # 鏣
    0x93E4: 'lòu',  # 鏤
    0x93E5: 'xiù',  # 鏥
    0x93E6: 'cōng',  # 鏦
    0x93E7: 'lóng',  # 鏧
    0x93E8: 'zàn',  # 鏨
    0x93E9: 'jiàn,zàn',  # 鏩
    0x93EA: 'cáo',  # 鏪
    0x93EB: 'lí',  # 鏫
    0x93EC: 'xià',  # 鏬
    0x93ED: 'xī',  # 鏭
    0x93EE: 'kāng',  # 鏮
    0x93EF: 'shuǎng',  # 鏯
    0x93F0: 'bèng',  # 鏰
    0x93F1: 'zhāng',  # 鏱
    0x93F2: 'qiān',  # 鏲
    0x93F3: 'zhēng',  # 鏳
    0x93F4: 'lù',  # 鏴
    0x93F5: 'huá',  # 鏵
    0x93F6: 'jí',  # 鏶
    0x93F7: 'pú',  # 鏷
    0x93F8: 'huì,suì,ruì',  # 鏸
    0x93F9: 'qiǎng,qiāng',  # 鏹
    0x93FA: 'pō',  # 鏺
    0x93FB: 'lín',  # 鏻
    0x93FC: 'sè',  # 鏼
    0x93FD: 'xiù',  # 鏽
    0x93FE: 'sǎn,xiàn,sà',  # 鏾
    0x93FF: 'chēng',  # 鏿
    0x9400: 'guì',  # 鐀
    0x9401: 'sī',  # 鐁
    0x9402: 'liú',  # 鐂
    0x9403: 'náo',  # 鐃
    0x9404: 'huáng',  # 鐄
    0x9405: 'piě',  # 鐅
    0x9406: 'suì',  # 鐆
    0x9407: 'fán',  # 鐇
    0x9408: 'qiáo',  # 鐈
    0x9409: 'quān',  # 鐉
    0x940A: 'xī',  # 鐊
    0x940B: 'tàng',  # 鐋
    0x940C: 'xiàng',  # 鐌
    0x940D: 'jué',  # 鐍
    0x940E: 'jiāo',  # 鐎
    0x940F: 'zūn',  # 鐏
    0x9410: 'liào',  # 鐐
    0x9411: 'qì',  # 鐑
    0x9412: 'láo',  # 鐒
    0x9413: 'duī',  # 鐓
    0x9414: 'xín',  # 鐔
    0x9415: 'zān',  # 鐕
    0x9416: 'jī',  # 鐖
    0x9417: 'jiǎn',  # 鐗
    0x9418: 'zhōng',  # 鐘
    0x9419: 'dèng',  # 鐙
    0x941A: 'yā',  # 鐚
    0x941B: 'yǐng',  # 鐛
    0x941C: 'duī',  # 鐜
    0x941D: 'jué',  # 鐝
    0x941E: 'nòu',  # 鐞
    0x941F: 'zān',  # 鐟
    0x9420: 'pǔ',  # 鐠
    0x9421: 'tiě',  # 鐡
    0x9422: 'fán',  # 鐢
    0x9423: 'chēng',  # 鐣
    0x9424: 'dǐng',  # 鐤
    0x9425: 'shàn',  # 鐥
    0x9426: 'kāi',  # 鐦
    0x9427: 'jiǎn',  # 鐧
    0x9428: 'fèi',  # 鐨
    0x9429: 'suì',  # 鐩
    0x942A: 'lǔ',  # 鐪
    0x942B: 'juān',  # 鐫
    0x942C: 'huì',  # 鐬
    0x942D: 'yù',  # 鐭
    0x942E: 'lián',  # 鐮
    0x942F: 'zhuō',  # 鐯
    0x9430: 'qiāo',  # 鐰
    0x9431: 'jiàn',  # 鐱
    0x9432: 'zhuó',  # 鐲
    0x9433: 'léi',  # 鐳
    0x9434: 'bì',  # 鐴
    0x9435: 'tiě',  # 鐵
    0x9436: 'huán',  # 鐶
    0x9437: 'yè',  # 鐷
    0x9438: 'duó',  # 鐸
    0x9439: 'guò',  # 鐹
    0x943A: 'dāng,chēng',  # 鐺
    0x943B: 'jù',  # 鐻
    0x943C: 'fén',  # 鐼
    0x943D: 'dá',  # 鐽
    0x943E: 'bèi',  # 鐾
    0x943F: 'yì',  # 鐿
    0x9440: 'ài',  # 鑀
    0x9441: 'zōng',  # 鑁
    0x9442: 'xùn',  # 鑂
    0x9443: 'diào',  # 鑃
    0x9444: 'zhù',  # 鑄
    0x9445: 'héng',  # 鑅
    0x9446: 'zhuì',  # 鑆
    0x9447: 'jī',  # 鑇
    0x9448: 'niè',  # 鑈
    0x9449: 'hé',  # 鑉
    0x944A: 'huò',  # 鑊
    0x944B: 'qīng',  # 鑋
    0x944C: 'bīn',  # 鑌
    0x944D: 'yīng',  # 鑍
    0x944E: 'guì',  # 鑎
    0x944F: 'níng',  # 鑏
    0x9450: 'xū',  # 鑐
    0x9451: 'jiàn',  # 鑑
    0x9452: 'jiàn',  # 鑒
    0x9453: 'qiǎn',  # 鑓
    0x9454: 'chǎ',  # 鑔
    0x9455: 'zhì',  # 鑕
    0x9456: 'miè',  # 鑖
    0x9457: 'lí',  # 鑗
    0x9458: 'léi',  # 鑘
    0x9459: 'jī',  # 鑙
    0x945A: 'zuān',  # 鑚
    0x945B: 'kuàng',  # 鑛
    0x945C: 'shǎng',  # 鑜
    0x945D: 'péng',  # 鑝
    0x945E: 'là',  # 鑞
    0x945F: 'dú',  # 鑟
    0x9460: 'shuò',  # 鑠
    0x9461: 'chuò',  # 鑡
    0x9462: 'lǜ',  # 鑢
    0x9463: 'biāo',  # 鑣
    0x9464: 'bào',  # 鑤
    0x9465: 'lǔ',  # 鑥
    0x9466: 'xián',  # 鑦
    0x9467: 'kuān',  # 鑧
    0x9468: 'lóng',  # 鑨
    0x9469: 'è',  # 鑩
    0x946A: 'lú',  # 鑪
    0x946B: 'xīn',  # 鑫
    0x946C: 'jiàn',  # 鑬
    0x946D: 'lán',  # 鑭
    0x946E: 'bó',  # 鑮
    0x946F: 'jiān',  # 鑯
    0x9470: 'yuè',  # 鑰
    0x9471: 'chán',  # 鑱
    0x9472: 'xiāng',  # 鑲
    0x9473: 'jiàn',  # 鑳
    0x9474: 'xī',  # 鑴
    0x9475: 'guàn',  # 鑵
    0x9476: 'cáng',  # 鑶
    0x9477: 'niè',  # 鑷
    0x9478: 'lěi',  # 鑸
    0x9479: 'cuān',  # 鑹
    0x947A: 'qú',  # 鑺
    0x947B: 'pàn',  # 鑻
    0x947C: 'luó',  # 鑼
    0x947D: 'zuān',  # 鑽
    0x947E: 'luán',  # 鑾
    0x947F: 'záo',  # 鑿
    0x9480: 'niè',  # 钀
    0x9481: 'jué',  # 钁
    0x9482: 'tǎng',  # 钂
    0x9483: 'zhú',  # 钃
    0x9484: 'làn',  # 钄
    0x9485: 'jīn',  # 钅
    0x9486: 'gá',  # 钆
    0x9487: 'yǐ',  # 钇
    0x9488: 'zhēn',  # 针
    0x9489: 'dīng,dìng',  # 钉
    0x948A: 'zhāo',  # 钊
    0x948B: 'pō',  # 钋
    0x948C: 'liǎo,liào',  # 钌
    0x948D: 'tǔ',  # 钍
    0x948E: 'qiān',  # 钎
    0x948F: 'chuàn',  # 钏
    0x9490: 'shān,shàn',  # 钐
    0x9491: 'sà,xì',  # 钑
    0x9492: 'fán',  # 钒
    0x9493: 'diào',  # 钓
    0x9494: 'mén',  # 钔
    0x9495: 'nǚ',  # 钕
    0x9496: 'yáng',  # 钖
    0x9497: 'chāi',  # 钗
    0x9498: 'xíng',  # 钘
    0x9499: 'gài',  # 钙
    0x949A: 'bù',  # 钚
    0x949B: 'tài',  # 钛
    0x949C: 'jù',  # 钜
    0x949D: 'dùn',  # 钝
    0x949E: 'chāo',  # 钞
    0x949F: 'zhōng',  # 钟
    0x94A0: 'nà',  # 钠
    0x94A1: 'bèi',  # 钡
    0x94A2: 'gāng,gàng',  # 钢
    0x94A3: 'bǎn',  # 钣
    0x94A4: 'qián',  # 钤
    0x94A5: 'yuè,yào',  # 钥
    0x94A6: 'qīn',  # 钦
    0x94A7: 'jūn',  # 钧
    0x94A8: 'wū',  # 钨
    0x94A9: 'gōu',  # 钩
    0x94AA: 'kàng',  # 钪
    0x94AB: 'fāng',  # 钫
    0x94AC: 'huǒ',  # 钬
    0x94AD: 'dǒu',  # 钭
    0x94AE: 'niǔ',  # 钮
    0x94AF: 'bǎ,pá',  # 钯
    0x94B0: 'yù',  # 钰
    0x94B1: 'qián',  # 钱
    0x94B2: 'zhēng,zhèng',  # 钲
    0x94B3: 'qián',  # 钳
    0x94B4: 'gǔ',  # 钴
    0x94B5: 'bō',  # 钵
    0x94B6: 'kē',  # 钶
    0x94B7: 'pǒ',  # 钷
    0x94B8: 'bū',  # 钸
    0x94B9: 'bó',  # 钹
    0x94BA: 'yuè',  # 钺
    0x94BB: 'zuān,zuàn',  # 钻
    0x94BC: 'mù',  # 钼
    0x94BD: 'tǎn',  # 钽
    0x94BE: 'jiǎ',  # 钾
    0x94BF: 'diàn,tián',  # 钿
    0x94C0: 'yóu',  # 铀
    0x94C1: 'tiě',  # 铁
    0x94C2: 'bó',  # 铂
    0x94C3: 'líng',  # 铃
    0x94C4: 'shuò',  # 铄
    0x94C5: 'qiān,yán',  # 铅
    0x94C6: 'mǎo',  # 铆
    0x94C7: 'bào,páo',  # 铇
    0x94C8: 'shì',  # 铈
    0x94C9: 'xuàn',  # 铉
    0x94CA: 'tā,tuó',  # 铊
    0x94CB: 'bì',  # 铋
    0x94CC: 'ní',  # 铌
    0x94CD: 'pí,pī',  # 铍
    0x94CE: 'duó',  # 铎
    0x94CF: 'xíng',  # 铏
    0x94D0: 'kào',  # 铐
    0x94D1: 'lǎo',  # 铑
    0x94D2: 'ěr',  # 铒
    0x94D3: 'máng',  # 铓
    0x94D4: 'yā,yà',  # 铔
    0x94D5: 'yǒu',  # 铕
    0x94D6: 'chéng',  # 铖
    0x94D7: 'jiá',  # 铗
    0x94D8: 'yé',  # 铘
    0x94D9: 'náo',  # 铙
    0x94DA: 'zhì',  # 铚
    0x94DB: 'dāng,chēng',  # 铛
    0x94DC: 'tóng',  # 铜
    0x94DD: 'lǚ',  # 铝
    0x94DE: 'diào',  # 铞
    0x94DF: 'yīn',  # 铟
    0x94E0: 'kǎi',  # 铠
    0x94E1: 'zhá',  # 铡
    0x94E2: 'zhū',  # 铢
    0x94E3: 'xiǎn,xǐ',  # 铣
    0x94E4: 'tǐng,dìng',  # 铤
    0x94E5: 'diū',  # 铥
    0x94E6: 'xiān,kuò,tiǎn,guā',  # 铦
    0x94E7: 'huá',  # 铧
    0x94E8: 'quán',  # 铨
    0x94E9: 'shā',  # 铩
    0x94EA: 'hā,kē',  # 铪
    0x94EB: 'diào,tiáo,yáo',  # 铫
    0x94EC: 'gè',  # 铬
    0x94ED: 'míng',  # 铭
    0x94EE: 'zhēng',  # 铮
    0x94EF: 'sè',  # 铯
    0x94F0: 'jiǎo',  # 铰
    0x94F1: 'yī',  # 铱
    0x94F2: 'chǎn',  # 铲
    0x94F3: 'chòng',  # 铳
    0x94F4: 'tàng,tāng',  # 铴
    0x94F5: 'ǎn',  # 铵
    0x94F6: 'yín',  # 银
    0x94F7: 'rú',  # 铷
    0x94F8: 'zhù',  # 铸
    0x94F9: 'láo',  # 铹
    0x94FA: 'pū,pù',  # 铺
    0x94FB: 'wú',  # 铻
    0x94FC: 'lái',  # 铼
    0x94FD: 'tè',  # 铽
    0x94FE: 'liàn',  # 链
    0x94FF: 'kēng',  # 铿
    0x9500: 'xiāo',  # 销
    0x9501: 'suǒ',  # 锁
    0x9502: 'lǐ',  # 锂
    0x9503: 'zèng',  # 锃
    0x9504: 'chú',  # 锄
    0x9505: 'guō',  # 锅
    0x9506: 'gào',  # 锆
    0x9507: 'é',  # 锇
    0x9508: 'xiù',  # 锈
    0x9509: 'cuò',  # 锉
    0x950A: 'lüè',  # 锊
    0x950B: 'fēng',  # 锋
    0x950C: 'xīn',  # 锌
    0x950D: 'liǔ',  # 锍
    0x950E: 'kāi',  # 锎
    0x950F: 'jiǎn',  # 锏
    0x9510: 'ruì',  # 锐
    0x9511: 'tī',  # 锑
    0x9512: 'láng',  # 锒
    0x9513: 'qǐn',  # 锓
    0x9514: 'jū',  # 锔
    0x9515: 'ā',  # 锕
    0x9516: 'qiāng',  # 锖
    0x9517: 'zhě',  # 锗
    0x9518: 'nuò',  # 锘
    0x9519: 'cuò',  # 错
    0x951A: 'máo',  # 锚
    0x951B: 'bēn',  # 锛
    0x951C: 'qí',  # 锜
    0x951D: 'dé',  # 锝
    0x951E: 'kè',  # 锞
    0x951F: 'kūn',  # 锟
    0x9520: 'chāng',  # 锠
    0x9521: 'xī',  # 锡
    0x9522: 'gù',  # 锢
    0x9523: 'luó',  # 锣
    0x9524: 'chuí',  # 锤
    0x9525: 'zhuī',  # 锥
    0x9526: 'jǐn',  # 锦
    0x9527: 'zhì',  # 锧
    0x9528: 'xiān',  # 锨
    0x9529: 'juǎn',  # 锩
    0x952A: 'huò',  # 锪
    0x952B: 'péi',  # 锫
    0x952C: 'tán',  # 锬
    0x952D: 'dìng',  # 锭
    0x952E: 'jiàn',  # 键
    0x952F: 'jù',  # 锯
    0x9530: 'měng',  # 锰
    0x9531: 'zī',  # 锱
    0x9532: 'qiè',  # 锲
    0x9533: 'yīng',  # 锳
    0x9534: 'kǎi',  # 锴
    0x9535: 'qiāng',  # 锵
    0x9536: 'sī',  # 锶
    0x9537: 'è',  # 锷
    0x9538: 'chā',  # 锸
    0x9539: 'qiāo',  # 锹
    0x953A: 'zhōng',  # 锺
    0x953B: 'duàn',  # 锻
    0x953C: 'sōu',  # 锼
    0x953D: 'huáng',  # 锽
    0x953E: 'huán',  # 锾
    0x953F: 'āi',  # 锿
    0x9540: 'dù',  # 镀
    0x9541: 'měi',  # 镁
    0x9542: 'lòu',  # 镂
    0x9543: 'zī',  # 镃
    0x9544: 'fèi',  # 镄
    0x9545: 'méi',  # 镅
    0x9546: 'mò',  # 镆
    0x9547: 'zhèn',  # 镇
    0x9548: 'bó',  # 镈
    0x9549: 'gé,lì',  # 镉
    0x954A: 'niè',  # 镊
    0x954B: 'tǎng',  # 镋
    0x954C: 'juān',  # 镌
    0x954D: 'niè',  # 镍
    0x954E: 'ná',  # 镎
    0x954F: 'liú',  # 镏
    0x9550: 'gǎo,hào',  # 镐
    0x9551: 'bàng',  # 镑
    0x9552: 'yì',  # 镒
    0x9553: 'jiā',  # 镓
    0x9554: 'bīn',  # 镔
    0x9555: 'róng',  # 镕
    0x9556: 'biāo',  # 镖
    0x9557: 'tāng',  # 镗
    0x9558: 'màn',  # 镘
    0x9559: 'luó',  # 镙
    0x955A: 'bèng',  # 镚
    0x955B: 'yōng',  # 镛
    0x955C: 'jìng',  # 镜
    0x955D: 'dí',  # 镝
    0x955E: 'zú',  # 镞
    0x955F: 'xuàn',  # 镟
    0x9560: 'liú',  # 镠
    0x9561: 'xín',  # 镡
    0x9562: 'jué',  # 镢
    0x9563: 'liào',  # 镣
    0x9564: 'pú',  # 镤
    0x9565: 'lǔ',  # 镥
    0x9566: 'duī',  # 镦
    0x9567: 'lán',  # 镧
    0x9568: 'pǔ',  # 镨
    0x9569: 'cuān',  # 镩
    0x956A: 'qiǎng',  # 镪
    0x956B: 'dèng',  # 镫
    0x956C: 'huò',  # 镬
    0x956D: 'léi',  # 镭
    0x956E: 'huán',  # 镮
    0x956F: 'zhuó',  # 镯
    0x9570: 'lián',  # 镰
    0x9571: 'yì',  # 镱
    0x9572: 'chǎ',  # 镲
    0x9573: 'biāo',  # 镳
    0x9574: 'là',  # 镴
    0x9575: 'chán',  # 镵
    0x9576: 'xiāng',  # 镶
    0x9577: 'cháng,zhǎng',  # 長
    0x9578: 'cháng',  # 镸
    0x9579: 'jiǔ',  # 镹
    0x957A: 'ǎo',  # 镺
    0x957B: 'dié',  # 镻
    0x957C: 'jié',  # 镼
    0x957D: 'liǎo',  # 镽
    0x957E: 'mí',  # 镾
    0x957F: 'cháng,zhǎng',  # 长
    0x9580: 'mén',  # 門
    0x9581: 'mà',  # 閁
    0x9582: 'shuān',  # 閂
    0x9583: 'shǎn',  # 閃
    0x9584: 'huò,shǎn',  # 閄
    0x9585: 'mén',  # 閅
    0x9586: 'yán',  # 閆
    0x9587: 'bì',  # 閇
    0x9588: 'hàn,bì',  # 閈
    0x9589: 'bì',  # 閉
    0x958A: 'shān',  # 閊
    0x958B: 'kāi',  # 開
    0x958C: 'kāng,kàng',  # 閌
    0x958D: 'bēng',  # 閍
    0x958E: 'hóng',  # 閎
    0x958F: 'rùn',  # 閏
    0x9590: 'sàn',  # 閐
    0x9591: 'xián',  # 閑
    0x9592: 'xián,jiān,jiàn',  # 閒
    0x9593: 'jiān,jiàn',  # 間
    0x9594: 'mǐn',  # 閔
    0x9595: 'xiā,xiǎ',  # 閕
    0x9596: 'shuǐ',  # 閖
    0x9597: 'dòu',  # 閗
    0x9598: 'zhá',  # 閘
    0x9599: 'nào',  # 閙
    0x959A: 'zhān',  # 閚
    0x959B: 'pēng,pèng',  # 閛
    0x959C: 'xiǎ,kě',  # 閜
    0x959D: 'líng',  # 閝
    0x959E: 'biàn,guān',  # 閞
    0x959F: 'bì',  # 閟
    0x95A0: 'rùn',  # 閠
    0x95A1: 'hé',  # 閡
    0x95A2: 'guān',  # 関
    0x95A3: 'gé',  # 閣
    0x95A4: 'hé,gé',  # 閤
    0x95A5: 'fá',  # 閥
    0x95A6: 'chù',  # 閦
    0x95A7: 'hòng,xiàng',  # 閧
    0x95A8: 'guī',  # 閨
    0x95A9: 'mǐn',  # 閩
    0x95AA: 'sē,xī',  # 閪
    0x95AB: 'kǔn',  # 閫
    0x95AC: 'làng',  # 閬
    0x95AD: 'lǘ',  # 閭
    0x95AE: 'tíng,tǐng',  # 閮
    0x95AF: 'shà',  # 閯
    0x95B0: 'jú',  # 閰
    0x95B1: 'yuè',  # 閱
    0x95B2: 'yuè',  # 閲
    0x95B3: 'chǎn',  # 閳
    0x95B4: 'qù',  # 閴
    0x95B5: 'lìn',  # 閵
    0x95B6: 'chāng',  # 閶
    0x95B7: 'shā',  # 閷
    0x95B8: 'kǔn',  # 閸
    0x95B9: 'yān',  # 閹
    0x95BA: 'wén',  # 閺
    0x95BB: 'yán',  # 閻
    0x95BC: 'è,yān',  # 閼
    0x95BD: 'hūn',  # 閽
    0x95BE: 'yù',  # 閾
    0x95BF: 'wén',  # 閿
    0x95C0: 'hòng',  # 闀
    0x95C1: 'bāo',  # 闁
    0x95C2: 'hòng,juǎn,xiàng',  # 闂
    0x95C3: 'qù',  # 闃
    0x95C4: 'yǎo',  # 闄
    0x95C5: 'wén',  # 闅
    0x95C6: 'bǎn,pàn',  # 闆
    0x95C7: 'àn',  # 闇
    0x95C8: 'wéi',  # 闈
    0x95C9: 'yīn',  # 闉
    0x95CA: 'kuò',  # 闊
    0x95CB: 'què',  # 闋
    0x95CC: 'lán',  # 闌
    0x95CD: 'dū,shé',  # 闍
    0x95CE: 'quán',  # 闎
    0x95CF: 'phdeng',  # 闏
    0x95D0: 'tián',  # 闐
    0x95D1: 'niè',  # 闑
    0x95D2: 'tà',  # 闒
    0x95D3: 'kǎi',  # 闓
    0x95D4: 'hé',  # 闔
    0x95D5: 'què,quē',  # 闕
    0x95D6: 'chuǎng',  # 闖
    0x95D7: 'guān',  # 闗
    0x95D8: 'dòu',  # 闘
    0x95D9: 'qǐ',  # 闙
    0x95DA: 'kuī',  # 闚
    0x95DB: 'táng,tāng,chāng',  # 闛
    0x95DC: 'guān',  # 關
    0x95DD: 'piáo',  # 闝
    0x95DE: 'kàn,hǎn',  # 闞
    0x95DF: 'xì,sè,tà',  # 闟
    0x95E0: 'huì',  # 闠
    0x95E1: 'chǎn',  # 闡
    0x95E2: 'pì',  # 闢
    0x95E3: 'dāng,dàng',  # 闣
    0x95E4: 'huán',  # 闤
    0x95E5: 'tà',  # 闥
    0x95E6: 'wén',  # 闦
    0x95E7: 'tā',  # 闧
    0x95E8: 'mén',  # 门
    0x95E9: 'shuān',  # 闩
    0x95EA: 'shǎn',  # 闪
    0x95EB: 'yán',  # 闫
    0x95EC: 'hàn,bì',  # 闬
    0x95ED: 'bì',  # 闭
    0x95EE: 'wèn',  # 问
    0x95EF: 'chuǎng',  # 闯
    0x95F0: 'rùn',  # 闰
    0x95F1: 'wéi',  # 闱
    0x95F2: 'xián',  # 闲
    0x95F3: 'hóng',  # 闳
    0x95F4: 'jiān,jiàn',  # 间
    0x95F5: 'mǐn',  # 闵
    0x95F6: 'kàng,kāng',  # 闶
    0x95F7: 'mèn,mēn',  # 闷
    0x95F8: 'zhá',  # 闸
    0x95F9: 'nào',  # 闹
    0x95FA: 'guī',  # 闺
    0x95FB: 'wén',  # 闻
    0x95FC: 'tà',  # 闼
    0x95FD: 'mǐn',  # 闽
    0x95FE: 'lǘ',  # 闾
    0x95FF: 'kǎi',  # 闿
    0x9600: 'fá',  # 阀
    0x9601: 'gé',  # 阁
    0x9602: 'hé',  # 阂
    0x9603: 'kǔn',  # 阃
    0x9604: 'jiū',  # 阄
    0x9605: 'yuè',  # 阅
    0x9606: 'làng',  # 阆
    0x9607: 'dū,shé',  # 阇
    0x9608: 'yù',  # 阈
    0x9609: 'yān',  # 阉
    0x960A: 'chāng',  # 阊
    0x960B: 'xì',  # 阋
    0x960C: 'wén',  # 阌
    0x960D: 'hūn',  # 阍
    0x960E: 'yán',  # 阎
    0x960F: 'è',  # 阏
    0x9610: 'chǎn',  # 阐
    0x9611: 'lán',  # 阑
    0x9612: 'qù',  # 阒
    0x9613: 'huì',  # 阓
    0x9614: 'kuò',  # 阔
    0x9615: 'què',  # 阕
    0x9616: 'hé',  # 阖
    0x9617: 'tián',  # 阗
    0x9618: 'tà',  # 阘
    0x9619: 'quē,què',  # 阙
    0x961A: 'kàn',  # 阚
    0x961B: 'huán',  # 阛
    0x961C: 'fù',  # 阜
    0x961D: 'fǔ',  # 阝
    0x961E: 'lè',  # 阞
    0x961F: 'duì',  # 队
    0x9620: 'xìn',  # 阠
    0x9621: 'qiān',  # 阡
    0x9622: 'wù',  # 阢
    0x9623: 'yì',  # 阣
    0x9624: 'tuó',  # 阤
    0x9625: 'yīn',  # 阥
    0x9626: 'yáng',  # 阦
    0x9627: 'dǒu',  # 阧
    0x9628: 'è',  # 阨
    0x9629: 'shēng',  # 阩
    0x962A: 'bǎn',  # 阪
    0x962B: 'péi',  # 阫
    0x962C: 'kēng',  # 阬
    0x962D: 'yǔn',  # 阭
    0x962E: 'ruǎn',  # 阮
    0x962F: 'zhǐ',  # 阯
    0x9630: 'pí',  # 阰
    0x9631: 'jǐng',  # 阱
    0x9632: 'fáng',  # 防
    0x9633: 'yáng',  # 阳
    0x9634: 'yīn',  # 阴
    0x9635: 'zhèn',  # 阵
    0x9636: 'jiē',  # 阶
    0x9637: 'chēng',  # 阷
    0x9638: 'è',  # 阸
    0x9639: 'qū',  # 阹
    0x963A: 'dǐ',  # 阺
    0x963B: 'zǔ',  # 阻
    0x963C: 'zuò',  # 阼
    0x963D: 'diàn',  # 阽
    0x963E: 'lín',  # 阾
    0x963F: 'ā,ē',  # 阿
    0x9640: 'tuó',  # 陀
    0x9641: 'tuó',  # 陁
    0x9642: 'bēi,pí,pō',  # 陂
    0x9643: 'bǐng',  # 陃
    0x9644: 'fù',  # 附
    0x9645: 'jì',  # 际
    0x9646: 'lù',  # 陆
    0x9647: 'lǒng',  # 陇
    0x9648: 'chén',  # 陈
    0x9649: 'xíng',  # 陉
    0x964A: 'duò',  # 陊
    0x964B: 'lòu',  # 陋
    0x964C: 'mò',  # 陌
    0x964D: 'jiàng,xiáng',  # 降
    0x964E: 'shū',  # 陎
    0x964F: 'duò',  # 陏
    0x9650: 'xiàn',  # 限
    0x9651: 'ér',  # 陑
    0x9652: 'guǐ',  # 陒
    0x9653: 'yū',  # 陓
    0x9654: 'gāi',  # 陔
    0x9655: 'shǎn',  # 陕
    0x9656: 'jùn',  # 陖
    0x9657: 'qiào',  # 陗
    0x9658: 'xíng',  # 陘
    0x9659: 'chún',  # 陙
    0x965A: 'wǔ',  # 陚
    0x965B: 'bì',  # 陛
    0x965C: 'xiá',  # 陜
    0x965D: 'shǎn',  # 陝
    0x965E: 'shēng',  # 陞
    0x965F: 'zhì',  # 陟
    0x9660: 'pū',  # 陠
    0x9661: 'dǒu',  # 陡
    0x9662: 'yuàn',  # 院
    0x9663: 'zhèn',  # 陣
    0x9664: 'chú',  # 除
    0x9665: 'xiàn',  # 陥
    0x9666: 'dǎo',  # 陦
    0x9667: 'niè',  # 陧
    0x9668: 'yǔn',  # 陨
    0x9669: 'xiǎn',  # 险
    0x966A: 'péi',  # 陪
    0x966B: 'fèi',  # 陫
    0x966C: 'zōu',  # 陬
    0x966D: 'qí',  # 陭
    0x966E: 'duì',  # 陮
    0x966F: 'lún',  # 陯
    0x9670: 'yīn',  # 陰
    0x9671: 'jū',  # 陱
    0x9672: 'chuí',  # 陲
    0x9673: 'chén',  # 陳
    0x9674: 'pī',  # 陴
    0x9675: 'líng',  # 陵
    0x9676: 'táo',  # 陶
    0x9677: 'xiàn',  # 陷
    0x9678: 'lù',  # 陸
    0x9679: 'shēng',  # 陹
    0x967A: 'xiǎn',  # 険
    0x967B: 'yīn',  # 陻
    0x967C: 'zhǔ',  # 陼
    0x967D: 'yáng',  # 陽
    0x967E: 'réng',  # 陾
    0x967F: 'xiá',  # 陿
    0x9680: 'chóng',  # 隀
    0x9681: 'yàn,yǎn',  # 隁
    0x9682: 'yīn',  # 隂
    0x9683: 'yú,yáo,shù',  # 隃
    0x9684: 'dī',  # 隄
    0x9685: 'yú',  # 隅
    0x9686: 'lóng',  # 隆
    0x9687: 'wēi',  # 隇
    0x9688: 'wēi',  # 隈
    0x9689: 'niè',  # 隉
    0x968A: 'duì,zhuì',  # 隊
    0x968B: 'suí,duò',  # 隋
    0x968C: 'àn',  # 隌
    0x968D: 'huáng',  # 隍
    0x968E: 'jiē',  # 階
    0x968F: 'suí',  # 随
    0x9690: 'yǐn,yìn',  # 隐
    0x9691: 'qí,gāi,ái',  # 隑
    0x9692: 'yǎn',  # 隒
    0x9693: 'huī,duò',  # 隓
    0x9694: 'gé',  # 隔
    0x9695: 'yǔn',  # 隕
    0x9696: 'wù',  # 隖
    0x9697: 'wěi,kuí',  # 隗
    0x9698: 'ài',  # 隘
    0x9699: 'xì',  # 隙
    0x969A: 'táng',  # 隚
    0x969B: 'jì',  # 際
    0x969C: 'zhàng',  # 障
    0x969D: 'dǎo',  # 隝
    0x969E: 'áo',  # 隞
    0x969F: 'xì',  # 隟
    0x96A0: 'yǐn,yìn',  # 隠
    0x96A1: 'sà',  # 隡
    0x96A2: 'rǎo',  # 隢
    0x96A3: 'lín',  # 隣
    0x96A4: 'tuí',  # 隤
    0x96A5: 'dèng',  # 隥
    0x96A6: 'pí',  # 隦
    0x96A7: 'suì',  # 隧
    0x96A8: 'suí',  # 隨
    0x96A9: 'ào,yù',  # 隩
    0x96AA: 'xiǎn',  # 險
    0x96AB: 'fén',  # 隫
    0x96AC: 'nǐ',  # 隬
    0x96AD: 'ér',  # 隭
    0x96AE: 'jī',  # 隮
    0x96AF: 'dǎo',  # 隯
    0x96B0: 'xí',  # 隰
    0x96B1: 'yǐn,yìn',  # 隱
    0x96B2: 'zhì',  # 隲
    0x96B3: 'huī,duò',  # 隳
    0x96B4: 'lǒng',  # 隴
    0x96B5: 'xī',  # 隵
    0x96B6: 'lì',  # 隶
    0x96B7: 'lì',  # 隷
    0x96B8: 'lì',  # 隸
    0x96B9: 'zhuī,cuī,wéi',  # 隹
    0x96BA: 'hú,hè',  # 隺
    0x96BB: 'zhī',  # 隻
    0x96BC: 'sǔn',  # 隼
    0x96BD: 'jùn,juàn',  # 隽
    0x96BE: 'nán,nàn,nuó',  # 难
    0x96BF: 'yì',  # 隿
    0x96C0: 'què,qiāo,qiǎo',  # 雀
    0x96C1: 'yàn',  # 雁
    0x96C2: 'qín',  # 雂
    0x96C3: 'jiān',  # 雃
    0x96C4: 'xióng',  # 雄
    0x96C5: 'yǎ',  # 雅
    0x96C6: 'jí',  # 集
    0x96C7: 'gù',  # 雇
    0x96C8: 'huán',  # 雈
    0x96C9: 'zhì',  # 雉
    0x96CA: 'gòu',  # 雊
    0x96CB: 'jùn,juàn',  # 雋
    0x96CC: 'cí',  # 雌
    0x96CD: 'yōng',  # 雍
    0x96CE: 'jū',  # 雎
    0x96CF: 'chú',  # 雏
    0x96D0: 'hū',  # 雐
    0x96D1: 'zá',  # 雑
    0x96D2: 'luò',  # 雒
    0x96D3: 'yú',  # 雓
    0x96D4: 'chóu',  # 雔
    0x96D5: 'diāo',  # 雕
    0x96D6: 'suī',  # 雖
    0x96D7: 'hàn',  # 雗
    0x96D8: 'huò',  # 雘
    0x96D9: 'shuāng',  # 雙
    0x96DA: 'guàn,huán',  # 雚
    0x96DB: 'chú',  # 雛
    0x96DC: 'zá',  # 雜
    0x96DD: 'yōng',  # 雝
    0x96DE: 'jī',  # 雞
    0x96DF: 'guī,xī',  # 雟
    0x96E0: 'chóu',  # 雠
    0x96E1: 'liù',  # 雡
    0x96E2: 'lí',  # 離
    0x96E3: 'nán,nàn,nuó',  # 難
    0x96E4: 'yù',  # 雤
    0x96E5: 'zá',  # 雥
    0x96E6: 'chóu',  # 雦
    0x96E7: 'jí',  # 雧
    0x96E8: 'yǔ,yù',  # 雨
    0x96E9: 'yú',  # 雩
    0x96EA: 'xuě',  # 雪
    0x96EB: 'nǎ',  # 雫
    0x96EC: 'fǒu',  # 雬
    0x96ED: 'sè,xí',  # 雭
    0x96EE: 'mù',  # 雮
    0x96EF: 'wén',  # 雯
    0x96F0: 'fēn',  # 雰
    0x96F1: 'pāng',  # 雱
    0x96F2: 'yún',  # 雲
    0x96F3: 'lì',  # 雳
    0x96F4: 'chì',  # 雴
    0x96F5: 'yāng',  # 雵
    0x96F6: 'líng',  # 零
    0x96F7: 'léi',  # 雷
    0x96F8: 'án',  # 雸
    0x96F9: 'báo',  # 雹
    0x96FA: 'wù,méng',  # 雺
    0x96FB: 'diàn',  # 電
    0x96FC: 'dàng',  # 雼
    0x96FD: 'hū,hù',  # 雽
    0x96FE: 'wù',  # 雾
    0x96FF: 'diào',  # 雿
    0x9700: 'xū',  # 需
    0x9701: 'jì',  # 霁
    0x9702: 'mù',  # 霂
    0x9703: 'chén',  # 霃
    0x9704: 'xiāo',  # 霄
    0x9705: 'zhá',  # 霅
    0x9706: 'tíng',  # 霆
    0x9707: 'zhèn',  # 震
    0x9708: 'pèi',  # 霈
    0x9709: 'méi',  # 霉
    0x970A: 'líng',  # 霊
    0x970B: 'qī',  # 霋
    0x970C: 'zhōu',  # 霌
    0x970D: 'huò',  # 霍
    0x970E: 'shà',  # 霎
    0x970F: 'fēi',  # 霏
    0x9710: 'hóng',  # 霐
    0x9711: 'zhān',  # 霑
    0x9712: 'yīn',  # 霒
    0x9713: 'ní',  # 霓
    0x9714: 'shù',  # 霔
    0x9715: 'tún',  # 霕
    0x9716: 'lín',  # 霖
    0x9717: 'líng',  # 霗
    0x9718: 'dòng',  # 霘
    0x9719: 'yīng',  # 霙
    0x971A: 'wù',  # 霚
    0x971B: 'líng',  # 霛
    0x971C: 'shuāng',  # 霜
    0x971D: 'líng',  # 霝
    0x971E: 'xiá',  # 霞
    0x971F: 'hóng',  # 霟
    0x9720: 'yīn',  # 霠
    0x9721: 'mài',  # 霡
    0x9722: 'mài',  # 霢
    0x9723: 'yǔn',  # 霣
    0x9724: 'liù',  # 霤
    0x9725: 'mèng',  # 霥
    0x9726: 'bīn',  # 霦
    0x9727: 'wù',  # 霧
    0x9728: 'wèi',  # 霨
    0x9729: 'kuò',  # 霩
    0x972A: 'yín',  # 霪
    0x972B: 'xí',  # 霫
    0x972C: 'yì',  # 霬
    0x972D: 'ǎi',  # 霭
    0x972E: 'dàn',  # 霮
    0x972F: 'tèng',  # 霯
    0x9730: 'xiàn',  # 霰
    0x9731: 'yù',  # 霱
    0x9732: 'lòu,lù',  # 露
    0x9733: 'lóng',  # 霳
    0x9734: 'dài',  # 霴
    0x9735: 'jí',  # 霵
    0x9736: 'pāng',  # 霶
    0x9737: 'yáng',  # 霷
    0x9738: 'bà',  # 霸
    0x9739: 'pī',  # 霹
    0x973A: 'wēi',  # 霺
    0x973B: 'fēng',  # 霻
    0x973C: 'xì',  # 霼
    0x973D: 'jì',  # 霽
    0x973E: 'mái',  # 霾
    0x973F: 'méng',  # 霿
    0x9740: 'méng',  # 靀
    0x9741: 'léi',  # 靁
    0x9742: 'lì',  # 靂
    0x9743: 'huò',  # 靃
    0x9744: 'ǎi',  # 靄
    0x9745: 'fèi',  # 靅
    0x9746: 'dài',  # 靆
    0x9747: 'lóng',  # 靇
    0x9748: 'lìng',  # 靈
    0x9749: 'ài',  # 靉
    0x974A: 'fēng',  # 靊
    0x974B: 'lì',  # 靋
    0x974C: 'bǎo',  # 靌
    0x974D: 'hè',  # 靍
    0x974E: 'hè',  # 靎
    0x974F: 'hè',  # 靏
    0x9750: 'bìng',  # 靐
    0x9751: 'qīng',  # 靑
    0x9752: 'qīng',  # 青
    0x9753: 'jìng,liàng',  # 靓
    0x9754: 'tiān',  # 靔
    0x9755: 'zhèng',  # 靕
    0x9756: 'jìng',  # 靖
    0x9757: 'chēng',  # 靗
    0x9758: 'qìng',  # 靘
    0x9759: 'jìng',  # 静
    0x975A: 'jìng',  # 靚
    0x975B: 'diàn',  # 靛
    0x975C: 'jìng',  # 靜
    0x975D: 'tiān',  # 靝
    0x975E: 'fēi',  # 非
    0x975F: 'fēi',  # 靟
    0x9760: 'kào',  # 靠
    0x9761: 'mí',  # 靡
    0x9762: 'miàn',  # 面
    0x9763: 'miàn',  # 靣
    0x9764: 'pào',  # 靤
    0x9765: 'yè',  # 靥
    0x9766: 'miǎn',  # 靦
    0x9767: 'huì',  # 靧
    0x9768: 'yè',  # 靨
    0x9769: 'gé',  # 革
    0x976A: 'dīng',  # 靪
    0x976B: 'chá',  # 靫
    0x976C: 'jiān',  # 靬
    0x976D: 'rèn',  # 靭
    0x976E: 'dí',  # 靮
    0x976F: 'dù',  # 靯
    0x9770: 'wù',  # 靰
    0x9771: 'rèn',  # 靱
    0x9772: 'qín',  # 靲
    0x9773: 'jìn',  # 靳
    0x9774: 'xuē',  # 靴
    0x9775: 'niǔ',  # 靵
    0x9776: 'bǎ',  # 靶
    0x9777: 'yǐn',  # 靷
    0x9778: 'sǎ',  # 靸
    0x9779: 'nà',  # 靹
    0x977A: 'mò',  # 靺
    0x977B: 'zǔ',  # 靻
    0x977C: 'dá',  # 靼
    0x977D: 'bàn',  # 靽
    0x977E: 'xiè',  # 靾
    0x977F: 'yào',  # 靿
    0x9780: 'táo',  # 鞀
    0x9781: 'bèi',  # 鞁
    0x9782: 'jiē',  # 鞂
    0x9783: 'hóng',  # 鞃
    0x9784: 'páo',  # 鞄
    0x9785: 'yāng,yàng',  # 鞅
    0x9786: 'bǐng',  # 鞆
    0x9787: 'yīn',  # 鞇
    0x9788: 'gé,tà,sǎ',  # 鞈
    0x9789: 'táo',  # 鞉
    0x978A: 'jié,jí',  # 鞊
    0x978B: 'xié',  # 鞋
    0x978C: 'ān',  # 鞌
    0x978D: 'ān',  # 鞍
    0x978E: 'hén',  # 鞎
    0x978F: 'gǒng',  # 鞏
    0x9790: 'qiǎ',  # 鞐
    0x9791: 'dá',  # 鞑
    0x9792: 'qiáo',  # 鞒
    0x9793: 'tīng',  # 鞓
    0x9794: 'mán,mèn',  # 鞔
    0x9795: 'biān,yìng',  # 鞕
    0x9796: 'suī',  # 鞖
    0x9797: 'tiáo',  # 鞗
    0x9798: 'qiào,shāo',  # 鞘
    0x9799: 'xuān,juān',  # 鞙
    0x979A: 'kòng',  # 鞚
    0x979B: 'běng',  # 鞛
    0x979C: 'tà',  # 鞜
    0x979D: 'shàng,zhǎng',  # 鞝
    0x979E: 'bǐng,pí,bì,bēi',  # 鞞
    0x979F: 'kuò',  # 鞟
    0x97A0: 'jū',  # 鞠
    0x97A1: 'la',  # 鞡
    0x97A2: 'xiè,dié',  # 鞢
    0x97A3: 'róu',  # 鞣
    0x97A4: 'bāng',  # 鞤
    0x97A5: 'ēng',  # 鞥
    0x97A6: 'qiū',  # 鞦
    0x97A7: 'qiū',  # 鞧
    0x97A8: 'hé',  # 鞨
    0x97A9: 'qiào',  # 鞩
    0x97AA: 'mù,móu',  # 鞪
    0x97AB: 'jū',  # 鞫
    0x97AC: 'jiàn,jiān',  # 鞬
    0x97AD: 'biān',  # 鞭
    0x97AE: 'dī',  # 鞮
    0x97AF: 'jiān',  # 鞯
    0x97B0: 'wēn,yùn',  # 鞰
    0x97B1: 'tāo',  # 鞱
    0x97B2: 'gōu',  # 鞲
    0x97B3: 'tà',  # 鞳
    0x97B4: 'bèi',  # 鞴
    0x97B5: 'xié',  # 鞵
    0x97B6: 'pán',  # 鞶
    0x97B7: 'gé',  # 鞷
    0x97B8: 'bì,bǐng',  # 鞸
    0x97B9: 'kuò',  # 鞹
    0x97BA: 'tāng',  # 鞺
    0x97BB: 'lóu',  # 鞻
    0x97BC: 'guì',  # 鞼
    0x97BD: 'qiáo',  # 鞽
    0x97BE: 'xuē',  # 鞾
    0x97BF: 'jī',  # 鞿
    0x97C0: 'jiān',  # 韀
    0x97C1: 'jiāng',  # 韁
    0x97C2: 'chàn',  # 韂
    0x97C3: 'dá',  # 韃
    0x97C4: 'huò',  # 韄
    0x97C5: 'xiǎn',  # 韅
    0x97C6: 'qiān',  # 韆
    0x97C7: 'dú',  # 韇
    0x97C8: 'wā',  # 韈
    0x97C9: 'jiān',  # 韉
    0x97CA: 'lán',  # 韊
    0x97CB: 'wéi',  # 韋
    0x97CC: 'rèn',  # 韌
    0x97CD: 'fú',  # 韍
    0x97CE: 'mèi,wà',  # 韎
    0x97CF: 'quàn',  # 韏
    0x97D0: 'gé',  # 韐
    0x97D1: 'wěi',  # 韑
    0x97D2: 'qiào',  # 韒
    0x97D3: 'hán',  # 韓
    0x97D4: 'chàng',  # 韔
    0x97D5: 'kuò',  # 韕
    0x97D6: 'rǒu',  # 韖
    0x97D7: 'yùn',  # 韗
    0x97D8: 'shè,xiè',  # 韘
    0x97D9: 'wěi',  # 韙
    0x97DA: 'gé',  # 韚
    0x97DB: 'bài',  # 韛
    0x97DC: 'tāo',  # 韜
    0x97DD: 'gōu',  # 韝
    0x97DE: 'yùn',  # 韞
    0x97DF: 'gāo',  # 韟
    0x97E0: 'bì',  # 韠
    0x97E1: 'wěi',  # 韡
    0x97E2: 'suì',  # 韢
    0x97E3: 'dú',  # 韣
    0x97E4: 'wà',  # 韤
    0x97E5: 'dú',  # 韥
    0x97E6: 'wéi',  # 韦
    0x97E7: 'rèn',  # 韧
    0x97E8: 'fú',  # 韨
    0x97E9: 'hán',  # 韩
    0x97EA: 'wěi',  # 韪
    0x97EB: 'yùn,wēn',  # 韫
    0x97EC: 'tāo',  # 韬
    0x97ED: 'jiǔ',  # 韭
    0x97EE: 'jiǔ',  # 韮
    0x97EF: 'xiān',  # 韯
    0x97F0: 'xiè',  # 韰
    0x97F1: 'xiān',  # 韱
    0x97F2: 'jī',  # 韲
    0x97F3: 'yīn',  # 音
    0x97F4: 'zá',  # 韴
    0x97F5: 'yùn',  # 韵
    0x97F6: 'sháo',  # 韶
    0x97F7: 'lè',  # 韷
    0x97F8: 'péng',  # 韸
    0x97F9: 'huáng',  # 韹
    0x97FA: 'yīng',  # 韺
    0x97FB: 'yùn',  # 韻
    0x97FC: 'péng',  # 韼
    0x97FD: 'ān',  # 韽
    0x97FE: 'yīn',  # 韾
    0x97FF: 'xiǎng',  # 響
    0x9800: 'hù',  # 頀
    0x9801: 'yè',  # 頁
    0x9802: 'dǐng',  # 頂
    0x9803: 'qǐng',  # 頃
    0x9804: 'qiú',  # 頄
    0x9805: 'xiàng',  # 項
    0x9806: 'shùn',  # 順
    0x9807: 'hān',  # 頇
    0x9808: 'xū',  # 須
    0x9809: 'yí',  # 頉
    0x980A: 'xū',  # 頊
    0x980B: 'ě',  # 頋
    0x980C: 'sòng',  # 頌
    0x980D: 'kuǐ',  # 頍
    0x980E: 'qí',  # 頎
    0x980F: 'háng',  # 頏
    0x9810: 'yù',  # 預
    0x9811: 'wán',  # 頑
    0x9812: 'bān',  # 頒
    0x9813: 'dùn',  # 頓
    0x9814: 'dí',  # 頔
    0x9815: 'dān',  # 頕
    0x9816: 'pàn',  # 頖
    0x9817: 'pō',  # 頗
    0x9818: 'lǐng',  # 領
    0x9819: 'chè',  # 頙
    0x981A: 'jǐng',  # 頚
    0x981B: 'lèi',  # 頛
    0x981C: 'hé',  # 頜
    0x981D: 'qiāo',  # 頝
    0x981E: 'è',  # 頞
    0x981F: 'é',  # 頟
    0x9820: 'wěi',  # 頠
    0x9821: 'jié',  # 頡
    0x9822: 'kuò',  # 頢
    0x9823: 'shěn',  # 頣
    0x9824: 'yí',  # 頤
    0x9825: 'yí',  # 頥
    0x9826: 'kē',  # 頦
    0x9827: 'duǐ',  # 頧
    0x9828: 'yǔ',  # 頨
    0x9829: 'pīng',  # 頩
    0x982A: 'lèi',  # 頪
    0x982B: 'fǔ',  # 頫
    0x982C: 'jiá',  # 頬
    0x982D: 'tóu',  # 頭
    0x982E: 'huì',  # 頮
    0x982F: 'kuí',  # 頯
    0x9830: 'jiá',  # 頰
    0x9831: 'luō',  # 頱
    0x9832: 'tǐng',  # 頲
    0x9833: 'chēng',  # 頳
    0x9834: 'yǐng',  # 頴
    0x9835: 'jūn',  # 頵
    0x9836: 'hú',  # 頶
    0x9837: 'hàn',  # 頷
    0x9838: 'jǐng',  # 頸
    0x9839: 'tuí',  # 頹
    0x983A: 'tuí',  # 頺
    0x983B: 'bīn',  # 頻
    0x983C: 'lài',  # 頼
    0x983D: 'tuí',  # 頽
    0x983E: 'zī',  # 頾
    0x983F: 'zī',  # 頿
    0x9840: 'chuí',  # 顀
    0x9841: 'dìng',  # 顁
    0x9842: 'lài',  # 顂
    0x9843: 'tán',  # 顃
    0x9844: 'hàn',  # 顄
    0x9845: 'qiān',  # 顅
    0x9846: 'kē',  # 顆
    0x9847: 'cuì',  # 顇
    0x9848: 'jiǒng',  # 顈
    0x9849: 'qīn',  # 顉
    0x984A: 'yí',  # 顊
    0x984B: 'sāi',  # 顋
    0x984C: 'tí',  # 題
    0x984D: 'é',  # 額
    0x984E: 'è',  # 顎
    0x984F: 'yán',  # 顏
    0x9850: 'wèn',  # 顐
    0x9851: 'kǎn',  # 顑
    0x9852: 'yóng',  # 顒
    0x9853: 'zhuān',  # 顓
    0x9854: 'yán',  # 顔
    0x9855: 'xiǎn',  # 顕
    0x9856: 'xìn',  # 顖
    0x9857: 'yǐ',  # 顗
    0x9858: 'yuàn',  # 願
    0x9859: 'sǎng',  # 顙
    0x985A: 'diān',  # 顚
    0x985B: 'diān',  # 顛
    0x985C: 'jiǎng',  # 顜
    0x985D: 'kuī',  # 顝
    0x985E: 'lèi',  # 類
    0x985F: 'láo',  # 顟
    0x9860: 'piǎo',  # 顠
    0x9861: 'wài',  # 顡
    0x9862: 'mān',  # 顢
    0x9863: 'cù',  # 顣
    0x9864: 'yáo',  # 顤
    0x9865: 'hào',  # 顥
    0x9866: 'qiáo',  # 顦
    0x9867: 'gù',  # 顧
    0x9868: 'xùn',  # 顨
    0x9869: 'yǎn',  # 顩
    0x986A: 'huì',  # 顪
    0x986B: 'chàn',  # 顫
    0x986C: 'rú',  # 顬
    0x986D: 'méng',  # 顭
    0x986E: 'bīn',  # 顮
    0x986F: 'xiǎn',  # 顯
    0x9870: 'pín',  # 顰
    0x9871: 'lú',  # 顱
    0x9872: 'lǎn',  # 顲
    0x9873: 'niè',  # 顳
    0x9874: 'quán',  # 顴
    0x9875: 'yè',  # 页
    0x9876: 'dǐng',  # 顶
    0x9877: 'qǐng',  # 顷
    0x9878: 'hān',  # 顸
    0x9879: 'xiàng',  # 项
    0x987A: 'shùn',  # 顺
    0x987B: 'xū',  # 须
    0x987C: 'xū',  # 顼
    0x987D: 'wán',  # 顽
    0x987E: 'gù',  # 顾
    0x987F: 'dùn',  # 顿
    0x9880: 'qí',  # 颀
    0x9881: 'bān',  # 颁
    0x9882: 'sòng',  # 颂
    0x9883: 'háng',  # 颃
    0x9884: 'yù',  # 预
    0x9885: 'lú',  # 颅
    0x9886: 'lǐng',  # 领
    0x9887: 'pō',  # 颇
    0x9888: 'jǐng,gěng',  # 颈
    0x9889: 'jié,xié,jiá',  # 颉
    0x988A: 'jiá',  # 颊
    0x988B: 'tǐng',  # 颋
    0x988C: 'hé,gé',  # 颌
    0x988D: 'yǐng',  # 颍
    0x988E: 'jiǒng',  # 颎
    0x988F: 'kē',  # 颏
    0x9890: 'yí',  # 颐
    0x9891: 'pín,bīn',  # 频
    0x9892: 'huì',  # 颒
    0x9893: 'tuí',  # 颓
    0x9894: 'hàn',  # 颔
    0x9895: 'yǐng',  # 颕
    0x9896: 'yǐng',  # 颖
    0x9897: 'kē',  # 颗
    0x9898: 'tí',  # 题
    0x9899: 'yóng',  # 颙
    0x989A: 'è',  # 颚
    0x989B: 'zhuān',  # 颛
    0x989C: 'yán',  # 颜
    0x989D: 'é',  # 额
    0x989E: 'niè',  # 颞
    0x989F: 'mān',  # 颟
    0x98A0: 'diān',  # 颠
    0x98A1: 'sǎng',  # 颡
    0x98A2: 'hào',  # 颢
    0x98A3: 'lèi',  # 颣
    0x98A4: 'chàn,zhàn',  # 颤
    0x98A5: 'rú',  # 颥
    0x98A6: 'pín',  # 颦
    0x98A7: 'quán',  # 颧
    0x98A8: 'fēng,fěng',  # 風
    0x98A9: 'biāo,diū',  # 颩
    0x98AA: 'guā',  # 颪
    0x98AB: 'fú',  # 颫
    0x98AC: 'xiā',  # 颬
    0x98AD: 'zhǎn',  # 颭
    0x98AE: 'biāo',  # 颮
    0x98AF: 'sà',  # 颯
    0x98B0: 'bá,fú',  # 颰
    0x98B1: 'tái',  # 颱
    0x98B2: 'liè',  # 颲
    0x98B3: 'guā',  # 颳
    0x98B4: 'xuàn',  # 颴
    0x98B5: 'xiāo',  # 颵
    0x98B6: 'jù',  # 颶
    0x98B7: 'biāo',  # 颷
    0x98B8: 'sī',  # 颸
    0x98B9: 'wěi',  # 颹
    0x98BA: 'yáng',  # 颺
    0x98BB: 'yáo',  # 颻
    0x98BC: 'sōu',  # 颼
    0x98BD: 'kǎi',  # 颽
    0x98BE: 'sāo,sōu',  # 颾
    0x98BF: 'fān',  # 颿
    0x98C0: 'liú',  # 飀
    0x98C1: 'xí',  # 飁
    0x98C2: 'liù,liáo',  # 飂
    0x98C3: 'piāo',  # 飃
    0x98C4: 'piāo',  # 飄
    0x98C5: 'liú',  # 飅
    0x98C6: 'biāo',  # 飆
    0x98C7: 'biāo',  # 飇
    0x98C8: 'biāo',  # 飈
    0x98C9: 'liáo',  # 飉
    0x98CA: 'biāo',  # 飊
    0x98CB: 'sè',  # 飋
    0x98CC: 'fēng',  # 飌
    0x98CD: 'xiū',  # 飍
    0x98CE: 'fēng,fěng',  # 风
    0x98CF: 'yáng',  # 飏
    0x98D0: 'zhǎn',  # 飐
    0x98D1: 'biāo',  # 飑
    0x98D2: 'sà',  # 飒
    0x98D3: 'jù',  # 飓
    0x98D4: 'sī',  # 飔
    0x98D5: 'sōu',  # 飕
    0x98D6: 'yáo',  # 飖
    0x98D7: 'liú',  # 飗
    0x98D8: 'piāo',  # 飘
    0x98D9: 'biāo',  # 飙
    0x98DA: 'biāo',  # 飚
    0x98DB: 'fēi',  # 飛
    0x98DC: 'fān',  # 飜
    0x98DD: 'fēi',  # 飝
    0x98DE: 'fēi',  # 飞
    0x98DF: 'shí,sì,yì',  # 食
    0x98E0: 'shí',  # 飠
    0x98E1: 'cān',  # 飡
    0x98E2: 'jī',  # 飢
    0x98E3: 'dìng',  # 飣
    0x98E4: 'sì',  # 飤
    0x98E5: 'tuō',  # 飥
    0x98E6: 'zhān',  # 飦
    0x98E7: 'sūn',  # 飧
    0x98E8: 'xiǎng',  # 飨
    0x98E9: 'tún',  # 飩
    0x98EA: 'rèn',  # 飪
    0x98EB: 'yù',  # 飫
    0x98EC: 'yǎng,juàn',  # 飬
    0x98ED: 'chì',  # 飭
    0x98EE: 'yǐn,yìn',  # 飮
    0x98EF: 'fàn',  # 飯
    0x98F0: 'fàn',  # 飰
    0x98F1: 'sūn',  # 飱
    0x98F2: 'yǐn,yìn',  # 飲
    0x98F3: 'zhù,tǒu',  # 飳
    0x98F4: 'yí,sì',  # 飴
    0x98F5: 'zuò,zé,zhā',  # 飵
    0x98F6: 'bì',  # 飶
    0x98F7: 'jiě',  # 飷
    0x98F8: 'tāo',  # 飸
    0x98F9: 'bǎo',  # 飹
    0x98FA: 'cí',  # 飺
    0x98FB: 'tiè',  # 飻
    0x98FC: 'sì',  # 飼
    0x98FD: 'bǎo',  # 飽
    0x98FE: 'shì',  # 飾
    0x98FF: 'duò',  # 飿
    0x9900: 'hài',  # 餀
    0x9901: 'rèn',  # 餁
    0x9902: 'tiǎn',  # 餂
    0x9903: 'jiǎo',  # 餃
    0x9904: 'hé',  # 餄
    0x9905: 'bǐng',  # 餅
    0x9906: 'yáo',  # 餆
    0x9907: 'tóng',  # 餇
    0x9908: 'cí',  # 餈
    0x9909: 'xiǎng',  # 餉
    0x990A: 'yǎng',  # 養
    0x990B: 'juàn',  # 餋
    0x990C: 'ěr',  # 餌
    0x990D: 'yàn',  # 餍
    0x990E: 'lè',  # 餎
    0x990F: 'xī',  # 餏
    0x9910: 'cān',  # 餐
    0x9911: 'bō',  # 餑
    0x9912: 'něi',  # 餒
    0x9913: 'è',  # 餓
    0x9914: 'bū',  # 餔
    0x9915: 'jùn',  # 餕
    0x9916: 'dòu',  # 餖
    0x9917: 'sù',  # 餗
    0x9918: 'yú',  # 餘
    0x9919: 'shì',  # 餙
    0x991A: 'yáo',  # 餚
    0x991B: 'hún',  # 餛
    0x991C: 'guǒ',  # 餜
    0x991D: 'shì',  # 餝
    0x991E: 'jiàn',  # 餞
    0x991F: 'chuò',  # 餟
    0x9920: 'bǐng',  # 餠
    0x9921: 'xiàn',  # 餡
    0x9922: 'bù',  # 餢
    0x9923: 'yè',  # 餣
    0x9924: 'dàn',  # 餤
    0x9925: 'fēi',  # 餥
    0x9926: 'zhāng',  # 餦
    0x9927: 'wèi',  # 餧
    0x9928: 'guǎn',  # 館
    0x9929: 'è',  # 餩
    0x992A: 'nuǎn',  # 餪
    0x992B: 'yùn',  # 餫
    0x992C: 'hú',  # 餬
    0x992D: 'huáng',  # 餭
    0x992E: 'tiè',  # 餮
    0x992F: 'huì',  # 餯
    0x9930: 'jiān',  # 餰
    0x9931: 'hóu',  # 餱
    0x9932: 'ài',  # 餲
    0x9933: 'xíng',  # 餳
    0x9934: 'fēn',  # 餴
    0x9935: 'wèi',  # 餵
    0x9936: 'gǔ',  # 餶
    0x9937: 'chā',  # 餷
    0x9938: 'sòng',  # 餸
    0x9939: 'táng',  # 餹
    0x993A: 'bó',  # 餺
    0x993B: 'gāo',  # 餻
    0x993C: 'xì',  # 餼
    0x993D: 'kuì',  # 餽
    0x993E: 'liù',  # 餾
    0x993F: 'sōu',  # 餿
    0x9940: 'táo',  # 饀
    0x9941: 'yè',  # 饁
    0x9942: 'wēn',  # 饂
    0x9943: 'mó',  # 饃
    0x9944: 'táng',  # 饄
    0x9945: 'mán',  # 饅
    0x9946: 'bì',  # 饆
    0x9947: 'yù',  # 饇
    0x9948: 'xiū',  # 饈
    0x9949: 'jǐn',  # 饉
    0x994A: 'sǎn',  # 饊
    0x994B: 'kuì',  # 饋
    0x994C: 'zhuàn',  # 饌
    0x994D: 'shàn',  # 饍
    0x994E: 'xī',  # 饎
    0x994F: 'dàn',  # 饏
    0x9950: 'yì',  # 饐
    0x9951: 'jī',  # 饑
    0x9952: 'ráo',  # 饒
    0x9953: 'chēng',  # 饓
    0x9954: 'yōng',  # 饔
    0x9955: 'tāo',  # 饕
    0x9956: 'wèi',  # 饖
    0x9957: 'xiǎng',  # 饗
    0x9958: 'zhān',  # 饘
    0x9959: 'fēn',  # 饙
    0x995A: 'hài',  # 饚
    0x995B: 'méng',  # 饛
    0x995C: 'yàn',  # 饜
    0x995D: 'mó',  # 饝
    0x995E: 'chán',  # 饞
    0x995F: 'xiǎng,náng',  # 饟
    0x9960: 'luó',  # 饠
    0x9961: 'zàn',  # 饡
    0x9962: 'náng',  # 饢
    0x9963: 'shí',  # 饣
    0x9964: 'dìng',  # 饤
    0x9965: 'jī',  # 饥
    0x9966: 'tuō',  # 饦
    0x9967: 'xíng',  # 饧
    0x9968: 'tún',  # 饨
    0x9969: 'xì',  # 饩
    0x996A: 'rèn',  # 饪
    0x996B: 'yù',  # 饫
    0x996C: 'chì',  # 饬
    0x996D: 'fàn',  # 饭
    0x996E: 'yǐn',  # 饮
    0x996F: 'jiàn',  # 饯
    0x9970: 'shì',  # 饰
    0x9971: 'bǎo',  # 饱
    0x9972: 'sì',  # 饲
    0x9973: 'duò',  # 饳
    0x9974: 'yí',  # 饴
    0x9975: 'ěr',  # 饵
    0x9976: 'ráo',  # 饶
    0x9977: 'xiǎng',  # 饷
    0x9978: 'hé',  # 饸
    0x9979: 'gē,le',  # 饹
    0x997A: 'jiǎo',  # 饺
    0x997B: 'xī',  # 饻
    0x997C: 'bǐng',  # 饼
    0x997D: 'bō',  # 饽
    0x997E: 'dòu',  # 饾
    0x997F: 'è',  # 饿
    0x9980: 'yú',  # 馀
    0x9981: 'něi',  # 馁
    0x9982: 'jùn',  # 馂
    0x9983: 'guǒ',  # 馃
    0x9984: 'hún',  # 馄
    0x9985: 'xiàn',  # 馅
    0x9986: 'guǎn',  # 馆
    0x9987: 'chā',  # 馇
    0x9988: 'kuì',  # 馈
    0x9989: 'gǔ',  # 馉
    0x998A: 'sōu',  # 馊
    0x998B: 'chán',  # 馋
    0x998C: 'yè',  # 馌
    0x998D: 'mó',  # 馍
    0x998E: 'bó',  # 馎
    0x998F: 'liù,liú',  # 馏
    0x9990: 'xiū',  # 馐
    0x9991: 'jǐn',  # 馑
    0x9992: 'mán',  # 馒
    0x9993: 'sǎn',  # 馓
    0x9994: 'zhuàn',  # 馔
    0x9995: 'náng,nǎng',  # 馕
    0x9996: 'shǒu',  # 首
    0x9997: 'kuí',  # 馗
    0x9998: 'guó',  # 馘
    0x9999: 'xiāng',  # 香
    0x999A: 'fēn',  # 馚
    0x999B: 'bó',  # 馛
    0x999C: 'ní',  # 馜
    0x999D: 'bì',  # 馝
    0x999E: 'bó',  # 馞
    0x999F: 'tú',  # 馟
    0x99A0: 'hān',  # 馠
    0x99A1: 'fēi',  # 馡
    0x99A2: 'jiān',  # 馢
    0x99A3: 'ān',  # 馣
    0x99A4: 'ài',  # 馤
    0x99A5: 'fù',  # 馥
    0x99A6: 'xiān',  # 馦
    0x99A7: 'yūn,wò',  # 馧
    0x99A8: 'xīn',  # 馨
    0x99A9: 'fén',  # 馩
    0x99AA: 'pīn',  # 馪
    0x99AB: 'xīn',  # 馫
    0x99AC: 'mǎ',  # 馬
    0x99AD: 'yù',  # 馭
    0x99AE: 'féng,píng',  # 馮
    0x99AF: 'hàn,hán',  # 馯
    0x99B0: 'dí',  # 馰
    0x99B1: 'tuó,duò',  # 馱
    0x99B2: 'tuō,zhé',  # 馲
    0x99B3: 'chí',  # 馳
    0x99B4: 'xùn',  # 馴
    0x99B5: 'zhù',  # 馵
    0x99B6: 'zhī,shì',  # 馶
    0x99B7: 'pèi',  # 馷
    0x99B8: 'xìn,jìn',  # 馸
    0x99B9: 'rì',  # 馹
    0x99BA: 'sà',  # 馺
    0x99BB: 'yǔn',  # 馻
    0x99BC: 'wén',  # 馼
    0x99BD: 'zhí',  # 馽
    0x99BE: 'dǎn,dàn',  # 馾
    0x99BF: 'lú',  # 馿
    0x99C0: 'yóu',  # 駀
    0x99C1: 'bó',  # 駁
    0x99C2: 'bǎo',  # 駂
    0x99C3: 'jué,kuài',  # 駃
    0x99C4: 'tuó,duò',  # 駄
    0x99C5: 'yì',  # 駅
    0x99C6: 'qū',  # 駆
    0x99C7: 'wén',  # 駇
    0x99C8: 'qū',  # 駈
    0x99C9: 'jiōng',  # 駉
    0x99CA: 'pǒ',  # 駊
    0x99CB: 'zhāo',  # 駋
    0x99CC: 'yuān',  # 駌
    0x99CD: 'pēng',  # 駍
    0x99CE: 'zhòu',  # 駎
    0x99CF: 'jù',  # 駏
    0x99D0: 'zhù',  # 駐
    0x99D1: 'nú',  # 駑
    0x99D2: 'jū',  # 駒
    0x99D3: 'pī',  # 駓
    0x99D4: 'zǎng',  # 駔
    0x99D5: 'jià',  # 駕
    0x99D6: 'líng',  # 駖
    0x99D7: 'zhěn',  # 駗
    0x99D8: 'tái,dài',  # 駘
    0x99D9: 'fù',  # 駙
    0x99DA: 'yǎng',  # 駚
    0x99DB: 'shǐ',  # 駛
    0x99DC: 'bì',  # 駜
    0x99DD: 'tuó',  # 駝
    0x99DE: 'tuó',  # 駞
    0x99DF: 'sì',  # 駟
    0x99E0: 'liú',  # 駠
    0x99E1: 'mà',  # 駡
    0x99E2: 'pián',  # 駢
    0x99E3: 'táo',  # 駣
    0x99E4: 'zhì',  # 駤
    0x99E5: 'róng',  # 駥
    0x99E6: 'téng',  # 駦
    0x99E7: 'dòng',  # 駧
    0x99E8: 'xún,xuān',  # 駨
    0x99E9: 'quán',  # 駩
    0x99EA: 'shēn',  # 駪
    0x99EB: 'jiōng',  # 駫
    0x99EC: 'ěr',  # 駬
    0x99ED: 'hài',  # 駭
    0x99EE: 'bó',  # 駮
    0x99EF: 'zhū',  # 駯
    0x99F0: 'yīn',  # 駰
    0x99F1: 'luò',  # 駱
    0x99F2: 'zhōu',  # 駲
    0x99F3: 'dàn',  # 駳
    0x99F4: 'hài',  # 駴
    0x99F5: 'liú',  # 駵
    0x99F6: 'jú',  # 駶
    0x99F7: 'sǒng',  # 駷
    0x99F8: 'qīn',  # 駸
    0x99F9: 'máng',  # 駹
    0x99FA: 'liáng,láng',  # 駺
    0x99FB: 'hàn',  # 駻
    0x99FC: 'tú',  # 駼
    0x99FD: 'xuān',  # 駽
    0x99FE: 'tuì',  # 駾
    0x99FF: 'jùn',  # 駿
    0x9A00: 'ě',  # 騀
    0x9A01: 'chěng',  # 騁
    0x9A02: 'xīng',  # 騂
    0x9A03: 'sì',  # 騃
    0x9A04: 'lù',  # 騄
    0x9A05: 'zhuī',  # 騅
    0x9A06: 'zhōu',  # 騆
    0x9A07: 'shè',  # 騇
    0x9A08: 'pián',  # 騈
    0x9A09: 'kūn',  # 騉
    0x9A0A: 'táo',  # 騊
    0x9A0B: 'lái',  # 騋
    0x9A0C: 'zōng',  # 騌
    0x9A0D: 'kè',  # 騍
    0x9A0E: 'qí',  # 騎
    0x9A0F: 'qí',  # 騏
    0x9A10: 'yàn',  # 騐
    0x9A11: 'fēi',  # 騑
    0x9A12: 'sāo',  # 騒
    0x9A13: 'yàn',  # 験
    0x9A14: 'gé',  # 騔
    0x9A15: 'yǎo',  # 騕
    0x9A16: 'wù',  # 騖
    0x9A17: 'piàn',  # 騗
    0x9A18: 'cōng',  # 騘
    0x9A19: 'piàn',  # 騙
    0x9A1A: 'qián',  # 騚
    0x9A1B: 'fēi',  # 騛
    0x9A1C: 'huáng',  # 騜
    0x9A1D: 'qián',  # 騝
    0x9A1E: 'huō',  # 騞
    0x9A1F: 'yú',  # 騟
    0x9A20: 'tí',  # 騠
    0x9A21: 'quán',  # 騡
    0x9A22: 'xiá',  # 騢
    0x9A23: 'zōng',  # 騣
    0x9A24: 'kuí',  # 騤
    0x9A25: 'róu',  # 騥
    0x9A26: 'sī',  # 騦
    0x9A27: 'guā',  # 騧
    0x9A28: 'tuó',  # 騨
    0x9A29: 'guī',  # 騩
    0x9A2A: 'sōu',  # 騪
    0x9A2B: 'qiān',  # 騫
    0x9A2C: 'chéng',  # 騬
    0x9A2D: 'zhì',  # 騭
    0x9A2E: 'liú',  # 騮
    0x9A2F: 'péng',  # 騯
    0x9A30: 'téng',  # 騰
    0x9A31: 'xí',  # 騱
    0x9A32: 'cǎo',  # 騲
    0x9A33: 'dú',  # 騳
    0x9A34: 'yàn',  # 騴
    0x9A35: 'yuán',  # 騵
    0x9A36: 'zōu',  # 騶
    0x9A37: 'sāo',  # 騷
    0x9A38: 'shàn',  # 騸
    0x9A39: 'qí',  # 騹
    0x9A3A: 'zhì',  # 騺
    0x9A3B: 'shuāng',  # 騻
    0x9A3C: 'lù',  # 騼
    0x9A3D: 'xí',  # 騽
    0x9A3E: 'luó',  # 騾
    0x9A3F: 'zhāng',  # 騿
    0x9A40: 'mò',  # 驀
    0x9A41: 'ào',  # 驁
    0x9A42: 'cān',  # 驂
    0x9A43: 'piào',  # 驃
    0x9A44: 'cōng',  # 驄
    0x9A45: 'qū',  # 驅
    0x9A46: 'bì',  # 驆
    0x9A47: 'zhì',  # 驇
    0x9A48: 'yù',  # 驈
    0x9A49: 'xū',  # 驉
    0x9A4A: 'huá',  # 驊
    0x9A4B: 'bō',  # 驋
    0x9A4C: 'sù',  # 驌
    0x9A4D: 'xiāo',  # 驍
    0x9A4E: 'lín',  # 驎
    0x9A4F: 'zhàn',  # 驏
    0x9A50: 'dūn',  # 驐
    0x9A51: 'liú',  # 驑
    0x9A52: 'tuó',  # 驒
    0x9A53: 'céng',  # 驓
    0x9A54: 'diàn',  # 驔
    0x9A55: 'jiāo',  # 驕
    0x9A56: 'tiě',  # 驖
    0x9A57: 'yàn',  # 驗
    0x9A58: 'luó',  # 驘
    0x9A59: 'zhān',  # 驙
    0x9A5A: 'jīng',  # 驚
    0x9A5B: 'yì',  # 驛
    0x9A5C: 'yè',  # 驜
    0x9A5D: 'tuó',  # 驝
    0x9A5E: 'pīn',  # 驞
    0x9A5F: 'zhòu',  # 驟
    0x9A60: 'yàn',  # 驠
    0x9A61: 'lóng',  # 驡
    0x9A62: 'lǘ',  # 驢
    0x9A63: 'téng',  # 驣
    0x9A64: 'xiāng',  # 驤
    0x9A65: 'jì',  # 驥
    0x9A66: 'shuāng',  # 驦
    0x9A67: 'jú',  # 驧
    0x9A68: 'xí',  # 驨
    0x9A69: 'huān',  # 驩
    0x9A6A: 'lí',  # 驪
    0x9A6B: 'biāo',  # 驫
    0x9A6C: 'mǎ',  # 马
    0x9A6D: 'yù',  # 驭
    0x9A6E: 'tuó',  # 驮
    0x9A6F: 'xùn',  # 驯
    0x9A70: 'chí',  # 驰
    0x9A71: 'qū',  # 驱
    0x9A72: 'rì',  # 驲
    0x9A73: 'bó',  # 驳
    0x9A74: 'lǘ',  # 驴
    0x9A75: 'zǎng',  # 驵
    0x9A76: 'shǐ',  # 驶
    0x9A77: 'sì',  # 驷
    0x9A78: 'fù',  # 驸
    0x9A79: 'jū',  # 驹
    0x9A7A: 'zōu',  # 驺
    0x9A7B: 'zhù',  # 驻
    0x9A7C: 'tuó',  # 驼
    0x9A7D: 'nú',  # 驽
    0x9A7E: 'jià',  # 驾
    0x9A7F: 'yì',  # 驿
    0x9A80: 'tái',  # 骀
    0x9A81: 'xiāo',  # 骁
    0x9A82: 'mà',  # 骂
    0x9A83: 'yīn',  # 骃
    0x9A84: 'jiāo',  # 骄
    0x9A85: 'huá',  # 骅
    0x9A86: 'luò',  # 骆
    0x9A87: 'hài',  # 骇
    0x9A88: 'pián',  # 骈
    0x9A89: 'biāo',  # 骉
    0x9A8A: 'lí',  # 骊
    0x9A8B: 'chěng',  # 骋
    0x9A8C: 'yàn',  # 验
    0x9A8D: 'xīng',  # 骍
    0x9A8E: 'qīn',  # 骎
    0x9A8F: 'jùn',  # 骏
    0x9A90: 'qí',  # 骐
    0x9A91: 'qí',  # 骑
    0x9A92: 'kè',  # 骒
    0x9A93: 'zhuī',  # 骓
    0x9A94: 'zōng',  # 骔
    0x9A95: 'sù',  # 骕
    0x9A96: 'cān',  # 骖
    0x9A97: 'piàn',  # 骗
    0x9A98: 'zhì',  # 骘
    0x9A99: 'kuí',  # 骙
    0x9A9A: 'sāo,sǎo',  # 骚
    0x9A9B: 'wù',  # 骛
    0x9A9C: 'áo',  # 骜
    0x9A9D: 'liú',  # 骝
    0x9A9E: 'qiān',  # 骞
    0x9A9F: 'shàn',  # 骟
    0x9AA0: 'piào,biāo',  # 骠
    0x9AA1: 'luó',  # 骡
    0x9AA2: 'cōng',  # 骢
    0x9AA3: 'chǎn',  # 骣
    0x9AA4: 'zhòu',  # 骤
    0x9AA5: 'jì',  # 骥
    0x9AA6: 'shuāng',  # 骦
    0x9AA7: 'xiāng',  # 骧
    0x9AA8: 'gǔ,gū',  # 骨
    0x9AA9: 'wěi',  # 骩
    0x9AAA: 'wěi',  # 骪
    0x9AAB: 'wěi',  # 骫
    0x9AAC: 'yú',  # 骬
    0x9AAD: 'gàn',  # 骭
    0x9AAE: 'yì',  # 骮
    0x9AAF: 'āng',  # 骯
    0x9AB0: 'tóu',  # 骰
    0x9AB1: 'jiè',  # 骱
    0x9AB2: 'bào',  # 骲
    0x9AB3: 'bèi,mó',  # 骳
    0x9AB4: 'cī',  # 骴
    0x9AB5: 'tǐ',  # 骵
    0x9AB6: 'dǐ',  # 骶
    0x9AB7: 'kū',  # 骷
    0x9AB8: 'hái',  # 骸
    0x9AB9: 'qiāo,xiāo',  # 骹
    0x9ABA: 'hóu',  # 骺
    0x9ABB: 'kuà',  # 骻
    0x9ABC: 'gé',  # 骼
    0x9ABD: 'tuǐ',  # 骽
    0x9ABE: 'gěng',  # 骾
    0x9ABF: 'pián',  # 骿
    0x9AC0: 'bì',  # 髀
    0x9AC1: 'kē',  # 髁
    0x9AC2: 'qià',  # 髂
    0x9AC3: 'yú',  # 髃
    0x9AC4: 'suí',  # 髄
    0x9AC5: 'lóu',  # 髅
    0x9AC6: 'bó',  # 髆
    0x9AC7: 'xiāo',  # 髇
    0x9AC8: 'bǎng',  # 髈
    0x9AC9: 'bó,jué',  # 髉
    0x9ACA: 'cī',  # 髊
    0x9ACB: 'kuān',  # 髋
    0x9ACC: 'bìn',  # 髌
    0x9ACD: 'mó',  # 髍
    0x9ACE: 'liáo',  # 髎
    0x9ACF: 'lóu',  # 髏
    0x9AD0: 'xiāo',  # 髐
    0x9AD1: 'dú',  # 髑
    0x9AD2: 'zāng',  # 髒
    0x9AD3: 'suǐ',  # 髓
    0x9AD4: 'tǐ,tī',  # 體
    0x9AD5: 'bìn',  # 髕
    0x9AD6: 'kuān',  # 髖
    0x9AD7: 'lú',  # 髗
    0x9AD8: 'gāo',  # 高
    0x9AD9: 'gāo',  # 髙
    0x9ADA: 'qiào',  # 髚
    0x9ADB: 'kāo',  # 髛
    0x9ADC: 'qiǎo',  # 髜
    0x9ADD: 'láo',  # 髝
    0x9ADE: 'sào',  # 髞
    0x9ADF: 'biāo',  # 髟
    0x9AE0: 'kūn',  # 髠
    0x9AE1: 'kūn',  # 髡
    0x9AE2: 'dí',  # 髢
    0x9AE3: 'fǎng',  # 髣
    0x9AE4: 'xiū',  # 髤
    0x9AE5: 'rán',  # 髥
    0x9AE6: 'máo',  # 髦
    0x9AE7: 'dàn',  # 髧
    0x9AE8: 'kūn',  # 髨
    0x9AE9: 'bìn',  # 髩
    0x9AEA: 'fà',  # 髪
    0x9AEB: 'tiáo',  # 髫
    0x9AEC: 'pī',  # 髬
    0x9AED: 'zī',  # 髭
    0x9AEE: 'fà',  # 髮
    0x9AEF: 'rán',  # 髯
    0x9AF0: 'tì',  # 髰
    0x9AF1: 'bào',  # 髱
    0x9AF2: 'bì,pǒ',  # 髲
    0x9AF3: 'máo,méng',  # 髳
    0x9AF4: 'fú',  # 髴
    0x9AF5: 'ér',  # 髵
    0x9AF6: 'èr',  # 髶
    0x9AF7: 'qū',  # 髷
    0x9AF8: 'gōng',  # 髸
    0x9AF9: 'xiū',  # 髹
    0x9AFA: 'kuò,yuè',  # 髺
    0x9AFB: 'jì',  # 髻
    0x9AFC: 'péng',  # 髼
    0x9AFD: 'zhuā',  # 髽
    0x9AFE: 'shāo',  # 髾
    0x9AFF: 'shā',  # 髿
    0x9B00: 'tì',  # 鬀
    0x9B01: 'lì',  # 鬁
    0x9B02: 'bìn',  # 鬂
    0x9B03: 'zōng',  # 鬃
    0x9B04: 'tì',  # 鬄
    0x9B05: 'péng',  # 鬅
    0x9B06: 'sōng',  # 鬆
    0x9B07: 'zhēng',  # 鬇
    0x9B08: 'quán',  # 鬈
    0x9B09: 'zōng',  # 鬉
    0x9B0A: 'shùn',  # 鬊
    0x9B0B: 'jiǎn',  # 鬋
    0x9B0C: 'duǒ',  # 鬌
    0x9B0D: 'hú',  # 鬍
    0x9B0E: 'là',  # 鬎
    0x9B0F: 'jiū',  # 鬏
    0x9B10: 'qí',  # 鬐
    0x9B11: 'lián',  # 鬑
    0x9B12: 'zhěn',  # 鬒
    0x9B13: 'bìn',  # 鬓
    0x9B14: 'péng',  # 鬔
    0x9B15: 'mà',  # 鬕
    0x9B16: 'sān',  # 鬖
    0x9B17: 'mán',  # 鬗
    0x9B18: 'mán',  # 鬘
    0x9B19: 'sēng',  # 鬙
    0x9B1A: 'xū',  # 鬚
    0x9B1B: 'liè',  # 鬛
    0x9B1C: 'qiān',  # 鬜
    0x9B1D: 'qiān',  # 鬝
    0x9B1E: 'nóng',  # 鬞
    0x9B1F: 'huán',  # 鬟
    0x9B20: 'kuò',  # 鬠
    0x9B21: 'níng',  # 鬡
    0x9B22: 'bìn',  # 鬢
    0x9B23: 'liè',  # 鬣
    0x9B24: 'ráng',  # 鬤
    0x9B25: 'dòu',  # 鬥
    0x9B26: 'dòu',  # 鬦
    0x9B27: 'nào',  # 鬧
    0x9B28: 'hòng',  # 鬨
    0x9B29: 'xì',  # 鬩
    0x9B2A: 'dòu',  # 鬪
    0x9B2B: 'kàn',  # 鬫
    0x9B2C: 'dòu',  # 鬬
    0x9B2D: 'dòu',  # 鬭
    0x9B2E: 'jiū',  # 鬮
    0x9B2F: 'chàng',  # 鬯
    0x9B30: 'yù',  # 鬰
    0x9B31: 'yù',  # 鬱
    0x9B32: 'gé,lì',  # 鬲
    0x9B33: 'yàn',  # 鬳
    0x9B34: 'fǔ',  # 鬴
    0x9B35: 'zèng',  # 鬵
    0x9B36: 'guī',  # 鬶
    0x9B37: 'zōng',  # 鬷
    0x9B38: 'liù',  # 鬸
    0x9B39: 'guī',  # 鬹
    0x9B3A: 'shāng',  # 鬺
    0x9B3B: 'yù',  # 鬻
    0x9B3C: 'guǐ',  # 鬼
    0x9B3D: 'mèi',  # 鬽
    0x9B3E: 'jì',  # 鬾
    0x9B3F: 'qí',  # 鬿
    0x9B40: 'gà',  # 魀
    0x9B41: 'kuí',  # 魁
    0x9B42: 'hún',  # 魂
    0x9B43: 'bá',  # 魃
    0x9B44: 'pò',  # 魄
    0x9B45: 'mèi',  # 魅
    0x9B46: 'xū',  # 魆
    0x9B47: 'yǎn',  # 魇
    0x9B48: 'xiāo',  # 魈
    0x9B49: 'liǎng',  # 魉
    0x9B4A: 'yù',  # 魊
    0x9B4B: 'tuí',  # 魋
    0x9B4C: 'qī',  # 魌
    0x9B4D: 'wǎng',  # 魍
    0x9B4E: 'liǎng',  # 魎
    0x9B4F: 'wèi',  # 魏
    0x9B50: 'gān',  # 魐
    0x9B51: 'chī',  # 魑
    0x9B52: 'piāo',  # 魒
    0x9B53: 'bì',  # 魓
    0x9B54: 'mó',  # 魔
    0x9B55: 'jī',  # 魕
    0x9B56: 'xū',  # 魖
    0x9B57: 'chǒu',  # 魗
    0x9B58: 'yǎn',  # 魘
    0x9B59: 'zhān',  # 魙
    0x9B5A: 'yú',  # 魚
    0x9B5B: 'dāo',  # 魛
    0x9B5C: 'rén',  # 魜
    0x9B5D: 'jì',  # 魝
    0x9B5E: 'bā,bà',  # 魞
    0x9B5F: 'hóng',  # 魟
    0x9B60: 'tuō',  # 魠
    0x9B61: 'diào',  # 魡
    0x9B62: 'jǐ',  # 魢
    0x9B63: 'yú',  # 魣
    0x9B64: 'é',  # 魤
    0x9B65: 'jì',  # 魥
    0x9B66: 'shā',  # 魦
    0x9B67: 'háng',  # 魧
    0x9B68: 'tún',  # 魨
    0x9B69: 'mò',  # 魩
    0x9B6A: 'jiè',  # 魪
    0x9B6B: 'shěn',  # 魫
    0x9B6C: 'bǎn',  # 魬
    0x9B6D: 'yuán',  # 魭
    0x9B6E: 'pí',  # 魮
    0x9B6F: 'lǔ',  # 魯
    0x9B70: 'wén',  # 魰
    0x9B71: 'hú',  # 魱
    0x9B72: 'lú',  # 魲
    0x9B73: 'zā',  # 魳
    0x9B74: 'fáng',  # 魴
    0x9B75: 'fén',  # 魵
    0x9B76: 'nà',  # 魶
    0x9B77: 'yóu',  # 魷
    0x9B78: 'piàn',  # 魸
    0x9B79: 'mó',  # 魹
    0x9B7A: 'hé',  # 魺
    0x9B7B: 'xiá',  # 魻
    0x9B7C: 'qū',  # 魼
    0x9B7D: 'hān',  # 魽
    0x9B7E: 'pī',  # 魾
    0x9B7F: 'líng',  # 魿
    0x9B80: 'tuó',  # 鮀
    0x9B81: 'bà',  # 鮁
    0x9B82: 'qiú',  # 鮂
    0x9B83: 'píng',  # 鮃
    0x9B84: 'fú',  # 鮄
    0x9B85: 'bì',  # 鮅
    0x9B86: 'cǐ,jì',  # 鮆
    0x9B87: 'wèi',  # 鮇
    0x9B88: 'jū',  # 鮈
    0x9B89: 'diāo',  # 鮉
    0x9B8A: 'bó,bà',  # 鮊
    0x9B8B: 'yóu',  # 鮋
    0x9B8C: 'gǔn',  # 鮌
    0x9B8D: 'pí',  # 鮍
    0x9B8E: 'nián',  # 鮎
    0x9B8F: 'xīng',  # 鮏
    0x9B90: 'tái',  # 鮐
    0x9B91: 'bào',  # 鮑
    0x9B92: 'fù',  # 鮒
    0x9B93: 'zhǎ,zhà',  # 鮓
    0x9B94: 'jù',  # 鮔
    0x9B95: 'gū',  # 鮕
    0x9B96: 'shí',  # 鮖
    0x9B97: 'dōng',  # 鮗
    0x9B98: 'chou,dài',  # 鮘
    0x9B99: 'tǎ',  # 鮙
    0x9B9A: 'jié',  # 鮚
    0x9B9B: 'shū',  # 鮛
    0x9B9C: 'hòu',  # 鮜
    0x9B9D: 'xiǎng',  # 鮝
    0x9B9E: 'ér',  # 鮞
    0x9B9F: 'ān',  # 鮟
    0x9BA0: 'wéi',  # 鮠
    0x9BA1: 'zhào',  # 鮡
    0x9BA2: 'zhū',  # 鮢
    0x9BA3: 'yìn',  # 鮣
    0x9BA4: 'liè',  # 鮤
    0x9BA5: 'luò,gé',  # 鮥
    0x9BA6: 'tóng',  # 鮦
    0x9BA7: 'yí',  # 鮧
    0x9BA8: 'yì',  # 鮨
    0x9BA9: 'bìng',  # 鮩
    0x9BAA: 'wěi',  # 鮪
    0x9BAB: 'jiāo',  # 鮫
    0x9BAC: 'kū',  # 鮬
    0x9BAD: 'guī,xié',  # 鮭
    0x9BAE: 'xiān,xiǎn',  # 鮮
    0x9BAF: 'gé',  # 鮯
    0x9BB0: 'huí',  # 鮰
    0x9BB1: 'lǎo',  # 鮱
    0x9BB2: 'fú',  # 鮲
    0x9BB3: 'kào',  # 鮳
    0x9BB4: 'xiū',  # 鮴
    0x9BB5: 'tuō',  # 鮵
    0x9BB6: 'jūn',  # 鮶
    0x9BB7: 'tí',  # 鮷
    0x9BB8: 'miǎn',  # 鮸
    0x9BB9: 'shāo',  # 鮹
    0x9BBA: 'zhǎ',  # 鮺
    0x9BBB: 'suō',  # 鮻
    0x9BBC: 'qīn',  # 鮼
    0x9BBD: 'yú',  # 鮽
    0x9BBE: 'něi',  # 鮾
    0x9BBF: 'zhé',  # 鮿
    0x9BC0: 'gǔn',  # 鯀
    0x9BC1: 'gěng',  # 鯁
    0x9BC2: 'sū',  # 鯂
    0x9BC3: 'wú',  # 鯃
    0x9BC4: 'qiú',  # 鯄
    0x9BC5: 'shān',  # 鯅
    0x9BC6: 'pū,bū',  # 鯆
    0x9BC7: 'huàn',  # 鯇
    0x9BC8: 'tiáo',  # 鯈
    0x9BC9: 'lǐ',  # 鯉
    0x9BCA: 'shā',  # 鯊
    0x9BCB: 'shā',  # 鯋
    0x9BCC: 'kào',  # 鯌
    0x9BCD: 'méng',  # 鯍
    0x9BCE: 'chéng',  # 鯎
    0x9BCF: 'lí',  # 鯏
    0x9BD0: 'zǒu',  # 鯐
    0x9BD1: 'xī',  # 鯑
    0x9BD2: 'yǒng',  # 鯒
    0x9BD3: 'shēn',  # 鯓
    0x9BD4: 'zī',  # 鯔
    0x9BD5: 'qí',  # 鯕
    0x9BD6: 'qīng',  # 鯖
    0x9BD7: 'xiǎng',  # 鯗
    0x9BD8: 'něi',  # 鯘
    0x9BD9: 'chún',  # 鯙
    0x9BDA: 'jì',  # 鯚
    0x9BDB: 'diāo',  # 鯛
    0x9BDC: 'qiè',  # 鯜
    0x9BDD: 'gù',  # 鯝
    0x9BDE: 'zhǒu',  # 鯞
    0x9BDF: 'dōng',  # 鯟
    0x9BE0: 'lái',  # 鯠
    0x9BE1: 'fēi',  # 鯡
    0x9BE2: 'ní',  # 鯢
    0x9BE3: 'yì,sī',  # 鯣
    0x9BE4: 'kūn',  # 鯤
    0x9BE5: 'lù',  # 鯥
    0x9BE6: 'jiù',  # 鯦
    0x9BE7: 'chāng',  # 鯧
    0x9BE8: 'jīng',  # 鯨
    0x9BE9: 'lún',  # 鯩
    0x9BEA: 'líng',  # 鯪
    0x9BEB: 'zōu',  # 鯫
    0x9BEC: 'lí',  # 鯬
    0x9BED: 'měng',  # 鯭
    0x9BEE: 'zōng',  # 鯮
    0x9BEF: 'zhì',  # 鯯
    0x9BF0: 'nián',  # 鯰
    0x9BF1: 'hǔ',  # 鯱
    0x9BF2: 'yú',  # 鯲
    0x9BF3: 'dǐ',  # 鯳
    0x9BF4: 'shī',  # 鯴
    0x9BF5: 'shēn',  # 鯵
    0x9BF6: 'huàn',  # 鯶
    0x9BF7: 'tí',  # 鯷
    0x9BF8: 'hóu',  # 鯸
    0x9BF9: 'xīng',  # 鯹
    0x9BFA: 'zhū',  # 鯺
    0x9BFB: 'là',  # 鯻
    0x9BFC: 'zōng',  # 鯼
    0x9BFD: 'jì',  # 鯽
    0x9BFE: 'biān',  # 鯾
    0x9BFF: 'biān',  # 鯿
    0x9C00: 'huàn',  # 鰀
    0x9C01: 'quán',  # 鰁
    0x9C02: 'zéi',  # 鰂
    0x9C03: 'wēi',  # 鰃
    0x9C04: 'wēi',  # 鰄
    0x9C05: 'yú',  # 鰅
    0x9C06: 'chūn',  # 鰆
    0x9C07: 'róu',  # 鰇
    0x9C08: 'dié',  # 鰈
    0x9C09: 'huáng',  # 鰉
    0x9C0A: 'liàn',  # 鰊
    0x9C0B: 'yǎn',  # 鰋
    0x9C0C: 'qiū',  # 鰌
    0x9C0D: 'qiū',  # 鰍
    0x9C0E: 'jiǎn',  # 鰎
    0x9C0F: 'bī',  # 鰏
    0x9C10: 'è',  # 鰐
    0x9C11: 'yáng',  # 鰑
    0x9C12: 'fù',  # 鰒
    0x9C13: 'sāi,xǐ',  # 鰓
    0x9C14: 'jiān',  # 鰔
    0x9C15: 'xiā',  # 鰕
    0x9C16: 'tuǒ',  # 鰖
    0x9C17: 'hú',  # 鰗
    0x9C18: 'shì',  # 鰘
    0x9C19: 'ruò',  # 鰙
    0x9C1A: 'xuān',  # 鰚
    0x9C1B: 'wēn',  # 鰛
    0x9C1C: 'jiān',  # 鰜
    0x9C1D: 'hào',  # 鰝
    0x9C1E: 'wū',  # 鰞
    0x9C1F: 'páng',  # 鰟
    0x9C20: 'sāo',  # 鰠
    0x9C21: 'liú',  # 鰡
    0x9C22: 'mǎ',  # 鰢
    0x9C23: 'shí',  # 鰣
    0x9C24: 'shī',  # 鰤
    0x9C25: 'guān',  # 鰥
    0x9C26: 'zī',  # 鰦
    0x9C27: 'téng',  # 鰧
    0x9C28: 'tǎ',  # 鰨
    0x9C29: 'yáo',  # 鰩
    0x9C2A: 'è',  # 鰪
    0x9C2B: 'yóng',  # 鰫
    0x9C2C: 'qián',  # 鰬
    0x9C2D: 'qí',  # 鰭
    0x9C2E: 'wēn',  # 鰮
    0x9C2F: 'ruò',  # 鰯
    0x9C30: 'shén',  # 鰰
    0x9C31: 'lián',  # 鰱
    0x9C32: 'áo',  # 鰲
    0x9C33: 'lè',  # 鰳
    0x9C34: 'huī',  # 鰴
    0x9C35: 'mǐn',  # 鰵
    0x9C36: 'jì',  # 鰶
    0x9C37: 'tiáo',  # 鰷
    0x9C38: 'qū',  # 鰸
    0x9C39: 'jiān',  # 鰹
    0x9C3A: 'shēn',  # 鰺
    0x9C3B: 'mán',  # 鰻
    0x9C3C: 'xí',  # 鰼
    0x9C3D: 'qiú',  # 鰽
    0x9C3E: 'piào',  # 鰾
    0x9C3F: 'jì',  # 鰿
    0x9C40: 'jì',  # 鱀
    0x9C41: 'zhú',  # 鱁
    0x9C42: 'jiāng',  # 鱂
    0x9C43: 'xiū',  # 鱃
    0x9C44: 'zhuān',  # 鱄
    0x9C45: 'yōng',  # 鱅
    0x9C46: 'zhāng',  # 鱆
    0x9C47: 'kāng',  # 鱇
    0x9C48: 'xuě',  # 鱈
    0x9C49: 'biē',  # 鱉
    0x9C4A: 'yù',  # 鱊
    0x9C4B: 'qū',  # 鱋
    0x9C4C: 'xiàng',  # 鱌
    0x9C4D: 'bō',  # 鱍
    0x9C4E: 'jiǎo',  # 鱎
    0x9C4F: 'xún',  # 鱏
    0x9C50: 'sù',  # 鱐
    0x9C51: 'huáng',  # 鱑
    0x9C52: 'zūn',  # 鱒
    0x9C53: 'shàn',  # 鱓
    0x9C54: 'shàn',  # 鱔
    0x9C55: 'fān',  # 鱕
    0x9C56: 'guì',  # 鱖
    0x9C57: 'lín',  # 鱗
    0x9C58: 'xún',  # 鱘
    0x9C59: 'yáo',  # 鱙
    0x9C5A: 'xǐ',  # 鱚
    0x9C5B: 'zēng',  # 鱛
    0x9C5C: 'xiāng',  # 鱜
    0x9C5D: 'fèn',  # 鱝
    0x9C5E: 'guān',  # 鱞
    0x9C5F: 'hòu',  # 鱟
    0x9C60: 'kuài',  # 鱠
    0x9C61: 'zéi',  # 鱡
    0x9C62: 'sāo',  # 鱢
    0x9C63: 'zhān',  # 鱣
    0x9C64: 'gǎn',  # 鱤
    0x9C65: 'guì',  # 鱥
    0x9C66: 'yìng',  # 鱦
    0x9C67: 'lǐ',  # 鱧
    0x9C68: 'cháng',  # 鱨
    0x9C69: 'léi',  # 鱩
    0x9C6A: 'shǔ',  # 鱪
    0x9C6B: 'ài',  # 鱫
    0x9C6C: 'rú',  # 鱬
    0x9C6D: 'jì',  # 鱭
    0x9C6E: 'xù',  # 鱮
    0x9C6F: 'hù',  # 鱯
    0x9C70: 'shǔ',  # 鱰
    0x9C71: 'lǐ',  # 鱱
    0x9C72: 'liè',  # 鱲
    0x9C73: 'lè',  # 鱳
    0x9C74: 'miè',  # 鱴
    0x9C75: 'zhēn',  # 鱵
    0x9C76: 'xiǎng',  # 鱶
    0x9C77: 'è',  # 鱷
    0x9C78: 'lú',  # 鱸
    0x9C79: 'guàn',  # 鱹
    0x9C7A: 'lí',  # 鱺
    0x9C7B: 'xiān',  # 鱻
    0x9C7C: 'yú',  # 鱼
    0x9C7D: 'dāo',  # 鱽
    0x9C7E: 'jǐ',  # 鱾
    0x9C7F: 'yóu',  # 鱿
    0x9C80: 'tún',  # 鲀
    0x9C81: 'lǔ',  # 鲁
    0x9C82: 'fáng',  # 鲂
    0x9C83: 'bā,bà',  # 鲃
    0x9C84: 'hé,gě',  # 鲄
    0x9C85: 'bà',  # 鲅
    0x9C86: 'píng',  # 鲆
    0x9C87: 'nián',  # 鲇
    0x9C88: 'lú',  # 鲈
    0x9C89: 'yóu',  # 鲉
    0x9C8A: 'zhǎ,zhà',  # 鲊
    0x9C8B: 'fù',  # 鲋
    0x9C8C: 'bó,bà',  # 鲌
    0x9C8D: 'bào',  # 鲍
    0x9C8E: 'hòu',  # 鲎
    0x9C8F: 'pí',  # 鲏
    0x9C90: 'tái',  # 鲐
    0x9C91: 'guī,xié',  # 鲑
    0x9C92: 'jié',  # 鲒
    0x9C93: 'kào',  # 鲓
    0x9C94: 'wěi',  # 鲔
    0x9C95: 'ér',  # 鲕
    0x9C96: 'tóng',  # 鲖
    0x9C97: 'zéi',  # 鲗
    0x9C98: 'hòu',  # 鲘
    0x9C99: 'kuài',  # 鲙
    0x9C9A: 'jì',  # 鲚
    0x9C9B: 'jiāo',  # 鲛
    0x9C9C: 'xiān,xiǎn',  # 鲜
    0x9C9D: 'zhǎ',  # 鲝
    0x9C9E: 'xiǎng',  # 鲞
    0x9C9F: 'xún',  # 鲟
    0x9CA0: 'gěng',  # 鲠
    0x9CA1: 'lí',  # 鲡
    0x9CA2: 'lián',  # 鲢
    0x9CA3: 'jiān',  # 鲣
    0x9CA4: 'lǐ',  # 鲤
    0x9CA5: 'shí',  # 鲥
    0x9CA6: 'tiáo',  # 鲦
    0x9CA7: 'gǔn',  # 鲧
    0x9CA8: 'shā',  # 鲨
    0x9CA9: 'huàn',  # 鲩
    0x9CAA: 'jūn',  # 鲪
    0x9CAB: 'jì',  # 鲫
    0x9CAC: 'yǒng',  # 鲬
    0x9CAD: 'qīng',  # 鲭
    0x9CAE: 'líng',  # 鲮
    0x9CAF: 'qí',  # 鲯
    0x9CB0: 'zōu',  # 鲰
    0x9CB1: 'fēi',  # 鲱
    0x9CB2: 'kūn',  # 鲲
    0x9CB3: 'chāng',  # 鲳
    0x9CB4: 'gù',  # 鲴
    0x9CB5: 'ní',  # 鲵
    0x9CB6: 'nián',  # 鲶
    0x9CB7: 'diāo',  # 鲷
    0x9CB8: 'jīng',  # 鲸
    0x9CB9: 'shēn',  # 鲹
    0x9CBA: 'shī',  # 鲺
    0x9CBB: 'zī',  # 鲻
    0x9CBC: 'fèn',  # 鲼
    0x9CBD: 'dié',  # 鲽
    0x9CBE: 'bī',  # 鲾
    0x9CBF: 'cháng',  # 鲿
    0x9CC0: 'tí',  # 鳀
    0x9CC1: 'wēn',  # 鳁
    0x9CC2: 'wēi',  # 鳂
    0x9CC3: 'sāi,xǐ',  # 鳃
    0x9CC4: 'è',  # 鳄
    0x9CC5: 'qiū',  # 鳅
    0x9CC6: 'fù',  # 鳆
    0x9CC7: 'huáng',  # 鳇
    0x9CC8: 'quán',  # 鳈
    0x9CC9: 'jiāng',  # 鳉
    0x9CCA: 'biān',  # 鳊
    0x9CCB: 'sāo',  # 鳋
    0x9CCC: 'áo',  # 鳌
    0x9CCD: 'qí',  # 鳍
    0x9CCE: 'tǎ',  # 鳎
    0x9CCF: 'guān',  # 鳏
    0x9CD0: 'yáo',  # 鳐
    0x9CD1: 'páng',  # 鳑
    0x9CD2: 'jiān',  # 鳒
    0x9CD3: 'lè',  # 鳓
    0x9CD4: 'biào',  # 鳔
    0x9CD5: 'xuě',  # 鳕
    0x9CD6: 'biē',  # 鳖
    0x9CD7: 'mán',  # 鳗
    0x9CD8: 'mǐn',  # 鳘
    0x9CD9: 'yōng',  # 鳙
    0x9CDA: 'wèi',  # 鳚
    0x9CDB: 'xí',  # 鳛
    0x9CDC: 'guì,jué',  # 鳜
    0x9CDD: 'shàn',  # 鳝
    0x9CDE: 'lín',  # 鳞
    0x9CDF: 'zūn',  # 鳟
    0x9CE0: 'hù',  # 鳠
    0x9CE1: 'gǎn',  # 鳡
    0x9CE2: 'lǐ',  # 鳢
    0x9CE3: 'zhān,shàn',  # 鳣
    0x9CE4: 'guǎn',  # 鳤
    0x9CE5: 'niǎo,diǎo',  # 鳥
    0x9CE6: 'yǐ',  # 鳦
    0x9CE7: 'fú',  # 鳧
    0x9CE8: 'lì',  # 鳨
    0x9CE9: 'jiū',  # 鳩
    0x9CEA: 'bú',  # 鳪
    0x9CEB: 'yàn',  # 鳫
    0x9CEC: 'fú',  # 鳬
    0x9CED: 'diāo,zhāo',  # 鳭
    0x9CEE: 'jī',  # 鳮
    0x9CEF: 'fèng',  # 鳯
    0x9CF0: 'rù',  # 鳰
    0x9CF1: 'gān,hàn,yàn',  # 鳱
    0x9CF2: 'shī',  # 鳲
    0x9CF3: 'fèng',  # 鳳
    0x9CF4: 'míng',  # 鳴
    0x9CF5: 'bǎo',  # 鳵
    0x9CF6: 'yuān',  # 鳶
    0x9CF7: 'zhī',  # 鳷
    0x9CF8: 'hù',  # 鳸
    0x9CF9: 'qín',  # 鳹
    0x9CFA: 'fū,guī',  # 鳺
    0x9CFB: 'bān,fén',  # 鳻
    0x9CFC: 'wén',  # 鳼
    0x9CFD: 'jiān,qiān,zhān',  # 鳽
    0x9CFE: 'shī',  # 鳾
    0x9CFF: 'yù',  # 鳿
    0x9D00: 'fǒu',  # 鴀
    0x9D01: 'yāo',  # 鴁
    0x9D02: 'jué',  # 鴂
    0x9D03: 'jué',  # 鴃
    0x9D04: 'pǐ',  # 鴄
    0x9D05: 'huān',  # 鴅
    0x9D06: 'zhèn',  # 鴆
    0x9D07: 'bǎo',  # 鴇
    0x9D08: 'yàn',  # 鴈
    0x9D09: 'yā',  # 鴉
    0x9D0A: 'zhèng',  # 鴊
    0x9D0B: 'fāng',  # 鴋
    0x9D0C: 'fèng',  # 鴌
    0x9D0D: 'wén',  # 鴍
    0x9D0E: 'ōu',  # 鴎
    0x9D0F: 'dài',  # 鴏
    0x9D10: 'jiā',  # 鴐
    0x9D11: 'rú',  # 鴑
    0x9D12: 'líng',  # 鴒
    0x9D13: 'miè',  # 鴓
    0x9D14: 'fú',  # 鴔
    0x9D15: 'tuó',  # 鴕
    0x9D16: 'mín',  # 鴖
    0x9D17: 'lì',  # 鴗
    0x9D18: 'biǎn',  # 鴘
    0x9D19: 'zhì',  # 鴙
    0x9D1A: 'gē',  # 鴚
    0x9D1B: 'yuān',  # 鴛
    0x9D1C: 'cí',  # 鴜
    0x9D1D: 'qú',  # 鴝
    0x9D1E: 'xiāo',  # 鴞
    0x9D1F: 'chī',  # 鴟
    0x9D20: 'dàn',  # 鴠
    0x9D21: 'jū',  # 鴡
    0x9D22: 'yāo',  # 鴢
    0x9D23: 'gū',  # 鴣
    0x9D24: 'zhōng',  # 鴤
    0x9D25: 'yù',  # 鴥
    0x9D26: 'yāng',  # 鴦
    0x9D27: 'yù',  # 鴧
    0x9D28: 'yā',  # 鴨
    0x9D29: 'dié',  # 鴩
    0x9D2A: 'yù',  # 鴪
    0x9D2B: 'tián',  # 鴫
    0x9D2C: 'yīng',  # 鴬
    0x9D2D: 'duī',  # 鴭
    0x9D2E: 'wū',  # 鴮
    0x9D2F: 'ér',  # 鴯
    0x9D30: 'guā',  # 鴰
    0x9D31: 'ài',  # 鴱
    0x9D32: 'zhī',  # 鴲
    0x9D33: 'yàn',  # 鴳
    0x9D34: 'héng',  # 鴴
    0x9D35: 'xiāo',  # 鴵
    0x9D36: 'jiá',  # 鴶
    0x9D37: 'liè',  # 鴷
    0x9D38: 'zhū',  # 鴸
    0x9D39: 'yáng',  # 鴹
    0x9D3A: 'yí',  # 鴺
    0x9D3B: 'hóng',  # 鴻
    0x9D3C: 'lù',  # 鴼
    0x9D3D: 'rú',  # 鴽
    0x9D3E: 'móu',  # 鴾
    0x9D3F: 'gē',  # 鴿
    0x9D40: 'rén',  # 鵀
    0x9D41: 'jiāo',  # 鵁
    0x9D42: 'xiū',  # 鵂
    0x9D43: 'zhōu',  # 鵃
    0x9D44: 'chī',  # 鵄
    0x9D45: 'luò',  # 鵅
    0x9D46: 'héng',  # 鵆
    0x9D47: 'nián',  # 鵇
    0x9D48: 'ě',  # 鵈
    0x9D49: 'luán',  # 鵉
    0x9D4A: 'jiá',  # 鵊
    0x9D4B: 'jì',  # 鵋
    0x9D4C: 'tú',  # 鵌
    0x9D4D: 'huān',  # 鵍
    0x9D4E: 'tuǒ',  # 鵎
    0x9D4F: 'bū',  # 鵏
    0x9D50: 'wú',  # 鵐
    0x9D51: 'jiān',  # 鵑
    0x9D52: 'yù',  # 鵒
    0x9D53: 'bó',  # 鵓
    0x9D54: 'jùn',  # 鵔
    0x9D55: 'jùn',  # 鵕
    0x9D56: 'bī',  # 鵖
    0x9D57: 'xī',  # 鵗
    0x9D58: 'jùn',  # 鵘
    0x9D59: 'jú',  # 鵙
    0x9D5A: 'tū',  # 鵚
    0x9D5B: 'jìng',  # 鵛
    0x9D5C: 'tí',  # 鵜
    0x9D5D: 'é',  # 鵝
    0x9D5E: 'é',  # 鵞
    0x9D5F: 'kuáng',  # 鵟
    0x9D60: 'hú',  # 鵠
    0x9D61: 'wǔ',  # 鵡
    0x9D62: 'shēn',  # 鵢
    0x9D63: 'lài',  # 鵣
    0x9D64: 'zān',  # 鵤
    0x9D65: 'pàn',  # 鵥
    0x9D66: 'lù',  # 鵦
    0x9D67: 'pí',  # 鵧
    0x9D68: 'shū',  # 鵨
    0x9D69: 'fú',  # 鵩
    0x9D6A: 'ān',  # 鵪
    0x9D6B: 'zhuó',  # 鵫
    0x9D6C: 'péng',  # 鵬
    0x9D6D: 'qín',  # 鵭
    0x9D6E: 'qiān',  # 鵮
    0x9D6F: 'bēi',  # 鵯
    0x9D70: 'diāo',  # 鵰
    0x9D71: 'lù',  # 鵱
    0x9D72: 'què',  # 鵲
    0x9D73: 'jiān',  # 鵳
    0x9D74: 'jú',  # 鵴
    0x9D75: 'tù',  # 鵵
    0x9D76: 'yā',  # 鵶
    0x9D77: 'yuān',  # 鵷
    0x9D78: 'qí',  # 鵸
    0x9D79: 'lí',  # 鵹
    0x9D7A: 'yè',  # 鵺
    0x9D7B: 'zhuī',  # 鵻
    0x9D7C: 'kōng',  # 鵼
    0x9D7D: 'duò',  # 鵽
    0x9D7E: 'kūn',  # 鵾
    0x9D7F: 'shēng',  # 鵿
    0x9D80: 'qí',  # 鶀
    0x9D81: 'jīng',  # 鶁
    0x9D82: 'yì',  # 鶂
    0x9D83: 'yì',  # 鶃
    0x9D84: 'jīng',  # 鶄
    0x9D85: 'zī',  # 鶅
    0x9D86: 'lái',  # 鶆
    0x9D87: 'dōng',  # 鶇
    0x9D88: 'qī',  # 鶈
    0x9D89: 'chún',  # 鶉
    0x9D8A: 'gēng',  # 鶊
    0x9D8B: 'jū',  # 鶋
    0x9D8C: 'qū',  # 鶌
    0x9D8D: 'yì',  # 鶍
    0x9D8E: 'zūn',  # 鶎
    0x9D8F: 'jī',  # 鶏
    0x9D90: 'shù',  # 鶐
    0x9D91: 'yīng',  # 鶑
    0x9D92: 'chì',  # 鶒
    0x9D93: 'miáo',  # 鶓
    0x9D94: 'róu',  # 鶔
    0x9D95: 'ān',  # 鶕
    0x9D96: 'qiū',  # 鶖
    0x9D97: 'tí,chí',  # 鶗
    0x9D98: 'hú',  # 鶘
    0x9D99: 'tí,chí',  # 鶙
    0x9D9A: 'è',  # 鶚
    0x9D9B: 'jiē',  # 鶛
    0x9D9C: 'máo',  # 鶜
    0x9D9D: 'fú,bì',  # 鶝
    0x9D9E: 'chūn',  # 鶞
    0x9D9F: 'tú',  # 鶟
    0x9DA0: 'yǎn',  # 鶠
    0x9DA1: 'hé,jiè',  # 鶡
    0x9DA2: 'yuán',  # 鶢
    0x9DA3: 'piān,biǎn',  # 鶣
    0x9DA4: 'kūn',  # 鶤
    0x9DA5: 'méi',  # 鶥
    0x9DA6: 'hú',  # 鶦
    0x9DA7: 'yīng',  # 鶧
    0x9DA8: 'chuàn,zhì',  # 鶨
    0x9DA9: 'wù',  # 鶩
    0x9DAA: 'jú',  # 鶪
    0x9DAB: 'dōng',  # 鶫
    0x9DAC: 'cāng,qiāng',  # 鶬
    0x9DAD: 'fǎng',  # 鶭
    0x9DAE: 'hè,hú',  # 鶮
    0x9DAF: 'yīng',  # 鶯
    0x9DB0: 'yuán',  # 鶰
    0x9DB1: 'xiān',  # 鶱
    0x9DB2: 'wēng',  # 鶲
    0x9DB3: 'shī',  # 鶳
    0x9DB4: 'hè',  # 鶴
    0x9DB5: 'chú',  # 鶵
    0x9DB6: 'táng',  # 鶶
    0x9DB7: 'xiá',  # 鶷
    0x9DB8: 'ruò',  # 鶸
    0x9DB9: 'liú',  # 鶹
    0x9DBA: 'jī',  # 鶺
    0x9DBB: 'gǔ,hú',  # 鶻
    0x9DBC: 'jiān',  # 鶼
    0x9DBD: 'sǔn,xùn',  # 鶽
    0x9DBE: 'hàn',  # 鶾
    0x9DBF: 'cí',  # 鶿
    0x9DC0: 'cí',  # 鷀
    0x9DC1: 'yì',  # 鷁
    0x9DC2: 'yào',  # 鷂
    0x9DC3: 'yàn',  # 鷃
    0x9DC4: 'jī',  # 鷄
    0x9DC5: 'lì',  # 鷅
    0x9DC6: 'tián',  # 鷆
    0x9DC7: 'kòu',  # 鷇
    0x9DC8: 'tī',  # 鷈
    0x9DC9: 'tī',  # 鷉
    0x9DCA: 'yì',  # 鷊
    0x9DCB: 'tú',  # 鷋
    0x9DCC: 'mǎ',  # 鷌
    0x9DCD: 'xiāo',  # 鷍
    0x9DCE: 'gāo',  # 鷎
    0x9DCF: 'tián',  # 鷏
    0x9DD0: 'chén',  # 鷐
    0x9DD1: 'jì',  # 鷑
    0x9DD2: 'tuán',  # 鷒
    0x9DD3: 'zhè',  # 鷓
    0x9DD4: 'áo',  # 鷔
    0x9DD5: 'yǎo',  # 鷕
    0x9DD6: 'yī',  # 鷖
    0x9DD7: 'ōu',  # 鷗
    0x9DD8: 'chì',  # 鷘
    0x9DD9: 'zhì',  # 鷙
    0x9DDA: 'liù',  # 鷚
    0x9DDB: 'yōng',  # 鷛
    0x9DDC: 'lóu,lǚ',  # 鷜
    0x9DDD: 'bì',  # 鷝
    0x9DDE: 'shuāng',  # 鷞
    0x9DDF: 'zhuó',  # 鷟
    0x9DE0: 'yú',  # 鷠
    0x9DE1: 'wú',  # 鷡
    0x9DE2: 'jué',  # 鷢
    0x9DE3: 'yín',  # 鷣
    0x9DE4: 'tí',  # 鷤
    0x9DE5: 'sī',  # 鷥
    0x9DE6: 'jiāo',  # 鷦
    0x9DE7: 'yì',  # 鷧
    0x9DE8: 'huá',  # 鷨
    0x9DE9: 'bì',  # 鷩
    0x9DEA: 'yīng',  # 鷪
    0x9DEB: 'sù',  # 鷫
    0x9DEC: 'huáng',  # 鷬
    0x9DED: 'fán',  # 鷭
    0x9DEE: 'jiāo',  # 鷮
    0x9DEF: 'liáo',  # 鷯
    0x9DF0: 'yàn',  # 鷰
    0x9DF1: 'gāo',  # 鷱
    0x9DF2: 'jiù',  # 鷲
    0x9DF3: 'xián',  # 鷳
    0x9DF4: 'xián',  # 鷴
    0x9DF5: 'tú',  # 鷵
    0x9DF6: 'mǎi',  # 鷶
    0x9DF7: 'zūn',  # 鷷
    0x9DF8: 'yù',  # 鷸
    0x9DF9: 'yīng',  # 鷹
    0x9DFA: 'lù',  # 鷺
    0x9DFB: 'tuán',  # 鷻
    0x9DFC: 'xián',  # 鷼
    0x9DFD: 'xué',  # 鷽
    0x9DFE: 'yì',  # 鷾
    0x9DFF: 'pì',  # 鷿
    0x9E00: 'zhǔ',  # 鸀
    0x9E01: 'luó',  # 鸁
    0x9E02: 'xī',  # 鸂
    0x9E03: 'yì',  # 鸃
    0x9E04: 'jī',  # 鸄
    0x9E05: 'zé',  # 鸅
    0x9E06: 'yú',  # 鸆
    0x9E07: 'zhān',  # 鸇
    0x9E08: 'yè',  # 鸈
    0x9E09: 'yáng',  # 鸉
    0x9E0A: 'pì',  # 鸊
    0x9E0B: 'níng',  # 鸋
    0x9E0C: 'hù',  # 鸌
    0x9E0D: 'mí',  # 鸍
    0x9E0E: 'yīng',  # 鸎
    0x9E0F: 'méng',  # 鸏
    0x9E10: 'dí',  # 鸐
    0x9E11: 'yuè',  # 鸑
    0x9E12: 'yù',  # 鸒
    0x9E13: 'lěi',  # 鸓
    0x9E14: 'bǔ',  # 鸔
    0x9E15: 'lú',  # 鸕
    0x9E16: 'hè',  # 鸖
    0x9E17: 'lóng',  # 鸗
    0x9E18: 'shuāng',  # 鸘
    0x9E19: 'yuè',  # 鸙
    0x9E1A: 'yīng',  # 鸚
    0x9E1B: 'guàn',  # 鸛
    0x9E1C: 'qú',  # 鸜
    0x9E1D: 'lí',  # 鸝
    0x9E1E: 'luán',  # 鸞
    0x9E1F: 'niǎo',  # 鸟
    0x9E20: 'jiū',  # 鸠
    0x9E21: 'jī',  # 鸡
    0x9E22: 'yuān',  # 鸢
    0x9E23: 'míng',  # 鸣
    0x9E24: 'shī',  # 鸤
    0x9E25: 'ōu',  # 鸥
    0x9E26: 'yā',  # 鸦
    0x9E27: 'cāng',  # 鸧
    0x9E28: 'bǎo',  # 鸨
    0x9E29: 'zhèn',  # 鸩
    0x9E2A: 'gū',  # 鸪
    0x9E2B: 'dōng',  # 鸫
    0x9E2C: 'lú',  # 鸬
    0x9E2D: 'yā',  # 鸭
    0x9E2E: 'xiāo',  # 鸮
    0x9E2F: 'yāng',  # 鸯
    0x9E30: 'líng',  # 鸰
    0x9E31: 'chī',  # 鸱
    0x9E32: 'qú',  # 鸲
    0x9E33: 'yuān',  # 鸳
    0x9E34: 'xué',  # 鸴
    0x9E35: 'tuó',  # 鸵
    0x9E36: 'sī',  # 鸶
    0x9E37: 'zhì',  # 鸷
    0x9E38: 'ér',  # 鸸
    0x9E39: 'guā',  # 鸹
    0x9E3A: 'xiū',  # 鸺
    0x9E3B: 'héng',  # 鸻
    0x9E3C: 'zhōu',  # 鸼
    0x9E3D: 'gē',  # 鸽
    0x9E3E: 'luán',  # 鸾
    0x9E3F: 'hóng',  # 鸿
    0x9E40: 'wú',  # 鹀
    0x9E41: 'bó',  # 鹁
    0x9E42: 'lí',  # 鹂
    0x9E43: 'juān',  # 鹃
    0x9E44: 'hú',  # 鹄
    0x9E45: 'é',  # 鹅
    0x9E46: 'yù',  # 鹆
    0x9E47: 'xián',  # 鹇
    0x9E48: 'tí',  # 鹈
    0x9E49: 'wǔ',  # 鹉
    0x9E4A: 'què',  # 鹊
    0x9E4B: 'miáo',  # 鹋
    0x9E4C: 'ān',  # 鹌
    0x9E4D: 'kūn',  # 鹍
    0x9E4E: 'bēi',  # 鹎
    0x9E4F: 'péng',  # 鹏
    0x9E50: 'qiān',  # 鹐
    0x9E51: 'chún',  # 鹑
    0x9E52: 'gēng',  # 鹒
    0x9E53: 'yuān',  # 鹓
    0x9E54: 'sù',  # 鹔
    0x9E55: 'hú',  # 鹕
    0x9E56: 'hé',  # 鹖
    0x9E57: 'è',  # 鹗
    0x9E58: 'gǔ',  # 鹘
    0x9E59: 'qiū',  # 鹙
    0x9E5A: 'cí',  # 鹚
    0x9E5B: 'méi',  # 鹛
    0x9E5C: 'wù',  # 鹜
    0x9E5D: 'yì',  # 鹝
    0x9E5E: 'yào',  # 鹞
    0x9E5F: 'wēng',  # 鹟
    0x9E60: 'liú',  # 鹠
    0x9E61: 'jī',  # 鹡
    0x9E62: 'yì',  # 鹢
    0x9E63: 'jiān',  # 鹣
    0x9E64: 'hè',  # 鹤
    0x9E65: 'yī',  # 鹥
    0x9E66: 'yīng',  # 鹦
    0x9E67: 'zhè',  # 鹧
    0x9E68: 'liù',  # 鹨
    0x9E69: 'liáo',  # 鹩
    0x9E6A: 'jiāo',  # 鹪
    0x9E6B: 'jiù',  # 鹫
    0x9E6C: 'yù',  # 鹬
    0x9E6D: 'lù',  # 鹭
    0x9E6E: 'huán',  # 鹮
    0x9E6F: 'zhān',  # 鹯
    0x9E70: 'yīng',  # 鹰
    0x9E71: 'hù',  # 鹱
    0x9E72: 'méng',  # 鹲
    0x9E73: 'guàn',  # 鹳
    0x9E74: 'shuāng',  # 鹴
    0x9E75: 'lǔ',  # 鹵
    0x9E76: 'jīn',  # 鹶
    0x9E77: 'líng',  # 鹷
    0x9E78: 'jiǎn',  # 鹸
    0x9E79: 'xián',  # 鹹
    0x9E7A: 'cuó',  # 鹺
    0x9E7B: 'jiǎn',  # 鹻
    0x9E7C: 'jiǎn',  # 鹼
    0x9E7D: 'yán',  # 鹽
    0x9E7E: 'cuó',  # 鹾
    0x9E7F: 'lù',  # 鹿
    0x9E80: 'yōu',  # 麀
    0x9E81: 'cū',  # 麁
    0x9E82: 'jǐ',  # 麂
    0x9E83: 'páo,biāo',  # 麃
    0x9E84: 'cū',  # 麄
    0x9E85: 'páo',  # 麅
    0x9E86: 'zhù,cū',  # 麆
    0x9E87: 'jūn,qún',  # 麇
    0x9E88: 'zhǔ',  # 麈
    0x9E89: 'jiān',  # 麉
    0x9E8A: 'mí',  # 麊
    0x9E8B: 'mí',  # 麋
    0x9E8C: 'yǔ',  # 麌
    0x9E8D: 'liú',  # 麍
    0x9E8E: 'chén',  # 麎
    0x9E8F: 'jūn',  # 麏
    0x9E90: 'lín',  # 麐
    0x9E91: 'ní',  # 麑
    0x9E92: 'qí',  # 麒
    0x9E93: 'lù',  # 麓
    0x9E94: 'jiù',  # 麔
    0x9E95: 'jūn',  # 麕
    0x9E96: 'jīng',  # 麖
    0x9E97: 'lí,lì',  # 麗
    0x9E98: 'xiāng',  # 麘
    0x9E99: 'xián',  # 麙
    0x9E9A: 'jiā',  # 麚
    0x9E9B: 'mí',  # 麛
    0x9E9C: 'lì',  # 麜
    0x9E9D: 'shè',  # 麝
    0x9E9E: 'zhāng',  # 麞
    0x9E9F: 'lín',  # 麟
    0x9EA0: 'jīng',  # 麠
    0x9EA1: 'qí',  # 麡
    0x9EA2: 'líng',  # 麢
    0x9EA3: 'yán',  # 麣
    0x9EA4: 'cū',  # 麤
    0x9EA5: 'mài',  # 麥
    0x9EA6: 'mài',  # 麦
    0x9EA7: 'hé',  # 麧
    0x9EA8: 'chǎo',  # 麨
    0x9EA9: 'fū',  # 麩
    0x9EAA: 'miàn',  # 麪
    0x9EAB: 'miàn',  # 麫
    0x9EAC: 'fū',  # 麬
    0x9EAD: 'pào',  # 麭
    0x9EAE: 'qù',  # 麮
    0x9EAF: 'qū',  # 麯
    0x9EB0: 'móu',  # 麰
    0x9EB1: 'fū',  # 麱
    0x9EB2: 'xiàn',  # 麲
    0x9EB3: 'lái',  # 麳
    0x9EB4: 'qū',  # 麴
    0x9EB5: 'miàn',  # 麵
    0x9EB6: 'chi',  # 麶
    0x9EB7: 'fēng',  # 麷
    0x9EB8: 'fū',  # 麸
    0x9EB9: 'qū',  # 麹
    0x9EBA: 'miàn',  # 麺
    0x9EBB: 'má',  # 麻
    0x9EBC: 'mó,me',  # 麼
    0x9EBD: 'mó,me,ma',  # 麽
    0x9EBE: 'huī',  # 麾
    0x9EBF: 'mí',  # 麿
    0x9EC0: 'zōu',  # 黀
    0x9EC1: 'nún',  # 黁
    0x9EC2: 'fén',  # 黂
    0x9EC3: 'huáng',  # 黃
    0x9EC4: 'huáng',  # 黄
    0x9EC5: 'jīn',  # 黅
    0x9EC6: 'guāng',  # 黆
    0x9EC7: 'tiān',  # 黇
    0x9EC8: 'tǒu',  # 黈
    0x9EC9: 'hóng',  # 黉
    0x9ECA: 'huà',  # 黊
    0x9ECB: 'kuàng',  # 黋
    0x9ECC: 'hóng',  # 黌
    0x9ECD: 'shǔ',  # 黍
    0x9ECE: 'lí',  # 黎
    0x9ECF: 'nián',  # 黏
    0x9ED0: 'chī',  # 黐
    0x9ED1: 'hēi',  # 黑
    0x9ED2: 'hēi',  # 黒
    0x9ED3: 'yì',  # 黓
    0x9ED4: 'qián',  # 黔
    0x9ED5: 'dǎn',  # 黕
    0x9ED6: 'xì',  # 黖
    0x9ED7: 'tún',  # 黗
    0x9ED8: 'mò',  # 默
    0x9ED9: 'mò',  # 黙
    0x9EDA: 'qián',  # 黚
    0x9EDB: 'dài',  # 黛
    0x9EDC: 'chù',  # 黜
    0x9EDD: 'yǒu',  # 黝
    0x9EDE: 'diǎn',  # 點
    0x9EDF: 'yī',  # 黟
    0x9EE0: 'xiá',  # 黠
    0x9EE1: 'yǎn',  # 黡
    0x9EE2: 'qū',  # 黢
    0x9EE3: 'měi',  # 黣
    0x9EE4: 'yǎn',  # 黤
    0x9EE5: 'qíng',  # 黥
    0x9EE6: 'yuè',  # 黦
    0x9EE7: 'lí',  # 黧
    0x9EE8: 'dǎng',  # 黨
    0x9EE9: 'dú',  # 黩
    0x9EEA: 'cǎn',  # 黪
    0x9EEB: 'yān',  # 黫
    0x9EEC: 'yǎn',  # 黬
    0x9EED: 'yǎn',  # 黭
    0x9EEE: 'dàn,shèn',  # 黮
    0x9EEF: 'àn',  # 黯
    0x9EF0: 'zhěn,yān',  # 黰
    0x9EF1: 'dài',  # 黱
    0x9EF2: 'cǎn',  # 黲
    0x9EF3: 'yī',  # 黳
    0x9EF4: 'méi',  # 黴
    0x9EF5: 'dǎn,zhǎn',  # 黵
    0x9EF6: 'yǎn',  # 黶
    0x9EF7: 'dú',  # 黷
    0x9EF8: 'lú',  # 黸
    0x9EF9: 'zhǐ',  # 黹
    0x9EFA: 'fěn',  # 黺
    0x9EFB: 'fú',  # 黻
    0x9EFC: 'fǔ',  # 黼
    0x9EFD: 'mǐn,miǎn,měng',  # 黽
    0x9EFE: 'mǐn,miǎn,měng',  # 黾
    0x9EFF: 'yuán',  # 黿
    0x9F00: 'cù',  # 鼀
    0x9F01: 'qù',  # 鼁
    0x9F02: 'cháo',  # 鼂
    0x9F03: 'wā',  # 鼃
    0x9F04: 'zhū',  # 鼄
    0x9F05: 'zhī',  # 鼅
    0x9F06: 'měng',  # 鼆
    0x9F07: 'áo',  # 鼇
    0x9F08: 'biē',  # 鼈
    0x9F09: 'tuó',  # 鼉
    0x9F0A: 'bì',  # 鼊
    0x9F0B: 'yuán',  # 鼋
    0x9F0C: 'cháo',  # 鼌
    0x9F0D: 'tuó',  # 鼍
    0x9F0E: 'dǐng',  # 鼎
    0x9F0F: 'mì',  # 鼏
    0x9F10: 'nài',  # 鼐
    0x9F11: 'dǐng',  # 鼑
    0x9F12: 'zī',  # 鼒
    0x9F13: 'gǔ',  # 鼓
    0x9F14: 'gǔ',  # 鼔
    0x9F15: 'dōng',  # 鼕
    0x9F16: 'fén',  # 鼖
    0x9F17: 'táo',  # 鼗
    0x9F18: 'yuān',  # 鼘
    0x9F19: 'pí',  # 鼙
    0x9F1A: 'chāng',  # 鼚
    0x9F1B: 'gāo',  # 鼛
    0x9F1C: 'cào',  # 鼜
    0x9F1D: 'yuān',  # 鼝
    0x9F1E: 'tāng',  # 鼞
    0x9F1F: 'tēng',  # 鼟
    0x9F20: 'shǔ',  # 鼠
    0x9F21: 'shǔ',  # 鼡
    0x9F22: 'fén',  # 鼢
    0x9F23: 'fèi',  # 鼣
    0x9F24: 'wén',  # 鼤
    0x9F25: 'bá',  # 鼥
    0x9F26: 'diāo',  # 鼦
    0x9F27: 'tuó',  # 鼧
    0x9F28: 'zhōng',  # 鼨
    0x9F29: 'qú',  # 鼩
    0x9F2A: 'shēng',  # 鼪
    0x9F2B: 'shí',  # 鼫
    0x9F2C: 'yòu',  # 鼬
    0x9F2D: 'shí',  # 鼭
    0x9F2E: 'tíng',  # 鼮
    0x9F2F: 'wú',  # 鼯
    0x9F30: 'jú',  # 鼰
    0x9F31: 'jīng',  # 鼱
    0x9F32: 'hún',  # 鼲
    0x9F33: 'jú',  # 鼳
    0x9F34: 'yǎn',  # 鼴
    0x9F35: 'tū',  # 鼵
    0x9F36: 'sī',  # 鼶
    0x9F37: 'xī',  # 鼷
    0x9F38: 'xiàn',  # 鼸
    0x9F39: 'yǎn',  # 鼹
    0x9F3A: 'léi',  # 鼺
    0x9F3B: 'bí',  # 鼻
    0x9F3C: 'yào',  # 鼼
    0x9F3D: 'qiú',  # 鼽
    0x9F3E: 'hān',  # 鼾
    0x9F3F: 'wù',  # 鼿
    0x9F40: 'wù',  # 齀
    0x9F41: 'hōu',  # 齁
    0x9F42: 'xiè',  # 齂
    0x9F43: 'è',  # 齃
    0x9F44: 'zhā',  # 齄
    0x9F45: 'xiù',  # 齅
    0x9F46: 'wèng',  # 齆
    0x9F47: 'zhā',  # 齇
    0x9F48: 'nòng',  # 齈
    0x9F49: 'nàng',  # 齉
    0x9F4A: 'qí,zhāi',  # 齊
    0x9F4B: 'zhāi',  # 齋
    0x9F4C: 'jì',  # 齌
    0x9F4D: 'zī',  # 齍
    0x9F4E: 'jí',  # 齎
    0x9F4F: 'jī',  # 齏
    0x9F50: 'qí,jì,zī,zhāi',  # 齐
    0x9F51: 'jī',  # 齑
    0x9F52: 'chǐ',  # 齒
    0x9F53: 'chèn',  # 齓
    0x9F54: 'chèn',  # 齔
    0x9F55: 'hé',  # 齕
    0x9F56: 'yá',  # 齖
    0x9F57: 'yīn',  # 齗
    0x9F58: 'xiè',  # 齘
    0x9F59: 'bāo',  # 齙
    0x9F5A: 'zé',  # 齚
    0x9F5B: 'xiè',  # 齛
    0x9F5C: 'zī',  # 齜
    0x9F5D: 'chī',  # 齝
    0x9F5E: 'yàn',  # 齞
    0x9F5F: 'jǔ',  # 齟
    0x9F60: 'tiáo',  # 齠
    0x9F61: 'líng',  # 齡
    0x9F62: 'líng',  # 齢
    0x9F63: 'chū',  # 齣
    0x9F64: 'quán',  # 齤
    0x9F65: 'xiè',  # 齥
    0x9F66: 'yín',  # 齦
    0x9F67: 'niè',  # 齧
    0x9F68: 'jiù',  # 齨
    0x9F69: 'yǎo',  # 齩
    0x9F6A: 'chuò',  # 齪
    0x9F6B: 'yǔn',  # 齫
    0x9F6C: 'yǔ',  # 齬
    0x9F6D: 'chǔ',  # 齭
    0x9F6E: 'yǐ',  # 齮
    0x9F6F: 'ní',  # 齯
    0x9F70: 'zé',  # 齰
    0x9F71: 'zōu',  # 齱
    0x9F72: 'qǔ',  # 齲
    0x9F73: 'yǔn',  # 齳
    0x9F74: 'yǎn',  # 齴
    0x9F75: 'yú',  # 齵
    0x9F76: 'è',  # 齶
    0x9F77: 'wò',  # 齷
    0x9F78: 'yì',  # 齸
    0x9F79: 'cī',  # 齹
    0x9F7A: 'zōu',  # 齺
    0x9F7B: 'diān',  # 齻
    0x9F7C: 'chǔ',  # 齼
    0x9F7D: 'jìn',  # 齽
    0x9F7E: 'yà',  # 齾
    0x9F7F: 'chǐ',  # 齿
    0x9F80: 'chèn',  # 龀
    0x9F81: 'hé',  # 龁
    0x9F82: 'yín,kěn',  # 龂
    0x9F83: 'jǔ',  # 龃
    0x9F84: 'líng',  # 龄
    0x9F85: 'bāo',  # 龅
    0x9F86: 'tiáo',  # 龆
    0x9F87: 'zī',  # 龇
    0x9F88: 'yín,kěn',  # 龈
    0x9F89: 'yǔ',  # 龉
    0x9F8A: 'chuò',  # 龊
    0x9F8B: 'qǔ',  # 龋
    0x9F8C: 'wò',  # 龌
    0x9F8D: 'lóng,lǒng',  # 龍
    0x9F8E: 'páng',  # 龎
    0x9F8F: 'gōng,wò',  # 龏
    0x9F90: 'páng',  # 龐
    0x9F91: 'yǎn',  # 龑
    0x9F92: 'lóng',  # 龒
    0x9F93: 'lóng,lǒng',  # 龓
    0x9F94: 'gōng',  # 龔
    0x9F95: 'kān',  # 龕
    0x9F96: 'dá',  # 龖
    0x9F97: 'líng',  # 龗
    0x9F98: 'dá',  # 龘
    0x9F99: 'lóng',  # 龙
    0x9F9A: 'gōng',  # 龚
    0x9F9B: 'kān',  # 龛
    0x9F9C: 'guī,jūn,qiū',  # 龜
    0x9F9D: 'qiū',  # 龝
    0x9F9E: 'biē',  # 龞
    0x9F9F: 'guī,jūn,qiū',  # 龟
    0x9FA0: 'yuè',  # 龠
    0x9FA1: 'chuī',  # 龡
    0x9FA2: 'hé',  # 龢
    0x9FA3: 'jiǎo',  # 龣
    0x9FA4: 'xié',  # 龤
    # 0x9FA5: '',  # 龥
    0x9FA6: 'cháng',  # 龦
    0x9FA7: 'shǔ',  # 龧
    0x9FA8: 'huái',  # 龨
    # 0x9FA9: '',  # 龩
    0x9FAA: 'zhān',  # 龪
    0x9FAB: 'gàn',  # 龫
    # 0x9FAC: '',  # 龬
    # 0x9FAD: '',  # 龭
    0x9FAE: 'jì',  # 龮
    0x9FAF: 'yuè',  # 龯
    0x9FB0: 'zǒu',  # 龰
    0x9FB1: 'sì',  # 龱
    0x9FB2: 'kù',  # 龲
    # 0x9FB3: '',  # 龳
    # 0x9FB4: '',  # 龴
    0x9FB5: 'shǒu',  # 龵
    # 0x9FB6: '',  # 龶
    0x9FB7: 'gòng',  # 龷
    # 0x9FB8: '',  # 龸
    0x9FB9: 'juǎn',  # 龹
    0x9FBA: 'zhuó',  # 龺
    0x9FBB: 'luán',  # 龻
    # 0x9FBC: '',  # 龼
    # 0x9FBD: '',  # 龽
    # 0x9FBE: '',  # 龾
    # 0x9FBF: '',  # 龿
    # 0x9FC0: '',  # 鿀
    # 0x9FC1: '',  # 鿁
    # 0x9FC2: '',  # 鿂
    0x9FC3: 'shǎn',  # 鿃
    0x9FC4: 'liáng',  # 鿄
    # 0x9FC5: '',  # 鿅
    # 0x9FC6: '',  # 鿆
    # 0x9FC7: '',  # 鿇
    # 0x9FC8: '',  # 鿈
    # 0x9FC9: '',  # 鿉
    # 0x9FCA: '',  # 鿊
    # 0x9FCB: '',  # 鿋
    0x9FCC: 'liáng,liàng',  # 鿌
    # 0x9FCD: '',  #
    # 0x9FCE: '',  #
    # 0x9FCF: '',  #
    # 0x9FD0: '',  #
    # 0x9FD1: '',  #
    # 0x9FD2: '',  #
    # 0x9FD3: '',  #
    # 0x9FD4: '',  #
    # 0x9FD5: '',  #
    # 0x9FD6: '',  #
    # 0x9FD7: '',  #
    # 0x9FD8: '',  #
    # 0x9FD9: '',  #
    # 0x9FDA: '',  #
    # 0x9FDB: '',  #
    # 0x9FDC: '',  #
    # 0x9FDD: '',  #
    # 0x9FDE: '',  #
    # 0x9FDF: '',  #
    # 0x9FE0: '',  #
    # 0x9FE1: '',  #
    # 0x9FE2: '',  #
    # 0x9FE3: '',  #
    # 0x9FE4: '',  #
    # 0x9FE5: '',  #
    # 0x9FE6: '',  #
    # 0x9FE7: '',  #
    # 0x9FE8: '',  #
    # 0x9FE9: '',  #
    # 0x9FEA: '',  #
    # 0x9FEB: '',  #
    # 0x9FEC: '',  #
    # 0x9FED: '',  #
    # 0x9FEE: '',  #
    # 0x9FEF: '',  #
    # 0x9FF0: '',  #
    # 0x9FF1: '',  #
    # 0x9FF2: '',  #
    # 0x9FF3: '',  #
    # 0x9FF4: '',  #
    # 0x9FF5: '',  #
    # 0x9FF6: '',  #
    # 0x9FF7: '',  #
    # 0x9FF8: '',  #
    # 0x9FF9: '',  #
    # 0x9FFA: '',  #
    # 0x9FFB: '',  #
    # 0x9FFC: '',  #
    # 0x9FFD: '',  #
    # 0x9FFE: '',  #
    # 0x9FFF: '',  #

    # CJK 兼容:[F900-FAFF]
    # 0xF900: '',  # 豈
    # 0xF901: '',  # 更
    # 0xF902: '',  # 車
    # 0xF903: '',  # 賈
    # 0xF904: '',  # 滑
    # 0xF905: '',  # 串
    # 0xF906: '',  # 句
    # 0xF907: '',  # 龜
    # 0xF908: '',  # 龜
    # 0xF909: '',  # 契
    # 0xF90A: '',  # 金
    # 0xF90B: '',  # 喇
    # 0xF90C: '',  # 奈
    # 0xF90D: '',  # 懶
    # 0xF90E: '',  # 癩
    # 0xF90F: '',  # 羅
    # 0xF910: '',  # 蘿
    # 0xF911: '',  # 螺
    # 0xF912: '',  # 裸
    # 0xF913: '',  # 邏
    # 0xF914: '',  # 樂
    # 0xF915: '',  # 洛
    # 0xF916: '',  # 烙
    # 0xF917: '',  # 珞
    # 0xF918: '',  # 落
    # 0xF919: '',  # 酪
    # 0xF91A: '',  # 駱
    # 0xF91B: '',  # 亂
    # 0xF91C: '',  # 卵
    # 0xF91D: '',  # 欄
    # 0xF91E: '',  # 爛
    # 0xF91F: '',  # 蘭
    # 0xF920: '',  # 鸞
    # 0xF921: '',  # 嵐
    # 0xF922: '',  # 濫
    # 0xF923: '',  # 藍
    # 0xF924: '',  # 襤
    # 0xF925: '',  # 拉
    # 0xF926: '',  # 臘
    # 0xF927: '',  # 蠟
    # 0xF928: '',  # 廊
    # 0xF929: '',  # 朗
    # 0xF92A: '',  # 浪
    # 0xF92B: '',  # 狼
    # 0xF92C: '',  # 郎
    # 0xF92D: '',  # 來
    # 0xF92E: '',  # 冷
    # 0xF92F: '',  # 勞
    # 0xF930: '',  # 擄
    # 0xF931: '',  # 櫓
    # 0xF932: '',  # 爐
    # 0xF933: '',  # 盧
    # 0xF934: '',  # 老
    # 0xF935: '',  # 蘆
    # 0xF936: '',  # 虜
    # 0xF937: '',  # 路
    # 0xF938: '',  # 露
    # 0xF939: '',  # 魯
    # 0xF93A: '',  # 鷺
    # 0xF93B: '',  # 碌
    # 0xF93C: '',  # 祿
    # 0xF93D: '',  # 綠
    # 0xF93E: '',  # 菉
    # 0xF93F: '',  # 錄
    # 0xF940: '',  # 鹿
    # 0xF941: '',  # 論
    # 0xF942: '',  # 壟
    # 0xF943: '',  # 弄
    # 0xF944: '',  # 籠
    # 0xF945: '',  # 聾
    # 0xF946: '',  # 牢
    # 0xF947: '',  # 磊
    # 0xF948: '',  # 賂
    # 0xF949: '',  # 雷
    # 0xF94A: '',  # 壘
    # 0xF94B: '',  # 屢
    # 0xF94C: '',  # 樓
    # 0xF94D: '',  # 淚
    # 0xF94E: '',  # 漏
    # 0xF94F: '',  # 累
    # 0xF950: '',  # 縷
    # 0xF951: '',  # 陋
    # 0xF952: '',  # 勒
    # 0xF953: '',  # 肋
    # 0xF954: '',  # 凜
    # 0xF955: '',  # 凌
    # 0xF956: '',  # 稜
    # 0xF957: '',  # 綾
    # 0xF958: '',  # 菱
    # 0xF959: '',  # 陵
    # 0xF95A: '',  # 讀
    # 0xF95B: '',  # 拏
    # 0xF95C: '',  # 樂
    # 0xF95D: '',  # 諾
    # 0xF95E: '',  # 丹
    # 0xF95F: '',  # 寧
    # 0xF960: '',  # 怒
    # 0xF961: '',  # 率
    # 0xF962: '',  # 異
    # 0xF963: '',  # 北
    # 0xF964: '',  # 磻
    # 0xF965: '',  # 便
    # 0xF966: '',  # 復
    # 0xF967: '',  # 不
    # 0xF968: '',  # 泌
    # 0xF969: '',  # 數
    # 0xF96A: '',  # 索
    # 0xF96B: '',  # 參
    # 0xF96C: '',  # 塞
    # 0xF96D: '',  # 省
    # 0xF96E: '',  # 葉
    # 0xF96F: '',  # 說
    # 0xF970: '',  # 殺
    # 0xF971: '',  # 辰
    # 0xF972: '',  # 沈
    # 0xF973: '',  # 拾
    # 0xF974: '',  # 若
    # 0xF975: '',  # 掠
    # 0xF976: '',  # 略
    # 0xF977: '',  # 亮
    # 0xF978: '',  # 兩
    # 0xF979: '',  # 凉
    # 0xF97A: '',  # 梁
    # 0xF97B: '',  # 糧
    # 0xF97C: '',  # 良
    # 0xF97D: '',  # 諒
    # 0xF97E: '',  # 量
    # 0xF97F: '',  # 勵
    # 0xF980: '',  # 呂
    # 0xF981: '',  # 女
    # 0xF982: '',  # 廬
    # 0xF983: '',  # 旅
    # 0xF984: '',  # 濾
    # 0xF985: '',  # 礪
    # 0xF986: '',  # 閭
    # 0xF987: '',  # 驪
    # 0xF988: '',  # 麗
    # 0xF989: '',  # 黎
    # 0xF98A: '',  # 力
    # 0xF98B: '',  # 曆
    # 0xF98C: '',  # 歷
    # 0xF98D: '',  # 轢
    # 0xF98E: '',  # 年
    # 0xF98F: '',  # 憐
    # 0xF990: '',  # 戀
    # 0xF991: '',  # 撚
    # 0xF992: '',  # 漣
    # 0xF993: '',  # 煉
    # 0xF994: '',  # 璉
    # 0xF995: '',  # 秊
    # 0xF996: '',  # 練
    # 0xF997: '',  # 聯
    # 0xF998: '',  # 輦
    # 0xF999: '',  # 蓮
    # 0xF99A: '',  # 連
    # 0xF99B: '',  # 鍊
    # 0xF99C: '',  # 列
    # 0xF99D: '',  # 劣
    # 0xF99E: '',  # 咽
    # 0xF99F: '',  # 烈
    # 0xF9A0: '',  # 裂
    # 0xF9A1: '',  # 說
    # 0xF9A2: '',  # 廉
    # 0xF9A3: '',  # 念
    # 0xF9A4: '',  # 捻
    # 0xF9A5: '',  # 殮
    # 0xF9A6: '',  # 簾
    # 0xF9A7: '',  # 獵
    # 0xF9A8: '',  # 令
    # 0xF9A9: '',  # 囹
    # 0xF9AA: '',  # 寧
    # 0xF9AB: '',  # 嶺
    # 0xF9AC: '',  # 怜
    # 0xF9AD: '',  # 玲
    # 0xF9AE: '',  # 瑩
    # 0xF9AF: '',  # 羚
    # 0xF9B0: '',  # 聆
    # 0xF9B1: '',  # 鈴
    # 0xF9B2: '',  # 零
    # 0xF9B3: '',  # 靈
    # 0xF9B4: '',  # 領
    # 0xF9B5: '',  # 例
    # 0xF9B6: '',  # 禮
    # 0xF9B7: '',  # 醴
    # 0xF9B8: '',  # 隸
    # 0xF9B9: '',  # 惡
    # 0xF9BA: '',  # 了
    # 0xF9BB: '',  # 僚
    # 0xF9BC: '',  # 寮
    # 0xF9BD: '',  # 尿
    # 0xF9BE: '',  # 料
    # 0xF9BF: '',  # 樂
    # 0xF9C0: '',  # 燎
    # 0xF9C1: '',  # 療
    # 0xF9C2: '',  # 蓼
    # 0xF9C3: '',  # 遼
    # 0xF9C4: '',  # 龍
    # 0xF9C5: '',  # 暈
    # 0xF9C6: '',  # 阮
    # 0xF9C7: '',  # 劉
    # 0xF9C8: '',  # 杻
    # 0xF9C9: '',  # 柳
    # 0xF9CA: '',  # 流
    # 0xF9CB: '',  # 溜
    # 0xF9CC: '',  # 琉
    # 0xF9CD: '',  # 留
    # 0xF9CE: '',  # 硫
    # 0xF9CF: '',  # 紐
    # 0xF9D0: '',  # 類
    # 0xF9D1: '',  # 六
    # 0xF9D2: '',  # 戮
    # 0xF9D3: '',  # 陸
    # 0xF9D4: '',  # 倫
    # 0xF9D5: '',  # 崙
    # 0xF9D6: '',  # 淪
    # 0xF9D7: '',  # 輪
    # 0xF9D8: '',  # 律
    # 0xF9D9: '',  # 慄
    # 0xF9DA: '',  # 栗
    # 0xF9DB: '',  # 率
    # 0xF9DC: '',  # 隆
    # 0xF9DD: '',  # 利
    # 0xF9DE: '',  # 吏
    # 0xF9DF: '',  # 履
    # 0xF9E0: '',  # 易
    # 0xF9E1: '',  # 李
    # 0xF9E2: '',  # 梨
    # 0xF9E3: '',  # 泥
    # 0xF9E4: '',  # 理
    # 0xF9E5: '',  # 痢
    # 0xF9E6: '',  # 罹
    # 0xF9E7: '',  # 裏
    # 0xF9E8: '',  # 裡
    # 0xF9E9: '',  # 里
    # 0xF9EA: '',  # 離
    # 0xF9EB: '',  # 匿
    # 0xF9EC: '',  # 溺
    # 0xF9ED: '',  # 吝
    # 0xF9EE: '',  # 燐
    # 0xF9EF: '',  # 璘
    # 0xF9F0: '',  # 藺
    # 0xF9F1: '',  # 隣
    # 0xF9F2: '',  # 鱗
    # 0xF9F3: '',  # 麟
    # 0xF9F4: '',  # 林
    # 0xF9F5: '',  # 淋
    # 0xF9F6: '',  # 臨
    # 0xF9F7: '',  # 立
    # 0xF9F8: '',  # 笠
    # 0xF9F9: '',  # 粒
    # 0xF9FA: '',  # 狀
    # 0xF9FB: '',  # 炙
    # 0xF9FC: '',  # 識
    # 0xF9FD: '',  # 什
    # 0xF9FE: '',  # 茶
    # 0xF9FF: '',  # 刺
    # 0xFA00: '',  # 切
    # 0xFA01: '',  # 度
    # 0xFA02: '',  # 拓
    # 0xFA03: '',  # 糖
    # 0xFA04: '',  # 宅
    # 0xFA05: '',  # 洞
    # 0xFA06: '',  # 暴
    # 0xFA07: '',  # 輻
    # 0xFA08: '',  # 行
    # 0xFA09: '',  # 降
    # 0xFA0A: '',  # 見
    # 0xFA0B: '',  # 廓
    # 0xFA0C: '',  # 兀
    # 0xFA0D: '',  # 嗀
    # 0xFA0E: '',  # 﨎
    # 0xFA0F: '',  # 﨏
    # 0xFA10: '',  # 塚
    # 0xFA11: '',  # 﨑
    # 0xFA12: '',  # 晴
    # 0xFA13: '',  # 﨓
    # 0xFA14: '',  # 﨔
    # 0xFA15: '',  # 凞
    # 0xFA16: '',  # 猪
    # 0xFA17: '',  # 益
    # 0xFA18: '',  # 礼
    # 0xFA19: '',  # 神
    # 0xFA1A: '',  # 祥
    # 0xFA1B: '',  # 福
    # 0xFA1C: '',  # 靖
    # 0xFA1D: '',  # 精
    0xFA1E: 'yǔ',  # 羽
    # 0xFA1F: '',  # 﨟
    # 0xFA20: '',  # 蘒
    # 0xFA21: '',  # 﨡
    # 0xFA22: '',  # 諸
    # 0xFA23: '',  # 﨣
    0xFA24: 'jí',  # 﨤
    # 0xFA25: '',  # 逸
    # 0xFA26: '',  # 都
    # 0xFA27: '',  # 﨧
    # 0xFA28: '',  # 﨨
    0xFA29: 'dǎo',  # 﨩
    # 0xFA2A: '',  # 飯
    # 0xFA2B: '',  # 飼
    # 0xFA2C: '',  # 館
    # 0xFA2D: '',  # 鶴
    # 0xFA2E: '',  # 郞
    # 0xFA2F: '',  # 隷
    # 0xFA30: '',  # 侮
    # 0xFA31: '',  # 僧
    # 0xFA32: '',  # 免
    # 0xFA33: '',  # 勉
    # 0xFA34: '',  # 勤
    # 0xFA35: '',  # 卑
    # 0xFA36: '',  # 喝
    # 0xFA37: '',  # 嘆
    # 0xFA38: '',  # 器
    # 0xFA39: '',  # 塀
    # 0xFA3A: '',  # 墨
    # 0xFA3B: '',  # 層
    # 0xFA3C: '',  # 屮
    # 0xFA3D: '',  # 悔
    # 0xFA3E: '',  # 慨
    # 0xFA3F: '',  # 憎
    # 0xFA40: '',  # 懲
    # 0xFA41: '',  # 敏
    # 0xFA42: '',  # 既
    # 0xFA43: '',  # 暑
    # 0xFA44: '',  # 梅
    # 0xFA45: '',  # 海
    # 0xFA46: '',  # 渚
    # 0xFA47: '',  # 漢
    # 0xFA48: '',  # 煮
    # 0xFA49: '',  # 爫
    # 0xFA4A: '',  # 琢
    # 0xFA4B: '',  # 碑
    # 0xFA4C: '',  # 社
    # 0xFA4D: '',  # 祉
    # 0xFA4E: '',  # 祈
    # 0xFA4F: '',  # 祐
    # 0xFA50: '',  # 祖
    # 0xFA51: '',  # 祝
    # 0xFA52: '',  # 禍
    # 0xFA53: '',  # 禎
    # 0xFA54: '',  # 穀
    # 0xFA55: '',  # 突
    # 0xFA56: '',  # 節
    # 0xFA57: '',  # 練
    # 0xFA58: '',  # 縉
    # 0xFA59: '',  # 繁
    # 0xFA5A: '',  # 署
    # 0xFA5B: '',  # 者
    # 0xFA5C: '',  # 臭
    # 0xFA5D: '',  # 艹
    # 0xFA5E: '',  # 艹
    # 0xFA5F: '',  # 著
    # 0xFA60: '',  # 褐
    # 0xFA61: '',  # 視
    # 0xFA62: '',  # 謁
    # 0xFA63: '',  # 謹
    # 0xFA64: '',  # 賓
    # 0xFA65: '',  # 贈
    # 0xFA66: '',  # 辶
    # 0xFA67: '',  # 逸
    # 0xFA68: '',  # 難
    # 0xFA69: '',  # 響
    # 0xFA6A: '',  # 頻
    # 0xFA6B: '',  #
    # 0xFA6C: '',  #
    # 0xFA6D: '',  #
    # 0xFA6E: '',  #
    # 0xFA6F: '',  #
    # 0xFA70: '',  # 並
    # 0xFA71: '',  # 况
    # 0xFA72: '',  # 全
    # 0xFA73: '',  # 侀
    # 0xFA74: '',  # 充
    # 0xFA75: '',  # 冀
    # 0xFA76: '',  # 勇
    # 0xFA77: '',  # 勺
    # 0xFA78: '',  # 喝
    # 0xFA79: '',  # 啕
    # 0xFA7A: '',  # 喙
    # 0xFA7B: '',  # 嗢
    # 0xFA7C: '',  # 塚
    # 0xFA7D: '',  # 墳
    # 0xFA7E: '',  # 奄
    # 0xFA7F: '',  # 奔
    # 0xFA80: '',  # 婢
    # 0xFA81: '',  # 嬨
    # 0xFA82: '',  # 廒
    # 0xFA83: '',  # 廙
    # 0xFA84: '',  # 彩
    # 0xFA85: '',  # 徭
    # 0xFA86: '',  # 惘
    # 0xFA87: '',  # 慎
    # 0xFA88: '',  # 愈
    # 0xFA89: '',  # 憎
    # 0xFA8A: '',  # 慠
    # 0xFA8B: '',  # 懲
    # 0xFA8C: '',  # 戴
    # 0xFA8D: '',  # 揄
    # 0xFA8E: '',  # 搜
    # 0xFA8F: '',  # 摒
    # 0xFA90: '',  # 敖
    # 0xFA91: '',  # 晴
    # 0xFA92: '',  # 朗
    # 0xFA93: '',  # 望
    # 0xFA94: '',  # 杖
    # 0xFA95: '',  # 歹
    # 0xFA96: '',  # 殺
    # 0xFA97: '',  # 流
    # 0xFA98: '',  # 滛
    # 0xFA99: '',  # 滋
    # 0xFA9A: '',  # 漢
    # 0xFA9B: '',  # 瀞
    # 0xFA9C: '',  # 煮
    # 0xFA9D: '',  # 瞧
    # 0xFA9E: '',  # 爵
    # 0xFA9F: '',  # 犯
    # 0xFAA0: '',  # 猪
    # 0xFAA1: '',  # 瑱
    # 0xFAA2: '',  # 甆
    # 0xFAA3: '',  # 画
    # 0xFAA4: '',  # 瘝
    # 0xFAA5: '',  # 瘟
    # 0xFAA6: '',  # 益
    # 0xFAA7: '',  # 盛
    # 0xFAA8: '',  # 直
    # 0xFAA9: '',  # 睊
    # 0xFAAA: '',  # 着
    # 0xFAAB: '',  # 磌
    # 0xFAAC: '',  # 窱
    # 0xFAAD: '',  # 節
    # 0xFAAE: '',  # 类
    # 0xFAAF: '',  # 絛
    # 0xFAB0: '',  # 練
    # 0xFAB1: '',  # 缾
    # 0xFAB2: '',  # 者
    # 0xFAB3: '',  # 荒
    # 0xFAB4: '',  # 華
    # 0xFAB5: '',  # 蝹
    # 0xFAB6: '',  # 襁
    # 0xFAB7: '',  # 覆
    # 0xFAB8: '',  # 視
    # 0xFAB9: '',  # 調
    # 0xFABA: '',  # 諸
    # 0xFABB: '',  # 請
    # 0xFABC: '',  # 謁
    # 0xFABD: '',  # 諾
    # 0xFABE: '',  # 諭
    # 0xFABF: '',  # 謹
    # 0xFAC0: '',  # 變
    # 0xFAC1: '',  # 贈
    # 0xFAC2: '',  # 輸
    # 0xFAC3: '',  # 遲
    # 0xFAC4: '',  # 醙
    # 0xFAC5: '',  # 鉶
    # 0xFAC6: '',  # 陼
    # 0xFAC7: '',  # 難
    # 0xFAC8: '',  # 靖
    # 0xFAC9: '',  # 韛
    # 0xFACA: '',  # 響
    # 0xFACB: '',  # 頋
    # 0xFACC: '',  # 頻
    # 0xFACD: '',  # 鬒
    # 0xFACE: '',  # 龜
    # 0xFACF: '',  # 𢡊
    # 0xFAD0: '',  # 𢡄
    # 0xFAD1: '',  # 𣏕
    # 0xFAD2: '',  # 㮝
    # 0xFAD3: '',  # 䀘
    # 0xFAD4: '',  # 䀹
    # 0xFAD5: '',  # 𥉉
    # 0xFAD6: '',  # 𥳐
    # 0xFAD7: '',  # 𧻓
    # 0xFAD8: '',  # 齃
    # 0xFAD9: '',  # 龎
    # 0xFADA: '',  #
    # 0xFADB: '',  #
    # 0xFADC: '',  #
    # 0xFADD: '',  #
    # 0xFADE: '',  #
    # 0xFADF: '',  #
    # 0xFAE0: '',  #
    # 0xFAE1: '',  #
    # 0xFAE2: '',  #
    # 0xFAE3: '',  #
    # 0xFAE4: '',  #
    # 0xFAE5: '',  #
    # 0xFAE6: '',  #
    # 0xFAE7: '',  #
    # 0xFAE8: '',  #
    # 0xFAE9: '',  #
    # 0xFAEA: '',  #
    # 0xFAEB: '',  #
    # 0xFAEC: '',  #
    # 0xFAED: '',  #
    # 0xFAEE: '',  #
    # 0xFAEF: '',  #
    # 0xFAF0: '',  #
    # 0xFAF1: '',  #
    # 0xFAF2: '',  #
    # 0xFAF3: '',  #
    # 0xFAF4: '',  #
    # 0xFAF5: '',  #
    # 0xFAF6: '',  #
    # 0xFAF7: '',  #
    # 0xFAF8: '',  #
    # 0xFAF9: '',  #
    # 0xFAFA: '',  #
    # 0xFAFB: '',  #
    # 0xFAFC: '',  #
    # 0xFAFD: '',  #
    # 0xFAFE: '',  #
    # 0xFAFF: '',  #
}

# Python 中高位(FFFF 以上) Unicode 字符的长度不再是1而是2，所以暂不处理。
'''
    # CJK 扩展 B:[20000-2A6DF]
    0x20000: 'hē',  # 𠀀
    0x20001: 'qī',  # 𠀁
    # 0x20002: '',  # 𠀂
    0x20003: 'qiě,jī',  # 𠀃
    # 0x20004: '',  # 𠀄
    0x20005: 'hài',  # 𠀅
    # 0x20006: '',  # 𠀆
    0x20007: 'qiě',  # 𠀇
    0x20008: 'qiū',  # 𠀈
    0x20009: 'qiū',  # 𠀉
    0x2000A: 'cāo',  # 𠀊
    # 0x2000B: '',  # 𠀋
    0x2000C: 'qiū',  # 𠀌
    0x2000D: 'shì',  # 𠀍
    # 0x2000E: '',  # 𠀎
    # 0x2000F: '',  # 𠀏
    # 0x20010: '',  # 𠀐
    # 0x20011: '',  # 𠀑
    # 0x20012: '',  # 𠀒
    0x20013: 'sī',  # 𠀓
    0x20014: 'jué',  # 𠀔
    0x20015: 'gèn',  # 𠀕
    # 0x20016: '',  # 𠀖
    # 0x20017: '',  # 𠀗
    # 0x20018: '',  # 𠀘
    # 0x20019: '',  # 𠀙
    0x2001A: 'bù',  # 𠀚
    0x2001B: 'yù',  # 𠀛
    # 0x2001C: '',  # 𠀜
    0x2001D: 'kōng',  # 𠀝
    # 0x2001E: '',  # 𠀞
    # 0x2001F: '',  # 𠀟
    # 0x20020: '',  # 𠀠
    # 0x20021: '',  # 𠀡
    0x20022: 'zī',  # 𠀢
    # 0x20023: '',  # 𠀣
    0x20024: 'bìng',  # 𠀤
    # 0x20025: '',  # 𠀥
    0x20026: 'xíng',  # 𠀦
    # 0x20027: '',  # 𠀧
    # 0x20028: '',  # 𠀨
    # 0x20029: '',  # 𠀩
    # 0x2002A: '',  # 𠀪
    # 0x2002B: '',  # 𠀫
    0x2002C: 'tiǎn',  # 𠀬
    # 0x2002D: '',  # 𠀭
    0x2002E: 'jī',  # 𠀮
    # 0x2002F: '',  # 𠀯
    # 0x20030: '',  # 𠀰
    0x20031: 'mǒu',  # 𠀱
    # 0x20032: '',  # 𠀲
    # 0x20033: '',  # 𠀳
    # 0x20034: '',  # 𠀴
    # 0x20035: '',  # 𠀵
    # 0x20036: '',  # 𠀶
    0x20037: 'jī',  # 𠀷
    0x20038: 'yè',  # 𠀸
    0x20039: 'jūn',  # 𠀹
    # 0x2003A: '',  # 𠀺
    # 0x2003B: '',  # 𠀻
    0x2003C: 'qián,xià',  # 𠀼
    0x2003D: 'lù',  # 𠀽
    0x2003E: 'pēi',  # 𠀾
    # 0x2003F: '',  # 𠀿
    # 0x20040: '',  # 𠁀
    # 0x20041: '',  # 𠁁
    # 0x20042: '',  # 𠁂
    # 0x20043: '',  # 𠁃
    # 0x20044: '',  # 𠁄
    # 0x20045: '',  # 𠁅
    # 0x20046: '',  # 𠁆
    # 0x20047: '',  # 𠁇
    # 0x20048: '',  # 𠁈
    0x20049: 'chū',  # 𠁉
    # 0x2004A: '',  # 𠁊
    # 0x2004B: '',  # 𠁋
    # 0x2004C: '',  # 𠁌
    # 0x2004D: '',  # 𠁍
    # 0x2004E: '',  # 𠁎
    # 0x2004F: '',  # 𠁏
    # 0x20050: '',  # 𠁐
    # 0x20051: '',  # 𠁑
    # 0x20052: '',  # 𠁒
    # 0x20053: '',  # 𠁓
    # 0x20054: '',  # 𠁔
    # 0x20055: '',  # 𠁕
    # 0x20056: '',  # 𠁖
    0x20057: 'shì,hè',  # 𠁗
    # 0x20058: '',  # 𠁘
    # 0x20059: '',  # 𠁙
    # 0x2005A: '',  # 𠁚
    # 0x2005B: '',  # 𠁛
    # 0x2005C: '',  # 𠁜
    # 0x2005D: '',  # 𠁝
    0x2005E: 'pēi',  # 𠁞
    # 0x2005F: '',  # 𠁟
    0x20060: 'qiè',  # 𠁠
    0x20061: 'bǔ',  # 𠁡
    # 0x20062: '',  # 𠁢
    # 0x20063: '',  # 𠁣
    # 0x20064: '',  # 𠁤
    0x20065: 'guǎi',  # 𠁥
    0x20066: 'zhōng',  # 𠁦
    0x20067: 'zhōng',  # 𠁧
    # 0x20068: '',  # 𠁨
    0x20069: 'zhōng',  # 𠁩
    # 0x2006A: '',  # 𠁪
    # 0x2006B: '',  # 𠁫
    # 0x2006C: '',  # 𠁬
    0x2006D: 'qí',  # 𠁭
    0x2006E: 'shū',  # 𠁮
    # 0x2006F: '',  # 𠁯
    0x20070: 'guāi',  # 𠁰
    0x20071: 'shì',  # 𠁱
    # 0x20072: '',  # 𠁲
    # 0x20073: '',  # 𠁳
    0x20074: 'guī',  # 𠁴
    # 0x20075: '',  # 𠁵
    # 0x20076: '',  # 𠁶
    0x20077: 'chǎn',  # 𠁷
    # 0x20078: '',  # 𠁸
    # 0x20079: '',  # 𠁹
    # 0x2007A: '',  # 𠁺
    # 0x2007B: '',  # 𠁻
    0x2007C: 'yī',  # 𠁼
    0x2007D: 'wán',  # 𠁽
    # 0x2007E: '',  # 𠁾
    0x2007F: 'dān',  # 𠁿
    # 0x20080: '',  # 𠂀
    # 0x20081: '',  # 𠂁
    0x20082: 'zhōng',  # 𠂂
    # 0x20083: '',  # 𠂃
    0x20084: 'huān',  # 𠂄
    # 0x20085: '',  # 𠂅
    0x20086: 'yì',  # 𠂆
    0x20087: 'zuǒ',  # 𠂇
    0x20088: 'jié',  # 𠂈
    # 0x20089: '',  # 𠂉
    # 0x2008A: '',  # 𠂊
    # 0x2008B: '',  # 𠂋
    # 0x2008C: '',  # 𠂌
    # 0x2008D: '',  # 𠂍
    # 0x2008E: '',  # 𠂎
    # 0x2008F: '',  # 𠂏
    # 0x20090: '',  # 𠂐
    0x20091: 'zōu',  # 𠂑
    # 0x20092: '',  # 𠂒
    # 0x20093: '',  # 𠂓
    0x20094: 'zǐ',  # 𠂔
    0x20095: 'shǐ',  # 𠂕
    0x20096: 'dì',  # 𠂖
    # 0x20097: '',  # 𠂗
    # 0x20098: '',  # 𠂘
    # 0x20099: '',  # 𠂙
    # 0x2009A: '',  # 𠂚
    # 0x2009B: '',  # 𠂛
    # 0x2009C: '',  # 𠂜
    # 0x2009D: '',  # 𠂝
    # 0x2009E: '',  # 𠂞
    0x2009F: 'jīn',  # 𠂟
    # 0x200A0: '',  # 𠂠
    # 0x200A1: '',  # 𠂡
    0x200A2: 'pài',  # 𠂢
    0x200A3: 'yī',  # 𠂣
    0x200A4: 'duī',  # 𠂤
    0x200A5: 'cóng',  # 𠂥
    # 0x200A6: '',  # 𠂦
    0x200A7: 'shèn',  # 𠂧
    # 0x200A8: '',  # 𠂨
    # 0x200A9: '',  # 𠂩
    # 0x200AA: '',  # 𠂪
    # 0x200AB: '',  # 𠂫
    # 0x200AC: '',  # 𠂬
    # 0x200AD: '',  # 𠂭
    # 0x200AE: '',  # 𠂮
    # 0x200AF: '',  # 𠂯
    # 0x200B0: '',  # 𠂰
    # 0x200B1: '',  # 𠂱
    # 0x200B2: '',  # 𠂲
    0x200B3: 'zǒng',  # 𠂳
    # 0x200B4: '',  # 𠂴
    # 0x200B5: '',  # 𠂵
    # 0x200B6: '',  # 𠂶
    0x200B7: 'xìng',  # 𠂷
    0x200B8: 'huáng',  # 𠂸
    0x200B9: 'chuí',  # 𠂹
    0x200BA: 'sī',  # 𠂺
    # 0x200BB: '',  # 𠂻
    # 0x200BC: '',  # 𠂼
    # 0x200BD: '',  # 𠂽
    # 0x200BE: '',  # 𠂾
    0x200BF: 'shǒu',  # 𠂿
    # 0x200C0: '',  # 𠃀
    # 0x200C1: '',  # 𠃁
    # 0x200C2: '',  # 𠃂
    # 0x200C3: '',  # 𠃃
    # 0x200C4: '',  # 𠃄
    # 0x200C5: '',  # 𠃅
    # 0x200C6: '',  # 𠃆
    # 0x200C7: '',  # 𠃇
    # 0x200C8: '',  # 𠃈
    0x200C9: 'yà',  # 𠃉
    0x200CA: 'yǐn',  # 𠃊
    0x200CB: 'gōng',  # 𠃋
    0x200CC: 'gǔn',  # 𠃌
    # 0x200CD: '',  # 𠃍
    # 0x200CE: '',  # 𠃎
    0x200CF: 'jiū',  # 𠃏
    0x200D0: 'huì',  # 𠃐
    # 0x200D1: '',  # 𠃑
    0x200D2: 'yě',  # 𠃒
    # 0x200D3: '',  # 𠃓
    0x200D4: 'jiǔ',  # 𠃔
    0x200D5: 'zhōu',  # 𠃕
    0x200D6: 'jiū',  # 𠃖
    # 0x200D7: '',  # 𠃗
    # 0x200D8: '',  # 𠃘
    # 0x200D9: '',  # 𠃙
    # 0x200DA: '',  # 𠃚
    # 0x200DB: '',  # 𠃛
    # 0x200DC: '',  # 𠃜
    # 0x200DD: '',  # 𠃝
    0x200DE: 'lǐ',  # 𠃞
    0x200DF: 'yě',  # 𠃟
    # 0x200E0: '',  # 𠃠
    # 0x200E1: '',  # 𠃡
    # 0x200E2: '',  # 𠃢
    # 0x200E3: '',  # 𠃣
    0x200E4: 'huāng',  # 𠃤
    0x200E5: 'jǔ',  # 𠃥
    # 0x200E6: '',  # 𠃦
    # 0x200E7: '',  # 𠃧
    0x200E8: 'jǐ',  # 𠃨
    # 0x200E9: '',  # 𠃩
    # 0x200EA: '',  # 𠃪
    0x200EB: 'shēn',  # 𠃫
    # 0x200EC: '',  # 𠃬
    0x200ED: 'shǐ',  # 𠃭
    # 0x200EE: '',  # 𠃮
    # 0x200EF: '',  # 𠃯
    # 0x200F0: '',  # 𠃰
    # 0x200F1: '',  # 𠃱
    0x200F2: 'jié',  # 𠃲
    0x200F3: 'kuí',  # 𠃳
    # 0x200F4: '',  # 𠃴
    # 0x200F5: '',  # 𠃵
    # 0x200F6: '',  # 𠃶
    # 0x200F7: '',  # 𠃷
    # 0x200F8: '',  # 𠃸
    # 0x200F9: '',  # 𠃹
    0x200FA: 'jiù',  # 𠃺
    # 0x200FB: '',  # 𠃻
    0x200FC: 'sī',  # 𠃼
    # 0x200FD: '',  # 𠃽
    # 0x200FE: '',  # 𠃾
    # 0x200FF: '',  # 𠃿
    # 0x20100: '',  # 𠄀
    # 0x20101: '',  # 𠄁
    # 0x20102: '',  # 𠄂
    0x20103: 'gān,qián',  # 𠄃
    # 0x20104: '',  # 𠄄
    0x20105: 'yè',  # 𠄅
    # 0x20106: '',  # 𠄆
    0x20107: 'lào',  # 𠄇
    0x20108: 'lín',  # 𠄈
    0x20109: 'dòng',  # 𠄉
    # 0x2010A: '',  # 𠄊
    0x2010B: 'gān,qián',  # 𠄋
    0x2010C: 'jué,zhuì',  # 𠄌
    0x2010D: 'jié',  # 𠄍
    0x2010E: 'nǎi',  # 𠄎
    0x2010F: 'diǎo',  # 𠄏
    0x20110: 'mā',  # 𠄐
    0x20111: 'jué',  # 𠄑
    0x20112: 'chuí,shā',  # 𠄒
    0x20113: 'zhōu',  # 𠄓
    0x20114: 'huàn',  # 𠄔
    0x20115: 'nǎi',  # 𠄕
    0x20116: 'líng',  # 𠄖
    0x20117: 'zhōu',  # 𠄗
    # 0x20118: '',  # 𠄘
    0x20119: 'zhēng',  # 𠄙
    0x2011A: 'tīng',  # 𠄚
    0x2011B: 'yù',  # 𠄛
    # 0x2011C: '',  # 𠄜
    0x2011D: 'yù',  # 𠄝
    0x2011E: 'shàng',  # 𠄞
    0x2011F: 'xià',  # 𠄟
    0x20120: 'shàng',  # 𠄠
    0x20121: 'wǔ',  # 𠄡
    0x20122: 'xuān',  # 𠄢
    0x20123: 'gèn',  # 𠄣
    0x20124: 'chún',  # 𠄤
    # 0x20125: '',  # 𠄥
    # 0x20126: '',  # 𠄦
    # 0x20127: '',  # 𠄧
    0x20128: 'héng',  # 𠄨
    # 0x20129: '',  # 𠄩
    # 0x2012A: '',  # 𠄪
    # 0x2012B: '',  # 𠄫
    # 0x2012C: '',  # 𠄬
    # 0x2012D: '',  # 𠄭
    0x2012E: 'yà,mǒ',  # 𠄮
    # 0x2012F: '',  # 𠄯
    0x20130: 'lǎo',  # 𠄰
    0x20131: 'yí',  # 𠄱
    # 0x20132: '',  # 𠄲
    # 0x20133: '',  # 𠄳
    # 0x20134: '',  # 𠄴
    0x20135: 'shèng',  # 𠄵
    # 0x20136: '',  # 𠄶
    # 0x20137: '',  # 𠄷
    # 0x20138: '',  # 𠄸
    0x20139: 'jí',  # 𠄹
    # 0x2013A: '',  # 𠄺
    # 0x2013B: '',  # 𠄻
    # 0x2013C: '',  # 𠄼
    # 0x2013D: '',  # 𠄽
    # 0x2013E: '',  # 𠄾
    0x2013F: 'wéi',  # 𠄿
    # 0x20140: '',  # 𠅀
    # 0x20141: '',  # 𠅁
    0x20142: 'jié',  # 𠅂
    0x20143: 'yì',  # 𠅃
    # 0x20144: '',  # 𠅄
    0x20145: 'sòng',  # 𠅅
    # 0x20146: '',  # 𠅆
    # 0x20147: '',  # 𠅇
    0x20148: 'nào',  # 𠅈
    # 0x20149: '',  # 𠅉
    # 0x2014A: '',  # 𠅊
    # 0x2014B: '',  # 𠅋
    0x2014C: 'yí',  # 𠅌
    # 0x2014D: '',  # 𠅍
    # 0x2014E: '',  # 𠅎
    # 0x2014F: '',  # 𠅏
    # 0x20150: '',  # 𠅐
    # 0x20151: '',  # 𠅑
    # 0x20152: '',  # 𠅒
    0x20153: 'yóu',  # 𠅓
    0x20154: 'kè',  # 𠅔
    # 0x20155: '',  # 𠅕
    0x20156: 'hēng',  # 𠅖
    0x20157: 'diè',  # 𠅗
    # 0x20158: '',  # 𠅘
    # 0x20159: '',  # 𠅙
    0x2015A: 'qí',  # 𠅚
    # 0x2015B: '',  # 𠅛
    # 0x2015C: '',  # 𠅜
    # 0x2015D: '',  # 𠅝
    0x2015E: 'chèng,shèng',  # 𠅞
    0x2015F: 'chèng,shèng',  # 𠅟
    0x20160: 'xiǎng',  # 𠅠
    0x20161: 'kè',  # 𠅡
    # 0x20162: '',  # 𠅢
    0x20163: 'gǎng',  # 𠅣
    0x20164: 'xí',  # 𠅤
    # 0x20165: '',  # 𠅥
    # 0x20166: '',  # 𠅦
    # 0x20167: '',  # 𠅧
    # 0x20168: '',  # 𠅨
    0x20169: 'shú',  # 𠅩
    0x2016A: 'guō',  # 𠅪
    0x2016B: 'shèng',  # 𠅫
    0x2016C: 'bāo',  # 𠅬
    # 0x2016D: '',  # 𠅭
    # 0x2016E: '',  # 𠅮
    # 0x2016F: '',  # 𠅯
    # 0x20170: '',  # 𠅰
    0x20171: 'xiè',  # 𠅱
    # 0x20172: '',  # 𠅲
    # 0x20173: '',  # 𠅳
    # 0x20174: '',  # 𠅴
    # 0x20175: '',  # 𠅵
    # 0x20176: '',  # 𠅶
    # 0x20177: '',  # 𠅷
    # 0x20178: '',  # 𠅸
    0x20179: 'zhàng',  # 𠅹
    # 0x2017A: '',  # 𠅺
    # 0x2017B: '',  # 𠅻
    # 0x2017C: '',  # 𠅼
    # 0x2017D: '',  # 𠅽
    # 0x2017E: '',  # 𠅾
    # 0x2017F: '',  # 𠅿
    # 0x20180: '',  # 𠆀
    0x20181: 'luǒ',  # 𠆁
    0x20182: 'shuāi',  # 𠆂
    # 0x20183: '',  # 𠆃
    # 0x20184: '',  # 𠆄
    # 0x20185: '',  # 𠆅
    # 0x20186: '',  # 𠆆
    # 0x20187: '',  # 𠆇
    # 0x20188: '',  # 𠆈
    # 0x20189: '',  # 𠆉
    # 0x2018A: '',  # 𠆊
    # 0x2018B: '',  # 𠆋
    0x2018C: 'yōng',  # 𠆌
    # 0x2018D: '',  # 𠆍
    # 0x2018E: '',  # 𠆎
    # 0x2018F: '',  # 𠆏
    0x20190: 'xù',  # 𠆐
    # 0x20191: '',  # 𠆑
    # 0x20192: '',  # 𠆒
    # 0x20193: '',  # 𠆓
    # 0x20194: '',  # 𠆔
    # 0x20195: '',  # 𠆕
    # 0x20196: '',  # 𠆖
    # 0x20197: '',  # 𠆗
    # 0x20198: '',  # 𠆘
    0x20199: 'diè',  # 𠆙
    # 0x2019A: '',  # 𠆚
    0x2019B: 'dān',  # 𠆛
    # 0x2019C: '',  # 𠆜
    0x2019D: 'xiāng',  # 𠆝
    # 0x2019E: '',  # 𠆞
    0x2019F: 'wěi',  # 𠆟
    # 0x201A0: '',  # 𠆠
    # 0x201A1: '',  # 𠆡
    # 0x201A2: '',  # 𠆢
    0x201A3: 'guǎ,zhuǎ',  # 𠆣
    0x201A4: 'dīng',  # 𠆤
    # 0x201A5: '',  # 𠆥
    0x201A6: 'zhà',  # 𠆦
    0x201A7: 'rén',  # 𠆧
    # 0x201A8: '',  # 𠆨
    0x201A9: 'fàn',  # 𠆩
    # 0x201AA: '',  # 𠆪
    # 0x201AB: '',  # 𠆫
    # 0x201AC: '',  # 𠆬
    0x201AD: 'yīn',  # 𠆭
    0x201AE: 'mò',  # 𠆮
    # 0x201AF: '',  # 𠆯
    # 0x201B0: '',  # 𠆰
    0x201B1: 'xī',  # 𠆱
    0x201B2: 'yǎn',  # 𠆲
    # 0x201B3: '',  # 𠆳
    # 0x201B4: '',  # 𠆴
    0x201B5: 'ní',  # 𠆵
    0x201B6: 'dàn',  # 𠆶
    # 0x201B7: '',  # 𠆷
    # 0x201B8: '',  # 𠆸
    # 0x201B9: '',  # 𠆹
    # 0x201BA: '',  # 𠆺
    # 0x201BB: '',  # 𠆻
    # 0x201BC: '',  # 𠆼
    # 0x201BD: '',  # 𠆽
    # 0x201BE: '',  # 𠆾
    # 0x201BF: '',  # 𠆿
    # 0x201C0: '',  # 𠇀
    # 0x201C1: '',  # 𠇁
    0x201C2: 'gè,gě',  # 𠇂
    # 0x201C3: '',  # 𠇃
    # 0x201C4: '',  # 𠇄
    # 0x201C5: '',  # 𠇅
    # 0x201C6: '',  # 𠇆
    # 0x201C7: '',  # 𠇇
    # 0x201C8: '',  # 𠇈
    # 0x201C9: '',  # 𠇉
    # 0x201CA: '',  # 𠇊
    0x201CB: 'dǎn',  # 𠇋
    0x201CC: 'hún',  # 𠇌
    # 0x201CD: '',  # 𠇍
    # 0x201CE: '',  # 𠇎
    0x201CF: 'tāo',  # 𠇏
    # 0x201D0: '',  # 𠇐
    # 0x201D1: '',  # 𠇑
    0x201D2: 'gōng',  # 𠇒
    # 0x201D3: '',  # 𠇓
    0x201D4: 'tuō,chà',  # 𠇔
    # 0x201D5: '',  # 𠇕
    # 0x201D6: '',  # 𠇖
    0x201D7: 'kuā',  # 𠇗
    0x201D8: 'chù',  # 𠇘
    # 0x201D9: '',  # 𠇙
    # 0x201DA: '',  # 𠇚
    # 0x201DB: '',  # 𠇛
    # 0x201DC: '',  # 𠇜
    # 0x201DD: '',  # 𠇝
    # 0x201DE: '',  # 𠇞
    # 0x201DF: '',  # 𠇟
    # 0x201E0: '',  # 𠇠
    # 0x201E1: '',  # 𠇡
    # 0x201E2: '',  # 𠇢
    # 0x201E3: '',  # 𠇣
    # 0x201E4: '',  # 𠇤
    # 0x201E5: '',  # 𠇥
    # 0x201E6: '',  # 𠇦
    # 0x201E7: '',  # 𠇧
    # 0x201E8: '',  # 𠇨
    # 0x201E9: '',  # 𠇩
    # 0x201EA: '',  # 𠇪
    # 0x201EB: '',  # 𠇫
    # 0x201EC: '',  # 𠇬
    # 0x201ED: '',  # 𠇭
    0x201EE: 'mìng',  # 𠇮
    0x201EF: 'qù',  # 𠇯
    # 0x201F0: '',  # 𠇰
    0x201F1: 'mò',  # 𠇱
    # 0x201F2: '',  # 𠇲
    0x201F3: 'shī',  # 𠇳
    # 0x201F4: '',  # 𠇴
    0x201F5: 'gǎn',  # 𠇵
    # 0x201F6: '',  # 𠇶
    0x201F7: 'shēng',  # 𠇷
    0x201F8: 'zuǒ',  # 𠇸
    # 0x201F9: '',  # 𠇹
    0x201FA: 'xiá',  # 𠇺
    # 0x201FB: '',  # 𠇻
    0x201FC: 'hǔ',  # 𠇼
    # 0x201FD: '',  # 𠇽
    # 0x201FE: '',  # 𠇾
    # 0x201FF: '',  # 𠇿
    # 0x20200: '',  # 𠈀
    # 0x20201: '',  # 𠈁
    # 0x20202: '',  # 𠈂
    # 0x20203: '',  # 𠈃
    # 0x20204: '',  # 𠈄
    0x20205: 'shōu',  # 𠈅
    # 0x20206: '',  # 𠈆
    # 0x20207: '',  # 𠈇
    # 0x20208: '',  # 𠈈
    # 0x20209: '',  # 𠈉
    0x2020A: 'niě',  # 𠈊
    # 0x2020B: '',  # 𠈋
    # 0x2020C: '',  # 𠈌
    # 0x2020D: '',  # 𠈍
    # 0x2020E: '',  # 𠈎
    # 0x2020F: '',  # 𠈏
    # 0x20210: '',  # 𠈐
    # 0x20211: '',  # 𠈑
    # 0x20212: '',  # 𠈒
    # 0x20213: '',  # 𠈓
    # 0x20214: '',  # 𠈔
    # 0x20215: '',  # 𠈕
    # 0x20216: '',  # 𠈖
    # 0x20217: '',  # 𠈗
    0x20218: 'kuí',  # 𠈘
    # 0x20219: '',  # 𠈙
    # 0x2021A: '',  # 𠈚
    # 0x2021B: '',  # 𠈛
    # 0x2021C: '',  # 𠈜
    # 0x2021D: '',  # 𠈝
    # 0x2021E: '',  # 𠈞
    # 0x2021F: '',  # 𠈟
    # 0x20220: '',  # 𠈠
    # 0x20221: '',  # 𠈡
    # 0x20222: '',  # 𠈢
    # 0x20223: '',  # 𠈣
    0x20224: 'yùn',  # 𠈤
    0x20225: 'guǎ',  # 𠈥
    # 0x20226: '',  # 𠈦
    # 0x20227: '',  # 𠈧
    # 0x20228: '',  # 𠈨
    # 0x20229: '',  # 𠈩
    # 0x2022A: '',  # 𠈪
    # 0x2022B: '',  # 𠈫
    0x2022C: 'xiāo',  # 𠈬
    0x2022D: 'láo',  # 𠈭
    # 0x2022E: '',  # 𠈮
    # 0x2022F: '',  # 𠈯
    0x20230: 'dàn',  # 𠈰
    0x20231: 'suō',  # 𠈱
    # 0x20232: '',  # 𠈲
    # 0x20233: '',  # 𠈳
    # 0x20234: '',  # 𠈴
    0x20235: 'mǎng',  # 𠈵
    0x20236: 'yí',  # 𠈶
    # 0x20237: '',  # 𠈷
    0x20238: 'tè',  # 𠈸
    # 0x20239: '',  # 𠈹
    0x2023A: 'bì',  # 𠈺
    # 0x2023B: '',  # 𠈻
    # 0x2023C: '',  # 𠈼
    # 0x2023D: '',  # 𠈽
    # 0x2023E: '',  # 𠈾
    # 0x2023F: '',  # 𠈿
    # 0x20240: '',  # 𠉀
    # 0x20241: '',  # 𠉁
    # 0x20242: '',  # 𠉂
    # 0x20243: '',  # 𠉃
    # 0x20244: '',  # 𠉄
    # 0x20245: '',  # 𠉅
    # 0x20246: '',  # 𠉆
    # 0x20247: '',  # 𠉇
    # 0x20248: '',  # 𠉈
    # 0x20249: '',  # 𠉉
    # 0x2024A: '',  # 𠉊
    # 0x2024B: '',  # 𠉋
    # 0x2024C: '',  # 𠉌
    # 0x2024D: '',  # 𠉍
    # 0x2024E: '',  # 𠉎
    # 0x2024F: '',  # 𠉏
    # 0x20250: '',  # 𠉐
    # 0x20251: '',  # 𠉑
    # 0x20252: '',  # 𠉒
    # 0x20253: '',  # 𠉓
    # 0x20254: '',  # 𠉔
    # 0x20255: '',  # 𠉕
    # 0x20256: '',  # 𠉖
    # 0x20257: '',  # 𠉗
    # 0x20258: '',  # 𠉘
    # 0x20259: '',  # 𠉙
    # 0x2025A: '',  # 𠉚
    # 0x2025B: '',  # 𠉛
    # 0x2025C: '',  # 𠉜
    # 0x2025D: '',  # 𠉝
    # 0x2025E: '',  # 𠉞
    # 0x2025F: '',  # 𠉟
    # 0x20260: '',  # 𠉠
    # 0x20261: '',  # 𠉡
    0x20262: 'xǐ',  # 𠉢
    0x20263: 'hūn,hùn',  # 𠉣
    0x20264: 'dá',  # 𠉤
    # 0x20265: '',  # 𠉥
    # 0x20266: '',  # 𠉦
    0x20267: 'jù',  # 𠉧
    # 0x20268: '',  # 𠉨
    0x20269: 'dú',  # 𠉩
    # 0x2026A: '',  # 𠉪
    # 0x2026B: '',  # 𠉫
    0x2026C: 'ǎn,yǎn',  # 𠉬
    # 0x2026D: '',  # 𠉭
    # 0x2026E: '',  # 𠉮
    # 0x2026F: '',  # 𠉯
    # 0x20270: '',  # 𠉰
    # 0x20271: '',  # 𠉱
    # 0x20272: '',  # 𠉲
    # 0x20273: '',  # 𠉳
    # 0x20274: '',  # 𠉴
    # 0x20275: '',  # 𠉵
    # 0x20276: '',  # 𠉶
    # 0x20277: '',  # 𠉷
    # 0x20278: '',  # 𠉸
    # 0x20279: '',  # 𠉹
    # 0x2027A: '',  # 𠉺
    # 0x2027B: '',  # 𠉻
    # 0x2027C: '',  # 𠉼
    # 0x2027D: '',  # 𠉽
    # 0x2027E: '',  # 𠉾
    # 0x2027F: '',  # 𠉿
    # 0x20280: '',  # 𠊀
    # 0x20281: '',  # 𠊁
    # 0x20282: '',  # 𠊂
    # 0x20283: '',  # 𠊃
    # 0x20284: '',  # 𠊄
    # 0x20285: '',  # 𠊅
    # 0x20286: '',  # 𠊆
    # 0x20287: '',  # 𠊇
    # 0x20288: '',  # 𠊈
    0x20289: 'mèi',  # 𠊉
    # 0x2028A: '',  # 𠊊
    # 0x2028B: '',  # 𠊋
    0x2028C: 'rán',  # 𠊌
    # 0x2028D: '',  # 𠊍
    0x2028E: 'ái',  # 𠊎
    0x2028F: 'yù,xián',  # 𠊏
    # 0x20290: '',  # 𠊐
    # 0x20291: '',  # 𠊑
    0x20292: 'jiàn',  # 𠊒
    # 0x20293: '',  # 𠊓
    0x20294: 'qì',  # 𠊔
    # 0x20295: '',  # 𠊕
    # 0x20296: '',  # 𠊖
    # 0x20297: '',  # 𠊗
    # 0x20298: '',  # 𠊘
    # 0x20299: '',  # 𠊙
    # 0x2029A: '',  # 𠊚
    # 0x2029B: '',  # 𠊛
    # 0x2029C: '',  # 𠊜
    # 0x2029D: '',  # 𠊝
    # 0x2029E: '',  # 𠊞
    # 0x2029F: '',  # 𠊟
    # 0x202A0: '',  # 𠊠
    # 0x202A1: '',  # 𠊡
    # 0x202A2: '',  # 𠊢
    0x202A3: 'zhòu',  # 𠊣
    0x202A4: 'zhì',  # 𠊤
    0x202A5: 'zhǒng',  # 𠊥
    0x202A6: 'nǎo',  # 𠊦
    0x202A7: 'bìng',  # 𠊧
    # 0x202A8: '',  # 𠊨
    0x202A9: 'zhuàn',  # 𠊩
    0x202AA: 'shù',  # 𠊪
    0x202AB: 'xùn,qióng',  # 𠊫
    0x202AC: 'jué',  # 𠊬
    0x202AD: 'qiǎn',  # 𠊭
    # 0x202AE: '',  # 𠊮
    # 0x202AF: '',  # 𠊯
    0x202B0: 'guǎ',  # 𠊰
    0x202B1: 'hòu',  # 𠊱
    0x202B2: 'tū',  # 𠊲
    # 0x202B3: '',  # 𠊳
    # 0x202B4: '',  # 𠊴
    0x202B5: 'bēng',  # 𠊵
    0x202B6: 'yìng',  # 𠊶
    0x202B7: 'zhì',  # 𠊷
    # 0x202B8: '',  # 𠊸
    # 0x202B9: '',  # 𠊹
    # 0x202BA: '',  # 𠊺
    # 0x202BB: '',  # 𠊻
    # 0x202BC: '',  # 𠊼
    # 0x202BD: '',  # 𠊽
    0x202BE: 'kuí',  # 𠊾
    # 0x202BF: '',  # 𠊿
    # 0x202C0: '',  # 𠋀
    # 0x202C1: '',  # 𠋁
    # 0x202C2: '',  # 𠋂
    # 0x202C3: '',  # 𠋃
    # 0x202C4: '',  # 𠋄
    # 0x202C5: '',  # 𠋅
    # 0x202C6: '',  # 𠋆
    # 0x202C7: '',  # 𠋇
    # 0x202C8: '',  # 𠋈
    # 0x202C9: '',  # 𠋉
    # 0x202CA: '',  # 𠋊
    # 0x202CB: '',  # 𠋋
    # 0x202CC: '',  # 𠋌
    # 0x202CD: '',  # 𠋍
    # 0x202CE: '',  # 𠋎
    # 0x202CF: '',  # 𠋏
    # 0x202D0: '',  # 𠋐
    # 0x202D1: '',  # 𠋑
    # 0x202D2: '',  # 𠋒
    # 0x202D3: '',  # 𠋓
    # 0x202D4: '',  # 𠋔
    # 0x202D5: '',  # 𠋕
    0x202D6: 'liàn',  # 𠋖
    0x202D7: 'yā',  # 𠋗
    # 0x202D8: '',  # 𠋘
    # 0x202D9: '',  # 𠋙
    # 0x202DA: '',  # 𠋚
    # 0x202DB: '',  # 𠋛
    0x202DC: 'guò',  # 𠋜
    0x202DD: 'miǎo',  # 𠋝
    0x202DE: 'shé',  # 𠋞
    0x202DF: 'yǔ',  # 𠋟
    # 0x202E0: '',  # 𠋠
    0x202E1: 'sì',  # 𠋡
    0x202E2: 'sǒu,zhòu',  # 𠋢
    0x202E3: 'yǐ',  # 𠋣
    0x202E4: 'zhì',  # 𠋤
    # 0x202E5: '',  # 𠋥
    # 0x202E6: '',  # 𠋦
    0x202E7: 'qiē',  # 𠋧
    # 0x202E8: '',  # 𠋨
    0x202E9: 'fù',  # 𠋩
    # 0x202EA: '',  # 𠋪
    # 0x202EB: '',  # 𠋫
    0x202EC: 'jú',  # 𠋬
    0x202ED: 'bèi',  # 𠋭
    # 0x202EE: '',  # 𠋮
    0x202EF: 'bì',  # 𠋯
    # 0x202F0: '',  # 𠋰
    # 0x202F1: '',  # 𠋱
    0x202F2: 'suǒ',  # 𠋲
    # 0x202F3: '',  # 𠋳
    # 0x202F4: '',  # 𠋴
    0x202F5: 'qiǎn',  # 𠋵
    0x202F6: 'mǐng',  # 𠋶
    0x202F7: 'chǎn',  # 𠋷
    # 0x202F8: '',  # 𠋸
    # 0x202F9: '',  # 𠋹
    0x202FA: 'sāo',  # 𠋺
    0x202FB: 'jī',  # 𠋻
    # 0x202FC: '',  # 𠋼
    # 0x202FD: '',  # 𠋽
    # 0x202FE: '',  # 𠋾
    # 0x202FF: '',  # 𠋿
    # 0x20300: '',  # 𠌀
    # 0x20301: '',  # 𠌁
    # 0x20302: '',  # 𠌂
    # 0x20303: '',  # 𠌃
    # 0x20304: '',  # 𠌄
    # 0x20305: '',  # 𠌅
    # 0x20306: '',  # 𠌆
    # 0x20307: '',  # 𠌇
    # 0x20308: '',  # 𠌈
    # 0x20309: '',  # 𠌉
    # 0x2030A: '',  # 𠌊
    # 0x2030B: '',  # 𠌋
    # 0x2030C: '',  # 𠌌
    # 0x2030D: '',  # 𠌍
    # 0x2030E: '',  # 𠌎
    # 0x2030F: '',  # 𠌏
    # 0x20310: '',  # 𠌐
    # 0x20311: '',  # 𠌑
    # 0x20312: '',  # 𠌒
    # 0x20313: '',  # 𠌓
    # 0x20314: '',  # 𠌔
    0x20315: 'gòng',  # 𠌕
    0x20316: 'qióng',  # 𠌖
    # 0x20317: '',  # 𠌗
    # 0x20318: '',  # 𠌘
    # 0x20319: '',  # 𠌙
    0x2031A: 'ròng',  # 𠌚
    # 0x2031B: '',  # 𠌛
    # 0x2031C: '',  # 𠌜
    # 0x2031D: '',  # 𠌝
    0x2031E: 'sǒu',  # 𠌞
    0x2031F: 'sǒu',  # 𠌟
    0x20320: 'yáo',  # 𠌠
    # 0x20321: '',  # 𠌡
    # 0x20322: '',  # 𠌢
    # 0x20323: '',  # 𠌣
    # 0x20324: '',  # 𠌤
    0x20325: 'wū',  # 𠌥
    # 0x20326: '',  # 𠌦
    # 0x20327: '',  # 𠌧
    # 0x20328: '',  # 𠌨
    # 0x20329: '',  # 𠌩
    0x2032A: 'chōu,tāo',  # 𠌪
    # 0x2032B: '',  # 𠌫
    # 0x2032C: '',  # 𠌬
    0x2032D: 'shuài',  # 𠌭
    0x2032E: 'zhē',  # 𠌮
    0x2032F: 'lì,lí',  # 𠌯
    0x20330: 'gài',  # 𠌰
    0x20331: 'suī',  # 𠌱
    0x20332: 'zhān',  # 𠌲
    # 0x20333: '',  # 𠌳
    0x20334: 'zhuàng',  # 𠌴
    # 0x20335: '',  # 𠌵
    0x20336: 'huā',  # 𠌶
    # 0x20337: '',  # 𠌷
    # 0x20338: '',  # 𠌸
    # 0x20339: '',  # 𠌹
    # 0x2033A: '',  # 𠌺
    # 0x2033B: '',  # 𠌻
    # 0x2033C: '',  # 𠌼
    0x2033D: 'fù',  # 𠌽
    # 0x2033E: '',  # 𠌾
    # 0x2033F: '',  # 𠌿
    # 0x20340: '',  # 𠍀
    # 0x20341: '',  # 𠍁
    # 0x20342: '',  # 𠍂
    0x20343: 'jī',  # 𠍃
    0x20344: 'dōu',  # 𠍄
    # 0x20345: '',  # 𠍅
    # 0x20346: '',  # 𠍆
    # 0x20347: '',  # 𠍇
    # 0x20348: '',  # 𠍈
    # 0x20349: '',  # 𠍉
    # 0x2034A: '',  # 𠍊
    # 0x2034B: '',  # 𠍋
    # 0x2034C: '',  # 𠍌
    # 0x2034D: '',  # 𠍍
    # 0x2034E: '',  # 𠍎
    # 0x2034F: '',  # 𠍏
    0x20350: 'hú,lěng',  # 𠍐
    # 0x20351: '',  # 𠍑
    # 0x20352: '',  # 𠍒
    # 0x20353: '',  # 𠍓
    # 0x20354: '',  # 𠍔
    # 0x20355: '',  # 𠍕
    # 0x20356: '',  # 𠍖
    0x20357: 'huì',  # 𠍗
    # 0x20358: '',  # 𠍘
    0x20359: 'bǎo',  # 𠍙
    0x2035A: 'jiǎn',  # 𠍚
    0x2035B: 'yǎn',  # 𠍛
    0x2035C: 'zhì',  # 𠍜
    # 0x2035D: '',  # 𠍝
    # 0x2035E: '',  # 𠍞
    # 0x2035F: '',  # 𠍟
    # 0x20360: '',  # 𠍠
    # 0x20361: '',  # 𠍡
    # 0x20362: '',  # 𠍢
    # 0x20363: '',  # 𠍣
    # 0x20364: '',  # 𠍤
    # 0x20365: '',  # 𠍥
    0x20366: 'xián',  # 𠍦
    # 0x20367: '',  # 𠍧
    0x20368: 'měi',  # 𠍨
    0x20369: 'yào',  # 𠍩
    0x2036A: 'dī',  # 𠍪
    0x2036B: 'yí',  # 𠍫
    # 0x2036C: '',  # 𠍬
    # 0x2036D: '',  # 𠍭
    # 0x2036E: '',  # 𠍮
    0x2036F: 'bié',  # 𠍯
    # 0x20370: '',  # 𠍰
    # 0x20371: '',  # 𠍱
    0x20372: 'qú',  # 𠍲
    0x20373: 'yì',  # 𠍳
    # 0x20374: '',  # 𠍴
    0x20375: 'yàng',  # 𠍵
    # 0x20376: '',  # 𠍶
    # 0x20377: '',  # 𠍷
    # 0x20378: '',  # 𠍸
    0x20379: 'zhá',  # 𠍹
    # 0x2037A: '',  # 𠍺
    # 0x2037B: '',  # 𠍻
    # 0x2037C: '',  # 𠍼
    0x2037D: 'shà',  # 𠍽
    # 0x2037E: '',  # 𠍾
    # 0x2037F: '',  # 𠍿
    # 0x20380: '',  # 𠎀
    # 0x20381: '',  # 𠎁
    # 0x20382: '',  # 𠎂
    # 0x20383: '',  # 𠎃
    # 0x20384: '',  # 𠎄
    # 0x20385: '',  # 𠎅
    # 0x20386: '',  # 𠎆
    # 0x20387: '',  # 𠎇
    # 0x20388: '',  # 𠎈
    # 0x20389: '',  # 𠎉
    # 0x2038A: '',  # 𠎊
    # 0x2038B: '',  # 𠎋
    # 0x2038C: '',  # 𠎌
    # 0x2038D: '',  # 𠎍
    # 0x2038E: '',  # 𠎎
    # 0x2038F: '',  # 𠎏
    # 0x20390: '',  # 𠎐
    # 0x20391: '',  # 𠎑
    0x20392: 'mèn',  # 𠎒
    # 0x20393: '',  # 𠎓
    # 0x20394: '',  # 𠎔
    # 0x20395: '',  # 𠎕
    # 0x20396: '',  # 𠎖
    # 0x20397: '',  # 𠎗
    # 0x20398: '',  # 𠎘
    0x20399: 'lái',  # 𠎙
    # 0x2039A: '',  # 𠎚
    # 0x2039B: '',  # 𠎛
    # 0x2039C: '',  # 𠎜
    0x2039D: 'qiān',  # 𠎝
    # 0x2039E: '',  # 𠎞
    # 0x2039F: '',  # 𠎟
    # 0x203A0: '',  # 𠎠
    # 0x203A1: '',  # 𠎡
    # 0x203A2: '',  # 𠎢
    # 0x203A3: '',  # 𠎣
    # 0x203A4: '',  # 𠎤
    # 0x203A5: '',  # 𠎥
    # 0x203A6: '',  # 𠎦
    # 0x203A7: '',  # 𠎧
    # 0x203A8: '',  # 𠎨
    # 0x203A9: '',  # 𠎩
    # 0x203AA: '',  # 𠎪
    # 0x203AB: '',  # 𠎫
    # 0x203AC: '',  # 𠎬
    # 0x203AD: '',  # 𠎭
    0x203AE: 'jué',  # 𠎮
    # 0x203AF: '',  # 𠎯
    0x203B0: 'qī',  # 𠎰
    # 0x203B1: '',  # 𠎱
    # 0x203B2: '',  # 𠎲
    0x203B3: 'yú',  # 𠎳
    # 0x203B4: '',  # 𠎴
    # 0x203B5: '',  # 𠎵
    0x203B6: 'zǎi',  # 𠎶
    0x203B7: 'sà',  # 𠎷
    0x203B8: 'sè',  # 𠎸
    # 0x203B9: '',  # 𠎹
    # 0x203BA: '',  # 𠎺
    0x203BB: 'dùn',  # 𠎻
    # 0x203BC: '',  # 𠎼
    # 0x203BD: '',  # 𠎽
    # 0x203BE: '',  # 𠎾
    0x203BF: 'jiě',  # 𠎿
    0x203C0: 'kē',  # 𠏀
    # 0x203C1: '',  # 𠏁
    # 0x203C2: '',  # 𠏂
    0x203C3: 'yuē',  # 𠏃
    # 0x203C4: '',  # 𠏄
    # 0x203C5: '',  # 𠏅
    # 0x203C6: '',  # 𠏆
    0x203C7: 'jiǎn',  # 𠏇
    0x203C8: 'yáo',  # 𠏈
    # 0x203C9: '',  # 𠏉
    # 0x203CA: '',  # 𠏊
    # 0x203CB: '',  # 𠏋
    # 0x203CC: '',  # 𠏌
    # 0x203CD: '',  # 𠏍
    # 0x203CE: '',  # 𠏎
    # 0x203CF: '',  # 𠏏
    # 0x203D0: '',  # 𠏐
    # 0x203D1: '',  # 𠏑
    # 0x203D2: '',  # 𠏒
    0x203D3: 'xiān',  # 𠏓
    # 0x203D4: '',  # 𠏔
    0x203D5: 'xiào',  # 𠏕
    0x203D6: 'qiāo',  # 𠏖
    # 0x203D7: '',  # 𠏗
    # 0x203D8: '',  # 𠏘
    # 0x203D9: '',  # 𠏙
    0x203DA: 'yù',  # 𠏚
    0x203DB: 'qú',  # 𠏛
    # 0x203DC: '',  # 𠏜
    # 0x203DD: '',  # 𠏝
    # 0x203DE: '',  # 𠏞
    # 0x203DF: '',  # 𠏟
    # 0x203E0: '',  # 𠏠
    0x203E1: 'xiān,líng',  # 𠏡
    0x203E2: 'luò',  # 𠏢
    # 0x203E3: '',  # 𠏣
    0x203E4: 'guǎng',  # 𠏤
    # 0x203E5: '',  # 𠏥
    # 0x203E6: '',  # 𠏦
    0x203E7: 'chēng',  # 𠏧
    0x203E8: 'chuǎng',  # 𠏨
    0x203E9: 'yí',  # 𠏩
    # 0x203EA: '',  # 𠏪
    0x203EB: 'zhěng',  # 𠏫
    # 0x203EC: '',  # 𠏬
    0x203ED: 'zòng',  # 𠏭
    0x203EE: 'duì',  # 𠏮
    # 0x203EF: '',  # 𠏯
    0x203F0: 'zhǎi',  # 𠏰
    # 0x203F1: '',  # 𠏱
    # 0x203F2: '',  # 𠏲
    # 0x203F3: '',  # 𠏳
    # 0x203F4: '',  # 𠏴
    # 0x203F5: '',  # 𠏵
    # 0x203F6: '',  # 𠏶
    # 0x203F7: '',  # 𠏷
    # 0x203F8: '',  # 𠏸
    # 0x203F9: '',  # 𠏹
    # 0x203FA: '',  # 𠏺
    # 0x203FB: '',  # 𠏻
    # 0x203FC: '',  # 𠏼
    # 0x203FD: '',  # 𠏽
    # 0x203FE: '',  # 𠏾
    0x203FF: 'fěi',  # 𠏿
    0x20400: 'yí',  # 𠐀
    0x20401: 'méng',  # 𠐁
    # 0x20402: '',  # 𠐂
    # 0x20403: '',  # 𠐃
    # 0x20404: '',  # 𠐄
    # 0x20405: '',  # 𠐅
    # 0x20406: '',  # 𠐆
    # 0x20407: '',  # 𠐇
    0x20408: 'biān,pián',  # 𠐈
    0x20409: 'jié',  # 𠐉
    0x2040A: 'shù',  # 𠐊
    0x2040B: 'liáo',  # 𠐋
    0x2040C: 'bǐ,bà',  # 𠐌
    0x2040D: 'sú',  # 𠐍
    # 0x2040E: '',  # 𠐎
    # 0x2040F: '',  # 𠐏
    # 0x20410: '',  # 𠐐
    0x20411: 'dì',  # 𠐑
    # 0x20412: '',  # 𠐒
    # 0x20413: '',  # 𠐓
    # 0x20414: '',  # 𠐔
    # 0x20415: '',  # 𠐕
    # 0x20416: '',  # 𠐖
    # 0x20417: '',  # 𠐗
    # 0x20418: '',  # 𠐘
    # 0x20419: '',  # 𠐙
    # 0x2041A: '',  # 𠐚
    # 0x2041B: '',  # 𠐛
    # 0x2041C: '',  # 𠐜
    # 0x2041D: '',  # 𠐝
    # 0x2041E: '',  # 𠐞
    # 0x2041F: '',  # 𠐟
    # 0x20420: '',  # 𠐠
    0x20421: 'bèi',  # 𠐡
    0x20422: 'wèn',  # 𠐢
    # 0x20423: '',  # 𠐣
    # 0x20424: '',  # 𠐤
    # 0x20425: '',  # 𠐥
    # 0x20426: '',  # 𠐦
    0x20427: 'méng',  # 𠐧
    # 0x20428: '',  # 𠐨
    0x20429: 'chǎn',  # 𠐩
    # 0x2042A: '',  # 𠐪
    # 0x2042B: '',  # 𠐫
    # 0x2042C: '',  # 𠐬
    # 0x2042D: '',  # 𠐭
    # 0x2042E: '',  # 𠐮
    # 0x2042F: '',  # 𠐯
    # 0x20430: '',  # 𠐰
    0x20431: 'gàn',  # 𠐱
    0x20432: 'bèi',  # 𠐲
    # 0x20433: '',  # 𠐳
    # 0x20434: '',  # 𠐴
    0x20435: 'dǎo',  # 𠐵
    # 0x20436: '',  # 𠐶
    # 0x20437: '',  # 𠐷
    # 0x20438: '',  # 𠐸
    # 0x20439: '',  # 𠐹
    0x2043A: 'pín',  # 𠐺
    0x2043B: 'jiǎn',  # 𠐻
    0x2043C: 'lìn',  # 𠐼
    0x2043D: 'guì,guī',  # 𠐽
    0x2043E: 'qī',  # 𠐾
    0x2043F: 'hōng',  # 𠐿
    # 0x20440: '',  # 𠑀
    # 0x20441: '',  # 𠑁
    # 0x20442: '',  # 𠑂
    0x20443: 'jí',  # 𠑃
    0x20444: 'xiè',  # 𠑄
    0x20445: 'zhēng',  # 𠑅
    0x20446: 'chǎn',  # 𠑆
    # 0x20447: '',  # 𠑇
    # 0x20448: '',  # 𠑈
    # 0x20449: '',  # 𠑉
    # 0x2044A: '',  # 𠑊
    # 0x2044B: '',  # 𠑋
    # 0x2044C: '',  # 𠑌
    # 0x2044D: '',  # 𠑍
    # 0x2044E: '',  # 𠑎
    # 0x2044F: '',  # 𠑏
    0x20450: 'yáo',  # 𠑐
    0x20451: 'chǎn',  # 𠑑
    # 0x20452: '',  # 𠑒
    # 0x20453: '',  # 𠑓
    # 0x20454: '',  # 𠑔
    # 0x20455: '',  # 𠑕
    # 0x20456: '',  # 𠑖
    # 0x20457: '',  # 𠑗
    0x20458: 'diān',  # 𠑘
    0x20459: 'chòng',  # 𠑙
    0x2045A: 'néi',  # 𠑚
    0x2045B: 'néi',  # 𠑛
    # 0x2045C: '',  # 𠑜
    # 0x2045D: '',  # 𠑝
    0x2045E: 'zhài',  # 𠑞
    0x2045F: 'biān,pián',  # 𠑟
    # 0x20460: '',  # 𠑠
    0x20461: 'chǎn',  # 𠑡
    # 0x20462: '',  # 𠑢
    # 0x20463: '',  # 𠑣
    # 0x20464: '',  # 𠑤
    # 0x20465: '',  # 𠑥
    # 0x20466: '',  # 𠑦
    # 0x20467: '',  # 𠑧
    # 0x20468: '',  # 𠑨
    # 0x20469: '',  # 𠑩
    0x2046A: 'xiāo',  # 𠑪
    # 0x2046B: '',  # 𠑫
    # 0x2046C: '',  # 𠑬
    # 0x2046D: '',  # 𠑭
    # 0x2046E: '',  # 𠑮
    0x2046F: 'cù',  # 𠑯
    0x20470: 'xīn',  # 𠑰
    0x20471: 'jǐng',  # 𠑱
    0x20472: 'qiān',  # 𠑲
    # 0x20473: '',  # 𠑳
    0x20474: 'qīng',  # 𠑴
    # 0x20475: '',  # 𠑵
    0x20476: 'wú',  # 𠑶
    0x20477: 'cháng,zhǎng',  # 𠑷
    # 0x20478: '',  # 𠑸
    0x20479: 'gǔ',  # 𠑹
    0x2047A: 'tiān',  # 𠑺
    0x2047B: 'cháng,zhǎng',  # 𠑻
    # 0x2047C: '',  # 𠑼
    0x2047D: 'chōng',  # 𠑽
    0x2047E: 'sǐ',  # 𠑾
    # 0x2047F: '',  # 𠑿
    # 0x20480: '',  # 𠒀
    # 0x20481: '',  # 𠒁
    # 0x20482: '',  # 𠒂
    0x20483: 'sì',  # 𠒃
    0x20484: 'wù',  # 𠒄
    0x20485: 'sì',  # 𠒅
    0x20486: 'ér',  # 𠒆
    # 0x20487: '',  # 𠒇
    # 0x20488: '',  # 𠒈
    # 0x20489: '',  # 𠒉
    # 0x2048A: '',  # 𠒊
    # 0x2048B: '',  # 𠒋
    0x2048C: 'qiāng',  # 𠒌
    0x2048D: 'yú',  # 𠒍
    # 0x2048E: '',  # 𠒎
    # 0x2048F: '',  # 𠒏
    # 0x20490: '',  # 𠒐
    # 0x20491: '',  # 𠒑
    # 0x20492: '',  # 𠒒
    # 0x20493: '',  # 𠒓
    # 0x20494: '',  # 𠒔
    # 0x20495: '',  # 𠒕
    # 0x20496: '',  # 𠒖
    # 0x20497: '',  # 𠒗
    # 0x20498: '',  # 𠒘
    # 0x20499: '',  # 𠒙
    # 0x2049A: '',  # 𠒚
    # 0x2049B: '',  # 𠒛
    0x2049C: 'yuǎn',  # 𠒜
    0x2049D: 'bǐng',  # 𠒝
    # 0x2049E: '',  # 𠒞
    # 0x2049F: '',  # 𠒟
    # 0x204A0: '',  # 𠒠
    # 0x204A1: '',  # 𠒡
    0x204A2: 'wán',  # 𠒢
    # 0x204A3: '',  # 𠒣
    # 0x204A4: '',  # 𠒤
    # 0x204A5: '',  # 𠒥
    # 0x204A6: '',  # 𠒦
    0x204A7: 'bó',  # 𠒧
    0x204A8: 'liáng,liàng',  # 𠒨
    # 0x204A9: '',  # 𠒩
    # 0x204AA: '',  # 𠒪
    # 0x204AB: '',  # 𠒫
    # 0x204AC: '',  # 𠒬
    # 0x204AD: '',  # 𠒭
    # 0x204AE: '',  # 𠒮
    # 0x204AF: '',  # 𠒯
    0x204B0: 'niǎo,ní',  # 𠒰
    0x204B1: 'pì',  # 𠒱
    # 0x204B2: '',  # 𠒲
    # 0x204B3: '',  # 𠒳
    # 0x204B4: '',  # 𠒴
    0x204B5: 'liàn',  # 𠒵
    # 0x204B6: '',  # 𠒶
    # 0x204B7: '',  # 𠒷
    0x204B8: 'rǎo',  # 𠒸
    # 0x204B9: '',  # 𠒹
    # 0x204BA: '',  # 𠒺
    # 0x204BB: '',  # 𠒻
    # 0x204BC: '',  # 𠒼
    # 0x204BD: '',  # 𠒽
    0x204BE: 'fàn',  # 𠒾
    0x204BF: 'dí',  # 𠒿
    # 0x204C0: '',  # 𠓀
    # 0x204C1: '',  # 𠓁
    # 0x204C2: '',  # 𠓂
    # 0x204C3: '',  # 𠓃
    # 0x204C4: '',  # 𠓄
    # 0x204C5: '',  # 𠓅
    0x204C6: 'jīng',  # 𠓆
    # 0x204C7: '',  # 𠓇
    # 0x204C8: '',  # 𠓈
    # 0x204C9: '',  # 𠓉
    0x204CA: 'huī,dān',  # 𠓊
    0x204CB: 'yì',  # 𠓋
    0x204CC: 'xián',  # 𠓌
    # 0x204CD: '',  # 𠓍
    # 0x204CE: '',  # 𠓎
    # 0x204CF: '',  # 𠓏
    # 0x204D0: '',  # 𠓐
    # 0x204D1: '',  # 𠓑
    # 0x204D2: '',  # 𠓒
    # 0x204D3: '',  # 𠓓
    # 0x204D4: '',  # 𠓔
    # 0x204D5: '',  # 𠓕
    0x204D6: 'lán',  # 𠓖
    0x204D7: 'fù',  # 𠓗
    # 0x204D8: '',  # 𠓘
    0x204D9: 'xiòng',  # 𠓙
    # 0x204DA: '',  # 𠓚
    0x204DB: 'jí',  # 𠓛
    0x204DC: 'liǎng',  # 𠓜
    0x204DD: 'tāo',  # 𠓝
    0x204DE: 'jí',  # 𠓞
    0x204DF: 'fá',  # 𠓟
    # 0x204E0: '',  # 𠓠
    0x204E1: 'shǐ',  # 𠓡
    0x204E2: 'jiè',  # 𠓢
    0x204E3: 'zhá',  # 𠓣
    0x204E4: 'shī',  # 𠓤
    # 0x204E5: '',  # 𠓥
    # 0x204E6: '',  # 𠓦
    # 0x204E7: '',  # 𠓧
    # 0x204E8: '',  # 𠓨
    # 0x204E9: '',  # 𠓩
    0x204EA: 'qí',  # 𠓪
    0x204EB: 'biǎn',  # 𠓫
    # 0x204EC: '',  # 𠓬
    0x204ED: 'lǎn',  # 𠓭
    0x204EE: 'lǐn',  # 𠓮
    # 0x204EF: '',  # 𠓯
    # 0x204F0: '',  # 𠓰
    0x204F1: 'yù',  # 𠓱
    0x204F2: 'chéng',  # 𠓲
    # 0x204F3: '',  # 𠓳
    0x204F4: 'quán',  # 𠓴
    0x204F5: 'bì',  # 𠓵
    0x204F6: 'zhì',  # 𠓶
    0x204F7: 'bì,chéng',  # 𠓷
    0x204F8: 'shèng',  # 𠓸
    # 0x204F9: '',  # 𠓹
    # 0x204FA: '',  # 𠓺
    # 0x204FB: '',  # 𠓻
    # 0x204FC: '',  # 𠓼
    0x204FD: 'shèng',  # 𠓽
    # 0x204FE: '',  # 𠓾
    0x204FF: 'qín',  # 𠓿
    0x20500: 'bān',  # 𠔀
    0x20501: 'bié',  # 𠔁
    0x20502: 'biāo',  # 𠔂
    0x20503: 'xī',  # 𠔃
    # 0x20504: '',  # 𠔄
    # 0x20505: '',  # 𠔅
    # 0x20506: '',  # 𠔆
    # 0x20507: '',  # 𠔇
    0x20508: 'zhōng',  # 𠔈
    0x20509: 'juàn',  # 𠔉
    0x2050A: 'cháng,zhǎng',  # 𠔊
    0x2050B: 'jī,xìn',  # 𠔋
    0x2050C: 'jué',  # 𠔌
    0x2050D: 'xī',  # 𠔍
    0x2050E: 'qǐn',  # 𠔎
    # 0x2050F: '',  # 𠔏
    0x20510: 'jī',  # 𠔐
    0x20511: 'hài',  # 𠔑
    0x20512: 'chǐ',  # 𠔒
    0x20513: 'diǎn',  # 𠔓
    0x20514: 'yǔ',  # 𠔔
    0x20515: 'lún',  # 𠔕
    0x20516: 'jǔ',  # 𠔖
    # 0x20517: '',  # 𠔗
    # 0x20518: '',  # 𠔘
    0x20519: 'zhōng',  # 𠔙
    0x2051A: 'qì',  # 𠔚
    0x2051B: 'jī',  # 𠔛
    # 0x2051C: '',  # 𠔜
    # 0x2051D: '',  # 𠔝
    # 0x2051E: '',  # 𠔞
    0x2051F: 'duó',  # 𠔟
    0x20520: 'yuè',  # 𠔠
    # 0x20521: '',  # 𠔡
    # 0x20522: '',  # 𠔢
    # 0x20523: '',  # 𠔣
    # 0x20524: '',  # 𠔤
    # 0x20525: '',  # 𠔥
    # 0x20526: '',  # 𠔦
    # 0x20527: '',  # 𠔧
    0x20528: 'lián',  # 𠔨
    # 0x20529: '',  # 𠔩
    # 0x2052A: '',  # 𠔪
    # 0x2052B: '',  # 𠔫
    # 0x2052C: '',  # 𠔬
    # 0x2052D: '',  # 𠔭
    # 0x2052E: '',  # 𠔮
    0x2052F: 'bān',  # 𠔯
    0x20530: 'diǎn',  # 𠔰
    # 0x20531: '',  # 𠔱
    0x20532: 'héng',  # 𠔲
    # 0x20533: '',  # 𠔳
    # 0x20534: '',  # 𠔴
    # 0x20535: '',  # 𠔵
    0x20536: 'qī',  # 𠔶
    # 0x20537: '',  # 𠔷
    0x20538: 'jī,qī',  # 𠔸
    0x20539: 'chén',  # 𠔹
    0x2053A: 'qiān',  # 𠔺
    0x2053B: 'zhèng',  # 𠔻
    0x2053C: 'mǎo',  # 𠔼
    0x2053D: 'rén',  # 𠔽
    0x2053E: 'zhōng',  # 𠔾
    # 0x2053F: '',  # 𠔿
    # 0x20540: '',  # 𠕀
    0x20541: 'cóng',  # 𠕁
    0x20542: 'zài',  # 𠕂
    0x20543: 'wǎng',  # 𠕃
    0x20544: 'nà',  # 𠕄
    0x20545: 'zài',  # 𠕅
    0x20546: 'diàn',  # 𠕆
    0x20547: 'diàn',  # 𠕇
    # 0x20548: '',  # 𠕈
    # 0x20549: '',  # 𠕉
    0x2054A: 'tǐng',  # 𠕊
    0x2054B: 'cè',  # 𠕋
    0x2054C: 'zōng',  # 𠕌
    0x2054D: 'guān',  # 𠕍
    # 0x2054E: '',  # 𠕎
    # 0x2054F: '',  # 𠕏
    0x20550: 'cè',  # 𠕐
    0x20551: 'dān',  # 𠕑
    0x20552: 'yǔ',  # 𠕒
    # 0x20553: '',  # 𠕓
    # 0x20554: '',  # 𠕔
    0x20555: 'jiōng',  # 𠕕
    0x20556: 'zhǎo',  # 𠕖
    0x20557: 'chuò',  # 𠕗
    0x20558: 'yǔ',  # 𠕘
    # 0x20559: '',  # 𠕙
    # 0x2055A: '',  # 𠕚
    0x2055B: 'hé',  # 𠕛
    # 0x2055C: '',  # 𠕜
    0x2055D: 'nuó',  # 𠕝
    0x2055E: 'cì',  # 𠕞
    0x2055F: 'niǎn',  # 𠕟
    0x20560: 'chéng',  # 𠕠
    # 0x20561: '',  # 𠕡
    # 0x20562: '',  # 𠕢
    0x20563: 'qià',  # 𠕣
    0x20564: 'yuān',  # 𠕤
    0x20565: 'dào',  # 𠕥
    0x20566: 'yù',  # 𠕦
    0x20567: 'jiǎo',  # 𠕧
    0x20568: 'jì',  # 𠕨
    0x20569: 'bēi',  # 𠕩
    # 0x2056A: '',  # 𠕪
    # 0x2056B: '',  # 𠕫
    # 0x2056C: '',  # 𠕬
    0x2056D: 'zhào',  # 𠕭
    0x2056E: 'xū',  # 𠕮
    # 0x2056F: '',  # 𠕯
    0x20570: 'nuó',  # 𠕰
    # 0x20571: '',  # 𠕱
    0x20572: 'yǔ',  # 𠕲
    0x20573: 'dí',  # 𠕳
    0x20574: 'jiū',  # 𠕴
    # 0x20575: '',  # 𠕵
    # 0x20576: '',  # 𠕶
    # 0x20577: '',  # 𠕷
    0x20578: 'suǐ',  # 𠕸
    # 0x20579: '',  # 𠕹
    # 0x2057A: '',  # 𠕺
    0x2057B: 'yāo',  # 𠕻
    # 0x2057C: '',  # 𠕼
    # 0x2057D: '',  # 𠕽
    # 0x2057E: '',  # 𠕾
    0x2057F: 'wāng',  # 𠕿
    # 0x20580: '',  # 𠖀
    # 0x20581: '',  # 𠖁
    0x20582: 'liáo',  # 𠖂
    # 0x20583: '',  # 𠖃
    0x20584: 'tóng',  # 𠖄
    # 0x20585: '',  # 𠖅
    0x20586: 'mèng',  # 𠖆
    # 0x20587: '',  # 𠖇
    # 0x20588: '',  # 𠖈
    # 0x20589: '',  # 𠖉
    # 0x2058A: '',  # 𠖊
    0x2058B: 'yǒu',  # 𠖋
    # 0x2058C: '',  # 𠖌
    # 0x2058D: '',  # 𠖍
    # 0x2058E: '',  # 𠖎
    # 0x2058F: '',  # 𠖏
    # 0x20590: '',  # 𠖐
    # 0x20591: '',  # 𠖑
    # 0x20592: '',  # 𠖒
    0x20593: 'sī',  # 𠖓
    # 0x20594: '',  # 𠖔
    # 0x20595: '',  # 𠖕
    # 0x20596: '',  # 𠖖
    # 0x20597: '',  # 𠖗
    # 0x20598: '',  # 𠖘
    # 0x20599: '',  # 𠖙
    # 0x2059A: '',  # 𠖚
    0x2059B: 'lòu',  # 𠖛
    # 0x2059C: '',  # 𠖜
    # 0x2059D: '',  # 𠖝
    # 0x2059E: '',  # 𠖞
    0x2059F: 'yīn',  # 𠖟
    # 0x205A0: '',  # 𠖠
    # 0x205A1: '',  # 𠖡
    # 0x205A2: '',  # 𠖢
    # 0x205A3: '',  # 𠖣
    # 0x205A4: '',  # 𠖤
    0x205A5: 'chǒng',  # 𠖥
    # 0x205A6: '',  # 𠖦
    # 0x205A7: '',  # 𠖧
    # 0x205A8: '',  # 𠖨
    # 0x205A9: '',  # 𠖩
    # 0x205AA: '',  # 𠖪
    0x205AB: 'gǎn',  # 𠖫
    0x205AC: 'jiū',  # 𠖬
    # 0x205AD: '',  # 𠖭
    # 0x205AE: '',  # 𠖮
    # 0x205AF: '',  # 𠖯
    # 0x205B0: '',  # 𠖰
    # 0x205B1: '',  # 𠖱
    # 0x205B2: '',  # 𠖲
    # 0x205B3: '',  # 𠖳
    # 0x205B4: '',  # 𠖴
    # 0x205B5: '',  # 𠖵
    0x205B6: 'qìn',  # 𠖶
    0x205B7: 'jiǒng',  # 𠖷
    # 0x205B8: '',  # 𠖸
    0x205B9: 'xié,xiá',  # 𠖹
    # 0x205BA: '',  # 𠖺
    # 0x205BB: '',  # 𠖻
    # 0x205BC: '',  # 𠖼
    # 0x205BD: '',  # 𠖽
    # 0x205BE: '',  # 𠖾
    # 0x205BF: '',  # 𠖿
    # 0x205C0: '',  # 𠗀
    # 0x205C1: '',  # 𠗁
    0x205C2: 'hè',  # 𠗂
    # 0x205C3: '',  # 𠗃
    # 0x205C4: '',  # 𠗄
    # 0x205C5: '',  # 𠗅
    0x205C6: 'tāo',  # 𠗆
    # 0x205C7: '',  # 𠗇
    0x205C8: 'qiú',  # 𠗈
    0x205C9: 'xié',  # 𠗉
    0x205CA: 'jìng',  # 𠗊
    0x205CB: 'niǎn',  # 𠗋
    0x205CC: 'jìng',  # 𠗌
    # 0x205CD: '',  # 𠗍
    # 0x205CE: '',  # 𠗎
    0x205CF: 'jí',  # 𠗏
    # 0x205D0: '',  # 𠗐
    # 0x205D1: '',  # 𠗑
    # 0x205D2: '',  # 𠗒
    # 0x205D3: '',  # 𠗓
    # 0x205D4: '',  # 𠗔
    # 0x205D5: '',  # 𠗕
    # 0x205D6: '',  # 𠗖
    # 0x205D7: '',  # 𠗗
    0x205D8: 'tiǎn',  # 𠗘
    0x205D9: 'hán',  # 𠗙
    0x205DA: 'cuì',  # 𠗚
    0x205DB: 'dié',  # 𠗛
    # 0x205DC: '',  # 𠗜
    0x205DD: 'qǐng',  # 𠗝
    # 0x205DE: '',  # 𠗞
    # 0x205DF: '',  # 𠗟
    # 0x205E0: '',  # 𠗠
    # 0x205E1: '',  # 𠗡
    # 0x205E2: '',  # 𠗢
    # 0x205E3: '',  # 𠗣
    # 0x205E4: '',  # 𠗤
    0x205E5: 'pìng',  # 𠗥
    0x205E6: 'píng',  # 𠗦
    # 0x205E7: '',  # 𠗧
    0x205E8: 'dié',  # 𠗨
    0x205E9: 'lòu',  # 𠗩
    # 0x205EA: '',  # 𠗪
    # 0x205EB: '',  # 𠗫
    # 0x205EC: '',  # 𠗬
    # 0x205ED: '',  # 𠗭
    # 0x205EE: '',  # 𠗮
    # 0x205EF: '',  # 𠗯
    # 0x205F0: '',  # 𠗰
    # 0x205F1: '',  # 𠗱
    # 0x205F2: '',  # 𠗲
    0x205F3: 'liǎn',  # 𠗳
    0x205F4: 'hán',  # 𠗴
    0x205F5: 'pāng',  # 𠗵
    0x205F6: 'táng',  # 𠗶
    # 0x205F7: '',  # 𠗷
    # 0x205F8: '',  # 𠗸
    # 0x205F9: '',  # 𠗹
    0x205FA: 'yí',  # 𠗺
    0x205FB: 'xuán',  # 𠗻
    0x205FC: 'suò',  # 𠗼
    0x205FD: 'liú',  # 𠗽
    0x205FE: 'shuǎng',  # 𠗾
    0x205FF: 'shèn',  # 𠗿
    # 0x20600: '',  # 𠘀
    0x20601: 'bù',  # 𠘁
    0x20602: 'sōu',  # 𠘂
    # 0x20603: '',  # 𠘃
    # 0x20604: '',  # 𠘄
    0x20605: 'qín',  # 𠘅
    0x20606: 'shěn',  # 𠘆
    # 0x20607: '',  # 𠘇
    # 0x20608: '',  # 𠘈
    # 0x20609: '',  # 𠘉
    0x2060A: 'nòng',  # 𠘊
    0x2060B: 'tǐng',  # 𠘋
    0x2060C: 'jiāng',  # 𠘌
    # 0x2060D: '',  # 𠘍
    # 0x2060E: '',  # 𠘎
    # 0x2060F: '',  # 𠘏
    # 0x20610: '',  # 𠘐
    # 0x20611: '',  # 𠘑
    # 0x20612: '',  # 𠘒
    # 0x20613: '',  # 𠘓
    # 0x20614: '',  # 𠘔
    0x20615: 'xī',  # 𠘕
    0x20616: 'zhì',  # 𠘖
    # 0x20617: '',  # 𠘗
    # 0x20618: '',  # 𠘘
    # 0x20619: '',  # 𠘙
    # 0x2061A: '',  # 𠘚
    # 0x2061B: '',  # 𠘛
    # 0x2061C: '',  # 𠘜
    0x2061D: 'lài',  # 𠘝
    0x2061E: 'lì',  # 𠘞
    0x2061F: 'lì',  # 𠘟
    # 0x20620: '',  # 𠘠
    # 0x20621: '',  # 𠘡
    0x20622: 'hé',  # 𠘢
    0x20623: 'jiào',  # 𠘣
    # 0x20624: '',  # 𠘤
    0x20625: 'yán',  # 𠘥
    # 0x20626: '',  # 𠘦
    0x20627: 'shū',  # 𠘧
    # 0x20628: '',  # 𠘨
    # 0x20629: '',  # 𠘩
    0x2062A: 'shǐ',  # 𠘪
    # 0x2062B: '',  # 𠘫
    # 0x2062C: '',  # 𠘬
    # 0x2062D: '',  # 𠘭
    # 0x2062E: '',  # 𠘮
    # 0x2062F: '',  # 𠘯
    # 0x20630: '',  # 𠘰
    0x20631: 'zhěn',  # 𠘱
    # 0x20632: '',  # 𠘲
    0x20633: 'yōu',  # 𠘳
    # 0x20634: '',  # 𠘴
    # 0x20635: '',  # 𠘵
    # 0x20636: '',  # 𠘶
    # 0x20637: '',  # 𠘷
    # 0x20638: '',  # 𠘸
    # 0x20639: '',  # 𠘹
    0x2063A: 'suò',  # 𠘺
    0x2063B: 'wú',  # 𠘻
    # 0x2063C: '',  # 𠘼
    # 0x2063D: '',  # 𠘽
    # 0x2063E: '',  # 𠘾
    # 0x2063F: '',  # 𠘿
    # 0x20640: '',  # 𠙀
    0x20641: 'cháng',  # 𠙁
    0x20642: 'cóng',  # 𠙂
    # 0x20643: '',  # 𠙃
    # 0x20644: '',  # 𠙄
    # 0x20645: '',  # 𠙅
    0x20646: 'jù',  # 𠙆
    # 0x20647: '',  # 𠙇
    # 0x20648: '',  # 𠙈
    # 0x20649: '',  # 𠙉
    # 0x2064A: '',  # 𠙊
    # 0x2064B: '',  # 𠙋
    # 0x2064C: '',  # 𠙌
    # 0x2064D: '',  # 𠙍
    0x2064E: 'shū',  # 𠙎
    # 0x2064F: '',  # 𠙏
    # 0x20650: '',  # 𠙐
    # 0x20651: '',  # 𠙑
    # 0x20652: '',  # 𠙒
    # 0x20653: '',  # 𠙓
    0x20654: 'jiù',  # 𠙔
    0x20655: 'wéi',  # 𠙕
    # 0x20656: '',  # 𠙖
    # 0x20657: '',  # 𠙗
    # 0x20658: '',  # 𠙘
    # 0x20659: '',  # 𠙙
    # 0x2065A: '',  # 𠙚
    # 0x2065B: '',  # 𠙛
    # 0x2065C: '',  # 𠙜
    # 0x2065D: '',  # 𠙝
    0x2065E: 'huò',  # 𠙞
    # 0x2065F: '',  # 𠙟
    0x20660: 'shuāng,shuǎng',  # 𠙠
    # 0x20661: '',  # 𠙡
    # 0x20662: '',  # 𠙢
    # 0x20663: '',  # 𠙣
    0x20664: 'jiē',  # 𠙤
    # 0x20665: '',  # 𠙥
    # 0x20666: '',  # 𠙦
    # 0x20667: '',  # 𠙧
    # 0x20668: '',  # 𠙨
    # 0x20669: '',  # 𠙩
    # 0x2066A: '',  # 𠙪
    # 0x2066B: '',  # 𠙫
    0x2066C: 'zǎo',  # 𠙬
    # 0x2066D: '',  # 𠙭
    # 0x2066E: '',  # 𠙮
    # 0x2066F: '',  # 𠙯
    # 0x20670: '',  # 𠙰
    # 0x20671: '',  # 𠙱
    # 0x20672: '',  # 𠙲
    # 0x20673: '',  # 𠙳
    0x20674: 'qū',  # 𠙴
    # 0x20675: '',  # 𠙵
    0x20676: 'ǒu',  # 𠙶
    # 0x20677: '',  # 𠙷
    # 0x20678: '',  # 𠙸
    # 0x20679: '',  # 𠙹
    # 0x2067A: '',  # 𠙺
    # 0x2067B: '',  # 𠙻
    0x2067C: 'guǎ',  # 𠙼
    # 0x2067D: '',  # 𠙽
    # 0x2067E: '',  # 𠙾
    # 0x2067F: '',  # 𠙿
    # 0x20680: '',  # 𠚀
    # 0x20681: '',  # 𠚁
    # 0x20682: '',  # 𠚂
    0x20683: 'háo',  # 𠚃
    0x20684: 'lǐ',  # 𠚄
    0x20685: 'zhì',  # 𠚅
    0x20686: 'xiàn',  # 𠚆
    # 0x20687: '',  # 𠚇
    # 0x20688: '',  # 𠚈
    0x20689: 'bū',  # 𠚉
    0x2068A: 'chàng',  # 𠚊
    # 0x2068B: '',  # 𠚋
    # 0x2068C: '',  # 𠚌
    # 0x2068D: '',  # 𠚍
    # 0x2068E: '',  # 𠚎
    # 0x2068F: '',  # 𠚏
    # 0x20690: '',  # 𠚐
    # 0x20691: '',  # 𠚑
    # 0x20692: '',  # 𠚒
    0x20693: 'yūn',  # 𠚓
    0x20694: 'hé',  # 𠚔
    # 0x20695: '',  # 𠚕
    # 0x20696: '',  # 𠚖
    # 0x20697: '',  # 𠚗
    # 0x20698: '',  # 𠚘
    # 0x20699: '',  # 𠚙
    # 0x2069A: '',  # 𠚚
    # 0x2069B: '',  # 𠚛
    0x2069C: 'tāo',  # 𠚜
    # 0x2069D: '',  # 𠚝
    # 0x2069E: '',  # 𠚞
    # 0x2069F: '',  # 𠚟
    0x206A0: 'biāo',  # 𠚠
    0x206A1: 'tāo',  # 𠚡
    # 0x206A2: '',  # 𠚢
    0x206A3: 'dāo',  # 𠚣
    # 0x206A4: '',  # 𠚤
    0x206A5: 'diāo',  # 𠚥
    # 0x206A6: '',  # 𠚦
    0x206A7: 'èr',  # 𠚧
    0x206A8: 'jiū',  # 𠚨
    # 0x206A9: '',  # 𠚩
    # 0x206AA: '',  # 𠚪
    # 0x206AB: '',  # 𠚫
    # 0x206AC: '',  # 𠚬
    0x206AD: 'dì',  # 𠚭
    0x206AE: 'yì',  # 𠚮
    0x206AF: 'kūn',  # 𠚯
    # 0x206B0: '',  # 𠚰
    0x206B1: 'zhé',  # 𠚱
    # 0x206B2: '',  # 𠚲
    # 0x206B3: '',  # 𠚳
    0x206B4: 'zhōu',  # 𠚴
    0x206B5: 'jù',  # 𠚵
    # 0x206B6: '',  # 𠚶
    # 0x206B7: '',  # 𠚷
    # 0x206B8: '',  # 𠚸
    0x206B9: 'shàn',  # 𠚹
    0x206BA: 'shà',  # 𠚺
    0x206BB: 'diāo',  # 𠚻
    0x206BC: 'bān',  # 𠚼
    0x206BD: 'jī',  # 𠚽
    # 0x206BE: '',  # 𠚾
    # 0x206BF: '',  # 𠚿
    0x206C0: 'zhōng',  # 𠛀
    # 0x206C1: '',  # 𠛁
    # 0x206C2: '',  # 𠛂
    0x206C3: 'yí',  # 𠛃
    # 0x206C4: '',  # 𠛄
    0x206C5: 'kōu',  # 𠛅
    # 0x206C6: '',  # 𠛆
    # 0x206C7: '',  # 𠛇
    # 0x206C8: '',  # 𠛈
    # 0x206C9: '',  # 𠛉
    0x206CA: 'gē',  # 𠛊
    0x206CB: 'bā',  # 𠛋
    # 0x206CC: '',  # 𠛌
    # 0x206CD: '',  # 𠛍
    0x206CE: 'gōu',  # 𠛎
    # 0x206CF: '',  # 𠛏
    # 0x206D0: '',  # 𠛐
    0x206D1: 'xián',  # 𠛑
    0x206D2: 'guā',  # 𠛒
    0x206D3: 'liǔ',  # 𠛓
    0x206D4: 'chǐ',  # 𠛔
    0x206D5: 'guāi',  # 𠛕
    0x206D6: 'chuān',  # 𠛖
    # 0x206D7: '',  # 𠛗
    0x206D8: 'lí',  # 𠛘
    0x206D9: 'cù',  # 𠛙
    0x206DA: 'shuā',  # 𠛚
    # 0x206DB: '',  # 𠛛
    # 0x206DC: '',  # 𠛜
    # 0x206DD: '',  # 𠛝
    # 0x206DE: '',  # 𠛞
    # 0x206DF: '',  # 𠛟
    # 0x206E0: '',  # 𠛠
    0x206E1: 'bǐ',  # 𠛡
    0x206E2: 'gē',  # 𠛢
    # 0x206E3: '',  # 𠛣
    # 0x206E4: '',  # 𠛤
    0x206E5: 'bǐng',  # 𠛥
    0x206E6: 'lì',  # 𠛦
    # 0x206E7: '',  # 𠛧
    # 0x206E8: '',  # 𠛨
    0x206E9: 'jiǔ',  # 𠛩
    0x206EA: 'tiāo,diāo',  # 𠛪
    0x206EB: 'duǒ',  # 𠛫
    0x206EC: 'xíng',  # 𠛬
    0x206ED: 'yān,yuān',  # 𠛭
    0x206EE: 'quān',  # 𠛮
    # 0x206EF: '',  # 𠛯
    0x206F0: 'bié',  # 𠛰
    0x206F1: 'liè,zā',  # 𠛱
    # 0x206F2: '',  # 𠛲
    0x206F3: 'kè,hé',  # 𠛳
    # 0x206F4: '',  # 𠛴
    0x206F5: 'gēn',  # 𠛵
    0x206F6: 'zhēn',  # 𠛶
    # 0x206F7: '',  # 𠛷
    0x206F8: 'fén',  # 𠛸
    # 0x206F9: '',  # 𠛹
    # 0x206FA: '',  # 𠛺
    # 0x206FB: '',  # 𠛻
    # 0x206FC: '',  # 𠛼
    # 0x206FD: '',  # 𠛽
    # 0x206FE: '',  # 𠛾
    # 0x206FF: '',  # 𠛿
    # 0x20700: '',  # 𠜀
    0x20701: 'yí',  # 𠜁
    # 0x20702: '',  # 𠜂
    0x20703: 'jiù',  # 𠜃
    0x20704: 'xù',  # 𠜄
    0x20705: 'jiǎo',  # 𠜅
    # 0x20706: '',  # 𠜆
    # 0x20707: '',  # 𠜇
    0x20708: 'lǜ',  # 𠜈
    0x20709: 'jiǔ',  # 𠜉
    # 0x2070A: '',  # 𠜊
    0x2070B: 'chǒu',  # 𠜋
    # 0x2070C: '',  # 𠜌
    # 0x2070D: '',  # 𠜍
    0x2070E: 'xiàn',  # 𠜎
    # 0x2070F: '',  # 𠜏
    0x20710: 'kuài',  # 𠜐
    0x20711: 'duì',  # 𠜑
    # 0x20712: '',  # 𠜒
    # 0x20713: '',  # 𠜓
    # 0x20714: '',  # 𠜔
    # 0x20715: '',  # 𠜕
    0x20716: 'luō',  # 𠜖
    0x20717: 'xī,xì',  # 𠜗
    0x20718: 'qìn',  # 𠜘
    0x20719: 'bù',  # 𠜙
    # 0x2071A: '',  # 𠜚
    # 0x2071B: '',  # 𠜛
    # 0x2071C: '',  # 𠜜
    # 0x2071D: '',  # 𠜝
    # 0x2071E: '',  # 𠜞
    # 0x2071F: '',  # 𠜟
    # 0x20720: '',  # 𠜠
    # 0x20721: '',  # 𠜡
    # 0x20722: '',  # 𠜢
    # 0x20723: '',  # 𠜣
    0x20724: 'qià',  # 𠜤
    # 0x20725: '',  # 𠜥
    # 0x20726: '',  # 𠜦
    # 0x20727: '',  # 𠜧
    # 0x20728: '',  # 𠜨
    # 0x20729: '',  # 𠜩
    # 0x2072A: '',  # 𠜪
    # 0x2072B: '',  # 𠜫
    # 0x2072C: '',  # 𠜬
    # 0x2072D: '',  # 𠜭
    # 0x2072E: '',  # 𠜮
    # 0x2072F: '',  # 𠜯
    # 0x20730: '',  # 𠜰
    0x20731: 'pī',  # 𠜱
    0x20732: 'yā',  # 𠜲
    0x20733: 'bēng',  # 𠜳
    0x20734: 'guǒ',  # 𠜴
    0x20735: 'guā',  # 𠜵
    0x20736: 'nǎo',  # 𠜶
    # 0x20737: '',  # 𠜷
    # 0x20738: '',  # 𠜸
    0x20739: 'jú',  # 𠜹
    # 0x2073A: '',  # 𠜺
    # 0x2073B: '',  # 𠜻
    0x2073C: 'qiā',  # 𠜼
    # 0x2073D: '',  # 𠜽
    0x2073E: 'jué,guì',  # 𠜾
    # 0x2073F: '',  # 𠜿
    # 0x20740: '',  # 𠝀
    # 0x20741: '',  # 𠝁
    # 0x20742: '',  # 𠝂
    # 0x20743: '',  # 𠝃
    0x20744: 'lì',  # 𠝄
    # 0x20745: '',  # 𠝅
    # 0x20746: '',  # 𠝆
    # 0x20747: '',  # 𠝇
    # 0x20748: '',  # 𠝈
    # 0x20749: '',  # 𠝉
    # 0x2074A: '',  # 𠝊
    # 0x2074B: '',  # 𠝋
    # 0x2074C: '',  # 𠝌
    # 0x2074D: '',  # 𠝍
    # 0x2074E: '',  # 𠝎
    # 0x2074F: '',  # 𠝏
    0x20750: 'huā',  # 𠝐
    0x20751: 'jiāo',  # 𠝑
    # 0x20752: '',  # 𠝒
    # 0x20753: '',  # 𠝓
    # 0x20754: '',  # 𠝔
    # 0x20755: '',  # 𠝕
    # 0x20756: '',  # 𠝖
    # 0x20757: '',  # 𠝗
    0x20758: 'qià',  # 𠝘
    # 0x20759: '',  # 𠝙
    0x2075A: 'zhá,zhé',  # 𠝚
    0x2075B: 'qiā',  # 𠝛
    # 0x2075C: '',  # 𠝜
    0x2075D: 'zhé,zhá',  # 𠝝
    0x2075E: 'chā',  # 𠝞
    0x2075F: 'yǐng',  # 𠝟
    # 0x20760: '',  # 𠝠
    # 0x20761: '',  # 𠝡
    0x20762: 'yān',  # 𠝢
    # 0x20763: '',  # 𠝣
    0x20764: 'chōng',  # 𠝤
    # 0x20765: '',  # 𠝥
    # 0x20766: '',  # 𠝦
    # 0x20767: '',  # 𠝧
    0x20768: 'chǐ',  # 𠝨
    # 0x20769: '',  # 𠝩
    0x2076A: 'wān',  # 𠝪
    # 0x2076B: '',  # 𠝫
    0x2076C: 'sōu',  # 𠝬
    # 0x2076D: '',  # 𠝭
    # 0x2076E: '',  # 𠝮
    # 0x2076F: '',  # 𠝯
    # 0x20770: '',  # 𠝰
    # 0x20771: '',  # 𠝱
    0x20772: 'kǎn',  # 𠝲
    0x20773: 'yuán',  # 𠝳
    # 0x20774: '',  # 𠝴
    # 0x20775: '',  # 𠝵
    # 0x20776: '',  # 𠝶
    # 0x20777: '',  # 𠝷
    # 0x20778: '',  # 𠝸
    0x20779: 'jiè',  # 𠝹
    # 0x2077A: '',  # 𠝺
    # 0x2077B: '',  # 𠝻
    # 0x2077C: '',  # 𠝼
    0x2077D: 'chóu',  # 𠝽
    # 0x2077E: '',  # 𠝾
    0x2077F: 'suǒ',  # 𠝿
    0x20780: 'tū',  # 𠞀
    # 0x20781: '',  # 𠞁
    # 0x20782: '',  # 𠞂
    0x20783: 'zhé',  # 𠞃
    0x20784: 'tī,chǐ',  # 𠞄
    # 0x20785: '',  # 𠞅
    0x20786: 'wū',  # 𠞆
    # 0x20787: '',  # 𠞇
    0x20788: 'dā',  # 𠞈
    0x20789: 'lì',  # 𠞉
    0x2078A: 'chā,chāi,chá',  # 𠞊
    # 0x2078B: '',  # 𠞋
    # 0x2078C: '',  # 𠞌
    # 0x2078D: '',  # 𠞍
    # 0x2078E: '',  # 𠞎
    # 0x2078F: '',  # 𠞏
    # 0x20790: '',  # 𠞐
    # 0x20791: '',  # 𠞑
    # 0x20792: '',  # 𠞒
    # 0x20793: '',  # 𠞓
    # 0x20794: '',  # 𠞔
    0x20795: 'róng',  # 𠞕
    0x20796: 'gòng',  # 𠞖
    0x20797: 'què',  # 𠞗
    # 0x20798: '',  # 𠞘
    0x20799: 'lí',  # 𠞙
    # 0x2079A: '',  # 𠞚
    # 0x2079B: '',  # 𠞛
    # 0x2079C: '',  # 𠞜
    # 0x2079D: '',  # 𠞝
    0x2079E: 'tāo',  # 𠞞
    # 0x2079F: '',  # 𠞟
    # 0x207A0: '',  # 𠞠
    # 0x207A1: '',  # 𠞡
    # 0x207A2: '',  # 𠞢
    # 0x207A3: '',  # 𠞣
    0x207A4: 'lì',  # 𠞤
    # 0x207A5: '',  # 𠞥
    # 0x207A6: '',  # 𠞦
    0x207A7: 'mí',  # 𠞧
    # 0x207A8: '',  # 𠞨
    0x207A9: 'chì,shuài',  # 𠞩
    # 0x207AA: '',  # 𠞪
    # 0x207AB: '',  # 𠞫
    0x207AC: 'gùn',  # 𠞬
    0x207AD: 'lóu,lòu',  # 𠞭
    0x207AE: 'chuǎng',  # 𠞮
    0x207AF: 'suǒ',  # 𠞯
    0x207B0: 'jiǎo',  # 𠞰
    0x207B1: 'jìn',  # 𠞱
    # 0x207B2: '',  # 𠞲
    # 0x207B3: '',  # 𠞳
    # 0x207B4: '',  # 𠞴
    0x207B5: 'fá',  # 𠞵
    0x207B6: 'zhāi',  # 𠞶
    # 0x207B7: '',  # 𠞷
    # 0x207B8: '',  # 𠞸
    # 0x207B9: '',  # 𠞹
    # 0x207BA: '',  # 𠞺
    # 0x207BB: '',  # 𠞻
    # 0x207BC: '',  # 𠞼
    # 0x207BD: '',  # 𠞽
    0x207BE: 'jìn',  # 𠞾
    0x207BF: 'cuì',  # 𠞿
    # 0x207C0: '',  # 𠟀
    # 0x207C1: '',  # 𠟁
    0x207C2: 'cèng',  # 𠟂
    0x207C3: 'zǔn',  # 𠟃
    0x207C4: 'lì',  # 𠟄
    0x207C5: 'zhào,rì,zhì',  # 𠟅
    # 0x207C6: '',  # 𠟆
    # 0x207C7: '',  # 𠟇
    0x207C8: 'piē',  # 𠟈
    0x207C9: 'zhǎn,chàn',  # 𠟉
    0x207CA: 'xī',  # 𠟊
    0x207CB: 'yào',  # 𠟋
    0x207CC: 'fǔ,pǒu',  # 𠟌
    0x207CD: 'chōng',  # 𠟍
    # 0x207CE: '',  # 𠟎
    # 0x207CF: '',  # 𠟏
    # 0x207D0: '',  # 𠟐
    # 0x207D1: '',  # 𠟑
    # 0x207D2: '',  # 𠟒
    0x207D3: 'cuì',  # 𠟓
    # 0x207D4: '',  # 𠟔
    # 0x207D5: '',  # 𠟕
    # 0x207D6: '',  # 𠟖
    0x207D7: 'guā',  # 𠟗
    # 0x207D8: '',  # 𠟘
    # 0x207D9: '',  # 𠟙
    # 0x207DA: '',  # 𠟚
    # 0x207DB: '',  # 𠟛
    # 0x207DC: '',  # 𠟜
    # 0x207DD: '',  # 𠟝
    # 0x207DE: '',  # 𠟞
    0x207DF: 'fá',  # 𠟟
    # 0x207E0: '',  # 𠟠
    # 0x207E1: '',  # 𠟡
    # 0x207E2: '',  # 𠟢
    0x207E3: 'jī',  # 𠟣
    # 0x207E4: '',  # 𠟤
    # 0x207E5: '',  # 𠟥
    0x207E6: 'sè',  # 𠟦
    0x207E7: 'zhān',  # 𠟧
    0x207E8: 'lìng,líng',  # 𠟨
    0x207E9: 'sè',  # 𠟩
    0x207EA: 'yè',  # 𠟪
    # 0x207EB: '',  # 𠟫
    # 0x207EC: '',  # 𠟬
    # 0x207ED: '',  # 𠟭
    # 0x207EE: '',  # 𠟮
    # 0x207EF: '',  # 𠟯
    0x207F0: 'jū',  # 𠟰
    # 0x207F1: '',  # 𠟱
    # 0x207F2: '',  # 𠟲
    # 0x207F3: '',  # 𠟳
    # 0x207F4: '',  # 𠟴
    # 0x207F5: '',  # 𠟵
    0x207F6: 'tū',  # 𠟶
    # 0x207F7: '',  # 𠟷
    # 0x207F8: '',  # 𠟸
    # 0x207F9: '',  # 𠟹
    0x207FA: 'rú,ruǎn',  # 𠟺
    0x207FB: 'zé,bài',  # 𠟻
    0x207FC: 'huán',  # 𠟼
    # 0x207FD: '',  # 𠟽
    # 0x207FE: '',  # 𠟾
    # 0x207FF: '',  # 𠟿
    # 0x20800: '',  # 𠠀
    0x20801: 'xiǎn',  # 𠠁
    # 0x20802: '',  # 𠠂
    0x20803: 'qiān',  # 𠠃
    0x20804: 'zhào',  # 𠠄
    # 0x20805: '',  # 𠠅
    # 0x20806: '',  # 𠠆
    # 0x20807: '',  # 𠠇
    # 0x20808: '',  # 𠠈
    # 0x20809: '',  # 𠠉
    # 0x2080A: '',  # 𠠊
    0x2080B: 'cán',  # 𠠋
    # 0x2080C: '',  # 𠠌
    0x2080D: 'lí',  # 𠠍
    0x2080E: 'kuò',  # 𠠎
    0x2080F: 'lì',  # 𠠏
    0x20810: 'róu',  # 𠠐
    # 0x20811: '',  # 𠠑
    # 0x20812: '',  # 𠠒
    # 0x20813: '',  # 𠠓
    0x20814: 'dú',  # 𠠔
    # 0x20815: '',  # 𠠕
    # 0x20816: '',  # 𠠖
    0x20817: 'liè',  # 𠠗
    # 0x20818: '',  # 𠠘
    # 0x20819: '',  # 𠠙
    # 0x2081A: '',  # 𠠚
    # 0x2081B: '',  # 𠠛
    0x2081C: 'yīng',  # 𠠜
    0x2081D: 'lì',  # 𠠝
    # 0x2081E: '',  # 𠠞
    # 0x2081F: '',  # 𠠟
    0x20820: 'dú',  # 𠠠
    # 0x20821: '',  # 𠠡
    0x20822: 'líng',  # 𠠢
    # 0x20823: '',  # 𠠣
    # 0x20824: '',  # 𠠤
    # 0x20825: '',  # 𠠥
    # 0x20826: '',  # 𠠦
    # 0x20827: '',  # 𠠧
    # 0x20828: '',  # 𠠨
    # 0x20829: '',  # 𠠩
    0x2082A: 'wān',  # 𠠪
    # 0x2082B: '',  # 𠠫
    # 0x2082C: '',  # 𠠬
    # 0x2082D: '',  # 𠠭
    # 0x2082E: '',  # 𠠮
    0x2082F: 'dié',  # 𠠯
    # 0x20830: '',  # 𠠰
    # 0x20831: '',  # 𠠱
    # 0x20832: '',  # 𠠲
    0x20833: 'jiū',  # 𠠳
    # 0x20834: '',  # 𠠴
    0x20835: 'lì',  # 𠠵
    0x20836: 'kū',  # 𠠶
    0x20837: 'kēng',  # 𠠷
    # 0x20838: '',  # 𠠸
    0x20839: 'zhěn',  # 𠠹
    # 0x2083A: '',  # 𠠺
    # 0x2083B: '',  # 𠠻
    # 0x2083C: '',  # 𠠼
    # 0x2083D: '',  # 𠠽
    # 0x2083E: '',  # 𠠾
    # 0x2083F: '',  # 𠠿
    0x20840: 'hè',  # 𠡀
    # 0x20841: '',  # 𠡁
    0x20842: 'bì,fú',  # 𠡂
    # 0x20843: '',  # 𠡃
    0x20844: 'pī',  # 𠡄
    # 0x20845: '',  # 𠡅
    # 0x20846: '',  # 𠡆
    # 0x20847: '',  # 𠡇
    # 0x20848: '',  # 𠡈
    # 0x20849: '',  # 𠡉
    0x2084A: 'hāng',  # 𠡊
    # 0x2084B: '',  # 𠡋
    # 0x2084C: '',  # 𠡌
    # 0x2084D: '',  # 𠡍
    # 0x2084E: '',  # 𠡎
    # 0x2084F: '',  # 𠡏
    # 0x20850: '',  # 𠡐
    0x20851: 'zhuó',  # 𠡑
    0x20852: 'duǐ',  # 𠡒
    # 0x20853: '',  # 𠡓
    0x20854: 'yì',  # 𠡔
    # 0x20855: '',  # 𠡕
    # 0x20856: '',  # 𠡖
    # 0x20857: '',  # 𠡗
    # 0x20858: '',  # 𠡘
    # 0x20859: '',  # 𠡙
    # 0x2085A: '',  # 𠡚
    # 0x2085B: '',  # 𠡛
    0x2085C: 'kè',  # 𠡜
    0x2085D: 'yì',  # 𠡝
    0x2085E: 'mò',  # 𠡞
    # 0x2085F: '',  # 𠡟
    0x20860: 'chì',  # 𠡠
    0x20861: 'cán',  # 𠡡
    # 0x20862: '',  # 𠡢
    0x20863: 'gěng',  # 𠡣
    0x20864: 'kè',  # 𠡤
    0x20865: 'shì',  # 𠡥
    # 0x20866: '',  # 𠡦
    # 0x20867: '',  # 𠡧
    # 0x20868: '',  # 𠡨
    # 0x20869: '',  # 𠡩
    # 0x2086A: '',  # 𠡪
    # 0x2086B: '',  # 𠡫
    # 0x2086C: '',  # 𠡬
    0x2086D: 'líng,lìng',  # 𠡭
    0x2086E: 'bēng,kēng',  # 𠡮
    # 0x2086F: '',  # 𠡯
    # 0x20870: '',  # 𠡰
    0x20871: 'duàn',  # 𠡱
    # 0x20872: '',  # 𠡲
    # 0x20873: '',  # 𠡳
    # 0x20874: '',  # 𠡴
    # 0x20875: '',  # 𠡵
    0x20876: 'juān',  # 𠡶
    0x20877: 'nǎo',  # 𠡷
    0x20878: 'zǐ',  # 𠡸
    # 0x20879: '',  # 𠡹
    # 0x2087A: '',  # 𠡺
    0x2087B: 'zòng',  # 𠡻
    # 0x2087C: '',  # 𠡼
    # 0x2087D: '',  # 𠡽
    # 0x2087E: '',  # 𠡾
    # 0x2087F: '',  # 𠡿
    # 0x20880: '',  # 𠢀
    # 0x20881: '',  # 𠢁
    # 0x20882: '',  # 𠢂
    0x20883: 'táng',  # 𠢃
    # 0x20884: '',  # 𠢄
    # 0x20885: '',  # 𠢅
    0x20886: 'xiá',  # 𠢆
    0x20887: 'hàn',  # 𠢇
    # 0x20888: '',  # 𠢈
    # 0x20889: '',  # 𠢉
    # 0x2088A: '',  # 𠢊
    # 0x2088B: '',  # 𠢋
    0x2088C: 'lüè',  # 𠢌
    0x2088D: 'qián',  # 𠢍
    # 0x2088E: '',  # 𠢎
    # 0x2088F: '',  # 𠢏
    # 0x20890: '',  # 𠢐
    # 0x20891: '',  # 𠢑
    # 0x20892: '',  # 𠢒
    0x20893: 'mò',  # 𠢓
    0x20894: 'ōu',  # 𠢔
    0x20895: 'háo',  # 𠢕
    # 0x20896: '',  # 𠢖
    # 0x20897: '',  # 𠢗
    # 0x20898: '',  # 𠢘
    0x20899: 'zhá',  # 𠢙
    0x2089A: 'juàn',  # 𠢚
    0x2089B: 'cóng',  # 𠢛
    # 0x2089C: '',  # 𠢜
    # 0x2089D: '',  # 𠢝
    # 0x2089E: '',  # 𠢞
    # 0x2089F: '',  # 𠢟
    0x208A0: 'lì,jí',  # 𠢠
    0x208A1: 'zhá',  # 𠢡
    0x208A2: 'yǒu',  # 𠢢
    0x208A3: 'diàn',  # 𠢣
    0x208A4: 'jué',  # 𠢤
    0x208A5: 'bèi',  # 𠢥
    # 0x208A6: '',  # 𠢦
    # 0x208A7: '',  # 𠢧
    # 0x208A8: '',  # 𠢨
    0x208A9: 'yǎo',  # 𠢩
    0x208AA: 'piē',  # 𠢪
    # 0x208AB: '',  # 𠢫
    # 0x208AC: '',  # 𠢬
    # 0x208AD: '',  # 𠢭
    # 0x208AE: '',  # 𠢮
    # 0x208AF: '',  # 𠢯
    # 0x208B0: '',  # 𠢰
    0x208B1: 'jìn',  # 𠢱
    0x208B2: 'kǎi,xiè',  # 𠢲
    0x208B3: 'sè',  # 𠢳
    0x208B4: 'yǎng',  # 𠢴
    0x208B5: 'jìn',  # 𠢵
    # 0x208B6: '',  # 𠢶
    # 0x208B7: '',  # 𠢷
    # 0x208B8: '',  # 𠢸
    0x208B9: 'kè',  # 𠢹
    # 0x208BA: '',  # 𠢺
    # 0x208BB: '',  # 𠢻
    # 0x208BC: '',  # 𠢼
    # 0x208BD: '',  # 𠢽
    # 0x208BE: '',  # 𠢾
    # 0x208BF: '',  # 𠢿
    # 0x208C0: '',  # 𠣀
    # 0x208C1: '',  # 𠣁
    # 0x208C2: '',  # 𠣂
    # 0x208C3: '',  # 𠣃
    0x208C4: 'chān',  # 𠣄
    # 0x208C5: '',  # 𠣅
    # 0x208C6: '',  # 𠣆
    0x208C7: 'niǎn',  # 𠣇
    # 0x208C8: '',  # 𠣈
    0x208C9: 'wàn',  # 𠣉
    0x208CA: 'lǜ',  # 𠣊
    # 0x208CB: '',  # 𠣋
    # 0x208CC: '',  # 𠣌
    # 0x208CD: '',  # 𠣍
    # 0x208CE: '',  # 𠣎
    # 0x208CF: '',  # 𠣏
    0x208D0: 'yún',  # 𠣐
    0x208D1: 'yāo',  # 𠣑
    0x208D2: 'bāo',  # 𠣒
    # 0x208D3: '',  # 𠣓
    # 0x208D4: '',  # 𠣔
    0x208D5: 'jūn',  # 𠣕
    0x208D6: 'xuán',  # 𠣖
    # 0x208D7: '',  # 𠣗
    0x208D8: 'zhōu',  # 𠣘
    # 0x208D9: '',  # 𠣙
    # 0x208DA: '',  # 𠣚
    # 0x208DB: '',  # 𠣛
    # 0x208DC: '',  # 𠣜
    # 0x208DD: '',  # 𠣝
    # 0x208DE: '',  # 𠣞
    # 0x208DF: '',  # 𠣟
    0x208E0: 'kuì',  # 𠣠
    0x208E1: 'fèng',  # 𠣡
    # 0x208E2: '',  # 𠣢
    # 0x208E3: '',  # 𠣣
    # 0x208E4: '',  # 𠣤
    # 0x208E5: '',  # 𠣥
    # 0x208E6: '',  # 𠣦
    # 0x208E7: '',  # 𠣧
    # 0x208E8: '',  # 𠣨
    # 0x208E9: '',  # 𠣩
    0x208EA: 'qú',  # 𠣪
    0x208EB: 'shào',  # 𠣫
    0x208EC: 'sǔn',  # 𠣬
    # 0x208ED: '',  # 𠣭
    # 0x208EE: '',  # 𠣮
    # 0x208EF: '',  # 𠣯
    0x208F0: 'dū',  # 𠣰
    # 0x208F1: '',  # 𠣱
    0x208F2: 'kuǎi',  # 𠣲
    0x208F3: 'pào',  # 𠣳
    # 0x208F4: '',  # 𠣴
    # 0x208F5: '',  # 𠣵
    # 0x208F6: '',  # 𠣶
    # 0x208F7: '',  # 𠣷
    # 0x208F8: '',  # 𠣸
    # 0x208F9: '',  # 𠣹
    0x208FA: 'bào',  # 𠣺
    # 0x208FB: '',  # 𠣻
    # 0x208FC: '',  # 𠣼
    # 0x208FD: '',  # 𠣽
    0x208FE: 'fù',  # 𠣾
    0x208FF: 'jiù',  # 𠣿
    0x20900: 'rán',  # 𠤀
    # 0x20901: '',  # 𠤁
    # 0x20902: '',  # 𠤂
    # 0x20903: '',  # 𠤃
    0x20904: 'jū',  # 𠤄
    # 0x20905: '',  # 𠤅
    # 0x20906: '',  # 𠤆
    # 0x20907: '',  # 𠤇
    # 0x20908: '',  # 𠤈
    # 0x20909: '',  # 𠤉
    0x2090A: 'qióng',  # 𠤊
    # 0x2090B: '',  # 𠤋
    # 0x2090C: '',  # 𠤌
    0x2090D: 'zhōu',  # 𠤍
    0x2090E: 'huà',  # 𠤎
    0x2090F: 'bǎo',  # 𠤏
    # 0x20910: '',  # 𠤐
    # 0x20911: '',  # 𠤑
    # 0x20912: '',  # 𠤒
    # 0x20913: '',  # 𠤓
    # 0x20914: '',  # 𠤔
    0x20915: 'yí,xián',  # 𠤕
    # 0x20916: '',  # 𠤖
    0x20917: 'yí',  # 𠤗
    0x20918: 'yí,yǐ',  # 𠤘
    # 0x20919: '',  # 𠤙
    # 0x2091A: '',  # 𠤚
    # 0x2091B: '',  # 𠤛
    # 0x2091C: '',  # 𠤜
    0x2091D: 'mào',  # 𠤝
    # 0x2091E: '',  # 𠤞
    # 0x2091F: '',  # 𠤟
    # 0x20920: '',  # 𠤠
    # 0x20921: '',  # 𠤡
    # 0x20922: '',  # 𠤢
    # 0x20923: '',  # 𠤣
    # 0x20924: '',  # 𠤤
    # 0x20925: '',  # 𠤥
    0x20926: 'ruǎn,rú',  # 𠤦
    # 0x20927: '',  # 𠤧
    # 0x20928: '',  # 𠤨
    # 0x20929: '',  # 𠤩
    # 0x2092A: '',  # 𠤪
    0x2092B: 'cí',  # 𠤫
    # 0x2092C: '',  # 𠤬
    # 0x2092D: '',  # 𠤭
    0x2092E: 'hán',  # 𠤮
    # 0x2092F: '',  # 𠤯
    0x20930: 'cóng,xuán',  # 𠤰
    # 0x20931: '',  # 𠤱
    # 0x20932: '',  # 𠤲
    # 0x20933: '',  # 𠤳
    0x20934: 'xì',  # 𠤴
    # 0x20935: '',  # 𠤵
    # 0x20936: '',  # 𠤶
    # 0x20937: '',  # 𠤷
    # 0x20938: '',  # 𠤸
    0x20939: 'quán',  # 𠤹
    0x2093A: 'tiáo',  # 𠤺
    # 0x2093B: '',  # 𠤻
    0x2093C: 'diào',  # 𠤼
    # 0x2093D: '',  # 𠤽
    0x2093E: 'hán',  # 𠤾
    # 0x2093F: '',  # 𠤿
    # 0x20940: '',  # 𠥀
    # 0x20941: '',  # 𠥁
    # 0x20942: '',  # 𠥂
    # 0x20943: '',  # 𠥃
    # 0x20944: '',  # 𠥄
    # 0x20945: '',  # 𠥅
    # 0x20946: '',  # 𠥆
    0x20947: 'yě',  # 𠥇
    # 0x20948: '',  # 𠥈
    # 0x20949: '',  # 𠥉
    0x2094A: 'jī',  # 𠥊
    # 0x2094B: '',  # 𠥋
    # 0x2094C: '',  # 𠥌
    0x2094D: 'ē',  # 𠥍
    0x2094E: 'wéi',  # 𠥎
    # 0x2094F: '',  # 𠥏
    0x20950: 'cāng',  # 𠥐
    0x20951: 'diào',  # 𠥑
    # 0x20952: '',  # 𠥒
    0x20953: 'fāng',  # 𠥓
    # 0x20954: '',  # 𠥔
    0x20955: 'è',  # 𠥕
    0x20956: 'dì',  # 𠥖
    # 0x20957: '',  # 𠥗
    0x20958: 'suǎn',  # 𠥘
    0x20959: 'quán',  # 𠥙
    # 0x2095A: '',  # 𠥚
    # 0x2095B: '',  # 𠥛
    0x2095C: 'è',  # 𠥜
    0x2095D: 'ōu,ǒu',  # 𠥝
    0x2095E: 'xuán',  # 𠥞
    # 0x2095F: '',  # 𠥟
    # 0x20960: '',  # 𠥠
    # 0x20961: '',  # 𠥡
    0x20962: 'wǔ',  # 𠥢
    # 0x20963: '',  # 𠥣
    # 0x20964: '',  # 𠥤
    # 0x20965: '',  # 𠥥
    0x20966: 'yì',  # 𠥦
    0x20967: 'bēi',  # 𠥧
    0x20968: 'móu',  # 𠥨
    0x20969: 'jī',  # 𠥩
    0x2096A: 'tāo',  # 𠥪
    0x2096B: 'biān',  # 𠥫
    0x2096C: 'jiù',  # 𠥬
    # 0x2096D: '',  # 𠥭
    # 0x2096E: '',  # 𠥮
    # 0x2096F: '',  # 𠥯
    0x20970: 'hū',  # 𠥰
    # 0x20971: '',  # 𠥱
    # 0x20972: '',  # 𠥲
    # 0x20973: '',  # 𠥳
    0x20974: 'hán,gān',  # 𠥴
    # 0x20975: '',  # 𠥵
    # 0x20976: '',  # 𠥶
    # 0x20977: '',  # 𠥷
    # 0x20978: '',  # 𠥸
    # 0x20979: '',  # 𠥹
    # 0x2097A: '',  # 𠥺
    # 0x2097B: '',  # 𠥻
    # 0x2097C: '',  # 𠥼
    # 0x2097D: '',  # 𠥽
    # 0x2097E: '',  # 𠥾
    0x2097F: 'shí',  # 𠥿
    # 0x20980: '',  # 𠦀
    # 0x20981: '',  # 𠦁
    # 0x20982: '',  # 𠦂
    0x20983: 'sà',  # 𠦃
    # 0x20984: '',  # 𠦄
    # 0x20985: '',  # 𠦅
    # 0x20986: '',  # 𠦆
    # 0x20987: '',  # 𠦇
    0x20988: 'bì',  # 𠦈
    # 0x20989: '',  # 𠦉
    0x2098A: 'hán',  # 𠦊
    0x2098B: 'jìng',  # 𠦋
    # 0x2098C: '',  # 𠦌
    # 0x2098D: '',  # 𠦍
    0x2098E: 'qìn',  # 𠦎
    0x2098F: 'cuó',  # 𠦏
    0x20990: 'cì',  # 𠦐
    # 0x20991: '',  # 𠦑
    0x20992: 'bān',  # 𠦒
    # 0x20993: '',  # 𠦓
    # 0x20994: '',  # 𠦔
    # 0x20995: '',  # 𠦕
    # 0x20996: '',  # 𠦖
    0x20997: 'duī',  # 𠦗
    # 0x20998: '',  # 𠦘
    # 0x20999: '',  # 𠦙
    # 0x2099A: '',  # 𠦚
    # 0x2099B: '',  # 𠦛
    0x2099C: 'xì,shù',  # 𠦜
    # 0x2099D: '',  # 𠦝
    # 0x2099E: '',  # 𠦞
    # 0x2099F: '',  # 𠦟
    # 0x209A0: '',  # 𠦠
    0x209A1: 'xìng',  # 𠦡
    # 0x209A2: '',  # 𠦢
    # 0x209A3: '',  # 𠦣
    # 0x209A4: '',  # 𠦤
    # 0x209A5: '',  # 𠦥
    # 0x209A6: '',  # 𠦦
    0x209A7: 'zhī',  # 𠦧
    0x209A8: 'luàn',  # 𠦨
    # 0x209A9: '',  # 𠦩
    0x209AA: 'hū',  # 𠦪
    0x209AB: 'jí',  # 𠦫
    0x209AC: 'guāi',  # 𠦬
    # 0x209AD: '',  # 𠦭
    # 0x209AE: '',  # 𠦮
    # 0x209AF: '',  # 𠦯
    # 0x209B0: '',  # 𠦰
    # 0x209B1: '',  # 𠦱
    0x209B2: 'pāng',  # 𠦲
    # 0x209B3: '',  # 𠦳
    # 0x209B4: '',  # 𠦴
    # 0x209B5: '',  # 𠦵
    # 0x209B6: '',  # 𠦶
    # 0x209B7: '',  # 𠦷
    # 0x209B8: '',  # 𠦸
    # 0x209B9: '',  # 𠦹
    # 0x209BA: '',  # 𠦺
    # 0x209BB: '',  # 𠦻
    # 0x209BC: '',  # 𠦼
    # 0x209BD: '',  # 𠦽
    # 0x209BE: '',  # 𠦾
    # 0x209BF: '',  # 𠦿
    0x209C0: 'zhū',  # 𠧀
    # 0x209C1: '',  # 𠧁
    # 0x209C2: '',  # 𠧂
    # 0x209C3: '',  # 𠧃
    # 0x209C4: '',  # 𠧄
    0x209C5: 'bǐ',  # 𠧅
    # 0x209C6: '',  # 𠧆
    0x209C7: 'yú',  # 𠧇
    # 0x209C8: '',  # 𠧈
    # 0x209C9: '',  # 𠧉
    # 0x209CA: '',  # 𠧊
    # 0x209CB: '',  # 𠧋
    # 0x209CC: '',  # 𠧌
    # 0x209CD: '',  # 𠧍
    # 0x209CE: '',  # 𠧎
    # 0x209CF: '',  # 𠧏
    # 0x209D0: '',  # 𠧐
    # 0x209D1: '',  # 𠧑
    0x209D2: 'qǐ',  # 𠧒
    # 0x209D3: '',  # 𠧓
    # 0x209D4: '',  # 𠧔
    0x209D5: 'hé',  # 𠧕
    0x209D6: 'chǔ',  # 𠧖
    # 0x209D7: '',  # 𠧗
    # 0x209D8: '',  # 𠧘
    0x209D9: 'shào',  # 𠧙
    0x209DA: 'chì',  # 𠧚
    0x209DB: 'bó',  # 𠧛
    # 0x209DC: '',  # 𠧜
    # 0x209DD: '',  # 𠧝
    0x209DE: 'zhào',  # 𠧞
    0x209DF: 'réng,nǎi',  # 𠧟
    0x209E0: 'yóu',  # 𠧠
    # 0x209E1: '',  # 𠧡
    # 0x209E2: '',  # 𠧢
    # 0x209E3: '',  # 𠧣
    0x209E4: 'nǎi',  # 𠧤
    # 0x209E5: '',  # 𠧥
    # 0x209E6: '',  # 𠧦
    # 0x209E7: '',  # 𠧧
    # 0x209E8: '',  # 𠧨
    0x209E9: 'huǐ,huì',  # 𠧩
    0x209EA: 'tiáo,yǒu',  # 𠧪
    0x209EB: 'bǎn',  # 𠧫
    # 0x209EC: '',  # 𠧬
    # 0x209ED: '',  # 𠧭
    # 0x209EE: '',  # 𠧮
    # 0x209EF: '',  # 𠧯
    0x209F0: 'xū',  # 𠧰
    # 0x209F1: '',  # 𠧱
    # 0x209F2: '',  # 𠧲
    # 0x209F3: '',  # 𠧳
    0x209F4: 'yóu,yòu',  # 𠧴
    0x209F5: 'chì',  # 𠧵
    # 0x209F6: '',  # 𠧶
    # 0x209F7: '',  # 𠧷
    # 0x209F8: '',  # 𠧸
    # 0x209F9: '',  # 𠧹
    # 0x209FA: '',  # 𠧺
    # 0x209FB: '',  # 𠧻
    # 0x209FC: '',  # 𠧼
    # 0x209FD: '',  # 𠧽
    # 0x209FE: '',  # 𠧾
    0x209FF: 'héng',  # 𠧿
    # 0x20A00: '',  # 𠨀
    # 0x20A01: '',  # 𠨁
    # 0x20A02: '',  # 𠨂
    0x20A03: 'wài',  # 𠨃
    # 0x20A04: '',  # 𠨄
    # 0x20A05: '',  # 𠨅
    0x20A06: 'xiè',  # 𠨆
    # 0x20A07: '',  # 𠨇
    # 0x20A08: '',  # 𠨈
    # 0x20A09: '',  # 𠨉
    0x20A0A: 'jué',  # 𠨊
    # 0x20A0B: '',  # 𠨋
    0x20A0C: 'suī',  # 𠨌
    0x20A0D: 'qīng',  # 𠨍
    0x20A0E: 'zhuàn',  # 𠨎
    # 0x20A0F: '',  # 𠨏
    0x20A10: 'yǎng',  # 𠨐
    # 0x20A11: '',  # 𠨑
    0x20A12: 'bì',  # 𠨒
    # 0x20A13: '',  # 𠨓
    # 0x20A14: '',  # 𠨔
    0x20A15: 'jì',  # 𠨕
    # 0x20A16: '',  # 𠨖
    # 0x20A17: '',  # 𠨗
    0x20A18: 'bì',  # 𠨘
    # 0x20A19: '',  # 𠨙
    0x20A1A: 'xī',  # 𠨚
    # 0x20A1B: '',  # 𠨛
    # 0x20A1C: '',  # 𠨜
    # 0x20A1D: '',  # 𠨝
    # 0x20A1E: '',  # 𠨞
    # 0x20A1F: '',  # 𠨟
    0x20A20: 'jí',  # 𠨠
    # 0x20A21: '',  # 𠨡
    0x20A22: 'jùn',  # 𠨢
    # 0x20A23: '',  # 𠨣
    # 0x20A24: '',  # 𠨤
    0x20A25: 'liáo',  # 𠨥
    0x20A26: 'yōu',  # 𠨦
    # 0x20A27: '',  # 𠨧
    # 0x20A28: '',  # 𠨨
    # 0x20A29: '',  # 𠨩
    # 0x20A2A: '',  # 𠨪
    # 0x20A2B: '',  # 𠨫
    # 0x20A2C: '',  # 𠨬
    0x20A2D: 'jú',  # 𠨭
    # 0x20A2E: '',  # 𠨮
    # 0x20A2F: '',  # 𠨯
    # 0x20A30: '',  # 𠨰
    # 0x20A31: '',  # 𠨱
    0x20A32: 'yuè',  # 𠨲
    # 0x20A33: '',  # 𠨳
    # 0x20A34: '',  # 𠨴
    0x20A35: 'bàng',  # 𠨵
    # 0x20A36: '',  # 𠨶
    # 0x20A37: '',  # 𠨷
    0x20A38: 'pí',  # 𠨸
    # 0x20A39: '',  # 𠨹
    # 0x20A3A: '',  # 𠨺
    0x20A3B: 'zè',  # 𠨻
    # 0x20A3C: '',  # 𠨼
    # 0x20A3D: '',  # 𠨽
    0x20A3E: 'yì',  # 𠨾
    0x20A3F: 'dǐ',  # 𠨿
    0x20A40: 'jú',  # 𠩀
    # 0x20A41: '',  # 𠩁
    0x20A42: 'qiè',  # 𠩂
    # 0x20A43: '',  # 𠩃
    0x20A44: 'suǒ',  # 𠩄
    # 0x20A45: '',  # 𠩅
    0x20A46: 'cì',  # 𠩆
    # 0x20A47: '',  # 𠩇
    0x20A48: 'zhù',  # 𠩈
    0x20A49: 'yuè,jú',  # 𠩉
    # 0x20A4A: '',  # 𠩊
    # 0x20A4B: '',  # 𠩋
    # 0x20A4C: '',  # 𠩌
    # 0x20A4D: '',  # 𠩍
    # 0x20A4E: '',  # 𠩎
    0x20A4F: 'jiāo',  # 𠩏
    # 0x20A50: '',  # 𠩐
    # 0x20A51: '',  # 𠩑
    # 0x20A52: '',  # 𠩒
    # 0x20A53: '',  # 𠩓
    0x20A54: 'shí',  # 𠩔
    0x20A55: 'sī',  # 𠩕
    # 0x20A56: '',  # 𠩖
    0x20A57: 'yí',  # 𠩗
    0x20A58: 'xiá',  # 𠩘
    # 0x20A59: '',  # 𠩙
    # 0x20A5A: '',  # 𠩚
    # 0x20A5B: '',  # 𠩛
    # 0x20A5C: '',  # 𠩜
    # 0x20A5D: '',  # 𠩝
    # 0x20A5E: '',  # 𠩞
    # 0x20A5F: '',  # 𠩟
    0x20A60: 'yuán',  # 𠩠
    # 0x20A61: '',  # 𠩡
    # 0x20A62: '',  # 𠩢
    # 0x20A63: '',  # 𠩣
    # 0x20A64: '',  # 𠩤
    0x20A65: 'guó',  # 𠩥
    # 0x20A66: '',  # 𠩦
    0x20A67: 'kè',  # 𠩧
    # 0x20A68: '',  # 𠩨
    # 0x20A69: '',  # 𠩩
    0x20A6A: 'cuì',  # 𠩪
    0x20A6B: 'yì',  # 𠩫
    # 0x20A6C: '',  # 𠩬
    # 0x20A6D: '',  # 𠩭
    # 0x20A6E: '',  # 𠩮
    # 0x20A6F: '',  # 𠩯
    # 0x20A70: '',  # 𠩰
    # 0x20A71: '',  # 𠩱
    # 0x20A72: '',  # 𠩲
    # 0x20A73: '',  # 𠩳
    # 0x20A74: '',  # 𠩴
    0x20A75: 'lì',  # 𠩵
    # 0x20A76: '',  # 𠩶
    0x20A77: 'diǎn',  # 𠩷
    # 0x20A78: '',  # 𠩸
    # 0x20A79: '',  # 𠩹
    0x20A7A: 'xī,chí',  # 𠩺
    # 0x20A7B: '',  # 𠩻
    # 0x20A7C: '',  # 𠩼
    # 0x20A7D: '',  # 𠩽
    # 0x20A7E: '',  # 𠩾
    0x20A7F: 'bì',  # 𠩿
    # 0x20A80: '',  # 𠪀
    # 0x20A81: '',  # 𠪁
    0x20A82: 'biǎn',  # 𠪂
    0x20A83: 'méi',  # 𠪃
    0x20A84: 'lì',  # 𠪄
    # 0x20A85: '',  # 𠪅
    # 0x20A86: '',  # 𠪆
    0x20A87: 'sǒu',  # 𠪇
    # 0x20A88: '',  # 𠪈
    # 0x20A89: '',  # 𠪉
    # 0x20A8A: '',  # 𠪊
    # 0x20A8B: '',  # 𠪋
    # 0x20A8C: '',  # 𠪌
    # 0x20A8D: '',  # 𠪍
    # 0x20A8E: '',  # 𠪎
    # 0x20A8F: '',  # 𠪏
    0x20A90: 'liú',  # 𠪐
    0x20A91: 'guì',  # 𠪑
    0x20A92: 'kè',  # 𠪒
    # 0x20A93: '',  # 𠪓
    # 0x20A94: '',  # 𠪔
    # 0x20A95: '',  # 𠪕
    # 0x20A96: '',  # 𠪖
    0x20A97: 'yí',  # 𠪗
    0x20A98: 'yín,ǎn,kǎn',  # 𠪘
    0x20A99: 'xǐ',  # 𠪙
    0x20A9A: 'yín,ǎn,kǎn',  # 𠪚
    # 0x20A9B: '',  # 𠪛
    # 0x20A9C: '',  # 𠪜
    # 0x20A9D: '',  # 𠪝
    # 0x20A9E: '',  # 𠪞
    0x20A9F: 'kè',  # 𠪟
    # 0x20AA0: '',  # 𠪠
    # 0x20AA1: '',  # 𠪡
    0x20AA2: 'qīn',  # 𠪢
    0x20AA3: 'shè',  # 𠪣
    # 0x20AA4: '',  # 𠪤
    # 0x20AA5: '',  # 𠪥
    # 0x20AA6: '',  # 𠪦
    0x20AA7: 'wǒ',  # 𠪧
    # 0x20AA8: '',  # 𠪨
    # 0x20AA9: '',  # 𠪩
    # 0x20AAA: '',  # 𠪪
    # 0x20AAB: '',  # 𠪫
    # 0x20AAC: '',  # 𠪬
    # 0x20AAD: '',  # 𠪭
    0x20AAE: 'pì',  # 𠪮
    # 0x20AAF: '',  # 𠪯
    # 0x20AB0: '',  # 𠪰
    0x20AB1: 'lì',  # 𠪱
    0x20AB2: 'jǐn',  # 𠪲
    0x20AB3: 'hǔ',  # 𠪳
    # 0x20AB4: '',  # 𠪴
    # 0x20AB5: '',  # 𠪵
    0x20AB6: 'yuè',  # 𠪶
    0x20AB7: 'hóng',  # 𠪷
    # 0x20AB8: '',  # 𠪸
    # 0x20AB9: '',  # 𠪹
    0x20ABA: 'lì',  # 𠪺
    0x20ABB: 'fù',  # 𠪻
    # 0x20ABC: '',  # 𠪼
    # 0x20ABD: '',  # 𠪽
    # 0x20ABE: '',  # 𠪾
    # 0x20ABF: '',  # 𠪿
    # 0x20AC0: '',  # 𠫀
    # 0x20AC1: '',  # 𠫁
    # 0x20AC2: '',  # 𠫂
    0x20AC3: 'jué',  # 𠫃
    0x20AC4: 'xiān',  # 𠫄
    # 0x20AC5: '',  # 𠫅
    # 0x20AC6: '',  # 𠫆
    # 0x20AC7: '',  # 𠫇
    # 0x20AC8: '',  # 𠫈
    0x20AC9: 'diān',  # 𠫉
    # 0x20ACA: '',  # 𠫊
    # 0x20ACB: '',  # 𠫋
    0x20ACC: 'lì',  # 𠫌
    # 0x20ACD: '',  # 𠫍
    0x20ACE: 'chū',  # 𠫎
    # 0x20ACF: '',  # 𠫏
    0x20AD0: 'yuán',  # 𠫐
    # 0x20AD1: '',  # 𠫑
    0x20AD2: 'yuán',  # 𠫒
    0x20AD3: 'tū',  # 𠫓
    # 0x20AD4: '',  # 𠫔
    # 0x20AD5: '',  # 𠫕
    # 0x20AD6: '',  # 𠫖
    # 0x20AD7: '',  # 𠫗
    0x20AD8: 'jiān',  # 𠫘
    # 0x20AD9: '',  # 𠫙
    # 0x20ADA: '',  # 𠫚
    0x20ADB: 'bǎi',  # 𠫛
    0x20ADC: 'dì',  # 𠫜
    0x20ADD: 'zhǎng',  # 𠫝
    # 0x20ADE: '',  # 𠫞
    # 0x20ADF: '',  # 𠫟
    # 0x20AE0: '',  # 𠫠
    # 0x20AE1: '',  # 𠫡
    # 0x20AE2: '',  # 𠫢
    0x20AE3: 'yù',  # 𠫣
    0x20AE4: 'lìn',  # 𠫤
    # 0x20AE5: '',  # 𠫥
    # 0x20AE6: '',  # 𠫦
    # 0x20AE7: '',  # 𠫧
    0x20AE8: 'duì',  # 𠫨
    # 0x20AE9: '',  # 𠫩
    # 0x20AEA: '',  # 𠫪
    # 0x20AEB: '',  # 𠫫
    # 0x20AEC: '',  # 𠫬
    0x20AED: 'cān',  # 𠫭
    0x20AEE: 'tú',  # 𠫮
    # 0x20AEF: '',  # 𠫯
    # 0x20AF0: '',  # 𠫰
    # 0x20AF1: '',  # 𠫱
    # 0x20AF2: '',  # 𠫲
    # 0x20AF3: '',  # 𠫳
    # 0x20AF4: '',  # 𠫴
    0x20AF5: 'cān',  # 𠫵
    0x20AF6: 'tān',  # 𠫶
    0x20AF7: 'jí',  # 𠫷
    0x20AF8: 'qí,zhāi',  # 𠫸
    0x20AF9: 'shàn',  # 𠫹
    0x20AFA: 'nián,shì',  # 𠫺
    # 0x20AFB: '',  # 𠫻
    # 0x20AFC: '',  # 𠫼
    # 0x20AFD: '',  # 𠫽
    # 0x20AFE: '',  # 𠫾
    # 0x20AFF: '',  # 𠫿
    # 0x20B00: '',  # 𠬀
    # 0x20B01: '',  # 𠬁
    # 0x20B02: '',  # 𠬂
    # 0x20B03: '',  # 𠬃
    # 0x20B04: '',  # 𠬄
    # 0x20B05: '',  # 𠬅
    0x20B06: 'guàn',  # 𠬆
    # 0x20B07: '',  # 𠬇
    0x20B08: 'bǐ',  # 𠬈
    # 0x20B09: '',  # 𠬉
    # 0x20B0A: '',  # 𠬊
    0x20B0B: 'xīng,nián',  # 𠬋
    # 0x20B0C: '',  # 𠬌
    # 0x20B0D: '',  # 𠬍
    # 0x20B0E: '',  # 𠬎
    # 0x20B0F: '',  # 𠬏
    # 0x20B10: '',  # 𠬐
    # 0x20B11: '',  # 𠬑
    # 0x20B12: '',  # 𠬒
    0x20B13: 'zhěn',  # 𠬓
    # 0x20B14: '',  # 𠬔
    # 0x20B15: '',  # 𠬕
    # 0x20B16: '',  # 𠬖
    # 0x20B17: '',  # 𠬗
    # 0x20B18: '',  # 𠬘
    0x20B19: 'sā',  # 𠬙
    # 0x20B1A: '',  # 𠬚
    0x20B1B: 'mò',  # 𠬛
    0x20B1C: 'pān',  # 𠬜
    0x20B1D: 'fú',  # 𠬝
    0x20B1E: 'gǒng',  # 𠬞
    # 0x20B1F: '',  # 𠬟
    # 0x20B20: '',  # 𠬠
    # 0x20B21: '',  # 𠬡
    0x20B22: 'tāo',  # 𠬢
    0x20B23: 'bàng',  # 𠬣
    # 0x20B24: '',  # 𠬤
    # 0x20B25: '',  # 𠬥
    # 0x20B26: '',  # 𠬦
    # 0x20B27: '',  # 𠬧
    # 0x20B28: '',  # 𠬨
    # 0x20B29: '',  # 𠬩
    0x20B2A: 'biào',  # 𠬪
    # 0x20B2B: '',  # 𠬫
    0x20B2C: 'xī',  # 𠬬
    # 0x20B2D: '',  # 𠬭
    0x20B2E: 'jié',  # 𠬮
    # 0x20B2F: '',  # 𠬯
    # 0x20B30: '',  # 𠬰
    # 0x20B31: '',  # 𠬱
    # 0x20B32: '',  # 𠬲
    # 0x20B33: '',  # 𠬳
    # 0x20B34: '',  # 𠬴
    # 0x20B35: '',  # 𠬵
    0x20B36: 'jìn',  # 𠬶
    # 0x20B37: '',  # 𠬷
    0x20B38: 'mò',  # 𠬸
    # 0x20B39: '',  # 𠬹
    # 0x20B3A: '',  # 𠬺
    # 0x20B3B: '',  # 𠬻
    # 0x20B3C: '',  # 𠬼
    # 0x20B3D: '',  # 𠬽
    0x20B3E: 'qiān',  # 𠬾
    # 0x20B3F: '',  # 𠬿
    # 0x20B40: '',  # 𠭀
    # 0x20B41: '',  # 𠭁
    # 0x20B42: '',  # 𠭂
    # 0x20B43: '',  # 𠭃
    # 0x20B44: '',  # 𠭄
    # 0x20B45: '',  # 𠭅
    # 0x20B46: '',  # 𠭆
    # 0x20B47: '',  # 𠭇
    0x20B48: 'sì',  # 𠭈
    0x20B49: 'jǐng',  # 𠭉
    # 0x20B4A: '',  # 𠭊
    0x20B4B: 'chǐ',  # 𠭋
    # 0x20B4C: '',  # 𠭌
    # 0x20B4D: '',  # 𠭍
    # 0x20B4E: '',  # 𠭎
    # 0x20B4F: '',  # 𠭏
    # 0x20B50: '',  # 𠭐
    # 0x20B51: '',  # 𠭑
    # 0x20B52: '',  # 𠭒
    # 0x20B53: '',  # 𠭓
    # 0x20B54: '',  # 𠭔
    # 0x20B55: '',  # 𠭕
    0x20B56: 'gǎn',  # 𠭖
    0x20B57: 'jǐng',  # 𠭗
    0x20B58: 'jǐng',  # 𠭘
    0x20B59: 'shēn',  # 𠭙
    # 0x20B5A: '',  # 𠭚
    # 0x20B5B: '',  # 𠭛
    # 0x20B5C: '',  # 𠭜
    # 0x20B5D: '',  # 𠭝
    # 0x20B5E: '',  # 𠭞
    # 0x20B5F: '',  # 𠭟
    # 0x20B60: '',  # 𠭠
    # 0x20B61: '',  # 𠭡
    # 0x20B62: '',  # 𠭢
    # 0x20B63: '',  # 𠭣
    # 0x20B64: '',  # 𠭤
    0x20B65: 'suì',  # 𠭥
    # 0x20B66: '',  # 𠭦
    # 0x20B67: '',  # 𠭧
    # 0x20B68: '',  # 𠭨
    # 0x20B69: '',  # 𠭩
    # 0x20B6A: '',  # 𠭪
    # 0x20B6B: '',  # 𠭫
    # 0x20B6C: '',  # 𠭬
    # 0x20B6D: '',  # 𠭭
    # 0x20B6E: '',  # 𠭮
    0x20B6F: 'zhā',  # 𠭯
    0x20B70: 'lí',  # 𠭰
    # 0x20B71: '',  # 𠭱
    # 0x20B72: '',  # 𠭲
    # 0x20B73: '',  # 𠭳
    0x20B74: 'zhuō',  # 𠭴
    # 0x20B75: '',  # 𠭵
    # 0x20B76: '',  # 𠭶
    # 0x20B77: '',  # 𠭷
    # 0x20B78: '',  # 𠭸
    0x20B79: 'biàn',  # 𠭹
    # 0x20B7A: '',  # 𠭺
    # 0x20B7B: '',  # 𠭻
    # 0x20B7C: '',  # 𠭼
    # 0x20B7D: '',  # 𠭽
    # 0x20B7E: '',  # 𠭾
    0x20B7F: 'tún',  # 𠭿
    # 0x20B80: '',  # 𠮀
    # 0x20B81: '',  # 𠮁
    # 0x20B82: '',  # 𠮂
    0x20B83: 'bì',  # 𠮃
    # 0x20B84: '',  # 𠮄
    # 0x20B85: '',  # 𠮅
    0x20B86: 'fèi',  # 𠮆
    # 0x20B87: '',  # 𠮇
    # 0x20B88: '',  # 𠮈
    # 0x20B89: '',  # 𠮉
    0x20B8A: 'dé',  # 𠮊
    # 0x20B8B: '',  # 𠮋
    0x20B8C: 'zhú',  # 𠮌
    # 0x20B8D: '',  # 𠮍
    # 0x20B8E: '',  # 𠮎
    # 0x20B8F: '',  # 𠮏
    # 0x20B90: '',  # 𠮐
    0x20B91: 'jū',  # 𠮑
    # 0x20B92: '',  # 𠮒
    # 0x20B93: '',  # 𠮓
    # 0x20B94: '',  # 𠮔
    # 0x20B95: '',  # 𠮕
    # 0x20B96: '',  # 𠮖
    # 0x20B97: '',  # 𠮗
    # 0x20B98: '',  # 𠮘
    0x20B99: 'yǐ',  # 𠮙
    # 0x20B9A: '',  # 𠮚
    # 0x20B9B: '',  # 𠮛
    0x20B9C: 'yà,yīn',  # 𠮜
    # 0x20B9D: '',  # 𠮝
    # 0x20B9E: '',  # 𠮞
    0x20B9F: 'chì',  # 𠮟
    0x20BA0: 'guǎ,bǎi',  # 𠮠
    0x20BA1: 'zhǐ',  # 𠮡
    # 0x20BA2: '',  # 𠮢
    # 0x20BA3: '',  # 𠮣
    # 0x20BA4: '',  # 𠮤
    # 0x20BA5: '',  # 𠮥
    0x20BA6: 'zhào',  # 𠮦
    # 0x20BA7: '',  # 𠮧
    0x20BA8: 'réng',  # 𠮨
    # 0x20BA9: '',  # 𠮩
    # 0x20BAA: '',  # 𠮪
    0x20BAB: 'yōu',  # 𠮫
    # 0x20BAC: '',  # 𠮬
    0x20BAD: 'bó',  # 𠮭
    # 0x20BAE: '',  # 𠮮
    0x20BAF: 'jǐ',  # 𠮯
    0x20BB0: 'pǐn',  # 𠮰
    0x20BB1: 'xū',  # 𠮱
    # 0x20BB2: '',  # 𠮲
    0x20BB3: 'yīng',  # 𠮳
    0x20BB4: 'yāng',  # 𠮴
    0x20BB5: 'màng',  # 𠮵
    0x20BB6: 'gǎ,gě',  # 𠮶
    0x20BB7: 'jí',  # 𠮷
    # 0x20BB8: '',  # 𠮸
    0x20BB9: 'cái',  # 𠮹
    # 0x20BBA: '',  # 𠮺
    # 0x20BBB: '',  # 𠮻
    # 0x20BBC: '',  # 𠮼
    0x20BBD: 'lòng',  # 𠮽
    0x20BBE: 'ǹ',  # 𠮾
    0x20BBF: 'sa,san',  # 𠮿
    0x20BC0: 'chuān',  # 𠯀
    0x20BC1: 'zú',  # 𠯁
    0x20BC2: 'cí',  # 𠯂
    0x20BC3: 'wǔ',  # 𠯃
    0x20BC4: 'rèn',  # 𠯄
    # 0x20BC5: '',  # 𠯅
    # 0x20BC6: '',  # 𠯆
    # 0x20BC7: '',  # 𠯇
    0x20BC8: 'dài',  # 𠯈
    0x20BC9: 'jí',  # 𠯉
    # 0x20BCA: '',  # 𠯊
    0x20BCB: 'yǐ',  # 𠯋
    # 0x20BCC: '',  # 𠯌
    0x20BCD: 'rán',  # 𠯍
    # 0x20BCE: '',  # 𠯎
    # 0x20BCF: '',  # 𠯏
    0x20BD0: 'huò',  # 𠯐
    0x20BD1: 'guā',  # 𠯑
    # 0x20BD2: '',  # 𠯒
    0x20BD3: 'zhé',  # 𠯓
    0x20BD4: 'pì',  # 𠯔
    # 0x20BD5: '',  # 𠯕
    # 0x20BD6: '',  # 𠯖
    0x20BD7: 'zā',  # 𠯗
    0x20BD8: 'bàn',  # 𠯘
    0x20BD9: 'jié',  # 𠯙
    # 0x20BDA: '',  # 𠯚
    # 0x20BDB: '',  # 𠯛
    0x20BDC: 'hōu,xǔ',  # 𠯜
    # 0x20BDD: '',  # 𠯝
    # 0x20BDE: '',  # 𠯞
    0x20BDF: 'xiàn',  # 𠯟
    0x20BE0: 'huī',  # 𠯠
    # 0x20BE1: '',  # 𠯡
    # 0x20BE2: '',  # 𠯢
    0x20BE3: 'zú',  # 𠯣
    # 0x20BE4: '',  # 𠯤
    # 0x20BE5: '',  # 𠯥
    # 0x20BE6: '',  # 𠯦
    # 0x20BE7: '',  # 𠯧
    # 0x20BE8: '',  # 𠯨
    0x20BE9: 'zhā',  # 𠯩
    0x20BEA: 'dāi,dǎi,è',  # 𠯪
    0x20BEB: 'gē',  # 𠯫
    # 0x20BEC: '',  # 𠯬
    0x20BED: 'pì',  # 𠯭
    # 0x20BEE: '',  # 𠯮
    0x20BEF: 'piàn',  # 𠯯
    0x20BF0: 'shí',  # 𠯰
    0x20BF1: 'liǎng',  # 𠯱
    0x20BF2: 'yuè',  # 𠯲
    0x20BF3: 'hù,wěn',  # 𠯳
    0x20BF4: 'biàn',  # 𠯴
    # 0x20BF5: '',  # 𠯵
    # 0x20BF6: '',  # 𠯶
    0x20BF7: 'réng',  # 𠯷
    0x20BF8: 'tīng',  # 𠯸
    0x20BF9: 'réng',  # 𠯹
    # 0x20BFA: '',  # 𠯺
    # 0x20BFB: '',  # 𠯻
    # 0x20BFC: '',  # 𠯼
    # 0x20BFD: '',  # 𠯽
    # 0x20BFE: '',  # 𠯾
    0x20BFF: 'lù,liū',  # 𠯿
    # 0x20C00: '',  # 𠰀
    # 0x20C01: '',  # 𠰁
    # 0x20C02: '',  # 𠰂
    # 0x20C03: '',  # 𠰃
    0x20C04: 'yī',  # 𠰄
    0x20C05: 'zhī',  # 𠰅
    # 0x20C06: '',  # 𠰆
    0x20C07: 'jīn',  # 𠰇
    0x20C08: 'wēng',  # 𠰈
    0x20C09: 'chāo',  # 𠰉
    # 0x20C0A: '',  # 𠰊
    0x20C0B: 'qiū',  # 𠰋
    # 0x20C0C: '',  # 𠰌
    0x20C0D: 'zhǔ,zhù',  # 𠰍
    # 0x20C0E: '',  # 𠰎
    0x20C0F: 'zhá',  # 𠰏
    0x20C10: 'pǒ',  # 𠰐
    0x20C11: 'àn',  # 𠰑
    # 0x20C12: '',  # 𠰒
    0x20C13: 'hé',  # 𠰓
    # 0x20C14: '',  # 𠰔
    0x20C15: 'chū',  # 𠰕
    0x20C16: 'yán',  # 𠰖
    # 0x20C17: '',  # 𠰗
    # 0x20C18: '',  # 𠰘
    # 0x20C19: '',  # 𠰙
    0x20C1A: 'shì',  # 𠰚
    0x20C1B: 'hù,gào',  # 𠰛
    0x20C1C: 'è',  # 𠰜
    # 0x20C1D: '',  # 𠰝
    # 0x20C1E: '',  # 𠰞
    # 0x20C1F: '',  # 𠰟
    # 0x20C20: '',  # 𠰠
    # 0x20C21: '',  # 𠰡
    0x20C22: 'bā',  # 𠰢
    # 0x20C23: '',  # 𠰣
    # 0x20C24: '',  # 𠰤
    # 0x20C25: '',  # 𠰥
    # 0x20C26: '',  # 𠰦
    # 0x20C27: '',  # 𠰧
    # 0x20C28: '',  # 𠰨
    # 0x20C29: '',  # 𠰩
    # 0x20C2A: '',  # 𠰪
    # 0x20C2B: '',  # 𠰫
    # 0x20C2C: '',  # 𠰬
    # 0x20C2D: '',  # 𠰭
    # 0x20C2E: '',  # 𠰮
    # 0x20C2F: '',  # 𠰯
    # 0x20C30: '',  # 𠰰
    # 0x20C31: '',  # 𠰱
    # 0x20C32: '',  # 𠰲
    0x20C33: 'bǐng',  # 𠰳
    0x20C34: 'shí',  # 𠰴
    # 0x20C35: '',  # 𠰵
    # 0x20C36: '',  # 𠰶
    # 0x20C37: '',  # 𠰷
    # 0x20C38: '',  # 𠰸
    0x20C39: 'tuō',  # 𠰹
    0x20C3A: 'dài',  # 𠰺
    0x20C3B: 'wài,wai',  # 𠰻
    0x20C3C: 'pō',  # 𠰼
    0x20C3D: 'rǒng',  # 𠰽
    0x20C3E: 'jū',  # 𠰾
    # 0x20C3F: '',  # 𠰿
    0x20C40: 'bō',  # 𠱀
    # 0x20C41: '',  # 𠱁
    # 0x20C42: '',  # 𠱂
    0x20C43: 'āo',  # 𠱃
    # 0x20C44: '',  # 𠱄
    # 0x20C45: '',  # 𠱅
    # 0x20C46: '',  # 𠱆
    # 0x20C47: '',  # 𠱇
    # 0x20C48: '',  # 𠱈
    # 0x20C49: '',  # 𠱉
    # 0x20C4A: '',  # 𠱊
    # 0x20C4B: '',  # 𠱋
    # 0x20C4C: '',  # 𠱌
    # 0x20C4D: '',  # 𠱍
    # 0x20C4E: '',  # 𠱎
    # 0x20C4F: '',  # 𠱏
    0x20C50: 'yǔ',  # 𠱐
    0x20C51: 'dōu',  # 𠱑
    # 0x20C52: '',  # 𠱒
    0x20C53: 'guǐ',  # 𠱓
    0x20C54: 'shòu',  # 𠱔
    # 0x20C55: '',  # 𠱕
    # 0x20C56: '',  # 𠱖
    0x20C57: 'suō',  # 𠱗
    0x20C58: 'nì',  # 𠱘
    0x20C59: 'zhōu,yù,jì,cù',  # 𠱙
    0x20C5A: 'lòng',  # 𠱚
    0x20C5B: 'bǐng',  # 𠱛
    0x20C5C: 'zùn',  # 𠱜
    0x20C5D: 'yè',  # 𠱝
    0x20C5E: 'rǎn',  # 𠱞
    # 0x20C5F: '',  # 𠱟
    0x20C60: 'líng',  # 𠱠
    0x20C61: 'sà,shài',  # 𠱡
    # 0x20C62: '',  # 𠱢
    # 0x20C63: '',  # 𠱣
    0x20C64: 'lěi',  # 𠱤
    0x20C65: 'è,huì,zá',  # 𠱥
    # 0x20C66: '',  # 𠱦
    0x20C67: 'zhòng',  # 𠱧
    0x20C68: 'jǐ',  # 𠱨
    # 0x20C69: '',  # 𠱩
    # 0x20C6A: '',  # 𠱪
    0x20C6B: 'è',  # 𠱫
    # 0x20C6C: '',  # 𠱬
    # 0x20C6D: '',  # 𠱭
    # 0x20C6E: '',  # 𠱮
    0x20C6F: 'zuò',  # 𠱯
    # 0x20C70: '',  # 𠱰
    # 0x20C71: '',  # 𠱱
    0x20C72: 'nà',  # 𠱲
    0x20C73: 'yǔn',  # 𠱳
    # 0x20C74: '',  # 𠱴
    # 0x20C75: '',  # 𠱵
    # 0x20C76: '',  # 𠱶
    # 0x20C77: '',  # 𠱷
    # 0x20C78: '',  # 𠱸
    # 0x20C79: '',  # 𠱹
    # 0x20C7A: '',  # 𠱺
    # 0x20C7B: '',  # 𠱻
    # 0x20C7C: '',  # 𠱼
    # 0x20C7D: '',  # 𠱽
    # 0x20C7E: '',  # 𠱾
    # 0x20C7F: '',  # 𠱿
    # 0x20C80: '',  # 𠲀
    # 0x20C81: '',  # 𠲁
    # 0x20C82: '',  # 𠲂
    # 0x20C83: '',  # 𠲃
    # 0x20C84: '',  # 𠲄
    # 0x20C85: '',  # 𠲅
    # 0x20C86: '',  # 𠲆
    # 0x20C87: '',  # 𠲇
    # 0x20C88: '',  # 𠲈
    # 0x20C89: '',  # 𠲉
    0x20C8A: 'xiè',  # 𠲊
    0x20C8B: 'zuǐ',  # 𠲋
    0x20C8C: 'shù',  # 𠲌
    0x20C8D: 'diū',  # 𠲍
    0x20C8E: 'fèi,fá,wa',  # 𠲎
    0x20C8F: 'rěn',  # 𠲏
    # 0x20C90: '',  # 𠲐
    0x20C91: 'bāng',  # 𠲑
    0x20C92: 'hán',  # 𠲒
    0x20C93: 'hóng',  # 𠲓
    0x20C94: 'yī',  # 𠲔
    # 0x20C95: '',  # 𠲕
    0x20C96: 'yī',  # 𠲖
    # 0x20C97: '',  # 𠲗
    # 0x20C98: '',  # 𠲘
    0x20C99: 'kē',  # 𠲙
    0x20C9A: 'yì',  # 𠲚
    0x20C9B: 'huí',  # 𠲛
    0x20C9C: 'zhēng',  # 𠲜
    # 0x20C9D: '',  # 𠲝
    # 0x20C9E: '',  # 𠲞
    # 0x20C9F: '',  # 𠲟
    # 0x20CA0: '',  # 𠲠
    # 0x20CA1: '',  # 𠲡
    # 0x20CA2: '',  # 𠲢
    # 0x20CA3: '',  # 𠲣
    # 0x20CA4: '',  # 𠲤
    0x20CA5: 'lǐ',  # 𠲥
    # 0x20CA6: '',  # 𠲦
    # 0x20CA7: '',  # 𠲧
    # 0x20CA8: '',  # 𠲨
    # 0x20CA9: '',  # 𠲩
    # 0x20CAA: '',  # 𠲪
    # 0x20CAB: '',  # 𠲫
    # 0x20CAC: '',  # 𠲬
    # 0x20CAD: '',  # 𠲭
    0x20CAE: 'jìng',  # 𠲮
    # 0x20CAF: '',  # 𠲯
    # 0x20CB0: '',  # 𠲰
    0x20CB1: 'gé',  # 𠲱
    # 0x20CB2: '',  # 𠲲
    # 0x20CB3: '',  # 𠲳
    0x20CB4: 'nóu',  # 𠲴
    0x20CB5: 'qiè,jié',  # 𠲵
    # 0x20CB6: '',  # 𠲶
    0x20CB7: 'dié',  # 𠲷
    # 0x20CB8: '',  # 𠲸
    0x20CB9: 'jì',  # 𠲹
    0x20CBA: 'yì',  # 𠲺
    0x20CBB: 'yí',  # 𠲻
    # 0x20CBC: '',  # 𠲼
    0x20CBD: 'fú',  # 𠲽
    0x20CBE: 'shuò',  # 𠲾
    0x20CBF: 'shuò',  # 𠲿
    0x20CC0: 'yǒng',  # 𠳀
    0x20CC1: 'kěn',  # 𠳁
    0x20CC2: 'huá',  # 𠳂
    0x20CC3: 'hòng',  # 𠳃
    # 0x20CC4: '',  # 𠳄
    # 0x20CC5: '',  # 𠳅
    0x20CC6: 'zāi',  # 𠳆
    0x20CC7: 'hé',  # 𠳇
    # 0x20CC8: '',  # 𠳈
    # 0x20CC9: '',  # 𠳉
    0x20CCA: 'hē',  # 𠳊
    0x20CCB: 'qiǎn',  # 𠳋
    0x20CCC: 'qià',  # 𠳌
    # 0x20CCD: '',  # 𠳍
    0x20CCE: 'sì',  # 𠳎
    # 0x20CCF: '',  # 𠳏
    0x20CD0: 'bāng',  # 𠳐
    # 0x20CD1: '',  # 𠳑
    # 0x20CD2: '',  # 𠳒
    # 0x20CD3: '',  # 𠳓
    # 0x20CD4: '',  # 𠳔
    # 0x20CD5: '',  # 𠳕
    # 0x20CD6: '',  # 𠳖
    # 0x20CD7: '',  # 𠳗
    # 0x20CD8: '',  # 𠳘
    # 0x20CD9: '',  # 𠳙
    # 0x20CDA: '',  # 𠳚
    # 0x20CDB: '',  # 𠳛
    # 0x20CDC: '',  # 𠳜
    # 0x20CDD: '',  # 𠳝
    # 0x20CDE: '',  # 𠳞
    # 0x20CDF: '',  # 𠳟
    # 0x20CE0: '',  # 𠳠
    # 0x20CE1: '',  # 𠳡
    # 0x20CE2: '',  # 𠳢
    # 0x20CE3: '',  # 𠳣
    # 0x20CE4: '',  # 𠳤
    # 0x20CE5: '',  # 𠳥
    # 0x20CE6: '',  # 𠳦
    # 0x20CE7: '',  # 𠳧
    # 0x20CE8: '',  # 𠳨
    # 0x20CE9: '',  # 𠳩
    # 0x20CEA: '',  # 𠳪
    # 0x20CEB: '',  # 𠳫
    0x20CEC: 'jīng',  # 𠳬
    0x20CED: 'kè',  # 𠳭
    # 0x20CEE: '',  # 𠳮
    # 0x20CEF: '',  # 𠳯
    # 0x20CF0: '',  # 𠳰
    # 0x20CF1: '',  # 𠳱
    # 0x20CF2: '',  # 𠳲
    0x20CF3: 'āi',  # 𠳳
    0x20CF4: 'lóu',  # 𠳴
    # 0x20CF5: '',  # 𠳵
    0x20CF6: 'tū',  # 𠳶
    # 0x20CF7: '',  # 𠳷
    # 0x20CF8: '',  # 𠳸
    0x20CF9: 'chuáng',  # 𠳹
    # 0x20CFA: '',  # 𠳺
    # 0x20CFB: '',  # 𠳻
    0x20CFC: 'sòng',  # 𠳼
    0x20CFD: 'chéng',  # 𠳽
    0x20CFE: 'hǎn',  # 𠳾
    0x20CFF: 'wēi',  # 𠳿
    # 0x20D00: '',  # 𠴀
    # 0x20D01: '',  # 𠴁
    0x20D02: 'nǔ',  # 𠴂
    # 0x20D03: '',  # 𠴃
    0x20D04: 'jiǔ',  # 𠴄
    # 0x20D05: '',  # 𠴅
    # 0x20D06: '',  # 𠴆
    0x20D07: 'bīn',  # 𠴇
    # 0x20D08: '',  # 𠴈
    # 0x20D09: '',  # 𠴉
    # 0x20D0A: '',  # 𠴊
    # 0x20D0B: '',  # 𠴋
    # 0x20D0C: '',  # 𠴌
    # 0x20D0D: '',  # 𠴍
    # 0x20D0E: '',  # 𠴎
    # 0x20D0F: '',  # 𠴏
    # 0x20D10: '',  # 𠴐
    # 0x20D11: '',  # 𠴑
    # 0x20D12: '',  # 𠴒
    # 0x20D13: '',  # 𠴓
    # 0x20D14: '',  # 𠴔
    # 0x20D15: '',  # 𠴕
    # 0x20D16: '',  # 𠴖
    # 0x20D17: '',  # 𠴗
    # 0x20D18: '',  # 𠴘
    # 0x20D19: '',  # 𠴙
    # 0x20D1A: '',  # 𠴚
    # 0x20D1B: '',  # 𠴛
    # 0x20D1C: '',  # 𠴜
    # 0x20D1D: '',  # 𠴝
    # 0x20D1E: '',  # 𠴞
    # 0x20D1F: '',  # 𠴟
    # 0x20D20: '',  # 𠴠
    0x20D21: 'xiào',  # 𠴡
    0x20D22: 'shēng',  # 𠴢
    0x20D23: 'hǒu',  # 𠴣
    # 0x20D24: '',  # 𠴤
    # 0x20D25: '',  # 𠴥
    0x20D26: 'zhù',  # 𠴦
    # 0x20D27: '',  # 𠴧
    0x20D28: 'guān',  # 𠴨
    0x20D29: 'jī,qǐ',  # 𠴩
    # 0x20D2A: '',  # 𠴪
    0x20D2B: 'jì,cù,yù,zhù',  # 𠴫
    # 0x20D2C: '',  # 𠴬
    0x20D2D: 'xī',  # 𠴭
    # 0x20D2E: '',  # 𠴮
    0x20D2F: 'shè',  # 𠴯
    0x20D30: 'ǒu',  # 𠴰
    0x20D31: 'hú',  # 𠴱
    0x20D32: 'tà',  # 𠴲
    0x20D33: 'xiáo',  # 𠴳
    # 0x20D34: '',  # 𠴴
    0x20D35: 'zào',  # 𠴵
    # 0x20D36: '',  # 𠴶
    # 0x20D37: '',  # 𠴷
    0x20D38: 'bò',  # 𠴸
    0x20D39: 'qì',  # 𠴹
    0x20D3A: 'wā',  # 𠴺
    0x20D3B: 'tuō',  # 𠴻
    0x20D3C: 'dào',  # 𠴼
    # 0x20D3D: '',  # 𠴽
    0x20D3E: 'nà',  # 𠴾
    # 0x20D3F: '',  # 𠴿
    # 0x20D40: '',  # 𠵀
    # 0x20D41: '',  # 𠵁
    # 0x20D42: '',  # 𠵂
    # 0x20D43: '',  # 𠵃
    # 0x20D44: '',  # 𠵄
    # 0x20D45: '',  # 𠵅
    # 0x20D46: '',  # 𠵆
    # 0x20D47: '',  # 𠵇
    # 0x20D48: '',  # 𠵈
    # 0x20D49: '',  # 𠵉
    # 0x20D4A: '',  # 𠵊
    # 0x20D4B: '',  # 𠵋
    # 0x20D4C: '',  # 𠵌
    # 0x20D4D: '',  # 𠵍
    # 0x20D4E: '',  # 𠵎
    # 0x20D4F: '',  # 𠵏
    # 0x20D50: '',  # 𠵐
    # 0x20D51: '',  # 𠵑
    # 0x20D52: '',  # 𠵒
    0x20D53: 'xuán',  # 𠵓
    # 0x20D54: '',  # 𠵔
    # 0x20D55: '',  # 𠵕
    # 0x20D56: '',  # 𠵖
    # 0x20D57: '',  # 𠵗
    0x20D58: 'mèn',  # 𠵘
    # 0x20D59: '',  # 𠵙
    # 0x20D5A: '',  # 𠵚
    # 0x20D5B: '',  # 𠵛
    # 0x20D5C: '',  # 𠵜
    # 0x20D5D: '',  # 𠵝
    # 0x20D5E: '',  # 𠵞
    # 0x20D5F: '',  # 𠵟
    0x20D60: 'zhāi',  # 𠵠
    # 0x20D61: '',  # 𠵡
    # 0x20D62: '',  # 𠵢
    0x20D63: 'yà',  # 𠵣
    # 0x20D64: '',  # 𠵤
    # 0x20D65: '',  # 𠵥
    0x20D66: 'wǔ',  # 𠵦
    0x20D67: 'zhén,chún',  # 𠵧
    0x20D68: 'de',  # 𠵨
    0x20D69: 'hē',  # 𠵩
    # 0x20D6A: '',  # 𠵪
    0x20D6B: 'āng',  # 𠵫
    0x20D6C: 'pí',  # 𠵬
    0x20D6D: 'sè',  # 𠵭
    0x20D6E: 'fěn',  # 𠵮
    0x20D6F: 'guā',  # 𠵯
    # 0x20D70: '',  # 𠵰
    # 0x20D71: '',  # 𠵱
    # 0x20D72: '',  # 𠵲
    0x20D73: 'pǒ',  # 𠵳
    # 0x20D74: '',  # 𠵴
    # 0x20D75: '',  # 𠵵
    # 0x20D76: '',  # 𠵶
    0x20D77: 'xuàn',  # 𠵷
    0x20D78: 'hān,mí',  # 𠵸
    0x20D79: 'gāng',  # 𠵹
    0x20D7A: 'bā',  # 𠵺
    0x20D7B: 'zōng',  # 𠵻
    0x20D7C: 'mèng',  # 𠵼
    # 0x20D7D: '',  # 𠵽
    # 0x20D7E: '',  # 𠵾
    # 0x20D7F: '',  # 𠵿
    # 0x20D80: '',  # 𠶀
    # 0x20D81: '',  # 𠶁
    # 0x20D82: '',  # 𠶂
    # 0x20D83: '',  # 𠶃
    # 0x20D84: '',  # 𠶄
    # 0x20D85: '',  # 𠶅
    # 0x20D86: '',  # 𠶆
    # 0x20D87: '',  # 𠶇
    # 0x20D88: '',  # 𠶈
    # 0x20D89: '',  # 𠶉
    # 0x20D8A: '',  # 𠶊
    # 0x20D8B: '',  # 𠶋
    # 0x20D8C: '',  # 𠶌
    # 0x20D8D: '',  # 𠶍
    # 0x20D8E: '',  # 𠶎
    # 0x20D8F: '',  # 𠶏
    # 0x20D90: '',  # 𠶐
    # 0x20D91: '',  # 𠶑
    # 0x20D92: '',  # 𠶒
    # 0x20D93: '',  # 𠶓
    # 0x20D94: '',  # 𠶔
    # 0x20D95: '',  # 𠶕
    # 0x20D96: '',  # 𠶖
    # 0x20D97: '',  # 𠶗
    # 0x20D98: '',  # 𠶘
    # 0x20D99: '',  # 𠶙
    # 0x20D9A: '',  # 𠶚
    # 0x20D9B: '',  # 𠶛
    0x20D9C: 'zhì',  # 𠶜
    # 0x20D9D: '',  # 𠶝
    # 0x20D9E: '',  # 𠶞
    # 0x20D9F: '',  # 𠶟
    # 0x20DA0: '',  # 𠶠
    # 0x20DA1: '',  # 𠶡
    # 0x20DA2: '',  # 𠶢
    # 0x20DA3: '',  # 𠶣
    # 0x20DA4: '',  # 𠶤
    # 0x20DA5: '',  # 𠶥
    # 0x20DA6: '',  # 𠶦
    0x20DA7: 'diān',  # 𠶧
    0x20DA8: 'xī',  # 𠶨
    # 0x20DA9: '',  # 𠶩
    # 0x20DAA: '',  # 𠶪
    0x20DAB: 'dà',  # 𠶫
    0x20DAC: 'nàng',  # 𠶬
    # 0x20DAD: '',  # 𠶭
    # 0x20DAE: '',  # 𠶮
    # 0x20DAF: '',  # 𠶯
    0x20DB0: 'diāo',  # 𠶰
    0x20DB1: 'luò',  # 𠶱
    0x20DB2: 'kè',  # 𠶲
    # 0x20DB3: '',  # 𠶳
    # 0x20DB4: '',  # 𠶴
    # 0x20DB5: '',  # 𠶵
    # 0x20DB6: '',  # 𠶶
    0x20DB7: 'yì',  # 𠶷
    0x20DB8: 'jué',  # 𠶸
    0x20DB9: 'hé',  # 𠶹
    # 0x20DBA: '',  # 𠶺
    0x20DBB: 'jí',  # 𠶻
    # 0x20DBC: '',  # 𠶼
    # 0x20DBD: '',  # 𠶽
    0x20DBE: 'hè',  # 𠶾
    0x20DBF: 'niè,zá',  # 𠶿
    0x20DC0: 'rǔn',  # 𠷀
    0x20DC1: 'qián,jiān',  # 𠷁
    0x20DC2: 'dài',  # 𠷂
    0x20DC3: 'shāo,sù,shòu',  # 𠷃
    0x20DC4: 'kè',  # 𠷄
    0x20DC5: 'zhú',  # 𠷅
    # 0x20DC6: '',  # 𠷆
    0x20DC7: 'shī',  # 𠷇
    0x20DC8: 'lǜ,liè',  # 𠷈
    0x20DC9: 'jiā',  # 𠷉
    0x20DCA: 'pián',  # 𠷊
    0x20DCB: 'hòu',  # 𠷋
    0x20DCC: 'jī,zé',  # 𠷌
    0x20DCD: 'tà',  # 𠷍
    0x20DCE: 'chóu,shòu',  # 𠷎
    0x20DCF: 'wō',  # 𠷏
    0x20DD0: 'jìng,jiàng',  # 𠷐
    0x20DD1: 'pō',  # 𠷑
    0x20DD2: 'zhāi',  # 𠷒
    0x20DD3: 'xīn',  # 𠷓
    # 0x20DD4: '',  # 𠷔
    # 0x20DD5: '',  # 𠷕
    0x20DD6: 'biàn',  # 𠷖
    # 0x20DD7: '',  # 𠷗
    # 0x20DD8: '',  # 𠷘
    0x20DD9: 'xù',  # 𠷙
    # 0x20DDA: '',  # 𠷚
    # 0x20DDB: '',  # 𠷛
    # 0x20DDC: '',  # 𠷜
    # 0x20DDD: '',  # 𠷝
    0x20DDE: 'gū',  # 𠷞
    0x20DDF: 'jiè',  # 𠷟
    0x20DE0: 'qǐ',  # 𠷠
    # 0x20DE1: '',  # 𠷡
    0x20DE2: 'xián',  # 𠷢
    # 0x20DE3: '',  # 𠷣
    # 0x20DE4: '',  # 𠷤
    # 0x20DE5: '',  # 𠷥
    # 0x20DE6: '',  # 𠷦
    # 0x20DE7: '',  # 𠷧
    0x20DE8: 'biǎn',  # 𠷨
    # 0x20DE9: '',  # 𠷩
    # 0x20DEA: '',  # 𠷪
    # 0x20DEB: '',  # 𠷫
    # 0x20DEC: '',  # 𠷬
    # 0x20DED: '',  # 𠷭
    # 0x20DEE: '',  # 𠷮
    # 0x20DEF: '',  # 𠷯
    # 0x20DF0: '',  # 𠷰
    # 0x20DF1: '',  # 𠷱
    # 0x20DF2: '',  # 𠷲
    # 0x20DF3: '',  # 𠷳
    # 0x20DF4: '',  # 𠷴
    # 0x20DF5: '',  # 𠷵
    # 0x20DF6: '',  # 𠷶
    # 0x20DF7: '',  # 𠷷
    0x20DF8: 'é,yóng',  # 𠷸
    # 0x20DF9: '',  # 𠷹
    0x20DFA: 'bó',  # 𠷺
    0x20DFB: 'piāo',  # 𠷻
    # 0x20DFC: '',  # 𠷼
    # 0x20DFD: '',  # 𠷽
    # 0x20DFE: '',  # 𠷾
    0x20DFF: 'zǎ',  # 𠷿
    # 0x20E00: '',  # 𠸀
    0x20E01: 'pài',  # 𠸁
    0x20E02: 'tū',  # 𠸂
    # 0x20E03: '',  # 𠸃
    0x20E04: 'yīng',  # 𠸄
    # 0x20E05: '',  # 𠸅
    # 0x20E06: '',  # 𠸆
    # 0x20E07: '',  # 𠸇
    # 0x20E08: '',  # 𠸈
    # 0x20E09: '',  # 𠸉
    # 0x20E0A: '',  # 𠸊
    # 0x20E0B: '',  # 𠸋
    # 0x20E0C: '',  # 𠸌
    0x20E0D: 'xiào',  # 𠸍
    # 0x20E0E: '',  # 𠸎
    # 0x20E0F: '',  # 𠸏
    # 0x20E10: '',  # 𠸐
    # 0x20E11: '',  # 𠸑
    # 0x20E12: '',  # 𠸒
    # 0x20E13: '',  # 𠸓
    # 0x20E14: '',  # 𠸔
    # 0x20E15: '',  # 𠸕
    # 0x20E16: '',  # 𠸖
    # 0x20E17: '',  # 𠸗
    # 0x20E18: '',  # 𠸘
    # 0x20E19: '',  # 𠸙
    # 0x20E1A: '',  # 𠸚
    # 0x20E1B: '',  # 𠸛
    # 0x20E1C: '',  # 𠸜
    # 0x20E1D: '',  # 𠸝
    # 0x20E1E: '',  # 𠸞
    # 0x20E1F: '',  # 𠸟
    # 0x20E20: '',  # 𠸠
    # 0x20E21: '',  # 𠸡
    # 0x20E22: '',  # 𠸢
    # 0x20E23: '',  # 𠸣
    # 0x20E24: '',  # 𠸤
    # 0x20E25: '',  # 𠸥
    # 0x20E26: '',  # 𠸦
    # 0x20E27: '',  # 𠸧
    # 0x20E28: '',  # 𠸨
    # 0x20E29: '',  # 𠸩
    # 0x20E2A: '',  # 𠸪
    # 0x20E2B: '',  # 𠸫
    # 0x20E2C: '',  # 𠸬
    # 0x20E2D: '',  # 𠸭
    0x20E2E: 'xiǎng',  # 𠸮
    # 0x20E2F: '',  # 𠸯
    # 0x20E30: '',  # 𠸰
    0x20E31: 'nuò',  # 𠸱
    0x20E32: 'gē',  # 𠸲
    0x20E33: 'bó',  # 𠸳
    0x20E34: 'xiè',  # 𠸴
    # 0x20E35: '',  # 𠸵
    # 0x20E36: '',  # 𠸶
    # 0x20E37: '',  # 𠸷
    0x20E38: 'zhēn,chún',  # 𠸸
    0x20E39: 'yú',  # 𠸹
    0x20E3A: 'nì',  # 𠸺
    # 0x20E3B: '',  # 𠸻
    # 0x20E3C: '',  # 𠸼
    # 0x20E3D: '',  # 𠸽
    # 0x20E3E: '',  # 𠸾
    # 0x20E3F: '',  # 𠸿
    0x20E40: 'xùn',  # 𠹀
    0x20E41: 'wà',  # 𠹁
    # 0x20E42: '',  # 𠹂
    0x20E43: 'àng',  # 𠹃
    0x20E44: 'hàn',  # 𠹄
    0x20E45: 'hōng',  # 𠹅
    0x20E46: 'dān',  # 𠹆
    # 0x20E47: '',  # 𠹇
    0x20E48: 'nuó',  # 𠹈
    # 0x20E49: '',  # 𠹉
    0x20E4A: 'cǎo',  # 𠹊
    0x20E4B: 'jí',  # 𠹋
    0x20E4C: 'něng',  # 𠹌
    0x20E4D: 'yǒng,róng',  # 𠹍
    0x20E4E: 'xiāo',  # 𠹎
    # 0x20E4F: '',  # 𠹏
    0x20E50: 'chuǎ',  # 𠹐
    0x20E51: 'yào',  # 𠹑
    # 0x20E52: '',  # 𠹒
    0x20E53: 'gé',  # 𠹓
    0x20E54: 'táng',  # 𠹔
    0x20E55: 'bào',  # 𠹕
    0x20E56: 'chǎn',  # 𠹖
    # 0x20E57: '',  # 𠹗
    0x20E58: 'xù',  # 𠹘
    # 0x20E59: '',  # 𠹙
    # 0x20E5A: '',  # 𠹚
    0x20E5B: 'hái',  # 𠹛
    # 0x20E5C: '',  # 𠹜
    0x20E5D: 'chóu',  # 𠹝
    # 0x20E5E: '',  # 𠹞
    0x20E5F: 'jiǎn',  # 𠹟
    0x20E60: 'zuō',  # 𠹠
    # 0x20E61: '',  # 𠹡
    # 0x20E62: '',  # 𠹢
    # 0x20E63: '',  # 𠹣
    0x20E64: 'wèi',  # 𠹤
    0x20E65: 'dā',  # 𠹥
    0x20E66: 'pī',  # 𠹦
    # 0x20E67: '',  # 𠹧
    # 0x20E68: '',  # 𠹨
    # 0x20E69: '',  # 𠹩
    # 0x20E6A: '',  # 𠹪
    # 0x20E6B: '',  # 𠹫
    # 0x20E6C: '',  # 𠹬
    0x20E6D: 'gē',  # 𠹭
    # 0x20E6E: '',  # 𠹮
    # 0x20E6F: '',  # 𠹯
    # 0x20E70: '',  # 𠹰
    # 0x20E71: '',  # 𠹱
    # 0x20E72: '',  # 𠹲
    0x20E73: 'jié',  # 𠹳
    # 0x20E74: '',  # 𠹴
    # 0x20E75: '',  # 𠹵
    # 0x20E76: '',  # 𠹶
    # 0x20E77: '',  # 𠹷
    # 0x20E78: '',  # 𠹸
    # 0x20E79: '',  # 𠹹
    # 0x20E7A: '',  # 𠹺
    # 0x20E7B: '',  # 𠹻
    # 0x20E7C: '',  # 𠹼
    # 0x20E7D: '',  # 𠹽
    # 0x20E7E: '',  # 𠹾
    # 0x20E7F: '',  # 𠹿
    # 0x20E80: '',  # 𠺀
    # 0x20E81: '',  # 𠺁
    # 0x20E82: '',  # 𠺂
    # 0x20E83: '',  # 𠺃
    # 0x20E84: '',  # 𠺄
    # 0x20E85: '',  # 𠺅
    # 0x20E86: '',  # 𠺆
    # 0x20E87: '',  # 𠺇
    # 0x20E88: '',  # 𠺈
    # 0x20E89: '',  # 𠺉
    # 0x20E8A: '',  # 𠺊
    # 0x20E8B: '',  # 𠺋
    # 0x20E8C: '',  # 𠺌
    # 0x20E8D: '',  # 𠺍
    # 0x20E8E: '',  # 𠺎
    # 0x20E8F: '',  # 𠺏
    0x20E90: 'huàn',  # 𠺐
    # 0x20E91: '',  # 𠺑
    0x20E92: 'xī',  # 𠺒
    # 0x20E93: '',  # 𠺓
    0x20E94: 'pèn',  # 𠺔
    0x20E95: 'liū,liáo',  # 𠺕
    0x20E96: 'mǔ',  # 𠺖
    0x20E97: 'miē',  # 𠺗
    0x20E98: 'làng',  # 𠺘
    0x20E99: 'tuì',  # 𠺙
    0x20E9A: 'bān',  # 𠺚
    # 0x20E9B: '',  # 𠺛
    # 0x20E9C: '',  # 𠺜
    0x20E9D: 'gē',  # 𠺝
    # 0x20E9E: '',  # 𠺞
    0x20E9F: 'kù',  # 𠺟
    # 0x20EA0: '',  # 𠺠
    # 0x20EA1: '',  # 𠺡
    0x20EA2: 'jiā',  # 𠺢
    0x20EA3: 'bō',  # 𠺣
    # 0x20EA4: '',  # 𠺤
    # 0x20EA5: '',  # 𠺥
    # 0x20EA6: '',  # 𠺦
    # 0x20EA7: '',  # 𠺧
    # 0x20EA8: '',  # 𠺨
    # 0x20EA9: '',  # 𠺩
    # 0x20EAA: '',  # 𠺪
    # 0x20EAB: '',  # 𠺫
    # 0x20EAC: '',  # 𠺬
    # 0x20EAD: '',  # 𠺭
    # 0x20EAE: '',  # 𠺮
    # 0x20EAF: '',  # 𠺯
    # 0x20EB0: '',  # 𠺰
    # 0x20EB1: '',  # 𠺱
    # 0x20EB2: '',  # 𠺲
    # 0x20EB3: '',  # 𠺳
    # 0x20EB4: '',  # 𠺴
    # 0x20EB5: '',  # 𠺵
    # 0x20EB6: '',  # 𠺶
    # 0x20EB7: '',  # 𠺷
    # 0x20EB8: '',  # 𠺸
    # 0x20EB9: '',  # 𠺹
    # 0x20EBA: '',  # 𠺺
    # 0x20EBB: '',  # 𠺻
    # 0x20EBC: '',  # 𠺼
    # 0x20EBD: '',  # 𠺽
    # 0x20EBE: '',  # 𠺾
    # 0x20EBF: '',  # 𠺿
    # 0x20EC0: '',  # 𠻀
    # 0x20EC1: '',  # 𠻁
    # 0x20EC2: '',  # 𠻂
    # 0x20EC3: '',  # 𠻃
    # 0x20EC4: '',  # 𠻄
    # 0x20EC5: '',  # 𠻅
    # 0x20EC6: '',  # 𠻆
    # 0x20EC7: '',  # 𠻇
    # 0x20EC8: '',  # 𠻈
    # 0x20EC9: '',  # 𠻉
    # 0x20ECA: '',  # 𠻊
    # 0x20ECB: '',  # 𠻋
    # 0x20ECC: '',  # 𠻌
    0x20ECD: 'huàn',  # 𠻍
    # 0x20ECE: '',  # 𠻎
    0x20ECF: 'zú',  # 𠻏
    0x20ED0: 'luò',  # 𠻐
    # 0x20ED1: '',  # 𠻑
    # 0x20ED2: '',  # 𠻒
    # 0x20ED3: '',  # 𠻓
    # 0x20ED4: '',  # 𠻔
    # 0x20ED5: '',  # 𠻕
    # 0x20ED6: '',  # 𠻖
    0x20ED7: 'lí',  # 𠻗
    # 0x20ED8: '',  # 𠻘
    0x20ED9: 'hé',  # 𠻙
    0x20EDA: 'mó',  # 𠻚
    # 0x20EDB: '',  # 𠻛
    0x20EDC: 'shuì,lǜ,sū',  # 𠻜
    0x20EDD: 'shēn',  # 𠻝
    0x20EDE: 'kǎng',  # 𠻞
    0x20EDF: 'chì',  # 𠻟
    0x20EE0: 'líng',  # 𠻠
    0x20EE1: 'luǒ',  # 𠻡
    # 0x20EE2: '',  # 𠻢
    # 0x20EE3: '',  # 𠻣
    0x20EE4: 'yǎn',  # 𠻤
    0x20EE5: 'zhào',  # 𠻥
    0x20EE6: 'chuǎ',  # 𠻦
    0x20EE7: 'gǔ',  # 𠻧
    0x20EE8: 'qǐn',  # 𠻨
    # 0x20EE9: '',  # 𠻩
    0x20EEA: 'tán',  # 𠻪
    0x20EEB: 'fèn',  # 𠻫
    0x20EEC: 'tú',  # 𠻬
    # 0x20EED: '',  # 𠻭
    # 0x20EEE: '',  # 𠻮
    # 0x20EEF: '',  # 𠻯
    # 0x20EF0: '',  # 𠻰
    0x20EF1: 'líng',  # 𠻱
    # 0x20EF2: '',  # 𠻲
    0x20EF3: 'zuò',  # 𠻳
    0x20EF4: 'lǎng',  # 𠻴
    # 0x20EF5: '',  # 𠻵
    # 0x20EF6: '',  # 𠻶
    # 0x20EF7: '',  # 𠻷
    # 0x20EF8: '',  # 𠻸
    # 0x20EF9: '',  # 𠻹
    # 0x20EFA: '',  # 𠻺
    # 0x20EFB: '',  # 𠻻
    # 0x20EFC: '',  # 𠻼
    # 0x20EFD: '',  # 𠻽
    # 0x20EFE: '',  # 𠻾
    # 0x20EFF: '',  # 𠻿
    # 0x20F00: '',  # 𠼀
    # 0x20F01: '',  # 𠼁
    # 0x20F02: '',  # 𠼂
    # 0x20F03: '',  # 𠼃
    # 0x20F04: '',  # 𠼄
    # 0x20F05: '',  # 𠼅
    # 0x20F06: '',  # 𠼆
    # 0x20F07: '',  # 𠼇
    # 0x20F08: '',  # 𠼈
    # 0x20F09: '',  # 𠼉
    # 0x20F0A: '',  # 𠼊
    # 0x20F0B: '',  # 𠼋
    # 0x20F0C: '',  # 𠼌
    # 0x20F0D: '',  # 𠼍
    # 0x20F0E: '',  # 𠼎
    # 0x20F0F: '',  # 𠼏
    # 0x20F10: '',  # 𠼐
    # 0x20F11: '',  # 𠼑
    # 0x20F12: '',  # 𠼒
    # 0x20F13: '',  # 𠼓
    # 0x20F14: '',  # 𠼔
    # 0x20F15: '',  # 𠼕
    0x20F16: 'lán',  # 𠼖
    0x20F17: 'zàn',  # 𠼗
    0x20F18: 'wù',  # 𠼘
    # 0x20F19: '',  # 𠼙
    # 0x20F1A: '',  # 𠼚
    # 0x20F1B: '',  # 𠼛
    # 0x20F1C: '',  # 𠼜
    0x20F1D: 'lí',  # 𠼝
    0x20F1E: 'ā',  # 𠼞
    0x20F1F: 'lüè',  # 𠼟
    0x20F20: 'zhǐ',  # 𠼠
    0x20F21: 'chóu',  # 𠼡
    0x20F22: 'jiàng,qiàng',  # 𠼢
    # 0x20F23: '',  # 𠼣
    0x20F24: 'jiān',  # 𠼤
    # 0x20F25: '',  # 𠼥
    # 0x20F26: '',  # 𠼦
    # 0x20F27: '',  # 𠼧
    # 0x20F28: '',  # 𠼨
    0x20F29: 'lún',  # 𠼩
    0x20F2A: 'yí',  # 𠼪
    # 0x20F2B: '',  # 𠼫
    0x20F2C: 'shāng',  # 𠼬
    # 0x20F2D: '',  # 𠼭
    0x20F2E: 'ǎi',  # 𠼮
    # 0x20F2F: '',  # 𠼯
    # 0x20F30: '',  # 𠼰
    # 0x20F31: '',  # 𠼱
    # 0x20F32: '',  # 𠼲
    # 0x20F33: '',  # 𠼳
    # 0x20F34: '',  # 𠼴
    # 0x20F35: '',  # 𠼵
    # 0x20F36: '',  # 𠼶
    # 0x20F37: '',  # 𠼷
    # 0x20F38: '',  # 𠼸
    # 0x20F39: '',  # 𠼹
    # 0x20F3A: '',  # 𠼺
    0x20F3B: 'jī',  # 𠼻
    # 0x20F3C: '',  # 𠼼
    # 0x20F3D: '',  # 𠼽
    # 0x20F3E: '',  # 𠼾
    # 0x20F3F: '',  # 𠼿
    # 0x20F40: '',  # 𠽀
    # 0x20F41: '',  # 𠽁
    # 0x20F42: '',  # 𠽂
    # 0x20F43: '',  # 𠽃
    # 0x20F44: '',  # 𠽄
    # 0x20F45: '',  # 𠽅
    # 0x20F46: '',  # 𠽆
    # 0x20F47: '',  # 𠽇
    # 0x20F48: '',  # 𠽈
    # 0x20F49: '',  # 𠽉
    # 0x20F4A: '',  # 𠽊
    # 0x20F4B: '',  # 𠽋
    # 0x20F4C: '',  # 𠽌
    # 0x20F4D: '',  # 𠽍
    # 0x20F4E: '',  # 𠽎
    # 0x20F4F: '',  # 𠽏
    # 0x20F50: '',  # 𠽐
    # 0x20F51: '',  # 𠽑
    # 0x20F52: '',  # 𠽒
    # 0x20F53: '',  # 𠽓
    # 0x20F54: '',  # 𠽔
    # 0x20F55: '',  # 𠽕
    # 0x20F56: '',  # 𠽖
    # 0x20F57: '',  # 𠽗
    # 0x20F58: '',  # 𠽘
    # 0x20F59: '',  # 𠽙
    # 0x20F5A: '',  # 𠽚
    # 0x20F5B: '',  # 𠽛
    0x20F5C: 'yì',  # 𠽜
    0x20F5D: 'nín',  # 𠽝
    # 0x20F5E: '',  # 𠽞
    # 0x20F5F: '',  # 𠽟
    # 0x20F60: '',  # 𠽠
    0x20F61: 'huì',  # 𠽡
    # 0x20F62: '',  # 𠽢
    0x20F63: 'zhā',  # 𠽣
    # 0x20F64: '',  # 𠽤
    # 0x20F65: '',  # 𠽥
    0x20F66: 'hǎn',  # 𠽦
    # 0x20F67: '',  # 𠽧
    0x20F68: 'yǐn',  # 𠽨
    0x20F69: 'bì',  # 𠽩
    0x20F6A: 'ān',  # 𠽪
    0x20F6B: 'xiā,xiǎ',  # 𠽫
    0x20F6C: 'ní',  # 𠽬
    # 0x20F6D: '',  # 𠽭
    # 0x20F6E: '',  # 𠽮
    # 0x20F6F: '',  # 𠽯
    0x20F70: 'dī',  # 𠽰
    0x20F71: 'jiǎn',  # 𠽱
    0x20F72: 'pán',  # 𠽲
    # 0x20F73: '',  # 𠽳
    # 0x20F74: '',  # 𠽴
    0x20F75: 'yù',  # 𠽵
    0x20F76: 'chuài,cuì,chuò',  # 𠽶
    0x20F77: 'zā',  # 𠽷
    # 0x20F78: '',  # 𠽸
    0x20F79: 'chá',  # 𠽹
    # 0x20F7A: '',  # 𠽺
    0x20F7B: 'zhé',  # 𠽻
    0x20F7C: 'sè',  # 𠽼
    # 0x20F7D: '',  # 𠽽
    0x20F7E: 'pēn,pǔ',  # 𠽾
    0x20F7F: 'gū',  # 𠽿
    0x20F80: 'zhé',  # 𠾀
    # 0x20F81: '',  # 𠾁
    # 0x20F82: '',  # 𠾂
    # 0x20F83: '',  # 𠾃
    # 0x20F84: '',  # 𠾄
    # 0x20F85: '',  # 𠾅
    0x20F86: 'lí',  # 𠾆
    0x20F87: 'dōu',  # 𠾇
    # 0x20F88: '',  # 𠾈
    0x20F89: 'chóu',  # 𠾉
    # 0x20F8A: '',  # 𠾊
    0x20F8B: 'zuǐ',  # 𠾋
    0x20F8C: 'pò',  # 𠾌
    # 0x20F8D: '',  # 𠾍
    # 0x20F8E: '',  # 𠾎
    0x20F8F: 'shē',  # 𠾏
    0x20F90: 'lóng',  # 𠾐
    # 0x20F91: '',  # 𠾑
    # 0x20F92: '',  # 𠾒
    # 0x20F93: '',  # 𠾓
    # 0x20F94: '',  # 𠾔
    # 0x20F95: '',  # 𠾕
    # 0x20F96: '',  # 𠾖
    # 0x20F97: '',  # 𠾗
    # 0x20F98: '',  # 𠾘
    # 0x20F99: '',  # 𠾙
    # 0x20F9A: '',  # 𠾚
    # 0x20F9B: '',  # 𠾛
    # 0x20F9C: '',  # 𠾜
    # 0x20F9D: '',  # 𠾝
    # 0x20F9E: '',  # 𠾞
    # 0x20F9F: '',  # 𠾟
    # 0x20FA0: '',  # 𠾠
    # 0x20FA1: '',  # 𠾡
    0x20FA2: 'shù',  # 𠾢
    # 0x20FA3: '',  # 𠾣
    0x20FA4: 'jìn',  # 𠾤
    0x20FA5: 'líng',  # 𠾥
    # 0x20FA6: '',  # 𠾦
    # 0x20FA7: '',  # 𠾧
    0x20FA8: 'kāng',  # 𠾨
    0x20FA9: 'là',  # 𠾩
    # 0x20FAA: '',  # 𠾪
    0x20FAB: 'xū',  # 𠾫
    0x20FAC: 'jìn',  # 𠾬
    # 0x20FAD: '',  # 𠾭
    0x20FAE: 'chuān',  # 𠾮
    # 0x20FAF: '',  # 𠾯
    # 0x20FB0: '',  # 𠾰
    # 0x20FB1: '',  # 𠾱
    0x20FB2: 'yuè',  # 𠾲
    # 0x20FB3: '',  # 𠾳
    # 0x20FB4: '',  # 𠾴
    # 0x20FB5: '',  # 𠾵
    # 0x20FB6: '',  # 𠾶
    # 0x20FB7: '',  # 𠾷
    # 0x20FB8: '',  # 𠾸
    # 0x20FB9: '',  # 𠾹
    # 0x20FBA: '',  # 𠾺
    # 0x20FBB: '',  # 𠾻
    # 0x20FBC: '',  # 𠾼
    # 0x20FBD: '',  # 𠾽
    # 0x20FBE: '',  # 𠾾
    # 0x20FBF: '',  # 𠾿
    # 0x20FC0: '',  # 𠿀
    # 0x20FC1: '',  # 𠿁
    # 0x20FC2: '',  # 𠿂
    # 0x20FC3: '',  # 𠿃
    # 0x20FC4: '',  # 𠿄
    # 0x20FC5: '',  # 𠿅
    0x20FC6: 'mǎi',  # 𠿆
    0x20FC7: 'xiè',  # 𠿇
    0x20FC8: 'jiū',  # 𠿈
    0x20FC9: 'jì',  # 𠿉
    # 0x20FCA: '',  # 𠿊
    0x20FCB: 'yuè',  # 𠿋
    # 0x20FCC: '',  # 𠿌
    # 0x20FCD: '',  # 𠿍
    # 0x20FCE: '',  # 𠿎
    0x20FCF: 'jiān',  # 𠿏
    # 0x20FD0: '',  # 𠿐
    0x20FD1: 'hán,gǎn,ǎn,hǎn',  # 𠿑
    # 0x20FD2: '',  # 𠿒
    0x20FD3: 'sà',  # 𠿓
    0x20FD4: 'huì',  # 𠿔
    0x20FD5: 'qiào',  # 𠿕
    # 0x20FD6: '',  # 𠿖
    0x20FD7: 'sè',  # 𠿗
    0x20FD8: 'zuǐ',  # 𠿘
    # 0x20FD9: '',  # 𠿙
    # 0x20FDA: '',  # 𠿚
    0x20FDB: 'lǔ',  # 𠿛
    0x20FDC: 'huà',  # 𠿜
    0x20FDD: 'chū',  # 𠿝
    0x20FDE: 'shǎn',  # 𠿞
    0x20FDF: 'wò',  # 𠿟
    0x20FE0: 'jí',  # 𠿠
    0x20FE1: 'zhuó',  # 𠿡
    0x20FE2: 'xián,xiàn',  # 𠿢
    0x20FE3: 'yī',  # 𠿣
    0x20FE4: 'guó',  # 𠿤
    0x20FE5: 'kuì,guì',  # 𠿥
    # 0x20FE6: '',  # 𠿦
    # 0x20FE7: '',  # 𠿧
    # 0x20FE8: '',  # 𠿨
    # 0x20FE9: '',  # 𠿩
    # 0x20FEA: '',  # 𠿪
    # 0x20FEB: '',  # 𠿫
    # 0x20FEC: '',  # 𠿬
    # 0x20FED: '',  # 𠿭
    # 0x20FEE: '',  # 𠿮
    # 0x20FEF: '',  # 𠿯
    # 0x20FF0: '',  # 𠿰
    # 0x20FF1: '',  # 𠿱
    # 0x20FF2: '',  # 𠿲
    # 0x20FF3: '',  # 𠿳
    # 0x20FF4: '',  # 𠿴
    # 0x20FF5: '',  # 𠿵
    # 0x20FF6: '',  # 𠿶
    # 0x20FF7: '',  # 𠿷
    # 0x20FF8: '',  # 𠿸
    # 0x20FF9: '',  # 𠿹
    # 0x20FFA: '',  # 𠿺
    # 0x20FFB: '',  # 𠿻
    # 0x20FFC: '',  # 𠿼
    # 0x20FFD: '',  # 𠿽
    # 0x20FFE: '',  # 𠿾
    # 0x20FFF: '',  # 𠿿
    # 0x21000: '',  # 𡀀
    # 0x21001: '',  # 𡀁
    # 0x21002: '',  # 𡀂
    # 0x21003: '',  # 𡀃
    # 0x21004: '',  # 𡀄
    # 0x21005: '',  # 𡀅
    # 0x21006: '',  # 𡀆
    0x21007: 'dǒng',  # 𡀇
    # 0x21008: '',  # 𡀈
    # 0x21009: '',  # 𡀉
    # 0x2100A: '',  # 𡀊
    # 0x2100B: '',  # 𡀋
    # 0x2100C: '',  # 𡀌
    # 0x2100D: '',  # 𡀍
    # 0x2100E: '',  # 𡀎
    # 0x2100F: '',  # 𡀏
    # 0x21010: '',  # 𡀐
    0x21011: 'zhōu',  # 𡀑
    # 0x21012: '',  # 𡀒
    # 0x21013: '',  # 𡀓
    0x21014: 'lù,lou',  # 𡀔
    # 0x21015: '',  # 𡀕
    0x21016: 'bō',  # 𡀖
    0x21017: 'shí',  # 𡀗
    0x21018: 'yìng',  # 𡀘
    0x21019: 'kū',  # 𡀙
    # 0x2101A: '',  # 𡀚
    # 0x2101B: '',  # 𡀛
    # 0x2101C: '',  # 𡀜
    # 0x2101D: '',  # 𡀝
    # 0x2101E: '',  # 𡀞
    # 0x2101F: '',  # 𡀟
    # 0x21020: '',  # 𡀠
    # 0x21021: '',  # 𡀡
    # 0x21022: '',  # 𡀢
    # 0x21023: '',  # 𡀣
    # 0x21024: '',  # 𡀤
    # 0x21025: '',  # 𡀥
    # 0x21026: '',  # 𡀦
    # 0x21027: '',  # 𡀧
    # 0x21028: '',  # 𡀨
    # 0x21029: '',  # 𡀩
    # 0x2102A: '',  # 𡀪
    # 0x2102B: '',  # 𡀫
    # 0x2102C: '',  # 𡀬
    # 0x2102D: '',  # 𡀭
    # 0x2102E: '',  # 𡀮
    # 0x2102F: '',  # 𡀯
    # 0x21030: '',  # 𡀰
    # 0x21031: '',  # 𡀱
    # 0x21032: '',  # 𡀲
    # 0x21033: '',  # 𡀳
    # 0x21034: '',  # 𡀴
    # 0x21035: '',  # 𡀵
    # 0x21036: '',  # 𡀶
    # 0x21037: '',  # 𡀷
    # 0x21038: '',  # 𡀸
    0x21039: 'zhì',  # 𡀹
    0x2103A: 'xié',  # 𡀺
    # 0x2103B: '',  # 𡀻
    # 0x2103C: '',  # 𡀼
    0x2103D: 'yè,hè',  # 𡀽
    0x2103E: 'è',  # 𡀾
    0x2103F: 'lǜ',  # 𡀿
    0x21040: 'hàn',  # 𡁀
    0x21041: 'yè,kài',  # 𡁁
    # 0x21042: '',  # 𡁂
    # 0x21043: '',  # 𡁃
    # 0x21044: '',  # 𡁄
    # 0x21045: '',  # 𡁅
    0x21046: 'luò',  # 𡁆
    0x21047: 'chuò',  # 𡁇
    0x21048: 'fàn',  # 𡁈
    0x21049: 'zhí',  # 𡁉
    0x2104A: 'yìng',  # 𡁊
    0x2104B: 'wěn',  # 𡁋
    0x2104C: 'wā',  # 𡁌
    0x2104D: 'ài',  # 𡁍
    0x2104E: 'yú',  # 𡁎
    0x2104F: 'méng',  # 𡁏
    # 0x21050: '',  # 𡁐
    0x21051: 'huā',  # 𡁑
    # 0x21052: '',  # 𡁒
    0x21053: 'liè',  # 𡁓
    0x21054: 'jīng',  # 𡁔
    0x21055: 'zá',  # 𡁕
    # 0x21056: '',  # 𡁖
    # 0x21057: '',  # 𡁗
    # 0x21058: '',  # 𡁘
    # 0x21059: '',  # 𡁙
    # 0x2105A: '',  # 𡁚
    # 0x2105B: '',  # 𡁛
    # 0x2105C: '',  # 𡁜
    # 0x2105D: '',  # 𡁝
    # 0x2105E: '',  # 𡁞
    # 0x2105F: '',  # 𡁟
    # 0x21060: '',  # 𡁠
    # 0x21061: '',  # 𡁡
    # 0x21062: '',  # 𡁢
    # 0x21063: '',  # 𡁣
    # 0x21064: '',  # 𡁤
    # 0x21065: '',  # 𡁥
    # 0x21066: '',  # 𡁦
    0x21067: 'zāng',  # 𡁧
    0x21068: 'duì',  # 𡁨
    # 0x21069: '',  # 𡁩
    0x2106A: 'jì',  # 𡁪
    # 0x2106B: '',  # 𡁫
    # 0x2106C: '',  # 𡁬
    # 0x2106D: '',  # 𡁭
    0x2106E: 'wō',  # 𡁮
    # 0x2106F: '',  # 𡁯
    0x21070: 'jí',  # 𡁰
    0x21071: 'xī',  # 𡁱
    # 0x21072: '',  # 𡁲
    0x21073: 'zhàn',  # 𡁳
    0x21074: 'tuán',  # 𡁴
    # 0x21075: '',  # 𡁵
    0x21076: 'jiē',  # 𡁶
    # 0x21077: '',  # 𡁷
    # 0x21078: '',  # 𡁸
    # 0x21079: '',  # 𡁹
    # 0x2107A: '',  # 𡁺
    # 0x2107B: '',  # 𡁻
    # 0x2107C: '',  # 𡁼
    # 0x2107D: '',  # 𡁽
    # 0x2107E: '',  # 𡁾
    # 0x2107F: '',  # 𡁿
    # 0x21080: '',  # 𡂀
    # 0x21081: '',  # 𡂁
    # 0x21082: '',  # 𡂂
    # 0x21083: '',  # 𡂃
    # 0x21084: '',  # 𡂄
    # 0x21085: '',  # 𡂅
    # 0x21086: '',  # 𡂆
    # 0x21087: '',  # 𡂇
    # 0x21088: '',  # 𡂈
    # 0x21089: '',  # 𡂉
    0x2108A: 'yú',  # 𡂊
    # 0x2108B: '',  # 𡂋
    # 0x2108C: '',  # 𡂌
    # 0x2108D: '',  # 𡂍
    # 0x2108E: '',  # 𡂎
    0x2108F: 'liè',  # 𡂏
    # 0x21090: '',  # 𡂐
    # 0x21091: '',  # 𡂑
    0x21092: 'zhì',  # 𡂒
    0x21093: 'shī',  # 𡂓
    # 0x21094: '',  # 𡂔
    0x21095: 'lǎo',  # 𡂕
    0x21096: 'lài,tà',  # 𡂖
    0x21097: 'wěi',  # 𡂗
    0x21098: 'páo',  # 𡂘
    0x21099: 'chí',  # 𡂙
    0x2109A: 'yǐng',  # 𡂚
    0x2109B: 'dòu',  # 𡂛
    # 0x2109C: '',  # 𡂜
    0x2109D: 'dòu',  # 𡂝
    # 0x2109E: '',  # 𡂞
    0x2109F: 'bào',  # 𡂟
    0x210A0: 'qiè',  # 𡂠
    0x210A1: 'shù',  # 𡂡
    0x210A2: 'jiāo',  # 𡂢
    0x210A3: 'zhí',  # 𡂣
    # 0x210A4: '',  # 𡂤
    # 0x210A5: '',  # 𡂥
    # 0x210A6: '',  # 𡂦
    # 0x210A7: '',  # 𡂧
    # 0x210A8: '',  # 𡂨
    0x210A9: 'liè',  # 𡂩
    # 0x210AA: '',  # 𡂪
    0x210AB: 'péng',  # 𡂫
    # 0x210AC: '',  # 𡂬
    0x210AD: 'zhē',  # 𡂭
    # 0x210AE: '',  # 𡂮
    # 0x210AF: '',  # 𡂯
    # 0x210B0: '',  # 𡂰
    # 0x210B1: '',  # 𡂱
    # 0x210B2: '',  # 𡂲
    # 0x210B3: '',  # 𡂳
    # 0x210B4: '',  # 𡂴
    # 0x210B5: '',  # 𡂵
    # 0x210B6: '',  # 𡂶
    # 0x210B7: '',  # 𡂷
    # 0x210B8: '',  # 𡂸
    # 0x210B9: '',  # 𡂹
    # 0x210BA: '',  # 𡂺
    # 0x210BB: '',  # 𡂻
    # 0x210BC: '',  # 𡂼
    # 0x210BD: '',  # 𡂽
    # 0x210BE: '',  # 𡂾
    0x210BF: 'ōu,ou',  # 𡂿
    # 0x210C0: '',  # 𡃀
    # 0x210C1: '',  # 𡃁
    0x210C2: 'xiè',  # 𡃂
    0x210C3: 'jí',  # 𡃃
    0x210C4: 'lài',  # 𡃄
    0x210C5: 'yíng',  # 𡃅
    0x210C6: 'cēng',  # 𡃆
    0x210C7: 'bì',  # 𡃇
    0x210C8: 'kè',  # 𡃈
    # 0x210C9: '',  # 𡃉
    # 0x210CA: '',  # 𡃊
    # 0x210CB: '',  # 𡃋
    # 0x210CC: '',  # 𡃌
    # 0x210CD: '',  # 𡃍
    # 0x210CE: '',  # 𡃎
    # 0x210CF: '',  # 𡃏
    # 0x210D0: '',  # 𡃐
    # 0x210D1: '',  # 𡃑
    # 0x210D2: '',  # 𡃒
    0x210D3: 'bō',  # 𡃓
    # 0x210D4: '',  # 𡃔
    # 0x210D5: '',  # 𡃕
    0x210D6: 'lē',  # 𡃖
    # 0x210D7: '',  # 𡃗
    # 0x210D8: '',  # 𡃘
    # 0x210D9: '',  # 𡃙
    # 0x210DA: '',  # 𡃚
    # 0x210DB: '',  # 𡃛
    # 0x210DC: '',  # 𡃜
    0x210DD: 'lùn',  # 𡃝
    # 0x210DE: '',  # 𡃞
    # 0x210DF: '',  # 𡃟
    # 0x210E0: '',  # 𡃠
    0x210E1: 'lóng',  # 𡃡
    0x210E2: 'xì',  # 𡃢
    # 0x210E3: '',  # 𡃣
    0x210E4: 'lài',  # 𡃤
    # 0x210E5: '',  # 𡃥
    0x210E6: 'lìn',  # 𡃦
    # 0x210E7: '',  # 𡃧
    # 0x210E8: '',  # 𡃨
    0x210E9: 'guī',  # 𡃩
    # 0x210EA: '',  # 𡃪
    # 0x210EB: '',  # 𡃫
    # 0x210EC: '',  # 𡃬
    # 0x210ED: '',  # 𡃭
    # 0x210EE: '',  # 𡃮
    # 0x210EF: '',  # 𡃯
    # 0x210F0: '',  # 𡃰
    # 0x210F1: '',  # 𡃱
    # 0x210F2: '',  # 𡃲
    0x210F3: 'xīng',  # 𡃳
    0x210F4: 'chú',  # 𡃴
    0x210F5: 'yōng',  # 𡃵
    # 0x210F6: '',  # 𡃶
    0x210F7: 'lí',  # 𡃷
    0x210F8: 'cī',  # 𡃸
    # 0x210F9: '',  # 𡃹
    # 0x210FA: '',  # 𡃺
    # 0x210FB: '',  # 𡃻
    # 0x210FC: '',  # 𡃼
    # 0x210FD: '',  # 𡃽
    # 0x210FE: '',  # 𡃾
    # 0x210FF: '',  # 𡃿
    # 0x21100: '',  # 𡄀
    # 0x21101: '',  # 𡄁
    # 0x21102: '',  # 𡄂
    # 0x21103: '',  # 𡄃
    # 0x21104: '',  # 𡄄
    # 0x21105: '',  # 𡄅
    # 0x21106: '',  # 𡄆
    0x21107: 'qǐng',  # 𡄇
    # 0x21108: '',  # 𡄈
    # 0x21109: '',  # 𡄉
    # 0x2110A: '',  # 𡄊
    # 0x2110B: '',  # 𡄋
    # 0x2110C: '',  # 𡄌
    # 0x2110D: '',  # 𡄍
    # 0x2110E: '',  # 𡄎
    # 0x2110F: '',  # 𡄏
    # 0x21110: '',  # 𡄐
    0x21111: 'jiān',  # 𡄑
    0x21112: 'dào',  # 𡄒
    0x21113: 'jiǎn',  # 𡄓
    0x21114: 'qìng',  # 𡄔
    0x21115: 'xiè',  # 𡄕
    0x21116: 'yìng',  # 𡄖
    # 0x21117: '',  # 𡄗
    # 0x21118: '',  # 𡄘
    # 0x21119: '',  # 𡄙
    # 0x2111A: '',  # 𡄚
    # 0x2111B: '',  # 𡄛
    # 0x2111C: '',  # 𡄜
    # 0x2111D: '',  # 𡄝
    # 0x2111E: '',  # 𡄞
    0x2111F: 'há',  # 𡄟
    # 0x21120: '',  # 𡄠
    0x21121: 'zhe',  # 𡄡
    0x21122: 'shē',  # 𡄢
    0x21123: 'mí',  # 𡄣
    0x21124: 'huán',  # 𡄤
    # 0x21125: '',  # 𡄥
    # 0x21126: '',  # 𡄦
    # 0x21127: '',  # 𡄧
    # 0x21128: '',  # 𡄨
    # 0x21129: '',  # 𡄩
    # 0x2112A: '',  # 𡄪
    # 0x2112B: '',  # 𡄫
    # 0x2112C: '',  # 𡄬
    # 0x2112D: '',  # 𡄭
    # 0x2112E: '',  # 𡄮
    # 0x2112F: '',  # 𡄯
    # 0x21130: '',  # 𡄰
    0x21131: 'cù',  # 𡄱
    0x21132: 'rú',  # 𡄲
    0x21133: 'sǎ',  # 𡄳
    0x21134: 'huò',  # 𡄴
    0x21135: 'yī',  # 𡄵
    # 0x21136: '',  # 𡄶
    0x21137: 'dī',  # 𡄷
    # 0x21138: '',  # 𡄸
    0x21139: 'luàn',  # 𡄹
    # 0x2113A: '',  # 𡄺
    0x2113B: 'yì',  # 𡄻
    # 0x2113C: '',  # 𡄼
    # 0x2113D: '',  # 𡄽
    # 0x2113E: '',  # 𡄾
    # 0x2113F: '',  # 𡄿
    # 0x21140: '',  # 𡅀
    # 0x21141: '',  # 𡅁
    0x21142: 'bò',  # 𡅂
    0x21143: 'páng',  # 𡅃
    0x21144: 'tán',  # 𡅄
    0x21145: 'é,éi',  # 𡅅
    0x21146: 'zāng',  # 𡅆
    0x21147: 'cóng',  # 𡅇
    # 0x21148: '',  # 𡅈
    # 0x21149: '',  # 𡅉
    # 0x2114A: '',  # 𡅊
    # 0x2114B: '',  # 𡅋
    # 0x2114C: '',  # 𡅌
    # 0x2114D: '',  # 𡅍
    # 0x2114E: '',  # 𡅎
    # 0x2114F: '',  # 𡅏
    # 0x21150: '',  # 𡅐
    # 0x21151: '',  # 𡅑
    # 0x21152: '',  # 𡅒
    0x21153: 'zhāi',  # 𡅓
    # 0x21154: '',  # 𡅔
    0x21155: 'xǐ',  # 𡅕
    0x21156: 'mǎng',  # 𡅖
    # 0x21157: '',  # 𡅗
    0x21158: 'là',  # 𡅘
    0x21159: 'yùn',  # 𡅙
    # 0x2115A: '',  # 𡅚
    # 0x2115B: '',  # 𡅛
    # 0x2115C: '',  # 𡅜
    # 0x2115D: '',  # 𡅝
    # 0x2115E: '',  # 𡅞
    # 0x2115F: '',  # 𡅟
    # 0x21160: '',  # 𡅠
    0x21161: 'è',  # 𡅡
    # 0x21162: '',  # 𡅢
    # 0x21163: '',  # 𡅣
    # 0x21164: '',  # 𡅤
    0x21165: 'dié',  # 𡅥
    # 0x21166: '',  # 𡅦
    # 0x21167: '',  # 𡅧
    # 0x21168: '',  # 𡅨
    # 0x21169: '',  # 𡅩
    # 0x2116A: '',  # 𡅪
    # 0x2116B: '',  # 𡅫
    # 0x2116C: '',  # 𡅬
    0x2116D: 'guān',  # 𡅭
    # 0x2116E: '',  # 𡅮
    # 0x2116F: '',  # 𡅯
    # 0x21170: '',  # 𡅰
    0x21171: 'huàn',  # 𡅱
    # 0x21172: '',  # 𡅲
    # 0x21173: '',  # 𡅳
    # 0x21174: '',  # 𡅴
    0x21175: 'shì',  # 𡅵
    0x21176: 'jiǎn',  # 𡅶
    # 0x21177: '',  # 𡅷
    # 0x21178: '',  # 𡅸
    0x21179: 'zhān',  # 𡅹
    0x2117A: 'jí',  # 𡅺
    0x2117B: 'huàn',  # 𡅻
    # 0x2117C: '',  # 𡅼
    # 0x2117D: '',  # 𡅽
    # 0x2117E: '',  # 𡅾
    # 0x2117F: '',  # 𡅿
    # 0x21180: '',  # 𡆀
    # 0x21181: '',  # 𡆁
    # 0x21182: '',  # 𡆂
    # 0x21183: '',  # 𡆃
    # 0x21184: '',  # 𡆄
    0x21185: 'wàn',  # 𡆅
    0x21186: 'luǒ',  # 𡆆
    # 0x21187: '',  # 𡆇
    # 0x21188: '',  # 𡆈
    # 0x21189: '',  # 𡆉
    # 0x2118A: '',  # 𡆊
    # 0x2118B: '',  # 𡆋
    # 0x2118C: '',  # 𡆌
    # 0x2118D: '',  # 𡆍
    # 0x2118E: '',  # 𡆎
    0x2118F: 'dòu',  # 𡆏
    # 0x21190: '',  # 𡆐
    # 0x21191: '',  # 𡆑
    # 0x21192: '',  # 𡆒
    # 0x21193: '',  # 𡆓
    # 0x21194: '',  # 𡆔
    0x21195: 'liàn',  # 𡆕
    # 0x21196: '',  # 𡆖
    # 0x21197: '',  # 𡆗
    # 0x21198: '',  # 𡆘
    # 0x21199: '',  # 𡆙
    # 0x2119A: '',  # 𡆚
    # 0x2119B: '',  # 𡆛
    # 0x2119C: '',  # 𡆜
    # 0x2119D: '',  # 𡆝
    # 0x2119E: '',  # 𡆞
    # 0x2119F: '',  # 𡆟
    # 0x211A0: '',  # 𡆠
    # 0x211A1: '',  # 𡆡
    0x211A2: 'qiú',  # 𡆢
    0x211A3: 'niè,dí',  # 𡆣
    0x211A4: 'nǎn',  # 𡆤
    0x211A5: 'jiù',  # 𡆥
    0x211A6: 'yuè',  # 𡆦
    # 0x211A7: '',  # 𡆧
    # 0x211A8: '',  # 𡆨
    0x211A9: 'yāo,jiǒng',  # 𡆩
    0x211AA: 'chuāng',  # 𡆪
    # 0x211AB: '',  # 𡆫
    0x211AC: 'yīn',  # 𡆬
    # 0x211AD: '',  # 𡆭
    0x211AE: 'cǎn',  # 𡆮
    0x211AF: 'lǐ',  # 𡆯
    0x211B0: 'dùn',  # 𡆰
    0x211B1: 'nǎn',  # 𡆱
    0x211B2: 'nǎn',  # 𡆲
    # 0x211B3: '',  # 𡆳
    # 0x211B4: '',  # 𡆴
    # 0x211B5: '',  # 𡆵
    # 0x211B6: '',  # 𡆶
    # 0x211B7: '',  # 𡆷
    0x211B8: 'rì,guó',  # 𡆸
    # 0x211B9: '',  # 𡆹
    # 0x211BA: '',  # 𡆺
    # 0x211BB: '',  # 𡆻
    # 0x211BC: '',  # 𡆼
    0x211BD: 'yuè',  # 𡆽
    # 0x211BE: '',  # 𡆾
    # 0x211BF: '',  # 𡆿
    0x211C0: 'yóu',  # 𡇀
    # 0x211C1: '',  # 𡇁
    0x211C2: 'yīn',  # 𡇂
    # 0x211C3: '',  # 𡇃
    0x211C4: 'guó,niè',  # 𡇄
    0x211C5: 'guó',  # 𡇅
    # 0x211C6: '',  # 𡇆
    # 0x211C7: '',  # 𡇇
    0x211C8: 'dàng,tuó',  # 𡇈
    # 0x211C9: '',  # 𡇉
    # 0x211CA: '',  # 𡇊
    # 0x211CB: '',  # 𡇋
    # 0x211CC: '',  # 𡇌
    # 0x211CD: '',  # 𡇍
    # 0x211CE: '',  # 𡇎
    # 0x211CF: '',  # 𡇏
    # 0x211D0: '',  # 𡇐
    0x211D1: 'zhēn',  # 𡇑
    0x211D2: 'mí',  # 𡇒
    0x211D3: 'dié',  # 𡇓
    # 0x211D4: '',  # 𡇔
    # 0x211D5: '',  # 𡇕
    0x211D6: 'zhēn',  # 𡇖
    # 0x211D7: '',  # 𡇗
    # 0x211D8: '',  # 𡇘
    # 0x211D9: '',  # 𡇙
    0x211DA: 'kuā',  # 𡇚
    # 0x211DB: '',  # 𡇛
    0x211DC: 'hán',  # 𡇜
    0x211DD: 'sòng',  # 𡇝
    0x211DE: 'hé',  # 𡇞
    0x211DF: 'jī',  # 𡇟
    0x211E0: 'zhé',  # 𡇠
    # 0x211E1: '',  # 𡇡
    # 0x211E2: '',  # 𡇢
    # 0x211E3: '',  # 𡇣
    0x211E4: 'bǐng',  # 𡇤
    # 0x211E5: '',  # 𡇥
    0x211E6: 'wéi',  # 𡇦
    0x211E7: 'tōu',  # 𡇧
    # 0x211E8: '',  # 𡇨
    0x211E9: 'tú',  # 𡇩
    # 0x211EA: '',  # 𡇪
    # 0x211EB: '',  # 𡇫
    0x211EC: 'gāng',  # 𡇬
    0x211ED: 'lóu',  # 𡇭
    0x211EE: 'quán',  # 𡇮
    0x211EF: 'hùn',  # 𡇯
    0x211F0: 'zhuǎn',  # 𡇰
    0x211F1: 'què',  # 𡇱
    # 0x211F2: '',  # 𡇲
    0x211F3: 'hóng',  # 𡇳
    # 0x211F4: '',  # 𡇴
    0x211F5: 'dàng',  # 𡇵
    0x211F6: 'hé',  # 𡇶
    0x211F7: 'tài',  # 𡇷
    0x211F8: 'guāi',  # 𡇸
    # 0x211F9: '',  # 𡇹
    0x211FA: 'yù',  # 𡇺
    # 0x211FB: '',  # 𡇻
    0x211FC: 'yà',  # 𡇼
    # 0x211FD: '',  # 𡇽
    # 0x211FE: '',  # 𡇾
    0x211FF: 'wān',  # 𡇿
    0x21200: 'qūn',  # 𡈀
    # 0x21201: '',  # 𡈁
    # 0x21202: '',  # 𡈂
    # 0x21203: '',  # 𡈃
    # 0x21204: '',  # 𡈄
    0x21205: 'jué',  # 𡈅
    0x21206: 'ōu',  # 𡈆
    # 0x21207: '',  # 𡈇
    # 0x21208: '',  # 𡈈
    0x21209: 'quān',  # 𡈉
    0x2120A: 'zhí',  # 𡈊
    0x2120B: 'kǔn',  # 𡈋
    # 0x2120C: '',  # 𡈌
    0x2120D: 'líng',  # 𡈍
    0x2120E: 'wū,rì',  # 𡈎
    0x2120F: 'xìn',  # 𡈏
    0x21210: 'dá',  # 𡈐
    # 0x21211: '',  # 𡈑
    0x21212: 'yuān',  # 𡈒
    0x21213: 'yuàn',  # 𡈓
    # 0x21214: '',  # 𡈔
    # 0x21215: '',  # 𡈕
    # 0x21216: '',  # 𡈖
    0x21217: 'mò',  # 𡈗
    # 0x21218: '',  # 𡈘
    0x21219: 'yóu',  # 𡈙
    # 0x2121A: '',  # 𡈚
    # 0x2121B: '',  # 𡈛
    # 0x2121C: '',  # 𡈜
    # 0x2121D: '',  # 𡈝
    0x2121E: 'wǔ',  # 𡈞
    # 0x2121F: '',  # 𡈟
    0x21220: 'zhāng',  # 𡈠
    # 0x21221: '',  # 𡈡
    # 0x21222: '',  # 𡈢
    0x21223: 'xuān',  # 𡈣
    # 0x21224: '',  # 𡈤
    # 0x21225: '',  # 𡈥
    0x21226: 'rǎo',  # 𡈦
    0x21227: 'gǔn',  # 𡈧
    0x21228: 'yù',  # 𡈨
    # 0x21229: '',  # 𡈩
    # 0x2122A: '',  # 𡈪
    # 0x2122B: '',  # 𡈫
    # 0x2122C: '',  # 𡈬
    # 0x2122D: '',  # 𡈭
    0x2122E: 'xiá',  # 𡈮
    0x2122F: 'biǎn',  # 𡈯
    0x21230: 'yóu',  # 𡈰
    # 0x21231: '',  # 𡈱
    0x21232: 'yīn',  # 𡈲
    # 0x21233: '',  # 𡈳
    0x21234: 'xuán,rǔ',  # 𡈴
    0x21235: 'yóu',  # 𡈵
    0x21236: 'léi',  # 𡈶
    # 0x21237: '',  # 𡈷
    # 0x21238: '',  # 𡈸
    # 0x21239: '',  # 𡈹
    # 0x2123A: '',  # 𡈺
    # 0x2123B: '',  # 𡈻
    0x2123C: 'tǐng,tíng,zhēng,zhǐ',  # 𡈼
    # 0x2123D: '',  # 𡈽
    # 0x2123E: '',  # 𡈾
    0x2123F: 'zhēn',  # 𡈿
    # 0x21240: '',  # 𡉀
    # 0x21241: '',  # 𡉁
    0x21242: 'tǐng',  # 𡉂
    # 0x21243: '',  # 𡉃
    0x21244: 'zài,kū',  # 𡉄
    0x21245: 'gā',  # 𡉅
    0x21246: 'lá',  # 𡉆
    0x21247: 'kuài',  # 𡉇
    # 0x21248: '',  # 𡉈
    0x21249: 'què',  # 𡉉
    # 0x2124A: '',  # 𡉊
    # 0x2124B: '',  # 𡉋
    # 0x2124C: '',  # 𡉌
    # 0x2124D: '',  # 𡉍
    0x2124E: 'jú',  # 𡉎
    # 0x2124F: '',  # 𡉏
    0x21250: 'chūn',  # 𡉐
    0x21251: 'dā',  # 𡉑
    0x21252: 'tún',  # 𡉒
    0x21253: 'āi',  # 𡉓
    # 0x21254: '',  # 𡉔
    # 0x21255: '',  # 𡉕
    # 0x21256: '',  # 𡉖
    0x21257: 'zǐ',  # 𡉗
    # 0x21258: '',  # 𡉘
    # 0x21259: '',  # 𡉙
    0x2125A: 'huáng,fēng',  # 𡉚
    0x2125B: 'yì',  # 𡉛
    # 0x2125C: '',  # 𡉜
    # 0x2125D: '',  # 𡉝
    # 0x2125E: '',  # 𡉞
    # 0x2125F: '',  # 𡉟
    # 0x21260: '',  # 𡉠
    0x21261: 'zuò',  # 𡉡
    # 0x21262: '',  # 𡉢
    # 0x21263: '',  # 𡉣
    # 0x21264: '',  # 𡉤
    # 0x21265: '',  # 𡉥
    0x21266: 'wù',  # 𡉦
    # 0x21267: '',  # 𡉧
    # 0x21268: '',  # 𡉨
    0x21269: 'bào',  # 𡉩
    0x2126A: 'chí',  # 𡉪
    0x2126B: 'tún',  # 𡉫
    # 0x2126C: '',  # 𡉬
    0x2126D: 'rì',  # 𡉭
    # 0x2126E: '',  # 𡉮
    # 0x2126F: '',  # 𡉯
    # 0x21270: '',  # 𡉰
    # 0x21271: '',  # 𡉱
    # 0x21272: '',  # 𡉲
    # 0x21273: '',  # 𡉳
    0x21274: 'lú,hù',  # 𡉴
    # 0x21275: '',  # 𡉵
    # 0x21276: '',  # 𡉶
    0x21277: 'jié',  # 𡉷
    0x21278: 'shì',  # 𡉸
    # 0x21279: '',  # 𡉹
    0x2127A: 'zuān',  # 𡉺
    # 0x2127B: '',  # 𡉻
    # 0x2127C: '',  # 𡉼
    # 0x2127D: '',  # 𡉽
    # 0x2127E: '',  # 𡉾
    # 0x2127F: '',  # 𡉿
    # 0x21280: '',  # 𡊀
    0x21281: 'yì',  # 𡊁
    # 0x21282: '',  # 𡊂
    # 0x21283: '',  # 𡊃
    0x21284: 'fèn',  # 𡊄
    0x21285: 'fèn,biàn',  # 𡊅
    # 0x21286: '',  # 𡊆
    # 0x21287: '',  # 𡊇
    # 0x21288: '',  # 𡊈
    0x21289: 'mò',  # 𡊉
    # 0x2128A: '',  # 𡊊
    # 0x2128B: '',  # 𡊋
    # 0x2128C: '',  # 𡊌
    0x2128D: 'shù',  # 𡊍
    # 0x2128E: '',  # 𡊎
    # 0x2128F: '',  # 𡊏
    # 0x21290: '',  # 𡊐
    # 0x21291: '',  # 𡊑
    # 0x21292: '',  # 𡊒
    # 0x21293: '',  # 𡊓
    # 0x21294: '',  # 𡊔
    # 0x21295: '',  # 𡊕
    # 0x21296: '',  # 𡊖
    # 0x21297: '',  # 𡊗
    # 0x21298: '',  # 𡊘
    # 0x21299: '',  # 𡊙
    # 0x2129A: '',  # 𡊚
    0x2129B: 'áo',  # 𡊛
    # 0x2129C: '',  # 𡊜
    0x2129D: 'pǐ',  # 𡊝
    0x2129E: 'píng,pìng',  # 𡊞
    0x2129F: 'pō',  # 𡊟
    0x212A0: 'jiá',  # 𡊠
    0x212A1: 'zhóu',  # 𡊡
    # 0x212A2: '',  # 𡊢
    0x212A3: 'qiū',  # 𡊣
    # 0x212A4: '',  # 𡊤
    0x212A5: 'zhào',  # 𡊥
    # 0x212A6: '',  # 𡊦
    0x212A7: 'yǒu',  # 𡊧
    0x212A8: 'tán',  # 𡊨
    # 0x212A9: '',  # 𡊩
    # 0x212AA: '',  # 𡊪
    0x212AB: 'rǒng',  # 𡊫
    # 0x212AC: '',  # 𡊬
    0x212AD: 'mì',  # 𡊭
    # 0x212AE: '',  # 𡊮
    # 0x212AF: '',  # 𡊯
    # 0x212B0: '',  # 𡊰
    # 0x212B1: '',  # 𡊱
    # 0x212B2: '',  # 𡊲
    # 0x212B3: '',  # 𡊳
    # 0x212B4: '',  # 𡊴
    # 0x212B5: '',  # 𡊵
    0x212B6: 'yì',  # 𡊶
    # 0x212B7: '',  # 𡊷
    0x212B8: 'rǒng',  # 𡊸
    # 0x212B9: '',  # 𡊹
    # 0x212BA: '',  # 𡊺
    0x212BB: 'liè',  # 𡊻
    0x212BC: 'qióng',  # 𡊼
    # 0x212BD: '',  # 𡊽
    # 0x212BE: '',  # 𡊾
    # 0x212BF: '',  # 𡊿
    # 0x212C0: '',  # 𡋀
    # 0x212C1: '',  # 𡋁
    # 0x212C2: '',  # 𡋂
    # 0x212C3: '',  # 𡋃
    # 0x212C4: '',  # 𡋄
    # 0x212C5: '',  # 𡋅
    # 0x212C6: '',  # 𡋆
    # 0x212C7: '',  # 𡋇
    # 0x212C8: '',  # 𡋈
    # 0x212C9: '',  # 𡋉
    # 0x212CA: '',  # 𡋊
    # 0x212CB: '',  # 𡋋
    # 0x212CC: '',  # 𡋌
    # 0x212CD: '',  # 𡋍
    # 0x212CE: '',  # 𡋎
    # 0x212CF: '',  # 𡋏
    # 0x212D0: '',  # 𡋐
    # 0x212D1: '',  # 𡋑
    # 0x212D2: '',  # 𡋒
    # 0x212D3: '',  # 𡋓
    # 0x212D4: '',  # 𡋔
    # 0x212D5: '',  # 𡋕
    # 0x212D6: '',  # 𡋖
    # 0x212D7: '',  # 𡋗
    # 0x212D8: '',  # 𡋘
    0x212D9: 'huí',  # 𡋙
    0x212DA: 'jì',  # 𡋚
    # 0x212DB: '',  # 𡋛
    # 0x212DC: '',  # 𡋜
    # 0x212DD: '',  # 𡋝
    # 0x212DE: '',  # 𡋞
    0x212DF: 'gào',  # 𡋟
    # 0x212E0: '',  # 𡋠
    # 0x212E1: '',  # 𡋡
    # 0x212E2: '',  # 𡋢
    # 0x212E3: '',  # 𡋣
    # 0x212E4: '',  # 𡋤
    # 0x212E5: '',  # 𡋥
    # 0x212E6: '',  # 𡋦
    0x212E7: 'yóu',  # 𡋧
    0x212E8: 'chā',  # 𡋨
    0x212E9: 'dé',  # 𡋩
    0x212EA: 'yīn',  # 𡋪
    # 0x212EB: '',  # 𡋫
    0x212EC: 'yù',  # 𡋬
    0x212ED: 'bèi',  # 𡋭
    # 0x212EE: '',  # 𡋮
    0x212EF: 'bó',  # 𡋯
    # 0x212F0: '',  # 𡋰
    # 0x212F1: '',  # 𡋱
    0x212F2: 'zuò',  # 𡋲
    # 0x212F3: '',  # 𡋳
    # 0x212F4: '',  # 𡋴
    # 0x212F5: '',  # 𡋵
    # 0x212F6: '',  # 𡋶
    # 0x212F7: '',  # 𡋷
    # 0x212F8: '',  # 𡋸
    # 0x212F9: '',  # 𡋹
    # 0x212FA: '',  # 𡋺
    # 0x212FB: '',  # 𡋻
    # 0x212FC: '',  # 𡋼
    # 0x212FD: '',  # 𡋽
    # 0x212FE: '',  # 𡋾
    # 0x212FF: '',  # 𡋿
    # 0x21300: '',  # 𡌀
    # 0x21301: '',  # 𡌁
    # 0x21302: '',  # 𡌂
    # 0x21303: '',  # 𡌃
    # 0x21304: '',  # 𡌄
    # 0x21305: '',  # 𡌅
    # 0x21306: '',  # 𡌆
    # 0x21307: '',  # 𡌇
    # 0x21308: '',  # 𡌈
    # 0x21309: '',  # 𡌉
    # 0x2130A: '',  # 𡌊
    # 0x2130B: '',  # 𡌋
    # 0x2130C: '',  # 𡌌
    # 0x2130D: '',  # 𡌍
    # 0x2130E: '',  # 𡌎
    # 0x2130F: '',  # 𡌏
    # 0x21310: '',  # 𡌐
    # 0x21311: '',  # 𡌑
    # 0x21312: '',  # 𡌒
    # 0x21313: '',  # 𡌓
    0x21314: 'qiāo',  # 𡌔
    # 0x21315: '',  # 𡌕
    # 0x21316: '',  # 𡌖
    # 0x21317: '',  # 𡌗
    # 0x21318: '',  # 𡌘
    # 0x21319: '',  # 𡌙
    0x2131A: 'chǎ',  # 𡌚
    # 0x2131B: '',  # 𡌛
    0x2131C: 'xīn',  # 𡌜
    # 0x2131D: '',  # 𡌝
    0x2131E: 'chí',  # 𡌞
    # 0x2131F: '',  # 𡌟
    # 0x21320: '',  # 𡌠
    # 0x21321: '',  # 𡌡
    # 0x21322: '',  # 𡌢
    # 0x21323: '',  # 𡌣
    0x21324: 'kuí',  # 𡌤
    # 0x21325: '',  # 𡌥
    0x21326: 'fèi',  # 𡌦
    # 0x21327: '',  # 𡌧
    # 0x21328: '',  # 𡌨
    0x21329: 'tā,dá',  # 𡌩
    0x2132A: 'guài',  # 𡌪
    # 0x2132B: '',  # 𡌫
    # 0x2132C: '',  # 𡌬
    0x2132D: 'duō',  # 𡌭
    # 0x2132E: '',  # 𡌮
    # 0x2132F: '',  # 𡌯
    # 0x21330: '',  # 𡌰
    # 0x21331: '',  # 𡌱
    0x21332: 'guī',  # 𡌲
    # 0x21333: '',  # 𡌳
    # 0x21334: '',  # 𡌴
    # 0x21335: '',  # 𡌵
    # 0x21336: '',  # 𡌶
    # 0x21337: '',  # 𡌷
    # 0x21338: '',  # 𡌸
    # 0x21339: '',  # 𡌹
    # 0x2133A: '',  # 𡌺
    # 0x2133B: '',  # 𡌻
    # 0x2133C: '',  # 𡌼
    # 0x2133D: '',  # 𡌽
    # 0x2133E: '',  # 𡌾
    # 0x2133F: '',  # 𡌿
    # 0x21340: '',  # 𡍀
    # 0x21341: '',  # 𡍁
    # 0x21342: '',  # 𡍂
    # 0x21343: '',  # 𡍃
    # 0x21344: '',  # 𡍄
    # 0x21345: '',  # 𡍅
    # 0x21346: '',  # 𡍆
    # 0x21347: '',  # 𡍇
    # 0x21348: '',  # 𡍈
    # 0x21349: '',  # 𡍉
    # 0x2134A: '',  # 𡍊
    # 0x2134B: '',  # 𡍋
    0x2134C: 'chǎn',  # 𡍌
    0x2134D: 'nǎo',  # 𡍍
    # 0x2134E: '',  # 𡍎
    # 0x2134F: '',  # 𡍏
    0x21350: 'hú',  # 𡍐
    # 0x21351: '',  # 𡍑
    0x21352: 'táo',  # 𡍒
    # 0x21353: '',  # 𡍓
    # 0x21354: '',  # 𡍔
    # 0x21355: '',  # 𡍕
    # 0x21356: '',  # 𡍖
    # 0x21357: '',  # 𡍗
    # 0x21358: '',  # 𡍘
    # 0x21359: '',  # 𡍙
    # 0x2135A: '',  # 𡍚
    # 0x2135B: '',  # 𡍛
    # 0x2135C: '',  # 𡍜
    # 0x2135D: '',  # 𡍝
    # 0x2135E: '',  # 𡍞
    # 0x2135F: '',  # 𡍟
    # 0x21360: '',  # 𡍠
    0x21361: 'yì',  # 𡍡
    # 0x21362: '',  # 𡍢
    # 0x21363: '',  # 𡍣
    0x21364: 'niè',  # 𡍤
    0x21365: 'zhài',  # 𡍥
    0x21366: 'huán',  # 𡍦
    # 0x21367: '',  # 𡍧
    0x21368: 'dù',  # 𡍨
    # 0x21369: '',  # 𡍩
    0x2136A: 'qì',  # 𡍪
    0x2136B: 'cè',  # 𡍫
    # 0x2136C: '',  # 𡍬
    # 0x2136D: '',  # 𡍭
    0x2136E: 'chuí',  # 𡍮
    # 0x2136F: '',  # 𡍯
    # 0x21370: '',  # 𡍰
    # 0x21371: '',  # 𡍱
    0x21372: 'dā',  # 𡍲
    # 0x21373: '',  # 𡍳
    # 0x21374: '',  # 𡍴
    # 0x21375: '',  # 𡍵
    0x21376: 'zhì',  # 𡍶
    0x21377: 'gèng',  # 𡍷
    # 0x21378: '',  # 𡍸
    # 0x21379: '',  # 𡍹
    # 0x2137A: '',  # 𡍺
    0x2137B: 'wèng',  # 𡍻
    # 0x2137C: '',  # 𡍼
    # 0x2137D: '',  # 𡍽
    # 0x2137E: '',  # 𡍾
    # 0x2137F: '',  # 𡍿
    # 0x21380: '',  # 𡎀
    0x21381: 'hù',  # 𡎁
    # 0x21382: '',  # 𡎂
    # 0x21383: '',  # 𡎃
    # 0x21384: '',  # 𡎄
    # 0x21385: '',  # 𡎅
    # 0x21386: '',  # 𡎆
    # 0x21387: '',  # 𡎇
    # 0x21388: '',  # 𡎈
    0x21389: 'dù',  # 𡎉
    0x2138A: 'fàn',  # 𡎊
    # 0x2138B: '',  # 𡎋
    # 0x2138C: '',  # 𡎌
    0x2138D: 'chí',  # 𡎍
    # 0x2138E: '',  # 𡎎
    # 0x2138F: '',  # 𡎏
    0x21390: 'yì',  # 𡎐
    0x21391: 'àn',  # 𡎑
    0x21392: 'kuò',  # 𡎒
    0x21393: 'hè',  # 𡎓
    0x21394: 'wò',  # 𡎔
    # 0x21395: '',  # 𡎕
    # 0x21396: '',  # 𡎖
    # 0x21397: '',  # 𡎗
    0x21398: 'yīng',  # 𡎘
    # 0x21399: '',  # 𡎙
    0x2139A: 'piǎn',  # 𡎚
    # 0x2139B: '',  # 𡎛
    # 0x2139C: '',  # 𡎜
    # 0x2139D: '',  # 𡎝
    # 0x2139E: '',  # 𡎞
    # 0x2139F: '',  # 𡎟
    # 0x213A0: '',  # 𡎠
    # 0x213A1: '',  # 𡎡
    # 0x213A2: '',  # 𡎢
    # 0x213A3: '',  # 𡎣
    # 0x213A4: '',  # 𡎤
    # 0x213A5: '',  # 𡎥
    # 0x213A6: '',  # 𡎦
    # 0x213A7: '',  # 𡎧
    # 0x213A8: '',  # 𡎨
    # 0x213A9: '',  # 𡎩
    # 0x213AA: '',  # 𡎪
    0x213AB: 'zhá,qì',  # 𡎫
    0x213AC: 'zhuǎ',  # 𡎬
    # 0x213AD: '',  # 𡎭
    0x213AE: 'sù',  # 𡎮
    # 0x213AF: '',  # 𡎯
    # 0x213B0: '',  # 𡎰
    # 0x213B1: '',  # 𡎱
    # 0x213B2: '',  # 𡎲
    0x213B3: 'nì',  # 𡎳
    # 0x213B4: '',  # 𡎴
    # 0x213B5: '',  # 𡎵
    # 0x213B6: '',  # 𡎶
    # 0x213B7: '',  # 𡎷
    # 0x213B8: '',  # 𡎸
    # 0x213B9: '',  # 𡎹
    0x213BA: 'zhú',  # 𡎺
    0x213BB: 'chán',  # 𡎻
    # 0x213BC: '',  # 𡎼
    # 0x213BD: '',  # 𡎽
    0x213BE: 'bèng',  # 𡎾
    0x213BF: 'ní',  # 𡎿
    0x213C0: 'zhí',  # 𡏀
    0x213C1: 'huì',  # 𡏁
    # 0x213C2: '',  # 𡏂
    # 0x213C3: '',  # 𡏃
    # 0x213C4: '',  # 𡏄
    # 0x213C5: '',  # 𡏅
    # 0x213C6: '',  # 𡏆
    # 0x213C7: '',  # 𡏇
    # 0x213C8: '',  # 𡏈
    # 0x213C9: '',  # 𡏉
    # 0x213CA: '',  # 𡏊
    # 0x213CB: '',  # 𡏋
    # 0x213CC: '',  # 𡏌
    # 0x213CD: '',  # 𡏍
    # 0x213CE: '',  # 𡏎
    # 0x213CF: '',  # 𡏏
    # 0x213D0: '',  # 𡏐
    # 0x213D1: '',  # 𡏑
    # 0x213D2: '',  # 𡏒
    # 0x213D3: '',  # 𡏓
    # 0x213D4: '',  # 𡏔
    # 0x213D5: '',  # 𡏕
    0x213D6: 'ài',  # 𡏖
    # 0x213D7: '',  # 𡏗
    0x213D8: 'xià',  # 𡏘
    # 0x213D9: '',  # 𡏙
    0x213DA: 'zhì',  # 𡏚
    0x213DB: 'xī',  # 𡏛
    # 0x213DC: '',  # 𡏜
    # 0x213DD: '',  # 𡏝
    0x213DE: 'jiǎng',  # 𡏞
    # 0x213DF: '',  # 𡏟
    # 0x213E0: '',  # 𡏠
    # 0x213E1: '',  # 𡏡
    # 0x213E2: '',  # 𡏢
    # 0x213E3: '',  # 𡏣
    # 0x213E4: '',  # 𡏤
    # 0x213E5: '',  # 𡏥
    # 0x213E6: '',  # 𡏦
    # 0x213E7: '',  # 𡏧
    # 0x213E8: '',  # 𡏨
    0x213E9: 'duī',  # 𡏩
    0x213EA: 'fū',  # 𡏪
    # 0x213EB: '',  # 𡏫
    # 0x213EC: '',  # 𡏬
    0x213ED: 'jiāo',  # 𡏭
    0x213EE: 'cháo',  # 𡏮
    0x213EF: 'bài',  # 𡏯
    # 0x213F0: '',  # 𡏰
    # 0x213F1: '',  # 𡏱
    0x213F2: 'xì',  # 𡏲
    # 0x213F3: '',  # 𡏳
    # 0x213F4: '',  # 𡏴
    0x213F5: 'liè',  # 𡏵
    # 0x213F6: '',  # 𡏶
    # 0x213F7: '',  # 𡏷
    # 0x213F8: '',  # 𡏸
    # 0x213F9: '',  # 𡏹
    # 0x213FA: '',  # 𡏺
    # 0x213FB: '',  # 𡏻
    0x213FC: 'áo',  # 𡏼
    # 0x213FD: '',  # 𡏽
    # 0x213FE: '',  # 𡏾
    # 0x213FF: '',  # 𡏿
    # 0x21400: '',  # 𡐀
    # 0x21401: '',  # 𡐁
    # 0x21402: '',  # 𡐂
    # 0x21403: '',  # 𡐃
    # 0x21404: '',  # 𡐄
    # 0x21405: '',  # 𡐅
    # 0x21406: '',  # 𡐆
    # 0x21407: '',  # 𡐇
    # 0x21408: '',  # 𡐈
    # 0x21409: '',  # 𡐉
    # 0x2140A: '',  # 𡐊
    0x2140B: 'zāo',  # 𡐋
    0x2140C: 'chù',  # 𡐌
    # 0x2140D: '',  # 𡐍
    # 0x2140E: '',  # 𡐎
    0x2140F: 'tuǒ',  # 𡐏
    # 0x21410: '',  # 𡐐
    # 0x21411: '',  # 𡐑
    0x21412: 'háo,hào',  # 𡐒
    0x21413: 'kāng',  # 𡐓
    0x21414: 'yín',  # 𡐔
    # 0x21415: '',  # 𡐕
    0x21416: 'xiàn',  # 𡐖
    # 0x21417: '',  # 𡐗
    # 0x21418: '',  # 𡐘
    # 0x21419: '',  # 𡐙
    # 0x2141A: '',  # 𡐚
    # 0x2141B: '',  # 𡐛
    # 0x2141C: '',  # 𡐜
    0x2141D: 'fù',  # 𡐝
    0x2141E: 'biē',  # 𡐞
    # 0x2141F: '',  # 𡐟
    0x21420: 'kuī',  # 𡐠
    # 0x21421: '',  # 𡐡
    # 0x21422: '',  # 𡐢
    # 0x21423: '',  # 𡐣
    0x21424: 'qiè',  # 𡐤
    0x21425: 'sà',  # 𡐥
    # 0x21426: '',  # 𡐦
    # 0x21427: '',  # 𡐧
    # 0x21428: '',  # 𡐨
    # 0x21429: '',  # 𡐩
    # 0x2142A: '',  # 𡐪
    # 0x2142B: '',  # 𡐫
    # 0x2142C: '',  # 𡐬
    # 0x2142D: '',  # 𡐭
    # 0x2142E: '',  # 𡐮
    # 0x2142F: '',  # 𡐯
    # 0x21430: '',  # 𡐰
    # 0x21431: '',  # 𡐱
    # 0x21432: '',  # 𡐲
    # 0x21433: '',  # 𡐳
    # 0x21434: '',  # 𡐴
    # 0x21435: '',  # 𡐵
    # 0x21436: '',  # 𡐶
    # 0x21437: '',  # 𡐷
    # 0x21438: '',  # 𡐸
    # 0x21439: '',  # 𡐹
    # 0x2143A: '',  # 𡐺
    # 0x2143B: '',  # 𡐻
    # 0x2143C: '',  # 𡐼
    # 0x2143D: '',  # 𡐽
    # 0x2143E: '',  # 𡐾
    0x2143F: 'dā,da',  # 𡐿
    0x21440: 'yě,shù',  # 𡑀
    # 0x21441: '',  # 𡑁
    # 0x21442: '',  # 𡑂
    # 0x21443: '',  # 𡑃
    0x21444: 'zhǎng',  # 𡑄
    # 0x21445: '',  # 𡑅
    0x21446: 'liáng',  # 𡑆
    # 0x21447: '',  # 𡑇
    0x21448: 'duǐ',  # 𡑈
    # 0x21449: '',  # 𡑉
    # 0x2144A: '',  # 𡑊
    # 0x2144B: '',  # 𡑋
    # 0x2144C: '',  # 𡑌
    0x2144D: 'láo',  # 𡑍
    0x2144E: 'xūn',  # 𡑎
    # 0x2144F: '',  # 𡑏
    # 0x21450: '',  # 𡑐
    # 0x21451: '',  # 𡑑
    # 0x21452: '',  # 𡑒
    # 0x21453: '',  # 𡑓
    # 0x21454: '',  # 𡑔
    # 0x21455: '',  # 𡑕
    # 0x21456: '',  # 𡑖
    # 0x21457: '',  # 𡑗
    0x21458: 'zhì',  # 𡑘
    # 0x21459: '',  # 𡑙
    0x2145A: 'kū',  # 𡑚
    # 0x2145B: '',  # 𡑛
    # 0x2145C: '',  # 𡑜
    # 0x2145D: '',  # 𡑝
    0x2145E: 'suì',  # 𡑞
    0x2145F: 'wō',  # 𡑟
    # 0x21460: '',  # 𡑠
    # 0x21461: '',  # 𡑡
    0x21462: 'dié',  # 𡑢
    0x21463: 'kū',  # 𡑣
    0x21464: 'luǒ,yíng ',  # 𡑤
    # 0x21465: '',  # 𡑥
    # 0x21466: '',  # 𡑦
    # 0x21467: '',  # 𡑧
    # 0x21468: '',  # 𡑨
    # 0x21469: '',  # 𡑩
    # 0x2146A: '',  # 𡑪
    # 0x2146B: '',  # 𡑫
    # 0x2146C: '',  # 𡑬
    # 0x2146D: '',  # 𡑭
    # 0x2146E: '',  # 𡑮
    0x2146F: 'jiǎn',  # 𡑯
    # 0x21470: '',  # 𡑰
    # 0x21471: '',  # 𡑱
    # 0x21472: '',  # 𡑲
    # 0x21473: '',  # 𡑳
    # 0x21474: '',  # 𡑴
    # 0x21475: '',  # 𡑵
    0x21476: 'jiǎng',  # 𡑶
    # 0x21477: '',  # 𡑷
    # 0x21478: '',  # 𡑸
    # 0x21479: '',  # 𡑹
    # 0x2147A: '',  # 𡑺
    0x2147B: 'zhuì',  # 𡑻
    # 0x2147C: '',  # 𡑼
    0x2147D: 'shuǎng',  # 𡑽
    0x2147E: 'yú',  # 𡑾
    # 0x2147F: '',  # 𡑿
    # 0x21480: '',  # 𡒀
    0x21481: 'sà',  # 𡒁
    # 0x21482: '',  # 𡒂
    0x21483: 'yù,ào',  # 𡒃
    0x21484: 'lǎn',  # 𡒄
    # 0x21485: '',  # 𡒅
    # 0x21486: '',  # 𡒆
    # 0x21487: '',  # 𡒇
    # 0x21488: '',  # 𡒈
    # 0x21489: '',  # 𡒉
    0x2148A: 'yù',  # 𡒊
    # 0x2148B: '',  # 𡒋
    0x2148C: 'qiǎn',  # 𡒌
    0x2148D: 'jù',  # 𡒍
    # 0x2148E: '',  # 𡒎
    0x2148F: 'liè',  # 𡒏
    # 0x21490: '',  # 𡒐
    # 0x21491: '',  # 𡒑
    0x21492: 'shú',  # 𡒒
    0x21493: 'xiàn',  # 𡒓
    # 0x21494: '',  # 𡒔
    # 0x21495: '',  # 𡒕
    0x21496: 'gài',  # 𡒖
    # 0x21497: '',  # 𡒗
    # 0x21498: '',  # 𡒘
    # 0x21499: '',  # 𡒙
    # 0x2149A: '',  # 𡒚
    # 0x2149B: '',  # 𡒛
    # 0x2149C: '',  # 𡒜
    # 0x2149D: '',  # 𡒝
    # 0x2149E: '',  # 𡒞
    # 0x2149F: '',  # 𡒟
    # 0x214A0: '',  # 𡒠
    # 0x214A1: '',  # 𡒡
    0x214A2: 'tái',  # 𡒢
    # 0x214A3: '',  # 𡒣
    # 0x214A4: '',  # 𡒤
    # 0x214A5: '',  # 𡒥
    # 0x214A6: '',  # 𡒦
    0x214A7: 'tiǎn',  # 𡒧
    # 0x214A8: '',  # 𡒨
    0x214A9: 'gāo',  # 𡒩
    # 0x214AA: '',  # 𡒪
    # 0x214AB: '',  # 𡒫
    # 0x214AC: '',  # 𡒬
    # 0x214AD: '',  # 𡒭
    # 0x214AE: '',  # 𡒮
    0x214AF: 'mèng',  # 𡒯
    # 0x214B0: '',  # 𡒰
    0x214B1: 'dí',  # 𡒱
    # 0x214B2: '',  # 𡒲
    0x214B3: 'mián',  # 𡒳
    # 0x214B4: '',  # 𡒴
    # 0x214B5: '',  # 𡒵
    # 0x214B6: '',  # 𡒶
    # 0x214B7: '',  # 𡒷
    # 0x214B8: '',  # 𡒸
    # 0x214B9: '',  # 𡒹
    # 0x214BA: '',  # 𡒺
    # 0x214BB: '',  # 𡒻
    # 0x214BC: '',  # 𡒼
    # 0x214BD: '',  # 𡒽
    0x214BE: 'huī,kuì',  # 𡒾
    # 0x214BF: '',  # 𡒿
    # 0x214C0: '',  # 𡓀
    # 0x214C1: '',  # 𡓁
    # 0x214C2: '',  # 𡓂
    # 0x214C3: '',  # 𡓃
    # 0x214C4: '',  # 𡓄
    # 0x214C5: '',  # 𡓅
    # 0x214C6: '',  # 𡓆
    # 0x214C7: '',  # 𡓇
    # 0x214C8: '',  # 𡓈
    0x214C9: 'duò',  # 𡓉
    # 0x214CA: '',  # 𡓊
    # 0x214CB: '',  # 𡓋
    # 0x214CC: '',  # 𡓌
    0x214CD: 'liè',  # 𡓍
    # 0x214CE: '',  # 𡓎
    # 0x214CF: '',  # 𡓏
    # 0x214D0: '',  # 𡓐
    # 0x214D1: '',  # 𡓑
    0x214D2: 'lài',  # 𡓒
    0x214D3: 'yín,yīn',  # 𡓓
    0x214D4: 'lǎn',  # 𡓔
    # 0x214D5: '',  # 𡓕
    0x214D6: 'jiāo',  # 𡓖
    # 0x214D7: '',  # 𡓗
    0x214D8: 'huò',  # 𡓘
    # 0x214D9: '',  # 𡓙
    # 0x214DA: '',  # 𡓚
    # 0x214DB: '',  # 𡓛
    0x214DC: 'qiáng',  # 𡓜
    # 0x214DD: '',  # 𡓝
    # 0x214DE: '',  # 𡓞
    # 0x214DF: '',  # 𡓟
    # 0x214E0: '',  # 𡓠
    # 0x214E1: '',  # 𡓡
    # 0x214E2: '',  # 𡓢
    0x214E3: 'guō',  # 𡓣
    # 0x214E4: '',  # 𡓤
    # 0x214E5: '',  # 𡓥
    0x214E6: 'zhàn',  # 𡓦
    # 0x214E7: '',  # 𡓧
    # 0x214E8: '',  # 𡓨
    # 0x214E9: '',  # 𡓩
    # 0x214EA: '',  # 𡓪
    # 0x214EB: '',  # 𡓫
    # 0x214EC: '',  # 𡓬
    0x214ED: 'mǐ',  # 𡓭
    # 0x214EE: '',  # 𡓮
    # 0x214EF: '',  # 𡓯
    0x214F0: 'kuī',  # 𡓰
    # 0x214F1: '',  # 𡓱
    # 0x214F2: '',  # 𡓲
    # 0x214F3: '',  # 𡓳
    # 0x214F4: '',  # 𡓴
    # 0x214F5: '',  # 𡓵
    # 0x214F6: '',  # 𡓶
    0x214F7: 'duò',  # 𡓷
    # 0x214F8: '',  # 𡓸
    # 0x214F9: '',  # 𡓹
    # 0x214FA: '',  # 𡓺
    # 0x214FB: '',  # 𡓻
    # 0x214FC: '',  # 𡓼
    # 0x214FD: '',  # 𡓽
    # 0x214FE: '',  # 𡓾
    0x214FF: 'yín',  # 𡓿
    # 0x21500: '',  # 𡔀
    # 0x21501: '',  # 𡔁
    # 0x21502: '',  # 𡔂
    # 0x21503: '',  # 𡔃
    # 0x21504: '',  # 𡔄
    # 0x21505: '',  # 𡔅
    # 0x21506: '',  # 𡔆
    0x21507: 'lèi',  # 𡔇
    # 0x21508: '',  # 𡔈
    # 0x21509: '',  # 𡔉
    # 0x2150A: '',  # 𡔊
    # 0x2150B: '',  # 𡔋
    # 0x2150C: '',  # 𡔌
    # 0x2150D: '',  # 𡔍
    # 0x2150E: '',  # 𡔎
    # 0x2150F: '',  # 𡔏
    # 0x21510: '',  # 𡔐
    # 0x21511: '',  # 𡔑
    # 0x21512: '',  # 𡔒
    # 0x21513: '',  # 𡔓
    # 0x21514: '',  # 𡔔
    0x21515: 'gòng',  # 𡔕
    # 0x21516: '',  # 𡔖
    # 0x21517: '',  # 𡔗
    # 0x21518: '',  # 𡔘
    # 0x21519: '',  # 𡔙
    # 0x2151A: '',  # 𡔚
    0x2151B: 'tǐng',  # 𡔛
    0x2151C: 'yáo',  # 𡔜
    # 0x2151D: '',  # 𡔝
    0x2151E: 'wǎng',  # 𡔞
    # 0x2151F: '',  # 𡔟
    # 0x21520: '',  # 𡔠
    # 0x21521: '',  # 𡔡
    0x21522: 'jié',  # 𡔢
    0x21523: 'jié,qiè',  # 𡔣
    # 0x21524: '',  # 𡔤
    # 0x21525: '',  # 𡔥
    # 0x21526: '',  # 𡔦
    # 0x21527: '',  # 𡔧
    0x21528: 'xiū',  # 𡔨
    # 0x21529: '',  # 𡔩
    0x2152A: 'shù',  # 𡔪
    # 0x2152B: '',  # 𡔫
    # 0x2152C: '',  # 𡔬
    # 0x2152D: '',  # 𡔭
    # 0x2152E: '',  # 𡔮
    # 0x2152F: '',  # 𡔯
    # 0x21530: '',  # 𡔰
    0x21531: 'wèi',  # 𡔱
    # 0x21532: '',  # 𡔲
    # 0x21533: '',  # 𡔳
    0x21534: 'yù',  # 𡔴
    # 0x21535: '',  # 𡔵
    # 0x21536: '',  # 𡔶
    # 0x21537: '',  # 𡔷
    # 0x21538: '',  # 𡔸
    # 0x21539: '',  # 𡔹
    # 0x2153A: '',  # 𡔺
    # 0x2153B: '',  # 𡔻
    # 0x2153C: '',  # 𡔼
    # 0x2153D: '',  # 𡔽
    # 0x2153E: '',  # 𡔾
    # 0x2153F: '',  # 𡔿
    # 0x21540: '',  # 𡕀
    0x21541: 'zhān',  # 𡕁
    # 0x21542: '',  # 𡕂
    # 0x21543: '',  # 𡕃
    0x21544: 'yī',  # 𡕄
    # 0x21545: '',  # 𡕅
    # 0x21546: '',  # 𡕆
    # 0x21547: '',  # 𡕇
    # 0x21548: '',  # 𡕈
    0x21549: 'āng',  # 𡕉
    # 0x2154A: '',  # 𡕊
    # 0x2154B: '',  # 𡕋
    # 0x2154C: '',  # 𡕌
    # 0x2154D: '',  # 𡕍
    # 0x2154E: '',  # 𡕎
    0x2154F: 'sǎng',  # 𡕏
    0x21550: 'chóu',  # 𡕐
    # 0x21551: '',  # 𡕑
    0x21552: 'kuà',  # 𡕒
    # 0x21553: '',  # 𡕓
    # 0x21554: '',  # 𡕔
    # 0x21555: '',  # 𡕕
    0x21556: 'jǔ,féng',  # 𡕖
    0x21557: 'hài',  # 𡕗
    # 0x21558: '',  # 𡕘
    # 0x21559: '',  # 𡕙
    # 0x2155A: '',  # 𡕚
    # 0x2155B: '',  # 𡕛
    # 0x2155C: '',  # 𡕜
    # 0x2155D: '',  # 𡕝
    # 0x2155E: '',  # 𡕞
    # 0x2155F: '',  # 𡕟
    # 0x21560: '',  # 𡕠
    # 0x21561: '',  # 𡕡
    0x21562: 'miǎn,mǎn',  # 𡕢
    # 0x21563: '',  # 𡕣
    # 0x21564: '',  # 𡕤
    0x21565: 'xuè',  # 𡕥
    # 0x21566: '',  # 𡕦
    0x21567: 'hàng',  # 𡕧
    0x21568: 'fú',  # 𡕨
    # 0x21569: '',  # 𡕩
    0x2156A: 'chóu',  # 𡕪
    # 0x2156B: '',  # 𡕫
    # 0x2156C: '',  # 𡕬
    # 0x2156D: '',  # 𡕭
    0x2156E: 'líng',  # 𡕮
    # 0x2156F: '',  # 𡕯
    0x21570: 'zōng',  # 𡕰
    # 0x21571: '',  # 𡕱
    # 0x21572: '',  # 𡕲
    # 0x21573: '',  # 𡕳
    # 0x21574: '',  # 𡕴
    # 0x21575: '',  # 𡕵
    # 0x21576: '',  # 𡕶
    # 0x21577: '',  # 𡕷
    # 0x21578: '',  # 𡕸
    # 0x21579: '',  # 𡕹
    # 0x2157A: '',  # 𡕺
    # 0x2157B: '',  # 𡕻
    # 0x2157C: '',  # 𡕼
    # 0x2157D: '',  # 𡕽
    # 0x2157E: '',  # 𡕾
    # 0x2157F: '',  # 𡕿
    # 0x21580: '',  # 𡖀
    # 0x21581: '',  # 𡖁
    # 0x21582: '',  # 𡖂
    # 0x21583: '',  # 𡖃
    # 0x21584: '',  # 𡖄
    # 0x21585: '',  # 𡖅
    # 0x21586: '',  # 𡖆
    # 0x21587: '',  # 𡖇
    # 0x21588: '',  # 𡖈
    0x21589: 'kūn',  # 𡖉
    0x2158A: 'sù',  # 𡖊
    # 0x2158B: '',  # 𡖋
    0x2158C: 'zhōng',  # 𡖌
    # 0x2158D: '',  # 𡖍
    0x2158E: 'zhāo',  # 𡖎
    # 0x2158F: '',  # 𡖏
    0x21590: 'diě',  # 𡖐
    0x21591: 'gǒu',  # 𡖑
    0x21592: 'yún',  # 𡖒
    0x21593: 'dān',  # 𡖓
    0x21594: 'nuǒ',  # 𡖔
    # 0x21595: '',  # 𡖕
    # 0x21596: '',  # 𡖖
    0x21597: 'niǎo',  # 𡖗
    # 0x21598: '',  # 𡖘
    # 0x21599: '',  # 𡖙
    # 0x2159A: '',  # 𡖚
    0x2159B: 'bǐng',  # 𡖛
    # 0x2159C: '',  # 𡖜
    0x2159D: 'rán',  # 𡖝
    0x2159E: 'chān',  # 𡖞
    # 0x2159F: '',  # 𡖟
    # 0x215A0: '',  # 𡖠
    # 0x215A1: '',  # 𡖡
    0x215A2: 'rǒng',  # 𡖢
    0x215A3: 'yīn',  # 𡖣
    0x215A4: 'chān',  # 𡖤
    # 0x215A5: '',  # 𡖥
    # 0x215A6: '',  # 𡖦
    0x215A7: 'zhì',  # 𡖧
    # 0x215A8: '',  # 𡖨
    # 0x215A9: '',  # 𡖩
    0x215AA: 'guài',  # 𡖪
    0x215AB: 'nuó',  # 𡖫
    0x215AC: 'shēn',  # 𡖬
    # 0x215AD: '',  # 𡖭
    # 0x215AE: '',  # 𡖮
    0x215AF: 'sù',  # 𡖯
    # 0x215B0: '',  # 𡖰
    # 0x215B1: '',  # 𡖱
    0x215B2: 'wǒ',  # 𡖲
    0x215B3: 'chǐ',  # 𡖳
    # 0x215B4: '',  # 𡖴
    # 0x215B5: '',  # 𡖵
    0x215B6: 'mò',  # 𡖶
    # 0x215B7: '',  # 𡖷
    # 0x215B8: '',  # 𡖸
    # 0x215B9: '',  # 𡖹
    0x215BA: 'miè',  # 𡖺
    0x215BB: 'zhí',  # 𡖻
    # 0x215BC: '',  # 𡖼
    # 0x215BD: '',  # 𡖽
    0x215BE: 'qī',  # 𡖾
    # 0x215BF: '',  # 𡖿
    # 0x215C0: '',  # 𡗀
    0x215C1: 'gōu',  # 𡗁
    # 0x215C2: '',  # 𡗂
    # 0x215C3: '',  # 𡗃
    # 0x215C4: '',  # 𡗄
    # 0x215C5: '',  # 𡗅
    0x215C6: 'lǒu',  # 𡗆
    # 0x215C7: '',  # 𡗇
    0x215C8: 'zī',  # 𡗈
    # 0x215C9: '',  # 𡗉
    # 0x215CA: '',  # 𡗊
    # 0x215CB: '',  # 𡗋
    # 0x215CC: '',  # 𡗌
    0x215CD: 'dǎng',  # 𡗍
    # 0x215CE: '',  # 𡗎
    0x215CF: 'xiǎn',  # 𡗏
    # 0x215D0: '',  # 𡗐
    0x215D1: 'rǒu',  # 𡗑
    # 0x215D2: '',  # 𡗒
    # 0x215D3: '',  # 𡗓
    0x215D4: 'tài',  # 𡗔
    # 0x215D5: '',  # 𡗕
    # 0x215D6: '',  # 𡗖
    0x215D7: 'pěng',  # 𡗗
    # 0x215D8: '',  # 𡗘
    # 0x215D9: '',  # 𡗙
    # 0x215DA: '',  # 𡗚
    # 0x215DB: '',  # 𡗛
    # 0x215DC: '',  # 𡗜
    # 0x215DD: '',  # 𡗝
    0x215DE: 'xī',  # 𡗞
    # 0x215DF: '',  # 𡗟
    # 0x215E0: '',  # 𡗠
    # 0x215E1: '',  # 𡗡
    0x215E2: 'kuā,běn',  # 𡗢
    # 0x215E3: '',  # 𡗣
    0x215E4: 'guì',  # 𡗤
    0x215E5: 'chún',  # 𡗥
    0x215E6: 'jiè',  # 𡗦
    # 0x215E7: '',  # 𡗧
    # 0x215E8: '',  # 𡗨
    # 0x215E9: '',  # 𡗩
    # 0x215EA: '',  # 𡗪
    # 0x215EB: '',  # 𡗫
    # 0x215EC: '',  # 𡗬
    # 0x215ED: '',  # 𡗭
    # 0x215EE: '',  # 𡗮
    # 0x215EF: '',  # 𡗯
    # 0x215F0: '',  # 𡗰
    # 0x215F1: '',  # 𡗱
    0x215F2: 'jiè,bēn',  # 𡗲
    0x215F3: 'xī',  # 𡗳
    # 0x215F4: '',  # 𡗴
    0x215F5: 'kū',  # 𡗵
    # 0x215F6: '',  # 𡗶
    0x215F7: 'gū',  # 𡗷
    0x215F8: 'zhà,kuā',  # 𡗸
    0x215F9: 'fàn',  # 𡗹
    # 0x215FA: '',  # 𡗺
    # 0x215FB: '',  # 𡗻
    0x215FC: 'xiè',  # 𡗼
    # 0x215FD: '',  # 𡗽
    # 0x215FE: '',  # 𡗾
    # 0x215FF: '',  # 𡗿
    # 0x21600: '',  # 𡘀
    # 0x21601: '',  # 𡘁
    # 0x21602: '',  # 𡘂
    # 0x21603: '',  # 𡘃
    # 0x21604: '',  # 𡘄
    # 0x21605: '',  # 𡘅
    # 0x21606: '',  # 𡘆
    # 0x21607: '',  # 𡘇
    # 0x21608: '',  # 𡘈
    # 0x21609: '',  # 𡘉
    # 0x2160A: '',  # 𡘊
    # 0x2160B: '',  # 𡘋
    # 0x2160C: '',  # 𡘌
    0x2160D: 'huán,qié',  # 𡘍
    # 0x2160E: '',  # 𡘎
    0x2160F: 'niǎo',  # 𡘏
    0x21610: 'xì',  # 𡘐
    # 0x21611: '',  # 𡘑
    # 0x21612: '',  # 𡘒
    # 0x21613: '',  # 𡘓
    # 0x21614: '',  # 𡘔
    # 0x21615: '',  # 𡘕
    # 0x21616: '',  # 𡘖
    # 0x21617: '',  # 𡘗
    # 0x21618: '',  # 𡘘
    # 0x21619: '',  # 𡘙
    # 0x2161A: '',  # 𡘚
    0x2161B: 'cū',  # 𡘛
    # 0x2161C: '',  # 𡘜
    0x2161D: 'gǔn',  # 𡘝
    # 0x2161E: '',  # 𡘞
    # 0x2161F: '',  # 𡘟
    # 0x21620: '',  # 𡘠
    0x21621: 'xī',  # 𡘡
    # 0x21622: '',  # 𡘢
    # 0x21623: '',  # 𡘣
    # 0x21624: '',  # 𡘤
    # 0x21625: '',  # 𡘥
    # 0x21626: '',  # 𡘦
    0x21627: 'qiá',  # 𡘧
    # 0x21628: '',  # 𡘨
    # 0x21629: '',  # 𡘩
    0x2162A: 'māng',  # 𡘪
    # 0x2162B: '',  # 𡘫
    # 0x2162C: '',  # 𡘬
    0x2162D: 'zhé',  # 𡘭
    # 0x2162E: '',  # 𡘮
    # 0x2162F: '',  # 𡘯
    0x21630: 'juàn',  # 𡘰
    # 0x21631: '',  # 𡘱
    # 0x21632: '',  # 𡘲
    # 0x21633: '',  # 𡘳
    0x21634: 'biē',  # 𡘴
    # 0x21635: '',  # 𡘵
    # 0x21636: '',  # 𡘶
    # 0x21637: '',  # 𡘷
    # 0x21638: '',  # 𡘸
    # 0x21639: '',  # 𡘹
    # 0x2163A: '',  # 𡘺
    # 0x2163B: '',  # 𡘻
    # 0x2163C: '',  # 𡘼
    # 0x2163D: '',  # 𡘽
    # 0x2163E: '',  # 𡘾
    # 0x2163F: '',  # 𡘿
    0x21640: 'biē',  # 𡙀
    # 0x21641: '',  # 𡙁
    # 0x21642: '',  # 𡙂
    # 0x21643: '',  # 𡙃
    # 0x21644: '',  # 𡙄
    0x21645: 'quán',  # 𡙅
    # 0x21646: '',  # 𡙆
    # 0x21647: '',  # 𡙇
    # 0x21648: '',  # 𡙈
    # 0x21649: '',  # 𡙉
    # 0x2164A: '',  # 𡙊
    0x2164B: 'xì',  # 𡙋
    # 0x2164C: '',  # 𡙌
    # 0x2164D: '',  # 𡙍
    0x2164E: 'jiǎo,miǎo',  # 𡙎
    # 0x2164F: '',  # 𡙏
    0x21650: 'quán',  # 𡙐
    0x21651: 'zhǐ',  # 𡙑
    0x21652: 'tiān',  # 𡙒
    0x21653: 'kāi',  # 𡙓
    # 0x21654: '',  # 𡙔
    # 0x21655: '',  # 𡙕
    # 0x21656: '',  # 𡙖
    # 0x21657: '',  # 𡙗
    0x21658: 'sǎn,yì',  # 𡙘
    # 0x21659: '',  # 𡙙
    # 0x2165A: '',  # 𡙚
    0x2165B: 'zī',  # 𡙛
    # 0x2165C: '',  # 𡙜
    # 0x2165D: '',  # 𡙝
    # 0x2165E: '',  # 𡙞
    # 0x2165F: '',  # 𡙟
    # 0x21660: '',  # 𡙠
    # 0x21661: '',  # 𡙡
    # 0x21662: '',  # 𡙢
    0x21663: 'jié',  # 𡙣
    # 0x21664: '',  # 𡙤
    # 0x21665: '',  # 𡙥
    # 0x21666: '',  # 𡙦
    # 0x21667: '',  # 𡙧
    # 0x21668: '',  # 𡙨
    # 0x21669: '',  # 𡙩
    0x2166A: 'bié',  # 𡙪
    # 0x2166B: '',  # 𡙫
    0x2166C: 'dòu',  # 𡙬
    0x2166D: 'zuī',  # 𡙭
    # 0x2166E: '',  # 𡙮
    # 0x2166F: '',  # 𡙯
    # 0x21670: '',  # 𡙰
    # 0x21671: '',  # 𡙱
    # 0x21672: '',  # 𡙲
    0x21673: 'jú',  # 𡙳
    # 0x21674: '',  # 𡙴
    # 0x21675: '',  # 𡙵
    0x21676: 'yǎn',  # 𡙶
    # 0x21677: '',  # 𡙷
    # 0x21678: '',  # 𡙸
    # 0x21679: '',  # 𡙹
    # 0x2167A: '',  # 𡙺
    # 0x2167B: '',  # 𡙻
    # 0x2167C: '',  # 𡙼
    # 0x2167D: '',  # 𡙽
    # 0x2167E: '',  # 𡙾
    # 0x2167F: '',  # 𡙿
    # 0x21680: '',  # 𡚀
    0x21681: 'bì',  # 𡚁
    # 0x21682: '',  # 𡚂
    # 0x21683: '',  # 𡚃
    # 0x21684: '',  # 𡚄
    0x21685: 'kuǎi',  # 𡚅
    # 0x21686: '',  # 𡚆
    0x21687: 'yàn',  # 𡚇
    0x21688: 'wéi',  # 𡚈
    # 0x21689: '',  # 𡚉
    0x2168A: 'huān',  # 𡚊
    # 0x2168B: '',  # 𡚋
    0x2168C: 'hào',  # 𡚌
    0x2168D: 'lián',  # 𡚍
    # 0x2168E: '',  # 𡚎
    # 0x2168F: '',  # 𡚏
    # 0x21690: '',  # 𡚐
    0x21691: 'gōng',  # 𡚑
    # 0x21692: '',  # 𡚒
    # 0x21693: '',  # 𡚓
    0x21694: 'méng',  # 𡚔
    # 0x21695: '',  # 𡚕
    # 0x21696: '',  # 𡚖
    0x21697: 'lěi',  # 𡚗
    # 0x21698: '',  # 𡚘
    0x21699: 'dì',  # 𡚙
    # 0x2169A: '',  # 𡚚
    0x2169B: 'bǐng',  # 𡚛
    0x2169C: 'huān,kàn',  # 𡚜
    # 0x2169D: '',  # 𡚝
    # 0x2169E: '',  # 𡚞
    0x2169F: 'wā',  # 𡚟
    0x216A0: 'jué',  # 𡚠
    # 0x216A1: '',  # 𡚡
    # 0x216A2: '',  # 𡚢
    # 0x216A3: '',  # 𡚣
    0x216A4: 'bì',  # 𡚤
    # 0x216A5: '',  # 𡚥
    0x216A6: 'jī',  # 𡚦
    # 0x216A7: '',  # 𡚧
    0x216A8: 'chì',  # 𡚨
    # 0x216A9: '',  # 𡚩
    # 0x216AA: '',  # 𡚪
    # 0x216AB: '',  # 𡚫
    # 0x216AC: '',  # 𡚬
    0x216AD: 'bā',  # 𡚭
    0x216AE: 'jiǔ',  # 𡚮
    # 0x216AF: '',  # 𡚯
    # 0x216B0: '',  # 𡚰
    # 0x216B1: '',  # 𡚱
    # 0x216B2: '',  # 𡚲
    # 0x216B3: '',  # 𡚳
    # 0x216B4: '',  # 𡚴
    # 0x216B5: '',  # 𡚵
    # 0x216B6: '',  # 𡚶
    0x216B7: 'dì',  # 𡚷
    0x216B8: 'yāo',  # 𡚸
    0x216B9: 'zhàng',  # 𡚹
    # 0x216BA: '',  # 𡚺
    0x216BB: 'dà',  # 𡚻
    0x216BC: 'shí',  # 𡚼
    0x216BD: 'hào',  # 𡚽
    0x216BE: 'shū',  # 𡚾
    # 0x216BF: '',  # 𡚿
    # 0x216C0: '',  # 𡛀
    # 0x216C1: '',  # 𡛁
    # 0x216C2: '',  # 𡛂
    # 0x216C3: '',  # 𡛃
    # 0x216C4: '',  # 𡛄
    # 0x216C5: '',  # 𡛅
    # 0x216C6: '',  # 𡛆
    # 0x216C7: '',  # 𡛇
    # 0x216C8: '',  # 𡛈
    # 0x216C9: '',  # 𡛉
    # 0x216CA: '',  # 𡛊
    # 0x216CB: '',  # 𡛋
    0x216CC: 'yè',  # 𡛌
    # 0x216CD: '',  # 𡛍
    # 0x216CE: '',  # 𡛎
    # 0x216CF: '',  # 𡛏
    # 0x216D0: '',  # 𡛐
    # 0x216D1: '',  # 𡛑
    # 0x216D2: '',  # 𡛒
    # 0x216D3: '',  # 𡛓
    # 0x216D4: '',  # 𡛔
    # 0x216D5: '',  # 𡛕
    # 0x216D6: '',  # 𡛖
    0x216D7: 'bì',  # 𡛗
    0x216D8: 'pǐ',  # 𡛘
    0x216D9: 'yǎo,yāo',  # 𡛙
    # 0x216DA: '',  # 𡛚
    # 0x216DB: '',  # 𡛛
    0x216DC: 'dī',  # 𡛜
    0x216DD: 'càn',  # 𡛝
    0x216DE: 'pín',  # 𡛞
    0x216DF: 'yuè',  # 𡛟
    0x216E0: 'qiē',  # 𡛠
    0x216E1: 'pī',  # 𡛡
    # 0x216E2: '',  # 𡛢
    # 0x216E3: '',  # 𡛣
    # 0x216E4: '',  # 𡛤
    # 0x216E5: '',  # 𡛥
    # 0x216E6: '',  # 𡛦
    # 0x216E7: '',  # 𡛧
    # 0x216E8: '',  # 𡛨
    # 0x216E9: '',  # 𡛩
    # 0x216EA: '',  # 𡛪
    # 0x216EB: '',  # 𡛫
    # 0x216EC: '',  # 𡛬
    # 0x216ED: '',  # 𡛭
    # 0x216EE: '',  # 𡛮
    # 0x216EF: '',  # 𡛯
    0x216F0: 'zhí',  # 𡛰
    # 0x216F1: '',  # 𡛱
    # 0x216F2: '',  # 𡛲
    # 0x216F3: '',  # 𡛳
    # 0x216F4: '',  # 𡛴
    0x216F5: 'tuǒ',  # 𡛵
    0x216F6: 'xiè',  # 𡛶
    # 0x216F7: '',  # 𡛷
    # 0x216F8: '',  # 𡛸
    # 0x216F9: '',  # 𡛹
    # 0x216FA: '',  # 𡛺
    # 0x216FB: '',  # 𡛻
    # 0x216FC: '',  # 𡛼
    0x216FD: 'yè',  # 𡛽
    # 0x216FE: '',  # 𡛾
    # 0x216FF: '',  # 𡛿
    0x21700: 'fàn',  # 𡜀
    0x21701: 'guā',  # 𡜁
    0x21702: 'hù',  # 𡜂
    0x21703: 'rǔ',  # 𡜃
    # 0x21704: '',  # 𡜄
    # 0x21705: '',  # 𡜅
    # 0x21706: '',  # 𡜆
    # 0x21707: '',  # 𡜇
    # 0x21708: '',  # 𡜈
    0x21709: 'rǎn,ràn',  # 𡜉
    0x2170A: 'fǒu',  # 𡜊
    0x2170B: 'huāng',  # 𡜋
    # 0x2170C: '',  # 𡜌
    # 0x2170D: '',  # 𡜍
    # 0x2170E: '',  # 𡜎
    # 0x2170F: '',  # 𡜏
    # 0x21710: '',  # 𡜐
    # 0x21711: '',  # 𡜑
    # 0x21712: '',  # 𡜒
    # 0x21713: '',  # 𡜓
    # 0x21714: '',  # 𡜔
    # 0x21715: '',  # 𡜕
    # 0x21716: '',  # 𡜖
    # 0x21717: '',  # 𡜗
    # 0x21718: '',  # 𡜘
    # 0x21719: '',  # 𡜙
    0x2171A: 'rú',  # 𡜚
    # 0x2171B: '',  # 𡜛
    # 0x2171C: '',  # 𡜜
    0x2171D: 'dòng',  # 𡜝
    # 0x2171E: '',  # 𡜞
    # 0x2171F: '',  # 𡜟
    # 0x21720: '',  # 𡜠
    # 0x21721: '',  # 𡜡
    0x21722: 'mǎo',  # 𡜢
    # 0x21723: '',  # 𡜣
    # 0x21724: '',  # 𡜤
    0x21725: 'duī',  # 𡜥
    0x21726: 'huì',  # 𡜦
    0x21727: 'xì',  # 𡜧
    0x21728: 'xiū',  # 𡜨
    # 0x21729: '',  # 𡜩
    0x2172A: 'nǎo',  # 𡜪
    0x2172B: 'rǎn',  # 𡜫
    0x2172C: 'yī',  # 𡜬
    # 0x2172D: '',  # 𡜭
    # 0x2172E: '',  # 𡜮
    0x2172F: 'zhé',  # 𡜯
    # 0x21730: '',  # 𡜰
    0x21731: 'jì',  # 𡜱
    0x21732: 'gào',  # 𡜲
    0x21733: 'yòu',  # 𡜳
    # 0x21734: '',  # 𡜴
    0x21735: 'pū',  # 𡜵
    # 0x21736: '',  # 𡜶
    # 0x21737: '',  # 𡜷
    # 0x21738: '',  # 𡜸
    # 0x21739: '',  # 𡜹
    # 0x2173A: '',  # 𡜺
    # 0x2173B: '',  # 𡜻
    # 0x2173C: '',  # 𡜼
    # 0x2173D: '',  # 𡜽
    # 0x2173E: '',  # 𡜾
    0x2173F: 'mǔ',  # 𡜿
    # 0x21740: '',  # 𡝀
    # 0x21741: '',  # 𡝁
    # 0x21742: '',  # 𡝂
    # 0x21743: '',  # 𡝃
    # 0x21744: '',  # 𡝄
    # 0x21745: '',  # 𡝅
    # 0x21746: '',  # 𡝆
    # 0x21747: '',  # 𡝇
    0x21748: 'chù',  # 𡝈
    0x21749: 'cū',  # 𡝉
    0x2174A: 'zhé',  # 𡝊
    0x2174B: 'niǎo',  # 𡝋
    # 0x2174C: '',  # 𡝌
    0x2174D: 'qiè',  # 𡝍
    # 0x2174E: '',  # 𡝎
    0x2174F: 'pín',  # 𡝏
    0x21750: 'chá',  # 𡝐
    # 0x21751: '',  # 𡝑
    0x21752: 'niǎo',  # 𡝒
    0x21753: 'suī',  # 𡝓
    # 0x21754: '',  # 𡝔
    # 0x21755: '',  # 𡝕
    # 0x21756: '',  # 𡝖
    0x21757: 'qún',  # 𡝗
    # 0x21758: '',  # 𡝘
    0x21759: 'chá',  # 𡝙
    0x2175A: 'chéng',  # 𡝚
    0x2175B: 'yáo',  # 𡝛
    0x2175C: 'dù',  # 𡝜
    0x2175D: 'wāng',  # 𡝝
    # 0x2175E: '',  # 𡝞
    0x2175F: 'niàn',  # 𡝟
    # 0x21760: '',  # 𡝠
    # 0x21761: '',  # 𡝡
    # 0x21762: '',  # 𡝢
    # 0x21763: '',  # 𡝣
    # 0x21764: '',  # 𡝤
    # 0x21765: '',  # 𡝥
    0x21766: 'nǒu',  # 𡝦
    0x21767: 'xì',  # 𡝧
    # 0x21768: '',  # 𡝨
    0x21769: 'yāo',  # 𡝩
    # 0x2176A: '',  # 𡝪
    0x2176B: 'chān',  # 𡝫
    # 0x2176C: '',  # 𡝬
    # 0x2176D: '',  # 𡝭
    # 0x2176E: '',  # 𡝮
    # 0x2176F: '',  # 𡝯
    # 0x21770: '',  # 𡝰
    # 0x21771: '',  # 𡝱
    # 0x21772: '',  # 𡝲
    # 0x21773: '',  # 𡝳
    # 0x21774: '',  # 𡝴
    # 0x21775: '',  # 𡝵
    # 0x21776: '',  # 𡝶
    # 0x21777: '',  # 𡝷
    # 0x21778: '',  # 𡝸
    # 0x21779: '',  # 𡝹
    # 0x2177A: '',  # 𡝺
    # 0x2177B: '',  # 𡝻
    # 0x2177C: '',  # 𡝼
    # 0x2177D: '',  # 𡝽
    # 0x2177E: '',  # 𡝾
    # 0x2177F: '',  # 𡝿
    # 0x21780: '',  # 𡞀
    # 0x21781: '',  # 𡞁
    # 0x21782: '',  # 𡞂
    # 0x21783: '',  # 𡞃
    # 0x21784: '',  # 𡞄
    # 0x21785: '',  # 𡞅
    # 0x21786: '',  # 𡞆
    # 0x21787: '',  # 𡞇
    # 0x21788: '',  # 𡞈
    # 0x21789: '',  # 𡞉
    # 0x2178A: '',  # 𡞊
    # 0x2178B: '',  # 𡞋
    # 0x2178C: '',  # 𡞌
    # 0x2178D: '',  # 𡞍
    # 0x2178E: '',  # 𡞎
    0x2178F: 'nài',  # 𡞏
    # 0x21790: '',  # 𡞐
    # 0x21791: '',  # 𡞑
    # 0x21792: '',  # 𡞒
    # 0x21793: '',  # 𡞓
    # 0x21794: '',  # 𡞔
    # 0x21795: '',  # 𡞕
    # 0x21796: '',  # 𡞖
    # 0x21797: '',  # 𡞗
    0x21798: 'xiè',  # 𡞘
    0x21799: 'miè',  # 𡞙
    0x2179A: 'kěng',  # 𡞚
    # 0x2179B: '',  # 𡞛
    0x2179C: 'cù',  # 𡞜
    # 0x2179D: '',  # 𡞝
    0x2179E: 'shěng',  # 𡞞
    0x2179F: 'pàn',  # 𡞟
    0x217A0: 'hù',  # 𡞠
    # 0x217A1: '',  # 𡞡
    0x217A2: 'kè',  # 𡞢
    0x217A3: 'xiàn',  # 𡞣
    # 0x217A4: '',  # 𡞤
    0x217A5: 'hóu',  # 𡞥
    0x217A6: 'qióng',  # 𡞦
    0x217A7: 'zōng',  # 𡞧
    # 0x217A8: '',  # 𡞨
    # 0x217A9: '',  # 𡞩
    0x217AA: 'fú',  # 𡞪
    0x217AB: 'nài',  # 𡞫
    # 0x217AC: '',  # 𡞬
    0x217AD: 'nì',  # 𡞭
    # 0x217AE: '',  # 𡞮
    0x217AF: 'kǔ',  # 𡞯
    # 0x217B0: '',  # 𡞰
    # 0x217B1: '',  # 𡞱
    # 0x217B2: '',  # 𡞲
    # 0x217B3: '',  # 𡞳
    # 0x217B4: '',  # 𡞴
    # 0x217B5: '',  # 𡞵
    # 0x217B6: '',  # 𡞶
    # 0x217B7: '',  # 𡞷
    # 0x217B8: '',  # 𡞸
    # 0x217B9: '',  # 𡞹
    # 0x217BA: '',  # 𡞺
    # 0x217BB: '',  # 𡞻
    # 0x217BC: '',  # 𡞼
    # 0x217BD: '',  # 𡞽
    0x217BE: 'nèn',  # 𡞾
    # 0x217BF: '',  # 𡞿
    # 0x217C0: '',  # 𡟀
    # 0x217C1: '',  # 𡟁
    # 0x217C2: '',  # 𡟂
    # 0x217C3: '',  # 𡟃
    # 0x217C4: '',  # 𡟄
    # 0x217C5: '',  # 𡟅
    # 0x217C6: '',  # 𡟆
    # 0x217C7: '',  # 𡟇
    # 0x217C8: '',  # 𡟈
    # 0x217C9: '',  # 𡟉
    # 0x217CA: '',  # 𡟊
    # 0x217CB: '',  # 𡟋
    # 0x217CC: '',  # 𡟌
    0x217CD: 'gē',  # 𡟍
    # 0x217CE: '',  # 𡟎
    # 0x217CF: '',  # 𡟏
    # 0x217D0: '',  # 𡟐
    0x217D1: 'hóu',  # 𡟑
    # 0x217D2: '',  # 𡟒
    0x217D3: 'āi',  # 𡟓
    # 0x217D4: '',  # 𡟔
    0x217D5: 'shī',  # 𡟕
    # 0x217D6: '',  # 𡟖
    # 0x217D7: '',  # 𡟗
    # 0x217D8: '',  # 𡟘
    # 0x217D9: '',  # 𡟙
    # 0x217DA: '',  # 𡟚
    # 0x217DB: '',  # 𡟛
    # 0x217DC: '',  # 𡟜
    # 0x217DD: '',  # 𡟝
    0x217DE: 'xiū',  # 𡟞
    0x217DF: 'cōng',  # 𡟟
    0x217E0: 'jiāo',  # 𡟠
    # 0x217E1: '',  # 𡟡
    0x217E2: 'zhá',  # 𡟢
    0x217E3: 'xiāo',  # 𡟣
    0x217E4: 'liàn',  # 𡟤
    0x217E5: 'qǔ',  # 𡟥
    # 0x217E6: '',  # 𡟦
    # 0x217E7: '',  # 𡟧
    0x217E8: 'shǎn',  # 𡟨
    0x217E9: 'xiè',  # 𡟩
    # 0x217EA: '',  # 𡟪
    0x217EB: 'gòng',  # 𡟫
    0x217EC: 'miè',  # 𡟬
    0x217ED: 'chái',  # 𡟭
    # 0x217EE: '',  # 𡟮
    0x217EF: 'ēn',  # 𡟯
    0x217F0: 'wǎn',  # 𡟰
    # 0x217F1: '',  # 𡟱
    # 0x217F2: '',  # 𡟲
    0x217F3: 'dòu',  # 𡟳
    # 0x217F4: '',  # 𡟴
    # 0x217F5: '',  # 𡟵
    # 0x217F6: '',  # 𡟶
    # 0x217F7: '',  # 𡟷
    # 0x217F8: '',  # 𡟸
    # 0x217F9: '',  # 𡟹
    # 0x217FA: '',  # 𡟺
    # 0x217FB: '',  # 𡟻
    # 0x217FC: '',  # 𡟼
    # 0x217FD: '',  # 𡟽
    # 0x217FE: '',  # 𡟾
    # 0x217FF: '',  # 𡟿
    # 0x21800: '',  # 𡠀
    # 0x21801: '',  # 𡠁
    # 0x21802: '',  # 𡠂
    # 0x21803: '',  # 𡠃
    # 0x21804: '',  # 𡠄
    # 0x21805: '',  # 𡠅
    0x21806: 'kòu',  # 𡠆
    # 0x21807: '',  # 𡠇
    # 0x21808: '',  # 𡠈
    0x21809: 'lí',  # 𡠉
    0x2180A: 'tiáo',  # 𡠊
    0x2180B: 'shī',  # 𡠋
    # 0x2180C: '',  # 𡠌
    # 0x2180D: '',  # 𡠍
    # 0x2180E: '',  # 𡠎
    0x2180F: 'sāng',  # 𡠏
    # 0x21810: '',  # 𡠐
    # 0x21811: '',  # 𡠑
    0x21812: 'guān',  # 𡠒
    # 0x21813: '',  # 𡠓
    # 0x21814: '',  # 𡠔
    # 0x21815: '',  # 𡠕
    0x21816: 'hào',  # 𡠖
    0x21817: 'zhì',  # 𡠗
    0x21818: 'yàng',  # 𡠘
    0x21819: 'tōng',  # 𡠙
    0x2181A: 'bì',  # 𡠚
    # 0x2181B: '',  # 𡠛
    0x2181C: 'mó,mò',  # 𡠜
    # 0x2181D: '',  # 𡠝
    0x2181E: 'fú',  # 𡠞
    # 0x2181F: '',  # 𡠟
    # 0x21820: '',  # 𡠠
    # 0x21821: '',  # 𡠡
    # 0x21822: '',  # 𡠢
    # 0x21823: '',  # 𡠣
    # 0x21824: '',  # 𡠤
    0x21825: 'qiáng',  # 𡠥
    # 0x21826: '',  # 𡠦
    # 0x21827: '',  # 𡠧
    # 0x21828: '',  # 𡠨
    # 0x21829: '',  # 𡠩
    # 0x2182A: '',  # 𡠪
    # 0x2182B: '',  # 𡠫
    # 0x2182C: '',  # 𡠬
    # 0x2182D: '',  # 𡠭
    # 0x2182E: '',  # 𡠮
    # 0x2182F: '',  # 𡠯
    # 0x21830: '',  # 𡠰
    # 0x21831: '',  # 𡠱
    # 0x21832: '',  # 𡠲
    # 0x21833: '',  # 𡠳
    # 0x21834: '',  # 𡠴
    # 0x21835: '',  # 𡠵
    # 0x21836: '',  # 𡠶
    # 0x21837: '',  # 𡠷
    # 0x21838: '',  # 𡠸
    0x21839: 'zhì',  # 𡠹
    # 0x2183A: '',  # 𡠺
    # 0x2183B: '',  # 𡠻
    0x2183C: 'sōu',  # 𡠼
    # 0x2183D: '',  # 𡠽
    # 0x2183E: '',  # 𡠾
    0x2183F: 'niǎo',  # 𡠿
    0x21840: 'juàn',  # 𡡀
    # 0x21841: '',  # 𡡁
    0x21842: 'yàng',  # 𡡂
    # 0x21843: '',  # 𡡃
    0x21844: 'huāng',  # 𡡄
    # 0x21845: '',  # 𡡅
    # 0x21846: '',  # 𡡆
    # 0x21847: '',  # 𡡇
    0x21848: 'bēng',  # 𡡈
    0x21849: 'mó',  # 𡡉
    0x2184A: 'cháo',  # 𡡊
    # 0x2184B: '',  # 𡡋
    # 0x2184C: '',  # 𡡌
    # 0x2184D: '',  # 𡡍
    0x2184E: 'lǚ,lóu',  # 𡡎
    0x2184F: 'shāo',  # 𡡏
    0x21850: 'bǔ',  # 𡡐
    0x21851: 'zēng',  # 𡡑
    0x21852: 'sī,xī',  # 𡡒
    0x21853: 'xū',  # 𡡓
    0x21854: 'zuì',  # 𡡔
    0x21855: 'yuē',  # 𡡕
    0x21856: 'zān,cān',  # 𡡖
    0x21857: 'luǎn,luàn',  # 𡡗
    # 0x21858: '',  # 𡡘
    # 0x21859: '',  # 𡡙
    # 0x2185A: '',  # 𡡚
    # 0x2185B: '',  # 𡡛
    # 0x2185C: '',  # 𡡜
    # 0x2185D: '',  # 𡡝
    # 0x2185E: '',  # 𡡞
    # 0x2185F: '',  # 𡡟
    # 0x21860: '',  # 𡡠
    # 0x21861: '',  # 𡡡
    # 0x21862: '',  # 𡡢
    # 0x21863: '',  # 𡡣
    # 0x21864: '',  # 𡡤
    0x21865: 'qú',  # 𡡥
    # 0x21866: '',  # 𡡦
    # 0x21867: '',  # 𡡧
    # 0x21868: '',  # 𡡨
    # 0x21869: '',  # 𡡩
    # 0x2186A: '',  # 𡡪
    # 0x2186B: '',  # 𡡫
    # 0x2186C: '',  # 𡡬
    # 0x2186D: '',  # 𡡭
    # 0x2186E: '',  # 𡡮
    # 0x2186F: '',  # 𡡯
    # 0x21870: '',  # 𡡰
    # 0x21871: '',  # 𡡱
    # 0x21872: '',  # 𡡲
    # 0x21873: '',  # 𡡳
    # 0x21874: '',  # 𡡴
    # 0x21875: '',  # 𡡵
    # 0x21876: '',  # 𡡶
    # 0x21877: '',  # 𡡷
    # 0x21878: '',  # 𡡸
    # 0x21879: '',  # 𡡹
    0x2187A: 'miǎo',  # 𡡺
    # 0x2187B: '',  # 𡡻
    # 0x2187C: '',  # 𡡼
    # 0x2187D: '',  # 𡡽
    # 0x2187E: '',  # 𡡾
    # 0x2187F: '',  # 𡡿
    0x21880: 'zhuàn',  # 𡢀
    # 0x21881: '',  # 𡢁
    # 0x21882: '',  # 𡢂
    # 0x21883: '',  # 𡢃
    # 0x21884: '',  # 𡢄
    # 0x21885: '',  # 𡢅
    # 0x21886: '',  # 𡢆
    # 0x21887: '',  # 𡢇
    0x21888: 'dàng',  # 𡢈
    # 0x21889: '',  # 𡢉
    0x2188A: 'yuān',  # 𡢊
    # 0x2188B: '',  # 𡢋
    # 0x2188C: '',  # 𡢌
    # 0x2188D: '',  # 𡢍
    0x2188E: 'fàn',  # 𡢎
    # 0x2188F: '',  # 𡢏
    # 0x21890: '',  # 𡢐
    # 0x21891: '',  # 𡢑
    0x21892: 'jǔ',  # 𡢒
    # 0x21893: '',  # 𡢓
    # 0x21894: '',  # 𡢔
    0x21895: 'huǐ',  # 𡢕
    0x21896: 'qì',  # 𡢖
    # 0x21897: '',  # 𡢗
    0x21898: 'yùn,yíng',  # 𡢘
    # 0x21899: '',  # 𡢙
    0x2189A: 'màn',  # 𡢚
    # 0x2189B: '',  # 𡢛
    0x2189C: 'mǒ',  # 𡢜
    # 0x2189D: '',  # 𡢝
    # 0x2189E: '',  # 𡢞
    # 0x2189F: '',  # 𡢟
    # 0x218A0: '',  # 𡢠
    # 0x218A1: '',  # 𡢡
    # 0x218A2: '',  # 𡢢
    # 0x218A3: '',  # 𡢣
    # 0x218A4: '',  # 𡢤
    # 0x218A5: '',  # 𡢥
    # 0x218A6: '',  # 𡢦
    # 0x218A7: '',  # 𡢧
    # 0x218A8: '',  # 𡢨
    # 0x218A9: '',  # 𡢩
    # 0x218AA: '',  # 𡢪
    # 0x218AB: '',  # 𡢫
    # 0x218AC: '',  # 𡢬
    # 0x218AD: '',  # 𡢭
    # 0x218AE: '',  # 𡢮
    # 0x218AF: '',  # 𡢯
    # 0x218B0: '',  # 𡢰
    0x218B1: 'piāo',  # 𡢱
    # 0x218B2: '',  # 𡢲
    0x218B3: 'jìn',  # 𡢳
    # 0x218B4: '',  # 𡢴
    # 0x218B5: '',  # 𡢵
    # 0x218B6: '',  # 𡢶
    # 0x218B7: '',  # 𡢷
    # 0x218B8: '',  # 𡢸
    0x218B9: 'yāo',  # 𡢹
    # 0x218BA: '',  # 𡢺
    # 0x218BB: '',  # 𡢻
    # 0x218BC: '',  # 𡢼
    # 0x218BD: '',  # 𡢽
    # 0x218BE: '',  # 𡢾
    # 0x218BF: '',  # 𡢿
    0x218C0: 'chì',  # 𡣀
    0x218C1: 'nì',  # 𡣁
    0x218C2: 'sōu',  # 𡣂
    # 0x218C3: '',  # 𡣃
    # 0x218C4: '',  # 𡣄
    # 0x218C5: '',  # 𡣅
    # 0x218C6: '',  # 𡣆
    # 0x218C7: '',  # 𡣇
    0x218C8: 'shù',  # 𡣈
    # 0x218C9: '',  # 𡣉
    # 0x218CA: '',  # 𡣊
    0x218CB: 'piāo',  # 𡣋
    # 0x218CC: '',  # 𡣌
    # 0x218CD: '',  # 𡣍
    # 0x218CE: '',  # 𡣎
    # 0x218CF: '',  # 𡣏
    # 0x218D0: '',  # 𡣐
    # 0x218D1: '',  # 𡣑
    # 0x218D2: '',  # 𡣒
    # 0x218D3: '',  # 𡣓
    0x218D4: 'hàn',  # 𡣔
    0x218D5: 'pín',  # 𡣕
    # 0x218D6: '',  # 𡣖
    # 0x218D7: '',  # 𡣗
    # 0x218D8: '',  # 𡣘
    # 0x218D9: '',  # 𡣙
    # 0x218DA: '',  # 𡣚
    # 0x218DB: '',  # 𡣛
    # 0x218DC: '',  # 𡣜
    # 0x218DD: '',  # 𡣝
    # 0x218DE: '',  # 𡣞
    # 0x218DF: '',  # 𡣟
    0x218E0: 'yāo',  # 𡣠
    # 0x218E1: '',  # 𡣡
    0x218E2: 'néi',  # 𡣢
    # 0x218E3: '',  # 𡣣
    # 0x218E4: '',  # 𡣤
    # 0x218E5: '',  # 𡣥
    # 0x218E6: '',  # 𡣦
    # 0x218E7: '',  # 𡣧
    # 0x218E8: '',  # 𡣨
    # 0x218E9: '',  # 𡣩
    0x218EA: 'shì',  # 𡣪
    # 0x218EB: '',  # 𡣫
    0x218EC: 'yuān',  # 𡣬
    # 0x218ED: '',  # 𡣭
    0x218EE: 'cài',  # 𡣮
    0x218EF: 'jié',  # 𡣯
    # 0x218F0: '',  # 𡣰
    # 0x218F1: '',  # 𡣱
    # 0x218F2: '',  # 𡣲
    # 0x218F3: '',  # 𡣳
    # 0x218F4: '',  # 𡣴
    # 0x218F5: '',  # 𡣵
    # 0x218F6: '',  # 𡣶
    # 0x218F7: '',  # 𡣷
    # 0x218F8: '',  # 𡣸
    0x218F9: 'xiè',  # 𡣹
    # 0x218FA: '',  # 𡣺
    # 0x218FB: '',  # 𡣻
    # 0x218FC: '',  # 𡣼
    0x218FD: 'yán',  # 𡣽
    0x218FE: 'xiāo',  # 𡣾
    # 0x218FF: '',  # 𡣿
    # 0x21900: '',  # 𡤀
    # 0x21901: '',  # 𡤁
    # 0x21902: '',  # 𡤂
    # 0x21903: '',  # 𡤃
    # 0x21904: '',  # 𡤄
    # 0x21905: '',  # 𡤅
    # 0x21906: '',  # 𡤆
    # 0x21907: '',  # 𡤇
    # 0x21908: '',  # 𡤈
    # 0x21909: '',  # 𡤉
    # 0x2190A: '',  # 𡤊
    0x2190B: 'xiè',  # 𡤋
    0x2190C: 'lì',  # 𡤌
    # 0x2190D: '',  # 𡤍
    0x2190E: 'fàn',  # 𡤎
    # 0x2190F: '',  # 𡤏
    # 0x21910: '',  # 𡤐
    # 0x21911: '',  # 𡤑
    # 0x21912: '',  # 𡤒
    # 0x21913: '',  # 𡤓
    # 0x21914: '',  # 𡤔
    # 0x21915: '',  # 𡤕
    # 0x21916: '',  # 𡤖
    0x21917: 'zhù',  # 𡤗
    # 0x21918: '',  # 𡤘
    0x21919: 'nà',  # 𡤙
    # 0x2191A: '',  # 𡤚
    0x2191B: 'zhuǎn',  # 𡤛
    # 0x2191C: '',  # 𡤜
    # 0x2191D: '',  # 𡤝
    0x2191E: 'kuī',  # 𡤞
    # 0x2191F: '',  # 𡤟
    # 0x21920: '',  # 𡤠
    # 0x21921: '',  # 𡤡
    0x21922: 'luó',  # 𡤢
    # 0x21923: '',  # 𡤣
    # 0x21924: '',  # 𡤤
    # 0x21925: '',  # 𡤥
    # 0x21926: '',  # 𡤦
    # 0x21927: '',  # 𡤧
    # 0x21928: '',  # 𡤨
    # 0x21929: '',  # 𡤩
    # 0x2192A: '',  # 𡤪
    0x2192B: 'qiā',  # 𡤫
    # 0x2192C: '',  # 𡤬
    # 0x2192D: '',  # 𡤭
    # 0x2192E: '',  # 𡤮
    # 0x2192F: '',  # 𡤯
    # 0x21930: '',  # 𡤰
    # 0x21931: '',  # 𡤱
    # 0x21932: '',  # 𡤲
    # 0x21933: '',  # 𡤳
    # 0x21934: '',  # 𡤴
    # 0x21935: '',  # 𡤵
    0x21936: 'wān',  # 𡤶
    # 0x21937: '',  # 𡤷
    # 0x21938: '',  # 𡤸
    # 0x21939: '',  # 𡤹
    # 0x2193A: '',  # 𡤺
    # 0x2193B: '',  # 𡤻
    # 0x2193C: '',  # 𡤼
    0x2193D: 'shǔ',  # 𡤽
    # 0x2193E: '',  # 𡤾
    0x2193F: 'chèng,kǒng',  # 𡤿
    # 0x21940: '',  # 𡥀
    0x21941: 'yì',  # 𡥁
    # 0x21942: '',  # 𡥂
    # 0x21943: '',  # 𡥃
    # 0x21944: '',  # 𡥄
    # 0x21945: '',  # 𡥅
    0x21946: 'hǎo,hào',  # 𡥆
    # 0x21947: '',  # 𡥇
    0x21948: 'jiào',  # 𡥈
    # 0x21949: '',  # 𡥉
    # 0x2194A: '',  # 𡥊
    0x2194B: 'huì',  # 𡥋
    # 0x2194C: '',  # 𡥌
    0x2194D: 'xiào',  # 𡥍
    0x2194E: 'cí,zǐ',  # 𡥎
    # 0x2194F: '',  # 𡥏
    # 0x21950: '',  # 𡥐
    # 0x21951: '',  # 𡥑
    # 0x21952: '',  # 𡥒
    # 0x21953: '',  # 𡥓
    # 0x21954: '',  # 𡥔
    # 0x21955: '',  # 𡥕
    # 0x21956: '',  # 𡥖
    # 0x21957: '',  # 𡥗
    0x21958: 'chuā',  # 𡥘
    # 0x21959: '',  # 𡥙
    # 0x2195A: '',  # 𡥚
    # 0x2195B: '',  # 𡥛
    # 0x2195C: '',  # 𡥜
    # 0x2195D: '',  # 𡥝
    0x2195E: 'jì,bèi',  # 𡥞
    # 0x2195F: '',  # 𡥟
    # 0x21960: '',  # 𡥠
    # 0x21961: '',  # 𡥡
    # 0x21962: '',  # 𡥢
    # 0x21963: '',  # 𡥣
    # 0x21964: '',  # 𡥤
    # 0x21965: '',  # 𡥥
    0x21966: 'nǐ,jìn',  # 𡥦
    0x21967: 'jìn',  # 𡥧
    0x21968: 'nǐ,jìn',  # 𡥨
    0x21969: 'tǐ',  # 𡥩
    # 0x2196A: '',  # 𡥪
    # 0x2196B: '',  # 𡥫
    # 0x2196C: '',  # 𡥬
    # 0x2196D: '',  # 𡥭
    # 0x2196E: '',  # 𡥮
    # 0x2196F: '',  # 𡥯
    # 0x21970: '',  # 𡥰
    # 0x21971: '',  # 𡥱
    # 0x21972: '',  # 𡥲
    # 0x21973: '',  # 𡥳
    # 0x21974: '',  # 𡥴
    # 0x21975: '',  # 𡥵
    0x21976: 'jù,rú',  # 𡥶
    # 0x21977: '',  # 𡥷
    0x21978: 'mìng',  # 𡥸
    # 0x21979: '',  # 𡥹
    # 0x2197A: '',  # 𡥺
    # 0x2197B: '',  # 𡥻
    # 0x2197C: '',  # 𡥼
    0x2197D: 'lí',  # 𡥽
    # 0x2197E: '',  # 𡥾
    0x2197F: 'zhòng',  # 𡥿
    # 0x21980: '',  # 𡦀
    0x21981: 'xù',  # 𡦁
    # 0x21982: '',  # 𡦂
    0x21983: 'qióng',  # 𡦃
    0x21984: 'fú',  # 𡦄
    # 0x21985: '',  # 𡦅
    0x21986: 'bìn',  # 𡦆
    # 0x21987: '',  # 𡦇
    # 0x21988: '',  # 𡦈
    # 0x21989: '',  # 𡦉
    0x2198A: 'jì',  # 𡦊
    # 0x2198B: '',  # 𡦋
    # 0x2198C: '',  # 𡦌
    0x2198D: 'qí',  # 𡦍
    0x2198E: 'xì',  # 𡦎
    # 0x2198F: '',  # 𡦏
    # 0x21990: '',  # 𡦐
    # 0x21991: '',  # 𡦑
    # 0x21992: '',  # 𡦒
    # 0x21993: '',  # 𡦓
    0x21994: 'dèng',  # 𡦔
    0x21995: 'ér',  # 𡦕
    # 0x21996: '',  # 𡦖
    # 0x21997: '',  # 𡦗
    # 0x21998: '',  # 𡦘
    # 0x21999: '',  # 𡦙
    # 0x2199A: '',  # 𡦚
    0x2199B: 'shú',  # 𡦛
    0x2199C: 'tóng',  # 𡦜
    0x2199D: 'xiáo',  # 𡦝
    # 0x2199E: '',  # 𡦞
    0x2199F: 'pí',  # 𡦟
    # 0x219A0: '',  # 𡦠
    # 0x219A1: '',  # 𡦡
    # 0x219A2: '',  # 𡦢
    # 0x219A3: '',  # 𡦣
    # 0x219A4: '',  # 𡦤
    # 0x219A5: '',  # 𡦥
    # 0x219A6: '',  # 𡦦
    # 0x219A7: '',  # 𡦧
    0x219A8: 'dǎn',  # 𡦨
    # 0x219A9: '',  # 𡦩
    0x219AA: 'jí',  # 𡦪
    # 0x219AB: '',  # 𡦫
    # 0x219AC: '',  # 𡦬
    # 0x219AD: '',  # 𡦭
    # 0x219AE: '',  # 𡦮
    # 0x219AF: '',  # 𡦯
    # 0x219B0: '',  # 𡦰
    # 0x219B1: '',  # 𡦱
    # 0x219B2: '',  # 𡦲
    0x219B3: 'xiào',  # 𡦳
    # 0x219B4: '',  # 𡦴
    # 0x219B5: '',  # 𡦵
    # 0x219B6: '',  # 𡦶
    0x219B7: 'cóng',  # 𡦷
    # 0x219B8: '',  # 𡦸
    0x219B9: 'guān',  # 𡦹
    # 0x219BA: '',  # 𡦺
    0x219BB: 'bīn',  # 𡦻
    0x219BC: 'rǒng',  # 𡦼
    # 0x219BD: '',  # 𡦽
    # 0x219BE: '',  # 𡦾
    # 0x219BF: '',  # 𡦿
    # 0x219C0: '',  # 𡧀
    # 0x219C1: '',  # 𡧁
    # 0x219C2: '',  # 𡧂
    # 0x219C3: '',  # 𡧃
    # 0x219C4: '',  # 𡧄
    # 0x219C5: '',  # 𡧅
    # 0x219C6: '',  # 𡧆
    # 0x219C7: '',  # 𡧇
    # 0x219C8: '',  # 𡧈
    # 0x219C9: '',  # 𡧉
    # 0x219CA: '',  # 𡧊
    # 0x219CB: '',  # 𡧋
    # 0x219CC: '',  # 𡧌
    0x219CD: 'miàn,bīn',  # 𡧍
    # 0x219CE: '',  # 𡧎
    # 0x219CF: '',  # 𡧏
    # 0x219D0: '',  # 𡧐
    # 0x219D1: '',  # 𡧑
    0x219D2: 'miàn',  # 𡧒
    # 0x219D3: '',  # 𡧓
    0x219D4: 'shū',  # 𡧔
    0x219D5: 'xiáo,shǒu',  # 𡧕
    0x219D6: 'bǎo',  # 𡧖
    0x219D7: 'wà',  # 𡧗
    # 0x219D8: '',  # 𡧘
    0x219D9: 'pào',  # 𡧙
    # 0x219DA: '',  # 𡧚
    # 0x219DB: '',  # 𡧛
    # 0x219DC: '',  # 𡧜
    # 0x219DD: '',  # 𡧝
    # 0x219DE: '',  # 𡧞
    # 0x219DF: '',  # 𡧟
    # 0x219E0: '',  # 𡧠
    # 0x219E1: '',  # 𡧡
    # 0x219E2: '',  # 𡧢
    0x219E3: 'gǎi',  # 𡧣
    # 0x219E4: '',  # 𡧤
    0x219E5: 'hū',  # 𡧥
    0x219E6: 'héng',  # 𡧦
    # 0x219E7: '',  # 𡧧
    0x219E8: 'zhú',  # 𡧨
    0x219E9: 'guāi',  # 𡧩
    # 0x219EA: '',  # 𡧪
    # 0x219EB: '',  # 𡧫
    # 0x219EC: '',  # 𡧬
    0x219ED: 'guì,guǐ',  # 𡧭
    0x219EE: 'yǎo',  # 𡧮
    0x219EF: 'jì',  # 𡧯
    # 0x219F0: '',  # 𡧰
    0x219F1: 'hài',  # 𡧱
    # 0x219F2: '',  # 𡧲
    # 0x219F3: '',  # 𡧳
    # 0x219F4: '',  # 𡧴
    # 0x219F5: '',  # 𡧵
    # 0x219F6: '',  # 𡧶
    # 0x219F7: '',  # 𡧷
    # 0x219F8: '',  # 𡧸
    0x219F9: 'dài',  # 𡧹
    # 0x219FA: '',  # 𡧺
    # 0x219FB: '',  # 𡧻
    0x219FC: 'bīn',  # 𡧼
    0x219FD: 'huǎng,huāng',  # 𡧽
    # 0x219FE: '',  # 𡧾
    # 0x219FF: '',  # 𡧿
    0x21A00: 'chá',  # 𡨀
    # 0x21A01: '',  # 𡨁
    0x21A02: 'wù',  # 𡨂
    # 0x21A03: '',  # 𡨃
    0x21A04: 'xià,sāi',  # 𡨄
    0x21A05: 'jú',  # 𡨅
    # 0x21A06: '',  # 𡨆
    0x21A07: 'yǎo,xiǎng',  # 𡨇
    # 0x21A08: '',  # 𡨈
    # 0x21A09: '',  # 𡨉
    # 0x21A0A: '',  # 𡨊
    # 0x21A0B: '',  # 𡨋
    # 0x21A0C: '',  # 𡨌
    # 0x21A0D: '',  # 𡨍
    # 0x21A0E: '',  # 𡨎
    # 0x21A0F: '',  # 𡨏
    # 0x21A10: '',  # 𡨐
    # 0x21A11: '',  # 𡨑
    # 0x21A12: '',  # 𡨒
    # 0x21A13: '',  # 𡨓
    # 0x21A14: '',  # 𡨔
    # 0x21A15: '',  # 𡨕
    0x21A16: 'fěn',  # 𡨖
    0x21A17: 'zào',  # 𡨗
    # 0x21A18: '',  # 𡨘
    # 0x21A19: '',  # 𡨙
    # 0x21A1A: '',  # 𡨚
    0x21A1B: 'fēng',  # 𡨛
    0x21A1C: 'jì',  # 𡨜
    # 0x21A1D: '',  # 𡨝
    # 0x21A1E: '',  # 𡨞
    # 0x21A1F: '',  # 𡨟
    # 0x21A20: '',  # 𡨠
    # 0x21A21: '',  # 𡨡
    0x21A22: 'jū',  # 𡨢
    0x21A23: 'yù',  # 𡨣
    # 0x21A24: '',  # 𡨤
    # 0x21A25: '',  # 𡨥
    # 0x21A26: '',  # 𡨦
    0x21A27: 'zǎi',  # 𡨧
    # 0x21A28: '',  # 𡨨
    0x21A29: 'hūn',  # 𡨩
    # 0x21A2A: '',  # 𡨪
    # 0x21A2B: '',  # 𡨫
    # 0x21A2C: '',  # 𡨬
    # 0x21A2D: '',  # 𡨭
    # 0x21A2E: '',  # 𡨮
    # 0x21A2F: '',  # 𡨯
    # 0x21A30: '',  # 𡨰
    # 0x21A31: '',  # 𡨱
    0x21A32: 'jié',  # 𡨲
    0x21A33: 'xiòng,hùn',  # 𡨳
    # 0x21A34: '',  # 𡨴
    0x21A35: 'nài',  # 𡨵
    # 0x21A36: '',  # 𡨶
    # 0x21A37: '',  # 𡨷
    # 0x21A38: '',  # 𡨸
    # 0x21A39: '',  # 𡨹
    # 0x21A3A: '',  # 𡨺
    0x21A3B: 'nǒu',  # 𡨻
    # 0x21A3C: '',  # 𡨼
    0x21A3D: 'shěng',  # 𡨽
    # 0x21A3E: '',  # 𡨾
    0x21A3F: 'yù',  # 𡨿
    # 0x21A40: '',  # 𡩀
    # 0x21A41: '',  # 𡩁
    0x21A42: 'huán',  # 𡩂
    0x21A43: 'gěng',  # 𡩃
    0x21A44: 'wǎn',  # 𡩄
    # 0x21A45: '',  # 𡩅
    0x21A46: 'tuó',  # 𡩆
    0x21A47: 'qiāo',  # 𡩇
    # 0x21A48: '',  # 𡩈
    # 0x21A49: '',  # 𡩉
    # 0x21A4A: '',  # 𡩊
    # 0x21A4B: '',  # 𡩋
    # 0x21A4C: '',  # 𡩌
    # 0x21A4D: '',  # 𡩍
    # 0x21A4E: '',  # 𡩎
    # 0x21A4F: '',  # 𡩏
    # 0x21A50: '',  # 𡩐
    # 0x21A51: '',  # 𡩑
    # 0x21A52: '',  # 𡩒
    # 0x21A53: '',  # 𡩓
    # 0x21A54: '',  # 𡩔
    # 0x21A55: '',  # 𡩕
    # 0x21A56: '',  # 𡩖
    # 0x21A57: '',  # 𡩗
    0x21A58: 'yìn',  # 𡩘
    # 0x21A59: '',  # 𡩙
    0x21A5A: 'jiā,zhuàn',  # 𡩚
    # 0x21A5B: '',  # 𡩛
    # 0x21A5C: '',  # 𡩜
    # 0x21A5D: '',  # 𡩝
    # 0x21A5E: '',  # 𡩞
    # 0x21A5F: '',  # 𡩟
    # 0x21A60: '',  # 𡩠
    0x21A61: 'suǒ',  # 𡩡
    # 0x21A62: '',  # 𡩢
    0x21A63: 'jié',  # 𡩣
    0x21A64: 'xī',  # 𡩤
    0x21A65: 'wěng',  # 𡩥
    # 0x21A66: '',  # 𡩦
    # 0x21A67: '',  # 𡩧
    # 0x21A68: '',  # 𡩨
    0x21A69: 'máng',  # 𡩩
    # 0x21A6A: '',  # 𡩪
    # 0x21A6B: '',  # 𡩫
    # 0x21A6C: '',  # 𡩬
    # 0x21A6D: '',  # 𡩭
    # 0x21A6E: '',  # 𡩮
    # 0x21A6F: '',  # 𡩯
    # 0x21A70: '',  # 𡩰
    # 0x21A71: '',  # 𡩱
    # 0x21A72: '',  # 𡩲
    # 0x21A73: '',  # 𡩳
    # 0x21A74: '',  # 𡩴
    # 0x21A75: '',  # 𡩵
    0x21A76: 'yáng',  # 𡩶
    # 0x21A77: '',  # 𡩷
    0x21A78: 'yáo',  # 𡩸
    # 0x21A79: '',  # 𡩹
    # 0x21A7A: '',  # 𡩺
    # 0x21A7B: '',  # 𡩻
    # 0x21A7C: '',  # 𡩼
    0x21A7D: 'máng',  # 𡩽
    0x21A7E: 'ōu',  # 𡩾
    # 0x21A7F: '',  # 𡩿
    # 0x21A80: '',  # 𡪀
    0x21A81: 'án',  # 𡪁
    # 0x21A82: '',  # 𡪂
    # 0x21A83: '',  # 𡪃
    # 0x21A84: '',  # 𡪄
    0x21A85: 'lòu',  # 𡪅
    # 0x21A86: '',  # 𡪆
    # 0x21A87: '',  # 𡪇
    # 0x21A88: '',  # 𡪈
    # 0x21A89: '',  # 𡪉
    # 0x21A8A: '',  # 𡪊
    # 0x21A8B: '',  # 𡪋
    # 0x21A8C: '',  # 𡪌
    # 0x21A8D: '',  # 𡪍
    # 0x21A8E: '',  # 𡪎
    # 0x21A8F: '',  # 𡪏
    0x21A90: 'diàn',  # 𡪐
    0x21A91: 'è',  # 𡪑
    0x21A92: 'zǐ',  # 𡪒
    # 0x21A93: '',  # 𡪓
    # 0x21A94: '',  # 𡪔
    # 0x21A95: '',  # 𡪕
    # 0x21A96: '',  # 𡪖
    0x21A97: 'è',  # 𡪗
    # 0x21A98: '',  # 𡪘
    0x21A99: 'àn',  # 𡪙
    # 0x21A9A: '',  # 𡪚
    # 0x21A9B: '',  # 𡪛
    # 0x21A9C: '',  # 𡪜
    # 0x21A9D: '',  # 𡪝
    0x21A9E: 'huò',  # 𡪞
    # 0x21A9F: '',  # 𡪟
    0x21AA0: 'céng',  # 𡪠
    # 0x21AA1: '',  # 𡪡
    # 0x21AA2: '',  # 𡪢
    # 0x21AA3: '',  # 𡪣
    # 0x21AA4: '',  # 𡪤
    # 0x21AA5: '',  # 𡪥
    # 0x21AA6: '',  # 𡪦
    # 0x21AA7: '',  # 𡪧
    # 0x21AA8: '',  # 𡪨
    # 0x21AA9: '',  # 𡪩
    # 0x21AAA: '',  # 𡪪
    # 0x21AAB: '',  # 𡪫
    # 0x21AAC: '',  # 𡪬
    # 0x21AAD: '',  # 𡪭
    # 0x21AAE: '',  # 𡪮
    # 0x21AAF: '',  # 𡪯
    0x21AB0: 'xiòng',  # 𡪰
    0x21AB1: 'jì',  # 𡪱
    # 0x21AB2: '',  # 𡪲
    0x21AB3: 'zuó',  # 𡪳
    # 0x21AB4: '',  # 𡪴
    0x21AB5: 'qí',  # 𡪵
    # 0x21AB6: '',  # 𡪶
    # 0x21AB7: '',  # 𡪷
    # 0x21AB8: '',  # 𡪸
    0x21AB9: 'liáo',  # 𡪹
    0x21ABA: 'zhēng',  # 𡪺
    # 0x21ABB: '',  # 𡪻
    # 0x21ABC: '',  # 𡪼
    # 0x21ABD: '',  # 𡪽
    # 0x21ABE: '',  # 𡪾
    # 0x21ABF: '',  # 𡪿
    0x21AC0: 'jī',  # 𡫀
    0x21AC1: 'qī,chèn',  # 𡫁
    0x21AC2: 'juǎn',  # 𡫂
    0x21AC3: 'níng',  # 𡫃
    # 0x21AC4: '',  # 𡫄
    # 0x21AC5: '',  # 𡫅
    # 0x21AC6: '',  # 𡫆
    # 0x21AC7: '',  # 𡫇
    # 0x21AC8: '',  # 𡫈
    # 0x21AC9: '',  # 𡫉
    # 0x21ACA: '',  # 𡫊
    # 0x21ACB: '',  # 𡫋
    # 0x21ACC: '',  # 𡫌
    # 0x21ACD: '',  # 𡫍
    # 0x21ACE: '',  # 𡫎
    # 0x21ACF: '',  # 𡫏
    # 0x21AD0: '',  # 𡫐
    # 0x21AD1: '',  # 𡫑
    # 0x21AD2: '',  # 𡫒
    # 0x21AD3: '',  # 𡫓
    # 0x21AD4: '',  # 𡫔
    # 0x21AD5: '',  # 𡫕
    # 0x21AD6: '',  # 𡫖
    # 0x21AD7: '',  # 𡫗
    # 0x21AD8: '',  # 𡫘
    # 0x21AD9: '',  # 𡫙
    # 0x21ADA: '',  # 𡫚
    0x21ADB: 'mián',  # 𡫛
    # 0x21ADC: '',  # 𡫜
    # 0x21ADD: '',  # 𡫝
    # 0x21ADE: '',  # 𡫞
    0x21ADF: 'sè',  # 𡫟
    # 0x21AE0: '',  # 𡫠
    # 0x21AE1: '',  # 𡫡
    # 0x21AE2: '',  # 𡫢
    # 0x21AE3: '',  # 𡫣
    # 0x21AE4: '',  # 𡫤
    0x21AE5: 'hè',  # 𡫥
    0x21AE6: 'rǒng',  # 𡫦
    0x21AE7: 'qǐn',  # 𡫧
    # 0x21AE8: '',  # 𡫨
    # 0x21AE9: '',  # 𡫩
    # 0x21AEA: '',  # 𡫪
    # 0x21AEB: '',  # 𡫫
    0x21AEC: 'jū',  # 𡫬
    # 0x21AED: '',  # 𡫭
    # 0x21AEE: '',  # 𡫮
    0x21AEF: 'lì',  # 𡫯
    # 0x21AF0: '',  # 𡫰
    # 0x21AF1: '',  # 𡫱
    # 0x21AF2: '',  # 𡫲
    0x21AF3: 'sè',  # 𡫳
    # 0x21AF4: '',  # 𡫴
    0x21AF5: 'shí',  # 𡫵
    # 0x21AF6: '',  # 𡫶
    # 0x21AF7: '',  # 𡫷
    0x21AF8: 'nì',  # 𡫸
    0x21AF9: 'xián',  # 𡫹
    0x21AFA: 'fū',  # 𡫺
    # 0x21AFB: '',  # 𡫻
    # 0x21AFC: '',  # 𡫼
    0x21AFD: 'rǔ,yù',  # 𡫽
    # 0x21AFE: '',  # 𡫾
    # 0x21AFF: '',  # 𡫿
    # 0x21B00: '',  # 𡬀
    0x21B01: 'xiòng',  # 𡬁
    0x21B02: 'guì',  # 𡬂
    # 0x21B03: '',  # 𡬃
    0x21B04: 'jì',  # 𡬄
    # 0x21B05: '',  # 𡬅
    0x21B06: 'měng,mèng',  # 𡬆
    0x21B07: 'fū',  # 𡬇
    # 0x21B08: '',  # 𡬈
    0x21B09: 'sài',  # 𡬉
    0x21B0A: 'yù',  # 𡬊
    0x21B0B: 'jiào',  # 𡬋
    0x21B0C: 'mèng',  # 𡬌
    0x21B0D: 'lóng',  # 𡬍
    0x21B0E: 'qiāng',  # 𡬎
    # 0x21B0F: '',  # 𡬏
    0x21B10: 'mí,mǐ',  # 𡬐
    # 0x21B11: '',  # 𡬑
    # 0x21B12: '',  # 𡬒
    0x21B13: 'yí',  # 𡬓
    # 0x21B14: '',  # 𡬔
    # 0x21B15: '',  # 𡬕
    0x21B16: 'hān',  # 𡬖
    0x21B17: 'nì',  # 𡬗
    0x21B18: 'lào',  # 𡬘
    0x21B19: 'sèng',  # 𡬙
    # 0x21B1A: '',  # 𡬚
    # 0x21B1B: '',  # 𡬛
    0x21B1C: 'lǐn',  # 𡬜
    # 0x21B1D: '',  # 𡬝
    0x21B1E: 'yù',  # 𡬞
    # 0x21B1F: '',  # 𡬟
    # 0x21B20: '',  # 𡬠
    # 0x21B21: '',  # 𡬡
    # 0x21B22: '',  # 𡬢
    # 0x21B23: '',  # 𡬣
    # 0x21B24: '',  # 𡬤
    0x21B25: 'nuó',  # 𡬥
    # 0x21B26: '',  # 𡬦
    # 0x21B27: '',  # 𡬧
    # 0x21B28: '',  # 𡬨
    # 0x21B29: '',  # 𡬩
    # 0x21B2A: '',  # 𡬪
    0x21B2B: 'wù',  # 𡬫
    # 0x21B2C: '',  # 𡬬
    # 0x21B2D: '',  # 𡬭
    # 0x21B2E: '',  # 𡬮
    0x21B2F: 'biǎn',  # 𡬯
    # 0x21B30: '',  # 𡬰
    # 0x21B31: '',  # 𡬱
    0x21B32: 'biǎn',  # 𡬲
    0x21B33: 'xuān,shòu',  # 𡬳
    # 0x21B34: '',  # 𡬴
    0x21B35: 'jiān',  # 𡬵
    # 0x21B36: '',  # 𡬶
    # 0x21B37: '',  # 𡬷
    0x21B38: 'biǎn',  # 𡬸
    # 0x21B39: '',  # 𡬹
    # 0x21B3A: '',  # 𡬺
    # 0x21B3B: '',  # 𡬻
    # 0x21B3C: '',  # 𡬼
    # 0x21B3D: '',  # 𡬽
    # 0x21B3E: '',  # 𡬾
    # 0x21B3F: '',  # 𡬿
    # 0x21B40: '',  # 𡭀
    # 0x21B41: '',  # 𡭁
    0x21B42: 'dé',  # 𡭂
    # 0x21B43: '',  # 𡭃
    # 0x21B44: '',  # 𡭄
    # 0x21B45: '',  # 𡭅
    # 0x21B46: '',  # 𡭆
    0x21B47: 'zhuān',  # 𡭇
    # 0x21B48: '',  # 𡭈
    # 0x21B49: '',  # 𡭉
    # 0x21B4A: '',  # 𡭊
    0x21B4B: 'rǒng',  # 𡭋
    # 0x21B4C: '',  # 𡭌
    # 0x21B4D: '',  # 𡭍
    # 0x21B4E: '',  # 𡭎
    # 0x21B4F: '',  # 𡭏
    0x21B50: 'shuàn',  # 𡭐
    # 0x21B51: '',  # 𡭑
    # 0x21B52: '',  # 𡭒
    # 0x21B53: '',  # 𡭓
    # 0x21B54: '',  # 𡭔
    # 0x21B55: '',  # 𡭕
    # 0x21B56: '',  # 𡭖
    # 0x21B57: '',  # 𡭗
    0x21B58: 'jiā',  # 𡭘
    # 0x21B59: '',  # 𡭙
    0x21B5A: 'mó',  # 𡭚
    0x21B5B: 'huǐ',  # 𡭛
    # 0x21B5C: '',  # 𡭜
    # 0x21B5D: '',  # 𡭝
    0x21B5E: 'zhān',  # 𡭞
    # 0x21B5F: '',  # 𡭟
    # 0x21B60: '',  # 𡭠
    # 0x21B61: '',  # 𡭡
    0x21B62: 'bài',  # 𡭢
    0x21B63: 'liè',  # 𡭣
    # 0x21B64: '',  # 𡭤
    0x21B65: 'xiē',  # 𡭥
    # 0x21B66: '',  # 𡭦
    # 0x21B67: '',  # 𡭧
    # 0x21B68: '',  # 𡭨
    # 0x21B69: '',  # 𡭩
    # 0x21B6A: '',  # 𡭪
    # 0x21B6B: '',  # 𡭫
    # 0x21B6C: '',  # 𡭬
    0x21B6D: 'jiǎn',  # 𡭭
    0x21B6E: 'shǒu',  # 𡭮
    # 0x21B6F: '',  # 𡭯
    # 0x21B70: '',  # 𡭰
    # 0x21B71: '',  # 𡭱
    # 0x21B72: '',  # 𡭲
    0x21B73: 'kào',  # 𡭳
    0x21B74: 'xì',  # 𡭴
    # 0x21B75: '',  # 𡭵
    # 0x21B76: '',  # 𡭶
    0x21B77: 'guān',  # 𡭷
    0x21B78: 'luàn',  # 𡭸
    # 0x21B79: '',  # 𡭹
    # 0x21B7A: '',  # 𡭺
    # 0x21B7B: '',  # 𡭻
    # 0x21B7C: '',  # 𡭼
    0x21B7D: 'xì',  # 𡭽
    0x21B7E: 'nǒu',  # 𡭾
    0x21B7F: 'chǎng',  # 𡭿
    # 0x21B80: '',  # 𡮀
    # 0x21B81: '',  # 𡮁
    # 0x21B82: '',  # 𡮂
    # 0x21B83: '',  # 𡮃
    # 0x21B84: '',  # 𡮄
    # 0x21B85: '',  # 𡮅
    # 0x21B86: '',  # 𡮆
    # 0x21B87: '',  # 𡮇
    # 0x21B88: '',  # 𡮈
    # 0x21B89: '',  # 𡮉
    # 0x21B8A: '',  # 𡮊
    # 0x21B8B: '',  # 𡮋
    # 0x21B8C: '',  # 𡮌
    # 0x21B8D: '',  # 𡮍
    0x21B8E: 'liáng',  # 𡮎
    # 0x21B8F: '',  # 𡮏
    # 0x21B90: '',  # 𡮐
    # 0x21B91: '',  # 𡮑
    # 0x21B92: '',  # 𡮒
    # 0x21B93: '',  # 𡮓
    # 0x21B94: '',  # 𡮔
    # 0x21B95: '',  # 𡮕
    # 0x21B96: '',  # 𡮖
    # 0x21B97: '',  # 𡮗
    # 0x21B98: '',  # 𡮘
    0x21B99: 'nài',  # 𡮙
    0x21B9A: 'rǔ',  # 𡮚
    # 0x21B9B: '',  # 𡮛
    # 0x21B9C: '',  # 𡮜
    # 0x21B9D: '',  # 𡮝
    0x21B9E: 'zhì',  # 𡮞
    # 0x21B9F: '',  # 𡮟
    # 0x21BA0: '',  # 𡮠
    # 0x21BA1: '',  # 𡮡
    # 0x21BA2: '',  # 𡮢
    # 0x21BA3: '',  # 𡮣
    # 0x21BA4: '',  # 𡮤
    # 0x21BA5: '',  # 𡮥
    0x21BA6: 'cáo',  # 𡮦
    # 0x21BA7: '',  # 𡮧
    # 0x21BA8: '',  # 𡮨
    # 0x21BA9: '',  # 𡮩
    # 0x21BAA: '',  # 𡮪
    # 0x21BAB: '',  # 𡮫
    # 0x21BAC: '',  # 𡮬
    # 0x21BAD: '',  # 𡮭
    # 0x21BAE: '',  # 𡮮
    # 0x21BAF: '',  # 𡮯
    0x21BB0: 'lì',  # 𡮰
    # 0x21BB1: '',  # 𡮱
    # 0x21BB2: '',  # 𡮲
    # 0x21BB3: '',  # 𡮳
    # 0x21BB4: '',  # 𡮴
    # 0x21BB5: '',  # 𡮵
    # 0x21BB6: '',  # 𡮶
    # 0x21BB7: '',  # 𡮷
    # 0x21BB8: '',  # 𡮸
    # 0x21BB9: '',  # 𡮹
    # 0x21BBA: '',  # 𡮺
    0x21BBB: 'lán',  # 𡮻
    # 0x21BBC: '',  # 𡮼
    # 0x21BBD: '',  # 𡮽
    # 0x21BBE: '',  # 𡮾
    0x21BBF: 'chān',  # 𡮿
    # 0x21BC0: '',  # 𡯀
    0x21BC1: 'wāng',  # 𡯁
    # 0x21BC2: '',  # 𡯂
    # 0x21BC3: '',  # 𡯃
    0x21BC4: 'lì',  # 𡯄
    # 0x21BC5: '',  # 𡯅
    # 0x21BC6: '',  # 𡯆
    0x21BC7: 'wù',  # 𡯇
    0x21BC8: 'páo',  # 𡯈
    0x21BC9: 'yòu',  # 𡯉
    # 0x21BCA: '',  # 𡯊
    0x21BCB: 'gān',  # 𡯋
    # 0x21BCC: '',  # 𡯌
    # 0x21BCD: '',  # 𡯍
    # 0x21BCE: '',  # 𡯎
    0x21BCF: 'ān',  # 𡯏
    0x21BD0: 'xiū',  # 𡯐
    0x21BD1: 'shuǐ,zhuǐ',  # 𡯑
    0x21BD2: 'ruǐ',  # 𡯒
    # 0x21BD3: '',  # 𡯓
    # 0x21BD4: '',  # 𡯔
    # 0x21BD5: '',  # 𡯕
    # 0x21BD6: '',  # 𡯖
    # 0x21BD7: '',  # 𡯗
    0x21BD8: 'bǎn',  # 𡯘
    0x21BD9: 'yóu',  # 𡯙
    # 0x21BDA: '',  # 𡯚
    0x21BDB: 'zuǒ',  # 𡯛
    # 0x21BDC: '',  # 𡯜
    # 0x21BDD: '',  # 𡯝
    # 0x21BDE: '',  # 𡯞
    # 0x21BDF: '',  # 𡯟
    # 0x21BE0: '',  # 𡯠
    # 0x21BE1: '',  # 𡯡
    0x21BE2: 'huó',  # 𡯢
    0x21BE3: 'yào',  # 𡯣
    # 0x21BE4: '',  # 𡯤
    0x21BE5: 'huī',  # 𡯥
    # 0x21BE6: '',  # 𡯦
    # 0x21BE7: '',  # 𡯧
    0x21BE8: 'zuò',  # 𡯨
    0x21BE9: 'xiāo',  # 𡯩
    # 0x21BEA: '',  # 𡯪
    0x21BEB: 'mián',  # 𡯫
    # 0x21BEC: '',  # 𡯬
    # 0x21BED: '',  # 𡯭
    # 0x21BEE: '',  # 𡯮
    # 0x21BEF: '',  # 𡯯
    0x21BF0: 'gà',  # 𡯰
    0x21BF1: 'yuǎn',  # 𡯱
    # 0x21BF2: '',  # 𡯲
    0x21BF3: 'bò',  # 𡯳
    0x21BF4: 'chào',  # 𡯴
    0x21BF5: 'tuǐ,kuì',  # 𡯵
    # 0x21BF6: '',  # 𡯶
    0x21BF7: 'bò,kòu',  # 𡯷
    # 0x21BF8: '',  # 𡯸
    # 0x21BF9: '',  # 𡯹
    # 0x21BFA: '',  # 𡯺
    # 0x21BFB: '',  # 𡯻
    # 0x21BFC: '',  # 𡯼
    0x21BFD: 'gà',  # 𡯽
    # 0x21BFE: '',  # 𡯾
    0x21BFF: 'tiāo',  # 𡯿
    0x21C00: 'ná',  # 𡰀
    # 0x21C01: '',  # 𡰁
    0x21C02: 'kuī',  # 𡰂
    # 0x21C03: '',  # 𡰃
    # 0x21C04: '',  # 𡰄
    0x21C05: 'hú',  # 𡰅
    0x21C06: 'niè',  # 𡰆
    # 0x21C07: '',  # 𡰇
    # 0x21C08: '',  # 𡰈
    # 0x21C09: '',  # 𡰉
    # 0x21C0A: '',  # 𡰊
    0x21C0B: 'huí',  # 𡰋
    0x21C0C: 'lǒu',  # 𡰌
    # 0x21C0D: '',  # 𡰍
    0x21C0E: 'tí',  # 𡰎
    # 0x21C0F: '',  # 𡰏
    0x21C10: 'qiào',  # 𡰐
    0x21C11: 'qiáo',  # 𡰑
    0x21C12: 'zhǒng',  # 𡰒
    # 0x21C13: '',  # 𡰓
    # 0x21C14: '',  # 𡰔
    # 0x21C15: '',  # 𡰕
    0x21C16: 'dī',  # 𡰖
    # 0x21C17: '',  # 𡰗
    # 0x21C18: '',  # 𡰘
    # 0x21C19: '',  # 𡰙
    0x21C1A: 'lín',  # 𡰚
    # 0x21C1B: '',  # 𡰛
    # 0x21C1C: '',  # 𡰜
    0x21C1D: 'quán',  # 𡰝
    0x21C1E: 'zhuān',  # 𡰞
    # 0x21C1F: '',  # 𡰟
    0x21C20: 'léi,luán',  # 𡰠
    # 0x21C21: '',  # 𡰡
    0x21C22: 'xié',  # 𡰢
    0x21C23: 'shī',  # 𡰣
    # 0x21C24: '',  # 𡰤
    0x21C25: 'rén,yí',  # 𡰥
    # 0x21C26: '',  # 𡰦
    # 0x21C27: '',  # 𡰧
    0x21C28: 'dāng',  # 𡰨
    # 0x21C29: '',  # 𡰩
    # 0x21C2A: '',  # 𡰪
    0x21C2B: 'niǎn',  # 𡰫
    # 0x21C2C: '',  # 𡰬
    # 0x21C2D: '',  # 𡰭
    # 0x21C2E: '',  # 𡰮
    0x21C2F: 'shǐ,diǎo,běi',  # 𡰯
    # 0x21C30: '',  # 𡰰
    # 0x21C31: '',  # 𡰱
    0x21C32: 'xián',  # 𡰲
    # 0x21C33: '',  # 𡰳
    # 0x21C34: '',  # 𡰴
    0x21C35: 'jī',  # 𡰵
    # 0x21C36: '',  # 𡰶
    # 0x21C37: '',  # 𡰷
    0x21C38: 'jī',  # 𡰸
    0x21C39: 'zhí',  # 𡰹
    # 0x21C3A: '',  # 𡰺
    # 0x21C3B: '',  # 𡰻
    # 0x21C3C: '',  # 𡰼
    0x21C3D: 'ài',  # 𡰽
    0x21C3E: 'cī',  # 𡰾
    0x21C3F: 'pú',  # 𡰿
    # 0x21C40: '',  # 𡱀
    0x21C41: 'shǐ',  # 𡱁
    0x21C42: 'tún',  # 𡱂
    # 0x21C43: '',  # 𡱃
    # 0x21C44: '',  # 𡱄
    0x21C45: 'qū',  # 𡱅
    0x21C46: 'shǔ',  # 𡱆
    0x21C47: 'diān',  # 𡱇
    # 0x21C48: '',  # 𡱈
    0x21C49: 'xiǎo',  # 𡱉
    0x21C4A: 'shuǐ',  # 𡱊
    # 0x21C4B: '',  # 𡱋
    0x21C4C: 'huán',  # 𡱌
    # 0x21C4D: '',  # 𡱍
    # 0x21C4E: '',  # 𡱎
    # 0x21C4F: '',  # 𡱏
    0x21C50: 'yí',  # 𡱐
    0x21C51: 'juān',  # 𡱑
    # 0x21C52: '',  # 𡱒
    # 0x21C53: '',  # 𡱓
    0x21C54: 'zhǐ,qì',  # 𡱔
    # 0x21C55: '',  # 𡱕
    # 0x21C56: '',  # 𡱖
    # 0x21C57: '',  # 𡱗
    # 0x21C58: '',  # 𡱘
    # 0x21C59: '',  # 𡱙
    # 0x21C5A: '',  # 𡱚
    # 0x21C5B: '',  # 𡱛
    0x21C5C: 'zhào',  # 𡱜
    # 0x21C5D: '',  # 𡱝
    # 0x21C5E: '',  # 𡱞
    # 0x21C5F: '',  # 𡱟
    # 0x21C60: '',  # 𡱠
    # 0x21C61: '',  # 𡱡
    # 0x21C62: '',  # 𡱢
    0x21C63: 'xù',  # 𡱣
    # 0x21C64: '',  # 𡱤
    # 0x21C65: '',  # 𡱥
    # 0x21C66: '',  # 𡱦
    # 0x21C67: '',  # 𡱧
    # 0x21C68: '',  # 𡱨
    # 0x21C69: '',  # 𡱩
    # 0x21C6A: '',  # 𡱪
    # 0x21C6B: '',  # 𡱫
    # 0x21C6C: '',  # 𡱬
    # 0x21C6D: '',  # 𡱭
    # 0x21C6E: '',  # 𡱮
    0x21C6F: 'lòng',  # 𡱯
    # 0x21C70: '',  # 𡱰
    0x21C71: 'zhù',  # 𡱱
    # 0x21C72: '',  # 𡱲
    0x21C73: 'suǒ',  # 𡱳
    # 0x21C74: '',  # 𡱴
    # 0x21C75: '',  # 𡱵
    # 0x21C76: '',  # 𡱶
    0x21C77: 'dié',  # 𡱷
    # 0x21C78: '',  # 𡱸
    # 0x21C79: '',  # 𡱹
    0x21C7A: 'qú',  # 𡱺
    # 0x21C7B: '',  # 𡱻
    0x21C7C: 'kè,kuà',  # 𡱼
    0x21C7D: 'hū',  # 𡱽
    0x21C7E: 'jū',  # 𡱾
    # 0x21C7F: '',  # 𡱿
    0x21C80: 'qǐng',  # 𡲀
    # 0x21C81: '',  # 𡲁
    # 0x21C82: '',  # 𡲂
    # 0x21C83: '',  # 𡲃
    # 0x21C84: '',  # 𡲄
    # 0x21C85: '',  # 𡲅
    0x21C86: 'jī',  # 𡲆
    # 0x21C87: '',  # 𡲇
    # 0x21C88: '',  # 𡲈
    # 0x21C89: '',  # 𡲉
    # 0x21C8A: '',  # 𡲊
    # 0x21C8B: '',  # 𡲋
    # 0x21C8C: '',  # 𡲌
    0x21C8D: 'bīng',  # 𡲍
    # 0x21C8E: '',  # 𡲎
    # 0x21C8F: '',  # 𡲏
    # 0x21C90: '',  # 𡲐
    # 0x21C91: '',  # 𡲑
    # 0x21C92: '',  # 𡲒
    # 0x21C93: '',  # 𡲓
    # 0x21C94: '',  # 𡲔
    0x21C95: 'tì',  # 𡲕
    # 0x21C96: '',  # 𡲖
    0x21C97: 'jué',  # 𡲗
    # 0x21C98: '',  # 𡲘
    # 0x21C99: '',  # 𡲙
    0x21C9A: 'qiú',  # 𡲚
    # 0x21C9B: '',  # 𡲛
    # 0x21C9C: '',  # 𡲜
    # 0x21C9D: '',  # 𡲝
    # 0x21C9E: '',  # 𡲞
    # 0x21C9F: '',  # 𡲟
    # 0x21CA0: '',  # 𡲠
    # 0x21CA1: '',  # 𡲡
    # 0x21CA2: '',  # 𡲢
    0x21CA3: 'jiàng',  # 𡲣
    # 0x21CA4: '',  # 𡲤
    # 0x21CA5: '',  # 𡲥
    # 0x21CA6: '',  # 𡲦
    # 0x21CA7: '',  # 𡲧
    # 0x21CA8: '',  # 𡲨
    # 0x21CA9: '',  # 𡲩
    0x21CAA: 'yùn',  # 𡲪
    # 0x21CAB: '',  # 𡲫
    # 0x21CAC: '',  # 𡲬
    0x21CAD: 'mèi',  # 𡲭
    0x21CAE: 'pī',  # 𡲮
    # 0x21CAF: '',  # 𡲯
    0x21CB0: 'qú',  # 𡲰
    # 0x21CB1: '',  # 𡲱
    # 0x21CB2: '',  # 𡲲
    # 0x21CB3: '',  # 𡲳
    # 0x21CB4: '',  # 𡲴
    # 0x21CB5: '',  # 𡲵
    # 0x21CB6: '',  # 𡲶
    # 0x21CB7: '',  # 𡲷
    # 0x21CB8: '',  # 𡲸
    # 0x21CB9: '',  # 𡲹
    # 0x21CBA: '',  # 𡲺
    # 0x21CBB: '',  # 𡲻
    0x21CBC: 'mì',  # 𡲼
    # 0x21CBD: '',  # 𡲽
    0x21CBE: 'tuī',  # 𡲾
    0x21CBF: 'tì',  # 𡲿
    # 0x21CC0: '',  # 𡳀
    # 0x21CC1: '',  # 𡳁
    0x21CC2: 'kài',  # 𡳂
    # 0x21CC3: '',  # 𡳃
    0x21CC4: 'bǐ',  # 𡳄
    # 0x21CC5: '',  # 𡳅
    0x21CC6: 'qū,qù',  # 𡳆
    # 0x21CC7: '',  # 𡳇
    # 0x21CC8: '',  # 𡳈
    # 0x21CC9: '',  # 𡳉
    # 0x21CCA: '',  # 𡳊
    # 0x21CCB: '',  # 𡳋
    # 0x21CCC: '',  # 𡳌
    # 0x21CCD: '',  # 𡳍
    # 0x21CCE: '',  # 𡳎
    0x21CCF: 'tiāo',  # 𡳏
    # 0x21CD0: '',  # 𡳐
    0x21CD1: 'chù',  # 𡳑
    # 0x21CD2: '',  # 𡳒
    # 0x21CD3: '',  # 𡳓
    # 0x21CD4: '',  # 𡳔
    # 0x21CD5: '',  # 𡳕
    # 0x21CD6: '',  # 𡳖
    # 0x21CD7: '',  # 𡳗
    0x21CD8: 'jú',  # 𡳘
    # 0x21CD9: '',  # 𡳙
    0x21CDA: 'xī',  # 𡳚
    # 0x21CDB: '',  # 𡳛
    # 0x21CDC: '',  # 𡳜
    # 0x21CDD: '',  # 𡳝
    0x21CDE: 'lìn',  # 𡳞
    # 0x21CDF: '',  # 𡳟
    # 0x21CE0: '',  # 𡳠
    # 0x21CE1: '',  # 𡳡
    # 0x21CE2: '',  # 𡳢
    # 0x21CE3: '',  # 𡳣
    # 0x21CE4: '',  # 𡳤
    # 0x21CE5: '',  # 𡳥
    # 0x21CE6: '',  # 𡳦
    # 0x21CE7: '',  # 𡳧
    # 0x21CE8: '',  # 𡳨
    # 0x21CE9: '',  # 𡳩
    # 0x21CEA: '',  # 𡳪
    # 0x21CEB: '',  # 𡳫
    # 0x21CEC: '',  # 𡳬
    0x21CED: 'chǐ',  # 𡳭
    0x21CEE: 'jī',  # 𡳮
    # 0x21CEF: '',  # 𡳯
    # 0x21CF0: '',  # 𡳰
    # 0x21CF1: '',  # 𡳱
    # 0x21CF2: '',  # 𡳲
    # 0x21CF3: '',  # 𡳳
    0x21CF4: 'lú',  # 𡳴
    # 0x21CF5: '',  # 𡳵
    # 0x21CF6: '',  # 𡳶
    # 0x21CF7: '',  # 𡳷
    0x21CF8: 'lì',  # 𡳸
    # 0x21CF9: '',  # 𡳹
    # 0x21CFA: '',  # 𡳺
    # 0x21CFB: '',  # 𡳻
    # 0x21CFC: '',  # 𡳼
    # 0x21CFD: '',  # 𡳽
    0x21CFE: 'jué',  # 𡳾
    # 0x21CFF: '',  # 𡳿
    # 0x21D00: '',  # 𡴀
    # 0x21D01: '',  # 𡴁
    # 0x21D02: '',  # 𡴂
    # 0x21D03: '',  # 𡴃
    # 0x21D04: '',  # 𡴄
    0x21D05: 'zhū',  # 𡴅
    0x21D06: 'lù',  # 𡴆
    # 0x21D07: '',  # 𡴇
    # 0x21D08: '',  # 𡴈
    # 0x21D09: '',  # 𡴉
    # 0x21D0A: '',  # 𡴊
    # 0x21D0B: '',  # 𡴋
    # 0x21D0C: '',  # 𡴌
    # 0x21D0D: '',  # 𡴍
    0x21D0E: 'niè',  # 𡴎
    # 0x21D0F: '',  # 𡴏
    # 0x21D10: '',  # 𡴐
    # 0x21D11: '',  # 𡴑
    # 0x21D12: '',  # 𡴒
    # 0x21D13: '',  # 𡴓
    0x21D14: 'quán',  # 𡴔
    # 0x21D15: '',  # 𡴕
    # 0x21D16: '',  # 𡴖
    # 0x21D17: '',  # 𡴗
    0x21D18: 'xìng',  # 𡴘
    # 0x21D19: '',  # 𡴙
    # 0x21D1A: '',  # 𡴚
    # 0x21D1B: '',  # 𡴛
    # 0x21D1C: '',  # 𡴜
    # 0x21D1D: '',  # 𡴝
    0x21D1E: 'yǔn',  # 𡴞
    # 0x21D1F: '',  # 𡴟
    # 0x21D20: '',  # 𡴠
    # 0x21D21: '',  # 𡴡
    # 0x21D22: '',  # 𡴢
    # 0x21D23: '',  # 𡴣
    # 0x21D24: '',  # 𡴤
    # 0x21D25: '',  # 𡴥
    # 0x21D26: '',  # 𡴦
    # 0x21D27: '',  # 𡴧
    # 0x21D28: '',  # 𡴨
    # 0x21D29: '',  # 𡴩
    # 0x21D2A: '',  # 𡴪
    # 0x21D2B: '',  # 𡴫
    # 0x21D2C: '',  # 𡴬
    0x21D2D: 'yà',  # 𡴭
    # 0x21D2E: '',  # 𡴮
    0x21D2F: 'è',  # 𡴯
    # 0x21D30: '',  # 𡴰
    0x21D31: 'hù,jié',  # 𡴱
    # 0x21D32: '',  # 𡴲
    # 0x21D33: '',  # 𡴳
    # 0x21D34: '',  # 𡴴
    # 0x21D35: '',  # 𡴵
    # 0x21D36: '',  # 𡴶
    # 0x21D37: '',  # 𡴷
    # 0x21D38: '',  # 𡴸
    0x21D39: 'jié',  # 𡴹
    # 0x21D3A: '',  # 𡴺
    # 0x21D3B: '',  # 𡴻
    # 0x21D3C: '',  # 𡴼
    # 0x21D3D: '',  # 𡴽
    # 0x21D3E: '',  # 𡴾
    # 0x21D3F: '',  # 𡴿
    0x21D40: 'máng',  # 𡵀
    # 0x21D41: '',  # 𡵁
    # 0x21D42: '',  # 𡵂
    # 0x21D43: '',  # 𡵃
    # 0x21D44: '',  # 𡵄
    # 0x21D45: '',  # 𡵅
    # 0x21D46: '',  # 𡵆
    # 0x21D47: '',  # 𡵇
    # 0x21D48: '',  # 𡵈
    0x21D49: 'wù',  # 𡵉
    # 0x21D4A: '',  # 𡵊
    # 0x21D4B: '',  # 𡵋
    0x21D4C: 'chā',  # 𡵌
    # 0x21D4D: '',  # 𡵍
    # 0x21D4E: '',  # 𡵎
    # 0x21D4F: '',  # 𡵏
    # 0x21D50: '',  # 𡵐
    0x21D51: 'qīn',  # 𡵑
    0x21D52: 'jié,qǐ',  # 𡵒
    0x21D53: 'hóng',  # 𡵓
    # 0x21D54: '',  # 𡵔
    0x21D55: 'dān',  # 𡵕
    0x21D56: 'ěn',  # 𡵖
    0x21D57: 'zè',  # 𡵗
    0x21D58: 'hù',  # 𡵘
    0x21D59: 'àng',  # 𡵙
    0x21D5A: 'jiè',  # 𡵚
    0x21D5B: 'fù',  # 𡵛
    0x21D5C: 'yòng',  # 𡵜
    # 0x21D5D: '',  # 𡵝
    0x21D5E: 'fēng',  # 𡵞
    # 0x21D5F: '',  # 𡵟
    # 0x21D60: '',  # 𡵠
    # 0x21D61: '',  # 𡵡
    # 0x21D62: '',  # 𡵢
    # 0x21D63: '',  # 𡵣
    # 0x21D64: '',  # 𡵤
    # 0x21D65: '',  # 𡵥
    # 0x21D66: '',  # 𡵦
    # 0x21D67: '',  # 𡵧
    # 0x21D68: '',  # 𡵨
    # 0x21D69: '',  # 𡵩
    # 0x21D6A: '',  # 𡵪
    # 0x21D6B: '',  # 𡵫
    0x21D6C: 'mù',  # 𡵬
    0x21D6D: 'cūn',  # 𡵭
    # 0x21D6E: '',  # 𡵮
    # 0x21D6F: '',  # 𡵯
    # 0x21D70: '',  # 𡵰
    # 0x21D71: '',  # 𡵱
    # 0x21D72: '',  # 𡵲
    # 0x21D73: '',  # 𡵳
    # 0x21D74: '',  # 𡵴
    # 0x21D75: '',  # 𡵵
    0x21D76: 'sè',  # 𡵶
    0x21D77: 'cóng',  # 𡵷
    # 0x21D78: '',  # 𡵸
    # 0x21D79: '',  # 𡵹
    # 0x21D7A: '',  # 𡵺
    0x21D7B: 'kāng',  # 𡵻
    # 0x21D7C: '',  # 𡵼
    # 0x21D7D: '',  # 𡵽
    # 0x21D7E: '',  # 𡵾
    # 0x21D7F: '',  # 𡵿
    # 0x21D80: '',  # 𡶀
    # 0x21D81: '',  # 𡶁
    0x21D82: 'yào',  # 𡶂
    0x21D83: 'ài',  # 𡶃
    0x21D84: 'bāo',  # 𡶄
    # 0x21D85: '',  # 𡶅
    0x21D86: 'pǒ',  # 𡶆
    # 0x21D87: '',  # 𡶇
    0x21D88: 'shǐ',  # 𡶈
    0x21D89: 'fàn',  # 𡶉
    # 0x21D8A: '',  # 𡶊
    0x21D8B: 'jú',  # 𡶋
    0x21D8C: 'pí',  # 𡶌
    # 0x21D8D: '',  # 𡶍
    0x21D8E: 'wèi',  # 𡶎
    0x21D8F: 'kū',  # 𡶏
    0x21D90: 'qié',  # 𡶐
    0x21D91: 'gān',  # 𡶑
    # 0x21D92: '',  # 𡶒
    # 0x21D93: '',  # 𡶓
    # 0x21D94: '',  # 𡶔
    # 0x21D95: '',  # 𡶕
    # 0x21D96: '',  # 𡶖
    # 0x21D97: '',  # 𡶗
    # 0x21D98: '',  # 𡶘
    # 0x21D99: '',  # 𡶙
    # 0x21D9A: '',  # 𡶚
    # 0x21D9B: '',  # 𡶛
    # 0x21D9C: '',  # 𡶜
    # 0x21D9D: '',  # 𡶝
    # 0x21D9E: '',  # 𡶞
    # 0x21D9F: '',  # 𡶟
    # 0x21DA0: '',  # 𡶠
    # 0x21DA1: '',  # 𡶡
    0x21DA2: 'kuàng',  # 𡶢
    0x21DA3: 'suì',  # 𡶣
    0x21DA4: 'bēng,yòng',  # 𡶤
    0x21DA5: 'jiā',  # 𡶥
    0x21DA6: 'yà',  # 𡶦
    # 0x21DA7: '',  # 𡶧
    # 0x21DA8: '',  # 𡶨
    # 0x21DA9: '',  # 𡶩
    0x21DAA: 'kàn',  # 𡶪
    0x21DAB: 'niè',  # 𡶫
    # 0x21DAC: '',  # 𡶬
    0x21DAD: 'xíng',  # 𡶭
    # 0x21DAE: '',  # 𡶮
    0x21DAF: 'xì',  # 𡶯
    # 0x21DB0: '',  # 𡶰
    0x21DB1: 'lìn',  # 𡶱
    0x21DB2: 'duǒ',  # 𡶲
    # 0x21DB3: '',  # 𡶳
    # 0x21DB4: '',  # 𡶴
    # 0x21DB5: '',  # 𡶵
    # 0x21DB6: '',  # 𡶶
    # 0x21DB7: '',  # 𡶷
    # 0x21DB8: '',  # 𡶸
    # 0x21DB9: '',  # 𡶹
    # 0x21DBA: '',  # 𡶺
    # 0x21DBB: '',  # 𡶻
    # 0x21DBC: '',  # 𡶼
    # 0x21DBD: '',  # 𡶽
    0x21DBE: 'shí',  # 𡶾
    # 0x21DBF: '',  # 𡶿
    # 0x21DC0: '',  # 𡷀
    # 0x21DC1: '',  # 𡷁
    # 0x21DC2: '',  # 𡷂
    # 0x21DC3: '',  # 𡷃
    # 0x21DC4: '',  # 𡷄
    # 0x21DC5: '',  # 𡷅
    # 0x21DC6: '',  # 𡷆
    # 0x21DC7: '',  # 𡷇
    0x21DC8: 'shì',  # 𡷈
    # 0x21DC9: '',  # 𡷉
    # 0x21DCA: '',  # 𡷊
    0x21DCB: 'duì',  # 𡷋
    # 0x21DCC: '',  # 𡷌
    0x21DCD: 'jiāng',  # 𡷍
    0x21DCE: 'yǔ',  # 𡷎
    0x21DCF: 'lù',  # 𡷏
    0x21DD0: 'ěn',  # 𡷐
    # 0x21DD1: '',  # 𡷑
    # 0x21DD2: '',  # 𡷒
    0x21DD3: 'gǔ',  # 𡷓
    # 0x21DD4: '',  # 𡷔
    0x21DD5: 'wěi',  # 𡷕
    0x21DD6: 'chē',  # 𡷖
    0x21DD7: 'huàn,huán',  # 𡷗
    0x21DD8: 'bié',  # 𡷘
    # 0x21DD9: '',  # 𡷙
    # 0x21DDA: '',  # 𡷚
    0x21DDB: 'hàn',  # 𡷛
    0x21DDC: 'tuí',  # 𡷜
    0x21DDD: 'nà',  # 𡷝
    0x21DDE: 'qǐ',  # 𡷞
    # 0x21DDF: '',  # 𡷟
    0x21DE0: 'tóu',  # 𡷠
    0x21DE1: 'yuān',  # 𡷡
    0x21DE2: 'wáng',  # 𡷢
    # 0x21DE3: '',  # 𡷣
    0x21DE4: 'wú',  # 𡷤
    0x21DE5: 'gào',  # 𡷥
    # 0x21DE6: '',  # 𡷦
    # 0x21DE7: '',  # 𡷧
    0x21DE8: 'kēng,xíng',  # 𡷨
    # 0x21DE9: '',  # 𡷩
    0x21DEA: 'yí,níng',  # 𡷪
    0x21DEB: 'chéng',  # 𡷫
    # 0x21DEC: '',  # 𡷬
    # 0x21DED: '',  # 𡷭
    # 0x21DEE: '',  # 𡷮
    # 0x21DEF: '',  # 𡷯
    # 0x21DF0: '',  # 𡷰
    # 0x21DF1: '',  # 𡷱
    # 0x21DF2: '',  # 𡷲
    # 0x21DF3: '',  # 𡷳
    # 0x21DF4: '',  # 𡷴
    # 0x21DF5: '',  # 𡷵
    # 0x21DF6: '',  # 𡷶
    # 0x21DF7: '',  # 𡷷
    0x21DF8: 'xiāo',  # 𡷸
    # 0x21DF9: '',  # 𡷹
    0x21DFA: 'guǐ',  # 𡷺
    0x21DFB: 'yà',  # 𡷻
    0x21DFC: 'suì',  # 𡷼
    0x21DFD: 'sǒng',  # 𡷽
    # 0x21DFE: '',  # 𡷾
    0x21DFF: 'zhuó',  # 𡷿
    # 0x21E00: '',  # 𡸀
    # 0x21E01: '',  # 𡸁
    0x21E02: 'tū,tú',  # 𡸂
    0x21E03: 'jiǎn',  # 𡸃
    # 0x21E04: '',  # 𡸄
    0x21E05: 'tāo',  # 𡸅
    # 0x21E06: '',  # 𡸆
    # 0x21E07: '',  # 𡸇
    0x21E08: 'zè',  # 𡸈
    0x21E09: 'lì',  # 𡸉
    # 0x21E0A: '',  # 𡸊
    # 0x21E0B: '',  # 𡸋
    0x21E0C: 'zhù',  # 𡸌
    # 0x21E0D: '',  # 𡸍
    0x21E0E: 'jié',  # 𡸎
    # 0x21E0F: '',  # 𡸏
    # 0x21E10: '',  # 𡸐
    0x21E11: 'tì',  # 𡸑
    # 0x21E12: '',  # 𡸒
    # 0x21E13: '',  # 𡸓
    0x21E14: 'xié',  # 𡸔
    0x21E15: 'qióng',  # 𡸕
    # 0x21E16: '',  # 𡸖
    0x21E17: 'yà',  # 𡸗
    0x21E18: 'jū',  # 𡸘
    # 0x21E19: '',  # 𡸙
    # 0x21E1A: '',  # 𡸚
    0x21E1B: 'yín',  # 𡸛
    0x21E1C: 'zhí',  # 𡸜
    # 0x21E1D: '',  # 𡸝
    0x21E1E: 'kǎn',  # 𡸞
    0x21E1F: 'zī',  # 𡸟
    # 0x21E20: '',  # 𡸠
    0x21E21: 'kē',  # 𡸡
    # 0x21E22: '',  # 𡸢
    0x21E23: 'niè',  # 𡸣
    0x21E24: 'qiáng',  # 𡸤
    0x21E25: 'wǎn',  # 𡸥
    0x21E26: 'zé',  # 𡸦
    # 0x21E27: '',  # 𡸧
    0x21E28: 'jū',  # 𡸨
    # 0x21E29: '',  # 𡸩
    0x21E2A: 'zì',  # 𡸪
    0x21E2B: 'pīn',  # 𡸫
    # 0x21E2C: '',  # 𡸬
    # 0x21E2D: '',  # 𡸭
    # 0x21E2E: '',  # 𡸮
    # 0x21E2F: '',  # 𡸯
    # 0x21E30: '',  # 𡸰
    # 0x21E31: '',  # 𡸱
    # 0x21E32: '',  # 𡸲
    # 0x21E33: '',  # 𡸳
    # 0x21E34: '',  # 𡸴
    # 0x21E35: '',  # 𡸵
    # 0x21E36: '',  # 𡸶
    # 0x21E37: '',  # 𡸷
    # 0x21E38: '',  # 𡸸
    # 0x21E39: '',  # 𡸹
    # 0x21E3A: '',  # 𡸺
    # 0x21E3B: '',  # 𡸻
    # 0x21E3C: '',  # 𡸼
    # 0x21E3D: '',  # 𡸽
    # 0x21E3E: '',  # 𡸾
    # 0x21E3F: '',  # 𡸿
    # 0x21E40: '',  # 𡹀
    # 0x21E41: '',  # 𡹁
    # 0x21E42: '',  # 𡹂
    # 0x21E43: '',  # 𡹃
    0x21E44: 'yà',  # 𡹄
    # 0x21E45: '',  # 𡹅
    # 0x21E46: '',  # 𡹆
    0x21E47: 'lín',  # 𡹇
    # 0x21E48: '',  # 𡹈
    0x21E49: 'qí',  # 𡹉
    # 0x21E4A: '',  # 𡹊
    # 0x21E4B: '',  # 𡹋
    # 0x21E4C: '',  # 𡹌
    # 0x21E4D: '',  # 𡹍
    0x21E4E: 'huí',  # 𡹎
    # 0x21E4F: '',  # 𡹏
    # 0x21E50: '',  # 𡹐
    # 0x21E51: '',  # 𡹑
    # 0x21E52: '',  # 𡹒
    0x21E53: 'qì',  # 𡹓
    0x21E54: 'bēng',  # 𡹔
    0x21E55: 'yáng',  # 𡹕
    0x21E56: 'suì',  # 𡹖
    # 0x21E57: '',  # 𡹗
    0x21E58: 'qǐ',  # 𡹘
    0x21E59: 'guī',  # 𡹙
    # 0x21E5A: '',  # 𡹚
    # 0x21E5B: '',  # 𡹛
    # 0x21E5C: '',  # 𡹜
    # 0x21E5D: '',  # 𡹝
    # 0x21E5E: '',  # 𡹞
    # 0x21E5F: '',  # 𡹟
    # 0x21E60: '',  # 𡹠
    # 0x21E61: '',  # 𡹡
    0x21E62: 'qìn',  # 𡹢
    0x21E63: 'ē',  # 𡹣
    # 0x21E64: '',  # 𡹤
    0x21E65: 'zuò',  # 𡹥
    # 0x21E66: '',  # 𡹦
    # 0x21E67: '',  # 𡹧
    0x21E68: 'zè',  # 𡹨
    0x21E69: 'qì',  # 𡹩
    0x21E6A: 'jí',  # 𡹪
    # 0x21E6B: '',  # 𡹫
    0x21E6C: 'tuó',  # 𡹬
    0x21E6D: 'dié',  # 𡹭
    # 0x21E6E: '',  # 𡹮
    0x21E6F: 'huì',  # 𡹯
    0x21E70: 'máo',  # 𡹰
    # 0x21E71: '',  # 𡹱
    0x21E72: 'xǔ',  # 𡹲
    # 0x21E73: '',  # 𡹳
    # 0x21E74: '',  # 𡹴
    0x21E75: 'hóu',  # 𡹵
    0x21E76: 'yǎn',  # 𡹶
    0x21E77: 'xiáng',  # 𡹷
    0x21E78: 'cōng',  # 𡹸
    0x21E79: 'hú',  # 𡹹
    # 0x21E7A: '',  # 𡹺
    # 0x21E7B: '',  # 𡹻
    0x21E7C: 'àn,yǎn',  # 𡹼
    # 0x21E7D: '',  # 𡹽
    0x21E7E: 'bǐng',  # 𡹾
    # 0x21E7F: '',  # 𡹿
    # 0x21E80: '',  # 𡺀
    # 0x21E81: '',  # 𡺁
    # 0x21E82: '',  # 𡺂
    # 0x21E83: '',  # 𡺃
    # 0x21E84: '',  # 𡺄
    # 0x21E85: '',  # 𡺅
    # 0x21E86: '',  # 𡺆
    0x21E87: 'duǒ',  # 𡺇
    # 0x21E88: '',  # 𡺈
    # 0x21E89: '',  # 𡺉
    # 0x21E8A: '',  # 𡺊
    # 0x21E8B: '',  # 𡺋
    # 0x21E8C: '',  # 𡺌
    # 0x21E8D: '',  # 𡺍
    # 0x21E8E: '',  # 𡺎
    # 0x21E8F: '',  # 𡺏
    0x21E90: 'zhǔ',  # 𡺐
    0x21E91: 'dié',  # 𡺑
    0x21E92: 'yōu',  # 𡺒
    0x21E93: 'qǐ',  # 𡺓
    0x21E94: 'shí',  # 𡺔
    0x21E95: 'xūn',  # 𡺕
    0x21E96: 'yōu',  # 𡺖
    0x21E97: 'kān',  # 𡺗
    0x21E98: 'qiǎo',  # 𡺘
    # 0x21E99: '',  # 𡺙
    # 0x21E9A: '',  # 𡺚
    0x21E9B: 'qiāng,huà',  # 𡺛
    0x21E9C: 'pén',  # 𡺜
    # 0x21E9D: '',  # 𡺝
    0x21E9E: 'shí',  # 𡺞
    0x21E9F: 'quán',  # 𡺟
    # 0x21EA0: '',  # 𡺠
    0x21EA1: 'yíng',  # 𡺡
    # 0x21EA2: '',  # 𡺢
    # 0x21EA3: '',  # 𡺣
    # 0x21EA4: '',  # 𡺤
    # 0x21EA5: '',  # 𡺥
    # 0x21EA6: '',  # 𡺦
    0x21EA7: 'shā',  # 𡺧
    # 0x21EA8: '',  # 𡺨
    # 0x21EA9: '',  # 𡺩
    # 0x21EAA: '',  # 𡺪
    0x21EAB: 'tāo',  # 𡺫
    # 0x21EAC: '',  # 𡺬
    0x21EAD: 'hòng',  # 𡺭
    0x21EAE: 'pǐ',  # 𡺮
    0x21EAF: 'yáo',  # 𡺯
    # 0x21EB0: '',  # 𡺰
    # 0x21EB1: '',  # 𡺱
    0x21EB2: 'jùn',  # 𡺲
    # 0x21EB3: '',  # 𡺳
    0x21EB4: 'tú',  # 𡺴
    0x21EB5: 'chái',  # 𡺵
    # 0x21EB6: '',  # 𡺶
    0x21EB7: 'xià',  # 𡺷
    0x21EB8: 'qí',  # 𡺸
    # 0x21EB9: '',  # 𡺹
    0x21EBA: 'qióng',  # 𡺺
    # 0x21EBB: '',  # 𡺻
    # 0x21EBC: '',  # 𡺼
    0x21EBD: 'jìn',  # 𡺽
    # 0x21EBE: '',  # 𡺾
    # 0x21EBF: '',  # 𡺿
    # 0x21EC0: '',  # 𡻀
    # 0x21EC1: '',  # 𡻁
    # 0x21EC2: '',  # 𡻂
    # 0x21EC3: '',  # 𡻃
    # 0x21EC4: '',  # 𡻄
    # 0x21EC5: '',  # 𡻅
    # 0x21EC6: '',  # 𡻆
    # 0x21EC7: '',  # 𡻇
    0x21EC8: 'zhēn',  # 𡻈
    # 0x21EC9: '',  # 𡻉
    # 0x21ECA: '',  # 𡻊
    # 0x21ECB: '',  # 𡻋
    0x21ECC: 'zhū',  # 𡻌
    # 0x21ECD: '',  # 𡻍
    0x21ECE: 'xī',  # 𡻎
    # 0x21ECF: '',  # 𡻏
    0x21ED0: 'wēng',  # 𡻐
    0x21ED1: 'zhǒng',  # 𡻑
    0x21ED2: 'wù,máo',  # 𡻒
    # 0x21ED3: '',  # 𡻓
    # 0x21ED4: '',  # 𡻔
    # 0x21ED5: '',  # 𡻕
    # 0x21ED6: '',  # 𡻖
    # 0x21ED7: '',  # 𡻗
    0x21ED8: 'kē',  # 𡻘
    0x21ED9: 'kuò',  # 𡻙
    0x21EDA: 'kǎng',  # 𡻚
    # 0x21EDB: '',  # 𡻛
    # 0x21EDC: '',  # 𡻜
    0x21EDD: 'cháo',  # 𡻝
    0x21EDE: 'bì',  # 𡻞
    0x21EDF: 'mò',  # 𡻟
    0x21EE0: 'zhù',  # 𡻠
    0x21EE1: 'hàn,yán',  # 𡻡
    0x21EE2: 'yǔ',  # 𡻢
    0x21EE3: 'yí',  # 𡻣
    0x21EE4: 'má',  # 𡻤
    # 0x21EE5: '',  # 𡻥
    # 0x21EE6: '',  # 𡻦
    0x21EE7: 'qì',  # 𡻧
    0x21EE8: 'gùn',  # 𡻨
    0x21EE9: 'màn',  # 𡻩
    0x21EEA: 'liáo,liù',  # 𡻪
    0x21EEB: 'lín',  # 𡻫
    0x21EEC: 'zú',  # 𡻬
    0x21EED: 'lěi',  # 𡻭
    0x21EEE: 'hù',  # 𡻮
    0x21EEF: 'chuǎng',  # 𡻯
    0x21EF0: 'qì',  # 𡻰
    0x21EF1: 'léi',  # 𡻱
    # 0x21EF2: '',  # 𡻲
    # 0x21EF3: '',  # 𡻳
    # 0x21EF4: '',  # 𡻴
    # 0x21EF5: '',  # 𡻵
    # 0x21EF6: '',  # 𡻶
    # 0x21EF7: '',  # 𡻷
    # 0x21EF8: '',  # 𡻸
    # 0x21EF9: '',  # 𡻹
    # 0x21EFA: '',  # 𡻺
    # 0x21EFB: '',  # 𡻻
    # 0x21EFC: '',  # 𡻼
    # 0x21EFD: '',  # 𡻽
    # 0x21EFE: '',  # 𡻾
    # 0x21EFF: '',  # 𡻿
    0x21F00: 'huà',  # 𡼀
    0x21F01: 'chī',  # 𡼁
    # 0x21F02: '',  # 𡼂
    0x21F03: 'pó',  # 𡼃
    0x21F04: 'dié',  # 𡼄
    # 0x21F05: '',  # 𡼅
    # 0x21F06: '',  # 𡼆
    # 0x21F07: '',  # 𡼇
    # 0x21F08: '',  # 𡼈
    # 0x21F09: '',  # 𡼉
    0x21F0A: 'lěi',  # 𡼊
    # 0x21F0B: '',  # 𡼋
    # 0x21F0C: '',  # 𡼌
    # 0x21F0D: '',  # 𡼍
    0x21F0E: 'yǐ',  # 𡼎
    # 0x21F0F: '',  # 𡼏
    0x21F10: 'mín',  # 𡼐
    # 0x21F11: '',  # 𡼑
    # 0x21F12: '',  # 𡼒
    0x21F13: 'diàn',  # 𡼓
    # 0x21F14: '',  # 𡼔
    # 0x21F15: '',  # 𡼕
    0x21F16: 'dūn',  # 𡼖
    0x21F17: 'gāo',  # 𡼗
    0x21F18: 'hū',  # 𡼘
    # 0x21F19: '',  # 𡼙
    0x21F1A: 'xiāo',  # 𡼚
    0x21F1B: 'gá',  # 𡼛
    0x21F1C: 'pēng',  # 𡼜
    # 0x21F1D: '',  # 𡼝
    # 0x21F1E: '',  # 𡼞
    # 0x21F1F: '',  # 𡼟
    # 0x21F20: '',  # 𡼠
    # 0x21F21: '',  # 𡼡
    # 0x21F22: '',  # 𡼢
    # 0x21F23: '',  # 𡼣
    # 0x21F24: '',  # 𡼤
    # 0x21F25: '',  # 𡼥
    # 0x21F26: '',  # 𡼦
    # 0x21F27: '',  # 𡼧
    # 0x21F28: '',  # 𡼨
    # 0x21F29: '',  # 𡼩
    # 0x21F2A: '',  # 𡼪
    # 0x21F2B: '',  # 𡼫
    0x21F2C: 'shěn',  # 𡼬
    # 0x21F2D: '',  # 𡼭
    # 0x21F2E: '',  # 𡼮
    # 0x21F2F: '',  # 𡼯
    # 0x21F30: '',  # 𡼰
    0x21F31: 'wéi',  # 𡼱
    # 0x21F32: '',  # 𡼲
    # 0x21F33: '',  # 𡼳
    # 0x21F34: '',  # 𡼴
    # 0x21F35: '',  # 𡼵
    # 0x21F36: '',  # 𡼶
    # 0x21F37: '',  # 𡼷
    # 0x21F38: '',  # 𡼸
    # 0x21F39: '',  # 𡼹
    # 0x21F3A: '',  # 𡼺
    0x21F3B: 'duì',  # 𡼻
    0x21F3C: 'cháo',  # 𡼼
    0x21F3D: 'yǐn',  # 𡼽
    0x21F3E: 'kuài',  # 𡼾
    0x21F3F: 'kū',  # 𡼿
    # 0x21F40: '',  # 𡽀
    0x21F41: 'zuì',  # 𡽁
    0x21F42: 'gǔ',  # 𡽂
    0x21F43: 'duò',  # 𡽃
    # 0x21F44: '',  # 𡽄
    0x21F45: 'yùn',  # 𡽅
    0x21F46: 'zhì',  # 𡽆
    # 0x21F47: '',  # 𡽇
    # 0x21F48: '',  # 𡽈
    0x21F49: 'jì',  # 𡽉
    0x21F4A: 'chēng',  # 𡽊
    # 0x21F4B: '',  # 𡽋
    # 0x21F4C: '',  # 𡽌
    # 0x21F4D: '',  # 𡽍
    # 0x21F4E: '',  # 𡽎
    # 0x21F4F: '',  # 𡽏
    # 0x21F50: '',  # 𡽐
    # 0x21F51: '',  # 𡽑
    # 0x21F52: '',  # 𡽒
    # 0x21F53: '',  # 𡽓
    # 0x21F54: '',  # 𡽔
    0x21F55: 'zuì',  # 𡽕
    0x21F56: 'xiè',  # 𡽖
    # 0x21F57: '',  # 𡽗
    # 0x21F58: '',  # 𡽘
    # 0x21F59: '',  # 𡽙
    # 0x21F5A: '',  # 𡽚
    0x21F5B: 'zuǐ',  # 𡽛
    0x21F5C: 'án',  # 𡽜
    0x21F5D: 'hāo',  # 𡽝
    # 0x21F5E: '',  # 𡽞
    # 0x21F5F: '',  # 𡽟
    0x21F60: 'pǒ',  # 𡽠
    # 0x21F61: '',  # 𡽡
    0x21F62: 'dí',  # 𡽢
    0x21F63: 'yè',  # 𡽣
    # 0x21F64: '',  # 𡽤
    # 0x21F65: '',  # 𡽥
    # 0x21F66: '',  # 𡽦
    0x21F67: 'náo',  # 𡽧
    # 0x21F68: '',  # 𡽨
    # 0x21F69: '',  # 𡽩
    # 0x21F6A: '',  # 𡽪
    # 0x21F6B: '',  # 𡽫
    # 0x21F6C: '',  # 𡽬
    # 0x21F6D: '',  # 𡽭
    # 0x21F6E: '',  # 𡽮
    # 0x21F6F: '',  # 𡽯
    # 0x21F70: '',  # 𡽰
    0x21F71: 'jié',  # 𡽱
    0x21F72: 'bàng',  # 𡽲
    0x21F73: 'lǎn',  # 𡽳
    0x21F74: 'cáng',  # 𡽴
    # 0x21F75: '',  # 𡽵
    0x21F76: 'bì',  # 𡽶
    # 0x21F77: '',  # 𡽷
    # 0x21F78: '',  # 𡽸
    # 0x21F79: '',  # 𡽹
    # 0x21F7A: '',  # 𡽺
    0x21F7B: 'zhǎn',  # 𡽻
    0x21F7C: 'qì',  # 𡽼
    # 0x21F7D: '',  # 𡽽
    # 0x21F7E: '',  # 𡽾
    # 0x21F7F: '',  # 𡽿
    # 0x21F80: '',  # 𡾀
    # 0x21F81: '',  # 𡾁
    0x21F82: 'náo',  # 𡾂
    # 0x21F83: '',  # 𡾃
    # 0x21F84: '',  # 𡾄
    0x21F85: 'lǜ',  # 𡾅
    # 0x21F86: '',  # 𡾆
    0x21F87: 'kuàng',  # 𡾇
    # 0x21F88: '',  # 𡾈
    0x21F89: 'mó',  # 𡾉
    # 0x21F8A: '',  # 𡾊
    0x21F8B: 'lěi,léi',  # 𡾋
    0x21F8C: 'páo',  # 𡾌
    # 0x21F8D: '',  # 𡾍
    # 0x21F8E: '',  # 𡾎
    # 0x21F8F: '',  # 𡾏
    # 0x21F90: '',  # 𡾐
    # 0x21F91: '',  # 𡾑
    0x21F92: 'lì',  # 𡾒
    0x21F93: 'céng',  # 𡾓
    # 0x21F94: '',  # 𡾔
    0x21F95: 'dàng',  # 𡾕
    0x21F96: 'lěi',  # 𡾖
    # 0x21F97: '',  # 𡾗
    # 0x21F98: '',  # 𡾘
    0x21F99: 'è',  # 𡾙
    # 0x21F9A: '',  # 𡾚
    0x21F9B: 'bèng',  # 𡾛
    0x21F9C: 'jué,huò',  # 𡾜
    0x21F9D: 'huái',  # 𡾝
    # 0x21F9E: '',  # 𡾞
    # 0x21F9F: '',  # 𡾟
    # 0x21FA0: '',  # 𡾠
    # 0x21FA1: '',  # 𡾡
    # 0x21FA2: '',  # 𡾢
    # 0x21FA3: '',  # 𡾣
    # 0x21FA4: '',  # 𡾤
    0x21FA5: 'xuán',  # 𡾥
    0x21FA6: 'niè',  # 𡾦
    # 0x21FA7: '',  # 𡾧
    0x21FA8: 'hài',  # 𡾨
    # 0x21FA9: '',  # 𡾩
    # 0x21FAA: '',  # 𡾪
    # 0x21FAB: '',  # 𡾫
    # 0x21FAC: '',  # 𡾬
    # 0x21FAD: '',  # 𡾭
    0x21FAE: 'xiǎn',  # 𡾮
    # 0x21FAF: '',  # 𡾯
    0x21FB0: 'jiǎn',  # 𡾰
    0x21FB1: 'mí',  # 𡾱
    0x21FB2: 'niè',  # 𡾲
    # 0x21FB3: '',  # 𡾳
    # 0x21FB4: '',  # 𡾴
    # 0x21FB5: '',  # 𡾵
    # 0x21FB6: '',  # 𡾶
    # 0x21FB7: '',  # 𡾷
    # 0x21FB8: '',  # 𡾸
    # 0x21FB9: '',  # 𡾹
    # 0x21FBA: '',  # 𡾺
    0x21FBB: 'cáng',  # 𡾻
    0x21FBC: 'sǒng',  # 𡾼
    0x21FBD: 'zēng',  # 𡾽
    0x21FBE: 'yì',  # 𡾾
    # 0x21FBF: '',  # 𡾿
    # 0x21FC0: '',  # 𡿀
    # 0x21FC1: '',  # 𡿁
    0x21FC2: 'chóng',  # 𡿂
    # 0x21FC3: '',  # 𡿃
    0x21FC4: 'cáng',  # 𡿄
    # 0x21FC5: '',  # 𡿅
    # 0x21FC6: '',  # 𡿆
    # 0x21FC7: '',  # 𡿇
    # 0x21FC8: '',  # 𡿈
    0x21FC9: 'lěi',  # 𡿉
    0x21FCA: 'nuó',  # 𡿊
    0x21FCB: 'lì',  # 𡿋
    # 0x21FCC: '',  # 𡿌
    # 0x21FCD: '',  # 𡿍
    0x21FCE: 'lí',  # 𡿎
    0x21FCF: 'luó',  # 𡿏
    # 0x21FD0: '',  # 𡿐
    # 0x21FD1: '',  # 𡿑
    # 0x21FD2: '',  # 𡿒
    0x21FD3: 'tǎng',  # 𡿓
    # 0x21FD4: '',  # 𡿔
    # 0x21FD5: '',  # 𡿕
    0x21FD6: 'niè,yà',  # 𡿖
    0x21FD7: 'niè',  # 𡿗
    # 0x21FD8: '',  # 𡿘
    0x21FD9: 'jī',  # 𡿙
    # 0x21FDA: '',  # 𡿚
    0x21FDB: 'lěi',  # 𡿛
    # 0x21FDC: '',  # 𡿜
    0x21FDD: 'nàng',  # 𡿝
    # 0x21FDE: '',  # 𡿞
    # 0x21FDF: '',  # 𡿟
    0x21FE0: 'lín',  # 𡿠
    0x21FE1: 'líng',  # 𡿡
    # 0x21FE2: '',  # 𡿢
    # 0x21FE3: '',  # 𡿣
    0x21FE4: 'xián',  # 𡿤
    0x21FE5: 'yù',  # 𡿥
    # 0x21FE6: '',  # 𡿦
    0x21FE7: 'zāi',  # 𡿧
    0x21FE8: 'quǎn',  # 𡿨
    0x21FE9: 'liè',  # 𡿩
    0x21FEA: 'liè',  # 𡿪
    # 0x21FEB: '',  # 𡿫
    # 0x21FEC: '',  # 𡿬
    # 0x21FED: '',  # 𡿭
    # 0x21FEE: '',  # 𡿮
    0x21FEF: 'yù',  # 𡿯
    0x21FF0: 'huāng',  # 𡿰
    # 0x21FF1: '',  # 𡿱
    # 0x21FF2: '',  # 𡿲
    # 0x21FF3: '',  # 𡿳
    # 0x21FF4: '',  # 𡿴
    # 0x21FF5: '',  # 𡿵
    # 0x21FF6: '',  # 𡿶
    # 0x21FF7: '',  # 𡿷
    # 0x21FF8: '',  # 𡿸
    # 0x21FF9: '',  # 𡿹
    0x21FFA: 'nǎo',  # 𡿺
    # 0x21FFB: '',  # 𡿻
    0x21FFC: 'xùn',  # 𡿼
    # 0x21FFD: '',  # 𡿽
    0x21FFE: 'jú',  # 𡿾
    0x21FFF: 'huò',  # 𡿿
    # 0x22000: '',  # 𢀀
    0x22001: 'yì',  # 𢀁
    # 0x22002: '',  # 𢀂
    # 0x22003: '',  # 𢀃
    # 0x22004: '',  # 𢀄
    # 0x22005: '',  # 𢀅
    # 0x22006: '',  # 𢀆
    # 0x22007: '',  # 𢀇
    # 0x22008: '',  # 𢀈
    # 0x22009: '',  # 𢀉
    0x2200A: 'xī',  # 𢀊
    0x2200B: 'sè',  # 𢀋
    0x2200C: 'jiǎo',  # 𢀌
    0x2200D: 'yōng',  # 𢀍
    # 0x2200E: '',  # 𢀎
    # 0x2200F: '',  # 𢀏
    # 0x22010: '',  # 𢀐
    # 0x22011: '',  # 𢀑
    # 0x22012: '',  # 𢀒
    0x22013: 'jù',  # 𢀓
    # 0x22014: '',  # 𢀔
    0x22015: 'shī',  # 𢀕
    0x22016: 'jīng',  # 𢀖
    0x22017: 'wàn',  # 𢀗
    0x22018: 'yě',  # 𢀘
    0x22019: 'jiū',  # 𢀙
    # 0x2201A: '',  # 𢀚
    # 0x2201B: '',  # 𢀛
    0x2201C: 'gǒng',  # 𢀜
    # 0x2201D: '',  # 𢀝
    # 0x2201E: '',  # 𢀞
    # 0x2201F: '',  # 𢀟
    # 0x22020: '',  # 𢀠
    0x22021: 'huī,zuǒ',  # 𢀡
    # 0x22022: '',  # 𢀢
    # 0x22023: '',  # 𢀣
    # 0x22024: '',  # 𢀤
    # 0x22025: '',  # 𢀥
    # 0x22026: '',  # 𢀦
    # 0x22027: '',  # 𢀧
    # 0x22028: '',  # 𢀨
    # 0x22029: '',  # 𢀩
    0x2202A: 'ěr',  # 𢀪
    # 0x2202B: '',  # 𢀫
    # 0x2202C: '',  # 𢀬
    # 0x2202D: '',  # 𢀭
    # 0x2202E: '',  # 𢀮
    # 0x2202F: '',  # 𢀯
    # 0x22030: '',  # 𢀰
    # 0x22031: '',  # 𢀱
    # 0x22032: '',  # 𢀲
    # 0x22033: '',  # 𢀳
    # 0x22034: '',  # 𢀴
    0x22035: 'hàn',  # 𢀵
    # 0x22036: '',  # 𢀶
    # 0x22037: '',  # 𢀷
    # 0x22038: '',  # 𢀸
    # 0x22039: '',  # 𢀹
    # 0x2203A: '',  # 𢀺
    # 0x2203B: '',  # 𢀻
    0x2203C: 'fú',  # 𢀼
    # 0x2203D: '',  # 𢀽
    # 0x2203E: '',  # 𢀾
    # 0x2203F: '',  # 𢀿
    0x22040: 'fú',  # 𢁀
    0x22041: 'zhuó',  # 𢁁
    0x22042: 'jī,jì',  # 𢁂
    # 0x22043: '',  # 𢁃
    # 0x22044: '',  # 𢁄
    # 0x22045: '',  # 𢁅
    # 0x22046: '',  # 𢁆
    # 0x22047: '',  # 𢁇
    # 0x22048: '',  # 𢁈
    # 0x22049: '',  # 𢁉
    # 0x2204A: '',  # 𢁊
    # 0x2204B: '',  # 𢁋
    # 0x2204C: '',  # 𢁌
    # 0x2204D: '',  # 𢁍
    # 0x2204E: '',  # 𢁎
    0x2204F: 'bāng',  # 𢁏
    # 0x22050: '',  # 𢁐
    # 0x22051: '',  # 𢁑
    0x22052: 'qí',  # 𢁒
    0x22053: 'shǐ,hài',  # 𢁓
    # 0x22054: '',  # 𢁔
    0x22055: 'diǎo',  # 𢁕
    0x22056: 'pèi',  # 𢁖
    0x22057: 'xiǎn,gàn',  # 𢁗
    0x22058: 'sān',  # 𢁘
    # 0x22059: '',  # 𢁙
    # 0x2205A: '',  # 𢁚
    # 0x2205B: '',  # 𢁛
    # 0x2205C: '',  # 𢁜
    0x2205D: 'cháng',  # 𢁝
    0x2205E: 'yuē',  # 𢁞
    # 0x2205F: '',  # 𢁟
    0x22060: 'gōng',  # 𢁠
    # 0x22061: '',  # 𢁡
    0x22062: 'wū',  # 𢁢
    # 0x22063: '',  # 𢁣
    0x22064: 'fēn',  # 𢁤
    0x22065: 'fēn',  # 𢁥
    # 0x22066: '',  # 𢁦
    0x22067: 'chǎn',  # 𢁧
    # 0x22068: '',  # 𢁨
    0x22069: 'nèi',  # 𢁩
    0x2206A: 'jué',  # 𢁪
    # 0x2206B: '',  # 𢁫
    0x2206C: 'zhǎo',  # 𢁬
    # 0x2206D: '',  # 𢁭
    0x2206E: 'qián',  # 𢁮
    # 0x2206F: '',  # 𢁯
    # 0x22070: '',  # 𢁰
    0x22071: 'ǎo',  # 𢁱
    # 0x22072: '',  # 𢁲
    # 0x22073: '',  # 𢁳
    # 0x22074: '',  # 𢁴
    # 0x22075: '',  # 𢁵
    0x22076: 'wǎng',  # 𢁶
    0x22077: 'zhōng',  # 𢁷
    # 0x22078: '',  # 𢁸
    0x22079: 'huāng',  # 𢁹
    # 0x2207A: '',  # 𢁺
    0x2207B: 'bù',  # 𢁻
    0x2207C: 'zhǔ',  # 𢁼
    0x2207D: 'bì',  # 𢁽
    0x2207E: 'chāo',  # 𢁾
    0x2207F: 'zhēng',  # 𢁿
    0x22080: 'fú',  # 𢂀
    0x22081: 'kōu,qú',  # 𢂁
    # 0x22082: '',  # 𢂂
    0x22083: 'zuó',  # 𢂃
    0x22084: 'xuàn',  # 𢂄
    # 0x22085: '',  # 𢂅
    0x22086: 'fù',  # 𢂆
    # 0x22087: '',  # 𢂇
    # 0x22088: '',  # 𢂈
    # 0x22089: '',  # 𢂉
    0x2208A: 'yǎo',  # 𢂊
    # 0x2208B: '',  # 𢂋
    # 0x2208C: '',  # 𢂌
    0x2208D: 'bō',  # 𢂍
    # 0x2208E: '',  # 𢂎
    0x2208F: 'bèi',  # 𢂏
    0x22090: 'xié',  # 𢂐
    0x22091: 'shì',  # 𢂑
    0x22092: 'yí',  # 𢂒
    # 0x22093: '',  # 𢂓
    0x22094: 'hóng',  # 𢂔
    0x22095: 'cuì',  # 𢂕
    # 0x22096: '',  # 𢂖
    0x22097: 'yì',  # 𢂗
    0x22098: 'zhuān',  # 𢂘
    # 0x22099: '',  # 𢂙
    # 0x2209A: '',  # 𢂚
    # 0x2209B: '',  # 𢂛
    # 0x2209C: '',  # 𢂜
    0x2209D: 'chì',  # 𢂝
    # 0x2209E: '',  # 𢂞
    # 0x2209F: '',  # 𢂟
    # 0x220A0: '',  # 𢂠
    # 0x220A1: '',  # 𢂡
    # 0x220A2: '',  # 𢂢
    # 0x220A3: '',  # 𢂣
    0x220A4: 'pō,lù',  # 𢂤
    # 0x220A5: '',  # 𢂥
    # 0x220A6: '',  # 𢂦
    # 0x220A7: '',  # 𢂧
    0x220A8: 'yín',  # 𢂨
    # 0x220A9: '',  # 𢂩
    # 0x220AA: '',  # 𢂪
    # 0x220AB: '',  # 𢂫
    # 0x220AC: '',  # 𢂬
    # 0x220AD: '',  # 𢂭
    # 0x220AE: '',  # 𢂮
    # 0x220AF: '',  # 𢂯
    # 0x220B0: '',  # 𢂰
    0x220B1: 'yuàn',  # 𢂱
    # 0x220B2: '',  # 𢂲
    # 0x220B3: '',  # 𢂳
    # 0x220B4: '',  # 𢂴
    # 0x220B5: '',  # 𢂵
    0x220B6: 'jiōng',  # 𢂶
    0x220B7: 'jiá',  # 𢂷
    # 0x220B8: '',  # 𢂸
    0x220B9: 'mào',  # 𢂹
    0x220BA: 'qiàn',  # 𢂺
    # 0x220BB: '',  # 𢂻
    0x220BC: 'yì',  # 𢂼
    # 0x220BD: '',  # 𢂽
    # 0x220BE: '',  # 𢂾
    # 0x220BF: '',  # 𢂿
    0x220C0: 'wú',  # 𢃀
    # 0x220C1: '',  # 𢃁
    # 0x220C2: '',  # 𢃂
    # 0x220C3: '',  # 𢃃
    # 0x220C4: '',  # 𢃄
    # 0x220C5: '',  # 𢃅
    # 0x220C6: '',  # 𢃆
    # 0x220C7: '',  # 𢃇
    # 0x220C8: '',  # 𢃈
    # 0x220C9: '',  # 𢃉
    # 0x220CA: '',  # 𢃊
    # 0x220CB: '',  # 𢃋
    # 0x220CC: '',  # 𢃌
    0x220CD: 'bēi',  # 𢃍
    0x220CE: 'huò',  # 𢃎
    0x220CF: 'cóng',  # 𢃏
    0x220D0: 'kōng',  # 𢃐
    # 0x220D1: '',  # 𢃑
    # 0x220D2: '',  # 𢃒
    # 0x220D3: '',  # 𢃓
    # 0x220D4: '',  # 𢃔
    0x220D5: 'tà',  # 𢃕
    # 0x220D6: '',  # 𢃖
    0x220D7: 'hàn',  # 𢃗
    0x220D8: 'qiàn',  # 𢃘
    # 0x220D9: '',  # 𢃙
    # 0x220DA: '',  # 𢃚
    0x220DB: 'qí',  # 𢃛
    0x220DC: 'zhí',  # 𢃜
    # 0x220DD: '',  # 𢃝
    # 0x220DE: '',  # 𢃞
    # 0x220DF: '',  # 𢃟
    # 0x220E0: '',  # 𢃠
    # 0x220E1: '',  # 𢃡
    0x220E2: 'sè',  # 𢃢
    # 0x220E3: '',  # 𢃣
    # 0x220E4: '',  # 𢃤
    0x220E5: 'qiān',  # 𢃥
    0x220E6: 'guǒ',  # 𢃦
    # 0x220E7: '',  # 𢃧
    # 0x220E8: '',  # 𢃨
    0x220E9: 'gǔn,juǎn',  # 𢃩
    # 0x220EA: '',  # 𢃪
    # 0x220EB: '',  # 𢃫
    0x220EC: 'jiān',  # 𢃬
    0x220ED: 'zhōng',  # 𢃭
    0x220EE: 'miǎn',  # 𢃮
    0x220EF: 'guǐ',  # 𢃯
    0x220F0: 'shì',  # 𢃰
    0x220F1: 'móu',  # 𢃱
    0x220F2: 'è',  # 𢃲
    0x220F3: 'bǎ',  # 𢃳
    0x220F4: 'là',  # 𢃴
    # 0x220F5: '',  # 𢃵
    # 0x220F6: '',  # 𢃶
    # 0x220F7: '',  # 𢃷
    0x220F8: 'zhòu',  # 𢃸
    # 0x220F9: '',  # 𢃹
    0x220FA: 'jí',  # 𢃺
    # 0x220FB: '',  # 𢃻
    # 0x220FC: '',  # 𢃼
    # 0x220FD: '',  # 𢃽
    # 0x220FE: '',  # 𢃾
    # 0x220FF: '',  # 𢃿
    0x22100: 'zǎo',  # 𢄀
    # 0x22101: '',  # 𢄁
    # 0x22102: '',  # 𢄂
    # 0x22103: '',  # 𢄃
    0x22104: 'zhā',  # 𢄄
    0x22105: 'yì',  # 𢄅
    # 0x22106: '',  # 𢄆
    0x22107: 'gǒu',  # 𢄇
    # 0x22108: '',  # 𢄈
    # 0x22109: '',  # 𢄉
    0x2210A: 'guī',  # 𢄊
    0x2210B: 'yīng',  # 𢄋
    0x2210C: 'shǎi',  # 𢄌
    0x2210D: 'hé,gé',  # 𢄍
    0x2210E: 'bàng',  # 𢄎
    0x2210F: 'mò',  # 𢄏
    0x22110: 'méng',  # 𢄐
    # 0x22111: '',  # 𢄑
    # 0x22112: '',  # 𢄒
    0x22113: 'wù',  # 𢄓
    0x22114: 'dài',  # 𢄔
    # 0x22115: '',  # 𢄕
    # 0x22116: '',  # 𢄖
    0x22117: 'jiǒng',  # 𢄗
    # 0x22118: '',  # 𢄘
    # 0x22119: '',  # 𢄙
    # 0x2211A: '',  # 𢄚
    # 0x2211B: '',  # 𢄛
    0x2211C: 'hàn',  # 𢄜
    # 0x2211D: '',  # 𢄝
    # 0x2211E: '',  # 𢄞
    0x2211F: 'tōng',  # 𢄟
    0x22120: 'kōu',  # 𢄠
    0x22121: 'lí',  # 𢄡
    0x22122: 'zhì',  # 𢄢
    0x22123: 'huì',  # 𢄣
    0x22124: 'zǎn',  # 𢄤
    0x22125: 'yì',  # 𢄥
    0x22126: 'diǎo',  # 𢄦
    0x22127: 'cù',  # 𢄧
    # 0x22128: '',  # 𢄨
    # 0x22129: '',  # 𢄩
    # 0x2212A: '',  # 𢄪
    # 0x2212B: '',  # 𢄫
    # 0x2212C: '',  # 𢄬
    # 0x2212D: '',  # 𢄭
    # 0x2212E: '',  # 𢄮
    # 0x2212F: '',  # 𢄯
    # 0x22130: '',  # 𢄰
    0x22131: 'zhì',  # 𢄱
    # 0x22132: '',  # 𢄲
    0x22133: 'kuǎ',  # 𢄳
    # 0x22134: '',  # 𢄴
    0x22135: 'xiàng',  # 𢄵
    0x22136: 'huà',  # 𢄶
    0x22137: 'liáo',  # 𢄷
    0x22138: 'cuì',  # 𢄸
    0x22139: 'qiāo',  # 𢄹
    0x2213A: 'jiǎo',  # 𢄺
    # 0x2213B: '',  # 𢄻
    0x2213C: 'xū',  # 𢄼
    0x2213D: 'èr',  # 𢄽
    # 0x2213E: '',  # 𢄾
    0x2213F: 'tuō',  # 𢄿
    0x22140: 'tán',  # 𢅀
    0x22141: 'zhì',  # 𢅁
    # 0x22142: '',  # 𢅂
    # 0x22143: '',  # 𢅃
    # 0x22144: '',  # 𢅄
    # 0x22145: '',  # 𢅅
    # 0x22146: '',  # 𢅆
    # 0x22147: '',  # 𢅇
    0x22148: 'nǎo',  # 𢅈
    0x22149: 'mào',  # 𢅉
    0x2214A: 'dì',  # 𢅊
    0x2214B: 'céng',  # 𢅋
    # 0x2214C: '',  # 𢅌
    # 0x2214D: '',  # 𢅍
    0x2214E: 'jiǎo',  # 𢅎
    0x2214F: 'lián',  # 𢅏
    # 0x22150: '',  # 𢅐
    0x22151: 'shā',  # 𢅑
    0x22152: 'dàn',  # 𢅒
    # 0x22153: '',  # 𢅓
    # 0x22154: '',  # 𢅔
    0x22155: 'suì',  # 𢅕
    # 0x22156: '',  # 𢅖
    0x22157: 'guò',  # 𢅗
    # 0x22158: '',  # 𢅘
    # 0x22159: '',  # 𢅙
    0x2215A: 'biǎo,biāo',  # 𢅚
    # 0x2215B: '',  # 𢅛
    0x2215C: 'cì',  # 𢅜
    0x2215D: 'diàn',  # 𢅝
    0x2215E: 'lǜ',  # 𢅞
    0x2215F: 'nǐ',  # 𢅟
    0x22160: 'yǎn',  # 𢅠
    0x22161: 'lán',  # 𢅡
    # 0x22162: '',  # 𢅢
    # 0x22163: '',  # 𢅣
    0x22164: 'gài',  # 𢅤
    0x22165: 'chú',  # 𢅥
    # 0x22166: '',  # 𢅦
    # 0x22167: '',  # 𢅧
    # 0x22168: '',  # 𢅨
    0x22169: 'bì',  # 𢅩
    0x2216A: 'zú',  # 𢅪
    0x2216B: 'huì',  # 𢅫
    # 0x2216C: '',  # 𢅬
    0x2216D: 'lǎi',  # 𢅭
    0x2216E: 'xián',  # 𢅮
    0x2216F: 'fèn',  # 𢅯
    0x22170: 'hè',  # 𢅰
    # 0x22171: '',  # 𢅱
    # 0x22172: '',  # 𢅲
    # 0x22173: '',  # 𢅳
    # 0x22174: '',  # 𢅴
    # 0x22175: '',  # 𢅵
    # 0x22176: '',  # 𢅶
    # 0x22177: '',  # 𢅷
    # 0x22178: '',  # 𢅸
    0x22179: 'yào',  # 𢅹
    0x2217A: 'zhǎn',  # 𢅺
    # 0x2217B: '',  # 𢅻
    0x2217C: 'néi',  # 𢅼
    # 0x2217D: '',  # 𢅽
    0x2217E: 'luǒ',  # 𢅾
    # 0x2217F: '',  # 𢅿
    0x22180: 'yuán',  # 𢆀
    # 0x22181: '',  # 𢆁
    0x22182: 'néng',  # 𢆂
    # 0x22183: '',  # 𢆃
    # 0x22184: '',  # 𢆄
    # 0x22185: '',  # 𢆅
    # 0x22186: '',  # 𢆆
    # 0x22187: '',  # 𢆇
    # 0x22188: '',  # 𢆈
    0x22189: 'rěn',  # 𢆉
    # 0x2218A: '',  # 𢆊
    # 0x2218B: '',  # 𢆋
    # 0x2218C: '',  # 𢆌
    0x2218D: 'chā',  # 𢆍
    # 0x2218E: '',  # 𢆎
    # 0x2218F: '',  # 𢆏
    # 0x22190: '',  # 𢆐
    # 0x22191: '',  # 𢆑
    # 0x22192: '',  # 𢆒
    # 0x22193: '',  # 𢆓
    # 0x22194: '',  # 𢆔
    # 0x22195: '',  # 𢆕
    # 0x22196: '',  # 𢆖
    # 0x22197: '',  # 𢆗
    # 0x22198: '',  # 𢆘
    # 0x22199: '',  # 𢆙
    # 0x2219A: '',  # 𢆚
    # 0x2219B: '',  # 𢆛
    0x2219C: 'gé',  # 𢆜
    # 0x2219D: '',  # 𢆝
    0x2219E: 'jiǎn',  # 𢆞
    0x2219F: 'píng',  # 𢆟
    # 0x221A0: '',  # 𢆠
    0x221A1: 'niān',  # 𢆡
    # 0x221A2: '',  # 𢆢
    0x221A3: 'biè',  # 𢆣
    # 0x221A4: '',  # 𢆤
    # 0x221A5: '',  # 𢆥
    0x221A6: 'jiàn',  # 𢆦
    # 0x221A7: '',  # 𢆧
    # 0x221A8: '',  # 𢆨
    0x221A9: 'bìng',  # 𢆩
    # 0x221AA: '',  # 𢆪
    # 0x221AB: '',  # 𢆫
    # 0x221AC: '',  # 𢆬
    # 0x221AD: '',  # 𢆭
    # 0x221AE: '',  # 𢆮
    0x221AF: 'mì,xuán',  # 𢆯
    0x221B0: 'hù',  # 𢆰
    # 0x221B1: '',  # 𢆱
    # 0x221B2: '',  # 𢆲
    # 0x221B3: '',  # 𢆳
    0x221B4: 'diǎo',  # 𢆴
    # 0x221B5: '',  # 𢆵
    0x221B6: 'yōu,zī',  # 𢆶
    0x221B7: 'yāo,miào',  # 𢆷
    0x221B8: 'bēng',  # 𢆸
    # 0x221B9: '',  # 𢆹
    0x221BA: 'chén',  # 𢆺
    0x221BB: 'jī,duì',  # 𢆻
    # 0x221BC: '',  # 𢆼
    0x221BD: 'yāo',  # 𢆽
    # 0x221BE: '',  # 𢆾
    # 0x221BF: '',  # 𢆿
    # 0x221C0: '',  # 𢇀
    # 0x221C1: '',  # 𢇁
    # 0x221C2: '',  # 𢇂
    # 0x221C3: '',  # 𢇃
    # 0x221C4: '',  # 𢇄
    0x221C5: 'guān',  # 𢇅
    # 0x221C6: '',  # 𢇆
    0x221C7: 'guān',  # 𢇇
    0x221C8: 'yàn',  # 𢇈
    # 0x221C9: '',  # 𢇉
    # 0x221CA: '',  # 𢇊
    # 0x221CB: '',  # 𢇋
    # 0x221CC: '',  # 𢇌
    # 0x221CD: '',  # 𢇍
    # 0x221CE: '',  # 𢇎
    # 0x221CF: '',  # 𢇏
    # 0x221D0: '',  # 𢇐
    # 0x221D1: '',  # 𢇑
    # 0x221D2: '',  # 𢇒
    # 0x221D3: '',  # 𢇓
    # 0x221D4: '',  # 𢇔
    0x221D5: 'chǐ',  # 𢇕
    # 0x221D6: '',  # 𢇖
    0x221D7: 'shà',  # 𢇗
    0x221D8: 'yǎn',  # 𢇘
    0x221D9: 'yì',  # 𢇙
    0x221DA: 'yì',  # 𢇚
    0x221DB: 'chè,chǐ',  # 𢇛
    # 0x221DC: '',  # 𢇜
    # 0x221DD: '',  # 𢇝
    0x221DE: 'hàn',  # 𢇞
    0x221DF: 'huāng',  # 𢇟
    # 0x221E0: '',  # 𢇠
    # 0x221E1: '',  # 𢇡
    # 0x221E2: '',  # 𢇢
    # 0x221E3: '',  # 𢇣
    0x221E4: 'shuì',  # 𢇤
    0x221E5: 'suì',  # 𢇥
    0x221E6: 'rén',  # 𢇦
    0x221E7: 'tán',  # 𢇧
    0x221E8: 'zhǐ',  # 𢇨
    # 0x221E9: '',  # 𢇩
    0x221EA: 'fàn',  # 𢇪
    0x221EB: 'fěng',  # 𢇫
    # 0x221EC: '',  # 𢇬
    # 0x221ED: '',  # 𢇭
    # 0x221EE: '',  # 𢇮
    # 0x221EF: '',  # 𢇯
    0x221F0: 'tán',  # 𢇰
    # 0x221F1: '',  # 𢇱
    0x221F2: 'mí',  # 𢇲
    0x221F3: 'pí',  # 𢇳
    0x221F4: 'bù',  # 𢇴
    0x221F5: 'nà',  # 𢇵
    0x221F6: 'tián',  # 𢇶
    0x221F7: 'bá',  # 𢇷
    0x221F8: 'yì',  # 𢇸
    # 0x221F9: '',  # 𢇹
    # 0x221FA: '',  # 𢇺
    # 0x221FB: '',  # 𢇻
    # 0x221FC: '',  # 𢇼
    # 0x221FD: '',  # 𢇽
    # 0x221FE: '',  # 𢇾
    # 0x221FF: '',  # 𢇿
    # 0x22200: '',  # 𢈀
    # 0x22201: '',  # 𢈁
    0x22202: 'yǎn',  # 𢈂
    # 0x22203: '',  # 𢈃
    0x22204: 'tiāo',  # 𢈄
    # 0x22205: '',  # 𢈅
    0x22206: 'yáo',  # 𢈆
    0x22207: 'shěn',  # 𢈇
    0x22208: 'kē,wā',  # 𢈈
    0x22209: 'tóng',  # 𢈉
    # 0x2220A: '',  # 𢈊
    0x2220B: 'xuǎn',  # 𢈋
    # 0x2220C: '',  # 𢈌
    # 0x2220D: '',  # 𢈍
    # 0x2220E: '',  # 𢈎
    # 0x2220F: '',  # 𢈏
    # 0x22210: '',  # 𢈐
    # 0x22211: '',  # 𢈑
    # 0x22212: '',  # 𢈒
    0x22213: 'yòu',  # 𢈓
    # 0x22214: '',  # 𢈔
    0x22215: 'bài',  # 𢈕
    # 0x22216: '',  # 𢈖
    # 0x22217: '',  # 𢈗
    # 0x22218: '',  # 𢈘
    0x22219: 'xiá',  # 𢈙
    0x2221A: 'lǚ',  # 𢈚
    0x2221B: 'kùn',  # 𢈛
    0x2221C: 'zāng',  # 𢈜
    0x2221D: 'qiú',  # 𢈝
    # 0x2221E: '',  # 𢈞
    # 0x2221F: '',  # 𢈟
    0x22220: 'cù,là',  # 𢈠
    0x22221: 'zuī',  # 𢈡
    0x22222: 'lǒu',  # 𢈢
    # 0x22223: '',  # 𢈣
    0x22224: 'xiá',  # 𢈤
    # 0x22225: '',  # 𢈥
    # 0x22226: '',  # 𢈦
    # 0x22227: '',  # 𢈧
    # 0x22228: '',  # 𢈨
    # 0x22229: '',  # 𢈩
    # 0x2222A: '',  # 𢈪
    # 0x2222B: '',  # 𢈫
    # 0x2222C: '',  # 𢈬
    # 0x2222D: '',  # 𢈭
    # 0x2222E: '',  # 𢈮
    0x2222F: 'shēn',  # 𢈯
    # 0x22230: '',  # 𢈰
    # 0x22231: '',  # 𢈱
    0x22232: 'pú',  # 𢈲
    # 0x22233: '',  # 𢈳
    0x22234: 'jīng',  # 𢈴
    0x22235: 'qiāng',  # 𢈵
    0x22236: 'yì,sī',  # 𢈶
    # 0x22237: '',  # 𢈷
    0x22238: 'niè',  # 𢈸
    0x22239: 'duī,tuí',  # 𢈹
    # 0x2223A: '',  # 𢈺
    0x2223B: 'jié',  # 𢈻
    0x2223C: 'suì',  # 𢈼
    0x2223D: 'zhàn',  # 𢈽
    0x2223E: 'cōu',  # 𢈾
    # 0x2223F: '',  # 𢈿
    # 0x22240: '',  # 𢉀
    0x22241: 'bēng',  # 𢉁
    0x22242: 'guān',  # 𢉂
    0x22243: 'shě',  # 𢉃
    # 0x22244: '',  # 𢉄
    0x22245: 'jìn',  # 𢉅
    0x22246: 'dì',  # 𢉆
    # 0x22247: '',  # 𢉇
    # 0x22248: '',  # 𢉈
    # 0x22249: '',  # 𢉉
    # 0x2224A: '',  # 𢉊
    # 0x2224B: '',  # 𢉋
    # 0x2224C: '',  # 𢉌
    # 0x2224D: '',  # 𢉍
    # 0x2224E: '',  # 𢉎
    # 0x2224F: '',  # 𢉏
    # 0x22250: '',  # 𢉐
    0x22251: 'dān',  # 𢉑
    # 0x22252: '',  # 𢉒
    0x22253: 'nǎi',  # 𢉓
    # 0x22254: '',  # 𢉔
    0x22255: 'nóu',  # 𢉕
    # 0x22256: '',  # 𢉖
    0x22257: 'jí',  # 𢉗
    0x22258: 'yán',  # 𢉘
    # 0x22259: '',  # 𢉙
    0x2225A: 'nòu',  # 𢉚
    # 0x2225B: '',  # 𢉛
    0x2225C: 'dù,tú',  # 𢉜
    0x2225D: 'wèi',  # 𢉝
    0x2225E: 'piān',  # 𢉞
    # 0x2225F: '',  # 𢉟
    # 0x22260: '',  # 𢉠
    # 0x22261: '',  # 𢉡
    0x22262: 'hú',  # 𢉢
    # 0x22263: '',  # 𢉣
    0x22264: 'jià',  # 𢉤
    0x22265: 'yè',  # 𢉥
    0x22266: 'jǔn',  # 𢉦
    0x22267: 'lán,lián',  # 𢉧
    0x22268: 'là',  # 𢉨
    0x22269: 'yīn',  # 𢉩
    # 0x2226A: '',  # 𢉪
    # 0x2226B: '',  # 𢉫
    # 0x2226C: '',  # 𢉬
    0x2226D: 'tuí',  # 𢉭
    # 0x2226E: '',  # 𢉮
    # 0x2226F: '',  # 𢉯
    # 0x22270: '',  # 𢉰
    # 0x22271: '',  # 𢉱
    # 0x22272: '',  # 𢉲
    # 0x22273: '',  # 𢉳
    # 0x22274: '',  # 𢉴
    0x22275: 'nǎo',  # 𢉵
    # 0x22276: '',  # 𢉶
    # 0x22277: '',  # 𢉷
    # 0x22278: '',  # 𢉸
    # 0x22279: '',  # 𢉹
    0x2227A: 'zǔ',  # 𢉺
    # 0x2227B: '',  # 𢉻
    # 0x2227C: '',  # 𢉼
    # 0x2227D: '',  # 𢉽
    # 0x2227E: '',  # 𢉾
    0x2227F: 'mà',  # 𢉿
    0x22280: 'sī,mà',  # 𢊀
    0x22281: 'zhì',  # 𢊁
    # 0x22282: '',  # 𢊂
    # 0x22283: '',  # 𢊃
    0x22284: 'huī',  # 𢊄
    0x22285: 'zhuì',  # 𢊅
    0x22286: 'lì',  # 𢊆
    0x22287: 'huì',  # 𢊇
    # 0x22288: '',  # 𢊈
    # 0x22289: '',  # 𢊉
    # 0x2228A: '',  # 𢊊
    # 0x2228B: '',  # 𢊋
    # 0x2228C: '',  # 𢊌
    0x2228D: 'chú',  # 𢊍
    # 0x2228E: '',  # 𢊎
    0x2228F: 'chè',  # 𢊏
    # 0x22290: '',  # 𢊐
    # 0x22291: '',  # 𢊑
    0x22292: 'xiū',  # 𢊒
    0x22293: 'lán',  # 𢊓
    # 0x22294: '',  # 𢊔
    0x22295: 'cōng',  # 𢊕
    0x22296: 'shèn',  # 𢊖
    0x22297: 'mò',  # 𢊗
    0x22298: 'yī',  # 𢊘
    0x22299: 'yáo',  # 𢊙
    0x2229A: 'xǐ',  # 𢊚
    0x2229B: 'zuǐ',  # 𢊛
    0x2229C: 'bìng',  # 𢊜
    # 0x2229D: '',  # 𢊝
    # 0x2229E: '',  # 𢊞
    # 0x2229F: '',  # 𢊟
    # 0x222A0: '',  # 𢊠
    # 0x222A1: '',  # 𢊡
    # 0x222A2: '',  # 𢊢
    # 0x222A3: '',  # 𢊣
    # 0x222A4: '',  # 𢊤
    # 0x222A5: '',  # 𢊥
    # 0x222A6: '',  # 𢊦
    0x222A7: 'yú',  # 𢊧
    # 0x222A8: '',  # 𢊨
    0x222A9: 'lù',  # 𢊩
    # 0x222AA: '',  # 𢊪
    # 0x222AB: '',  # 𢊫
    # 0x222AC: '',  # 𢊬
    # 0x222AD: '',  # 𢊭
    0x222AE: 'tuí',  # 𢊮
    0x222AF: 'wěi',  # 𢊯
    # 0x222B0: '',  # 𢊰
    0x222B1: 'fén',  # 𢊱
    0x222B2: 'shěn',  # 𢊲
    # 0x222B3: '',  # 𢊳
    # 0x222B4: '',  # 𢊴
    # 0x222B5: '',  # 𢊵
    # 0x222B6: '',  # 𢊶
    # 0x222B7: '',  # 𢊷
    # 0x222B8: '',  # 𢊸
    # 0x222B9: '',  # 𢊹
    0x222BA: 'liù',  # 𢊺
    0x222BB: 'liáo',  # 𢊻
    # 0x222BC: '',  # 𢊼
    # 0x222BD: '',  # 𢊽
    # 0x222BE: '',  # 𢊾
    # 0x222BF: '',  # 𢊿
    # 0x222C0: '',  # 𢋀
    # 0x222C1: '',  # 𢋁
    0x222C2: 'shǔ',  # 𢋂
    0x222C3: 'dǎn',  # 𢋃
    0x222C4: 'juǎn',  # 𢋄
    0x222C5: 'yú',  # 𢋅
    0x222C6: 'xìn',  # 𢋆
    0x222C7: 'yáo',  # 𢋇
    # 0x222C8: '',  # 𢋈
    # 0x222C9: '',  # 𢋉
    # 0x222CA: '',  # 𢋊
    # 0x222CB: '',  # 𢋋
    # 0x222CC: '',  # 𢋌
    # 0x222CD: '',  # 𢋍
    # 0x222CE: '',  # 𢋎
    # 0x222CF: '',  # 𢋏
    # 0x222D0: '',  # 𢋐
    # 0x222D1: '',  # 𢋑
    0x222D2: 'huó',  # 𢋒
    # 0x222D3: '',  # 𢋓
    0x222D4: 'qiān',  # 𢋔
    # 0x222D5: '',  # 𢋕
    # 0x222D6: '',  # 𢋖
    # 0x222D7: '',  # 𢋗
    # 0x222D8: '',  # 𢋘
    # 0x222D9: '',  # 𢋙
    0x222DA: 'má',  # 𢋚
    # 0x222DB: '',  # 𢋛
    # 0x222DC: '',  # 𢋜
    0x222DD: 'kǎi',  # 𢋝
    # 0x222DE: '',  # 𢋞
    # 0x222DF: '',  # 𢋟
    # 0x222E0: '',  # 𢋠
    0x222E1: 'lǔ',  # 𢋡
    # 0x222E2: '',  # 𢋢
    0x222E3: 'yōu',  # 𢋣
    # 0x222E4: '',  # 𢋤
    # 0x222E5: '',  # 𢋥
    # 0x222E6: '',  # 𢋦
    # 0x222E7: '',  # 𢋧
    # 0x222E8: '',  # 𢋨
    # 0x222E9: '',  # 𢋩
    # 0x222EA: '',  # 𢋪
    # 0x222EB: '',  # 𢋫
    # 0x222EC: '',  # 𢋬
    # 0x222ED: '',  # 𢋭
    0x222EE: 'xiàn',  # 𢋮
    # 0x222EF: '',  # 𢋯
    # 0x222F0: '',  # 𢋰
    # 0x222F1: '',  # 𢋱
    # 0x222F2: '',  # 𢋲
    # 0x222F3: '',  # 𢋳
    # 0x222F4: '',  # 𢋴
    # 0x222F5: '',  # 𢋵
    # 0x222F6: '',  # 𢋶
    # 0x222F7: '',  # 𢋷
    # 0x222F8: '',  # 𢋸
    0x222F9: 'wú',  # 𢋹
    # 0x222FA: '',  # 𢋺
    0x222FB: 'yǐn',  # 𢋻
    0x222FC: 'xī',  # 𢋼
    # 0x222FD: '',  # 𢋽
    0x222FE: 'qiáng',  # 𢋾
    0x222FF: 'zhāi',  # 𢋿
    0x22300: 'xiè',  # 𢌀
    # 0x22301: '',  # 𢌁
    # 0x22302: '',  # 𢌂
    # 0x22303: '',  # 𢌃
    0x22304: 'qú',  # 𢌄
    # 0x22305: '',  # 𢌅
    # 0x22306: '',  # 𢌆
    # 0x22307: '',  # 𢌇
    0x22308: 'lí',  # 𢌈
    # 0x22309: '',  # 𢌉
    # 0x2230A: '',  # 𢌊
    # 0x2230B: '',  # 𢌋
    # 0x2230C: '',  # 𢌌
    0x2230D: 'qiān',  # 𢌍
    # 0x2230E: '',  # 𢌎
    # 0x2230F: '',  # 𢌏
    # 0x22310: '',  # 𢌐
    # 0x22311: '',  # 𢌑
    # 0x22312: '',  # 𢌒
    # 0x22313: '',  # 𢌓
    0x22314: 'líng',  # 𢌔
    0x22315: 'luán',  # 𢌕
    # 0x22316: '',  # 𢌖
    # 0x22317: '',  # 𢌗
    # 0x22318: '',  # 𢌘
    # 0x22319: '',  # 𢌙
    0x2231A: 'chān',  # 𢌚
    0x2231B: 'zhēng',  # 𢌛
    # 0x2231C: '',  # 𢌜
    # 0x2231D: '',  # 𢌝
    # 0x2231E: '',  # 𢌞
    # 0x2231F: '',  # 𢌟
    # 0x22320: '',  # 𢌠
    # 0x22321: '',  # 𢌡
    # 0x22322: '',  # 𢌢
    # 0x22323: '',  # 𢌣
    # 0x22324: '',  # 𢌤
    # 0x22325: '',  # 𢌥
    0x22326: 'zhèng',  # 𢌦
    # 0x22327: '',  # 𢌧
    0x22328: 'yán',  # 𢌨
    # 0x22329: '',  # 𢌩
    # 0x2232A: '',  # 𢌪
    # 0x2232B: '',  # 𢌫
    # 0x2232C: '',  # 𢌬
    # 0x2232D: '',  # 𢌭
    # 0x2232E: '',  # 𢌮
    # 0x2232F: '',  # 𢌯
    # 0x22330: '',  # 𢌰
    # 0x22331: '',  # 𢌱
    0x22332: 'yìn',  # 𢌲
    0x22333: 'kuí',  # 𢌳
    # 0x22334: '',  # 𢌴
    # 0x22335: '',  # 𢌵
    # 0x22336: '',  # 𢌶
    0x22337: 'qū',  # 𢌷
    # 0x22338: '',  # 𢌸
    0x22339: 'fú',  # 𢌹
    # 0x2233A: '',  # 𢌺
    0x2233B: 'yù',  # 𢌻
    # 0x2233C: '',  # 𢌼
    # 0x2233D: '',  # 𢌽
    # 0x2233E: '',  # 𢌾
    # 0x2233F: '',  # 𢌿
    # 0x22340: '',  # 𢍀
    0x22341: 'qí,bì',  # 𢍁
    # 0x22342: '',  # 𢍂
    # 0x22343: '',  # 𢍃
    # 0x22344: '',  # 𢍄
    # 0x22345: '',  # 𢍅
    0x22346: 'qì,qiè',  # 𢍆
    0x22347: 'jì',  # 𢍇
    0x22348: 'yuān,zàng',  # 𢍈
    0x22349: 'qí',  # 𢍉
    # 0x2234A: '',  # 𢍊
    # 0x2234B: '',  # 𢍋
    # 0x2234C: '',  # 𢍌
    # 0x2234D: '',  # 𢍍
    0x2234E: 'gào',  # 𢍎
    0x2234F: 'juàn',  # 𢍏
    # 0x22350: '',  # 𢍐
    0x22351: 'qí',  # 𢍑
    # 0x22352: '',  # 𢍒
    0x22353: 'gǎi',  # 𢍓
    # 0x22354: '',  # 𢍔
    0x22355: 'quàn',  # 𢍕
    # 0x22356: '',  # 𢍖
    # 0x22357: '',  # 𢍗
    # 0x22358: '',  # 𢍘
    # 0x22359: '',  # 𢍙
    0x2235A: 'wèi',  # 𢍚
    # 0x2235B: '',  # 𢍛
    0x2235C: 'zūn',  # 𢍜
    # 0x2235D: '',  # 𢍝
    # 0x2235E: '',  # 𢍞
    # 0x2235F: '',  # 𢍟
    # 0x22360: '',  # 𢍠
    # 0x22361: '',  # 𢍡
    # 0x22362: '',  # 𢍢
    # 0x22363: '',  # 𢍣
    # 0x22364: '',  # 𢍤
    # 0x22365: '',  # 𢍥
    # 0x22366: '',  # 𢍦
    0x22367: 'zhì',  # 𢍧
    # 0x22368: '',  # 𢍨
    0x22369: 'shèn',  # 𢍩
    0x2236A: 'dēng',  # 𢍪
    0x2236B: 'jiǎn',  # 𢍫
    # 0x2236C: '',  # 𢍬
    0x2236D: 'sì',  # 𢍭
    # 0x2236E: '',  # 𢍮
    # 0x2236F: '',  # 𢍯
    0x22370: 'yì,zé',  # 𢍰
    0x22371: 'qiān',  # 𢍱
    # 0x22372: '',  # 𢍲
    # 0x22373: '',  # 𢍳
    # 0x22374: '',  # 𢍴
    # 0x22375: '',  # 𢍵
    # 0x22376: '',  # 𢍶
    # 0x22377: '',  # 𢍷
    # 0x22378: '',  # 𢍸
    # 0x22379: '',  # 𢍹
    # 0x2237A: '',  # 𢍺
    # 0x2237B: '',  # 𢍻
    0x2237C: 'lì',  # 𢍼
    # 0x2237D: '',  # 𢍽
    # 0x2237E: '',  # 𢍾
    0x2237F: 'zāng',  # 𢍿
    0x22380: 'yì',  # 𢎀
    # 0x22381: '',  # 𢎁
    0x22382: 'cái',  # 𢎂
    0x22383: 'yì',  # 𢎃
    0x22384: 'gē',  # 𢎄
    # 0x22385: '',  # 𢎅
    0x22386: 'dié',  # 𢎆
    # 0x22387: '',  # 𢎇
    0x22388: 'zhī',  # 𢎈
    0x22389: 'yì',  # 𢎉
    # 0x2238A: '',  # 𢎊
    0x2238B: 'zāi',  # 𢎋
    0x2238C: 'dài',  # 𢎌
    # 0x2238D: '',  # 𢎍
    0x2238E: 'sù',  # 𢎎
    # 0x2238F: '',  # 𢎏
    # 0x22390: '',  # 𢎐
    # 0x22391: '',  # 𢎑
    # 0x22392: '',  # 𢎒
    # 0x22393: '',  # 𢎓
    0x22394: 'jié',  # 𢎔
    0x22395: 'chèn',  # 𢎕
    0x22396: 'qú',  # 𢎖
    # 0x22397: '',  # 𢎗
    0x22398: 'hàn',  # 𢎘
    0x22399: 'xián',  # 𢎙
    # 0x2239A: '',  # 𢎚
    0x2239B: 'jié',  # 𢎛
    # 0x2239C: '',  # 𢎜
    # 0x2239D: '',  # 𢎝
    # 0x2239E: '',  # 𢎞
    0x2239F: 'dàn',  # 𢎟
    0x223A0: 'quán,juàn',  # 𢎠
    0x223A1: 'jié',  # 𢎡
    # 0x223A2: '',  # 𢎢
    # 0x223A3: '',  # 𢎣
    # 0x223A4: '',  # 𢎤
    0x223A5: 'juàn',  # 𢎥
    # 0x223A6: '',  # 𢎦
    # 0x223A7: '',  # 𢎧
    # 0x223A8: '',  # 𢎨
    # 0x223A9: '',  # 𢎩
    0x223AA: 'dàn',  # 𢎪
    # 0x223AB: '',  # 𢎫
    # 0x223AC: '',  # 𢎬
    0x223AD: 'jīn',  # 𢎭
    # 0x223AE: '',  # 𢎮
    0x223AF: 'yí',  # 𢎯
    # 0x223B0: '',  # 𢎰
    # 0x223B1: '',  # 𢎱
    # 0x223B2: '',  # 𢎲
    # 0x223B3: '',  # 𢎳
    0x223B4: 'bīng',  # 𢎴
    0x223B5: 'hú',  # 𢎵
    # 0x223B6: '',  # 𢎶
    # 0x223B7: '',  # 𢎷
    # 0x223B8: '',  # 𢎸
    0x223B9: 'jué',  # 𢎹
    # 0x223BA: '',  # 𢎺
    0x223BB: 'yú',  # 𢎻
    # 0x223BC: '',  # 𢎼
    # 0x223BD: '',  # 𢎽
    # 0x223BE: '',  # 𢎾
    # 0x223BF: '',  # 𢎿
    # 0x223C0: '',  # 𢏀
    # 0x223C1: '',  # 𢏁
    # 0x223C2: '',  # 𢏂
    0x223C3: 'lǐ',  # 𢏃
    0x223C4: 'qiáng',  # 𢏄
    0x223C5: 'shuǐ',  # 𢏅
    0x223C6: 'kū',  # 𢏆
    # 0x223C7: '',  # 𢏇
    0x223C8: 'zhěn',  # 𢏈
    # 0x223C9: '',  # 𢏉
    # 0x223CA: '',  # 𢏊
    # 0x223CB: '',  # 𢏋
    # 0x223CC: '',  # 𢏌
    0x223CD: 'fú',  # 𢏍
    0x223CE: 'shēn',  # 𢏎
    # 0x223CF: '',  # 𢏏
    # 0x223D0: '',  # 𢏐
    # 0x223D1: '',  # 𢏑
    0x223D2: 'chuí',  # 𢏒
    # 0x223D3: '',  # 𢏓
    # 0x223D4: '',  # 𢏔
    0x223D5: 'tóng',  # 𢏕
    # 0x223D6: '',  # 𢏖
    0x223D7: 'yì',  # 𢏗
    # 0x223D8: '',  # 𢏘
    0x223D9: 'yáng',  # 𢏙
    # 0x223DA: '',  # 𢏚
    # 0x223DB: '',  # 𢏛
    0x223DC: 'tuó',  # 𢏜
    0x223DD: 'zhōu',  # 𢏝
    0x223DE: 'jí',  # 𢏞
    # 0x223DF: '',  # 𢏟
    # 0x223E0: '',  # 𢏠
    # 0x223E1: '',  # 𢏡
    # 0x223E2: '',  # 𢏢
    # 0x223E3: '',  # 𢏣
    0x223E4: 'xùn',  # 𢏤
    # 0x223E5: '',  # 𢏥
    0x223E6: 'shěn',  # 𢏦
    0x223E7: 'xuān',  # 𢏧
    # 0x223E8: '',  # 𢏨
    # 0x223E9: '',  # 𢏩
    # 0x223EA: '',  # 𢏪
    # 0x223EB: '',  # 𢏫
    # 0x223EC: '',  # 𢏬
    0x223ED: 'liú',  # 𢏭
    0x223EE: 'yuān',  # 𢏮
    0x223EF: 'hú,shǐ',  # 𢏯
    0x223F0: 'zhèng',  # 𢏰
    # 0x223F1: '',  # 𢏱
    # 0x223F2: '',  # 𢏲
    0x223F3: 'pēng,bēng',  # 𢏳
    # 0x223F4: '',  # 𢏴
    # 0x223F5: '',  # 𢏵
    # 0x223F6: '',  # 𢏶
    0x223F7: 'jué',  # 𢏷
    # 0x223F8: '',  # 𢏸
    # 0x223F9: '',  # 𢏹
    # 0x223FA: '',  # 𢏺
    # 0x223FB: '',  # 𢏻
    # 0x223FC: '',  # 𢏼
    # 0x223FD: '',  # 𢏽
    # 0x223FE: '',  # 𢏾
    # 0x223FF: '',  # 𢏿
    # 0x22400: '',  # 𢐀
    # 0x22401: '',  # 𢐁
    0x22402: 'zhì',  # 𢐂
    0x22403: 'piān',  # 𢐃
    0x22404: 'yuàn',  # 𢐄
    # 0x22405: '',  # 𢐅
    0x22406: 'jiān',  # 𢐆
    # 0x22407: '',  # 𢐇
    # 0x22408: '',  # 𢐈
    # 0x22409: '',  # 𢐉
    0x2240A: 'páng',  # 𢐊
    # 0x2240B: '',  # 𢐋
    # 0x2240C: '',  # 𢐌
    # 0x2240D: '',  # 𢐍
    0x2240E: 'zhuàn',  # 𢐎
    # 0x2240F: '',  # 𢐏
    0x22410: 'xián',  # 𢐐
    # 0x22411: '',  # 𢐑
    0x22412: 'bēng',  # 𢐒
    # 0x22413: '',  # 𢐓
    0x22414: 'cōng',  # 𢐔
    # 0x22415: '',  # 𢐕
    0x22416: 'mò',  # 𢐖
    # 0x22417: '',  # 𢐗
    # 0x22418: '',  # 𢐘
    # 0x22419: '',  # 𢐙
    0x2241A: 'guó',  # 𢐚
    # 0x2241B: '',  # 𢐛
    # 0x2241C: '',  # 𢐜
    # 0x2241D: '',  # 𢐝
    0x2241E: 'chéng',  # 𢐞
    0x2241F: 'qiāo',  # 𢐟
    # 0x22420: '',  # 𢐠
    # 0x22421: '',  # 𢐡
    # 0x22422: '',  # 𢐢
    # 0x22423: '',  # 𢐣
    # 0x22424: '',  # 𢐤
    # 0x22425: '',  # 𢐥
    0x22426: 'bì',  # 𢐦
    # 0x22427: '',  # 𢐧
    # 0x22428: '',  # 𢐨
    0x22429: 'qiǎng',  # 𢐩
    # 0x2242A: '',  # 𢐪
    0x2242B: 'zhōu',  # 𢐫
    # 0x2242C: '',  # 𢐬
    # 0x2242D: '',  # 𢐭
    # 0x2242E: '',  # 𢐮
    # 0x2242F: '',  # 𢐯
    # 0x22430: '',  # 𢐰
    # 0x22431: '',  # 𢐱
    0x22432: 'fán',  # 𢐲
    0x22433: 'biē',  # 𢐳
    0x22434: 'fèng',  # 𢐴
    # 0x22435: '',  # 𢐵
    # 0x22436: '',  # 𢐶
    # 0x22437: '',  # 𢐷
    # 0x22438: '',  # 𢐸
    # 0x22439: '',  # 𢐹
    # 0x2243A: '',  # 𢐺
    # 0x2243B: '',  # 𢐻
    # 0x2243C: '',  # 𢐼
    # 0x2243D: '',  # 𢐽
    0x2243E: 'bó',  # 𢐾
    0x2243F: 'rǒng',  # 𢐿
    # 0x22440: '',  # 𢑀
    # 0x22441: '',  # 𢑁
    # 0x22442: '',  # 𢑂
    # 0x22443: '',  # 𢑃
    # 0x22444: '',  # 𢑄
    0x22445: 'dǐng',  # 𢑅
    0x22446: 'quán',  # 𢑆
    0x22447: 'jiù',  # 𢑇
    0x22448: 'yáo',  # 𢑈
    # 0x22449: '',  # 𢑉
    # 0x2244A: '',  # 𢑊
    # 0x2244B: '',  # 𢑋
    # 0x2244C: '',  # 𢑌
    # 0x2244D: '',  # 𢑍
    # 0x2244E: '',  # 𢑎
    0x2244F: 'yì',  # 𢑏
    # 0x22450: '',  # 𢑐
    # 0x22451: '',  # 𢑑
    # 0x22452: '',  # 𢑒
    0x22453: 'xiá',  # 𢑓
    # 0x22454: '',  # 𢑔
    # 0x22455: '',  # 𢑕
    0x22456: 'zǎo',  # 𢑖
    # 0x22457: '',  # 𢑗
    # 0x22458: '',  # 𢑘
    # 0x22459: '',  # 𢑙
    0x2245A: 'shēn',  # 𢑚
    # 0x2245B: '',  # 𢑛
    # 0x2245C: '',  # 𢑜
    0x2245D: 'dān',  # 𢑝
    0x2245E: 'yì',  # 𢑞
    0x2245F: 'wǔ',  # 𢑟
    0x22460: 'tuó',  # 𢑠
    # 0x22461: '',  # 𢑡
    0x22462: 'hū',  # 𢑢
    # 0x22463: '',  # 𢑣
    # 0x22464: '',  # 𢑤
    # 0x22465: '',  # 𢑥
    # 0x22466: '',  # 𢑦
    0x22467: 'xī',  # 𢑧
    # 0x22468: '',  # 𢑨
    # 0x22469: '',  # 𢑩
    # 0x2246A: '',  # 𢑪
    # 0x2246B: '',  # 𢑫
    0x2246C: 'lái',  # 𢑬
    0x2246D: 'wèi',  # 𢑭
    0x2246E: 'fēi',  # 𢑮
    # 0x2246F: '',  # 𢑯
    # 0x22470: '',  # 𢑰
    0x22471: 'yí',  # 𢑱
    # 0x22472: '',  # 𢑲
    # 0x22473: '',  # 𢑳
    # 0x22474: '',  # 𢑴
    # 0x22475: '',  # 𢑵
    # 0x22476: '',  # 𢑶
    # 0x22477: '',  # 𢑷
    # 0x22478: '',  # 𢑸
    0x22479: 'hú',  # 𢑹
    # 0x2247A: '',  # 𢑺
    # 0x2247B: '',  # 𢑻
    # 0x2247C: '',  # 𢑼
    # 0x2247D: '',  # 𢑽
    # 0x2247E: '',  # 𢑾
    # 0x2247F: '',  # 𢑿
    # 0x22480: '',  # 𢒀
    # 0x22481: '',  # 𢒁
    # 0x22482: '',  # 𢒂
    # 0x22483: '',  # 𢒃
    # 0x22484: '',  # 𢒄
    # 0x22485: '',  # 𢒅
    0x22486: 'xiān',  # 𢒆
    # 0x22487: '',  # 𢒇
    # 0x22488: '',  # 𢒈
    0x22489: 'shǎn',  # 𢒉
    # 0x2248A: '',  # 𢒊
    # 0x2248B: '',  # 𢒋
    # 0x2248C: '',  # 𢒌
    0x2248D: 'fèi',  # 𢒍
    # 0x2248E: '',  # 𢒎
    # 0x2248F: '',  # 𢒏
    0x22490: 'cuò',  # 𢒐
    # 0x22491: '',  # 𢒑
    0x22492: 'fú',  # 𢒒
    # 0x22493: '',  # 𢒓
    0x22494: 'chù',  # 𢒔
    # 0x22495: '',  # 𢒕
    # 0x22496: '',  # 𢒖
    # 0x22497: '',  # 𢒗
    # 0x22498: '',  # 𢒘
    # 0x22499: '',  # 𢒙
    # 0x2249A: '',  # 𢒚
    # 0x2249B: '',  # 𢒛
    # 0x2249C: '',  # 𢒜
    0x2249D: 'diū',  # 𢒝
    0x2249E: 'làn',  # 𢒞
    # 0x2249F: '',  # 𢒟
    # 0x224A0: '',  # 𢒠
    # 0x224A1: '',  # 𢒡
    # 0x224A2: '',  # 𢒢
    # 0x224A3: '',  # 𢒣
    # 0x224A4: '',  # 𢒤
    # 0x224A5: '',  # 𢒥
    # 0x224A6: '',  # 𢒦
    # 0x224A7: '',  # 𢒧
    # 0x224A8: '',  # 𢒨
    0x224A9: 'xǐ',  # 𢒩
    # 0x224AA: '',  # 𢒪
    0x224AB: 'xún',  # 𢒫
    # 0x224AC: '',  # 𢒬
    # 0x224AD: '',  # 𢒭
    # 0x224AE: '',  # 𢒮
    0x224AF: 'biāo',  # 𢒯
    0x224B0: 'yù',  # 𢒰
    0x224B1: 'suì',  # 𢒱
    0x224B2: 'xǐ',  # 𢒲
    # 0x224B3: '',  # 𢒳
    # 0x224B4: '',  # 𢒴
    # 0x224B5: '',  # 𢒵
    # 0x224B6: '',  # 𢒶
    0x224B7: 'póu',  # 𢒷
    # 0x224B8: '',  # 𢒸
    # 0x224B9: '',  # 𢒹
    # 0x224BA: '',  # 𢒺
    # 0x224BB: '',  # 𢒻
    # 0x224BC: '',  # 𢒼
    # 0x224BD: '',  # 𢒽
    0x224BE: 'jiào',  # 𢒾
    # 0x224BF: '',  # 𢒿
    0x224C0: 'yì',  # 𢓀
    # 0x224C1: '',  # 𢓁
    # 0x224C2: '',  # 𢓂
    0x224C3: 'wán',  # 𢓃
    0x224C4: 'jǐ',  # 𢓄
    # 0x224C5: '',  # 𢓅
    0x224C6: 'wán',  # 𢓆
    0x224C7: 'tuì,nà',  # 𢓇
    0x224C8: 'xùn',  # 𢓈
    # 0x224C9: '',  # 𢓉
    # 0x224CA: '',  # 𢓊
    0x224CB: 'àng',  # 𢓋
    # 0x224CC: '',  # 𢓌
    0x224CD: 'tiān',  # 𢓍
    0x224CE: 'chí',  # 𢓎
    # 0x224CF: '',  # 𢓏
    # 0x224D0: '',  # 𢓐
    # 0x224D1: '',  # 𢓑
    0x224D2: 'rán',  # 𢓒
    # 0x224D3: '',  # 𢓓
    0x224D4: 'sà',  # 𢓔
    0x224D5: 'yín',  # 𢓕
    0x224D6: 'pī',  # 𢓖
    0x224D7: 'cǐ',  # 𢓗
    0x224D8: 'tóng,tāo',  # 𢓘
    0x224D9: 'yǐn',  # 𢓙
    # 0x224DA: '',  # 𢓚
    # 0x224DB: '',  # 𢓛
    0x224DC: 'gé',  # 𢓜
    0x224DD: 'tiāo',  # 𢓝
    0x224DE: 'zhēng',  # 𢓞
    0x224DF: 'zhòu',  # 𢓟
    # 0x224E0: '',  # 𢓠
    0x224E1: 'yí,tí',  # 𢓡
    0x224E2: 'kuà',  # 𢓢
    0x224E3: 'sōng',  # 𢓣
    # 0x224E4: '',  # 𢓤
    # 0x224E5: '',  # 𢓥
    # 0x224E6: '',  # 𢓦
    0x224E7: 'dì',  # 𢓧
    # 0x224E8: '',  # 𢓨
    # 0x224E9: '',  # 𢓩
    # 0x224EA: '',  # 𢓪
    # 0x224EB: '',  # 𢓫
    0x224EC: 'xié',  # 𢓬
    # 0x224ED: '',  # 𢓭
    0x224EE: 'xiāo',  # 𢓮
    0x224EF: 'guàng,wǎng',  # 𢓯
    0x224F0: 'tuǒ',  # 𢓰
    0x224F1: 'fēng,fèng',  # 𢓱
    0x224F2: 'wú,hú',  # 𢓲
    # 0x224F3: '',  # 𢓳
    0x224F4: 'tuì',  # 𢓴
    0x224F5: 'xiù',  # 𢓵
    # 0x224F6: '',  # 𢓶
    # 0x224F7: '',  # 𢓷
    # 0x224F8: '',  # 𢓸
    # 0x224F9: '',  # 𢓹
    # 0x224FA: '',  # 𢓺
    # 0x224FB: '',  # 𢓻
    # 0x224FC: '',  # 𢓼
    # 0x224FD: '',  # 𢓽
    # 0x224FE: '',  # 𢓾
    0x224FF: 'yóu',  # 𢓿
    # 0x22500: '',  # 𢔀
    0x22501: 'líng',  # 𢔁
    0x22502: 'yàn',  # 𢔂
    # 0x22503: '',  # 𢔃
    # 0x22504: '',  # 𢔄
    0x22505: 'dōng',  # 𢔅
    0x22506: 'qì',  # 𢔆
    0x22507: 'táo',  # 𢔇
    0x22508: 'hán',  # 𢔈
    # 0x22509: '',  # 𢔉
    0x2250A: 'chí',  # 𢔊
    0x2250B: 'sōng',  # 𢔋
    # 0x2250C: '',  # 𢔌
    # 0x2250D: '',  # 𢔍
    # 0x2250E: '',  # 𢔎
    # 0x2250F: '',  # 𢔏
    # 0x22510: '',  # 𢔐
    0x22511: 'quǎn',  # 𢔑
    # 0x22512: '',  # 𢔒
    # 0x22513: '',  # 𢔓
    0x22514: 'hàn,jí',  # 𢔔
    # 0x22515: '',  # 𢔕
    # 0x22516: '',  # 𢔖
    # 0x22517: '',  # 𢔗
    # 0x22518: '',  # 𢔘
    # 0x22519: '',  # 𢔙
    # 0x2251A: '',  # 𢔚
    # 0x2251B: '',  # 𢔛
    # 0x2251C: '',  # 𢔜
    # 0x2251D: '',  # 𢔝
    # 0x2251E: '',  # 𢔞
    0x2251F: 'rǒu,niǔ',  # 𢔟
    0x22520: 'qì',  # 𢔠
    0x22521: 'kāi',  # 𢔡
    0x22522: 'yú',  # 𢔢
    0x22523: 'chā,shà',  # 𢔣
    0x22524: 'chèng',  # 𢔤
    0x22525: 'yù',  # 𢔥
    # 0x22526: '',  # 𢔦
    0x22527: 'bìng',  # 𢔧
    # 0x22528: '',  # 𢔨
    0x22529: 'cōng,sǒng',  # 𢔩
    0x2252A: 'zhū',  # 𢔪
    # 0x2252B: '',  # 𢔫
    0x2252C: 'yù',  # 𢔬
    # 0x2252D: '',  # 𢔭
    # 0x2252E: '',  # 𢔮
    0x2252F: 'là',  # 𢔯
    # 0x22530: '',  # 𢔰
    0x22531: 'jué,què',  # 𢔱
    0x22532: 'liù',  # 𢔲
    0x22533: 'sāo',  # 𢔳
    0x22534: 'yù',  # 𢔴
    # 0x22535: '',  # 𢔵
    # 0x22536: '',  # 𢔶
    # 0x22537: '',  # 𢔷
    # 0x22538: '',  # 𢔸
    # 0x22539: '',  # 𢔹
    # 0x2253A: '',  # 𢔺
    # 0x2253B: '',  # 𢔻
    # 0x2253C: '',  # 𢔼
    # 0x2253D: '',  # 𢔽
    # 0x2253E: '',  # 𢔾
    # 0x2253F: '',  # 𢔿
    # 0x22540: '',  # 𢕀
    # 0x22541: '',  # 𢕁
    # 0x22542: '',  # 𢕂
    # 0x22543: '',  # 𢕃
    # 0x22544: '',  # 𢕄
    0x22545: 'shuài',  # 𢕅
    # 0x22546: '',  # 𢕆
    # 0x22547: '',  # 𢕇
    0x22548: 'sǒng',  # 𢕈
    # 0x22549: '',  # 𢕉
    # 0x2254A: '',  # 𢕊
    0x2254B: 'yuàn',  # 𢕋
    # 0x2254C: '',  # 𢕌
    # 0x2254D: '',  # 𢕍
    0x2254E: 'zhāng',  # 𢕎
    # 0x2254F: '',  # 𢕏
    # 0x22550: '',  # 𢕐
    0x22551: 'shuài',  # 𢕑
    # 0x22552: '',  # 𢕒
    0x22553: 'chǔ',  # 𢕓
    0x22554: 'zhāng,zhàng',  # 𢕔
    0x22555: 'sǎn,sàn',  # 𢕕
    0x22556: 'xiān',  # 𢕖
    # 0x22557: '',  # 𢕗
    0x22558: 'cuī',  # 𢕘
    0x22559: 'měng',  # 𢕙
    0x2255A: 'dí',  # 𢕚
    # 0x2255B: '',  # 𢕛
    # 0x2255C: '',  # 𢕜
    # 0x2255D: '',  # 𢕝
    0x2255E: 'zhì',  # 𢕞
    0x2255F: 'ào',  # 𢕟
    # 0x22560: '',  # 𢕠
    # 0x22561: '',  # 𢕡
    # 0x22562: '',  # 𢕢
    # 0x22563: '',  # 𢕣
    # 0x22564: '',  # 𢕤
    # 0x22565: '',  # 𢕥
    0x22566: 'xiū',  # 𢕦
    # 0x22567: '',  # 𢕧
    0x22568: 'pián',  # 𢕨
    # 0x22569: '',  # 𢕩
    0x2256A: 'jiào',  # 𢕪
    0x2256B: 'kuǎn',  # 𢕫
    0x2256C: 'sà',  # 𢕬
    0x2256D: 'xiàn',  # 𢕭
    0x2256E: 'zhà',  # 𢕮
    0x2256F: 'diàn',  # 𢕯
    # 0x22570: '',  # 𢕰
    # 0x22571: '',  # 𢕱
    # 0x22572: '',  # 𢕲
    # 0x22573: '',  # 𢕳
    # 0x22574: '',  # 𢕴
    # 0x22575: '',  # 𢕵
    # 0x22576: '',  # 𢕶
    0x22577: 'yí',  # 𢕷
    # 0x22578: '',  # 𢕸
    # 0x22579: '',  # 𢕹
    0x2257A: 'huì',  # 𢕺
    0x2257B: 'shàn',  # 𢕻
    # 0x2257C: '',  # 𢕼
    # 0x2257D: '',  # 𢕽
    # 0x2257E: '',  # 𢕾
    # 0x2257F: '',  # 𢕿
    # 0x22580: '',  # 𢖀
    # 0x22581: '',  # 𢖁
    # 0x22582: '',  # 𢖂
    # 0x22583: '',  # 𢖃
    0x22584: 'chóng',  # 𢖄
    0x22585: 'yí',  # 𢖅
    0x22586: 'xiè',  # 𢖆
    0x22587: 'zhì',  # 𢖇
    0x22588: 'tiào',  # 𢖈
    # 0x22589: '',  # 𢖉
    0x2258A: 'pīng',  # 𢖊
    0x2258B: 'xián',  # 𢖋
    # 0x2258C: '',  # 𢖌
    # 0x2258D: '',  # 𢖍
    0x2258E: 'xiān',  # 𢖎
    0x2258F: 'sù',  # 𢖏
    # 0x22590: '',  # 𢖐
    0x22591: 'cuán',  # 𢖑
    # 0x22592: '',  # 𢖒
    # 0x22593: '',  # 𢖓
    # 0x22594: '',  # 𢖔
    # 0x22595: '',  # 𢖕
    # 0x22596: '',  # 𢖖
    0x22597: 'sǒng',  # 𢖗
    # 0x22598: '',  # 𢖘
    # 0x22599: '',  # 𢖙
    # 0x2259A: '',  # 𢖚
    0x2259B: 'hēi',  # 𢖛
    # 0x2259C: '',  # 𢖜
    0x2259D: 'xiàn',  # 𢖝
    # 0x2259E: '',  # 𢖞
    0x2259F: 'yóu',  # 𢖟
    # 0x225A0: '',  # 𢖠
    0x225A1: 'yù',  # 𢖡
    # 0x225A2: '',  # 𢖢
    # 0x225A3: '',  # 𢖣
    0x225A4: 'tái',  # 𢖤
    # 0x225A5: '',  # 𢖥
    0x225A6: 'jué',  # 𢖦
    0x225A7: 'nàng',  # 𢖧
    # 0x225A8: '',  # 𢖨
    0x225A9: 'diān',  # 𢖩
    # 0x225AA: '',  # 𢖪
    0x225AB: 'yì',  # 𢖫
    0x225AC: 'bì',  # 𢖬
    # 0x225AD: '',  # 𢖭
    # 0x225AE: '',  # 𢖮
    # 0x225AF: '',  # 𢖯
    # 0x225B0: '',  # 𢖰
    # 0x225B1: '',  # 𢖱
    0x225B2: 'chà',  # 𢖲
    0x225B3: 'xū',  # 𢖳
    0x225B4: 'yì',  # 𢖴
    0x225B5: 'rù',  # 𢖵
    # 0x225B6: '',  # 𢖶
    0x225B7: 'gōng',  # 𢖷
    # 0x225B8: '',  # 𢖸
    # 0x225B9: '',  # 𢖹
    0x225BA: 'yì',  # 𢖺
    0x225BB: 'ài',  # 𢖻
    0x225BC: 'tè',  # 𢖼
    0x225BD: 'zhì',  # 𢖽
    # 0x225BE: '',  # 𢖾
    0x225BF: 'zhì',  # 𢖿
    0x225C0: 'xīn',  # 𢗀
    # 0x225C1: '',  # 𢗁
    0x225C2: 'jì',  # 𢗂
    # 0x225C3: '',  # 𢗃
    0x225C4: 'xià',  # 𢗄
    # 0x225C5: '',  # 𢗅
    # 0x225C6: '',  # 𢗆
    # 0x225C7: '',  # 𢗇
    0x225C8: 'zhāo',  # 𢗈
    0x225C9: 'nè',  # 𢗉
    0x225CA: 'xiè,jiá',  # 𢗊
    # 0x225CB: '',  # 𢗋
    # 0x225CC: '',  # 𢗌
    # 0x225CD: '',  # 𢗍
    0x225CE: 'yì',  # 𢗎
    # 0x225CF: '',  # 𢗏
    # 0x225D0: '',  # 𢗐
    # 0x225D1: '',  # 𢗑
    # 0x225D2: '',  # 𢗒
    # 0x225D3: '',  # 𢗓
    # 0x225D4: '',  # 𢗔
    # 0x225D5: '',  # 𢗕
    # 0x225D6: '',  # 𢗖
    # 0x225D7: '',  # 𢗗
    # 0x225D8: '',  # 𢗘
    # 0x225D9: '',  # 𢗙
    # 0x225DA: '',  # 𢗚
    # 0x225DB: '',  # 𢗛
    # 0x225DC: '',  # 𢗜
    0x225DD: 'dì',  # 𢗝
    # 0x225DE: '',  # 𢗞
    # 0x225DF: '',  # 𢗟
    # 0x225E0: '',  # 𢗠
    # 0x225E1: '',  # 𢗡
    # 0x225E2: '',  # 𢗢
    # 0x225E3: '',  # 𢗣
    # 0x225E4: '',  # 𢗤
    # 0x225E5: '',  # 𢗥
    # 0x225E6: '',  # 𢗦
    # 0x225E7: '',  # 𢗧
    # 0x225E8: '',  # 𢗨
    # 0x225E9: '',  # 𢗩
    # 0x225EA: '',  # 𢗪
    0x225EB: 'fǔ',  # 𢗫
    # 0x225EC: '',  # 𢗬
    0x225ED: 'shè',  # 𢗭
    # 0x225EE: '',  # 𢗮
    0x225EF: 'yuán',  # 𢗯
    0x225F0: 'fǎn',  # 𢗰
    # 0x225F1: '',  # 𢗱
    0x225F2: 'fū',  # 𢗲
    0x225F3: 'wù',  # 𢗳
    0x225F4: 'xī',  # 𢗴
    0x225F5: 'hǒng',  # 𢗵
    # 0x225F6: '',  # 𢗶
    # 0x225F7: '',  # 𢗷
    # 0x225F8: '',  # 𢗸
    0x225F9: 'jì',  # 𢗹
    0x225FA: 'chàng',  # 𢗺
    # 0x225FB: '',  # 𢗻
    # 0x225FC: '',  # 𢗼
    # 0x225FD: '',  # 𢗽
    # 0x225FE: '',  # 𢗾
    0x225FF: 'mò',  # 𢗿
    0x22600: 'pèi',  # 𢘀
    0x22601: 'xiān',  # 𢘁
    # 0x22602: '',  # 𢘂
    0x22603: 'mú,wǔ',  # 𢘃
    0x22604: 'qiú',  # 𢘄
    0x22605: 'mào,róu',  # 𢘅
    # 0x22606: '',  # 𢘆
    0x22607: 'dá,dàn',  # 𢘇
    # 0x22608: '',  # 𢘈
    0x22609: 'xiá',  # 𢘉
    0x2260A: 'shēn',  # 𢘊
    0x2260B: 'tè',  # 𢘋
    0x2260C: 'hóng',  # 𢘌
    0x2260D: 'bì,fú',  # 𢘍
    # 0x2260E: '',  # 𢘎
    # 0x2260F: '',  # 𢘏
    # 0x22610: '',  # 𢘐
    # 0x22611: '',  # 𢘑
    # 0x22612: '',  # 𢘒
    # 0x22613: '',  # 𢘓
    # 0x22614: '',  # 𢘔
    # 0x22615: '',  # 𢘕
    # 0x22616: '',  # 𢘖
    # 0x22617: '',  # 𢘗
    # 0x22618: '',  # 𢘘
    # 0x22619: '',  # 𢘙
    # 0x2261A: '',  # 𢘚
    # 0x2261B: '',  # 𢘛
    # 0x2261C: '',  # 𢘜
    # 0x2261D: '',  # 𢘝
    # 0x2261E: '',  # 𢘞
    0x2261F: 'qiáo',  # 𢘟
    # 0x22620: '',  # 𢘠
    # 0x22621: '',  # 𢘡
    # 0x22622: '',  # 𢘢
    # 0x22623: '',  # 𢘣
    # 0x22624: '',  # 𢘤
    0x22625: 'shì',  # 𢘥
    # 0x22626: '',  # 𢘦
    0x22627: 'ruǎn',  # 𢘧
    # 0x22628: '',  # 𢘨
    # 0x22629: '',  # 𢘩
    # 0x2262A: '',  # 𢘪
    0x2262B: 'zhèng',  # 𢘫
    # 0x2262C: '',  # 𢘬
    # 0x2262D: '',  # 𢘭
    # 0x2262E: '',  # 𢘮
    # 0x2262F: '',  # 𢘯
    # 0x22630: '',  # 𢘰
    # 0x22631: '',  # 𢘱
    # 0x22632: '',  # 𢘲
    # 0x22633: '',  # 𢘳
    # 0x22634: '',  # 𢘴
    # 0x22635: '',  # 𢘵
    # 0x22636: '',  # 𢘶
    # 0x22637: '',  # 𢘷
    0x22638: 'jiàng',  # 𢘸
    0x22639: 'chā',  # 𢘹
    0x2263A: 'mǐ,mí',  # 𢘺
    # 0x2263B: '',  # 𢘻
    # 0x2263C: '',  # 𢘼
    0x2263D: 'yì',  # 𢘽
    # 0x2263E: '',  # 𢘾
    0x2263F: 'suō',  # 𢘿
    # 0x22640: '',  # 𢙀
    0x22641: 'wù',  # 𢙁
    0x22642: 'xuān',  # 𢙂
    # 0x22643: '',  # 𢙃
    # 0x22644: '',  # 𢙄
    0x22645: 'xí',  # 𢙅
    # 0x22646: '',  # 𢙆
    0x22647: 'yǐ',  # 𢙇
    # 0x22648: '',  # 𢙈
    0x22649: 'nǎo',  # 𢙉
    # 0x2264A: '',  # 𢙊
    # 0x2264B: '',  # 𢙋
    # 0x2264C: '',  # 𢙌
    # 0x2264D: '',  # 𢙍
    # 0x2264E: '',  # 𢙎
    # 0x2264F: '',  # 𢙏
    0x22650: 'náo',  # 𢙐
    # 0x22651: '',  # 𢙑
    # 0x22652: '',  # 𢙒
    # 0x22653: '',  # 𢙓
    # 0x22654: '',  # 𢙔
    # 0x22655: '',  # 𢙕
    # 0x22656: '',  # 𢙖
    # 0x22657: '',  # 𢙗
    # 0x22658: '',  # 𢙘
    # 0x22659: '',  # 𢙙
    # 0x2265A: '',  # 𢙚
    # 0x2265B: '',  # 𢙛
    # 0x2265C: '',  # 𢙜
    # 0x2265D: '',  # 𢙝
    # 0x2265E: '',  # 𢙞
    # 0x2265F: '',  # 𢙟
    0x22660: 'yín',  # 𢙠
    # 0x22661: '',  # 𢙡
    0x22662: 'kǒng',  # 𢙢
    # 0x22663: '',  # 𢙣
    # 0x22664: '',  # 𢙤
    # 0x22665: '',  # 𢙥
    # 0x22666: '',  # 𢙦
    0x22667: 'piàn',  # 𢙧
    # 0x22668: '',  # 𢙨
    # 0x22669: '',  # 𢙩
    # 0x2266A: '',  # 𢙪
    # 0x2266B: '',  # 𢙫
    # 0x2266C: '',  # 𢙬
    # 0x2266D: '',  # 𢙭
    0x2266E: 'kàn',  # 𢙮
    # 0x2266F: '',  # 𢙯
    # 0x22670: '',  # 𢙰
    0x22671: 'lòng',  # 𢙱
    0x22672: 'lǚ',  # 𢙲
    0x22673: 'zhuǎng',  # 𢙳
    0x22674: 'ài',  # 𢙴
    # 0x22675: '',  # 𢙵
    # 0x22676: '',  # 𢙶
    # 0x22677: '',  # 𢙷
    # 0x22678: '',  # 𢙸
    # 0x22679: '',  # 𢙹
    0x2267A: 'zhì',  # 𢙺
    # 0x2267B: '',  # 𢙻
    0x2267C: 'xìng',  # 𢙼
    # 0x2267D: '',  # 𢙽
    0x2267E: 'gěng',  # 𢙾
    0x2267F: 'jìn',  # 𢙿
    0x22680: 'xiàn',  # 𢚀
    0x22681: 'jì',  # 𢚁
    0x22682: 'cuò',  # 𢚂
    # 0x22683: '',  # 𢚃
    0x22684: 'láo',  # 𢚄
    0x22685: 'fěn',  # 𢚅
    0x22686: 'jù',  # 𢚆
    # 0x22687: '',  # 𢚇
    # 0x22688: '',  # 𢚈
    # 0x22689: '',  # 𢚉
    # 0x2268A: '',  # 𢚊
    0x2268B: 'miào',  # 𢚋
    0x2268C: 'xiá',  # 𢚌
    # 0x2268D: '',  # 𢚍
    # 0x2268E: '',  # 𢚎
    # 0x2268F: '',  # 𢚏
    # 0x22690: '',  # 𢚐
    0x22691: 'sù',  # 𢚑
    # 0x22692: '',  # 𢚒
    # 0x22693: '',  # 𢚓
    # 0x22694: '',  # 𢚔
    # 0x22695: '',  # 𢚕
    # 0x22696: '',  # 𢚖
    0x22697: 'sàn',  # 𢚗
    # 0x22698: '',  # 𢚘
    # 0x22699: '',  # 𢚙
    # 0x2269A: '',  # 𢚚
    # 0x2269B: '',  # 𢚛
    # 0x2269C: '',  # 𢚜
    # 0x2269D: '',  # 𢚝
    # 0x2269E: '',  # 𢚞
    # 0x2269F: '',  # 𢚟
    # 0x226A0: '',  # 𢚠
    # 0x226A1: '',  # 𢚡
    # 0x226A2: '',  # 𢚢
    # 0x226A3: '',  # 𢚣
    # 0x226A4: '',  # 𢚤
    # 0x226A5: '',  # 𢚥
    # 0x226A6: '',  # 𢚦
    # 0x226A7: '',  # 𢚧
    0x226A8: 'zhì',  # 𢚨
    # 0x226A9: '',  # 𢚩
    0x226AA: 'hù',  # 𢚪
    0x226AB: 'kòu',  # 𢚫
    # 0x226AC: '',  # 𢚬
    0x226AD: 'suǒ',  # 𢚭
    0x226AE: 'nì',  # 𢚮
    # 0x226AF: '',  # 𢚯
    # 0x226B0: '',  # 𢚰
    # 0x226B1: '',  # 𢚱
    # 0x226B2: '',  # 𢚲
    # 0x226B3: '',  # 𢚳
    # 0x226B4: '',  # 𢚴
    # 0x226B5: '',  # 𢚵
    # 0x226B6: '',  # 𢚶
    # 0x226B7: '',  # 𢚷
    # 0x226B8: '',  # 𢚸
    # 0x226B9: '',  # 𢚹
    0x226BA: 'tēng',  # 𢚺
    0x226BB: 'zhù',  # 𢚻
    # 0x226BC: '',  # 𢚼
    # 0x226BD: '',  # 𢚽
    # 0x226BE: '',  # 𢚾
    # 0x226BF: '',  # 𢚿
    # 0x226C0: '',  # 𢛀
    0x226C1: 'dá,chè',  # 𢛁
    # 0x226C2: '',  # 𢛂
    0x226C3: 'qiú',  # 𢛃
    0x226C4: 'yà',  # 𢛄
    # 0x226C5: '',  # 𢛅
    0x226C6: 'xián',  # 𢛆
    # 0x226C7: '',  # 𢛇
    # 0x226C8: '',  # 𢛈
    0x226C9: 'nèi',  # 𢛉
    # 0x226CA: '',  # 𢛊
    # 0x226CB: '',  # 𢛋
    # 0x226CC: '',  # 𢛌
    0x226CD: 'zhǐ',  # 𢛍
    0x226CE: 'bié',  # 𢛎
    # 0x226CF: '',  # 𢛏
    # 0x226D0: '',  # 𢛐
    # 0x226D1: '',  # 𢛑
    0x226D2: 'chǒng',  # 𢛒
    0x226D3: 'lán',  # 𢛓
    0x226D4: 'dōng',  # 𢛔
    0x226D5: 'qūn',  # 𢛕
    0x226D6: 'xiàng',  # 𢛖
    # 0x226D7: '',  # 𢛗
    0x226D8: 'xiáo',  # 𢛘
    0x226D9: 'wǎn',  # 𢛙
    0x226DA: 'rù',  # 𢛚
    0x226DB: 'wàng',  # 𢛛
    0x226DC: 'nì',  # 𢛜
    # 0x226DD: '',  # 𢛝
    0x226DE: 'bāi',  # 𢛞
    0x226DF: 'yà',  # 𢛟
    # 0x226E0: '',  # 𢛠
    # 0x226E1: '',  # 𢛡
    # 0x226E2: '',  # 𢛢
    # 0x226E3: '',  # 𢛣
    # 0x226E4: '',  # 𢛤
    0x226E5: 'sī',  # 𢛥
    0x226E6: 'yǐn',  # 𢛦
    # 0x226E7: '',  # 𢛧
    0x226E8: 'yù',  # 𢛨
    # 0x226E9: '',  # 𢛩
    # 0x226EA: '',  # 𢛪
    # 0x226EB: '',  # 𢛫
    # 0x226EC: '',  # 𢛬
    # 0x226ED: '',  # 𢛭
    0x226EE: 'lí',  # 𢛮
    # 0x226EF: '',  # 𢛯
    # 0x226F0: '',  # 𢛰
    # 0x226F1: '',  # 𢛱
    # 0x226F2: '',  # 𢛲
    # 0x226F3: '',  # 𢛳
    # 0x226F4: '',  # 𢛴
    # 0x226F5: '',  # 𢛵
    # 0x226F6: '',  # 𢛶
    # 0x226F7: '',  # 𢛷
    # 0x226F8: '',  # 𢛸
    # 0x226F9: '',  # 𢛹
    # 0x226FA: '',  # 𢛺
    # 0x226FB: '',  # 𢛻
    # 0x226FC: '',  # 𢛼
    # 0x226FD: '',  # 𢛽
    # 0x226FE: '',  # 𢛾
    # 0x226FF: '',  # 𢛿
    # 0x22700: '',  # 𢜀
    # 0x22701: '',  # 𢜁
    # 0x22702: '',  # 𢜂
    # 0x22703: '',  # 𢜃
    # 0x22704: '',  # 𢜄
    # 0x22705: '',  # 𢜅
    # 0x22706: '',  # 𢜆
    # 0x22707: '',  # 𢜇
    # 0x22708: '',  # 𢜈
    # 0x22709: '',  # 𢜉
    # 0x2270A: '',  # 𢜊
    # 0x2270B: '',  # 𢜋
    # 0x2270C: '',  # 𢜌
    # 0x2270D: '',  # 𢜍
    # 0x2270E: '',  # 𢜎
    # 0x2270F: '',  # 𢜏
    # 0x22710: '',  # 𢜐
    # 0x22711: '',  # 𢜑
    # 0x22712: '',  # 𢜒
    # 0x22713: '',  # 𢜓
    # 0x22714: '',  # 𢜔
    # 0x22715: '',  # 𢜕
    # 0x22716: '',  # 𢜖
    0x22717: 'bàng',  # 𢜗
    0x22718: 'bèn',  # 𢜘
    # 0x22719: '',  # 𢜙
    # 0x2271A: '',  # 𢜚
    # 0x2271B: '',  # 𢜛
    # 0x2271C: '',  # 𢜜
    # 0x2271D: '',  # 𢜝
    # 0x2271E: '',  # 𢜞
    # 0x2271F: '',  # 𢜟
    # 0x22720: '',  # 𢜠
    # 0x22721: '',  # 𢜡
    # 0x22722: '',  # 𢜢
    0x22723: 'xī',  # 𢜣
    # 0x22724: '',  # 𢜤
    0x22725: 'jiū',  # 𢜥
    # 0x22726: '',  # 𢜦
    # 0x22727: '',  # 𢜧
    0x22728: 'xiè,dié',  # 𢜨
    0x22729: 'qiān',  # 𢜩
    0x2272A: 'nuò,ruò',  # 𢜪
    0x2272B: 'xǐng',  # 𢜫
    0x2272C: 'duó',  # 𢜬
    0x2272D: 'jǐ',  # 𢜭
    0x2272E: 'wǔ',  # 𢜮
    0x2272F: 'mú,móu,mǔ',  # 𢜯
    0x22730: 'yàn,yǎn',  # 𢜰
    0x22731: 'qì',  # 𢜱
    0x22732: 'ná',  # 𢜲
    0x22733: 'chì',  # 𢜳
    0x22734: 'hóu',  # 𢜴
    # 0x22735: '',  # 𢜵
    0x22736: 'sào',  # 𢜶
    # 0x22737: '',  # 𢜷
    0x22738: 'náo',  # 𢜸
    # 0x22739: '',  # 𢜹
    # 0x2273A: '',  # 𢜺
    0x2273B: 'chěng',  # 𢜻
    0x2273C: 'chěng',  # 𢜼
    0x2273D: 'kuǐ',  # 𢜽
    # 0x2273E: '',  # 𢜾
    0x2273F: 'jià',  # 𢜿
    0x22740: 'tú',  # 𢝀
    # 0x22741: '',  # 𢝁
    0x22742: 'dú',  # 𢝂
    # 0x22743: '',  # 𢝃
    # 0x22744: '',  # 𢝄
    0x22745: 'xiá',  # 𢝅
    0x22746: 'zhòng',  # 𢝆
    0x22747: 'huò',  # 𢝇
    0x22748: 'chóng',  # 𢝈
    0x22749: 'dá',  # 𢝉
    0x2274A: 'yōu',  # 𢝊
    # 0x2274B: '',  # 𢝋
    0x2274C: 'mào',  # 𢝌
    0x2274D: 'yào',  # 𢝍
    # 0x2274E: '',  # 𢝎
    # 0x2274F: '',  # 𢝏
    # 0x22750: '',  # 𢝐
    # 0x22751: '',  # 𢝑
    # 0x22752: '',  # 𢝒
    0x22753: 'juān',  # 𢝓
    # 0x22754: '',  # 𢝔
    # 0x22755: '',  # 𢝕
    # 0x22756: '',  # 𢝖
    # 0x22757: '',  # 𢝗
    # 0x22758: '',  # 𢝘
    # 0x22759: '',  # 𢝙
    # 0x2275A: '',  # 𢝚
    # 0x2275B: '',  # 𢝛
    # 0x2275C: '',  # 𢝜
    # 0x2275D: '',  # 𢝝
    # 0x2275E: '',  # 𢝞
    # 0x2275F: '',  # 𢝟
    # 0x22760: '',  # 𢝠
    # 0x22761: '',  # 𢝡
    # 0x22762: '',  # 𢝢
    # 0x22763: '',  # 𢝣
    # 0x22764: '',  # 𢝤
    # 0x22765: '',  # 𢝥
    # 0x22766: '',  # 𢝦
    # 0x22767: '',  # 𢝧
    # 0x22768: '',  # 𢝨
    # 0x22769: '',  # 𢝩
    # 0x2276A: '',  # 𢝪
    # 0x2276B: '',  # 𢝫
    0x2276C: 'shì',  # 𢝬
    # 0x2276D: '',  # 𢝭
    # 0x2276E: '',  # 𢝮
    0x2276F: 'yín',  # 𢝯
    # 0x22770: '',  # 𢝰
    # 0x22771: '',  # 𢝱
    0x22772: 'chóu',  # 𢝲
    0x22773: 'gǔ',  # 𢝳
    0x22774: 'wù',  # 𢝴
    # 0x22775: '',  # 𢝵
    # 0x22776: '',  # 𢝶
    # 0x22777: '',  # 𢝷
    0x22778: 'guò',  # 𢝸
    0x22779: 'tì',  # 𢝹
    # 0x2277A: '',  # 𢝺
    0x2277B: 'hōng',  # 𢝻
    # 0x2277C: '',  # 𢝼
    # 0x2277D: '',  # 𢝽
    # 0x2277E: '',  # 𢝾
    # 0x2277F: '',  # 𢝿
    # 0x22780: '',  # 𢞀
    # 0x22781: '',  # 𢞁
    # 0x22782: '',  # 𢞂
    # 0x22783: '',  # 𢞃
    # 0x22784: '',  # 𢞄
    # 0x22785: '',  # 𢞅
    # 0x22786: '',  # 𢞆
    0x22787: 'rě',  # 𢞇
    # 0x22788: '',  # 𢞈
    0x22789: 'yí',  # 𢞉
    # 0x2278A: '',  # 𢞊
    0x2278B: 'tǔn',  # 𢞋
    # 0x2278C: '',  # 𢞌
    # 0x2278D: '',  # 𢞍
    # 0x2278E: '',  # 𢞎
    0x2278F: 'qióng',  # 𢞏
    0x22790: 'hài',  # 𢞐
    # 0x22791: '',  # 𢞑
    0x22792: 'qì',  # 𢞒
    # 0x22793: '',  # 𢞓
    # 0x22794: '',  # 𢞔
    0x22795: 'huò',  # 𢞕
    0x22796: 'tì',  # 𢞖
    0x22797: 'pī,bī',  # 𢞗
    # 0x22798: '',  # 𢞘
    # 0x22799: '',  # 𢞙
    0x2279A: 'gěng',  # 𢞚
    # 0x2279B: '',  # 𢞛
    0x2279C: 'xiè',  # 𢞜
    # 0x2279D: '',  # 𢞝
    0x2279E: 'mì,mí',  # 𢞞
    0x2279F: 'gào',  # 𢞟
    0x227A0: 'tā',  # 𢞠
    0x227A1: 'xiǎng',  # 𢞡
    # 0x227A2: '',  # 𢞢
    0x227A3: 'shū',  # 𢞣
    # 0x227A4: '',  # 𢞤
    # 0x227A5: '',  # 𢞥
    0x227A6: 'fú',  # 𢞦
    # 0x227A7: '',  # 𢞧
    # 0x227A8: '',  # 𢞨
    # 0x227A9: '',  # 𢞩
    # 0x227AA: '',  # 𢞪
    # 0x227AB: '',  # 𢞫
    0x227AC: 'zhuān',  # 𢞬
    0x227AD: 'liù',  # 𢞭
    # 0x227AE: '',  # 𢞮
    # 0x227AF: '',  # 𢞯
    # 0x227B0: '',  # 𢞰
    # 0x227B1: '',  # 𢞱
    # 0x227B2: '',  # 𢞲
    # 0x227B3: '',  # 𢞳
    # 0x227B4: '',  # 𢞴
    # 0x227B5: '',  # 𢞵
    # 0x227B6: '',  # 𢞶
    # 0x227B7: '',  # 𢞷
    # 0x227B8: '',  # 𢞸
    # 0x227B9: '',  # 𢞹
    # 0x227BA: '',  # 𢞺
    # 0x227BB: '',  # 𢞻
    # 0x227BC: '',  # 𢞼
    # 0x227BD: '',  # 𢞽
    # 0x227BE: '',  # 𢞾
    # 0x227BF: '',  # 𢞿
    # 0x227C0: '',  # 𢟀
    # 0x227C1: '',  # 𢟁
    # 0x227C2: '',  # 𢟂
    # 0x227C3: '',  # 𢟃
    # 0x227C4: '',  # 𢟄
    0x227C5: 'yóu',  # 𢟅
    # 0x227C6: '',  # 𢟆
    # 0x227C7: '',  # 𢟇
    # 0x227C8: '',  # 𢟈
    # 0x227C9: '',  # 𢟉
    0x227CA: 'chěng',  # 𢟊
    0x227CB: 'duī',  # 𢟋
    # 0x227CC: '',  # 𢟌
    # 0x227CD: '',  # 𢟍
    # 0x227CE: '',  # 𢟎
    # 0x227CF: '',  # 𢟏
    # 0x227D0: '',  # 𢟐
    # 0x227D1: '',  # 𢟑
    # 0x227D2: '',  # 𢟒
    # 0x227D3: '',  # 𢟓
    # 0x227D4: '',  # 𢟔
    # 0x227D5: '',  # 𢟕
    # 0x227D6: '',  # 𢟖
    # 0x227D7: '',  # 𢟗
    # 0x227D8: '',  # 𢟘
    # 0x227D9: '',  # 𢟙
    # 0x227DA: '',  # 𢟚
    # 0x227DB: '',  # 𢟛
    # 0x227DC: '',  # 𢟜
    # 0x227DD: '',  # 𢟝
    # 0x227DE: '',  # 𢟞
    # 0x227DF: '',  # 𢟟
    # 0x227E0: '',  # 𢟠
    0x227E1: 'bèi',  # 𢟡
    0x227E2: 'lí',  # 𢟢
    0x227E3: 'yàng',  # 𢟣
    0x227E4: 'lí',  # 𢟤
    # 0x227E5: '',  # 𢟥
    # 0x227E6: '',  # 𢟦
    0x227E7: 'lǔ',  # 𢟧
    0x227E8: 'mǔ',  # 𢟨
    0x227E9: 'suì',  # 𢟩
    0x227EA: 'ài,xì',  # 𢟪
    # 0x227EB: '',  # 𢟫
    # 0x227EC: '',  # 𢟬
    0x227ED: 'kòu',  # 𢟭
    # 0x227EE: '',  # 𢟮
    0x227EF: 'zhé,shì',  # 𢟯
    0x227F0: 'ài',  # 𢟰
    0x227F1: 'téng',  # 𢟱
    # 0x227F2: '',  # 𢟲
    0x227F3: 'lǜ',  # 𢟳
    0x227F4: 'tuí',  # 𢟴
    0x227F5: 'bī',  # 𢟵
    # 0x227F6: '',  # 𢟶
    # 0x227F7: '',  # 𢟷
    # 0x227F8: '',  # 𢟸
    # 0x227F9: '',  # 𢟹
    # 0x227FA: '',  # 𢟺
    # 0x227FB: '',  # 𢟻
    # 0x227FC: '',  # 𢟼
    0x227FD: 'mù',  # 𢟽
    0x227FE: 'huì',  # 𢟾
    0x227FF: 'huán',  # 𢟿
    # 0x22800: '',  # 𢠀
    # 0x22801: '',  # 𢠁
    # 0x22802: '',  # 𢠂
    # 0x22803: '',  # 𢠃
    # 0x22804: '',  # 𢠄
    # 0x22805: '',  # 𢠅
    # 0x22806: '',  # 𢠆
    # 0x22807: '',  # 𢠇
    # 0x22808: '',  # 𢠈
    # 0x22809: '',  # 𢠉
    # 0x2280A: '',  # 𢠊
    # 0x2280B: '',  # 𢠋
    # 0x2280C: '',  # 𢠌
    # 0x2280D: '',  # 𢠍
    # 0x2280E: '',  # 𢠎
    # 0x2280F: '',  # 𢠏
    # 0x22810: '',  # 𢠐
    # 0x22811: '',  # 𢠑
    # 0x22812: '',  # 𢠒
    # 0x22813: '',  # 𢠓
    # 0x22814: '',  # 𢠔
    # 0x22815: '',  # 𢠕
    # 0x22816: '',  # 𢠖
    # 0x22817: '',  # 𢠗
    # 0x22818: '',  # 𢠘
    # 0x22819: '',  # 𢠙
    # 0x2281A: '',  # 𢠚
    0x2281B: 'kuò',  # 𢠛
    # 0x2281C: '',  # 𢠜
    0x2281D: 'xīn',  # 𢠝
    # 0x2281E: '',  # 𢠞
    # 0x2281F: '',  # 𢠟
    # 0x22820: '',  # 𢠠
    0x22821: 'sào',  # 𢠡
    # 0x22822: '',  # 𢠢
    # 0x22823: '',  # 𢠣
    # 0x22824: '',  # 𢠤
    # 0x22825: '',  # 𢠥
    # 0x22826: '',  # 𢠦
    # 0x22827: '',  # 𢠧
    # 0x22828: '',  # 𢠨
    # 0x22829: '',  # 𢠩
    # 0x2282A: '',  # 𢠪
    0x2282B: 'shù',  # 𢠫
    0x2282C: 'què',  # 𢠬
    0x2282D: 'bā',  # 𢠭
    0x2282E: 'tuì',  # 𢠮
    # 0x2282F: '',  # 𢠯
    0x22830: 'sǒng',  # 𢠰
    # 0x22831: '',  # 𢠱
    0x22832: 'fù',  # 𢠲
    0x22833: 'biē',  # 𢠳
    # 0x22834: '',  # 𢠴
    0x22835: 'chǎng,tǎng',  # 𢠵
    # 0x22836: '',  # 𢠶
    0x22837: 'xiàng',  # 𢠷
    # 0x22838: '',  # 𢠸
    0x22839: 'sī,xī',  # 𢠹
    0x2283A: 'bó',  # 𢠺
    # 0x2283B: '',  # 𢠻
    0x2283C: 'mái',  # 𢠼
    0x2283D: 'dàng',  # 𢠽
    # 0x2283E: '',  # 𢠾
    0x2283F: 'guì',  # 𢠿
    0x22840: 'hēi',  # 𢡀
    0x22841: 'xī',  # 𢡁
    0x22842: 'dàng',  # 𢡂
    0x22843: 'yì',  # 𢡃
    # 0x22844: '',  # 𢡄
    0x22845: 'bī',  # 𢡅
    0x22846: 'kěn',  # 𢡆
    0x22847: 'gū',  # 𢡇
    0x22848: 'cuì',  # 𢡈
    0x22849: 'sè',  # 𢡉
    # 0x2284A: '',  # 𢡊
    # 0x2284B: '',  # 𢡋
    # 0x2284C: '',  # 𢡌
    0x2284D: 'gé',  # 𢡍
    0x2284E: 'yù',  # 𢡎
    0x2284F: 'nǎ',  # 𢡏
    # 0x22850: '',  # 𢡐
    0x22851: 'lì',  # 𢡑
    0x22852: 'zhì',  # 𢡒
    # 0x22853: '',  # 𢡓
    # 0x22854: '',  # 𢡔
    # 0x22855: '',  # 𢡕
    # 0x22856: '',  # 𢡖
    # 0x22857: '',  # 𢡗
    # 0x22858: '',  # 𢡘
    # 0x22859: '',  # 𢡙
    # 0x2285A: '',  # 𢡚
    # 0x2285B: '',  # 𢡛
    # 0x2285C: '',  # 𢡜
    # 0x2285D: '',  # 𢡝
    # 0x2285E: '',  # 𢡞
    # 0x2285F: '',  # 𢡟
    # 0x22860: '',  # 𢡠
    # 0x22861: '',  # 𢡡
    # 0x22862: '',  # 𢡢
    # 0x22863: '',  # 𢡣
    # 0x22864: '',  # 𢡤
    # 0x22865: '',  # 𢡥
    # 0x22866: '',  # 𢡦
    # 0x22867: '',  # 𢡧
    # 0x22868: '',  # 𢡨
    # 0x22869: '',  # 𢡩
    # 0x2286A: '',  # 𢡪
    # 0x2286B: '',  # 𢡫
    # 0x2286C: '',  # 𢡬
    # 0x2286D: '',  # 𢡭
    # 0x2286E: '',  # 𢡮
    # 0x2286F: '',  # 𢡯
    0x22870: 'zhào',  # 𢡰
    # 0x22871: '',  # 𢡱
    # 0x22872: '',  # 𢡲
    # 0x22873: '',  # 𢡳
    0x22874: 'jī',  # 𢡴
    0x22875: 'ruǎn',  # 𢡵
    # 0x22876: '',  # 𢡶
    # 0x22877: '',  # 𢡷
    # 0x22878: '',  # 𢡸
    0x22879: 'chòng',  # 𢡹
    # 0x2287A: '',  # 𢡺
    # 0x2287B: '',  # 𢡻
    # 0x2287C: '',  # 𢡼
    # 0x2287D: '',  # 𢡽
    # 0x2287E: '',  # 𢡾
    # 0x2287F: '',  # 𢡿
    # 0x22880: '',  # 𢢀
    # 0x22881: '',  # 𢢁
    0x22882: 'jié',  # 𢢂
    # 0x22883: '',  # 𢢃
    # 0x22884: '',  # 𢢄
    # 0x22885: '',  # 𢢅
    # 0x22886: '',  # 𢢆
    # 0x22887: '',  # 𢢇
    # 0x22888: '',  # 𢢈
    # 0x22889: '',  # 𢢉
    # 0x2288A: '',  # 𢢊
    # 0x2288B: '',  # 𢢋
    0x2288C: 'chàng',  # 𢢌
    0x2288D: 'zhé',  # 𢢍
    # 0x2288E: '',  # 𢢎
    # 0x2288F: '',  # 𢢏
    # 0x22890: '',  # 𢢐
    # 0x22891: '',  # 𢢑
    0x22892: 'sù',  # 𢢒
    0x22893: 'yōng',  # 𢢓
    # 0x22894: '',  # 𢢔
    # 0x22895: '',  # 𢢕
    0x22896: 'qì',  # 𢢖
    0x22897: 'zhuó',  # 𢢗
    # 0x22898: '',  # 𢢘
    # 0x22899: '',  # 𢢙
    0x2289A: 'kài',  # 𢢚
    # 0x2289B: '',  # 𢢛
    0x2289C: 'yè',  # 𢢜
    # 0x2289D: '',  # 𢢝
    0x2289E: 'qì,jì,kuài',  # 𢢞
    # 0x2289F: '',  # 𢢟
    # 0x228A0: '',  # 𢢠
    # 0x228A1: '',  # 𢢡
    # 0x228A2: '',  # 𢢢
    # 0x228A3: '',  # 𢢣
    # 0x228A4: '',  # 𢢤
    # 0x228A5: '',  # 𢢥
    # 0x228A6: '',  # 𢢦
    # 0x228A7: '',  # 𢢧
    # 0x228A8: '',  # 𢢨
    # 0x228A9: '',  # 𢢩
    # 0x228AA: '',  # 𢢪
    # 0x228AB: '',  # 𢢫
    # 0x228AC: '',  # 𢢬
    # 0x228AD: '',  # 𢢭
    # 0x228AE: '',  # 𢢮
    # 0x228AF: '',  # 𢢯
    # 0x228B0: '',  # 𢢰
    # 0x228B1: '',  # 𢢱
    # 0x228B2: '',  # 𢢲
    # 0x228B3: '',  # 𢢳
    # 0x228B4: '',  # 𢢴
    # 0x228B5: '',  # 𢢵
    # 0x228B6: '',  # 𢢶
    # 0x228B7: '',  # 𢢷
    # 0x228B8: '',  # 𢢸
    0x228B9: 'xiòng',  # 𢢹
    # 0x228BA: '',  # 𢢺
    # 0x228BB: '',  # 𢢻
    0x228BC: 'biāo',  # 𢢼
    # 0x228BD: '',  # 𢢽
    # 0x228BE: '',  # 𢢾
    # 0x228BF: '',  # 𢢿
    # 0x228C0: '',  # 𢣀
    # 0x228C1: '',  # 𢣁
    # 0x228C2: '',  # 𢣂
    # 0x228C3: '',  # 𢣃
    # 0x228C4: '',  # 𢣄
    # 0x228C5: '',  # 𢣅
    # 0x228C6: '',  # 𢣆
    # 0x228C7: '',  # 𢣇
    # 0x228C8: '',  # 𢣈
    0x228C9: 'yī',  # 𢣉
    0x228CA: 'chǒu',  # 𢣊
    # 0x228CB: '',  # 𢣋
    # 0x228CC: '',  # 𢣌
    # 0x228CD: '',  # 𢣍
    0x228CE: 'tuǎn',  # 𢣎
    0x228CF: 'ài',  # 𢣏
    0x228D0: 'pīn',  # 𢣐
    # 0x228D1: '',  # 𢣑
    # 0x228D2: '',  # 𢣒
    0x228D3: 'liè',  # 𢣓
    0x228D4: 'mián',  # 𢣔
    0x228D5: 'ài,chī',  # 𢣕
    # 0x228D6: '',  # 𢣖
    0x228D7: 'mǒ',  # 𢣗
    0x228D8: 'wèi',  # 𢣘
    0x228D9: 'yìng',  # 𢣙
    0x228DA: 'nǐ',  # 𢣚
    # 0x228DB: '',  # 𢣛
    # 0x228DC: '',  # 𢣜
    # 0x228DD: '',  # 𢣝
    0x228DE: 'bó',  # 𢣞
    # 0x228DF: '',  # 𢣟
    0x228E0: 'liù',  # 𢣠
    # 0x228E1: '',  # 𢣡
    0x228E2: 'xié',  # 𢣢
    # 0x228E3: '',  # 𢣣
    # 0x228E4: '',  # 𢣤
    # 0x228E5: '',  # 𢣥
    # 0x228E6: '',  # 𢣦
    # 0x228E7: '',  # 𢣧
    # 0x228E8: '',  # 𢣨
    # 0x228E9: '',  # 𢣩
    # 0x228EA: '',  # 𢣪
    # 0x228EB: '',  # 𢣫
    # 0x228EC: '',  # 𢣬
    # 0x228ED: '',  # 𢣭
    # 0x228EE: '',  # 𢣮
    # 0x228EF: '',  # 𢣯
    # 0x228F0: '',  # 𢣰
    # 0x228F1: '',  # 𢣱
    # 0x228F2: '',  # 𢣲
    0x228F3: 'ruì',  # 𢣳
    # 0x228F4: '',  # 𢣴
    # 0x228F5: '',  # 𢣵
    # 0x228F6: '',  # 𢣶
    # 0x228F7: '',  # 𢣷
    # 0x228F8: '',  # 𢣸
    # 0x228F9: '',  # 𢣹
    # 0x228FA: '',  # 𢣺
    0x228FB: 'lǘ',  # 𢣻
    0x228FC: 'chá',  # 𢣼
    # 0x228FD: '',  # 𢣽
    # 0x228FE: '',  # 𢣾
    0x228FF: 'chù',  # 𢣿
    # 0x22900: '',  # 𢤀
    0x22901: 'sào',  # 𢤁
    0x22902: 'lí',  # 𢤂
    # 0x22903: '',  # 𢤃
    0x22904: 'sōng',  # 𢤄
    # 0x22905: '',  # 𢤅
    0x22906: 'lì,là',  # 𢤆
    # 0x22907: '',  # 𢤇
    # 0x22908: '',  # 𢤈
    # 0x22909: '',  # 𢤉
    # 0x2290A: '',  # 𢤊
    0x2290B: 'xì',  # 𢤋
    # 0x2290C: '',  # 𢤌
    0x2290D: 'yān',  # 𢤍
    0x2290E: 'cuō,zuǒ',  # 𢤎
    # 0x2290F: '',  # 𢤏
    0x22910: 'liú',  # 𢤐
    # 0x22911: '',  # 𢤑
    # 0x22912: '',  # 𢤒
    # 0x22913: '',  # 𢤓
    # 0x22914: '',  # 𢤔
    # 0x22915: '',  # 𢤕
    # 0x22916: '',  # 𢤖
    # 0x22917: '',  # 𢤗
    0x22918: 'méng',  # 𢤘
    # 0x22919: '',  # 𢤙
    0x2291A: 'zhàn',  # 𢤚
    # 0x2291B: '',  # 𢤛
    # 0x2291C: '',  # 𢤜
    # 0x2291D: '',  # 𢤝
    # 0x2291E: '',  # 𢤞
    # 0x2291F: '',  # 𢤟
    # 0x22920: '',  # 𢤠
    # 0x22921: '',  # 𢤡
    # 0x22922: '',  # 𢤢
    # 0x22923: '',  # 𢤣
    0x22924: 'zhuàng',  # 𢤤
    # 0x22925: '',  # 𢤥
    # 0x22926: '',  # 𢤦
    0x22927: 'miǎo',  # 𢤧
    # 0x22928: '',  # 𢤨
    0x22929: 'lì',  # 𢤩
    # 0x2292A: '',  # 𢤪
    0x2292B: 'jǔ',  # 𢤫
    # 0x2292C: '',  # 𢤬
    # 0x2292D: '',  # 𢤭
    # 0x2292E: '',  # 𢤮
    0x2292F: 'xiè',  # 𢤯
    0x22930: 'xiè',  # 𢤰
    0x22931: 'lǒng',  # 𢤱
    0x22932: 'lóng',  # 𢤲
    # 0x22933: '',  # 𢤳
    # 0x22934: '',  # 𢤴
    # 0x22935: '',  # 𢤵
    # 0x22936: '',  # 𢤶
    # 0x22937: '',  # 𢤷
    # 0x22938: '',  # 𢤸
    # 0x22939: '',  # 𢤹
    # 0x2293A: '',  # 𢤺
    # 0x2293B: '',  # 𢤻
    # 0x2293C: '',  # 𢤼
    # 0x2293D: '',  # 𢤽
    # 0x2293E: '',  # 𢤾
    # 0x2293F: '',  # 𢤿
    # 0x22940: '',  # 𢥀
    # 0x22941: '',  # 𢥁
    0x22942: 'téng',  # 𢥂
    0x22943: 'zhù',  # 𢥃
    # 0x22944: '',  # 𢥄
    # 0x22945: '',  # 𢥅
    # 0x22946: '',  # 𢥆
    # 0x22947: '',  # 𢥇
    # 0x22948: '',  # 𢥈
    # 0x22949: '',  # 𢥉
    # 0x2294A: '',  # 𢥊
    0x2294B: 'chán',  # 𢥋
    0x2294C: 'xiǎn',  # 𢥌
    # 0x2294D: '',  # 𢥍
    # 0x2294E: '',  # 𢥎
    0x2294F: 'yíng',  # 𢥏
    0x22950: 'pèi',  # 𢥐
    # 0x22951: '',  # 𢥑
    # 0x22952: '',  # 𢥒
    # 0x22953: '',  # 𢥓
    # 0x22954: '',  # 𢥔
    # 0x22955: '',  # 𢥕
    # 0x22956: '',  # 𢥖
    # 0x22957: '',  # 𢥗
    0x22958: 'xié',  # 𢥘
    # 0x22959: '',  # 𢥙
    0x2295A: 'jiào',  # 𢥚
    0x2295B: 'sè',  # 𢥛
    # 0x2295C: '',  # 𢥜
    # 0x2295D: '',  # 𢥝
    0x2295E: 'chōng',  # 𢥞
    # 0x2295F: '',  # 𢥟
    0x22960: 'sǒng',  # 𢥠
    # 0x22961: '',  # 𢥡
    # 0x22962: '',  # 𢥢
    # 0x22963: '',  # 𢥣
    # 0x22964: '',  # 𢥤
    # 0x22965: '',  # 𢥥
    # 0x22966: '',  # 𢥦
    # 0x22967: '',  # 𢥧
    # 0x22968: '',  # 𢥨
    # 0x22969: '',  # 𢥩
    # 0x2296A: '',  # 𢥪
    # 0x2296B: '',  # 𢥫
    # 0x2296C: '',  # 𢥬
    # 0x2296D: '',  # 𢥭
    # 0x2296E: '',  # 𢥮
    # 0x2296F: '',  # 𢥯
    # 0x22970: '',  # 𢥰
    # 0x22971: '',  # 𢥱
    # 0x22972: '',  # 𢥲
    0x22973: 'hē',  # 𢥳
    # 0x22974: '',  # 𢥴
    # 0x22975: '',  # 𢥵
    # 0x22976: '',  # 𢥶
    # 0x22977: '',  # 𢥷
    # 0x22978: '',  # 𢥸
    # 0x22979: '',  # 𢥹
    # 0x2297A: '',  # 𢥺
    # 0x2297B: '',  # 𢥻
    # 0x2297C: '',  # 𢥼
    0x2297D: 'tǔn',  # 𢥽
    # 0x2297E: '',  # 𢥾
    # 0x2297F: '',  # 𢥿
    # 0x22980: '',  # 𢦀
    # 0x22981: '',  # 𢦁
    # 0x22982: '',  # 𢦂
    # 0x22983: '',  # 𢦃
    # 0x22984: '',  # 𢦄
    0x22985: 'hǒng,zhuàng',  # 𢦅
    # 0x22986: '',  # 𢦆
    # 0x22987: '',  # 𢦇
    0x22988: 'mán',  # 𢦈
    # 0x22989: '',  # 𢦉
    0x2298A: 'jīn',  # 𢦊
    # 0x2298B: '',  # 𢦋
    0x2298C: 'qú',  # 𢦌
    0x2298D: 'dǒu',  # 𢦍
    0x2298E: 'qiú',  # 𢦎
    0x2298F: 'zāi',  # 𢦏
    # 0x22990: '',  # 𢦐
    0x22991: 'shēng',  # 𢦑
    0x22992: 'zāi',  # 𢦒
    # 0x22993: '',  # 𢦓
    0x22994: 'zāi',  # 𢦔
    0x22995: 'yǐ,zhí',  # 𢦕
    # 0x22996: '',  # 𢦖
    # 0x22997: '',  # 𢦗
    # 0x22998: '',  # 𢦘
    # 0x22999: '',  # 𢦙
    0x2299A: 'huà',  # 𢦚
    # 0x2299B: '',  # 𢦛
    # 0x2299C: '',  # 𢦜
    # 0x2299D: '',  # 𢦝
    # 0x2299E: '',  # 𢦞
    0x2299F: 'kān',  # 𢦟
    # 0x229A0: '',  # 𢦠
    # 0x229A1: '',  # 𢦡
    # 0x229A2: '',  # 𢦢
    0x229A3: 'yè',  # 𢦣
    # 0x229A4: '',  # 𢦤
    # 0x229A5: '',  # 𢦥
    0x229A6: 'róng',  # 𢦦
    # 0x229A7: '',  # 𢦧
    # 0x229A8: '',  # 𢦨
    # 0x229A9: '',  # 𢦩
    # 0x229AA: '',  # 𢦪
    # 0x229AB: '',  # 𢦫
    # 0x229AC: '',  # 𢦬
    # 0x229AD: '',  # 𢦭
    # 0x229AE: '',  # 𢦮
    # 0x229AF: '',  # 𢦯
    0x229B0: 'yuè',  # 𢦰
    0x229B1: 'nì',  # 𢦱
    0x229B2: 'sī',  # 𢦲
    # 0x229B3: '',  # 𢦳
    0x229B4: 'wǒ',  # 𢦴
    # 0x229B5: '',  # 𢦵
    # 0x229B6: '',  # 𢦶
    # 0x229B7: '',  # 𢦷
    0x229B8: 'cán',  # 𢦸
    # 0x229B9: '',  # 𢦹
    0x229BA: 'jiān',  # 𢦺
    # 0x229BB: '',  # 𢦻
    0x229BC: 'miè',  # 𢦼
    0x229BD: 'sháo,qī',  # 𢦽
    # 0x229BE: '',  # 𢦾
    0x229BF: 'rǒng',  # 𢦿
    0x229C0: 'gān',  # 𢧀
    # 0x229C1: '',  # 𢧁
    # 0x229C2: '',  # 𢧂
    # 0x229C3: '',  # 𢧃
    0x229C4: 'dié',  # 𢧄
    0x229C5: 'qiáng',  # 𢧅
    # 0x229C6: '',  # 𢧆
    0x229C7: 'shú',  # 𢧇
    0x229C8: 'zhuó',  # 𢧈
    # 0x229C9: '',  # 𢧉
    # 0x229CA: '',  # 𢧊
    # 0x229CB: '',  # 𢧋
    # 0x229CC: '',  # 𢧌
    # 0x229CD: '',  # 𢧍
    # 0x229CE: '',  # 𢧎
    0x229CF: 'shī',  # 𢧏
    # 0x229D0: '',  # 𢧐
    0x229D1: 'tì',  # 𢧑
    # 0x229D2: '',  # 𢧒
    # 0x229D3: '',  # 𢧓
    # 0x229D4: '',  # 𢧔
    # 0x229D5: '',  # 𢧕
    0x229D6: 'zhá',  # 𢧖
    0x229D7: 'zhān',  # 𢧗
    # 0x229D8: '',  # 𢧘
    # 0x229D9: '',  # 𢧙
    # 0x229DA: '',  # 𢧚
    # 0x229DB: '',  # 𢧛
    0x229DC: 'zhì',  # 𢧜
    0x229DD: 'fèn',  # 𢧝
    0x229DE: 'miè',  # 𢧞
    # 0x229DF: '',  # 𢧟
    0x229E0: 'zè',  # 𢧠
    # 0x229E1: '',  # 𢧡
    0x229E2: 'jǐ',  # 𢧢
    # 0x229E3: '',  # 𢧣
    0x229E4: 'zhì',  # 𢧤
    0x229E5: 'qiān',  # 𢧥
    0x229E6: 'hàn',  # 𢧦
    0x229E7: 'gé',  # 𢧧
    # 0x229E8: '',  # 𢧨
    # 0x229E9: '',  # 𢧩
    # 0x229EA: '',  # 𢧪
    # 0x229EB: '',  # 𢧫
    # 0x229EC: '',  # 𢧬
    # 0x229ED: '',  # 𢧭
    0x229EE: 'cán',  # 𢧮
    # 0x229EF: '',  # 𢧯
    0x229F0: 'guó',  # 𢧰
    0x229F1: 'jiāo',  # 𢧱
    # 0x229F2: '',  # 𢧲
    0x229F3: 'yōng',  # 𢧳
    0x229F4: 'áo',  # 𢧴
    0x229F5: 'jié',  # 𢧵
    # 0x229F6: '',  # 𢧶
    # 0x229F7: '',  # 𢧷
    # 0x229F8: '',  # 𢧸
    # 0x229F9: '',  # 𢧹
    # 0x229FA: '',  # 𢧺
    0x229FB: 'zhá',  # 𢧻
    # 0x229FC: '',  # 𢧼
    0x229FD: 'xì',  # 𢧽
    # 0x229FE: '',  # 𢧾
    # 0x229FF: '',  # 𢧿
    # 0x22A00: '',  # 𢨀
    0x22A01: 'xū',  # 𢨁
    0x22A02: 'wǔ',  # 𢨂
    # 0x22A03: '',  # 𢨃
    # 0x22A04: '',  # 𢨄
    # 0x22A05: '',  # 𢨅
    # 0x22A06: '',  # 𢨆
    # 0x22A07: '',  # 𢨇
    # 0x22A08: '',  # 𢨈
    # 0x22A09: '',  # 𢨉
    # 0x22A0A: '',  # 𢨊
    # 0x22A0B: '',  # 𢨋
    # 0x22A0C: '',  # 𢨌
    # 0x22A0D: '',  # 𢨍
    # 0x22A0E: '',  # 𢨎
    0x22A0F: 'jué',  # 𢨏
    0x22A10: 'jī',  # 𢨐
    # 0x22A11: '',  # 𢨑
    0x22A12: 'chì',  # 𢨒
    # 0x22A13: '',  # 𢨓
    0x22A14: 'wǎn',  # 𢨔
    # 0x22A15: '',  # 𢨕
    0x22A16: 'miè',  # 𢨖
    0x22A17: 'zéi',  # 𢨗
    # 0x22A18: '',  # 𢨘
    # 0x22A19: '',  # 𢨙
    # 0x22A1A: '',  # 𢨚
    # 0x22A1B: '',  # 𢨛
    0x22A1C: 'jié',  # 𢨜
    0x22A1D: 'shí',  # 𢨝
    # 0x22A1E: '',  # 𢨞
    0x22A1F: 'xī,xì',  # 𢨟
    # 0x22A20: '',  # 𢨠
    0x22A21: 'è',  # 𢨡
    # 0x22A22: '',  # 𢨢
    # 0x22A23: '',  # 𢨣
    # 0x22A24: '',  # 𢨤
    0x22A25: 'hù',  # 𢨥
    0x22A26: 'hù',  # 𢨦
    # 0x22A27: '',  # 𢨧
    0x22A28: 'lì',  # 𢨨
    # 0x22A29: '',  # 𢨩
    # 0x22A2A: '',  # 𢨪
    0x22A2B: 'chù',  # 𢨫
    # 0x22A2C: '',  # 𢨬
    # 0x22A2D: '',  # 𢨭
    0x22A2E: 'yī',  # 𢨮
    0x22A2F: 'mǎo',  # 𢨯
    0x22A30: 'xū',  # 𢨰
    0x22A31: 'zhōng',  # 𢨱
    0x22A32: 'fáng',  # 𢨲
    0x22A33: 'yì',  # 𢨳
    # 0x22A34: '',  # 𢨴
    # 0x22A35: '',  # 𢨵
    # 0x22A36: '',  # 𢨶
    # 0x22A37: '',  # 𢨷
    # 0x22A38: '',  # 𢨸
    # 0x22A39: '',  # 𢨹
    0x22A3A: 'liáo',  # 𢨺
    # 0x22A3B: '',  # 𢨻
    # 0x22A3C: '',  # 𢨼
    # 0x22A3D: '',  # 𢨽
    # 0x22A3E: '',  # 𢨾
    0x22A3F: 'jiān',  # 𢨿
    0x22A40: 'jiǎn',  # 𢩀
    0x22A41: 'jú',  # 𢩁
    # 0x22A42: '',  # 𢩂
    # 0x22A43: '',  # 𢩃
    0x22A44: 'zhù',  # 𢩄
    # 0x22A45: '',  # 𢩅
    # 0x22A46: '',  # 𢩆
    # 0x22A47: '',  # 𢩇
    0x22A48: 'wǔ',  # 𢩈
    # 0x22A49: '',  # 𢩉
    # 0x22A4A: '',  # 𢩊
    # 0x22A4B: '',  # 𢩋
    # 0x22A4C: '',  # 𢩌
    # 0x22A4D: '',  # 𢩍
    # 0x22A4E: '',  # 𢩎
    0x22A4F: 'kè',  # 𢩏
    0x22A50: 'kě',  # 𢩐
    0x22A51: 'lì',  # 𢩑
    0x22A52: 'bǐ',  # 𢩒
    0x22A53: 'gé',  # 𢩓
    # 0x22A54: '',  # 𢩔
    0x22A55: 'xū',  # 𢩕
    0x22A56: 'shā',  # 𢩖
    0x22A57: 'líng',  # 𢩗
    0x22A58: 'kē',  # 𢩘
    # 0x22A59: '',  # 𢩙
    # 0x22A5A: '',  # 𢩚
    # 0x22A5B: '',  # 𢩛
    # 0x22A5C: '',  # 𢩜
    # 0x22A5D: '',  # 𢩝
    0x22A5E: 'bó',  # 𢩞
    0x22A5F: 'biān',  # 𢩟
    0x22A60: 'shuān',  # 𢩠
    0x22A61: 'qí',  # 𢩡
    0x22A62: 'shàn',  # 𢩢
    # 0x22A63: '',  # 𢩣
    # 0x22A64: '',  # 𢩤
    # 0x22A65: '',  # 𢩥
    0x22A66: 'jī',  # 𢩦
    # 0x22A67: '',  # 𢩧
    0x22A68: 'qiǎo,xiǔ',  # 𢩨
    # 0x22A69: '',  # 𢩩
    0x22A6A: 'liāo',  # 𢩪
    # 0x22A6B: '',  # 𢩫
    # 0x22A6C: '',  # 𢩬
    # 0x22A6D: '',  # 𢩭
    0x22A6E: 'yì',  # 𢩮
    0x22A6F: 'jué',  # 𢩯
    0x22A70: 'zhǎng',  # 𢩰
    # 0x22A71: '',  # 𢩱
    0x22A72: 'xìn',  # 𢩲
    # 0x22A73: '',  # 𢩳
    # 0x22A74: '',  # 𢩴
    # 0x22A75: '',  # 𢩵
    # 0x22A76: '',  # 𢩶
    0x22A77: 'tuō',  # 𢩷
    0x22A78: 'hài',  # 𢩸
    0x22A79: 'xià',  # 𢩹
    # 0x22A7A: '',  # 𢩺
    0x22A7B: 'tuó',  # 𢩻
    0x22A7C: 'yí',  # 𢩼
    # 0x22A7D: '',  # 𢩽
    # 0x22A7E: '',  # 𢩾
    # 0x22A7F: '',  # 𢩿
    # 0x22A80: '',  # 𢪀
    # 0x22A81: '',  # 𢪁
    0x22A82: 'xuǎn',  # 𢪂
    0x22A83: 'cù',  # 𢪃
    # 0x22A84: '',  # 𢪄
    # 0x22A85: '',  # 𢪅
    # 0x22A86: '',  # 𢪆
    0x22A87: 'jiāng',  # 𢪇
    0x22A88: 'nán',  # 𢪈
    # 0x22A89: '',  # 𢪉
    # 0x22A8A: '',  # 𢪊
    0x22A8B: 'pěng,féng,bàng',  # 𢪋
    # 0x22A8C: '',  # 𢪌
    0x22A8D: 'jié,jiā',  # 𢪍
    0x22A8E: 'xuē',  # 𢪎
    0x22A8F: 'hú,gǔ',  # 𢪏
    # 0x22A90: '',  # 𢪐
    0x22A91: 'gài',  # 𢪑
    # 0x22A92: '',  # 𢪒
    # 0x22A93: '',  # 𢪓
    # 0x22A94: '',  # 𢪔
    # 0x22A95: '',  # 𢪕
    # 0x22A96: '',  # 𢪖
    # 0x22A97: '',  # 𢪗
    # 0x22A98: '',  # 𢪘
    # 0x22A99: '',  # 𢪙
    # 0x22A9A: '',  # 𢪚
    # 0x22A9B: '',  # 𢪛
    # 0x22A9C: '',  # 𢪜
    # 0x22A9D: '',  # 𢪝
    # 0x22A9E: '',  # 𢪞
    # 0x22A9F: '',  # 𢪟
    0x22AA0: 'chōng',  # 𢪠
    # 0x22AA1: '',  # 𢪡
    # 0x22AA2: '',  # 𢪢
    # 0x22AA3: '',  # 𢪣
    # 0x22AA4: '',  # 𢪤
    0x22AA5: 'yǒu',  # 𢪥
    0x22AA6: 'nǔ',  # 𢪦
    0x22AA7: 'yè',  # 𢪧
    # 0x22AA8: '',  # 𢪨
    # 0x22AA9: '',  # 𢪩
    0x22AAA: 'yìn',  # 𢪪
    # 0x22AAB: '',  # 𢪫
    0x22AAC: 'kǒng',  # 𢪬
    # 0x22AAD: '',  # 𢪭
    # 0x22AAE: '',  # 𢪮
    # 0x22AAF: '',  # 𢪯
    # 0x22AB0: '',  # 𢪰
    0x22AB1: 'wù',  # 𢪱
    # 0x22AB2: '',  # 𢪲
    # 0x22AB3: '',  # 𢪳
    # 0x22AB4: '',  # 𢪴
    # 0x22AB5: '',  # 𢪵
    0x22AB6: 'xiāo',  # 𢪶
    0x22AB7: 'xiāng',  # 𢪷
    # 0x22AB8: '',  # 𢪸
    # 0x22AB9: '',  # 𢪹
    # 0x22ABA: '',  # 𢪺
    # 0x22ABB: '',  # 𢪻
    0x22ABC: 'náo',  # 𢪼
    # 0x22ABD: '',  # 𢪽
    0x22ABE: 'zhàng',  # 𢪾
    # 0x22ABF: '',  # 𢪿
    # 0x22AC0: '',  # 𢫀
    # 0x22AC1: '',  # 𢫁
    # 0x22AC2: '',  # 𢫂
    # 0x22AC3: '',  # 𢫃
    # 0x22AC4: '',  # 𢫄
    # 0x22AC5: '',  # 𢫅
    0x22AC6: 'bō',  # 𢫆
    # 0x22AC7: '',  # 𢫇
    0x22AC8: 'gū,gǔ',  # 𢫈
    # 0x22AC9: '',  # 𢫉
    # 0x22ACA: '',  # 𢫊
    # 0x22ACB: '',  # 𢫋
    # 0x22ACC: '',  # 𢫌
    # 0x22ACD: '',  # 𢫍
    # 0x22ACE: '',  # 𢫎
    # 0x22ACF: '',  # 𢫏
    0x22AD0: 'jié',  # 𢫐
    # 0x22AD1: '',  # 𢫑
    # 0x22AD2: '',  # 𢫒
    0x22AD3: 'nǔ',  # 𢫓
    0x22AD4: 'shàn,quán',  # 𢫔
    0x22AD5: 'yǒng',  # 𢫕
    # 0x22AD6: '',  # 𢫖
    # 0x22AD7: '',  # 𢫗
    0x22AD8: 'lú',  # 𢫘
    # 0x22AD9: '',  # 𢫙
    # 0x22ADA: '',  # 𢫚
    # 0x22ADB: '',  # 𢫛
    # 0x22ADC: '',  # 𢫜
    # 0x22ADD: '',  # 𢫝
    # 0x22ADE: '',  # 𢫞
    # 0x22ADF: '',  # 𢫟
    # 0x22AE0: '',  # 𢫠
    # 0x22AE1: '',  # 𢫡
    0x22AE2: 'jiá',  # 𢫢
    # 0x22AE3: '',  # 𢫣
    # 0x22AE4: '',  # 𢫤
    # 0x22AE5: '',  # 𢫥
    0x22AE6: 'pāi',  # 𢫦
    0x22AE7: 'zhǒu',  # 𢫧
    0x22AE8: 'rǒng,rēng',  # 𢫨
    0x22AE9: 'hāo',  # 𢫩
    # 0x22AEA: '',  # 𢫪
    0x22AEB: 'lù',  # 𢫫
    0x22AEC: 'cuō',  # 𢫬
    0x22AED: 'nù',  # 𢫭
    # 0x22AEE: '',  # 𢫮
    0x22AEF: 'bó',  # 𢫯
    0x22AF0: 'zhé',  # 𢫰
    # 0x22AF1: '',  # 𢫱
    0x22AF2: 'qǐn',  # 𢫲
    # 0x22AF3: '',  # 𢫳
    0x22AF4: 'cī',  # 𢫴
    0x22AF5: 'zú',  # 𢫵
    # 0x22AF6: '',  # 𢫶
    0x22AF7: 'wǒ',  # 𢫷
    0x22AF8: 'wǔ,wū',  # 𢫸
    # 0x22AF9: '',  # 𢫹
    # 0x22AFA: '',  # 𢫺
    0x22AFB: 'nié',  # 𢫻
    # 0x22AFC: '',  # 𢫼
    # 0x22AFD: '',  # 𢫽
    # 0x22AFE: '',  # 𢫾
    0x22AFF: 'xiān',  # 𢫿
    0x22B00: 'hóng',  # 𢬀
    # 0x22B01: '',  # 𢬁
    # 0x22B02: '',  # 𢬂
    # 0x22B03: '',  # 𢬃
    # 0x22B04: '',  # 𢬄
    # 0x22B05: '',  # 𢬅
    # 0x22B06: '',  # 𢬆
    # 0x22B07: '',  # 𢬇
    # 0x22B08: '',  # 𢬈
    # 0x22B09: '',  # 𢬉
    # 0x22B0A: '',  # 𢬊
    # 0x22B0B: '',  # 𢬋
    # 0x22B0C: '',  # 𢬌
    # 0x22B0D: '',  # 𢬍
    # 0x22B0E: '',  # 𢬎
    # 0x22B0F: '',  # 𢬏
    # 0x22B10: '',  # 𢬐
    # 0x22B11: '',  # 𢬑
    # 0x22B12: '',  # 𢬒
    # 0x22B13: '',  # 𢬓
    # 0x22B14: '',  # 𢬔
    # 0x22B15: '',  # 𢬕
    # 0x22B16: '',  # 𢬖
    # 0x22B17: '',  # 𢬗
    # 0x22B18: '',  # 𢬘
    # 0x22B19: '',  # 𢬙
    # 0x22B1A: '',  # 𢬚
    # 0x22B1B: '',  # 𢬛
    # 0x22B1C: '',  # 𢬜
    # 0x22B1D: '',  # 𢬝
    # 0x22B1E: '',  # 𢬞
    # 0x22B1F: '',  # 𢬟
    # 0x22B20: '',  # 𢬠
    # 0x22B21: '',  # 𢬡
    # 0x22B22: '',  # 𢬢
    # 0x22B23: '',  # 𢬣
    # 0x22B24: '',  # 𢬤
    # 0x22B25: '',  # 𢬥
    # 0x22B26: '',  # 𢬦
    # 0x22B27: '',  # 𢬧
    # 0x22B28: '',  # 𢬨
    # 0x22B29: '',  # 𢬩
    # 0x22B2A: '',  # 𢬪
    0x22B2B: 'tìng',  # 𢬫
    0x22B2C: 'jǐn',  # 𢬬
    # 0x22B2D: '',  # 𢬭
    # 0x22B2E: '',  # 𢬮
    # 0x22B2F: '',  # 𢬯
    # 0x22B30: '',  # 𢬰
    0x22B31: 'jié',  # 𢬱
    0x22B32: 'hè',  # 𢬲
    0x22B33: 'tū',  # 𢬳
    0x22B34: 'zhé,niè,dié',  # 𢬴
    0x22B35: 'pīn,pān,biàn,fān',  # 𢬵
    0x22B36: 'jìn',  # 𢬶
    0x22B37: 'nàn',  # 𢬷
    # 0x22B38: '',  # 𢬸
    # 0x22B39: '',  # 𢬹
    # 0x22B3A: '',  # 𢬺
    # 0x22B3B: '',  # 𢬻
    0x22B3C: 'dùn',  # 𢬼
    # 0x22B3D: '',  # 𢬽
    0x22B3E: 'xī',  # 𢬾
    0x22B3F: 'xiè',  # 𢬿
    # 0x22B40: '',  # 𢭀
    0x22B41: 'xì',  # 𢭁
    0x22B42: 'láo',  # 𢭂
    0x22B43: 'duǎn,dòu',  # 𢭃
    0x22B44: 'jì',  # 𢭄
    0x22B45: 'chā',  # 𢭅
    0x22B46: 'chōu',  # 𢭆
    # 0x22B47: '',  # 𢭇
    0x22B48: 'gāng',  # 𢭈
    # 0x22B49: '',  # 𢭉
    # 0x22B4A: '',  # 𢭊
    # 0x22B4B: '',  # 𢭋
    # 0x22B4C: '',  # 𢭌
    # 0x22B4D: '',  # 𢭍
    0x22B4E: 'xiáng',  # 𢭎
    0x22B4F: 'dǎo',  # 𢭏
    # 0x22B50: '',  # 𢭐
    # 0x22B51: '',  # 𢭑
    # 0x22B52: '',  # 𢭒
    # 0x22B53: '',  # 𢭓
    # 0x22B54: '',  # 𢭔
    # 0x22B55: '',  # 𢭕
    # 0x22B56: '',  # 𢭖
    # 0x22B57: '',  # 𢭗
    # 0x22B58: '',  # 𢭘
    # 0x22B59: '',  # 𢭙
    # 0x22B5A: '',  # 𢭚
    # 0x22B5B: '',  # 𢭛
    # 0x22B5C: '',  # 𢭜
    # 0x22B5D: '',  # 𢭝
    # 0x22B5E: '',  # 𢭞
    # 0x22B5F: '',  # 𢭟
    # 0x22B60: '',  # 𢭠
    # 0x22B61: '',  # 𢭡
    # 0x22B62: '',  # 𢭢
    # 0x22B63: '',  # 𢭣
    # 0x22B64: '',  # 𢭤
    0x22B65: 'biàn',  # 𢭥
    0x22B66: 'xiāo',  # 𢭦
    0x22B67: 'xīn',  # 𢭧
    # 0x22B68: '',  # 𢭨
    # 0x22B69: '',  # 𢭩
    # 0x22B6A: '',  # 𢭪
    # 0x22B6B: '',  # 𢭫
    # 0x22B6C: '',  # 𢭬
    # 0x22B6D: '',  # 𢭭
    # 0x22B6E: '',  # 𢭮
    # 0x22B6F: '',  # 𢭯
    # 0x22B70: '',  # 𢭰
    # 0x22B71: '',  # 𢭱
    # 0x22B72: '',  # 𢭲
    # 0x22B73: '',  # 𢭳
    # 0x22B74: '',  # 𢭴
    # 0x22B75: '',  # 𢭵
    # 0x22B76: '',  # 𢭶
    # 0x22B77: '',  # 𢭷
    # 0x22B78: '',  # 𢭸
    # 0x22B79: '',  # 𢭹
    # 0x22B7A: '',  # 𢭺
    # 0x22B7B: '',  # 𢭻
    # 0x22B7C: '',  # 𢭼
    # 0x22B7D: '',  # 𢭽
    # 0x22B7E: '',  # 𢭾
    # 0x22B7F: '',  # 𢭿
    # 0x22B80: '',  # 𢮀
    0x22B81: 'yǔ',  # 𢮁
    0x22B82: 'xián',  # 𢮂
    0x22B83: 'lí',  # 𢮃
    0x22B84: 'qiǎn',  # 𢮄
    # 0x22B85: '',  # 𢮅
    # 0x22B86: '',  # 𢮆
    0x22B87: 'měi',  # 𢮇
    # 0x22B88: '',  # 𢮈
    0x22B89: 'qiāo',  # 𢮉
    0x22B8A: 'yà',  # 𢮊
    # 0x22B8B: '',  # 𢮋
    0x22B8C: 'qiā,jié',  # 𢮌
    0x22B8D: 'qiòng',  # 𢮍
    # 0x22B8E: '',  # 𢮎
    0x22B8F: 'bàng',  # 𢮏
    0x22B90: 'zhēng',  # 𢮐
    # 0x22B91: '',  # 𢮑
    # 0x22B92: '',  # 𢮒
    # 0x22B93: '',  # 𢮓
    # 0x22B94: '',  # 𢮔
    # 0x22B95: '',  # 𢮕
    # 0x22B96: '',  # 𢮖
    # 0x22B97: '',  # 𢮗
    # 0x22B98: '',  # 𢮘
    # 0x22B99: '',  # 𢮙
    0x22B9A: 'zè',  # 𢮚
    0x22B9B: 'shuàn,tuán',  # 𢮛
    # 0x22B9C: '',  # 𢮜
    # 0x22B9D: '',  # 𢮝
    0x22B9E: 'sào',  # 𢮞
    # 0x22B9F: '',  # 𢮟
    # 0x22BA0: '',  # 𢮠
    # 0x22BA1: '',  # 𢮡
    # 0x22BA2: '',  # 𢮢
    # 0x22BA3: '',  # 𢮣
    # 0x22BA4: '',  # 𢮤
    # 0x22BA5: '',  # 𢮥
    # 0x22BA6: '',  # 𢮦
    # 0x22BA7: '',  # 𢮧
    # 0x22BA8: '',  # 𢮨
    # 0x22BA9: '',  # 𢮩
    # 0x22BAA: '',  # 𢮪
    # 0x22BAB: '',  # 𢮫
    # 0x22BAC: '',  # 𢮬
    # 0x22BAD: '',  # 𢮭
    # 0x22BAE: '',  # 𢮮
    # 0x22BAF: '',  # 𢮯
    # 0x22BB0: '',  # 𢮰
    # 0x22BB1: '',  # 𢮱
    # 0x22BB2: '',  # 𢮲
    # 0x22BB3: '',  # 𢮳
    # 0x22BB4: '',  # 𢮴
    # 0x22BB5: '',  # 𢮵
    # 0x22BB6: '',  # 𢮶
    # 0x22BB7: '',  # 𢮷
    # 0x22BB8: '',  # 𢮸
    # 0x22BB9: '',  # 𢮹
    # 0x22BBA: '',  # 𢮺
    # 0x22BBB: '',  # 𢮻
    # 0x22BBC: '',  # 𢮼
    # 0x22BBD: '',  # 𢮽
    # 0x22BBE: '',  # 𢮾
    # 0x22BBF: '',  # 𢮿
    # 0x22BC0: '',  # 𢯀
    # 0x22BC1: '',  # 𢯁
    # 0x22BC2: '',  # 𢯂
    # 0x22BC3: '',  # 𢯃
    # 0x22BC4: '',  # 𢯄
    0x22BC5: 'lù,jué',  # 𢯅
    # 0x22BC6: '',  # 𢯆
    # 0x22BC7: '',  # 𢯇
    # 0x22BC8: '',  # 𢯈
    0x22BC9: 'xié',  # 𢯉
    # 0x22BCA: '',  # 𢯊
    0x22BCB: 'fǔ',  # 𢯋
    0x22BCC: 'zhài',  # 𢯌
    # 0x22BCD: '',  # 𢯍
    # 0x22BCE: '',  # 𢯎
    # 0x22BCF: '',  # 𢯏
    # 0x22BD0: '',  # 𢯐
    # 0x22BD1: '',  # 𢯑
    # 0x22BD2: '',  # 𢯒
    # 0x22BD3: '',  # 𢯓
    # 0x22BD4: '',  # 𢯔
    # 0x22BD5: '',  # 𢯕
    # 0x22BD6: '',  # 𢯖
    # 0x22BD7: '',  # 𢯗
    # 0x22BD8: '',  # 𢯘
    # 0x22BD9: '',  # 𢯙
    # 0x22BDA: '',  # 𢯚
    # 0x22BDB: '',  # 𢯛
    # 0x22BDC: '',  # 𢯜
    # 0x22BDD: '',  # 𢯝
    # 0x22BDE: '',  # 𢯞
    # 0x22BDF: '',  # 𢯟
    # 0x22BE0: '',  # 𢯠
    # 0x22BE1: '',  # 𢯡
    # 0x22BE2: '',  # 𢯢
    # 0x22BE3: '',  # 𢯣
    # 0x22BE4: '',  # 𢯤
    # 0x22BE5: '',  # 𢯥
    0x22BE6: 'lái',  # 𢯦
    # 0x22BE7: '',  # 𢯧
    # 0x22BE8: '',  # 𢯨
    0x22BE9: 'zè',  # 𢯩
    # 0x22BEA: '',  # 𢯪
    0x22BEB: 'duàn,wǎn',  # 𢯫
    # 0x22BEC: '',  # 𢯬
    0x22BED: 'dèng',  # 𢯭
    0x22BEE: 'yù',  # 𢯮
    # 0x22BEF: '',  # 𢯯
    0x22BF0: 'lǜ',  # 𢯰
    0x22BF1: 'sōu',  # 𢯱
    0x22BF2: 'wàn',  # 𢯲
    0x22BF3: 'xué',  # 𢯳
    0x22BF4: 'jiǎo',  # 𢯴
    0x22BF5: 'yuě',  # 𢯵
    0x22BF6: 'zhì',  # 𢯶
    0x22BF7: 'wěi,huī',  # 𢯷
    # 0x22BF8: '',  # 𢯸
    0x22BF9: 'gé',  # 𢯹
    0x22BFA: 'jǔ',  # 𢯺
    # 0x22BFB: '',  # 𢯻
    0x22BFC: 'yǎn',  # 𢯼
    0x22BFD: 'cuò',  # 𢯽
    0x22BFE: 'mào',  # 𢯾
    # 0x22BFF: '',  # 𢯿
    # 0x22C00: '',  # 𢰀
    # 0x22C01: '',  # 𢰁
    # 0x22C02: '',  # 𢰂
    # 0x22C03: '',  # 𢰃
    # 0x22C04: '',  # 𢰄
    # 0x22C05: '',  # 𢰅
    0x22C06: 'fú',  # 𢰆
    0x22C07: 'āi',  # 𢰇
    # 0x22C08: '',  # 𢰈
    # 0x22C09: '',  # 𢰉
    0x22C0A: 'xuān',  # 𢰊
    # 0x22C0B: '',  # 𢰋
    0x22C0C: 'gāng',  # 𢰌
    0x22C0D: 'ān',  # 𢰍
    # 0x22C0E: '',  # 𢰎
    # 0x22C0F: '',  # 𢰏
    # 0x22C10: '',  # 𢰐
    # 0x22C11: '',  # 𢰑
    0x22C12: 'jí',  # 𢰒
    # 0x22C13: '',  # 𢰓
    # 0x22C14: '',  # 𢰔
    # 0x22C15: '',  # 𢰕
    # 0x22C16: '',  # 𢰖
    # 0x22C17: '',  # 𢰗
    0x22C18: 'pí',  # 𢰘
    0x22C19: 'zhǐ',  # 𢰙
    # 0x22C1A: '',  # 𢰚
    # 0x22C1B: '',  # 𢰛
    0x22C1C: 'nuó',  # 𢰜
    # 0x22C1D: '',  # 𢰝
    # 0x22C1E: '',  # 𢰞
    # 0x22C1F: '',  # 𢰟
    # 0x22C20: '',  # 𢰠
    # 0x22C21: '',  # 𢰡
    # 0x22C22: '',  # 𢰢
    # 0x22C23: '',  # 𢰣
    # 0x22C24: '',  # 𢰤
    # 0x22C25: '',  # 𢰥
    # 0x22C26: '',  # 𢰦
    # 0x22C27: '',  # 𢰧
    # 0x22C28: '',  # 𢰨
    # 0x22C29: '',  # 𢰩
    # 0x22C2A: '',  # 𢰪
    # 0x22C2B: '',  # 𢰫
    # 0x22C2C: '',  # 𢰬
    # 0x22C2D: '',  # 𢰭
    # 0x22C2E: '',  # 𢰮
    # 0x22C2F: '',  # 𢰯
    # 0x22C30: '',  # 𢰰
    # 0x22C31: '',  # 𢰱
    # 0x22C32: '',  # 𢰲
    # 0x22C33: '',  # 𢰳
    # 0x22C34: '',  # 𢰴
    # 0x22C35: '',  # 𢰵
    # 0x22C36: '',  # 𢰶
    # 0x22C37: '',  # 𢰷
    # 0x22C38: '',  # 𢰸
    # 0x22C39: '',  # 𢰹
    # 0x22C3A: '',  # 𢰺
    # 0x22C3B: '',  # 𢰻
    # 0x22C3C: '',  # 𢰼
    # 0x22C3D: '',  # 𢰽
    # 0x22C3E: '',  # 𢰾
    0x22C3F: 'pàn',  # 𢰿
    # 0x22C40: '',  # 𢱀
    0x22C41: 'yí',  # 𢱁
    # 0x22C42: '',  # 𢱂
    # 0x22C43: '',  # 𢱃
    0x22C44: 'jié',  # 𢱄
    # 0x22C45: '',  # 𢱅
    0x22C46: 'zī',  # 𢱆
    # 0x22C47: '',  # 𢱇
    0x22C48: 'jià',  # 𢱈
    0x22C49: 'wǎi',  # 𢱉
    0x22C4A: 'lüè',  # 𢱊
    # 0x22C4B: '',  # 𢱋
    0x22C4C: 'jià',  # 𢱌
    # 0x22C4D: '',  # 𢱍
    # 0x22C4E: '',  # 𢱎
    # 0x22C4F: '',  # 𢱏
    # 0x22C50: '',  # 𢱐
    # 0x22C51: '',  # 𢱑
    # 0x22C52: '',  # 𢱒
    # 0x22C53: '',  # 𢱓
    # 0x22C54: '',  # 𢱔
    # 0x22C55: '',  # 𢱕
    # 0x22C56: '',  # 𢱖
    # 0x22C57: '',  # 𢱗
    # 0x22C58: '',  # 𢱘
    # 0x22C59: '',  # 𢱙
    # 0x22C5A: '',  # 𢱚
    # 0x22C5B: '',  # 𢱛
    # 0x22C5C: '',  # 𢱜
    # 0x22C5D: '',  # 𢱝
    # 0x22C5E: '',  # 𢱞
    0x22C5F: 'chǎn,chī',  # 𢱟
    # 0x22C60: '',  # 𢱠
    0x22C61: 'suǒ',  # 𢱡
    0x22C62: 'suǒ,sè',  # 𢱢
    0x22C63: 'jí',  # 𢱣
    0x22C64: 'sǒng',  # 𢱤
    # 0x22C65: '',  # 𢱥
    0x22C66: 'tī',  # 𢱦
    0x22C67: 'pī',  # 𢱧
    0x22C68: 'pó',  # 𢱨
    # 0x22C69: '',  # 𢱩
    # 0x22C6A: '',  # 𢱪
    # 0x22C6B: '',  # 𢱫
    # 0x22C6C: '',  # 𢱬
    # 0x22C6D: '',  # 𢱭
    0x22C6E: 'mì',  # 𢱮
    # 0x22C6F: '',  # 𢱯
    # 0x22C70: '',  # 𢱰
    # 0x22C71: '',  # 𢱱
    # 0x22C72: '',  # 𢱲
    # 0x22C73: '',  # 𢱳
    0x22C74: 'yè',  # 𢱴
    # 0x22C75: '',  # 𢱵
    0x22C76: 'qìn',  # 𢱶
    0x22C77: 'jìn',  # 𢱷
    # 0x22C78: '',  # 𢱸
    # 0x22C79: '',  # 𢱹
    0x22C7A: 'juē',  # 𢱺
    # 0x22C7B: '',  # 𢱻
    # 0x22C7C: '',  # 𢱼
    0x22C7D: 'yuān',  # 𢱽
    0x22C7E: 'ruán',  # 𢱾
    # 0x22C7F: '',  # 𢱿
    # 0x22C80: '',  # 𢲀
    # 0x22C81: '',  # 𢲁
    # 0x22C82: '',  # 𢲂
    # 0x22C83: '',  # 𢲃
    # 0x22C84: '',  # 𢲄
    # 0x22C85: '',  # 𢲅
    # 0x22C86: '',  # 𢲆
    # 0x22C87: '',  # 𢲇
    # 0x22C88: '',  # 𢲈
    # 0x22C89: '',  # 𢲉
    # 0x22C8A: '',  # 𢲊
    # 0x22C8B: '',  # 𢲋
    # 0x22C8C: '',  # 𢲌
    # 0x22C8D: '',  # 𢲍
    # 0x22C8E: '',  # 𢲎
    # 0x22C8F: '',  # 𢲏
    # 0x22C90: '',  # 𢲐
    # 0x22C91: '',  # 𢲑
    # 0x22C92: '',  # 𢲒
    # 0x22C93: '',  # 𢲓
    0x22C94: 'bàn,bān,pān',  # 𢲔
    # 0x22C95: '',  # 𢲕
    # 0x22C96: '',  # 𢲖
    # 0x22C97: '',  # 𢲗
    # 0x22C98: '',  # 𢲘
    # 0x22C99: '',  # 𢲙
    # 0x22C9A: '',  # 𢲚
    # 0x22C9B: '',  # 𢲛
    # 0x22C9C: '',  # 𢲜
    # 0x22C9D: '',  # 𢲝
    # 0x22C9E: '',  # 𢲞
    # 0x22C9F: '',  # 𢲟
    # 0x22CA0: '',  # 𢲠
    # 0x22CA1: '',  # 𢲡
    # 0x22CA2: '',  # 𢲢
    # 0x22CA3: '',  # 𢲣
    # 0x22CA4: '',  # 𢲤
    # 0x22CA5: '',  # 𢲥
    # 0x22CA6: '',  # 𢲦
    # 0x22CA7: '',  # 𢲧
    # 0x22CA8: '',  # 𢲨
    # 0x22CA9: '',  # 𢲩
    # 0x22CAA: '',  # 𢲪
    0x22CAB: 'mā',  # 𢲫
    # 0x22CAC: '',  # 𢲬
    # 0x22CAD: '',  # 𢲭
    # 0x22CAE: '',  # 𢲮
    # 0x22CAF: '',  # 𢲯
    0x22CB0: 'bīn',  # 𢲰
    # 0x22CB1: '',  # 𢲱
    # 0x22CB2: '',  # 𢲲
    # 0x22CB3: '',  # 𢲳
    0x22CB4: 'wèi',  # 𢲴
    0x22CB5: 'zào',  # 𢲵
    0x22CB6: 'qiè',  # 𢲶
    0x22CB7: 'ǎo',  # 𢲷
    0x22CB8: 'lǔ',  # 𢲸
    # 0x22CB9: '',  # 𢲹
    # 0x22CBA: '',  # 𢲺
    # 0x22CBB: '',  # 𢲻
    0x22CBC: 'dié',  # 𢲼
    0x22CBD: 'chuāi',  # 𢲽
    0x22CBE: 'bì',  # 𢲾
    0x22CBF: 'zhú',  # 𢲿
    0x22CC0: 'mó,mā',  # 𢳀
    0x22CC1: 'fèi',  # 𢳁
    0x22CC2: 'piē',  # 𢳂
    0x22CC3: 'yìn',  # 𢳃
    0x22CC4: 'xuàn,xuán',  # 𢳄
    # 0x22CC5: '',  # 𢳅
    0x22CC6: 'ào,áo',  # 𢳆
    0x22CC7: 'zhuó,zú',  # 𢳇
    0x22CC8: 'zú',  # 𢳈
    # 0x22CC9: '',  # 𢳉
    # 0x22CCA: '',  # 𢳊
    0x22CCB: 'bǐ',  # 𢳋
    # 0x22CCC: '',  # 𢳌
    # 0x22CCD: '',  # 𢳍
    0x22CCE: 'bài',  # 𢳎
    # 0x22CCF: '',  # 𢳏
    # 0x22CD0: '',  # 𢳐
    0x22CD1: 'làng',  # 𢳑
    # 0x22CD2: '',  # 𢳒
    0x22CD3: 'tì',  # 𢳓
    # 0x22CD4: '',  # 𢳔
    # 0x22CD5: '',  # 𢳕
    # 0x22CD6: '',  # 𢳖
    # 0x22CD7: '',  # 𢳗
    # 0x22CD8: '',  # 𢳘
    0x22CD9: 'tiǎo',  # 𢳙
    0x22CDA: 'jiān',  # 𢳚
    0x22CDB: 'zhā',  # 𢳛
    # 0x22CDC: '',  # 𢳜
    # 0x22CDD: '',  # 𢳝
    # 0x22CDE: '',  # 𢳞
    0x22CDF: 'tǒng',  # 𢳟
    # 0x22CE0: '',  # 𢳠
    # 0x22CE1: '',  # 𢳡
    # 0x22CE2: '',  # 𢳢
    # 0x22CE3: '',  # 𢳣
    # 0x22CE4: '',  # 𢳤
    0x22CE5: 'cāo',  # 𢳥
    # 0x22CE6: '',  # 𢳦
    # 0x22CE7: '',  # 𢳧
    # 0x22CE8: '',  # 𢳨
    # 0x22CE9: '',  # 𢳩
    # 0x22CEA: '',  # 𢳪
    # 0x22CEB: '',  # 𢳫
    # 0x22CEC: '',  # 𢳬
    # 0x22CED: '',  # 𢳭
    # 0x22CEE: '',  # 𢳮
    # 0x22CEF: '',  # 𢳯
    # 0x22CF0: '',  # 𢳰
    # 0x22CF1: '',  # 𢳱
    # 0x22CF2: '',  # 𢳲
    # 0x22CF3: '',  # 𢳳
    # 0x22CF4: '',  # 𢳴
    # 0x22CF5: '',  # 𢳵
    # 0x22CF6: '',  # 𢳶
    # 0x22CF7: '',  # 𢳷
    # 0x22CF8: '',  # 𢳸
    # 0x22CF9: '',  # 𢳹
    # 0x22CFA: '',  # 𢳺
    # 0x22CFB: '',  # 𢳻
    # 0x22CFC: '',  # 𢳼
    0x22CFD: 'duō',  # 𢳽
    0x22CFE: 'dòng',  # 𢳾
    # 0x22CFF: '',  # 𢳿
    # 0x22D00: '',  # 𢴀
    # 0x22D01: '',  # 𢴁
    0x22D02: 'biǎn',  # 𢴂
    # 0x22D03: '',  # 𢴃
    # 0x22D04: '',  # 𢴄
    # 0x22D05: '',  # 𢴅
    # 0x22D06: '',  # 𢴆
    # 0x22D07: '',  # 𢴇
    0x22D08: 'dá',  # 𢴈
    # 0x22D09: '',  # 𢴉
    # 0x22D0A: '',  # 𢴊
    # 0x22D0B: '',  # 𢴋
    # 0x22D0C: '',  # 𢴌
    # 0x22D0D: '',  # 𢴍
    # 0x22D0E: '',  # 𢴎
    # 0x22D0F: '',  # 𢴏
    # 0x22D10: '',  # 𢴐
    # 0x22D11: '',  # 𢴑
    0x22D12: 'pēng',  # 𢴒
    # 0x22D13: '',  # 𢴓
    # 0x22D14: '',  # 𢴔
    # 0x22D15: '',  # 𢴕
    # 0x22D16: '',  # 𢴖
    # 0x22D17: '',  # 𢴗
    # 0x22D18: '',  # 𢴘
    # 0x22D19: '',  # 𢴙
    0x22D1A: 'nì',  # 𢴚
    # 0x22D1B: '',  # 𢴛
    # 0x22D1C: '',  # 𢴜
    # 0x22D1D: '',  # 𢴝
    # 0x22D1E: '',  # 𢴞
    # 0x22D1F: '',  # 𢴟
    0x22D20: 'zhì',  # 𢴠
    # 0x22D21: '',  # 𢴡
    0x22D22: 'fén',  # 𢴢
    # 0x22D23: '',  # 𢴣
    # 0x22D24: '',  # 𢴤
    # 0x22D25: '',  # 𢴥
    0x22D26: 'káng',  # 𢴦
    0x22D27: 'zhì',  # 𢴧
    0x22D28: 'zhāi,zhì,chì',  # 𢴨
    0x22D29: 'bì',  # 𢴩
    0x22D2A: 'kuǎn',  # 𢴪
    # 0x22D2B: '',  # 𢴫
    0x22D2C: 'bàn',  # 𢴬
    0x22D2D: 'juē',  # 𢴭
    0x22D2E: 'qū',  # 𢴮
    # 0x22D2F: '',  # 𢴯
    0x22D30: 'qī',  # 𢴰
    0x22D31: 'léi',  # 𢴱
    0x22D32: 'xié,jié',  # 𢴲
    0x22D33: 'tāng',  # 𢴳
    # 0x22D34: '',  # 𢴴
    # 0x22D35: '',  # 𢴵
    # 0x22D36: '',  # 𢴶
    # 0x22D37: '',  # 𢴷
    # 0x22D38: '',  # 𢴸
    # 0x22D39: '',  # 𢴹
    # 0x22D3A: '',  # 𢴺
    # 0x22D3B: '',  # 𢴻
    0x22D3C: 'sōu',  # 𢴼
    # 0x22D3D: '',  # 𢴽
    0x22D3E: 'bèi',  # 𢴾
    # 0x22D3F: '',  # 𢴿
    # 0x22D40: '',  # 𢵀
    # 0x22D41: '',  # 𢵁
    # 0x22D42: '',  # 𢵂
    # 0x22D43: '',  # 𢵃
    # 0x22D44: '',  # 𢵄
    # 0x22D45: '',  # 𢵅
    # 0x22D46: '',  # 𢵆
    0x22D47: 'yàng',  # 𢵇
    0x22D48: 'jiǎn,zhǎn',  # 𢵈
    # 0x22D49: '',  # 𢵉
    # 0x22D4A: '',  # 𢵊
    # 0x22D4B: '',  # 𢵋
    # 0x22D4C: '',  # 𢵌
    # 0x22D4D: '',  # 𢵍
    # 0x22D4E: '',  # 𢵎
    # 0x22D4F: '',  # 𢵏
    # 0x22D50: '',  # 𢵐
    # 0x22D51: '',  # 𢵑
    # 0x22D52: '',  # 𢵒
    # 0x22D53: '',  # 𢵓
    # 0x22D54: '',  # 𢵔
    # 0x22D55: '',  # 𢵕
    # 0x22D56: '',  # 𢵖
    # 0x22D57: '',  # 𢵗
    # 0x22D58: '',  # 𢵘
    # 0x22D59: '',  # 𢵙
    # 0x22D5A: '',  # 𢵚
    # 0x22D5B: '',  # 𢵛
    # 0x22D5C: '',  # 𢵜
    # 0x22D5D: '',  # 𢵝
    # 0x22D5E: '',  # 𢵞
    # 0x22D5F: '',  # 𢵟
    # 0x22D60: '',  # 𢵠
    # 0x22D61: '',  # 𢵡
    # 0x22D62: '',  # 𢵢
    0x22D63: 'yā',  # 𢵣
    # 0x22D64: '',  # 𢵤
    0x22D65: 'zào',  # 𢵥
    # 0x22D66: '',  # 𢵦
    # 0x22D67: '',  # 𢵧
    # 0x22D68: '',  # 𢵨
    # 0x22D69: '',  # 𢵩
    # 0x22D6A: '',  # 𢵪
    # 0x22D6B: '',  # 𢵫
    # 0x22D6C: '',  # 𢵬
    # 0x22D6D: '',  # 𢵭
    0x22D6E: 'lū',  # 𢵮
    # 0x22D6F: '',  # 𢵯
    # 0x22D70: '',  # 𢵰
    # 0x22D71: '',  # 𢵱
    # 0x22D72: '',  # 𢵲
    # 0x22D73: '',  # 𢵳
    # 0x22D74: '',  # 𢵴
    # 0x22D75: '',  # 𢵵
    # 0x22D76: '',  # 𢵶
    # 0x22D77: '',  # 𢵷
    # 0x22D78: '',  # 𢵸
    # 0x22D79: '',  # 𢵹
    # 0x22D7A: '',  # 𢵺
    # 0x22D7B: '',  # 𢵻
    # 0x22D7C: '',  # 𢵼
    # 0x22D7D: '',  # 𢵽
    # 0x22D7E: '',  # 𢵾
    # 0x22D7F: '',  # 𢵿
    0x22D80: 'chuái,zhuài',  # 𢶀
    # 0x22D81: '',  # 𢶁
    # 0x22D82: '',  # 𢶂
    0x22D83: 'fán',  # 𢶃
    # 0x22D84: '',  # 𢶄
    0x22D85: 'shé',  # 𢶅
    # 0x22D86: '',  # 𢶆
    0x22D87: 'qióng',  # 𢶇
    # 0x22D88: '',  # 𢶈
    0x22D89: 'pò',  # 𢶉
    # 0x22D8A: '',  # 𢶊
    0x22D8B: 'tiě',  # 𢶋
    0x22D8C: 'shā',  # 𢶌
    0x22D8D: 'zá,sà',  # 𢶍
    # 0x22D8E: '',  # 𢶎
    # 0x22D8F: '',  # 𢶏
    # 0x22D90: '',  # 𢶐
    0x22D91: 'niǎo',  # 𢶑
    0x22D92: 'guài',  # 𢶒
    0x22D93: 'cuǐ',  # 𢶓
    # 0x22D94: '',  # 𢶔
    # 0x22D95: '',  # 𢶕
    # 0x22D96: '',  # 𢶖
    # 0x22D97: '',  # 𢶗
    # 0x22D98: '',  # 𢶘
    # 0x22D99: '',  # 𢶙
    # 0x22D9A: '',  # 𢶚
    # 0x22D9B: '',  # 𢶛
    # 0x22D9C: '',  # 𢶜
    # 0x22D9D: '',  # 𢶝
    # 0x22D9E: '',  # 𢶞
    # 0x22D9F: '',  # 𢶟
    # 0x22DA0: '',  # 𢶠
    0x22DA1: 'qiào,jiǎo',  # 𢶡
    # 0x22DA2: '',  # 𢶢
    0x22DA3: 'dié',  # 𢶣
    # 0x22DA4: '',  # 𢶤
    # 0x22DA5: '',  # 𢶥
    # 0x22DA6: '',  # 𢶦
    # 0x22DA7: '',  # 𢶧
    # 0x22DA8: '',  # 𢶨
    # 0x22DA9: '',  # 𢶩
    # 0x22DAA: '',  # 𢶪
    # 0x22DAB: '',  # 𢶫
    # 0x22DAC: '',  # 𢶬
    # 0x22DAD: '',  # 𢶭
    # 0x22DAE: '',  # 𢶮
    # 0x22DAF: '',  # 𢶯
    # 0x22DB0: '',  # 𢶰
    # 0x22DB1: '',  # 𢶱
    # 0x22DB2: '',  # 𢶲
    0x22DB3: 'pīn',  # 𢶳
    0x22DB4: 'cí',  # 𢶴
    # 0x22DB5: '',  # 𢶵
    0x22DB6: 'bàng',  # 𢶶
    # 0x22DB7: '',  # 𢶷
    # 0x22DB8: '',  # 𢶸
    # 0x22DB9: '',  # 𢶹
    # 0x22DBA: '',  # 𢶺
    # 0x22DBB: '',  # 𢶻
    # 0x22DBC: '',  # 𢶼
    # 0x22DBD: '',  # 𢶽
    # 0x22DBE: '',  # 𢶾
    # 0x22DBF: '',  # 𢶿
    # 0x22DC0: '',  # 𢷀
    # 0x22DC1: '',  # 𢷁
    # 0x22DC2: '',  # 𢷂
    0x22DC3: 'nào',  # 𢷃
    # 0x22DC4: '',  # 𢷄
    0x22DC5: 'lù',  # 𢷅
    # 0x22DC6: '',  # 𢷆
    # 0x22DC7: '',  # 𢷇
    # 0x22DC8: '',  # 𢷈
    # 0x22DC9: '',  # 𢷉
    # 0x22DCA: '',  # 𢷊
    # 0x22DCB: '',  # 𢷋
    # 0x22DCC: '',  # 𢷌
    0x22DCD: 'yìn',  # 𢷍
    # 0x22DCE: '',  # 𢷎
    # 0x22DCF: '',  # 𢷏
    # 0x22DD0: '',  # 𢷐
    0x22DD1: 'xiǎn',  # 𢷑
    # 0x22DD2: '',  # 𢷒
    # 0x22DD3: '',  # 𢷓
    0x22DD4: 'yǐ',  # 𢷔
    0x22DD5: 'miǎo',  # 𢷕
    0x22DD6: 'duǎn',  # 𢷖
    0x22DD7: 'zhòu',  # 𢷗
    # 0x22DD8: '',  # 𢷘
    0x22DD9: 'kōng',  # 𢷙
    # 0x22DDA: '',  # 𢷚
    # 0x22DDB: '',  # 𢷛
    # 0x22DDC: '',  # 𢷜
    # 0x22DDD: '',  # 𢷝
    # 0x22DDE: '',  # 𢷞
    # 0x22DDF: '',  # 𢷟
    # 0x22DE0: '',  # 𢷠
    # 0x22DE1: '',  # 𢷡
    0x22DE2: 'zhāng',  # 𢷢
    # 0x22DE3: '',  # 𢷣
    # 0x22DE4: '',  # 𢷤
    # 0x22DE5: '',  # 𢷥
    # 0x22DE6: '',  # 𢷦
    # 0x22DE7: '',  # 𢷧
    # 0x22DE8: '',  # 𢷨
    # 0x22DE9: '',  # 𢷩
    # 0x22DEA: '',  # 𢷪
    # 0x22DEB: '',  # 𢷫
    # 0x22DEC: '',  # 𢷬
    # 0x22DED: '',  # 𢷭
    # 0x22DEE: '',  # 𢷮
    # 0x22DEF: '',  # 𢷯
    # 0x22DF0: '',  # 𢷰
    # 0x22DF1: '',  # 𢷱
    # 0x22DF2: '',  # 𢷲
    # 0x22DF3: '',  # 𢷳
    # 0x22DF4: '',  # 𢷴
    # 0x22DF5: '',  # 𢷵
    0x22DF6: 'liú',  # 𢷶
    # 0x22DF7: '',  # 𢷷
    0x22DF8: 'zhǐ',  # 𢷸
    0x22DF9: 'chǎn',  # 𢷹
    0x22DFA: 'dú',  # 𢷺
    0x22DFB: 'yuán',  # 𢷻
    # 0x22DFC: '',  # 𢷼
    # 0x22DFD: '',  # 𢷽
    0x22DFE: 'suò,cè',  # 𢷾
    0x22DFF: 'jié',  # 𢷿
    0x22E00: 'lì',  # 𢸀
    0x22E01: 'gǒng',  # 𢸁
    # 0x22E02: '',  # 𢸂
    # 0x22E03: '',  # 𢸃
    # 0x22E04: '',  # 𢸄
    # 0x22E05: '',  # 𢸅
    # 0x22E06: '',  # 𢸆
    # 0x22E07: '',  # 𢸇
    # 0x22E08: '',  # 𢸈
    # 0x22E09: '',  # 𢸉
    # 0x22E0A: '',  # 𢸊
    # 0x22E0B: '',  # 𢸋
    0x22E0C: 'bāng',  # 𢸌
    # 0x22E0D: '',  # 𢸍
    # 0x22E0E: '',  # 𢸎
    # 0x22E0F: '',  # 𢸏
    # 0x22E10: '',  # 𢸐
    # 0x22E11: '',  # 𢸑
    # 0x22E12: '',  # 𢸒
    # 0x22E13: '',  # 𢸓
    # 0x22E14: '',  # 𢸔
    # 0x22E15: '',  # 𢸕
    # 0x22E16: '',  # 𢸖
    0x22E17: 'guó',  # 𢸗
    0x22E18: 'liáo',  # 𢸘
    0x22E19: 'shěn',  # 𢸙
    # 0x22E1A: '',  # 𢸚
    # 0x22E1B: '',  # 𢸛
    # 0x22E1C: '',  # 𢸜
    # 0x22E1D: '',  # 𢸝
    # 0x22E1E: '',  # 𢸞
    # 0x22E1F: '',  # 𢸟
    # 0x22E20: '',  # 𢸠
    # 0x22E21: '',  # 𢸡
    # 0x22E22: '',  # 𢸢
    0x22E23: 'niǎo',  # 𢸣
    # 0x22E24: '',  # 𢸤
    0x22E25: 'cuàn',  # 𢸥
    0x22E26: 'wěi',  # 𢸦
    # 0x22E27: '',  # 𢸧
    0x22E28: 'tuō',  # 𢸨
    # 0x22E29: '',  # 𢸩
    # 0x22E2A: '',  # 𢸪
    0x22E2B: 'sū',  # 𢸫
    # 0x22E2C: '',  # 𢸬
    0x22E2D: 'lóng',  # 𢸭
    # 0x22E2E: '',  # 𢸮
    # 0x22E2F: '',  # 𢸯
    # 0x22E30: '',  # 𢸰
    # 0x22E31: '',  # 𢸱
    # 0x22E32: '',  # 𢸲
    # 0x22E33: '',  # 𢸳
    0x22E34: 'yǎn,yán',  # 𢸴
    # 0x22E35: '',  # 𢸵
    # 0x22E36: '',  # 𢸶
    # 0x22E37: '',  # 𢸷
    # 0x22E38: '',  # 𢸸
    # 0x22E39: '',  # 𢸹
    # 0x22E3A: '',  # 𢸺
    # 0x22E3B: '',  # 𢸻
    # 0x22E3C: '',  # 𢸼
    # 0x22E3D: '',  # 𢸽
    # 0x22E3E: '',  # 𢸾
    # 0x22E3F: '',  # 𢸿
    # 0x22E40: '',  # 𢹀
    # 0x22E41: '',  # 𢹁
    # 0x22E42: '',  # 𢹂
    0x22E43: 'qǐng',  # 𢹃
    # 0x22E44: '',  # 𢹄
    # 0x22E45: '',  # 𢹅
    # 0x22E46: '',  # 𢹆
    # 0x22E47: '',  # 𢹇
    # 0x22E48: '',  # 𢹈
    # 0x22E49: '',  # 𢹉
    # 0x22E4A: '',  # 𢹊
    # 0x22E4B: '',  # 𢹋
    # 0x22E4C: '',  # 𢹌
    0x22E4D: 'xī',  # 𢹍
    0x22E4E: 'rǎo',  # 𢹎
    0x22E4F: 'yú',  # 𢹏
    # 0x22E50: '',  # 𢹐
    0x22E51: 'zhèng,zhēng',  # 𢹑
    0x22E52: 'xiè',  # 𢹒
    0x22E53: 'chāi',  # 𢹓
    0x22E54: 'fèn',  # 𢹔
    # 0x22E55: '',  # 𢹕
    0x22E56: 'guó',  # 𢹖
    # 0x22E57: '',  # 𢹗
    0x22E58: 'jǐng',  # 𢹘
    0x22E59: 'làn',  # 𢹙
    0x22E5A: 'xiān',  # 𢹚
    # 0x22E5B: '',  # 𢹛
    # 0x22E5C: '',  # 𢹜
    0x22E5D: 'líng',  # 𢹝
    # 0x22E5E: '',  # 𢹞
    # 0x22E5F: '',  # 𢹟
    # 0x22E60: '',  # 𢹠
    # 0x22E61: '',  # 𢹡
    # 0x22E62: '',  # 𢹢
    # 0x22E63: '',  # 𢹣
    # 0x22E64: '',  # 𢹤
    0x22E65: 'yā',  # 𢹥
    # 0x22E66: '',  # 𢹦
    # 0x22E67: '',  # 𢹧
    # 0x22E68: '',  # 𢹨
    # 0x22E69: '',  # 𢹩
    # 0x22E6A: '',  # 𢹪
    # 0x22E6B: '',  # 𢹫
    0x22E6C: 'yǒng',  # 𢹬
    # 0x22E6D: '',  # 𢹭
    0x22E6E: 'lěi',  # 𢹮
    # 0x22E6F: '',  # 𢹯
    # 0x22E70: '',  # 𢹰
    # 0x22E71: '',  # 𢹱
    # 0x22E72: '',  # 𢹲
    0x22E73: 'xiào',  # 𢹳
    # 0x22E74: '',  # 𢹴
    # 0x22E75: '',  # 𢹵
    # 0x22E76: '',  # 𢹶
    # 0x22E77: '',  # 𢹷
    # 0x22E78: '',  # 𢹸
    # 0x22E79: '',  # 𢹹
    # 0x22E7A: '',  # 𢹺
    # 0x22E7B: '',  # 𢹻
    0x22E7C: 'zá',  # 𢹼
    # 0x22E7D: '',  # 𢹽
    # 0x22E7E: '',  # 𢹾
    # 0x22E7F: '',  # 𢹿
    # 0x22E80: '',  # 𢺀
    # 0x22E81: '',  # 𢺁
    # 0x22E82: '',  # 𢺂
    # 0x22E83: '',  # 𢺃
    0x22E84: 'guān',  # 𢺄
    0x22E85: 'qiè',  # 𢺅
    0x22E86: 'luò',  # 𢺆
    0x22E87: 'yào',  # 𢺇
    0x22E88: 'luán',  # 𢺈
    0x22E89: 'tà',  # 𢺉
    # 0x22E8A: '',  # 𢺊
    # 0x22E8B: '',  # 𢺋
    # 0x22E8C: '',  # 𢺌
    # 0x22E8D: '',  # 𢺍
    # 0x22E8E: '',  # 𢺎
    # 0x22E8F: '',  # 𢺏
    # 0x22E90: '',  # 𢺐
    0x22E91: 'luò',  # 𢺑
    # 0x22E92: '',  # 𢺒
    # 0x22E93: '',  # 𢺓
    # 0x22E94: '',  # 𢺔
    # 0x22E95: '',  # 𢺕
    # 0x22E96: '',  # 𢺖
    # 0x22E97: '',  # 𢺗
    # 0x22E98: '',  # 𢺘
    # 0x22E99: '',  # 𢺙
    # 0x22E9A: '',  # 𢺚
    # 0x22E9B: '',  # 𢺛
    # 0x22E9C: '',  # 𢺜
    # 0x22E9D: '',  # 𢺝
    0x22E9E: 'bǎ',  # 𢺞
    0x22E9F: 'chàn',  # 𢺟
    # 0x22EA0: '',  # 𢺠
    0x22EA1: 'zhuó',  # 𢺡
    # 0x22EA2: '',  # 𢺢
    # 0x22EA3: '',  # 𢺣
    # 0x22EA4: '',  # 𢺤
    # 0x22EA5: '',  # 𢺥
    # 0x22EA6: '',  # 𢺦
    # 0x22EA7: '',  # 𢺧
    # 0x22EA8: '',  # 𢺨
    # 0x22EA9: '',  # 𢺩
    # 0x22EAA: '',  # 𢺪
    0x22EAB: 'tiǎo',  # 𢺫
    # 0x22EAC: '',  # 𢺬
    # 0x22EAD: '',  # 𢺭
    # 0x22EAE: '',  # 𢺮
    0x22EAF: 'wān',  # 𢺯
    0x22EB0: 'líng,lìng',  # 𢺰
    # 0x22EB1: '',  # 𢺱
    # 0x22EB2: '',  # 𢺲
    0x22EB3: 'mán',  # 𢺳
    0x22EB4: 'yù',  # 𢺴
    0x22EB5: 'qì,qǐ',  # 𢺵
    # 0x22EB6: '',  # 𢺶
    0x22EB7: 'qí',  # 𢺷
    # 0x22EB8: '',  # 𢺸
    # 0x22EB9: '',  # 𢺹
    # 0x22EBA: '',  # 𢺺
    # 0x22EBB: '',  # 𢺻
    0x22EBC: 'jì',  # 𢺼
    0x22EBD: 'bó,jiào',  # 𢺽
    # 0x22EBE: '',  # 𢺾
    0x22EBF: 'shī',  # 𢺿
    0x22EC0: 'fǔ',  # 𢻀
    # 0x22EC1: '',  # 𢻁
    0x22EC2: 'guī',  # 𢻂
    # 0x22EC3: '',  # 𢻃
    # 0x22EC4: '',  # 𢻄
    0x22EC5: 'diǎn',  # 𢻅
    # 0x22EC6: '',  # 𢻆
    0x22EC7: 'hāo',  # 𢻇
    # 0x22EC8: '',  # 𢻈
    0x22EC9: 'gǎi',  # 𢻉
    # 0x22ECA: '',  # 𢻊
    0x22ECB: 'qí',  # 𢻋
    # 0x22ECC: '',  # 𢻌
    # 0x22ECD: '',  # 𢻍
    # 0x22ECE: '',  # 𢻎
    # 0x22ECF: '',  # 𢻏
    # 0x22ED0: '',  # 𢻐
    # 0x22ED1: '',  # 𢻑
    # 0x22ED2: '',  # 𢻒
    0x22ED3: 'chéng',  # 𢻓
    0x22ED4: 'huì',  # 𢻔
    # 0x22ED5: '',  # 𢻕
    # 0x22ED6: '',  # 𢻖
    0x22ED7: 'xiá,guī',  # 𢻗
    0x22ED8: 'shí',  # 𢻘
    0x22ED9: 'zhì',  # 𢻙
    0x22EDA: 'qí',  # 𢻚
    # 0x22EDB: '',  # 𢻛
    0x22EDC: 'hài',  # 𢻜
    # 0x22EDD: '',  # 𢻝
    # 0x22EDE: '',  # 𢻞
    0x22EDF: 'jiǎo',  # 𢻟
    0x22EE0: 'lì',  # 𢻠
    # 0x22EE1: '',  # 𢻡
    0x22EE2: 'liǎo',  # 𢻢
    # 0x22EE3: '',  # 𢻣
    0x22EE4: 'qiāo,qiáo',  # 𢻤
    # 0x22EE5: '',  # 𢻥
    # 0x22EE6: '',  # 𢻦
    