// This file implements the IInitializeWithStream Interface and Gateway for Python.
// Generated by makegw.py
#include "PythonCOM.h"
#include "PythonCOMServer.h"
#include "propsys.h"
#include "PyIInitializeWithStream.h"

// @doc - This file contains autoduck documentation
// ---------------------------------------------------
//
// Interface Implementation

PyIInitializeWithStream::PyIInitializeWithStream(IUnknown *pdisp):
	PyIUnknown(pdisp)
{
	ob_type = &type;
}

PyIInitializeWithStream::~PyIInitializeWithStream()
{
}

/* static */ IInitializeWithStream *PyIInitializeWithStream::GetI(PyObject *self)
{
	return (IInitializeWithStream *)PyIUnknown::GetI(self);
}

// @pymethod |PyIInitializeWithStream|Initialize|Initializes a property handler with a stream
PyObject *PyIInitializeWithStream::Initialize(PyObject *self, PyObject *args)
{
	IInitializeWithStream *pIIWS = GetI(self);
	if ( pIIWS == NULL )
		return NULL;
	// @pyparm <o PyIStream>|Stream||Stream containing the contents from which to extract properties
	// @pyparm int|Mode||Indicates if stream is writable, STGM_READ or STGM_READWRITE 
	PyObject *obstream;
	IStream *pstream;
	DWORD grfMode;
	if (!PyArg_ParseTuple(args, "Ok:Initialize", &obstream, &grfMode))
		return NULL;
	if (!PyCom_InterfaceFromPyInstanceOrObject(obstream, IID_IStream, (void **)&pstream, FALSE))
		return NULL;
	HRESULT hr;
	PY_INTERFACE_PRECALL;
	hr = pIIWS->Initialize(pstream, grfMode );
	pstream->Release();
	PY_INTERFACE_POSTCALL;

	if ( FAILED(hr) )
		return PyCom_BuildPyException(hr, pIIWS, IID_IInitializeWithStream );
	Py_INCREF(Py_None);
	return Py_None;
}

// @object PyIInitializeWithStream|Interface that initializes a handler capable of reading properties from a stream
static struct PyMethodDef PyIInitializeWithStream_methods[] =
{
	{ "Initialize", PyIInitializeWithStream::Initialize, 1 }, // @pymeth Initialize|Initializes a property handler with a stream
	{ NULL }
};

PyComTypeObject PyIInitializeWithStream::type("PyIInitializeWithStream",
		&PyIUnknown::type,
		sizeof(PyIInitializeWithStream),
		PyIInitializeWithStream_methods,
		GET_PYCOM_CTOR(PyIInitializeWithStream));
// ---------------------------------------------------
//
// Gateway Implementation
STDMETHODIMP PyGInitializeWithStream::Initialize(
	IStream *pstream,
	DWORD grfMode)
{
	PY_GATEWAY_METHOD;
	PyObject *obstream = PyCom_PyObjectFromIUnknown(pstream, IID_IStream);
	if (obstream == NULL)
		return MAKE_PYCOM_GATEWAY_FAILURE_CODE("Initialize");
	HRESULT hr=InvokeViaPolicy("Initialize", NULL, "Ok", obstream, grfMode);
	Py_DECREF(obstream);
	return hr;
}

