// This file implements the IEnumResources Interface and Gateway for Python.
// Generated by makegw.py

#include "shell_pch.h"
#include "PyIEnumResources.h"

// @doc - This file contains autoduck documentation

// ---------------------------------------------------
//
// Interface Implementation

PyIEnumResources::PyIEnumResources(IUnknown *pdisp):
	PyIUnknown(pdisp)
{
	ob_type = &type;
}

PyIEnumResources::~PyIEnumResources()
{
}

/* static */ IEnumResources *PyIEnumResources::GetI(PyObject *self)
{
	return (IEnumResources *)PyIUnknown::GetI(self);
}

// @pymethod object|PyIEnumResources|Next|Retrieves a specified number of items in the enumeration sequence.
PyObject *PyIEnumResources::Next(PyObject *self, PyObject *args)
{
	long celt = 1;
	// @pyparm int|num|1|Number of items to retrieve.
	if ( !PyArg_ParseTuple(args, "|l:Next", &celt) )
		return NULL;

	IEnumResources *pIEResources = GetI(self);
	if ( pIEResources == NULL )
		return NULL;

	SHELL_ITEM_RESOURCE *rgVar = new SHELL_ITEM_RESOURCE[celt];
	if ( rgVar == NULL ) {
		PyErr_SetString(PyExc_MemoryError, "allocating result Resourcess");
		return NULL;
	}

	int i;
/*	for ( i = celt; i--; )
		// *** possibly init each structure element???
*/

	ULONG celtFetched = 0;
	PY_INTERFACE_PRECALL;
	HRESULT hr = pIEResources->Next(celt, rgVar, &celtFetched);
	PY_INTERFACE_POSTCALL;
	if (  HRESULT_CODE(hr) != ERROR_NO_MORE_ITEMS && FAILED(hr) )
	{
		delete [] rgVar;
		return PyCom_BuildPyException(hr,pIEResources, IID_IEnumResources);
	}

	PyObject *result = PyTuple_New(celtFetched);
	if ( result != NULL )
	{
		for ( i = celtFetched; i--; )
		{
			PyObject *ob = PyWinObject_FromSHELL_ITEM_RESOURCE(&rgVar[i]);
			if ( ob == NULL )
			{
				Py_DECREF(result);
				result = NULL;
				break;
			}
			PyTuple_SET_ITEM(result, i, ob);
		}
	}

/*	for ( i = celtFetched; i--; )
		// *** possibly cleanup each structure element???
*/
	delete [] rgVar;
	return result;
}

// @pymethod |PyIEnumResources|Skip|Skips over the next specified elementes.
PyObject *PyIEnumResources::Skip(PyObject *self, PyObject *args)
{
	long celt;
	if ( !PyArg_ParseTuple(args, "l:Skip", &celt) )
		return NULL;

	IEnumResources *pIEResources = GetI(self);
	if ( pIEResources == NULL )
		return NULL;

	PY_INTERFACE_PRECALL;
	HRESULT hr = pIEResources->Skip(celt);
	PY_INTERFACE_POSTCALL;
	if ( FAILED(hr) )
		return PyCom_BuildPyException(hr, pIEResources, IID_IEnumResources);

	Py_INCREF(Py_None);
	return Py_None;
}

// @pymethod |PyIEnumResources|Reset|Resets the enumeration sequence to the beginning.
PyObject *PyIEnumResources::Reset(PyObject *self, PyObject *args)
{
	if ( !PyArg_ParseTuple(args, ":Reset") )
		return NULL;

	IEnumResources *pIEResources = GetI(self);
	if ( pIEResources == NULL )
		return NULL;

	PY_INTERFACE_PRECALL;
	HRESULT hr = pIEResources->Reset();
	PY_INTERFACE_POSTCALL;
	if ( FAILED(hr) )
		return PyCom_BuildPyException(hr, pIEResources, IID_IEnumResources);

	Py_INCREF(Py_None);
	return Py_None;
}

// @pymethod <o PyIEnumResources>|PyIEnumResources|Clone|Creates another enumerator that contains the same enumeration state as the current one
PyObject *PyIEnumResources::Clone(PyObject *self, PyObject *args)
{
	if ( !PyArg_ParseTuple(args, ":Clone") )
		return NULL;

	IEnumResources *pIEResources = GetI(self);
	if ( pIEResources == NULL )
		return NULL;

	IEnumResources *pClone;
	PY_INTERFACE_PRECALL;
	HRESULT hr = pIEResources->Clone(&pClone);
	PY_INTERFACE_POSTCALL;
	if ( FAILED(hr) )
		return PyCom_BuildPyException(hr, pIEResources, IID_IEnumResources);

	return PyCom_PyObjectFromIUnknown(pClone, IID_IEnumResources, FALSE);
}

// @object PyIEnumResources|A Python interface to IEnumResources
static struct PyMethodDef PyIEnumResources_methods[] =
{
	{ "Next", PyIEnumResources::Next, 1 },    // @pymeth Next|Retrieves a specified number of items in the enumeration sequence.
	{ "Skip", PyIEnumResources::Skip, 1 },	// @pymeth Skip|Skips over the next specified elementes.
	{ "Reset", PyIEnumResources::Reset, 1 },	// @pymeth Reset|Resets the enumeration sequence to the beginning.
	{ "Clone", PyIEnumResources::Clone, 1 },	// @pymeth Clone|Creates another enumerator that contains the same enumeration state as the current one.
	{ NULL }
};

PyComEnumTypeObject PyIEnumResources::type("PyIEnumResources",
		&PyIUnknown::type,
		sizeof(PyIEnumResources),
		PyIEnumResources_methods,
		GET_PYCOM_CTOR(PyIEnumResources));

// ---------------------------------------------------
//
// Gateway Implementation

// Std delegation
STDMETHODIMP PyGEnumResources::Next( 
            /* [in] */ ULONG celt,
            /* [out] */ SHELL_ITEM_RESOURCE *rgVar,
            /* [out] */ ULONG *pCeltFetched)
{
	PY_GATEWAY_METHOD;
	PyObject *result;
	HRESULT hr = InvokeViaPolicy("Next", &result, "i", celt);
	if ( FAILED(hr) )
		return hr;

	if ( !PySequence_Check(result) )
		goto error;
	int len;
	len = PyObject_Length(result);
	if ( len == -1 )
		goto error;
	if ( len > (int)celt)
		len = celt;

	if ( pCeltFetched )
		*pCeltFetched = len;

	int i;
	for ( i = 0; i < len; ++i )
	{
		PyObject *ob = PySequence_GetItem(result, i);
		if ( ob == NULL )
			goto error;

		if ( !PyWinObject_AsSHELL_ITEM_RESOURCE(ob, &rgVar[i]))
		{
			Py_DECREF(result);
			return PyCom_SetCOMErrorFromPyException(IID_IEnumResources);
		}
	}

	Py_DECREF(result);

	return len < (int)celt ? S_FALSE : S_OK;

  error:
	PyErr_Clear();	// just in case
	Py_DECREF(result);
	return PyCom_SetCOMErrorFromSimple(E_FAIL, IID_IEnumResources, "Next() did not return a sequence of objects");
}

STDMETHODIMP PyGEnumResources::Skip( 
            /* [in] */ ULONG celt)
{
	PY_GATEWAY_METHOD;
	return InvokeViaPolicy("Skip", NULL, "i", celt);
}

STDMETHODIMP PyGEnumResources::Reset(void)
{
	PY_GATEWAY_METHOD;
	return InvokeViaPolicy("Reset");
}

STDMETHODIMP PyGEnumResources::Clone( 
            /* [out] */ IEnumResources __RPC_FAR *__RPC_FAR *ppEnum)
{
	PY_GATEWAY_METHOD;
	PyObject * result;
	HRESULT hr = InvokeViaPolicy("Clone", &result);
	if ( FAILED(hr) )
		return hr;

	/*
	** Make sure we have the right kind of object: we should have some kind
	** of IUnknown subclass wrapped into a PyIUnknown instance.
	*/
	if ( !PyIBase::is_object(result, &PyIUnknown::type) )
	{
		/* the wrong kind of object was returned to us */
		Py_DECREF(result);
		return PyCom_SetCOMErrorFromSimple(E_FAIL, IID_IEnumResources);
	}

	/*
	** Get the IUnknown out of the thing. note that the Python ob maintains
	** a reference, so we don't have to explicitly AddRef() here.
	*/
	IUnknown *punk = ((PyIUnknown *)result)->m_obj;
	if ( !punk )
	{
		/* damn. the object was released. */
		Py_DECREF(result);
		return PyCom_SetCOMErrorFromSimple(E_FAIL, IID_IEnumResources);
	}

	/*
	** Get the interface we want. note it is returned with a refcount.
	** This QI is actually going to instantiate a PyGEnumResources.
	*/
	hr = punk->QueryInterface(IID_IEnumResources, (LPVOID *)ppEnum);

	/* done with the result; this DECREF is also for <punk> */
	Py_DECREF(result);

	return PyCom_SetCOMErrorFromSimple(hr, IID_IEnumResources, "Python could not convert the result from Next() into the required COM interface");
}
