import release

class cls:
    server=None
    role=None
    name=None
    _versions=None
    data=None

    def __init__(self,server,role=None,name=None):
        self.server=server
        self.role=role
        self.name=name
        self._versions=None
        self.data=release.data(self)

    @property
    def version(self):
        """return latest package version"""
        versions=self.versions
        if len(versions)>0:
            return versions[0]

    @property
    def versions(self):
        """return package versions"""
        if not self._versions:
            self._versions=self.server.package_releases(self.name,True)
        return self._versions

    def __str__(self):
        return "%s-%s" % (self.name,self.version)

    def __repr__(self):
        return "<%s-%s>" % (self.name,self.version)