class fluentdict(dict):
    def __getattr__(self, key):
        return self[key]

class data(object):
    package=None
    releases=None

    def __init__(self,package):
        self.package=package
        self.releases=dict()

    def __getitem__(self,version):
        """return release data for specific version"""
        if version not in self.releases.keys():
            self.releases[version]=fluentdict(
                self.package.server.release_data(
                    self.package.name,
                    version
                )
            )
        return self.releases[version]

    def __getattribute__(self, k):
        try:  # exists
            return object.__getattribute__(self, k)
            #return super(type(self), self).__getattribute__(key)
        except AttributeError, e:  # not exists
            version=self.package.version
            if k in self.package.versions:
                return self[version]
            else:
                return getattr(self[version],k)
        except Exception, e:
            print type(e), str(e)

    def __str__(self):
        return str(self[self.package.version])