from nose.tools import assert_raises, assert_equal
import numpy as np
import potrace
import Image
import ImageDraw

adaptive = [
        [ 13.31417446,  23.4900536 ],
        [ 11.8989711 ,  22.78194571],
        [  9.85537247,  20.67271536],
        [  8.84117847,  17.95986131],
        [  8.95109458,  14.89670995],
        [  9.5099464 ,  13.31417446],
        [  9.5099464 ,  13.31417446],
        [ 10.05094235,  12.20495274],
        [ 11.58462424,  10.4881329 ],
        [ 13.51192652,   9.36908006],
        [ 15.66795189,   8.84314831],
        [ 17.88780304,   8.90569174],
        [ 20.00658267,   9.55206442],
        [ 21.85939346,  10.77762044],
        [ 23.28133811,  12.57771388],
        [ 23.75094638,  13.71540898],
        [ 23.75094638,  13.71540898],
        [ 24.11967007,  14.95878038],
        [ 24.23632249,  17.33619353],
        [ 23.69554109,  19.50044342],
        [ 22.59457044,  21.36045485],
        [ 21.0306551 ,  22.82515263],
        [ 19.10103965,  23.80346155],
        [ 16.90296864,  24.20430642],
        [ 14.53368665,  23.93661202],
        [ 13.31417446,  23.4900536 ]]

regular = [
        [ 13.31417446,  23.4900536 ],
        [ 12.19485325,  22.91315459],
        [ 11.22356861,  22.19509034],
        [ 10.40638171,  21.35207374],
        [  9.74935368,  20.40031768],
        [  9.25854569,  19.35603504],
        [  8.94001887,  18.23543873],
        [  8.79983438,  17.05474163],
        [  8.84405337,  15.83015662],
        [  9.078737  ,  14.5778966 ],
        [  9.5099464 ,  13.31417446],
        [  9.5099464 ,  13.31417446],
        [ 10.48111574,  11.65190728],
        [ 11.77807614,  10.37429236],
        [ 13.31640015,   9.47895097],
        [ 15.01166037,   8.96350443],
        [ 16.77942937,   8.82557401],
        [ 18.53527974,   9.062781  ],
        [ 20.19478404,   9.67274671],
        [ 21.67351486,  10.65309241],
        [ 22.88704479,  12.00143941],
        [ 23.75094638,  13.71540898],
        [ 23.75094638,  13.71540898],
        [ 24.19925302,  15.68274205],
        [ 24.18323645,  17.55445232],
        [ 23.75268588,  19.2839093 ],
        [ 22.95739053,  20.82448247],
        [ 21.84713964,  22.12954135],
        [ 20.4717224 ,  23.15245542],
        [ 18.88092805,  23.84659418],
        [ 17.12454579,  24.16532713],
        [ 15.25236486,  24.06202378],
        [ 13.31417446,  23.4900536 ]]

def test_tesselate():
    # Make a circle
    data = np.zeros((32, 32), np.uint32)
    radius2 = 8 * 8
    for j in range(32):
        y = j - 16
        for i in range(32):
            x = i - 16
            if x * x + y * y > radius2:
                data[j, i] = 0
            else:
                data[j, i] = 1

    # Trace it
    bmp = potrace.Bitmap(data)
    path = bmp.trace()
    out = Image.new("RGB", (32, 32), (0, 0, 0))
    draw = ImageDraw.Draw(out)
    curve = path.curves[0]
    points = curve.tesselate(curve.adaptive)
    assert (points - adaptive).sum() < 1e-6
    points = curve.tesselate(curve.regular, res=10)
    assert (points - regular).sum() < 1e-6
