from __future__ import absolute_import

'''// Generated by the protocol buffer compiler.  DO NOT EDIT!\n
// source: $file_name$\n", "file_name"
/**
*   @fileoverview Generated Protocol Buffer code for file %(filename)s.
*/'''

TMPL_PROVIDE = '''goog.provide('%(name)s');'''

TMPL_REQUIRE = '''goog.require('goog.proto2.Message');'''

TMPL_MESSAGE_CONST = '''/** Message %(name)s.
*   @constructor
*   @extends {goog.proto2.Message}
*/
%(name)s = function() {
  goog.base(this);
}
goog.inherits( %(name)s, goog.proto2.Message);

'''

FIELD_GETTERSETTER = '''
/**
 * Gets the value of the {field_name} field.
 * @return {{{js_type}}} The value.
 */
{message_name}.prototype.get{field_upper_camel} = function() {{
  return /** @type {{proto2.TestAllTypes}} */ (this.get$Value({field_tag}));
}};


/**
 * Gets the value of the {field_name} field or the default value if not set.
 * @return {{!{js_type}}} The value.
 */
{message_name}.prototype.get{field_upper_camel} = function() {{
  return /** @type {{!proto2.TestAllTypes}} */ (this.get$ValueOrDefault({field_tag}));
}};


/**
 * Sets the value of the {field_name} field.
 * @param {{!{js_type}}} value The value.
 */
{message_name}.prototype.set{field_upper_camel} = function(value) {{
  this.set$Value({field_tag}, value);
}};


/**
 * @return {{boolean}} Whether the {field_name} field has a value.
 */
{message_name}.prototype.has{field_upper_camel} = function() {{
  return this.has$Value({field_tag});
}};


/**
 * @return {{number}} The number of values in the {field_name} field.
 */
{message_name}.prototype.{field_lower_camel}Count = function() {{
  return this.count$Values({field_tag});
}};


/**
 * Clears the values in the {field_name} field.
 */
{message_name}.prototype.clear{field_upper_camel} = function() {{
  this.clear$Field({field_tag});
}};
'''

TMPL_META = '''
goog.proto2.Message.set$Metadata(MessageType, {
  0: {
    name: 'test_message',
    fullName: 'this.is.a.test_message'
  },
  10: {
    name: 'test',
    fieldType: 7,
    type: Number
  }
});

'''
import json
import pyprotobuf.nodes as nodes
from pyprotobuf.codegenerator import CodeGenerator        


GOOG_PROTO2_TYPE_MAP = {
    'bool':'goog.proto2.Message.FieldType.BOOLEAN',
    'string': 'goog.proto2.Message.FieldType.STRING',
    'int64': 'goog.proto2.Message.FieldType.INT64',        
    'int32': 'goog.proto2.Message.FieldType.INT32',
    'uint64': 'goog.proto2.Message.FieldType.UINT64', 
    'uint32': 'goog.proto2.Message.FieldType.UINT32',
    'sint64': 'goog.proto2.Message.FieldType.SINT64', 
    'sint32': 'goog.proto2.Message.FieldType.SINT32',
    'fixed64': 'goog.proto2.Message.FieldType.FIXED64', 
    'fixed32': 'goog.proto2.Message.FieldType.FIXED32',
    'sfixed64': 'goog.proto2.Message.FieldType.SFIXED64',   
    'sfixed32': 'goog.proto2.Message.FieldType.SFIXED32',    
    'double': 'goog.proto2.Message.FieldType.DOUBLE',    
    'float': 'goog.proto2.Message.FieldType.FLOAT', 
    'bytes': 'goog.proto2.Message.FieldType.BYTES',
    'enum': 'goog.proto2.Message.FieldType.ENUM',
    'message': 'goog.proto2.Message.FieldType.MESSAGE'
}

JS_TYPE_MAP = {
    'bool':'Boolean',
    'bytes': 'String',
    'double': 'Number',
    'fixed32': 'Number',
    'fixed64': 'String',
    'float': 'Number',
    'int32': 'Number',
    'int64': 'String',
    'sfixed32': 'Number',
    'sfixed64': 'String',
    'sint32': 'Number',
    'sint64': 'String',
    'string': 'String',
    'uint32': 'Number',
    'uint64': 'String',
}

'''
"/**\n"
" * Enumeration $name$.\n"
" * @enum {number}\n"
" */\n",
$name$ = {
'''

from pyprotobuf.generators.go import camel_case

def join_with_dots(*args):
    args = map(str, args)
    return '.'.join(args)


def quote_literal(string):
    return '"{}"'.format(string)


class ClosureLib(CodeGenerator):
    
    comment = '//'
    prefix = ''
    
    def generate_file(self, protonode, **kwargs):
        self.output.write(TMPL_REQUIRE + '\n\n')
        self.visit(protonode)
        
        return self.output.to_string()

    def visit_EnumNode(self, node):
        if getattr(node, 'visited', False):
            return

        enum_name = node.get_full_name()

        self.output.write('%s = {\n' % enum_name)

        enum_assignments = filter(lambda x: isinstance(x, nodes.EnumAssignmentNode), node.children)

        for enum in enum_assignments:
            name, value = enum.name, enum.value
            self.output.write("  %s: %s\n" % (name, value))

        self.output.write('};\n\n')

        # mark as visited so we dont output twice
        # XXX: improve file node traversal so we dont need this
        setattr(node, 'visited', True)

    def add_prefix(self, name):
        return '{0}{1}'.format(self.prefix, name)

    def visit_MessageNode(self, node):
        # loop over fields
        fields = filter(lambda x: isinstance(x, nodes.FieldDescriptorNode), node.children)
        fields = sorted(fields, key=lambda x: x.number)
        all_field_meta = {}

        message_name = node.get_full_name()

        messagemeta = {'name': message_name, 'prefix' : self.prefix}
        
        self.output.write(TMPL_MESSAGE_CONST % messagemeta)

        enums = filter(lambda x: isinstance(x, nodes.EnumNode), node.children)

        for enum in enums:
            self.visit_EnumNode(enum)

        for field in fields:
            str_field_type = str(field.type)
            field_camel = camel_case(field.name)
            field_lower_camel = (field_camel[0].lower() + field_camel[1:])


            if isinstance(field.type, nodes.MessageNode):
                js_type = self.add_prefix(field.get_full_typename())
            elif isinstance(field.type, nodes.EnumNode):
                js_type = self.add_prefix(field.type.get_full_typename())
            else:
                # needs to be lowercase
                # literals {name} are different than wrapper objects {Name}
                # aka Primitive Data Type Wrapper Objects
                js_type = JS_TYPE_MAP.get(str_field_type).lower()

            if field.label == field.LabelType.REPEATED:
                js_type = '[{}]'.format(js_type)

            self.output.write(FIELD_GETTERSETTER.format(message_name=message_name,
                                                        field_name=field.name,
                                                        js_type=js_type,
                                                        field_tag=field.number,
                                                        field_upper_camel=field_camel,
                                                        field_lower_camel=field_lower_camel))

        self.output.write('goog.proto2.Message.set$$Metadata(%(prefix)s%(name)s, {\n'% messagemeta)
        lines = []
        for field in fields:
            field_number = field.number
            field_meta = all_field_meta[field_number] = {}

            str_field_type = str(field.type)

            jsfieldtype = GOOG_PROTO2_TYPE_MAP.get(str_field_type)


            if isinstance(field.type, nodes.MessageNode):
                jstype = '{0}{1}'.format(self.prefix, field.get_full_typename())
                jsfieldtype = GOOG_PROTO2_TYPE_MAP.get('message')
            elif isinstance(field.type, nodes.EnumNode):
                jstype = field.get_full_typename()
                jsfieldtype = GOOG_PROTO2_TYPE_MAP.get('enum')
            else:
                jstype = JS_TYPE_MAP.get(str_field_type, None)


            line = ['  %s: {' % field.number]
            field_meta['name'] = field.name
            field_meta['fieldType'] = jsfieldtype
            field_meta['type'] = jstype
            field_meta['prefix'] = self.prefix
            line.append("'name':'{name}', 'fieldType': {fieldType}, 'type': {type}".format(name=field.name,
                                                                                                 fieldType=jsfieldtype, type=jstype, prefix=self.prefix))
            
            if field.label == "repeated":
                field_meta['repeated'] = True
                line.append(", 'repeated': true")
            if hasattr(field, 'default'):
                if isinstance(field.type, nodes.EnumNode):
                    field_meta['defaultValue'] = join_with_dots(field.type.get_full_typename(), field.default)
                elif str(field.type) in nodes.NUMERIC_TYPES:
                    field_meta['defaultValue'] = field.default
                elif field.type == nodes.Types.BOOL:
                    field_meta['defaultValue'] = field.default
                else:
                    field_meta['defaultValue'] = quote_literal(field.default)

                line.append(", 'defaultValue': %(defaultValue)s" % field_meta)
            line.append("}")
            lines.append(''.join(line))
          
        self.output.write(',\n'.join(lines))  
        
        self.output.write('\n});')

        self.output.write('\n\n')
        
        
    def visit_FieldDescriptorNode(self, node):
        pass
    
    def visit_OptionNode(self, node):
        if node.name == 'javascript_package':
            self.prefix = node.value.strip('"') + '.'    
 
__generator__ = ClosureLib
