#from cmath import pi
#from collections import OrderedDict
#from models2dict import Models

def to_file(file_name, model, IBUS, ID):
     f = open(file_name + '.rst', 'w')
     f.write(toReST)
      
     
    
def device_writer(model, IBUS, ID, models_dict):
   
    Models = models_dict
    NI, NC, NS, NV = 0, 0, 0, 0
    toPSSE=''
    if Models[model].has_key('type'):
        if Models[model]['type']=='USRMDL':
            '''
                BUSID 'USRMDL' IM 'model name' IC IT NI NC NS NV data list
                    Where:
                        BUSID and IM are the external bus number and the machine id of the machine that is being
                        subject to test.
                        IC Is the user-model type code, which in this case would be 505 since the model is classified
                        as a "Machine Other model".
                        IT determines the placement in CONET. In this case, IT is 0 since the model does not need
                        to be called during dynamic simulation network solution.
                        NI Is the number of ICONs used by the model (NI = 2).
                        NC Is the number of CONs used by the model (NC = 6).
                        NS Is the number of STATEs used by the model. (NS = 0).
                        NV Is the number of VARs used by the model. (NV = 2).
            '''
            BUSID = IBUS
            IM  = ID
            IT = Models[model]['IT']
            IC = Models[model]['type_code']
            if Models[model].has_key('ICONs'): NI=len(Models[model]['ICONs'])
            if Models[model].has_key('CONs'):  NC=len(Models[model]['CONs'])
            if Models[model].has_key('STATEs'): NS=len(Models[model]['STATEs'])
            if Models[model].has_key('VARs'):  NV=len(Models[model]['VARs'])   
            toPSSE = " %d 'USRMDL'  %s  '%s'   %d %d %d %d %d %d " %(IBUS, ID,  model, IC, IT, NI, NC, NS, NV)

    else:
        toPSSE = "{:d}  '{:s}' '{:s}'  ".format(IBUS,   model, str(ID))
        

                                                     
    
    toReST = ''


    
    if Models[model].has_key('ICONs'):
        
        toReST+=    'Integer Constants\n'
        toReST+=    len(toReST.split('\n')[-2])*'-' + '\n'
                                           
        toReST+=    '\n'                    
        toReST+=    '====== ==== ====== ===========================================================================\n' 
        toReST+=    'ICONS   #   Value  Description                             \n' 
        toReST+=    '====== ==== ====== ===========================================================================\n'
        ICONS=Models[model]['ICONs']
        it = 0
        it_row = 0
        for item in ICONS:
            it+=1
            toReST+='%5s %4d %6d   %s \n' %(item.keys()[0],it, item[item.keys()[0]]['typical'], item[item.keys()[0]]['Description'])
            it_row+=1
            if it_row>5:
                it_row=0
                toPSSE+=' \n'
            toPSSE+= '%4d  ' %(item[item.keys()[0]]['typical'])
        toReST+=    '====== ==== ====== ===========================================================================\n'
        toReST+=    '\n'
        toReST+=    '\n'

    if Models[model].has_key('CONs'):

        toReST+=    'Constants\n'
        toReST+=    len(toReST.split('\n')[-2])*'-' + '\n'
        toReST+=    '\n'
        toReST+=    '====== ==== ========= ===========================================================================\n'
        toReST+=    'CONS    #   Value     Description                             \n' 
        toReST+=    '====== ==== ========= ===========================================================================\n'
        CONS=Models[model]['CONs']
        it = 0
        it_row = 0
        for item in CONS:
            it+=1
            toReST+='%5s %4d %10.3f %s \n' %(item.keys()[0],it, item[item.keys()[0]]['typical'], item[item.keys()[0]]['Description'])
            it_row+=1
            if it_row>5:
                it_row=0
                toPSSE+=' \n'
            toPSSE+= '%4.3f  ' %(item[item.keys()[0]]['typical'])
        toReST+=    '====== ==== ========= ===========================================================================\n'
        toReST+=    '\n'
        toReST+=    '\n'


    if Models[model].has_key('STATEs'):
        toReST+=    'States\n'
        toReST+=    len(toReST.split('\n')[-2])*'-' + '\n'
        toReST+=    '\n'
        toReST+=    '====== ==== ========= ===========================================================================\n'
        toReST+=    'STATEs  #   Value     Description                             \n' 
        toReST+=    '====== ==== ========= ===========================================================================\n'
        STATEs=Models[model]['STATEs']
        for item in STATEs:
            toReST+='%5s %4s %10.3f %s \n' %(item.keys()[0],' ', 0.0, item[item.keys()[0]][u'Description']) 
        toReST+=    '====== ==== ========= ===========================================================================\n'

    toPSSE+='/ \n'


    return toReST, toPSSE

if __name__ == "__main__":
    file_name_rst = 'sexs_1'
    file_name_dyr = 'sys_8bus'
    f_dyr = open(file_name_dyr + '.dyr', 'w')
    toDYR = ''    
    models = ['GENSAL', 'DEGOV1', 'SEXS', 'GPINVB']
    IBUSES = [1, 2]
    ID = 1

    for IBUS in IBUSES:
        for model in models:
            toReST, toPSSE = device_writer(file_name_rst, model, IBUS, ID)
            toDYR += toPSSE
        
    f_dyr.write(toDYR)
    f_dyr.close()
