# -*- coding: utf-8 -*-
"""
Created on Thu Jan 30 13:59:21 2014

@author: jmmauricio-s
"""

import matplotlib.pyplot as plt
import numpy as np
import os, sys
import matplotlib.pyplot as plt 
from matplotlib.tri import Triangulation        
import matplotlib.cm as cm
import matplotlib.colors as mcolors
import rst_tools as rst



print os.getcwd()


class PSTools:
    """
    Pruba de doc
    
    """
    def __init__(self):
        
        self.bus = {}
        self.gen = {}
        self.load = {}
        self.branch = {}
        
        
    def get_single(self, loc_file):
        
        ''' 
        
        buses format
        ------------
        
        /buses
        x_ini, y_ini
        x_end, y_end
 
 
        generators format
        -----------------
        
        /generators
        x_center, y_center        
        
        '''
        
        loc_data = file(os.path.join(os.getcwd(),loc_file))
        dxy = 20.0
        end = False
        bus_i = 1
        bus = {}
        
        for item in loc_data.readlines():
            
            if item[0:6] == '/buses':
                reading = 'buses'
                continue
            
            if item[0:6] == '/gener':
                reading = 'generators'
            
            if reading == 'buses':
                
                if end == False:
                    bus.update({bus_i:{'x_ini':float(item.split(',')[0]),'y_ini':float(item.split(',')[1].split('/')[0])}})    
                    end = True
                    continue 
                    
                if end == True:
                    bus[bus_i].update({'x_end':float(item.split(',')[0]),'y_end':float(item.split(',')[1].split('/')[0])})
                    end = False
                     
            
                    if bus[bus_i]['x_ini']==bus[bus_i]['x_end']:
                        if bus[bus_i]['y_ini']<bus[bus_i]['y_end']:
                            y_nodes=np.arange(bus[bus_i]['y_ini'],bus[bus_i]['y_end']+dxy,dxy)
                        else:
                            y_nodes=np.arange(bus[bus_i]['y_end'],bus[bus_i]['y_ini']+dxy,dxy)
                            
                        x_nodes=np.interp(y_nodes,np.array([bus[bus_i]['y_ini'], bus[bus_i]['y_end']]),np.array([bus[bus_i]['x_ini'], bus[bus_i]['x_end']]))
                        z_values = x_nodes*0.0
                        
                        bus[bus_i].update({'x_nodes':x_nodes,'y_nodes':y_nodes,'z_values':z_values})
                        
                    bus_i   +=1 
                    
            self.bus = bus
        return self.bus
        
    def set_mesh(self, psse_out):
        
        '''
        psse_out: dict with the following format
                psse_out = {'buses':{1:{'name':'bus 1', 'v_pu':1.01}},'generators':{1:{'name':'gen 1', 'efd':1.05}}}    
        
        
        '''
        
        x,y = np.array([]),np.array([])
        z =  np.array([])
        
        for it in range(1,len(self.bus.items())+1):
            
            x = np.append(x,bus[it]['x_nodes'])
            y = np.append(y,bus[it]['y_nodes'])   
            z = np.append(z,bus[it]['z_values']+psse_out['buses'][it]['v_pu'])        

        self.x = x
        self.y = y
        self.z = z
        
        return x,y,z
        

    def refine_mesh(self):

        # add new points (rectangular grid)
        x_min, x_max=200.0, 500.0
        y_min, y_max=500.0, 750.0
        x_mesh, y_mesh = np.meshgrid(np.linspace(x_min, x_max, 10), np.linspace(y_min, y_max, 10))

        # add new points (elliptical grid)    
        x =  np.append(x, x_mesh)
        y =  np.append(y, y_mesh)
        z = x_mesh*0.0 
        v_pu = np.append(v_pu,z+1.0)
        p = np.linspace(0.0,2.0*np.pi, 20)
        radio=1000.0
        x_offset = 0.5* (x_min+ x_max)
        y_offset = 0.5* (y_min+ y_max)
        
        x =  np.append(x, np.sin(p)*(x_max - x_min)*0.5*1.4  + x_offset)
        y =  np.append(y,np.cos(p)*(y_max - y_min)*0.5*1.4 + y_offset)
        z = p*0.0   
        v_pu = np.append(v_pu,z+1.0)    
        
        x =  np.append(x, np.sin(p)*(x_max - x_min)*0.5*1.6  + x_offset)
        y =  np.append(y,np.cos(p)*(y_max - y_min)*0.5*1.6 + y_offset)
        z = p*0.0   
        v_pu = np.append(v_pu,z+v_pu.mean())

    def set_boundary(self, boundary, border_value=1.0, radio=1000.0, n_point=20):
        
        x_min,x_max,y_min,y_max =boundary['x_min'],boundary['x_max'],boundary['y_min'],boundary['y_max']
        
        p = np.linspace(0.0,2.0*np.pi, n_point)

        x_offset = 0.5* (x_min+ x_max)
        y_offset = 0.5* (y_min+ y_max)
        
        self.x =  np.append(self.x, np.sin(p)*(x_max - x_min)*0.5*1.4  + x_offset)
        self.y =  np.append(self.y, np.cos(p)*(y_max - y_min)*0.5*1.4 + y_offset)

        z = p*0.0   
        self.z = np.append(self.z,z+border_value)    

        
        
    def draw_contours(self, var_type='v_pu'):
        
        fig = plt.figure()
        ax1 = fig.add_subplot(111)

        cdict = {'red':   [(0.0,  0.0, 1.0),
                           (1.0,  0.3, 0.0)],
                 'green': [(0.0,  0.0, 0.0),
                           (0.5,  0.5, 0.5),
                           (1.0,  0.0, 0.0)],
                 'blue':  [(0.0,  0.0, 0.3),
                           (1.0,  1.0, 0.0)]}
                           
        rvb = mcolors.LinearSegmentedColormap('CustomMap', cdict)
        
        
        #-----------------------------------------------------------------------------
        # Creating a Triangulation
        #-----------------------------------------------------------------------------
        # First create the x and y coordinates of the points.
        
        #x = np.array(x)
        #y = np.array(y)

        
        
        # Now create the Triangulation.
        # (Creating a Triangulation without specifying the triangles results in the
        # Delaunay triangulation of the points.)
        self.triang = Triangulation(self.x, self.y)
#        #min_circle_ratio = 0.1
#        #mask = TriAnalyzer(triang).get_flat_tri_mask(min_circle_ratio)
#        #triang.set_mask(mask)
#        
#        ## Mask off unwanted triangles.
#        #xmid = x[triang.triangles].mean(axis=1)
#        #ymid = y[triang.triangles].mean(axis=1)
#        #mask = np.where(xmid*xmid + ymid*ymid < min_radius*min_radius, 1, 0)
#        #triang.set_mask(mask)
#        
#        #-----------------------------------------------------------------------------
#        # Refine data
#        #-----------------------------------------------------------------------------
#        #refiner = UniformTriRefiner(triang)
#        #tri_refi, z_test_refi = refiner.refine_field(z,'LinearTriInterpolator', subdiv=5)
#        #tri_refi, z_test_refi = refiner.refine_field(z,'LinearTriInterpolator', subdiv=5)
#        #interp_lin = CubicTriInterpolator(triang,z, kind='min_E')
#        #z_test_refi = interp_lin(x, y)
#        #-----------------------------------------------------------------------------
#        # Plot the triangulation and the high-res iso-contours
#        #-----------------------------------------------------------------------------
#        #plt.figure()
#        #plt.triplot(triang, lw=0.5, color='white')
        z_min = self.z.min()        
        z_max = self.z.max()
#        
        margin =  (z_max-z_min)*0.3
        dlevel = (z_max-z_min)/40.0
        levels = np.arange(z_min-margin, z_max+margin+dlevel, dlevel)
#        
#        #ax1.tricontourf(tri_refi, z_test_refi, levels=levels, cmap=rvb)
#        #ax1.tricontour(triang, z, levels=levels, cmap=rvb)
        #plt.tricontourf(triang, z, levels=levels, cmap=rvb)
        plt.tricontourf(self.triang, self.z, shading='gouraud', levels=levels,cmap=rvb)
#        #plt.tricontour(tri_refi, z_test_refi, levels=levels,
#        #               colors=['0.25', '0.5', '0.5', '0.5', '0.5'],
#        #               linewidths=[1.0, 0.5, 0.5, 0.5, 0.5])
#        #plt.tripcolor(triang, z, shading='flat', cmap=plt.cm.rainbow)
#        
#        
#        
#        
#        
#        
        self.plt = plt
        self.fig = fig
        

    def add_png(self, image_file):
        
        #        image_file =r'ieee12.png'
        image=plt.imread(image_file)
        
        self.plt.imshow(image, extent=(187.58974,507.61196,512.410244,736.0), alpha=1.0,  zorder=1)
        plt.title("High-resolution tricontouring")
        
        
        plt.show()
#        
        self.fig.savefig('prueba1.png')

    def circ(self, bus, psse_out, image_file):
        
        self.plt = plt
        delta = 10.0
        x = np.arange(000.0, 700.0+delta, delta)
        y = np.arange(300.0, 1000.0+delta, delta)
        X, Y = np.meshgrid(x, y)
        Z=X*0.0
    #    X_i = [2.1, 2.0, 1.5, -1.0]
    #    Y_i = [2.1, 2.5, -2.3, -2]
    #    Z_i = [0.1, 0.1, -0.2, 0.1]
        radio = 20.0
        
        for item in bus:
            print item
            for it_i in range(len(bus[item]['z_values'])):
                x_i = bus[item]['x_nodes'][it_i]
    #            print x_i
                y_i = bus[item]['y_nodes'][it_i]    
                z_i = psse_out['buses'][item]['v_pu']-1
                print x_i, y_i
                
                
                a,x_idxs = np.where([np.logical_and(x > x_i-radio, x < x_i+radio)])
                print x_idxs
                for it_x in x_idxs:
                    a,y_idxs = np.where([np.logical_and(y > y_i-radio, y < y_i+radio)])
                    for it_y in y_idxs:   
                
                        dr = np.sqrt((X[it_x,it_y]-x_i)**2 + (Y[it_x,it_y]-y_i)**2)
                        z_j = -dr*z_i/radio + z_i
                        
                        if z_j*z_i<0.0:
                            z_j = 0.0
    #                        print 'z_j'
                
                        Z[it_x,it_y]=Z[it_x,it_y]+z_j
    #            print z_j
        #Z1 = mlab.bivariate_normal(X, Y, 1.0, 1.0, 0.0, 0.0)
        #Z2 = mlab.bivariate_normal(X, Y, 1.5, 0.5, 1, 1)
        #Z = Z2-Z1  # difference of Gaussians
        #
#        self.plt.contourf(X,Y, Z,  cmap=cm.coolwarm,vmax=Z.max(), vmin=Z.min())
        self.plt.contourf(X,Y, Z)
    #    fig = plt.figure(figsize=plt.figaspect(0.5))
    #    ##---- First subplot
    #    ax = fig.add_subplot(1, 2, 1, projection='3d')
    #    
    #    #
    #    surf = ax.tricontour(X, Y, Z, cmap=cm.coolwarm,
    #            linewidth=0)
    #    ax.set_zlim3d(-1.01, 1.01)
        
        
        image=self.plt.imread(image_file)       
        self.plt.imshow(image, extent=(187.58974,507.61196,512.410244,736.0), alpha=1.0,  zorder=1)        
        print X
        print Y
        self.plt.show()
        

        return y
        
def models2rst(psspy, devices = ['GEN', 'EXC', 'STAB', 'GOV'], report_models = ['GENROU', 'GENSAL', 'SEXS', 'STAB1', 'HYGOV', 'TGOV1']):
    '''
    rst models
    '''
    from models import models2dict as models_data
    
    sid = -1
    flag = 4
    gens_buses = psspy.amachint(sid, flag, 'NUMBER')[1][0]
    gens_ids = psspy.amachchar(sid, flag, 'ID')[1][0]
    current_models_dic = models_data.psse_models_dic.copy()

    for model in report_models:
        for item_con in current_models_dic[model]['CONs']:
            item_con.values()[0]['values'] = []          
            item_con.values()[0]['buses'] = [] 
        
    for ibus,idstr in zip(gens_buses,gens_ids):  
        
        for dev in devices:
            ierr, cval = psspy.mdlnam(ibus,idstr, dev) 
            
            print cval
            it_value = 0
            if cval:
                model = cval.split()[0]
            
                it_con = 0
                


                    
                for item_con in current_models_dic[model]['CONs']:
                    ierr, ival = psspy.mdlind(ibus, idstr, dev, 'CON')
                    ierr, rval = psspy.dsrval('CON', ival+it_con)
#                    print '{:s}: {:5.3f}'.format(item_con.values()[0]['Description'], rval)
                    if (not item_con.values()[0].has_key('buses')):
                        item_con.values()[0].update({'buses':[]})
                    item_con.values()[0]['buses']  += [ibus]    
                    if it_value == 0:
                         item_con.values()[0]['values']  += [rval]
                    else:
                        item_con.values()[0]['values']  += [rval]              
                    it_con += 1
    #                it_value = +1    
    
    str_con = ''
    for report_model in report_models:
        str_aux = '\n'*3 + 'Constants for model {:s}'.format(report_model) 
        str_con += str_aux + '\n'
        str_con += '-'*len(str_aux) + ' \n'*2
        
        fig_name = report_model + '.png'
        str_con += rst.figure(fig_name)      

        n_values = len(current_models_dic[report_model]['CONs'][0].values()[0]['values'])
        str_header = '='*32 + ' ' +   ('='*10 + ' ')*n_values  + ' \n' 
        str_con +=str_header
        str_con += '{:32s} '.format('Description')
        if current_models_dic[report_model]['CONs'][0].values()[0].has_key('buses'):
            for item_bus in current_models_dic[report_model]['CONs'][0].values()[0]['buses']:
                str_con += 'G{:<8d}  '.format(gens_buses.index(item_bus)+1)
        str_con += ' \n'
        str_con += str_header
        for item_con in current_models_dic[report_model]['CONs']:  
            str_con += '{:32s} '.format(item_con.values()[0]['Description'] +  ' ') 
            for item_value in item_con.values()[0]['values']:         
                str_con += '{:9.3f}  '.format(item_value)
            str_con += '\n'
        str_con +=str_header
        
    return str_con
    


        
if __name__ == '__main__':
    pstools=PSTools()
    bus = pstools.get_single(loc_file = r'/home/jmmauricio/Documents/public/jmmauricio6/RESEARCH/ABENGOA/HVDC/IEEE12/svg/ieee12_locs.dat')
    psse_out = {'buses':{1: {'ang_deg': -4.143028736114502, 'v_pu': 0.98571169376373291}, 2: {'ang_deg': -2.9168791770935059, 'v_pu': 0.99258172512054443}, 3: {'ang_deg': -29.395549774169922, 'v_pu': 1.0196530818939209}, 4: {'ang_deg': -30.868520736694336, 'v_pu': 1.0230060815811157}, 5: {'ang_deg': -29.418529510498047, 'v_pu': 1.018092155456543}, 6: {'ang_deg': -3.7774019241333008, 'v_pu': 1.0113478899002075}, 7: {'ang_deg': -7.1886520385742188, 'v_pu': 1.0030512809753418}, 8: {'ang_deg': -26.65687370300293, 'v_pu': 1.0437520742416382}, 9: {'ang_deg': 0.0, 'v_pu': 1.0}, 10: {'ang_deg': 1.0052182674407959, 'v_pu': 1.0099999904632568}, 11: {'ang_deg': -24.382028579711914, 'v_pu': 1.0099999904632568}, 12: {'ang_deg': 1.2695542573928833, 'v_pu': 1.0199999809265137}}}
    image_file = r'/home/jmmauricio/Documents/public/jmmauricio6/RESEARCH/ABENGOA/HVDC/IEEE12/svg/ieee12.png'    
    y=pstools.circ(bus, psse_out,image_file)
#    x,y,z = pstools.set_mesh(psse_out)
    
#    boundary = {'x_min':200.0, 'x_max':500.0, 'y_min':500.0, 'y_max':750.0}
#    pstools.set_boundary(boundary)
    
#    pstools.draw_contours(var_type='v_pu')

#    pstools.add_png(r'/home/jmmauricio/Documents/public/jmmauricio6/RESEARCH/ABENGOA/HVDC/IEEE12/svg/ieee12.png')
# 