# -*- coding: cp1252/latin-1 -*-
"""
Created on Thu Jul 03 20:48:16 2014

@author: 2
"""
import sys, os
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.colors import  rgb2hex
from tools.name2chan import name2chan  

class test:
    
    ''' 
    
    '''
    
    def __init__(self):
        self.pssedir = r'C:\Program Files\PTI\PSSE33'
        self.pssedir = r'C:\Program Files\PTI\PSSEUniversity33'
        
        self.pssbindir  = os.path.join(self.pssedir,'PSSBIN')
        
        azul_g = rgb2hex((51./255,102./255,204./255))
        rojo_g = rgb2hex((220./255,57./255,18./255))
        amarillo_g = rgb2hex((255./255,153./255,0./255))
        verde_g = rgb2hex((16./255,150./255,24./255))
        violeta_g = rgb2hex((153./255,0./255,153./255))
        celeste_g = rgb2hex((0./255,153./255,198./255))
        
        self.g_colors = [rojo_g, verde_g, azul_g, amarillo_g, violeta_g,celeste_g]
        self.lw = 2.0
        

    def setup(self,case_name, case_dir, dll_dir, ps_tools_dir, dya_dir):
        '''
         Files Used
        '''
        
        self.case_dir = case_dir
        sys.path.append(ps_tools_dir)
        self.libraryname = os.path.join(dll_dir, 'dsusr.dll')
        self.rawfile    = os.path.join(case_dir,case_name + '.raw')
        self.dyrfile    = os.path.join(case_dir,case_name + '.dyr')
        self.dyafile_avr= os.path.join(case_dir, dya_dir, case_name + '_avr.dya')
        self.dyafile_gov= os.path.join(case_dir, dya_dir,case_name + '_gov.dya')
        self.dyafile_pss= os.path.join(case_dir, dya_dir,case_name + '_pss.dya')
        self.xsfile = os.path.join(case_dir,case_name + '_xs.txt')
        self.savfile    = os.path.join(case_dir,case_name + '.sav')
        self.savdynfile = os.path.join(case_dir,case_name + '_dyn.sav')
        self.snpfile    = os.path.join(case_dir,case_name + '.snp')
        self.outfile1   = os.path.join(case_dir,case_name + '.out')
        self.outfile2   = os.path.join(case_dir,case_name + '.out')
        self.outfile3   = os.path.join(case_dir,case_name + '.out')
        self.prgfile    = os.path.join(case_dir,'dyntools_demo_progress.txt')
        self.chnffile = os.path.join(case_dir,case_name + '.pkl') 
        self.lsa_file  = os.path.join(case_dir,case_name + '.lsa')
        self.lsa_dat  = os.path.join(case_dir,case_name + '.dat')
        self.ltifile = os.path.join(case_dir,'sys_abcd_f102.pkl')
        # =============================================================================================
        # Check if running from Python Interpreter
        exename = sys.executable
        p, nx   = os.path.split(exename)
        nx      = nx.lower()
        if nx in ['python.exe', 'pythonw.exe']:
            os.environ['PATH'] = self.pssbindir + ';' + os.environ['PATH']
            sys.path.insert(0,self.pssbindir)
        
        # =============================================================================================
        import dyntools
        
        import redirect
        redirect.psse2py()    
        import psspy
        ierr = psspy.psseinit(buses=80000)  # choose here bus numbers you want
        
        psspy.lines_per_page_one_device(1,90)
        psspy.progress_output(2,self.prgfile,[0,0])
        # =============================================================================================

        self.psspy = psspy
        self.dyntools = dyntools

        self.psspy.delete_all_plot_channels()
    def setup_pf(self):
        
        # Se carga el .raw
        self.psspy.read(0,self.rawfile)
        
        # Se soluciona el flujo de potencia
        self.psspy.fdns([0,0,0,1,1,0,99,0])
        
        # Se guarda la solucion
        self.psspy.save(self.savfile)
        
        
    def setup_dyn(self, vip_buses):
        
        # Se cargan los datos dinamicos
        self.psspy.dyre_new([1,1,1,1],self.dyrfile,"","","")
        self.psspy.dyre_add([],self.dyafile_avr,"","")
        self.psspy.dyre_add([],self.dyafile_gov,"","")

        # Se convierten las cargas y los generadores para la simulacion dinamica
        self.psspy.cong(0)
        self.psspy.conl(0,1,1,[0,0],[0.0, 100.0,0.0, 100.0])
        self.psspy.conl(0,1,2,[0,0],[0.0, 100.0,0.0, 100.0])
        self.psspy.conl(0,1,3,[0,0],[0.0, 100.0,0.0, 100.0])
        
        # se guarda la solucion .sav para simulacion dinamica
        self.psspy.save(self.savdynfile)
        
        
        ierr = self.psspy.addmodellibrary(self.libraryname)
        
        self.vip_buses = vip_buses
        self.sid = 1
        self.psspy.bsys(self.sid,0,[ 0.0, 900.0],0,[],len(vip_buses),vip_buses,0,[],0,[])
        
        chan_ids = {
        'ANGLE': {'id':1, 'output_name':'ANGL', 'description':'machine relative rotor angle (degrees)', 'name':'theta', 'latex':'\theta'},
        'PELEC': {'id':2, 'output_name':'POWR','description':'machine electrical power (pu on SBASE).', 'name':'p_gen', 'latex':'p_g'},
        'QELEC': {'id':3, 'output_name':'VARS','description':'machine reactive power.', 'name':'q_gen', 'latex':'q_g'},
        'ETERM': {'id':4, 'description':'machine terminal voltage (pu).'},
        'EFD':   {'id':5, 'description':'generator main field voltage (pu).'},
        'PMECH': {'id':6, 'description':'turbine mechanical power (pu on MBASE).', 'name':'p_m', 'latex':'p_m'},
        'SPEED': {'id':7, 'output_name':'SPD', 'description':'machine speed deviation from nominal (pu).', 'name':'speed'},
        'XADIFD':{'id':8, 'description':'machine field current (pu).'},
        'ECOMP': {'id':9, 'description':'voltage regulator compensated voltage (pu).'},
        'VOTHSG':{'id':10,'description':'stabilizer output signal (pu).',  'name':'v_pss', 'latex':'v_s'},
        'VREF':  {'id':11,'description':'voltage regulator voltage setpoint (pu).', 'name':'v_ref', 'latex':'v^\star'},
        'BSFREQ':{'id':12,'description':'bus pu frequency deviations.'},
        'VOLT':  {'id':13,'output_name':'VOLT','description':'bus pu voltages (complex).', 'name':'volt', 'latex':'v_b'},
        'ITERM': {'id':21,'description':'', 'name':'iterm'},
        'VUEL':  {'id':23,'description':'minimum excitation limiter output signal (pu).', 'name':'vuel'},
        'VOEL':  {'id':24,'description':'maximum excitation limiter output signal (pu).', 'name':'voel'},
        'PLOAD ':{'id':25,'description':'', 'name':'p_load', 'latex':'p_l'},
        'QLOAD': {'id':26,'description':'', 'name':'q_load', 'latex':'q_l'},
        'GREF':  {'id':27,'description':'turbine governor reference.', 'name':'gref', 'latex':'p_g^\star'}
        }
       
        self.chan_ids = chan_ids
        # se definen los canales

        self.vip_chan_vars = ['ANGLE','SPEED','PELEC','QELEC']
        self.chan_vars = ['VOLT']
        
        for item in self.vip_chan_vars:             
            self.psspy.chsb(self.sid,0,[-1,-1,-1,1,chan_ids[item]['id'],0])
            
        for item in self.chan_vars:             
            self.psspy.chsb(0,1,[-1,-1,-1,1,chan_ids[item]['id'],0])

  
    def run_fault(self, bus_fault=1, fault_duration=0.05, to_bus=2, line_id='1 '):

        self.bus_fault =bus_fault
        self.fault_duration = fault_duration
        # se inicializa el sistema
        self.psspy.strt(0,self.outfile1)
        
        # comienza la simulacion
        self.psspy.run(0, 0.2,1000,1,0)
        
        # se aplica la falta
        self.psspy.dist_bus_fault(bus_fault,1, 400.0,[0.0,-0.2E+10])
        self.psspy.run(0, 0.2+fault_duration,1000,1,0)
        
        # se quita la falta y se quita la linea 
        self.psspy.dist_clear_fault(1)
        self.psspy.dist_branch_trip(bus_fault,to_bus,line_id)
        self.psspy.run(0, 5.0,1000,1,1)

        
        self.chnf = self.dyntools.CHNF(self.outfile1)

    def run_gen_trip(self, bus_gen=1, gen_id='1 '):

        self.bus_gen =bus_gen
        self.gen_id = gen_id
        # se inicializa el sistema
        self.psspy.strt(0,self.outfile1)
        
        # comienza la simulacion
        self.psspy.run(0, 0.2,1000,1,0)
        
        # se tripea el generador
        self.psspy.dist_machine_trip(self.bus_gen,self.gen_id)

        self.psspy.run(0, 5.0,1000,1,1)

        
        self.chnf = self.dyntools.CHNF(self.outfile1)
        
        
    def tear_down(self):
        '''
        theta_9  = np.array(chnf.get_data()[2][name2chan(chnf,'ANGL',  9)])
        theta_10 = np.array(chnf.get_data()[2][name2chan(chnf,'ANGL', 10)])
        theta_11 = np.array(chnf.get_data()[2][name2chan(chnf,'ANGL', 11)])
        theta_12 = np.array(chnf.get_data()[2][name2chan(chnf,'ANGL', 12)])
        speed_9  = np.array(chnf.get_data()[2][name2chan(chnf,'SPD',  9)])
        speed_10 = np.array(chnf.get_data()[2][name2chan(chnf,'SPD', 10)])
        speed_11 = np.array(chnf.get_data()[2][name2chan(chnf,'SPD', 11)])
        speed_12 = np.array(chnf.get_data()[2][name2chan(chnf,'SPD', 12)])
        volt_9  = np.array(chnf.get_data()[2][name2chan(chnf,'VOLT',  9)])
        volt_10 = np.array(chnf.get_data()[2][name2chan(chnf,'VOLT', 10)])
        volt_11 = np.array(chnf.get_data()[2][name2chan(chnf,'VOLT', 11)])
        volt_12 = np.array(chnf.get_data()[2][name2chan(chnf,'VOLT', 12)])
        p_gen_9  = np.array(chnf.get_data()[2][name2chan(chnf,'POWR',  9)])
        p_gen_10 = np.array(chnf.get_data()[2][name2chan(chnf,'POWR', 10)])
        p_gen_11 = np.array(chnf.get_data()[2][name2chan(chnf,'POWR', 11)])
        p_gen_12 = np.array(chnf.get_data()[2][name2chan(chnf,'POWR', 12)])
        q_gen_9  = np.array(chnf.get_data()[2][name2chan(chnf,'VARS',  9)])
        q_gen_10 = np.array(chnf.get_data()[2][name2chan(chnf,'VARS', 10)])
        q_gen_11 = np.array(chnf.get_data()[2][name2chan(chnf,'VARS', 11)])
        q_gen_12 = np.array(chnf.get_data()[2][name2chan(chnf,'VARS', 12)])
        vref_9  = np.array(chnf.get_data()[2][name2chan(chnf,'VREF',  9)])
        vref_10 = np.array(chnf.get_data()[2][name2chan(chnf,'VREF', 10)])
        vref_11 = np.array(chnf.get_data()[2][name2chan(chnf,'VREF', 11)])
        vref_12 = np.array(chnf.get_data()[2][name2chan(chnf,'VREF', 12)])
        p_ref_1 = np.array(chnf.get_data()[2][name2chan(chnf,'VAR', L_vsc_1+4)]) 
        q_ref_1 = np.array(chnf.get_data()[2][name2chan(chnf,'VAR', L_vsc_1+5)])
        p_ref_2 = np.array(chnf.get_data()[2][name2chan(chnf,'VAR', L_vsc_2+4)]) 
        q_ref_2 = np.array(chnf.get_data()[2][name2chan(chnf,'VAR', L_vsc_2+5)])
        p_ref_3 = np.array(chnf.get_data()[2][name2chan(chnf,'VAR', L_vsc_3+4)]) 
        q_ref_3 = np.array(chnf.get_data()[2][name2chan(chnf,'VAR', L_vsc_3+5)])
        '''

        t = np.array(self.chnf.get_data()[2]['time'])
        ierr, iarray = self.psspy.abusint(-1, 2, 'NUMBER')
        self.chan_data = {'t':t}
        buses = iarray[0]
        print buses
        for bus in buses:
            for var in self.chan_vars: 
                #print var, bus, name2chan(self.chnf,var,  bus)
                data = np.array(self.chnf.get_data()[2][name2chan(self.chnf,var,  bus)])
                name=self.chan_ids[var]['name'] + '_{:d}'.format(bus)
                self.chan_data.update({name:data})


        ierr, iarray = self.psspy.abusint(self.sid, 2, 'NUMBER')
        buses = iarray[0]
        print buses
        for bus in buses:
            for var in self.vip_chan_vars: 
                chan_id = name2chan(self.chnf,self.chan_ids[var]['output_name'],  bus)
                print var, bus, chan_id 
                data = np.array(self.chnf.get_data()[2][chan_id])
                name=self.chan_ids[var]['name'] + '_{:d}'.format(bus)
                self.chan_data.update({name:data})
                
                
    def report_fault(self):
        

        
        fig_delta_speed = plt.figure( figsize=(8, 8))
        fig_v = plt.figure( figsize=(8, 6))
        fig_pg_qg= plt.figure( figsize=(8, 8))
        
        ax_delta = fig_delta_speed.add_subplot(211)
        ax_speed = fig_delta_speed.add_subplot(212)        
        ax_V = fig_v.add_subplot(111)
        ax_pg = fig_pg_qg.add_subplot(211)
        ax_qg = fig_pg_qg.add_subplot(212)
        
        it_color = 0
        ls='solid'
        legend = []
        for bus in self.vip_buses:            
            ax_delta.plot(self.chan_data['t'], self.chan_data['theta_{:d}'.format(bus)], color=self.g_colors[it_color], ls=ls, lw=self.lw )
            legend += ['$\\theta_{{{:d}}}$'.format(bus)]
            it_color += 1
            if it_color>5: it_color=0
        ax_delta.set_xlim((self.chan_data['t'][0], self.chan_data['t'][-1]))
        ax_delta.legend(legend, loc='best', prop={'size':10})
        ax_delta.set_ylabel(u'Angle ()', color='k')
        ax_delta.grid(True)            
            
        it_color = 0
        ls='solid'
        legend = []
        for bus in self.vip_buses:            
            ax_speed.plot(self.chan_data['t'], self.chan_data['speed_{:d}'.format(bus)], color=self.g_colors[it_color], ls=ls, lw=self.lw )
            legend += ['$\\omega_{{{:d}}}$'.format(bus)]
            it_color += 1
            if it_color>5: it_color, ls =0 , 'dashed'
        ax_speed.set_xlim((self.chan_data['t'][0], self.chan_data['t'][-1]))
        ax_speed.legend(legend, loc='best', prop={'size':10})
        ax_speed.set_ylabel(u'Speed (pu)', color='k')
        ax_speed.grid(True)              
        ax_speed.set_xlabel('Time (s)', color='k')
    
        it_color = 0
        ls='solid'
        legend = []
        for bus in self.vip_buses:            
            ax_V.plot(self.chan_data['t'], self.chan_data['volt_{:d}'.format(bus)], color=self.g_colors[it_color], ls=ls, lw=self.lw )
            legend += ['$V_{{{:d}}}$'.format(bus)]
            it_color += 1
            if it_color>5: it_color, ls =0 , 'dashed'
        ax_V.set_xlim((self.chan_data['t'][0], self.chan_data['t'][-1]))
        ax_V.legend(legend, loc='best', prop={'size':10})
        ax_V.set_ylabel(u'Voltage (pu)', color='k')
        ax_V.grid(True)              
        ax_V.set_xlabel('Time (s)', color='k')
        
        it_color = 0
        legend_p = []
        legend_q = []
        for bus in self.vip_buses:            
            ax_pg.plot(self.chan_data['t'], self.chan_data['p_gen_{:d}'.format(bus)], color=self.g_colors[it_color], ls=ls, lw=self.lw )
            ax_qg.plot(self.chan_data['t'], self.chan_data['q_gen_{:d}'.format(bus)], color=self.g_colors[it_color], ls=ls, lw=self.lw )
            legend_p += ['$p_{{g{:d}}}$'.format(bus)]
            legend_q += ['$q_{{g{:d}}}$'.format(bus)]
            it_color += 1
            if it_color>5: it_color, ls =0 , 'dashed'
        ax_pg.set_xlim((self.chan_data['t'][0], self.chan_data['t'][-1]))
        ax_qg.set_xlim((self.chan_data['t'][0], self.chan_data['t'][-1]))
        ax_pg.legend(legend_p, loc='best', prop={'size':10})
        ax_qg.legend(legend_q, loc='best', prop={'size':10})
        ax_pg.set_ylabel(u'Active Power (pu)', color='k')
        ax_qg.set_ylabel(u'Reactive Power (pu)', color='k')        
        ax_pg.grid(True)              
        ax_qg.grid(True)         
        ax_qg.set_xlabel('Time (s)', color='k')
        
        
        fig_file = 'fault_delta_speed_bus{:d}_{:d}ms.svg'.format(self.bus_fault, int(self.fault_duration*1000))
        fig_delta_speed.savefig(os.path.join(self.case_dir,fig_file))
        
        fig_file = 'fault_volt_bus{:d}_{:d}ms.svg'.format(self.bus_fault, int(self.fault_duration*1000))
        fig_v.savefig(os.path.join(self.case_dir,fig_file))
        
        fig_file = 'fault_pg_qg_bus{:d}_{:d}ms.svg'.format(self.bus_fault, int(self.fault_duration*1000))
        fig_pg_qg.savefig(os.path.join(self.case_dir,fig_file))
        




    def report_gen_trip(self):
        fig_delta_speed = plt.figure( figsize=(8, 8))
        fig_v = plt.figure( figsize=(8, 6))
        fig_pg_qg= plt.figure( figsize=(8, 8))
        
        ax_delta = fig_delta_speed.add_subplot(211)
        ax_speed = fig_delta_speed.add_subplot(212)        
        ax_V = fig_v.add_subplot(111)
        ax_pg = fig_pg_qg.add_subplot(211)
        ax_qg = fig_pg_qg.add_subplot(212)
        
        it_color = 0
        ls='solid'
        legend = []
        for bus in self.vip_buses:            
            ax_delta.plot(self.chan_data['t'], self.chan_data['theta_{:d}'.format(bus)], color=self.g_colors[it_color], ls=ls, lw=self.lw )
            legend += ['$\\theta_{{{:d}}}$'.format(bus)]
            it_color += 1
            if it_color>5: it_color, ls =0 , 'dashed'
        ax_delta.set_xlim((self.chan_data['t'][0], self.chan_data['t'][-1]))
        ax_delta.legend(legend, loc='best', prop={'size':10})
        ax_delta.set_ylabel(u'Angle ()', color='k')
        ax_delta.grid(True)            
            
        it_color = 0
        ls='solid'
        legend = []
        for bus in self.vip_buses:            
            ax_speed.plot(self.chan_data['t'], self.chan_data['speed_{:d}'.format(bus)], color=self.g_colors[it_color], ls=ls, lw=self.lw )
            legend += ['$\\omega_{{{:d}}}$'.format(bus)]
            it_color += 1
            if it_color>5: it_color, ls =0 , 'dashed'
        ax_speed.set_xlim((self.chan_data['t'][0], self.chan_data['t'][-1]))
        ax_speed.legend(legend, loc='best', prop={'size':10})
        ax_speed.set_ylabel(u'Speed (pu)', color='k')
        ax_speed.grid(True)              
        ax_speed.set_xlabel('Time (s)', color='k')
    
        it_color = 0
        ls='solid'
        legend = []
        for bus in self.vip_buses:            
            ax_V.plot(self.chan_data['t'], self.chan_data['volt_{:d}'.format(bus)], color=self.g_colors[it_color], ls=ls, lw=self.lw )
            legend += ['$V_{{{:d}}}$'.format(bus)]
            it_color += 1
            if it_color>5: it_color, ls =0 , 'dashed'
        ax_V.set_xlim((self.chan_data['t'][0], self.chan_data['t'][-1]))
        ax_V.legend(legend, loc='best', prop={'size':10})
        ax_V.set_ylabel(u'Voltage (pu)', color='k')
        ax_V.grid(True)              
        ax_V.set_xlabel('Time (s)', color='k')
        
        it_color = 0
        ls='solid'
        legend_p = []
        legend_q = []
        for bus in self.vip_buses:            
            ax_pg.plot(self.chan_data['t'], self.chan_data['p_gen_{:d}'.format(bus)], color=self.g_colors[it_color], ls=ls, lw=self.lw )
            ax_qg.plot(self.chan_data['t'], self.chan_data['q_gen_{:d}'.format(bus)], color=self.g_colors[it_color], ls=ls, lw=self.lw )
            legend_p += ['$p_{{g{:d}}}$'.format(bus)]
            legend_q += ['$q_{{g{:d}}}$'.format(bus)]
            it_color += 1
            if it_color>5: it_color, ls =0 , 'dashed'
        ax_pg.set_xlim((self.chan_data['t'][0], self.chan_data['t'][-1]))
        ax_qg.set_xlim((self.chan_data['t'][0], self.chan_data['t'][-1]))
        ax_pg.legend(legend_p, loc='best', prop={'size':10})
        ax_qg.legend(legend_q, loc='best', prop={'size':10})
        ax_pg.set_ylabel(u'Active Power (pu)', color='k')
        ax_qg.set_ylabel(u'Reactive Power (pu)', color='k')        
        ax_pg.grid(True)              
        ax_qg.grid(True)         
        ax_qg.set_xlabel('Time (s)', color='k')

        fig_file = 'gen_trip_delta_speed_gen_bus{:d}.svg'.format(self.bus_gen)
        fig_delta_speed.savefig(os.path.join(self.case_dir,fig_file))

        fig_file = 'gen_trip_volt_gen_bus{:d}.svg'.format(self.bus_gen)
        fig_v.savefig(os.path.join(self.case_dir,fig_file))

        fig_file = 'gen_trip_pg_qg_gen_bus{:d}.svg'.format(self.bus_gen)
        fig_pg_qg.savefig(os.path.join(self.case_dir,fig_file))  
        
        
def report_gen_trip_compare(test_list):
    
    # frequency determination
    speed_media = []
    t_list = []
    legends = []
    it = 0
    for test in test_list:
        for bus in test.vip_buses: 
            speed = test.chan_data['speed_{:d}'.format(bus)]
            if it == 0:
                speeds = speed
            else:
                speeds = np.vstack((speeds, speed))
            it += 1  
        
        legends += [test.legend]        
        speed_media += [np.sum(speeds, axis=0)]
        t = np.array(test.chan_data['t'])
        print t.shape
        t_list += [t]

        fig_speeds = plt.figure( figsize=(6, 4))
      
        ax_speed = fig_speeds.add_subplot(111) 

        it_color = 0
        ls='solid'
        for speed in speed_media:  
            ax_speed.plot(t,speed, color=test.g_colors[it_color], ls=ls, lw=test.lw )
            it_color += 1
            if it_color>5: it_color, ls =0 , 'dashed'
        ax_speed.set_xlim(t[0], t[-1])
        ax_speed.legend(legends, loc='best', prop={'size':10})
        ax_speed.set_ylabel(u'Speed (pu)', color='k')
        ax_speed.grid(True)              
        ax_speed.set_xlabel('Time (s)', color='k')
        
        fig_file = 'gen_trip_speeds.svg'.format(test.bus_gen)
        fig_speeds.savefig(os.path.join(test.case_dir,fig_file)) 
        
        




       
if __name__ == "__main__":

    case_dir = r'E:\jmmauricio\Documents\public\jmmauricio6\RESEARCH\benches\ieee_12_generic\data\ieee12_generic_ac_7_8'
    dll_dir  = r'E:\jmmauricio\Documents\public\jmmauricio6\RESEARCH\benches\ieee_12_generic\data\ieee12_generic_ac_7_8'
    ps_tools_dir  = r'E:\jmmauricio\Documents\public\jmmauricio6\RESEARCH\benches\ieee_12_generic\ps_tools'
    dya_dir = 'avr_pss'
    
#    test_fault = test()
#    test_fault.setup('ieee12_generic_ac_7_8', case_dir, dll_dir, ps_tools_dir, dya_dir)
#    
#    test_fault.setup_pf()
#    test_fault.setup_dyn([9,10,11,12]) 
#    test_fault.run_fault(bus_fault=1, fault_duration=0.05, to_bus=6, line_id='1 ')
#    test_fault.tear_down()
#    test_fault.report_fault()
#
#    test_fault.setup_pf()
#    test_fault.setup_dyn([9,10,11,12]) 
#    test_fault.run_fault(bus_fault=1, fault_duration=0.1, to_bus=6, line_id='1 ')
#    test_fault.tear_down()
#    test_fault.report_fault()

    

    
