# Copyright (c) 2014, Riverbank Computing Limited
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
# 
# 1. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# 
# 2. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# 
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.


from .metadata import Metadata


class PyQt5Metadata(Metadata):
    """ Encapsulate the meta-data for a single PyQt5 module. """

    def __init__(self, group='base', deps=(), qt=(), config=()):
        """ Initialise the object. """

        super().__init__(group=group, deps=deps, qt=qt, config=config,
                needs_suffix=False)


# The dictionary of meta-data for the PyQt5 modules.
pyqt5_metadata = {
    'QAxContainer':             PyQt5Metadata(
                                    deps=['QtWidgets'],
                                    qt=['axcontainer']),

    'Qt':                       PyQt5Metadata(),

    'QtBluetooth':              PyQt5Metadata(
                                    deps=['QtCore'],
                                    qt=['bluetooth']),

    'QtCore':                   PyQt5Metadata(
                                    qt=['-gui']),

    'QtDBus':                   PyQt5Metadata(
                                    deps=['QtCore'],
                                    qt=['dbus', '-gui']),

    'QtDesigner':               PyQt5Metadata(
                                    deps=['QtWidgets'],
                                    qt=['designer']),

    'QtGui':                    PyQt5Metadata(
                                    deps=['QtCore']),

    'QtHelp':                   PyQt5Metadata(
                                    deps=['QtWidgets'],
                                    qt=['help']),

    'QtMacExtras':              PyQt5Metadata(
                                    deps=['QtCore'],
                                    qt=['macextras']),

    'QtMultimedia':             PyQt5Metadata(
                                    deps=['QtGui', 'QtNetwork'],
                                    qt=['multimedia']),

    'QtMultimediaWidgets':      PyQt5Metadata(
                                    deps=['QtMultimedia', 'QtWidgets'],
                                    qt=['multimediawidgets', 'multimedia']),

    'QtNetwork':                PyQt5Metadata(
                                    deps=['QtCore'],
                                    qt=['network', '-gui']),

    'QtOpenGL':                 PyQt5Metadata(
                                    deps=['QtWidgets'],
                                    qt=['opengl']),

    'QtPositioning':            PyQt5Metadata(
                                    deps=['QtCore'],
                                    qt=['positioning']),

    'QtPrintSupport':           PyQt5Metadata(
                                    deps=['QtWidgets'],
                                    qt=['printsupport']),

    'QtQml':                    PyQt5Metadata(
                                    deps=['QtNetwork'],
                                    qt=['qml']),

    'QtQuick':                  PyQt5Metadata(
                                    deps=['QtGui', 'QtQml'],
                                    qt=['quick']),

    'QtSensors':                PyQt5Metadata(
                                    deps=['QtCore'],
                                    qt=['sensors']),

    'QtSerialPort':             PyQt5Metadata(
                                    deps=['QtCore'],
                                    qt=['serialport']),

    'QtSql':                    PyQt5Metadata(
                                    deps=['QtWidgets'],
                                    qt=['sql', 'widgets']),

    'QtSvg':                    PyQt5Metadata(
                                    deps=['QtWidgets'],
                                    qt=['svg']),

    'QtTest':                   PyQt5Metadata(
                                    deps=['QtWidgets'],
                                    qt=['testlib', 'widgets']),

    'QtWebKit':                 PyQt5Metadata(
                                    deps=['QtGui', 'QtNetwork'],
                                    qt=['webkit', 'network']),

    'QtWebKitWidgets':          PyQt5Metadata(
                                    deps=['QtPrintSupport', 'QtWebKit'],
                                    qt=['webkitwidgets']),

    'QtWidgets':                PyQt5Metadata(
                                    deps=['QtGui'],
                                    qt=['widgets']),

    'QtWinExtras':              PyQt5Metadata(
                                    deps=['QtWidgets'],
                                    qt=['winextras', 'widgets']),

    'QtX11Extras':              PyQt5Metadata(
                                    deps=['QtCore'],
                                    qt=['x11extras']),

    'QtXmlPatterns':            PyQt5Metadata(
                                    deps=['QtNetwork'],
                                    qt=['xmlpatterns', '-gui', 'network']),

    'uic':                      PyQt5Metadata(
                                    deps=['QtWidgets']),

    '_QOpenGLFunctions_2_0':    PyQt5Metadata(
                                    group='opengl',
                                    deps=['QtGui']),

    '_QOpenGLFunctions_ES2':    PyQt5Metadata(
                                    group='opengl',
                                    deps=['QtGui']),

    'QtChart':                  PyQt5Metadata(
                                    group='addon',
                                    deps=['QtWidgets'],
                                    config=['qtcommercialchart']),

    'QtDataVisualization':      PyQt5Metadata(
                                    group='addon',
                                    deps=['QtGui'],
                                    qt=['datavisualization']),

    'Qsci':                     PyQt5Metadata(
                                    group='addon',
                                    deps=['QtWidgets'],
                                    config=['qscintilla2']),
}
