#!/usr/bin/env python
# -*- coding: utf-8 -*-

from setuptools import setup, find_packages

def _read(file_name):
    sock = open(file_name)
    text = sock.read()
    sock.close()
    return text


setup(
    name='pyramid_simpleauth',
    version='0.6',
    description='Session based authentication and role based security \
                   for a Pyramid web application.',
    author='James Arthur',
    author_email='username: thruflo, domain: gmail.com',
    url='http://github.com/thruflo/pyramid_simpleauth',
    classifiers=[
        'Development Status :: 3 - Alpha',
        'Environment :: Web Environment',
        'Intended Audience :: Developers',
        'License :: Public Domain',
        'Natural Language :: English',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Programming Language :: Python :: 2.6',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.2',
        'Framework :: Pylons',
        'Topic :: Internet :: WWW/HTTP',
        'Topic :: Internet :: WWW/HTTP :: WSGI',
        'Topic :: Software Development :: Libraries :: Python Modules',
    ],
    license=_read('UNLICENSE').split('\n')[0],
    packages=find_packages('src'),
    package_dir={'': 'src'},
    include_package_data=True,
    zip_safe=False,
    install_requires=[
        'pyramid_basemodel',
        'pyramid_simpleform',
        'pyramid',
        'SQLAlchemy',
        'formencode',
        'passlib',
        'pyDNS',
    ]
)
