import os
from distutils.core import setup

long_description = '''
====
pyriodic
====

is a scheduler written in Python using dateutil to run periodic jobs.

This project was just started and is in the alpha stage so there is a lot yet to do.
It is coded in Python 3.3; other versions of Python have yet to be tested.

Schedule recurring jobs by specifying at least a desired interval from dateutil's rrule module.
Or schedule delayed jobs to run after any number of hours, minutes, seconds etc.

Intervals included are:
    * YEARLY (haven't had the *time* to test this one out yet)
    * MONTHLY (nor this one)
    * DAILY
    * HOURLY
    * MINUTELY
    * SECONDLY

Other parameters include:
    * string "start_date" (defaults to today's date)
    * string "start_time" (defaults to midnight)
    * integer "how_many" intervals to run (default is infinite)
    * integer "retrys" upon exceptions (default is 3 times)
    * integer "retry_delay" seconds to delay next run time after exception (default is 10 seconds right now)
    * string "name" the name that the job can then be refered to as (defaults to function name)

Start dates and times are parsed by dateutil so it is flexible in what it excepts.
Go to http://ayehavgunne.github.io/pyriodic/ for more information.
'''
if os.path.exists('README.rst'):
    with open('README.rst', 'r') as readme:
        long_description = readme.read()

setup(name='pyriodic',
      version='0.2.3',
      py_modules=['pyriodic/pyriodic', 'pyriodic/settings'],
      author='Anthony Post',
      author_email='postanthony3000 at gmail com',
      maintainer='Anthony Post',
      maintainer_email='postanthony3000 at gmail com',
      url='http://ayehavgunne.github.io/pyriodic/',
      download_url='http://ayehavgunne.github.io/pyriodic/',
      description='A scheduler written in Python using dateutil for periodic jobs.',
      long_description=long_description,
      license='Simplified BSD',
      keywords='schedule periodic job',
      classifiers=[
          'Development Status :: 2 - Pre-Alpha',
          'Programming Language :: Python :: 3.3',
          'Intended Audience :: Developers'
      ],
      requires=['dateutils']
)