import os
import sys
from distutils.core import setup


version = '0.2.4'

long_description = '''
====
pyriodic
====

is a scheduler written in Python using dateutil to run periodic jobs.

This project was just started and is in the alpha stage so there is a lot yet to do.
It is coded in Python 3.3; other versions of Python have yet to be tested.

Schedule recurring jobs by specifying at least a desired interval from dateutil's rrule module.
Or schedule delayed jobs to run after any number of hours, minutes, seconds etc.

Intervals included are:
    * YEARLY (haven't had the *time* to test this one out yet)
    * MONTHLY (nor this one)
    * DAILY
    * HOURLY
    * MINUTELY
    * SECONDLY

Other parameters include:
    * string "start_date" (defaults to today's date)
    * string "start_time" (defaults to midnight)
    * integer "how_many" intervals to run (default is infinite)
    * integer "retrys" upon exceptions (default is 3 times)
    * integer "retry_delay" seconds to delay next run time after exception (default is 10 seconds right now)
    * string "name" the name that the job can then be refered to as (defaults to function name)

Start dates and times are parsed by dateutil so it is flexible in what it excepts.
Go to http://ayehavgunne.github.io/pyriodic/ for more information.
'''
if os.path.exists('README.rst'):
    with open('README.rst', 'r') as text:
        long_description = text.read()

bsd_license = 'Simplified BSD'

if os.path.exists('LICENSE'):
    with open('LICENSE', 'r') as text:
        bsd_license = text.read()

setup(name='pyriodic',
      version=version,
      py_modules=['pyriodic/pyriodic', 'pyriodic/__init__'],
      author='Anthony Post',
      author_email='postanthony3000 at gmail com',
      maintainer='Anthony Post',
      maintainer_email='postanthony3000 at gmail com',
      url='http://ayehavgunne.github.io/pyriodic/',
      download_url='http://ayehavgunne.github.io/pyriodic/',
      description='A scheduler that uses dateutil to run periodic jobs.',
      long_description=long_description,
      requires=['dateutils'],
      license=bsd_license,
      keywords='schedule periodic job task time timer thread calendar clock queue dateutil',
      classifiers=[
          'Development Status :: 2 - Pre-Alpha',
          'Programming Language :: Python :: %s.%s' % (sys.version_info[0], sys.version_info[1]),
          'Intended Audience :: Developers'
      ]
)