import time, sys
from datetime import datetime

from pyriodic.pyriodic import Scheduler, HOURLY, MINUTELY


pkgdir = {'': 'python%s%s' % (sys.version_info[0], sys.version_info[1])}
print(pkgdir)
print('Program starting at', datetime.now())
sched = Scheduler()
message = 'Hello from argumentland.'
message2 = 'Gone with the day.'


def run_test1(mes):
    print('This is test 1.', mes, datetime.now())
    return mes


@sched.schedule_recuring_job(interval=MINUTELY, start_time='32m 30S')
def run_test2():
    print('This is test 2.', datetime.now())


def run_test3(mes):
    print('This is test 3.', mes, datetime.now())
    raise TypeError('Testing out error handling')


@sched.schedule_delayed_job(hours=2, minutes=1)
def run_test4():
    print('This is test 4.', datetime.now())


def run_test5(mes):
    print('This is test 5.', mes, datetime.now())

sched.add_recuring_job(run_test1, args=(message,), interval=MINUTELY)
run_test2()
sched.add_recuring_job(run_test3, args=(message2,), interval=HOURLY, start_time='9:00:45 AM')
run_test4()
sched.add_delayed_job(run_test5, args=(message2,), days=1)


class TestClass:
    count = 0

    @sched.schedule_recuring_job(interval=HOURLY, how_many=1, name='MyLittleMethod')
    def run_test6(self):
        print('This is test 6.', datetime.now())

    def run_test7(self):
        print('This is test 7.', datetime.now())

    @sched.schedule_delayed_job(seconds=5)
    def run_test8(self, mes):
        print('This is test 8.', mes, datetime.now())
        self.count += 1
        return 'Message: %s Count: %s' % (mes, self.count)

TestClass().run_test6()
sched.add_recuring_job(TestClass().run_test7, interval=MINUTELY, start_time='15S')
TestClass().run_test8(message)


class TestClass2:
    def __init__(self, mes):
        self.mes = mes
        print('This is test Class 2.', self.mes, datetime.now())

sched.add_recuring_job(TestClass2, args=(message2,), interval=MINUTELY)

print('Going to sleep')
sched.remove_job('thisjobdontexist')
time.sleep(60)
print('Done sleeping')
print(sched.get_results('run_test1'))
sched.remove_job('run_test1')
sched.remove_job(run_test2)
sched.remove_job('MyLittleMethod')
print(sched.get_results(TestClass.run_test8))