# This setup.py was generated automatically by Pyron.
# For details, see http://pypi.python.org/pypi/pyron/

from setuptools import setup, find_packages

setup(
    name = 'pyron',
    version = '0.2',
    description = u'The DRY Python package builder',
    long_description = u'\nPyron is a simple tool that lets you develop and distribute Python\npackages while avoiding the complexity of writing and maintaining a\n"setup.py" file.  With Pyron, each package you are developing needs only\na small ``pyron.ini`` file, whose format is designed to help you avoid\nrepeating yourself.\n\nDeveloping with Pyron\n---------------------\n\nTo see Pyron in action, install Ian Bicking\'s virtualenv_ tool and\ncreate a virtual environment to serve as your development environment.\nInstall the Pyron package there. ::\n\n    $ virtualenv dev\n    $ cd dev\n    $ source bin/activate\n    (dev)$ ls\n    bin/  include/  lib/\n    (dev)$ pip install pyron\n    ...\n    Successfully installed argparse pyron\n\nTwo packages that are currently developed using Pyron, and that we can\nuse here as samples, are the ``cursive`` tools that you might have seen\non the `Python Package Index`_.  You can check out their development\ntrees very simply, using Mercurial::\n\n    (dev)$ hg clone http://bitbucket.org/brandon/cursivepymag\n    (dev)$ hg clone http://bitbucket.org/brandon/cursivetools\n    (dev)$ ls\n    bin/  cursivepymag/  cursivetools/  include/  lib/\n\nYou can always identify a Pyron-powered development package because it\nwill have a ``pyron.ini`` file at the top level. ::\n\n    (dev)$ ls cursivetools\n    README.txt  __init__.py  cursive.py  entry_points.ini  pyron.ini  wc.py\n\nThe ``pyron.ini`` file contains all of the essential metadata about a\nproject that cannot be easily introspected from its contents::\n\n    (dev)$ cat cursivetools/pyron.ini\n    [package]\n    name = cursive.tools\n    author = Brandon Craig Rhodes <brandon@rhodesmill.org>\n    url = http://bitbucket.org/brandon/cursivetools/\n    requires = docutils\n\nThe version, however, is taken directly from the ``__version__`` symbol\nin the package\'s ``__init__.py`` file, to avoid having to maintain the\nsame version number in two different places. ::\n\n    (dev)$ grep __version__ cursivetools/__init__.py\n    __version__ = \'0.3\'\n\nThe description that is placed on the Python Package Index for this\npackage will be copied verbatim from ``README.txt``, which should start\nwith a title that can be used for the short summary description on the\nPackage Index::\n\n    (dev)$ head -6 cursivetools/README.txt\n    \n    Tools for authoring restructured text files\n    ===========================================\n    \n    This package provides a ``cursive`` command that is intended to become\n    the core of a whole set of tools for working with `reStructured Text`_\n\nBy pulling version information from the package\'s code and documentation\nfrom its ``README.txt``, Pyron not only enforces good Python community\ncustoms, but it avoids either making the developer repeat the same\ninformation in several different places, or else write complicated\n``setup.py`` code to pull the information in from elsewhere.\n\nActivating Development Packages\n-------------------------------\n\nWhen developing a package, you not only need its files on your hard\ndrive, but you need for Python itself to be able to see the package.\nThis involves three things:\n\n* Python should be able to import the package.\n* The package\'s entry points should be available.\n* Any console scripts the package declares should be installed.\n\nNone of these three things are true yet of the development packages in\nour example, because Python cannot yet see them. ::\n\n    (dev)$ python -c \'import cursive.tools\'\n    Traceback (most recent call last):\n      ...\n    ImportError: No module named cursive.tools\n\nTo make the development copy of this package "appear" in our virtual\nenvironment, we have to use the Pyron command-line tool to activate it.\nYou can use the Pyron "status" (abbreviated "st") command to see which\ndevelopment packages are currently active in the virtual environment,\nand the "add" command to activate further projects::\n\n    (dev)$ pyron status\n    No packages are under development in this environment.\n    (dev)$ pyron add cursivetools \n    (dev)$ pyron status\n    /home/brandon/dev/cursivetools\n        Package: cursive.tools\n        Console-script: cursive (cursive.tools.cursive:console_script_cursive)\n\nAs you can see from the "status" command, the ``cursive.tools`` package\nis now under active development.  This means that Python will now be\nable to import it!  You can verify that Python is now loading the\npackage directly from its development directory::\n\n    (dev)$ python\n    >>> import cursive.tools\n    >>> cursive.tools.__file__\n    \'/home/brandon/dev/cursivetools/__init__.py\'\n    >>> exit()\n\nAnd the console script declared by ``cursive.tools`` is now available in\nthe virtual environment as well. ::\n\n    (dev)$ bin/cursive\n    Usage: cursive [options] <command> [options]\n    ...\n    Available Commands:\n\n     wc - Word count\n\nThe above output shows both that the ``cursive.tools`` package is fully\nup and running, and also that its one built-in entry point, that defines\nthe "wc" sub-command, is active as well.  To add another entry point, we\ncan activate the ``cursive.pymag`` package that we downloaded earlier as\nwell::\n\n    (dev)$ pyron add cursivepymag\n    (dev)$ pyron st\n    /home/brandon/dev/cursivetools\n        Package: cursive.tools\n            Console-script: cursive (cursive.tools.cursive:console_script_cursive)\n\n    /home/brandon/dev/cursivepymag\n        Package: cursive.pymag\n\n    (dev)$ bin/cursive\n    Usage: cursive [options] <command> [options]\n    ...\n    Available Commands:\n\n     pymag - Convert an RST document to Python Magazine Ceres markup\n     wc    - Word count\n\nYou can see that a second sub-command, "pymag", is available because the\n``cursive.pymag`` package declares an entry point for it.  Activating a\ndevelopment project with Pyron has all of the old advantages of running\na ``setup.py`` with the ``develop`` sub-command, but has the additional\nfeatures that metadata is always pulled live from the ``pyron.ini`` file\n(rather than being copied into an ``egg-info`` directory and growing\nstale), and that you can easily turn packages back off.  You can turn\nthem off with the "remove" or "rm" sub-command by either naming their\ndirectory, or using the package name itself::\n\n    (dev)$ pyron rm ./cursivepymag\n    (dev)$ pyron rm cursive.tools\n    (dev)$ pyron st\n    No packages are under development in this environment.\n    (dev)$ python -c \'import cursive.tools\'\n    Traceback (most recent call last):\n      ...\n    ImportError: No module named cursive.tools\n    (dev)$ bin/cursive\n    zsh: no such file or directory: bin/cursive\n\nThis makes it easy to quickly adjust the mix of active development\npackages as you write and test your code.\n\nDeploying Packages\n------------------\n\nSharing a Python package with other people typically has two steps: you\nneed to first *register* the package on the `Python Package Index`_ so\nthat its name, description, and other metadata shows up, and then you\nneed to provide a ``.tar.gz`` file that other people can download and\ninstall using ``pip`` or ``easy_install``.  These two steps are quite\neasy to accomplish using Pyron::\n\n    (dev)$ pyron register cursivetools\n    (dev)$ pyron upload cursivetools\n\nWith both of these sub-commands, and in fact with most Pyron commands,\nyou should follow the command with the names of one or more directories\nwhere a Pyron-powered development package lives.  If you provide no\ndirectory name, then the current directory is searched, so the two\ncommands above could also have been written::\n\n    (dev)$ cd cursivetools\n    (dev)$ pyron register\n    (dev)$ pyron upload\n    (dev)$ cd ..\n\nIf you want the source distribution written to a local file without\nbeing made available yet for the entire world, use the "sdist"\nsub-command.  It prints out the name of the file it creates. ::\n\n    (dev)$ pyron sdist cursivetools\n    ./cursive.tools-0.3.tar.gz\n\nNote that when Pyron builds a ``.tar.gz`` distribution, it includes\nmost of the files in the development package, except that Pyron:\n\n* Ignores hidden files that begin with a period.\n* Ignores files whose names end with ``.pyc`` and ``.pyo``.\n* Does not include the ``pyron.ini`` file.\n* Does not include the ``entry_points.ini`` file (if any).\n\nBefore you run the "sdist" or "upload" sub-command, therefore, you\nshould make sure that no temporary data or other unnecessary files are\nsitting inside of the development package\'s directory, or those files\nwill be included in the archive.\n\nNote that Pyron has *no* provision for building, or distributing,\nC-language extensions or shared libraries or other binary code that has\nto be compiled.  If your package needs to be compiled to operate, then\nyou should use the normal ``setup.py`` mechanism; that\'s what it\'s good\nfor: situations that are already complicated, where you need lots of\ncontrol over a difficult build process.  Pyron, by constrast, is\nintended only for distributing pure-Python packages.\n\n\n.. _virtualenv: http://pypi.python.org/pypi/virtualenv/\n.. _Python Package Index: http://pypi.python.org/pypi/\n',
    author = 'Brandon Craig Rhodes',
    author_email = 'brandon@rhodesmill.org',
    url = 'http://bitbucket.org/brandon/pyron/',
    classifiers = ['Development Status :: 4 - Beta', 'Environment :: Console', 'Intended Audience :: Developers', 'License :: OSI Approved :: GNU General Public License (GPL)', 'Programming Language :: Python', 'Topic :: Software Development :: Build Tools'],

    package_dir = {'': 'src'},
    packages = find_packages('src'),
    include_package_data = True,
    install_requires = ['argparse'],
    entry_points = '[console_scripts]\npyron = pyron.command:main\n',
    )
