# wrap SDL functions for error checking and shorter names.
from __future__ import (print_function, division, absolute_import)

class SDLError(Exception):
    pass

from functools import wraps

from .cdefs import ffi
from .dso import _LIB

class SDLError(Exception):
    pass

__missing_functions = []

def get_missing_functions():
    return __missing_functions

def wrapstr(result):
    if result:
        return ffi.string(result)
    return None

def wrap_retstr(func):
    def wrapper(*argv):
        return wrapstr(func(*argv))
    return wrapper

def lookup(name):
    if hasattr(_LIB, name):
        return getattr(_LIB, name)
    __missing_functions.append(name)
    return None

ignore_errors = False

def check_error():
    error = ffi.string(_LIB.SDL_GetError())
    if error:
        _LIB.SDL_ClearError()
        if ignore_errors:
            return
        raise SDLError, error

def guard(func):
    if not func:
        return None
    if isinstance(func, int):
        return func
    name = repr(func)
    def newfunc(*args):
        result = func(*args)
        check_error()
        return result
    newfunc.func_name = name
    newfunc.__doc__ = func.__doc__
    return newfunc

def register(name, dsoname):
    globals()[dsoname] = guard(lookup(dsoname))

register('getPlatform', 'SDL_GetPlatform')
register('malloc', 'SDL_malloc')
register('calloc', 'SDL_calloc')
register('realloc', 'SDL_realloc')
register('free', 'SDL_free')
register('getenv', 'SDL_getenv')
register('setenv', 'SDL_setenv')
register('qsort', 'SDL_qsort')
register('abs', 'SDL_abs')
register('isdigit', 'SDL_isdigit')
register('isspace', 'SDL_isspace')
register('toupper', 'SDL_toupper')
register('tolower', 'SDL_tolower')
register('memset', 'SDL_memset')
register('memcpy', 'SDL_memcpy')
register('memmove', 'SDL_memmove')
register('memcmp', 'SDL_memcmp')
register('wcslen', 'SDL_wcslen')
register('wcslcpy', 'SDL_wcslcpy')
register('wcslcat', 'SDL_wcslcat')
register('strlen', 'SDL_strlen')
register('strlcpy', 'SDL_strlcpy')
register('utf8strlcpy', 'SDL_utf8strlcpy')
register('strlcat', 'SDL_strlcat')
register('strdup', 'SDL_strdup')
register('strrev', 'SDL_strrev')
register('strupr', 'SDL_strupr')
register('strlwr', 'SDL_strlwr')
register('strchr', 'SDL_strchr')
register('strrchr', 'SDL_strrchr')
register('strstr', 'SDL_strstr')
register('itoa', 'SDL_itoa')
register('uitoa', 'SDL_uitoa')
register('ltoa', 'SDL_ltoa')
register('ultoa', 'SDL_ultoa')
register('lltoa', 'SDL_lltoa')
register('ulltoa', 'SDL_ulltoa')
register('atoi', 'SDL_atoi')
register('atof', 'SDL_atof')
register('strtol', 'SDL_strtol')
register('strtoul', 'SDL_strtoul')
register('strtoll', 'SDL_strtoll')
register('strtoull', 'SDL_strtoull')
register('strtod', 'SDL_strtod')
register('strcmp', 'SDL_strcmp')
register('strncmp', 'SDL_strncmp')
register('strcasecmp', 'SDL_strcasecmp')
register('strncasecmp', 'SDL_strncasecmp')
register('sscanf', 'SDL_sscanf')
register('snprintf', 'SDL_snprintf')
register('vsnprintf', 'SDL_vsnprintf')
register('atan', 'SDL_atan')
register('atan2', 'SDL_atan2')
register('ceil', 'SDL_ceil')
register('copysign', 'SDL_copysign')
register('cos', 'SDL_cos')
register('cosf', 'SDL_cosf')
register('fabs', 'SDL_fabs')
register('floor', 'SDL_floor')
register('log', 'SDL_log')
register('pow', 'SDL_pow')
register('scalbn', 'SDL_scalbn')
register('sin', 'SDL_sin')
register('sinf', 'SDL_sinf')
register('sqrt', 'SDL_sqrt')
register('iconv_open', 'SDL_iconv_open')
register('iconv_close', 'SDL_iconv_close')
register('iconv', 'SDL_iconv')
register('iconv_string', 'SDL_iconv_string')
register('main', 'SDL_main')
register('setMainReady', 'SDL_SetMainReady')
register('reportAssertion', 'SDL_ReportAssertion')
register('assert_state', 'SDL_assert_state')
register('setAssertionHandler', 'SDL_SetAssertionHandler')
register('getAssertionReport', 'SDL_GetAssertionReport')
register('resetAssertionReport', 'SDL_ResetAssertionReport')
register('atomicTryLock', 'SDL_AtomicTryLock')
register('atomicLock', 'SDL_AtomicLock')
register('atomicUnlock', 'SDL_AtomicUnlock')
register('setError', 'SDL_SetError')
register('getError', 'SDL_GetError')
register('clearError', 'SDL_ClearError')
register('error', 'SDL_Error')
register('createMutex', 'SDL_CreateMutex')
register('lockMutex', 'SDL_LockMutex')
register('tryLockMutex', 'SDL_TryLockMutex')
register('unlockMutex', 'SDL_UnlockMutex')
register('destroyMutex', 'SDL_DestroyMutex')
register('createSemaphore', 'SDL_CreateSemaphore')
register('destroySemaphore', 'SDL_DestroySemaphore')
register('semWait', 'SDL_SemWait')
register('semTryWait', 'SDL_SemTryWait')
register('semWaitTimeout', 'SDL_SemWaitTimeout')
register('semPost', 'SDL_SemPost')
register('semValue', 'SDL_SemValue')
register('createCond', 'SDL_CreateCond')
register('destroyCond', 'SDL_DestroyCond')
register('condSignal', 'SDL_CondSignal')
register('condBroadcast', 'SDL_CondBroadcast')
register('condWait', 'SDL_CondWait')
register('condWaitTimeout', 'SDL_CondWaitTimeout')

register('getThreadName', 'SDL_GetThreadName')
register('threadID', 'SDL_ThreadID')
register('getThreadID', 'SDL_GetThreadID')
register('setThreadPriority', 'SDL_SetThreadPriority')
register('waitThread', 'SDL_WaitThread')
register('tLSCreate', 'SDL_TLSCreate')
register('tLSGet', 'SDL_TLSGet')
register('tLSSet', 'SDL_TLSSet')
register('RWFromFile', 'SDL_RWFromFile')
register('RWFromFP', 'SDL_RWFromFP')
register('RWFromMem', 'SDL_RWFromMem')
register('RWFromConstMem', 'SDL_RWFromConstMem')
register('allocRW', 'SDL_AllocRW')
register('freeRW', 'SDL_FreeRW')
register('readU8', 'SDL_ReadU8')
register('readLE16', 'SDL_ReadLE16')
register('readBE16', 'SDL_ReadBE16')
register('readLE32', 'SDL_ReadLE32')
register('readBE32', 'SDL_ReadBE32')
register('readLE64', 'SDL_ReadLE64')
register('readBE64', 'SDL_ReadBE64')
register('writeU8', 'SDL_WriteU8')
register('writeLE16', 'SDL_WriteLE16')
register('writeBE16', 'SDL_WriteBE16')
register('writeLE32', 'SDL_WriteLE32')
register('writeBE32', 'SDL_WriteBE32')
register('writeLE64', 'SDL_WriteLE64')
register('writeBE64', 'SDL_WriteBE64')
register('getNumAudioDrivers', 'SDL_GetNumAudioDrivers')
register('getAudioDriver', 'SDL_GetAudioDriver')
register('audioInit', 'SDL_AudioInit')
register('audioQuit', 'SDL_AudioQuit')
register('getCurrentAudioDriver', 'SDL_GetCurrentAudioDriver')
register('openAudio', 'SDL_OpenAudio')
register('getNumAudioDevices', 'SDL_GetNumAudioDevices')
register('getAudioDeviceName', 'SDL_GetAudioDeviceName')
register('openAudioDevice', 'SDL_OpenAudioDevice')
register('getAudioStatus', 'SDL_GetAudioStatus')
register('getAudioDeviceStatus', 'SDL_GetAudioDeviceStatus')
register('pauseAudio', 'SDL_PauseAudio')
register('pauseAudioDevice', 'SDL_PauseAudioDevice')
register('loadWAV_RW', 'SDL_LoadWAV_RW')
register('freeWAV', 'SDL_FreeWAV')
register('buildAudioCVT', 'SDL_BuildAudioCVT')
register('convertAudio', 'SDL_ConvertAudio')
register('mixAudio', 'SDL_MixAudio')
register('mixAudioFormat', 'SDL_MixAudioFormat')
register('lockAudio', 'SDL_LockAudio')
register('lockAudioDevice', 'SDL_LockAudioDevice')
register('unlockAudio', 'SDL_UnlockAudio')
register('unlockAudioDevice', 'SDL_UnlockAudioDevice')
register('closeAudio', 'SDL_CloseAudio')
register('closeAudioDevice', 'SDL_CloseAudioDevice')
register('setClipboardText', 'SDL_SetClipboardText')
register('getClipboardText', 'SDL_GetClipboardText')
register('hasClipboardText', 'SDL_HasClipboardText')
register('getCPUCount', 'SDL_GetCPUCount')
register('getCPUCacheLineSize', 'SDL_GetCPUCacheLineSize')
register('hasRDTSC', 'SDL_HasRDTSC')
register('hasAltiVec', 'SDL_HasAltiVec')
register('hasMMX', 'SDL_HasMMX')
register('has3DNow', 'SDL_Has3DNow')
register('hasSSE', 'SDL_HasSSE')
register('hasSSE2', 'SDL_HasSSE2')
register('hasSSE3', 'SDL_HasSSE3')
register('hasSSE41', 'SDL_HasSSE41')
register('hasSSE42', 'SDL_HasSSE42')
register('getPixelFormatName', 'SDL_GetPixelFormatName')
register('pixelFormatEnumToMasks', 'SDL_PixelFormatEnumToMasks')
register('masksToPixelFormatEnum', 'SDL_MasksToPixelFormatEnum')
register('allocFormat', 'SDL_AllocFormat')
register('freeFormat', 'SDL_FreeFormat')
register('allocPalette', 'SDL_AllocPalette')
register('setPixelFormatPalette', 'SDL_SetPixelFormatPalette')
register('setPaletteColors', 'SDL_SetPaletteColors')
register('freePalette', 'SDL_FreePalette')
register('mapRGB', 'SDL_MapRGB')
register('mapRGBA', 'SDL_MapRGBA')
register('getRGB', 'SDL_GetRGB')
register('getRGBA', 'SDL_GetRGBA')
register('calculateGammaRamp', 'SDL_CalculateGammaRamp')
register('hasIntersection', 'SDL_HasIntersection')
register('intersectRect', 'SDL_IntersectRect')
register('unionRect', 'SDL_UnionRect')
register('enclosePoints', 'SDL_EnclosePoints')
register('intersectRectAndLine', 'SDL_IntersectRectAndLine')
register('createRGBSurface', 'SDL_CreateRGBSurface')
register('createRGBSurfaceFrom', 'SDL_CreateRGBSurfaceFrom')
register('freeSurface', 'SDL_FreeSurface')
register('setSurfacePalette', 'SDL_SetSurfacePalette')
register('lockSurface', 'SDL_LockSurface')
register('unlockSurface', 'SDL_UnlockSurface')
register('loadBMP_RW', 'SDL_LoadBMP_RW')
register('saveBMP_RW', 'SDL_SaveBMP_RW')
register('setSurfaceRLE', 'SDL_SetSurfaceRLE')
register('setColorKey', 'SDL_SetColorKey')
register('getColorKey', 'SDL_GetColorKey')
register('setSurfaceColorMod', 'SDL_SetSurfaceColorMod')
register('getSurfaceColorMod', 'SDL_GetSurfaceColorMod')
register('setSurfaceAlphaMod', 'SDL_SetSurfaceAlphaMod')
register('getSurfaceAlphaMod', 'SDL_GetSurfaceAlphaMod')
register('setSurfaceBlendMode', 'SDL_SetSurfaceBlendMode')
register('getSurfaceBlendMode', 'SDL_GetSurfaceBlendMode')
register('setClipRect', 'SDL_SetClipRect')
register('getClipRect', 'SDL_GetClipRect')
register('convertSurface', 'SDL_ConvertSurface')
register('convertSurfaceFormat', 'SDL_ConvertSurfaceFormat')
register('convertPixels', 'SDL_ConvertPixels')
register('fillRect', 'SDL_FillRect')
register('fillRects', 'SDL_FillRects')
register('upperBlit', 'SDL_UpperBlit')
register('lowerBlit', 'SDL_LowerBlit')
register('softStretch', 'SDL_SoftStretch')
register('upperBlitScaled', 'SDL_UpperBlitScaled')
register('lowerBlitScaled', 'SDL_LowerBlitScaled')
register('getNumVideoDrivers', 'SDL_GetNumVideoDrivers')
register('getVideoDriver', 'SDL_GetVideoDriver')
register('videoInit', 'SDL_VideoInit')
register('videoQuit', 'SDL_VideoQuit')
register('getCurrentVideoDriver', 'SDL_GetCurrentVideoDriver')
register('getNumVideoDisplays', 'SDL_GetNumVideoDisplays')
register('getDisplayName', 'SDL_GetDisplayName')
register('getDisplayBounds', 'SDL_GetDisplayBounds')
register('getNumDisplayModes', 'SDL_GetNumDisplayModes')
register('getDisplayMode', 'SDL_GetDisplayMode')
register('getDesktopDisplayMode', 'SDL_GetDesktopDisplayMode')
register('getCurrentDisplayMode', 'SDL_GetCurrentDisplayMode')
register('getClosestDisplayMode', 'SDL_GetClosestDisplayMode')
register('getWindowDisplayIndex', 'SDL_GetWindowDisplayIndex')
register('setWindowDisplayMode', 'SDL_SetWindowDisplayMode')
register('getWindowDisplayMode', 'SDL_GetWindowDisplayMode')
register('getWindowPixelFormat', 'SDL_GetWindowPixelFormat')
register('createWindow', 'SDL_CreateWindow')
register('createWindowFrom', 'SDL_CreateWindowFrom')
register('getWindowID', 'SDL_GetWindowID')
register('getWindowFromID', 'SDL_GetWindowFromID')
register('getWindowFlags', 'SDL_GetWindowFlags')
register('setWindowTitle', 'SDL_SetWindowTitle')
register('getWindowTitle', 'SDL_GetWindowTitle')
register('setWindowIcon', 'SDL_SetWindowIcon')
register('setWindowData', 'SDL_SetWindowData')
register('getWindowData', 'SDL_GetWindowData')
register('setWindowPosition', 'SDL_SetWindowPosition')
register('getWindowPosition', 'SDL_GetWindowPosition')
register('setWindowSize', 'SDL_SetWindowSize')
register('getWindowSize', 'SDL_GetWindowSize')
register('setWindowMinimumSize', 'SDL_SetWindowMinimumSize')
register('getWindowMinimumSize', 'SDL_GetWindowMinimumSize')
register('setWindowMaximumSize', 'SDL_SetWindowMaximumSize')
register('getWindowMaximumSize', 'SDL_GetWindowMaximumSize')
register('setWindowBordered', 'SDL_SetWindowBordered')
register('showWindow', 'SDL_ShowWindow')
register('hideWindow', 'SDL_HideWindow')
register('raiseWindow', 'SDL_RaiseWindow')
register('maximizeWindow', 'SDL_MaximizeWindow')
register('minimizeWindow', 'SDL_MinimizeWindow')
register('restoreWindow', 'SDL_RestoreWindow')
register('setWindowFullscreen', 'SDL_SetWindowFullscreen')
register('getWindowSurface', 'SDL_GetWindowSurface')
register('updateWindowSurface', 'SDL_UpdateWindowSurface')
register('updateWindowSurfaceRects', 'SDL_UpdateWindowSurfaceRects')
register('setWindowGrab', 'SDL_SetWindowGrab')
register('getWindowGrab', 'SDL_GetWindowGrab')
register('setWindowBrightness', 'SDL_SetWindowBrightness')
register('getWindowBrightness', 'SDL_GetWindowBrightness')
register('setWindowGammaRamp', 'SDL_SetWindowGammaRamp')
register('getWindowGammaRamp', 'SDL_GetWindowGammaRamp')
register('destroyWindow', 'SDL_DestroyWindow')
register('isScreenSaverEnabled', 'SDL_IsScreenSaverEnabled')
register('enableScreenSaver', 'SDL_EnableScreenSaver')
register('disableScreenSaver', 'SDL_DisableScreenSaver')
register('gL_LoadLibrary', 'SDL_GL_LoadLibrary')
register('gL_GetProcAddress', 'SDL_GL_GetProcAddress')
register('gL_UnloadLibrary', 'SDL_GL_UnloadLibrary')
register('gL_ExtensionSupported', 'SDL_GL_ExtensionSupported')
register('gL_SetAttribute', 'SDL_GL_SetAttribute')
register('gL_GetAttribute', 'SDL_GL_GetAttribute')
register('gL_CreateContext', 'SDL_GL_CreateContext')
register('gL_MakeCurrent', 'SDL_GL_MakeCurrent')
register('gL_GetCurrentWindow', 'SDL_GL_GetCurrentWindow')
register('gL_GetCurrentContext', 'SDL_GL_GetCurrentContext')
register('gL_SetSwapInterval', 'SDL_GL_SetSwapInterval')
register('gL_GetSwapInterval', 'SDL_GL_GetSwapInterval')
register('gL_SwapWindow', 'SDL_GL_SwapWindow')
register('gL_DeleteContext', 'SDL_GL_DeleteContext')
register('getKeyboardFocus', 'SDL_GetKeyboardFocus')
register('getKeyboardState', 'SDL_GetKeyboardState')
register('getModState', 'SDL_GetModState')
register('setModState', 'SDL_SetModState')
register('getKeyFromScancode', 'SDL_GetKeyFromScancode')
register('getScancodeFromKey', 'SDL_GetScancodeFromKey')
register('getScancodeName', 'SDL_GetScancodeName')
register('getScancodeFromName', 'SDL_GetScancodeFromName')
register('getKeyName', 'SDL_GetKeyName')
register('getKeyFromName', 'SDL_GetKeyFromName')
register('startTextInput', 'SDL_StartTextInput')
register('isTextInputActive', 'SDL_IsTextInputActive')
register('stopTextInput', 'SDL_StopTextInput')
register('setTextInputRect', 'SDL_SetTextInputRect')
register('hasScreenKeyboardSupport', 'SDL_HasScreenKeyboardSupport')
register('isScreenKeyboardShown', 'SDL_IsScreenKeyboardShown')
register('getMouseFocus', 'SDL_GetMouseFocus')
register('getMouseState', 'SDL_GetMouseState')
register('getRelativeMouseState', 'SDL_GetRelativeMouseState')
register('warpMouseInWindow', 'SDL_WarpMouseInWindow')
register('setRelativeMouseMode', 'SDL_SetRelativeMouseMode')
register('getRelativeMouseMode', 'SDL_GetRelativeMouseMode')
register('createCursor', 'SDL_CreateCursor')
register('createColorCursor', 'SDL_CreateColorCursor')
register('createSystemCursor', 'SDL_CreateSystemCursor')
register('setCursor', 'SDL_SetCursor')
register('getCursor', 'SDL_GetCursor')
register('getDefaultCursor', 'SDL_GetDefaultCursor')
register('freeCursor', 'SDL_FreeCursor')
register('showCursor', 'SDL_ShowCursor')
register('numJoysticks', 'SDL_NumJoysticks')
register('joystickNameForIndex', 'SDL_JoystickNameForIndex')
register('joystickOpen', 'SDL_JoystickOpen')
register('joystickName', 'SDL_JoystickName')
register('joystickGetDeviceGUID', 'SDL_JoystickGetDeviceGUID')
register('joystickGetGUID', 'SDL_JoystickGetGUID')
register('joystickGetGUIDString', 'SDL_JoystickGetGUIDString')
register('joystickGetGUIDFromString', 'SDL_JoystickGetGUIDFromString')
register('joystickGetAttached', 'SDL_JoystickGetAttached')
register('joystickInstanceID', 'SDL_JoystickInstanceID')
register('joystickNumAxes', 'SDL_JoystickNumAxes')
register('joystickNumBalls', 'SDL_JoystickNumBalls')
register('joystickNumHats', 'SDL_JoystickNumHats')
register('joystickNumButtons', 'SDL_JoystickNumButtons')
register('joystickUpdate', 'SDL_JoystickUpdate')
register('joystickEventState', 'SDL_JoystickEventState')
register('joystickGetAxis', 'SDL_JoystickGetAxis')
register('joystickGetHat', 'SDL_JoystickGetHat')
register('joystickGetBall', 'SDL_JoystickGetBall')
register('joystickGetButton', 'SDL_JoystickGetButton')
register('joystickClose', 'SDL_JoystickClose')
register('gameControllerAddMapping', 'SDL_GameControllerAddMapping')
register('gameControllerMappingForGUID', 'SDL_GameControllerMappingForGUID')
register('gameControllerMapping', 'SDL_GameControllerMapping')
register('isGameController', 'SDL_IsGameController')
register('gameControllerNameForIndex', 'SDL_GameControllerNameForIndex')
register('gameControllerOpen', 'SDL_GameControllerOpen')
register('gameControllerName', 'SDL_GameControllerName')
register('gameControllerGetAttached', 'SDL_GameControllerGetAttached')
register('gameControllerGetJoystick', 'SDL_GameControllerGetJoystick')
register('gameControllerEventState', 'SDL_GameControllerEventState')
register('gameControllerUpdate', 'SDL_GameControllerUpdate')
register('gameControllerGetAxisFromString', 'SDL_GameControllerGetAxisFromString')
register('gameControllerGetStringForAxis', 'SDL_GameControllerGetStringForAxis')
register('gameControllerGetBindForAxis', 'SDL_GameControllerGetBindForAxis')
register('gameControllerGetAxis', 'SDL_GameControllerGetAxis')
register('gameControllerGetButtonFromString', 'SDL_GameControllerGetButtonFromString')
register('gameControllerGetStringForButton', 'SDL_GameControllerGetStringForButton')
register('gameControllerGetBindForButton', 'SDL_GameControllerGetBindForButton')
register('gameControllerGetButton', 'SDL_GameControllerGetButton')
register('gameControllerClose', 'SDL_GameControllerClose')
register('getNumTouchDevices', 'SDL_GetNumTouchDevices')
register('getTouchDevice', 'SDL_GetTouchDevice')
register('getNumTouchFingers', 'SDL_GetNumTouchFingers')
register('getTouchFinger', 'SDL_GetTouchFinger')
register('recordGesture', 'SDL_RecordGesture')
register('saveAllDollarTemplates', 'SDL_SaveAllDollarTemplates')
register('saveDollarTemplate', 'SDL_SaveDollarTemplate')
register('loadDollarTemplates', 'SDL_LoadDollarTemplates')
register('pumpEvents', 'SDL_PumpEvents')
register('peepEvents', 'SDL_PeepEvents')
register('hasEvent', 'SDL_HasEvent')
register('hasEvents', 'SDL_HasEvents')
register('flushEvent', 'SDL_FlushEvent')
register('flushEvents', 'SDL_FlushEvents')
register('pollEvent', 'SDL_PollEvent')
register('waitEvent', 'SDL_WaitEvent')
register('waitEventTimeout', 'SDL_WaitEventTimeout')
register('pushEvent', 'SDL_PushEvent')
register('setEventFilter', 'SDL_SetEventFilter')
register('getEventFilter', 'SDL_GetEventFilter')
register('addEventWatch', 'SDL_AddEventWatch')
register('delEventWatch', 'SDL_DelEventWatch')
register('filterEvents', 'SDL_FilterEvents')
register('eventState', 'SDL_EventState')
register('registerEvents', 'SDL_RegisterEvents')
register('numHaptics', 'SDL_NumHaptics')
register('hapticName', 'SDL_HapticName')
register('hapticOpen', 'SDL_HapticOpen')
register('hapticOpened', 'SDL_HapticOpened')
register('hapticIndex', 'SDL_HapticIndex')
register('mouseIsHaptic', 'SDL_MouseIsHaptic')
register('hapticOpenFromMouse', 'SDL_HapticOpenFromMouse')
register('joystickIsHaptic', 'SDL_JoystickIsHaptic')
register('hapticOpenFromJoystick', 'SDL_HapticOpenFromJoystick')
register('hapticClose', 'SDL_HapticClose')
register('hapticNumEffects', 'SDL_HapticNumEffects')
register('hapticNumEffectsPlaying', 'SDL_HapticNumEffectsPlaying')
register('hapticQuery', 'SDL_HapticQuery')
register('hapticNumAxes', 'SDL_HapticNumAxes')
register('hapticEffectSupported', 'SDL_HapticEffectSupported')
register('hapticNewEffect', 'SDL_HapticNewEffect')
register('hapticUpdateEffect', 'SDL_HapticUpdateEffect')
register('hapticRunEffect', 'SDL_HapticRunEffect')
register('hapticStopEffect', 'SDL_HapticStopEffect')
register('hapticDestroyEffect', 'SDL_HapticDestroyEffect')
register('hapticGetEffectStatus', 'SDL_HapticGetEffectStatus')
register('hapticSetGain', 'SDL_HapticSetGain')
register('hapticSetAutocenter', 'SDL_HapticSetAutocenter')
register('hapticPause', 'SDL_HapticPause')
register('hapticUnpause', 'SDL_HapticUnpause')
register('hapticStopAll', 'SDL_HapticStopAll')
register('hapticRumbleSupported', 'SDL_HapticRumbleSupported')
register('hapticRumbleInit', 'SDL_HapticRumbleInit')
register('hapticRumblePlay', 'SDL_HapticRumblePlay')
register('hapticRumbleStop', 'SDL_HapticRumbleStop')
register('setHintWithPriority', 'SDL_SetHintWithPriority')
register('setHint', 'SDL_SetHint')
register('getHint', 'SDL_GetHint')
register('addHintCallback', 'SDL_AddHintCallback')
register('delHintCallback', 'SDL_DelHintCallback')
register('clearHints', 'SDL_ClearHints')
register('loadObject', 'SDL_LoadObject')
register('loadFunction', 'SDL_LoadFunction')
register('unloadObject', 'SDL_UnloadObject')
register('logSetAllPriority', 'SDL_LogSetAllPriority')
register('logSetPriority', 'SDL_LogSetPriority')
register('logGetPriority', 'SDL_LogGetPriority')
register('logResetPriorities', 'SDL_LogResetPriorities')
register('log', 'SDL_Log')
register('logVerbose', 'SDL_LogVerbose')
register('logDebug', 'SDL_LogDebug')
register('logInfo', 'SDL_LogInfo')
register('logWarn', 'SDL_LogWarn')
register('logError', 'SDL_LogError')
register('logCritical', 'SDL_LogCritical')
register('logMessage', 'SDL_LogMessage')
register('logMessageV', 'SDL_LogMessageV')
register('logGetOutputFunction', 'SDL_LogGetOutputFunction')
register('logSetOutputFunction', 'SDL_LogSetOutputFunction')
register('showMessageBox', 'SDL_ShowMessageBox')
register('showSimpleMessageBox', 'SDL_ShowSimpleMessageBox')
register('getPowerInfo', 'SDL_GetPowerInfo')
register('getNumRenderDrivers', 'SDL_GetNumRenderDrivers')
register('getRenderDriverInfo', 'SDL_GetRenderDriverInfo')
register('createWindowAndRenderer', 'SDL_CreateWindowAndRenderer')
register('createRenderer', 'SDL_CreateRenderer')
register('createSoftwareRenderer', 'SDL_CreateSoftwareRenderer')
register('getRenderer', 'SDL_GetRenderer')
register('getRendererInfo', 'SDL_GetRendererInfo')
register('getRendererOutputSize', 'SDL_GetRendererOutputSize')
register('createTexture', 'SDL_CreateTexture')
register('createTextureFromSurface', 'SDL_CreateTextureFromSurface')
register('queryTexture', 'SDL_QueryTexture')
register('setTextureColorMod', 'SDL_SetTextureColorMod')
register('getTextureColorMod', 'SDL_GetTextureColorMod')
register('setTextureAlphaMod', 'SDL_SetTextureAlphaMod')
register('getTextureAlphaMod', 'SDL_GetTextureAlphaMod')
register('setTextureBlendMode', 'SDL_SetTextureBlendMode')
register('getTextureBlendMode', 'SDL_GetTextureBlendMode')
register('updateTexture', 'SDL_UpdateTexture')
register('lockTexture', 'SDL_LockTexture')
register('unlockTexture', 'SDL_UnlockTexture')
register('renderTargetSupported', 'SDL_RenderTargetSupported')
register('setRenderTarget', 'SDL_SetRenderTarget')
register('getRenderTarget', 'SDL_GetRenderTarget')
register('renderSetLogicalSize', 'SDL_RenderSetLogicalSize')
register('renderGetLogicalSize', 'SDL_RenderGetLogicalSize')
register('renderSetViewport', 'SDL_RenderSetViewport')
register('renderGetViewport', 'SDL_RenderGetViewport')
register('renderSetClipRect', 'SDL_RenderSetClipRect')
register('renderGetClipRect', 'SDL_RenderGetClipRect')
register('renderSetScale', 'SDL_RenderSetScale')
register('renderGetScale', 'SDL_RenderGetScale')
register('setRenderDrawColor', 'SDL_SetRenderDrawColor')
register('getRenderDrawColor', 'SDL_GetRenderDrawColor')
register('setRenderDrawBlendMode', 'SDL_SetRenderDrawBlendMode')
register('getRenderDrawBlendMode', 'SDL_GetRenderDrawBlendMode')
register('renderClear', 'SDL_RenderClear')
register('renderDrawPoint', 'SDL_RenderDrawPoint')
register('renderDrawPoints', 'SDL_RenderDrawPoints')
register('renderDrawLine', 'SDL_RenderDrawLine')
register('renderDrawLines', 'SDL_RenderDrawLines')
register('renderDrawRect', 'SDL_RenderDrawRect')
register('renderDrawRects', 'SDL_RenderDrawRects')
register('renderFillRect', 'SDL_RenderFillRect')
register('renderFillRects', 'SDL_RenderFillRects')
register('renderCopy', 'SDL_RenderCopy')
register('renderCopyEx', 'SDL_RenderCopyEx')
register('renderReadPixels', 'SDL_RenderReadPixels')
register('renderPresent', 'SDL_RenderPresent')
register('destroyTexture', 'SDL_DestroyTexture')
register('destroyRenderer', 'SDL_DestroyRenderer')
register('gL_BindTexture', 'SDL_GL_BindTexture')
register('gL_UnbindTexture', 'SDL_GL_UnbindTexture')
register('getTicks', 'SDL_GetTicks')
register('getPerformanceCounter', 'SDL_GetPerformanceCounter')
register('getPerformanceFrequency', 'SDL_GetPerformanceFrequency')
register('delay', 'SDL_Delay')
register('addTimer', 'SDL_AddTimer')
register('removeTimer', 'SDL_RemoveTimer')
register('getVersion', 'SDL_GetVersion')
register('getRevision', 'SDL_GetRevision')
register('getRevisionNumber', 'SDL_GetRevisionNumber')
register('init', 'SDL_Init')
register('initSubSystem', 'SDL_InitSubSystem')
register('quitSubSystem', 'SDL_QuitSubSystem')
register('wasInit', 'SDL_WasInit')
register('quit', 'SDL_Quit')
register('registerApp', 'SDL_RegisterApp')
register('unregisterApp', 'SDL_UnregisterApp')

register('FALSE', 'SDL_FALSE')
register('TRUE', 'SDL_TRUE')
register('DUMMY_ENUM', 'SDL_DUMMY_ENUM')
register('DUMMY_ENUM', 'SDL_DUMMY_ENUM')
register('ASSERTION_RETRY', 'SDL_ASSERTION_RETRY')
register('ASSERTION_BREAK', 'SDL_ASSERTION_BREAK')
register('ASSERTION_ABORT', 'SDL_ASSERTION_ABORT')
register('ASSERTION_IGNORE', 'SDL_ASSERTION_IGNORE')
register('ASSERTION_ALWAYS_IGNORE', 'SDL_ASSERTION_ALWAYS_IGNORE')
register('ENOMEM', 'SDL_ENOMEM')
register('EFREAD', 'SDL_EFREAD')
register('EFWRITE', 'SDL_EFWRITE')
register('EFSEEK', 'SDL_EFSEEK')
register('UNSUPPORTED', 'SDL_UNSUPPORTED')
register('LASTERROR', 'SDL_LASTERROR')
register('TLSID', 'SDL_TLSID')
register('THREAD_PRIORITY_LOW', 'SDL_THREAD_PRIORITY_LOW')
register('THREAD_PRIORITY_NORMAL', 'SDL_THREAD_PRIORITY_NORMAL')
register('THREAD_PRIORITY_HIGH', 'SDL_THREAD_PRIORITY_HIGH')
register('TLSID', 'SDL_TLSID')
register('TLSID', 'SDL_TLSID')
register('TLSID', 'SDL_TLSID')
register('AUDIO_STOPPED', 'SDL_AUDIO_STOPPED')
register('AUDIO_PLAYING', 'SDL_AUDIO_PLAYING')
register('AUDIO_PAUSED', 'SDL_AUDIO_PAUSED')
register('PIXELTYPE_UNKNOWN', 'SDL_PIXELTYPE_UNKNOWN')
register('PIXELTYPE_INDEX1', 'SDL_PIXELTYPE_INDEX1')
register('PIXELTYPE_INDEX4', 'SDL_PIXELTYPE_INDEX4')
register('PIXELTYPE_INDEX8', 'SDL_PIXELTYPE_INDEX8')
register('PIXELTYPE_PACKED8', 'SDL_PIXELTYPE_PACKED8')
register('PIXELTYPE_PACKED16', 'SDL_PIXELTYPE_PACKED16')
register('PIXELTYPE_PACKED32', 'SDL_PIXELTYPE_PACKED32')
register('PIXELTYPE_ARRAYU8', 'SDL_PIXELTYPE_ARRAYU8')
register('PIXELTYPE_ARRAYU16', 'SDL_PIXELTYPE_ARRAYU16')
register('PIXELTYPE_ARRAYU32', 'SDL_PIXELTYPE_ARRAYU32')
register('PIXELTYPE_ARRAYF16', 'SDL_PIXELTYPE_ARRAYF16')
register('PIXELTYPE_ARRAYF32', 'SDL_PIXELTYPE_ARRAYF32')
register('BITMAPORDER_NONE', 'SDL_BITMAPORDER_NONE')
register('BITMAPORDER_4321', 'SDL_BITMAPORDER_4321')
register('BITMAPORDER_1234', 'SDL_BITMAPORDER_1234')
register('PACKEDORDER_NONE', 'SDL_PACKEDORDER_NONE')
register('PACKEDORDER_XRGB', 'SDL_PACKEDORDER_XRGB')
register('PACKEDORDER_RGBX', 'SDL_PACKEDORDER_RGBX')
register('PACKEDORDER_ARGB', 'SDL_PACKEDORDER_ARGB')
register('PACKEDORDER_RGBA', 'SDL_PACKEDORDER_RGBA')
register('PACKEDORDER_XBGR', 'SDL_PACKEDORDER_XBGR')
register('PACKEDORDER_BGRX', 'SDL_PACKEDORDER_BGRX')
register('PACKEDORDER_ABGR', 'SDL_PACKEDORDER_ABGR')
register('PACKEDORDER_BGRA', 'SDL_PACKEDORDER_BGRA')
register('ARRAYORDER_NONE', 'SDL_ARRAYORDER_NONE')
register('ARRAYORDER_RGB', 'SDL_ARRAYORDER_RGB')
register('ARRAYORDER_RGBA', 'SDL_ARRAYORDER_RGBA')
register('ARRAYORDER_ARGB', 'SDL_ARRAYORDER_ARGB')
register('ARRAYORDER_BGR', 'SDL_ARRAYORDER_BGR')
register('ARRAYORDER_BGRA', 'SDL_ARRAYORDER_BGRA')
register('ARRAYORDER_ABGR', 'SDL_ARRAYORDER_ABGR')
register('PACKEDLAYOUT_NONE', 'SDL_PACKEDLAYOUT_NONE')
register('PACKEDLAYOUT_332', 'SDL_PACKEDLAYOUT_332')
register('PACKEDLAYOUT_4444', 'SDL_PACKEDLAYOUT_4444')
register('PACKEDLAYOUT_1555', 'SDL_PACKEDLAYOUT_1555')
register('PACKEDLAYOUT_5551', 'SDL_PACKEDLAYOUT_5551')
register('PACKEDLAYOUT_565', 'SDL_PACKEDLAYOUT_565')
register('PACKEDLAYOUT_8888', 'SDL_PACKEDLAYOUT_8888')
register('PACKEDLAYOUT_2101010', 'SDL_PACKEDLAYOUT_2101010')
register('PACKEDLAYOUT_1010102', 'SDL_PACKEDLAYOUT_1010102')
register('PIXELFORMAT_UNKNOWN', 'SDL_PIXELFORMAT_UNKNOWN')
register('PIXELFORMAT_INDEX1LSB', 'SDL_PIXELFORMAT_INDEX1LSB')
register('PIXELTYPE_INDEX1', 'SDL_PIXELTYPE_INDEX1')
register('BITMAPORDER_4321', 'SDL_BITMAPORDER_4321')
register('PIXELFORMAT_INDEX1MSB', 'SDL_PIXELFORMAT_INDEX1MSB')
register('PIXELTYPE_INDEX1', 'SDL_PIXELTYPE_INDEX1')
register('BITMAPORDER_1234', 'SDL_BITMAPORDER_1234')
register('PIXELFORMAT_INDEX4LSB', 'SDL_PIXELFORMAT_INDEX4LSB')
register('PIXELTYPE_INDEX4', 'SDL_PIXELTYPE_INDEX4')
register('BITMAPORDER_4321', 'SDL_BITMAPORDER_4321')
register('PIXELFORMAT_INDEX4MSB', 'SDL_PIXELFORMAT_INDEX4MSB')
register('PIXELTYPE_INDEX4', 'SDL_PIXELTYPE_INDEX4')
register('BITMAPORDER_1234', 'SDL_BITMAPORDER_1234')
register('PIXELFORMAT_INDEX8', 'SDL_PIXELFORMAT_INDEX8')
register('PIXELTYPE_INDEX8', 'SDL_PIXELTYPE_INDEX8')
register('PIXELFORMAT_RGB332', 'SDL_PIXELFORMAT_RGB332')
register('PIXELTYPE_PACKED8', 'SDL_PIXELTYPE_PACKED8')
register('PACKEDORDER_XRGB', 'SDL_PACKEDORDER_XRGB')
register('PACKEDLAYOUT_332', 'SDL_PACKEDLAYOUT_332')
register('PIXELFORMAT_RGB444', 'SDL_PIXELFORMAT_RGB444')
register('PIXELTYPE_PACKED16', 'SDL_PIXELTYPE_PACKED16')
register('PACKEDORDER_XRGB', 'SDL_PACKEDORDER_XRGB')
register('PACKEDLAYOUT_4444', 'SDL_PACKEDLAYOUT_4444')
register('PIXELFORMAT_RGB555', 'SDL_PIXELFORMAT_RGB555')
register('PIXELTYPE_PACKED16', 'SDL_PIXELTYPE_PACKED16')
register('PACKEDORDER_XRGB', 'SDL_PACKEDORDER_XRGB')
register('PACKEDLAYOUT_1555', 'SDL_PACKEDLAYOUT_1555')
register('PIXELFORMAT_BGR555', 'SDL_PIXELFORMAT_BGR555')
register('PIXELTYPE_PACKED16', 'SDL_PIXELTYPE_PACKED16')
register('PACKEDORDER_XBGR', 'SDL_PACKEDORDER_XBGR')
register('PACKEDLAYOUT_1555', 'SDL_PACKEDLAYOUT_1555')
register('PIXELFORMAT_ARGB4444', 'SDL_PIXELFORMAT_ARGB4444')
register('PIXELTYPE_PACKED16', 'SDL_PIXELTYPE_PACKED16')
register('PACKEDORDER_ARGB', 'SDL_PACKEDORDER_ARGB')
register('PACKEDLAYOUT_4444', 'SDL_PACKEDLAYOUT_4444')
register('PIXELFORMAT_RGBA4444', 'SDL_PIXELFORMAT_RGBA4444')
register('PIXELTYPE_PACKED16', 'SDL_PIXELTYPE_PACKED16')
register('PACKEDORDER_RGBA', 'SDL_PACKEDORDER_RGBA')
register('PACKEDLAYOUT_4444', 'SDL_PACKEDLAYOUT_4444')
register('PIXELFORMAT_ABGR4444', 'SDL_PIXELFORMAT_ABGR4444')
register('PIXELTYPE_PACKED16', 'SDL_PIXELTYPE_PACKED16')
register('PACKEDORDER_ABGR', 'SDL_PACKEDORDER_ABGR')
register('PACKEDLAYOUT_4444', 'SDL_PACKEDLAYOUT_4444')
register('PIXELFORMAT_BGRA4444', 'SDL_PIXELFORMAT_BGRA4444')
register('PIXELTYPE_PACKED16', 'SDL_PIXELTYPE_PACKED16')
register('PACKEDORDER_BGRA', 'SDL_PACKEDORDER_BGRA')
register('PACKEDLAYOUT_4444', 'SDL_PACKEDLAYOUT_4444')
register('PIXELFORMAT_ARGB1555', 'SDL_PIXELFORMAT_ARGB1555')
register('PIXELTYPE_PACKED16', 'SDL_PIXELTYPE_PACKED16')
register('PACKEDORDER_ARGB', 'SDL_PACKEDORDER_ARGB')
register('PACKEDLAYOUT_1555', 'SDL_PACKEDLAYOUT_1555')
register('PIXELFORMAT_RGBA5551', 'SDL_PIXELFORMAT_RGBA5551')
register('PIXELTYPE_PACKED16', 'SDL_PIXELTYPE_PACKED16')
register('PACKEDORDER_RGBA', 'SDL_PACKEDORDER_RGBA')
register('PACKEDLAYOUT_5551', 'SDL_PACKEDLAYOUT_5551')
register('PIXELFORMAT_ABGR1555', 'SDL_PIXELFORMAT_ABGR1555')
register('PIXELTYPE_PACKED16', 'SDL_PIXELTYPE_PACKED16')
register('PACKEDORDER_ABGR', 'SDL_PACKEDORDER_ABGR')
register('PACKEDLAYOUT_1555', 'SDL_PACKEDLAYOUT_1555')
register('PIXELFORMAT_BGRA5551', 'SDL_PIXELFORMAT_BGRA5551')
register('PIXELTYPE_PACKED16', 'SDL_PIXELTYPE_PACKED16')
register('PACKEDORDER_BGRA', 'SDL_PACKEDORDER_BGRA')
register('PACKEDLAYOUT_5551', 'SDL_PACKEDLAYOUT_5551')
register('PIXELFORMAT_RGB565', 'SDL_PIXELFORMAT_RGB565')
register('PIXELTYPE_PACKED16', 'SDL_PIXELTYPE_PACKED16')
register('PACKEDORDER_XRGB', 'SDL_PACKEDORDER_XRGB')
register('PACKEDLAYOUT_565', 'SDL_PACKEDLAYOUT_565')
register('PIXELFORMAT_BGR565', 'SDL_PIXELFORMAT_BGR565')
register('PIXELTYPE_PACKED16', 'SDL_PIXELTYPE_PACKED16')
register('PACKEDORDER_XBGR', 'SDL_PACKEDORDER_XBGR')
register('PACKEDLAYOUT_565', 'SDL_PACKEDLAYOUT_565')
register('PIXELFORMAT_RGB24', 'SDL_PIXELFORMAT_RGB24')
register('PIXELTYPE_ARRAYU8', 'SDL_PIXELTYPE_ARRAYU8')
register('ARRAYORDER_RGB', 'SDL_ARRAYORDER_RGB')
register('PIXELFORMAT_BGR24', 'SDL_PIXELFORMAT_BGR24')
register('PIXELTYPE_ARRAYU8', 'SDL_PIXELTYPE_ARRAYU8')
register('ARRAYORDER_BGR', 'SDL_ARRAYORDER_BGR')
register('PIXELFORMAT_RGB888', 'SDL_PIXELFORMAT_RGB888')
register('PIXELTYPE_PACKED32', 'SDL_PIXELTYPE_PACKED32')
register('PACKEDORDER_XRGB', 'SDL_PACKEDORDER_XRGB')
register('PACKEDLAYOUT_8888', 'SDL_PACKEDLAYOUT_8888')
register('PIXELFORMAT_RGBX8888', 'SDL_PIXELFORMAT_RGBX8888')
register('PIXELTYPE_PACKED32', 'SDL_PIXELTYPE_PACKED32')
register('PACKEDORDER_RGBX', 'SDL_PACKEDORDER_RGBX')
register('PACKEDLAYOUT_8888', 'SDL_PACKEDLAYOUT_8888')
register('PIXELFORMAT_BGR888', 'SDL_PIXELFORMAT_BGR888')
register('PIXELTYPE_PACKED32', 'SDL_PIXELTYPE_PACKED32')
register('PACKEDORDER_XBGR', 'SDL_PACKEDORDER_XBGR')
register('PACKEDLAYOUT_8888', 'SDL_PACKEDLAYOUT_8888')
register('PIXELFORMAT_BGRX8888', 'SDL_PIXELFORMAT_BGRX8888')
register('PIXELTYPE_PACKED32', 'SDL_PIXELTYPE_PACKED32')
register('PACKEDORDER_BGRX', 'SDL_PACKEDORDER_BGRX')
register('PACKEDLAYOUT_8888', 'SDL_PACKEDLAYOUT_8888')
register('PIXELFORMAT_ARGB8888', 'SDL_PIXELFORMAT_ARGB8888')
register('PIXELTYPE_PACKED32', 'SDL_PIXELTYPE_PACKED32')
register('PACKEDORDER_ARGB', 'SDL_PACKEDORDER_ARGB')
register('PACKEDLAYOUT_8888', 'SDL_PACKEDLAYOUT_8888')
register('PIXELFORMAT_RGBA8888', 'SDL_PIXELFORMAT_RGBA8888')
register('PIXELTYPE_PACKED32', 'SDL_PIXELTYPE_PACKED32')
register('PACKEDORDER_RGBA', 'SDL_PACKEDORDER_RGBA')
register('PACKEDLAYOUT_8888', 'SDL_PACKEDLAYOUT_8888')
register('PIXELFORMAT_ABGR8888', 'SDL_PIXELFORMAT_ABGR8888')
register('PIXELTYPE_PACKED32', 'SDL_PIXELTYPE_PACKED32')
register('PACKEDORDER_ABGR', 'SDL_PACKEDORDER_ABGR')
register('PACKEDLAYOUT_8888', 'SDL_PACKEDLAYOUT_8888')
register('PIXELFORMAT_BGRA8888', 'SDL_PIXELFORMAT_BGRA8888')
register('PIXELTYPE_PACKED32', 'SDL_PIXELTYPE_PACKED32')
register('PACKEDORDER_BGRA', 'SDL_PACKEDORDER_BGRA')
register('PACKEDLAYOUT_8888', 'SDL_PACKEDLAYOUT_8888')
register('PIXELFORMAT_ARGB2101010', 'SDL_PIXELFORMAT_ARGB2101010')
register('PIXELTYPE_PACKED32', 'SDL_PIXELTYPE_PACKED32')
register('PACKEDORDER_ARGB', 'SDL_PACKEDORDER_ARGB')
register('PACKEDLAYOUT_2101010', 'SDL_PACKEDLAYOUT_2101010')
register('PIXELFORMAT_YV12', 'SDL_PIXELFORMAT_YV12')
register('PIXELFORMAT_IYUV', 'SDL_PIXELFORMAT_IYUV')
register('PIXELFORMAT_YUY2', 'SDL_PIXELFORMAT_YUY2')
register('PIXELFORMAT_UYVY', 'SDL_PIXELFORMAT_UYVY')
register('PIXELFORMAT_YVYU', 'SDL_PIXELFORMAT_YVYU')
register('BLENDMODE_NONE', 'SDL_BLENDMODE_NONE')
register('BLENDMODE_BLEND', 'SDL_BLENDMODE_BLEND')
register('BLENDMODE_ADD', 'SDL_BLENDMODE_ADD')
register('BLENDMODE_MOD', 'SDL_BLENDMODE_MOD')
register('WINDOW_FULLSCREEN', 'SDL_WINDOW_FULLSCREEN')
register('WINDOW_OPENGL', 'SDL_WINDOW_OPENGL')
register('WINDOW_SHOWN', 'SDL_WINDOW_SHOWN')
register('WINDOW_HIDDEN', 'SDL_WINDOW_HIDDEN')
register('WINDOW_BORDERLESS', 'SDL_WINDOW_BORDERLESS')
register('WINDOW_RESIZABLE', 'SDL_WINDOW_RESIZABLE')
register('WINDOW_MINIMIZED', 'SDL_WINDOW_MINIMIZED')
register('WINDOW_MAXIMIZED', 'SDL_WINDOW_MAXIMIZED')
register('WINDOW_INPUT_GRABBED', 'SDL_WINDOW_INPUT_GRABBED')
register('WINDOW_INPUT_FOCUS', 'SDL_WINDOW_INPUT_FOCUS')
register('WINDOW_MOUSE_FOCUS', 'SDL_WINDOW_MOUSE_FOCUS')
register('WINDOW_FULLSCREEN_DESKTOP', 'SDL_WINDOW_FULLSCREEN_DESKTOP')
register('WINDOW_FULLSCREEN', 'SDL_WINDOW_FULLSCREEN')
register('WINDOW_FOREIGN', 'SDL_WINDOW_FOREIGN')
register('WINDOWEVENT_NONE', 'SDL_WINDOWEVENT_NONE')
register('WINDOWEVENT_SHOWN', 'SDL_WINDOWEVENT_SHOWN')
register('WINDOWEVENT_HIDDEN', 'SDL_WINDOWEVENT_HIDDEN')
register('WINDOWEVENT_EXPOSED', 'SDL_WINDOWEVENT_EXPOSED')
register('WINDOWEVENT_MOVED', 'SDL_WINDOWEVENT_MOVED')
register('WINDOWEVENT_RESIZED', 'SDL_WINDOWEVENT_RESIZED')
register('WINDOWEVENT_SIZE_CHANGED', 'SDL_WINDOWEVENT_SIZE_CHANGED')
register('WINDOWEVENT_MINIMIZED', 'SDL_WINDOWEVENT_MINIMIZED')
register('WINDOWEVENT_MAXIMIZED', 'SDL_WINDOWEVENT_MAXIMIZED')
register('WINDOWEVENT_RESTORED', 'SDL_WINDOWEVENT_RESTORED')
register('WINDOWEVENT_ENTER', 'SDL_WINDOWEVENT_ENTER')
register('WINDOWEVENT_LEAVE', 'SDL_WINDOWEVENT_LEAVE')
register('WINDOWEVENT_FOCUS_GAINED', 'SDL_WINDOWEVENT_FOCUS_GAINED')
register('WINDOWEVENT_FOCUS_LOST', 'SDL_WINDOWEVENT_FOCUS_LOST')
register('WINDOWEVENT_CLOSE', 'SDL_WINDOWEVENT_CLOSE')
register('GL_RED_SIZE', 'SDL_GL_RED_SIZE')
register('GL_GREEN_SIZE', 'SDL_GL_GREEN_SIZE')
register('GL_BLUE_SIZE', 'SDL_GL_BLUE_SIZE')
register('GL_ALPHA_SIZE', 'SDL_GL_ALPHA_SIZE')
register('GL_BUFFER_SIZE', 'SDL_GL_BUFFER_SIZE')
register('GL_DOUBLEBUFFER', 'SDL_GL_DOUBLEBUFFER')
register('GL_DEPTH_SIZE', 'SDL_GL_DEPTH_SIZE')
register('GL_STENCIL_SIZE', 'SDL_GL_STENCIL_SIZE')
register('GL_ACCUM_RED_SIZE', 'SDL_GL_ACCUM_RED_SIZE')
register('GL_ACCUM_GREEN_SIZE', 'SDL_GL_ACCUM_GREEN_SIZE')
register('GL_ACCUM_BLUE_SIZE', 'SDL_GL_ACCUM_BLUE_SIZE')
register('GL_ACCUM_ALPHA_SIZE', 'SDL_GL_ACCUM_ALPHA_SIZE')
register('GL_STEREO', 'SDL_GL_STEREO')
register('GL_MULTISAMPLEBUFFERS', 'SDL_GL_MULTISAMPLEBUFFERS')
register('GL_MULTISAMPLESAMPLES', 'SDL_GL_MULTISAMPLESAMPLES')
register('GL_ACCELERATED_VISUAL', 'SDL_GL_ACCELERATED_VISUAL')
register('GL_RETAINED_BACKING', 'SDL_GL_RETAINED_BACKING')
register('GL_CONTEXT_MAJOR_VERSION', 'SDL_GL_CONTEXT_MAJOR_VERSION')
register('GL_CONTEXT_MINOR_VERSION', 'SDL_GL_CONTEXT_MINOR_VERSION')
register('GL_CONTEXT_EGL', 'SDL_GL_CONTEXT_EGL')
register('GL_CONTEXT_FLAGS', 'SDL_GL_CONTEXT_FLAGS')
register('GL_CONTEXT_PROFILE_MASK', 'SDL_GL_CONTEXT_PROFILE_MASK')
register('GL_SHARE_WITH_CURRENT_CONTEXT', 'SDL_GL_SHARE_WITH_CURRENT_CONTEXT')
register('GL_CONTEXT_PROFILE_CORE', 'SDL_GL_CONTEXT_PROFILE_CORE')
register('GL_CONTEXT_PROFILE_COMPATIBILITY', 'SDL_GL_CONTEXT_PROFILE_COMPATIBILITY')
register('GL_CONTEXT_PROFILE_ES', 'SDL_GL_CONTEXT_PROFILE_ES')
register('GL_CONTEXT_DEBUG_FLAG', 'SDL_GL_CONTEXT_DEBUG_FLAG')
register('GL_CONTEXT_FORWARD_COMPATIBLE_FLAG', 'SDL_GL_CONTEXT_FORWARD_COMPATIBLE_FLAG')
register('GL_CONTEXT_ROBUST_ACCESS_FLAG', 'SDL_GL_CONTEXT_ROBUST_ACCESS_FLAG')
register('GL_CONTEXT_RESET_ISOLATION_FLAG', 'SDL_GL_CONTEXT_RESET_ISOLATION_FLAG')
register('SCANCODE_UNKNOWN', 'SDL_SCANCODE_UNKNOWN')
register('SCANCODE_A', 'SDL_SCANCODE_A')
register('SCANCODE_B', 'SDL_SCANCODE_B')
register('SCANCODE_C', 'SDL_SCANCODE_C')
register('SCANCODE_D', 'SDL_SCANCODE_D')
register('SCANCODE_E', 'SDL_SCANCODE_E')
register('SCANCODE_F', 'SDL_SCANCODE_F')
register('SCANCODE_G', 'SDL_SCANCODE_G')
register('SCANCODE_H', 'SDL_SCANCODE_H')
register('SCANCODE_I', 'SDL_SCANCODE_I')
register('SCANCODE_J', 'SDL_SCANCODE_J')
register('SCANCODE_K', 'SDL_SCANCODE_K')
register('SCANCODE_L', 'SDL_SCANCODE_L')
register('SCANCODE_M', 'SDL_SCANCODE_M')
register('SCANCODE_N', 'SDL_SCANCODE_N')
register('SCANCODE_O', 'SDL_SCANCODE_O')
register('SCANCODE_P', 'SDL_SCANCODE_P')
register('SCANCODE_Q', 'SDL_SCANCODE_Q')
register('SCANCODE_R', 'SDL_SCANCODE_R')
register('SCANCODE_S', 'SDL_SCANCODE_S')
register('SCANCODE_T', 'SDL_SCANCODE_T')
register('SCANCODE_U', 'SDL_SCANCODE_U')
register('SCANCODE_V', 'SDL_SCANCODE_V')
register('SCANCODE_W', 'SDL_SCANCODE_W')
register('SCANCODE_X', 'SDL_SCANCODE_X')
register('SCANCODE_Y', 'SDL_SCANCODE_Y')
register('SCANCODE_Z', 'SDL_SCANCODE_Z')
register('SCANCODE_1', 'SDL_SCANCODE_1')
register('SCANCODE_2', 'SDL_SCANCODE_2')
register('SCANCODE_3', 'SDL_SCANCODE_3')
register('SCANCODE_4', 'SDL_SCANCODE_4')
register('SCANCODE_5', 'SDL_SCANCODE_5')
register('SCANCODE_6', 'SDL_SCANCODE_6')
register('SCANCODE_7', 'SDL_SCANCODE_7')
register('SCANCODE_8', 'SDL_SCANCODE_8')
register('SCANCODE_9', 'SDL_SCANCODE_9')
register('SCANCODE_0', 'SDL_SCANCODE_0')
register('SCANCODE_RETURN', 'SDL_SCANCODE_RETURN')
register('SCANCODE_ESCAPE', 'SDL_SCANCODE_ESCAPE')
register('SCANCODE_BACKSPACE', 'SDL_SCANCODE_BACKSPACE')
register('SCANCODE_TAB', 'SDL_SCANCODE_TAB')
register('SCANCODE_SPACE', 'SDL_SCANCODE_SPACE')
register('SCANCODE_MINUS', 'SDL_SCANCODE_MINUS')
register('SCANCODE_EQUALS', 'SDL_SCANCODE_EQUALS')
register('SCANCODE_LEFTBRACKET', 'SDL_SCANCODE_LEFTBRACKET')
register('SCANCODE_RIGHTBRACKET', 'SDL_SCANCODE_RIGHTBRACKET')
register('SCANCODE_BACKSLASH', 'SDL_SCANCODE_BACKSLASH')
register('SCANCODE_NONUSHASH', 'SDL_SCANCODE_NONUSHASH')
register('SCANCODE_SEMICOLON', 'SDL_SCANCODE_SEMICOLON')
register('SCANCODE_APOSTROPHE', 'SDL_SCANCODE_APOSTROPHE')
register('SCANCODE_GRAVE', 'SDL_SCANCODE_GRAVE')
register('SCANCODE_COMMA', 'SDL_SCANCODE_COMMA')
register('SCANCODE_PERIOD', 'SDL_SCANCODE_PERIOD')
register('SCANCODE_SLASH', 'SDL_SCANCODE_SLASH')
register('SCANCODE_CAPSLOCK', 'SDL_SCANCODE_CAPSLOCK')
register('SCANCODE_F1', 'SDL_SCANCODE_F1')
register('SCANCODE_F2', 'SDL_SCANCODE_F2')
register('SCANCODE_F3', 'SDL_SCANCODE_F3')
register('SCANCODE_F4', 'SDL_SCANCODE_F4')
register('SCANCODE_F5', 'SDL_SCANCODE_F5')
register('SCANCODE_F6', 'SDL_SCANCODE_F6')
register('SCANCODE_F7', 'SDL_SCANCODE_F7')
register('SCANCODE_F8', 'SDL_SCANCODE_F8')
register('SCANCODE_F9', 'SDL_SCANCODE_F9')
register('SCANCODE_F10', 'SDL_SCANCODE_F10')
register('SCANCODE_F11', 'SDL_SCANCODE_F11')
register('SCANCODE_F12', 'SDL_SCANCODE_F12')
register('SCANCODE_PRINTSCREEN', 'SDL_SCANCODE_PRINTSCREEN')
register('SCANCODE_SCROLLLOCK', 'SDL_SCANCODE_SCROLLLOCK')
register('SCANCODE_PAUSE', 'SDL_SCANCODE_PAUSE')
register('SCANCODE_INSERT', 'SDL_SCANCODE_INSERT')
register('SCANCODE_HOME', 'SDL_SCANCODE_HOME')
register('SCANCODE_PAGEUP', 'SDL_SCANCODE_PAGEUP')
register('SCANCODE_DELETE', 'SDL_SCANCODE_DELETE')
register('SCANCODE_END', 'SDL_SCANCODE_END')
register('SCANCODE_PAGEDOWN', 'SDL_SCANCODE_PAGEDOWN')
register('SCANCODE_RIGHT', 'SDL_SCANCODE_RIGHT')
register('SCANCODE_LEFT', 'SDL_SCANCODE_LEFT')
register('SCANCODE_DOWN', 'SDL_SCANCODE_DOWN')
register('SCANCODE_UP', 'SDL_SCANCODE_UP')
register('SCANCODE_NUMLOCKCLEAR', 'SDL_SCANCODE_NUMLOCKCLEAR')
register('SCANCODE_KP_DIVIDE', 'SDL_SCANCODE_KP_DIVIDE')
register('SCANCODE_KP_MULTIPLY', 'SDL_SCANCODE_KP_MULTIPLY')
register('SCANCODE_KP_MINUS', 'SDL_SCANCODE_KP_MINUS')
register('SCANCODE_KP_PLUS', 'SDL_SCANCODE_KP_PLUS')
register('SCANCODE_KP_ENTER', 'SDL_SCANCODE_KP_ENTER')
register('SCANCODE_KP_1', 'SDL_SCANCODE_KP_1')
register('SCANCODE_KP_2', 'SDL_SCANCODE_KP_2')
register('SCANCODE_KP_3', 'SDL_SCANCODE_KP_3')
register('SCANCODE_KP_4', 'SDL_SCANCODE_KP_4')
register('SCANCODE_KP_5', 'SDL_SCANCODE_KP_5')
register('SCANCODE_KP_6', 'SDL_SCANCODE_KP_6')
register('SCANCODE_KP_7', 'SDL_SCANCODE_KP_7')
register('SCANCODE_KP_8', 'SDL_SCANCODE_KP_8')
register('SCANCODE_KP_9', 'SDL_SCANCODE_KP_9')
register('SCANCODE_KP_0', 'SDL_SCANCODE_KP_0')
register('SCANCODE_KP_PERIOD', 'SDL_SCANCODE_KP_PERIOD')
register('SCANCODE_NONUSBACKSLASH', 'SDL_SCANCODE_NONUSBACKSLASH')
register('SCANCODE_APPLICATION', 'SDL_SCANCODE_APPLICATION')
register('SCANCODE_POWER', 'SDL_SCANCODE_POWER')
register('SCANCODE_KP_EQUALS', 'SDL_SCANCODE_KP_EQUALS')
register('SCANCODE_F13', 'SDL_SCANCODE_F13')
register('SCANCODE_F14', 'SDL_SCANCODE_F14')
register('SCANCODE_F15', 'SDL_SCANCODE_F15')
register('SCANCODE_F16', 'SDL_SCANCODE_F16')
register('SCANCODE_F17', 'SDL_SCANCODE_F17')
register('SCANCODE_F18', 'SDL_SCANCODE_F18')
register('SCANCODE_F19', 'SDL_SCANCODE_F19')
register('SCANCODE_F20', 'SDL_SCANCODE_F20')
register('SCANCODE_F21', 'SDL_SCANCODE_F21')
register('SCANCODE_F22', 'SDL_SCANCODE_F22')
register('SCANCODE_F23', 'SDL_SCANCODE_F23')
register('SCANCODE_F24', 'SDL_SCANCODE_F24')
register('SCANCODE_EXECUTE', 'SDL_SCANCODE_EXECUTE')
register('SCANCODE_HELP', 'SDL_SCANCODE_HELP')
register('SCANCODE_MENU', 'SDL_SCANCODE_MENU')
register('SCANCODE_SELECT', 'SDL_SCANCODE_SELECT')
register('SCANCODE_STOP', 'SDL_SCANCODE_STOP')
register('SCANCODE_AGAIN', 'SDL_SCANCODE_AGAIN')
register('SCANCODE_UNDO', 'SDL_SCANCODE_UNDO')
register('SCANCODE_CUT', 'SDL_SCANCODE_CUT')
register('SCANCODE_COPY', 'SDL_SCANCODE_COPY')
register('SCANCODE_PASTE', 'SDL_SCANCODE_PASTE')
register('SCANCODE_FIND', 'SDL_SCANCODE_FIND')
register('SCANCODE_MUTE', 'SDL_SCANCODE_MUTE')
register('SCANCODE_VOLUMEUP', 'SDL_SCANCODE_VOLUMEUP')
register('SCANCODE_VOLUMEDOWN', 'SDL_SCANCODE_VOLUMEDOWN')
register('SCANCODE_KP_COMMA', 'SDL_SCANCODE_KP_COMMA')
register('SCANCODE_KP_EQUALSAS400', 'SDL_SCANCODE_KP_EQUALSAS400')
register('SCANCODE_INTERNATIONAL1', 'SDL_SCANCODE_INTERNATIONAL1')
register('SCANCODE_INTERNATIONAL2', 'SDL_SCANCODE_INTERNATIONAL2')
register('SCANCODE_INTERNATIONAL3', 'SDL_SCANCODE_INTERNATIONAL3')
register('SCANCODE_INTERNATIONAL4', 'SDL_SCANCODE_INTERNATIONAL4')
register('SCANCODE_INTERNATIONAL5', 'SDL_SCANCODE_INTERNATIONAL5')
register('SCANCODE_INTERNATIONAL6', 'SDL_SCANCODE_INTERNATIONAL6')
register('SCANCODE_INTERNATIONAL7', 'SDL_SCANCODE_INTERNATIONAL7')
register('SCANCODE_INTERNATIONAL8', 'SDL_SCANCODE_INTERNATIONAL8')
register('SCANCODE_INTERNATIONAL9', 'SDL_SCANCODE_INTERNATIONAL9')
register('SCANCODE_LANG1', 'SDL_SCANCODE_LANG1')
register('SCANCODE_LANG2', 'SDL_SCANCODE_LANG2')
register('SCANCODE_LANG3', 'SDL_SCANCODE_LANG3')
register('SCANCODE_LANG4', 'SDL_SCANCODE_LANG4')
register('SCANCODE_LANG5', 'SDL_SCANCODE_LANG5')
register('SCANCODE_LANG6', 'SDL_SCANCODE_LANG6')
register('SCANCODE_LANG7', 'SDL_SCANCODE_LANG7')
register('SCANCODE_LANG8', 'SDL_SCANCODE_LANG8')
register('SCANCODE_LANG9', 'SDL_SCANCODE_LANG9')
register('SCANCODE_ALTERASE', 'SDL_SCANCODE_ALTERASE')
register('SCANCODE_SYSREQ', 'SDL_SCANCODE_SYSREQ')
register('SCANCODE_CANCEL', 'SDL_SCANCODE_CANCEL')
register('SCANCODE_CLEAR', 'SDL_SCANCODE_CLEAR')
register('SCANCODE_PRIOR', 'SDL_SCANCODE_PRIOR')
register('SCANCODE_RETURN2', 'SDL_SCANCODE_RETURN2')
register('SCANCODE_SEPARATOR', 'SDL_SCANCODE_SEPARATOR')
register('SCANCODE_OUT', 'SDL_SCANCODE_OUT')
register('SCANCODE_OPER', 'SDL_SCANCODE_OPER')
register('SCANCODE_CLEARAGAIN', 'SDL_SCANCODE_CLEARAGAIN')
register('SCANCODE_CRSEL', 'SDL_SCANCODE_CRSEL')
register('SCANCODE_EXSEL', 'SDL_SCANCODE_EXSEL')
register('SCANCODE_KP_00', 'SDL_SCANCODE_KP_00')
register('SCANCODE_KP_000', 'SDL_SCANCODE_KP_000')
register('SCANCODE_THOUSANDSSEPARATOR', 'SDL_SCANCODE_THOUSANDSSEPARATOR')
register('SCANCODE_DECIMALSEPARATOR', 'SDL_SCANCODE_DECIMALSEPARATOR')
register('SCANCODE_CURRENCYUNIT', 'SDL_SCANCODE_CURRENCYUNIT')
register('SCANCODE_CURRENCYSUBUNIT', 'SDL_SCANCODE_CURRENCYSUBUNIT')
register('SCANCODE_KP_LEFTPAREN', 'SDL_SCANCODE_KP_LEFTPAREN')
register('SCANCODE_KP_RIGHTPAREN', 'SDL_SCANCODE_KP_RIGHTPAREN')
register('SCANCODE_KP_LEFTBRACE', 'SDL_SCANCODE_KP_LEFTBRACE')
register('SCANCODE_KP_RIGHTBRACE', 'SDL_SCANCODE_KP_RIGHTBRACE')
register('SCANCODE_KP_TAB', 'SDL_SCANCODE_KP_TAB')
register('SCANCODE_KP_BACKSPACE', 'SDL_SCANCODE_KP_BACKSPACE')
register('SCANCODE_KP_A', 'SDL_SCANCODE_KP_A')
register('SCANCODE_KP_B', 'SDL_SCANCODE_KP_B')
register('SCANCODE_KP_C', 'SDL_SCANCODE_KP_C')
register('SCANCODE_KP_D', 'SDL_SCANCODE_KP_D')
register('SCANCODE_KP_E', 'SDL_SCANCODE_KP_E')
register('SCANCODE_KP_F', 'SDL_SCANCODE_KP_F')
register('SCANCODE_KP_XOR', 'SDL_SCANCODE_KP_XOR')
register('SCANCODE_KP_POWER', 'SDL_SCANCODE_KP_POWER')
register('SCANCODE_KP_PERCENT', 'SDL_SCANCODE_KP_PERCENT')
register('SCANCODE_KP_LESS', 'SDL_SCANCODE_KP_LESS')
register('SCANCODE_KP_GREATER', 'SDL_SCANCODE_KP_GREATER')
register('SCANCODE_KP_AMPERSAND', 'SDL_SCANCODE_KP_AMPERSAND')
register('SCANCODE_KP_DBLAMPERSAND', 'SDL_SCANCODE_KP_DBLAMPERSAND')
register('SCANCODE_KP_VERTICALBAR', 'SDL_SCANCODE_KP_VERTICALBAR')
register('SCANCODE_KP_DBLVERTICALBAR', 'SDL_SCANCODE_KP_DBLVERTICALBAR')
register('SCANCODE_KP_COLON', 'SDL_SCANCODE_KP_COLON')
register('SCANCODE_KP_HASH', 'SDL_SCANCODE_KP_HASH')
register('SCANCODE_KP_SPACE', 'SDL_SCANCODE_KP_SPACE')
register('SCANCODE_KP_AT', 'SDL_SCANCODE_KP_AT')
register('SCANCODE_KP_EXCLAM', 'SDL_SCANCODE_KP_EXCLAM')
register('SCANCODE_KP_MEMSTORE', 'SDL_SCANCODE_KP_MEMSTORE')
register('SCANCODE_KP_MEMRECALL', 'SDL_SCANCODE_KP_MEMRECALL')
register('SCANCODE_KP_MEMCLEAR', 'SDL_SCANCODE_KP_MEMCLEAR')
register('SCANCODE_KP_MEMADD', 'SDL_SCANCODE_KP_MEMADD')
register('SCANCODE_KP_MEMSUBTRACT', 'SDL_SCANCODE_KP_MEMSUBTRACT')
register('SCANCODE_KP_MEMMULTIPLY', 'SDL_SCANCODE_KP_MEMMULTIPLY')
register('SCANCODE_KP_MEMDIVIDE', 'SDL_SCANCODE_KP_MEMDIVIDE')
register('SCANCODE_KP_PLUSMINUS', 'SDL_SCANCODE_KP_PLUSMINUS')
register('SCANCODE_KP_CLEAR', 'SDL_SCANCODE_KP_CLEAR')
register('SCANCODE_KP_CLEARENTRY', 'SDL_SCANCODE_KP_CLEARENTRY')
register('SCANCODE_KP_BINARY', 'SDL_SCANCODE_KP_BINARY')
register('SCANCODE_KP_OCTAL', 'SDL_SCANCODE_KP_OCTAL')
register('SCANCODE_KP_DECIMAL', 'SDL_SCANCODE_KP_DECIMAL')
register('SCANCODE_KP_HEXADECIMAL', 'SDL_SCANCODE_KP_HEXADECIMAL')
register('SCANCODE_LCTRL', 'SDL_SCANCODE_LCTRL')
register('SCANCODE_LSHIFT', 'SDL_SCANCODE_LSHIFT')
register('SCANCODE_LALT', 'SDL_SCANCODE_LALT')
register('SCANCODE_LGUI', 'SDL_SCANCODE_LGUI')
register('SCANCODE_RCTRL', 'SDL_SCANCODE_RCTRL')
register('SCANCODE_RSHIFT', 'SDL_SCANCODE_RSHIFT')
register('SCANCODE_RALT', 'SDL_SCANCODE_RALT')
register('SCANCODE_RGUI', 'SDL_SCANCODE_RGUI')
register('SCANCODE_MODE', 'SDL_SCANCODE_MODE')
register('SCANCODE_AUDIONEXT', 'SDL_SCANCODE_AUDIONEXT')
register('SCANCODE_AUDIOPREV', 'SDL_SCANCODE_AUDIOPREV')
register('SCANCODE_AUDIOSTOP', 'SDL_SCANCODE_AUDIOSTOP')
register('SCANCODE_AUDIOPLAY', 'SDL_SCANCODE_AUDIOPLAY')
register('SCANCODE_AUDIOMUTE', 'SDL_SCANCODE_AUDIOMUTE')
register('SCANCODE_MEDIASELECT', 'SDL_SCANCODE_MEDIASELECT')
register('SCANCODE_WWW', 'SDL_SCANCODE_WWW')
register('SCANCODE_MAIL', 'SDL_SCANCODE_MAIL')
register('SCANCODE_CALCULATOR', 'SDL_SCANCODE_CALCULATOR')
register('SCANCODE_COMPUTER', 'SDL_SCANCODE_COMPUTER')
register('SCANCODE_AC_SEARCH', 'SDL_SCANCODE_AC_SEARCH')
register('SCANCODE_AC_HOME', 'SDL_SCANCODE_AC_HOME')
register('SCANCODE_AC_BACK', 'SDL_SCANCODE_AC_BACK')
register('SCANCODE_AC_FORWARD', 'SDL_SCANCODE_AC_FORWARD')
register('SCANCODE_AC_STOP', 'SDL_SCANCODE_AC_STOP')
register('SCANCODE_AC_REFRESH', 'SDL_SCANCODE_AC_REFRESH')
register('SCANCODE_AC_BOOKMARKS', 'SDL_SCANCODE_AC_BOOKMARKS')
register('SCANCODE_BRIGHTNESSDOWN', 'SDL_SCANCODE_BRIGHTNESSDOWN')
register('SCANCODE_BRIGHTNESSUP', 'SDL_SCANCODE_BRIGHTNESSUP')
register('SCANCODE_DISPLAYSWITCH', 'SDL_SCANCODE_DISPLAYSWITCH')
register('SCANCODE_KBDILLUMTOGGLE', 'SDL_SCANCODE_KBDILLUMTOGGLE')
register('SCANCODE_KBDILLUMDOWN', 'SDL_SCANCODE_KBDILLUMDOWN')
register('SCANCODE_KBDILLUMUP', 'SDL_SCANCODE_KBDILLUMUP')
register('SCANCODE_EJECT', 'SDL_SCANCODE_EJECT')
register('SCANCODE_SLEEP', 'SDL_SCANCODE_SLEEP')
register('SCANCODE_APP1', 'SDL_SCANCODE_APP1')
register('SCANCODE_APP2', 'SDL_SCANCODE_APP2')
register('NUM_SCANCODES', 'SDL_NUM_SCANCODES')
register('SCANCODE_CAPSLOCK', 'SDL_SCANCODE_CAPSLOCK')
register('SCANCODE_F1', 'SDL_SCANCODE_F1')
register('SCANCODE_F2', 'SDL_SCANCODE_F2')
register('SCANCODE_F3', 'SDL_SCANCODE_F3')
register('SCANCODE_F4', 'SDL_SCANCODE_F4')
register('SCANCODE_F5', 'SDL_SCANCODE_F5')
register('SCANCODE_F6', 'SDL_SCANCODE_F6')
register('SCANCODE_F7', 'SDL_SCANCODE_F7')
register('SCANCODE_F8', 'SDL_SCANCODE_F8')
register('SCANCODE_F9', 'SDL_SCANCODE_F9')
register('SCANCODE_F10', 'SDL_SCANCODE_F10')
register('SCANCODE_F11', 'SDL_SCANCODE_F11')
register('SCANCODE_F12', 'SDL_SCANCODE_F12')
register('SCANCODE_PRINTSCREEN', 'SDL_SCANCODE_PRINTSCREEN')
register('SCANCODE_SCROLLLOCK', 'SDL_SCANCODE_SCROLLLOCK')
register('SCANCODE_PAUSE', 'SDL_SCANCODE_PAUSE')
register('SCANCODE_INSERT', 'SDL_SCANCODE_INSERT')
register('SCANCODE_HOME', 'SDL_SCANCODE_HOME')
register('SCANCODE_PAGEUP', 'SDL_SCANCODE_PAGEUP')
register('SCANCODE_END', 'SDL_SCANCODE_END')
register('SCANCODE_PAGEDOWN', 'SDL_SCANCODE_PAGEDOWN')
register('SCANCODE_RIGHT', 'SDL_SCANCODE_RIGHT')
register('SCANCODE_LEFT', 'SDL_SCANCODE_LEFT')
register('SCANCODE_DOWN', 'SDL_SCANCODE_DOWN')
register('SCANCODE_UP', 'SDL_SCANCODE_UP')
register('SCANCODE_NUMLOCKCLEAR', 'SDL_SCANCODE_NUMLOCKCLEAR')
register('SCANCODE_KP_DIVIDE', 'SDL_SCANCODE_KP_DIVIDE')
register('SCANCODE_KP_MULTIPLY', 'SDL_SCANCODE_KP_MULTIPLY')
register('SCANCODE_KP_MINUS', 'SDL_SCANCODE_KP_MINUS')
register('SCANCODE_KP_PLUS', 'SDL_SCANCODE_KP_PLUS')
register('SCANCODE_KP_ENTER', 'SDL_SCANCODE_KP_ENTER')
register('SCANCODE_KP_1', 'SDL_SCANCODE_KP_1')
register('SCANCODE_KP_2', 'SDL_SCANCODE_KP_2')
register('SCANCODE_KP_3', 'SDL_SCANCODE_KP_3')
register('SCANCODE_KP_4', 'SDL_SCANCODE_KP_4')
register('SCANCODE_KP_5', 'SDL_SCANCODE_KP_5')
register('SCANCODE_KP_6', 'SDL_SCANCODE_KP_6')
register('SCANCODE_KP_7', 'SDL_SCANCODE_KP_7')
register('SCANCODE_KP_8', 'SDL_SCANCODE_KP_8')
register('SCANCODE_KP_9', 'SDL_SCANCODE_KP_9')
register('SCANCODE_KP_0', 'SDL_SCANCODE_KP_0')
register('SCANCODE_KP_PERIOD', 'SDL_SCANCODE_KP_PERIOD')
register('SCANCODE_APPLICATION', 'SDL_SCANCODE_APPLICATION')
register('SCANCODE_POWER', 'SDL_SCANCODE_POWER')
register('SCANCODE_KP_EQUALS', 'SDL_SCANCODE_KP_EQUALS')
register('SCANCODE_F13', 'SDL_SCANCODE_F13')
register('SCANCODE_F14', 'SDL_SCANCODE_F14')
register('SCANCODE_F15', 'SDL_SCANCODE_F15')
register('SCANCODE_F16', 'SDL_SCANCODE_F16')
register('SCANCODE_F17', 'SDL_SCANCODE_F17')
register('SCANCODE_F18', 'SDL_SCANCODE_F18')
register('SCANCODE_F19', 'SDL_SCANCODE_F19')
register('SCANCODE_F20', 'SDL_SCANCODE_F20')
register('SCANCODE_F21', 'SDL_SCANCODE_F21')
register('SCANCODE_F22', 'SDL_SCANCODE_F22')
register('SCANCODE_F23', 'SDL_SCANCODE_F23')
register('SCANCODE_F24', 'SDL_SCANCODE_F24')
register('SCANCODE_EXECUTE', 'SDL_SCANCODE_EXECUTE')
register('SCANCODE_HELP', 'SDL_SCANCODE_HELP')
register('SCANCODE_MENU', 'SDL_SCANCODE_MENU')
register('SCANCODE_SELECT', 'SDL_SCANCODE_SELECT')
register('SCANCODE_STOP', 'SDL_SCANCODE_STOP')
register('SCANCODE_AGAIN', 'SDL_SCANCODE_AGAIN')
register('SCANCODE_UNDO', 'SDL_SCANCODE_UNDO')
register('SCANCODE_CUT', 'SDL_SCANCODE_CUT')
register('SCANCODE_COPY', 'SDL_SCANCODE_COPY')
register('SCANCODE_PASTE', 'SDL_SCANCODE_PASTE')
register('SCANCODE_FIND', 'SDL_SCANCODE_FIND')
register('SCANCODE_MUTE', 'SDL_SCANCODE_MUTE')
register('SCANCODE_VOLUMEUP', 'SDL_SCANCODE_VOLUMEUP')
register('SCANCODE_VOLUMEDOWN', 'SDL_SCANCODE_VOLUMEDOWN')
register('SCANCODE_KP_COMMA', 'SDL_SCANCODE_KP_COMMA')
register('SCANCODE_KP_EQUALSAS400', 'SDL_SCANCODE_KP_EQUALSAS400')
register('SCANCODE_ALTERASE', 'SDL_SCANCODE_ALTERASE')
register('SCANCODE_SYSREQ', 'SDL_SCANCODE_SYSREQ')
register('SCANCODE_CANCEL', 'SDL_SCANCODE_CANCEL')
register('SCANCODE_CLEAR', 'SDL_SCANCODE_CLEAR')
register('SCANCODE_PRIOR', 'SDL_SCANCODE_PRIOR')
register('SCANCODE_RETURN2', 'SDL_SCANCODE_RETURN2')
register('SCANCODE_SEPARATOR', 'SDL_SCANCODE_SEPARATOR')
register('SCANCODE_OUT', 'SDL_SCANCODE_OUT')
register('SCANCODE_OPER', 'SDL_SCANCODE_OPER')
register('SCANCODE_CLEARAGAIN', 'SDL_SCANCODE_CLEARAGAIN')
register('SCANCODE_CRSEL', 'SDL_SCANCODE_CRSEL')
register('SCANCODE_EXSEL', 'SDL_SCANCODE_EXSEL')
register('SCANCODE_KP_00', 'SDL_SCANCODE_KP_00')
register('SCANCODE_KP_000', 'SDL_SCANCODE_KP_000')
register('SCANCODE_THOUSANDSSEPARATOR', 'SDL_SCANCODE_THOUSANDSSEPARATOR')
register('SCANCODE_DECIMALSEPARATOR', 'SDL_SCANCODE_DECIMALSEPARATOR')
register('SCANCODE_CURRENCYUNIT', 'SDL_SCANCODE_CURRENCYUNIT')
register('SCANCODE_CURRENCYSUBUNIT', 'SDL_SCANCODE_CURRENCYSUBUNIT')
register('SCANCODE_KP_LEFTPAREN', 'SDL_SCANCODE_KP_LEFTPAREN')
register('SCANCODE_KP_RIGHTPAREN', 'SDL_SCANCODE_KP_RIGHTPAREN')
register('SCANCODE_KP_LEFTBRACE', 'SDL_SCANCODE_KP_LEFTBRACE')
register('SCANCODE_KP_RIGHTBRACE', 'SDL_SCANCODE_KP_RIGHTBRACE')
register('SCANCODE_KP_TAB', 'SDL_SCANCODE_KP_TAB')
register('SCANCODE_KP_BACKSPACE', 'SDL_SCANCODE_KP_BACKSPACE')
register('SCANCODE_KP_A', 'SDL_SCANCODE_KP_A')
register('SCANCODE_KP_B', 'SDL_SCANCODE_KP_B')
register('SCANCODE_KP_C', 'SDL_SCANCODE_KP_C')
register('SCANCODE_KP_D', 'SDL_SCANCODE_KP_D')
register('SCANCODE_KP_E', 'SDL_SCANCODE_KP_E')
register('SCANCODE_KP_F', 'SDL_SCANCODE_KP_F')
register('SCANCODE_KP_XOR', 'SDL_SCANCODE_KP_XOR')
register('SCANCODE_KP_POWER', 'SDL_SCANCODE_KP_POWER')
register('SCANCODE_KP_PERCENT', 'SDL_SCANCODE_KP_PERCENT')
register('SCANCODE_KP_LESS', 'SDL_SCANCODE_KP_LESS')
register('SCANCODE_KP_GREATER', 'SDL_SCANCODE_KP_GREATER')
register('SCANCODE_KP_AMPERSAND', 'SDL_SCANCODE_KP_AMPERSAND')
register('SCANCODE_KP_DBLAMPERSAND', 'SDL_SCANCODE_KP_DBLAMPERSAND')
register('SCANCODE_KP_VERTICALBAR', 'SDL_SCANCODE_KP_VERTICALBAR')
register('SCANCODE_KP_DBLVERTICALBAR', 'SDL_SCANCODE_KP_DBLVERTICALBAR')
register('SCANCODE_KP_COLON', 'SDL_SCANCODE_KP_COLON')
register('SCANCODE_KP_HASH', 'SDL_SCANCODE_KP_HASH')
register('SCANCODE_KP_SPACE', 'SDL_SCANCODE_KP_SPACE')
register('SCANCODE_KP_AT', 'SDL_SCANCODE_KP_AT')
register('SCANCODE_KP_EXCLAM', 'SDL_SCANCODE_KP_EXCLAM')
register('SCANCODE_KP_MEMSTORE', 'SDL_SCANCODE_KP_MEMSTORE')
register('SCANCODE_KP_MEMRECALL', 'SDL_SCANCODE_KP_MEMRECALL')
register('SCANCODE_KP_MEMCLEAR', 'SDL_SCANCODE_KP_MEMCLEAR')
register('SCANCODE_KP_MEMADD', 'SDL_SCANCODE_KP_MEMADD')
register('SCANCODE_KP_MEMSUBTRACT', 'SDL_SCANCODE_KP_MEMSUBTRACT')
register('SCANCODE_KP_MEMMULTIPLY', 'SDL_SCANCODE_KP_MEMMULTIPLY')
register('SCANCODE_KP_MEMDIVIDE', 'SDL_SCANCODE_KP_MEMDIVIDE')
register('SCANCODE_KP_PLUSMINUS', 'SDL_SCANCODE_KP_PLUSMINUS')
register('SCANCODE_KP_CLEAR', 'SDL_SCANCODE_KP_CLEAR')
register('SCANCODE_KP_CLEARENTRY', 'SDL_SCANCODE_KP_CLEARENTRY')
register('SCANCODE_KP_BINARY', 'SDL_SCANCODE_KP_BINARY')
register('SCANCODE_KP_OCTAL', 'SDL_SCANCODE_KP_OCTAL')
register('SCANCODE_KP_DECIMAL', 'SDL_SCANCODE_KP_DECIMAL')
register('SCANCODE_KP_HEXADECIMAL', 'SDL_SCANCODE_KP_HEXADECIMAL')
register('SCANCODE_LCTRL', 'SDL_SCANCODE_LCTRL')
register('SCANCODE_LSHIFT', 'SDL_SCANCODE_LSHIFT')
register('SCANCODE_LALT', 'SDL_SCANCODE_LALT')
register('SCANCODE_LGUI', 'SDL_SCANCODE_LGUI')
register('SCANCODE_RCTRL', 'SDL_SCANCODE_RCTRL')
register('SCANCODE_RSHIFT', 'SDL_SCANCODE_RSHIFT')
register('SCANCODE_RALT', 'SDL_SCANCODE_RALT')
register('SCANCODE_RGUI', 'SDL_SCANCODE_RGUI')
register('SCANCODE_MODE', 'SDL_SCANCODE_MODE')
register('SCANCODE_AUDIONEXT', 'SDL_SCANCODE_AUDIONEXT')
register('SCANCODE_AUDIOPREV', 'SDL_SCANCODE_AUDIOPREV')
register('SCANCODE_AUDIOSTOP', 'SDL_SCANCODE_AUDIOSTOP')
register('SCANCODE_AUDIOPLAY', 'SDL_SCANCODE_AUDIOPLAY')
register('SCANCODE_AUDIOMUTE', 'SDL_SCANCODE_AUDIOMUTE')
register('SCANCODE_MEDIASELECT', 'SDL_SCANCODE_MEDIASELECT')
register('SCANCODE_WWW', 'SDL_SCANCODE_WWW')
register('SCANCODE_MAIL', 'SDL_SCANCODE_MAIL')
register('SCANCODE_CALCULATOR', 'SDL_SCANCODE_CALCULATOR')
register('SCANCODE_COMPUTER', 'SDL_SCANCODE_COMPUTER')
register('SCANCODE_AC_SEARCH', 'SDL_SCANCODE_AC_SEARCH')
register('SCANCODE_AC_HOME', 'SDL_SCANCODE_AC_HOME')
register('SCANCODE_AC_BACK', 'SDL_SCANCODE_AC_BACK')
register('SCANCODE_AC_FORWARD', 'SDL_SCANCODE_AC_FORWARD')
register('SCANCODE_AC_STOP', 'SDL_SCANCODE_AC_STOP')
register('SCANCODE_AC_REFRESH', 'SDL_SCANCODE_AC_REFRESH')
register('SCANCODE_AC_BOOKMARKS', 'SDL_SCANCODE_AC_BOOKMARKS')
register('SCANCODE_BRIGHTNESSDOWN', 'SDL_SCANCODE_BRIGHTNESSDOWN')
register('SCANCODE_BRIGHTNESSUP', 'SDL_SCANCODE_BRIGHTNESSUP')
register('SCANCODE_DISPLAYSWITCH', 'SDL_SCANCODE_DISPLAYSWITCH')
register('SCANCODE_KBDILLUMTOGGLE', 'SDL_SCANCODE_KBDILLUMTOGGLE')
register('SCANCODE_KBDILLUMDOWN', 'SDL_SCANCODE_KBDILLUMDOWN')
register('SCANCODE_KBDILLUMUP', 'SDL_SCANCODE_KBDILLUMUP')
register('SCANCODE_EJECT', 'SDL_SCANCODE_EJECT')
register('SCANCODE_SLEEP', 'SDL_SCANCODE_SLEEP')
register('KMOD_NONE', 'SDL_KMOD_NONE')
register('KMOD_LSHIFT', 'SDL_KMOD_LSHIFT')
register('KMOD_RSHIFT', 'SDL_KMOD_RSHIFT')
register('KMOD_LCTRL', 'SDL_KMOD_LCTRL')
register('KMOD_RCTRL', 'SDL_KMOD_RCTRL')
register('KMOD_LALT', 'SDL_KMOD_LALT')
register('KMOD_RALT', 'SDL_KMOD_RALT')
register('KMOD_LGUI', 'SDL_KMOD_LGUI')
register('KMOD_RGUI', 'SDL_KMOD_RGUI')
register('KMOD_NUM', 'SDL_KMOD_NUM')
register('KMOD_CAPS', 'SDL_KMOD_CAPS')
register('KMOD_MODE', 'SDL_KMOD_MODE')
register('KMOD_RESERVED', 'SDL_KMOD_RESERVED')
register('SYSTEM_CURSOR_ARROW', 'SDL_SYSTEM_CURSOR_ARROW')
register('SYSTEM_CURSOR_IBEAM', 'SDL_SYSTEM_CURSOR_IBEAM')
register('SYSTEM_CURSOR_WAIT', 'SDL_SYSTEM_CURSOR_WAIT')
register('SYSTEM_CURSOR_CROSSHAIR', 'SDL_SYSTEM_CURSOR_CROSSHAIR')
register('SYSTEM_CURSOR_WAITARROW', 'SDL_SYSTEM_CURSOR_WAITARROW')
register('SYSTEM_CURSOR_SIZENWSE', 'SDL_SYSTEM_CURSOR_SIZENWSE')
register('SYSTEM_CURSOR_SIZENESW', 'SDL_SYSTEM_CURSOR_SIZENESW')
register('SYSTEM_CURSOR_SIZEWE', 'SDL_SYSTEM_CURSOR_SIZEWE')
register('SYSTEM_CURSOR_SIZENS', 'SDL_SYSTEM_CURSOR_SIZENS')
register('SYSTEM_CURSOR_SIZEALL', 'SDL_SYSTEM_CURSOR_SIZEALL')
register('SYSTEM_CURSOR_NO', 'SDL_SYSTEM_CURSOR_NO')
register('SYSTEM_CURSOR_HAND', 'SDL_SYSTEM_CURSOR_HAND')
register('NUM_SYSTEM_CURSORS', 'SDL_NUM_SYSTEM_CURSORS')
register('CONTROLLER_BINDTYPE_NONE', 'SDL_CONTROLLER_BINDTYPE_NONE')
register('CONTROLLER_BINDTYPE_BUTTON', 'SDL_CONTROLLER_BINDTYPE_BUTTON')
register('CONTROLLER_BINDTYPE_AXIS', 'SDL_CONTROLLER_BINDTYPE_AXIS')
register('CONTROLLER_BINDTYPE_HAT', 'SDL_CONTROLLER_BINDTYPE_HAT')
register('CONTROLLER_AXIS_INVALID', 'SDL_CONTROLLER_AXIS_INVALID')
register('CONTROLLER_AXIS_LEFTX', 'SDL_CONTROLLER_AXIS_LEFTX')
register('CONTROLLER_AXIS_LEFTY', 'SDL_CONTROLLER_AXIS_LEFTY')
register('CONTROLLER_AXIS_RIGHTX', 'SDL_CONTROLLER_AXIS_RIGHTX')
register('CONTROLLER_AXIS_RIGHTY', 'SDL_CONTROLLER_AXIS_RIGHTY')
register('CONTROLLER_AXIS_TRIGGERLEFT', 'SDL_CONTROLLER_AXIS_TRIGGERLEFT')
register('CONTROLLER_AXIS_TRIGGERRIGHT', 'SDL_CONTROLLER_AXIS_TRIGGERRIGHT')
register('CONTROLLER_AXIS_MAX', 'SDL_CONTROLLER_AXIS_MAX')
register('CONTROLLER_BUTTON_INVALID', 'SDL_CONTROLLER_BUTTON_INVALID')
register('CONTROLLER_BUTTON_A', 'SDL_CONTROLLER_BUTTON_A')
register('CONTROLLER_BUTTON_B', 'SDL_CONTROLLER_BUTTON_B')
register('CONTROLLER_BUTTON_X', 'SDL_CONTROLLER_BUTTON_X')
register('CONTROLLER_BUTTON_Y', 'SDL_CONTROLLER_BUTTON_Y')
register('CONTROLLER_BUTTON_BACK', 'SDL_CONTROLLER_BUTTON_BACK')
register('CONTROLLER_BUTTON_GUIDE', 'SDL_CONTROLLER_BUTTON_GUIDE')
register('CONTROLLER_BUTTON_START', 'SDL_CONTROLLER_BUTTON_START')
register('CONTROLLER_BUTTON_LEFTSTICK', 'SDL_CONTROLLER_BUTTON_LEFTSTICK')
register('CONTROLLER_BUTTON_RIGHTSTICK', 'SDL_CONTROLLER_BUTTON_RIGHTSTICK')
register('CONTROLLER_BUTTON_LEFTSHOULDER', 'SDL_CONTROLLER_BUTTON_LEFTSHOULDER')
register('CONTROLLER_BUTTON_RIGHTSHOULDER', 'SDL_CONTROLLER_BUTTON_RIGHTSHOULDER')
register('CONTROLLER_BUTTON_DPAD_UP', 'SDL_CONTROLLER_BUTTON_DPAD_UP')
register('CONTROLLER_BUTTON_DPAD_DOWN', 'SDL_CONTROLLER_BUTTON_DPAD_DOWN')
register('CONTROLLER_BUTTON_DPAD_LEFT', 'SDL_CONTROLLER_BUTTON_DPAD_LEFT')
register('CONTROLLER_BUTTON_DPAD_RIGHT', 'SDL_CONTROLLER_BUTTON_DPAD_RIGHT')
register('CONTROLLER_BUTTON_MAX', 'SDL_CONTROLLER_BUTTON_MAX')
register('FIRSTEVENT', 'SDL_FIRSTEVENT')
register('QUIT', 'SDL_QUIT')
register('APP_TERMINATING', 'SDL_APP_TERMINATING')
register('APP_LOWMEMORY', 'SDL_APP_LOWMEMORY')
register('APP_WILLENTERBACKGROUND', 'SDL_APP_WILLENTERBACKGROUND')
register('APP_DIDENTERBACKGROUND', 'SDL_APP_DIDENTERBACKGROUND')
register('APP_WILLENTERFOREGROUND', 'SDL_APP_WILLENTERFOREGROUND')
register('APP_DIDENTERFOREGROUND', 'SDL_APP_DIDENTERFOREGROUND')
register('WINDOWEVENT', 'SDL_WINDOWEVENT')
register('SYSWMEVENT', 'SDL_SYSWMEVENT')
register('KEYDOWN', 'SDL_KEYDOWN')
register('KEYUP', 'SDL_KEYUP')
register('TEXTEDITING', 'SDL_TEXTEDITING')
register('TEXTINPUT', 'SDL_TEXTINPUT')
register('MOUSEMOTION', 'SDL_MOUSEMOTION')
register('MOUSEBUTTONDOWN', 'SDL_MOUSEBUTTONDOWN')
register('MOUSEBUTTONUP', 'SDL_MOUSEBUTTONUP')
register('MOUSEWHEEL', 'SDL_MOUSEWHEEL')
register('JOYAXISMOTION', 'SDL_JOYAXISMOTION')
register('JOYBALLMOTION', 'SDL_JOYBALLMOTION')
register('JOYHATMOTION', 'SDL_JOYHATMOTION')
register('JOYBUTTONDOWN', 'SDL_JOYBUTTONDOWN')
register('JOYBUTTONUP', 'SDL_JOYBUTTONUP')
register('JOYDEVICEADDED', 'SDL_JOYDEVICEADDED')
register('JOYDEVICEREMOVED', 'SDL_JOYDEVICEREMOVED')
register('CONTROLLERAXISMOTION', 'SDL_CONTROLLERAXISMOTION')
register('CONTROLLERBUTTONDOWN', 'SDL_CONTROLLERBUTTONDOWN')
register('CONTROLLERBUTTONUP', 'SDL_CONTROLLERBUTTONUP')
register('CONTROLLERDEVICEADDED', 'SDL_CONTROLLERDEVICEADDED')
register('CONTROLLERDEVICEREMOVED', 'SDL_CONTROLLERDEVICEREMOVED')
register('CONTROLLERDEVICEREMAPPED', 'SDL_CONTROLLERDEVICEREMAPPED')
register('FINGERDOWN', 'SDL_FINGERDOWN')
register('FINGERUP', 'SDL_FINGERUP')
register('FINGERMOTION', 'SDL_FINGERMOTION')
register('DOLLARGESTURE', 'SDL_DOLLARGESTURE')
register('DOLLARRECORD', 'SDL_DOLLARRECORD')
register('MULTIGESTURE', 'SDL_MULTIGESTURE')
register('CLIPBOARDUPDATE', 'SDL_CLIPBOARDUPDATE')
register('DROPFILE', 'SDL_DROPFILE')
register('USEREVENT', 'SDL_USEREVENT')
register('LASTEVENT', 'SDL_LASTEVENT')
register('ADDEVENT', 'SDL_ADDEVENT')
register('PEEKEVENT', 'SDL_PEEKEVENT')
register('GETEVENT', 'SDL_GETEVENT')
register('HINT_DEFAULT', 'SDL_HINT_DEFAULT')
register('HINT_NORMAL', 'SDL_HINT_NORMAL')
register('HINT_OVERRIDE', 'SDL_HINT_OVERRIDE')
register('LOG_CATEGORY_APPLICATION', 'SDL_LOG_CATEGORY_APPLICATION')
register('LOG_CATEGORY_ERROR', 'SDL_LOG_CATEGORY_ERROR')
register('LOG_CATEGORY_ASSERT', 'SDL_LOG_CATEGORY_ASSERT')
register('LOG_CATEGORY_SYSTEM', 'SDL_LOG_CATEGORY_SYSTEM')
register('LOG_CATEGORY_AUDIO', 'SDL_LOG_CATEGORY_AUDIO')
register('LOG_CATEGORY_VIDEO', 'SDL_LOG_CATEGORY_VIDEO')
register('LOG_CATEGORY_RENDER', 'SDL_LOG_CATEGORY_RENDER')
register('LOG_CATEGORY_INPUT', 'SDL_LOG_CATEGORY_INPUT')
register('LOG_CATEGORY_TEST', 'SDL_LOG_CATEGORY_TEST')
register('LOG_CATEGORY_RESERVED1', 'SDL_LOG_CATEGORY_RESERVED1')
register('LOG_CATEGORY_RESERVED2', 'SDL_LOG_CATEGORY_RESERVED2')
register('LOG_CATEGORY_RESERVED3', 'SDL_LOG_CATEGORY_RESERVED3')
register('LOG_CATEGORY_RESERVED4', 'SDL_LOG_CATEGORY_RESERVED4')
register('LOG_CATEGORY_RESERVED5', 'SDL_LOG_CATEGORY_RESERVED5')
register('LOG_CATEGORY_RESERVED6', 'SDL_LOG_CATEGORY_RESERVED6')
register('LOG_CATEGORY_RESERVED7', 'SDL_LOG_CATEGORY_RESERVED7')
register('LOG_CATEGORY_RESERVED8', 'SDL_LOG_CATEGORY_RESERVED8')
register('LOG_CATEGORY_RESERVED9', 'SDL_LOG_CATEGORY_RESERVED9')
register('LOG_CATEGORY_RESERVED10', 'SDL_LOG_CATEGORY_RESERVED10')
register('LOG_CATEGORY_CUSTOM', 'SDL_LOG_CATEGORY_CUSTOM')
register('LOG_PRIORITY_VERBOSE', 'SDL_LOG_PRIORITY_VERBOSE')
register('LOG_PRIORITY_DEBUG', 'SDL_LOG_PRIORITY_DEBUG')
register('LOG_PRIORITY_INFO', 'SDL_LOG_PRIORITY_INFO')
register('LOG_PRIORITY_WARN', 'SDL_LOG_PRIORITY_WARN')
register('LOG_PRIORITY_ERROR', 'SDL_LOG_PRIORITY_ERROR')
register('LOG_PRIORITY_CRITICAL', 'SDL_LOG_PRIORITY_CRITICAL')
register('NUM_LOG_PRIORITIES', 'SDL_NUM_LOG_PRIORITIES')
register('MESSAGEBOX_ERROR', 'SDL_MESSAGEBOX_ERROR')
register('MESSAGEBOX_WARNING', 'SDL_MESSAGEBOX_WARNING')
register('MESSAGEBOX_INFORMATION', 'SDL_MESSAGEBOX_INFORMATION')
register('MESSAGEBOX_BUTTON_RETURNKEY_DEFAULT', 'SDL_MESSAGEBOX_BUTTON_RETURNKEY_DEFAULT')
register('MESSAGEBOX_BUTTON_ESCAPEKEY_DEFAULT', 'SDL_MESSAGEBOX_BUTTON_ESCAPEKEY_DEFAULT')
register('MESSAGEBOX_COLOR_BACKGROUND', 'SDL_MESSAGEBOX_COLOR_BACKGROUND')
register('MESSAGEBOX_COLOR_TEXT', 'SDL_MESSAGEBOX_COLOR_TEXT')
register('MESSAGEBOX_COLOR_BUTTON_BORDER', 'SDL_MESSAGEBOX_COLOR_BUTTON_BORDER')
register('MESSAGEBOX_COLOR_BUTTON_BACKGROUND', 'SDL_MESSAGEBOX_COLOR_BUTTON_BACKGROUND')
register('MESSAGEBOX_COLOR_BUTTON_SELECTED', 'SDL_MESSAGEBOX_COLOR_BUTTON_SELECTED')
register('MESSAGEBOX_COLOR_MAX', 'SDL_MESSAGEBOX_COLOR_MAX')
register('MESSAGEBOX_COLOR_MAX', 'SDL_MESSAGEBOX_COLOR_MAX')
register('POWERSTATE_UNKNOWN', 'SDL_POWERSTATE_UNKNOWN')
register('POWERSTATE_ON_BATTERY', 'SDL_POWERSTATE_ON_BATTERY')
register('POWERSTATE_NO_BATTERY', 'SDL_POWERSTATE_NO_BATTERY')
register('POWERSTATE_CHARGING', 'SDL_POWERSTATE_CHARGING')
register('POWERSTATE_CHARGED', 'SDL_POWERSTATE_CHARGED')
register('RENDERER_SOFTWARE', 'SDL_RENDERER_SOFTWARE')
register('RENDERER_ACCELERATED', 'SDL_RENDERER_ACCELERATED')
register('RENDERER_PRESENTVSYNC', 'SDL_RENDERER_PRESENTVSYNC')
register('RENDERER_TARGETTEXTURE', 'SDL_RENDERER_TARGETTEXTURE')
register('TEXTUREACCESS_STATIC', 'SDL_TEXTUREACCESS_STATIC')
register('TEXTUREACCESS_STREAMING', 'SDL_TEXTUREACCESS_STREAMING')
register('TEXTUREACCESS_TARGET', 'SDL_TEXTUREACCESS_TARGET')
register('TEXTUREMODULATE_NONE', 'SDL_TEXTUREMODULATE_NONE')
register('TEXTUREMODULATE_COLOR', 'SDL_TEXTUREMODULATE_COLOR')
register('TEXTUREMODULATE_ALPHA', 'SDL_TEXTUREMODULATE_ALPHA')
register('FLIP_NONE', 'SDL_FLIP_NONE')
register('FLIP_HORIZONTAL', 'SDL_FLIP_HORIZONTAL')
register('FLIP_VERTICAL', 'SDL_FLIP_VERTICAL')
register('INIT_TIMER', 'SDL_INIT_TIMER')
register('INIT_AUDIO', 'SDL_INIT_AUDIO')
register('INIT_VIDEO', 'SDL_INIT_VIDEO')
register('INIT_JOYSTICK', 'SDL_INIT_JOYSTICK')
register('INIT_HAPTIC', 'SDL_INIT_HAPTIC')
register('INIT_GAMECONTROLLER', 'SDL_INIT_GAMECONTROLLER')
register('INIT_EVENTS', 'SDL_INIT_EVENTS')
register('INIT_NOPARACHUTE', 'SDL_INIT_NOPARACHUTE')
register('INIT_EVERYTHING', 'SDL_INIT_EVERYTHING')
register('INIT_TIMER', 'SDL_INIT_TIMER')
register('INIT_AUDIO', 'SDL_INIT_AUDIO')
register('INIT_VIDEO', 'SDL_INIT_VIDEO')
register('INIT_EVENTS', 'SDL_INIT_EVENTS')
register('INIT_JOYSTICK', 'SDL_INIT_JOYSTICK')
register('INIT_HAPTIC', 'SDL_INIT_HAPTIC')
register('INIT_GAMECONTROLLER', 'SDL_INIT_GAMECONTROLLER')
register('AUDIO_MASK_BITSIZE', 'SDL_AUDIO_MASK_BITSIZE')
register('AUDIO_MASK_DATATYPE', 'SDL_AUDIO_MASK_DATATYPE')
register('AUDIO_MASK_ENDIAN', 'SDL_AUDIO_MASK_ENDIAN')
register('AUDIO_MASK_SIGNED', 'SDL_AUDIO_MASK_SIGNED')
register('AUDIO_U8', 'SDL_AUDIO_U8')
register('AUDIO_S8', 'SDL_AUDIO_S8')
register('AUDIO_U16LSB', 'SDL_AUDIO_U16LSB')
register('AUDIO_S16LSB', 'SDL_AUDIO_S16LSB')
register('AUDIO_U16MSB', 'SDL_AUDIO_U16MSB')
register('AUDIO_S16MSB', 'SDL_AUDIO_S16MSB')
register('AUDIO_U16', 'SDL_AUDIO_U16')
register('AUDIO_U16LSB', 'SDL_AUDIO_U16LSB')
register('AUDIO_S16', 'SDL_AUDIO_S16')
register('AUDIO_S16LSB', 'SDL_AUDIO_S16LSB')
register('AUDIO_S32LSB', 'SDL_AUDIO_S32LSB')
register('AUDIO_S32MSB', 'SDL_AUDIO_S32MSB')
register('AUDIO_S32', 'SDL_AUDIO_S32')
register('AUDIO_S32LSB', 'SDL_AUDIO_S32LSB')
register('AUDIO_F32LSB', 'SDL_AUDIO_F32LSB')
register('AUDIO_F32MSB', 'SDL_AUDIO_F32MSB')
register('AUDIO_F32', 'SDL_AUDIO_F32')
register('AUDIO_F32LSB', 'SDL_AUDIO_F32LSB')
register('AUDIO_ALLOW_FREQUENCY_CHANGE', 'SDL_AUDIO_ALLOW_FREQUENCY_CHANGE')
register('AUDIO_ALLOW_FORMAT_CHANGE', 'SDL_AUDIO_ALLOW_FORMAT_CHANGE')
register('AUDIO_ALLOW_CHANNELS_CHANGE', 'SDL_AUDIO_ALLOW_CHANNELS_CHANGE')
register('AUDIO_ALLOW_ANY_CHANGE', 'SDL_AUDIO_ALLOW_ANY_CHANGE')
register('AUDIO_ALLOW_FREQUENCY_CHANGE', 'SDL_AUDIO_ALLOW_FREQUENCY_CHANGE')
register('AUDIO_ALLOW_FORMAT_CHANGE', 'SDL_AUDIO_ALLOW_FORMAT_CHANGE')
register('AUDIO_ALLOW_CHANNELS_CHANGE', 'SDL_AUDIO_ALLOW_CHANNELS_CHANGE')
register('MIX_MAXVOLUME', 'SDL_MIX_MAXVOLUME')
register('RELEASED', 'SDL_RELEASED')
register('PRESSED', 'SDL_PRESSED')
register('QUERY', 'SDL_QUERY')
register('IGNORE', 'SDL_IGNORE')
register('DISABLE', 'SDL_DISABLE')
register('ENABLE', 'SDL_ENABLE')
register('HAPTIC_CONSTANT', 'SDL_HAPTIC_CONSTANT')
register('HAPTIC_SINE', 'SDL_HAPTIC_SINE')
register('HAPTIC_LEFTRIGHT', 'SDL_HAPTIC_LEFTRIGHT')
register('HAPTIC_TRIANGLE', 'SDL_HAPTIC_TRIANGLE')
register('HAPTIC_SAWTOOTHUP', 'SDL_HAPTIC_SAWTOOTHUP')
register('HAPTIC_SAWTOOTHDOWN', 'SDL_HAPTIC_SAWTOOTHDOWN')
register('HAPTIC_RAMP', 'SDL_HAPTIC_RAMP')
register('HAPTIC_SPRING', 'SDL_HAPTIC_SPRING')
register('HAPTIC_DAMPER', 'SDL_HAPTIC_DAMPER')
register('HAPTIC_INERTIA', 'SDL_HAPTIC_INERTIA')
register('HAPTIC_FRICTION', 'SDL_HAPTIC_FRICTION')
register('HAPTIC_CUSTOM', 'SDL_HAPTIC_CUSTOM')
register('HAPTIC_GAIN', 'SDL_HAPTIC_GAIN')
register('HAPTIC_AUTOCENTER', 'SDL_HAPTIC_AUTOCENTER')
register('HAPTIC_STATUS', 'SDL_HAPTIC_STATUS')
register('HAPTIC_PAUSE', 'SDL_HAPTIC_PAUSE')
register('HAPTIC_POLAR', 'SDL_HAPTIC_POLAR')
register('HAPTIC_CARTESIAN', 'SDL_HAPTIC_CARTESIAN')
register('HAPTIC_SPHERICAL', 'SDL_HAPTIC_SPHERICAL')
register('HAPTIC_INFINITY', 'SDL_HAPTIC_INFINITY')
register('HAT_CENTERED', 'SDL_HAT_CENTERED')
register('HAT_UP', 'SDL_HAT_UP')
register('HAT_RIGHT', 'SDL_HAT_RIGHT')
register('HAT_DOWN', 'SDL_HAT_DOWN')
register('HAT_LEFT', 'SDL_HAT_LEFT')
register('HAT_RIGHTUP', 'SDL_HAT_RIGHTUP')
register('HAT_RIGHT', 'SDL_HAT_RIGHT')
register('HAT_UP', 'SDL_HAT_UP')
register('HAT_RIGHTDOWN', 'SDL_HAT_RIGHTDOWN')
register('HAT_RIGHT', 'SDL_HAT_RIGHT')
register('HAT_DOWN', 'SDL_HAT_DOWN')
register('HAT_LEFTUP', 'SDL_HAT_LEFTUP')
register('HAT_LEFT', 'SDL_HAT_LEFT')
register('HAT_UP', 'SDL_HAT_UP')
register('HAT_LEFTDOWN', 'SDL_HAT_LEFTDOWN')
register('HAT_LEFT', 'SDL_HAT_LEFT')
register('HAT_DOWN', 'SDL_HAT_DOWN')
register('SCANCODE_MASK', 'SDL_SCANCODE_MASK')
register('KMOD_CTRL', 'SDL_KMOD_CTRL')
register('KMOD_LCTRL', 'SDL_KMOD_LCTRL')
register('KMOD_RCTRL', 'SDL_KMOD_RCTRL')
register('KMOD_SHIFT', 'SDL_KMOD_SHIFT')
register('KMOD_LSHIFT', 'SDL_KMOD_LSHIFT')
register('KMOD_RSHIFT', 'SDL_KMOD_RSHIFT')
register('KMOD_ALT', 'SDL_KMOD_ALT')
register('KMOD_LALT', 'SDL_KMOD_LALT')
register('KMOD_RALT', 'SDL_KMOD_RALT')
register('KMOD_GUI', 'SDL_KMOD_GUI')
register('KMOD_LGUI', 'SDL_KMOD_LGUI')
register('KMOD_RGUI', 'SDL_KMOD_RGUI')
register('BUTTON_LEFT', 'SDL_BUTTON_LEFT')
register('BUTTON_MIDDLE', 'SDL_BUTTON_MIDDLE')
register('BUTTON_RIGHT', 'SDL_BUTTON_RIGHT')
register('BUTTON_X1', 'SDL_BUTTON_X1')
register('BUTTON_X2', 'SDL_BUTTON_X2')
register('BUTTON_LMASK', 'SDL_BUTTON_LMASK')
register('BUTTON_LEFT-1', 'SDL_BUTTON_LEFT-1')
register('BUTTON_MMASK', 'SDL_BUTTON_MMASK')
register('BUTTON_MIDDLE-1', 'SDL_BUTTON_MIDDLE-1')
register('BUTTON_RMASK', 'SDL_BUTTON_RMASK')
register('BUTTON_RIGHT-1', 'SDL_BUTTON_RIGHT-1')
register('BUTTON_X1MASK', 'SDL_BUTTON_X1MASK')
register('BUTTON_X1-1', 'SDL_BUTTON_X1-1')
register('BUTTON_X2MASK', 'SDL_BUTTON_X2MASK')
register('BUTTON_X2-1', 'SDL_BUTTON_X2-1')
register('MUTEX_TIMEDOUT', 'SDL_MUTEX_TIMEDOUT')
register('MUTEX_MAXWAIT', 'SDL_MUTEX_MAXWAIT')
register('ALPHA_OPAQUE', 'SDL_ALPHA_OPAQUE')
register('ALPHA_TRANSPARENT', 'SDL_ALPHA_TRANSPARENT')
register('RWOPS_UNKNOWN', 'SDL_RWOPS_UNKNOWN')
register('RWOPS_WINFILE', 'SDL_RWOPS_WINFILE')
register('RWOPS_STDFILE', 'SDL_RWOPS_STDFILE')
register('RWOPS_JNIFILE', 'SDL_RWOPS_JNIFILE')
register('RWOPS_MEMORY', 'SDL_RWOPS_MEMORY')
register('RWOPS_MEMORY_RO', 'SDL_RWOPS_MEMORY_RO')
register('NONSHAPEABLE_WINDOW', 'SDL_NONSHAPEABLE_WINDOW')
register('INVALID_SHAPE_ARGUMENT', 'SDL_INVALID_SHAPE_ARGUMENT')
register('WINDOW_LACKS_SHAPE', 'SDL_WINDOW_LACKS_SHAPE')
register('SWSURFACE', 'SDL_SWSURFACE')
register('PREALLOC', 'SDL_PREALLOC')
register('RLEACCEL', 'SDL_RLEACCEL')
register('DONTFREE', 'SDL_DONTFREE')
register('WINDOWPOS_CENTERED_MASK', 'SDL_WINDOWPOS_CENTERED_MASK')
register('WINDOWPOS_CENTERED', 'SDL_WINDOWPOS_CENTERED')

from .pixelformats import * # overwrite some missing def's from register() calls
from .constants import * # including things that would otherwise involve math in an enum declaration
from .helpers import *