# just the pixel formats & macros
# from PySDL2

from .dso import _LIB

SDL_PIXELTYPE_UNKNOWN = _LIB.SDL_PIXELTYPE_UNKNOWN
SDL_PIXELTYPE_INDEX1 = _LIB.SDL_PIXELTYPE_INDEX1
SDL_PIXELTYPE_INDEX4 = _LIB.SDL_PIXELTYPE_INDEX4
SDL_PIXELTYPE_INDEX8 = _LIB.SDL_PIXELTYPE_INDEX8
SDL_PIXELTYPE_PACKED8 = _LIB.SDL_PIXELTYPE_PACKED8
SDL_PIXELTYPE_PACKED16 = _LIB.SDL_PIXELTYPE_PACKED16
SDL_PIXELTYPE_PACKED32 = _LIB.SDL_PIXELTYPE_PACKED32
SDL_PIXELTYPE_ARRAYU8 = _LIB.SDL_PIXELTYPE_ARRAYU8
SDL_PIXELTYPE_ARRAYU16 = _LIB.SDL_PIXELTYPE_ARRAYU16
SDL_PIXELTYPE_ARRAYU32 = _LIB.SDL_PIXELTYPE_ARRAYU32
SDL_PIXELTYPE_ARRAYF16 = _LIB.SDL_PIXELTYPE_ARRAYF16
SDL_PIXELTYPE_ARRAYF32 = _LIB.SDL_PIXELTYPE_ARRAYF32

SDL_BITMAPORDER_NONE = _LIB.SDL_BITMAPORDER_NONE
SDL_BITMAPORDER_4321 = _LIB.SDL_BITMAPORDER_4321
SDL_BITMAPORDER_1234 = _LIB.SDL_BITMAPORDER_1234

SDL_PACKEDORDER_NONE = _LIB.SDL_PACKEDORDER_NONE
SDL_PACKEDORDER_XRGB = _LIB.SDL_PACKEDORDER_XRGB
SDL_PACKEDORDER_RGBX = _LIB.SDL_PACKEDORDER_RGBX
SDL_PACKEDORDER_ARGB = _LIB.SDL_PACKEDORDER_ARGB
SDL_PACKEDORDER_RGBA = _LIB.SDL_PACKEDORDER_RGBA
SDL_PACKEDORDER_XBGR = _LIB.SDL_PACKEDORDER_XBGR
SDL_PACKEDORDER_BGRX = _LIB.SDL_PACKEDORDER_BGRX
SDL_PACKEDORDER_ABGR = _LIB.SDL_PACKEDORDER_ABGR
SDL_PACKEDORDER_BGRA = _LIB.SDL_PACKEDORDER_BGRA

SDL_ARRAYORDER_NONE = _LIB.SDL_ARRAYORDER_NONE
SDL_ARRAYORDER_RGB = _LIB.SDL_ARRAYORDER_RGB
SDL_ARRAYORDER_RGBA = _LIB.SDL_ARRAYORDER_RGBA
SDL_ARRAYORDER_ARGB = _LIB.SDL_ARRAYORDER_ARGB
SDL_ARRAYORDER_BGR = _LIB.SDL_ARRAYORDER_BGR
SDL_ARRAYORDER_BGRA = _LIB.SDL_ARRAYORDER_BGRA
SDL_ARRAYORDER_ABGR = _LIB.SDL_ARRAYORDER_ABGR

SDL_PACKEDLAYOUT_NONE = _LIB.SDL_PACKEDLAYOUT_NONE
SDL_PACKEDLAYOUT_332 = _LIB.SDL_PACKEDLAYOUT_332
SDL_PACKEDLAYOUT_4444 = _LIB.SDL_PACKEDLAYOUT_4444
SDL_PACKEDLAYOUT_1555 = _LIB.SDL_PACKEDLAYOUT_1555
SDL_PACKEDLAYOUT_5551 = _LIB.SDL_PACKEDLAYOUT_5551
SDL_PACKEDLAYOUT_565 = _LIB.SDL_PACKEDLAYOUT_565
SDL_PACKEDLAYOUT_8888 = _LIB.SDL_PACKEDLAYOUT_8888
SDL_PACKEDLAYOUT_2101010 = _LIB.SDL_PACKEDLAYOUT_2101010
SDL_PACKEDLAYOUT_1010102 = _LIB.SDL_PACKEDLAYOUT_1010102

# Macro re-implementations from PySDL2:
SDL_FOURCC = lambda a, b, c, d: (ord(a) << 0) | (ord(b) << 8) | (ord(c) << 16) | (ord(d) << 24)
SDL_DEFINE_PIXELFOURCC = SDL_FOURCC
SDL_DEFINE_PIXELFORMAT = lambda ptype, order, layout, bits, pbytes: ((1 << 28) | ((ptype) << 24) | ((order) << 20) | ((layout) << 16) | ((bits) << 8) | ((pbytes) << 0))
SDL_PIXELFLAG = lambda X: (((X) >> 28) & 0x0F)
SDL_PIXELTYPE = lambda X: (((X) >> 24) & 0x0F)
SDL_PIXELORDER = lambda X: (((X) >> 20) & 0x0F)
SDL_PIXELLAYOUT = lambda X: (((X) >> 16) & 0x0F)
SDL_BITSPERPIXEL = lambda X: (((X) >> 8) & 0xFF)
def SDL_BYTESPERPIXEL(x):
    valid = (SDL_PIXELFORMAT_YUY2, SDL_PIXELFORMAT_UYVY, SDL_PIXELFORMAT_YVYU)
    if SDL_ISPIXELFORMAT_FOURCC(x):
        if x in valid:
            return 2
        else:
            return 1
    else:
        return(((x) >> 0) & 0xFF)
def SDL_ISPIXELFORMAT_INDEXED(pformat):
    """Checks, if the passed format value is an indexed format."""
    return ((not SDL_ISPIXELFORMAT_FOURCC(pformat)) and
            ((SDL_PIXELTYPE(pformat) == SDL_PIXELTYPE_INDEX1) or
             (SDL_PIXELTYPE(pformat) == SDL_PIXELTYPE_INDEX4) or
             (SDL_PIXELTYPE(pformat) == SDL_PIXELTYPE_INDEX8)))
def SDL_ISPIXELFORMAT_ALPHA(pformat):
    """Checks, if the passed format value is an alpha channel supporting
    format.
    """
    return ((not SDL_ISPIXELFORMAT_FOURCC(pformat)) and
            ((SDL_PIXELORDER(pformat) == SDL_PACKEDORDER_ARGB) or
             (SDL_PIXELORDER(pformat) == SDL_PACKEDORDER_RGBA) or
             (SDL_PIXELORDER(pformat) == SDL_PACKEDORDER_ABGR) or
             (SDL_PIXELORDER(pformat) == SDL_PACKEDORDER_BGRA)))

# XXX could change these all to #define SDL_X ... in the cdef and grab once with .verify()

SDL_ISPIXELFORMAT_FOURCC = lambda fmt: ((fmt) and (SDL_PIXELFLAG(fmt) != 1))
SDL_PIXELFORMAT_UNKNOWN = 0
SDL_PIXELFORMAT_INDEX1LSB = SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_INDEX1,
                                                   SDL_BITMAPORDER_4321,
                                                   0, 1, 0)
SDL_PIXELFORMAT_INDEX1MSB = SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_INDEX1,
                                                   SDL_BITMAPORDER_1234,
                                                   0, 1, 0)
SDL_PIXELFORMAT_INDEX4LSB = SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_INDEX4,
                                                   SDL_BITMAPORDER_4321,
                                                   0, 4, 0)
SDL_PIXELFORMAT_INDEX4MSB = SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_INDEX4,
                                                   SDL_BITMAPORDER_1234,
                                                   0, 4, 0)
SDL_PIXELFORMAT_INDEX8 = SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_INDEX8, 0,
                                                0, 8, 1)
SDL_PIXELFORMAT_RGB332 = SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED8,
                                                SDL_PACKEDORDER_XRGB,
                                                SDL_PACKEDLAYOUT_332, 8, 1)
SDL_PIXELFORMAT_RGB444 = SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED16,
                                                SDL_PACKEDORDER_XRGB,
                                                SDL_PACKEDLAYOUT_4444, 12, 2)
SDL_PIXELFORMAT_RGB555 = SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED16,
                                                SDL_PACKEDORDER_XRGB,
                                                SDL_PACKEDLAYOUT_1555, 15, 2)
SDL_PIXELFORMAT_BGR555 = SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED16,
                                                SDL_PACKEDORDER_XBGR,
                                                SDL_PACKEDLAYOUT_1555, 15, 2)
SDL_PIXELFORMAT_ARGB4444 = SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED16,
                                                  SDL_PACKEDORDER_ARGB,
                                                  SDL_PACKEDLAYOUT_4444, 16, 2)
SDL_PIXELFORMAT_RGBA4444 = SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED16,
                                                  SDL_PACKEDORDER_RGBA,
                                                  SDL_PACKEDLAYOUT_4444, 16, 2)
SDL_PIXELFORMAT_ABGR4444 = SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED16,
                                                  SDL_PACKEDORDER_ABGR,
                                                  SDL_PACKEDLAYOUT_4444, 16, 2)
SDL_PIXELFORMAT_BGRA4444 = SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED16,
                                                  SDL_PACKEDORDER_BGRA,
                                                  SDL_PACKEDLAYOUT_4444, 16, 2)
SDL_PIXELFORMAT_ARGB1555 = SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED16,
                                                  SDL_PACKEDORDER_ARGB,
                                                  SDL_PACKEDLAYOUT_1555, 16, 2)
SDL_PIXELFORMAT_RGBA5551 = SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED16,
                                                  SDL_PACKEDORDER_RGBA,
                                                  SDL_PACKEDLAYOUT_5551, 16, 2)
SDL_PIXELFORMAT_ABGR1555 = SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED16,
                                                  SDL_PACKEDORDER_ABGR,
                                                  SDL_PACKEDLAYOUT_1555, 16, 2)
SDL_PIXELFORMAT_BGRA5551 = SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED16,
                                                  SDL_PACKEDORDER_BGRA,
                                                  SDL_PACKEDLAYOUT_5551, 16, 2)
SDL_PIXELFORMAT_RGB565 = SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED16,
                                                SDL_PACKEDORDER_XRGB,
                                                SDL_PACKEDLAYOUT_565, 16, 2)
SDL_PIXELFORMAT_BGR565 = SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED16,
                                                SDL_PACKEDORDER_XBGR,
                                                SDL_PACKEDLAYOUT_565, 16, 2)
SDL_PIXELFORMAT_RGB24 = SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_ARRAYU8,
                                               SDL_ARRAYORDER_RGB, 0, 24, 3)
SDL_PIXELFORMAT_BGR24 = SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_ARRAYU8,
                                               SDL_ARRAYORDER_BGR, 0, 24, 3)
SDL_PIXELFORMAT_RGB888 = SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED32,
                                                SDL_PACKEDORDER_XRGB,
                                                SDL_PACKEDLAYOUT_8888, 24, 4)
SDL_PIXELFORMAT_RGBX8888 = SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED32,
                                                  SDL_PACKEDORDER_RGBX,
                                                  SDL_PACKEDLAYOUT_8888, 24, 4)
SDL_PIXELFORMAT_BGR888 = SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED32,
                                                SDL_PACKEDORDER_XBGR,
                                                SDL_PACKEDLAYOUT_8888, 24, 4)
SDL_PIXELFORMAT_BGRX8888 = SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED32,
                                                  SDL_PACKEDORDER_BGRX,
                                                  SDL_PACKEDLAYOUT_8888, 24, 4)
SDL_PIXELFORMAT_ARGB8888 = SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED32,
                                                  SDL_PACKEDORDER_ARGB,
                                                  SDL_PACKEDLAYOUT_8888, 32, 4)
SDL_PIXELFORMAT_RGBA8888 = SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED32,
                                                  SDL_PACKEDORDER_RGBA,
                                                  SDL_PACKEDLAYOUT_8888, 32, 4)
SDL_PIXELFORMAT_ABGR8888 = SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED32,
                                                  SDL_PACKEDORDER_ABGR,
                                                  SDL_PACKEDLAYOUT_8888, 32, 4)
SDL_PIXELFORMAT_BGRA8888 = SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED32,
                                                  SDL_PACKEDORDER_BGRA,
                                                  SDL_PACKEDLAYOUT_8888, 32, 4)
SDL_PIXELFORMAT_ARGB2101010 = SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED32,
                                                     SDL_PACKEDORDER_ARGB,
                                                     SDL_PACKEDLAYOUT_2101010,
                                                     32, 4)
SDL_PIXELFORMAT_YV12 = SDL_DEFINE_PIXELFOURCC('Y', 'V', '1', '2')
SDL_PIXELFORMAT_IYUV = SDL_DEFINE_PIXELFOURCC('I', 'Y', 'U', 'V')
SDL_PIXELFORMAT_YUY2 = SDL_DEFINE_PIXELFOURCC('Y', 'U', 'Y', '2')
SDL_PIXELFORMAT_UYVY = SDL_DEFINE_PIXELFOURCC('U', 'Y', 'V', 'Y')
SDL_PIXELFORMAT_YVYU = SDL_DEFINE_PIXELFOURCC('Y', 'V', 'Y', 'U')

ALL_PIXELFORMATS = (
    SDL_PIXELFORMAT_INDEX1LSB,
    SDL_PIXELFORMAT_INDEX1MSB,
    SDL_PIXELFORMAT_INDEX4LSB,
    SDL_PIXELFORMAT_INDEX4MSB,
    SDL_PIXELFORMAT_INDEX8,
    SDL_PIXELFORMAT_RGB332,
    SDL_PIXELFORMAT_RGB444,
    SDL_PIXELFORMAT_RGB555,
    SDL_PIXELFORMAT_BGR555,
    SDL_PIXELFORMAT_ARGB4444,
    SDL_PIXELFORMAT_RGBA4444,
    SDL_PIXELFORMAT_ABGR4444,
    SDL_PIXELFORMAT_BGRA4444,
    SDL_PIXELFORMAT_ARGB1555,
    SDL_PIXELFORMAT_RGBA5551,
    SDL_PIXELFORMAT_ABGR1555,
    SDL_PIXELFORMAT_BGRA5551,
    SDL_PIXELFORMAT_RGB565,
    SDL_PIXELFORMAT_BGR565,
    SDL_PIXELFORMAT_RGB24,
    SDL_PIXELFORMAT_BGR24,
    SDL_PIXELFORMAT_RGB888,
    SDL_PIXELFORMAT_RGBX8888,
    SDL_PIXELFORMAT_BGR888,
    SDL_PIXELFORMAT_BGRX8888,
    SDL_PIXELFORMAT_ARGB8888,
    SDL_PIXELFORMAT_RGBA8888,
    SDL_PIXELFORMAT_ABGR8888,
    SDL_PIXELFORMAT_BGRA8888,
    SDL_PIXELFORMAT_ARGB2101010,
    SDL_PIXELFORMAT_YV12,
    SDL_PIXELFORMAT_IYUV,
    SDL_PIXELFORMAT_YUY2,
    SDL_PIXELFORMAT_UYVY,
    SDL_PIXELFORMAT_YVYU,
    )
