# The parts of SDL_pixels.h that can't be parsed by cffi.

from .autohelpers import (
    SDL_PIXELTYPE_UNKNOWN,
    SDL_PIXELTYPE_INDEX1,
    SDL_PIXELTYPE_INDEX4,
    SDL_PIXELTYPE_INDEX8,
    SDL_PIXELTYPE_PACKED8,
    SDL_PIXELTYPE_PACKED16,
    SDL_PIXELTYPE_PACKED32,
    SDL_PIXELTYPE_ARRAYU8,
    SDL_PIXELTYPE_ARRAYU16,
    SDL_PIXELTYPE_ARRAYU32,
    SDL_PIXELTYPE_ARRAYF16,
    SDL_PIXELTYPE_ARRAYF32,

    SDL_BITMAPORDER_NONE,
    SDL_BITMAPORDER_4321,
    SDL_BITMAPORDER_1234,

    SDL_PACKEDORDER_NONE,
    SDL_PACKEDORDER_XRGB,
    SDL_PACKEDORDER_RGBX,
    SDL_PACKEDORDER_ARGB,
    SDL_PACKEDORDER_RGBA,
    SDL_PACKEDORDER_XBGR,
    SDL_PACKEDORDER_BGRX,
    SDL_PACKEDORDER_ABGR,
    SDL_PACKEDORDER_BGRA,

    SDL_ARRAYORDER_NONE,
    SDL_ARRAYORDER_RGB,
    SDL_ARRAYORDER_RGBA,
    SDL_ARRAYORDER_ARGB,
    SDL_ARRAYORDER_BGR,
    SDL_ARRAYORDER_BGRA,
    SDL_ARRAYORDER_ABGR,

    SDL_PACKEDLAYOUT_NONE,
    SDL_PACKEDLAYOUT_332,
    SDL_PACKEDLAYOUT_4444,
    SDL_PACKEDLAYOUT_1555,
    SDL_PACKEDLAYOUT_5551,
    SDL_PACKEDLAYOUT_565,
    SDL_PACKEDLAYOUT_8888,
    SDL_PACKEDLAYOUT_2101010,
    SDL_PACKEDLAYOUT_1010102, )

SDL_ALPHA_OPAQUE=255
SDL_ALPHA_TRANSPARENT=0

def SDL_FOURCC(A, B, C, D):
    """Return a four-character code as a uint32."""
    return ord(A) | (ord(B)<<8) | (ord(C)<<16) | (ord(D)<<24)

SDL_DEFINE_PIXELFOURCC = SDL_FOURCC

def SDL_DEFINE_PIXELFORMAT(type, order, layout, bits, bytes):
    return ((1 << 28) | ((type) << 24) | ((order) << 20) | ((layout) << 16) |
            ((bits) << 8) | ((bytes) << 0))
def SDL_PIXELFLAG(X):
    return (((X) >> 28) & 0x0F)
def SDL_PIXELTYPE(X):
    return (((X) >> 24) & 0x0F)
def SDL_PIXELORDER(X):
    return (((X) >> 20) & 0x0F)
def SDL_PIXELLAYOUT(X):
    return (((X) >> 16) & 0x0F)
def SDL_BITSPERPIXEL(X):
    return (((X) >> 8) & 0xFF)
def SDL_BYTESPERPIXEL(X):
    if SDL_ISPIXELFORMAT_FOURCC(X):
        if (((X) == SDL_PIXELFORMAT_YUY2) or
            ((X) == SDL_PIXELFORMAT_UYVY) or
            ((X) == SDL_PIXELFORMAT_YVYU)):
            return 2
        return 1
    else:
        return (((X) >> 0) & 0xFF)

def SDL_ISPIXELFORMAT_INDEXED(format):
    return (not SDL_ISPIXELFORMAT_FOURCC(format) and
     ((SDL_PIXELTYPE(format) == SDL_PIXELTYPE_INDEX1) or
      (SDL_PIXELTYPE(format) == SDL_PIXELTYPE_INDEX4) or
      (SDL_PIXELTYPE(format) == SDL_PIXELTYPE_INDEX8)))

def SDL_ISPIXELFORMAT_ALPHA(format):
    return (not SDL_ISPIXELFORMAT_FOURCC(format) and
     ((SDL_PIXELORDER(format) == SDL_PACKEDORDER_ARGB) or
      (SDL_PIXELORDER(format) == SDL_PACKEDORDER_RGBA) or
      (SDL_PIXELORDER(format) == SDL_PACKEDORDER_ABGR) or
      (SDL_PIXELORDER(format) == SDL_PACKEDORDER_BGRA)))

# The flag is set to 1 because 0x1? is not in the printable ASCII range
def SDL_ISPIXELFORMAT_FOURCC(format):
    return ((format) and (SDL_PIXELFLAG(format) != 1))

SDL_PIXELFORMAT_UNKNOWN = 0
SDL_PIXELFORMAT_INDEX1LSB =\
    SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_INDEX1, SDL_BITMAPORDER_4321, 0,
                           1, 0)
SDL_PIXELFORMAT_INDEX1MSB =\
    SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_INDEX1, SDL_BITMAPORDER_1234, 0,
                           1, 0)
SDL_PIXELFORMAT_INDEX4LSB =\
    SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_INDEX4, SDL_BITMAPORDER_4321, 0,
                           4, 0)
SDL_PIXELFORMAT_INDEX4MSB =\
    SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_INDEX4, SDL_BITMAPORDER_1234, 0,
                           4, 0)
SDL_PIXELFORMAT_INDEX8 =\
    SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_INDEX8, 0, 0, 8, 1)
SDL_PIXELFORMAT_RGB332 =\
    SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED8, SDL_PACKEDORDER_XRGB,
                           SDL_PACKEDLAYOUT_332, 8, 1)
SDL_PIXELFORMAT_RGB444 =\
    SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED16, SDL_PACKEDORDER_XRGB,
                           SDL_PACKEDLAYOUT_4444, 12, 2)
SDL_PIXELFORMAT_RGB555 =\
    SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED16, SDL_PACKEDORDER_XRGB,
                           SDL_PACKEDLAYOUT_1555, 15, 2)
SDL_PIXELFORMAT_BGR555 =\
    SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED16, SDL_PACKEDORDER_XBGR,
                           SDL_PACKEDLAYOUT_1555, 15, 2)
SDL_PIXELFORMAT_ARGB4444 =\
    SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED16, SDL_PACKEDORDER_ARGB,
                           SDL_PACKEDLAYOUT_4444, 16, 2)
SDL_PIXELFORMAT_RGBA4444 =\
    SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED16, SDL_PACKEDORDER_RGBA,
                           SDL_PACKEDLAYOUT_4444, 16, 2)
SDL_PIXELFORMAT_ABGR4444 =\
    SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED16, SDL_PACKEDORDER_ABGR,
                           SDL_PACKEDLAYOUT_4444, 16, 2)
SDL_PIXELFORMAT_BGRA4444 =\
    SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED16, SDL_PACKEDORDER_BGRA,
                           SDL_PACKEDLAYOUT_4444, 16, 2)
SDL_PIXELFORMAT_ARGB1555 =\
    SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED16, SDL_PACKEDORDER_ARGB,
                           SDL_PACKEDLAYOUT_1555, 16, 2)
SDL_PIXELFORMAT_RGBA5551 =\
    SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED16, SDL_PACKEDORDER_RGBA,
                           SDL_PACKEDLAYOUT_5551, 16, 2)
SDL_PIXELFORMAT_ABGR1555 =\
    SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED16, SDL_PACKEDORDER_ABGR,
                           SDL_PACKEDLAYOUT_1555, 16, 2)
SDL_PIXELFORMAT_BGRA5551 =\
    SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED16, SDL_PACKEDORDER_BGRA,
                           SDL_PACKEDLAYOUT_5551, 16, 2)
SDL_PIXELFORMAT_RGB565 =\
    SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED16, SDL_PACKEDORDER_XRGB,
                           SDL_PACKEDLAYOUT_565, 16, 2)
SDL_PIXELFORMAT_BGR565 =\
    SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED16, SDL_PACKEDORDER_XBGR,
                           SDL_PACKEDLAYOUT_565, 16, 2)
SDL_PIXELFORMAT_RGB24 =\
    SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_ARRAYU8, SDL_ARRAYORDER_RGB, 0,
                           24, 3)
SDL_PIXELFORMAT_BGR24 =\
    SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_ARRAYU8, SDL_ARRAYORDER_BGR, 0,
                           24, 3)
SDL_PIXELFORMAT_RGB888 =\
    SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED32, SDL_PACKEDORDER_XRGB,
                           SDL_PACKEDLAYOUT_8888, 24, 4)
SDL_PIXELFORMAT_RGBX8888 =\
    SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED32, SDL_PACKEDORDER_RGBX,
                           SDL_PACKEDLAYOUT_8888, 24, 4)
SDL_PIXELFORMAT_BGR888 =\
    SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED32, SDL_PACKEDORDER_XBGR,
                           SDL_PACKEDLAYOUT_8888, 24, 4)
SDL_PIXELFORMAT_BGRX8888 =\
    SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED32, SDL_PACKEDORDER_BGRX,
                           SDL_PACKEDLAYOUT_8888, 24, 4)
SDL_PIXELFORMAT_ARGB8888 =\
    SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED32, SDL_PACKEDORDER_ARGB,
                           SDL_PACKEDLAYOUT_8888, 32, 4)
SDL_PIXELFORMAT_RGBA8888 =\
    SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED32, SDL_PACKEDORDER_RGBA,
                           SDL_PACKEDLAYOUT_8888, 32, 4)
SDL_PIXELFORMAT_ABGR8888 =\
    SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED32, SDL_PACKEDORDER_ABGR,
                           SDL_PACKEDLAYOUT_8888, 32, 4)
SDL_PIXELFORMAT_BGRA8888 =\
    SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED32, SDL_PACKEDORDER_BGRA,
                           SDL_PACKEDLAYOUT_8888, 32, 4)
SDL_PIXELFORMAT_ARGB2101010 =\
    SDL_DEFINE_PIXELFORMAT(SDL_PIXELTYPE_PACKED32, SDL_PACKEDORDER_ARGB,
                           SDL_PACKEDLAYOUT_2101010, 32, 4)

SDL_PIXELFORMAT_YV12 =\
    SDL_DEFINE_PIXELFOURCC('Y', 'V', '1', '2')
SDL_PIXELFORMAT_IYUV =\
    SDL_DEFINE_PIXELFOURCC('I', 'Y', 'U', 'V')
SDL_PIXELFORMAT_YUY2 =\
    SDL_DEFINE_PIXELFOURCC('Y', 'U', 'Y', '2')
SDL_PIXELFORMAT_UYVY =\
    SDL_DEFINE_PIXELFOURCC('U', 'Y', 'V', 'Y')
SDL_PIXELFORMAT_YVYU =\
    SDL_DEFINE_PIXELFOURCC('Y', 'V', 'Y', 'U')
