import scipy as sp
import pysep
from pysep.base import base
            
class distillation(base):
    def __init__(self,feed=None,name=''):
        r'''
        '''
        super().__init__()
        self.specs = {'F' : None,
                      'D' : None,
                      'B' : None,
                      'R' : None,
                      'Rb' : None, #Boilup rate
                      'Nf': None,
                      'Nt': None,
                      }
        
    def run(self):
        pass
    
    def _internal_flows(self):
        #Find feed quality q
        q = 0.5

        Lt = self.specs['D']*self.specs['R']
        Vt = Lt + self.specs['D']
        Lb = Lt + q*self.specs['F']
        Vb = Vt - (1-q)*self.specs['F']
        
        L = sp.zeros((self.specs['Nt']+2))
        V = sp.zeros((self.specs['Nt']+2))        
        
        L[0] = self.specs['D']
        V[0] = 0
        for n in range(1,self.specs['Nt']+2):
            if n > self.specs['Nf']:
                L[n] = Lt
                V[n] = Vt
            elif n == self.specs['Nf']:
                L[n] = Lt
                V[n] = Vb
            else:
                L[n] = Lb
                V[n] = Vb
                
        self.data = {}
        self.data['L'] = L
        self.data['V'] = V












