import scipy as sp
import pysep
from pysep.base import base
            
class flash(base):
    def __init__(self,feed,**kwargs):
        r'''
        '''
        super(flash,self).__init__(**kwargs)
        self.F = feed
    
    def run(self,P=None,T=None,phi=None):
        r'''
        '''
        self.T = T
        self.P = P
        self.phi = phi
        z = self.F['components']['mole_fraction']
        self._RR = self.rachford_rice(z=z,T=T,P=P,phi=phi)
        [L,V] = self._finalize()
        return L, V
        
    def _finalize(self):
        #Update properties of the outlet streams V and L
        V = self.F.clone(mode='full')
        L = self.F.clone(mode='full')
        x = {}
        y = {}
        K = dict([(item.name, item.Pvap(self.T)/self.P) for item in self.F._comps])
        z = self.F['components']['mole_fraction']
        for item in self.F._comps:
            x[item.name] = z[item.name]/(1 + self.phi*(K[item.name] - 1))
            y[item.name] = K[item.name]*x[item.name]
        V['molar_flow'] = self.F['molar_flow']*self.phi
        L['molar_flow'] = self.F['molar_flow']*(1-self.phi)
        V['components']['mole_fraction'].update(y)
        L['components']['mole_fraction'].update(x)
        L['temperature'] = self.T
        V['temperature'] = self.T
        L['pressure'] = self.P
        V['pressure'] = self.P
        return L, V
        
    def rachford_rice(self,z,T=None,P=None,phi=None):
        r'''
        '''
        TP = PV = TV = False
        if T and P:
            TP = True
            f = 1.01  # Set numerical derivative spacing parameter
            tol = 1e-8
            phi = 0.5  # Guess phi
            K = dict([(item.name, item.Pvap(T)/P) for item in self.F._comps])  # Calculate K
        elif P and phi:
            PV = True
            f = 1.00001  # Set numerical derivative spacing parameter
            tol = 1e-3
            T = sp.mean([item.Tbub(P) for item in self.F._comps])  # Guess T
            K = dict([(item.name, item.Pvap(T)/P) for item in self.F._comps])  # Guess K
        elif T and phi:
            TV = True
            f = 1.000001  # Set numerical derivative spacing parameter
            tol = 1e-5
            P = sp.mean([item.Pvap(T) for item in self.F._comps])  # Guess P
            K = dict([(item.name, item.Pvap(T)/P) for item in self.F._comps])  # Calculate K
        
        #Initial RR loop parameters
        SRR = sp.inf
        count = 0
        clim = 100
        while (sp.absolute(SRR) > tol) and (count < clim):
            count += 1
            SRR = 0  # Reset sum(RRi)
            SRR1 = 0  
            #Solve basic RR
            for item in z.keys():  
                SRR = SRR + z[item]*(K[item] - 1)/(1 + phi*(K[item] - 1))
            #Find the derivatives
            if TP:
                for item in z.keys():
                    SRR1 = SRR1 + z[item]*(K[item] - 1)/(1 + f*phi*(K[item] - 1))
                dSRR = (SRR1 - SRR)/(f*phi - phi)
                phi = phi + SRR/(-dSRR)
                self.phi = phi
            elif PV:
                K = dict([(item.name, item.Pvap(f*T)/P) for item in self.F._comps])
                for item in z.keys():  
                    SRR1 = SRR1 + z[item]*(K[item] - 1)/(1 + phi*(K[item] - 1))
                dSRR = (SRR1 - SRR)/(f*T - T)
                T = T + SRR/(-dSRR)
                self.T = T
            elif TV:
                K = dict([(item.name, item.Pvap(T)/(f*P)) for item in self.F._comps])
                for item in z.keys():
                    SRR1 = SRR1 + z[item]*(K[item] - 1)/(1 + phi*(K[item] - 1))
                dSRR = (SRR1 - SRR)/(f*P - P)
                P = P + SRR/(-dSRR)
                self.P = P
        if count >= clim:
            print('WARNING: Rachford-Rice did not converge!')
        return {'iterations':count,'convergence':SRR}
        
        
        













