#!/usr/bin/env python
#
import sys
import os
from distutils.core import setup

VERSION = '1.8.0a1'

def get_description():
    README = os.path.abspath(os.path.join(os.path.dirname(__file__), 'pyshield.rst'))
    f = open(README, 'r')
    try:
        return f.read()
    finally:
        f.close()

def main():
    args = dict(
        name='pyshield',
        version=VERSION,
        description='An integrated development platform that supports ' \
                    'Python script editing, debugging and running ' \
                    'encrypted python scripts.',
        long_description=get_description(),
        keywords=['ide', 'debug', 'gui', 'editor'],
        py_modules=['pyshield', 'pyimcore'],
        author='Jondy Zhao',
        author_email='jondy.zhao@gmail.com',
        maintainer='Jondy Zhao',
        maintainer_email='jondy.zhao@gmail.com',
        url='http://dashingsoft.com/products/pyshield.html',
        platforms=['Windows', 'Linux'],
        license='Shareware',
        )
    setup(**args)

if __name__ == '__main__':
    main()
