#! /usr/bin/env python
# -*- coding: utf-8 -*-
#
#############################################################
#                                                           #
#      Copyright @ 2013 - 2014 Dashingsoft corp.            #
#      All rights reserved.                                 #
#                                                           #
#      Pyshield                                             #
#                                                           #
#      Version: 1.7.0 - 1.8.0                               #
#                                                           #
#############################################################
#
#
#  @File: pyshield.py
#
#  @Author: Jondy Zhao(jondy.zhao@gmail.com)
#
#  @Create Date: 2014/11/03
#
#  @Description:
#
#   Startup pyshield.
#
import fnmatch
import getopt
import glob
import os
import platform
import shutil
import sys

__errormsg__ = '''
The trial license is expired, you need pay for a registration code
from:

  http://dashingsoft.com/products/pyshield/license.lic

You will receive information electronically immediately after ordering,
then replace "license.lic" with registration code only (no newline).
'''

if not ((sys.version_info[0] == 3) and (sys.version_info[1] == 3)):
    raise RuntimeError('Unsupported python version, Pyshield need python3.3')

def format_arch():
    arch = platform.machine().lower()
    if arch in ('amd64', 'x86_64'):
        arch = 'x86_64'
    elif arch in ('x86', 'i386', 'i486', 'i586', 'i686'):
        arch = 'x86'
    elif arch.startswith('arm'):
        arch = 'arm'
    else:
        raise RuntimeError('Unsupport processor architecture.')
    return arch

def format_extension_filename():
    if sys.platform.startswith('linux'):
        ext = 'so'
        osname = 'linux'
    elif sys.platform.startswith('win'):
        ext = 'pyd'
        osname = 'win32'
    else:
        raise RuntimeError('This platform is unsupported.')

    arch = format_arch()
    target = os.path.join(sys.rootdir, 'pytransform.%s' % ext)
    src = None
    pat = os.path.join(
        sys.rootdir,
        'extensions',
        'pytransform-*.%s-%s-py3.3.%s' % (osname, arch, ext)
        )
    for s in glob.glob(pat):
        src = s
    return target, src

def get_related_files():
    osname = sys.platform
    arch = format_arch()
    path = os.path.join(sys.rootdir, 'extensions')
    if osname == 'win32':
        if arch == 'x86':
            filelist = 'cygtfm-0.dll', 'cygtomcrypt-0.dll'
        else:
            filelist = 'libtfm-0.dll', 'libtomcrypt-0.dll', 'libgcc_s_seh-1.dll'
    else:
        filelist = []
    return [os.path.join(path, s) for s in filelist]

def import_pytransform():
    try:
        m = __import__('pytransform')
        return m
    except ImportError:
        pass

    target, src = format_extension_filename()
    if src is not None and os.path.exists(src):
        if not os.path.exists(target):
            shutil.copyfile(src, target)
        for filename in get_related_files(src):
            if os.path.exists(filename):
                shutil.copy(filename, sys.rootdir)
            else:
                raise RuntimeError('missing file "%s"' % filename)
    m = __import__('pytransform')
    return m

if __name__ == '__main__':
    sys.rootdir = os.path.dirname(os.path.abspath(sys.argv[0]))
    try:
        m = import_pytransform()
    except Exception:
        print(__errormsg__)
        sys.exit(1)

    import pyimcore
    m.exec_file('main.pyx')
