from setuptools.extension import Extension
from paver.easy import *
from paver.setuputils import setup
from setuptools import find_packages

import paver.doctools
import paver.misctasks
from paved import *
from paved.dist import *
from paved.util import *
from paved.docs import *
from paved.pycheck import *
from paved.pkg import *
from sphinxcontrib import paverutils

# get info from setup.py
setup_py = ''.join(
    [x for x in path('setup.py').lines() if 'setuptools' not in x])
exec(setup_py)


options(
    sphinx=Bunch(
        docroot='docs',
        builddir="_build",
    ),
    pdf=Bunch(
        builddir='_build',
        builder='latex',
    ),
)

options.paved.clean.rmdirs += ['.tox',
                               'dist',
                               'build',
                               ]
options.paved.clean.patterns += ['*.pickle',
                                 '*.doctree',
                                 '*.gz',
                                 'nosetests.xml',
                                 'sloccount.sc',
                                 '*.pdf', '*.tex',
                                 '*.png',
                                 '*.o', '*.os',  # object files
                                 '*.so',  # libs
                                 '*_wrap.c',  # generated by swig
                                 '*.vcd',
                                 '*.zip',
                                 'distribute_setup.py',
                                 ]

options.paved.dist.manifest.include.remove('distribute_setup.py')
options.paved.dist.manifest.include.remove('paver-minilib.zip')
options.paved.dist.manifest.recursive_include.add('pysimavr *.h')
options.paved.dist.manifest.include.add('requirements.txt')


@task
@needs(
    #           'clean',
    'scons',
    'sloccount',
    'html',
    'pdf',
    'sdist',
    'nose', 'tox',
)
def alltest():
    'all tasks to check'
    pass


@task
@needs('sphinxcontrib.paverutils.html')
def html():
    pass


@task
@needs('sphinxcontrib.paverutils.pdf')
def pdf():
    'Generate PDF output and copy into html directory'
    fpdf = list(path('docs/_build/latex').walkfiles('*.pdf'))[0]
    d = path('docs/_build/html')
    d.makedirs()
    fpdf.copy(d)


@task
#    @needs('paved.paved.clean') # this does not work! strange
def clean(options, info):
    paved.clean(options, info)
    info("Cleaning swig files")
    d = path('pysimavr') / 'swig'
    for x in d.walkfiles('*.py'):
        if path(x).stripext() + '.i' in d.files('*.i'):
            x.remove()


@task
def scons():
    sh('scons', cwd='pysimavr/swig')


@task
@needs(
#       'bdist_egg', 
       'sdist', 
       'distutils.command.upload',
       )
def upload():
    pass


@task
def tox():
    '''Run tox.'''
    sh('tox')


@task
@needs('manifest', 'setuptools.command.sdist')
def sdist():
    """Overrides sdist to make sure that our MANIFEST.in is generated.
    """
    pass


@task
@needs('scons', 
       'paved.pycheck.nose')
def nose():
    """Overrides nose to make sure that scons is run.
    """
    pass


@task
@needs('scons')
def build():
    ''

