#! /usr/bin/env python

import unittest

from pyslet.html40_19991224 import *

def suite():
	return unittest.TestSuite((
		unittest.makeSuite(HTML40_19991224Tests,'test'),
		unittest.makeSuite(ParserTests,'test'),
		))

class HTML40_19991224Tests(unittest.TestCase):		
	def testCaseConstants(self):
		self.assertTrue(HTML40_PUBLICID=="-//W3C//DTD HTML 4.01//EN")

	def testCaseLength(self):
		l=LengthType(10,LengthType.Percentage)
		self.assertTrue(l.type==LengthType.Percentage,"Specified type")
		self.assertTrue(l.value==10,"Specified value")
		self.assertTrue(l.GetValue(50)==5,"Percentage value")
		l=LengthType(10)
		self.assertTrue(l.type==LengthType.Pixel,"Specified type")
		self.assertTrue(l.value==10,"Specified value")
		self.assertTrue(l.GetValue(50)==10,"Pixel value")
		l2=LengthType(l)
		self.assertTrue(l.type==LengthType.Pixel,"Copied type")
		self.assertTrue(l.value==10,"Copied value")		
	
	def testCaseCoordsRect(self):
		SAMPLE_RECT=(2,3,8,4)
		RESULT1="""..........
..........
..........
..*#####..
........+.
.........."""
		RESULT2="""....................
....................
....................
....................
....................
....................
....................
....................
....................
....*###########....
....############....
....############....
................+...
....................
....................
....................
....................
...................."""
		c=Coords(map(lambda x:LengthType(x,LengthType.Pixel),SAMPLE_RECT))
		result=[]
		for y in xrange(6):
			s=[]
			for x in xrange(10):
				v=False
				for i in xrange(len(SAMPLE_RECT)//2):
					if x==SAMPLE_RECT[2*i] and y==SAMPLE_RECT[2*i+1]:
						v=True
						break
				if c.TestRect(x,y,300,300):
					s.append('*' if v else '#')
				else:
					s.append('+' if v else '.')
			result.append(string.join(s,''))
		result=string.join(result,'\n')
		self.assertTrue(result==RESULT1,"Bad Rect test:\n%s"%result)
		c=Coords(map(lambda x:LengthType(x,LengthType.Percentage),SAMPLE_RECT))
		result=[]
		for y in xrange(18):
			s=[]
			for x in xrange(20):
				v=False
				for i in xrange(len(SAMPLE_RECT)//2):
					if x==2*SAMPLE_RECT[2*i] and y==3*SAMPLE_RECT[2*i+1]:
						v=True
						break
				if c.TestRect(x,y,200,300):
					s.append('*' if v else '#')
				else:
					s.append('+' if v else '.')
			result.append(string.join(s,''))
		result=string.join(result,'\n')
		self.assertTrue(result==RESULT2,"Bad Rect test:\n%s"%result)
			
	def testCaseCoordsCircle(self):
		SAMPLE_CIRCLE=(4,5,3)
		RESULT1="""..........
..........
....#.....
..#####...
..#####...
.###*###..
..#####...
..#####...
....#.....
.........."""
		RESULT2="""....................
....................
....................
....................
....................
....................
....................
....................
....................
........#...........
.....#######........
....#########.......
...###########......
...###########......
...###########......
..######*######.....
...###########......
...###########......
...###########......
....#########.......
.....#######........
........#...........
....................
....................
....................
....................
....................
....................
....................
...................."""
		c=Coords(map(lambda x:LengthType(x,LengthType.Pixel),SAMPLE_CIRCLE))
		result=[]
		for y in xrange(10):
			s=[]
			for x in xrange(10):
				v=False
				if x==SAMPLE_CIRCLE[0] and y==SAMPLE_CIRCLE[1]:
					v=True
				if c.TestCircle(x,y,300,300):
					s.append('*' if v else '#')
				else:
					s.append('+' if v else '.')
			result.append(string.join(s,''))
		result=string.join(result,'\n')
		self.assertTrue(result==RESULT1,"Bad Circle test:\n%s"%result)
		c=Coords(map(lambda x:LengthType(x,LengthType.Percentage),SAMPLE_CIRCLE))
		result=[]
		for y in xrange(30):
			s=[]
			for x in xrange(20):
				v=False
				if x==2*SAMPLE_CIRCLE[0] and y==3*SAMPLE_CIRCLE[1]:
					v=True
				if c.TestCircle(x,y,200,300):
					s.append('*' if v else '#')
				else:
					s.append('+' if v else '.')
			result.append(string.join(s,''))
		result=string.join(result,'\n')
		self.assertTrue(result==RESULT2,"Bad Circle test:\n%s"%result)
			
	def testCaseCoordsPoly(self):
		SAMPLE_POLY=(3,1,1,3,2,6,3,4,5,3,6,6,4,7,7,8,9,7,8,5,11,6,13,6,14,3,12,1,12,3,10,1,7,2,3,1)
		RESULT1="""................
...+......+.+...
..#####*###.#...
.*###*######*#+.
..#+..########..
..#...##*#####..
..+...*##..+.+..
....*####+......
.......+........
................"""
		RESULT2="""................................
................................
................................
......+.............+...+.......
......###.........###...#.......
.....#######....######..##......
....##########*#######..##......
....###################.###.....
...#########################....
..*#######*#############*###+...
...######..#################....
...#####...#################....
...###+....#################....
...###.....#################....
....##......###############.....
....#.......####*##########.....
....#.......#####.#########.....
....#.......#####...#######.....
....+.......*####.....+...+.....
...........#######..............
..........########..............
........*#########+.............
..........#######...............
............####................
..............+.................
................................
................................"""
		c=Coords(map(lambda x:LengthType(x,LengthType.Pixel),SAMPLE_POLY))
		result=[]
		for y in xrange(10):
			s=[]
			for x in xrange(16):
				v=False
				for i in xrange(len(SAMPLE_POLY)//2):
					if x==SAMPLE_POLY[2*i] and y==SAMPLE_POLY[2*i+1]:
						v=True
						break
				if c.TestPoly(x,y,300,300):
					s.append('*' if v else '#')
				else:
					s.append('+' if v else '.')
			result.append(string.join(s,''))
		result=string.join(result,'\n')
		self.assertTrue(result==RESULT1,"Bad Poly test:\n%s"%result)
		c=Coords(map(lambda x:LengthType(x,LengthType.Percentage),SAMPLE_POLY))
		result=[]
		for y in xrange(27):
			s=[]
			for x in xrange(32):
				v=False
				for i in xrange(len(SAMPLE_POLY)//2):
					if x==2*SAMPLE_POLY[2*i] and y==3*SAMPLE_POLY[2*i+1]:
						v=True
						break
				if c.TestPoly(x,y,200,300):
					s.append('*' if v else '#')
				else:
					s.append('+' if v else '.')
			result.append(string.join(s,''))
		result=string.join(result,'\n')
		self.assertTrue(result==RESULT2,"Bad Poly test:\n%s"%result)

class ParserTests(unittest.TestCase):		
	def testCaseConstructor(self):
		e=xml.XMLEntity("Preamble\n<P>Hello&nbsp;<b>World!<P>Pleased to meet you.</P>")
		p=HTMLParser(e)
		doc=p.ParseDocument(XHTMLDocument())
		self.assertTrue(isinstance(doc,XHTMLDocument),"Type of document parsed")
		fragment=list(doc.root.Body.GetChildren())
		self.assertTrue(len(fragment)==1,"Expected a single child")
		self.assertTrue(isinstance(fragment[0],Div),"Expected a single Div child")
		fragment=list(fragment[0].GetChildren())
		self.assertTrue(fragment[0]=='Preamble\n',"Preamble: %s"%repr(fragment[0]))
		tag=fragment[1]
		self.assertTrue(isinstance(tag,P),"P Tag: %s"%repr(tag))
		children=list(tag.GetChildren())
		self.assertTrue(children[0]==u'Hello\xA0',"nbsp: %s"%repr(children[0]))
		self.assertTrue(isinstance(children[1],B),"B Tag: %s"%repr(children[1]))
		self.assertTrue(children[1].GetValue()=="World!")
		tag=fragment[2]
		self.assertTrue(isinstance(tag,P),"P Tag: %s"%repr(tag))
		self.assertTrue(tag.GetValue()=="Pleased to meet you.")
		
if __name__ == "__main__":
	unittest.main()
