/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.algorithmrun;

import ca.ubc.cs.beta.aclib.algorithmrun.AbstractAlgorithmRun;
import ca.ubc.cs.beta.aclib.algorithmrun.RunResult;
import ca.ubc.cs.beta.aclib.execconfig.AlgorithmExecutionConfig;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExistingAlgorithmRun
extends AbstractAlgorithmRun {
    private static final long serialVersionUID = -7798477429606839878L;
    private transient Logger log = LoggerFactory.getLogger(this.getClass());

    public ExistingAlgorithmRun(AlgorithmExecutionConfig execConfig, RunConfig runConfig, RunResult runResult, double runtime, double runLength, double quality, long resultSeed, String additionalRunData, double wallclockTime) {
        super(execConfig, runConfig);
        this.setResult(runResult, runtime, runLength, quality, resultSeed, "<Existing Run>", additionalRunData);
        this.setWallclockExecutionTime(wallclockTime);
    }

    public ExistingAlgorithmRun(AlgorithmExecutionConfig execConfig, RunConfig runConfig, RunResult runResult, double runtime, double runLength, double quality, long resultSeed, double wallclockTime) {
        super(execConfig, runConfig);
        this.setResult(runResult, runtime, runLength, quality, resultSeed, "<Existing Run>", "");
        this.setWallclockExecutionTime(wallclockTime);
    }

    public ExistingAlgorithmRun(AlgorithmExecutionConfig execConfig, RunConfig runConfig, RunResult runResult, double runtime, double runlength, double quality, long seed, String additionalRunData) {
        this(execConfig, runConfig, runResult, runtime, runlength, quality, seed, additionalRunData, 0.0);
    }

    public ExistingAlgorithmRun(AlgorithmExecutionConfig execConfig, RunConfig runConfig, RunResult runResult, double runtime, double runlength, double quality, long seed) {
        this(execConfig, runConfig, runResult, runtime, runlength, quality, seed, "", 0.0);
    }

    @Deprecated
    public ExistingAlgorithmRun(AlgorithmExecutionConfig execConfig, RunConfig runConfig, String result) {
        this(execConfig, runConfig, result, 0.0);
    }

    @Deprecated
    public ExistingAlgorithmRun(AlgorithmExecutionConfig execConfig, RunConfig runConfig, String result, double wallClockTime) {
        super(execConfig, runConfig);
        String[] resultLine = result.split(",");
        try {
            RunResult acResult;
            try {
                acResult = RunResult.getAutomaticConfiguratorResultForCode(Integer.valueOf(resultLine[0]));
            }
            catch (NumberFormatException e) {
                acResult = RunResult.getAutomaticConfiguratorResultForKey(resultLine[0]);
            }
            double runtime = Double.valueOf(resultLine[1].trim());
            double runLength = Double.valueOf(resultLine[2].trim());
            double quality = Double.valueOf(resultLine[3].trim());
            long resultSeed = Long.valueOf(resultLine[4].trim());
            String additionalRunData = "";
            if (resultLine.length == 6) {
                additionalRunData = resultLine[5].trim();
            }
            this.setResult(acResult, runtime, runLength, quality, resultSeed, result, additionalRunData);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Object[] args = new Object[]{execConfig, runConfig, result};
            this.log.info("Malformed Run Result for Execution (ArrayIndexOutOfBoundsException): {}, Instance: {}, Result: {}", args);
            this.log.info("Exception:", (Throwable)e);
            this.setAbortResult(e.getMessage());
        }
        catch (NumberFormatException e) {
            Object[] args = new Object[]{execConfig, runConfig, result};
            this.log.info("Malformed Run Result for Execution (NumberFormatException): {}, Instance: {}, Result: {}", args);
            this.log.info("Exception:", (Throwable)e);
            this.setAbortResult(e.getMessage());
        }
        this.setWallclockExecutionTime(wallClockTime);
    }

    @Override
    public void run() {
    }
}

