/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.probleminstance;

import au.com.bytecode.opencsv.CSVReader;
import ca.ubc.cs.beta.aclib.exceptions.FeatureNotFoundException;
import ca.ubc.cs.beta.aclib.misc.csvhelpers.ConfigCSVFileHelper;
import ca.ubc.cs.beta.aclib.probleminstance.InstanceListWithSeeds;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aclib.seedgenerator.InstanceSeedGenerator;
import ca.ubc.cs.beta.aclib.seedgenerator.RandomInstanceSeedGenerator;
import ca.ubc.cs.beta.aclib.seedgenerator.SetInstanceSeedGenerator;
import com.beust.jcommander.ParameterException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProblemInstanceHelper {
    private static Logger logger = LoggerFactory.getLogger(ProblemInstanceHelper.class);
    private static final Map<String, ProblemInstance> cachedProblemInstances = new HashMap<String, ProblemInstance>();

    private static File getFileForPath(String context, String path) {
        File f;
        logger.trace("Trying to find file with context {} and path {}", (Object)context, (Object)path);
        if (path.length() > 0 && path.substring(0, 1).equals(File.separator)) {
            logger.trace("Absolute path given for path, checking {}", (Object)path);
            f = new File(path);
        } else {
            Object[] args = new Object[]{context, File.separator, path};
            logger.trace("Relative path given for path, checking {}{}{}", args);
            f = new File(context + File.separator + path);
        }
        if (!f.exists()) {
            logger.trace("Could not find needed file:" + path + " Context:" + context);
            logger.trace("Trying basename of path in context");
            f = new File(context + File.separator + new File(path).getName());
            if (!f.exists()) {
                throw new ParameterException("Could not find needed file:" + path + " Context:" + context);
            }
        }
        return f;
    }

    public static void clearCache() {
        cachedProblemInstances.clear();
    }

    public static InstanceListWithSeeds getInstances(String filename, String experimentDir, boolean checkFileExistsOnDisk) throws IOException {
        return ProblemInstanceHelper.getInstances(filename, experimentDir, null, checkFileExistsOnDisk);
    }

    public static InstanceListWithSeeds getInstances(String filename, String experimentDir, boolean checkFileExistsOnDisk, boolean deterministic) throws IOException {
        return ProblemInstanceHelper.getInstances(filename, experimentDir, null, checkFileExistsOnDisk, deterministic);
    }

    public static InstanceListWithSeeds getInstances(String filename, String experimentDir, String featureFileName, boolean checkFileExistsOnDisk) throws IOException {
        return ProblemInstanceHelper.getInstances(filename, experimentDir, featureFileName, checkFileExistsOnDisk, 0L, Integer.MAX_VALUE);
    }

    public static InstanceListWithSeeds getInstances(String filename, String experimentDir, String featureFileName, boolean checkFileExistsOnDisk, long seed, boolean deterministic) throws IOException {
        return ProblemInstanceHelper.getInstances(filename, experimentDir, featureFileName, checkFileExistsOnDisk, seed, Integer.MAX_VALUE, deterministic);
    }

    public static InstanceListWithSeeds getInstances(String filename, String experimentDir, String featureFileName, boolean checkFileExistsOnDisk, long seed, int maxSeedsPerInstance) throws IOException {
        return ProblemInstanceHelper.getInstances(filename, experimentDir, featureFileName, checkFileExistsOnDisk, seed, Integer.MAX_VALUE, false);
    }

    public static InstanceListWithSeeds getInstances(String filename, String experimentDir, String featureFileName, boolean checkFileExistsOnDisk, boolean deterministic) throws IOException {
        return ProblemInstanceHelper.getInstances(filename, experimentDir, featureFileName, checkFileExistsOnDisk, 0L, Integer.MAX_VALUE, deterministic);
    }

    /*
     * WARNING - void declaration
     */
    public static InstanceListWithSeeds getInstances(String filename, String experimentDir, String featureFileName, boolean checkFileExistsOnDisk, long seed, int maxSeedsPerInstance, boolean deterministic) throws IOException {
        InstanceSeedGenerator gen;
        if (experimentDir == null) {
            throw new ParameterException("Experiment directory cannot be null");
        }
        logger.debug("Loading instances from file: {} and experiment dir {}", (Object)filename, (Object)experimentDir);
        ArrayList<ProblemInstance> instances = new ArrayList<ProblemInstance>();
        HashSet<void> instancesSet = new HashSet<void>();
        String instanceFileAbsolutePath = null;
        String instanceFeatureFileAbsolutePath = null;
        String line = "";
        int instID = 1;
        LinkedHashMap featuresMap = new LinkedHashMap();
        int numberOfFeatures = 0;
        boolean numericFeatureNames = false;
        if (featureFileName != null) {
            logger.debug("Feature File specified reading features from: {} ", (Object)new File(featureFileName).getAbsolutePath());
            File featureFile = ProblemInstanceHelper.getFileForPath(experimentDir, featureFileName);
            if (!featureFile.exists()) {
                throw new ParameterException("Feature file given does not exist " + featureFile);
            }
            instanceFeatureFileAbsolutePath = featureFile.getAbsolutePath();
            CSVReader featureCSV = new CSVReader((Reader)new InputStreamReader(new FileInputStream(featureFile)));
            ConfigCSVFileHelper features = new ConfigCSVFileHelper(featureCSV.readAll(), 1, 1);
            featureCSV.close();
            numberOfFeatures = features.getNumberOfDataColumns();
            int column = 2;
            for (String key : features.getDataKeyList()) {
                try {
                    Double.valueOf(key);
                    numericFeatureNames = true;
                    throw new ParameterException("Column " + column + " of feature file seems to have a numeric name:  " + key + " this is forbidden. All Feature Files must have a header row that identifies for each feature a non-numeric name");
                }
                catch (NumberFormatException numberFormatException) {
                    ++column;
                }
            }
            logger.debug("Feature File specifies: {} features for {} instances", (Object)numberOfFeatures, (Object)features.getNumberOfDataRows());
            for (int i = 0; i < features.getNumberOfDataRows(); ++i) {
                TreeMap<String, Double> instFeatMap = new TreeMap<String, Double>();
                featuresMap.put(features.getKeyForDataRow(i).replaceAll("//", "/"), Collections.unmodifiableMap(instFeatMap));
                String lastValue = "";
                try {
                    for (int j = 0; j < features.getNumberOfDataColumns(); ++j) {
                        String string = features.getDataKeyByIndex(j);
                        lastValue = features.getStringDataValue(i, j);
                        Double value = features.getDoubleDataValue(i, j);
                        instFeatMap.put(string, value);
                    }
                    continue;
                }
                catch (NumberFormatException e) {
                    void var25_45;
                    e.printStackTrace();
                    boolean bl = false;
                    while (var25_45 < lastValue.length()) {
                        System.out.println((int)var25_45 + ":" + lastValue.charAt((int)var25_45) + ":" + Integer.toHexString(lastValue.getBytes()[var25_45]));
                        ++var25_45;
                    }
                    throw new ParameterException("Could not parse feature file " + featureFileName + " , error on line " + i + " expected double value but got string:" + e.getMessage() + " value " + lastValue);
                }
            }
        }
        List<Object> instanceList = new ArrayList(featuresMap.size());
        Map<Object, Object> instanceSpecificInfo = Collections.emptyMap();
        if (filename != null) {
            if (filename.trim().equals("")) {
                throw new ParameterException("File name is specified but empty");
            }
            File instanceListFile = ProblemInstanceHelper.getFileForPath(experimentDir, filename);
            instanceFileAbsolutePath = instanceListFile.getAbsolutePath();
            logger.debug("Reading instances from file {}", (Object)instanceFileAbsolutePath);
            InstanceListWithSeeds insc = ProblemInstanceHelper.getListAndSeedGen(instanceListFile, seed, maxSeedsPerInstance);
            instanceList = insc.getInstancesByName();
            gen = insc.getSeedGen();
            instanceSpecificInfo = insc.getInstanceSpecificInfo();
        } else {
            instanceList.addAll(featuresMap.keySet());
            logger.info("Reading instances from feature file");
            gen = new RandomInstanceSeedGenerator(instanceList.size(), seed, maxSeedsPerInstance);
        }
        HashSet unMappedFeatureMapEntries = new HashSet();
        unMappedFeatureMapEntries.addAll(featuresMap.keySet());
        Iterator<Object> i$ = instanceList.iterator();
        while (i$.hasNext()) {
            void var25_51;
            Map features;
            String instanceFile;
            String originalInstanceFilename = instanceFile = (String)i$.next();
            if (checkFileExistsOnDisk) {
                File f = ProblemInstanceHelper.getFileForPath(experimentDir, instanceFile);
                instanceFile = f.getAbsolutePath();
                if (!f.exists()) {
                    throw new ParameterException("Instance does not exist on disk " + f.getAbsolutePath());
                }
            }
            if (featureFileName != null) {
                String[] stringArray = new String[]{instanceFile, instanceFile.replace(experimentDir, ""), instanceFile.replaceAll("//", "/"), instanceFile.replace(experimentDir, "").replaceAll("//", "/")};
                features = null;
                boolean firstTry = true;
                for (String possibleFile : stringArray) {
                    features = (Map)featuresMap.get(possibleFile.trim());
                    if (features != null) {
                        if (firstTry) {
                            logger.trace("Matched features for instance named {} in feature file ", (Object)possibleFile);
                        } else {
                            logger.debug("Matched features for instance named {} in feature file ", (Object)possibleFile);
                        }
                        unMappedFeatureMapEntries.remove(possibleFile.trim());
                        break;
                    }
                    firstTry = false;
                    logger.debug("No match for instance named {} in feature file ", (Object)possibleFile);
                }
                if (features == null) {
                    logger.warn("Could not find features for instance {} trying more creative matching, may be error prone and slow [probably not really]", (Object)instanceFile);
                    for (Map.Entry<Object, Object> entry : featuresMap.entrySet()) {
                        if (instanceFile.endsWith((String)entry.getKey())) {
                            logger.debug("Matched instance {} with this entry {}", (Object)instanceFile, entry.getKey());
                            features = (Map)entry.getValue();
                            break;
                        }
                        logger.trace("Didn't match ({}) with ({})", (Object)instanceFile, entry.getKey());
                    }
                }
                if (features == null) {
                    throw new FeatureNotFoundException("Feature file : " + featureFileName + " does not contain feature data for instance: " + instanceFile);
                }
                if (features.size() != numberOfFeatures) {
                    if (numericFeatureNames) {
                        throw new ParameterException("Feature file : " + featureFileName + " is almost certainly missing a header row identifying each of the features in it. Otherwise there is a mismatch between the number of features we found for this instance and the number expected: " + instanceFile + " found: " + features.size() + " but expected: " + numberOfFeatures);
                    }
                    throw new ParameterException("Feature file : " + featureFileName + " contains " + features.size() + " for instance: " + instanceFile + " but expected " + numberOfFeatures);
                }
            } else {
                features = Collections.emptyMap();
            }
            if (cachedProblemInstances.containsKey(instanceFile = instanceFile.replaceAll("//", "/"))) {
                logger.trace("Instance file has already been loaded once this runtime, using cached instance of {}", (Object)instanceFile);
                ProblemInstance problemInstance = cachedProblemInstances.get(instanceFile);
                if (problemInstance.getFeatures().size() > 0 && features.size() > 0 && !((Object)problemInstance.getFeatures()).equals(features)) {
                    logger.warn("We previously loaded an instance for filename {} but the instance Features don't match", (Object)instanceFile);
                }
            } else {
                HashMap<String, Object> fixedInstanceSpecificInfo = new HashMap<String, Object>();
                for (Map.Entry<Object, Object> entry : instanceSpecificInfo.entrySet()) {
                    fixedInstanceSpecificInfo.put(((String)entry.getKey()).replaceAll("//", "/"), entry.getValue());
                }
                ProblemInstance problemInstance = new ProblemInstance(instanceFile, instID++, features, (String)fixedInstanceSpecificInfo.get(originalInstanceFilename));
                cachedProblemInstances.put(instanceFile, problemInstance);
            }
            if (instancesSet.contains(var25_51)) {
                logger.warn("Instance file seems to contain duplicate entries for the following filename {}", (Object)line);
            }
            instances.add((ProblemInstance)var25_51);
            instancesSet.add(var25_51);
        }
        ArrayList<ProblemInstance> instancesFromFeatures = new ArrayList<ProblemInstance>(instances.size() * 2);
        instancesFromFeatures.addAll(instances);
        for (String instanceFromFeatureFile : unMappedFeatureMapEntries) {
            instancesFromFeatures.add(new ProblemInstance(instanceFromFeatureFile, instID++, (Map)featuresMap.get(instanceFromFeatureFile)));
        }
        if (deterministic) {
            if (gen instanceof SetInstanceSeedGenerator) {
                logger.warn("Detected that seeds have been preloaded, yet the algorithm is listed as deterministic, generally this means we should use -1 as a seed");
            } else {
                logger.debug("Deterministic algorithm, selecting hard coded instance seed generator");
                LinkedHashMap<String, List<Long>> instanceSeedMap = new LinkedHashMap<String, List<Long>>();
                for (ProblemInstance pi : instances) {
                    ArrayList<Long> arrayList = new ArrayList<Long>(1);
                    arrayList.add(-1L);
                    instanceSeedMap.put(pi.getInstanceName(), arrayList);
                }
                ArrayList<String> absolutePathList = new ArrayList<String>(instanceList.size());
                block14: for (String string : instanceList) {
                    for (ProblemInstance pi : instances) {
                        if (!pi.getInstanceName().endsWith(string.replaceAll("//", "/"))) continue;
                        absolutePathList.add(pi.getInstanceName());
                        continue block14;
                    }
                }
                if (instanceList.size() != absolutePathList.size()) {
                    throw new IllegalStateException("Mapping from Relative to Absolute Path names broke something");
                }
                gen = new SetInstanceSeedGenerator(instanceSeedMap, absolutePathList, 1);
            }
        }
        logger.debug("Instances loaded from file named: {}", (Object)filename);
        return new InstanceListWithSeeds(gen, instances, instancesFromFeatures, instanceFileAbsolutePath, instanceFeatureFileAbsolutePath);
    }

    private static InstanceListWithSeeds getListAndSeedGen(File instanceListFile, long seed, int maxSeedsPerConfig) throws IOException {
        InstanceSeedGenerator gen;
        LinkedHashMap<String, String> instanceSpecificInfo;
        LinkedHashMap<String, List<Long>> instances;
        LinkedList<String> instanceList = new LinkedList<String>();
        logger.debug("Reading instance file detecting format");
        List<String> declaredInstanceOrderForSeeds = null;
        try {
            CSVReader reader = new CSVReader((Reader)new FileReader(instanceListFile), ',', '\"', true);
            List csvContents = reader.readAll();
            ValueObject v = ProblemInstanceHelper.parseCSVContents(csvContents, InstanceFileFormat.NEW_CSV_INSTANCE_PER_ROW, InstanceFileFormat.NEW_CSV_SEED_INSTANCE_PER_ROW, InstanceFileFormat.NEW_INSTANCE_SPECIFIC_PER_ROW, InstanceFileFormat.NEW_SEED_INSTANCE_SPECIFIC_PER_ROW);
            instances = v.instanceSeedMap;
            instanceSpecificInfo = v.instanceSpecificInfoMap;
            declaredInstanceOrderForSeeds = v.declaredInstanceOrderForSeeds;
            reader.close();
        }
        catch (IllegalArgumentException e) {
            try {
                String line;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(instanceListFile));
                StringBuilder sb = new StringBuilder();
                while ((line = bufferedReader.readLine()) != null) {
                    sb.append(line.trim()).append("\n");
                }
                bufferedReader.close();
                CSVReader reader = new CSVReader((Reader)new StringReader(sb.toString().trim()), ' ');
                List csvContents = reader.readAll();
                ValueObject v = ProblemInstanceHelper.parseCSVContents(csvContents, InstanceFileFormat.LEGACY_INSTANCE_PER_ROW, InstanceFileFormat.LEGACY_SEED_INSTANCE_PER_ROW, InstanceFileFormat.LEGACY_INSTANCE_SPECIFIC_PER_ROW, InstanceFileFormat.LEGACY_SEED_INSTANCE_SPECIFIC_PER_ROW);
                instances = v.instanceSeedMap;
                instanceSpecificInfo = v.instanceSpecificInfoMap;
                declaredInstanceOrderForSeeds = v.declaredInstanceOrderForSeeds;
                reader.close();
            }
            catch (IllegalArgumentException e2) {
                throw new ParameterException("Could not parse instanceFile " + instanceListFile.getAbsolutePath());
            }
        }
        if (instances.entrySet().iterator().next().getValue().size() > 0) {
            if (declaredInstanceOrderForSeeds == null) {
                throw new IllegalStateException("Expected instanceOrder to be specified, got null.");
            }
            gen = new SetInstanceSeedGenerator(instances, declaredInstanceOrderForSeeds, maxSeedsPerConfig);
        } else {
            gen = new RandomInstanceSeedGenerator(instances.size(), seed, maxSeedsPerConfig);
        }
        instanceList.addAll(instances.keySet());
        return new InstanceListWithSeeds(gen, null, instanceList, instanceSpecificInfo);
    }

    private static ValueObject parseCSVContents(List<String[]> csvContents, InstanceFileFormat instanceOnly, InstanceFileFormat seedPair, InstanceFileFormat instanceSpecific, InstanceFileFormat instanceSpecificSeed) {
        InstanceFileFormat possibleFormat = null;
        LinkedHashMap instanceSeedMap = new LinkedHashMap();
        LinkedHashMap<String, String> instanceSpecificInfoMap = new LinkedHashMap<String, String>();
        ArrayList<String> problemInstanceDeclaredOrder = new ArrayList<String>();
        for (String[] s : csvContents) {
            String instanceName;
            if (s.length == 1) {
                if (s[0].trim().equals("")) {
                    throw new IllegalArgumentException();
                }
                if (possibleFormat == null) {
                    possibleFormat = instanceOnly;
                    logger.debug("Line with only 1 entry found, trying {}", (Object)possibleFormat);
                }
                if (possibleFormat == instanceOnly) {
                    instanceSeedMap.put(s[0], new LinkedList());
                    continue;
                }
                logger.debug("Line with only 1 entry found, we are not {}", (Object)possibleFormat);
                throw new IllegalArgumentException();
            }
            if (s.length == 2) {
                if (possibleFormat == null) {
                    try {
                        possibleFormat = seedPair;
                        logger.debug("Line with only 2 entries found, trying {}", (Object)possibleFormat);
                        Long.valueOf(s[0]);
                        possibleFormat = seedPair;
                    }
                    catch (NumberFormatException e) {
                        possibleFormat = instanceSpecific;
                        logger.debug("First entry on line 1 not a long value, trying {}", (Object)possibleFormat);
                    }
                }
                if (possibleFormat.equals((Object)seedPair)) {
                    instanceName = s[1];
                    try {
                        if (instanceSeedMap.get(instanceName) == null) {
                            instanceSeedMap.put(instanceName, new LinkedList());
                        }
                        ((List)instanceSeedMap.get(instanceName)).add(Long.valueOf(s[0]));
                    }
                    catch (NumberFormatException e) {
                        logger.debug("{} is not a valid long value", (Object)s[0]);
                        throw new IllegalArgumentException();
                    }
                    problemInstanceDeclaredOrder.add(instanceName);
                    continue;
                }
                if (possibleFormat.equals((Object)instanceSpecific)) {
                    instanceName = s[0];
                    String instanceSpecificInfo = s[1];
                    instanceSpecificInfoMap.put(instanceName, instanceSpecificInfo);
                    instanceSeedMap.put(instanceName, new LinkedList());
                    continue;
                }
                logger.debug("Line with 2 entries found, we are not {}", (Object)possibleFormat);
                throw new IllegalArgumentException();
            }
            if (s.length == 3) {
                if (possibleFormat == null) {
                    possibleFormat = instanceSpecificSeed;
                }
                if (possibleFormat == instanceSpecificSeed) {
                    instanceName = s[1];
                    if (s[1].trim().length() == 0) {
                        logger.debug("\"{}\" is not a valid instance name (All Whitespace)", (Object)s[1]);
                        throw new IllegalArgumentException();
                    }
                    if (instanceSeedMap.get(instanceName) == null) {
                        instanceSeedMap.put(instanceName, new LinkedList());
                    }
                    try {
                        ((List)instanceSeedMap.get(instanceName)).add(Long.valueOf(s[0]));
                    }
                    catch (NumberFormatException e) {
                        logger.debug("{} is not a valid long value", (Object)s[0]);
                        throw new IllegalArgumentException();
                    }
                    s[2] = s[2].trim();
                    if (instanceSpecificInfoMap.get(instanceName) != null) {
                        if (!s[2].equals(instanceSpecificInfoMap.get(instanceName))) {
                            Object[] args = new Object[]{instanceName, s[2], instanceSpecificInfoMap.get(instanceName)};
                            logger.debug("Discrepancy detected in instance specific information {} had {} vs. {}  (This is not permitted)", args);
                            throw new IllegalArgumentException();
                        }
                    } else {
                        instanceSpecificInfoMap.put(instanceName, s[2]);
                    }
                    problemInstanceDeclaredOrder.add(instanceName);
                    continue;
                }
                logger.debug("Line with 3 entries found, we are not {}", (Object)possibleFormat);
                throw new IllegalArgumentException();
            }
            logger.debug("Line with {} entries found unknown format", (Object)s.length);
            possibleFormat = null;
            throw new IllegalArgumentException();
        }
        if (instanceSeedMap.size() == 0) {
            throw new IllegalArgumentException("No Instances Found");
        }
        ValueObject v = new ValueObject();
        v.instanceSeedMap = instanceSeedMap;
        v.instanceSpecificInfoMap = instanceSpecificInfoMap;
        v.declaredInstanceOrderForSeeds = problemInstanceDeclaredOrder;
        return v;
    }

    public static boolean isVerifySATCompatible(Collection<ProblemInstance> pis) {
        HashSet<String> validValues = new HashSet<String>();
        validValues.add("SAT");
        validValues.add("SATISFIABLE");
        validValues.add("UNKNOWN");
        validValues.add("UNSAT");
        validValues.add("UNSATISFIABLE");
        for (ProblemInstance pi : pis) {
            if (validValues.contains(pi.getInstanceSpecificInformation())) continue;
            return false;
        }
        return true;
    }

    static class ValueObject {
        public List<String> declaredInstanceOrderForSeeds;
        public LinkedHashMap<String, List<Long>> instanceSeedMap;
        public LinkedHashMap<String, String> instanceSpecificInfoMap;

        ValueObject() {
        }
    }

    static enum InstanceFileFormat {
        NEW_CSV_SEED_INSTANCE_PER_ROW,
        NEW_CSV_INSTANCE_PER_ROW,
        NEW_INSTANCE_SPECIFIC_PER_ROW,
        NEW_SEED_INSTANCE_SPECIFIC_PER_ROW,
        LEGACY_INSTANCE_PER_ROW,
        LEGACY_SEED_INSTANCE_PER_ROW,
        LEGACY_INSTANCE_SPECIFIC_PER_ROW,
        LEGACY_SEED_INSTANCE_SPECIFIC_PER_ROW;

    }
}

