/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.targetalgorithmevaluator.base.cli;

import ca.ubc.cs.beta.aclib.algorithmrun.AbstractAlgorithmRun;
import ca.ubc.cs.beta.aclib.algorithmrun.RunResult;
import ca.ubc.cs.beta.aclib.algorithmrun.RunningAlgorithmRun;
import ca.ubc.cs.beta.aclib.algorithmrun.kill.KillHandler;
import ca.ubc.cs.beta.aclib.algorithmrun.kill.KillableWrappedAlgorithmRun;
import ca.ubc.cs.beta.aclib.concurrent.threadfactory.SequentiallyNamedThreadFactory;
import ca.ubc.cs.beta.aclib.configspace.ParamConfiguration;
import ca.ubc.cs.beta.aclib.execconfig.AlgorithmExecutionConfig;
import ca.ubc.cs.beta.aclib.misc.logback.MarkerFilter;
import ca.ubc.cs.beta.aclib.misc.logging.LoggingMarker;
import ca.ubc.cs.beta.aclib.misc.string.SplitQuotedString;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.base.cli.CommandLineTargetAlgorithmEvaluatorOptions;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.exceptions.TargetAlgorithmAbortException;
import com.google.common.util.concurrent.AtomicDouble;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class CommandLineAlgorithmRun
extends AbstractAlgorithmRun {
    private static final long serialVersionUID = -70897405824987641L;
    public static final String AUTOMATIC_CONFIGURATOR_RESULT_REGEX = "^\\s*(Final)?\\s*[Rr]esult\\s+(?:([Ff]or)|([oO]f))\\s+(?:(HAL)|(ParamILS)|(SMAC)|([tT]his [wW]rapper)):";
    private static final Pattern pattern = Pattern.compile("^\\s*(Final)?\\s*[Rr]esult\\s+(?:([Ff]or)|([oO]f))\\s+(?:(HAL)|(ParamILS)|(SMAC)|([tT]his [wW]rapper)):");
    private static transient Logger log = LoggerFactory.getLogger(CommandLineAlgorithmRun.class);
    private Queue<String> outputQueue = new ArrayDeque<String>(2000);
    private transient TargetAlgorithmEvaluatorRunObserver runObserver;
    private transient KillHandler killHandler;
    public static final String PORT_ENVIRONMENT_VARIABLE = "ACLIB_PORT";
    public static final String FREQUENCY_ENVIRONMENT_VARIABLE = "ACLIB_CPU_TIME_FREQUENCY";
    public static final String CONCURRENT_TASK_ID = "ACLIB_CONCURRENT_TASK_ID";
    private static transient Marker fullProcessOutputMarker = MarkerFactory.getMarker((String)LoggingMarker.FULL_PROCESS_OUTPUT.name());
    private static String commandSeparator = ";";
    private static final double WALLCLOCK_TIMING_SLACK = 0.001;
    private transient ExecutorService threadPoolExecutor = Executors.newCachedThreadPool(new SequentiallyNamedThreadFactory("Command Line Target Algorithm Evaluator Thread "));
    private final int observerFrequency;
    private AtomicBoolean processEnded = new AtomicBoolean(false);
    private final transient BlockingQueue<Integer> executionIDs;
    private final transient CommandLineTargetAlgorithmEvaluatorOptions options;
    private static final int MAX_LINES_TO_SAVE = 1000;
    private volatile boolean wasKilled = false;

    public CommandLineAlgorithmRun(AlgorithmExecutionConfig execConfig, RunConfig runConfig, TargetAlgorithmEvaluatorRunObserver obs, KillHandler handler, CommandLineTargetAlgorithmEvaluatorOptions options, BlockingQueue<Integer> executionIDs) {
        super(execConfig, runConfig);
        if (runConfig.getCutoffTime() <= 0.0 || handler.isKilled()) {
            log.info("Cap time is less than or equal to zero for {} setting run as timeout", (Object)runConfig);
            String rawResultLine = "[DIDN'T BOTHER TO RUN ALGORITHM AS THE CAPTIME IS NOT POSITIVE]";
            this.setResult(RunResult.TIMEOUT, 0.0, 0.0, 0.0, runConfig.getProblemInstanceSeedPair().getSeed(), rawResultLine, "");
        }
        this.runObserver = obs;
        this.killHandler = handler;
        this.observerFrequency = options.observerFrequency;
        if (this.observerFrequency < 25) {
            throw new IllegalArgumentException("Observer Frequency can't be less than 25 milliseconds");
        }
        this.options = options;
        this.executionIDs = executionIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        if (this.isRunCompleted()) {
            return;
        }
        this.runObserver.currentStatus(Collections.singletonList(new RunningAlgorithmRun(this.execConfig, this.getRunConfig(), 0.0, 0.0, 0.0, this.getRunConfig().getProblemInstanceSeedPair().getSeed(), 0.0, this.killHandler)));
        if (this.killHandler.isKilled()) {
            log.debug("Run was killed", (Object)this.runConfig);
            String rawResultLine = "Killed Manually";
            this.setResult(RunResult.KILLED, 0.0, 0.0, 0.0, this.runConfig.getProblemInstanceSeedPair().getSeed(), rawResultLine, "");
            return;
        }
        try {
            Integer token;
            try {
                token = this.executionIDs.take();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.setResult(RunResult.ABORT, 0.0, 0.0, 0.0, 0L, "", "Target CLI Thread was Interrupted");
                return;
            }
            try {
                Process proc;
                DatagramSocket serverSocket;
                if (this.killHandler.isKilled()) {
                    log.debug("Run was killed", (Object)this.runConfig);
                    String rawResultLine = "Killed Manually";
                    this.setResult(RunResult.KILLED, 0.0, 0.0, 0.0, this.runConfig.getProblemInstanceSeedPair().getSeed(), rawResultLine, "");
                    return;
                }
                AtomicInteger pid = new AtomicInteger(-1);
                int port = 0;
                if (this.options.listenForUpdates) {
                    serverSocket = new DatagramSocket();
                    port = serverSocket.getLocalPort();
                } else {
                    serverSocket = null;
                }
                final AtomicDouble currentRuntime = new AtomicDouble(0.0);
                Runnable socketThread = new Runnable(){

                    @Override
                    public void run() {
                        byte[] receiveData = new byte[1024];
                        while (true) {
                            try {
                                while (true) {
                                    DatagramPacket receivePacket = new DatagramPacket(receiveData, receiveData.length);
                                    serverSocket.receive(receivePacket);
                                    InetAddress IPAddress = receivePacket.getAddress();
                                    if (!InetAddress.getByName("localhost").equals(IPAddress)) {
                                        log.warn("Received Request from Non-localhost, ignoring request from: {}", (Object)IPAddress.getHostAddress());
                                        continue;
                                    }
                                    Double runtime = Double.valueOf(new String(receivePacket.getData()));
                                    currentRuntime.set(runtime.doubleValue());
                                }
                            }
                            catch (RuntimeException e) {
                                log.debug("Got some runtime exception while processing data packet", (Throwable)e);
                                continue;
                            }
                            catch (SocketException e) {
                                log.trace("SocketException occurred which we expected when we shutdown probably", (Throwable)e);
                                return;
                            }
                            catch (IOException e) {
                                log.warn("Unknown IOException occurred ", (Throwable)e);
                                continue;
                            }
                            break;
                        }
                    }
                };
                this.startWallclockTimer();
                final Process innerProcess = proc = this.runProcess(port, token);
                final Semaphore stdErrorDone = new Semaphore(0);
                Runnable standardErrorReader = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Thread.currentThread().setName("Command Line Target Algorithm Evaluator Thread (Standard Error Processor)" + CommandLineAlgorithmRun.this.getRunConfig());
                        try {
                            try {
                                BufferedReader procIn = new BufferedReader(new InputStreamReader(innerProcess.getErrorStream()));
                                do {
                                    boolean read = false;
                                    while (procIn.ready()) {
                                        read = true;
                                        String line = procIn.readLine();
                                        if (line == null) {
                                            return;
                                        }
                                        log.warn("[PROCESS-ERR]  {}", (Object)line);
                                    }
                                    if (read) continue;
                                    Thread.sleep(50L);
                                } while (!CommandLineAlgorithmRun.this.processEnded.get());
                                StringBuilder sb = new StringBuilder();
                                if (procIn.ready()) {
                                    char[] input = new char[10000];
                                    procIn.read(input);
                                    sb.append(String.valueOf(input));
                                }
                                if (sb.toString().trim().length() > 0) {
                                    log.warn("[PROCESS-ERR] {}", (Object)sb.toString().trim());
                                }
                                procIn.close();
                            }
                            finally {
                                stdErrorDone.release();
                                log.debug("Standard Error Done");
                            }
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            return;
                        }
                        catch (IOException e) {
                            log.warn("Unexpected IOException occurred {}", (Throwable)e);
                        }
                    }
                };
                Runnable observerThread = new Runnable(){

                    @Override
                    public void run() {
                        Thread.currentThread().setName("Command Line Target Algorithm Evaluator Thread (Observer)" + CommandLineAlgorithmRun.this.getRunConfig());
                        while (true) {
                            double currentTime = (double)CommandLineAlgorithmRun.this.getCurrentWallClockTime() / 1000.0;
                            CommandLineAlgorithmRun.this.runObserver.currentStatus(Collections.singletonList(new RunningAlgorithmRun(CommandLineAlgorithmRun.this.execConfig, CommandLineAlgorithmRun.this.getRunConfig(), Math.max(0.0, currentRuntime.get()), 0.0, 0.0, CommandLineAlgorithmRun.this.getRunConfig().getProblemInstanceSeedPair().getSeed(), currentTime, CommandLineAlgorithmRun.this.killHandler)));
                            try {
                                Thread.sleep(25L);
                                if (CommandLineAlgorithmRun.this.killHandler.isKilled()) {
                                    CommandLineAlgorithmRun.this.wasKilled = true;
                                    log.debug("Trying to kill");
                                    CommandLineAlgorithmRun.this.killProcess(proc);
                                    return;
                                }
                                Thread.sleep(CommandLineAlgorithmRun.this.observerFrequency - 25);
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                return;
                            }
                        }
                    }
                };
                if (this.options.listenForUpdates) {
                    this.threadPoolExecutor.execute(socketThread);
                }
                this.threadPoolExecutor.execute(observerThread);
                this.threadPoolExecutor.execute(standardErrorReader);
                BufferedReader read = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                this.processRunLoop(read, proc);
                this.killProcess(proc);
                if (!this.isRunCompleted()) {
                    if (this.wasKilled) {
                        double currentTime = Math.max(0.0, currentRuntime.get());
                        this.setResult(RunResult.KILLED, currentTime, 0.0, 0.0, this.getRunConfig().getProblemInstanceSeedPair().getSeed(), "Killed Manually", "");
                    } else {
                        this.setCrashResult("Wrapper did not output anything that matched our regex please see the manual for more information. Please try executing the wrapper directly and ensuring that some line starts with: \"Results for ParamILS:\" (case sensitive). In more gorey detail it needs to match the following Regular Expression: ^\\s*(Final)?\\s*[Rr]esult\\s+(?:([Ff]or)|([oO]f))\\s+(?:(HAL)|(ParamILS)|(SMAC)|([tT]his [wW]rapper)):");
                    }
                }
                switch (this.getRunResult()) {
                    case ABORT: 
                    case CRASHED: {
                        log.error("Failed Run Detected Call: cd \"{}\" " + commandSeparator + "  {} ", (Object)new File(this.execConfig.getAlgorithmExecutionDirectory()).getAbsolutePath(), (Object)CommandLineAlgorithmRun.getTargetAlgorithmExecutionCommandAsString(this.execConfig, this.runConfig));
                        log.error("Failed Run Detected output last {} lines", (Object)this.outputQueue.size());
                        for (String s : this.outputQueue) {
                            log.error("> " + s);
                        }
                        log.error("Output complete");
                    }
                }
                this.outputQueue.clear();
                read.close();
                stdErrorDone.acquireUninterruptibly();
                this.threadPoolExecutor.shutdownNow();
                serverSocket.close();
                try {
                    this.threadPoolExecutor.awaitTermination(24L, TimeUnit.HOURS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                this.runObserver.currentStatus(Collections.singletonList(new KillableWrappedAlgorithmRun(this)));
                log.debug("Run {} is completed", (Object)this);
            }
            finally {
                if (!this.executionIDs.offer(token)) {
                    log.error("Developer Error: Couldn't offer run token back to pool, which violates an invariant. We will essentially block until it is accepted.");
                    try {
                        this.executionIDs.put(token);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
            }
        }
        catch (IOException e1) {
            log.error("Failed Run Detected (IOException) Call: cd \"{}\" " + commandSeparator + "  {} ", (Object)new File(this.execConfig.getAlgorithmExecutionDirectory()).getAbsolutePath(), (Object)CommandLineAlgorithmRun.getTargetAlgorithmExecutionCommandAsString(this.execConfig, this.runConfig));
            throw new TargetAlgorithmAbortException(e1);
        }
    }

    public void processRunLoop(BufferedReader procIn, Process p) {
        int i = 0;
        try {
            boolean matchFound = false;
            block3: do {
                boolean read = false;
                while (procIn.ready()) {
                    read = true;
                    String line = procIn.readLine();
                    if (line == null) {
                        log.debug("Process has ended");
                        this.processEnded.set(true);
                        break block3;
                    }
                    this.outputQueue.add(line);
                    if (this.outputQueue.size() > 1000) {
                        this.outputQueue.poll();
                    }
                    if (this.wasKilled) continue;
                    boolean matched = this.processLine(line);
                    if (matched && matchFound) {
                        log.error("Second output of matching line detected, there is a problem with your wrapper. You can try turning with log all process output enabled to debug: {} ", (Object)line);
                        this.setAbortResult("duplicate lines matched");
                        continue;
                    }
                    matchFound |= matched;
                }
                if (this.isRunCompleted() && this.wasKilled) {
                    log.warn("Run was killed but we somehow completed this might be a race condition but our result is: {}. This is a warning just so that developers can see this having occurred and judge the correctness", (Object)this.getResultLine());
                }
                if (!procIn.ready() && CommandLineAlgorithmRun.exited(p)) {
                    this.processEnded.set(true);
                    break;
                }
                if (read) continue;
                if (++i % 200 == 0) {
                    log.debug("Slept for 5 second waiting for pid {}  && {} ", (Object)CommandLineAlgorithmRun.getPID(p), (Object)matchFound);
                }
                Thread.sleep(25L);
            } while (!this.processEnded.get());
            procIn.close();
        }
        catch (IOException e) {
            if (!this.processEnded.get()) {
                log.debug("IO Exception occurred while processing runs");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    private Process runProcess(int port, Integer token) throws IOException {
        String[] execCmdArray = CommandLineAlgorithmRun.getTargetAlgorithmExecutionCommand(this.execConfig, this.runConfig);
        if (this.options.logAllCallStrings) {
            log.info("Call (with token {}) : cd \"{}\" " + commandSeparator + "  {} ", new Object[]{token, new File(this.execConfig.getAlgorithmExecutionDirectory()).getAbsolutePath(), CommandLineAlgorithmRun.getTargetAlgorithmExecutionCommandAsString(this.execConfig, this.runConfig)});
        }
        ArrayList<String> envpList = new ArrayList<String>(System.getenv().size());
        for (Map.Entry<String, String> ent : System.getenv().entrySet()) {
            envpList.add(ent.getKey() + "=" + ent.getValue());
        }
        if (this.options.listenForUpdates) {
            envpList.add("ACLIB_PORT=" + port);
            envpList.add("ACLIB_CPU_TIME_FREQUENCY=" + (double)this.observerFrequency / 2000.0);
        }
        envpList.add("ACLIB_CONCURRENT_TASK_ID=" + token);
        String[] envp = envpList.toArray(new String[0]);
        Process proc = Runtime.getRuntime().exec(execCmdArray, envp, new File(this.execConfig.getAlgorithmExecutionDirectory()));
        return proc;
    }

    private static String[] getTargetAlgorithmExecutionCommand(AlgorithmExecutionConfig execConfig, RunConfig runConfig) {
        String cmd = execConfig.getAlgorithmExecutable();
        cmd = cmd.replace("Who am I, Alan Turing?...also from X-Men?", "");
        String[] execCmdArray = SplitQuotedString.splitQuotedString(cmd);
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(execCmdArray));
        list.add(runConfig.getProblemInstanceSeedPair().getInstance().getInstanceName());
        list.add(runConfig.getProblemInstanceSeedPair().getInstance().getInstanceSpecificInformation());
        list.add(String.valueOf(runConfig.getCutoffTime()));
        list.add(String.valueOf(Integer.MAX_VALUE));
        list.add(String.valueOf(runConfig.getProblemInstanceSeedPair().getSeed()));
        ParamConfiguration.StringFormat f = ParamConfiguration.StringFormat.NODB_SYNTAX;
        for (String key : runConfig.getParamConfiguration().getActiveParameters()) {
            if (!f.getKeyValueSeperator().equals(" ") || !f.getGlue().equals(" ")) {
                throw new IllegalStateException("Key Value seperator or glue is not a space, and this means the way we handle this logic won't work currently");
            }
            list.add(f.getPreKey() + key);
            list.add(f.getValueDelimeter() + runConfig.getParamConfiguration().get(key) + f.getValueDelimeter());
        }
        return list.toArray(new String[0]);
    }

    public static String getTargetAlgorithmExecutionCommandAsString(AlgorithmExecutionConfig execConfig, RunConfig runConfig) {
        String cmd = execConfig.getAlgorithmExecutable();
        cmd = cmd.replace("Who am I, Alan Turing?...also from X-Men?", "");
        String[] execCmdArray = SplitQuotedString.splitQuotedString(cmd);
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(execCmdArray));
        list.add(runConfig.getProblemInstanceSeedPair().getInstance().getInstanceName());
        list.add(runConfig.getProblemInstanceSeedPair().getInstance().getInstanceSpecificInformation());
        list.add(String.valueOf(runConfig.getCutoffTime()));
        list.add(String.valueOf(Integer.MAX_VALUE));
        list.add(String.valueOf(runConfig.getProblemInstanceSeedPair().getSeed()));
        ParamConfiguration.StringFormat f = ParamConfiguration.StringFormat.NODB_SYNTAX;
        for (String key : runConfig.getParamConfiguration().getActiveParameters()) {
            if (!f.getKeyValueSeperator().equals(" ") || !f.getGlue().equals(" ")) {
                throw new IllegalStateException("Key Value seperator or glue is not a space, and this means the way we handle this logic won't work currently");
            }
            list.add(f.getPreKey() + key);
            list.add(f.getValueDelimeter() + runConfig.getParamConfiguration().get(key) + f.getValueDelimeter());
        }
        StringBuilder sb = new StringBuilder();
        for (String s : list) {
            if (s.matches(".*\\s+.*")) {
                sb.append("\"" + s + "\"");
            } else {
                sb.append(s);
            }
            sb.append(" ");
        }
        return sb.toString();
    }

    public boolean processLine(String line) {
        Matcher matcher = pattern.matcher(line);
        String rawResultLine = "[No Matching Output Found]";
        if (this.options.logAllProcessOutput) {
            log.debug("[PROCESS]  {}", (Object)line);
        }
        if (matcher.find()) {
            String fullLine = line.trim();
            String additionalRunData = "";
            try {
                String acExecResultString = line.substring(matcher.end()).trim();
                String[] results = acExecResultString.split(",");
                for (int i = 0; i < results.length; ++i) {
                    results[i] = results[i].trim();
                }
                rawResultLine = acExecResultString;
                RunResult acResult = RunResult.getAutomaticConfiguratorResultForKey(results[0]);
                if (!acResult.permittedByWrappers()) {
                    throw new IllegalArgumentException(" The Run Result reported is NOT permitted to be output by a wrapper and is for internal SMAC use only.");
                }
                String runtime = results[1].trim();
                String runLength = results[2].trim();
                String bestSolution = results[3].trim();
                String seed = results[4].trim();
                if (results.length > 5) {
                    if (results.length == 6) {
                        additionalRunData = results[5].trim();
                    } else {
                        log.warn("Too many fields were encounted (expected 5 or 6) when parsing line (Additional Run Data cannot have commas): {}\n ", (Object)line);
                    }
                }
                double runLengthD = Double.valueOf(runLength);
                double runtimeD = Double.valueOf(runtime);
                double qualityD = Double.valueOf(bestSolution);
                long resultSeedD = Long.valueOf(seed);
                if (!MarkerFilter.log(fullProcessOutputMarker.getName())) {
                    log.info("Algorithm Reported: {}", (Object)line);
                }
                this.setResult(acResult, runtimeD, runLengthD, qualityD, resultSeedD, rawResultLine, additionalRunData);
                return true;
            }
            catch (NumberFormatException e) {
                this.setCrashResult("Output:" + fullLine + "\n Exception Message: " + e.getMessage() + "\n Name:" + e.getClass().getCanonicalName());
                Object[] args = new Object[]{CommandLineAlgorithmRun.getTargetAlgorithmExecutionCommandAsString(this.execConfig, this.runConfig), fullLine};
                log.error("Target Algorithm Call failed:{}\nResponse:{}\nComment: Most likely one of the values of runLength, runtime, quality could not be parsed as a Double, or the seed could not be parsed as a valid long", args);
                log.error("Exception that occured trying to parse result was: ", (Throwable)e);
                log.error("Run will be counted as {}", (Object)RunResult.CRASHED);
                return true;
            }
            catch (IllegalArgumentException e) {
                this.setCrashResult("Output:" + fullLine + "\n Exception Message: " + e.getMessage() + "\n Name:" + e.getClass().getCanonicalName());
                ArrayList<String> validValues = new ArrayList<String>();
                for (RunResult r : RunResult.values()) {
                    if (!r.permittedByWrappers()) continue;
                    validValues.addAll(r.getAliases());
                }
                Collections.sort(validValues);
                Object[] validArgs = validValues.toArray(new String[0]);
                Object[] args = new Object[]{CommandLineAlgorithmRun.getTargetAlgorithmExecutionCommandAsString(this.execConfig, this.runConfig), fullLine, Arrays.toString(validArgs)};
                log.error("Target Algorithm Call failed:{}\nResponse:{}\nComment: Most likely the Algorithm did not report a result string as one of: {}", args);
                log.error("Exception that occured trying to parse result was: ", (Throwable)e);
                log.error("Run will be counted as {}", (Object)RunResult.CRASHED);
                return true;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.setCrashResult("Output:" + fullLine + "\n Exception Message: " + e.getMessage() + "\n Name:" + e.getClass().getCanonicalName());
                Object[] args = new Object[]{CommandLineAlgorithmRun.getTargetAlgorithmExecutionCommandAsString(this.execConfig, this.runConfig), fullLine};
                log.error("Target Algorithm Call failed:{}\nResponse:{}\nComment: Most likely the algorithm did not specify all of the required outputs that is <solved>,<runtime>,<runlength>,<quality>,<seed>", args);
                log.error("Exception that occured trying to parse result was: ", (Throwable)e);
                log.error("Run will be counted as {}", (Object)RunResult.CRASHED);
                return true;
            }
        }
        return false;
    }

    private static int getPID(Process p) {
        int pid = 0;
        try {
            Field f = p.getClass().getDeclaredField("pid");
            f.setAccessible(true);
            pid = Integer.valueOf(f.get(p).toString());
            f.setAccessible(false);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            return -1;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (pid > 0) {
            return pid;
        }
        return -1;
    }

    public static boolean exited(Process p) {
        try {
            p.exitValue();
            return true;
        }
        catch (IllegalThreadStateException e) {
            return false;
        }
    }

    private String replacePid(String input, int pid) {
        return input.replaceAll("%pid", String.valueOf(pid));
    }

    /*
     * Exception decompiling
     */
    private void killProcess(Process p) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static {
        log.warn("This version of SMAC hardcodes run length for calls to the target algorithm to {}.", (Object)Integer.MAX_VALUE);
        if (System.getProperty("os.name").toLowerCase().contains("win")) {
            commandSeparator = "&";
        }
    }
}

