/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.debug;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.runconfig.RunConfig;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.functionality.OutstandingEvaluationsTargetAlgorithmEvaluatorDecorator;
import java.util.Collections;
import java.util.List;

public class EqualTargetAlgorithmEvaluatorTester
implements TargetAlgorithmEvaluator {
    private final TargetAlgorithmEvaluator tae1;
    private final TargetAlgorithmEvaluator tae2;

    public EqualTargetAlgorithmEvaluatorTester(TargetAlgorithmEvaluator tae1, TargetAlgorithmEvaluator tae2) {
        this.tae1 = tae1;
        this.tae2 = tae2;
    }

    @Override
    public List<AlgorithmRun> evaluateRun(RunConfig run) {
        return this.evaluateRun(Collections.singletonList(run));
    }

    @Override
    public List<AlgorithmRun> evaluateRun(List<RunConfig> runConfigs) {
        return this.evaluateRun(runConfigs, null);
    }

    @Override
    public List<AlgorithmRun> evaluateRun(List<RunConfig> runConfigs, TargetAlgorithmEvaluatorRunObserver obs) {
        List<AlgorithmRun> runTae1 = this.tae1.evaluateRun(runConfigs, obs);
        List<AlgorithmRun> runTae2 = this.tae2.evaluateRun(runConfigs, obs);
        if (runTae1.size() != runTae2.size()) {
            throw new IllegalStateException("Run sizes did not match");
        }
        for (int i = 0; i < runTae1.size(); ++i) {
            if (!runTae1.get(i).equals(runTae2.get(i))) {
                throw new IllegalStateException(runTae1.get(i) + " did not equals " + runTae2.get(i));
            }
            if (Math.abs(runTae1.get(i).getRuntime() - runTae2.get(i).getRuntime()) > 0.1) {
                throw new IllegalStateException("Runtimes did not agree");
            }
            if (runTae1.get(i).getResultSeed() != runTae2.get(i).getResultSeed()) {
                throw new IllegalStateException("Result Seeds did not agree");
            }
            if (Math.abs(runTae1.get(i).getQuality() - runTae2.get(i).getQuality()) > 0.1) {
                throw new IllegalStateException("Quality did not agree");
            }
            if (runTae1.get(i).getRunResult().equals((Object)runTae2.get(i).getRunResult())) continue;
            throw new IllegalStateException("Run Results did not agree");
        }
        return runTae1;
    }

    @Override
    public int getRunCount() {
        if (this.tae1.getRunCount() != this.tae2.getRunCount()) {
            throw new IllegalStateException("RunCount should have been the same between two target algorithm evaluators");
        }
        return this.tae1.getRunCount();
    }

    @Override
    public int getRunHash() {
        if (this.tae1.getRunHash() != this.tae2.getRunHash()) {
            throw new IllegalStateException("Run Hash should have been the same between two target algorithm evaluators");
        }
        return this.tae1.getRunHash();
    }

    @Override
    public void seek(List<AlgorithmRun> runs) {
        this.tae1.seek(runs);
        this.tae2.seek(runs);
    }

    @Override
    public String getManualCallString(RunConfig runConfig) {
        return this.tae1.getManualCallString(runConfig);
    }

    @Override
    public void notifyShutdown() {
        this.tae1.notifyShutdown();
        this.tae2.notifyShutdown();
    }

    @Override
    public void evaluateRunsAsync(RunConfig runConfig, TargetAlgorithmEvaluatorCallback handler) {
        throw new UnsupportedOperationException("This TAE does not support Asynchronous Execution at the moment");
    }

    @Override
    public void evaluateRunsAsync(List<RunConfig> runConfigs, TargetAlgorithmEvaluatorCallback handler) {
        this.evaluateRunsAsync(runConfigs, handler, null);
    }

    @Override
    public void evaluateRunsAsync(List<RunConfig> runConfigs, TargetAlgorithmEvaluatorCallback handler, TargetAlgorithmEvaluatorRunObserver obs) {
        throw new UnsupportedOperationException("This TAE does not support Asynchronous Execution at the moment");
    }

    @Override
    public boolean isRunFinal() {
        return false;
    }

    @Override
    public boolean areRunsPersisted() {
        return false;
    }

    @Override
    public boolean areRunsObservable() {
        return false;
    }

    @Override
    public void waitForOutstandingEvaluations() {
        throw new UnsupportedOperationException(this.getClass().getCanonicalName() + " does NOT support waiting or observing the number of outstanding evaluations, you should probably wrap this TargetAlgorithmEvaluator with an instance of " + OutstandingEvaluationsTargetAlgorithmEvaluatorDecorator.class);
    }

    @Override
    public int getNumberOfOutstandingEvaluations() {
        throw new UnsupportedOperationException(this.getClass().getCanonicalName() + " does NOT support waiting or observing the number of outstanding evaluations, you should probably wrap this TargetAlgorithmEvaluator with an instance of " + OutstandingEvaluationsTargetAlgorithmEvaluatorDecorator.class);
    }

    @Override
    public int getNumberOfOutstandingBatches() {
        throw new UnsupportedOperationException(this.getClass().getCanonicalName() + " does NOT support waiting or observing the number of outstanding evaluations, you should probably wrap this TargetAlgorithmEvaluator with an instance of " + OutstandingEvaluationsTargetAlgorithmEvaluatorDecorator.class);
    }

    @Override
    public int getNumberOfOutstandingRuns() {
        throw new UnsupportedOperationException(this.getClass().getCanonicalName() + " does NOT support waiting or observing the number of outstanding evaluations, you should probably wrap this TargetAlgorithmEvaluator with an instance of " + OutstandingEvaluationsTargetAlgorithmEvaluatorDecorator.class);
    }
}

