/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.termination.standard;

import ca.ubc.cs.beta.aclib.eventsystem.EventHandler;
import ca.ubc.cs.beta.aclib.eventsystem.EventManager;
import ca.ubc.cs.beta.aclib.eventsystem.events.AutomaticConfiguratorEvent;
import ca.ubc.cs.beta.aclib.eventsystem.events.ac.ChallengeStartEvent;
import ca.ubc.cs.beta.aclib.eventsystem.events.basic.AlgorithmRunCompletedEvent;
import ca.ubc.cs.beta.aclib.termination.ValueMaxStatus;
import ca.ubc.cs.beta.aclib.termination.standard.AbstractTerminationCondition;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicLong;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class NoRunsForManyChallengesEvent
extends AbstractTerminationCondition
implements EventHandler<AutomaticConfiguratorEvent> {
    private final long iterationWithOutRuns;
    private final AtomicLong attemptedChallengesSinceLastRun = new AtomicLong(0L);

    public NoRunsForManyChallengesEvent(long iterationsWithoutRun) {
        this.iterationWithOutRuns = iterationsWithoutRun;
    }

    @Override
    public boolean haveToStop() {
        return this.attemptedChallengesSinceLastRun.get() >= this.iterationWithOutRuns;
    }

    @Override
    public Collection<ValueMaxStatus> currentStatus() {
        return Collections.emptySet();
    }

    @Override
    public void handleEvent(AutomaticConfiguratorEvent event) {
        if (event instanceof ChallengeStartEvent) {
            this.attemptedChallengesSinceLastRun.incrementAndGet();
        } else if (event instanceof AlgorithmRunCompletedEvent) {
            this.attemptedChallengesSinceLastRun.set(0L);
        }
    }

    public String toString() {
        return this.currentStatus().toString();
    }

    @Override
    public void registerWithEventManager(EventManager evtManager) {
        evtManager.registerHandler(ChallengeStartEvent.class, this);
        evtManager.registerHandler(AlgorithmRunCompletedEvent.class, this);
    }

    @Override
    public String getTerminationReason() {
        if (this.haveToStop()) {
            return "Too many challenges have been attempted without a successful run (" + this.attemptedChallengesSinceLastRun + ") has been reached";
        }
        return "";
    }
}

