import java.util.*;
import java.io.*;

public class Surface{
  
    private Vector faces;
    
    public Surface(){
	faces = new Vector();
    }

    public Surface(Vector f){
	faces = f;
    }
    
    public Vector getVertices(){
	Vector vertices = new Vector();
	
	// Get the vertices of each face
	for (Enumeration e = faces.elements();e.hasMoreElements();){
	    Vector face_verts = ((Polygon)e.nextElement()).getVertices();
	    for (Enumeration f = face_verts.elements();f.hasMoreElements();){
		Vertex vertex = (Vertex)f.nextElement();
		if (vertices.indexOf(vertex) == -1)
		    vertices.addElement(vertex);
	    }
	}
	return vertices;
    }

    public Vector getFaces(){
	return faces;
    }
    
    public Vector getFaces(Vertex v){
	Vector adjFaces = new Vector();
	
	// Get the vertices adj to the Vertex
	for (Enumeration e = faces.elements();e.hasMoreElements();){
	    Triangle p = (Triangle)e.nextElement();
	    if(p.inTriangle(v)){
			if (!p.coPlanar(adjFaces))
		    	adjFaces.addElement(p);
	    }
	}
	return adjFaces;
    }
    
    //Finds the center of the surface
    public Vertex getCenter(){
	Vector vertices = getVertices();
	int size = vertices.size();
	double[] c = {0.0,0.0,0.0};

	for (Enumeration v = vertices.elements();v.hasMoreElements();){
	    double[] x = ((Vertex)v.nextElement()).getCoords();
	    c[0]+=x[0];
	    c[1]+=x[1];
	    c[2]+=x[2];
	}
	c[0]=c[0]/size;
	c[1]=c[1]/size;
	c[2]=c[2]/size;

	return new Vertex(c[0],c[1],c[2]);
    }
    
    public void writeOFF(PrintWriter pw) throws IOException{
	//Write header
	pw.println("OFF");
	Vector vertices = getVertices();
	pw.println(vertices.size() + " " + " " + faces.size() + " " +
		   (3 * faces.size()));
	
	//Write vertex list
	for (Enumeration v = vertices.elements();v.hasMoreElements();){
	    double[] c = ((Vertex)v.nextElement()).getCoords();
	    pw.println(c[0] + " " + c[1] + " " + c[2]);
	}
	
	//Write polygon list
	for (Enumeration f = faces.elements();f.hasMoreElements();){
	    Vector pV = ((Polygon)f.nextElement()).getVertices();
	    pw.print(pV.size());
	    for (Enumeration v = pV.elements();v.hasMoreElements();)
		pw.print(" " + vertices.indexOf((Vertex)v.nextElement()));
	    pw.println();
	}
    }
    
    public void writeVRML(PrintWriter pw) throws IOException{
	//Write header
	pw.println("#VRML V2.0 utf8");
	pw.println("Shape {");
	pw.println("geometry IndexedFaceSet {");
	pw.println("coord Coordinate {");
	pw.println("point [");

	Vector vertices = getVertices();
	//Write vertexes
	for (Enumeration v = vertices.elements();v.hasMoreElements();){
	    double[] c = ((Vertex)v.nextElement()).getCoords();
	    pw.println(c[0] + " " + c[1] + " " + c[2]+",");
	}

	pw.println("]}");
	pw.println("coordIndex [");
	
	//Write polygons
	for (Enumeration f = faces.elements();f.hasMoreElements();){
	    Vector pV = ((Polygon)f.nextElement()).getVertices();
	    for (Enumeration v = pV.elements();v.hasMoreElements();)
		pw.print(vertices.indexOf((Vertex)v.nextElement()) + " ,");
	    pw.println("-1,");
	}
	pw.println("]}}");
    }
    
    public String toString(){
	String s = new String();
	
	for (Enumeration e = faces.elements();e.hasMoreElements();)
	    s += (Polygon)e.nextElement() + "\n";
	return s;
    }
}
