import java.util.*;

public class Triangle extends Polygon{

  public Triangle (Vector vertices){
      super(vertices);
  }

  public Triangle (Vertex v1, Vertex v2, Vertex v3){
      super();
      Vector v = getVertices();
      v.addElement(v1);
      v.addElement(v2);
      v.addElement(v3);
  }

  public static boolean sameTriangle(Triangle t1, Triangle t2){
      if (t1 == t2)
	{
	  return true;
	}

      Vector v1 = t1.getVertices();
      Vector v2 = t2.getVertices();
      if (v1 == v2)
	{
	  return true;
	}

      Vertex t1A = (Vertex)v1.firstElement();
      Vertex t1B = (Vertex)v1.elementAt(1);
      Vertex t1C = (Vertex)v1.lastElement();
      Vertex t2A = (Vertex)v2.firstElement();
      Vertex t2B = (Vertex)v2.elementAt(1);
      Vertex t2C = (Vertex)v2.lastElement();
      return
	(Vertex.sameVertex(t1A, t2A) || Vertex.sameVertex(t1A, t2B) ||
	 Vertex.sameVertex(t1A, t2C)) &&
	   (Vertex.sameVertex(t1B, t2A) || Vertex.sameVertex(t1B, t2B) ||
	    Vertex.sameVertex(t1B, t2C)) &&
	      (Vertex.sameVertex(t1C, t2A) || Vertex.sameVertex(t1C, t2B) ||
	       Vertex.sameVertex(t1C, t2C));
  }

    // Returns true whether a vertex belongs to the triangle
    public boolean inTriangle(Vertex v){
	Vector vertices = getVertices();
	Vertex vert1 = (Vertex)vertices.elementAt(0);
	Vertex vert2 = (Vertex)vertices.elementAt(1);
	Vertex vert3 = (Vertex)vertices.elementAt(2);
	
	if (v == vert1 || v == vert2 || v == vert3)
	    return true;
	else
	    return false;
    }
    
    //Add a Vector v to the Triangle's vertices
    public Triangle addTriangle (Vertex v){
	Vector vertices = getVertices();
	Vertex vert1 = (Vertex)vertices.elementAt(0);
	Vertex vert2 = (Vertex)vertices.elementAt(1);
	Vertex vert3 = (Vertex)vertices.elementAt(2);
	
	return new Triangle(Vertex.vectorAdd(vert1,v),Vertex.vectorAdd(vert2,v),Vertex.vectorAdd(vert3,v));
    }
    
    public static Vertex calcTrInt(Vector faces){
	for (Enumeration t = faces.elements();t.hasMoreElements();){
	    Triangle tr = (Triangle)t.nextElement();
	    
	}
	return new Vertex();
    }
    
  /**
   * Tests whether a triangle is present in a vector.
   *
   * @param vec  vector of triangles to match
   */
  public boolean matches(Vector vec){
      for (Enumeration e = vec.elements();
	   e.hasMoreElements();)
	{
	  if (sameTriangle(this, (Triangle)e.nextElement()))
	    {
	      return true;
	    }
	}
      return false;
    }


  /**
   * Returns the index of a triangle in a vector.
   *
   * @param vec  vector of triangles to match
   * @return     index of the match or -1 if no match
   */
  public int matchIndex(Vector vec){
      int i = 0;
      for (Enumeration e = vec.elements();
	   e.hasMoreElements();)
	{
	  if (sameTriangle(this, (Triangle)e.nextElement()))
	    {
	      return i;
	    }
	  i++;
	}
      return -1;
    }


  /**
   * Returns the third vertex of a triangle given the other two.
   *
   * @param v1, v2  the other two vertices
   * @return        the third vertex or null if v1 and v2 are not
   *                vertices
   */
  public Vertex thirdVertex(Vertex v1, Vertex v2){
      Vector vertices = getVertices();
      Vertex vert1 = (Vertex)vertices.elementAt(0);
      Vertex vert2 = (Vertex)vertices.elementAt(1);
      Vertex vert3 = (Vertex)vertices.elementAt(2);
      if (v1 == vert1 && v2 == vert2 ||
	  v2 == vert1 && v1 == vert2)
	{
	  return vert3;
	}
      if (v1 == vert1 && v2 == vert3 ||
	  v2 == vert1 && v1 == vert3)
	{
	  return vert2;
	}
      if (v1 == vert2 && v2 == vert3 ||
	  v2 == vert2 && v1 == vert3)
	{
	  return vert1;
	}
      return null;
    }


    /**
     * Returns the triangle that shares a particular edge.
     *
     * @params tris   the list of triangles to search
     *         v1 v2  the vertices that define the edge
     * @return        the neighbouring triangle or null if not found
     */
    public Triangle edgeNeighbour(Vector tris, Vertex v1, Vertex v2){
	for (Enumeration e = tris.elements();
	     e.hasMoreElements();)
	    {
		Triangle t = (Triangle)e.nextElement();
		if (!sameTriangle(t, this))
		    {
			Vector verts = t.getVertices();
			if (verts.contains(v1) && verts.contains(v2))
			    {
				return t;
			    }
		    }
	    }
	return null;
    }
    
    // Returnd the norm of the triangle
    public Vertex triangleNorm(){
      Vector vertices = getVertices();
      double[] v1 = ((Vertex)vertices.firstElement()).getCoords();
      double[] v2 = ((Vertex)vertices.elementAt(1)).getCoords();
      double[] v3 = ((Vertex)vertices.lastElement()).getCoords();
      double ax = v1[0] - v2[0];
      double ay = v1[1] - v2[1];
      double az = v1[2] - v2[2];
      double bx = v1[0] - v3[0];
      double by = v1[1] - v3[1];
      double bz = v1[2] - v3[2];
      
      Vertex v = Vertex.crossProduct(new Vertex(ax,ay,az),new Vertex(bx,by,bz));
      
      v.normalize();
      
      return v;
    }

    public boolean coPlanar(Vector faces){
	if(faces.isEmpty()){
	    return false;
	}
	else {
	    for (Enumeration e = faces.elements();e.hasMoreElements();){
		Triangle p = (Triangle)e.nextElement();
		if(coPlanar(p))
		    return true;
	    }
	}
	return false;
    }
    
    public boolean coPlanar(Triangle t){	
	Vector vertices = t.getVertices();
	Vertex vert1 = (Vertex)vertices.elementAt(0);
	Vertex vert2 = (Vertex)vertices.elementAt(1);
	Vertex vert3 = (Vertex)vertices.elementAt(2);
	
	if(volumeSign(vert1)==0&&volumeSign(vert2)==0&&volumeSign(vert3)==0)
	    return true;
	else
	    return false;
    }
    
  /**
   * Returns the sign of the volume of the tetrahedron formed by a
   * triangle and a vertex. VolumeSign is positive iff the vertex is
   * on the negative side of the triangle, where the positive side is
   * determined by the rh-rule. So the volume is positive if the ccw
   * normal to points outside the tetrahedron.  The final
   * fewer-multiplications form is due to Bob Williamson.
   *
   * @param v  vertex to test
   * @return   -1/0/1 if vertex is on the negative/coplanar/positive
   *           side of the triangle according to the rh-rule
   */
  public int volumeSign(Vertex v){
      Vector vertices = getVertices();
      double[] v1 = ((Vertex)vertices.firstElement()).getCoords();
      double[] v2 = ((Vertex)vertices.elementAt(1)).getCoords();
      double[] v3 = ((Vertex)vertices.lastElement()).getCoords();
      double[] v4 = v.getCoords();
      double ax = v1[0] - v4[0];
      double ay = v1[1] - v4[1];
      double az = v1[2] - v4[2];
      double bx = v2[0] - v4[0];
      double by = v2[1] - v4[1];
      double bz = v2[2] - v4[2];
      double cx = v3[0] - v4[0];
      double cy = v3[1] - v4[1];
      double cz = v3[2] - v4[2];
      
      double vol = ax * (by * cz - bz * cy) + ay * (bz * cx - bx * cz)
	+ az * (bx * cy - by * cx);
      
      /* The volume should be an integer. */
      if (vol >  0)
	{
	  return 1;
	}
      else if (vol < 0)
	{
	  return -1;
	}
      else
	{
	  return 0;
	}
    }
    
  /**
   * Returns six times the volume of the tetrahedron formed by a
   * triangle and vertex.  The volume is positive iff the vertex is on
   * the negative side of the triangle, where the positive side is
   * determined by the rh-rule.
   *
   * @param v the vertex
   */
  public double volume6(Vertex v){
      Vector vertices = getVertices();
      double[] v1 = ((Vertex)vertices.firstElement()).getCoords();
      double[] v2 = ((Vertex)vertices.elementAt(1)).getCoords();
      double[] v3 = ((Vertex)vertices.lastElement()).getCoords();
      double[] v4 = v.getCoords();
      double ax = v1[0];
      double ay = v1[1];
      double az = v1[2];
      double bx = v2[0];
      double by = v2[1];
      double bz = v2[2];
      double cx = v3[0];
      double cy = v3[1];
      double cz = v3[2];
      double dx = v4[0];
      double dy = v4[1];
      double dz = v4[2];
      double bxdx=bx-dx;
      double bydy=by-dy;
      double bzdz=bz-dz;
      double cxdx=cx-dx;
      double cydy=cy-dy;
      double czdz=cz-dz;
      return (az-dz)*(bxdx*cydy-bydy*cxdx) + (ay-dy)*(bzdz*cxdx-bxdx*czdz)
	+ (ax-dx)*(bydy*czdz-bzdz*cydy);
    }
}
