/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.smac.handler;

import ca.ubc.cs.beta.aclib.configspace.ParamConfiguration;
import ca.ubc.cs.beta.aclib.configspace.tracking.ParamConfigurationOriginTracker;
import ca.ubc.cs.beta.aclib.eventsystem.EventHandler;
import ca.ubc.cs.beta.aclib.eventsystem.events.AutomaticConfiguratorEvent;
import ca.ubc.cs.beta.aclib.eventsystem.events.ac.ChallengeStartEvent;
import ca.ubc.cs.beta.aclib.eventsystem.events.model.ModelBuildEndEvent;
import ca.ubc.cs.beta.aclib.eventsystem.events.model.ModelBuildStartEvent;
import ca.ubc.cs.beta.models.fastrf.RandomForest;
import ca.ubc.cs.beta.smac.configurator.AbstractAlgorithmFramework;
import java.util.Collections;
import java.util.List;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.NormalDistributionImpl;

public class ChallengePredictionHandler
implements EventHandler<AutomaticConfiguratorEvent> {
    private AbstractAlgorithmFramework smac;
    private RandomForest forest;
    private ParamConfigurationOriginTracker configTracker;

    public ChallengePredictionHandler(AbstractAlgorithmFramework smac, ParamConfigurationOriginTracker configTracker) {
        this.smac = smac;
        this.configTracker = configTracker;
    }

    public void handleEvent(AutomaticConfiguratorEvent event) {
        if (event instanceof ChallengeStartEvent) {
            if (this.forest != null) {
                ParamConfiguration incumbent = this.smac.getIncumbent();
                ParamConfiguration challenger = ((ChallengeStartEvent)event).getChallenger();
                double[] incumbentMeanVar = this.applyMarginalModel(incumbent)[0];
                double[] challengerMeanVar = this.applyMarginalModel(challenger)[0];
                double challengerMean = challengerMeanVar[0];
                double incumbentMean = incumbentMeanVar[0];
                double challengerVar = challengerMeanVar[1];
                double incumbentVar = incumbentMeanVar[1];
                double mean = this.getExpMean(challengerMean, challengerVar) - this.getExpMean(incumbentMean, incumbentVar);
                double var = this.getExpVar(challengerMean, challengerVar) + this.getExpVar(incumbentMean, incumbentVar);
                NormalDistributionImpl normal = new NormalDistributionImpl();
                double probability = Double.NaN;
                try {
                    probability = normal.cumulativeProbability(-mean / var);
                }
                catch (MathException e) {
                    // empty catch block
                }
                this.configTracker.addConfiguration(challenger, "Challenge-Prediction", new String[]{"Incumbent Mean=" + incumbentMeanVar[0], "IncumbentVariance=" + incumbentMeanVar[1], "ChallengerMean=" + challengerMeanVar[0], "ChallengerVariance=" + challengerMeanVar[1], "ProbabilityOfSuccess=" + probability});
            }
        } else if (event instanceof ModelBuildStartEvent) {
            this.forest = null;
        } else if (event instanceof ModelBuildEndEvent) {
            this.forest = (RandomForest)((ModelBuildEndEvent)event).getModelIfAvailable();
        }
    }

    private double getExpMean(double pred, double var) {
        double mu_l10;
        double test_mu_n = pred;
        double test_var_n = var;
        double var_ln = Math.log(test_var_n / (test_mu_n * test_mu_n) + 1.0);
        double mu_ln = Math.log(test_mu_n) - var_ln / 2.0;
        double var_l10 = var_ln / Math.log(10.0) / Math.log(10.0);
        pred = mu_l10 = mu_ln / Math.log(10.0);
        var = var_l10;
        return pred;
    }

    private double getExpVar(double pred, double var) {
        double mu_l10;
        double test_mu_n = pred;
        double test_var_n = var;
        double var_ln = Math.log(test_var_n / (test_mu_n * test_mu_n) + 1.0);
        double mu_ln = Math.log(test_mu_n) - var_ln / 2.0;
        double var_l10 = var_ln / Math.log(10.0) / Math.log(10.0);
        pred = mu_l10 = mu_ln / Math.log(10.0);
        var = var_l10;
        return var;
    }

    protected double[][] applyMarginalModel(double[][] configArrays) {
        int[] treeIdxsToUse = new int[this.forest.numTrees];
        for (int i = 0; i < this.forest.numTrees; ++i) {
            treeIdxsToUse[i] = i;
        }
        return RandomForest.applyMarginal((RandomForest)this.forest, (int[])treeIdxsToUse, (double[][])configArrays);
    }

    protected double[][] applyMarginalModel(ParamConfiguration configtoCheck) {
        List<ParamConfiguration> configs = Collections.singletonList(configtoCheck);
        double[][] configArrays = new double[configs.size()][];
        int i = 0;
        for (ParamConfiguration config : configs) {
            configArrays[i] = config.toValueArray();
            ++i;
        }
        return this.applyMarginalModel(configArrays);
    }
}

