/*
 * Decompiled with CFR 0.152.
 */
package net.sf.doodleproject.numerics4j.random;

import net.sf.doodleproject.numerics4j.random.AbstractDiscreteRandomVariable;
import net.sf.doodleproject.numerics4j.random.RNG;
import net.sf.doodleproject.numerics4j.random.RandomRNG;

public class PoissonRandomVariable
extends AbstractDiscreteRandomVariable {
    private double mean;

    public PoissonRandomVariable() {
        this(1.0);
    }

    public PoissonRandomVariable(double m) {
        this(m, new RandomRNG());
    }

    public PoissonRandomVariable(double m, RNG source) {
        super(source);
        this.setMean(m);
    }

    public static int nextRandomVariable(double m, RNG source) {
        double u = Math.exp(-m);
        double p = 1.0;
        int k = 0;
        do {
            ++k;
        } while ((p *= source.nextRandomNumber()) >= u);
        return k - 1;
    }

    private double getMean() {
        return this.mean;
    }

    public int nextRandomVariable() {
        return PoissonRandomVariable.nextRandomVariable(this.getMean(), this.getSource());
    }

    private void setMean(double m) {
        if (Double.isNaN(m) || m <= 0.0) {
            throw new IllegalArgumentException("mean must be positive.");
        }
        this.mean = m;
    }
}

