/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.misc.watch;

import java.io.Serializable;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class StopWatch
implements Serializable {
    private static final long serialVersionUID = 9116898201991111651L;
    private long startTime = -1L;
    private long endTime = Long.MAX_VALUE;
    private long lastLaps;

    public long start() {
        if (this.startTime >= 0L) {
            throw new IllegalStateException("Watch already started");
        }
        this.lastLaps = this.startTime = System.currentTimeMillis();
        return this.startTime;
    }

    public long stop() {
        if (this.startTime < 0L) {
            throw new IllegalStateException("Watch hasn't been started");
        }
        this.endTime = System.currentTimeMillis();
        return this.endTime - this.startTime;
    }

    public long time() {
        if (this.startTime < 0L) {
            throw new IllegalStateException("Watch hasn't been started");
        }
        return Math.min(this.endTime, System.currentTimeMillis()) - this.startTime;
    }

    public long laps() {
        long cTime = System.currentTimeMillis();
        long lapTime = cTime - this.lastLaps;
        this.lastLaps = cTime;
        return lapTime;
    }
}

